"""Generated message classes for aiplatform version v1.

Train high-quality custom machine learning models with minimal machine
learning expertise and effort.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'aiplatform'


class AiplatformProjectsLocationsBatchPredictionJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1CancelBatchPredictionJobRequest: A
      GoogleCloudAiplatformV1CancelBatchPredictionJobRequest resource to be
      passed as the request body.
    name: Required. The name of the BatchPredictionJob to cancel. Format: `pro
      jects/{project}/locations/{location}/batchPredictionJobs/{batch_predicti
      on_job}`
  """

  googleCloudAiplatformV1CancelBatchPredictionJobRequest = _messages.MessageField('GoogleCloudAiplatformV1CancelBatchPredictionJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1BatchPredictionJob: A
      GoogleCloudAiplatformV1BatchPredictionJob resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      BatchPredictionJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1BatchPredictionJob = _messages.MessageField('GoogleCloudAiplatformV1BatchPredictionJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource to be deleted.
      Format: `projects/{project}/locations/{location}/batchPredictionJobs/{ba
      tch_prediction_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsGetRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource. Format: `proj
      ects/{project}/locations/{location}/batchPredictionJobs/{batch_predictio
      n_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `model_display_name`
      supports `=`, `!=` comparisons. * `state` supports `=`, `!=`
      comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=`
      comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListBatchPredictionJobsResponse.next_page_token of the previous
      JobService.ListBatchPredictionJobs call.
    parent: Required. The resource name of the Location to list the
      BatchPredictionJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsCustomJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1CancelCustomJobRequest: A
      GoogleCloudAiplatformV1CancelCustomJobRequest resource to be passed as
      the request body.
    name: Required. The name of the CustomJob to cancel. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  googleCloudAiplatformV1CancelCustomJobRequest = _messages.MessageField('GoogleCloudAiplatformV1CancelCustomJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1CustomJob: A GoogleCloudAiplatformV1CustomJob
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the
      CustomJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1CustomJob = _messages.MessageField('GoogleCloudAiplatformV1CustomJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsDeleteRequest object.

  Fields:
    name: Required. The name of the CustomJob resource to be deleted. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsGetRequest object.

  Fields:
    name: Required. The name of the CustomJob resource. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListCustomJobsResponse.next_page_token of the previous
      JobService.ListCustomJobs call.
    parent: Required. The resource name of the Location to list the CustomJobs
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsDataLabelingJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1CancelDataLabelingJobRequest: A
      GoogleCloudAiplatformV1CancelDataLabelingJobRequest resource to be
      passed as the request body.
    name: Required. The name of the DataLabelingJob. Format: `projects/{projec
      t}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  """

  googleCloudAiplatformV1CancelDataLabelingJobRequest = _messages.MessageField('GoogleCloudAiplatformV1CancelDataLabelingJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDataLabelingJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1DataLabelingJob: A
      GoogleCloudAiplatformV1DataLabelingJob resource to be passed as the
      request body.
    parent: Required. The parent of the DataLabelingJob. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1DataLabelingJob = _messages.MessageField('GoogleCloudAiplatformV1DataLabelingJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDataLabelingJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsDeleteRequest object.

  Fields:
    name: Required. The name of the DataLabelingJob to be deleted. Format: `pr
      ojects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_jo
      b}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsGetRequest object.

  Fields:
    name: Required. The name of the DataLabelingJob. Format: `projects/{projec
      t}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order by default. Use `desc` after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The parent of the DataLabelingJob. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read. FieldMask represents a set
      of symbolic field paths. For example, the mask can be `paths: "name"`.
      The "name" here is a field in DataLabelingJob. If this field is not set,
      all fields of the DataLabelingJob are returned.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest object.

  Fields:
    name: Required. The name of the AnnotationSpec resource. Format: `projects
      /{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{anno
      tation_spec}`
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsCreateRequest object.

  Fields:
    googleCloudAiplatformV1Dataset: A GoogleCloudAiplatformV1Dataset resource
      to be passed as the request body.
    parent: Required. The resource name of the Location to create the Dataset
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1Dataset = _messages.MessageField('GoogleCloudAiplatformV1Dataset', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the DataItem to list Annotations
      from. Format: `projects/{project}/locations/{location}/datasets/{dataset
      }/dataItems/{data_item}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDataItemsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsListRequest object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the Dataset to list DataItems from.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDatasetVersionsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1DatasetVersion: A
      GoogleCloudAiplatformV1DatasetVersion resource to be passed as the
      request body.
    parent: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1DatasetVersion = _messages.MessageField('GoogleCloudAiplatformV1DatasetVersion', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsDatasetVersionsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the Dataset version to delete.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDatasetVersionsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsGetRequest object.

  Fields:
    name: Required. The resource name of the Dataset version to delete.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDatasetVersionsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsListRequest object.

  Fields:
    filter: Optional. The standard list filter.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token.
    parent: Required. The resource name of the Dataset to list DatasetVersions
      from. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDatasetVersionsRestoreRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsRestoreRequest
  object.

  Fields:
    name: Required. The name of the DatasetVersion resource. Format: `projects
      /{project}/locations/{location}/datasets/{dataset}/datasetVersions/{data
      set_version}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDeleteRequest object.

  Fields:
    name: Required. The resource name of the Dataset to delete. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsExportRequest object.

  Fields:
    googleCloudAiplatformV1ExportDataRequest: A
      GoogleCloudAiplatformV1ExportDataRequest resource to be passed as the
      request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1ExportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1ExportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsGetRequest object.

  Fields:
    name: Required. The name of the Dataset resource.
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsImportRequest object.

  Fields:
    googleCloudAiplatformV1ImportDataRequest: A
      GoogleCloudAiplatformV1ImportDataRequest resource to be passed as the
      request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1ImportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1ImportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `display_name`:
      supports = and != * `metadata_schema_uri`: supports = and != * `labels`
      supports general map functions that is: * `labels.key=value` - key:value
      equality * `labels.key:* or labels:key - key existence * A key including
      a space must be quoted. `labels."a key"`. Some examples: *
      `displayName="myDisplayName"` * `labels.myKey="myValue"`
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `display_name` * `create_time` * `update_time`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The name of the Dataset's parent resource. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsPatchRequest object.

  Fields:
    googleCloudAiplatformV1Dataset: A GoogleCloudAiplatformV1Dataset resource
      to be passed as the request body.
    name: Output only. The resource name of the Dataset.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields:
      * `display_name` * `description` * `labels`
  """

  googleCloudAiplatformV1Dataset = _messages.MessageField('GoogleCloudAiplatformV1Dataset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsDatasetsSavedQueriesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesDeleteRequest object.

  Fields:
    name: Required. The resource name of the SavedQuery to delete. Format: `pr
      ojects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{s
      aved_query}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesListRequest object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the Dataset to list SavedQueries
      from. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsSearchDataItemsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSearchDataItemsRequest object.

  Fields:
    annotationFilters: An expression that specifies what Annotations will be
      returned per DataItem. Annotations satisfied either of the conditions
      will be returned. * `annotation_spec_id` - for = or !=. Must specify
      `saved_query_id=` - saved query id that annotations should belong to.
    annotationsFilter: An expression for filtering the Annotations that will
      be returned per DataItem. * `annotation_spec_id` - for = or !=.
    annotationsLimit: If set, only up to this many of Annotations will be
      returned per DataItemView. The maximum value is 1000. If not set, the
      maximum value will be used.
    dataItemFilter: An expression for filtering the DataItem that will be
      returned. * `data_item_id` - for = or !=. * `labeled` - for = or !=. *
      `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that have
      at least one annotation with annotation_spec_id = `ANNOTATION_SPEC_ID`
      in the context of SavedQuery or DataLabelingJob. For example: *
      `data_item=1` * `has_annotation(5)`
    dataLabelingJob: The resource name of a DataLabelingJob. Format: `projects
      /{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}` If
      this field is set, all of the search will be done in the context of this
      DataLabelingJob.
    dataset: Required. The resource name of the Dataset from which to search
      DataItems. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    fieldMask: Mask specifying which fields of DataItemView to read.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    orderByAnnotation_orderBy: A comma-separated list of annotation fields to
      order by, sorted in ascending order. Use "desc" after a field name for
      descending. Must also specify saved_query.
    orderByAnnotation_savedQuery: Required. Saved query of the Annotation.
      Only Annotations belong to this saved query will be considered for
      ordering.
    orderByDataItem: A comma-separated list of data item fields to order by,
      sorted in ascending order. Use "desc" after a field name for descending.
    pageSize: Requested page size. Server may return fewer results than
      requested. Default and maximum page size is 100.
    pageToken: A token identifying a page of results for the server to return
      Typically obtained via SearchDataItemsResponse.next_page_token of the
      previous DatasetService.SearchDataItems call.
    savedQuery: The resource name of a SavedQuery(annotation set in UI).
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/save
      dQueries/{saved_query}` All of the search will be done in the context of
      this SavedQuery.
  """

  annotationFilters = _messages.StringField(1, repeated=True)
  annotationsFilter = _messages.StringField(2)
  annotationsLimit = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  dataItemFilter = _messages.StringField(4)
  dataLabelingJob = _messages.StringField(5)
  dataset = _messages.StringField(6, required=True)
  fieldMask = _messages.StringField(7)
  orderBy = _messages.StringField(8)
  orderByAnnotation_orderBy = _messages.StringField(9)
  orderByAnnotation_savedQuery = _messages.StringField(10)
  orderByDataItem = _messages.StringField(11)
  pageSize = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(13)
  savedQuery = _messages.StringField(14)


class AiplatformProjectsLocationsEndpointsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsCreateRequest object.

  Fields:
    endpointId: Immutable. The ID to use for endpoint, which will become the
      final component of the endpoint resource name. If not provided, Vertex
      AI will generate a value for this ID. If the first character is a
      letter, this value may be up to 63 characters, and valid characters are
      `[a-z0-9-]`. The last character must be a letter or number. If the first
      character is a number, this value may be up to 9 characters, and valid
      characters are `[0-9]` with no leading zeros. When using HTTP/JSON, this
      field is populated based on a query string argument, such as
      `?endpoint_id=12345`. This is the fallback for fields that are not
      included in either the URI or the body.
    googleCloudAiplatformV1Endpoint: A GoogleCloudAiplatformV1Endpoint
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the Endpoint
      in. Format: `projects/{project}/locations/{location}`
  """

  endpointId = _messages.StringField(1)
  googleCloudAiplatformV1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1Endpoint', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsEndpointsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeleteRequest object.

  Fields:
    name: Required. The name of the Endpoint resource to be deleted. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsDeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource into which to deploy
      a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1DeployModelRequest: A
      GoogleCloudAiplatformV1DeployModelRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1DeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1DeployModelRequest', 2)


class AiplatformProjectsLocationsEndpointsExplainRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsExplainRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      explanation. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1ExplainRequest: A
      GoogleCloudAiplatformV1ExplainRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1ExplainRequest = _messages.MessageField('GoogleCloudAiplatformV1ExplainRequest', 2)


class AiplatformProjectsLocationsEndpointsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsGetRequest object.

  Fields:
    name: Required. The name of the Endpoint resource. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `endpoint` supports = and !=. `endpoint` represents the Endpoint ID,
      i.e. the last segment of the Endpoint's resource name. * `display_name`
      supports = and, != * `labels` supports general map functions that is: *
      `labels.key=value` - key:value equality * `labels.key:* or labels:key -
      key existence * A key including a space must be quoted. `labels."a
      key"`. Some examples: * `endpoint=1` * `displayName="myDisplayName"` *
      `labels.myKey="myValue"`
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `display_name` * `create_time` * `update_time` Example: `display_name,
      create_time desc`.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListEndpointsResponse.next_page_token of the previous
      EndpointService.ListEndpoints call.
    parent: Required. The resource name of the Location from which to list the
      Endpoints. Format: `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsEndpointsMutateDeployedModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsMutateDeployedModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource into which to mutate
      a DeployedModel. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1MutateDeployedModelRequest: A
      GoogleCloudAiplatformV1MutateDeployedModelRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1MutateDeployedModelRequest = _messages.MessageField('GoogleCloudAiplatformV1MutateDeployedModelRequest', 2)


class AiplatformProjectsLocationsEndpointsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPatchRequest object.

  Fields:
    googleCloudAiplatformV1Endpoint: A GoogleCloudAiplatformV1Endpoint
      resource to be passed as the request body.
    name: Output only. The resource name of the Endpoint.
    updateMask: Required. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1Endpoint', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsEndpointsPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1PredictRequest: A
      GoogleCloudAiplatformV1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1PredictRequest', 2)


class AiplatformProjectsLocationsEndpointsRawPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsRawPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1RawPredictRequest: A
      GoogleCloudAiplatformV1RawPredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1RawPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1RawPredictRequest', 2)


class AiplatformProjectsLocationsEndpointsUndeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsUndeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource from which to
      undeploy a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1UndeployModelRequest: A
      GoogleCloudAiplatformV1UndeployModelRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1UndeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1UndeployModelRequest', 2)


class AiplatformProjectsLocationsFeaturestoresBatchReadFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresBatchReadFeatureValuesRequest
  object.

  Fields:
    featurestore: Required. The resource name of the Featurestore from which
      to query Feature values. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    googleCloudAiplatformV1BatchReadFeatureValuesRequest: A
      GoogleCloudAiplatformV1BatchReadFeatureValuesRequest resource to be
      passed as the request body.
  """

  featurestore = _messages.StringField(1, required=True)
  googleCloudAiplatformV1BatchReadFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1BatchReadFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresCreateRequest object.

  Fields:
    featurestoreId: Required. The ID to use for this Featurestore, which will
      become the final component of the Featurestore's resource name. This
      value may be up to 60 characters, and valid characters are `[a-z0-9_]`.
      The first character cannot be a number. The value must be unique within
      the project and location.
    googleCloudAiplatformV1Featurestore: A GoogleCloudAiplatformV1Featurestore
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create
      Featurestores. Format: `projects/{project}/locations/{location}`
  """

  featurestoreId = _messages.StringField(1)
  googleCloudAiplatformV1Featurestore = _messages.MessageField('GoogleCloudAiplatformV1Featurestore', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeaturestoresDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresDeleteRequest object.

  Fields:
    force: If set to true, any EntityTypes and Features for this Featurestore
      will also be deleted. (Otherwise, the request will only work if the
      Featurestore has no EntityTypes.)
    name: Required. The name of the Featurestore to be deleted. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesCreateRequest
  object.

  Fields:
    entityTypeId: Required. The ID to use for the EntityType, which will
      become the final component of the EntityType's resource name. This value
      may be up to 60 characters, and valid characters are `[a-z0-9_]`. The
      first character cannot be a number. The value must be unique within a
      featurestore.
    googleCloudAiplatformV1EntityType: A GoogleCloudAiplatformV1EntityType
      resource to be passed as the request body.
    parent: Required. The resource name of the Featurestore to create
      EntityTypes. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
  """

  entityTypeId = _messages.StringField(1)
  googleCloudAiplatformV1EntityType = _messages.MessageField('GoogleCloudAiplatformV1EntityType', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteFeatureValues
  Request object.

  Fields:
    entityType: Required. The resource name of the EntityType grouping the
      Features for which values are being deleted from. Format: `projects/{pro
      ject}/locations/{location}/featurestores/{featurestore}/entityTypes/{ent
      ityType}`
    googleCloudAiplatformV1DeleteFeatureValuesRequest: A
      GoogleCloudAiplatformV1DeleteFeatureValuesRequest resource to be passed
      as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1DeleteFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1DeleteFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteRequest
  object.

  Fields:
    force: If set to true, any Features for this EntityType will also be
      deleted. (Otherwise, the request will only work if the EntityType has no
      Features.)
    name: Required. The name of the EntityType to be deleted. Format: `project
      s/{project}/locations/{location}/featurestores/{featurestore}/entityType
      s/{entity_type}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesExportFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesExportFeatureValues
  Request object.

  Fields:
    entityType: Required. The resource name of the EntityType from which to
      export Feature values. Format: `projects/{project}/locations/{location}/
      featurestores/{featurestore}/entityTypes/{entity_type}`
    googleCloudAiplatformV1ExportFeatureValuesRequest: A
      GoogleCloudAiplatformV1ExportFeatureValuesRequest resource to be passed
      as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1ExportFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1ExportFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesBatchCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesBatchCreate
  Request object.

  Fields:
    googleCloudAiplatformV1BatchCreateFeaturesRequest: A
      GoogleCloudAiplatformV1BatchCreateFeaturesRequest resource to be passed
      as the request body.
    parent: Required. The resource name of the EntityType to create the batch
      of Features under. Format: `projects/{project}/locations/{location}/feat
      urestores/{featurestore}/entityTypes/{entity_type}`
  """

  googleCloudAiplatformV1BatchCreateFeaturesRequest = _messages.MessageField('GoogleCloudAiplatformV1BatchCreateFeaturesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesCreateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesCreateRequest
  object.

  Fields:
    featureId: Required. The ID to use for the Feature, which will become the
      final component of the Feature's resource name. This value may be up to
      128 characters, and valid characters are `[a-z0-9_]`. The first
      character cannot be a number. The value must be unique within an
      EntityType/FeatureGroup.
    googleCloudAiplatformV1Feature: A GoogleCloudAiplatformV1Feature resource
      to be passed as the request body.
    parent: Required. The resource name of the EntityType or FeatureGroup to
      create a Feature. Format for entity_type as parent: `projects/{project}/
      locations/{location}/featurestores/{featurestore}/entityTypes/{entity_ty
      pe}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  featureId = _messages.StringField(1)
  googleCloudAiplatformV1Feature = _messages.MessageField('GoogleCloudAiplatformV1Feature', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesDeleteRequest
  object.

  Fields:
    name: Required. The name of the Features to be deleted. Format: `projects/
      {project}/locations/{location}/featurestores/{featurestore}/entityTypes/
      {entity_type}/features/{feature}` `projects/{project}/locations/{locatio
      n}/featureGroups/{feature_group}/features/{feature}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesGetRequest
  object.

  Fields:
    name: Required. The name of the Feature resource. Format for entity_type
      as parent: `projects/{project}/locations/{location}/featurestores/{featu
      restore}/entityTypes/{entity_type}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesListRequest
  object.

  Fields:
    filter: Lists the Features that match the filter expression. The following
      filters are supported: * `value_type`: Supports = and != comparisons. *
      `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
      be in RFC 3339 format. * `update_time`: Supports =, !=, <, >, >=, and <=
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality as well as key presence. Examples: * `value_type =
      DOUBLE` --> Features whose type is DOUBLE. * `create_time >
      \"2020-01-31T15:30:00.000000Z\" OR update_time >
      \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created or updated
      after 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env
      = prod` --> Features having both (active: yes) and (env: prod) labels. *
      `labels.env: *` --> Any Feature which has a label with 'env' as the key.
    latestStatsCount: Only applicable for Vertex AI Feature Store (Legacy). If
      set, return the most recent ListFeaturesRequest.latest_stats_count of
      stats for each Feature in response. Valid value is [0, 10]. If number of
      stats exists < ListFeaturesRequest.latest_stats_count, return all
      existing stats.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `feature_id` * `value_type` (Not supported for FeatureRegistry Feature)
      * `create_time` * `update_time`
    pageSize: The maximum number of Features to return. The service may return
      fewer than this value. If unspecified, at most 1000 Features will be
      returned. The maximum value is 1000; any value greater than 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous
      FeaturestoreService.ListFeatures call or
      FeatureRegistryService.ListFeatures call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.ListFeatures or or
      FeatureRegistryService.ListFeatures must match the call that provided
      the page token.
    parent: Required. The resource name of the Location to list Features.
      Format for entity_type as parent: `projects/{project}/locations/{locatio
      n}/featurestores/{featurestore}/entityTypes/{entity_type}` Format for
      feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  latestStatsCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)
  readMask = _messages.StringField(7)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesPatchRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1Feature: A GoogleCloudAiplatformV1Feature resource
      to be passed as the request body.
    name: Immutable. Name of the Feature. Format: `projects/{project}/location
      s/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/feat
      ures/{feature}` `projects/{project}/locations/{location}/featureGroups/{
      feature_group}/features/{feature}` The last part feature is assigned by
      the client. The feature can be up to 64 characters long and can consist
      only of ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits
      0-9 starting with a letter. The value will be unique given an entity
      type.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Features resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `description` * `labels` * `disable_monitoring` (Not
      supported for FeatureRegistry Feature)
  """

  googleCloudAiplatformV1Feature = _messages.MessageField('GoogleCloudAiplatformV1Feature', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeaturestoresEntityTypesGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesGetRequest object.

  Fields:
    name: Required. The name of the EntityType resource. Format: `projects/{pr
      oject}/locations/{location}/featurestores/{featurestore}/entityTypes/{en
      tity_type}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesImportFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesImportFeatureValues
  Request object.

  Fields:
    entityType: Required. The resource name of the EntityType grouping the
      Features for which values are being imported. Format: `projects/{project
      }/locations/{location}/featurestores/{featurestore}/entityTypes/{entityT
      ype}`
    googleCloudAiplatformV1ImportFeatureValuesRequest: A
      GoogleCloudAiplatformV1ImportFeatureValuesRequest resource to be passed
      as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1ImportFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1ImportFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesListRequest object.

  Fields:
    filter: Lists the EntityTypes that match the filter expression. The
      following filters are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `>=`, and `<=` comparisons. Values must be in RFC 3339 format.
      * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=`
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality as well as key presence. Examples: * `create_time >
      \"2020-01-31T15:30:00.000000Z\" OR update_time >
      \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created or updated
      after 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env
      = prod` --> EntityTypes having both (active: yes) and (env: prod)
      labels. * `labels.env: *` --> Any EntityType which has a label with
      'env' as the key.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `entity_type_id` * `create_time` * `update_time`
    pageSize: The maximum number of EntityTypes to return. The service may
      return fewer than this value. If unspecified, at most 1000 EntityTypes
      will be returned. The maximum value is 1000; any value greater than 1000
      will be coerced to 1000.
    pageToken: A page token, received from a previous
      FeaturestoreService.ListEntityTypes call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.ListEntityTypes must match the call that provided
      the page token.
    parent: Required. The resource name of the Featurestore to list
      EntityTypes. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsFeaturestoresEntityTypesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1EntityType: A GoogleCloudAiplatformV1EntityType
      resource to be passed as the request body.
    name: Immutable. Name of the EntityType. Format: `projects/{project}/locat
      ions/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
      The last part entity_type is assigned by the client. The entity_type can
      be up to 64 characters long and can consist only of ASCII Latin letters
      A-Z and a-z and underscore(_), and ASCII digits 0-9 starting with a
      letter. The value will be unique given a featurestore.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the EntityType resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `description` * `labels` *
      `monitoring_config.snapshot_analysis.disabled` *
      `monitoring_config.snapshot_analysis.monitoring_interval_days` *
      `monitoring_config.snapshot_analysis.staleness_days` *
      `monitoring_config.import_features_analysis.state` *
      `monitoring_config.import_features_analysis.anomaly_detection_baseline`
      * `monitoring_config.numerical_threshold_config.value` *
      `monitoring_config.categorical_threshold_config.value` *
      `offline_storage_ttl_days`
  """

  googleCloudAiplatformV1EntityType = _messages.MessageField('GoogleCloudAiplatformV1EntityType', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeaturestoresEntityTypesReadFeatureValuesRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesReadFeatureValuesRequest
  object.

  Fields:
    entityType: Required. The resource name of the EntityType for the entity
      being read. Value format: `projects/{project}/locations/{location}/featu
      restores/{featurestore}/entityTypes/{entityType}`. For example, for a
      machine learning model predicting user clicks on a website, an
      EntityType ID could be `user`.
    googleCloudAiplatformV1ReadFeatureValuesRequest: A
      GoogleCloudAiplatformV1ReadFeatureValuesRequest resource to be passed as
      the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1ReadFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1ReadFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesStreamingReadFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesStreamingReadFeatur
  eValuesRequest object.

  Fields:
    entityType: Required. The resource name of the entities' type. Value
      format: `projects/{project}/locations/{location}/featurestores/{features
      tore}/entityTypes/{entityType}`. For example, for a machine learning
      model predicting user clicks on a website, an EntityType ID could be
      `user`.
    googleCloudAiplatformV1StreamingReadFeatureValuesRequest: A
      GoogleCloudAiplatformV1StreamingReadFeatureValuesRequest resource to be
      passed as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1StreamingReadFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1StreamingReadFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesTestIamPermissionsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesTestIamPermissionsRequest
  object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesWriteFeatureValuesRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesWriteFeatureValuesRequest
  object.

  Fields:
    entityType: Required. The resource name of the EntityType for the entities
      being written. Value format:
      `projects/{project}/locations/{location}/featurestores/
      {featurestore}/entityTypes/{entityType}`. For example, for a machine
      learning model predicting user clicks on a website, an EntityType ID
      could be `user`.
    googleCloudAiplatformV1WriteFeatureValuesRequest: A
      GoogleCloudAiplatformV1WriteFeatureValuesRequest resource to be passed
      as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1WriteFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1WriteFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresGetRequest object.

  Fields:
    name: Required. The name of the Featurestore resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresListRequest object.

  Fields:
    filter: Lists the featurestores that match the filter expression. The
      following fields are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format.
      * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
      comparisons. Values must be in RFC 3339 format. *
      `online_serving_config.fixed_node_count`: Supports `=`, `!=`, `<`, `>`,
      `<=`, and `>=` comparisons. * `labels`: Supports key-value equality and
      key presence. Examples: * `create_time > "2020-01-01" OR update_time >
      "2020-01-01"` Featurestores created or updated after 2020-01-01. *
      `labels.env = "prod"` Featurestores with label "env" set to "prod".
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported Fields: *
      `create_time` * `update_time` * `online_serving_config.fixed_node_count`
    pageSize: The maximum number of Featurestores to return. The service may
      return fewer than this value. If unspecified, at most 100 Featurestores
      will be returned. The maximum value is 100; any value greater than 100
      will be coerced to 100.
    pageToken: A page token, received from a previous
      FeaturestoreService.ListFeaturestores call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.ListFeaturestores must match the call that provided
      the page token.
    parent: Required. The resource name of the Location to list Featurestores.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsFeaturestoresPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresPatchRequest object.

  Fields:
    googleCloudAiplatformV1Featurestore: A GoogleCloudAiplatformV1Featurestore
      resource to be passed as the request body.
    name: Output only. Name of the Featurestore. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Featurestore resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `labels` * `online_serving_config.fixed_node_count`
      * `online_serving_config.scaling` * `online_storage_ttl_days`
  """

  googleCloudAiplatformV1Featurestore = _messages.MessageField('GoogleCloudAiplatformV1Featurestore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeaturestoresSearchFeaturesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresSearchFeaturesRequest object.

  Fields:
    location: Required. The resource name of the Location to search Features.
      Format: `projects/{project}/locations/{location}`
    pageSize: The maximum number of Features to return. The service may return
      fewer than this value. If unspecified, at most 100 Features will be
      returned. The maximum value is 100; any value greater than 100 will be
      coerced to 100.
    pageToken: A page token, received from a previous
      FeaturestoreService.SearchFeatures call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.SearchFeatures, except `page_size`, must match the
      call that provided the page token.
    query: Query string that is a conjunction of field-restricted queries
      and/or field-restricted filters. Field-restricted queries and filters
      can be combined using `AND` to form a conjunction. A field query is in
      the form FIELD:QUERY. This implicitly checks if QUERY exists as a
      substring within Feature's FIELD. The QUERY and the FIELD are converted
      to a sequence of words (i.e. tokens) for comparison. This is done by: *
      Removing leading/trailing whitespace and tokenizing the search value.
      Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
      `_`, or asterisk `*` are treated as delimiters for tokens. `*` is
      treated as a wildcard that matches characters within a token. * Ignoring
      case. * Prepending an asterisk to the first and appending an asterisk to
      the last token in QUERY. A QUERY must be either a singular token or a
      phrase. A phrase is one or multiple words enclosed in double quotation
      marks ("). With phrases, the order of the words is important. Words in
      the phrase must be matching in order and consecutively. Supported FIELDs
      for field-restricted queries: * `feature_id` * `description` *
      `entity_type_id` Examples: * `feature_id: foo` --> Matches a Feature
      with ID containing the substring `foo` (eg. `foo`, `foofeature`,
      `barfoo`). * `feature_id: foo*feature` --> Matches a Feature with ID
      containing the substring `foo*feature` (eg. `foobarfeature`). *
      `feature_id: foo AND description: bar` --> Matches a Feature with ID
      containing the substring `foo` and description containing the substring
      `bar`. Besides field queries, the following exact-match filters are
      supported. The exact-match filters do not support wildcards. Unlike
      field-restricted queries, exact-match filters are case-sensitive. *
      `feature_id`: Supports = comparisons. * `description`: Supports =
      comparisons. Multi-token filters should be enclosed in quotes. *
      `entity_type_id`: Supports = comparisons. * `value_type`: Supports = and
      != comparisons. * `labels`: Supports key-value equality as well as key
      presence. * `featurestore_id`: Supports = comparisons. Examples: *
      `description = "foo bar"` --> Any Feature with description exactly equal
      to `foo bar` * `value_type = DOUBLE` --> Features whose type is DOUBLE.
      * `labels.active = yes AND labels.env = prod` --> Features having both
      (active: yes) and (env: prod) labels. * `labels.env: *` --> Any Feature
      which has a label with `env` as the key.
  """

  location = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  query = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresTestIamPermissionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresTestIamPermissionsRequest
  object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest
  object.

  Fields:
    googleCloudAiplatformV1CancelHyperparameterTuningJobRequest: A
      GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest resource to
      be passed as the request body.
    name: Required. The name of the HyperparameterTuningJob to cancel. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  googleCloudAiplatformV1CancelHyperparameterTuningJobRequest = _messages.MessageField('GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1HyperparameterTuningJob: A
      GoogleCloudAiplatformV1HyperparameterTuningJob resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      HyperparameterTuningJob in. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1HyperparameterTuningJob = _messages.MessageField('GoogleCloudAiplatformV1HyperparameterTuningJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest
  object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource to be
      deleted. Format: `projects/{project}/locations/{location}/hyperparameter
      TuningJobs/{hyperparameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListHyperparameterTuningJobsResponse.next_page_token of the previous
      JobService.ListHyperparameterTuningJobs call.
    parent: Required. The resource name of the Location to list the
      HyperparameterTuningJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsIndexEndpointsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsCreateRequest object.

  Fields:
    googleCloudAiplatformV1IndexEndpoint: A
      GoogleCloudAiplatformV1IndexEndpoint resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      IndexEndpoint in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1IndexEndpoint = _messages.MessageField('GoogleCloudAiplatformV1IndexEndpoint', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsDeleteRequest object.

  Fields:
    name: Required. The name of the IndexEndpoint resource to be deleted.
      Format: `projects/{project}/locations/{location}/indexEndpoints/{index_e
      ndpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexEndpointsDeployIndexRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsDeployIndexRequest object.

  Fields:
    googleCloudAiplatformV1DeployIndexRequest: A
      GoogleCloudAiplatformV1DeployIndexRequest resource to be passed as the
      request body.
    indexEndpoint: Required. The name of the IndexEndpoint resource into which
      to deploy an Index. Format: `projects/{project}/locations/{location}/ind
      exEndpoints/{index_endpoint}`
  """

  googleCloudAiplatformV1DeployIndexRequest = _messages.MessageField('GoogleCloudAiplatformV1DeployIndexRequest', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsGetRequest object.

  Fields:
    name: Required. The name of the IndexEndpoint resource. Format:
      `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}
      `
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexEndpointsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `index_endpoint` supports = and !=. `index_endpoint` represents the
      IndexEndpoint ID, ie. the last segment of the IndexEndpoint's
      resourcename. * `display_name` supports =, != and regex() (uses
      [re2](https://github.com/google/re2/wiki/Syntax) syntax) * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* or labels:key - key existence A key including a
      space must be quoted. `labels."a key"`. Some examples: *
      `index_endpoint="1"` * `display_name="myDisplayName"` *
      `regex(display_name, "^A") -> The display name starts with an A. *
      `labels.myKey="myValue"`
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListIndexEndpointsResponse.next_page_token of the previous
      IndexEndpointService.ListIndexEndpoints call.
    parent: Required. The resource name of the Location from which to list the
      IndexEndpoints. Format: `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsIndexEndpointsMutateDeployedIndexRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsMutateDeployedIndexRequest
  object.

  Fields:
    googleCloudAiplatformV1DeployedIndex: A
      GoogleCloudAiplatformV1DeployedIndex resource to be passed as the
      request body.
    indexEndpoint: Required. The name of the IndexEndpoint resource into which
      to deploy an Index. Format: `projects/{project}/locations/{location}/ind
      exEndpoints/{index_endpoint}`
  """

  googleCloudAiplatformV1DeployedIndex = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndex', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsPatchRequest object.

  Fields:
    googleCloudAiplatformV1IndexEndpoint: A
      GoogleCloudAiplatformV1IndexEndpoint resource to be passed as the
      request body.
    name: Output only. The resource name of the IndexEndpoint.
    updateMask: Required. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1IndexEndpoint = _messages.MessageField('GoogleCloudAiplatformV1IndexEndpoint', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsIndexEndpointsUndeployIndexRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsUndeployIndexRequest object.

  Fields:
    googleCloudAiplatformV1UndeployIndexRequest: A
      GoogleCloudAiplatformV1UndeployIndexRequest resource to be passed as the
      request body.
    indexEndpoint: Required. The name of the IndexEndpoint resource from which
      to undeploy an Index. Format: `projects/{project}/locations/{location}/i
      ndexEndpoints/{index_endpoint}`
  """

  googleCloudAiplatformV1UndeployIndexRequest = _messages.MessageField('GoogleCloudAiplatformV1UndeployIndexRequest', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesCreateRequest object.

  Fields:
    googleCloudAiplatformV1Index: A GoogleCloudAiplatformV1Index resource to
      be passed as the request body.
    parent: Required. The resource name of the Location to create the Index
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1Index = _messages.MessageField('GoogleCloudAiplatformV1Index', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesDeleteRequest object.

  Fields:
    name: Required. The name of the Index resource to be deleted. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesGetRequest object.

  Fields:
    name: Required. The name of the Index resource. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListIndexesResponse.next_page_token of the previous
      IndexService.ListIndexes call.
    parent: Required. The resource name of the Location from which to list the
      Indexes. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsIndexesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesPatchRequest object.

  Fields:
    googleCloudAiplatformV1Index: A GoogleCloudAiplatformV1Index resource to
      be passed as the request body.
    name: Output only. The resource name of the Index.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1Index = _messages.MessageField('GoogleCloudAiplatformV1Index', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsIndexesRemoveDatapointsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesRemoveDatapointsRequest object.

  Fields:
    googleCloudAiplatformV1RemoveDatapointsRequest: A
      GoogleCloudAiplatformV1RemoveDatapointsRequest resource to be passed as
      the request body.
    index: Required. The name of the Index resource to be updated. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  googleCloudAiplatformV1RemoveDatapointsRequest = _messages.MessageField('GoogleCloudAiplatformV1RemoveDatapointsRequest', 1)
  index = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexesUpsertDatapointsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesUpsertDatapointsRequest object.

  Fields:
    googleCloudAiplatformV1UpsertDatapointsRequest: A
      GoogleCloudAiplatformV1UpsertDatapointsRequest resource to be passed as
      the request body.
    index: Required. The name of the Index resource to be updated. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  googleCloudAiplatformV1UpsertDatapointsRequest = _messages.MessageField('GoogleCloudAiplatformV1UpsertDatapointsRequest', 1)
  index = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsCreateRequest
  object.

  Fields:
    artifactId: The {artifact} portion of the resource name with the format: `
      projects/{project}/locations/{location}/metadataStores/{metadatastore}/a
      rtifacts/{artifact}` If not provided, the Artifact's ID will be a UUID
      generated by the service. Must be 4-128 characters in length. Valid
      characters are `/a-z-/`. Must be unique across all Artifacts in the
      parent MetadataStore. (Otherwise the request will fail with
      ALREADY_EXISTS, or PERMISSION_DENIED if the caller can't view the
      preexisting Artifact.)
    googleCloudAiplatformV1Artifact: A GoogleCloudAiplatformV1Artifact
      resource to be passed as the request body.
    parent: Required. The resource name of the MetadataStore where the
      Artifact should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  artifactId = _messages.StringField(1)
  googleCloudAiplatformV1Artifact = _messages.MessageField('GoogleCloudAiplatformV1Artifact', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsDeleteRequest
  object.

  Fields:
    etag: Optional. The etag of the Artifact to delete. If this is provided,
      it must match the server's etag. Otherwise, the request will fail with a
      FAILED_PRECONDITION.
    name: Required. The resource name of the Artifact to delete. Format: `proj
      ects/{project}/locations/{location}/metadataStores/{metadatastore}/artif
      acts/{artifact}`
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsGetRequest object.

  Fields:
    name: Required. The resource name of the Artifact to retrieve. Format: `pr
      ojects/{project}/locations/{location}/metadataStores/{metadatastore}/art
      ifacts/{artifact}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsListRequest object.

  Fields:
    filter: Filter specifying the boolean condition for the Artifacts to
      satisfy in order to be part of the result set. The syntax to define
      filter query is based on https://google.aip.dev/160. The supported set
      of filters include the following: * **Attribute filtering**: For
      example: `display_name = "test"`. Supported fields include: `name`,
      `display_name`, `uri`, `state`, `schema_title`, `create_time`, and
      `update_time`. Time fields, such as `create_time` and `update_time`,
      require values specified in RFC-3339 format. For example: `create_time =
      "2020-11-19T11:30:00-04:00"` * **Metadata field**: To filter on metadata
      fields use traversal operation as follows: `metadata..`. For example:
      `metadata.field_1.number_value = 10.0` In case the field name contains
      special characters (such as colon), one can embed it inside double
      quote. For example: `metadata."field:1".number_value = 10.0` * **Context
      based filtering**: To filter Artifacts based on the contexts to which
      they belong, use the function operator with the full resource name
      `in_context()`. For example:
      `in_context("projects//locations//metadataStores//contexts/")` Each of
      the above supported filter types can be combined together using logical
      operators (`AND` & `OR`). Maximum nested expression depth allowed is 5.
      For example: `display_name = "test" AND metadata.field1.bool_value =
      true`.
    orderBy: How the list of messages is ordered. Specify the values to order
      by and an ordering operation. The default sorting order is ascending. To
      specify descending order for a field, users append a " desc" suffix; for
      example: "foo desc, bar". Subfields are specified with a `.` character,
      such as foo.bar. see https://google.aip.dev/132#ordering for more
      details.
    pageSize: The maximum number of Artifacts to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListArtifacts call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose Artifacts should be listed.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the Artifact is not found, a new
      Artifact is created.
    googleCloudAiplatformV1Artifact: A GoogleCloudAiplatformV1Artifact
      resource to be passed as the request body.
    name: Output only. The resource name of the Artifact.
    updateMask: Optional. A FieldMask indicating which fields should be
      updated.
  """

  allowMissing = _messages.BooleanField(1)
  googleCloudAiplatformV1Artifact = _messages.MessageField('GoogleCloudAiplatformV1Artifact', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresArtifactsPurgeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsPurgeRequest object.

  Fields:
    googleCloudAiplatformV1PurgeArtifactsRequest: A
      GoogleCloudAiplatformV1PurgeArtifactsRequest resource to be passed as
      the request body.
    parent: Required. The metadata store to purge Artifacts from. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1PurgeArtifactsRequest = _messages.MessageField('GoogleCloudAiplatformV1PurgeArtifactsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsQueryArtifactLineageSubgraphRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsQueryArtifactLineage
  SubgraphRequest object.

  Fields:
    artifact: Required. The resource name of the Artifact whose Lineage needs
      to be retrieved as a LineageSubgraph. Format: `projects/{project}/locati
      ons/{location}/metadataStores/{metadatastore}/artifacts/{artifact}` The
      request may error with FAILED_PRECONDITION if the number of Artifacts,
      the number of Executions, or the number of Events that would be returned
      for the Context exceeds 1000.
    filter: Filter specifying the boolean condition for the Artifacts to
      satisfy in order to be part of the Lineage Subgraph. The syntax to
      define filter query is based on https://google.aip.dev/160. The
      supported set of filters include the following: * **Attribute
      filtering**: For example: `display_name = "test"` Supported fields
      include: `name`, `display_name`, `uri`, `state`, `schema_title`,
      `create_time`, and `update_time`. Time fields, such as `create_time` and
      `update_time`, require values specified in RFC-3339 format. For example:
      `create_time = "2020-11-19T11:30:00-04:00"` * **Metadata field**: To
      filter on metadata fields use traversal operation as follows:
      `metadata..`. For example: `metadata.field_1.number_value = 10.0` In
      case the field name contains special characters (such as colon), one can
      embed it inside double quote. For example:
      `metadata."field:1".number_value = 10.0` Each of the above supported
      filter types can be combined together using logical operators (`AND` &
      `OR`). Maximum nested expression depth allowed is 5. For example:
      `display_name = "test" AND metadata.field1.bool_value = true`.
    maxHops: Specifies the size of the lineage graph in terms of number of
      hops from the specified artifact. Negative Value: INVALID_ARGUMENT error
      is returned 0: Only input artifact is returned. No value: Transitive
      closure is performed to return the complete graph.
  """

  artifact = _messages.StringField(1, required=True)
  filter = _messages.StringField(2)
  maxHops = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class AiplatformProjectsLocationsMetadataStoresContextsAddContextArtifactsAndExecutionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsAddContextArtifactsAn
  dExecutionsRequest object.

  Fields:
    context: Required. The resource name of the Context that the Artifacts and
      Executions belong to. Format: `projects/{project}/locations/{location}/m
      etadataStores/{metadatastore}/contexts/{context}`
    googleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest: A
      GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest resource
      to be passed as the request body.
  """

  context = _messages.StringField(1, required=True)
  googleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest = _messages.MessageField('GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest', 2)


class AiplatformProjectsLocationsMetadataStoresContextsAddContextChildrenRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresContextsAddContextChildrenRequest
  object.

  Fields:
    context: Required. The resource name of the parent Context. Format: `proje
      cts/{project}/locations/{location}/metadataStores/{metadatastore}/contex
      ts/{context}`
    googleCloudAiplatformV1AddContextChildrenRequest: A
      GoogleCloudAiplatformV1AddContextChildrenRequest resource to be passed
      as the request body.
  """

  context = _messages.StringField(1, required=True)
  googleCloudAiplatformV1AddContextChildrenRequest = _messages.MessageField('GoogleCloudAiplatformV1AddContextChildrenRequest', 2)


class AiplatformProjectsLocationsMetadataStoresContextsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsCreateRequest object.

  Fields:
    contextId: The {context} portion of the resource name with the format: `pr
      ojects/{project}/locations/{location}/metadataStores/{metadatastore}/con
      texts/{context}`. If not provided, the Context's ID will be a UUID
      generated by the service. Must be 4-128 characters in length. Valid
      characters are `/a-z-/`. Must be unique across all Contexts in the
      parent MetadataStore. (Otherwise the request will fail with
      ALREADY_EXISTS, or PERMISSION_DENIED if the caller can't view the
      preexisting Context.)
    googleCloudAiplatformV1Context: A GoogleCloudAiplatformV1Context resource
      to be passed as the request body.
    parent: Required. The resource name of the MetadataStore where the Context
      should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  contextId = _messages.StringField(1)
  googleCloudAiplatformV1Context = _messages.MessageField('GoogleCloudAiplatformV1Context', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsDeleteRequest object.

  Fields:
    etag: Optional. The etag of the Context to delete. If this is provided, it
      must match the server's etag. Otherwise, the request will fail with a
      FAILED_PRECONDITION.
    force: The force deletion semantics is still undefined. Users should not
      use this field.
    name: Required. The resource name of the Context to delete. Format: `proje
      cts/{project}/locations/{location}/metadataStores/{metadatastore}/contex
      ts/{context}`
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsGetRequest object.

  Fields:
    name: Required. The resource name of the Context to retrieve. Format: `pro
      jects/{project}/locations/{location}/metadataStores/{metadatastore}/cont
      exts/{context}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsListRequest object.

  Fields:
    filter: Filter specifying the boolean condition for the Contexts to
      satisfy in order to be part of the result set. The syntax to define
      filter query is based on https://google.aip.dev/160. Following are the
      supported set of filters: * **Attribute filtering**: For example:
      `display_name = "test"`. Supported fields include: `name`,
      `display_name`, `schema_title`, `create_time`, and `update_time`. Time
      fields, such as `create_time` and `update_time`, require values
      specified in RFC-3339 format. For example: `create_time =
      "2020-11-19T11:30:00-04:00"`. * **Metadata field**: To filter on
      metadata fields use traversal operation as follows: `metadata..`. For
      example: `metadata.field_1.number_value = 10.0`. In case the field name
      contains special characters (such as colon), one can embed it inside
      double quote. For example: `metadata."field:1".number_value = 10.0` *
      **Parent Child filtering**: To filter Contexts based on parent-child
      relationship use the HAS operator as follows: ``` parent_contexts:
      "projects//locations//metadataStores//contexts/" child_contexts:
      "projects//locations//metadataStores//contexts/" ``` Each of the above
      supported filters can be combined together using logical operators
      (`AND` & `OR`). Maximum nested expression depth allowed is 5. For
      example: `display_name = "test" AND metadata.field1.bool_value = true`.
    orderBy: How the list of messages is ordered. Specify the values to order
      by and an ordering operation. The default sorting order is ascending. To
      specify descending order for a field, users append a " desc" suffix; for
      example: "foo desc, bar". Subfields are specified with a `.` character,
      such as foo.bar. see https://google.aip.dev/132#ordering for more
      details.
    pageSize: The maximum number of Contexts to return. The service may return
      fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListContexts call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose Contexts should be listed.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the Context is not found, a new Context
      is created.
    googleCloudAiplatformV1Context: A GoogleCloudAiplatformV1Context resource
      to be passed as the request body.
    name: Immutable. The resource name of the Context.
    updateMask: Optional. A FieldMask indicating which fields should be
      updated.
  """

  allowMissing = _messages.BooleanField(1)
  googleCloudAiplatformV1Context = _messages.MessageField('GoogleCloudAiplatformV1Context', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresContextsPurgeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsPurgeRequest object.

  Fields:
    googleCloudAiplatformV1PurgeContextsRequest: A
      GoogleCloudAiplatformV1PurgeContextsRequest resource to be passed as the
      request body.
    parent: Required. The metadata store to purge Contexts from. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1PurgeContextsRequest = _messages.MessageField('GoogleCloudAiplatformV1PurgeContextsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsQueryContextLineageSubgraphRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsQueryContextLineageSu
  bgraphRequest object.

  Fields:
    context: Required. The resource name of the Context whose Artifacts and
      Executions should be retrieved as a LineageSubgraph. Format: `projects/{
      project}/locations/{location}/metadataStores/{metadatastore}/contexts/{c
      ontext}` The request may error with FAILED_PRECONDITION if the number of
      Artifacts, the number of Executions, or the number of Events that would
      be returned for the Context exceeds 1000.
  """

  context = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsRemoveContextChildrenRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsRemoveContextChildren
  Request object.

  Fields:
    context: Required. The resource name of the parent Context. Format: `proje
      cts/{project}/locations/{location}/metadataStores/{metadatastore}/contex
      ts/{context}`
    googleCloudAiplatformV1RemoveContextChildrenRequest: A
      GoogleCloudAiplatformV1RemoveContextChildrenRequest resource to be
      passed as the request body.
  """

  context = _messages.StringField(1, required=True)
  googleCloudAiplatformV1RemoveContextChildrenRequest = _messages.MessageField('GoogleCloudAiplatformV1RemoveContextChildrenRequest', 2)


class AiplatformProjectsLocationsMetadataStoresCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresCreateRequest object.

  Fields:
    googleCloudAiplatformV1MetadataStore: A
      GoogleCloudAiplatformV1MetadataStore resource to be passed as the
      request body.
    metadataStoreId: The {metadatastore} portion of the resource name with the
      format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
      If not provided, the MetadataStore's ID will be a UUID generated by the
      service. Must be 4-128 characters in length. Valid characters are
      `/a-z-/`. Must be unique across all MetadataStores in the parent
      Location. (Otherwise the request will fail with ALREADY_EXISTS, or
      PERMISSION_DENIED if the caller can't view the preexisting
      MetadataStore.)
    parent: Required. The resource name of the Location where the
      MetadataStore should be created. Format:
      `projects/{project}/locations/{location}/`
  """

  googleCloudAiplatformV1MetadataStore = _messages.MessageField('GoogleCloudAiplatformV1MetadataStore', 1)
  metadataStoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresDeleteRequest object.

  Fields:
    force: Deprecated: Field is no longer supported.
    name: Required. The resource name of the MetadataStore to delete. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsAddExecutionEventsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresExecutionsAddExecutionEventsRequest
  object.

  Fields:
    execution: Required. The resource name of the Execution that the Events
      connect Artifacts with. Format: `projects/{project}/locations/{location}
      /metadataStores/{metadatastore}/executions/{execution}`
    googleCloudAiplatformV1AddExecutionEventsRequest: A
      GoogleCloudAiplatformV1AddExecutionEventsRequest resource to be passed
      as the request body.
  """

  execution = _messages.StringField(1, required=True)
  googleCloudAiplatformV1AddExecutionEventsRequest = _messages.MessageField('GoogleCloudAiplatformV1AddExecutionEventsRequest', 2)


class AiplatformProjectsLocationsMetadataStoresExecutionsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsCreateRequest
  object.

  Fields:
    executionId: The {execution} portion of the resource name with the format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}/
      executions/{execution}` If not provided, the Execution's ID will be a
      UUID generated by the service. Must be 4-128 characters in length. Valid
      characters are `/a-z-/`. Must be unique across all Executions in the
      parent MetadataStore. (Otherwise the request will fail with
      ALREADY_EXISTS, or PERMISSION_DENIED if the caller can't view the
      preexisting Execution.)
    googleCloudAiplatformV1Execution: A GoogleCloudAiplatformV1Execution
      resource to be passed as the request body.
    parent: Required. The resource name of the MetadataStore where the
      Execution should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  executionId = _messages.StringField(1)
  googleCloudAiplatformV1Execution = _messages.MessageField('GoogleCloudAiplatformV1Execution', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsDeleteRequest
  object.

  Fields:
    etag: Optional. The etag of the Execution to delete. If this is provided,
      it must match the server's etag. Otherwise, the request will fail with a
      FAILED_PRECONDITION.
    name: Required. The resource name of the Execution to delete. Format: `pro
      jects/{project}/locations/{location}/metadataStores/{metadatastore}/exec
      utions/{execution}`
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsGetRequest object.

  Fields:
    name: Required. The resource name of the Execution to retrieve. Format: `p
      rojects/{project}/locations/{location}/metadataStores/{metadatastore}/ex
      ecutions/{execution}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsListRequest object.

  Fields:
    filter: Filter specifying the boolean condition for the Executions to
      satisfy in order to be part of the result set. The syntax to define
      filter query is based on https://google.aip.dev/160. Following are the
      supported set of filters: * **Attribute filtering**: For example:
      `display_name = "test"`. Supported fields include: `name`,
      `display_name`, `state`, `schema_title`, `create_time`, and
      `update_time`. Time fields, such as `create_time` and `update_time`,
      require values specified in RFC-3339 format. For example: `create_time =
      "2020-11-19T11:30:00-04:00"`. * **Metadata field**: To filter on
      metadata fields use traversal operation as follows: `metadata..` For
      example: `metadata.field_1.number_value = 10.0` In case the field name
      contains special characters (such as colon), one can embed it inside
      double quote. For example: `metadata."field:1".number_value = 10.0` *
      **Context based filtering**: To filter Executions based on the contexts
      to which they belong use the function operator with the full resource
      name: `in_context()`. For example:
      `in_context("projects//locations//metadataStores//contexts/")` Each of
      the above supported filters can be combined together using logical
      operators (`AND` & `OR`). Maximum nested expression depth allowed is 5.
      For example: `display_name = "test" AND metadata.field1.bool_value =
      true`.
    orderBy: How the list of messages is ordered. Specify the values to order
      by and an ordering operation. The default sorting order is ascending. To
      specify descending order for a field, users append a " desc" suffix; for
      example: "foo desc, bar". Subfields are specified with a `.` character,
      such as foo.bar. see https://google.aip.dev/132#ordering for more
      details.
    pageSize: The maximum number of Executions to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListExecutions call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with an INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose Executions should be listed.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsPatchRequest
  object.

  Fields:
    allowMissing: If set to true, and the Execution is not found, a new
      Execution is created.
    googleCloudAiplatformV1Execution: A GoogleCloudAiplatformV1Execution
      resource to be passed as the request body.
    name: Output only. The resource name of the Execution.
    updateMask: Optional. A FieldMask indicating which fields should be
      updated.
  """

  allowMissing = _messages.BooleanField(1)
  googleCloudAiplatformV1Execution = _messages.MessageField('GoogleCloudAiplatformV1Execution', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresExecutionsPurgeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsPurgeRequest
  object.

  Fields:
    googleCloudAiplatformV1PurgeExecutionsRequest: A
      GoogleCloudAiplatformV1PurgeExecutionsRequest resource to be passed as
      the request body.
    parent: Required. The metadata store to purge Executions from. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1PurgeExecutionsRequest = _messages.MessageField('GoogleCloudAiplatformV1PurgeExecutionsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsQueryExecutionInputsAndOutputsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsQueryExecutionInput
  sAndOutputsRequest object.

  Fields:
    execution: Required. The resource name of the Execution whose input and
      output Artifacts should be retrieved as a LineageSubgraph. Format: `proj
      ects/{project}/locations/{location}/metadataStores/{metadatastore}/execu
      tions/{execution}`
  """

  execution = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresGetRequest object.

  Fields:
    name: Required. The resource name of the MetadataStore to retrieve.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresListRequest object.

  Fields:
    pageSize: The maximum number of Metadata Stores to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListMetadataStores call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with INVALID_ARGUMENT error.)
    parent: Required. The Location whose MetadataStores should be listed.
      Format: `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresMetadataSchemasCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresMetadataSchemasCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1MetadataSchema: A
      GoogleCloudAiplatformV1MetadataSchema resource to be passed as the
      request body.
    metadataSchemaId: The {metadata_schema} portion of the resource name with
      the format: `projects/{project}/locations/{location}/metadataStores/{met
      adatastore}/metadataSchemas/{metadataschema}` If not provided, the
      MetadataStore's ID will be a UUID generated by the service. Must be
      4-128 characters in length. Valid characters are `/a-z-/`. Must be
      unique across all MetadataSchemas in the parent Location. (Otherwise the
      request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
      caller can't view the preexisting MetadataSchema.)
    parent: Required. The resource name of the MetadataStore where the
      MetadataSchema should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1MetadataSchema = _messages.MessageField('GoogleCloudAiplatformV1MetadataSchema', 1)
  metadataSchemaId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresMetadataSchemasGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresMetadataSchemasGetRequest
  object.

  Fields:
    name: Required. The resource name of the MetadataSchema to retrieve.
      Format: `projects/{project}/locations/{location}/metadataStores/{metadat
      astore}/metadataSchemas/{metadataschema}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresMetadataSchemasListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresMetadataSchemasListRequest
  object.

  Fields:
    filter: A query to filter available MetadataSchemas for matching results.
    pageSize: The maximum number of MetadataSchemas to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListMetadataSchemas call. Provide this to retrieve the
      next page. When paginating, all other provided parameters must match the
      call that provided the page token. (Otherwise the request will fail with
      INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose MetadataSchemas should be
      listed. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest
  object.

  Fields:
    googleCloudAiplatformV1BatchMigrateResourcesRequest: A
      GoogleCloudAiplatformV1BatchMigrateResourcesRequest resource to be
      passed as the request body.
    parent: Required. The location of the migrated resource will live in.
      Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1BatchMigrateResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1BatchMigrateResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMigratableResourcesSearchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesSearchRequest object.

  Fields:
    googleCloudAiplatformV1SearchMigratableResourcesRequest: A
      GoogleCloudAiplatformV1SearchMigratableResourcesRequest resource to be
      passed as the request body.
    parent: Required. The location that the migratable resources should be
      searched from. It's the Vertex AI location that the resources can be
      migrated to, not the resources' original location. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1SearchMigratableResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1SearchMigratableResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1ModelDeploymentMonitoringJob: A
      GoogleCloudAiplatformV1ModelDeploymentMonitoringJob resource to be
      passed as the request body.
    parent: Required. The parent of the ModelDeploymentMonitoringJob. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1ModelDeploymentMonitoringJob = _messages.MessageField('GoogleCloudAiplatformV1ModelDeploymentMonitoringJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the model monitoring job to delete.
      Format: `projects/{project}/locations/{location}/modelDeploymentMonitori
      ngJobs/{model_deployment_monitoring_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsGetRequest
  object.

  Fields:
    name: Required. The resource name of the ModelDeploymentMonitoringJob.
      Format: `projects/{project}/locations/{location}/modelDeploymentMonitori
      ngJobs/{model_deployment_monitoring_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsListRequest
  object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The parent of the ModelDeploymentMonitoringJob. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1ModelDeploymentMonitoringJob: A
      GoogleCloudAiplatformV1ModelDeploymentMonitoringJob resource to be
      passed as the request body.
    name: Output only. Resource name of a ModelDeploymentMonitoringJob.
    updateMask: Required. The update mask is used to specify the fields to be
      overwritten in the ModelDeploymentMonitoringJob resource by the update.
      The fields specified in the update_mask are relative to the resource,
      not the full request. A field will be overwritten if it is in the mask.
      If the user does not provide a mask then only the non-empty fields
      present in the request will be overwritten. Set the update_mask to `*`
      to override all fields. For the objective config, the user can either
      provide the update mask for
      model_deployment_monitoring_objective_configs or any combination of its
      nested fields, such as: model_deployment_monitoring_objective_configs.ob
      jective_config.training_dataset. Updatable fields: * `display_name` *
      `model_deployment_monitoring_schedule_config` *
      `model_monitoring_alert_config` * `logging_sampling_strategy` * `labels`
      * `log_ttl` * `enable_monitoring_pipeline_logs` . and *
      `model_deployment_monitoring_objective_configs` . or * `model_deployment
      _monitoring_objective_configs.objective_config.training_dataset` * `mode
      l_deployment_monitoring_objective_configs.objective_config.training_pred
      iction_skew_detection_config` * `model_deployment_monitoring_objective_c
      onfigs.objective_config.prediction_drift_detection_config`
  """

  googleCloudAiplatformV1ModelDeploymentMonitoringJob = _messages.MessageField('GoogleCloudAiplatformV1ModelDeploymentMonitoringJob', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsPauseRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsPauseRequest
  object.

  Fields:
    googleCloudAiplatformV1PauseModelDeploymentMonitoringJobRequest: A
      GoogleCloudAiplatformV1PauseModelDeploymentMonitoringJobRequest resource
      to be passed as the request body.
    name: Required. The resource name of the ModelDeploymentMonitoringJob to
      pause. Format: `projects/{project}/locations/{location}/modelDeploymentM
      onitoringJobs/{model_deployment_monitoring_job}`
  """

  googleCloudAiplatformV1PauseModelDeploymentMonitoringJobRequest = _messages.MessageField('GoogleCloudAiplatformV1PauseModelDeploymentMonitoringJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsResumeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsResumeRequest
  object.

  Fields:
    googleCloudAiplatformV1ResumeModelDeploymentMonitoringJobRequest: A
      GoogleCloudAiplatformV1ResumeModelDeploymentMonitoringJobRequest
      resource to be passed as the request body.
    name: Required. The resource name of the ModelDeploymentMonitoringJob to
      resume. Format: `projects/{project}/locations/{location}/modelDeployment
      MonitoringJobs/{model_deployment_monitoring_job}`
  """

  googleCloudAiplatformV1ResumeModelDeploymentMonitoringJobRequest = _messages.MessageField('GoogleCloudAiplatformV1ResumeModelDeploymentMonitoringJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsSearchModelDeploymentMonitoringStatsAnomaliesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsSearchModelDep
  loymentMonitoringStatsAnomaliesRequest object.

  Fields:
    googleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesReques
      t: A GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomalie
      sRequest resource to be passed as the request body.
    modelDeploymentMonitoringJob: Required. ModelDeploymentMonitoring Job
      resource name. Format: `projects/{project}/locations/{location}/modelDep
      loymentMonitoringJobs/{model_deployment_monitoring_job}`
  """

  googleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequest = _messages.MessageField('GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequest', 1)
  modelDeploymentMonitoringJob = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsCopyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsCopyRequest object.

  Fields:
    googleCloudAiplatformV1CopyModelRequest: A
      GoogleCloudAiplatformV1CopyModelRequest resource to be passed as the
      request body.
    parent: Required. The resource name of the Location into which to copy the
      Model. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1CopyModelRequest = _messages.MessageField('GoogleCloudAiplatformV1CopyModelRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsDeleteRequest object.

  Fields:
    name: Required. The name of the Model resource to be deleted. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsDeleteVersionRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsDeleteVersionRequest object.

  Fields:
    name: Required. The name of the model version to be deleted, with a
      version ID explicitly included. Example:
      `projects/{project}/locations/{location}/models/{model}@1234`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluation resource. Format: `project
      s/{project}/locations/{location}/models/{model}/evaluations/{evaluation}
      `
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsImportRequest object.

  Fields:
    googleCloudAiplatformV1ImportModelEvaluationRequest: A
      GoogleCloudAiplatformV1ImportModelEvaluationRequest resource to be
      passed as the request body.
    parent: Required. The name of the parent model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  googleCloudAiplatformV1ImportModelEvaluationRequest = _messages.MessageField('GoogleCloudAiplatformV1ImportModelEvaluationRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsEvaluationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationsResponse.next_page_token of the previous
      ModelService.ListModelEvaluations call.
    parent: Required. The resource name of the Model to list the
      ModelEvaluations from. Format:
      `projects/{project}/locations/{location}/models/{model}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsEvaluationsSlicesBatchImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesBatchImportRequest
  object.

  Fields:
    googleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest: A
      GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest resource
      to be passed as the request body.
    parent: Required. The name of the parent ModelEvaluationSlice resource.
      Format: `projects/{project}/locations/{location}/models/{model}/evaluati
      ons/{evaluation}/slices/{slice}`
  """

  googleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest = _messages.MessageField('GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluationSlice resource. Format: `pr
      ojects/{project}/locations/{location}/models/{model}/evaluations/{evalua
      tion}/slices/{slice}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest object.

  Fields:
    filter: The standard list filter. * `slice.dimension` - for =.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationSlicesResponse.next_page_token of the previous
      ModelService.ListModelEvaluationSlices call.
    parent: Required. The resource name of the ModelEvaluation to list the
      ModelEvaluationSlices from. Format: `projects/{project}/locations/{locat
      ion}/models/{model}/evaluations/{evaluation}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsExportRequest object.

  Fields:
    googleCloudAiplatformV1ExportModelRequest: A
      GoogleCloudAiplatformV1ExportModelRequest resource to be passed as the
      request body.
    name: Required. The resource name of the Model to export. The resource
      name may contain version id or version alias to specify the version, if
      no version is specified, the default version will be exported.
  """

  googleCloudAiplatformV1ExportModelRequest = _messages.MessageField('GoogleCloudAiplatformV1ExportModelRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsGetRequest object.

  Fields:
    name: Required. The name of the Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}` In order to
      retrieve a specific version of the model, also provide the version ID or
      version alias. Example:
      `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` If no
      version ID or alias is specified, the "default" version will be
      returned. The "default" version alias is created for the first version
      of the model, and can be moved to other versions later on. There will be
      exactly one default version.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `model` supports =
      and !=. `model` represents the Model ID, i.e. the last segment of the
      Model's resource name. * `display_name` supports = and != * `labels`
      supports general map functions that is: * `labels.key=value` - key:value
      equality * `labels.key:* or labels:key - key existence * A key including
      a space must be quoted. `labels."a key"`. Some examples: * `model=1234`
      * `displayName="myDisplayName"` * `labels.myKey="myValue"`
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `display_name` * `create_time` * `update_time` Example: `display_name,
      create_time desc`.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelsResponse.next_page_token of the previous
      ModelService.ListModels call.
    parent: Required. The resource name of the Location to list the Models
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsModelsListVersionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsListVersionsRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `labels` supports
      general map functions that is: * `labels.key=value` - key:value equality
      * `labels.key:* or labels:key - key existence * A key including a space
      must be quoted. `labels."a key"`. Some examples: *
      `labels.myKey="myValue"`
    name: Required. The name of the model to list versions for.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `create_time` * `update_time` Example: `update_time asc, create_time
      desc`.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      next_page_token of the previous ListModelVersions call.
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsModelsMergeVersionAliasesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsMergeVersionAliasesRequest object.

  Fields:
    googleCloudAiplatformV1MergeVersionAliasesRequest: A
      GoogleCloudAiplatformV1MergeVersionAliasesRequest resource to be passed
      as the request body.
    name: Required. The name of the model version to merge aliases, with a
      version ID explicitly included. Example:
      `projects/{project}/locations/{location}/models/{model}@1234`
  """

  googleCloudAiplatformV1MergeVersionAliasesRequest = _messages.MessageField('GoogleCloudAiplatformV1MergeVersionAliasesRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsPatchRequest object.

  Fields:
    googleCloudAiplatformV1Model: A GoogleCloudAiplatformV1Model resource to
      be passed as the request body.
    name: The resource name of the Model.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1Model = _messages.MessageField('GoogleCloudAiplatformV1Model', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsModelsUpdateExplanationDatasetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsUpdateExplanationDatasetRequest
  object.

  Fields:
    googleCloudAiplatformV1UpdateExplanationDatasetRequest: A
      GoogleCloudAiplatformV1UpdateExplanationDatasetRequest resource to be
      passed as the request body.
    model: Required. The resource name of the Model to update. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  googleCloudAiplatformV1UpdateExplanationDatasetRequest = _messages.MessageField('GoogleCloudAiplatformV1UpdateExplanationDatasetRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsUploadRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsUploadRequest object.

  Fields:
    googleCloudAiplatformV1UploadModelRequest: A
      GoogleCloudAiplatformV1UploadModelRequest resource to be passed as the
      request body.
    parent: Required. The resource name of the Location into which to upload
      the Model. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1UploadModelRequest = _messages.MessageField('GoogleCloudAiplatformV1UploadModelRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNasJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1CancelNasJobRequest: A
      GoogleCloudAiplatformV1CancelNasJobRequest resource to be passed as the
      request body.
    name: Required. The name of the NasJob to cancel. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  googleCloudAiplatformV1CancelNasJobRequest = _messages.MessageField('GoogleCloudAiplatformV1CancelNasJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNasJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1NasJob: A GoogleCloudAiplatformV1NasJob resource to
      be passed as the request body.
    parent: Required. The resource name of the Location to create the NasJob
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1NasJob = _messages.MessageField('GoogleCloudAiplatformV1NasJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNasJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsDeleteRequest object.

  Fields:
    name: Required. The name of the NasJob resource to be deleted. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNasJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsGetRequest object.

  Fields:
    name: Required. The name of the NasJob resource. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNasJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListNasJobsResponse.next_page_token of the previous
      JobService.ListNasJobs call.
    parent: Required. The resource name of the Location to list the NasJobs
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsNasJobsNasTrialDetailsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsNasTrialDetailsGetRequest object.

  Fields:
    name: Required. The name of the NasTrialDetail resource. Format: `projects
      /{project}/locations/{location}/nasJobs/{nas_job}/nasTrialDetails/{nas_t
      rial_detail}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNasJobsNasTrialDetailsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsNasTrialDetailsListRequest object.

  Fields:
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListNasTrialDetailsResponse.next_page_token of the previous
      JobService.ListNasTrialDetails call.
    parent: Required. The name of the NasJob resource. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsPipelineJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1CancelPipelineJobRequest: A
      GoogleCloudAiplatformV1CancelPipelineJobRequest resource to be passed as
      the request body.
    name: Required. The name of the PipelineJob to cancel. Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  """

  googleCloudAiplatformV1CancelPipelineJobRequest = _messages.MessageField('GoogleCloudAiplatformV1CancelPipelineJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPipelineJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1PipelineJob: A GoogleCloudAiplatformV1PipelineJob
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the
      PipelineJob in. Format: `projects/{project}/locations/{location}`
    pipelineJobId: The ID to use for the PipelineJob, which will become the
      final component of the PipelineJob name. If not provided, an ID will be
      automatically generated. This value should be less than 128 characters,
      and valid characters are `/a-z-/`.
  """

  googleCloudAiplatformV1PipelineJob = _messages.MessageField('GoogleCloudAiplatformV1PipelineJob', 1)
  parent = _messages.StringField(2, required=True)
  pipelineJobId = _messages.StringField(3)


class AiplatformProjectsLocationsPipelineJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsDeleteRequest object.

  Fields:
    name: Required. The name of the PipelineJob resource to be deleted.
      Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsGetRequest object.

  Fields:
    name: Required. The name of the PipelineJob resource. Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsListRequest object.

  Fields:
    filter: Lists the PipelineJobs that match the filter expression. The
      following fields are supported: * `pipeline_name`: Supports `=` and `!=`
      comparisons. * `display_name`: Supports `=`, `!=` comparisons, and `:`
      wildcard. * `pipeline_job_user_id`: Supports `=`, `!=` comparisons, and
      `:` wildcard. for example, can check if pipeline's display_name contains
      *step* by doing display_name:\"*step*\" * `state`: Supports `=` and `!=`
      comparisons. * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and
      `>=` comparisons. Values must be in RFC 3339 format. * `update_time`:
      Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons. Values must be
      in RFC 3339 format. * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`,
      and `>=` comparisons. Values must be in RFC 3339 format. * `labels`:
      Supports key-value equality and key presence. * `template_uri`: Supports
      `=`, `!=` comparisons, and `:` wildcard. * `template_metadata.version`:
      Supports `=`, `!=` comparisons, and `:` wildcard. Filter expressions can
      be combined together using logical operators (`AND` & `OR`). For
      example: `pipeline_name="test" AND create_time>"2020-05-18T13:30:00Z"`.
      The syntax to define filter expression is based on
      https://google.aip.dev/160. Examples: *
      `create_time>"2021-05-18T00:00:00Z" OR
      update_time>"2020-05-18T00:00:00Z"` PipelineJobs created or updated
      after 2020-05-18 00:00:00 UTC. * `labels.env = "prod"` PipelineJobs with
      label "env" set to "prod".
    orderBy: A comma-separated list of fields to order by. The default sort
      order is in ascending order. Use "desc" after a field name for
      descending. You can have multiple order_by fields provided e.g.
      "create_time desc, end_time", "end_time, start_time, update_time" For
      example, using "create_time desc, end_time" will order results by create
      time in descending order, and if there are multiple jobs having the same
      create time, order them by the end time in ascending order. if order_by
      is not specified, it will order by default order is create time in
      descending order. Supported fields: * `create_time` * `update_time` *
      `end_time` * `start_time`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListPipelineJobsResponse.next_page_token of the previous
      PipelineService.ListPipelineJobs call.
    parent: Required. The resource name of the Location to list the
      PipelineJobs from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsPublishersModelsPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1PredictRequest: A
      GoogleCloudAiplatformV1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1PredictRequest', 2)


class AiplatformProjectsLocationsPublishersModelsRawPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsRawPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1RawPredictRequest: A
      GoogleCloudAiplatformV1RawPredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1RawPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1RawPredictRequest', 2)


class AiplatformProjectsLocationsSchedulesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesCreateRequest object.

  Fields:
    googleCloudAiplatformV1Schedule: A GoogleCloudAiplatformV1Schedule
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the Schedule
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1Schedule = _messages.MessageField('GoogleCloudAiplatformV1Schedule', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSchedulesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesDeleteRequest object.

  Fields:
    name: Required. The name of the Schedule resource to be deleted. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSchedulesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesGetRequest object.

  Fields:
    name: Required. The name of the Schedule resource. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSchedulesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesListRequest object.

  Fields:
    filter: Lists the Schedules that match the filter expression. The
      following fields are supported: * `display_name`: Supports `=`, `!=`
      comparisons, and `:` wildcard. * `state`: Supports `=` and `!=`
      comparisons. * `request`: Supports existence of the check. (e.g.
      `create_pipeline_job_request:*` --> Schedule has
      create_pipeline_job_request). * `create_time`: Supports `=`, `!=`, `<`,
      `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format. *
      `start_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
      Values must be in RFC 3339 format. * `end_time`: Supports `=`, `!=`,
      `<`, `>`, `<=`, `>=` comparisons and `:*` existence check. Values must
      be in RFC 3339 format. * `next_run_time`: Supports `=`, `!=`, `<`, `>`,
      `<=`, and `>=` comparisons. Values must be in RFC 3339 format. Filter
      expressions can be combined together using logical operators (`NOT`,
      `AND` & `OR`). The syntax to define filter expression is based on
      https://google.aip.dev/160. Examples: * `state="ACTIVE" AND
      display_name:"my_schedule_*"` * `NOT display_name="my_schedule"` *
      `create_time>"2021-05-18T00:00:00Z"` * `end_time>"2021-05-18T00:00:00Z"
      OR NOT end_time:*` * `create_pipeline_job_request:*`
    orderBy: A comma-separated list of fields to order by. The default sort
      order is in ascending order. Use "desc" after a field name for
      descending. You can have multiple order_by fields provided. For example,
      using "create_time desc, end_time" will order results by create time in
      descending order, and if there are multiple schedules having the same
      create time, order them by the end time in ascending order. If order_by
      is not specified, it will order by default with create_time in
      descending order. Supported fields: * `create_time` * `start_time` *
      `end_time` * `next_run_time`
    pageSize: The standard list page size. Default to 100 if not specified.
    pageToken: The standard list page token. Typically obtained via
      ListSchedulesResponse.next_page_token of the previous
      ScheduleService.ListSchedules call.
    parent: Required. The resource name of the Location to list the Schedules
      from. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsSchedulesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesPatchRequest object.

  Fields:
    googleCloudAiplatformV1Schedule: A GoogleCloudAiplatformV1Schedule
      resource to be passed as the request body.
    name: Immutable. The resource name of the Schedule.
    updateMask: Required. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1Schedule = _messages.MessageField('GoogleCloudAiplatformV1Schedule', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsSchedulesPauseRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesPauseRequest object.

  Fields:
    googleCloudAiplatformV1PauseScheduleRequest: A
      GoogleCloudAiplatformV1PauseScheduleRequest resource to be passed as the
      request body.
    name: Required. The name of the Schedule resource to be paused. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  googleCloudAiplatformV1PauseScheduleRequest = _messages.MessageField('GoogleCloudAiplatformV1PauseScheduleRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSchedulesResumeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesResumeRequest object.

  Fields:
    googleCloudAiplatformV1ResumeScheduleRequest: A
      GoogleCloudAiplatformV1ResumeScheduleRequest resource to be passed as
      the request body.
    name: Required. The name of the Schedule resource to be resumed. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  googleCloudAiplatformV1ResumeScheduleRequest = _messages.MessageField('GoogleCloudAiplatformV1ResumeScheduleRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsCreateRequest object.

  Fields:
    googleCloudAiplatformV1SpecialistPool: A
      GoogleCloudAiplatformV1SpecialistPool resource to be passed as the
      request body.
    parent: Required. The parent Project name for the new SpecialistPool. The
      form is `projects/{project}/locations/{location}`.
  """

  googleCloudAiplatformV1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1SpecialistPool', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsDeleteRequest object.

  Fields:
    force: If set to true, any specialist managers in this SpecialistPool will
      also be deleted. (Otherwise, the request will only work if the
      SpecialistPool has no specialist managers.)
    name: Required. The resource name of the SpecialistPool to delete. Format:
      `projects/{project}/locations/{location}/specialistPools/{specialist_poo
      l}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsGetRequest object.

  Fields:
    name: Required. The name of the SpecialistPool resource. The form is `proj
      ects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsListRequest object.

  Fields:
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained by
      ListSpecialistPoolsResponse.next_page_token of the previous
      SpecialistPoolService.ListSpecialistPools call. Return first page if
      empty.
    parent: Required. The name of the SpecialistPool's parent resource.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read. FieldMask represents a set
      of
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  readMask = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsPatchRequest object.

  Fields:
    googleCloudAiplatformV1SpecialistPool: A
      GoogleCloudAiplatformV1SpecialistPool resource to be passed as the
      request body.
    name: Required. The resource name of the SpecialistPool.
    updateMask: Required. The update mask applies to the resource.
  """

  googleCloudAiplatformV1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1SpecialistPool', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsStudiesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesCreateRequest object.

  Fields:
    googleCloudAiplatformV1Study: A GoogleCloudAiplatformV1Study resource to
      be passed as the request body.
    parent: Required. The resource name of the Location to create the
      CustomJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1Study = _messages.MessageField('GoogleCloudAiplatformV1Study', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesDeleteRequest object.

  Fields:
    name: Required. The name of the Study resource to be deleted. Format:
      `projects/{project}/locations/{location}/studies/{study}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesGetRequest object.

  Fields:
    name: Required. The name of the Study resource. Format:
      `projects/{project}/locations/{location}/studies/{study}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of studies to return per "page" of
      results. If unspecified, service will pick an appropriate default.
    pageToken: Optional. A page token to request the next page of results. If
      unspecified, there are no subsequent pages.
    parent: Required. The resource name of the Location to list the Study
      from. Format: `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsStudiesLookupRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesLookupRequest object.

  Fields:
    googleCloudAiplatformV1LookupStudyRequest: A
      GoogleCloudAiplatformV1LookupStudyRequest resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to get the Study from.
      Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1LookupStudyRequest = _messages.MessageField('GoogleCloudAiplatformV1LookupStudyRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsAddTrialMeasurementRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsAddTrialMeasurementRequest
  object.

  Fields:
    googleCloudAiplatformV1AddTrialMeasurementRequest: A
      GoogleCloudAiplatformV1AddTrialMeasurementRequest resource to be passed
      as the request body.
    trialName: Required. The name of the trial to add measurement. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1AddTrialMeasurementRequest = _messages.MessageField('GoogleCloudAiplatformV1AddTrialMeasurementRequest', 1)
  trialName = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsCheckTrialEarlyStoppingStateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsStudiesTrialsCheckTrialEarlyStoppingStateRequest
  object.

  Fields:
    googleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest: A
      GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest resource to
      be passed as the request body.
    trialName: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest = _messages.MessageField('GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest', 1)
  trialName = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsCompleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsCompleteRequest object.

  Fields:
    googleCloudAiplatformV1CompleteTrialRequest: A
      GoogleCloudAiplatformV1CompleteTrialRequest resource to be passed as the
      request body.
    name: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1CompleteTrialRequest = _messages.MessageField('GoogleCloudAiplatformV1CompleteTrialRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsCreateRequest object.

  Fields:
    googleCloudAiplatformV1Trial: A GoogleCloudAiplatformV1Trial resource to
      be passed as the request body.
    parent: Required. The resource name of the Study to create the Trial in.
      Format: `projects/{project}/locations/{location}/studies/{study}`
  """

  googleCloudAiplatformV1Trial = _messages.MessageField('GoogleCloudAiplatformV1Trial', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsDeleteRequest object.

  Fields:
    name: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsGetRequest object.

  Fields:
    name: Required. The name of the Trial resource. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsListOptimalTrialsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsListOptimalTrialsRequest
  object.

  Fields:
    googleCloudAiplatformV1ListOptimalTrialsRequest: A
      GoogleCloudAiplatformV1ListOptimalTrialsRequest resource to be passed as
      the request body.
    parent: Required. The name of the Study that the optimal Trial belongs to.
  """

  googleCloudAiplatformV1ListOptimalTrialsRequest = _messages.MessageField('GoogleCloudAiplatformV1ListOptimalTrialsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsListRequest object.

  Fields:
    pageSize: Optional. The number of Trials to retrieve per "page" of
      results. If unspecified, the service will pick an appropriate default.
    pageToken: Optional. A page token to request the next page of results. If
      unspecified, there are no subsequent pages.
    parent: Required. The resource name of the Study to list the Trial from.
      Format: `projects/{project}/locations/{location}/studies/{study}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsStudiesTrialsStopRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsStopRequest object.

  Fields:
    googleCloudAiplatformV1StopTrialRequest: A
      GoogleCloudAiplatformV1StopTrialRequest resource to be passed as the
      request body.
    name: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1StopTrialRequest = _messages.MessageField('GoogleCloudAiplatformV1StopTrialRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsSuggestRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsSuggestRequest object.

  Fields:
    googleCloudAiplatformV1SuggestTrialsRequest: A
      GoogleCloudAiplatformV1SuggestTrialsRequest resource to be passed as the
      request body.
    parent: Required. The project and location that the Study belongs to.
      Format: `projects/{project}/locations/{location}/studies/{study}`
  """

  googleCloudAiplatformV1SuggestTrialsRequest = _messages.MessageField('GoogleCloudAiplatformV1SuggestTrialsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsCreateRequest object.

  Fields:
    googleCloudAiplatformV1Tensorboard: A GoogleCloudAiplatformV1Tensorboard
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the
      Tensorboard in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1Tensorboard = _messages.MessageField('GoogleCloudAiplatformV1Tensorboard', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsDeleteRequest object.

  Fields:
    name: Required. The name of the Tensorboard to be deleted. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1TensorboardExperiment: A
      GoogleCloudAiplatformV1TensorboardExperiment resource to be passed as
      the request body.
    parent: Required. The resource name of the Tensorboard to create the
      TensorboardExperiment in. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    tensorboardExperimentId: Required. The ID to use for the Tensorboard
      experiment, which becomes the final component of the Tensorboard
      experiment's resource name. This value should be 1-128 characters, and
      valid characters are `/a-z-/`.
  """

  googleCloudAiplatformV1TensorboardExperiment = _messages.MessageField('GoogleCloudAiplatformV1TensorboardExperiment', 1)
  parent = _messages.StringField(2, required=True)
  tensorboardExperimentId = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsDeleteRequest
  object.

  Fields:
    name: Required. The name of the TensorboardExperiment to be deleted.
      Format: `projects/{project}/locations/{location}/tensorboards/{tensorboa
      rd}/experiments/{experiment}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsGetRequest object.

  Fields:
    name: Required. The name of the TensorboardExperiment resource. Format: `p
      rojects/{project}/locations/{location}/tensorboards/{tensorboard}/experi
      ments/{experiment}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsListRequest object.

  Fields:
    filter: Lists the TensorboardExperiments that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of TensorboardExperiments to return. The
      service may return fewer than this value. If unspecified, at most 50
      TensorboardExperiments are returned. The maximum value is 1000; values
      above 1000 are coerced to 1000.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboardExperiments call. Provide this to
      retrieve the subsequent page. When paginating, all other parameters
      provided to TensorboardService.ListTensorboardExperiments must match the
      call that provided the page token.
    parent: Required. The resource name of the Tensorboard to list
      TensorboardExperiments. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsExperimentsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsPatchRequest object.

  Fields:
    googleCloudAiplatformV1TensorboardExperiment: A
      GoogleCloudAiplatformV1TensorboardExperiment resource to be passed as
      the request body.
    name: Output only. Name of the TensorboardExperiment. Format: `projects/{p
      roject}/locations/{location}/tensorboards/{tensorboard}/experiments/{exp
      eriment}`
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the TensorboardExperiment resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field is overwritten if it's in the mask. If the
      user does not provide a mask then all fields are overwritten if new
      values are specified.
  """

  googleCloudAiplatformV1TensorboardExperiment = _messages.MessageField('GoogleCloudAiplatformV1TensorboardExperiment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsBatchCreateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsBatchCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1BatchCreateTensorboardRunsRequest: A
      GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardRuns in. Format: `projects/{project}/locations/{location}
      /tensorboards/{tensorboard}/experiments/{experiment}` The parent field
      in the CreateTensorboardRunRequest messages must match this field.
  """

  googleCloudAiplatformV1BatchCreateTensorboardRunsRequest = _messages.MessageField('GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1TensorboardRun: A
      GoogleCloudAiplatformV1TensorboardRun resource to be passed as the
      request body.
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardRun in. Format: `projects/{project}/locations/{location}/
      tensorboards/{tensorboard}/experiments/{experiment}`
    tensorboardRunId: Required. The ID to use for the Tensorboard run, which
      becomes the final component of the Tensorboard run's resource name. This
      value should be 1-128 characters, and valid characters are `/a-z-/`.
  """

  googleCloudAiplatformV1TensorboardRun = _messages.MessageField('GoogleCloudAiplatformV1TensorboardRun', 1)
  parent = _messages.StringField(2, required=True)
  tensorboardRunId = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsDeleteRequest
  object.

  Fields:
    name: Required. The name of the TensorboardRun to be deleted. Format: `pro
      jects/{project}/locations/{location}/tensorboards/{tensorboard}/experime
      nts/{experiment}/runs/{run}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsGetRequest
  object.

  Fields:
    name: Required. The name of the TensorboardRun resource. Format: `projects
      /{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{
      experiment}/runs/{run}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsListRequest
  object.

  Fields:
    filter: Lists the TensorboardRuns that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of TensorboardRuns to return. The service may
      return fewer than this value. If unspecified, at most 50 TensorboardRuns
      are returned. The maximum value is 1000; values above 1000 are coerced
      to 1000.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboardRuns call. Provide this to retrieve
      the subsequent page. When paginating, all other parameters provided to
      TensorboardService.ListTensorboardRuns must match the call that provided
      the page token.
    parent: Required. The resource name of the TensorboardExperiment to list
      TensorboardRuns. Format: `projects/{project}/locations/{location}/tensor
      boards/{tensorboard}/experiments/{experiment}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1TensorboardRun: A
      GoogleCloudAiplatformV1TensorboardRun resource to be passed as the
      request body.
    name: Output only. Name of the TensorboardRun. Format: `projects/{project}
      /locations/{location}/tensorboards/{tensorboard}/experiments/{experiment
      }/runs/{run}`
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the TensorboardRun resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field is overwritten if it's in the mask. If the user does
      not provide a mask then all fields are overwritten if new values are
      specified.
  """

  googleCloudAiplatformV1TensorboardRun = _messages.MessageField('GoogleCloudAiplatformV1TensorboardRun', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesBatchCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesBatchC
  reateRequest object.

  Fields:
    googleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest: A
      GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest resource
      to be passed as the request body.
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardTimeSeries in. Format: `projects/{project}/locations/{loc
      ation}/tensorboards/{tensorboard}/experiments/{experiment}` The
      TensorboardRuns referenced by the parent fields in the
      CreateTensorboardTimeSeriesRequest messages must be sub resources of
      this TensorboardExperiment.
    runsId: A string attribute.
  """

  googleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest = _messages.MessageField('GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest', 1)
  parent = _messages.StringField(2, required=True)
  runsId = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesBatchReadRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesBatchR
  eadRequest object.

  Fields:
    experimentsId: A string attribute.
    runsId: A string attribute.
    tensorboard: Required. The resource name of the Tensorboard containing
      TensorboardTimeSeries to read data from. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`.
      The TensorboardTimeSeries referenced by time_series must be sub
      resources of this Tensorboard.
    timeSeries: Required. The resource names of the TensorboardTimeSeries to
      read data from. Format: `projects/{project}/locations/{location}/tensorb
      oards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time
      _series}`
  """

  experimentsId = _messages.StringField(1, required=True)
  runsId = _messages.StringField(2, required=True)
  tensorboard = _messages.StringField(3, required=True)
  timeSeries = _messages.StringField(4, repeated=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesCreate
  Request object.

  Fields:
    googleCloudAiplatformV1TensorboardTimeSeries: A
      GoogleCloudAiplatformV1TensorboardTimeSeries resource to be passed as
      the request body.
    parent: Required. The resource name of the TensorboardRun to create the
      TensorboardTimeSeries in. Format: `projects/{project}/locations/{locatio
      n}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
    tensorboardTimeSeriesId: Optional. The user specified unique ID to use for
      the TensorboardTimeSeries, which becomes the final component of the
      TensorboardTimeSeries's resource name. This value should match
      "a-z0-9{0, 127}"
  """

  googleCloudAiplatformV1TensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1TensorboardTimeSeries', 1)
  parent = _messages.StringField(2, required=True)
  tensorboardTimeSeriesId = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesDelete
  Request object.

  Fields:
    name: Required. The name of the TensorboardTimeSeries to be deleted.
      Format: `projects/{project}/locations/{location}/tensorboards/{tensorboa
      rd}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesExportTensorboardTimeSeriesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesExport
  TensorboardTimeSeriesRequest object.

  Fields:
    googleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest: A
      GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest resource
      to be passed as the request body.
    tensorboardTimeSeries: Required. The resource name of the
      TensorboardTimeSeries to export data from. Format: `projects/{project}/l
      ocations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/
      runs/{run}/timeSeries/{time_series}`
  """

  googleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest = _messages.MessageField('GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest', 1)
  tensorboardTimeSeries = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesGetRequest
  object.

  Fields:
    name: Required. The name of the TensorboardTimeSeries resource. Format: `p
      rojects/{project}/locations/{location}/tensorboards/{tensorboard}/experi
      ments/{experiment}/runs/{run}/timeSeries/{time_series}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesListRequest
  object.

  Fields:
    filter: Lists the TensorboardTimeSeries that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of TensorboardTimeSeries to return. The
      service may return fewer than this value. If unspecified, at most 50
      TensorboardTimeSeries are returned. The maximum value is 1000; values
      above 1000 are coerced to 1000.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboardTimeSeries call. Provide this to
      retrieve the subsequent page. When paginating, all other parameters
      provided to TensorboardService.ListTensorboardTimeSeries must match the
      call that provided the page token.
    parent: Required. The resource name of the TensorboardRun to list
      TensorboardTimeSeries. Format: `projects/{project}/locations/{location}/
      tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesPatchRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1TensorboardTimeSeries: A
      GoogleCloudAiplatformV1TensorboardTimeSeries resource to be passed as
      the request body.
    name: Output only. Name of the TensorboardTimeSeries.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the TensorboardTimeSeries resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field is overwritten if it's in the mask. If the
      user does not provide a mask then all fields are overwritten if new
      values are specified.
  """

  googleCloudAiplatformV1TensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1TensorboardTimeSeries', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadBlobDataRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadBl
  obDataRequest object.

  Fields:
    blobIds: IDs of the blobs to read.
    timeSeries: Required. The resource name of the TensorboardTimeSeries to
      list Blobs. Format: `projects/{project}/locations/{location}/tensorboard
      s/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_ser
      ies}`
  """

  blobIds = _messages.StringField(1, repeated=True)
  timeSeries = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadRequest
  object.

  Fields:
    filter: Reads the TensorboardTimeSeries' data that match the filter
      expression.
    maxDataPoints: The maximum number of TensorboardTimeSeries' data to
      return. This value should be a positive integer. This value can be set
      to -1 to return all data.
    tensorboardTimeSeries: Required. The resource name of the
      TensorboardTimeSeries to read data from. Format: `projects/{project}/loc
      ations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/ru
      ns/{run}/timeSeries/{time_series}`
  """

  filter = _messages.StringField(1)
  maxDataPoints = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  tensorboardTimeSeries = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsWriteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsWriteRequest object.

  Fields:
    googleCloudAiplatformV1WriteTensorboardExperimentDataRequest: A
      GoogleCloudAiplatformV1WriteTensorboardExperimentDataRequest resource to
      be passed as the request body.
    tensorboardExperiment: Required. The resource name of the
      TensorboardExperiment to write data to. Format: `projects/{project}/loca
      tions/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  """

  googleCloudAiplatformV1WriteTensorboardExperimentDataRequest = _messages.MessageField('GoogleCloudAiplatformV1WriteTensorboardExperimentDataRequest', 1)
  tensorboardExperiment = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsGetRequest object.

  Fields:
    name: Required. The name of the Tensorboard resource. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsListRequest object.

  Fields:
    filter: Lists the Tensorboards that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of Tensorboards to return. The service may
      return fewer than this value. If unspecified, at most 100 Tensorboards
      are returned. The maximum value is 100; values above 100 are coerced to
      100.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboards call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      TensorboardService.ListTensorboards must match the call that provided
      the page token.
    parent: Required. The resource name of the Location to list Tensorboards.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsPatchRequest object.

  Fields:
    googleCloudAiplatformV1Tensorboard: A GoogleCloudAiplatformV1Tensorboard
      resource to be passed as the request body.
    name: Output only. Name of the Tensorboard. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Tensorboard resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field is overwritten if it's in the mask. If the user does
      not provide a mask then all fields are overwritten if new values are
      specified.
  """

  googleCloudAiplatformV1Tensorboard = _messages.MessageField('GoogleCloudAiplatformV1Tensorboard', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsReadSizeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsReadSizeRequest object.

  Fields:
    tensorboard: Required. The name of the Tensorboard resource. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  tensorboard = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsReadUsageRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsReadUsageRequest object.

  Fields:
    tensorboard: Required. The name of the Tensorboard resource. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  tensorboard = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCancelRequest object.

  Fields:
    googleCloudAiplatformV1CancelTrainingPipelineRequest: A
      GoogleCloudAiplatformV1CancelTrainingPipelineRequest resource to be
      passed as the request body.
    name: Required. The name of the TrainingPipeline to cancel. Format: `proje
      cts/{project}/locations/{location}/trainingPipelines/{training_pipeline}
      `
  """

  googleCloudAiplatformV1CancelTrainingPipelineRequest = _messages.MessageField('GoogleCloudAiplatformV1CancelTrainingPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCreateRequest object.

  Fields:
    googleCloudAiplatformV1TrainingPipeline: A
      GoogleCloudAiplatformV1TrainingPipeline resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      TrainingPipeline in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1TrainingPipeline = _messages.MessageField('GoogleCloudAiplatformV1TrainingPipeline', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesDeleteRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource to be deleted.
      Format: `projects/{project}/locations/{location}/trainingPipelines/{trai
      ning_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesGetRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource. Format: `projec
      ts/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `training_task_definition` `=`, `!=`
      comparisons, and `:` wildcard. * `create_time` supports `=`, `!=`,`<`,
      `<=`,`>`, `>=` comparisons. `create_time` must be in RFC 3339 format. *
      `labels` supports general map functions that is: `labels.key=value` -
      key:value equality `labels.key:* - key existence Some examples of using
      the filter are: * `state="PIPELINE_STATE_SUCCEEDED" AND
      display_name:"my_pipeline_*"` * `state!="PIPELINE_STATE_FAILED" OR
      display_name="my_pipeline"` * `NOT display_name="my_pipeline"` *
      `create_time>"2021-05-18T00:00:00Z"` *
      `training_task_definition:"*automl_text_classification*"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListTrainingPipelinesResponse.next_page_token of the previous
      PipelineService.ListTrainingPipelines call.
    parent: Required. The resource name of the Location to list the
      TrainingPipelines from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class GoogleApiHttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page. This message can be used both in streaming and non-streaming
  API methods in the request as well as the response. It can be used as a top-
  level request field, which is convenient if one wants to extract parameters
  from either the URL or HTTP template into the request fields and also want
  access to the raw HTTP body. Example: message GetResourceRequest { // A
  unique request id. string request_id = 1; // The raw HTTP body is bound to
  this field. google.api.HttpBody http_body = 2; } service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); }
  Example with streaming methods: service CaldavService { rpc
  GetCalendar(stream google.api.HttpBody) returns (stream
  google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
  (stream google.api.HttpBody); } Use of this type only changes how the
  request and response bodies are handled, all other features will continue to
  work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class GoogleCloudAiplatformV1ActiveLearningConfig(_messages.Message):
  r"""Parameters that configure the active learning pipeline. Active learning
  will label the data incrementally by several iterations. For every
  iteration, it will select a batch of data based on the sampling strategy.

  Fields:
    maxDataItemCount: Max number of human labeled DataItems.
    maxDataItemPercentage: Max percent of total DataItems for human labeling.
    sampleConfig: Active learning data sampling config. For every active
      learning labeling iteration, it will select a batch of data based on the
      sampling strategy.
    trainingConfig: CMLE training config. For every active learning labeling
      iteration, system will train a machine learning model on CMLE. The
      trained model will be used by data sampling algorithm to select
      DataItems.
  """

  maxDataItemCount = _messages.IntegerField(1)
  maxDataItemPercentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sampleConfig = _messages.MessageField('GoogleCloudAiplatformV1SampleConfig', 3)
  trainingConfig = _messages.MessageField('GoogleCloudAiplatformV1TrainingConfig', 4)


class GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest(_messages.Message):
  r"""Request message for MetadataService.AddContextArtifactsAndExecutions.

  Fields:
    artifacts: The resource names of the Artifacts to attribute to the
      Context. Format: `projects/{project}/locations/{location}/metadataStores
      /{metadatastore}/artifacts/{artifact}`
    executions: The resource names of the Executions to associate with the
      Context. Format: `projects/{project}/locations/{location}/metadataStores
      /{metadatastore}/executions/{execution}`
  """

  artifacts = _messages.StringField(1, repeated=True)
  executions = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse(_messages.Message):
  r"""Response message for MetadataService.AddContextArtifactsAndExecutions.
  """



class GoogleCloudAiplatformV1AddContextChildrenRequest(_messages.Message):
  r"""Request message for MetadataService.AddContextChildren.

  Fields:
    childContexts: The resource names of the child Contexts.
  """

  childContexts = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1AddContextChildrenResponse(_messages.Message):
  r"""Response message for MetadataService.AddContextChildren."""


class GoogleCloudAiplatformV1AddExecutionEventsRequest(_messages.Message):
  r"""Request message for MetadataService.AddExecutionEvents.

  Fields:
    events: The Events to create and add.
  """

  events = _messages.MessageField('GoogleCloudAiplatformV1Event', 1, repeated=True)


class GoogleCloudAiplatformV1AddExecutionEventsResponse(_messages.Message):
  r"""Response message for MetadataService.AddExecutionEvents."""


class GoogleCloudAiplatformV1AddTrialMeasurementRequest(_messages.Message):
  r"""Request message for VizierService.AddTrialMeasurement.

  Fields:
    measurement: Required. The measurement to be added to a Trial.
  """

  measurement = _messages.MessageField('GoogleCloudAiplatformV1Measurement', 1)


class GoogleCloudAiplatformV1Annotation(_messages.Message):
  r"""Used to assign specific AnnotationSpec to a particular area of a
  DataItem or the whole part of the DataItem.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Annotations. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set, the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.

  Fields:
    annotationSource: Output only. The source of the Annotation.
    createTime: Output only. Timestamp when this Annotation was created.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      Annotations. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set, the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.
    name: Output only. Resource name of the Annotation.
    payload: Required. The schema of the payload can be found in
      payload_schema.
    payloadSchemaUri: Required. Google Cloud Storage URI points to a YAML file
      describing payload. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). The schema
      files that can be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/annotation/, note that the chosen schema must
      be consistent with the parent Dataset's metadata.
    updateTime: Output only. Timestamp when this Annotation was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Annotations. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one Annotation(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each Annotation: *
    "aiplatform.googleapis.com/annotation_set_name": optional, name of the
    UI's annotation set this Annotation belongs to. If not set, the Annotation
    is not visible in the UI. * "aiplatform.googleapis.com/payload_schema":
    output only, its value is the payload_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationSource = _messages.MessageField('GoogleCloudAiplatformV1UserActionReference', 1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  payload = _messages.MessageField('extra_types.JsonValue', 6)
  payloadSchemaUri = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1AnnotationSpec(_messages.Message):
  r"""Identifies a concept with which DataItems may be annotated with.

  Fields:
    createTime: Output only. Timestamp when this AnnotationSpec was created.
    displayName: Required. The user-defined name of the AnnotationSpec. The
      name can be up to 128 characters long and can consist of any UTF-8
      characters.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    name: Output only. Resource name of the AnnotationSpec.
    updateTime: Output only. Timestamp when AnnotationSpec was last updated.
  """

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleCloudAiplatformV1Artifact(_messages.Message):
  r"""Instance of a general artifact.

  Enums:
    StateValueValuesEnum: The state of this Artifact. This is a property of
      the Artifact, and does not imply or capture any ongoing process. This
      property is managed by clients (such as Vertex AI Pipelines), and the
      system does not prescribe or check the validity of state transitions.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Artifacts. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Artifact
      (System labels are excluded).
    MetadataValue: Properties of the Artifact. Top level metadata keys'
      heading and trailing spaces will be trimmed. The size of this field
      should not exceed 200KB.

  Fields:
    createTime: Output only. Timestamp when this Artifact was created.
    description: Description of the Artifact
    displayName: User provided display name of the Artifact. May be up to 128
      Unicode characters.
    etag: An eTag used to perform consistent read-modify-write updates. If not
      set, a blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Artifacts.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Artifact (System labels
      are excluded).
    metadata: Properties of the Artifact. Top level metadata keys' heading and
      trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.
    name: Output only. The resource name of the Artifact.
    schemaTitle: The title of the schema describing the metadata. Schema title
      and version is expected to be registered in earlier Create Schema calls.
      And both are used together as unique identifiers to identify schemas
      within the local metadata store.
    schemaVersion: The version of the schema in schema_name to use. Schema
      title and version is expected to be registered in earlier Create Schema
      calls. And both are used together as unique identifiers to identify
      schemas within the local metadata store.
    state: The state of this Artifact. This is a property of the Artifact, and
      does not imply or capture any ongoing process. This property is managed
      by clients (such as Vertex AI Pipelines), and the system does not
      prescribe or check the validity of state transitions.
    updateTime: Output only. Timestamp when this Artifact was last updated.
    uri: The uniform resource identifier of the artifact file. May be empty if
      there is no actual artifact file.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of this Artifact. This is a property of the Artifact, and
    does not imply or capture any ongoing process. This property is managed by
    clients (such as Vertex AI Pipelines), and the system does not prescribe
    or check the validity of state transitions.

    Values:
      STATE_UNSPECIFIED: Unspecified state for the Artifact.
      PENDING: A state used by systems like Vertex AI Pipelines to indicate
        that the underlying data item represented by this Artifact is being
        created.
      LIVE: A state indicating that the Artifact should exist, unless
        something external to the system deletes it.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    LIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Artifacts.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. No more than
    64 user labels can be associated with one Artifact (System labels are
    excluded).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Properties of the Artifact. Top level metadata keys' heading and
    trailing spaces will be trimmed. The size of this field should not exceed
    200KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  name = _messages.StringField(7)
  schemaTitle = _messages.StringField(8)
  schemaVersion = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)
  uri = _messages.StringField(12)


class GoogleCloudAiplatformV1Attribution(_messages.Message):
  r"""Attribution that explains a particular prediction output.

  Fields:
    approximationError: Output only. Error of feature_attributions caused by
      approximation used in the explanation method. Lower value means more
      precise attributions. * For Sampled Shapley attribution, increasing
      path_count might reduce the error. * For Integrated Gradients
      attribution, increasing step_count might reduce the error. * For XRAI
      attribution, increasing step_count might reduce the error. See [this
      introduction](/vertex-ai/docs/explainable-ai/overview) for more
      information.
    baselineOutputValue: Output only. Model predicted output if the input
      instance is constructed from the baselines of all the features defined
      in ExplanationMetadata.inputs. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model's
      predicted output has multiple dimensions (rank > 1), this is the value
      in the output located by output_index. If there are multiple baselines,
      their output values are averaged.
    featureAttributions: Output only. Attributions of each explained feature.
      Features are extracted from the prediction instances according to
      explanation metadata for inputs. The value is a struct, whose keys are
      the name of the feature. The values are how much the feature in the
      instance contributed to the predicted result. The format of the value is
      determined by the feature's input format: * If the feature is a scalar
      value, the attribution value is a floating number. * If the feature is
      an array of scalar values, the attribution value is an array. * If the
      feature is a struct, the attribution value is a struct. The keys in the
      attribution value struct are the same as the keys in the feature struct.
      The formats of the values in the attribution struct are determined by
      the formats of the values in the feature struct. The
      ExplanationMetadata.feature_attributions_schema_uri field, pointed to by
      the ExplanationSpec field of the Endpoint.deployed_models object, points
      to the schema file that describes the features and their attribution
      values (if it is populated).
    instanceOutputValue: Output only. Model predicted output on the
      corresponding explanation instance. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model
      predicted output has multiple dimensions, this is the value in the
      output located by output_index.
    outputDisplayName: Output only. The display name of the output identified
      by output_index. For example, the predicted class name by a multi-
      classification Model. This field is only populated iff the Model
      predicts display names as a separate field along with the explained
      output. The predicted display name must has the same shape of the
      explained output, and can be located using output_index.
    outputIndex: Output only. The index that locates the explained prediction
      output. If the prediction output is a scalar value, output_index is not
      populated. If the prediction output has multiple dimensions, the length
      of the output_index list is the same as the number of dimensions of the
      output. The i-th element in output_index is the element index of the
      i-th dimension of the output vector. Indices start from 0.
    outputName: Output only. Name of the explain output. Specified as the key
      in ExplanationMetadata.outputs.
  """

  approximationError = _messages.FloatField(1)
  baselineOutputValue = _messages.FloatField(2)
  featureAttributions = _messages.MessageField('extra_types.JsonValue', 3)
  instanceOutputValue = _messages.FloatField(4)
  outputDisplayName = _messages.StringField(5)
  outputIndex = _messages.IntegerField(6, repeated=True, variant=_messages.Variant.INT32)
  outputName = _messages.StringField(7)


class GoogleCloudAiplatformV1AutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by Vertex
  AI, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If the requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      a no upper bound for scaling under heavy traffic will be assume, though
      Vertex AI may be unable to scale beyond certain replica number.
    minReplicaCount: Immutable. The minimum number of replicas this
      DeployedModel will be always deployed on. If traffic against it
      increases, it may dynamically be deployed onto more replicas up to
      max_replica_count, and as traffic decreases, some of these extra
      replicas may be freed. If the requested value is too large, the
      deployment will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1AutoscalingMetricSpec(_messages.Message):
  r"""The metric specification that defines the target resource utilization
  (CPU utilization, accelerator's duty cycle, and so on) for calculating the
  desired replica count.

  Fields:
    metricName: Required. The resource metric name. Supported metrics: * For
      Online Prediction: *
      `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` *
      `aiplatform.googleapis.com/prediction/online/cpu/utilization`
    target: The target resource utilization in percentage (1% - 100%) for the
      given metric; once the real usage deviates from the target by a certain
      percentage, the machine replicas change. The default value is 60
      (representing 60%) if not provided.
  """

  metricName = _messages.StringField(1)
  target = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1AvroSource(_messages.Message):
  r"""The storage details for Avro input content.

  Fields:
    gcsSource: Required. Google Cloud Storage location.
  """

  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1GcsSource', 1)


class GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata(_messages.Message):
  r"""Details of operations that perform batch create Features.

  Fields:
    genericMetadata: Operation metadata for Feature.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1BatchCreateFeaturesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.BatchCreateFeatures.

  Fields:
    requests: Required. The request message specifying the Features to create.
      All Features must be created under the same parent EntityType. The
      `parent` field in each child request message can be omitted. If `parent`
      is set in a child request, then the value must match the `parent` value
      in this request message.
  """

  requests = _messages.MessageField('GoogleCloudAiplatformV1CreateFeatureRequest', 1, repeated=True)


class GoogleCloudAiplatformV1BatchCreateFeaturesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.BatchCreateFeatures.

  Fields:
    features: The Features created.
  """

  features = _messages.MessageField('GoogleCloudAiplatformV1Feature', 1, repeated=True)


class GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest(_messages.Message):
  r"""Request message for TensorboardService.BatchCreateTensorboardRuns.

  Fields:
    requests: Required. The request message specifying the TensorboardRuns to
      create. A maximum of 1000 TensorboardRuns can be created in a batch.
  """

  requests = _messages.MessageField('GoogleCloudAiplatformV1CreateTensorboardRunRequest', 1, repeated=True)


class GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse(_messages.Message):
  r"""Response message for TensorboardService.BatchCreateTensorboardRuns.

  Fields:
    tensorboardRuns: The created TensorboardRuns.
  """

  tensorboardRuns = _messages.MessageField('GoogleCloudAiplatformV1TensorboardRun', 1, repeated=True)


class GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest(_messages.Message):
  r"""Request message for TensorboardService.BatchCreateTensorboardTimeSeries.

  Fields:
    requests: Required. The request message specifying the
      TensorboardTimeSeries to create. A maximum of 1000 TensorboardTimeSeries
      can be created in a batch.
  """

  requests = _messages.MessageField('GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest', 1, repeated=True)


class GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse(_messages.Message):
  r"""Response message for
  TensorboardService.BatchCreateTensorboardTimeSeries.

  Fields:
    tensorboardTimeSeries: The created TensorboardTimeSeries.
  """

  tensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1TensorboardTimeSeries', 1, repeated=True)


class GoogleCloudAiplatformV1BatchDedicatedResources(_messages.Message):
  r"""A description of resources that are used for performing batch
  operations, are dedicated to a Model, and need manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine.
    maxReplicaCount: Immutable. The maximum number of machine replicas the
      batch operation may be scaled to. The default value is 10.
    startingReplicaCount: Immutable. The number of machine replicas used at
      the start of the batch operation. If not set, Vertex AI decides starting
      number, not greater than max_replica_count
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1MachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startingReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest(_messages.Message):
  r"""Request message for ModelService.BatchImportEvaluatedAnnotations

  Fields:
    evaluatedAnnotations: Required. Evaluated annotations resource to be
      imported.
  """

  evaluatedAnnotations = _messages.MessageField('GoogleCloudAiplatformV1EvaluatedAnnotation', 1, repeated=True)


class GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse(_messages.Message):
  r"""Response message for ModelService.BatchImportEvaluatedAnnotations

  Fields:
    importedEvaluatedAnnotationsCount: Output only. Number of
      EvaluatedAnnotations imported.
  """

  importedEvaluatedAnnotationsCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest(_messages.Message):
  r"""Request message for ModelService.BatchImportModelEvaluationSlices

  Fields:
    modelEvaluationSlices: Required. Model evaluation slice resource to be
      imported.
  """

  modelEvaluationSlices = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationSlice', 1, repeated=True)


class GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse(_messages.Message):
  r"""Response message for ModelService.BatchImportModelEvaluationSlices

  Fields:
    importedModelEvaluationSlices: Output only. List of imported
      ModelEvaluationSlice.name.
  """

  importedModelEvaluationSlices = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
    partialResults: Partial results that reflect the latest migration
      operation progress.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)
  partialResults = _messages.MessageField('GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult', 2, repeated=True)


class GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult(_messages.Message):
  r"""Represents a partial result in batch migration operation for one
  MigrateResourceRequest.

  Fields:
    dataset: Migrated dataset resource name.
    error: The error result of the migration request in case of failure.
    model: Migrated model resource name.
    request: It's the same as the value in
      MigrateResourceRequest.migrate_resource_requests.
  """

  dataset = _messages.StringField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  model = _messages.StringField(3)
  request = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceRequest', 4)


class GoogleCloudAiplatformV1BatchMigrateResourcesRequest(_messages.Message):
  r"""Request message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceRequests: Required. The request messages specifying the
      resources to migrate. They must be in the same location as the
      destination. Up to 50 resources can be migrated in one batch.
  """

  migrateResourceRequests = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceRequest', 1, repeated=True)


class GoogleCloudAiplatformV1BatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformV1BatchPredictionJob(_messages.Message):
  r"""A job that uses a Model to produce predictions on multiple input
  instances. If predictions for significant portion of the instances fail, the
  job may finish without attempting predictions for all remaining instances.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    completionStats: Output only. Statistics on completed and failed
      prediction instances.
    createTime: Output only. Time when the BatchPredictionJob was created.
    dedicatedResources: The config of resources used by the Model during the
      batch prediction. If the Model supports DEDICATED_RESOURCES this config
      may be provided (and the job will use these resources), if the Model
      doesn't support AUTOMATIC_RESOURCES, this config must be provided.
    disableContainerLogging: For custom-trained Models and AutoML Tabular
      Models, the container of the DeployedModel instances will send `stderr`
      and `stdout` streams to Cloud Logging by default. Please note that the
      logs incur cost, which are subject to [Cloud Logging
      pricing](https://cloud.google.com/logging/pricing). User can disable
      container logging by setting this flag to true.
    displayName: Required. The user-defined name of this BatchPredictionJob.
    encryptionSpec: Customer-managed encryption key options for a
      BatchPredictionJob. If this is set, then all resources created by the
      BatchPredictionJob will be encrypted with the provided encryption key.
    endTime: Output only. Time when the BatchPredictionJob entered any of the
      following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when the job's state is
      JOB_STATE_FAILED or JOB_STATE_CANCELLED.
    explanationSpec: Explanation configuration for this BatchPredictionJob.
      Can be specified only if generate_explanation is set to `true`. This
      value overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of the
      explanation_spec object is not populated, the corresponding field of the
      Model.explanation_spec object is inherited.
    generateExplanation: Generate explanation with the batch prediction
      results. When set to `true`, the batch prediction output changes based
      on the `predictions_format` field of the
      BatchPredictionJob.output_config object: * `bigquery`: output includes a
      column named `explanation`. The value is a struct that conforms to the
      Explanation object. * `jsonl`: The JSON objects on each line include an
      additional entry keyed `explanation`. The value of the entry is a JSON
      object that conforms to the Explanation object. * `csv`: Generating
      explanations for CSV format is not supported. If this field is set to
      true, either the Model.explanation_spec or explanation_spec must be
      populated.
    inputConfig: Required. Input configuration of the instances on which
      predictions are performed. The schema of any single instance may be
      specified via the Model's PredictSchemata's instance_schema_uri.
    instanceConfig: Configuration for how to convert batch prediction input
      instances to the prediction instances that are sent to the Model.
    labels: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    manualBatchTuningParameters: Immutable. Parameters configuring the batch
      behavior. Currently only applicable when dedicated_resources are used
      (in other cases Vertex AI does the tuning itself).
    model: The name of the Model resource that produces the predictions via
      this job, must share the same ancestor Location. Starting this job has
      no impact on any existing deployments of the Model and their resources.
      Exactly one of model and unmanaged_container_model must be set. The
      model resource name may contain version id or version alias to specify
      the version. Example:
      `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` if no
      version is specified, the default version will be deployed. The model
      resource could also be a publisher model. Example:
      `publishers/{publisher}/models/{model}` or `projects/{project}/locations
      /{location}/publishers/{publisher}/models/{model}`
    modelParameters: The parameters that govern the predictions. The schema of
      the parameters may be specified via the Model's PredictSchemata's
      parameters_schema_uri.
    modelVersionId: Output only. The version ID of the Model that produces the
      predictions via this job.
    name: Output only. Resource name of the BatchPredictionJob.
    outputConfig: Required. The Configuration specifying where output
      predictions should be written. The schema of any single prediction may
      be specified as a concatenation of Model's PredictSchemata's
      instance_schema_uri and prediction_schema_uri.
    outputInfo: Output only. Information further describing the output of this
      job.
    partialFailures: Output only. Partial failures encountered. For example,
      single files that can't be read. This field never exceeds 20 entries.
      Status details fields contain standard Google Cloud error details.
    resourcesConsumed: Output only. Information about resources that had been
      consumed by this job. Provided in real time at best effort basis, as
      well as a final value once the job completes. Note: This field currently
      may be not populated for batch predictions that use AutoML Models.
    serviceAccount: The service account that the DeployedModel's container
      runs as. If not specified, a system generated one will be used, which
      has minimal permissions and the custom container, if used, may not have
      enough permission to access other Google Cloud resources. Users
      deploying the Model must have the `iam.serviceAccounts.actAs` permission
      on this service account.
    startTime: Output only. Time when the BatchPredictionJob for the first
      time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    unmanagedContainerModel: Contains model information necessary to perform
      batch prediction without requiring uploading to model registry. Exactly
      one of model and unmanaged_container_model must be set.
    updateTime: Output only. Time when the BatchPredictionJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize BatchPredictionJobs.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  completionStats = _messages.MessageField('GoogleCloudAiplatformV1CompletionStats', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1BatchDedicatedResources', 3)
  disableContainerLogging = _messages.BooleanField(4)
  displayName = _messages.StringField(5)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 6)
  endTime = _messages.StringField(7)
  error = _messages.MessageField('GoogleRpcStatus', 8)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1ExplanationSpec', 9)
  generateExplanation = _messages.BooleanField(10)
  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1BatchPredictionJobInputConfig', 11)
  instanceConfig = _messages.MessageField('GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig', 12)
  labels = _messages.MessageField('LabelsValue', 13)
  manualBatchTuningParameters = _messages.MessageField('GoogleCloudAiplatformV1ManualBatchTuningParameters', 14)
  model = _messages.StringField(15)
  modelParameters = _messages.MessageField('extra_types.JsonValue', 16)
  modelVersionId = _messages.StringField(17)
  name = _messages.StringField(18)
  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1BatchPredictionJobOutputConfig', 19)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1BatchPredictionJobOutputInfo', 20)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 21, repeated=True)
  resourcesConsumed = _messages.MessageField('GoogleCloudAiplatformV1ResourcesConsumed', 22)
  serviceAccount = _messages.StringField(23)
  startTime = _messages.StringField(24)
  state = _messages.EnumField('StateValueValuesEnum', 25)
  unmanagedContainerModel = _messages.MessageField('GoogleCloudAiplatformV1UnmanagedContainerModel', 26)
  updateTime = _messages.StringField(27)


class GoogleCloudAiplatformV1BatchPredictionJobInputConfig(_messages.Message):
  r"""Configures the input to BatchPredictionJob. See
  Model.supported_input_storage_formats for Model's supported input formats,
  and how instances should be expressed via any of them.

  Fields:
    bigquerySource: The BigQuery location of the input table. The schema of
      the table should be in the format described by the given context OpenAPI
      Schema, if one is provided. The table may contain additional columns
      that are not described by the schema, and they will be ignored.
    gcsSource: The Cloud Storage location for the input instances.
    instancesFormat: Required. The format in which instances are given, must
      be one of the Model's supported_input_storage_formats.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1BigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1GcsSource', 2)
  instancesFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig(_messages.Message):
  r"""Configuration defining how to transform batch prediction input instances
  to the instances that the Model accepts.

  Fields:
    excludedFields: Fields that will be excluded in the prediction instance
      that is sent to the Model. Excluded will be attached to the batch
      prediction output if key_field is not specified. When excluded_fields is
      populated, included_fields must be empty. The input must be JSONL with
      objects at each line, CSV, BigQuery or TfRecord.
    includedFields: Fields that will be included in the prediction instance
      that is sent to the Model. If instance_type is `array`, the order of
      field names in included_fields also determines the order of the values
      in the array. When included_fields is populated, excluded_fields must be
      empty. The input must be JSONL with objects at each line, CSV, BigQuery
      or TfRecord.
    instanceType: The format of the instance that the Model accepts. Vertex AI
      will convert compatible batch prediction input instance formats to the
      specified format. Supported values are: * `object`: Each input is
      converted to JSON object format. * For `bigquery`, each row is converted
      to an object. * For `jsonl`, each line of the JSONL input must be an
      object. * Does not apply to `csv`, `file-list`, `tf-record`, or `tf-
      record-gzip`. * `array`: Each input is converted to JSON array format. *
      For `bigquery`, each row is converted to an array. The order of columns
      is determined by the BigQuery column order, unless included_fields is
      populated. included_fields must be populated for specifying field
      orders. * For `jsonl`, if each line of the JSONL input is an object,
      included_fields must be populated for specifying field orders. * Does
      not apply to `csv`, `file-list`, `tf-record`, or `tf-record-gzip`. If
      not specified, Vertex AI converts the batch prediction input as follows:
      * For `bigquery` and `csv`, the behavior is the same as `array`. The
      order of columns is the same as defined in the file or table, unless
      included_fields is populated. * For `jsonl`, the prediction instance
      format is determined by each line of the input. * For `tf-record`/`tf-
      record-gzip`, each record will be converted to an object in the format
      of `{"b64": }`, where `` is the Base64-encoded string of the content of
      the record. * For `file-list`, each file in the list will be converted
      to an object in the format of `{"b64": }`, where `` is the
      Base64-encoded string of the content of the file.
    keyField: The name of the field that is considered as a key. The values
      identified by the key field is not included in the transformed instances
      that is sent to the Model. This is similar to specifying this name of
      the field in excluded_fields. In addition, the batch prediction output
      will not include the instances. Instead the output will only include the
      value of the key field, in a field named `key` in the output: * For
      `jsonl` output format, the output will have a `key` field instead of the
      `instance` field. * For `csv`/`bigquery` output format, the output will
      have have a `key` column instead of the instance feature columns. The
      input must be JSONL with objects at each line, CSV, BigQuery or
      TfRecord.
  """

  excludedFields = _messages.StringField(1, repeated=True)
  includedFields = _messages.StringField(2, repeated=True)
  instanceType = _messages.StringField(3)
  keyField = _messages.StringField(4)


class GoogleCloudAiplatformV1BatchPredictionJobOutputConfig(_messages.Message):
  r"""Configures the output of BatchPredictionJob. See
  Model.supported_output_storage_formats for supported output formats, and how
  predictions are expressed via any of them.

  Fields:
    bigqueryDestination: The BigQuery project or dataset location where the
      output is to be written to. If project is provided, a new dataset is
      created with name `prediction__` where is made BigQuery-dataset-name
      compatible (for example, most special characters become underscores),
      and timestamp is in YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format.
      In the dataset two tables will be created, `predictions`, and `errors`.
      If the Model has both instance and prediction schemata defined then the
      tables have columns as follows: The `predictions` table contains
      instances for which the prediction succeeded, it has columns as per a
      concatenation of the Model's instance and prediction schemata. The
      `errors` table contains rows for which the prediction has failed, it has
      instance columns, as per the instance schema, followed by a single
      "errors" column, which as values has google.rpc.Status represented as a
      STRUCT, and containing only `code` and `message`.
    gcsDestination: The Cloud Storage location of the directory where the
      output is to be written to. In the given directory a new directory is
      created. Its name is `prediction--`, where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format. Inside of it files
      `predictions_0001.`, `predictions_0002.`, ..., `predictions_N.` are
      created where `` depends on chosen predictions_format, and N may equal
      0001 and depends on the total number of successfully predicted
      instances. If the Model has both instance and prediction schemata
      defined then each such file contains predictions as per the
      predictions_format. If prediction for any instance failed (partially or
      completely), then an additional `errors_0001.`, `errors_0002.`,...,
      `errors_N.` files are created (N depends on total number of failed
      predictions). These files contain the failed instances, as per their
      schema, followed by an additional `error` field which as value has
      google.rpc.Status containing only `code` and `message` fields.
    predictionsFormat: Required. The format in which Vertex AI gives the
      predictions, must be one of the Model's
      supported_output_storage_formats.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 2)
  predictionsFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1BatchPredictionJobOutputInfo(_messages.Message):
  r"""Further describes this job's output. Supplements output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in `bq://projectId.bqDatasetId` format, into which the
      prediction output is written.
    bigqueryOutputTable: Output only. The name of the BigQuery table created,
      in `predictions_` format, into which the prediction output is written.
      Can be used by UI to generate the BigQuery output path, for example.
    gcsOutputDirectory: Output only. The full path of the Cloud Storage
      directory created, into which the prediction output is written.
  """

  bigqueryOutputDataset = _messages.StringField(1)
  bigqueryOutputTable = _messages.StringField(2)
  gcsOutputDirectory = _messages.StringField(3)


class GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that batch reads Feature values.

  Fields:
    genericMetadata: Operation metadata for Featurestore batch read Features
      values.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1BatchReadFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.BatchReadFeatureValues.

  Fields:
    bigqueryReadInstances: Similar to csv_read_instances, but from BigQuery
      source.
    csvReadInstances: Each read instance consists of exactly one read
      timestamp and one or more entity IDs identifying entities of the
      corresponding EntityTypes whose Features are requested. Each output
      instance contains Feature values of requested entities concatenated
      together as of the read time. An example read instance may be
      `foo_entity_id, bar_entity_id, 2020-01-01T10:00:00.123Z`. An example
      output instance may be `foo_entity_id, bar_entity_id,
      2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
      bar_entity_feature2_value`. Timestamp in each read instance must be
      millisecond-aligned. `csv_read_instances` are read instances stored in a
      plain-text CSV file. The header should be: [ENTITY_TYPE_ID1],
      [ENTITY_TYPE_ID2], ..., timestamp The columns can be in any order.
      Values in the timestamp column must use the RFC 3339 format, e.g.
      `2012-07-30T10:43:17.123Z`.
    destination: Required. Specifies output location and format.
    entityTypeSpecs: Required. Specifies EntityType grouping Features to read
      values of and settings.
    passThroughFields: When not empty, the specified fields in the
      *_read_instances source will be joined as-is in the output, in addition
      to those fields from the Featurestore Entity. For BigQuery source, the
      type of the pass-through values will be automatically inferred. For CSV
      source, the pass-through values will be passed as opaque bytes.
    startTime: Optional. Excludes Feature values with feature generation
      timestamp before this timestamp. If not set, retrieve oldest values kept
      in Feature Store. Timestamp, if present, must not have higher than
      millisecond precision.
  """

  bigqueryReadInstances = _messages.MessageField('GoogleCloudAiplatformV1BigQuerySource', 1)
  csvReadInstances = _messages.MessageField('GoogleCloudAiplatformV1CsvSource', 2)
  destination = _messages.MessageField('GoogleCloudAiplatformV1FeatureValueDestination', 3)
  entityTypeSpecs = _messages.MessageField('GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec', 4, repeated=True)
  passThroughFields = _messages.MessageField('GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField', 5, repeated=True)
  startTime = _messages.StringField(6)


class GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec(_messages.Message):
  r"""Selects Features of an EntityType to read values of and specifies read
  settings.

  Fields:
    entityTypeId: Required. ID of the EntityType to select Features. The
      EntityType id is the entity_type_id specified during EntityType
      creation.
    featureSelector: Required. Selectors choosing which Feature values to read
      from the EntityType.
    settings: Per-Feature settings for the batch read.
  """

  entityTypeId = _messages.StringField(1)
  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1FeatureSelector', 2)
  settings = _messages.MessageField('GoogleCloudAiplatformV1DestinationFeatureSetting', 3, repeated=True)


class GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField(_messages.Message):
  r"""Describe pass-through fields in read_instance source.

  Fields:
    fieldName: Required. The name of the field in the CSV header or the name
      of the column in BigQuery table. The naming restriction is the same as
      Feature.name.
  """

  fieldName = _messages.StringField(1)


class GoogleCloudAiplatformV1BatchReadFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.BatchReadFeatureValues."""


class GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse(_messages.Message):
  r"""Response message for
  TensorboardService.BatchReadTensorboardTimeSeriesData.

  Fields:
    timeSeriesData: The returned time series data.
  """

  timeSeriesData = _messages.MessageField('GoogleCloudAiplatformV1TimeSeriesData', 1, repeated=True)


class GoogleCloudAiplatformV1BigQueryDestination(_messages.Message):
  r"""The BigQuery location for the output content.

  Fields:
    outputUri: Required. BigQuery URI to a project or table, up to 2000
      characters long. When only the project is specified, the Dataset and
      Table is created. When the full table reference is specified, the
      Dataset must exist and table must not exist. Accepted forms: * BigQuery
      path. For example: `bq://projectId` or `bq://projectId.bqDatasetId` or
      `bq://projectId.bqDatasetId.bqTableId`.
  """

  outputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1BigQuerySource(_messages.Message):
  r"""The BigQuery location for the input content.

  Fields:
    inputUri: Required. BigQuery URI to a table, up to 2000 characters long.
      Accepted forms: * BigQuery path. For example:
      `bq://projectId.bqDatasetId.bqTableId`.
  """

  inputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1BlurBaselineConfig(_messages.Message):
  r"""Config for blur baseline. When enabled, a linear path from the maximally
  blurred image to the input image is created. Using a blurred baseline
  instead of zero (black image) is motivated by the BlurIG approach explained
  here: https://arxiv.org/abs/2004.03383

  Fields:
    maxBlurSigma: The standard deviation of the blur kernel for the blurred
      baseline. The same blurring parameter is used for both the height and
      the width dimension. If not set, the method defaults to the zero (i.e.
      black for images) baseline.
  """

  maxBlurSigma = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1BoolArray(_messages.Message):
  r"""A list of boolean values.

  Fields:
    values: A list of bool values.
  """

  values = _messages.BooleanField(1, repeated=True)


class GoogleCloudAiplatformV1CancelBatchPredictionJobRequest(_messages.Message):
  r"""Request message for JobService.CancelBatchPredictionJob."""


class GoogleCloudAiplatformV1CancelCustomJobRequest(_messages.Message):
  r"""Request message for JobService.CancelCustomJob."""


class GoogleCloudAiplatformV1CancelDataLabelingJobRequest(_messages.Message):
  r"""Request message for JobService.CancelDataLabelingJob."""


class GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest(_messages.Message):
  r"""Request message for JobService.CancelHyperparameterTuningJob."""


class GoogleCloudAiplatformV1CancelNasJobRequest(_messages.Message):
  r"""Request message for JobService.CancelNasJob."""


class GoogleCloudAiplatformV1CancelPipelineJobRequest(_messages.Message):
  r"""Request message for PipelineService.CancelPipelineJob."""


class GoogleCloudAiplatformV1CancelTrainingPipelineRequest(_messages.Message):
  r"""Request message for PipelineService.CancelTrainingPipeline."""


class GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata(_messages.Message):
  r"""This message will be placed in the metadata field of a
  google.longrunning.Operation associated with a CheckTrialEarlyStoppingState
  request.

  Fields:
    genericMetadata: Operation metadata for suggesting Trials.
    study: The name of the Study that the Trial belongs to.
    trial: The Trial name.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)
  study = _messages.StringField(2)
  trial = _messages.StringField(3)


class GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest(_messages.Message):
  r"""Request message for VizierService.CheckTrialEarlyStoppingState."""


class GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse(_messages.Message):
  r"""Response message for VizierService.CheckTrialEarlyStoppingState.

  Fields:
    shouldStop: True if the Trial should stop.
  """

  shouldStop = _messages.BooleanField(1)


class GoogleCloudAiplatformV1CompleteTrialRequest(_messages.Message):
  r"""Request message for VizierService.CompleteTrial.

  Fields:
    finalMeasurement: Optional. If provided, it will be used as the completed
      Trial's final_measurement; Otherwise, the service will auto-select a
      previously reported measurement as the final-measurement
    infeasibleReason: Optional. A human readable reason why the trial was
      infeasible. This should only be provided if `trial_infeasible` is true.
    trialInfeasible: Optional. True if the Trial cannot be run with the given
      Parameter, and final_measurement will be ignored.
  """

  finalMeasurement = _messages.MessageField('GoogleCloudAiplatformV1Measurement', 1)
  infeasibleReason = _messages.StringField(2)
  trialInfeasible = _messages.BooleanField(3)


class GoogleCloudAiplatformV1CompletionStats(_messages.Message):
  r"""Success and error statistics of processing multiple entities (for
  example, DataItems or structured data rows) in batch.

  Fields:
    failedCount: Output only. The number of entities for which any error was
      encountered.
    incompleteCount: Output only. In cases when enough errors are encountered
      a job, pipeline, or operation may be failed as a whole. Below is the
      number of entities for which the processing had not been finished
      (either in successful or failed state). Set to -1 if the number is
      unknown (for example, the operation failed before the total entity
      number could be collected).
    successfulCount: Output only. The number of entities that had been
      processed successfully.
    successfulForecastPointCount: Output only. The number of the successful
      forecast points that are generated by the forecasting model. This is
      ONLY used by the forecasting batch prediction.
  """

  failedCount = _messages.IntegerField(1)
  incompleteCount = _messages.IntegerField(2)
  successfulCount = _messages.IntegerField(3)
  successfulForecastPointCount = _messages.IntegerField(4)


class GoogleCloudAiplatformV1ContainerRegistryDestination(_messages.Message):
  r"""The Container Registry location for the container image.

  Fields:
    outputUri: Required. Container Registry URI of a container image. Only
      Google Container Registry and Artifact Registry are supported now.
      Accepted forms: * Google Container Registry path. For example:
      `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For example:
      `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a tag
      is not specified, "latest" will be used as the default tag.
  """

  outputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1ContainerSpec(_messages.Message):
  r"""The spec of a Container.

  Fields:
    args: The arguments to be passed when starting the container.
    command: The command to be invoked when the container is started. It
      overrides the entrypoint instruction in Dockerfile when provided.
    env: Environment variables to be passed to the container. Maximum limit is
      100.
    imageUri: Required. The URI of a container image in the Container Registry
      that is to be run on each worker replica.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('GoogleCloudAiplatformV1EnvVar', 3, repeated=True)
  imageUri = _messages.StringField(4)


class GoogleCloudAiplatformV1Context(_messages.Message):
  r"""Instance of a general context.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Contexts. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Context
      (System labels are excluded).
    MetadataValue: Properties of the Context. Top level metadata keys' heading
      and trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.

  Fields:
    createTime: Output only. Timestamp when this Context was created.
    description: Description of the Context
    displayName: User provided display name of the Context. May be up to 128
      Unicode characters.
    etag: An eTag used to perform consistent read-modify-write updates. If not
      set, a blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Contexts.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Context (System labels
      are excluded).
    metadata: Properties of the Context. Top level metadata keys' heading and
      trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.
    name: Immutable. The resource name of the Context.
    parentContexts: Output only. A list of resource names of Contexts that are
      parents of this Context. A Context may have at most 10 parent_contexts.
    schemaTitle: The title of the schema describing the metadata. Schema title
      and version is expected to be registered in earlier Create Schema calls.
      And both are used together as unique identifiers to identify schemas
      within the local metadata store.
    schemaVersion: The version of the schema in schema_name to use. Schema
      title and version is expected to be registered in earlier Create Schema
      calls. And both are used together as unique identifiers to identify
      schemas within the local metadata store.
    updateTime: Output only. Timestamp when this Context was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Contexts. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Context (System labels are excluded).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Properties of the Context. Top level metadata keys' heading and
    trailing spaces will be trimmed. The size of this field should not exceed
    200KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  name = _messages.StringField(7)
  parentContexts = _messages.StringField(8, repeated=True)
  schemaTitle = _messages.StringField(9)
  schemaVersion = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class GoogleCloudAiplatformV1CopyModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.CopyModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CopyModelRequest(_messages.Message):
  r"""Request message for ModelService.CopyModel.

  Fields:
    encryptionSpec: Customer-managed encryption key options. If this is set,
      then the Model copy will be encrypted with the provided encryption key.
    modelId: Optional. Copy source_model into a new Model with this ID. The ID
      will become the final component of the model resource name. This value
      may be up to 63 characters, and valid characters are `[a-z0-9_-]`. The
      first character cannot be a number or hyphen.
    parentModel: Optional. Specify this field to copy source_model into this
      existing Model as a new version. Format:
      `projects/{project}/locations/{location}/models/{model}`
    sourceModel: Required. The resource name of the Model to copy. That Model
      must be in the same Project. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 1)
  modelId = _messages.StringField(2)
  parentModel = _messages.StringField(3)
  sourceModel = _messages.StringField(4)


class GoogleCloudAiplatformV1CopyModelResponse(_messages.Message):
  r"""Response message of ModelService.CopyModel operation.

  Fields:
    model: The name of the copied Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
    modelVersionId: Output only. The version ID of the model that is copied.
  """

  model = _messages.StringField(1)
  modelVersionId = _messages.StringField(2)


class GoogleCloudAiplatformV1CreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDatasetVersion.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata(_messages.Message):
  r"""Details of operations that perform create EntityType.

  Fields:
    genericMetadata: Operation metadata for EntityType.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateFeatureOperationMetadata(_messages.Message):
  r"""Details of operations that perform create Feature.

  Fields:
    genericMetadata: Operation metadata for Feature.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateFeatureRequest(_messages.Message):
  r"""Request message for FeaturestoreService.CreateFeature. Request message
  for FeatureRegistryService.CreateFeature.

  Fields:
    feature: Required. The Feature to create.
    featureId: Required. The ID to use for the Feature, which will become the
      final component of the Feature's resource name. This value may be up to
      128 characters, and valid characters are `[a-z0-9_]`. The first
      character cannot be a number. The value must be unique within an
      EntityType/FeatureGroup.
    parent: Required. The resource name of the EntityType or FeatureGroup to
      create a Feature. Format for entity_type as parent: `projects/{project}/
      locations/{location}/featurestores/{featurestore}/entityTypes/{entity_ty
      pe}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  feature = _messages.MessageField('GoogleCloudAiplatformV1Feature', 1)
  featureId = _messages.StringField(2)
  parent = _messages.StringField(3)


class GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform create Featurestore.

  Fields:
    genericMetadata: Operation metadata for Featurestore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  IndexEndpointService.CreateIndexEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateIndexOperationMetadata(_messages.Message):
  r"""Runtime operation information for IndexService.CreateIndex.

  Fields:
    genericMetadata: The operation generic information.
    nearestNeighborSearchOperationMetadata: The operation metadata with regard
      to Matching Engine Index operation.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)
  nearestNeighborSearchOperationMetadata = _messages.MessageField('GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata', 2)


class GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform MetadataService.CreateMetadataStore.

  Fields:
    genericMetadata: Operation metadata for creating a MetadataStore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreatePipelineJobRequest(_messages.Message):
  r"""Request message for PipelineService.CreatePipelineJob.

  Fields:
    parent: Required. The resource name of the Location to create the
      PipelineJob in. Format: `projects/{project}/locations/{location}`
    pipelineJob: Required. The PipelineJob to create.
    pipelineJobId: The ID to use for the PipelineJob, which will become the
      final component of the PipelineJob name. If not provided, an ID will be
      automatically generated. This value should be less than 128 characters,
      and valid characters are `/a-z-/`.
  """

  parent = _messages.StringField(1)
  pipelineJob = _messages.MessageField('GoogleCloudAiplatformV1PipelineJob', 2)
  pipelineJobId = _messages.StringField(3)


class GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateTensorboardOperationMetadata(_messages.Message):
  r"""Details of operations that perform create Tensorboard.

  Fields:
    genericMetadata: Operation metadata for Tensorboard.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1CreateTensorboardRunRequest(_messages.Message):
  r"""Request message for TensorboardService.CreateTensorboardRun.

  Fields:
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardRun in. Format: `projects/{project}/locations/{location}/
      tensorboards/{tensorboard}/experiments/{experiment}`
    tensorboardRun: Required. The TensorboardRun to create.
    tensorboardRunId: Required. The ID to use for the Tensorboard run, which
      becomes the final component of the Tensorboard run's resource name. This
      value should be 1-128 characters, and valid characters are `/a-z-/`.
  """

  parent = _messages.StringField(1)
  tensorboardRun = _messages.MessageField('GoogleCloudAiplatformV1TensorboardRun', 2)
  tensorboardRunId = _messages.StringField(3)


class GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest(_messages.Message):
  r"""Request message for TensorboardService.CreateTensorboardTimeSeries.

  Fields:
    parent: Required. The resource name of the TensorboardRun to create the
      TensorboardTimeSeries in. Format: `projects/{project}/locations/{locatio
      n}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
    tensorboardTimeSeries: Required. The TensorboardTimeSeries to create.
    tensorboardTimeSeriesId: Optional. The user specified unique ID to use for
      the TensorboardTimeSeries, which becomes the final component of the
      TensorboardTimeSeries's resource name. This value should match
      "a-z0-9{0, 127}"
  """

  parent = _messages.StringField(1)
  tensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1TensorboardTimeSeries', 2)
  tensorboardTimeSeriesId = _messages.StringField(3)


class GoogleCloudAiplatformV1CsvDestination(_messages.Message):
  r"""The storage details for CSV output content.

  Fields:
    gcsDestination: Required. Google Cloud Storage location.
  """

  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 1)


class GoogleCloudAiplatformV1CsvSource(_messages.Message):
  r"""The storage details for CSV input content.

  Fields:
    gcsSource: Required. Google Cloud Storage location.
  """

  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1GcsSource', 1)


class GoogleCloudAiplatformV1CustomJob(_messages.Message):
  r"""Represents a job that runs custom workloads such as a Docker container
  or a Python package. A CustomJob can have multiple worker pools and each
  worker pool can have its own machine and input spec. A CustomJob will be
  cleaned up once the job enters terminal state (failed or succeeded).

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    WebAccessUrisValue: Output only. URIs for accessing [interactive
      shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
      interactive-shell) (one URI for each training node). Only available if
      job_spec.enable_web_access is `true`. The keys are names of each node in
      the training job; for example, `workerpool0-0` for the primary node,
      `workerpool1-0` for the first node in the second worker pool, and
      `workerpool1-1` for the second node in the second worker pool. The
      values are the URIs for each node's interactive shell.

  Fields:
    createTime: Output only. Time when the CustomJob was created.
    displayName: Required. The display name of the CustomJob. The name can be
      up to 128 characters long and can consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key options for a CustomJob.
      If this is set, then all resources created by the CustomJob will be
      encrypted with the provided encryption key.
    endTime: Output only. Time when the CustomJob entered any of the following
      states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is `JOB_STATE_FAILED`
      or `JOB_STATE_CANCELLED`.
    jobSpec: Required. Job spec.
    labels: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    name: Output only. Resource name of a CustomJob.
    startTime: Output only. Time when the CustomJob for the first time entered
      the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Time when the CustomJob was most recently
      updated.
    webAccessUris: Output only. URIs for accessing [interactive
      shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
      interactive-shell) (one URI for each training node). Only available if
      job_spec.enable_web_access is `true`. The keys are names of each node in
      the training job; for example, `workerpool0-0` for the primary node,
      `workerpool1-0` for the first node in the second worker pool, and
      `workerpool1-1` for the second node in the second worker pool. The
      values are the URIs for each node's interactive shell.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize CustomJobs. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class WebAccessUrisValue(_messages.Message):
    r"""Output only. URIs for accessing [interactive
    shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
    interactive-shell) (one URI for each training node). Only available if
    job_spec.enable_web_access is `true`. The keys are names of each node in
    the training job; for example, `workerpool0-0` for the primary node,
    `workerpool1-0` for the first node in the second worker pool, and
    `workerpool1-1` for the second node in the second worker pool. The values
    are the URIs for each node's interactive shell.

    Messages:
      AdditionalProperty: An additional property for a WebAccessUrisValue
        object.

    Fields:
      additionalProperties: Additional properties of type WebAccessUrisValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a WebAccessUrisValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  jobSpec = _messages.MessageField('GoogleCloudAiplatformV1CustomJobSpec', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  startTime = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)
  webAccessUris = _messages.MessageField('WebAccessUrisValue', 12)


class GoogleCloudAiplatformV1CustomJobSpec(_messages.Message):
  r"""Represents the spec of a CustomJob.

  Fields:
    baseOutputDirectory: The Cloud Storage location to store the output of
      this CustomJob or HyperparameterTuningJob. For HyperparameterTuningJob,
      the baseOutputDirectory of each child CustomJob backing a Trial is set
      to a subdirectory of name id under its parent HyperparameterTuningJob's
      baseOutputDirectory. The following Vertex AI environment variables will
      be passed to containers or python modules when this field is set: For
      CustomJob: * AIP_MODEL_DIR = `/model/` * AIP_CHECKPOINT_DIR =
      `/checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `/logs/` For CustomJob
      backing a Trial of HyperparameterTuningJob: * AIP_MODEL_DIR = `//model/`
      * AIP_CHECKPOINT_DIR = `//checkpoints/` * AIP_TENSORBOARD_LOG_DIR =
      `//logs/`
    enableDashboardAccess: Optional. Whether you want Vertex AI to enable
      access to the customized dashboard in training chief container. If set
      to `true`, you can access the dashboard at the URIs given by
      CustomJob.web_access_uris or Trial.web_access_uris (within
      HyperparameterTuningJob.trials).
    enableWebAccess: Optional. Whether you want Vertex AI to enable
      [interactive shell access](https://cloud.google.com/vertex-
      ai/docs/training/monitor-debug-interactive-shell) to training
      containers. If set to `true`, you can access interactive shells at the
      URIs given by CustomJob.web_access_uris or Trial.web_access_uris (within
      HyperparameterTuningJob.trials).
    experiment: Optional. The Experiment associated with this job. Format: `pr
      ojects/{project}/locations/{location}/metadataStores/{metadataStores}/co
      ntexts/{experiment-name}`
    experimentRun: Optional. The Experiment Run associated with this job.
      Format: `projects/{project}/locations/{location}/metadataStores/{metadat
      aStores}/contexts/{experiment-name}-{experiment-run-name}`
    network: Optional. The full name of the Compute Engine
      [network](/compute/docs/networks-and-firewalls#networks) to which the
      Job should be peered. For example,
      `projects/12345/global/networks/myVPC`.
      [Format](/compute/docs/reference/rest/v1/networks/insert) is of the form
      `projects/{project}/global/networks/{network}`. Where {project} is a
      project number, as in `12345`, and {network} is a network name. To
      specify this field, you must have already [configured VPC Network
      Peering for Vertex AI](https://cloud.google.com/vertex-
      ai/docs/general/vpc-peering). If this field is left unspecified, the job
      is not peered with any network.
    reservedIpRanges: Optional. A list of names for the reserved ip ranges
      under the VPC network that can be used for this job. If set, we will
      deploy the job within the provided ip ranges. Otherwise, the job will be
      deployed to any ip ranges under the provided VPC network. Example:
      ['vertex-ai-ip-range'].
    scheduling: Scheduling options for a CustomJob.
    serviceAccount: Specifies the service account for workload run-as account.
      Users submitting jobs must have act-as permission on this run-as
      account. If unspecified, the [Vertex AI Custom Code Service
      Agent](https://cloud.google.com/vertex-ai/docs/general/access-
      control#service-agents) for the CustomJob's project is used.
    tensorboard: Optional. The name of a Vertex AI Tensorboard resource to
      which this CustomJob will upload Tensorboard logs. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    workerPoolSpecs: Required. The spec of the worker pools including machine
      type and Docker image. All worker pools except the first one are
      optional and can be skipped by providing an empty value.
  """

  baseOutputDirectory = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 1)
  enableDashboardAccess = _messages.BooleanField(2)
  enableWebAccess = _messages.BooleanField(3)
  experiment = _messages.StringField(4)
  experimentRun = _messages.StringField(5)
  network = _messages.StringField(6)
  reservedIpRanges = _messages.StringField(7, repeated=True)
  scheduling = _messages.MessageField('GoogleCloudAiplatformV1Scheduling', 8)
  serviceAccount = _messages.StringField(9)
  tensorboard = _messages.StringField(10)
  workerPoolSpecs = _messages.MessageField('GoogleCloudAiplatformV1WorkerPoolSpec', 11, repeated=True)


class GoogleCloudAiplatformV1DataItem(_messages.Message):
  r"""A piece of data in a Dataset. Could be an image, a video, a document or
  plain text.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your DataItems. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this DataItem was created.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      DataItems. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Output only. The resource name of the DataItem.
    payload: Required. The data that the DataItem represents (for example, an
      image or a text snippet). The schema of the payload is stored in the
      parent Dataset's metadata schema's dataItemSchemaUri field.
    updateTime: Output only. Timestamp when this DataItem was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    DataItems. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one DataItem(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  payload = _messages.MessageField('extra_types.JsonValue', 5)
  updateTime = _messages.StringField(6)


class GoogleCloudAiplatformV1DataItemView(_messages.Message):
  r"""A container for a single DataItem and Annotations on it.

  Fields:
    annotations: The Annotations on the DataItem. If too many Annotations
      should be returned for the DataItem, this field will be truncated per
      annotations_limit in request. If it was, then the
      has_truncated_annotations will be set to true.
    dataItem: The DataItem.
    hasTruncatedAnnotations: True if and only if the Annotations field has
      been truncated. It happens if more Annotations for this DataItem met the
      request's annotation_filter than are allowed to be returned by
      annotations_limit. Note that if Annotations field is not being returned
      due to field mask, then this field will not be set to true no matter how
      many Annotations are there.
  """

  annotations = _messages.MessageField('GoogleCloudAiplatformV1Annotation', 1, repeated=True)
  dataItem = _messages.MessageField('GoogleCloudAiplatformV1DataItem', 2)
  hasTruncatedAnnotations = _messages.BooleanField(3)


class GoogleCloudAiplatformV1DataLabelingJob(_messages.Message):
  r"""DataLabelingJob is used to trigger a human labeling job on unlabeled
  data from the following Dataset:

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    AnnotationLabelsValue: Labels to assign to annotations generated by this
      DataLabelingJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    LabelsValue: The labels with user-defined metadata to organize your
      DataLabelingJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
      output only, its value is the inputs_schema's title.

  Fields:
    activeLearningConfig: Parameters that configure the active learning
      pipeline. Active learning will label the data incrementally via several
      iterations. For every iteration, it will select a batch of data based on
      the sampling strategy.
    annotationLabels: Labels to assign to annotations generated by this
      DataLabelingJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    createTime: Output only. Timestamp when this DataLabelingJob was created.
    currentSpend: Output only. Estimated cost(in US dollars) that the
      DataLabelingJob has incurred to date.
    datasets: Required. Dataset resource names. Right now we only support
      labeling from a single Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    displayName: Required. The user-defined name of the DataLabelingJob. The
      name can be up to 128 characters long and can consist of any UTF-8
      characters. Display name of a DataLabelingJob.
    encryptionSpec: Customer-managed encryption key spec for a
      DataLabelingJob. If set, this DataLabelingJob will be secured by this
      key. Note: Annotations created in the DataLabelingJob are associated
      with the EncryptionSpec of the Dataset they are exported to.
    error: Output only. DataLabelingJob errors. It is only populated when
      job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
    inputs: Required. Input config parameters for the DataLabelingJob.
    inputsSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing the config for a specific type of DataLabelingJob.
      The schema files that can be used here are found in the
      https://storage.googleapis.com/google-cloud-aiplatform bucket in the
      /schema/datalabelingjob/inputs/ folder.
    instructionUri: Required. The Google Cloud Storage location of the
      instruction pdf. This pdf is shared with labelers, and provides detailed
      description on how to label DataItems in Datasets.
    labelerCount: Required. Number of labelers to work on each DataItem.
    labelingProgress: Output only. Current labeling job progress percentage
      scaled in interval [0, 100], indicating the percentage of DataItems that
      has been finished.
    labels: The labels with user-defined metadata to organize your
      DataLabelingJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
      output only, its value is the inputs_schema's title.
    name: Output only. Resource name of the DataLabelingJob.
    specialistPools: The SpecialistPools' resource names associated with this
      job.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Timestamp when this DataLabelingJob was updated
      most recently.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationLabelsValue(_messages.Message):
    r"""Labels to assign to annotations generated by this DataLabelingJob.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable.

    Messages:
      AdditionalProperty: An additional property for a AnnotationLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AnnotationLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your
    DataLabelingJobs. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
    output only, its value is the inputs_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activeLearningConfig = _messages.MessageField('GoogleCloudAiplatformV1ActiveLearningConfig', 1)
  annotationLabels = _messages.MessageField('AnnotationLabelsValue', 2)
  createTime = _messages.StringField(3)
  currentSpend = _messages.MessageField('GoogleTypeMoney', 4)
  datasets = _messages.StringField(5, repeated=True)
  displayName = _messages.StringField(6)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 7)
  error = _messages.MessageField('GoogleRpcStatus', 8)
  inputs = _messages.MessageField('extra_types.JsonValue', 9)
  inputsSchemaUri = _messages.StringField(10)
  instructionUri = _messages.StringField(11)
  labelerCount = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  labelingProgress = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 14)
  name = _messages.StringField(15)
  specialistPools = _messages.StringField(16, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 17)
  updateTime = _messages.StringField(18)


class GoogleCloudAiplatformV1Dataset(_messages.Message):
  r"""A collection of DataItems and Annotations on them.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Datasets. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Dataset
      (System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.

  Fields:
    createTime: Output only. Timestamp when this Dataset was created.
    dataItemCount: Output only. The number of DataItems in this Dataset. Only
      apply for non-structured Dataset.
    description: The description of the Dataset.
    displayName: Required. The user-defined name of the Dataset. The name can
      be up to 128 characters long and can consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key spec for a Dataset. If
      set, this Dataset and all sub-resources of this Dataset will be secured
      by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Datasets.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Dataset (System labels
      are excluded). See https://goo.gl/xmQnxf for more information and
      examples of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.
    metadata: Required. Additional information about the Dataset.
    metadataArtifact: Output only. The resource name of the Artifact that was
      created in MetadataStore when creating the Dataset. The Artifact
      resource name pattern is `projects/{project}/locations/{location}/metada
      taStores/{metadata_store}/artifacts/{artifact}`.
    metadataSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Dataset. The schema
      is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can
      be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/metadata/.
    name: Output only. The resource name of the Dataset.
    savedQueries: All SavedQueries belong to the Dataset will be returned in
      List/Get Dataset response. The annotation_specs field will not be
      populated except for UI cases which will only use annotation_spec_count.
      In CreateDataset request, a SavedQuery is created together if this field
      is set, up to one SavedQuery can be set in CreateDatasetRequest. The
      SavedQuery should not contain any AnnotationSpec.
    updateTime: Output only. Timestamp when this Dataset was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Datasets. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Dataset (System labels are excluded). See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable. Following system labels exist for each Dataset: *
    "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
    value is the metadata_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  dataItemCount = _messages.IntegerField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  metadata = _messages.MessageField('extra_types.JsonValue', 8)
  metadataArtifact = _messages.StringField(9)
  metadataSchemaUri = _messages.StringField(10)
  name = _messages.StringField(11)
  savedQueries = _messages.MessageField('GoogleCloudAiplatformV1SavedQuery', 12, repeated=True)
  updateTime = _messages.StringField(13)


class GoogleCloudAiplatformV1DatasetVersion(_messages.Message):
  r"""Describes the dataset version.

  Fields:
    bigQueryDatasetName: Output only. Name of the associated BigQuery dataset.
    createTime: Output only. Timestamp when this DatasetVersion was created.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    name: Output only. The resource name of the DatasetVersion.
    updateTime: Output only. Timestamp when this DatasetVersion was last
      updated.
  """

  bigQueryDatasetName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleCloudAiplatformV1DedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel, and
  that need a higher degree of manual configuration.

  Fields:
    autoscalingMetricSpecs: Immutable. The metric specifications that
      overrides a resource utilization metric (CPU utilization, accelerator's
      duty cycle, and so on) target value (default to 60 if not set). At most
      one entry is allowed per metric. If machine_spec.accelerator_count is
      above 0, the autoscaling will be based on both CPU utilization and
      accelerator's duty cycle metrics and scale up when either metrics
      exceeds its target value while scale down if both metrics are under
      their target value. The default target value is 60 for both metrics. If
      machine_spec.accelerator_count is 0, the autoscaling will be based on
      CPU utilization metric only with default target value 60 if not
      explicitly set. For example, in the case of Online Prediction, if you
      want to override target CPU utilization to 80, you should set
      autoscaling_metric_specs.metric_name to
      `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
      autoscaling_metric_specs.target to `80`.
    machineSpec: Required. Immutable. The specification of a single machine
      used by the prediction.
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If the requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      will use min_replica_count as the default value. The value of this field
      impacts the charge against Vertex CPU and GPU quotas. Specifically, you
      will be charged for (max_replica_count * number of cores in the selected
      machine type) and (max_replica_count * number of GPUs per replica in the
      selected machine type).
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas this DeployedModel will be always deployed on. This value must
      be greater than or equal to 1. If traffic against the DeployedModel
      increases, it may dynamically be deployed onto more replicas, and as
      traffic decreases, some of these extra replicas may be freed.
  """

  autoscalingMetricSpecs = _messages.MessageField('GoogleCloudAiplatformV1AutoscalingMetricSpec', 1, repeated=True)
  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1MachineSpec', 2)
  maxReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that delete Feature values.

  Fields:
    genericMetadata: Operation metadata for Featurestore delete Features
      values.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1DeleteFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.DeleteFeatureValues.

  Fields:
    selectEntity: Select feature values to be deleted by specifying entities.
    selectTimeRangeAndFeature: Select feature values to be deleted by
      specifying time range and features.
  """

  selectEntity = _messages.MessageField('GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity', 1)
  selectTimeRangeAndFeature = _messages.MessageField('GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature', 2)


class GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity(_messages.Message):
  r"""Message to select entity. If an entity id is selected, all the feature
  values corresponding to the entity id will be deleted, including the
  entityId.

  Fields:
    entityIdSelector: Required. Selectors choosing feature values of which
      entity id to be deleted from the EntityType.
  """

  entityIdSelector = _messages.MessageField('GoogleCloudAiplatformV1EntityIdSelector', 1)


class GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature(_messages.Message):
  r"""Message to select time range and feature. Values of the selected feature
  generated within an inclusive time range will be deleted. Using this option
  permanently deletes the feature values from the specified feature IDs within
  the specified time range. This might include data from the online storage.
  If you want to retain any deleted historical data in the online storage, you
  must re-ingest it.

  Fields:
    featureSelector: Required. Selectors choosing which feature values to be
      deleted from the EntityType.
    skipOnlineStorageDelete: If set, data will not be deleted from online
      storage. When time range is older than the data in online storage,
      setting this to be true will make the deletion have no impact on online
      serving.
    timeRange: Required. Select feature generated within a half-inclusive time
      range. The time range is lower inclusive and upper exclusive.
  """

  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1FeatureSelector', 1)
  skipOnlineStorageDelete = _messages.BooleanField(2)
  timeRange = _messages.MessageField('GoogleTypeInterval', 3)


class GoogleCloudAiplatformV1DeleteFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.DeleteFeatureValues.

  Fields:
    selectEntity: Response for request specifying the entities to delete
    selectTimeRangeAndFeature: Response for request specifying time range and
      feature
  """

  selectEntity = _messages.MessageField('GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity', 1)
  selectTimeRangeAndFeature = _messages.MessageField('GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature', 2)


class GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity(_messages.Message):
  r"""Response message if the request uses the SelectEntity option.

  Fields:
    offlineStorageDeletedEntityRowCount: The count of deleted entity rows in
      the offline storage. Each row corresponds to the combination of an
      entity ID and a timestamp. One entity ID can have multiple rows in the
      offline storage.
    onlineStorageDeletedEntityCount: The count of deleted entities in the
      online storage. Each entity ID corresponds to one entity.
  """

  offlineStorageDeletedEntityRowCount = _messages.IntegerField(1)
  onlineStorageDeletedEntityCount = _messages.IntegerField(2)


class GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature(_messages.Message):
  r"""Response message if the request uses the SelectTimeRangeAndFeature
  option.

  Fields:
    impactedFeatureCount: The count of the features or columns impacted. This
      is the same as the feature count in the request.
    offlineStorageModifiedEntityRowCount: The count of modified entity rows in
      the offline storage. Each row corresponds to the combination of an
      entity ID and a timestamp. One entity ID can have multiple rows in the
      offline storage. Within each row, only the features specified in the
      request are deleted.
    onlineStorageModifiedEntityCount: The count of modified entities in the
      online storage. Each entity ID corresponds to one entity. Within each
      entity, only the features specified in the request are deleted.
  """

  impactedFeatureCount = _messages.IntegerField(1)
  offlineStorageModifiedEntityRowCount = _messages.IntegerField(2)
  onlineStorageModifiedEntityCount = _messages.IntegerField(3)


class GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform MetadataService.DeleteMetadataStore.

  Fields:
    genericMetadata: Operation metadata for deleting a MetadataStore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1DeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1DeployIndexOperationMetadata(_messages.Message):
  r"""Runtime operation information for IndexEndpointService.DeployIndex.

  Fields:
    deployedIndexId: The unique index id specified by user
    genericMetadata: The operation generic information.
  """

  deployedIndexId = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1DeployIndexRequest(_messages.Message):
  r"""Request message for IndexEndpointService.DeployIndex.

  Fields:
    deployedIndex: Required. The DeployedIndex to be created within the
      IndexEndpoint.
  """

  deployedIndex = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndex', 1)


class GoogleCloudAiplatformV1DeployIndexResponse(_messages.Message):
  r"""Response message for IndexEndpointService.DeployIndex.

  Fields:
    deployedIndex: The DeployedIndex that had been deployed in the
      IndexEndpoint.
  """

  deployedIndex = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndex', 1)


class GoogleCloudAiplatformV1DeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1DeployModelRequest(_messages.Message):
  r"""Request message for EndpointService.DeployModel.

  Messages:
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.

  Fields:
    deployedModel: Required. The DeployedModel to be created within the
      Endpoint. Note that Endpoint.traffic_split must be updated for the
      DeployedModel to start receiving traffic, either as part of this call,
      or via EndpointService.UpdateEndpoint.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If
      this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If this field is
    non-empty, then the Endpoint's traffic_split will be overwritten with it.
    To refer to the ID of the just being deployed Model, a "0" should be used,
    and the actual ID of the new DeployedModel will be filled in its place by
    this method. The traffic percentage values must add up to 100. If this
    field is empty, then the Endpoint's traffic_split is not updated.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1DeployedModel', 1)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 2)


class GoogleCloudAiplatformV1DeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1DeployedModel', 1)


class GoogleCloudAiplatformV1DeployedIndex(_messages.Message):
  r"""A deployment of an Index. IndexEndpoints contain one or more
  DeployedIndexes.

  Fields:
    automaticResources: Optional. A description of resources that the
      DeployedIndex uses, which to large degree are decided by Vertex AI, and
      optionally allows only a modest additional configuration. If
      min_replica_count is not set, the default value is 2 (we don't provide
      SLA when min_replica_count=1). If max_replica_count is not set, the
      default value is min_replica_count. The max allowed replica count is
      1000.
    createTime: Output only. Timestamp when the DeployedIndex was created.
    dedicatedResources: Optional. A description of resources that are
      dedicated to the DeployedIndex, and that need a higher degree of manual
      configuration. If min_replica_count is not set, the default value is 2
      (we don't provide SLA when min_replica_count=1). If max_replica_count is
      not set, the default value is min_replica_count. The max allowed replica
      count is 1000. Available machine types for SMALL shard: e2-standard-2
      and all machine types available for MEDIUM and LARGE shard. Available
      machine types for MEDIUM shard: e2-standard-16 and all machine types
      available for LARGE shard. Available machine types for LARGE shard:
      e2-highmem-16, n2d-standard-32. n1-standard-16 and n1-standard-32 are
      still available, but we recommend e2-standard-16 and e2-highmem-16 for
      cost efficiency.
    deployedIndexAuthConfig: Optional. If set, the authentication is enabled
      for the private endpoint.
    deploymentGroup: Optional. The deployment group can be no longer than 64
      characters (eg: 'test', 'prod'). If not set, we will use the 'default'
      deployment group. Creating `deployment_groups` with `reserved_ip_ranges`
      is a recommended practice when the peered network has multiple peering
      ranges. This creates your deployments from predictable IP spaces for
      easier traffic administration. Also, one deployment_group (except
      'default') can only be used with the same reserved_ip_ranges which means
      if the deployment_group has been used with reserved_ip_ranges: [a, b,
      c], using it with [a, b] or [d, e] is disallowed. Note: we only support
      up to 5 deployment groups(not including 'default').
    displayName: The display name of the DeployedIndex. If not provided upon
      creation, the Index's display_name is used.
    enableAccessLogging: Optional. If true, private endpoint's access logs are
      sent to Cloud Logging. These logs are like standard server access logs,
      containing information like timestamp and latency for each MatchRequest.
      Note that logs may incur a cost, especially if the deployed index
      receives a high queries per second rate (QPS). Estimate your costs
      before enabling this option.
    id: Required. The user specified ID of the DeployedIndex. The ID can be up
      to 128 characters long and must start with a letter and only contain
      letters, numbers, and underscores. The ID must be unique within the
      project it is created in.
    index: Required. The name of the Index this is the deployment of. We may
      refer to this Index as the DeployedIndex's "original" Index.
    indexSyncTime: Output only. The DeployedIndex may depend on various data
      on its original Index. Additionally when certain changes to the original
      Index are being done (e.g. when what the Index contains is being
      changed) the DeployedIndex may be asynchronously updated in the
      background to reflect these changes. If this timestamp's value is at
      least the Index.update_time of the original Index, it means that this
      DeployedIndex and the original Index are in sync. If this timestamp is
      older, then to see which updates this DeployedIndex already contains
      (and which it does not), one must list the operations that are running
      on the original Index. Only the successfully completed Operations with
      update_time equal or before this sync time are contained in this
      DeployedIndex.
    privateEndpoints: Output only. Provides paths for users to send requests
      directly to the deployed index services running on Cloud via private
      services access. This field is populated if network is configured.
    reservedIpRanges: Optional. A list of reserved ip ranges under the VPC
      network that can be used for this DeployedIndex. If set, we will deploy
      the index within the provided ip ranges. Otherwise, the index might be
      deployed to any ip ranges under the provided VPC network. The value
      should be the name of the address
      (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
      Example: ['vertex-ai-ip-range']. For more information about subnets and
      network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#
      manually_created_subnet_ip_ranges.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1DedicatedResources', 3)
  deployedIndexAuthConfig = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndexAuthConfig', 4)
  deploymentGroup = _messages.StringField(5)
  displayName = _messages.StringField(6)
  enableAccessLogging = _messages.BooleanField(7)
  id = _messages.StringField(8)
  index = _messages.StringField(9)
  indexSyncTime = _messages.StringField(10)
  privateEndpoints = _messages.MessageField('GoogleCloudAiplatformV1IndexPrivateEndpoints', 11)
  reservedIpRanges = _messages.StringField(12, repeated=True)


class GoogleCloudAiplatformV1DeployedIndexAuthConfig(_messages.Message):
  r"""Used to set up the auth on the DeployedIndex's private endpoint.

  Fields:
    authProvider: Defines the authentication provider that the DeployedIndex
      uses.
  """

  authProvider = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider', 1)


class GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider(_messages.Message):
  r"""Configuration for an authentication provider, including support for
  [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-
  web-token-32).

  Fields:
    allowedIssuers: A list of allowed JWT issuers. Each entry must be a valid
      Google service account, in the following format: `service-account-
      name@project-id.iam.gserviceaccount.com`
    audiences: The list of JWT [audiences](https://tools.ietf.org/html/draft-
      ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access.
      A JWT containing any of these audiences will be accepted.
  """

  allowedIssuers = _messages.StringField(1, repeated=True)
  audiences = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1DeployedIndexRef(_messages.Message):
  r"""Points to a DeployedIndex.

  Fields:
    deployedIndexId: Immutable. The ID of the DeployedIndex in the above
      IndexEndpoint.
    indexEndpoint: Immutable. A resource name of the IndexEndpoint.
  """

  deployedIndexId = _messages.StringField(1)
  indexEndpoint = _messages.StringField(2)


class GoogleCloudAiplatformV1DeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by Vertex AI, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    disableContainerLogging: For custom-trained Models and AutoML Tabular
      Models, the container of the DeployedModel instances will send `stderr`
      and `stdout` streams to Cloud Logging by default. Please note that the
      logs incur cost, which are subject to [Cloud Logging
      pricing](https://cloud.google.com/logging/pricing). User can disable
      container logging by setting this flag to true.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    enableAccessLogging: If true, online prediction access logs are sent to
      Cloud Logging. These logs are like standard server access logs,
      containing information like timestamp and latency for each prediction
      request. Note that logs may incur a cost, especially if your project
      receives prediction requests at a high queries per second rate (QPS).
      Estimate your costs before enabling this option.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. If the corresponding
      Model.explanation_spec is not populated, all fields of the
      explanation_spec will be used for the explanation configuration.
    id: Immutable. The ID of the DeployedModel. If not provided upon
      deployment, Vertex AI will generate a value for this ID. This value
      should be 1-10 characters, and valid characters are `/[0-9]/`.
    model: Required. The resource name of the Model that this is the
      deployment of. Note that the Model may be in a different location than
      the DeployedModel's Endpoint. The resource name may contain version id
      or version alias to specify the version. Example:
      `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` if no
      version is specified, the default version will be deployed.
    modelVersionId: Output only. The version ID of the model that is deployed.
    privateEndpoints: Output only. Provide paths for users to send
      predict/explain/health requests directly to the deployed model services
      running on Cloud via private services access. This field is populated if
      network is configured.
    serviceAccount: The service account that the DeployedModel's container
      runs as. Specify the email address of the service account. If this
      service account is not specified, the container runs as a service
      account that doesn't have access to the resource project. Users
      deploying the Model must have the `iam.serviceAccounts.actAs` permission
      on this service account.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1DedicatedResources', 3)
  disableContainerLogging = _messages.BooleanField(4)
  displayName = _messages.StringField(5)
  enableAccessLogging = _messages.BooleanField(6)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1ExplanationSpec', 7)
  id = _messages.StringField(8)
  model = _messages.StringField(9)
  modelVersionId = _messages.StringField(10)
  privateEndpoints = _messages.MessageField('GoogleCloudAiplatformV1PrivateEndpoints', 11)
  serviceAccount = _messages.StringField(12)


class GoogleCloudAiplatformV1DeployedModelRef(_messages.Message):
  r"""Points to a DeployedModel.

  Fields:
    deployedModelId: Immutable. An ID of a DeployedModel in the above
      Endpoint.
    endpoint: Immutable. A resource name of an Endpoint.
  """

  deployedModelId = _messages.StringField(1)
  endpoint = _messages.StringField(2)


class GoogleCloudAiplatformV1DestinationFeatureSetting(_messages.Message):
  r"""A GoogleCloudAiplatformV1DestinationFeatureSetting object.

  Fields:
    destinationField: Specify the field name in the export destination. If not
      specified, Feature ID is used.
    featureId: Required. The ID of the Feature to apply the setting to.
  """

  destinationField = _messages.StringField(1)
  featureId = _messages.StringField(2)


class GoogleCloudAiplatformV1DiskSpec(_messages.Message):
  r"""Represents the spec of disk options.

  Fields:
    bootDiskSizeGb: Size in GB of the boot disk (default is 100GB).
    bootDiskType: Type of the boot disk (default is "pd-ssd"). Valid values:
      "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard"
      (Persistent Disk Hard Disk Drive).
  """

  bootDiskSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  bootDiskType = _messages.StringField(2)


class GoogleCloudAiplatformV1DoubleArray(_messages.Message):
  r"""A list of double values.

  Fields:
    values: A list of double values.
  """

  values = _messages.FloatField(1, repeated=True)


class GoogleCloudAiplatformV1EncryptionSpec(_messages.Message):
  r"""Represents a customer-managed encryption key spec that can be applied to
  a top-level resource.

  Fields:
    kmsKeyName: Required. The Cloud KMS resource identifier of the customer
      managed encryption key used to protect a resource. Has the form:
      `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-
      key`. The key needs to be in the same region as where the compute
      resource is created.
  """

  kmsKeyName = _messages.StringField(1)


class GoogleCloudAiplatformV1Endpoint(_messages.Message):
  r"""Models are deployed into it, and afterwards Endpoint is called to obtain
  predictions and explanations.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Endpoints. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If a DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.

  Fields:
    createTime: Output only. Timestamp when this Endpoint was created.
    deployedModels: Output only. The models deployed in this Endpoint. To add
      or remove DeployedModels use EndpointService.DeployModel and
      EndpointService.UndeployModel respectively.
    description: The description of the Endpoint.
    displayName: Required. The display name of the Endpoint. The name can be
      up to 128 characters long and can consist of any UTF-8 characters.
    enablePrivateServiceConnect: Deprecated: If true, expose the Endpoint via
      private service connect. Only one of the fields, network or
      enable_private_service_connect, can be set.
    encryptionSpec: Customer-managed encryption key spec for an Endpoint. If
      set, this Endpoint and all sub-resources of this Endpoint will be
      secured by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Endpoints.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    modelDeploymentMonitoringJob: Output only. Resource name of the Model
      Monitoring job associated with this Endpoint if monitoring is enabled by
      JobService.CreateModelDeploymentMonitoringJob. Format: `projects/{projec
      t}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_
      monitoring_job}`
    name: Output only. The resource name of the Endpoint.
    network: Optional. The full name of the Google Compute Engine
      [network](https://cloud.google.com//compute/docs/networks-and-
      firewalls#networks) to which the Endpoint should be peered. Private
      services access must already be configured for the network. If left
      unspecified, the Endpoint is not peered with any network. Only one of
      the fields, network or enable_private_service_connect, can be set. [Form
      at](https://cloud.google.com/compute/docs/reference/rest/v1/networks/ins
      ert): `projects/{project}/global/networks/{network}`. Where `{project}`
      is a project number, as in `12345`, and `{network}` is network name.
    predictRequestResponseLoggingConfig: Configures the request-response
      logging for online prediction.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If a
      DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.
    updateTime: Output only. Timestamp when this Endpoint was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Endpoints.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If a
    DeployedModel's ID is not listed in this map, then it receives no traffic.
    The traffic percentage values must add up to 100, or map must be empty if
    the Endpoint is to not accept any traffic at a moment.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deployedModels = _messages.MessageField('GoogleCloudAiplatformV1DeployedModel', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  enablePrivateServiceConnect = _messages.BooleanField(5)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  modelDeploymentMonitoringJob = _messages.StringField(9)
  name = _messages.StringField(10)
  network = _messages.StringField(11)
  predictRequestResponseLoggingConfig = _messages.MessageField('GoogleCloudAiplatformV1PredictRequestResponseLoggingConfig', 12)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 13)
  updateTime = _messages.StringField(14)


class GoogleCloudAiplatformV1EntityIdSelector(_messages.Message):
  r"""Selector for entityId. Getting ids from the given source.

  Fields:
    csvSource: Source of Csv
    entityIdField: Source column that holds entity IDs. If not provided,
      entity IDs are extracted from the column named entity_id.
  """

  csvSource = _messages.MessageField('GoogleCloudAiplatformV1CsvSource', 1)
  entityIdField = _messages.StringField(2)


class GoogleCloudAiplatformV1EntityType(_messages.Message):
  r"""An entity type is a type of object in a system that needs to be modeled
  and have stored information about. For example, driver is an entity type,
  and driver0 is an instance of an entity type driver.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your EntityTypes. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      EntityType (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this EntityType was created.
    description: Optional. Description of the EntityType.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      EntityTypes. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      EntityType (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    monitoringConfig: Optional. The default monitoring configuration for all
      Features with value type (Feature.ValueType) BOOL, STRING, DOUBLE or
      INT64 under this EntityType. If this is populated with
      [FeaturestoreMonitoringConfig.monitoring_interval] specified, snapshot
      analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
      is disabled.
    name: Immutable. Name of the EntityType. Format: `projects/{project}/locat
      ions/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
      The last part entity_type is assigned by the client. The entity_type can
      be up to 64 characters long and can consist only of ASCII Latin letters
      A-Z and a-z and underscore(_), and ASCII digits 0-9 starting with a
      letter. The value will be unique given a featurestore.
    updateTime: Output only. Timestamp when this EntityType was most recently
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    EntityTypes. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one EntityType (System
    labels are excluded)." System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  monitoringConfig = _messages.MessageField('GoogleCloudAiplatformV1FeaturestoreMonitoringConfig', 5)
  name = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class GoogleCloudAiplatformV1EnvVar(_messages.Message):
  r"""Represents an environment variable present in a Container or Python
  Module.

  Fields:
    name: Required. Name of the environment variable. Must be a valid C
      identifier.
    value: Required. Variables that reference a $(VAR_NAME) are expanded using
      the previous defined environment variables in the container and any
      service environment variables. If a variable cannot be resolved, the
      reference in the input string will be unchanged. The $(VAR_NAME) syntax
      can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references
      will never be expanded, regardless of whether the variable exists or
      not.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleCloudAiplatformV1ErrorAnalysisAnnotation(_messages.Message):
  r"""Model error analysis for each annotation.

  Enums:
    QueryTypeValueValuesEnum: The query type used for finding the attributed
      items.

  Fields:
    attributedItems: Attributed items for a given annotation, typically
      representing neighbors from the training sets constrained by the query
      type.
    outlierScore: The outlier score of this annotated item. Usually defined as
      the min of all distances from attributed items.
    outlierThreshold: The threshold used to determine if this annotation is an
      outlier or not.
    queryType: The query type used for finding the attributed items.
  """

  class QueryTypeValueValuesEnum(_messages.Enum):
    r"""The query type used for finding the attributed items.

    Values:
      QUERY_TYPE_UNSPECIFIED: Unspecified query type for model error analysis.
      ALL_SIMILAR: Query similar samples across all classes in the dataset.
      SAME_CLASS_SIMILAR: Query similar samples from the same class of the
        input sample.
      SAME_CLASS_DISSIMILAR: Query dissimilar samples from the same class of
        the input sample.
    """
    QUERY_TYPE_UNSPECIFIED = 0
    ALL_SIMILAR = 1
    SAME_CLASS_SIMILAR = 2
    SAME_CLASS_DISSIMILAR = 3

  attributedItems = _messages.MessageField('GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem', 1, repeated=True)
  outlierScore = _messages.FloatField(2)
  outlierThreshold = _messages.FloatField(3)
  queryType = _messages.EnumField('QueryTypeValueValuesEnum', 4)


class GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem(_messages.Message):
  r"""Attributed items for a given annotation, typically representing
  neighbors from the training sets constrained by the query type.

  Fields:
    annotationResourceName: The unique ID for each annotation. Used by FE to
      allocate the annotation in DB.
    distance: The distance of this item to the annotation.
  """

  annotationResourceName = _messages.StringField(1)
  distance = _messages.FloatField(2)


class GoogleCloudAiplatformV1EvaluatedAnnotation(_messages.Message):
  r"""True positive, false positive, or false negative. EvaluatedAnnotation is
  only available under ModelEvaluationSlice with slice of `annotationSpec`
  dimension.

  Enums:
    TypeValueValuesEnum: Output only. Type of the EvaluatedAnnotation.

  Fields:
    dataItemPayload: Output only. The data item payload that the Model
      predicted this EvaluatedAnnotation on.
    errorAnalysisAnnotations: Annotations of model error analysis results.
    evaluatedDataItemViewId: Output only. ID of the EvaluatedDataItemView
      under the same ancestor ModelEvaluation. The EvaluatedDataItemView
      consists of all ground truths and predictions on data_item_payload.
    explanations: Explanations of predictions. Each element of the
      explanations indicates the explanation for one explanation Method. The
      attributions list in the EvaluatedAnnotationExplanation.explanation
      object corresponds to the predictions list. For example, the second
      element in the attributions list explains the second element in the
      predictions list.
    groundTruths: Output only. The ground truth Annotations, i.e. the
      Annotations that exist in the test data the Model is evaluated on. For
      true positive, there is one and only one ground truth annotation, which
      matches the only prediction in predictions. For false positive, there
      are zero or more ground truth annotations that are similar to the only
      prediction in predictions, but not enough for a match. For false
      negative, there is one and only one ground truth annotation, which
      doesn't match any predictions created by the model. The schema of the
      ground truth is stored in ModelEvaluation.annotation_schema_uri
    predictions: Output only. The model predicted annotations. For true
      positive, there is one and only one prediction, which matches the only
      one ground truth annotation in ground_truths. For false positive, there
      is one and only one prediction, which doesn't match any ground truth
      annotation of the corresponding data_item_view_id. For false negative,
      there are zero or more predictions which are similar to the only ground
      truth annotation in ground_truths but not enough for a match. The schema
      of the prediction is stored in ModelEvaluation.annotation_schema_uri
    type: Output only. Type of the EvaluatedAnnotation.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of the EvaluatedAnnotation.

    Values:
      EVALUATED_ANNOTATION_TYPE_UNSPECIFIED: Invalid value.
      TRUE_POSITIVE: The EvaluatedAnnotation is a true positive. It has a
        prediction created by the Model and a ground truth Annotation which
        the prediction matches.
      FALSE_POSITIVE: The EvaluatedAnnotation is false positive. It has a
        prediction created by the Model which does not match any ground truth
        annotation.
      FALSE_NEGATIVE: The EvaluatedAnnotation is false negative. It has a
        ground truth annotation which is not matched by any of the model
        created predictions.
    """
    EVALUATED_ANNOTATION_TYPE_UNSPECIFIED = 0
    TRUE_POSITIVE = 1
    FALSE_POSITIVE = 2
    FALSE_NEGATIVE = 3

  dataItemPayload = _messages.MessageField('extra_types.JsonValue', 1)
  errorAnalysisAnnotations = _messages.MessageField('GoogleCloudAiplatformV1ErrorAnalysisAnnotation', 2, repeated=True)
  evaluatedDataItemViewId = _messages.StringField(3)
  explanations = _messages.MessageField('GoogleCloudAiplatformV1EvaluatedAnnotationExplanation', 4, repeated=True)
  groundTruths = _messages.MessageField('extra_types.JsonValue', 5, repeated=True)
  predictions = _messages.MessageField('extra_types.JsonValue', 6, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class GoogleCloudAiplatformV1EvaluatedAnnotationExplanation(_messages.Message):
  r"""Explanation result of the prediction produced by the Model.

  Fields:
    explanation: Explanation attribution response details.
    explanationType: Explanation type. For AutoML Image Classification models,
      possible values are: * `image-integrated-gradients` * `image-xrai`
  """

  explanation = _messages.MessageField('GoogleCloudAiplatformV1Explanation', 1)
  explanationType = _messages.StringField(2)


class GoogleCloudAiplatformV1Event(_messages.Message):
  r"""An edge describing the relationship between an Artifact and an Execution
  in a lineage graph.

  Enums:
    TypeValueValuesEnum: Required. The type of the Event.

  Messages:
    LabelsValue: The labels with user-defined metadata to annotate Events.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Event (System labels are
      excluded). See https://goo.gl/xmQnxf for more information and examples
      of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.

  Fields:
    artifact: Required. The relative resource name of the Artifact in the
      Event.
    eventTime: Output only. Time the Event occurred.
    execution: Output only. The relative resource name of the Execution in the
      Event.
    labels: The labels with user-defined metadata to annotate Events. Label
      keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Event (System labels are
      excluded). See https://goo.gl/xmQnxf for more information and examples
      of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    type: Required. The type of the Event.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the Event.

    Values:
      TYPE_UNSPECIFIED: Unspecified whether input or output of the Execution.
      INPUT: An input of the Execution.
      OUTPUT: An output of the Execution.
    """
    TYPE_UNSPECIFIED = 0
    INPUT = 1
    OUTPUT = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to annotate Events. Label keys
    and values can be no longer than 64 characters (Unicode codepoints), can
    only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Event (System labels are excluded). See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifact = _messages.StringField(1)
  eventTime = _messages.StringField(2)
  execution = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class GoogleCloudAiplatformV1Examples(_messages.Message):
  r"""Example-based explainability that returns the nearest neighbors from the
  provided dataset.

  Fields:
    exampleGcsSource: The Cloud Storage input instances.
    nearestNeighborSearchConfig: The full configuration for the generated
      index, the semantics are the same as metadata and should match
      [NearestNeighborSearchConfig](https://cloud.google.com/vertex-
      ai/docs/explainable-ai/configuring-explanations-example-based#nearest-
      neighbor-search-config).
    neighborCount: The number of neighbors to return when querying for
      examples.
    presets: Simplified preset configuration, which automatically sets
      configuration values based on the desired query speed-precision trade-
      off and modality.
  """

  exampleGcsSource = _messages.MessageField('GoogleCloudAiplatformV1ExamplesExampleGcsSource', 1)
  nearestNeighborSearchConfig = _messages.MessageField('extra_types.JsonValue', 2)
  neighborCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  presets = _messages.MessageField('GoogleCloudAiplatformV1Presets', 4)


class GoogleCloudAiplatformV1ExamplesExampleGcsSource(_messages.Message):
  r"""The Cloud Storage input instances.

  Enums:
    DataFormatValueValuesEnum: The format in which instances are given, if not
      specified, assume it's JSONL format. Currently only JSONL format is
      supported.

  Fields:
    dataFormat: The format in which instances are given, if not specified,
      assume it's JSONL format. Currently only JSONL format is supported.
    gcsSource: The Cloud Storage location for the input instances.
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""The format in which instances are given, if not specified, assume it's
    JSONL format. Currently only JSONL format is supported.

    Values:
      DATA_FORMAT_UNSPECIFIED: Format unspecified, used when unset.
      JSONL: Examples are stored in JSONL files.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSONL = 1

  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1GcsSource', 2)


class GoogleCloudAiplatformV1ExamplesOverride(_messages.Message):
  r"""Overrides for example-based explanations.

  Enums:
    DataFormatValueValuesEnum: The format of the data being provided with each
      call.

  Fields:
    crowdingCount: The number of neighbors to return that have the same
      crowding tag.
    dataFormat: The format of the data being provided with each call.
    neighborCount: The number of neighbors to return.
    restrictions: Restrict the resulting nearest neighbors to respect these
      constraints.
    returnEmbeddings: If true, return the embeddings instead of neighbors.
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""The format of the data being provided with each call.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format. Must not be used.
      INSTANCES: Provided data is a set of model inputs.
      EMBEDDINGS: Provided data is a set of embeddings.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    INSTANCES = 1
    EMBEDDINGS = 2

  crowdingCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 2)
  neighborCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  restrictions = _messages.MessageField('GoogleCloudAiplatformV1ExamplesRestrictionsNamespace', 4, repeated=True)
  returnEmbeddings = _messages.BooleanField(5)


class GoogleCloudAiplatformV1ExamplesRestrictionsNamespace(_messages.Message):
  r"""Restrictions namespace for example-based explanations overrides.

  Fields:
    allow: The list of allowed tags.
    deny: The list of deny tags.
    namespaceName: The namespace name.
  """

  allow = _messages.StringField(1, repeated=True)
  deny = _messages.StringField(2, repeated=True)
  namespaceName = _messages.StringField(3)


class GoogleCloudAiplatformV1Execution(_messages.Message):
  r"""Instance of a general execution.

  Enums:
    StateValueValuesEnum: The state of this Execution. This is a property of
      the Execution, and does not imply or capture any ongoing process. This
      property is managed by clients (such as Vertex AI Pipelines) and the
      system does not prescribe or check the validity of state transitions.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Executions. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Execution (System labels are excluded).
    MetadataValue: Properties of the Execution. Top level metadata keys'
      heading and trailing spaces will be trimmed. The size of this field
      should not exceed 200KB.

  Fields:
    createTime: Output only. Timestamp when this Execution was created.
    description: Description of the Execution
    displayName: User provided display name of the Execution. May be up to 128
      Unicode characters.
    etag: An eTag used to perform consistent read-modify-write updates. If not
      set, a blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Executions.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Execution (System labels
      are excluded).
    metadata: Properties of the Execution. Top level metadata keys' heading
      and trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.
    name: Output only. The resource name of the Execution.
    schemaTitle: The title of the schema describing the metadata. Schema title
      and version is expected to be registered in earlier Create Schema calls.
      And both are used together as unique identifiers to identify schemas
      within the local metadata store.
    schemaVersion: The version of the schema in `schema_title` to use. Schema
      title and version is expected to be registered in earlier Create Schema
      calls. And both are used together as unique identifiers to identify
      schemas within the local metadata store.
    state: The state of this Execution. This is a property of the Execution,
      and does not imply or capture any ongoing process. This property is
      managed by clients (such as Vertex AI Pipelines) and the system does not
      prescribe or check the validity of state transitions.
    updateTime: Output only. Timestamp when this Execution was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of this Execution. This is a property of the Execution, and
    does not imply or capture any ongoing process. This property is managed by
    clients (such as Vertex AI Pipelines) and the system does not prescribe or
    check the validity of state transitions.

    Values:
      STATE_UNSPECIFIED: Unspecified Execution state
      NEW: The Execution is new
      RUNNING: The Execution is running
      COMPLETE: The Execution has finished running
      FAILED: The Execution has failed
      CACHED: The Execution completed through Cache hit.
      CANCELLED: The Execution was cancelled.
    """
    STATE_UNSPECIFIED = 0
    NEW = 1
    RUNNING = 2
    COMPLETE = 3
    FAILED = 4
    CACHED = 5
    CANCELLED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Executions.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. No more than
    64 user labels can be associated with one Execution (System labels are
    excluded).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Properties of the Execution. Top level metadata keys' heading and
    trailing spaces will be trimmed. The size of this field should not exceed
    200KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  name = _messages.StringField(7)
  schemaTitle = _messages.StringField(8)
  schemaVersion = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class GoogleCloudAiplatformV1ExplainRequest(_messages.Message):
  r"""Request message for PredictionService.Explain.

  Fields:
    deployedModelId: If specified, this ExplainRequest will be served by the
      chosen DeployedModel, overriding Endpoint.traffic_split.
    explanationSpecOverride: If specified, overrides the explanation_spec of
      the DeployedModel. Can be used for explaining prediction results with
      different configurations, such as: - Explaining top-5 predictions
      results as opposed to top-1; - Increasing path count or step count of
      the attribution methods to reduce approximate errors; - Using different
      baselines for explaining the prediction results.
    instances: Required. The instances that are the input to the explanation
      call. A DeployedModel may have an upper limit on the number of instances
      it supports per request, and when it is exceeded the explanation call
      errors in case of AutoML Models, or, in case of customer created Models,
      the behaviour is as documented by that Model. The schema of any single
      instance may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's instance_schema_uri.
    parameters: The parameters that govern the prediction. The schema of the
      parameters may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's parameters_schema_uri.
  """

  deployedModelId = _messages.StringField(1)
  explanationSpecOverride = _messages.MessageField('GoogleCloudAiplatformV1ExplanationSpecOverride', 2)
  instances = _messages.MessageField('extra_types.JsonValue', 3, repeated=True)
  parameters = _messages.MessageField('extra_types.JsonValue', 4)


class GoogleCloudAiplatformV1ExplainResponse(_messages.Message):
  r"""Response message for PredictionService.Explain.

  Fields:
    deployedModelId: ID of the Endpoint's DeployedModel that served this
      explanation.
    explanations: The explanations of the Model's PredictResponse.predictions.
      It has the same number of elements as instances to be explained.
    predictions: The predictions that are the output of the predictions call.
      Same as PredictResponse.predictions.
  """

  deployedModelId = _messages.StringField(1)
  explanations = _messages.MessageField('GoogleCloudAiplatformV1Explanation', 2, repeated=True)
  predictions = _messages.MessageField('extra_types.JsonValue', 3, repeated=True)


class GoogleCloudAiplatformV1Explanation(_messages.Message):
  r"""Explanation of a prediction (provided in PredictResponse.predictions)
  produced by the Model on a given instance.

  Fields:
    attributions: Output only. Feature attributions grouped by predicted
      outputs. For Models that predict only one output, such as regression
      Models that predict only one score, there is only one attibution that
      explains the predicted output. For Models that predict multiple outputs,
      such as multiclass Models that predict multiple classes, each element
      explains one specific item. Attribution.output_index can be used to
      identify which output this attribution is explaining. If users set
      ExplanationParameters.top_k, the attributions are sorted by
      instance_output_value in descending order. If
      ExplanationParameters.output_indices is specified, the attributions are
      stored by Attribution.output_index in the same order as they appear in
      the output_indices.
    neighbors: Output only. List of the nearest neighbors for example-based
      explanations. For models deployed with the examples explanations feature
      enabled, the attributions field is empty and instead the neighbors field
      is populated.
  """

  attributions = _messages.MessageField('GoogleCloudAiplatformV1Attribution', 1, repeated=True)
  neighbors = _messages.MessageField('GoogleCloudAiplatformV1Neighbor', 2, repeated=True)


class GoogleCloudAiplatformV1ExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by Vertex AI. For Vertex AI-
      provided Tensorflow images, the key can be any friendly name of the
      feature. Once specified, featureAttributions are keyed by this key (if
      not grouped with another feature). For custom images, the key must match
      with the key in instance.
    OutputsValue: Required. Map from output names to output metadata. For
      Vertex AI-provided Tensorflow images, keys can be any user defined
      string that consists of any UTF-8 characters. For custom images, keys
      are the name of the output field in the prediction to be explained.
      Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML tabular
      Models always have this field populated by Vertex AI. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by Vertex AI. For Vertex AI-
      provided Tensorflow images, the key can be any friendly name of the
      feature. Once specified, featureAttributions are keyed by this key (if
      not grouped with another feature). For custom images, the key must match
      with the key in instance.
    latentSpaceSource: Name of the source to generate embeddings for example
      based explanations.
    outputs: Required. Map from output names to output metadata. For Vertex
      AI-provided Tensorflow images, keys can be any user defined string that
      consists of any UTF-8 characters. For custom images, keys are the name
      of the output field in the prediction to be explained. Currently only
      one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by Vertex AI. For Vertex AI-provided
    Tensorflow images, the key can be any friendly name of the feature. Once
    specified, featureAttributions are keyed by this key (if not grouped with
    another feature). For custom images, the key must match with the key in
    instance.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1ExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. For Vertex AI-
    provided Tensorflow images, keys can be any user defined string that
    consists of any UTF-8 characters. For custom images, keys are the name of
    the output field in the prediction to be explained. Currently only one key
    is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  latentSpaceSource = _messages.StringField(3)
  outputs = _messages.MessageField('OutputsValue', 4)


class GoogleCloudAiplatformV1ExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature. Fields other than
  InputMetadata.input_baselines are applicable only for Models that are using
  Vertex AI-provided images for Tensorflow.

  Enums:
    EncodingValueValuesEnum: Defines how the feature is encoded into the input
      tensor. Defaults to IDENTITY.

  Fields:
    denseShapeTensorName: Specifies the shape of the values of the input if
      the input is a sparse representation. Refer to Tensorflow documentation
      for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    encodedBaselines: A list of baselines for the encoded tensor. The shape of
      each baseline should match the shape of the encoded tensor. If a scalar
      is provided, Vertex AI broadcasts to the same shape as the encoded
      tensor.
    encodedTensorName: Encoded tensor is a transformation of the input tensor.
      Must be provided if choosing Integrated Gradients attribution or XRAI
      attribution and the input tensor is not differentiable. An encoded
      tensor is generated if the input tensor is encoded by a lookup table.
    encoding: Defines how the feature is encoded into the input tensor.
      Defaults to IDENTITY.
    featureValueDomain: The domain details of the input feature value. Like
      min/max, original mean or standard deviation if normalized.
    groupName: Name of the group that the input belongs to. Features with the
      same group name will be treated as one feature when computing
      attributions. Features grouped together can have different shapes in
      value. If provided, there will be one single attribution generated in
      Attribution.feature_attributions, keyed by the group name.
    indexFeatureMapping: A list of feature names for each index in the input
      tensor. Required when the input InputMetadata.encoding is
      BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
    indicesTensorName: Specifies the index of the values of the input tensor.
      Required when the input tensor is a sparse representation. Refer to
      Tensorflow documentation for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, Vertex AI chooses the baseline for this feature. If multiple
      baselines are specified, Vertex AI returns the average attributions
      across them in Attribution.feature_attributions. For Vertex AI-provided
      Tensorflow images (both 1.x and 2.x), the shape of each baseline must
      match the shape of the input tensor. If a scalar is provided, we
      broadcast to the same shape as the input tensor. For custom images, the
      element of the baselines must be in the same format as the feature's
      input in the instance[]. The schema of any single instance may be
      specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
    inputTensorName: Name of the input tensor for this feature. Required and
      is only applicable to Vertex AI-provided images for Tensorflow.
    modality: Modality of the feature. Valid values are: numeric, image.
      Defaults to numeric.
    visualization: Visualization configurations for image explanation.
  """

  class EncodingValueValuesEnum(_messages.Enum):
    r"""Defines how the feature is encoded into the input tensor. Defaults to
    IDENTITY.

    Values:
      ENCODING_UNSPECIFIED: Default value. This is the same as IDENTITY.
      IDENTITY: The tensor represents one feature.
      BAG_OF_FEATURES: The tensor represents a bag of features where each
        index maps to a feature. InputMetadata.index_feature_mapping must be
        provided for this encoding. For example: ``` input = [27, 6.0, 150]
        index_feature_mapping = ["age", "height", "weight"] ```
      BAG_OF_FEATURES_SPARSE: The tensor represents a bag of features where
        each index maps to a feature. Zero values in the tensor indicates
        feature being non-existent. InputMetadata.index_feature_mapping must
        be provided for this encoding. For example: ``` input = [2, 0, 5, 0,
        1] index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      INDICATOR: The tensor is a list of binaries representing whether a
        feature exists or not (1 indicates existence).
        InputMetadata.index_feature_mapping must be provided for this
        encoding. For example: ``` input = [1, 0, 1, 0, 1]
        index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      COMBINED_EMBEDDING: The tensor is encoded into a 1-dimensional array
        represented by an encoded tensor. InputMetadata.encoded_tensor_name
        must be provided for this encoding. For example: ``` input = ["This",
        "is", "a", "test", "."] encoded = [0.1, 0.2, 0.3, 0.4, 0.5] ```
      CONCAT_EMBEDDING: Select this encoding when the input tensor is encoded
        into a 2-dimensional array represented by an encoded tensor.
        InputMetadata.encoded_tensor_name must be provided for this encoding.
        The first dimension of the encoded tensor's shape is the same as the
        input tensor's shape. For example: ``` input = ["This", "is", "a",
        "test", "."] encoded = [[0.1, 0.2, 0.3, 0.4, 0.5], [0.2, 0.1, 0.4,
        0.3, 0.5], [0.5, 0.1, 0.3, 0.5, 0.4], [0.5, 0.3, 0.1, 0.2, 0.4], [0.4,
        0.3, 0.2, 0.5, 0.1]] ```
    """
    ENCODING_UNSPECIFIED = 0
    IDENTITY = 1
    BAG_OF_FEATURES = 2
    BAG_OF_FEATURES_SPARSE = 3
    INDICATOR = 4
    COMBINED_EMBEDDING = 5
    CONCAT_EMBEDDING = 6

  denseShapeTensorName = _messages.StringField(1)
  encodedBaselines = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  encodedTensorName = _messages.StringField(3)
  encoding = _messages.EnumField('EncodingValueValuesEnum', 4)
  featureValueDomain = _messages.MessageField('GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain', 5)
  groupName = _messages.StringField(6)
  indexFeatureMapping = _messages.StringField(7, repeated=True)
  indicesTensorName = _messages.StringField(8)
  inputBaselines = _messages.MessageField('extra_types.JsonValue', 9, repeated=True)
  inputTensorName = _messages.StringField(10)
  modality = _messages.StringField(11)
  visualization = _messages.MessageField('GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization', 12)


class GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain(_messages.Message):
  r"""Domain details of the input feature value. Provides numeric information
  about the feature, such as its range (min, max). If the feature has been
  pre-processed, for example with z-scoring, then it provides information
  about how to recover the original feature. For example, if the input feature
  is an image and it has been pre-processed to obtain 0-mean and stddev = 1
  values, then original_mean, and original_stddev refer to the mean and stddev
  of the original feature (e.g. image tensor) from which input feature (with
  mean = 0 and stddev = 1) was obtained.

  Fields:
    maxValue: The maximum permissible value for this feature.
    minValue: The minimum permissible value for this feature.
    originalMean: If this input feature has been normalized to a mean value of
      0, the original_mean specifies the mean value of the domain prior to
      normalization.
    originalStddev: If this input feature has been normalized to a standard
      deviation of 1.0, the original_stddev specifies the standard deviation
      of the domain prior to normalization.
  """

  maxValue = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  minValue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  originalMean = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  originalStddev = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization(_messages.Message):
  r"""Visualization configurations for image explanation.

  Enums:
    ColorMapValueValuesEnum: The color scheme used for the highlighted areas.
      Defaults to PINK_GREEN for Integrated Gradients attribution, which shows
      positive attributions in green and negative in pink. Defaults to VIRIDIS
      for XRAI attribution, which highlights the most influential regions in
      yellow and the least influential in blue.
    OverlayTypeValueValuesEnum: How the original image is displayed in the
      visualization. Adjusting the overlay can help increase visual clarity if
      the original image makes it difficult to view the visualization.
      Defaults to NONE.
    PolarityValueValuesEnum: Whether to only highlight pixels with positive
      contributions, negative or both. Defaults to POSITIVE.
    TypeValueValuesEnum: Type of the image visualization. Only applicable to
      Integrated Gradients attribution. OUTLINES shows regions of attribution,
      while PIXELS shows per-pixel attribution. Defaults to OUTLINES.

  Fields:
    clipPercentLowerbound: Excludes attributions below the specified
      percentile, from the highlighted areas. Defaults to 62.
    clipPercentUpperbound: Excludes attributions above the specified
      percentile from the highlighted areas. Using the clip_percent_upperbound
      and clip_percent_lowerbound together can be useful for filtering out
      noise and making it easier to see areas of strong attribution. Defaults
      to 99.9.
    colorMap: The color scheme used for the highlighted areas. Defaults to
      PINK_GREEN for Integrated Gradients attribution, which shows positive
      attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
      attribution, which highlights the most influential regions in yellow and
      the least influential in blue.
    overlayType: How the original image is displayed in the visualization.
      Adjusting the overlay can help increase visual clarity if the original
      image makes it difficult to view the visualization. Defaults to NONE.
    polarity: Whether to only highlight pixels with positive contributions,
      negative or both. Defaults to POSITIVE.
    type: Type of the image visualization. Only applicable to Integrated
      Gradients attribution. OUTLINES shows regions of attribution, while
      PIXELS shows per-pixel attribution. Defaults to OUTLINES.
  """

  class ColorMapValueValuesEnum(_messages.Enum):
    r"""The color scheme used for the highlighted areas. Defaults to
    PINK_GREEN for Integrated Gradients attribution, which shows positive
    attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
    attribution, which highlights the most influential regions in yellow and
    the least influential in blue.

    Values:
      COLOR_MAP_UNSPECIFIED: Should not be used.
      PINK_GREEN: Positive: green. Negative: pink.
      VIRIDIS: Viridis color map: A perceptually uniform color mapping which
        is easier to see by those with colorblindness and progresses from
        yellow to green to blue. Positive: yellow. Negative: blue.
      RED: Positive: red. Negative: red.
      GREEN: Positive: green. Negative: green.
      RED_GREEN: Positive: green. Negative: red.
      PINK_WHITE_GREEN: PiYG palette.
    """
    COLOR_MAP_UNSPECIFIED = 0
    PINK_GREEN = 1
    VIRIDIS = 2
    RED = 3
    GREEN = 4
    RED_GREEN = 5
    PINK_WHITE_GREEN = 6

  class OverlayTypeValueValuesEnum(_messages.Enum):
    r"""How the original image is displayed in the visualization. Adjusting
    the overlay can help increase visual clarity if the original image makes
    it difficult to view the visualization. Defaults to NONE.

    Values:
      OVERLAY_TYPE_UNSPECIFIED: Default value. This is the same as NONE.
      NONE: No overlay.
      ORIGINAL: The attributions are shown on top of the original image.
      GRAYSCALE: The attributions are shown on top of grayscaled version of
        the original image.
      MASK_BLACK: The attributions are used as a mask to reveal predictive
        parts of the image and hide the un-predictive parts.
    """
    OVERLAY_TYPE_UNSPECIFIED = 0
    NONE = 1
    ORIGINAL = 2
    GRAYSCALE = 3
    MASK_BLACK = 4

  class PolarityValueValuesEnum(_messages.Enum):
    r"""Whether to only highlight pixels with positive contributions, negative
    or both. Defaults to POSITIVE.

    Values:
      POLARITY_UNSPECIFIED: Default value. This is the same as POSITIVE.
      POSITIVE: Highlights the pixels/outlines that were most influential to
        the model's prediction.
      NEGATIVE: Setting polarity to negative highlights areas that does not
        lead to the models's current prediction.
      BOTH: Shows both positive and negative attributions.
    """
    POLARITY_UNSPECIFIED = 0
    POSITIVE = 1
    NEGATIVE = 2
    BOTH = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the image visualization. Only applicable to Integrated
    Gradients attribution. OUTLINES shows regions of attribution, while PIXELS
    shows per-pixel attribution. Defaults to OUTLINES.

    Values:
      TYPE_UNSPECIFIED: Should not be used.
      PIXELS: Shows which pixel contributed to the image prediction.
      OUTLINES: Shows which region contributed to the image prediction by
        outlining the region.
    """
    TYPE_UNSPECIFIED = 0
    PIXELS = 1
    OUTLINES = 2

  clipPercentLowerbound = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  clipPercentUpperbound = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  colorMap = _messages.EnumField('ColorMapValueValuesEnum', 3)
  overlayType = _messages.EnumField('OverlayTypeValueValuesEnum', 4)
  polarity = _messages.EnumField('PolarityValueValuesEnum', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)


class GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimensions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
    outputTensorName: Name of the output tensor. Required and is only
      applicable to Vertex AI provided images for Tensorflow.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)
  outputTensorName = _messages.StringField(3)


class GoogleCloudAiplatformV1ExplanationMetadataOverride(_messages.Message):
  r"""The ExplanationMetadata entries that can be overridden at online
  explanation time.

  Messages:
    InputsValue: Required. Overrides the input metadata of the features. The
      key is the name of the feature to be overridden. The keys specified here
      must exist in the input metadata to be overridden. If a feature is not
      specified here, the corresponding feature's input metadata is not
      overridden.

  Fields:
    inputs: Required. Overrides the input metadata of the features. The key is
      the name of the feature to be overridden. The keys specified here must
      exist in the input metadata to be overridden. If a feature is not
      specified here, the corresponding feature's input metadata is not
      overridden.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Overrides the input metadata of the features. The key is the
    name of the feature to be overridden. The keys specified here must exist
    in the input metadata to be overridden. If a feature is not specified
    here, the corresponding feature's input metadata is not overridden.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetada
          taOverride attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  inputs = _messages.MessageField('InputsValue', 1)


class GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride(_messages.Message):
  r"""The input metadata entries to be overridden.

  Fields:
    inputBaselines: Baseline inputs for this feature. This overrides the
      `input_baseline` field of the ExplanationMetadata.InputMetadata object
      of the corresponding feature's input metadata. If it's not specified,
      the original baselines are not overridden.
  """

  inputBaselines = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)


class GoogleCloudAiplatformV1ExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    examples: Example-based explanations that returns the nearest neighbors
      from the provided dataset.
    integratedGradientsAttribution: An attribution method that computes
      Aumann-Shapley values taking advantage of the model's fully
      differentiable structure. Refer to this paper for more details:
      https://arxiv.org/abs/1703.01365
    outputIndices: If populated, only returns attributions that have
      output_index contained in output_indices. It must be an ndarray of
      integers, with the same shape of the output it's explaining. If not
      populated, returns attributions for top_k indices of outputs. If neither
      top_k nor output_indices is populated, returns the argmax index of the
      outputs. Only applicable to Models that predict multiple outputs (e,g,
      multi-class Models that predict multiple classes).
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features. Refer to this paper for model
      details: https://arxiv.org/abs/1306.4265.
    topK: If populated, returns attributions for top K indices of outputs
      (defaults to 1). Only applies to Models that predicts more than one
      outputs (e,g, multi-class Models). When set to -1, returns explanations
      for all outputs.
    xraiAttribution: An attribution method that redistributes Integrated
      Gradients attribution to segmented regions, taking advantage of the
      model's fully differentiable structure. Refer to this paper for more
      details: https://arxiv.org/abs/1906.02825 XRAI currently performs better
      on natural images, like a picture of a house or an animal. If the images
      are taken in artificial environments, like a lab or manufacturing line,
      or from diagnostic equipment, like x-rays or quality-control cameras,
      use Integrated Gradients instead.
  """

  examples = _messages.MessageField('GoogleCloudAiplatformV1Examples', 1)
  integratedGradientsAttribution = _messages.MessageField('GoogleCloudAiplatformV1IntegratedGradientsAttribution', 2)
  outputIndices = _messages.MessageField('extra_types.JsonValue', 3, repeated=True)
  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformV1SampledShapleyAttribution', 4)
  topK = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  xraiAttribution = _messages.MessageField('GoogleCloudAiplatformV1XraiAttribution', 6)


class GoogleCloudAiplatformV1ExplanationSpec(_messages.Message):
  r"""Specification of Model explanation.

  Fields:
    metadata: Optional. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformV1ExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1ExplanationParameters', 2)


class GoogleCloudAiplatformV1ExplanationSpecOverride(_messages.Message):
  r"""The ExplanationSpec entries that can be overridden at online explanation
  time.

  Fields:
    examplesOverride: The example-based explanations parameter overrides.
    metadata: The metadata to be overridden. If not specified, no metadata is
      overridden.
    parameters: The parameters to be overridden. Note that the attribution
      method cannot be changed. If not specified, no parameter is overridden.
  """

  examplesOverride = _messages.MessageField('GoogleCloudAiplatformV1ExamplesOverride', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1ExplanationMetadataOverride', 2)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1ExplanationParameters', 3)


class GoogleCloudAiplatformV1ExportDataConfig(_messages.Message):
  r"""Describes what part of the Dataset is to be exported, the destination of
  the export and how to export.

  Fields:
    annotationsFilter: An expression for filtering what part of the Dataset is
      to be exported. Only Annotations that match this filter will be
      exported. The filter syntax is the same as in ListAnnotations.
    gcsDestination: The Google Cloud Storage location where the output is to
      be written to. In the given directory a new directory will be created
      with name: `export-data--` where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format. All export output will be written into
      that directory. Inside that directory, annotations with the same schema
      will be grouped into sub directories which are named with the
      corresponding annotations' schema title. Inside these sub directories, a
      schema.yaml will be created to describe the output format.
  """

  annotationsFilter = _messages.StringField(1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 2)


class GoogleCloudAiplatformV1ExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1ExportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ExportData.

  Fields:
    exportConfig: Required. The desired output location.
  """

  exportConfig = _messages.MessageField('GoogleCloudAiplatformV1ExportDataConfig', 1)


class GoogleCloudAiplatformV1ExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation.
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that exports Features values.

  Fields:
    genericMetadata: Operation metadata for Featurestore export Feature
      values.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1ExportFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.ExportFeatureValues.

  Fields:
    destination: Required. Specifies destination location and format.
    featureSelector: Required. Selects Features to export values of.
    fullExport: Exports all historical values of all entities of the
      EntityType within a time range
    settings: Per-Feature export settings.
    snapshotExport: Exports the latest Feature values of all entities of the
      EntityType within a time range.
  """

  destination = _messages.MessageField('GoogleCloudAiplatformV1FeatureValueDestination', 1)
  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1FeatureSelector', 2)
  fullExport = _messages.MessageField('GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport', 3)
  settings = _messages.MessageField('GoogleCloudAiplatformV1DestinationFeatureSetting', 4, repeated=True)
  snapshotExport = _messages.MessageField('GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport', 5)


class GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport(_messages.Message):
  r"""Describes exporting all historical Feature values of all entities of the
  EntityType between [start_time, end_time].

  Fields:
    endTime: Exports Feature values as of this timestamp. If not set, retrieve
      values as of now. Timestamp, if present, must not have higher than
      millisecond precision.
    startTime: Excludes Feature values with feature generation timestamp
      before this timestamp. If not set, retrieve oldest values kept in
      Feature Store. Timestamp, if present, must not have higher than
      millisecond precision.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport(_messages.Message):
  r"""Describes exporting the latest Feature values of all entities of the
  EntityType between [start_time, snapshot_time].

  Fields:
    snapshotTime: Exports Feature values as of this timestamp. If not set,
      retrieve values as of now. Timestamp, if present, must not have higher
      than millisecond precision.
    startTime: Excludes Feature values with feature generation timestamp
      before this timestamp. If not set, retrieve oldest values kept in
      Feature Store. Timestamp, if present, must not have higher than
      millisecond precision.
  """

  snapshotTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class GoogleCloudAiplatformV1ExportFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ExportFeatureValues."""


class GoogleCloudAiplatformV1ExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    artifactOutputUri: Output only. If the Model artifact is being exported to
      Google Cloud Storage this is the full path of the directory created,
      into which the Model files are being written to.
    imageOutputUri: Output only. If the Model image is being exported to
      Google Container Registry or Artifact Registry this is the full path of
      the image created.
  """

  artifactOutputUri = _messages.StringField(1)
  imageOutputUri = _messages.StringField(2)


class GoogleCloudAiplatformV1ExportModelRequest(_messages.Message):
  r"""Request message for ModelService.ExportModel.

  Fields:
    outputConfig: Required. The desired output location and configuration.
  """

  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1ExportModelRequestOutputConfig', 1)


class GoogleCloudAiplatformV1ExportModelRequestOutputConfig(_messages.Message):
  r"""Output configuration for the Model export.

  Fields:
    artifactDestination: The Cloud Storage location where the Model artifact
      is to be written to. Under the directory given as the destination a new
      one with name "`model-export--`", where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format, will be created. Inside, the Model and
      any of its supporting files will be written. This field should only be
      set when the `exportableContent` field of the
      [Model.supported_export_formats] object contains `ARTIFACT`.
    exportFormatId: The ID of the format in which the Model must be exported.
      Each Model lists the export formats it supports. If no value is provided
      here, then the first from the list of the Model's supported formats is
      used by default.
    imageDestination: The Google Container Registry or Artifact Registry uri
      where the Model container image will be copied to. This field should
      only be set when the `exportableContent` field of the
      [Model.supported_export_formats] object contains `IMAGE`.
  """

  artifactDestination = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 1)
  exportFormatId = _messages.StringField(2)
  imageDestination = _messages.MessageField('GoogleCloudAiplatformV1ContainerRegistryDestination', 3)


class GoogleCloudAiplatformV1ExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest(_messages.Message):
  r"""Request message for TensorboardService.ExportTensorboardTimeSeriesData.

  Fields:
    filter: Exports the TensorboardTimeSeries' data that match the filter
      expression.
    orderBy: Field to use to sort the TensorboardTimeSeries' data. By default,
      TensorboardTimeSeries' data is returned in a pseudo random order.
    pageSize: The maximum number of data points to return per page. The
      default page_size is 1000. Values must be between 1 and 10000. Values
      above 10000 are coerced to 10000.
    pageToken: A page token, received from a previous
      ExportTensorboardTimeSeriesData call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      ExportTensorboardTimeSeriesData must match the call that provided the
      page token.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse(_messages.Message):
  r"""Response message for TensorboardService.ExportTensorboardTimeSeriesData.

  Fields:
    nextPageToken: A token, which can be sent as page_token to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    timeSeriesDataPoints: The returned time series data points.
  """

  nextPageToken = _messages.StringField(1)
  timeSeriesDataPoints = _messages.MessageField('GoogleCloudAiplatformV1TimeSeriesDataPoint', 2, repeated=True)


class GoogleCloudAiplatformV1Feature(_messages.Message):
  r"""Feature Metadata information. For example, color is a feature that
  describes an apple.

  Enums:
    ValueTypeValueValuesEnum: Immutable. Only applicable for Vertex AI Feature
      Store (Legacy). Type of Feature value.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Features. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Feature (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Only applicable for Vertex AI Feature Store
      (Legacy). Timestamp when this EntityType was created.
    description: Description of the Feature.
    disableMonitoring: Optional. Only applicable for Vertex AI Feature Store
      (Legacy). If not set, use the monitoring_config defined for the
      EntityType this Feature belongs to. Only Features with type
      (Feature.ValueType) BOOL, STRING, DOUBLE or INT64 can enable monitoring.
      If set to true, all types of data monitoring are disabled despite the
      config on EntityType.
    etag: Used to perform a consistent read-modify-write updates. If not set,
      a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      Features. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Feature (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    monitoringStatsAnomalies: Output only. Only applicable for Vertex AI
      Feature Store (Legacy). The list of historical stats and anomalies with
      specified objectives.
    name: Immutable. Name of the Feature. Format: `projects/{project}/location
      s/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/feat
      ures/{feature}` `projects/{project}/locations/{location}/featureGroups/{
      feature_group}/features/{feature}` The last part feature is assigned by
      the client. The feature can be up to 64 characters long and can consist
      only of ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits
      0-9 starting with a letter. The value will be unique given an entity
      type.
    updateTime: Output only. Only applicable for Vertex AI Feature Store
      (Legacy). Timestamp when this EntityType was most recently updated.
    valueType: Immutable. Only applicable for Vertex AI Feature Store
      (Legacy). Type of Feature value.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. Only applicable for Vertex AI Feature Store (Legacy). Type
    of Feature value.

    Values:
      VALUE_TYPE_UNSPECIFIED: The value type is unspecified.
      BOOL: Used for Feature that is a boolean.
      BOOL_ARRAY: Used for Feature that is a list of boolean.
      DOUBLE: Used for Feature that is double.
      DOUBLE_ARRAY: Used for Feature that is a list of double.
      INT64: Used for Feature that is INT64.
      INT64_ARRAY: Used for Feature that is a list of INT64.
      STRING: Used for Feature that is string.
      STRING_ARRAY: Used for Feature that is a list of String.
      BYTES: Used for Feature that is bytes.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    BOOL = 1
    BOOL_ARRAY = 2
    DOUBLE = 3
    DOUBLE_ARRAY = 4
    INT64 = 5
    INT64_ARRAY = 6
    STRING = 7
    STRING_ARRAY = 8
    BYTES = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Features. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one Feature (System
    labels are excluded)." System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  disableMonitoring = _messages.BooleanField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  monitoringStatsAnomalies = _messages.MessageField('GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly', 6, repeated=True)
  name = _messages.StringField(7)
  updateTime = _messages.StringField(8)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 9)


class GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly(_messages.Message):
  r"""A list of historical SnapshotAnalysis or ImportFeaturesAnalysis stats
  requested by user, sorted by FeatureStatsAnomaly.start_time descending.

  Enums:
    ObjectiveValueValuesEnum: Output only. The objective for each stats.

  Fields:
    featureStatsAnomaly: Output only. The stats and anomalies generated at
      specific timestamp.
    objective: Output only. The objective for each stats.
  """

  class ObjectiveValueValuesEnum(_messages.Enum):
    r"""Output only. The objective for each stats.

    Values:
      OBJECTIVE_UNSPECIFIED: If it's OBJECTIVE_UNSPECIFIED, monitoring_stats
        will be empty.
      IMPORT_FEATURE_ANALYSIS: Stats are generated by Import Feature Analysis.
      SNAPSHOT_ANALYSIS: Stats are generated by Snapshot Analysis.
    """
    OBJECTIVE_UNSPECIFIED = 0
    IMPORT_FEATURE_ANALYSIS = 1
    SNAPSHOT_ANALYSIS = 2

  featureStatsAnomaly = _messages.MessageField('GoogleCloudAiplatformV1FeatureStatsAnomaly', 1)
  objective = _messages.EnumField('ObjectiveValueValuesEnum', 2)


class GoogleCloudAiplatformV1FeatureNoiseSigma(_messages.Message):
  r"""Noise sigma by features. Noise sigma represents the standard deviation
  of the gaussian kernel that will be used to add noise to interpolated inputs
  prior to computing gradients.

  Fields:
    noiseSigma: Noise sigma per feature. No noise is added to features that
      are not set.
  """

  noiseSigma = _messages.MessageField('GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature', 1, repeated=True)


class GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature(_messages.Message):
  r"""Noise sigma for a single feature.

  Fields:
    name: The name of the input feature for which noise sigma is provided. The
      features are defined in explanation metadata inputs.
    sigma: This represents the standard deviation of the Gaussian kernel that
      will be used to add noise to the feature prior to computing gradients.
      Similar to noise_sigma but represents the noise added to the current
      feature. Defaults to 0.1.
  """

  name = _messages.StringField(1)
  sigma = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1FeatureSelector(_messages.Message):
  r"""Selector for Features of an EntityType.

  Fields:
    idMatcher: Required. Matches Features based on ID.
  """

  idMatcher = _messages.MessageField('GoogleCloudAiplatformV1IdMatcher', 1)


class GoogleCloudAiplatformV1FeatureStatsAnomaly(_messages.Message):
  r"""Stats and Anomaly generated at specific timestamp for specific Feature.
  The start_time and end_time are used to define the time range of the dataset
  that current stats belongs to, e.g. prediction traffic is bucketed into
  prediction datasets by time window. If the Dataset is not defined by time
  window, start_time = end_time. Timestamp of the stats and anomalies always
  refers to end_time. Raw stats and anomalies are stored in stats_uri or
  anomaly_uri in the tensorflow defined protos. Field data_stats contains
  almost identical information with the raw stats in Vertex AI defined proto,
  for UI to display.

  Fields:
    anomalyDetectionThreshold: This is the threshold used when detecting
      anomalies. The threshold can be changed by user, so this one might be
      different from ThresholdConfig.value.
    anomalyUri: Path of the anomaly file for current feature values in Cloud
      Storage bucket. Format: gs:////anomalies. Example:
      gs://monitoring_bucket/feature_name/anomalies. Stats are stored as
      binary format with Protobuf message Anoamlies are stored as binary
      format with Protobuf message [tensorflow.metadata.v0.AnomalyInfo] (https
      ://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/
      v0/anomalies.proto).
    distributionDeviation: Deviation from the current stats to baseline stats.
      1. For categorical feature, the distribution distance is calculated by
      L-inifinity norm. 2. For numerical feature, the distribution distance is
      calculated by Jensen\u2013Shannon divergence.
    endTime: The end timestamp of window where stats were generated. For
      objectives where time window doesn't make sense (e.g. Featurestore
      Snapshot Monitoring), end_time indicates the timestamp of the data used
      to generate stats (e.g. timestamp we take snapshots for feature values).
    score: Feature importance score, only populated when cross-feature
      monitoring is enabled. For now only used to represent feature
      attribution score within range [0, 1] for
      ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW and
      ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT.
    startTime: The start timestamp of window where stats were generated. For
      objectives where time window doesn't make sense (e.g. Featurestore
      Snapshot Monitoring), start_time is only used to indicate the monitoring
      intervals, so it always equals to (end_time - monitoring_interval).
    statsUri: Path of the stats file for current feature values in Cloud
      Storage bucket. Format: gs:////stats. Example:
      gs://monitoring_bucket/feature_name/stats. Stats are stored as binary
      format with Protobuf message [tensorflow.metadata.v0.FeatureNameStatisti
      cs](https://github.com/tensorflow/metadata/blob/master/tensorflow_metada
      ta/proto/v0/statistics.proto).
  """

  anomalyDetectionThreshold = _messages.FloatField(1)
  anomalyUri = _messages.StringField(2)
  distributionDeviation = _messages.FloatField(3)
  endTime = _messages.StringField(4)
  score = _messages.FloatField(5)
  startTime = _messages.StringField(6)
  statsUri = _messages.StringField(7)


class GoogleCloudAiplatformV1FeatureValue(_messages.Message):
  r"""Value for a feature.

  Fields:
    boolArrayValue: A list of bool type feature value.
    boolValue: Bool type feature value.
    bytesValue: Bytes feature value.
    doubleArrayValue: A list of double type feature value.
    doubleValue: Double type feature value.
    int64ArrayValue: A list of int64 type feature value.
    int64Value: Int64 feature value.
    metadata: Metadata of feature value.
    stringArrayValue: A list of string type feature value.
    stringValue: String feature value.
  """

  boolArrayValue = _messages.MessageField('GoogleCloudAiplatformV1BoolArray', 1)
  boolValue = _messages.BooleanField(2)
  bytesValue = _messages.BytesField(3)
  doubleArrayValue = _messages.MessageField('GoogleCloudAiplatformV1DoubleArray', 4)
  doubleValue = _messages.FloatField(5)
  int64ArrayValue = _messages.MessageField('GoogleCloudAiplatformV1Int64Array', 6)
  int64Value = _messages.IntegerField(7)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1FeatureValueMetadata', 8)
  stringArrayValue = _messages.MessageField('GoogleCloudAiplatformV1StringArray', 9)
  stringValue = _messages.StringField(10)


class GoogleCloudAiplatformV1FeatureValueDestination(_messages.Message):
  r"""A destination location for Feature values and format.

  Fields:
    bigqueryDestination: Output in BigQuery format.
      BigQueryDestination.output_uri in
      FeatureValueDestination.bigquery_destination must refer to a table.
    csvDestination: Output in CSV format. Array Feature value types are not
      allowed in CSV format.
    tfrecordDestination: Output in TFRecord format. Below are the mapping from
      Feature value type in Featurestore to Feature value type in TFRecord:
      Value type in Featurestore | Value type in TFRecord DOUBLE, DOUBLE_ARRAY
      | FLOAT_LIST INT64, INT64_ARRAY | INT64_LIST STRING, STRING_ARRAY, BYTES
      | BYTES_LIST true -> byte_string("true"), false -> byte_string("false")
      BOOL, BOOL_ARRAY (true, false) | BYTES_LIST
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1BigQueryDestination', 1)
  csvDestination = _messages.MessageField('GoogleCloudAiplatformV1CsvDestination', 2)
  tfrecordDestination = _messages.MessageField('GoogleCloudAiplatformV1TFRecordDestination', 3)


class GoogleCloudAiplatformV1FeatureValueList(_messages.Message):
  r"""Container for list of values.

  Fields:
    values: A list of feature values. All of them should be the same data
      type.
  """

  values = _messages.MessageField('GoogleCloudAiplatformV1FeatureValue', 1, repeated=True)


class GoogleCloudAiplatformV1FeatureValueMetadata(_messages.Message):
  r"""Metadata of feature value.

  Fields:
    generateTime: Feature generation timestamp. Typically, it is provided by
      user at feature ingestion time. If not, feature store will use the
      system timestamp when the data is ingested into feature store. For
      streaming ingestion, the time, aligned by days, must be no older than
      five years (1825 days) and no later than one year (366 days) in the
      future.
  """

  generateTime = _messages.StringField(1)


class GoogleCloudAiplatformV1Featurestore(_messages.Message):
  r"""Vertex AI Feature Store provides a centralized repository for
  organizing, storing, and serving ML features. The Featurestore is a top-
  level container for your features and their values.

  Enums:
    StateValueValuesEnum: Output only. State of the featurestore.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Featurestore. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Featurestore(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this Featurestore was created.
    encryptionSpec: Optional. Customer-managed encryption key spec for data
      storage. If set, both of the online and offline data storage will be
      secured by this key.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      Featurestore. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Featurestore(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Output only. Name of the Featurestore. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    onlineServingConfig: Optional. Config for online storage resources. The
      field should not co-exist with the field of
      `OnlineStoreReplicationConfig`. If both of it and
      OnlineStoreReplicationConfig are unset, the feature store will not have
      an online store and cannot be used for online serving.
    state: Output only. State of the featurestore.
    updateTime: Output only. Timestamp when this Featurestore was last
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the featurestore.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      STABLE: State when the featurestore configuration is not being updated
        and the fields reflect the current configuration of the featurestore.
        The featurestore is usable in this state.
      UPDATING: The state of the featurestore configuration when it is being
        updated. During an update, the fields reflect either the original
        configuration or the updated configuration of the featurestore. For
        example, `online_serving_config.fixed_node_count` can take minutes to
        update. While the update is in progress, the featurestore is in the
        UPDATING state, and the value of `fixed_node_count` can be the
        original value or the updated value, depending on the progress of the
        operation. Until the update completes, the actual number of nodes can
        still be the original value of `fixed_node_count`. The featurestore is
        still usable in this state.
    """
    STATE_UNSPECIFIED = 0
    STABLE = 1
    UPDATING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Featurestore. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one Featurestore(System
    labels are excluded)." System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  onlineServingConfig = _messages.MessageField('GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1FeaturestoreMonitoringConfig(_messages.Message):
  r"""Configuration of how features in Featurestore are monitored.

  Fields:
    categoricalThresholdConfig: Threshold for categorical features of anomaly
      detection. This is shared by all types of Featurestore Monitoring for
      categorical features (i.e. Features with type (Feature.ValueType) BOOL
      or STRING).
    importFeaturesAnalysis: The config for ImportFeatures Analysis Based
      Feature Monitoring.
    numericalThresholdConfig: Threshold for numerical features of anomaly
      detection. This is shared by all objectives of Featurestore Monitoring
      for numerical features (i.e. Features with type (Feature.ValueType)
      DOUBLE or INT64).
    snapshotAnalysis: The config for Snapshot Analysis Based Feature
      Monitoring.
  """

  categoricalThresholdConfig = _messages.MessageField('GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig', 1)
  importFeaturesAnalysis = _messages.MessageField('GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis', 2)
  numericalThresholdConfig = _messages.MessageField('GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig', 3)
  snapshotAnalysis = _messages.MessageField('GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis', 4)


class GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis(_messages.Message):
  r"""Configuration of the Featurestore's ImportFeature Analysis Based
  Monitoring. This type of analysis generates statistics for values of each
  Feature imported by every ImportFeatureValues operation.

  Enums:
    AnomalyDetectionBaselineValueValuesEnum: The baseline used to do anomaly
      detection for the statistics generated by import features analysis.
    StateValueValuesEnum: Whether to enable / disable / inherite default
      hebavior for import features analysis.

  Fields:
    anomalyDetectionBaseline: The baseline used to do anomaly detection for
      the statistics generated by import features analysis.
    state: Whether to enable / disable / inherite default hebavior for import
      features analysis.
  """

  class AnomalyDetectionBaselineValueValuesEnum(_messages.Enum):
    r"""The baseline used to do anomaly detection for the statistics generated
    by import features analysis.

    Values:
      BASELINE_UNSPECIFIED: Should not be used.
      LATEST_STATS: Choose the later one statistics generated by either most
        recent snapshot analysis or previous import features analysis. If non
        of them exists, skip anomaly detection and only generate a statistics.
      MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most
        recent snapshot analysis if exists.
      PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the
        previous import features analysis if exists.
    """
    BASELINE_UNSPECIFIED = 0
    LATEST_STATS = 1
    MOST_RECENT_SNAPSHOT_STATS = 2
    PREVIOUS_IMPORT_FEATURES_STATS = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Whether to enable / disable / inherite default hebavior for import
    features analysis.

    Values:
      STATE_UNSPECIFIED: Should not be used.
      DEFAULT: The default behavior of whether to enable the monitoring.
        EntityType-level config: disabled. Feature-level config: inherited
        from the configuration of EntityType this Feature belongs to.
      ENABLED: Explicitly enables import features analysis. EntityType-level
        config: by default enables import features analysis for all Features
        under it. Feature-level config: enables import features analysis
        regardless of the EntityType-level config.
      DISABLED: Explicitly disables import features analysis. EntityType-level
        config: by default disables import features analysis for all Features
        under it. Feature-level config: disables import features analysis
        regardless of the EntityType-level config.
    """
    STATE_UNSPECIFIED = 0
    DEFAULT = 1
    ENABLED = 2
    DISABLED = 3

  anomalyDetectionBaseline = _messages.EnumField('AnomalyDetectionBaselineValueValuesEnum', 1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis(_messages.Message):
  r"""Configuration of the Featurestore's Snapshot Analysis Based Monitoring.
  This type of analysis generates statistics for each Feature based on a
  snapshot of the latest feature value of each entities every
  monitoring_interval.

  Fields:
    disabled: The monitoring schedule for snapshot analysis. For EntityType-
      level config: unset / disabled = true indicates disabled by default for
      Features under it; otherwise by default enable snapshot analysis
      monitoring with monitoring_interval for Features under it. Feature-level
      config: disabled = true indicates disabled regardless of the EntityType-
      level config; unset monitoring_interval indicates going with EntityType-
      level config; otherwise run snapshot analysis monitoring with
      monitoring_interval regardless of the EntityType-level config.
      Explicitly Disable the snapshot analysis based monitoring.
    monitoringIntervalDays: Configuration of the snapshot analysis based
      monitoring pipeline running interval. The value indicates number of
      days.
    stalenessDays: Customized export features time window for snapshot
      analysis. Unit is one day. Default value is 3 weeks. Minimum value is 1
      day. Maximum value is 4000 days.
  """

  disabled = _messages.BooleanField(1)
  monitoringIntervalDays = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  stalenessDays = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig(_messages.Message):
  r"""The config for Featurestore Monitoring threshold.

  Fields:
    value: Specify a threshold value that can trigger the alert. 1. For
      categorical feature, the distribution distance is calculated by
      L-inifinity norm. 2. For numerical feature, the distribution distance is
      calculated by Jensen\u2013Shannon divergence. Each feature must have a
      non-zero threshold if they need to be monitored. Otherwise no alert will
      be triggered for that feature.
  """

  value = _messages.FloatField(1)


class GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig(_messages.Message):
  r"""OnlineServingConfig specifies the details for provisioning online
  serving resources.

  Fields:
    fixedNodeCount: The number of nodes for the online store. The number of
      nodes doesn't scale automatically, but you can manually update the
      number of nodes. If set to 0, the featurestore will not have an online
      store and cannot be used for online serving.
    scaling: Online serving scaling configuration. Only one of
      `fixed_node_count` and `scaling` can be set. Setting one will reset the
      other.
  """

  fixedNodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  scaling = _messages.MessageField('GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling', 2)


class GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling(_messages.Message):
  r"""Online serving scaling configuration. If min_node_count and
  max_node_count are set to the same value, the cluster will be configured
  with the fixed number of node (no auto-scaling).

  Fields:
    cpuUtilizationTarget: Optional. The cpu utilization that the Autoscaler
      should be trying to achieve. This number is on a scale from 0 (no
      utilization) to 100 (total utilization), and is limited between 10 and
      80. When a cluster's CPU utilization exceeds the target that you have
      set, Bigtable immediately adds nodes to the cluster. When CPU
      utilization is substantially lower than the target, Bigtable removes
      nodes. If not set or set to 0, default to 50.
    maxNodeCount: The maximum number of nodes to scale up to. Must be greater
      than min_node_count, and less than or equal to 10 times of
      'min_node_count'.
    minNodeCount: Required. The minimum number of nodes to scale down to. Must
      be greater than or equal to 1.
  """

  cpuUtilizationTarget = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1FilterSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on the
  given filters, data pieces not matched by any filter are ignored. Currently
  only supported for Datasets containing DataItems. If any of the filters in
  this message are to match nothing, then they can be set as '-' (the minus
  sign). Supported only for unstructured Datasets.

  Fields:
    testFilter: Required. A filter on DataItems of the Dataset. DataItems that
      match this filter are used to test the Model. A filter with same syntax
      as the one used in DatasetService.ListDataItems may be used. If a single
      DataItem is matched by more than one of the FilterSplit filters, then it
      is assigned to the first set that applies to it in the training,
      validation, test order.
    trainingFilter: Required. A filter on DataItems of the Dataset. DataItems
      that match this filter are used to train the Model. A filter with same
      syntax as the one used in DatasetService.ListDataItems may be used. If a
      single DataItem is matched by more than one of the FilterSplit filters,
      then it is assigned to the first set that applies to it in the training,
      validation, test order.
    validationFilter: Required. A filter on DataItems of the Dataset.
      DataItems that match this filter are used to validate the Model. A
      filter with same syntax as the one used in DatasetService.ListDataItems
      may be used. If a single DataItem is matched by more than one of the
      FilterSplit filters, then it is assigned to the first set that applies
      to it in the training, validation, test order.
  """

  testFilter = _messages.StringField(1)
  trainingFilter = _messages.StringField(2)
  validationFilter = _messages.StringField(3)


class GoogleCloudAiplatformV1FractionSplit(_messages.Message):
  r"""Assigns the input data to training, validation, and test sets as per the
  given fractions. Any of `training_fraction`, `validation_fraction` and
  `test_fraction` may optionally be provided, they must sum to up to 1. If the
  provided ones sum to less than 1, the remainder is assigned to sets as
  decided by Vertex AI. If none of the fractions are set, by default roughly
  80% of data is used for training, 10% for validation, and 10% for test.

  Fields:
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  testFraction = _messages.FloatField(1)
  trainingFraction = _messages.FloatField(2)
  validationFraction = _messages.FloatField(3)


class GoogleCloudAiplatformV1GcsDestination(_messages.Message):
  r"""The Google Cloud Storage location where the output is to be written to.

  Fields:
    outputUriPrefix: Required. Google Cloud Storage URI to output directory.
      If the uri doesn't end with '/', a '/' will be automatically appended.
      The directory is created if it doesn't exist.
  """

  outputUriPrefix = _messages.StringField(1)


class GoogleCloudAiplatformV1GcsSource(_messages.Message):
  r"""The Google Cloud Storage location for the input content.

  Fields:
    uris: Required. Google Cloud Storage URI(-s) to the input file(s). May
      contain wildcards. For more information on wildcards, see
      https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
  """

  uris = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1GenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Fields:
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard Google Cloud error details.
    updateTime: Output only. Time when the operation was updated for the last
      time. If the operation has finished (successfully or not), this is the
      finish time.
  """

  createTime = _messages.StringField(1)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformV1HyperparameterTuningJob(_messages.Message):
  r"""Represents a HyperparameterTuningJob. A HyperparameterTuningJob has a
  Study specification and multiple CustomJobs with identical CustomJob
  specification.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Time when the HyperparameterTuningJob was
      created.
    displayName: Required. The display name of the HyperparameterTuningJob.
      The name can be up to 128 characters long and can consist of any UTF-8
      characters.
    encryptionSpec: Customer-managed encryption key options for a
      HyperparameterTuningJob. If this is set, then all resources created by
      the HyperparameterTuningJob will be encrypted with the provided
      encryption key.
    endTime: Output only. Time when the HyperparameterTuningJob entered any of
      the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is JOB_STATE_FAILED or
      JOB_STATE_CANCELLED.
    labels: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    maxFailedTrialCount: The number of failed Trials that need to be seen
      before failing the HyperparameterTuningJob. If set to 0, Vertex AI
      decides how many Trials must fail before the whole job fails.
    maxTrialCount: Required. The desired total number of Trials.
    name: Output only. Resource name of the HyperparameterTuningJob.
    parallelTrialCount: Required. The desired number of Trials to run in
      parallel.
    startTime: Output only. Time when the HyperparameterTuningJob for the
      first time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    studySpec: Required. Study configuration of the HyperparameterTuningJob.
    trialJobSpec: Required. The spec of a trial job. The same spec applies to
      the CustomJobs created in all the trials.
    trials: Output only. Trials of the HyperparameterTuningJob.
    updateTime: Output only. Time when the HyperparameterTuningJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize
    HyperparameterTuningJobs. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  maxFailedTrialCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  maxTrialCount = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  name = _messages.StringField(9)
  parallelTrialCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  studySpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpec', 13)
  trialJobSpec = _messages.MessageField('GoogleCloudAiplatformV1CustomJobSpec', 14)
  trials = _messages.MessageField('GoogleCloudAiplatformV1Trial', 15, repeated=True)
  updateTime = _messages.StringField(16)


class GoogleCloudAiplatformV1IdMatcher(_messages.Message):
  r"""Matcher for Features of an EntityType by Feature ID.

  Fields:
    ids: Required. The following are accepted as `ids`: * A single-element
      list containing only `*`, which selects all Features in the target
      EntityType, or * A list containing only Feature IDs, which selects only
      Features with those IDs in the target EntityType.
  """

  ids = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1ImportDataConfig(_messages.Message):
  r"""Describes the location from where we import data into a Dataset,
  together with the labels that will be applied to the DataItems and the
  Annotations.

  Messages:
    AnnotationLabelsValue: Labels that will be applied to newly imported
      Annotations. If two Annotations are identical, one of them will be
      deduped. Two Annotations are considered identical if their payload,
      payload_schema_uri and all of their labels are the same. These labels
      will be overridden by Annotation labels specified inside index file
      referenced by import_schema_uri, e.g. jsonl file.
    DataItemLabelsValue: Labels that will be applied to newly imported
      DataItems. If an identical DataItem as one being imported already exists
      in the Dataset, then these labels will be appended to these of the
      already existing one, and if labels with identical key is imported
      before, the old label value will be overwritten. If two DataItems are
      identical in the same import data operation, the labels will be combined
      and if key collision happens in this case, one of the values will be
      picked randomly. Two DataItems are considered identical if their content
      bytes are identical (e.g. image bytes or pdf bytes). These labels will
      be overridden by Annotation labels specified inside index file
      referenced by import_schema_uri, e.g. jsonl file.

  Fields:
    annotationLabels: Labels that will be applied to newly imported
      Annotations. If two Annotations are identical, one of them will be
      deduped. Two Annotations are considered identical if their payload,
      payload_schema_uri and all of their labels are the same. These labels
      will be overridden by Annotation labels specified inside index file
      referenced by import_schema_uri, e.g. jsonl file.
    dataItemLabels: Labels that will be applied to newly imported DataItems.
      If an identical DataItem as one being imported already exists in the
      Dataset, then these labels will be appended to these of the already
      existing one, and if labels with identical key is imported before, the
      old label value will be overwritten. If two DataItems are identical in
      the same import data operation, the labels will be combined and if key
      collision happens in this case, one of the values will be picked
      randomly. Two DataItems are considered identical if their content bytes
      are identical (e.g. image bytes or pdf bytes). These labels will be
      overridden by Annotation labels specified inside index file referenced
      by import_schema_uri, e.g. jsonl file.
    gcsSource: The Google Cloud Storage location for the input content.
    importSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing the import format. Validation will be done against
      the schema. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationLabelsValue(_messages.Message):
    r"""Labels that will be applied to newly imported Annotations. If two
    Annotations are identical, one of them will be deduped. Two Annotations
    are considered identical if their payload, payload_schema_uri and all of
    their labels are the same. These labels will be overridden by Annotation
    labels specified inside index file referenced by import_schema_uri, e.g.
    jsonl file.

    Messages:
      AdditionalProperty: An additional property for a AnnotationLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AnnotationLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataItemLabelsValue(_messages.Message):
    r"""Labels that will be applied to newly imported DataItems. If an
    identical DataItem as one being imported already exists in the Dataset,
    then these labels will be appended to these of the already existing one,
    and if labels with identical key is imported before, the old label value
    will be overwritten. If two DataItems are identical in the same import
    data operation, the labels will be combined and if key collision happens
    in this case, one of the values will be picked randomly. Two DataItems are
    considered identical if their content bytes are identical (e.g. image
    bytes or pdf bytes). These labels will be overridden by Annotation labels
    specified inside index file referenced by import_schema_uri, e.g. jsonl
    file.

    Messages:
      AdditionalProperty: An additional property for a DataItemLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DataItemLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataItemLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationLabels = _messages.MessageField('AnnotationLabelsValue', 1)
  dataItemLabels = _messages.MessageField('DataItemLabelsValue', 2)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1GcsSource', 3)
  importSchemaUri = _messages.StringField(4)


class GoogleCloudAiplatformV1ImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1ImportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ImportData.

  Fields:
    importConfigs: Required. The desired input locations. The contents of all
      input locations will be imported in one batch.
  """

  importConfigs = _messages.MessageField('GoogleCloudAiplatformV1ImportDataConfig', 1, repeated=True)


class GoogleCloudAiplatformV1ImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that perform import Feature values.

  Fields:
    blockingOperationIds: List of ImportFeatureValues operations running under
      a single EntityType that are blocking this operation.
    genericMetadata: Operation metadata for Featurestore import Feature
      values.
    importedEntityCount: Number of entities that have been imported by the
      operation.
    importedFeatureValueCount: Number of Feature values that have been
      imported by the operation.
    invalidRowCount: The number of rows in input source that weren't imported
      due to either * Not having any featureValues. * Having a null entityId.
      * Having a null timestamp. * Not being parsable (applicable for CSV
      sources).
    sourceUris: The source URI from where Feature values are imported.
    timestampOutsideRetentionRowsCount: The number rows that weren't ingested
      due to having timestamps outside the retention boundary.
  """

  blockingOperationIds = _messages.IntegerField(1, repeated=True)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 2)
  importedEntityCount = _messages.IntegerField(3)
  importedFeatureValueCount = _messages.IntegerField(4)
  invalidRowCount = _messages.IntegerField(5)
  sourceUris = _messages.StringField(6, repeated=True)
  timestampOutsideRetentionRowsCount = _messages.IntegerField(7)


class GoogleCloudAiplatformV1ImportFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.ImportFeatureValues.

  Fields:
    avroSource: A GoogleCloudAiplatformV1AvroSource attribute.
    bigquerySource: A GoogleCloudAiplatformV1BigQuerySource attribute.
    csvSource: A GoogleCloudAiplatformV1CsvSource attribute.
    disableIngestionAnalysis: If true, API doesn't start ingestion analysis
      pipeline.
    disableOnlineServing: If set, data will not be imported for online
      serving. This is typically used for backfilling, where Feature
      generation timestamps are not in the timestamp range needed for online
      serving.
    entityIdField: Source column that holds entity IDs. If not provided,
      entity IDs are extracted from the column named entity_id.
    featureSpecs: Required. Specifications defining which Feature values to
      import from the entity. The request fails if no feature_specs are
      provided, and having multiple feature_specs for one Feature is not
      allowed.
    featureTime: Single Feature timestamp for all entities being imported. The
      timestamp must not have higher than millisecond precision.
    featureTimeField: Source column that holds the Feature timestamp for all
      Feature values in each entity.
    workerCount: Specifies the number of workers that are used to write data
      to the Featurestore. Consider the online serving capacity that you
      require to achieve the desired import throughput without interfering
      with online serving. The value must be positive, and less than or equal
      to 100. If not set, defaults to using 1 worker. The low count ensures
      minimal impact on online serving performance.
  """

  avroSource = _messages.MessageField('GoogleCloudAiplatformV1AvroSource', 1)
  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1BigQuerySource', 2)
  csvSource = _messages.MessageField('GoogleCloudAiplatformV1CsvSource', 3)
  disableIngestionAnalysis = _messages.BooleanField(4)
  disableOnlineServing = _messages.BooleanField(5)
  entityIdField = _messages.StringField(6)
  featureSpecs = _messages.MessageField('GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec', 7, repeated=True)
  featureTime = _messages.StringField(8)
  featureTimeField = _messages.StringField(9)
  workerCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec(_messages.Message):
  r"""Defines the Feature value(s) to import.

  Fields:
    id: Required. ID of the Feature to import values of. This Feature must
      exist in the target EntityType, or the request will fail.
    sourceField: Source column to get the Feature values from. If not set,
      uses the column with the same name as the Feature ID.
  """

  id = _messages.StringField(1)
  sourceField = _messages.StringField(2)


class GoogleCloudAiplatformV1ImportFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ImportFeatureValues.

  Fields:
    importedEntityCount: Number of entities that have been imported by the
      operation.
    importedFeatureValueCount: Number of Feature values that have been
      imported by the operation.
    invalidRowCount: The number of rows in input source that weren't imported
      due to either * Not having any featureValues. * Having a null entityId.
      * Having a null timestamp. * Not being parsable (applicable for CSV
      sources).
    timestampOutsideRetentionRowsCount: The number rows that weren't ingested
      due to having feature timestamps outside the retention boundary.
  """

  importedEntityCount = _messages.IntegerField(1)
  importedFeatureValueCount = _messages.IntegerField(2)
  invalidRowCount = _messages.IntegerField(3)
  timestampOutsideRetentionRowsCount = _messages.IntegerField(4)


class GoogleCloudAiplatformV1ImportModelEvaluationRequest(_messages.Message):
  r"""Request message for ModelService.ImportModelEvaluation

  Fields:
    modelEvaluation: Required. Model evaluation resource to be imported.
  """

  modelEvaluation = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluation', 1)


class GoogleCloudAiplatformV1Index(_messages.Message):
  r"""A representation of a collection of database items organized in a way
  that allows for approximate nearest neighbor (a.k.a ANN) algorithms search.

  Enums:
    IndexUpdateMethodValueValuesEnum: Immutable. The update method to use with
      this Index. If not set, BATCH_UPDATE will be used by default.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Indexes. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Timestamp when this Index was created.
    deployedIndexes: Output only. The pointers to DeployedIndexes created from
      this Index. An Index can be only deleted if all its DeployedIndexes had
      been undeployed first.
    description: The description of the Index.
    displayName: Required. The display name of the Index. The name can be up
      to 128 characters long and can consist of any UTF-8 characters.
    encryptionSpec: Immutable. Customer-managed encryption key spec for an
      Index. If set, this Index and all sub-resources of this Index will be
      secured by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    indexStats: Output only. Stats of the index resource.
    indexUpdateMethod: Immutable. The update method to use with this Index. If
      not set, BATCH_UPDATE will be used by default.
    labels: The labels with user-defined metadata to organize your Indexes.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    metadata: An additional information about the Index; the schema of the
      metadata can be found in metadata_schema.
    metadataSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Index, that is
      specific to it. Unset if the Index does not have any additional
      information. The schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). Note: The URI
      given on output will be immutable and probably different, including the
      URI scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    name: Output only. The resource name of the Index.
    updateTime: Output only. Timestamp when this Index was most recently
      updated. This also includes any update to the contents of the Index.
      Note that Operations working on this Index may have their
      Operations.metadata.generic_metadata.update_time a little after the
      value of this timestamp, yet that does not mean their results are not
      already reflected in the Index. Result of any successfully completed
      Operation on the Index is reflected in it.
  """

  class IndexUpdateMethodValueValuesEnum(_messages.Enum):
    r"""Immutable. The update method to use with this Index. If not set,
    BATCH_UPDATE will be used by default.

    Values:
      INDEX_UPDATE_METHOD_UNSPECIFIED: Should not be used.
      BATCH_UPDATE: BatchUpdate: user can call UpdateIndex with files on Cloud
        Storage of Datapoints to update.
      STREAM_UPDATE: StreamUpdate: user can call
        UpsertDatapoints/DeleteDatapoints to update the Index and the updates
        will be applied in corresponding DeployedIndexes in nearly real-time.
    """
    INDEX_UPDATE_METHOD_UNSPECIFIED = 0
    BATCH_UPDATE = 1
    STREAM_UPDATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Indexes. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deployedIndexes = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndexRef', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 5)
  etag = _messages.StringField(6)
  indexStats = _messages.MessageField('GoogleCloudAiplatformV1IndexStats', 7)
  indexUpdateMethod = _messages.EnumField('IndexUpdateMethodValueValuesEnum', 8)
  labels = _messages.MessageField('LabelsValue', 9)
  metadata = _messages.MessageField('extra_types.JsonValue', 10)
  metadataSchemaUri = _messages.StringField(11)
  name = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class GoogleCloudAiplatformV1IndexDatapoint(_messages.Message):
  r"""A datapoint of Index.

  Fields:
    crowdingTag: Optional. CrowdingTag of the datapoint, the number of
      neighbors to return in each crowding can be configured during query.
    datapointId: Required. Unique identifier of the datapoint.
    featureVector: Required. Feature embedding vector. An array of numbers
      with the length of [NearestNeighborSearchConfig.dimensions].
    restricts: Optional. List of Restrict of the datapoint, used to perform
      "restricted searches" where boolean rule are used to filter the subset
      of the database eligible for matching. This uses categorical tokens.
      See: https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
  """

  crowdingTag = _messages.MessageField('GoogleCloudAiplatformV1IndexDatapointCrowdingTag', 1)
  datapointId = _messages.StringField(2)
  featureVector = _messages.FloatField(3, repeated=True, variant=_messages.Variant.FLOAT)
  restricts = _messages.MessageField('GoogleCloudAiplatformV1IndexDatapointRestriction', 4, repeated=True)


class GoogleCloudAiplatformV1IndexDatapointCrowdingTag(_messages.Message):
  r"""Crowding tag is a constraint on a neighbor list produced by nearest
  neighbor search requiring that no more than some value k' of the k neighbors
  returned have the same value of crowding_attribute.

  Fields:
    crowdingAttribute: The attribute value used for crowding. The maximum
      number of neighbors to return per crowding attribute value
      (per_crowding_attribute_num_neighbors) is configured per-query. This
      field is ignored if per_crowding_attribute_num_neighbors is larger than
      the total number of neighbors to return for a given query.
  """

  crowdingAttribute = _messages.StringField(1)


class GoogleCloudAiplatformV1IndexDatapointRestriction(_messages.Message):
  r"""Restriction of a datapoint which describe its attributes(tokens) from
  each of several attribute categories(namespaces).

  Fields:
    allowList: The attributes to allow in this namespace. e.g.: 'red'
    denyList: The attributes to deny in this namespace. e.g.: 'blue'
    namespace: The namespace of this restriction. e.g.: color.
  """

  allowList = _messages.StringField(1, repeated=True)
  denyList = _messages.StringField(2, repeated=True)
  namespace = _messages.StringField(3)


class GoogleCloudAiplatformV1IndexEndpoint(_messages.Message):
  r"""Indexes are deployed into it. An IndexEndpoint can have multiple
  DeployedIndexes.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      IndexEndpoints. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Timestamp when this IndexEndpoint was created.
    deployedIndexes: Output only. The indexes deployed in this endpoint.
    description: The description of the IndexEndpoint.
    displayName: Required. The display name of the IndexEndpoint. The name can
      be up to 128 characters long and can consist of any UTF-8 characters.
    enablePrivateServiceConnect: Optional. Deprecated: If true, expose the
      IndexEndpoint via private service connect. Only one of the fields,
      network or enable_private_service_connect, can be set.
    encryptionSpec: Immutable. Customer-managed encryption key spec for an
      IndexEndpoint. If set, this IndexEndpoint and all sub-resources of this
      IndexEndpoint will be secured by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your
      IndexEndpoints. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    name: Output only. The resource name of the IndexEndpoint.
    network: Optional. The full name of the Google Compute Engine
      [network](https://cloud.google.com/compute/docs/networks-and-
      firewalls#networks) to which the IndexEndpoint should be peered. Private
      services access must already be configured for the network. If left
      unspecified, the Endpoint is not peered with any network. network and
      private_service_connect_config are mutually exclusive. [Format](https://
      cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
      `projects/{project}/global/networks/{network}`. Where {project} is a
      project number, as in '12345', and {network} is network name.
    privateServiceConnectConfig: Optional. Configuration for private service
      connect. network and private_service_connect_config are mutually
      exclusive.
    publicEndpointDomainName: Output only. If public_endpoint_enabled is true,
      this field will be populated with the domain name to use for this index
      endpoint.
    publicEndpointEnabled: Optional. If true, the deployed index will be
      accessible through public endpoint.
    updateTime: Output only. Timestamp when this IndexEndpoint was last
      updated. This timestamp is not updated when the endpoint's
      DeployedIndexes are updated, e.g. due to updates of the original Indexes
      they are the deployments of.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your IndexEndpoints.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deployedIndexes = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndex', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  enablePrivateServiceConnect = _messages.BooleanField(5)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  network = _messages.StringField(10)
  privateServiceConnectConfig = _messages.MessageField('GoogleCloudAiplatformV1PrivateServiceConnectConfig', 11)
  publicEndpointDomainName = _messages.StringField(12)
  publicEndpointEnabled = _messages.BooleanField(13)
  updateTime = _messages.StringField(14)


class GoogleCloudAiplatformV1IndexPrivateEndpoints(_messages.Message):
  r"""IndexPrivateEndpoints proto is used to provide paths for users to send
  requests via private endpoints (e.g. private service access, private service
  connect). To send request via private service access, use
  match_grpc_address. To send request via private service connect, use
  service_attachment.

  Fields:
    matchGrpcAddress: Output only. The ip address used to send match gRPC
      requests.
    serviceAttachment: Output only. The name of the service attachment
      resource. Populated if private service connect is enabled.
  """

  matchGrpcAddress = _messages.StringField(1)
  serviceAttachment = _messages.StringField(2)


class GoogleCloudAiplatformV1IndexStats(_messages.Message):
  r"""Stats of the Index.

  Fields:
    shardsCount: Output only. The number of shards in the Index.
    vectorsCount: Output only. The number of vectors in the Index.
  """

  shardsCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  vectorsCount = _messages.IntegerField(2)


class GoogleCloudAiplatformV1InputDataConfig(_messages.Message):
  r"""Specifies Vertex AI owned input data to be used for training, and
  possibly evaluating, the Model.

  Fields:
    annotationSchemaUri: Applicable only to custom training with Datasets that
      have DataItems and Annotations. Cloud Storage URI that points to a YAML
      file describing the annotation schema. The schema is defined as an
      OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). The schema
      files that can be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/annotation/ , note that the chosen schema must
      be consistent with metadata of the Dataset specified by dataset_id. Only
      Annotations that both match this schema and belong to DataItems not
      ignored by the split method are used in respectively training,
      validation or test role, depending on the role of the DataItem they are
      on. When used in conjunction with annotations_filter, the Annotations
      used for training are filtered by both annotations_filter and
      annotation_schema_uri.
    annotationsFilter: Applicable only to Datasets that have DataItems and
      Annotations. A filter on Annotations of the Dataset. Only Annotations
      that both match this filter and belong to DataItems not ignored by the
      split method are used in respectively training, validation or test role,
      depending on the role of the DataItem they are on (for the auto-assigned
      that role is decided by Vertex AI). A filter with same syntax as the one
      used in ListAnnotations may be used, but note here it filters across all
      Annotations of the Dataset, and not just within a single DataItem.
    bigqueryDestination: Only applicable to custom training with tabular
      Dataset with BigQuery source. The BigQuery project location where the
      training data is to be written to. In the given project a new dataset is
      created with name `dataset___` where timestamp is in
      YYYY_MM_DDThh_mm_ss_sssZ format. All training input data is written into
      that dataset. In the dataset three tables are created, `training`,
      `validation` and `test`. * AIP_DATA_FORMAT = "bigquery". *
      AIP_TRAINING_DATA_URI = "bigquery_destination.dataset___.training" *
      AIP_VALIDATION_DATA_URI = "bigquery_destination.dataset___.validation" *
      AIP_TEST_DATA_URI = "bigquery_destination.dataset___.test"
    datasetId: Required. The ID of the Dataset in the same Project and
      Location which data will be used to train the Model. The Dataset must
      use schema compatible with Model being trained, and what is compatible
      should be described in the used TrainingPipeline's
      training_task_definition. For tabular Datasets, all their data is
      exported to training, to pick and choose from.
    filterSplit: Split based on the provided filters for each set.
    fractionSplit: Split based on fractions defining the size of each set.
    gcsDestination: The Cloud Storage location where the training data is to
      be written to. In the given directory a new directory is created with
      name: `dataset---` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
      ISO-8601 format. All training input data is written into that directory.
      The Vertex AI environment variables representing Cloud Storage data URIs
      are represented in the Cloud Storage wildcard format to support sharded
      data. e.g.: "gs://.../training-*.jsonl" * AIP_DATA_FORMAT = "jsonl" for
      non-tabular data, "csv" for tabular data * AIP_TRAINING_DATA_URI =
      "gcs_destination/dataset---/training-*.${AIP_DATA_FORMAT}" *
      AIP_VALIDATION_DATA_URI =
      "gcs_destination/dataset---/validation-*.${AIP_DATA_FORMAT}" *
      AIP_TEST_DATA_URI =
      "gcs_destination/dataset---/test-*.${AIP_DATA_FORMAT}"
    persistMlUseAssignment: Whether to persist the ML use assignment to data
      item system labels.
    predefinedSplit: Supported only for tabular Datasets. Split based on a
      predefined key.
    savedQueryId: Only applicable to Datasets that have SavedQueries. The ID
      of a SavedQuery (annotation set) under the Dataset specified by
      dataset_id used for filtering Annotations for training. Only Annotations
      that are associated with this SavedQuery are used in respectively
      training. When used in conjunction with annotations_filter, the
      Annotations used for training are filtered by both saved_query_id and
      annotations_filter. Only one of saved_query_id and annotation_schema_uri
      should be specified as both of them represent the same thing: problem
      type.
    stratifiedSplit: Supported only for tabular Datasets. Split based on the
      distribution of the specified column.
    timestampSplit: Supported only for tabular Datasets. Split based on the
      timestamp of the input data pieces.
  """

  annotationSchemaUri = _messages.StringField(1)
  annotationsFilter = _messages.StringField(2)
  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1BigQueryDestination', 3)
  datasetId = _messages.StringField(4)
  filterSplit = _messages.MessageField('GoogleCloudAiplatformV1FilterSplit', 5)
  fractionSplit = _messages.MessageField('GoogleCloudAiplatformV1FractionSplit', 6)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 7)
  persistMlUseAssignment = _messages.BooleanField(8)
  predefinedSplit = _messages.MessageField('GoogleCloudAiplatformV1PredefinedSplit', 9)
  savedQueryId = _messages.StringField(10)
  stratifiedSplit = _messages.MessageField('GoogleCloudAiplatformV1StratifiedSplit', 11)
  timestampSplit = _messages.MessageField('GoogleCloudAiplatformV1TimestampSplit', 12)


class GoogleCloudAiplatformV1Int64Array(_messages.Message):
  r"""A list of int64 values.

  Fields:
    values: A list of int64 values.
  """

  values = _messages.IntegerField(1, repeated=True)


class GoogleCloudAiplatformV1IntegratedGradientsAttribution(_messages.Message):
  r"""An attribution method that computes the Aumann-Shapley value taking
  advantage of the model's fully differentiable structure. Refer to this paper
  for more details: https://arxiv.org/abs/1703.01365

  Fields:
    blurBaselineConfig: Config for IG with blur baseline. When enabled, a
      linear path from the maximally blurred image to the input image is
      created. Using a blurred baseline instead of zero (black image) is
      motivated by the BlurIG approach explained here:
      https://arxiv.org/abs/2004.03383
    smoothGradConfig: Config for SmoothGrad approximation of gradients. When
      enabled, the gradients are approximated by averaging the gradients from
      noisy samples in the vicinity of the inputs. Adding noise can help
      improve the computed gradients. Refer to this paper for more details:
      https://arxiv.org/pdf/1706.03825.pdf
    stepCount: Required. The number of steps for approximating the path
      integral. A good value to start is 50 and gradually increase until the
      sum to diff property is within the desired error range. Valid range of
      its value is [1, 100], inclusively.
  """

  blurBaselineConfig = _messages.MessageField('GoogleCloudAiplatformV1BlurBaselineConfig', 1)
  smoothGradConfig = _messages.MessageField('GoogleCloudAiplatformV1SmoothGradConfig', 2)
  stepCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1LineageSubgraph(_messages.Message):
  r"""A subgraph of the overall lineage graph. Event edges connect Artifact
  and Execution nodes.

  Fields:
    artifacts: The Artifact nodes in the subgraph.
    events: The Event edges between Artifacts and Executions in the subgraph.
    executions: The Execution nodes in the subgraph.
  """

  artifacts = _messages.MessageField('GoogleCloudAiplatformV1Artifact', 1, repeated=True)
  events = _messages.MessageField('GoogleCloudAiplatformV1Event', 2, repeated=True)
  executions = _messages.MessageField('GoogleCloudAiplatformV1Execution', 3, repeated=True)


class GoogleCloudAiplatformV1ListAnnotationsResponse(_messages.Message):
  r"""Response message for DatasetService.ListAnnotations.

  Fields:
    annotations: A list of Annotations that matches the specified filter in
      the request.
    nextPageToken: The standard List next-page token.
  """

  annotations = _messages.MessageField('GoogleCloudAiplatformV1Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListArtifactsResponse(_messages.Message):
  r"""Response message for MetadataService.ListArtifacts.

  Fields:
    artifacts: The Artifacts retrieved from the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListArtifactsRequest.page_token to retrieve the next page. If this field
      is not populated, there are no subsequent pages.
  """

  artifacts = _messages.MessageField('GoogleCloudAiplatformV1Artifact', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListBatchPredictionJobsResponse(_messages.Message):
  r"""Response message for JobService.ListBatchPredictionJobs

  Fields:
    batchPredictionJobs: List of BatchPredictionJobs in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListBatchPredictionJobsRequest.page_token to obtain that page.
  """

  batchPredictionJobs = _messages.MessageField('GoogleCloudAiplatformV1BatchPredictionJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListContextsResponse(_messages.Message):
  r"""Response message for MetadataService.ListContexts.

  Fields:
    contexts: The Contexts retrieved from the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListContextsRequest.page_token to retrieve the next page. If this field
      is not populated, there are no subsequent pages.
  """

  contexts = _messages.MessageField('GoogleCloudAiplatformV1Context', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListCustomJobsResponse(_messages.Message):
  r"""Response message for JobService.ListCustomJobs

  Fields:
    customJobs: List of CustomJobs in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListCustomJobsRequest.page_token to obtain that page.
  """

  customJobs = _messages.MessageField('GoogleCloudAiplatformV1CustomJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListDataItemsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDataItems.

  Fields:
    dataItems: A list of DataItems that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  dataItems = _messages.MessageField('GoogleCloudAiplatformV1DataItem', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListDataLabelingJobsResponse(_messages.Message):
  r"""Response message for JobService.ListDataLabelingJobs.

  Fields:
    dataLabelingJobs: A list of DataLabelingJobs that matches the specified
      filter in the request.
    nextPageToken: The standard List next-page token.
  """

  dataLabelingJobs = _messages.MessageField('GoogleCloudAiplatformV1DataLabelingJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListDatasetVersionsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDatasetVersions.

  Fields:
    datasetVersions: A list of DatasetVersions that matches the specified
      filter in the request.
    nextPageToken: The standard List next-page token.
  """

  datasetVersions = _messages.MessageField('GoogleCloudAiplatformV1DatasetVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListDatasetsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDatasets.

  Fields:
    datasets: A list of Datasets that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  datasets = _messages.MessageField('GoogleCloudAiplatformV1Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListEndpointsResponse(_messages.Message):
  r"""Response message for EndpointService.ListEndpoints.

  Fields:
    endpoints: List of Endpoints in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListEndpointsRequest.page_token to obtain that page.
  """

  endpoints = _messages.MessageField('GoogleCloudAiplatformV1Endpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListEntityTypesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ListEntityTypes.

  Fields:
    entityTypes: The EntityTypes matching the request.
    nextPageToken: A token, which can be sent as
      ListEntityTypesRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  entityTypes = _messages.MessageField('GoogleCloudAiplatformV1EntityType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListExecutionsResponse(_messages.Message):
  r"""Response message for MetadataService.ListExecutions.

  Fields:
    executions: The Executions retrieved from the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListExecutionsRequest.page_token to retrieve the next page. If this
      field is not populated, there are no subsequent pages.
  """

  executions = _messages.MessageField('GoogleCloudAiplatformV1Execution', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListFeaturesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ListFeatures. Response message
  for FeatureRegistryService.ListFeatures.

  Fields:
    features: The Features matching the request.
    nextPageToken: A token, which can be sent as
      ListFeaturesRequest.page_token to retrieve the next page. If this field
      is omitted, there are no subsequent pages.
  """

  features = _messages.MessageField('GoogleCloudAiplatformV1Feature', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListFeaturestoresResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ListFeaturestores.

  Fields:
    featurestores: The Featurestores matching the request.
    nextPageToken: A token, which can be sent as
      ListFeaturestoresRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  featurestores = _messages.MessageField('GoogleCloudAiplatformV1Featurestore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse(_messages.Message):
  r"""Response message for JobService.ListHyperparameterTuningJobs

  Fields:
    hyperparameterTuningJobs: List of HyperparameterTuningJobs in the
      requested page. HyperparameterTuningJob.trials of the jobs will be not
      be returned.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListHyperparameterTuningJobsRequest.page_token to obtain that page.
  """

  hyperparameterTuningJobs = _messages.MessageField('GoogleCloudAiplatformV1HyperparameterTuningJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListIndexEndpointsResponse(_messages.Message):
  r"""Response message for IndexEndpointService.ListIndexEndpoints.

  Fields:
    indexEndpoints: List of IndexEndpoints in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListIndexEndpointsRequest.page_token to obtain that page.
  """

  indexEndpoints = _messages.MessageField('GoogleCloudAiplatformV1IndexEndpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListIndexesResponse(_messages.Message):
  r"""Response message for IndexService.ListIndexes.

  Fields:
    indexes: List of indexes in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListIndexesRequest.page_token to obtain that page.
  """

  indexes = _messages.MessageField('GoogleCloudAiplatformV1Index', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListMetadataSchemasResponse(_messages.Message):
  r"""Response message for MetadataService.ListMetadataSchemas.

  Fields:
    metadataSchemas: The MetadataSchemas found for the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListMetadataSchemasRequest.page_token to retrieve the next page. If this
      field is not populated, there are no subsequent pages.
  """

  metadataSchemas = _messages.MessageField('GoogleCloudAiplatformV1MetadataSchema', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListMetadataStoresResponse(_messages.Message):
  r"""Response message for MetadataService.ListMetadataStores.

  Fields:
    metadataStores: The MetadataStores found for the Location.
    nextPageToken: A token, which can be sent as
      ListMetadataStoresRequest.page_token to retrieve the next page. If this
      field is not populated, there are no subsequent pages.
  """

  metadataStores = _messages.MessageField('GoogleCloudAiplatformV1MetadataStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse(_messages.Message):
  r"""Response message for JobService.ListModelDeploymentMonitoringJobs.

  Fields:
    modelDeploymentMonitoringJobs: A list of ModelDeploymentMonitoringJobs
      that matches the specified filter in the request.
    nextPageToken: The standard List next-page token.
  """

  modelDeploymentMonitoringJobs = _messages.MessageField('GoogleCloudAiplatformV1ModelDeploymentMonitoringJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse(_messages.Message):
  r"""Response message for ModelService.ListModelEvaluationSlices.

  Fields:
    modelEvaluationSlices: List of ModelEvaluations in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelEvaluationSlicesRequest.page_token to obtain that page.
  """

  modelEvaluationSlices = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationSlice', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListModelEvaluationsResponse(_messages.Message):
  r"""Response message for ModelService.ListModelEvaluations.

  Fields:
    modelEvaluations: List of ModelEvaluations in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelEvaluationsRequest.page_token to obtain that page.
  """

  modelEvaluations = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListModelVersionsResponse(_messages.Message):
  r"""Response message for ModelService.ListModelVersions

  Fields:
    models: List of Model versions in the requested page. In the returned
      Model name field, version ID instead of regvision tag will be included.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListModelVersionsRequest.page_token to obtain that page.
  """

  models = _messages.MessageField('GoogleCloudAiplatformV1Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListModelsResponse(_messages.Message):
  r"""Response message for ModelService.ListModels

  Fields:
    models: List of Models in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelsRequest.page_token to obtain that page.
  """

  models = _messages.MessageField('GoogleCloudAiplatformV1Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListNasJobsResponse(_messages.Message):
  r"""Response message for JobService.ListNasJobs

  Fields:
    nasJobs: List of NasJobs in the requested page. NasJob.nas_job_output of
      the jobs will not be returned.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListNasJobsRequest.page_token to obtain that page.
  """

  nasJobs = _messages.MessageField('GoogleCloudAiplatformV1NasJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListNasTrialDetailsResponse(_messages.Message):
  r"""Response message for JobService.ListNasTrialDetails

  Fields:
    nasTrialDetails: List of top NasTrials in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListNasTrialDetailsRequest.page_token to obtain that page.
  """

  nasTrialDetails = _messages.MessageField('GoogleCloudAiplatformV1NasTrialDetail', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1ListOptimalTrialsRequest(_messages.Message):
  r"""Request message for VizierService.ListOptimalTrials."""


class GoogleCloudAiplatformV1ListOptimalTrialsResponse(_messages.Message):
  r"""Response message for VizierService.ListOptimalTrials.

  Fields:
    optimalTrials: The pareto-optimal Trials for multiple objective Study or
      the optimal trial for single objective Study. The definition of pareto-
      optimal can be checked in wiki page.
      https://en.wikipedia.org/wiki/Pareto_efficiency
  """

  optimalTrials = _messages.MessageField('GoogleCloudAiplatformV1Trial', 1, repeated=True)


class GoogleCloudAiplatformV1ListPipelineJobsResponse(_messages.Message):
  r"""Response message for PipelineService.ListPipelineJobs

  Fields:
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListPipelineJobsRequest.page_token to obtain that page.
    pipelineJobs: List of PipelineJobs in the requested page.
  """

  nextPageToken = _messages.StringField(1)
  pipelineJobs = _messages.MessageField('GoogleCloudAiplatformV1PipelineJob', 2, repeated=True)


class GoogleCloudAiplatformV1ListSavedQueriesResponse(_messages.Message):
  r"""Response message for DatasetService.ListSavedQueries.

  Fields:
    nextPageToken: The standard List next-page token.
    savedQueries: A list of SavedQueries that match the specified filter in
      the request.
  """

  nextPageToken = _messages.StringField(1)
  savedQueries = _messages.MessageField('GoogleCloudAiplatformV1SavedQuery', 2, repeated=True)


class GoogleCloudAiplatformV1ListSchedulesResponse(_messages.Message):
  r"""Response message for ScheduleService.ListSchedules

  Fields:
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListSchedulesRequest.page_token to obtain that page.
    schedules: List of Schedules in the requested page.
  """

  nextPageToken = _messages.StringField(1)
  schedules = _messages.MessageField('GoogleCloudAiplatformV1Schedule', 2, repeated=True)


class GoogleCloudAiplatformV1ListSpecialistPoolsResponse(_messages.Message):
  r"""Response message for SpecialistPoolService.ListSpecialistPools.

  Fields:
    nextPageToken: The standard List next-page token.
    specialistPools: A list of SpecialistPools that matches the specified
      filter in the request.
  """

  nextPageToken = _messages.StringField(1)
  specialistPools = _messages.MessageField('GoogleCloudAiplatformV1SpecialistPool', 2, repeated=True)


class GoogleCloudAiplatformV1ListStudiesResponse(_messages.Message):
  r"""Response message for VizierService.ListStudies.

  Fields:
    nextPageToken: Passes this token as the `page_token` field of the request
      for a subsequent call. If this field is omitted, there are no subsequent
      pages.
    studies: The studies associated with the project.
  """

  nextPageToken = _messages.StringField(1)
  studies = _messages.MessageField('GoogleCloudAiplatformV1Study', 2, repeated=True)


class GoogleCloudAiplatformV1ListTensorboardExperimentsResponse(_messages.Message):
  r"""Response message for TensorboardService.ListTensorboardExperiments.

  Fields:
    nextPageToken: A token, which can be sent as
      ListTensorboardExperimentsRequest.page_token to retrieve the next page.
      If this field is omitted, there are no subsequent pages.
    tensorboardExperiments: The TensorboardExperiments mathching the request.
  """

  nextPageToken = _messages.StringField(1)
  tensorboardExperiments = _messages.MessageField('GoogleCloudAiplatformV1TensorboardExperiment', 2, repeated=True)


class GoogleCloudAiplatformV1ListTensorboardRunsResponse(_messages.Message):
  r"""Response message for TensorboardService.ListTensorboardRuns.

  Fields:
    nextPageToken: A token, which can be sent as
      ListTensorboardRunsRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
    tensorboardRuns: The TensorboardRuns mathching the request.
  """

  nextPageToken = _messages.StringField(1)
  tensorboardRuns = _messages.MessageField('GoogleCloudAiplatformV1TensorboardRun', 2, repeated=True)


class GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse(_messages.Message):
  r"""Response message for TensorboardService.ListTensorboardTimeSeries.

  Fields:
    nextPageToken: A token, which can be sent as
      ListTensorboardTimeSeriesRequest.page_token to retrieve the next page.
      If this field is omitted, there are no subsequent pages.
    tensorboardTimeSeries: The TensorboardTimeSeries mathching the request.
  """

  nextPageToken = _messages.StringField(1)
  tensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1TensorboardTimeSeries', 2, repeated=True)


class GoogleCloudAiplatformV1ListTensorboardsResponse(_messages.Message):
  r"""Response message for TensorboardService.ListTensorboards.

  Fields:
    nextPageToken: A token, which can be sent as
      ListTensorboardsRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
    tensorboards: The Tensorboards mathching the request.
  """

  nextPageToken = _messages.StringField(1)
  tensorboards = _messages.MessageField('GoogleCloudAiplatformV1Tensorboard', 2, repeated=True)


class GoogleCloudAiplatformV1ListTrainingPipelinesResponse(_messages.Message):
  r"""Response message for PipelineService.ListTrainingPipelines

  Fields:
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListTrainingPipelinesRequest.page_token to obtain that page.
    trainingPipelines: List of TrainingPipelines in the requested page.
  """

  nextPageToken = _messages.StringField(1)
  trainingPipelines = _messages.MessageField('GoogleCloudAiplatformV1TrainingPipeline', 2, repeated=True)


class GoogleCloudAiplatformV1ListTrialsResponse(_messages.Message):
  r"""Response message for VizierService.ListTrials.

  Fields:
    nextPageToken: Pass this token as the `page_token` field of the request
      for a subsequent call. If this field is omitted, there are no subsequent
      pages.
    trials: The Trials associated with the Study.
  """

  nextPageToken = _messages.StringField(1)
  trials = _messages.MessageField('GoogleCloudAiplatformV1Trial', 2, repeated=True)


class GoogleCloudAiplatformV1LookupStudyRequest(_messages.Message):
  r"""Request message for VizierService.LookupStudy.

  Fields:
    displayName: Required. The user-defined display name of the Study
  """

  displayName = _messages.StringField(1)


class GoogleCloudAiplatformV1MachineSpec(_messages.Message):
  r"""Specification of a single machine.

  Enums:
    AcceleratorTypeValueValuesEnum: Immutable. The type of accelerator(s) that
      may be attached to the machine as per accelerator_count.

  Fields:
    acceleratorCount: The number of accelerators to attach to the machine.
    acceleratorType: Immutable. The type of accelerator(s) that may be
      attached to the machine as per accelerator_count.
    machineType: Immutable. The type of the machine. See the [list of machine
      types supported for prediction](https://cloud.google.com/vertex-
      ai/docs/predictions/configure-compute#machine-types) See the [list of
      machine types supported for custom
      training](https://cloud.google.com/vertex-ai/docs/training/configure-
      compute#machine-types). For DeployedModel this field is optional, and
      the default value is `n1-standard-2`. For BatchPredictionJob or as part
      of WorkerPoolSpec this field is required.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of accelerator(s) that may be attached to the
    machine as per accelerator_count.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type, which means
        no accelerator.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      NVIDIA_TESLA_A100: Nvidia Tesla A100 GPU.
      NVIDIA_A100_80GB: Nvidia A100 80GB GPU.
      NVIDIA_L4: Nvidia L4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
      TPU_V4_POD: TPU v4.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    NVIDIA_TESLA_A100 = 6
    NVIDIA_A100_80GB = 7
    NVIDIA_L4 = 8
    TPU_V2 = 9
    TPU_V3 = 10
    TPU_V4_POD = 11

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 2)
  machineType = _messages.StringField(3)


class GoogleCloudAiplatformV1ManualBatchTuningParameters(_messages.Message):
  r"""Manual batch tuning parameters.

  Fields:
    batchSize: Immutable. The number of the records (e.g. instances) of the
      operation given in each batch to a machine replica. Machine type, and
      size of a single record should be considered when setting this
      parameter, higher value speeds up the batch operation's execution, but
      too high value will result in a whole batch not fitting in a machine's
      memory, and the whole operation will fail. The default value is 64.
  """

  batchSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1Measurement(_messages.Message):
  r"""A message representing a Measurement of a Trial. A Measurement contains
  the Metrics got by executing a Trial using suggested hyperparameter values.

  Fields:
    elapsedDuration: Output only. Time that the Trial has been running at the
      point of this Measurement.
    metrics: Output only. A list of metrics got by evaluating the objective
      functions using suggested Parameter values.
    stepCount: Output only. The number of steps the machine learning model has
      been trained for. Must be non-negative.
  """

  elapsedDuration = _messages.StringField(1)
  metrics = _messages.MessageField('GoogleCloudAiplatformV1MeasurementMetric', 2, repeated=True)
  stepCount = _messages.IntegerField(3)


class GoogleCloudAiplatformV1MeasurementMetric(_messages.Message):
  r"""A message representing a metric in the measurement.

  Fields:
    metricId: Output only. The ID of the Metric. The Metric should be defined
      in StudySpec's Metrics.
    value: Output only. The value for this metric.
  """

  metricId = _messages.StringField(1)
  value = _messages.FloatField(2)


class GoogleCloudAiplatformV1MergeVersionAliasesRequest(_messages.Message):
  r"""Request message for ModelService.MergeVersionAliases.

  Fields:
    versionAliases: Required. The set of version aliases to merge. The alias
      should be at most 128 characters, and match `a-z{0,126}[a-z-0-9]`. Add
      the `-` prefix to an alias means removing that alias from the version.
      `-` is NOT counted in the 128 characters. Example: `-golden` means
      removing the `golden` alias from the version. There is NO ordering in
      aliases, which means 1) The aliases returned from GetModel API might not
      have the exactly same order from this MergeVersionAliases API. 2) Adding
      and deleting the same alias in the request is not recommended, and the 2
      operations will be cancelled out.
  """

  versionAliases = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1MetadataSchema(_messages.Message):
  r"""Instance of a general MetadataSchema.

  Enums:
    SchemaTypeValueValuesEnum: The type of the MetadataSchema. This is a
      property that identifies which metadata types will use the
      MetadataSchema.

  Fields:
    createTime: Output only. Timestamp when this MetadataSchema was created.
    description: Description of the Metadata Schema
    name: Output only. The resource name of the MetadataSchema.
    schema: Required. The raw YAML string representation of the
      MetadataSchema. The combination of [MetadataSchema.version] and the
      schema name given by `title` in [MetadataSchema.schema] must be unique
      within a MetadataStore. The schema is defined as an OpenAPI 3.0.2
      [MetadataSchema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/master/versions/3.0.2.md#schemaObject)
    schemaType: The type of the MetadataSchema. This is a property that
      identifies which metadata types will use the MetadataSchema.
    schemaVersion: The version of the MetadataSchema. The version's format
      must match the following regular expression: `^[0-9]+.+.+$`, which would
      allow to order/compare different versions. Example: 1.0.0, 1.0.1, etc.
  """

  class SchemaTypeValueValuesEnum(_messages.Enum):
    r"""The type of the MetadataSchema. This is a property that identifies
    which metadata types will use the MetadataSchema.

    Values:
      METADATA_SCHEMA_TYPE_UNSPECIFIED: Unspecified type for the
        MetadataSchema.
      ARTIFACT_TYPE: A type indicating that the MetadataSchema will be used by
        Artifacts.
      EXECUTION_TYPE: A typee indicating that the MetadataSchema will be used
        by Executions.
      CONTEXT_TYPE: A state indicating that the MetadataSchema will be used by
        Contexts.
    """
    METADATA_SCHEMA_TYPE_UNSPECIFIED = 0
    ARTIFACT_TYPE = 1
    EXECUTION_TYPE = 2
    CONTEXT_TYPE = 3

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  name = _messages.StringField(3)
  schema = _messages.StringField(4)
  schemaType = _messages.EnumField('SchemaTypeValueValuesEnum', 5)
  schemaVersion = _messages.StringField(6)


class GoogleCloudAiplatformV1MetadataStore(_messages.Message):
  r"""Instance of a metadata store. Contains a set of metadata that can be
  queried.

  Fields:
    createTime: Output only. Timestamp when this MetadataStore was created.
    description: Description of the MetadataStore.
    encryptionSpec: Customer-managed encryption key spec for a Metadata Store.
      If set, this Metadata Store and all sub-resources of this Metadata Store
      are secured using this key.
    name: Output only. The resource name of the MetadataStore instance.
    state: Output only. State information of the MetadataStore.
    updateTime: Output only. Timestamp when this MetadataStore was last
      updated.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 3)
  name = _messages.StringField(4)
  state = _messages.MessageField('GoogleCloudAiplatformV1MetadataStoreMetadataStoreState', 5)
  updateTime = _messages.StringField(6)


class GoogleCloudAiplatformV1MetadataStoreMetadataStoreState(_messages.Message):
  r"""Represents state information for a MetadataStore.

  Fields:
    diskUtilizationBytes: The disk utilization of the MetadataStore in bytes.
  """

  diskUtilizationBytes = _messages.IntegerField(1)


class GoogleCloudAiplatformV1MigratableResource(_messages.Message):
  r"""Represents one resource that exists in automl.googleapis.com,
  datalabeling.googleapis.com or ml.googleapis.com.

  Fields:
    automlDataset: Output only. Represents one Dataset in
      automl.googleapis.com.
    automlModel: Output only. Represents one Model in automl.googleapis.com.
    dataLabelingDataset: Output only. Represents one Dataset in
      datalabeling.googleapis.com.
    lastMigrateTime: Output only. Timestamp when the last migration attempt on
      this MigratableResource started. Will not be set if there's no migration
      attempt on this MigratableResource.
    lastUpdateTime: Output only. Timestamp when this MigratableResource was
      last updated.
    mlEngineModelVersion: Output only. Represents one Version in
      ml.googleapis.com.
  """

  automlDataset = _messages.MessageField('GoogleCloudAiplatformV1MigratableResourceAutomlDataset', 1)
  automlModel = _messages.MessageField('GoogleCloudAiplatformV1MigratableResourceAutomlModel', 2)
  dataLabelingDataset = _messages.MessageField('GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset', 3)
  lastMigrateTime = _messages.StringField(4)
  lastUpdateTime = _messages.StringField(5)
  mlEngineModelVersion = _messages.MessageField('GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion', 6)


class GoogleCloudAiplatformV1MigratableResourceAutomlDataset(_messages.Message):
  r"""Represents one Dataset in automl.googleapis.com.

  Fields:
    dataset: Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in automl.googleapis.com.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1MigratableResourceAutomlModel(_messages.Message):
  r"""Represents one Model in automl.googleapis.com.

  Fields:
    model: Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: The Model's display name in automl.googleapis.com.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset(_messages.Message):
  r"""Represents one Dataset in datalabeling.googleapis.com.

  Fields:
    dataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
      datalabeling.googleapis.com belongs to the data labeling Dataset.
    dataset: Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in
      datalabeling.googleapis.com.
  """

  dataLabelingAnnotatedDatasets = _messages.MessageField('GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset', 1, repeated=True)
  dataset = _messages.StringField(2)
  datasetDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset(_messages.Message):
  r"""Represents one AnnotatedDataset in datalabeling.googleapis.com.

  Fields:
    annotatedDataset: Full resource name of data labeling AnnotatedDataset.
      Format: `projects/{project}/datasets/{dataset}/annotatedDatasets/{annota
      ted_dataset}`.
    annotatedDatasetDisplayName: The AnnotatedDataset's display name in
      datalabeling.googleapis.com.
  """

  annotatedDataset = _messages.StringField(1)
  annotatedDatasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion(_messages.Message):
  r"""Represents one model Version in ml.googleapis.com.

  Fields:
    endpoint: The ml.googleapis.com endpoint that this model Version currently
      lives in. Example values: * ml.googleapis.com * us-centrall-
      ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    version: Full resource name of ml engine model Version. Format:
      `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  version = _messages.StringField(2)


class GoogleCloudAiplatformV1MigrateResourceRequest(_messages.Message):
  r"""Config of migrating one resource from automl.googleapis.com,
  datalabeling.googleapis.com and ml.googleapis.com to Vertex AI.

  Fields:
    migrateAutomlDatasetConfig: Config for migrating Dataset in
      automl.googleapis.com to Vertex AI's Dataset.
    migrateAutomlModelConfig: Config for migrating Model in
      automl.googleapis.com to Vertex AI's Model.
    migrateDataLabelingDatasetConfig: Config for migrating Dataset in
      datalabeling.googleapis.com to Vertex AI's Dataset.
    migrateMlEngineModelVersionConfig: Config for migrating Version in
      ml.googleapis.com to Vertex AI's Model.
  """

  migrateAutomlDatasetConfig = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig', 1)
  migrateAutomlModelConfig = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig', 2)
  migrateDataLabelingDatasetConfig = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig', 3)
  migrateMlEngineModelVersionConfig = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig', 4)


class GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig(_messages.Message):
  r"""Config for migrating Dataset in automl.googleapis.com to Vertex AI's
  Dataset.

  Fields:
    dataset: Required. Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: Required. Display name of the Dataset in Vertex AI.
      System will pick a display name if unspecified.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig(_messages.Message):
  r"""Config for migrating Model in automl.googleapis.com to Vertex AI's
  Model.

  Fields:
    model: Required. Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: Optional. Display name of the model in Vertex AI. System
      will pick a display name if unspecified.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig(_messages.Message):
  r"""Config for migrating Dataset in datalabeling.googleapis.com to Vertex
  AI's Dataset.

  Fields:
    dataset: Required. Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: Optional. Display name of the Dataset in Vertex AI.
      System will pick a display name if unspecified.
    migrateDataLabelingAnnotatedDatasetConfigs: Optional. Configs for
      migrating AnnotatedDataset in datalabeling.googleapis.com to Vertex AI's
      SavedQuery. The specified AnnotatedDatasets have to belong to the
      datalabeling Dataset.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)
  migrateDataLabelingAnnotatedDatasetConfigs = _messages.MessageField('GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig', 3, repeated=True)


class GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig(_messages.Message):
  r"""Config for migrating AnnotatedDataset in datalabeling.googleapis.com to
  Vertex AI's SavedQuery.

  Fields:
    annotatedDataset: Required. Full resource name of data labeling
      AnnotatedDataset. Format: `projects/{project}/datasets/{dataset}/annotat
      edDatasets/{annotated_dataset}`.
  """

  annotatedDataset = _messages.StringField(1)


class GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig(_messages.Message):
  r"""Config for migrating version in ml.googleapis.com to Vertex AI's Model.

  Fields:
    endpoint: Required. The ml.googleapis.com endpoint that this model version
      should be migrated from. Example values: * ml.googleapis.com * us-
      centrall-ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    modelDisplayName: Required. Display name of the model in Vertex AI. System
      will pick a display name if unspecified.
    modelVersion: Required. Full resource name of ml engine model version.
      Format: `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)
  modelVersion = _messages.StringField(3)


class GoogleCloudAiplatformV1MigrateResourceResponse(_messages.Message):
  r"""Describes a successfully migrated resource.

  Fields:
    dataset: Migrated Dataset's resource name.
    migratableResource: Before migration, the identifier in ml.googleapis.com,
      automl.googleapis.com or datalabeling.googleapis.com.
    model: Migrated Model's resource name.
  """

  dataset = _messages.StringField(1)
  migratableResource = _messages.MessageField('GoogleCloudAiplatformV1MigratableResource', 2)
  model = _messages.StringField(3)


class GoogleCloudAiplatformV1Model(_messages.Message):
  r"""A trained machine learning Model.

  Enums:
    SupportedDeploymentResourcesTypesValueListEntryValuesEnum:

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Models. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    artifactUri: Immutable. The path to the directory containing the Model
      artifact and any of its supporting files. Not present for AutoML Models
      or Large Models.
    containerSpec: Input only. The specification of the container that is to
      be used when deploying this Model. The specification is ingested upon
      ModelService.UploadModel, and all binaries it contains are copied and
      stored internally by Vertex AI. Not present for AutoML Models or Large
      Models.
    createTime: Output only. Timestamp when this Model was uploaded into
      Vertex AI.
    deployedModels: Output only. The pointers to DeployedModels created from
      this Model. Note that Model could have been deployed to Endpoints in
      different Locations.
    description: The description of the Model.
    displayName: Required. The display name of the Model. The name can be up
      to 128 characters long and can consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key spec for a Model. If set,
      this Model and all sub-resources of this Model will be secured by this
      key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    explanationSpec: The default explanation specification for this Model. The
      Model can be used for requesting explanation after being deployed if it
      is populated. The Model can be used for batch explanation if it is
      populated. All fields of the explanation_spec can be overridden by
      explanation_spec of DeployModelRequest.deployed_model, or
      explanation_spec of BatchPredictionJob. If the default explanation
      specification is not set for this Model, this Model can still be used
      for requesting explanation by setting explanation_spec of
      DeployModelRequest.deployed_model and for batch explanation by setting
      explanation_spec of BatchPredictionJob.
    labels: The labels with user-defined metadata to organize your Models.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    metadata: Immutable. An additional information about the Model; the schema
      of the metadata can be found in metadata_schema. Unset if the Model does
      not have any additional information.
    metadataArtifact: Output only. The resource name of the Artifact that was
      created in MetadataStore when creating the Model. The Artifact resource
      name pattern is `projects/{project}/locations/{location}/metadataStores/
      {metadata_store}/artifacts/{artifact}`.
    metadataSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Model, that is
      specific to it. Unset if the Model does not have any additional
      information. The schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models
      always have this field populated by Vertex AI, if no additional metadata
      is needed, this field is set to an empty string. Note: The URI given on
      output will be immutable and probably different, including the URI
      scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    modelSourceInfo: Output only. Source of a model. It can either be automl
      training pipeline, custom training pipeline, BigQuery ML, or existing
      Vertex AI Model.
    name: The resource name of the Model.
    originalModelInfo: Output only. If this Model is a copy of another Model,
      this contains info about the original.
    pipelineJob: Optional. This field is populated if the model is produced by
      a pipeline job.
    predictSchemata: The schemata that describe formats of the Model's
      predictions and explanations as given and returned via
      PredictionService.Predict and PredictionService.Explain.
    supportedDeploymentResourcesTypes: Output only. When this Model is
      deployed, its prediction resources are described by the
      `prediction_resources` field of the Endpoint.deployed_models object.
      Because not all Models support all resource configuration types, the
      configuration types this Model supports are listed here. If no
      configuration types are listed, the Model cannot be deployed to an
      Endpoint and does not support online predictions
      (PredictionService.Predict or PredictionService.Explain). Such a Model
      can serve predictions by using a BatchPredictionJob, if it has at least
      one entry each in supported_input_storage_formats and
      supported_output_storage_formats.
    supportedExportFormats: Output only. The formats in which this Model may
      be exported. If empty, this Model is not available for export.
    supportedInputStorageFormats: Output only. The formats this Model supports
      in BatchPredictionJob.input_config. If
      PredictSchemata.instance_schema_uri exists, the instances should be
      given as per that schema. The possible formats are: * `jsonl` The JSON
      Lines format, where each instance is a single line. Uses GcsSource. *
      `csv` The CSV format, where each instance is a single comma-separated
      line. The first line in the file is the header, containing comma-
      separated field names. Uses GcsSource. * `tf-record` The TFRecord
      format, where each instance is a single record in tfrecord syntax. Uses
      GcsSource. * `tf-record-gzip` Similar to `tf-record`, but the file is
      gzipped. Uses GcsSource. * `bigquery` Each instance is a single row in
      BigQuery. Uses BigQuerySource. * `file-list` Each line of the file is
      the location of an instance to process, uses `gcs_source` field of the
      InputConfig object. If this Model doesn't support any of these formats
      it means it cannot be used with a BatchPredictionJob. However, if it has
      supported_deployment_resources_types, it could serve online predictions
      by using PredictionService.Predict or PredictionService.Explain.
    supportedOutputStorageFormats: Output only. The formats this Model
      supports in BatchPredictionJob.output_config. If both
      PredictSchemata.instance_schema_uri and
      PredictSchemata.prediction_schema_uri exist, the predictions are
      returned together with their instances. In other words, the prediction
      has the original instance data first, followed by the actual prediction
      content (as per the schema). The possible formats are: * `jsonl` The
      JSON Lines format, where each prediction is a single line. Uses
      GcsDestination. * `csv` The CSV format, where each prediction is a
      single comma-separated line. The first line in the file is the header,
      containing comma-separated field names. Uses GcsDestination. *
      `bigquery` Each prediction is a single row in a BigQuery table, uses
      BigQueryDestination . If this Model doesn't support any of these formats
      it means it cannot be used with a BatchPredictionJob. However, if it has
      supported_deployment_resources_types, it could serve online predictions
      by using PredictionService.Predict or PredictionService.Explain.
    trainingPipeline: Output only. The resource name of the TrainingPipeline
      that uploaded this Model, if any.
    updateTime: Output only. Timestamp when this Model was most recently
      updated.
    versionAliases: User provided version aliases so that a model version can
      be referenced via alias (i.e. `projects/{project}/locations/{location}/m
      odels/{model_id}@{version_alias}` instead of auto-generated version id
      (i.e. `projects/{project}/locations/{location}/models/{model_id}@{versio
      n_id})`. The format is a-z{0,126}[a-z0-9] to distinguish from
      version_id. A default version alias will be created for the first
      version of the model, and there must be exactly one default version
      alias for a model.
    versionCreateTime: Output only. Timestamp when this version was created.
    versionDescription: The description of this version.
    versionId: Output only. Immutable. The version ID of the model. A new
      version is committed when a new model version is uploaded or trained
      under an existing model id. It is an auto-incrementing decimal number in
      string representation.
    versionUpdateTime: Output only. Timestamp when this version was most
      recently updated.
  """

  class SupportedDeploymentResourcesTypesValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedDeploymentResourcesTypesValueListEntryValuesEnum enum type.

    Values:
      DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED: Should not be used.
      DEDICATED_RESOURCES: Resources that are dedicated to the DeployedModel,
        and that need a higher degree of manual configuration.
      AUTOMATIC_RESOURCES: Resources that to large degree are decided by
        Vertex AI, and require only a modest additional configuration.
      SHARED_RESOURCES: Resources that can be shared by multiple
        DeployedModels. A pre-configured DeploymentResourcePool is required.
    """
    DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED = 0
    DEDICATED_RESOURCES = 1
    AUTOMATIC_RESOURCES = 2
    SHARED_RESOURCES = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Models. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifactUri = _messages.StringField(1)
  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1ModelContainerSpec', 2)
  createTime = _messages.StringField(3)
  deployedModels = _messages.MessageField('GoogleCloudAiplatformV1DeployedModelRef', 4, repeated=True)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 7)
  etag = _messages.StringField(8)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1ExplanationSpec', 9)
  labels = _messages.MessageField('LabelsValue', 10)
  metadata = _messages.MessageField('extra_types.JsonValue', 11)
  metadataArtifact = _messages.StringField(12)
  metadataSchemaUri = _messages.StringField(13)
  modelSourceInfo = _messages.MessageField('GoogleCloudAiplatformV1ModelSourceInfo', 14)
  name = _messages.StringField(15)
  originalModelInfo = _messages.MessageField('GoogleCloudAiplatformV1ModelOriginalModelInfo', 16)
  pipelineJob = _messages.StringField(17)
  predictSchemata = _messages.MessageField('GoogleCloudAiplatformV1PredictSchemata', 18)
  supportedDeploymentResourcesTypes = _messages.EnumField('SupportedDeploymentResourcesTypesValueListEntryValuesEnum', 19, repeated=True)
  supportedExportFormats = _messages.MessageField('GoogleCloudAiplatformV1ModelExportFormat', 20, repeated=True)
  supportedInputStorageFormats = _messages.StringField(21, repeated=True)
  supportedOutputStorageFormats = _messages.StringField(22, repeated=True)
  trainingPipeline = _messages.StringField(23)
  updateTime = _messages.StringField(24)
  versionAliases = _messages.StringField(25, repeated=True)
  versionCreateTime = _messages.StringField(26)
  versionDescription = _messages.StringField(27)
  versionId = _messages.StringField(28)
  versionUpdateTime = _messages.StringField(29)


class GoogleCloudAiplatformV1ModelContainerSpec(_messages.Message):
  r"""Specification of a container for serving predictions. Some fields in
  this message correspond to fields in the [Kubernetes Container v1 core
  specification](https://kubernetes.io/docs/reference/generated/kubernetes-
  api/v1.23/#container-v1-core).

  Fields:
    args: Immutable. Specifies arguments for the command that runs when the
      container starts. This overrides the container's
      [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
      this field as an array of executable and arguments, similar to a Docker
      `CMD`'s "default parameters" form. If you don't specify this field but
      do specify the command field, then the command from the `command` field
      runs without any additional arguments. See the [Kubernetes documentation
      about how the `command` and `args` fields interact with a container's
      `ENTRYPOINT` and `CMD`](https://kubernetes.io/docs/tasks/inject-data-
      application/define-command-argument-container/#notes). If you don't
      specify this field and don't specify the `command` field, then the
      container's
      [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd)
      and `CMD` determine what runs based on their default behavior. See the
      Docker documentation about [how `CMD` and `ENTRYPOINT`
      interact](https://docs.docker.com/engine/reference/builder/#understand-
      how-cmd-and-entrypoint-interact). In this field, you can reference
      [environment variables set by Vertex
      AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-
      container-requirements#aip-variables) and environment variables set in
      the env field. You cannot reference environment variables set in the
      Docker image. In order for environment variables to be expanded,
      reference them by using the following syntax: $( VARIABLE_NAME) Note
      that this differs from Bash variable expansion, which does not use
      parentheses. If a variable cannot be resolved, the reference in the
      input string is used unchanged. To avoid variable expansion, you can
      escape this syntax with `$$`; for example: $$(VARIABLE_NAME) This field
      corresponds to the `args` field of the Kubernetes Containers [v1 core
      API](https://kubernetes.io/docs/reference/generated/kubernetes-
      api/v1.23/#container-v1-core).
    command: Immutable. Specifies the command that runs when the container
      starts. This overrides the container's [ENTRYPOINT](https://docs.docker.
      com/engine/reference/builder/#entrypoint). Specify this field as an
      array of executable and arguments, similar to a Docker `ENTRYPOINT`'s
      "exec" form, not its "shell" form. If you do not specify this field,
      then the container's `ENTRYPOINT` runs, in conjunction with the args
      field or the container's
      [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if
      either exists. If this field is not specified and the container does not
      have an `ENTRYPOINT`, then refer to the Docker documentation about [how
      `CMD` and `ENTRYPOINT`
      interact](https://docs.docker.com/engine/reference/builder/#understand-
      how-cmd-and-entrypoint-interact). If you specify this field, then you
      can also specify the `args` field to provide additional arguments for
      this command. However, if you specify this field, then the container's
      `CMD` is ignored. See the [Kubernetes documentation about how the
      `command` and `args` fields interact with a container's `ENTRYPOINT` and
      `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-
      command-argument-container/#notes). In this field, you can reference
      [environment variables set by Vertex
      AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-
      container-requirements#aip-variables) and environment variables set in
      the env field. You cannot reference environment variables set in the
      Docker image. In order for environment variables to be expanded,
      reference them by using the following syntax: $( VARIABLE_NAME) Note
      that this differs from Bash variable expansion, which does not use
      parentheses. If a variable cannot be resolved, the reference in the
      input string is used unchanged. To avoid variable expansion, you can
      escape this syntax with `$$`; for example: $$(VARIABLE_NAME) This field
      corresponds to the `command` field of the Kubernetes Containers [v1 core
      API](https://kubernetes.io/docs/reference/generated/kubernetes-
      api/v1.23/#container-v1-core).
    env: Immutable. List of environment variables to set in the container.
      After the container starts running, code running in the container can
      read these environment variables. Additionally, the command and args
      fields can reference these variables. Later entries in this list can
      also reference earlier entries. For example, the following example sets
      the variable `VAR_2` to have the value `foo bar`: ```json [ { "name":
      "VAR_1", "value": "foo" }, { "name": "VAR_2", "value": "$(VAR_1) bar" }
      ] ``` If you switch the order of the variables in the example, then the
      expansion does not occur. This field corresponds to the `env` field of
      the Kubernetes Containers [v1 core
      API](https://kubernetes.io/docs/reference/generated/kubernetes-
      api/v1.23/#container-v1-core).
    healthRoute: Immutable. HTTP path on the container to send health checks
      to. Vertex AI intermittently sends GET requests to this path on the
      container's IP address and port to check that the container is healthy.
      Read more about [health checks](https://cloud.google.com/vertex-
      ai/docs/predictions/custom-container-requirements#health). For example,
      if you set this field to `/bar`, then Vertex AI intermittently sends a
      GET request to the `/bar` path on the port of your container specified
      by the first value of this `ModelContainerSpec`'s ports field. If you
      don't specify this field, it defaults to the following value when you
      deploy this Model to an Endpoint: /v1/endpoints/ENDPOINT/deployedModels/
      DEPLOYED_MODEL:predict The placeholders in this value are replaced as
      follows: * ENDPOINT: The last segment (following `endpoints/`)of the
      Endpoint.name][] field of the Endpoint where this Model has been
      deployed. (Vertex AI makes this value available to your container code
      as the [`AIP_ENDPOINT_ID` environment
      variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-
      container-requirements#aip-variables).) * DEPLOYED_MODEL:
      DeployedModel.id of the `DeployedModel`. (Vertex AI makes this value
      available to your container code as the [`AIP_DEPLOYED_MODEL_ID`
      environment variable](https://cloud.google.com/vertex-
      ai/docs/predictions/custom-container-requirements#aip-variables).)
    imageUri: Required. Immutable. URI of the Docker image to be used as the
      custom container for serving predictions. This URI must identify an
      image in Artifact Registry or Container Registry. Learn more about the
      [container publishing requirements](https://cloud.google.com/vertex-
      ai/docs/predictions/custom-container-requirements#publishing), including
      permissions requirements for the Vertex AI Service Agent. The container
      image is ingested upon ModelService.UploadModel, stored internally, and
      this original path is afterwards not used. To learn about the
      requirements for the Docker image itself, see [Custom container
      requirements](https://cloud.google.com/vertex-
      ai/docs/predictions/custom-container-requirements#). You can use the URI
      to one of Vertex AI's [pre-built container images for
      prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-
      built-containers) in this field.
    ports: Immutable. List of ports to expose from the container. Vertex AI
      sends any prediction requests that it receives to the first port on this
      list. Vertex AI also sends [liveness and health
      checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-
      container-requirements#liveness) to this port. If you do not specify
      this field, it defaults to following value: ```json [ { "containerPort":
      8080 } ] ``` Vertex AI does not use ports other than the first one
      listed. This field corresponds to the `ports` field of the Kubernetes
      Containers [v1 core
      API](https://kubernetes.io/docs/reference/generated/kubernetes-
      api/v1.23/#container-v1-core).
    predictRoute: Immutable. HTTP path on the container to send prediction
      requests to. Vertex AI forwards requests sent using
      projects.locations.endpoints.predict to this path on the container's IP
      address and port. Vertex AI then returns the container's response in the
      API response. For example, if you set this field to `/foo`, then when
      Vertex AI receives a prediction request, it forwards the request body in
      a POST request to the `/foo` path on the port of your container
      specified by the first value of this `ModelContainerSpec`'s ports field.
      If you don't specify this field, it defaults to the following value when
      you deploy this Model to an Endpoint:
      /v1/endpoints/ENDPOINT/deployedModels/DEPLOYED_MODEL:predict The
      placeholders in this value are replaced as follows: * ENDPOINT: The last
      segment (following `endpoints/`)of the Endpoint.name][] field of the
      Endpoint where this Model has been deployed. (Vertex AI makes this value
      available to your container code as the [`AIP_ENDPOINT_ID` environment
      variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-
      container-requirements#aip-variables).) * DEPLOYED_MODEL:
      DeployedModel.id of the `DeployedModel`. (Vertex AI makes this value
      available to your container code as the [`AIP_DEPLOYED_MODEL_ID`
      environment variable](https://cloud.google.com/vertex-
      ai/docs/predictions/custom-container-requirements#aip-variables).)
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('GoogleCloudAiplatformV1EnvVar', 3, repeated=True)
  healthRoute = _messages.StringField(4)
  imageUri = _messages.StringField(5)
  ports = _messages.MessageField('GoogleCloudAiplatformV1Port', 6, repeated=True)
  predictRoute = _messages.StringField(7)


class GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable(_messages.Message):
  r"""ModelDeploymentMonitoringBigQueryTable specifies the BigQuery table name
  as well as some information of the logs stored in this table.

  Enums:
    LogSourceValueValuesEnum: The source of log.
    LogTypeValueValuesEnum: The type of log.

  Fields:
    bigqueryTablePath: The created BigQuery table to store logs. Customer
      could do their own query & analysis. Format:
      `bq://.model_deployment_monitoring_._`
    logSource: The source of log.
    logType: The type of log.
  """

  class LogSourceValueValuesEnum(_messages.Enum):
    r"""The source of log.

    Values:
      LOG_SOURCE_UNSPECIFIED: Unspecified source.
      TRAINING: Logs coming from Training dataset.
      SERVING: Logs coming from Serving traffic.
    """
    LOG_SOURCE_UNSPECIFIED = 0
    TRAINING = 1
    SERVING = 2

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The type of log.

    Values:
      LOG_TYPE_UNSPECIFIED: Unspecified type.
      PREDICT: Predict logs.
      EXPLAIN: Explain logs.
    """
    LOG_TYPE_UNSPECIFIED = 0
    PREDICT = 1
    EXPLAIN = 2

  bigqueryTablePath = _messages.StringField(1)
  logSource = _messages.EnumField('LogSourceValueValuesEnum', 2)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 3)


class GoogleCloudAiplatformV1ModelDeploymentMonitoringJob(_messages.Message):
  r"""Represents a job that runs periodically to monitor the deployed models
  in an endpoint. It will analyze the logged training & prediction data to
  detect any abnormal behaviors.

  Enums:
    ScheduleStateValueValuesEnum: Output only. Schedule state when the
      monitoring job is in Running state.
    StateValueValuesEnum: Output only. The detailed state of the monitoring
      job. When the job is still creating, the state will be 'PENDING'. Once
      the job is successfully created, the state will be 'RUNNING'. Pause the
      job, the state will be 'PAUSED'. Resume the job, the state will return
      to 'RUNNING'.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      ModelDeploymentMonitoringJob. Label keys and values can be no longer
      than 64 characters (Unicode codepoints), can only contain lowercase
      letters, numeric characters, underscores and dashes. International
      characters are allowed. See https://goo.gl/xmQnxf for more information
      and examples of labels.

  Fields:
    analysisInstanceSchemaUri: YAML schema file uri describing the format of a
      single instance that you want Tensorflow Data Validation (TFDV) to
      analyze. If this field is empty, all the feature data types are inferred
      from predict_instance_schema_uri, meaning that TFDV will use the data in
      the exact format(data type) as prediction request/response. If there are
      any data type differences between predict instance and TFDV instance,
      this field can be used to override the schema. For models trained with
      Vertex AI, this field must be set as all the fields in predict instance
      formatted as string.
    bigqueryTables: Output only. The created bigquery tables for the job under
      customer project. Customer could do their own query & analysis. There
      could be 4 log tables in maximum: 1. Training data logging predict
      request/response 2. Serving data logging predict request/response
    createTime: Output only. Timestamp when this ModelDeploymentMonitoringJob
      was created.
    displayName: Required. The user-defined name of the
      ModelDeploymentMonitoringJob. The name can be up to 128 characters long
      and can consist of any UTF-8 characters. Display name of a
      ModelDeploymentMonitoringJob.
    enableMonitoringPipelineLogs: If true, the scheduled monitoring pipeline
      logs are sent to Google Cloud Logging, including pipeline status and
      anomalies detected. Please note the logs incur cost, which are subject
      to [Cloud Logging pricing](https://cloud.google.com/logging#pricing).
    encryptionSpec: Customer-managed encryption key spec for a
      ModelDeploymentMonitoringJob. If set, this ModelDeploymentMonitoringJob
      and all sub-resources of this ModelDeploymentMonitoringJob will be
      secured by this key.
    endpoint: Required. Endpoint resource name. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    error: Output only. Only populated when the job's state is
      `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
    labels: The labels with user-defined metadata to organize your
      ModelDeploymentMonitoringJob. Label keys and values can be no longer
      than 64 characters (Unicode codepoints), can only contain lowercase
      letters, numeric characters, underscores and dashes. International
      characters are allowed. See https://goo.gl/xmQnxf for more information
      and examples of labels.
    latestMonitoringPipelineMetadata: Output only. Latest triggered monitoring
      pipeline metadata.
    logTtl: The TTL of BigQuery tables in user projects which stores logs. A
      day is the basic unit of the TTL and we take the ceil of TTL/86400(a
      day). e.g. { second: 3600} indicates ttl = 1 day.
    loggingSamplingStrategy: Required. Sample Strategy for logging.
    modelDeploymentMonitoringObjectiveConfigs: Required. The config for
      monitoring objectives. This is a per DeployedModel config. Each
      DeployedModel needs to be configured separately.
    modelDeploymentMonitoringScheduleConfig: Required. Schedule config for
      running the monitoring job.
    modelMonitoringAlertConfig: Alert config for model monitoring.
    name: Output only. Resource name of a ModelDeploymentMonitoringJob.
    nextScheduleTime: Output only. Timestamp when this monitoring pipeline
      will be scheduled to run for the next round.
    predictInstanceSchemaUri: YAML schema file uri describing the format of a
      single instance, which are given to format this Endpoint's prediction
      (and explanation). If not set, we will generate predict schema from
      collected predict requests.
    samplePredictInstance: Sample Predict instance, same format as
      PredictRequest.instances, this can be set as a replacement of
      ModelDeploymentMonitoringJob.predict_instance_schema_uri. If not set, we
      will generate predict schema from collected predict requests.
    scheduleState: Output only. Schedule state when the monitoring job is in
      Running state.
    state: Output only. The detailed state of the monitoring job. When the job
      is still creating, the state will be 'PENDING'. Once the job is
      successfully created, the state will be 'RUNNING'. Pause the job, the
      state will be 'PAUSED'. Resume the job, the state will return to
      'RUNNING'.
    statsAnomaliesBaseDirectory: Stats anomalies base folder path.
    updateTime: Output only. Timestamp when this ModelDeploymentMonitoringJob
      was updated most recently.
  """

  class ScheduleStateValueValuesEnum(_messages.Enum):
    r"""Output only. Schedule state when the monitoring job is in Running
    state.

    Values:
      MONITORING_SCHEDULE_STATE_UNSPECIFIED: Unspecified state.
      PENDING: The pipeline is picked up and wait to run.
      OFFLINE: The pipeline is offline and will be scheduled for next run.
      RUNNING: The pipeline is running.
    """
    MONITORING_SCHEDULE_STATE_UNSPECIFIED = 0
    PENDING = 1
    OFFLINE = 2
    RUNNING = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the monitoring job. When the job is
    still creating, the state will be 'PENDING'. Once the job is successfully
    created, the state will be 'RUNNING'. Pause the job, the state will be
    'PAUSED'. Resume the job, the state will return to 'RUNNING'.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your
    ModelDeploymentMonitoringJob. Label keys and values can be no longer than
    64 characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  analysisInstanceSchemaUri = _messages.StringField(1)
  bigqueryTables = _messages.MessageField('GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable', 2, repeated=True)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  enableMonitoringPipelineLogs = _messages.BooleanField(5)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 6)
  endpoint = _messages.StringField(7)
  error = _messages.MessageField('GoogleRpcStatus', 8)
  labels = _messages.MessageField('LabelsValue', 9)
  latestMonitoringPipelineMetadata = _messages.MessageField('GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata', 10)
  logTtl = _messages.StringField(11)
  loggingSamplingStrategy = _messages.MessageField('GoogleCloudAiplatformV1SamplingStrategy', 12)
  modelDeploymentMonitoringObjectiveConfigs = _messages.MessageField('GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig', 13, repeated=True)
  modelDeploymentMonitoringScheduleConfig = _messages.MessageField('GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig', 14)
  modelMonitoringAlertConfig = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringAlertConfig', 15)
  name = _messages.StringField(16)
  nextScheduleTime = _messages.StringField(17)
  predictInstanceSchemaUri = _messages.StringField(18)
  samplePredictInstance = _messages.MessageField('extra_types.JsonValue', 19)
  scheduleState = _messages.EnumField('ScheduleStateValueValuesEnum', 20)
  state = _messages.EnumField('StateValueValuesEnum', 21)
  statsAnomaliesBaseDirectory = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 22)
  updateTime = _messages.StringField(23)


class GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata(_messages.Message):
  r"""All metadata of most recent monitoring pipelines.

  Fields:
    runTime: The time that most recent monitoring pipelines that is related to
      this run.
    status: The status of the most recent monitoring pipeline.
  """

  runTime = _messages.StringField(1)
  status = _messages.MessageField('GoogleRpcStatus', 2)


class GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig(_messages.Message):
  r"""ModelDeploymentMonitoringObjectiveConfig contains the pair of
  deployed_model_id to ModelMonitoringObjectiveConfig.

  Fields:
    deployedModelId: The DeployedModel ID of the objective config.
    objectiveConfig: The objective config of for the modelmonitoring job of
      this deployed model.
  """

  deployedModelId = _messages.StringField(1)
  objectiveConfig = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig', 2)


class GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig(_messages.Message):
  r"""The config for scheduling monitoring job.

  Fields:
    monitorInterval: Required. The model monitoring job scheduling interval.
      It will be rounded up to next full hour. This defines how often the
      monitoring jobs are triggered.
    monitorWindow: The time window of the prediction data being included in
      each prediction dataset. This window specifies how long the data should
      be collected from historical model results for each run. If not set,
      ModelDeploymentMonitoringScheduleConfig.monitor_interval will be used.
      e.g. If currently the cutoff time is 2022-01-08 14:30:00 and the
      monitor_window is set to be 3600, then data from 2022-01-08 13:30:00 to
      2022-01-08 14:30:00 will be retrieved and aggregated to calculate the
      monitoring statistics.
  """

  monitorInterval = _messages.StringField(1)
  monitorWindow = _messages.StringField(2)


class GoogleCloudAiplatformV1ModelEvaluation(_messages.Message):
  r"""A collection of metrics calculated by comparing Model's predictions on
  all of the test data against annotations from the test data.

  Fields:
    annotationSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing EvaluatedDataItemView.predictions,
      EvaluatedDataItemView.ground_truths, EvaluatedAnnotation.predictions,
      and EvaluatedAnnotation.ground_truths. The schema is defined as an
      OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). This field is
      not populated if there are neither EvaluatedDataItemViews nor
      EvaluatedAnnotations under this ModelEvaluation.
    createTime: Output only. Timestamp when this ModelEvaluation was created.
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing EvaluatedDataItemView.data_item_payload and
      EvaluatedAnnotation.data_item_payload. The schema is defined as an
      OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). This field is
      not populated if there are neither EvaluatedDataItemViews nor
      EvaluatedAnnotations under this ModelEvaluation.
    displayName: The display name of the ModelEvaluation.
    explanationSpecs: Describes the values of ExplanationSpec that are used
      for explaining the predicted values on the evaluated data.
    metadata: The metadata of the ModelEvaluation. For the ModelEvaluation
      uploaded from Managed Pipeline, metadata contains a structured value
      with keys of "pipeline_job_id", "evaluation_dataset_type",
      "evaluation_dataset_path".
    metrics: Evaluation metrics of the Model. The schema of the metrics is
      stored in metrics_schema_uri
    metricsSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing the metrics of this ModelEvaluation. The schema is defined as
      an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject).
    modelExplanation: Aggregated explanation metrics for the Model's
      prediction output over the data this ModelEvaluation uses. This field is
      populated only if the Model is evaluated with explanations, and only for
      AutoML tabular Models.
    name: Output only. The resource name of the ModelEvaluation.
    sliceDimensions: All possible dimensions of ModelEvaluationSlices. The
      dimensions can be used as the filter of the
      ModelService.ListModelEvaluationSlices request, in the form of
      `slice.dimension = `.
  """

  annotationSchemaUri = _messages.StringField(1)
  createTime = _messages.StringField(2)
  dataItemSchemaUri = _messages.StringField(3)
  displayName = _messages.StringField(4)
  explanationSpecs = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec', 5, repeated=True)
  metadata = _messages.MessageField('extra_types.JsonValue', 6)
  metrics = _messages.MessageField('extra_types.JsonValue', 7)
  metricsSchemaUri = _messages.StringField(8)
  modelExplanation = _messages.MessageField('GoogleCloudAiplatformV1ModelExplanation', 9)
  name = _messages.StringField(10)
  sliceDimensions = _messages.StringField(11, repeated=True)


class GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec(_messages.Message):
  r"""A GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec
  object.

  Fields:
    explanationSpec: Explanation spec details.
    explanationType: Explanation type. For AutoML Image Classification models,
      possible values are: * `image-integrated-gradients` * `image-xrai`
  """

  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1ExplanationSpec', 1)
  explanationType = _messages.StringField(2)


class GoogleCloudAiplatformV1ModelEvaluationSlice(_messages.Message):
  r"""A collection of metrics calculated by comparing Model's predictions on a
  slice of the test data against ground truth annotations.

  Fields:
    createTime: Output only. Timestamp when this ModelEvaluationSlice was
      created.
    metrics: Output only. Sliced evaluation metrics of the Model. The schema
      of the metrics is stored in metrics_schema_uri
    metricsSchemaUri: Output only. Points to a YAML file stored on Google
      Cloud Storage describing the metrics of this ModelEvaluationSlice. The
      schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject).
    modelExplanation: Output only. Aggregated explanation metrics for the
      Model's prediction output over the data this ModelEvaluation uses. This
      field is populated only if the Model is evaluated with explanations, and
      only for tabular Models.
    name: Output only. The resource name of the ModelEvaluationSlice.
    slice: Output only. The slice of the test data that is used to evaluate
      the Model.
  """

  createTime = _messages.StringField(1)
  metrics = _messages.MessageField('extra_types.JsonValue', 2)
  metricsSchemaUri = _messages.StringField(3)
  modelExplanation = _messages.MessageField('GoogleCloudAiplatformV1ModelExplanation', 4)
  name = _messages.StringField(5)
  slice = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationSliceSlice', 6)


class GoogleCloudAiplatformV1ModelEvaluationSliceSlice(_messages.Message):
  r"""Definition of a slice.

  Fields:
    dimension: Output only. The dimension of the slice. Well-known dimensions
      are: * `annotationSpec`: This slice is on the test data that has either
      ground truth or prediction with AnnotationSpec.display_name equals to
      value. * `slice`: This slice is a user customized slice defined by its
      SliceSpec.
    sliceSpec: Output only. Specification for how the data was sliced.
    value: Output only. The value of the dimension in this slice.
  """

  dimension = _messages.StringField(1)
  sliceSpec = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec', 2)
  value = _messages.StringField(3)


class GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec(_messages.Message):
  r"""Specification for how the data should be sliced.

  Messages:
    ConfigsValue: Mapping configuration for this SliceSpec. The key is the
      name of the feature. By default, the key will be prefixed by "instance"
      as a dictionary prefix for Vertex Batch Predictions output format.

  Fields:
    configs: Mapping configuration for this SliceSpec. The key is the name of
      the feature. By default, the key will be prefixed by "instance" as a
      dictionary prefix for Vertex Batch Predictions output format.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigsValue(_messages.Message):
    r"""Mapping configuration for this SliceSpec. The key is the name of the
    feature. By default, the key will be prefixed by "instance" as a
    dictionary prefix for Vertex Batch Predictions output format.

    Messages:
      AdditionalProperty: An additional property for a ConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type ConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  configs = _messages.MessageField('ConfigsValue', 1)


class GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange(_messages.Message):
  r"""A range of values for slice(s). `low` is inclusive, `high` is exclusive.

  Fields:
    high: Exclusive high value for the range.
    low: Inclusive low value for the range.
  """

  high = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  low = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig(_messages.Message):
  r"""Specification message containing the config for this SliceSpec. When
  `kind` is selected as `value` and/or `range`, only a single slice will be
  computed. When `all_values` is present, a separate slice will be computed
  for each possible label/value for the corresponding key in `config`.
  Examples, with feature zip_code with values 12345, 23334, 88888 and feature
  country with values "US", "Canada", "Mexico" in the dataset: Example 1: {
  "zip_code": { "value": { "float_value": 12345.0 } } } A single slice for any
  data with zip_code 12345 in the dataset. Example 2: { "zip_code": { "range":
  { "low": 12345, "high": 20000 } } } A single slice containing data where the
  zip_codes between 12345 and 20000 For this example, data with the zip_code
  of 12345 will be in this slice. Example 3: { "zip_code": { "range": { "low":
  10000, "high": 20000 } }, "country": { "value": { "string_value": "US" } } }
  A single slice containing data where the zip_codes between 10000 and 20000
  has the country "US". For this example, data with the zip_code of 12345 and
  country "US" will be in this slice. Example 4: { "country": {"all_values": {
  "value": true } } } Three slices are computed, one for each unique country
  in the dataset. Example 5: { "country": { "all_values": { "value": true } },
  "zip_code": { "value": { "float_value": 12345.0 } } } Three slices are
  computed, one for each unique country in the dataset where the zip_code is
  also 12345. For this example, data with zip_code 12345 and country "US" will
  be in one slice, zip_code 12345 and country "Canada" in another slice, and
  zip_code 12345 and country "Mexico" in another slice, totaling 3 slices.

  Fields:
    allValues: If all_values is set to true, then all possible labels of the
      keyed feature will have another slice computed. Example:
      `{"all_values":{"value":true}}`
    range: A range of values for a numerical feature. Example:
      `{"range":{"low":10000.0,"high":50000.0}}` will capture 12345 and 23334
      in the slice.
    value: A unique specific value for a given feature. Example: `{ "value": {
      "string_value": "12345" } }`
  """

  allValues = _messages.BooleanField(1)
  range = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange', 2)
  value = _messages.MessageField('GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue', 3)


class GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue(_messages.Message):
  r"""Single value that supports strings and floats.

  Fields:
    floatValue: Float type.
    stringValue: String type.
  """

  floatValue = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  stringValue = _messages.StringField(2)


class GoogleCloudAiplatformV1ModelExplanation(_messages.Message):
  r"""Aggregated explanation metrics for a Model over a set of instances.

  Fields:
    meanAttributions: Output only. Aggregated attributions explaining the
      Model's prediction outputs over the set of instances. The attributions
      are grouped by outputs. For Models that predict only one output, such as
      regression Models that predict only one score, there is only one
      attibution that explains the predicted output. For Models that predict
      multiple outputs, such as multiclass Models that predict multiple
      classes, each element explains one specific item.
      Attribution.output_index can be used to identify which output this
      attribution is explaining. The baselineOutputValue, instanceOutputValue
      and featureAttributions fields are averaged over the test data. NOTE:
      Currently AutoML tabular classification Models produce only one
      attribution, which averages attributions over all the classes it
      predicts. Attribution.approximation_error is not populated.
  """

  meanAttributions = _messages.MessageField('GoogleCloudAiplatformV1Attribution', 1, repeated=True)


class GoogleCloudAiplatformV1ModelExportFormat(_messages.Message):
  r"""Represents export format supported by the Model. All formats export to
  Google Cloud Storage.

  Enums:
    ExportableContentsValueListEntryValuesEnum:

  Fields:
    exportableContents: Output only. The content of this Model that may be
      exported.
    id: Output only. The ID of the export format. The possible format IDs are:
      * `tflite` Used for Android mobile devices. * `edgetpu-tflite` Used for
      [Edge TPU](https://cloud.google.com/edge-tpu/) devices. * `tf-saved-
      model` A tensorflow model in SavedModel format. * `tf-js` A
      [TensorFlow.js](https://www.tensorflow.org/js) model that can be used in
      the browser and in Node.js using JavaScript. * `core-ml` Used for iOS
      mobile devices. * `custom-trained` A Model that was uploaded or trained
      by custom code.
  """

  class ExportableContentsValueListEntryValuesEnum(_messages.Enum):
    r"""ExportableContentsValueListEntryValuesEnum enum type.

    Values:
      EXPORTABLE_CONTENT_UNSPECIFIED: Should not be used.
      ARTIFACT: Model artifact and any of its supported files. Will be
        exported to the location specified by the `artifactDestination` field
        of the ExportModelRequest.output_config object.
      IMAGE: The container image that is to be used when deploying this Model.
        Will be exported to the location specified by the `imageDestination`
        field of the ExportModelRequest.output_config object.
    """
    EXPORTABLE_CONTENT_UNSPECIFIED = 0
    ARTIFACT = 1
    IMAGE = 2

  exportableContents = _messages.EnumField('ExportableContentsValueListEntryValuesEnum', 1, repeated=True)
  id = _messages.StringField(2)


class GoogleCloudAiplatformV1ModelMonitoringAlertConfig(_messages.Message):
  r"""A GoogleCloudAiplatformV1ModelMonitoringAlertConfig object.

  Fields:
    emailAlertConfig: Email alert config.
    enableLogging: Dump the anomalies to Cloud Logging. The anomalies will be
      put to json payload encoded from proto
      google.cloud.aiplatform.logging.ModelMonitoringAnomaliesLogEntry. This
      can be further sinked to Pub/Sub or any other services supported by
      Cloud Logging.
  """

  emailAlertConfig = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig', 1)
  enableLogging = _messages.BooleanField(2)


class GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig(_messages.Message):
  r"""The config for email alert.

  Fields:
    userEmails: The email addresses to send the alert.
  """

  userEmails = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig(_messages.Message):
  r"""The objective configuration for model monitoring, including the
  information needed to detect anomalies for one particular model.

  Fields:
    explanationConfig: The config for integrating with Vertex Explainable AI.
    predictionDriftDetectionConfig: The config for drift of prediction data.
    trainingDataset: Training dataset for models. This field has to be set
      only if TrainingPredictionSkewDetectionConfig is specified.
    trainingPredictionSkewDetectionConfig: The config for skew between
      training data and prediction data.
  """

  explanationConfig = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig', 1)
  predictionDriftDetectionConfig = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig', 2)
  trainingDataset = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset', 3)
  trainingPredictionSkewDetectionConfig = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig', 4)


class GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig(_messages.Message):
  r"""The config for integrating with Vertex Explainable AI. Only applicable
  if the Model has explanation_spec populated.

  Fields:
    enableFeatureAttributes: If want to analyze the Vertex Explainable AI
      feature attribute scores or not. If set to true, Vertex AI will log the
      feature attributions from explain response and do the skew/drift
      detection for them.
    explanationBaseline: Predictions generated by the BatchPredictionJob using
      baseline dataset.
  """

  enableFeatureAttributes = _messages.BooleanField(1)
  explanationBaseline = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline', 2)


class GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline(_messages.Message):
  r"""Output from BatchPredictionJob for Model Monitoring baseline dataset,
  which can be used to generate baseline attribution scores.

  Enums:
    PredictionFormatValueValuesEnum: The storage format of the predictions
      generated BatchPrediction job.

  Fields:
    bigquery: BigQuery location for BatchExplain output.
    gcs: Cloud Storage location for BatchExplain output.
    predictionFormat: The storage format of the predictions generated
      BatchPrediction job.
  """

  class PredictionFormatValueValuesEnum(_messages.Enum):
    r"""The storage format of the predictions generated BatchPrediction job.

    Values:
      PREDICTION_FORMAT_UNSPECIFIED: Should not be set.
      JSONL: Predictions are in JSONL files.
      BIGQUERY: Predictions are in BigQuery.
    """
    PREDICTION_FORMAT_UNSPECIFIED = 0
    JSONL = 1
    BIGQUERY = 2

  bigquery = _messages.MessageField('GoogleCloudAiplatformV1BigQueryDestination', 1)
  gcs = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 2)
  predictionFormat = _messages.EnumField('PredictionFormatValueValuesEnum', 3)


class GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig(_messages.Message):
  r"""The config for Prediction data drift detection.

  Messages:
    AttributionScoreDriftThresholdsValue: Key is the feature name and value is
      the threshold. The threshold here is against attribution score distance
      between different time windows.
    DriftThresholdsValue: Key is the feature name and value is the threshold.
      If a feature needs to be monitored for drift, a value threshold must be
      configured for that feature. The threshold here is against feature
      distribution distance between different time windws.

  Fields:
    attributionScoreDriftThresholds: Key is the feature name and value is the
      threshold. The threshold here is against attribution score distance
      between different time windows.
    defaultDriftThreshold: Drift anomaly detection threshold used by all
      features. When the per-feature thresholds are not set, this field can be
      used to specify a threshold for all features.
    driftThresholds: Key is the feature name and value is the threshold. If a
      feature needs to be monitored for drift, a value threshold must be
      configured for that feature. The threshold here is against feature
      distribution distance between different time windws.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributionScoreDriftThresholdsValue(_messages.Message):
    r"""Key is the feature name and value is the threshold. The threshold here
    is against attribution score distance between different time windows.

    Messages:
      AdditionalProperty: An additional property for a
        AttributionScoreDriftThresholdsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AttributionScoreDriftThresholdsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributionScoreDriftThresholdsValue
      object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1ThresholdConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ThresholdConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DriftThresholdsValue(_messages.Message):
    r"""Key is the feature name and value is the threshold. If a feature needs
    to be monitored for drift, a value threshold must be configured for that
    feature. The threshold here is against feature distribution distance
    between different time windws.

    Messages:
      AdditionalProperty: An additional property for a DriftThresholdsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DriftThresholdsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DriftThresholdsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1ThresholdConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ThresholdConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributionScoreDriftThresholds = _messages.MessageField('AttributionScoreDriftThresholdsValue', 1)
  defaultDriftThreshold = _messages.MessageField('GoogleCloudAiplatformV1ThresholdConfig', 2)
  driftThresholds = _messages.MessageField('DriftThresholdsValue', 3)


class GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset(_messages.Message):
  r"""Training Dataset information.

  Fields:
    bigquerySource: The BigQuery table of the unmanaged Dataset used to train
      this Model.
    dataFormat: Data format of the dataset, only applicable if the input is
      from Google Cloud Storage. The possible formats are: "tf-record" The
      source file is a TFRecord file. "csv" The source file is a CSV file.
      "jsonl" The source file is a JSONL file.
    dataset: The resource name of the Dataset used to train this Model.
    gcsSource: The Google Cloud Storage uri of the unmanaged Dataset used to
      train this Model.
    loggingSamplingStrategy: Strategy to sample data from Training Dataset. If
      not set, we process the whole dataset.
    targetField: The target field name the model is to predict. This field
      will be excluded when doing Predict and (or) Explain for the training
      data.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1BigQuerySource', 1)
  dataFormat = _messages.StringField(2)
  dataset = _messages.StringField(3)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1GcsSource', 4)
  loggingSamplingStrategy = _messages.MessageField('GoogleCloudAiplatformV1SamplingStrategy', 5)
  targetField = _messages.StringField(6)


class GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig(_messages.Message):
  r"""The config for Training & Prediction data skew detection. It specifies
  the training dataset sources and the skew detection parameters.

  Messages:
    AttributionScoreSkewThresholdsValue: Key is the feature name and value is
      the threshold. The threshold here is against attribution score distance
      between the training and prediction feature.
    SkewThresholdsValue: Key is the feature name and value is the threshold.
      If a feature needs to be monitored for skew, a value threshold must be
      configured for that feature. The threshold here is against feature
      distribution distance between the training and prediction feature.

  Fields:
    attributionScoreSkewThresholds: Key is the feature name and value is the
      threshold. The threshold here is against attribution score distance
      between the training and prediction feature.
    defaultSkewThreshold: Skew anomaly detection threshold used by all
      features. When the per-feature thresholds are not set, this field can be
      used to specify a threshold for all features.
    skewThresholds: Key is the feature name and value is the threshold. If a
      feature needs to be monitored for skew, a value threshold must be
      configured for that feature. The threshold here is against feature
      distribution distance between the training and prediction feature.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributionScoreSkewThresholdsValue(_messages.Message):
    r"""Key is the feature name and value is the threshold. The threshold here
    is against attribution score distance between the training and prediction
    feature.

    Messages:
      AdditionalProperty: An additional property for a
        AttributionScoreSkewThresholdsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AttributionScoreSkewThresholdsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributionScoreSkewThresholdsValue
      object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1ThresholdConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ThresholdConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SkewThresholdsValue(_messages.Message):
    r"""Key is the feature name and value is the threshold. If a feature needs
    to be monitored for skew, a value threshold must be configured for that
    feature. The threshold here is against feature distribution distance
    between the training and prediction feature.

    Messages:
      AdditionalProperty: An additional property for a SkewThresholdsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SkewThresholdsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SkewThresholdsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1ThresholdConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ThresholdConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributionScoreSkewThresholds = _messages.MessageField('AttributionScoreSkewThresholdsValue', 1)
  defaultSkewThreshold = _messages.MessageField('GoogleCloudAiplatformV1ThresholdConfig', 2)
  skewThresholds = _messages.MessageField('SkewThresholdsValue', 3)


class GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies(_messages.Message):
  r"""Statistics and anomalies generated by Model Monitoring.

  Enums:
    ObjectiveValueValuesEnum: Model Monitoring Objective those stats and
      anomalies belonging to.

  Fields:
    anomalyCount: Number of anomalies within all stats.
    deployedModelId: Deployed Model ID.
    featureStats: A list of historical Stats and Anomalies generated for all
      Features.
    objective: Model Monitoring Objective those stats and anomalies belonging
      to.
  """

  class ObjectiveValueValuesEnum(_messages.Enum):
    r"""Model Monitoring Objective those stats and anomalies belonging to.

    Values:
      MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED: Default value,
        should not be set.
      RAW_FEATURE_SKEW: Raw feature values' stats to detect skew between
        Training-Prediction datasets.
      RAW_FEATURE_DRIFT: Raw feature values' stats to detect drift between
        Serving-Prediction datasets.
      FEATURE_ATTRIBUTION_SKEW: Feature attribution scores to detect skew
        between Training-Prediction datasets.
      FEATURE_ATTRIBUTION_DRIFT: Feature attribution scores to detect skew
        between Prediction datasets collected within different time windows.
    """
    MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED = 0
    RAW_FEATURE_SKEW = 1
    RAW_FEATURE_DRIFT = 2
    FEATURE_ATTRIBUTION_SKEW = 3
    FEATURE_ATTRIBUTION_DRIFT = 4

  anomalyCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  deployedModelId = _messages.StringField(2)
  featureStats = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies', 3, repeated=True)
  objective = _messages.EnumField('ObjectiveValueValuesEnum', 4)


class GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies(_messages.Message):
  r"""Historical Stats (and Anomalies) for a specific Feature.

  Fields:
    featureDisplayName: Display Name of the Feature.
    predictionStats: A list of historical stats generated by different time
      window's Prediction Dataset.
    threshold: Threshold for anomaly detection.
    trainingStats: Stats calculated for the Training Dataset.
  """

  featureDisplayName = _messages.StringField(1)
  predictionStats = _messages.MessageField('GoogleCloudAiplatformV1FeatureStatsAnomaly', 2, repeated=True)
  threshold = _messages.MessageField('GoogleCloudAiplatformV1ThresholdConfig', 3)
  trainingStats = _messages.MessageField('GoogleCloudAiplatformV1FeatureStatsAnomaly', 4)


class GoogleCloudAiplatformV1ModelOriginalModelInfo(_messages.Message):
  r"""Contains information about the original Model if this Model is a copy.

  Fields:
    model: Output only. The resource name of the Model this Model is a copy
      of, including the revision. Format:
      `projects/{project}/locations/{location}/models/{model_id}@{version_id}`
  """

  model = _messages.StringField(1)


class GoogleCloudAiplatformV1ModelSourceInfo(_messages.Message):
  r"""Detail description of the source information of the model.

  Enums:
    SourceTypeValueValuesEnum: Type of the model source.

  Fields:
    sourceType: Type of the model source.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""Type of the model source.

    Values:
      MODEL_SOURCE_TYPE_UNSPECIFIED: Should not be used.
      AUTOML: The Model is uploaded by automl training pipeline.
      CUSTOM: The Model is uploaded by user or custom training pipeline.
      BQML: The Model is registered and sync'ed from BigQuery ML.
    """
    MODEL_SOURCE_TYPE_UNSPECIFIED = 0
    AUTOML = 1
    CUSTOM = 2
    BQML = 3

  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 1)


class GoogleCloudAiplatformV1MutateDeployedIndexOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  IndexEndpointService.MutateDeployedIndex.

  Fields:
    deployedIndexId: The unique index id specified by user
    genericMetadata: The operation generic information.
  """

  deployedIndexId = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1MutateDeployedIndexResponse(_messages.Message):
  r"""Response message for IndexEndpointService.MutateDeployedIndex.

  Fields:
    deployedIndex: The DeployedIndex that had been updated in the
      IndexEndpoint.
  """

  deployedIndex = _messages.MessageField('GoogleCloudAiplatformV1DeployedIndex', 1)


class GoogleCloudAiplatformV1MutateDeployedModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.MutateDeployedModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1MutateDeployedModelRequest(_messages.Message):
  r"""Request message for EndpointService.MutateDeployedModel.

  Fields:
    deployedModel: Required. The DeployedModel to be mutated within the
      Endpoint. Only the following fields can be mutated: *
      `min_replica_count` in either DedicatedResources or AutomaticResources *
      `max_replica_count` in either DedicatedResources or AutomaticResources *
      autoscaling_metric_specs * `disable_container_logging` (v1 only) *
      `enable_container_logging` (v1beta1 only)
    updateMask: Required. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1DeployedModel', 1)
  updateMask = _messages.StringField(2)


class GoogleCloudAiplatformV1MutateDeployedModelResponse(_messages.Message):
  r"""Response message for EndpointService.MutateDeployedModel.

  Fields:
    deployedModel: The DeployedModel that's being mutated.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1DeployedModel', 1)


class GoogleCloudAiplatformV1NasJob(_messages.Message):
  r"""Represents a Neural Architecture Search (NAS) job.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize NasJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.

  Fields:
    createTime: Output only. Time when the NasJob was created.
    displayName: Required. The display name of the NasJob. The name can be up
      to 128 characters long and can consist of any UTF-8 characters.
    enableRestrictedImageTraining: Optional. Enable a separation of Custom
      model training and restricted image training for tenant project.
    encryptionSpec: Customer-managed encryption key options for a NasJob. If
      this is set, then all resources created by the NasJob will be encrypted
      with the provided encryption key.
    endTime: Output only. Time when the NasJob entered any of the following
      states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is JOB_STATE_FAILED or
      JOB_STATE_CANCELLED.
    labels: The labels with user-defined metadata to organize NasJobs. Label
      keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    name: Output only. Resource name of the NasJob.
    nasJobOutput: Output only. Output of the NasJob.
    nasJobSpec: Required. The specification of a NasJob.
    startTime: Output only. Time when the NasJob for the first time entered
      the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Time when the NasJob was most recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize NasJobs. Label keys
    and values can be no longer than 64 characters (Unicode codepoints), can
    only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  enableRestrictedImageTraining = _messages.BooleanField(3)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 4)
  endTime = _messages.StringField(5)
  error = _messages.MessageField('GoogleRpcStatus', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  nasJobOutput = _messages.MessageField('GoogleCloudAiplatformV1NasJobOutput', 9)
  nasJobSpec = _messages.MessageField('GoogleCloudAiplatformV1NasJobSpec', 10)
  startTime = _messages.StringField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  updateTime = _messages.StringField(13)


class GoogleCloudAiplatformV1NasJobOutput(_messages.Message):
  r"""Represents a uCAIP NasJob output.

  Fields:
    multiTrialJobOutput: Output only. The output of this multi-trial Neural
      Architecture Search (NAS) job.
  """

  multiTrialJobOutput = _messages.MessageField('GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput', 1)


class GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput(_messages.Message):
  r"""The output of a multi-trial Neural Architecture Search (NAS) jobs.

  Fields:
    searchTrials: Output only. List of NasTrials that were started as part of
      search stage.
    trainTrials: Output only. List of NasTrials that were started as part of
      train stage.
  """

  searchTrials = _messages.MessageField('GoogleCloudAiplatformV1NasTrial', 1, repeated=True)
  trainTrials = _messages.MessageField('GoogleCloudAiplatformV1NasTrial', 2, repeated=True)


class GoogleCloudAiplatformV1NasJobSpec(_messages.Message):
  r"""Represents the spec of a NasJob.

  Fields:
    multiTrialAlgorithmSpec: The spec of multi-trial algorithms.
    resumeNasJobId: The ID of the existing NasJob in the same Project and
      Location which will be used to resume search. search_space_spec and
      nas_algorithm_spec are obtained from previous NasJob hence should not
      provide them again for this NasJob.
    searchSpaceSpec: It defines the search space for Neural Architecture
      Search (NAS).
  """

  multiTrialAlgorithmSpec = _messages.MessageField('GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec', 1)
  resumeNasJobId = _messages.StringField(2)
  searchSpaceSpec = _messages.StringField(3)


class GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec(_messages.Message):
  r"""The spec of multi-trial Neural Architecture Search (NAS).

  Enums:
    MultiTrialAlgorithmValueValuesEnum: The multi-trial Neural Architecture
      Search (NAS) algorithm type. Defaults to `REINFORCEMENT_LEARNING`.

  Fields:
    metric: Metric specs for the NAS job. Validation for this field is done at
      `multi_trial_algorithm_spec` field.
    multiTrialAlgorithm: The multi-trial Neural Architecture Search (NAS)
      algorithm type. Defaults to `REINFORCEMENT_LEARNING`.
    searchTrialSpec: Required. Spec for search trials.
    trainTrialSpec: Spec for train trials. Top N
      [TrainTrialSpec.max_parallel_trial_count] search trials will be trained
      for every M [TrainTrialSpec.frequency] trials searched.
  """

  class MultiTrialAlgorithmValueValuesEnum(_messages.Enum):
    r"""The multi-trial Neural Architecture Search (NAS) algorithm type.
    Defaults to `REINFORCEMENT_LEARNING`.

    Values:
      MULTI_TRIAL_ALGORITHM_UNSPECIFIED: Defaults to `REINFORCEMENT_LEARNING`.
      REINFORCEMENT_LEARNING: The Reinforcement Learning Algorithm for Multi-
        trial Neural Architecture Search (NAS).
      GRID_SEARCH: The Grid Search Algorithm for Multi-trial Neural
        Architecture Search (NAS).
    """
    MULTI_TRIAL_ALGORITHM_UNSPECIFIED = 0
    REINFORCEMENT_LEARNING = 1
    GRID_SEARCH = 2

  metric = _messages.MessageField('GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec', 1)
  multiTrialAlgorithm = _messages.EnumField('MultiTrialAlgorithmValueValuesEnum', 2)
  searchTrialSpec = _messages.MessageField('GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec', 3)
  trainTrialSpec = _messages.MessageField('GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec', 4)


class GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec(_messages.Message):
  r"""Represents a metric to optimize.

  Enums:
    GoalValueValuesEnum: Required. The optimization goal of the metric.

  Fields:
    goal: Required. The optimization goal of the metric.
    metricId: Required. The ID of the metric. Must not contain whitespaces.
  """

  class GoalValueValuesEnum(_messages.Enum):
    r"""Required. The optimization goal of the metric.

    Values:
      GOAL_TYPE_UNSPECIFIED: Goal Type will default to maximize.
      MAXIMIZE: Maximize the goal metric.
      MINIMIZE: Minimize the goal metric.
    """
    GOAL_TYPE_UNSPECIFIED = 0
    MAXIMIZE = 1
    MINIMIZE = 2

  goal = _messages.EnumField('GoalValueValuesEnum', 1)
  metricId = _messages.StringField(2)


class GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec(_messages.Message):
  r"""Represent spec for search trials.

  Fields:
    maxFailedTrialCount: The number of failed trials that need to be seen
      before failing the NasJob. If set to 0, Vertex AI decides how many
      trials must fail before the whole job fails.
    maxParallelTrialCount: Required. The maximum number of trials to run in
      parallel.
    maxTrialCount: Required. The maximum number of Neural Architecture Search
      (NAS) trials to run.
    searchTrialJobSpec: Required. The spec of a search trial job. The same
      spec applies to all search trials.
  """

  maxFailedTrialCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxParallelTrialCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  maxTrialCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  searchTrialJobSpec = _messages.MessageField('GoogleCloudAiplatformV1CustomJobSpec', 4)


class GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec(_messages.Message):
  r"""Represent spec for train trials.

  Fields:
    frequency: Required. Frequency of search trials to start train stage. Top
      N [TrainTrialSpec.max_parallel_trial_count] search trials will be
      trained for every M [TrainTrialSpec.frequency] trials searched.
    maxParallelTrialCount: Required. The maximum number of trials to run in
      parallel.
    trainTrialJobSpec: Required. The spec of a train trial job. The same spec
      applies to all train trials.
  """

  frequency = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxParallelTrialCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  trainTrialJobSpec = _messages.MessageField('GoogleCloudAiplatformV1CustomJobSpec', 3)


class GoogleCloudAiplatformV1NasTrial(_messages.Message):
  r"""Represents a uCAIP NasJob trial.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the NasTrial.

  Fields:
    endTime: Output only. Time when the NasTrial's status changed to
      `SUCCEEDED` or `INFEASIBLE`.
    finalMeasurement: Output only. The final measurement containing the
      objective value.
    id: Output only. The identifier of the NasTrial assigned by the service.
    startTime: Output only. Time when the NasTrial was started.
    state: Output only. The detailed state of the NasTrial.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the NasTrial.

    Values:
      STATE_UNSPECIFIED: The NasTrial state is unspecified.
      REQUESTED: Indicates that a specific NasTrial has been requested, but it
        has not yet been suggested by the service.
      ACTIVE: Indicates that the NasTrial has been suggested.
      STOPPING: Indicates that the NasTrial should stop according to the
        service.
      SUCCEEDED: Indicates that the NasTrial is completed successfully.
      INFEASIBLE: Indicates that the NasTrial should not be attempted again.
        The service will set a NasTrial to INFEASIBLE when it's done but
        missing the final_measurement.
    """
    STATE_UNSPECIFIED = 0
    REQUESTED = 1
    ACTIVE = 2
    STOPPING = 3
    SUCCEEDED = 4
    INFEASIBLE = 5

  endTime = _messages.StringField(1)
  finalMeasurement = _messages.MessageField('GoogleCloudAiplatformV1Measurement', 2)
  id = _messages.StringField(3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleCloudAiplatformV1NasTrialDetail(_messages.Message):
  r"""Represents a NasTrial details along with its parameters. If there is a
  corresponding train NasTrial, the train NasTrial is also returned.

  Fields:
    name: Output only. Resource name of the NasTrialDetail.
    parameters: The parameters for the NasJob NasTrial.
    searchTrial: The requested search NasTrial.
    trainTrial: The train NasTrial corresponding to search_trial. Only
      populated if search_trial is used for training.
  """

  name = _messages.StringField(1)
  parameters = _messages.StringField(2)
  searchTrial = _messages.MessageField('GoogleCloudAiplatformV1NasTrial', 3)
  trainTrial = _messages.MessageField('GoogleCloudAiplatformV1NasTrial', 4)


class GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata(_messages.Message):
  r"""Runtime operation metadata with regard to Matching Engine Index.

  Fields:
    contentValidationStats: The validation stats of the content (per file) to
      be inserted or updated on the Matching Engine Index resource. Populated
      if contentsDeltaUri is provided as part of Index.metadata. Please note
      that, currently for those files that are broken or has unsupported file
      format, we will not have the stats for those files.
    dataBytesCount: The ingested data size in bytes.
  """

  contentValidationStats = _messages.MessageField('GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats', 1, repeated=True)
  dataBytesCount = _messages.IntegerField(2)


class GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats(_messages.Message):
  r"""A GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentVa
  lidationStats object.

  Fields:
    invalidRecordCount: Number of records in this file we skipped due to
      validate errors.
    partialErrors: The detail information of the partial failures encountered
      for those invalid records that couldn't be parsed. Up to 50 partial
      errors will be reported.
    sourceGcsUri: Cloud Storage URI pointing to the original file in user's
      bucket.
    validRecordCount: Number of records in this file that were successfully
      processed.
  """

  invalidRecordCount = _messages.IntegerField(1)
  partialErrors = _messages.MessageField('GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError', 2, repeated=True)
  sourceGcsUri = _messages.StringField(3)
  validRecordCount = _messages.IntegerField(4)


class GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError
  object.

  Enums:
    ErrorTypeValueValuesEnum: The error type of this record.

  Fields:
    embeddingId: Empty if the embedding id is failed to parse.
    errorMessage: A human-readable message that is shown to the user to help
      them fix the error. Note that this message may change from time to time,
      your code should check against error_type as the source of truth.
    errorType: The error type of this record.
    rawRecord: The original content of this record.
    sourceGcsUri: Cloud Storage URI pointing to the original file in user's
      bucket.
  """

  class ErrorTypeValueValuesEnum(_messages.Enum):
    r"""The error type of this record.

    Values:
      ERROR_TYPE_UNSPECIFIED: Default, shall not be used.
      EMPTY_LINE: The record is empty.
      INVALID_JSON_SYNTAX: Invalid json format.
      INVALID_CSV_SYNTAX: Invalid csv format.
      INVALID_AVRO_SYNTAX: Invalid avro format.
      INVALID_EMBEDDING_ID: The embedding id is not valid.
      EMBEDDING_SIZE_MISMATCH: The size of the embedding vectors does not
        match with the specified dimension.
      NAMESPACE_MISSING: The `namespace` field is missing.
    """
    ERROR_TYPE_UNSPECIFIED = 0
    EMPTY_LINE = 1
    INVALID_JSON_SYNTAX = 2
    INVALID_CSV_SYNTAX = 3
    INVALID_AVRO_SYNTAX = 4
    INVALID_EMBEDDING_ID = 5
    EMBEDDING_SIZE_MISMATCH = 6
    NAMESPACE_MISSING = 7

  embeddingId = _messages.StringField(1)
  errorMessage = _messages.StringField(2)
  errorType = _messages.EnumField('ErrorTypeValueValuesEnum', 3)
  rawRecord = _messages.StringField(4)
  sourceGcsUri = _messages.StringField(5)


class GoogleCloudAiplatformV1Neighbor(_messages.Message):
  r"""Neighbors for example-based explanations.

  Fields:
    neighborDistance: Output only. The neighbor distance.
    neighborId: Output only. The neighbor id.
  """

  neighborDistance = _messages.FloatField(1)
  neighborId = _messages.StringField(2)


class GoogleCloudAiplatformV1NfsMount(_messages.Message):
  r"""Represents a mount configuration for Network File System (NFS) to mount.

  Fields:
    mountPoint: Required. Destination mount path. The NFS will be mounted for
      the user under /mnt/nfs/
    path: Required. Source path exported from NFS server. Has to start with
      '/', and combined with the ip address, it indicates the source mount
      path in the form of `server:path`
    server: Required. IP address of the NFS server.
  """

  mountPoint = _messages.StringField(1)
  path = _messages.StringField(2)
  server = _messages.StringField(3)


class GoogleCloudAiplatformV1PauseModelDeploymentMonitoringJobRequest(_messages.Message):
  r"""Request message for JobService.PauseModelDeploymentMonitoringJob."""


class GoogleCloudAiplatformV1PauseScheduleRequest(_messages.Message):
  r"""Request message for ScheduleService.PauseSchedule."""


class GoogleCloudAiplatformV1PipelineJob(_messages.Message):
  r"""An instance of a machine learning PipelineJob.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      PipelineJob. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. Note there is some reserved label key for Vertex AI Pipelines. -
      `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
    PipelineSpecValue: The spec of the pipeline.

  Fields:
    createTime: Output only. Pipeline creation time.
    displayName: The display name of the Pipeline. The name can be up to 128
      characters long and can consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key spec for a pipelineJob. If
      set, this PipelineJob and all of its sub-resources will be secured by
      this key.
    endTime: Output only. Pipeline end time.
    error: Output only. The error that occurred during pipeline execution.
      Only populated when the pipeline's state is FAILED or CANCELLED.
    jobDetail: Output only. The details of pipeline run. Not available in the
      list view.
    labels: The labels with user-defined metadata to organize PipelineJob.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels. Note
      there is some reserved label key for Vertex AI Pipelines. - `vertex-ai-
      pipelines-run-billing-id`, user set value will get overrided.
    name: Output only. The resource name of the PipelineJob.
    network: The full name of the Compute Engine
      [network](/compute/docs/networks-and-firewalls#networks) to which the
      Pipeline Job's workload should be peered. For example,
      `projects/12345/global/networks/myVPC`.
      [Format](/compute/docs/reference/rest/v1/networks/insert) is of the form
      `projects/{project}/global/networks/{network}`. Where {project} is a
      project number, as in `12345`, and {network} is a network name. Private
      services access must already be configured for the network. Pipeline job
      will apply the network configuration to the Google Cloud resources being
      launched, if applied, such as Vertex AI Training or Dataflow job. If
      left unspecified, the workload is not peered with any network.
    pipelineSpec: The spec of the pipeline.
    runtimeConfig: Runtime config of the pipeline.
    scheduleName: Output only. The schedule resource name. Only returned if
      the Pipeline is created by Schedule API.
    serviceAccount: The service account that the pipeline workload runs as. If
      not specified, the Compute Engine default service account in the project
      will be used. See https://cloud.google.com/compute/docs/access/service-
      accounts#default_service_account Users starting the pipeline must have
      the `iam.serviceAccounts.actAs` permission on this service account.
    startTime: Output only. Pipeline start time.
    state: Output only. The detailed state of the job.
    templateMetadata: Output only. Pipeline template metadata. Will fill up
      fields if PipelineJob.template_uri is from supported template registry.
    templateUri: A template uri from where the PipelineJob.pipeline_spec, if
      empty, will be downloaded. Currently, only uri from Vertex Template
      Registry & Gallery is supported. Reference to
      https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-
      template.
    updateTime: Output only. Timestamp when this PipelineJob was most recently
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      PIPELINE_STATE_UNSPECIFIED: The pipeline state is unspecified.
      PIPELINE_STATE_QUEUED: The pipeline has been created or resumed, and
        processing has not yet begun.
      PIPELINE_STATE_PENDING: The service is preparing to run the pipeline.
      PIPELINE_STATE_RUNNING: The pipeline is in progress.
      PIPELINE_STATE_SUCCEEDED: The pipeline completed successfully.
      PIPELINE_STATE_FAILED: The pipeline failed.
      PIPELINE_STATE_CANCELLING: The pipeline is being cancelled. From this
        state, the pipeline may only go to either PIPELINE_STATE_SUCCEEDED,
        PIPELINE_STATE_FAILED or PIPELINE_STATE_CANCELLED.
      PIPELINE_STATE_CANCELLED: The pipeline has been cancelled.
      PIPELINE_STATE_PAUSED: The pipeline has been stopped, and can be
        resumed.
    """
    PIPELINE_STATE_UNSPECIFIED = 0
    PIPELINE_STATE_QUEUED = 1
    PIPELINE_STATE_PENDING = 2
    PIPELINE_STATE_RUNNING = 3
    PIPELINE_STATE_SUCCEEDED = 4
    PIPELINE_STATE_FAILED = 5
    PIPELINE_STATE_CANCELLING = 6
    PIPELINE_STATE_CANCELLED = 7
    PIPELINE_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize PipelineJob. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels. Note there is some reserved
    label key for Vertex AI Pipelines. - `vertex-ai-pipelines-run-billing-id`,
    user set value will get overrided.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PipelineSpecValue(_messages.Message):
    r"""The spec of the pipeline.

    Messages:
      AdditionalProperty: An additional property for a PipelineSpecValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PipelineSpecValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  jobDetail = _messages.MessageField('GoogleCloudAiplatformV1PipelineJobDetail', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  network = _messages.StringField(9)
  pipelineSpec = _messages.MessageField('PipelineSpecValue', 10)
  runtimeConfig = _messages.MessageField('GoogleCloudAiplatformV1PipelineJobRuntimeConfig', 11)
  scheduleName = _messages.StringField(12)
  serviceAccount = _messages.StringField(13)
  startTime = _messages.StringField(14)
  state = _messages.EnumField('StateValueValuesEnum', 15)
  templateMetadata = _messages.MessageField('GoogleCloudAiplatformV1PipelineTemplateMetadata', 16)
  templateUri = _messages.StringField(17)
  updateTime = _messages.StringField(18)


class GoogleCloudAiplatformV1PipelineJobDetail(_messages.Message):
  r"""The runtime detail of PipelineJob.

  Fields:
    pipelineContext: Output only. The context of the pipeline.
    pipelineRunContext: Output only. The context of the current pipeline run.
    taskDetails: Output only. The runtime details of the tasks under the
      pipeline.
  """

  pipelineContext = _messages.MessageField('GoogleCloudAiplatformV1Context', 1)
  pipelineRunContext = _messages.MessageField('GoogleCloudAiplatformV1Context', 2)
  taskDetails = _messages.MessageField('GoogleCloudAiplatformV1PipelineTaskDetail', 3, repeated=True)


class GoogleCloudAiplatformV1PipelineJobRuntimeConfig(_messages.Message):
  r"""The runtime config of a PipelineJob.

  Enums:
    FailurePolicyValueValuesEnum: Represents the failure policy of a pipeline.
      Currently, the default of a pipeline is that the pipeline will continue
      to run until no more tasks can be executed, also known as
      PIPELINE_FAILURE_POLICY_FAIL_SLOW. However, if a pipeline is set to
      PIPELINE_FAILURE_POLICY_FAIL_FAST, it will stop scheduling any new tasks
      when a task has failed. Any scheduled tasks will continue to completion.

  Messages:
    InputArtifactsValue: The runtime artifacts of the PipelineJob. The key
      will be the input artifact name and the value would be one of the
      InputArtifact.
    ParameterValuesValue: The runtime parameters of the PipelineJob. The
      parameters will be passed into PipelineJob.pipeline_spec to replace the
      placeholders at runtime. This field is used by pipelines built using
      `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as pipelines
      built using Kubeflow Pipelines SDK 1.9 or higher and the v2 DSL.
    ParametersValue: Deprecated. Use RuntimeConfig.parameter_values instead.
      The runtime parameters of the PipelineJob. The parameters will be passed
      into PipelineJob.pipeline_spec to replace the placeholders at runtime.
      This field is used by pipelines built using
      `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower, such as
      pipelines built using Kubeflow Pipelines SDK 1.8 or lower.

  Fields:
    failurePolicy: Represents the failure policy of a pipeline. Currently, the
      default of a pipeline is that the pipeline will continue to run until no
      more tasks can be executed, also known as
      PIPELINE_FAILURE_POLICY_FAIL_SLOW. However, if a pipeline is set to
      PIPELINE_FAILURE_POLICY_FAIL_FAST, it will stop scheduling any new tasks
      when a task has failed. Any scheduled tasks will continue to completion.
    gcsOutputDirectory: Required. A path in a Cloud Storage bucket, which will
      be treated as the root output directory of the pipeline. It is used by
      the system to generate the paths of output artifacts. The artifact paths
      are generated with a sub-path pattern `{job_id}/{task_id}/{output_key}`
      under the specified output directory. The service account specified in
      this pipeline must have the `storage.objects.get` and
      `storage.objects.create` permissions for this bucket.
    inputArtifacts: The runtime artifacts of the PipelineJob. The key will be
      the input artifact name and the value would be one of the InputArtifact.
    parameterValues: The runtime parameters of the PipelineJob. The parameters
      will be passed into PipelineJob.pipeline_spec to replace the
      placeholders at runtime. This field is used by pipelines built using
      `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as pipelines
      built using Kubeflow Pipelines SDK 1.9 or higher and the v2 DSL.
    parameters: Deprecated. Use RuntimeConfig.parameter_values instead. The
      runtime parameters of the PipelineJob. The parameters will be passed
      into PipelineJob.pipeline_spec to replace the placeholders at runtime.
      This field is used by pipelines built using
      `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower, such as
      pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
  """

  class FailurePolicyValueValuesEnum(_messages.Enum):
    r"""Represents the failure policy of a pipeline. Currently, the default of
    a pipeline is that the pipeline will continue to run until no more tasks
    can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW. However,
    if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it will stop
    scheduling any new tasks when a task has failed. Any scheduled tasks will
    continue to completion.

    Values:
      PIPELINE_FAILURE_POLICY_UNSPECIFIED: Default value, and follows fail
        slow behavior.
      PIPELINE_FAILURE_POLICY_FAIL_SLOW: Indicates that the pipeline should
        continue to run until all possible tasks have been scheduled and
        completed.
      PIPELINE_FAILURE_POLICY_FAIL_FAST: Indicates that the pipeline should
        stop scheduling new tasks after a task has failed.
    """
    PIPELINE_FAILURE_POLICY_UNSPECIFIED = 0
    PIPELINE_FAILURE_POLICY_FAIL_SLOW = 1
    PIPELINE_FAILURE_POLICY_FAIL_FAST = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputArtifactsValue(_messages.Message):
    r"""The runtime artifacts of the PipelineJob. The key will be the input
    artifact name and the value would be one of the InputArtifact.

    Messages:
      AdditionalProperty: An additional property for a InputArtifactsValue
        object.

    Fields:
      additionalProperties: Additional properties of type InputArtifactsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputArtifactsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1PipelineJobRuntimeConfigInputArtifact
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1PipelineJobRuntimeConfigInputArtifact', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParameterValuesValue(_messages.Message):
    r"""The runtime parameters of the PipelineJob. The parameters will be
    passed into PipelineJob.pipeline_spec to replace the placeholders at
    runtime. This field is used by pipelines built using
    `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as pipelines built
    using Kubeflow Pipelines SDK 1.9 or higher and the v2 DSL.

    Messages:
      AdditionalProperty: An additional property for a ParameterValuesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ParameterValuesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParameterValuesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Deprecated. Use RuntimeConfig.parameter_values instead. The runtime
    parameters of the PipelineJob. The parameters will be passed into
    PipelineJob.pipeline_spec to replace the placeholders at runtime. This
    field is used by pipelines built using
    `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower, such as
    pipelines built using Kubeflow Pipelines SDK 1.8 or lower.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1Value attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1Value', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  failurePolicy = _messages.EnumField('FailurePolicyValueValuesEnum', 1)
  gcsOutputDirectory = _messages.StringField(2)
  inputArtifacts = _messages.MessageField('InputArtifactsValue', 3)
  parameterValues = _messages.MessageField('ParameterValuesValue', 4)
  parameters = _messages.MessageField('ParametersValue', 5)


class GoogleCloudAiplatformV1PipelineJobRuntimeConfigInputArtifact(_messages.Message):
  r"""The type of an input artifact.

  Fields:
    artifactId: Artifact resource id from MLMD. Which is the last portion of
      an artifact resource name: `projects/{project}/locations/{location}/meta
      dataStores/default/artifacts/{artifact_id}`. The artifact must stay
      within the same project, location and default metadatastore as the
      pipeline.
  """

  artifactId = _messages.StringField(1)


class GoogleCloudAiplatformV1PipelineTaskDetail(_messages.Message):
  r"""The runtime detail of a task execution.

  Enums:
    StateValueValuesEnum: Output only. State of the task.

  Messages:
    InputsValue: Output only. The runtime input artifacts of the task.
    OutputsValue: Output only. The runtime output artifacts of the task.

  Fields:
    createTime: Output only. Task create time.
    endTime: Output only. Task end time.
    error: Output only. The error that occurred during task execution. Only
      populated when the task's state is FAILED or CANCELLED.
    execution: Output only. The execution metadata of the task.
    executorDetail: Output only. The detailed execution info.
    inputs: Output only. The runtime input artifacts of the task.
    outputs: Output only. The runtime output artifacts of the task.
    parentTaskId: Output only. The id of the parent task if the task is within
      a component scope. Empty if the task is at the root level.
    pipelineTaskStatus: Output only. A list of task status. This field keeps a
      record of task status evolving over time.
    startTime: Output only. Task start time.
    state: Output only. State of the task.
    taskId: Output only. The system generated ID of the task.
    taskName: Output only. The user specified name of the task that is defined
      in pipeline_spec.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the task.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      PENDING: Specifies pending state for the task.
      RUNNING: Specifies task is being executed.
      SUCCEEDED: Specifies task completed successfully.
      CANCEL_PENDING: Specifies Task cancel is in pending state.
      CANCELLING: Specifies task is being cancelled.
      CANCELLED: Specifies task was cancelled.
      FAILED: Specifies task failed.
      SKIPPED: Specifies task was skipped due to cache hit.
      NOT_TRIGGERED: Specifies that the task was not triggered because the
        task's trigger policy is not satisfied. The trigger policy is
        specified in the `condition` field of PipelineJob.pipeline_spec.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    SUCCEEDED = 3
    CANCEL_PENDING = 4
    CANCELLING = 5
    CANCELLED = 6
    FAILED = 7
    SKIPPED = 8
    NOT_TRIGGERED = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Output only. The runtime input artifacts of the task.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1PipelineTaskDetailArtifactList
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1PipelineTaskDetailArtifactList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Output only. The runtime output artifacts of the task.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1PipelineTaskDetailArtifactList
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1PipelineTaskDetailArtifactList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  error = _messages.MessageField('GoogleRpcStatus', 3)
  execution = _messages.MessageField('GoogleCloudAiplatformV1Execution', 4)
  executorDetail = _messages.MessageField('GoogleCloudAiplatformV1PipelineTaskExecutorDetail', 5)
  inputs = _messages.MessageField('InputsValue', 6)
  outputs = _messages.MessageField('OutputsValue', 7)
  parentTaskId = _messages.IntegerField(8)
  pipelineTaskStatus = _messages.MessageField('GoogleCloudAiplatformV1PipelineTaskDetailPipelineTaskStatus', 9, repeated=True)
  startTime = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  taskId = _messages.IntegerField(12)
  taskName = _messages.StringField(13)


class GoogleCloudAiplatformV1PipelineTaskDetailArtifactList(_messages.Message):
  r"""A list of artifact metadata.

  Fields:
    artifacts: Output only. A list of artifact metadata.
  """

  artifacts = _messages.MessageField('GoogleCloudAiplatformV1Artifact', 1, repeated=True)


class GoogleCloudAiplatformV1PipelineTaskDetailPipelineTaskStatus(_messages.Message):
  r"""A single record of the task status.

  Enums:
    StateValueValuesEnum: Output only. The state of the task.

  Fields:
    error: Output only. The error that occurred during the state. May be set
      when the state is any of the non-final state
      (PENDING/RUNNING/CANCELLING) or FAILED state. If the state is FAILED,
      the error here is final and not going to be retried. If the state is a
      non-final state, the error indicates a system-error being retried.
    state: Output only. The state of the task.
    updateTime: Output only. Update time of this status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the task.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      PENDING: Specifies pending state for the task.
      RUNNING: Specifies task is being executed.
      SUCCEEDED: Specifies task completed successfully.
      CANCEL_PENDING: Specifies Task cancel is in pending state.
      CANCELLING: Specifies task is being cancelled.
      CANCELLED: Specifies task was cancelled.
      FAILED: Specifies task failed.
      SKIPPED: Specifies task was skipped due to cache hit.
      NOT_TRIGGERED: Specifies that the task was not triggered because the
        task's trigger policy is not satisfied. The trigger policy is
        specified in the `condition` field of PipelineJob.pipeline_spec.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    SUCCEEDED = 3
    CANCEL_PENDING = 4
    CANCELLING = 5
    CANCELLED = 6
    FAILED = 7
    SKIPPED = 8
    NOT_TRIGGERED = 9

  error = _messages.MessageField('GoogleRpcStatus', 1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformV1PipelineTaskExecutorDetail(_messages.Message):
  r"""The runtime detail of a pipeline executor.

  Fields:
    containerDetail: Output only. The detailed info for a container executor.
    customJobDetail: Output only. The detailed info for a custom job executor.
  """

  containerDetail = _messages.MessageField('GoogleCloudAiplatformV1PipelineTaskExecutorDetailContainerDetail', 1)
  customJobDetail = _messages.MessageField('GoogleCloudAiplatformV1PipelineTaskExecutorDetailCustomJobDetail', 2)


class GoogleCloudAiplatformV1PipelineTaskExecutorDetailContainerDetail(_messages.Message):
  r"""The detail of a container execution. It contains the job names of the
  lifecycle of a container execution.

  Fields:
    failedMainJobs: Output only. The names of the previously failed CustomJob
      for the main container executions. The list includes the all attempts in
      chronological order.
    failedPreCachingCheckJobs: Output only. The names of the previously failed
      CustomJob for the pre-caching-check container executions. This job will
      be available if the PipelineJob.pipeline_spec specifies the
      `pre_caching_check` hook in the lifecycle events. The list includes the
      all attempts in chronological order.
    mainJob: Output only. The name of the CustomJob for the main container
      execution.
    preCachingCheckJob: Output only. The name of the CustomJob for the pre-
      caching-check container execution. This job will be available if the
      PipelineJob.pipeline_spec specifies the `pre_caching_check` hook in the
      lifecycle events.
  """

  failedMainJobs = _messages.StringField(1, repeated=True)
  failedPreCachingCheckJobs = _messages.StringField(2, repeated=True)
  mainJob = _messages.StringField(3)
  preCachingCheckJob = _messages.StringField(4)


class GoogleCloudAiplatformV1PipelineTaskExecutorDetailCustomJobDetail(_messages.Message):
  r"""The detailed info for a custom job executor.

  Fields:
    failedJobs: Output only. The names of the previously failed CustomJob. The
      list includes the all attempts in chronological order.
    job: Output only. The name of the CustomJob.
  """

  failedJobs = _messages.StringField(1, repeated=True)
  job = _messages.StringField(2)


class GoogleCloudAiplatformV1PipelineTemplateMetadata(_messages.Message):
  r"""Pipeline template metadata if PipelineJob.template_uri is from supported
  template registry. Currently, the only supported registry is Artifact
  Registry.

  Fields:
    version: The version_name in artifact registry. Will always be presented
      in output if the PipelineJob.template_uri is from supported template
      registry. Format is "sha256:abcdef123456...".
  """

  version = _messages.StringField(1)


class GoogleCloudAiplatformV1Port(_messages.Message):
  r"""Represents a network port in a container.

  Fields:
    containerPort: The number of the port to expose on the pod's IP address.
      Must be a valid port number, between 1 and 65535 inclusive.
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1PredefinedSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on the
  value of a provided key. Supported only for tabular Datasets.

  Fields:
    key: Required. The key is a name of one of the Dataset's data columns. The
      value of the key (either the label's value or value in the column) must
      be one of {`training`, `validation`, `test`}, and it defines to which
      set the given piece of data is assigned. If for a piece of data the key
      is not present or has an invalid value, that piece is ignored by the
      pipeline.
  """

  key = _messages.StringField(1)


class GoogleCloudAiplatformV1PredictRequest(_messages.Message):
  r"""Request message for PredictionService.Predict.

  Fields:
    instances: Required. The instances that are the input to the prediction
      call. A DeployedModel may have an upper limit on the number of instances
      it supports per request, and when it is exceeded the prediction call
      errors in case of AutoML Models, or, in case of customer created Models,
      the behaviour is as documented by that Model. The schema of any single
      instance may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's instance_schema_uri.
    parameters: The parameters that govern the prediction. The schema of the
      parameters may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's parameters_schema_uri.
  """

  instances = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)
  parameters = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1PredictRequestResponseLoggingConfig(_messages.Message):
  r"""Configuration for logging request-response to a BigQuery table.

  Fields:
    bigqueryDestination: BigQuery table for logging. If only given a project,
      a new dataset will be created with name `logging__` where will be made
      BigQuery-dataset-name compatible (e.g. most special characters will
      become underscores). If no table name is given, a new table will be
      created with name `request_response_logging`
    enabled: If logging is enabled or not.
    samplingRate: Percentage of requests to be logged, expressed as a fraction
      in range(0,1].
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1BigQueryDestination', 1)
  enabled = _messages.BooleanField(2)
  samplingRate = _messages.FloatField(3)


class GoogleCloudAiplatformV1PredictResponse(_messages.Message):
  r"""Response message for PredictionService.Predict.

  Fields:
    deployedModelId: ID of the Endpoint's DeployedModel that served this
      prediction.
    model: Output only. The resource name of the Model which is deployed as
      the DeployedModel that this prediction hits.
    modelDisplayName: Output only. The display name of the Model which is
      deployed as the DeployedModel that this prediction hits.
    modelVersionId: Output only. The version ID of the Model which is deployed
      as the DeployedModel that this prediction hits.
    predictions: The predictions that are the output of the predictions call.
      The schema of any single prediction may be specified via Endpoint's
      DeployedModels' Model's PredictSchemata's prediction_schema_uri.
  """

  deployedModelId = _messages.StringField(1)
  model = _messages.StringField(2)
  modelDisplayName = _messages.StringField(3)
  modelVersionId = _messages.StringField(4)
  predictions = _messages.MessageField('extra_types.JsonValue', 5, repeated=True)


class GoogleCloudAiplatformV1PredictSchemata(_messages.Message):
  r"""Contains the schemata used in Model's predictions and explanations via
  PredictionService.Predict, PredictionService.Explain and BatchPredictionJob.

  Fields:
    instanceSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing the format of a single instance, which are used in
      PredictRequest.instances, ExplainRequest.instances and
      BatchPredictionJob.input_config. The schema is defined as an OpenAPI
      3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models
      always have this field populated by Vertex AI. Note: The URI given on
      output will be immutable and probably different, including the URI
      scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    parametersSchemaUri: Immutable. Points to a YAML file stored on Google
      Cloud Storage describing the parameters of prediction and explanation
      via PredictRequest.parameters, ExplainRequest.parameters and
      BatchPredictionJob.model_parameters. The schema is defined as an OpenAPI
      3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models
      always have this field populated by Vertex AI, if no parameters are
      supported, then it is set to an empty string. Note: The URI given on
      output will be immutable and probably different, including the URI
      scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    predictionSchemaUri: Immutable. Points to a YAML file stored on Google
      Cloud Storage describing the format of a single prediction produced by
      this Model, which are returned via PredictResponse.predictions,
      ExplainResponse.explanations, and BatchPredictionJob.output_config. The
      schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models
      always have this field populated by Vertex AI. Note: The URI given on
      output will be immutable and probably different, including the URI
      scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
  """

  instanceSchemaUri = _messages.StringField(1)
  parametersSchemaUri = _messages.StringField(2)
  predictionSchemaUri = _messages.StringField(3)


class GoogleCloudAiplatformV1Presets(_messages.Message):
  r"""Preset configuration for example-based explanations

  Enums:
    ModalityValueValuesEnum: The modality of the uploaded model, which
      automatically configures the distance measurement and feature
      normalization for the underlying example index and queries. If your
      model does not precisely fit one of these types, it is okay to choose
      the closest type.
    QueryValueValuesEnum: Preset option controlling parameters for speed-
      precision trade-off when querying for examples. If omitted, defaults to
      `PRECISE`.

  Fields:
    modality: The modality of the uploaded model, which automatically
      configures the distance measurement and feature normalization for the
      underlying example index and queries. If your model does not precisely
      fit one of these types, it is okay to choose the closest type.
    query: Preset option controlling parameters for speed-precision trade-off
      when querying for examples. If omitted, defaults to `PRECISE`.
  """

  class ModalityValueValuesEnum(_messages.Enum):
    r"""The modality of the uploaded model, which automatically configures the
    distance measurement and feature normalization for the underlying example
    index and queries. If your model does not precisely fit one of these
    types, it is okay to choose the closest type.

    Values:
      MODALITY_UNSPECIFIED: Should not be set. Added as a recommended best
        practice for enums
      IMAGE: IMAGE modality
      TEXT: TEXT modality
      TABULAR: TABULAR modality
    """
    MODALITY_UNSPECIFIED = 0
    IMAGE = 1
    TEXT = 2
    TABULAR = 3

  class QueryValueValuesEnum(_messages.Enum):
    r"""Preset option controlling parameters for speed-precision trade-off
    when querying for examples. If omitted, defaults to `PRECISE`.

    Values:
      PRECISE: More precise neighbors as a trade-off against slower response.
      FAST: Faster response as a trade-off against less precise neighbors.
    """
    PRECISE = 0
    FAST = 1

  modality = _messages.EnumField('ModalityValueValuesEnum', 1)
  query = _messages.EnumField('QueryValueValuesEnum', 2)


class GoogleCloudAiplatformV1PrivateEndpoints(_messages.Message):
  r"""PrivateEndpoints proto is used to provide paths for users to send
  requests privately. To send request via private service access, use
  predict_http_uri, explain_http_uri or health_http_uri. To send request via
  private service connect, use service_attachment.

  Fields:
    explainHttpUri: Output only. Http(s) path to send explain requests.
    healthHttpUri: Output only. Http(s) path to send health check requests.
    predictHttpUri: Output only. Http(s) path to send prediction requests.
    serviceAttachment: Output only. The name of the service attachment
      resource. Populated if private service connect is enabled.
  """

  explainHttpUri = _messages.StringField(1)
  healthHttpUri = _messages.StringField(2)
  predictHttpUri = _messages.StringField(3)
  serviceAttachment = _messages.StringField(4)


class GoogleCloudAiplatformV1PrivateServiceConnectConfig(_messages.Message):
  r"""Represents configuration for private service connect.

  Fields:
    enablePrivateServiceConnect: Required. If true, expose the IndexEndpoint
      via private service connect.
    projectAllowlist: A list of Projects from which the forwarding rule will
      target the service attachment.
  """

  enablePrivateServiceConnect = _messages.BooleanField(1)
  projectAllowlist = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1PurgeArtifactsMetadata(_messages.Message):
  r"""Details of operations that perform MetadataService.PurgeArtifacts.

  Fields:
    genericMetadata: Operation metadata for purging Artifacts.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1PurgeArtifactsRequest(_messages.Message):
  r"""Request message for MetadataService.PurgeArtifacts.

  Fields:
    filter: Required. A required filter matching the Artifacts to be purged.
      E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
    force: Optional. Flag to indicate to actually perform the purge. If
      `force` is set to false, the method will return a sample of Artifact
      names that would be deleted.
  """

  filter = _messages.StringField(1)
  force = _messages.BooleanField(2)


class GoogleCloudAiplatformV1PurgeArtifactsResponse(_messages.Message):
  r"""Response message for MetadataService.PurgeArtifacts.

  Fields:
    purgeCount: The number of Artifacts that this request deleted (or, if
      `force` is false, the number of Artifacts that will be deleted). This
      can be an estimate.
    purgeSample: A sample of the Artifact names that will be deleted. Only
      populated if `force` is set to false. The maximum number of samples is
      100 (it is possible to return fewer).
  """

  purgeCount = _messages.IntegerField(1)
  purgeSample = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1PurgeContextsMetadata(_messages.Message):
  r"""Details of operations that perform MetadataService.PurgeContexts.

  Fields:
    genericMetadata: Operation metadata for purging Contexts.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1PurgeContextsRequest(_messages.Message):
  r"""Request message for MetadataService.PurgeContexts.

  Fields:
    filter: Required. A required filter matching the Contexts to be purged.
      E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
    force: Optional. Flag to indicate to actually perform the purge. If
      `force` is set to false, the method will return a sample of Context
      names that would be deleted.
  """

  filter = _messages.StringField(1)
  force = _messages.BooleanField(2)


class GoogleCloudAiplatformV1PurgeContextsResponse(_messages.Message):
  r"""Response message for MetadataService.PurgeContexts.

  Fields:
    purgeCount: The number of Contexts that this request deleted (or, if
      `force` is false, the number of Contexts that will be deleted). This can
      be an estimate.
    purgeSample: A sample of the Context names that will be deleted. Only
      populated if `force` is set to false. The maximum number of samples is
      100 (it is possible to return fewer).
  """

  purgeCount = _messages.IntegerField(1)
  purgeSample = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1PurgeExecutionsMetadata(_messages.Message):
  r"""Details of operations that perform MetadataService.PurgeExecutions.

  Fields:
    genericMetadata: Operation metadata for purging Executions.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1PurgeExecutionsRequest(_messages.Message):
  r"""Request message for MetadataService.PurgeExecutions.

  Fields:
    filter: Required. A required filter matching the Executions to be purged.
      E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
    force: Optional. Flag to indicate to actually perform the purge. If
      `force` is set to false, the method will return a sample of Execution
      names that would be deleted.
  """

  filter = _messages.StringField(1)
  force = _messages.BooleanField(2)


class GoogleCloudAiplatformV1PurgeExecutionsResponse(_messages.Message):
  r"""Response message for MetadataService.PurgeExecutions.

  Fields:
    purgeCount: The number of Executions that this request deleted (or, if
      `force` is false, the number of Executions that will be deleted). This
      can be an estimate.
    purgeSample: A sample of the Execution names that will be deleted. Only
      populated if `force` is set to false. The maximum number of samples is
      100 (it is possible to return fewer).
  """

  purgeCount = _messages.IntegerField(1)
  purgeSample = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1PythonPackageSpec(_messages.Message):
  r"""The spec of a Python packaged code.

  Fields:
    args: Command line arguments to be passed to the Python task.
    env: Environment variables to be passed to the python module. Maximum
      limit is 100.
    executorImageUri: Required. The URI of a container image in Artifact
      Registry that will run the provided Python package. Vertex AI provides a
      wide range of executor images with pre-installed packages to meet users'
      various use cases. See the list of [pre-built containers for
      training](https://cloud.google.com/vertex-ai/docs/training/pre-built-
      containers). You must use an image from this list.
    packageUris: Required. The Google Cloud Storage location of the Python
      package files which are the training program and its dependent packages.
      The maximum number of package URIs is 100.
    pythonModule: Required. The Python module name to run after installing the
      packages.
  """

  args = _messages.StringField(1, repeated=True)
  env = _messages.MessageField('GoogleCloudAiplatformV1EnvVar', 2, repeated=True)
  executorImageUri = _messages.StringField(3)
  packageUris = _messages.StringField(4, repeated=True)
  pythonModule = _messages.StringField(5)


class GoogleCloudAiplatformV1RawPredictRequest(_messages.Message):
  r"""Request message for PredictionService.RawPredict.

  Fields:
    httpBody: The prediction input. Supports HTTP headers and arbitrary data
      payload. A DeployedModel may have an upper limit on the number of
      instances it supports per request. When this limit it is exceeded for an
      AutoML model, the RawPredict method returns an error. When this limit is
      exceeded for a custom-trained model, the behavior varies depending on
      the model. You can specify the schema for each instance in the
      predict_schemata.instance_schema_uri field when you create a Model. This
      schema applies when you deploy the `Model` as a `DeployedModel` to an
      Endpoint and use the `RawPredict` method.
  """

  httpBody = _messages.MessageField('GoogleApiHttpBody', 1)


class GoogleCloudAiplatformV1ReadFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreOnlineServingService.ReadFeatureValues.

  Fields:
    entityId: Required. ID for a specific entity. For example, for a machine
      learning model predicting user clicks on a website, an entity ID could
      be `user_123`.
    featureSelector: Required. Selector choosing Features of the target
      EntityType.
  """

  entityId = _messages.StringField(1)
  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1FeatureSelector', 2)


class GoogleCloudAiplatformV1ReadFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreOnlineServingService.ReadFeatureValues.

  Fields:
    entityView: Entity view with Feature values. This may be the entity in the
      Featurestore if values for all Features were requested, or a projection
      of the entity in the Featurestore if values for only some Features were
      requested.
    header: Response header.
  """

  entityView = _messages.MessageField('GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityView', 1)
  header = _messages.MessageField('GoogleCloudAiplatformV1ReadFeatureValuesResponseHeader', 2)


class GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityView(_messages.Message):
  r"""Entity view with Feature values.

  Fields:
    data: Each piece of data holds the k requested values for one requested
      Feature. If no values for the requested Feature exist, the corresponding
      cell will be empty. This has the same size and is in the same order as
      the features from the header ReadFeatureValuesResponse.header.
    entityId: ID of the requested entity.
  """

  data = _messages.MessageField('GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityViewData', 1, repeated=True)
  entityId = _messages.StringField(2)


class GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityViewData(_messages.Message):
  r"""Container to hold value(s), successive in time, for one Feature from the
  request.

  Fields:
    value: Feature value if a single value is requested.
    values: Feature values list if values, successive in time, are requested.
      If the requested number of values is greater than the number of existing
      Feature values, nonexistent values are omitted instead of being returned
      as empty.
  """

  value = _messages.MessageField('GoogleCloudAiplatformV1FeatureValue', 1)
  values = _messages.MessageField('GoogleCloudAiplatformV1FeatureValueList', 2)


class GoogleCloudAiplatformV1ReadFeatureValuesResponseFeatureDescriptor(_messages.Message):
  r"""Metadata for requested Features.

  Fields:
    id: Feature ID.
  """

  id = _messages.StringField(1)


class GoogleCloudAiplatformV1ReadFeatureValuesResponseHeader(_messages.Message):
  r"""Response header with metadata for the requested
  ReadFeatureValuesRequest.entity_type and Features.

  Fields:
    entityType: The resource name of the EntityType from the
      ReadFeatureValuesRequest. Value format: `projects/{project}/locations/{l
      ocation}/featurestores/{featurestore}/entityTypes/{entityType}`.
    featureDescriptors: List of Feature metadata corresponding to each piece
      of ReadFeatureValuesResponse.EntityView.data.
  """

  entityType = _messages.StringField(1)
  featureDescriptors = _messages.MessageField('GoogleCloudAiplatformV1ReadFeatureValuesResponseFeatureDescriptor', 2, repeated=True)


class GoogleCloudAiplatformV1ReadTensorboardBlobDataResponse(_messages.Message):
  r"""Response message for TensorboardService.ReadTensorboardBlobData.

  Fields:
    blobs: Blob messages containing blob bytes.
  """

  blobs = _messages.MessageField('GoogleCloudAiplatformV1TensorboardBlob', 1, repeated=True)


class GoogleCloudAiplatformV1ReadTensorboardSizeResponse(_messages.Message):
  r"""Response message for TensorboardService.ReadTensorboardSize.

  Fields:
    storageSizeByte: Payload storage size for the TensorBoard
  """

  storageSizeByte = _messages.IntegerField(1)


class GoogleCloudAiplatformV1ReadTensorboardTimeSeriesDataResponse(_messages.Message):
  r"""Response message for TensorboardService.ReadTensorboardTimeSeriesData.

  Fields:
    timeSeriesData: The returned time series data.
  """

  timeSeriesData = _messages.MessageField('GoogleCloudAiplatformV1TimeSeriesData', 1)


class GoogleCloudAiplatformV1ReadTensorboardUsageResponse(_messages.Message):
  r"""Response message for TensorboardService.ReadTensorboardUsage.

  Messages:
    MonthlyUsageDataValue: Maps year-month (YYYYMM) string to per month usage
      data.

  Fields:
    monthlyUsageData: Maps year-month (YYYYMM) string to per month usage data.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MonthlyUsageDataValue(_messages.Message):
    r"""Maps year-month (YYYYMM) string to per month usage data.

    Messages:
      AdditionalProperty: An additional property for a MonthlyUsageDataValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        MonthlyUsageDataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MonthlyUsageDataValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerMonthUsageData
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerMonthUsageData', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  monthlyUsageData = _messages.MessageField('MonthlyUsageDataValue', 1)


class GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerMonthUsageData(_messages.Message):
  r"""Per month usage data

  Fields:
    userUsageData: Usage data for each user in the given month.
  """

  userUsageData = _messages.MessageField('GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerUserUsageData', 1, repeated=True)


class GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerUserUsageData(_messages.Message):
  r"""Per user usage data.

  Fields:
    username: User's username
    viewCount: Number of times the user has read data within the Tensorboard.
  """

  username = _messages.StringField(1)
  viewCount = _messages.IntegerField(2)


class GoogleCloudAiplatformV1RemoveContextChildrenRequest(_messages.Message):
  r"""Request message for MetadataService.DeleteContextChildrenRequest.

  Fields:
    childContexts: The resource names of the child Contexts.
  """

  childContexts = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1RemoveContextChildrenResponse(_messages.Message):
  r"""Response message for MetadataService.RemoveContextChildren."""


class GoogleCloudAiplatformV1RemoveDatapointsRequest(_messages.Message):
  r"""Request message for IndexService.RemoveDatapoints

  Fields:
    datapointIds: A list of datapoint ids to be deleted.
  """

  datapointIds = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1RemoveDatapointsResponse(_messages.Message):
  r"""Response message for IndexService.RemoveDatapoints"""


class GoogleCloudAiplatformV1ResourcesConsumed(_messages.Message):
  r"""Statistics information about resource consumption.

  Fields:
    replicaHours: Output only. The number of replica hours used. Note that
      many replicas may run in parallel, and additionally any given work may
      be queued for some time. Therefore this value is not strictly related to
      wall time.
  """

  replicaHours = _messages.FloatField(1)


class GoogleCloudAiplatformV1RestoreDatasetVersionOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.RestoreDatasetVersion.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1ResumeModelDeploymentMonitoringJobRequest(_messages.Message):
  r"""Request message for JobService.ResumeModelDeploymentMonitoringJob."""


class GoogleCloudAiplatformV1ResumeScheduleRequest(_messages.Message):
  r"""Request message for ScheduleService.ResumeSchedule.

  Fields:
    catchUp: Optional. Whether to backfill missed runs when the schedule is
      resumed from PAUSED state. If set to true, all missed runs will be
      scheduled. New runs will be scheduled after the backfill is complete.
      This will also update Schedule.catch_up field. Default to false.
  """

  catchUp = _messages.BooleanField(1)


class GoogleCloudAiplatformV1SampleConfig(_messages.Message):
  r"""Active learning data sampling config. For every active learning labeling
  iteration, it will select a batch of data based on the sampling strategy.

  Enums:
    SampleStrategyValueValuesEnum: Field to choose sampling strategy. Sampling
      strategy will decide which data should be selected for human labeling in
      every batch.

  Fields:
    followingBatchSamplePercentage: The percentage of data needed to be
      labeled in each following batch (except the first batch).
    initialBatchSamplePercentage: The percentage of data needed to be labeled
      in the first batch.
    sampleStrategy: Field to choose sampling strategy. Sampling strategy will
      decide which data should be selected for human labeling in every batch.
  """

  class SampleStrategyValueValuesEnum(_messages.Enum):
    r"""Field to choose sampling strategy. Sampling strategy will decide which
    data should be selected for human labeling in every batch.

    Values:
      SAMPLE_STRATEGY_UNSPECIFIED: Default will be treated as UNCERTAINTY.
      UNCERTAINTY: Sample the most uncertain data to label.
    """
    SAMPLE_STRATEGY_UNSPECIFIED = 0
    UNCERTAINTY = 1

  followingBatchSamplePercentage = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  initialBatchSamplePercentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sampleStrategy = _messages.EnumField('SampleStrategyValueValuesEnum', 3)


class GoogleCloudAiplatformV1SampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    pathCount: Required. The number of feature permutations to consider when
      approximating the Shapley values. Valid range of its value is [1, 50],
      inclusively.
  """

  pathCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SamplingStrategy(_messages.Message):
  r"""Sampling Strategy for logging, can be for both training and prediction
  dataset.

  Fields:
    randomSampleConfig: Random sample config. Will support more sampling
      strategies later.
  """

  randomSampleConfig = _messages.MessageField('GoogleCloudAiplatformV1SamplingStrategyRandomSampleConfig', 1)


class GoogleCloudAiplatformV1SamplingStrategyRandomSampleConfig(_messages.Message):
  r"""Requests are randomly selected.

  Fields:
    sampleRate: Sample rate (0, 1]
  """

  sampleRate = _messages.FloatField(1)


class GoogleCloudAiplatformV1SavedQuery(_messages.Message):
  r"""A SavedQuery is a view of the dataset. It references a subset of
  annotations by problem type and filters.

  Fields:
    annotationFilter: Output only. Filters on the Annotations in the dataset.
    annotationSpecCount: Output only. Number of AnnotationSpecs in the context
      of the SavedQuery.
    createTime: Output only. Timestamp when this SavedQuery was created.
    displayName: Required. The user-defined name of the SavedQuery. The name
      can be up to 128 characters long and can consist of any UTF-8
      characters.
    etag: Used to perform a consistent read-modify-write update. If not set, a
      blind "overwrite" update happens.
    metadata: Some additional information about the SavedQuery.
    name: Output only. Resource name of the SavedQuery.
    problemType: Required. Problem type of the SavedQuery. Allowed values: *
      IMAGE_CLASSIFICATION_SINGLE_LABEL * IMAGE_CLASSIFICATION_MULTI_LABEL *
      IMAGE_BOUNDING_POLY * IMAGE_BOUNDING_BOX *
      TEXT_CLASSIFICATION_SINGLE_LABEL * TEXT_CLASSIFICATION_MULTI_LABEL *
      TEXT_EXTRACTION * TEXT_SENTIMENT * VIDEO_CLASSIFICATION *
      VIDEO_OBJECT_TRACKING
    supportAutomlTraining: Output only. If the Annotations belonging to the
      SavedQuery can be used for AutoML training.
    updateTime: Output only. Timestamp when SavedQuery was last updated.
  """

  annotationFilter = _messages.StringField(1)
  annotationSpecCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  metadata = _messages.MessageField('extra_types.JsonValue', 6)
  name = _messages.StringField(7)
  problemType = _messages.StringField(8)
  supportAutomlTraining = _messages.BooleanField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudAiplatformV1Scalar(_messages.Message):
  r"""One point viewable on a scalar metric plot.

  Fields:
    value: Value of the point at this step / timestamp.
  """

  value = _messages.FloatField(1)


class GoogleCloudAiplatformV1Schedule(_messages.Message):
  r"""An instance of a Schedule periodically schedules runs to make API calls
  based on user specified time specification and API request type.

  Enums:
    StateValueValuesEnum: Output only. The state of this Schedule.

  Fields:
    allowQueueing: Optional. Whether new scheduled runs can be queued when
      max_concurrent_runs limit is reached. If set to true, new runs will be
      queued instead of skipped. Default to false.
    catchUp: Output only. Whether to backfill missed runs when the schedule is
      resumed from PAUSED state. If set to true, all missed runs will be
      scheduled. New runs will be scheduled after the backfill is complete.
      Default to false.
    createPipelineJobRequest: Request for PipelineService.CreatePipelineJob.
      CreatePipelineJobRequest.parent field is required (format:
      projects/{project}/locations/{location}).
    createTime: Output only. Timestamp when this Schedule was created.
    cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch
      scheduled runs. To explicitly set a timezone to the cron tab, apply a
      prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
      "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
      from IANA time zone database. For example, "CRON_TZ=America/New_York 1 *
      * * *", or "TZ=America/New_York 1 * * * *".
    displayName: Required. User provided name of the Schedule. The name can be
      up to 128 characters long and can consist of any UTF-8 characters.
    endTime: Optional. Timestamp after which no new runs can be scheduled. If
      specified, The schedule will be completed when either end_time is
      reached or when scheduled_run_count >= max_run_count. If not specified,
      new runs will keep getting scheduled until this Schedule is paused or
      deleted. Already scheduled runs will be allowed to complete. Unset if
      not specified.
    lastPauseTime: Output only. Timestamp when this Schedule was last paused.
      Unset if never paused.
    lastResumeTime: Output only. Timestamp when this Schedule was last
      resumed. Unset if never resumed from pause.
    lastScheduledRunResponse: Output only. Response of the last scheduled run.
      This is the response for starting the scheduled requests and not the
      execution of the operations/jobs created by the requests (if
      applicable). Unset if no run has been scheduled yet.
    maxConcurrentRunCount: Required. Maximum number of runs that can be
      started concurrently for this Schedule. This is the limit for starting
      the scheduled requests and not the execution of the operations/jobs
      created by the requests (if applicable).
    maxRunCount: Optional. Maximum run count of the schedule. If specified,
      The schedule will be completed when either started_run_count >=
      max_run_count or when end_time is reached. If not specified, new runs
      will keep getting scheduled until this Schedule is paused or deleted.
      Already scheduled runs will be allowed to complete. Unset if not
      specified.
    name: Immutable. The resource name of the Schedule.
    nextRunTime: Output only. Timestamp when this Schedule should schedule the
      next run. Having a next_run_time in the past means the runs are being
      started behind schedule.
    startTime: Optional. Timestamp after which the first run can be scheduled.
      Default to Schedule create time if not specified.
    startedRunCount: Output only. The number of runs started by this schedule.
    state: Output only. The state of this Schedule.
    updateTime: Output only. Timestamp when this Schedule was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of this Schedule.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      ACTIVE: The Schedule is active. Runs are being scheduled on the user-
        specified timespec.
      PAUSED: The schedule is paused. No new runs will be created until the
        schedule is resumed. Already started runs will be allowed to complete.
      COMPLETED: The Schedule is completed. No new runs will be scheduled.
        Already started runs will be allowed to complete. Schedules in
        completed state cannot be paused or resumed.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    PAUSED = 2
    COMPLETED = 3

  allowQueueing = _messages.BooleanField(1)
  catchUp = _messages.BooleanField(2)
  createPipelineJobRequest = _messages.MessageField('GoogleCloudAiplatformV1CreatePipelineJobRequest', 3)
  createTime = _messages.StringField(4)
  cron = _messages.StringField(5)
  displayName = _messages.StringField(6)
  endTime = _messages.StringField(7)
  lastPauseTime = _messages.StringField(8)
  lastResumeTime = _messages.StringField(9)
  lastScheduledRunResponse = _messages.MessageField('GoogleCloudAiplatformV1ScheduleRunResponse', 10)
  maxConcurrentRunCount = _messages.IntegerField(11)
  maxRunCount = _messages.IntegerField(12)
  name = _messages.StringField(13)
  nextRunTime = _messages.StringField(14)
  startTime = _messages.StringField(15)
  startedRunCount = _messages.IntegerField(16)
  state = _messages.EnumField('StateValueValuesEnum', 17)
  updateTime = _messages.StringField(18)


class GoogleCloudAiplatformV1ScheduleRunResponse(_messages.Message):
  r"""Status of a scheduled run.

  Fields:
    runResponse: The response of the scheduled run.
    scheduledRunTime: The scheduled run time based on the user-specified
      schedule.
  """

  runResponse = _messages.StringField(1)
  scheduledRunTime = _messages.StringField(2)


class GoogleCloudAiplatformV1Scheduling(_messages.Message):
  r"""All parameters related to queuing and scheduling of custom jobs.

  Fields:
    disableRetries: Optional. Indicates if the job should retry for internal
      errors after the job starts running. If true, overrides
      `Scheduling.restart_job_on_worker_restart` to false.
    restartJobOnWorkerRestart: Restarts the entire CustomJob if a worker gets
      restarted. This feature can be used by distributed training jobs that
      are not resilient to workers leaving and joining a job.
    timeout: The maximum job running time. The default is 7 days.
  """

  disableRetries = _messages.BooleanField(1)
  restartJobOnWorkerRestart = _messages.BooleanField(2)
  timeout = _messages.StringField(3)


class GoogleCloudAiplatformV1SchemaAnnotationSpecColor(_messages.Message):
  r"""An entry of mapping between color and AnnotationSpec. The mapping is
  used in segmentation mask.

  Fields:
    color: The color of the AnnotationSpec in a segmentation mask.
    displayName: The display name of the AnnotationSpec represented by the
      color in the segmentation mask.
    id: The ID of the AnnotationSpec represented by the color in the
      segmentation mask.
  """

  color = _messages.MessageField('GoogleTypeColor', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)


class GoogleCloudAiplatformV1SchemaImageBoundingBoxAnnotation(_messages.Message):
  r"""Annotation details specific to image object detection.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  xMax = _messages.FloatField(3)
  xMin = _messages.FloatField(4)
  yMax = _messages.FloatField(5)
  yMin = _messages.FloatField(6)


class GoogleCloudAiplatformV1SchemaImageClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to image classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaImageDataItem(_messages.Message):
  r"""Payload of Image DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original image in
      user's bucket. The image is up to 30MB in size.
    mimeType: Output only. The mime type of the content of the image. Only the
      images in below listed mime types are supported. - image/jpeg -
      image/gif - image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaImageDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Image DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Image DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaImageSegmentationAnnotation(_messages.Message):
  r"""Annotation details specific to image segmentation.

  Fields:
    maskAnnotation: Mask based segmentation annotation. Only one mask
      annotation can exist for one image.
    polygonAnnotation: Polygon annotation.
    polylineAnnotation: Polyline annotation.
  """

  maskAnnotation = _messages.MessageField('GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationMaskAnnotation', 1)
  polygonAnnotation = _messages.MessageField('GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolygonAnnotation', 2)
  polylineAnnotation = _messages.MessageField('GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolylineAnnotation', 3)


class GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationMaskAnnotation(_messages.Message):
  r"""The mask based segmentation annotation.

  Fields:
    annotationSpecColors: The mapping between color and AnnotationSpec for
      this Annotation.
    maskGcsUri: Google Cloud Storage URI that points to the mask image. The
      image must be in PNG format. It must have the same size as the
      DataItem's image. Each pixel in the image mask represents the
      AnnotationSpec which the pixel in the image DataItem belong to. Each
      color is mapped to one AnnotationSpec based on annotation_spec_colors.
  """

  annotationSpecColors = _messages.MessageField('GoogleCloudAiplatformV1SchemaAnnotationSpecColor', 1, repeated=True)
  maskGcsUri = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolygonAnnotation(_messages.Message):
  r"""Represents a polygon in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex is
      connected to the first one to represent a polygon.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformV1SchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolylineAnnotation(_messages.Message):
  r"""Represents a polyline in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex in not
      connected to the first one.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformV1SchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformV1SchemaPredictInstanceImageClassificationPredictionInstance(_messages.Message):
  r"""Prediction input format for Image Classification.

  Fields:
    content: The image bytes or Cloud Storage URI to make the prediction on.
    mimeType: The MIME type of the content of the image. Only the images in
      below listed MIME types are supported. - image/jpeg - image/gif -
      image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaPredictInstanceImageObjectDetectionPredictionInstance(_messages.Message):
  r"""Prediction input format for Image Object Detection.

  Fields:
    content: The image bytes or Cloud Storage URI to make the prediction on.
    mimeType: The MIME type of the content of the image. Only the images in
      below listed MIME types are supported. - image/jpeg - image/gif -
      image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaPredictInstanceImageSegmentationPredictionInstance(_messages.Message):
  r"""Prediction input format for Image Segmentation.

  Fields:
    content: The image bytes to make the predictions on.
    mimeType: The MIME type of the content of the image. Only the images in
      below listed MIME types are supported. - image/jpeg - image/png
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaPredictInstanceTextClassificationPredictionInstance(_messages.Message):
  r"""Prediction input format for Text Classification.

  Fields:
    content: The text snippet to make the predictions on.
    mimeType: The MIME type of the text snippet. The supported MIME types are
      listed below. - text/plain
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaPredictInstanceTextExtractionPredictionInstance(_messages.Message):
  r"""Prediction input format for Text Extraction.

  Fields:
    content: The text snippet to make the predictions on.
    key: This field is only used for batch prediction. If a key is provided,
      the batch prediction result will by mapped to this key. If omitted, then
      the batch prediction result will contain the entire input instance.
      Vertex AI will not check if keys in the request are duplicates, so it is
      up to the caller to ensure the keys are unique.
    mimeType: The MIME type of the text snippet. The supported MIME types are
      listed below. - text/plain
  """

  content = _messages.StringField(1)
  key = _messages.StringField(2)
  mimeType = _messages.StringField(3)


class GoogleCloudAiplatformV1SchemaPredictInstanceTextSentimentPredictionInstance(_messages.Message):
  r"""Prediction input format for Text Sentiment.

  Fields:
    content: The text snippet to make the predictions on.
    mimeType: The MIME type of the text snippet. The supported MIME types are
      listed below. - text/plain
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaPredictInstanceVideoActionRecognitionPredictionInstance(_messages.Message):
  r"""Prediction input format for Video Action Recognition.

  Fields:
    content: The Google Cloud Storage location of the video on which to
      perform the prediction.
    mimeType: The MIME type of the content of the video. Only the following
      are supported: video/mp4 video/avi video/quicktime
    timeSegmentEnd: The end, exclusive, of the video's time segment on which
      to perform the prediction. Expressed as a number of seconds as measured
      from the start of the video, with "s" appended at the end. Fractions are
      allowed, up to a microsecond precision, and "inf" or "Infinity" is
      allowed, which means the end of the video.
    timeSegmentStart: The beginning, inclusive, of the video's time segment on
      which to perform the prediction. Expressed as a number of seconds as
      measured from the start of the video, with "s" appended at the end.
      Fractions are allowed, up to a microsecond precision.
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)
  timeSegmentEnd = _messages.StringField(3)
  timeSegmentStart = _messages.StringField(4)


class GoogleCloudAiplatformV1SchemaPredictInstanceVideoClassificationPredictionInstance(_messages.Message):
  r"""Prediction input format for Video Classification.

  Fields:
    content: The Google Cloud Storage location of the video on which to
      perform the prediction.
    mimeType: The MIME type of the content of the video. Only the following
      are supported: video/mp4 video/avi video/quicktime
    timeSegmentEnd: The end, exclusive, of the video's time segment on which
      to perform the prediction. Expressed as a number of seconds as measured
      from the start of the video, with "s" appended at the end. Fractions are
      allowed, up to a microsecond precision, and "inf" or "Infinity" is
      allowed, which means the end of the video.
    timeSegmentStart: The beginning, inclusive, of the video's time segment on
      which to perform the prediction. Expressed as a number of seconds as
      measured from the start of the video, with "s" appended at the end.
      Fractions are allowed, up to a microsecond precision.
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)
  timeSegmentEnd = _messages.StringField(3)
  timeSegmentStart = _messages.StringField(4)


class GoogleCloudAiplatformV1SchemaPredictInstanceVideoObjectTrackingPredictionInstance(_messages.Message):
  r"""Prediction input format for Video Object Tracking.

  Fields:
    content: The Google Cloud Storage location of the video on which to
      perform the prediction.
    mimeType: The MIME type of the content of the video. Only the following
      are supported: video/mp4 video/avi video/quicktime
    timeSegmentEnd: The end, exclusive, of the video's time segment on which
      to perform the prediction. Expressed as a number of seconds as measured
      from the start of the video, with "s" appended at the end. Fractions are
      allowed, up to a microsecond precision, and "inf" or "Infinity" is
      allowed, which means the end of the video.
    timeSegmentStart: The beginning, inclusive, of the video's time segment on
      which to perform the prediction. Expressed as a number of seconds as
      measured from the start of the video, with "s" appended at the end.
      Fractions are allowed, up to a microsecond precision.
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)
  timeSegmentEnd = _messages.StringField(3)
  timeSegmentStart = _messages.StringField(4)


class GoogleCloudAiplatformV1SchemaPredictParamsImageClassificationPredictionParams(_messages.Message):
  r"""Prediction model parameters for Image Classification.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The Model only returns up to that many top, by confidence
      score, predictions per instance. If this number is very high, the Model
      may return fewer predictions. Default value is 10.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SchemaPredictParamsImageObjectDetectionPredictionParams(_messages.Message):
  r"""Prediction model parameters for Image Object Detection.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The Model only returns up to that many top, by confidence
      score, predictions per instance. Note that number of returned
      predictions is also limited by metadata's predictionsLimit. Default
      value is 10.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SchemaPredictParamsImageSegmentationPredictionParams(_messages.Message):
  r"""Prediction model parameters for Image Segmentation.

  Fields:
    confidenceThreshold: When the model predicts category of pixels of the
      image, it will only provide predictions for pixels that it is at least
      this much confident about. All other pixels will be classified as
      background. Default value is 0.5.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1SchemaPredictParamsVideoActionRecognitionPredictionParams(_messages.Message):
  r"""Prediction model parameters for Video Action Recognition.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The model only returns up to that many top, by confidence
      score, predictions per frame of the video. If this number is very high,
      the Model may return fewer predictions per frame. Default value is 50.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SchemaPredictParamsVideoClassificationPredictionParams(_messages.Message):
  r"""Prediction model parameters for Video Classification.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The Model only returns up to that many top, by confidence
      score, predictions per instance. If this number is very high, the Model
      may return fewer predictions. Default value is 10,000.
    oneSecIntervalClassification: Set to true to request classification for a
      video at one-second intervals. Vertex AI returns labels and their
      confidence scores for each second of the entire time segment of the
      video that user specified in the input WARNING: Model evaluation is not
      done for this classification type, the quality of it depends on the
      training data, but there are no metrics provided to describe that
      quality. Default value is false
    segmentClassification: Set to true to request segment-level
      classification. Vertex AI returns labels and their confidence scores for
      the entire time segment of the video that user specified in the input
      instance. Default value is true
    shotClassification: Set to true to request shot-level classification.
      Vertex AI determines the boundaries for each camera shot in the entire
      time segment of the video that user specified in the input instance.
      Vertex AI then returns labels and their confidence scores for each
      detected shot, along with the start and end time of the shot. WARNING:
      Model evaluation is not done for this classification type, the quality
      of it depends on the training data, but there are no metrics provided to
      describe that quality. Default value is false
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  oneSecIntervalClassification = _messages.BooleanField(3)
  segmentClassification = _messages.BooleanField(4)
  shotClassification = _messages.BooleanField(5)


class GoogleCloudAiplatformV1SchemaPredictParamsVideoObjectTrackingPredictionParams(_messages.Message):
  r"""Prediction model parameters for Video Object Tracking.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The model only returns up to that many top, by confidence
      score, predictions per frame of the video. If this number is very high,
      the Model may return fewer predictions per frame. Default value is 50.
    minBoundingBoxSize: Only bounding boxes with shortest edge at least that
      long as a relative value of video frame size are returned. Default value
      is 0.0.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minBoundingBoxSize = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1SchemaPredictPredictionClassificationPredictionResult(_messages.Message):
  r"""Prediction output format for Image and Text Classification.

  Fields:
    confidences: The Model's confidences in correctness of the predicted IDs,
      higher value means higher confidence. Order matches the Ids.
    displayNames: The display names of the AnnotationSpecs that had been
      identified, order matches the IDs.
    ids: The resource IDs of the AnnotationSpecs that had been identified.
  """

  confidences = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)
  displayNames = _messages.StringField(2, repeated=True)
  ids = _messages.IntegerField(3, repeated=True)


class GoogleCloudAiplatformV1SchemaPredictPredictionImageObjectDetectionPredictionResult(_messages.Message):
  r"""Prediction output format for Image Object Detection.

  Messages:
    BboxesValueListEntry: Single entry in a BboxesValue.

  Fields:
    bboxes: Bounding boxes, i.e. the rectangles over the image, that pinpoint
      the found AnnotationSpecs. Given in order that matches the IDs. Each
      bounding box is an array of 4 numbers `xMin`, `xMax`, `yMin`, and
      `yMax`, which represent the extremal coordinates of the box. They are
      relative to the image size, and the point 0,0 is in the top left of the
      image.
    confidences: The Model's confidences in correctness of the predicted IDs,
      higher value means higher confidence. Order matches the Ids.
    displayNames: The display names of the AnnotationSpecs that had been
      identified, order matches the IDs.
    ids: The resource IDs of the AnnotationSpecs that had been identified,
      ordered by the confidence score descendingly.
  """

  class BboxesValueListEntry(_messages.Message):
    r"""Single entry in a BboxesValue.

    Fields:
      entry: A extra_types.JsonValue attribute.
    """

    entry = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)

  bboxes = _messages.MessageField('BboxesValueListEntry', 1, repeated=True)
  confidences = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)
  displayNames = _messages.StringField(3, repeated=True)
  ids = _messages.IntegerField(4, repeated=True)


class GoogleCloudAiplatformV1SchemaPredictPredictionImageSegmentationPredictionResult(_messages.Message):
  r"""Prediction output format for Image Segmentation.

  Fields:
    categoryMask: A PNG image where each pixel in the mask represents the
      category in which the pixel in the original image was predicted to
      belong to. The size of this image will be the same as the original
      image. The mapping between the AnntoationSpec and the color can be found
      in model's metadata. The model will choose the most likely category and
      if none of the categories reach the confidence threshold, the pixel will
      be marked as background.
    confidenceMask: A one channel image which is encoded as an 8bit lossless
      PNG. The size of the image will be the same as the original image. For a
      specific pixel, darker color means less confidence in correctness of the
      cateogry in the categoryMask for the corresponding pixel. Black means no
      confidence and white means complete confidence.
  """

  categoryMask = _messages.StringField(1)
  confidenceMask = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaPredictPredictionTabularClassificationPredictionResult(_messages.Message):
  r"""Prediction output format for Tabular Classification.

  Fields:
    classes: The name of the classes being classified, contains all possible
      values of the target column.
    scores: The model's confidence in each class being correct, higher value
      means higher confidence. The N-th score corresponds to the N-th class in
      classes.
  """

  classes = _messages.StringField(1, repeated=True)
  scores = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1SchemaPredictPredictionTabularRegressionPredictionResult(_messages.Message):
  r"""Prediction output format for Tabular Regression.

  Fields:
    lowerBound: The lower bound of the prediction interval.
    quantilePredictions: Quantile predictions, in 1-1 correspondence with
      quantile_values.
    quantileValues: Quantile values.
    upperBound: The upper bound of the prediction interval.
    value: The regression value.
  """

  lowerBound = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  quantilePredictions = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)
  quantileValues = _messages.FloatField(3, repeated=True, variant=_messages.Variant.FLOAT)
  upperBound = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  value = _messages.FloatField(5, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1SchemaPredictPredictionTextExtractionPredictionResult(_messages.Message):
  r"""Prediction output format for Text Extraction.

  Fields:
    confidences: The Model's confidences in correctness of the predicted IDs,
      higher value means higher confidence. Order matches the Ids.
    displayNames: The display names of the AnnotationSpecs that had been
      identified, order matches the IDs.
    ids: The resource IDs of the AnnotationSpecs that had been identified,
      ordered by the confidence score descendingly.
    textSegmentEndOffsets: The end offsets, inclusive, of the text segment in
      which the AnnotationSpec has been identified. Expressed as a zero-based
      number of characters as measured from the start of the text snippet.
    textSegmentStartOffsets: The start offsets, inclusive, of the text segment
      in which the AnnotationSpec has been identified. Expressed as a zero-
      based number of characters as measured from the start of the text
      snippet.
  """

  confidences = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)
  displayNames = _messages.StringField(2, repeated=True)
  ids = _messages.IntegerField(3, repeated=True)
  textSegmentEndOffsets = _messages.IntegerField(4, repeated=True)
  textSegmentStartOffsets = _messages.IntegerField(5, repeated=True)


class GoogleCloudAiplatformV1SchemaPredictPredictionTextSentimentPredictionResult(_messages.Message):
  r"""Prediction output format for Text Sentiment

  Fields:
    sentiment: The integer sentiment labels between 0 (inclusive) and
      sentimentMax label (inclusive), while 0 maps to the least positive
      sentiment and sentimentMax maps to the most positive one. The higher the
      score is, the more positive the sentiment in the text snippet is. Note:
      sentimentMax is an integer value between 1 (inclusive) and 10
      (inclusive).
  """

  sentiment = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SchemaPredictPredictionTftFeatureImportance(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaPredictPredictionTftFeatureImportance
  object.

  Fields:
    attributeColumns: A string attribute.
    attributeWeights: A number attribute.
    contextColumns: A string attribute.
    contextWeights: TFT feature importance values. Each pair for
      {context/horizon/attribute} should have the same shape since the weight
      corresponds to the column names.
    horizonColumns: A string attribute.
    horizonWeights: A number attribute.
  """

  attributeColumns = _messages.StringField(1, repeated=True)
  attributeWeights = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)
  contextColumns = _messages.StringField(3, repeated=True)
  contextWeights = _messages.FloatField(4, repeated=True, variant=_messages.Variant.FLOAT)
  horizonColumns = _messages.StringField(5, repeated=True)
  horizonWeights = _messages.FloatField(6, repeated=True, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1SchemaPredictPredictionTimeSeriesForecastingPredictionResult(_messages.Message):
  r"""Prediction output format for Time Series Forecasting.

  Fields:
    quantilePredictions: Quantile predictions, in 1-1 correspondence with
      quantile_values.
    quantileValues: Quantile values.
    tftFeatureImportance: Only use these if TFt is enabled.
    value: The regression value.
  """

  quantilePredictions = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)
  quantileValues = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)
  tftFeatureImportance = _messages.MessageField('GoogleCloudAiplatformV1SchemaPredictPredictionTftFeatureImportance', 3)
  value = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1SchemaPredictPredictionVideoActionRecognitionPredictionResult(_messages.Message):
  r"""Prediction output format for Video Action Recognition.

  Fields:
    confidence: The Model's confidence in correction of this prediction,
      higher value means higher confidence.
    displayName: The display name of the AnnotationSpec that had been
      identified.
    id: The resource ID of the AnnotationSpec that had been identified.
    timeSegmentEnd: The end, exclusive, of the video's time segment in which
      the AnnotationSpec has been identified. Expressed as a number of seconds
      as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
    timeSegmentStart: The beginning, inclusive, of the video's time segment in
      which the AnnotationSpec has been identified. Expressed as a number of
      seconds as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)
  timeSegmentEnd = _messages.StringField(4)
  timeSegmentStart = _messages.StringField(5)


class GoogleCloudAiplatformV1SchemaPredictPredictionVideoClassificationPredictionResult(_messages.Message):
  r"""Prediction output format for Video Classification.

  Fields:
    confidence: The Model's confidence in correction of this prediction,
      higher value means higher confidence.
    displayName: The display name of the AnnotationSpec that had been
      identified.
    id: The resource ID of the AnnotationSpec that had been identified.
    timeSegmentEnd: The end, exclusive, of the video's time segment in which
      the AnnotationSpec has been identified. Expressed as a number of seconds
      as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end. Note that for
      'segment-classification' prediction type, this equals the original
      'timeSegmentEnd' from the input instance, for other types it is the end
      of a shot or a 1 second interval respectively.
    timeSegmentStart: The beginning, inclusive, of the video's time segment in
      which the AnnotationSpec has been identified. Expressed as a number of
      seconds as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end. Note that for
      'segment-classification' prediction type, this equals the original
      'timeSegmentStart' from the input instance, for other types it is the
      start of a shot or a 1 second interval respectively.
    type: The type of the prediction. The requested types can be configured
      via parameters. This will be one of - segment-classification - shot-
      classification - one-sec-interval-classification
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)
  timeSegmentEnd = _messages.StringField(4)
  timeSegmentStart = _messages.StringField(5)
  type = _messages.StringField(6)


class GoogleCloudAiplatformV1SchemaPredictPredictionVideoObjectTrackingPredictionResult(_messages.Message):
  r"""Prediction output format for Video Object Tracking.

  Fields:
    confidence: The Model's confidence in correction of this prediction,
      higher value means higher confidence.
    displayName: The display name of the AnnotationSpec that had been
      identified.
    frames: All of the frames of the video in which a single object instance
      has been detected. The bounding boxes in the frames identify the same
      object.
    id: The resource ID of the AnnotationSpec that had been identified.
    timeSegmentEnd: The end, inclusive, of the video's time segment in which
      the object instance has been detected. Expressed as a number of seconds
      as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
    timeSegmentStart: The beginning, inclusive, of the video's time segment in
      which the object instance has been detected. Expressed as a number of
      seconds as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  displayName = _messages.StringField(2)
  frames = _messages.MessageField('GoogleCloudAiplatformV1SchemaPredictPredictionVideoObjectTrackingPredictionResultFrame', 3, repeated=True)
  id = _messages.StringField(4)
  timeSegmentEnd = _messages.StringField(5)
  timeSegmentStart = _messages.StringField(6)


class GoogleCloudAiplatformV1SchemaPredictPredictionVideoObjectTrackingPredictionResultFrame(_messages.Message):
  r"""The fields `xMin`, `xMax`, `yMin`, and `yMax` refer to a bounding box,
  i.e. the rectangle over the video frame pinpointing the found
  AnnotationSpec. The coordinates are relative to the frame size, and the
  point 0,0 is in the top left of the frame.

  Fields:
    timeOffset: A time (frame) of a video in which the object has been
      detected. Expressed as a number of seconds as measured from the start of
      the video, with fractions up to a microsecond precision, and with "s"
      appended at the end.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  timeOffset = _messages.StringField(1)
  xMax = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  xMin = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  yMax = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  yMin = _messages.FloatField(5, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1SchemaPredictionResult(_messages.Message):
  r"""Represents a line of JSONL in the batch prediction output file.

  Messages:
    InstanceValue: User's input instance. Struct is used here instead of Any
      so that JsonFormat does not append an extra "@type" field when we
      convert the proto to JSON.

  Fields:
    error: The error result. Do not set prediction if this is set.
    instance: User's input instance. Struct is used here instead of Any so
      that JsonFormat does not append an extra "@type" field when we convert
      the proto to JSON.
    key: Optional user-provided key from the input instance.
    prediction: The prediction result. Value is used here instead of Any so
      that JsonFormat does not append an extra "@type" field when we convert
      the proto to JSON and so we can represent array of objects. Do not set
      error if this is set.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InstanceValue(_messages.Message):
    r"""User's input instance. Struct is used here instead of Any so that
    JsonFormat does not append an extra "@type" field when we convert the
    proto to JSON.

    Messages:
      AdditionalProperty: An additional property for a InstanceValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InstanceValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  error = _messages.MessageField('GoogleCloudAiplatformV1SchemaPredictionResultError', 1)
  instance = _messages.MessageField('InstanceValue', 2)
  key = _messages.StringField(3)
  prediction = _messages.MessageField('extra_types.JsonValue', 4)


class GoogleCloudAiplatformV1SchemaPredictionResultError(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaPredictionResultError object.

  Enums:
    StatusValueValuesEnum: Error status. This will be serialized into the enum
      name e.g. "NOT_FOUND".

  Fields:
    message: Error message with additional details.
    status: Error status. This will be serialized into the enum name e.g.
      "NOT_FOUND".
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Error status. This will be serialized into the enum name e.g.
    "NOT_FOUND".

    Values:
      OK: Not an error; returned on success. HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller. HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error. For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space. Also errors raised by
        APIs that do not return enough error information may be converted to
        this error. HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument. Note that
        this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name). HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully. For example, a successful response from a server could
        have been delayed long enough for the deadline to expire. HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found. Note to server developers: if a request is denied for an entire
        class of users, such as gradual feature rollout or undocumented
        allowlist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used. HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists. HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions. HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation. HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space. HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution. For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc. Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
        retry just the failing call. (b) Use `ABORTED` if the client should
        retry at a higher level. For example, when a client-specified test-
        and-set fails, indicating the client should restart a read-modify-
        write sequence. (c) Use `FAILED_PRECONDITION` if the client should not
        retry until the system state has been explicitly fixed. For example,
        if an "rmdir" fails because the directory is non-empty,
        `FAILED_PRECONDITION` should be returned since the client should not
        retry unless the files are deleted from the directory. HTTP Mapping:
        400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort. See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range. E.g.,
        seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size. There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We recommend
        using `OUT_OF_RANGE` (the more specific error) when it applies so that
        callers who are iterating through a space can easily look for an
        `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping: 400
        Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service. HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors. This means that some invariants expected by
        the underlying system have been broken. This error code is reserved
        for serious errors. HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable. This is most likely a
        transient condition, which can be corrected by retrying with a
        backoff. Note that it is not always safe to retry non-idempotent
        operations. See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 503
        Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption. HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  message = _messages.StringField(1)
  status = _messages.EnumField('StatusValueValuesEnum', 2)


class GoogleCloudAiplatformV1SchemaTablesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain tables data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1SchemaTablesDatasetMetadataInputConfig attribute.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTablesDatasetMetadataInputConfig', 1)


class GoogleCloudAiplatformV1SchemaTablesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTablesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table. e.g.
      bq://projectId.bqDatasetId.bqTableId
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTablesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTablesDatasetMetadataGcsSource object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1SchemaTablesDatasetMetadataInputConfig(_messages.Message):
  r"""The tables Dataset's data source. The Dataset doesn't store the data
  directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1SchemaTablesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A GoogleCloudAiplatformV1SchemaTablesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1SchemaTablesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1SchemaTablesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1SchemaTextClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to text classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTextDataItem(_messages.Message):
  r"""Payload of Text DataItem.

  Fields:
    gcsUri: Output only. Google Cloud Storage URI points to the original text
      in user's bucket. The text file is up to 10MB in size.
  """

  gcsUri = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTextDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Text DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Text DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTextExtractionAnnotation(_messages.Message):
  r"""Annotation details specific to text extraction.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    textSegment: The segment of the text content.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  textSegment = _messages.MessageField('GoogleCloudAiplatformV1SchemaTextSegment', 3)


class GoogleCloudAiplatformV1SchemaTextSegment(_messages.Message):
  r"""The text segment inside of DataItem.

  Fields:
    content: The text content in the segment for output only.
    endOffset: Zero-based character index of the first character past the end
      of the text segment (counting character from the beginning of the text).
      The character at the end_offset is NOT included in the text segment.
    startOffset: Zero-based character index of the first character of the text
      segment (counting characters from the beginning of the text).
  """

  content = _messages.StringField(1)
  endOffset = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  startOffset = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class GoogleCloudAiplatformV1SchemaTextSentimentAnnotation(_messages.Message):
  r"""Annotation details specific to text sentiment.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    sentiment: The sentiment score for text.
    sentimentMax: The sentiment max score for text.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sentiment = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sentimentMax = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SchemaTextSentimentSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains TextSentiment Annotations.

  Fields:
    sentimentMax: The maximum sentiment of sentiment Anntoation in this
      SavedQuery.
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SchemaTimeSegment(_messages.Message):
  r"""A time period inside of a DataItem that has a time dimension (e.g.
  video).

  Fields:
    endTimeOffset: End of the time segment (exclusive), represented as the
      duration since the start of the DataItem.
    startTimeOffset: Start of the time segment (inclusive), represented as the
      duration since the start of the DataItem.
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain time series data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataInputConfig
      attribute.
    timeColumn: The column name of the time column that identifies time order
      in the time series.
    timeSeriesIdentifierColumn: The column name of the time series identifier
      column that identifies the time series.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataInputConfig', 1)
  timeColumn = _messages.StringField(2)
  timeSeriesIdentifierColumn = _messages.StringField(3)


class GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataInputConfig(_messages.Message):
  r"""The time series Dataset's data source. The Dataset doesn't store the
  data directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A
      GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecasting(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Forecasting Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputs(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputs
  object.

  Fields:
    additionalExperiments: Additional experiment flags for the time series
      forcasting training.
    availableAtForecastColumns: Names of columns that are available and
      provided when a forecast is requested. These columns contain information
      for the given entity (identified by the time_series_identifier_column
      column) that is known at forecast. For example, predicted weather for a
      specific day.
    contextWindow: The amount of time into the past training and prediction
      data is used for model training and prediction respectively. Expressed
      in number of units defined by the `data_granularity` field.
    dataGranularity: Expected difference in time granularity between rows in
      the data.
    enableProbabilisticInference: If probabilistic inference is enabled, the
      model will fit a distribution that captures the uncertainty of a
      prediction. At inference time, the predictive distribution is used to
      make a point prediction that minimizes the optimization objective. For
      example, the mean of a predictive distribution is the point prediction
      that minimizes RMSE loss. If quantiles are specified, then the quantiles
      of the distribution are also returned. The optimization objective cannot
      be minimize-quantile-loss.
    exportEvaluatedDataItemsConfig: Configuration for exporting test set
      predictions to a BigQuery table. If this configuration is absent, then
      the export is not performed.
    forecastHorizon: The amount of time into the future for which forecasted
      values for the target are returned. Expressed in number of units defined
      by the `data_granularity` field.
    hierarchyConfig: Configuration that defines the hierarchical relationship
      of time series and parameters for hierarchical forecasting strategies.
    holidayRegions: The geographical region based on which the holiday effect
      is applied in modeling by adding holiday categorical array feature that
      include all holidays matching the date. This option only allowed when
      data_granularity is day. By default, holiday effect modeling is
      disabled. To turn it on, specify the holiday region using this option.
    optimizationObjective: Objective function the model is optimizing towards.
      The training process creates a model that optimizes the value of the
      objective function over the validation set. The supported optimization
      objectives: * "minimize-rmse" (default) - Minimize root-mean-squared
      error (RMSE). * "minimize-mae" - Minimize mean-absolute error (MAE). *
      "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE). *
      "minimize-rmspe" - Minimize root-mean-squared percentage error (RMSPE).
      * "minimize-wape-mae" - Minimize the combination of weighted absolute
      percentage error (WAPE) and mean-absolute-error (MAE). * "minimize-
      quantile-loss" - Minimize the quantile loss at the quantiles defined in
      `quantiles`. * "minimize-mape" - Minimize the mean absolute percentage
      error.
    quantiles: Quantiles to use for minimize-quantile-loss
      `optimization_objective`, or for probabilistic inference. Up to 5
      quantiles are allowed of values between 0 and 1, exclusive. Required if
      the value of optimization_objective is minimize-quantile-loss.
      Represents the percent quantiles to use for that objective. Quantiles
      must be unique.
    targetColumn: The name of the column that the Model is to predict values
      for. This column must be unavailable at forecast.
    timeColumn: The name of the column that identifies time order in the time
      series. This column must be available at forecast.
    timeSeriesAttributeColumns: Column names that should be used as attribute
      columns. The value of these columns does not vary as a function of time.
      For example, store ID or item color.
    timeSeriesIdentifierColumn: The name of the column that identifies the
      time series.
    trainBudgetMilliNodeHours: Required. The train budget of creating this
      model, expressed in milli node hours i.e. 1,000 value in this field
      means 1 node hour. The training cost of the model will not exceed this
      budget. The final cost will be attempted to be close to the budget,
      though may end up being (even) noticeably smaller - at the backend's
      discretion. This especially may happen when further model training
      ceases to provide any improvements. If the budget is set to a value
      known to be insufficient to train a model for the given dataset, the
      training won't be attempted and will error. The train budget must be
      between 1,000 and 72,000 milli node hours, inclusive.
    transformations: Each transformation will apply transform function to
      given input column. And the result will be used for training. When
      creating transformation for BigQuery Struct column, the column should be
      flattened using "." as the delimiter.
    unavailableAtForecastColumns: Names of columns that are unavailable when a
      forecast is requested. This column contains information for the given
      entity (identified by the time_series_identifier_column) that is unknown
      before the forecast For example, actual weather on a given day.
    validationOptions: Validation options for the data validation component.
      The available options are: * "fail-pipeline" - default, will validate
      against the validation and fail the pipeline if it fails. * "ignore-
      validation" - ignore the results of the validation and continue
    weightColumn: Column name that should be used as the weight column. Higher
      values in this column give more importance to the row during model
      training. The column must have numeric values between 0 and 10000
      inclusively; 0 means the row is ignored for training. If weight column
      field is not set, then all rows are assumed to have equal weight of 1.
    windowConfig: Config containing strategy for generating sliding windows.
  """

  additionalExperiments = _messages.StringField(1, repeated=True)
  availableAtForecastColumns = _messages.StringField(2, repeated=True)
  contextWindow = _messages.IntegerField(3)
  dataGranularity = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsGranularity', 4)
  enableProbabilisticInference = _messages.BooleanField(5)
  exportEvaluatedDataItemsConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig', 6)
  forecastHorizon = _messages.IntegerField(7)
  hierarchyConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHierarchyConfig', 8)
  holidayRegions = _messages.StringField(9, repeated=True)
  optimizationObjective = _messages.StringField(10)
  quantiles = _messages.FloatField(11, repeated=True)
  targetColumn = _messages.StringField(12)
  timeColumn = _messages.StringField(13)
  timeSeriesAttributeColumns = _messages.StringField(14, repeated=True)
  timeSeriesIdentifierColumn = _messages.StringField(15)
  trainBudgetMilliNodeHours = _messages.IntegerField(16)
  transformations = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformation', 17, repeated=True)
  unavailableAtForecastColumns = _messages.StringField(18, repeated=True)
  validationOptions = _messages.StringField(19)
  weightColumn = _messages.StringField(20)
  windowConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionWindowConfig', 21)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsGranularity(_messages.Message):
  r"""A duration of time expressed in time granularity units.

  Fields:
    quantity: The number of granularity_units between data points in the
      training data. If `granularity_unit` is `minute`, can be 1, 5, 10, 15,
      or 30. For all other values of `granularity_unit`, must be 1.
    unit: The time granularity unit of this time period. The supported units
      are: * "minute" * "hour" * "day" * "week" * "month" * "year"
  """

  quantity = _messages.IntegerField(1)
  unit = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformation(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInp
  utsTransformation object.

  Fields:
    auto: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastin
      gInputsTransformationAutoTransformation attribute.
    categorical: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlFor
      ecastingInputsTransformationCategoricalTransformation attribute.
    numeric: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecas
      tingInputsTransformationNumericTransformation attribute.
    text: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastin
      gInputsTransformationTextTransformation attribute.
    timestamp: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForec
      astingInputsTransformationTimestampTransformation attribute.
  """

  auto = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationAutoTransformation', 1)
  categorical = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalTransformation', 2)
  numeric = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericTransformation', 3)
  text = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextTransformation', 4)
  timestamp = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTimestampTransformation', 5)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationAutoTransformation(_messages.Message):
  r"""Training pipeline will infer the proper transformation based on the
  statistic of dataset.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  categorical string as is--no change to case, punctuation, spelling, tense,
  and so on. * Convert the category name to a dictionary lookup index and
  generate an embedding for each index. * Categories that appear less than 5
  times in the training dataset are treated as the "unknown" category. The
  "unknown" category gets its own special lookup index and resulting
  embedding.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  value converted to float32. * The z_score of the value. * log(value+1) when
  the value is greater than or equal to 0. Otherwise, this transformation is
  not applied and the value is considered a missing value. * z_score of
  log(value+1) when the value is greater than or equal to 0. Otherwise, this
  transformation is not applied and the value is considered a missing value. *
  A boolean value that indicates whether the value is valid.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  text as is--no change to case, punctuation, spelling, tense, and so on. *
  Convert the category name to a dictionary lookup index and generate an
  embedding for each index.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTimestampTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. *
  Apply the transformation functions for Numerical columns. * Determine the
  year, month, day,and weekday. Treat each value from the timestamp as a
  Categorical column. * Invalid numerical values (for example, values that
  fall outside of a typical timestamp range, or are extreme values) receive no
  special treatment and are not removed.

  Fields:
    columnName: A string attribute.
    timeFormat: The format in which that time field is expressed. The
      time_format must either be one of: * `unix-seconds` * `unix-
      milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for
      respectively number of seconds, milliseconds, microseconds and
      nanoseconds since start of the Unix epoch); or be written in `strftime`
      syntax. If time_format is not set, then the default format is RFC 3339
      `date-time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z)
  """

  columnName = _messages.StringField(1)
  timeFormat = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingMetadata(_messages.Message):
  r"""Model metadata specific to AutoML Forecasting.

  Fields:
    evaluatedDataItemsBigqueryUri: BigQuery destination uri for exported
      evaluated examples.
    trainCostMilliNodeHours: Output only. The actual training cost of the
      model, expressed in milli node hours, i.e. 1,000 value in this field
      means 1 node hour. Guaranteed to not exceed the train budget.
  """

  evaluatedDataItemsBigqueryUri = _messages.StringField(1)
  trainCostMilliNodeHours = _messages.IntegerField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassification(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Image Classification
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassific
  ationInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    baseModelId: The ID of the `base` model. If it is specified, the new model
      will be trained based on the `base` model. Otherwise, the new model will
      be trained from scratch. The `base` model must be in the same Project
      and Location as the new Model to train, and have the same modelType.
    budgetMilliNodeHours: The training budget of creating this model,
      expressed in milli node hours i.e. 1,000 value in this field means 1
      node hour. The actual metadata.costMilliNodeHours will be equal or less
      than this value. If further model training ceases to provide any
      improvements, it will stop without using the full budget and the
      metadata.successfulStopReason will be `model-converged`. Note, node_hour
      = actual_hour * number_of_nodes_involved. For modelType
      `cloud`(default), the budget must be between 8,000 and 800,000 milli
      node hours, inclusive. The default value is 192,000 which represents one
      day in wall time, considering 8 nodes are used. For model types `mobile-
      tf-low-latency-1`, `mobile-tf-versatile-1`, `mobile-tf-high-accuracy-1`,
      the training budget must be between 1,000 and 100,000 milli node hours,
      inclusive. The default value is 24,000 which represents one day in wall
      time on a single node that is used.
    disableEarlyStopping: Use the entire training budget. This disables the
      early stopping feature. When false the early stopping feature is
      enabled, which means that AutoML Image Classification might stop
      training before the entire training budget has been used.
    modelType: A ModelTypeValueValuesEnum attribute.
    multiLabel: If false, a single-label (multi-class) Model will be trained
      (i.e. assuming that for each image just up to one annotation may be
      applicable). If true, a multi-label Model will be trained (i.e. assuming
      that for each image multiple annotations may be applicable).
    uptrainBaseModelId: The ID of `base` model for upTraining. If it is
      specified, the new model will be upTrained based on the `base` model for
      upTraining. Otherwise, the new model will be trained from scratch. The
      `base` model for upTraining must be in the same Project and Location as
      the new Model to train, and have the same modelType.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A Model best tailored to be used within Google Cloud, and which
        cannot be exported. Default.
      CLOUD_1: A model type best tailored to be used within Google Cloud,
        which cannot be exported externally. Compared to the CLOUD model
        above, it is expected to have higher prediction accuracy.
      MOBILE_TF_LOW_LATENCY_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as TensorFlow or Core ML model and used on a
        mobile or edge device afterwards. Expected to have low latency, but
        may have lower prediction quality than other mobile models.
      MOBILE_TF_VERSATILE_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as TensorFlow or Core ML model and used on a
        mobile or edge device with afterwards.
      MOBILE_TF_HIGH_ACCURACY_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as TensorFlow or Core ML model and used on a
        mobile or edge device afterwards. Expected to have a higher latency,
        but should also have a higher prediction quality than other mobile
        models.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    CLOUD_1 = 2
    MOBILE_TF_LOW_LATENCY_1 = 3
    MOBILE_TF_VERSATILE_1 = 4
    MOBILE_TF_HIGH_ACCURACY_1 = 5

  baseModelId = _messages.StringField(1)
  budgetMilliNodeHours = _messages.IntegerField(2)
  disableEarlyStopping = _messages.BooleanField(3)
  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 4)
  multiLabel = _messages.BooleanField(5)
  uptrainBaseModelId = _messages.StringField(6)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassific
  ationMetadata object.

  Enums:
    SuccessfulStopReasonValueValuesEnum: For successful job completions, this
      is the reason why the job has finished.

  Fields:
    costMilliNodeHours: The actual training cost of creating this model,
      expressed in milli node hours, i.e. 1,000 value in this field means 1
      node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
    successfulStopReason: For successful job completions, this is the reason
      why the job has finished.
  """

  class SuccessfulStopReasonValueValuesEnum(_messages.Enum):
    r"""For successful job completions, this is the reason why the job has
    finished.

    Values:
      SUCCESSFUL_STOP_REASON_UNSPECIFIED: Should not be set.
      BUDGET_REACHED: The inputs.budgetMilliNodeHours had been reached.
      MODEL_CONVERGED: Further training of the Model ceased to increase its
        quality, since it already has converged.
    """
    SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0
    BUDGET_REACHED = 1
    MODEL_CONVERGED = 2

  costMilliNodeHours = _messages.IntegerField(1)
  successfulStopReason = _messages.EnumField('SuccessfulStopReasonValueValuesEnum', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetection(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Image Object Detection
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDet
  ectionInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    budgetMilliNodeHours: The training budget of creating this model,
      expressed in milli node hours i.e. 1,000 value in this field means 1
      node hour. The actual metadata.costMilliNodeHours will be equal or less
      than this value. If further model training ceases to provide any
      improvements, it will stop without using the full budget and the
      metadata.successfulStopReason will be `model-converged`. Note, node_hour
      = actual_hour * number_of_nodes_involved. For modelType
      `cloud`(default), the budget must be between 20,000 and 900,000 milli
      node hours, inclusive. The default value is 216,000 which represents one
      day in wall time, considering 9 nodes are used. For model types `mobile-
      tf-low-latency-1`, `mobile-tf-versatile-1`, `mobile-tf-high-accuracy-1`
      the training budget must be between 1,000 and 100,000 milli node hours,
      inclusive. The default value is 24,000 which represents one day in wall
      time on a single node that is used.
    disableEarlyStopping: Use the entire training budget. This disables the
      early stopping feature. When false the early stopping feature is
      enabled, which means that AutoML Image Object Detection might stop
      training before the entire training budget has been used.
    modelType: A ModelTypeValueValuesEnum attribute.
    uptrainBaseModelId: The ID of `base` model for upTraining. If it is
      specified, the new model will be upTrained based on the `base` model for
      upTraining. Otherwise, the new model will be trained from scratch. The
      `base` model for upTraining must be in the same Project and Location as
      the new Model to train, and have the same modelType.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD_HIGH_ACCURACY_1: A model best tailored to be used within Google
        Cloud, and which cannot be exported. Expected to have a higher
        latency, but should also have a higher prediction quality than other
        cloud models.
      CLOUD_LOW_LATENCY_1: A model best tailored to be used within Google
        Cloud, and which cannot be exported. Expected to have a low latency,
        but may have lower prediction quality than other cloud models.
      CLOUD_1: A model best tailored to be used within Google Cloud, and which
        cannot be exported. Compared to the CLOUD_HIGH_ACCURACY_1 and
        CLOUD_LOW_LATENCY_1 models above, it is expected to have higher
        prediction quality and lower latency.
      MOBILE_TF_LOW_LATENCY_1: A model that, in addition to being available
        within Google Cloud can also be exported (see
        ModelService.ExportModel) and used on a mobile or edge device with
        TensorFlow afterwards. Expected to have low latency, but may have
        lower prediction quality than other mobile models.
      MOBILE_TF_VERSATILE_1: A model that, in addition to being available
        within Google Cloud can also be exported (see
        ModelService.ExportModel) and used on a mobile or edge device with
        TensorFlow afterwards.
      MOBILE_TF_HIGH_ACCURACY_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) and used on a mobile or edge device with
        TensorFlow afterwards. Expected to have a higher latency, but should
        also have a higher prediction quality than other mobile models.
      CLOUD_STREAMING_1: A model best tailored to be used within Google Cloud,
        and which cannot be exported. Expected to best support predictions in
        streaming with lower latency and lower prediction quality than other
        cloud models.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD_HIGH_ACCURACY_1 = 1
    CLOUD_LOW_LATENCY_1 = 2
    CLOUD_1 = 3
    MOBILE_TF_LOW_LATENCY_1 = 4
    MOBILE_TF_VERSATILE_1 = 5
    MOBILE_TF_HIGH_ACCURACY_1 = 6
    CLOUD_STREAMING_1 = 7

  budgetMilliNodeHours = _messages.IntegerField(1)
  disableEarlyStopping = _messages.BooleanField(2)
  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 3)
  uptrainBaseModelId = _messages.StringField(4)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDet
  ectionMetadata object.

  Enums:
    SuccessfulStopReasonValueValuesEnum: For successful job completions, this
      is the reason why the job has finished.

  Fields:
    costMilliNodeHours: The actual training cost of creating this model,
      expressed in milli node hours, i.e. 1,000 value in this field means 1
      node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
    successfulStopReason: For successful job completions, this is the reason
      why the job has finished.
  """

  class SuccessfulStopReasonValueValuesEnum(_messages.Enum):
    r"""For successful job completions, this is the reason why the job has
    finished.

    Values:
      SUCCESSFUL_STOP_REASON_UNSPECIFIED: Should not be set.
      BUDGET_REACHED: The inputs.budgetMilliNodeHours had been reached.
      MODEL_CONVERGED: Further training of the Model ceased to increase its
        quality, since it already has converged.
    """
    SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0
    BUDGET_REACHED = 1
    MODEL_CONVERGED = 2

  costMilliNodeHours = _messages.IntegerField(1)
  successfulStopReason = _messages.EnumField('SuccessfulStopReasonValueValuesEnum', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentation(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Image Segmentation
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentat
  ionInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    baseModelId: The ID of the `base` model. If it is specified, the new model
      will be trained based on the `base` model. Otherwise, the new model will
      be trained from scratch. The `base` model must be in the same Project
      and Location as the new Model to train, and have the same modelType.
    budgetMilliNodeHours: The training budget of creating this model,
      expressed in milli node hours i.e. 1,000 value in this field means 1
      node hour. The actual metadata.costMilliNodeHours will be equal or less
      than this value. If further model training ceases to provide any
      improvements, it will stop without using the full budget and the
      metadata.successfulStopReason will be `model-converged`. Note, node_hour
      = actual_hour * number_of_nodes_involved. Or actual_wall_clock_hours =
      train_budget_milli_node_hours / (number_of_nodes_involved * 1000) For
      modelType `cloud-high-accuracy-1`(default), the budget must be between
      20,000 and 2,000,000 milli node hours, inclusive. The default value is
      192,000 which represents one day in wall time (1000 milli * 24 hours * 8
      nodes).
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD_HIGH_ACCURACY_1: A model to be used via prediction calls to uCAIP
        API. Expected to have a higher latency, but should also have a higher
        prediction quality than other models.
      CLOUD_LOW_ACCURACY_1: A model to be used via prediction calls to uCAIP
        API. Expected to have a lower latency but relatively lower prediction
        quality.
      MOBILE_TF_LOW_LATENCY_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as TensorFlow model and used on a mobile or
        edge device afterwards. Expected to have low latency, but may have
        lower prediction quality than other mobile models.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD_HIGH_ACCURACY_1 = 1
    CLOUD_LOW_ACCURACY_1 = 2
    MOBILE_TF_LOW_LATENCY_1 = 3

  baseModelId = _messages.StringField(1)
  budgetMilliNodeHours = _messages.IntegerField(2)
  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 3)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentat
  ionMetadata object.

  Enums:
    SuccessfulStopReasonValueValuesEnum: For successful job completions, this
      is the reason why the job has finished.

  Fields:
    costMilliNodeHours: The actual training cost of creating this model,
      expressed in milli node hours, i.e. 1,000 value in this field means 1
      node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
    successfulStopReason: For successful job completions, this is the reason
      why the job has finished.
  """

  class SuccessfulStopReasonValueValuesEnum(_messages.Enum):
    r"""For successful job completions, this is the reason why the job has
    finished.

    Values:
      SUCCESSFUL_STOP_REASON_UNSPECIFIED: Should not be set.
      BUDGET_REACHED: The inputs.budgetMilliNodeHours had been reached.
      MODEL_CONVERGED: Further training of the Model ceased to increase its
        quality, since it already has converged.
    """
    SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0
    BUDGET_REACHED = 1
    MODEL_CONVERGED = 2

  costMilliNodeHours = _messages.IntegerField(1)
  successfulStopReason = _messages.EnumField('SuccessfulStopReasonValueValuesEnum', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTables(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Tables Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputs
  object.

  Fields:
    additionalExperiments: Additional experiment flags for the Tables training
      pipeline.
    disableEarlyStopping: Use the entire training budget. This disables the
      early stopping feature. By default, the early stopping feature is
      enabled, which means that AutoML Tables might stop training before the
      entire training budget has been used.
    exportEvaluatedDataItemsConfig: Configuration for exporting test set
      predictions to a BigQuery table. If this configuration is absent, then
      the export is not performed.
    optimizationObjective: Objective function the model is optimizing towards.
      The training process creates a model that maximizes/minimizes the value
      of the objective function over the validation set. The supported
      optimization objectives depend on the prediction type. If the field is
      not set, a default objective function is used. classification (binary):
      "maximize-au-roc" (default) - Maximize the area under the receiver
      operating characteristic (ROC) curve. "minimize-log-loss" - Minimize log
      loss. "maximize-au-prc" - Maximize the area under the precision-recall
      curve. "maximize-precision-at-recall" - Maximize precision for a
      specified recall value. "maximize-recall-at-precision" - Maximize recall
      for a specified precision value. classification (multi-class):
      "minimize-log-loss" (default) - Minimize log loss. regression:
      "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE).
      "minimize-mae" - Minimize mean-absolute error (MAE). "minimize-rmsle" -
      Minimize root-mean-squared log error (RMSLE).
    optimizationObjectivePrecisionValue: Required when optimization_objective
      is "maximize-recall-at-precision". Must be between 0 and 1, inclusive.
    optimizationObjectiveRecallValue: Required when optimization_objective is
      "maximize-precision-at-recall". Must be between 0 and 1, inclusive.
    predictionType: The type of prediction the Model is to produce.
      "classification" - Predict one out of multiple target values is picked
      for each row. "regression" - Predict a value based on its relation to
      other values. This type is available only to columns that contain
      semantically numeric values, i.e. integers or floating point number,
      even if stored as e.g. strings.
    targetColumn: The column name of the target column that the model is to
      predict.
    trainBudgetMilliNodeHours: Required. The train budget of creating this
      model, expressed in milli node hours i.e. 1,000 value in this field
      means 1 node hour. The training cost of the model will not exceed this
      budget. The final cost will be attempted to be close to the budget,
      though may end up being (even) noticeably smaller - at the backend's
      discretion. This especially may happen when further model training
      ceases to provide any improvements. If the budget is set to a value
      known to be insufficient to train a model for the given dataset, the
      training won't be attempted and will error. The train budget must be
      between 1,000 and 72,000 milli node hours, inclusive.
    transformations: Each transformation will apply transform function to
      given input column. And the result will be used for training. When
      creating transformation for BigQuery Struct column, the column should be
      flattened using "." as the delimiter.
    weightColumnName: Column name that should be used as the weight column.
      Higher values in this column give more importance to the row during
      model training. The column must have numeric values between 0 and 10000
      inclusively; 0 means the row is ignored for training. If weight column
      field is not set, then all rows are assumed to have equal weight of 1.
  """

  additionalExperiments = _messages.StringField(1, repeated=True)
  disableEarlyStopping = _messages.BooleanField(2)
  exportEvaluatedDataItemsConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig', 3)
  optimizationObjective = _messages.StringField(4)
  optimizationObjectivePrecisionValue = _messages.FloatField(5, variant=_messages.Variant.FLOAT)
  optimizationObjectiveRecallValue = _messages.FloatField(6, variant=_messages.Variant.FLOAT)
  predictionType = _messages.StringField(7)
  targetColumn = _messages.StringField(8)
  trainBudgetMilliNodeHours = _messages.IntegerField(9)
  transformations = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformation', 10, repeated=True)
  weightColumnName = _messages.StringField(11)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformation(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTr
  ansformation object.

  Fields:
    auto: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInpu
      tsTransformationAutoTransformation attribute.
    categorical: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTab
      lesInputsTransformationCategoricalTransformation attribute.
    numeric: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesI
      nputsTransformationNumericTransformation attribute.
    repeatedCategorical: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionA
      utoMlTablesInputsTransformationCategoricalArrayTransformation attribute.
    repeatedNumeric: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoM
      lTablesInputsTransformationNumericArrayTransformation attribute.
    repeatedText: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTa
      blesInputsTransformationTextArrayTransformation attribute.
    text: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInpu
      tsTransformationTextTransformation attribute.
    timestamp: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTable
      sInputsTransformationTimestampTransformation attribute.
  """

  auto = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationAutoTransformation', 1)
  categorical = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalTransformation', 2)
  numeric = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericTransformation', 3)
  repeatedCategorical = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalArrayTransformation', 4)
  repeatedNumeric = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericArrayTransformation', 5)
  repeatedText = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextArrayTransformation', 6)
  text = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextTransformation', 7)
  timestamp = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTimestampTransformation', 8)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationAutoTransformation(_messages.Message):
  r"""Training pipeline will infer the proper transformation based on the
  statistic of dataset.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalArrayTransformation(_messages.Message):
  r"""Treats the column as categorical array and performs following
  transformation functions. * For each element in the array, convert the
  category name to a dictionary lookup index and generate an embedding for
  each index. Combine the embedding of all elements into a single embedding
  using the mean. * Empty arrays treated as an embedding of zeroes.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  categorical string as is--no change to case, punctuation, spelling, tense,
  and so on. * Convert the category name to a dictionary lookup index and
  generate an embedding for each index. * Categories that appear less than 5
  times in the training dataset are treated as the "unknown" category. The
  "unknown" category gets its own special lookup index and resulting
  embedding.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericArrayTransformation(_messages.Message):
  r"""Treats the column as numerical array and performs following
  transformation functions. * All transformations for Numerical types applied
  to the average of the all elements. * The average of empty arrays is treated
  as zero.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  value converted to float32. * The z_score of the value. * log(value+1) when
  the value is greater than or equal to 0. Otherwise, this transformation is
  not applied and the value is considered a missing value. * z_score of
  log(value+1) when the value is greater than or equal to 0. Otherwise, this
  transformation is not applied and the value is considered a missing value. *
  A boolean value that indicates whether the value is valid.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextArrayTransformation(_messages.Message):
  r"""Treats the column as text array and performs following transformation
  functions. * Concatenate all text values in the array into a single text
  value using a space (" ") as a delimiter, and then treat the result as a
  single text value. Apply the transformations for Text columns. * Empty
  arrays treated as an empty text.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  text as is--no change to case, punctuation, spelling, tense, and so on. *
  Tokenize text to words. Convert each words to a dictionary lookup index and
  generate an embedding for each index. Combine the embedding of all elements
  into a single embedding using the mean. * Tokenization is based on unicode
  script boundaries. * Missing values get their own lookup index and resulting
  embedding. * Stop-words receive no special treatment and are not removed.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTimestampTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. *
  Apply the transformation functions for Numerical columns. * Determine the
  year, month, day,and weekday. Treat each value from the * timestamp as a
  Categorical column. * Invalid numerical values (for example, values that
  fall outside of a typical timestamp range, or are extreme values) receive no
  special treatment and are not removed.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
    timeFormat: The format in which that time field is expressed. The
      time_format must either be one of: * `unix-seconds` * `unix-
      milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for
      respectively number of seconds, milliseconds, microseconds and
      nanoseconds since start of the Unix epoch); or be written in `strftime`
      syntax. If time_format is not set, then the default format is RFC 3339
      `date-time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z)
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)
  timeFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesMetadata(_messages.Message):
  r"""Model metadata specific to AutoML Tables.

  Fields:
    evaluatedDataItemsBigqueryUri: BigQuery destination uri for exported
      evaluated examples.
    trainCostMilliNodeHours: Output only. The actual training cost of the
      model, expressed in milli node hours, i.e. 1,000 value in this field
      means 1 node hour. Guaranteed to not exceed the train budget.
  """

  evaluatedDataItemsBigqueryUri = _messages.StringField(1)
  trainCostMilliNodeHours = _messages.IntegerField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextClassification(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Text Classification
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextClassificationInputs', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextClassificationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextClassifica
  tionInputs object.

  Fields:
    multiLabel: A boolean attribute.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextExtraction(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Text Extraction Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextExtractionInputs', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextExtractionInputs(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextExtractionInputs
  object.
  """



class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextSentiment(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Text Sentiment Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextSentimentInputs', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextSentimentInputs(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextSentimentInputs
  object.

  Fields:
    sentimentMax: A sentiment is expressed as an integer ordinal, where higher
      value means a more positive sentiment. The range of sentiments that will
      be used is between 0 and sentimentMax (inclusive on both ends), and all
      the values in the range must be represented in the dataset before a
      model can be created. Only the Annotations with this sentimentMax will
      be used for training. sentimentMax value must be between 1 and 10
      (inclusive).
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoActionRecognition(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Video Action Recognition
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoActionRecognitionInputs', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoActionRecognitionInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoActionRec
  ognitionInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A model best tailored to be used within Google Cloud, and which c
        annot be exported. Default.
      MOBILE_VERSATILE_1: A model that, in addition to being available within
        Google Cloud, can also be exported (see ModelService.ExportModel) as a
        TensorFlow or TensorFlow Lite model and used on a mobile or edge
        device afterwards.
      MOBILE_JETSON_VERSATILE_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) to a Jetson device afterwards.
      MOBILE_CORAL_VERSATILE_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as a TensorFlow or TensorFlow Lite model and
        used on a Coral device afterwards.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    MOBILE_VERSATILE_1 = 2
    MOBILE_JETSON_VERSATILE_1 = 3
    MOBILE_CORAL_VERSATILE_1 = 4

  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoClassification(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Video Classification
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoClassificationInputs', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoClassificationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoClassific
  ationInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A model best tailored to be used within Google Cloud, and which
        cannot be exported. Default.
      MOBILE_VERSATILE_1: A model that, in addition to being available within
        Google Cloud, can also be exported (see ModelService.ExportModel) as a
        TensorFlow or TensorFlow Lite model and used on a mobile or edge
        device afterwards.
      MOBILE_JETSON_VERSATILE_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) to a Jetson device afterwards.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    MOBILE_VERSATILE_1 = 2
    MOBILE_JETSON_VERSATILE_1 = 3

  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoObjectTracking(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Video ObjectTracking
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoObjectTrackingInputs', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoObjectTrackingInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoObjectTra
  ckingInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A model best tailored to be used within Google Cloud, and which c
        annot be exported. Default.
      MOBILE_VERSATILE_1: A model that, in addition to being available within
        Google Cloud, can also be exported (see ModelService.ExportModel) as a
        TensorFlow or TensorFlow Lite model and used on a mobile or edge
        device afterwards.
      MOBILE_CORAL_VERSATILE_1: A versatile model that is meant to be exported
        (see ModelService.ExportModel) and used on a Google Coral device.
      MOBILE_CORAL_LOW_LATENCY_1: A model that trades off quality for low
        latency, to be exported (see ModelService.ExportModel) and used on a
        Google Coral device.
      MOBILE_JETSON_VERSATILE_1: A versatile model that is meant to be
        exported (see ModelService.ExportModel) and used on an NVIDIA Jetson
        device.
      MOBILE_JETSON_LOW_LATENCY_1: A model that trades off quality for low
        latency, to be exported (see ModelService.ExportModel) and used on an
        NVIDIA Jetson device.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    MOBILE_VERSATILE_1 = 2
    MOBILE_CORAL_VERSATILE_1 = 3
    MOBILE_CORAL_LOW_LATENCY_1 = 4
    MOBILE_JETSON_VERSATILE_1 = 5
    MOBILE_JETSON_LOW_LATENCY_1 = 6

  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionCustomJobMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionCustomJobMetadata
  object.

  Fields:
    backingCustomJob: The resource name of the CustomJob that has been created
      to carry out this custom task.
  """

  backingCustomJob = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionCustomTask(_messages.Message):
  r"""A TrainingJob that trains a custom code Model.

  Fields:
    inputs: The input parameters of this CustomTask.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1CustomJobSpec', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionCustomJobMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig(_messages.Message):
  r"""Configuration for exporting test set predictions to a BigQuery table.

  Fields:
    destinationBigqueryUri: URI of desired destination BigQuery table.
      Expected format: `bq://{project_id}:{dataset_id}:{table}` If not
      specified, then results are exported to the following auto-created
      BigQuery table: `{project_id}:export_evaluated_examples_{model_name}_{yy
      yy_MM_dd'T'HH_mm_ss_SSS'Z'}.evaluated_examples`
    overrideExistingTable: If true and an export destination is specified,
      then the contents of the destination are overwritten. Otherwise, if the
      export destination already exists, then the export operation fails.
  """

  destinationBigqueryUri = _messages.StringField(1)
  overrideExistingTable = _messages.BooleanField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHierarchyConfig(_messages.Message):
  r"""Configuration that defines the hierarchical relationship of time series
  and parameters for hierarchical forecasting strategies.

  Fields:
    groupColumns: A list of time series attribute column names that define the
      time series hierarchy. Only one level of hierarchy is supported, ex.
      'region' for a hierarchy of stores or 'department' for a hierarchy of
      products. If multiple columns are specified, time series will be grouped
      by their combined values, ex. ('blue', 'large') for 'color' and 'size',
      up to 5 columns are accepted. If no group columns are specified, all
      time series are considered to be part of the same group.
    groupTemporalTotalWeight: The weight of the loss for predictions
      aggregated over both the horizon and time series in the same hierarchy
      group.
    groupTotalWeight: The weight of the loss for predictions aggregated over
      time series in the same group.
    temporalTotalWeight: The weight of the loss for predictions aggregated
      over the horizon for a single time series.
  """

  groupColumns = _messages.StringField(1, repeated=True)
  groupTemporalTotalWeight = _messages.FloatField(2)
  groupTotalWeight = _messages.FloatField(3)
  temporalTotalWeight = _messages.FloatField(4)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuning
  JobMetadata object.

  Fields:
    backingHyperparameterTuningJob: The resource name of the
      HyperparameterTuningJob that has been created to carry out this
      HyperparameterTuning task.
    bestTrialBackingCustomJob: The resource name of the CustomJob that has
      been created to run the best Trial of this HyperparameterTuning task.
  """

  backingHyperparameterTuningJob = _messages.StringField(1)
  bestTrialBackingCustomJob = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobSpec(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuning
  JobSpec object.

  Fields:
    maxFailedTrialCount: The number of failed Trials that need to be seen
      before failing the HyperparameterTuningJob. If set to 0, Vertex AI
      decides how many Trials must fail before the whole job fails.
    maxTrialCount: The desired total number of Trials.
    parallelTrialCount: The desired number of Trials to run in parallel.
    studySpec: Study configuration of the HyperparameterTuningJob.
    trialJobSpec: The spec of a trial job. The same spec applies to the
      CustomJobs created in all the trials.
  """

  maxFailedTrialCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxTrialCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  parallelTrialCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  studySpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpec', 4)
  trialJobSpec = _messages.MessageField('GoogleCloudAiplatformV1CustomJobSpec', 5)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningTask(_messages.Message):
  r"""A TrainingJob that tunes Hypererparameters of a custom code Model.

  Fields:
    inputs: The input parameters of this HyperparameterTuningTask.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobSpec', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecasting(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Forecasting Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingMetadata', 2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecasti
  ngInputs object.

  Fields:
    additionalExperiments: Additional experiment flags for the time series
      forcasting training.
    availableAtForecastColumns: Names of columns that are available and
      provided when a forecast is requested. These columns contain information
      for the given entity (identified by the time_series_identifier_column
      column) that is known at forecast. For example, predicted weather for a
      specific day.
    contextWindow: The amount of time into the past training and prediction
      data is used for model training and prediction respectively. Expressed
      in number of units defined by the `data_granularity` field.
    dataGranularity: Expected difference in time granularity between rows in
      the data.
    exportEvaluatedDataItemsConfig: Configuration for exporting test set
      predictions to a BigQuery table. If this configuration is absent, then
      the export is not performed.
    forecastHorizon: The amount of time into the future for which forecasted
      values for the target are returned. Expressed in number of units defined
      by the `data_granularity` field.
    hierarchyConfig: Configuration that defines the hierarchical relationship
      of time series and parameters for hierarchical forecasting strategies.
    holidayRegions: The geographical region based on which the holiday effect
      is applied in modeling by adding holiday categorical array feature that
      include all holidays matching the date. This option only allowed when
      data_granularity is day. By default, holiday effect modeling is
      disabled. To turn it on, specify the holiday region using this option.
    optimizationObjective: Objective function the model is optimizing towards.
      The training process creates a model that optimizes the value of the
      objective function over the validation set. The supported optimization
      objectives: * "minimize-rmse" (default) - Minimize root-mean-squared
      error (RMSE). * "minimize-mae" - Minimize mean-absolute error (MAE). *
      "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE). *
      "minimize-rmspe" - Minimize root-mean-squared percentage error (RMSPE).
      * "minimize-wape-mae" - Minimize the combination of weighted absolute
      percentage error (WAPE) and mean-absolute-error (MAE). * "minimize-
      quantile-loss" - Minimize the quantile loss at the quantiles defined in
      `quantiles`. * "minimize-mape" - Minimize the mean absolute percentage
      error.
    quantiles: Quantiles to use for minimize-quantile-loss
      `optimization_objective`. Up to 5 quantiles are allowed of values
      between 0 and 1, exclusive. Required if the value of
      optimization_objective is minimize-quantile-loss. Represents the percent
      quantiles to use for that objective. Quantiles must be unique.
    targetColumn: The name of the column that the Model is to predict values
      for. This column must be unavailable at forecast.
    timeColumn: The name of the column that identifies time order in the time
      series. This column must be available at forecast.
    timeSeriesAttributeColumns: Column names that should be used as attribute
      columns. The value of these columns does not vary as a function of time.
      For example, store ID or item color.
    timeSeriesIdentifierColumn: The name of the column that identifies the
      time series.
    trainBudgetMilliNodeHours: Required. The train budget of creating this
      model, expressed in milli node hours i.e. 1,000 value in this field
      means 1 node hour. The training cost of the model will not exceed this
      budget. The final cost will be attempted to be close to the budget,
      though may end up being (even) noticeably smaller - at the backend's
      discretion. This especially may happen when further model training
      ceases to provide any improvements. If the budget is set to a value
      known to be insufficient to train a model for the given dataset, the
      training won't be attempted and will error. The train budget must be
      between 1,000 and 72,000 milli node hours, inclusive.
    transformations: Each transformation will apply transform function to
      given input column. And the result will be used for training. When
      creating transformation for BigQuery Struct column, the column should be
      flattened using "." as the delimiter.
    unavailableAtForecastColumns: Names of columns that are unavailable when a
      forecast is requested. This column contains information for the given
      entity (identified by the time_series_identifier_column) that is unknown
      before the forecast For example, actual weather on a given day.
    validationOptions: Validation options for the data validation component.
      The available options are: * "fail-pipeline" - default, will validate
      against the validation and fail the pipeline if it fails. * "ignore-
      validation" - ignore the results of the validation and continue
    weightColumn: Column name that should be used as the weight column. Higher
      values in this column give more importance to the row during model
      training. The column must have numeric values between 0 and 10000
      inclusively; 0 means the row is ignored for training. If weight column
      field is not set, then all rows are assumed to have equal weight of 1.
      This column must be available at forecast.
    windowConfig: Config containing strategy for generating sliding windows.
  """

  additionalExperiments = _messages.StringField(1, repeated=True)
  availableAtForecastColumns = _messages.StringField(2, repeated=True)
  contextWindow = _messages.IntegerField(3)
  dataGranularity = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsGranularity', 4)
  exportEvaluatedDataItemsConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig', 5)
  forecastHorizon = _messages.IntegerField(6)
  hierarchyConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHierarchyConfig', 7)
  holidayRegions = _messages.StringField(8, repeated=True)
  optimizationObjective = _messages.StringField(9)
  quantiles = _messages.FloatField(10, repeated=True)
  targetColumn = _messages.StringField(11)
  timeColumn = _messages.StringField(12)
  timeSeriesAttributeColumns = _messages.StringField(13, repeated=True)
  timeSeriesIdentifierColumn = _messages.StringField(14)
  trainBudgetMilliNodeHours = _messages.IntegerField(15)
  transformations = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformation', 16, repeated=True)
  unavailableAtForecastColumns = _messages.StringField(17, repeated=True)
  validationOptions = _messages.StringField(18)
  weightColumn = _messages.StringField(19)
  windowConfig = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionWindowConfig', 20)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsGranularity(_messages.Message):
  r"""A duration of time expressed in time granularity units.

  Fields:
    quantity: The number of granularity_units between data points in the
      training data. If `granularity_unit` is `minute`, can be 1, 5, 10, 15,
      or 30. For all other values of `granularity_unit`, must be 1.
    unit: The time granularity unit of this time period. The supported units
      are: * "minute" * "hour" * "day" * "week" * "month" * "year"
  """

  quantity = _messages.IntegerField(1)
  unit = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformation(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecasti
  ngInputsTransformation object.

  Fields:
    auto: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForec
      astingInputsTransformationAutoTransformation attribute.
    categorical: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPl
      usForecastingInputsTransformationCategoricalTransformation attribute.
    numeric: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusFo
      recastingInputsTransformationNumericTransformation attribute.
    text: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForec
      astingInputsTransformationTextTransformation attribute.
    timestamp: A GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlus
      ForecastingInputsTransformationTimestampTransformation attribute.
  """

  auto = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationAutoTransformation', 1)
  categorical = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationCategoricalTransformation', 2)
  numeric = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationNumericTransformation', 3)
  text = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTextTransformation', 4)
  timestamp = _messages.MessageField('GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTimestampTransformation', 5)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationAutoTransformation(_messages.Message):
  r"""Training pipeline will infer the proper transformation based on the
  statistic of dataset.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationCategoricalTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  categorical string as is--no change to case, punctuation, spelling, tense,
  and so on. * Convert the category name to a dictionary lookup index and
  generate an embedding for each index. * Categories that appear less than 5
  times in the training dataset are treated as the "unknown" category. The
  "unknown" category gets its own special lookup index and resulting
  embedding.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationNumericTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  value converted to float32. * The z_score of the value. * log(value+1) when
  the value is greater than or equal to 0. Otherwise, this transformation is
  not applied and the value is considered a missing value. * z_score of
  log(value+1) when the value is greater than or equal to 0. Otherwise, this
  transformation is not applied and the value is considered a missing value.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTextTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  text as is--no change to case, punctuation, spelling, tense, and so on. *
  Convert the category name to a dictionary lookup index and generate an
  embedding for each index.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTimestampTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. *
  Apply the transformation functions for Numerical columns. * Determine the
  year, month, day,and weekday. Treat each value from the timestamp as a
  Categorical column. * Invalid numerical values (for example, values that
  fall outside of a typical timestamp range, or are extreme values) receive no
  special treatment and are not removed.

  Fields:
    columnName: A string attribute.
    timeFormat: The format in which that time field is expressed. The
      time_format must either be one of: * `unix-seconds` * `unix-
      milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for
      respectively number of seconds, milliseconds, microseconds and
      nanoseconds since start of the Unix epoch); or be written in `strftime`
      syntax. If time_format is not set, then the default format is RFC 3339
      `date-time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z)
  """

  columnName = _messages.StringField(1)
  timeFormat = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingMetadata(_messages.Message):
  r"""Model metadata specific to Seq2Seq Plus Forecasting.

  Fields:
    evaluatedDataItemsBigqueryUri: BigQuery destination uri for exported
      evaluated examples.
    trainCostMilliNodeHours: Output only. The actual training cost of the
      model, expressed in milli node hours, i.e. 1,000 value in this field
      means 1 node hour. Guaranteed to not exceed the train budget.
  """

  evaluatedDataItemsBigqueryUri = _messages.StringField(1)
  trainCostMilliNodeHours = _messages.IntegerField(2)


class GoogleCloudAiplatformV1SchemaTrainingjobDefinitionWindowConfig(_messages.Message):
  r"""Config that contains the strategy used to generate sliding windows in
  time series training. A window is a series of rows that comprise the context
  up to the time of prediction, and the horizon following. The corresponding
  row for each window marks the start of the forecast horizon. Each window is
  used as an input example for training/evaluation.

  Fields:
    column: Name of the column that should be used to generate sliding
      windows. The column should contain either booleans or string booleans;
      if the value of the row is True, generate a sliding window with the
      horizon starting at that row. The column will not be used as a feature
      in training.
    maxCount: Maximum number of windows that should be generated across all
      time series.
    strideLength: Stride length used to generate input examples. Within one
      time series, every {$STRIDE_LENGTH} rows will be used to generate a
      sliding window.
  """

  column = _messages.StringField(1)
  maxCount = _messages.IntegerField(2)
  strideLength = _messages.IntegerField(3)


class GoogleCloudAiplatformV1SchemaVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1)
  y = _messages.FloatField(2)


class GoogleCloudAiplatformV1SchemaVideoActionRecognitionAnnotation(_messages.Message):
  r"""Annotation details specific to video action recognition.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1SchemaVideoClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to video classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1SchemaVideoDataItem(_messages.Message):
  r"""Payload of Video DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original video in
      user's bucket. The video is up to 50 GB in size and up to 3 hour in
      duration.
    mimeType: Output only. The mime type of the content of the video. Only the
      videos in below listed mime types are supported. Supported mime_type: -
      video/mp4 - video/avi - video/quicktime
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaVideoDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Video DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Video DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1SchemaVideoObjectTrackingAnnotation(_messages.Message):
  r"""Annotation details specific to video object tracking.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    instanceId: The instance of the object, expressed as a positive integer.
      Used to track the same object across different frames.
    timeOffset: A time (frame) of a video to which this annotation pertains.
      Represented as the duration since the video's start.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  instanceId = _messages.IntegerField(3)
  timeOffset = _messages.StringField(4)
  xMax = _messages.FloatField(5)
  xMin = _messages.FloatField(6)
  yMax = _messages.FloatField(7)
  yMin = _messages.FloatField(8)


class GoogleCloudAiplatformV1SchemaVisualInspectionClassificationLabelSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaVisualInspectionClassificationLabelSavedQ
  ueryMetadata object.

  Fields:
    multiLabel: Whether or not the classification label is multi_label.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformV1SchemaVisualInspectionMaskSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1SchemaVisualInspectionMaskSavedQueryMetadata
  object.
  """



class GoogleCloudAiplatformV1SearchDataItemsResponse(_messages.Message):
  r"""Response message for DatasetService.SearchDataItems.

  Fields:
    dataItemViews: The DataItemViews read.
    nextPageToken: A token to retrieve next page of results. Pass to
      SearchDataItemsRequest.page_token to obtain that page.
  """

  dataItemViews = _messages.MessageField('GoogleCloudAiplatformV1DataItemView', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1SearchFeaturesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.SearchFeatures.

  Fields:
    features: The Features matching the request. Fields returned: * `name` *
      `description` * `labels` * `create_time` * `update_time`
    nextPageToken: A token, which can be sent as
      SearchFeaturesRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  features = _messages.MessageField('GoogleCloudAiplatformV1Feature', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1SearchMigratableResourcesRequest(_messages.Message):
  r"""Request message for MigrationService.SearchMigratableResources.

  Fields:
    filter: A filter for your search. You can use the following types of
      filters: * Resource type filters. The following strings filter for a
      specific type of MigratableResource: * `ml_engine_model_version:*` *
      `automl_model:*` * `automl_dataset:*` * `data_labeling_dataset:*` *
      "Migrated or not" filters. The following strings filter for resources
      that either have or have not already been migrated: *
      `last_migrate_time:*` filters for migrated resources. * `NOT
      last_migrate_time:*` filters for not yet migrated resources.
    pageSize: The standard page size. The default and maximum value is 100.
    pageToken: The standard page token.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class GoogleCloudAiplatformV1SearchMigratableResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.SearchMigratableResources.

  Fields:
    migratableResources: All migratable resources that can be migrated to the
      location specified in the request.
    nextPageToken: The standard next-page token. The migratable_resources may
      not fill page_size in SearchMigratableResourcesRequest even when there
      are subsequent pages.
  """

  migratableResources = _messages.MessageField('GoogleCloudAiplatformV1MigratableResource', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequest(_messages.Message):
  r"""Request message for
  JobService.SearchModelDeploymentMonitoringStatsAnomalies.

  Fields:
    deployedModelId: Required. The DeployedModel ID of the
      [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
    endTime: The latest timestamp of stats being generated. If not set,
      indicates feching stats till the latest possible one.
    featureDisplayName: The feature display name. If specified, only return
      the stats belonging to this feature. Format: ModelMonitoringStatsAnomali
      es.FeatureHistoricStatsAnomalies.feature_display_name, example:
      "user_destination".
    objectives: Required. Objectives of the stats to retrieve.
    pageSize: The standard list page size.
    pageToken: A page token received from a previous
      JobService.SearchModelDeploymentMonitoringStatsAnomalies call.
    startTime: The earliest timestamp of stats being generated. If not set,
      indicates fetching stats till the earliest possible one.
  """

  deployedModelId = _messages.StringField(1)
  endTime = _messages.StringField(2)
  featureDisplayName = _messages.StringField(3)
  objectives = _messages.MessageField('GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequestStatsAnomaliesObjective', 4, repeated=True)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  startTime = _messages.StringField(7)


class GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequestStatsAnomaliesObjective(_messages.Message):
  r"""Stats requested for specific objective.

  Enums:
    TypeValueValuesEnum:

  Fields:
    topFeatureCount: If set, all attribution scores between
      SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time and
      SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time are
      fetched, and page token doesn't take effect in this case. Only used to
      retrieve attribution score for the top Features which has the highest
      attribution score in the latest monitoring run.
    type: A TypeValueValuesEnum attribute.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""TypeValueValuesEnum enum type.

    Values:
      MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED: Default value,
        should not be set.
      RAW_FEATURE_SKEW: Raw feature values' stats to detect skew between
        Training-Prediction datasets.
      RAW_FEATURE_DRIFT: Raw feature values' stats to detect drift between
        Serving-Prediction datasets.
      FEATURE_ATTRIBUTION_SKEW: Feature attribution scores to detect skew
        between Training-Prediction datasets.
      FEATURE_ATTRIBUTION_DRIFT: Feature attribution scores to detect skew
        between Prediction datasets collected within different time windows.
    """
    MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED = 0
    RAW_FEATURE_SKEW = 1
    RAW_FEATURE_DRIFT = 2
    FEATURE_ATTRIBUTION_SKEW = 3
    FEATURE_ATTRIBUTION_DRIFT = 4

  topFeatureCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesResponse(_messages.Message):
  r"""Response message for
  JobService.SearchModelDeploymentMonitoringStatsAnomalies.

  Fields:
    monitoringStats: Stats retrieved for requested objectives. There are at
      most 1000 ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.pr
      ediction_stats in the response.
    nextPageToken: The page token that can be used by the next
      JobService.SearchModelDeploymentMonitoringStatsAnomalies call.
  """

  monitoringStats = _messages.MessageField('GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1SmoothGradConfig(_messages.Message):
  r"""Config for SmoothGrad approximation of gradients. When enabled, the
  gradients are approximated by averaging the gradients from noisy samples in
  the vicinity of the inputs. Adding noise can help improve the computed
  gradients. Refer to this paper for more details:
  https://arxiv.org/pdf/1706.03825.pdf

  Fields:
    featureNoiseSigma: This is similar to noise_sigma, but provides additional
      flexibility. A separate noise sigma can be provided for each feature,
      which is useful if their distributions are different. No noise is added
      to features that are not set. If this field is unset, noise_sigma will
      be used for all features.
    noiseSigma: This is a single float value and will be used to add noise to
      all the features. Use this field when all features are normalized to
      have the same distribution: scale to range [0, 1], [-1, 1] or z-scoring,
      where features are normalized to have 0-mean and 1-variance. Learn more
      about [normalization](https://developers.google.com/machine-
      learning/data-prep/transform/normalization). For best results the
      recommended value is about 10% - 20% of the standard deviation of the
      input feature. Refer to section 3.2 of the SmoothGrad paper:
      https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1. If the
      distribution is different per feature, set feature_noise_sigma instead
      for each feature.
    noisySampleCount: The number of gradient samples to use for approximation.
      The higher this number, the more accurate the gradient is, but the
      runtime complexity increases by this factor as well. Valid range of its
      value is [1, 50]. Defaults to 3.
  """

  featureNoiseSigma = _messages.MessageField('GoogleCloudAiplatformV1FeatureNoiseSigma', 1)
  noiseSigma = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  noisySampleCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SpecialistPool(_messages.Message):
  r"""SpecialistPool represents customers' own workforce to work on their data
  labeling jobs. It includes a group of specialist managers and workers.
  Managers are responsible for managing the workers in this pool as well as
  customers' data labeling jobs associated with this pool. Customers create
  specialist pool as well as start data labeling jobs on Cloud, managers and
  workers handle the jobs using CrowdCompute console.

  Fields:
    displayName: Required. The user-defined name of the SpecialistPool. The
      name can be up to 128 characters long and can consist of any UTF-8
      characters. This field should be unique on project-level.
    name: Required. The resource name of the SpecialistPool.
    pendingDataLabelingJobs: Output only. The resource name of the pending
      data labeling jobs.
    specialistManagerEmails: The email addresses of the managers in the
      SpecialistPool.
    specialistManagersCount: Output only. The number of managers in this
      SpecialistPool.
    specialistWorkerEmails: The email addresses of workers in the
      SpecialistPool.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  pendingDataLabelingJobs = _messages.StringField(3, repeated=True)
  specialistManagerEmails = _messages.StringField(4, repeated=True)
  specialistManagersCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  specialistWorkerEmails = _messages.StringField(6, repeated=True)


class GoogleCloudAiplatformV1StopTrialRequest(_messages.Message):
  r"""Request message for VizierService.StopTrial."""


class GoogleCloudAiplatformV1StratifiedSplit(_messages.Message):
  r"""Assigns input data to the training, validation, and test sets so that
  the distribution of values found in the categorical column (as specified by
  the `key` field) is mirrored within each split. The fraction values
  determine the relative sizes of the splits. For example, if the specified
  column has three values, with 50% of the rows having value "A", 25% value
  "B", and 25% value "C", and the split fractions are specified as 80/10/10,
  then the training set will constitute 80% of the training data, with about
  50% of the training set rows having the value "A" for the specified column,
  about 25% having the value "B", and about 25% having the value "C". Only the
  top 500 occurring values are used; any values not in the top 500 values are
  randomly assigned to a split. If less than three rows contain a specific
  value, those rows are randomly assigned. Supported only for tabular
  Datasets.

  Fields:
    key: Required. The key is a name of one of the Dataset's data columns. The
      key provided must be for a categorical column.
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  key = _messages.StringField(1)
  testFraction = _messages.FloatField(2)
  trainingFraction = _messages.FloatField(3)
  validationFraction = _messages.FloatField(4)


class GoogleCloudAiplatformV1StreamingReadFeatureValuesRequest(_messages.Message):
  r"""Request message for
  FeaturestoreOnlineServingService.StreamingFeatureValuesRead.

  Fields:
    entityIds: Required. IDs of entities to read Feature values of. The
      maximum number of IDs is 100. For example, for a machine learning model
      predicting user clicks on a website, an entity ID could be `user_123`.
    featureSelector: Required. Selector choosing Features of the target
      EntityType. Feature IDs will be deduplicated.
  """

  entityIds = _messages.StringField(1, repeated=True)
  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1FeatureSelector', 2)


class GoogleCloudAiplatformV1StringArray(_messages.Message):
  r"""A list of string values.

  Fields:
    values: A list of string values.
  """

  values = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1Study(_messages.Message):
  r"""A message representing a Study.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of a Study.

  Fields:
    createTime: Output only. Time at which the study was created.
    displayName: Required. Describes the Study, default value is empty string.
    inactiveReason: Output only. A human readable reason why the Study is
      inactive. This should be empty if a study is ACTIVE or COMPLETED.
    name: Output only. The name of a study. The study's globally unique
      identifier. Format:
      `projects/{project}/locations/{location}/studies/{study}`
    state: Output only. The detailed state of a Study.
    studySpec: Required. Configuration of the Study.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of a Study.

    Values:
      STATE_UNSPECIFIED: The study state is unspecified.
      ACTIVE: The study is active.
      INACTIVE: The study is stopped due to an internal error.
      COMPLETED: The study is done when the service exhausts the parameter
        search space or max_trial_count is reached.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2
    COMPLETED = 3

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  inactiveReason = _messages.StringField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  studySpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpec', 6)


class GoogleCloudAiplatformV1StudySpec(_messages.Message):
  r"""Represents specification of a Study.

  Enums:
    AlgorithmValueValuesEnum: The search algorithm specified for the Study.
    MeasurementSelectionTypeValueValuesEnum: Describe which measurement
      selection type will be used
    ObservationNoiseValueValuesEnum: The observation noise level of the study.
      Currently only supported by the Vertex AI Vizier service. Not supported
      by HyperparameterTuningJob or TrainingPipeline.

  Fields:
    algorithm: The search algorithm specified for the Study.
    convexAutomatedStoppingSpec: The automated early stopping spec using
      convex stopping rule.
    decayCurveStoppingSpec: The automated early stopping spec using decay
      curve rule.
    measurementSelectionType: Describe which measurement selection type will
      be used
    medianAutomatedStoppingSpec: The automated early stopping spec using
      median rule.
    metrics: Required. Metric specs for the Study.
    observationNoise: The observation noise level of the study. Currently only
      supported by the Vertex AI Vizier service. Not supported by
      HyperparameterTuningJob or TrainingPipeline.
    parameters: Required. The set of parameters to tune.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""The search algorithm specified for the Study.

    Values:
      ALGORITHM_UNSPECIFIED: The default algorithm used by Vertex AI for
        [hyperparameter tuning](https://cloud.google.com/vertex-
        ai/docs/training/hyperparameter-tuning-overview) and [Vertex AI
        Vizier](https://cloud.google.com/vertex-ai/docs/vizier).
      GRID_SEARCH: Simple grid search within the feasible space. To use grid
        search, all parameters must be `INTEGER`, `CATEGORICAL`, or
        `DISCRETE`.
      RANDOM_SEARCH: Simple random search within the feasible space.
    """
    ALGORITHM_UNSPECIFIED = 0
    GRID_SEARCH = 1
    RANDOM_SEARCH = 2

  class MeasurementSelectionTypeValueValuesEnum(_messages.Enum):
    r"""Describe which measurement selection type will be used

    Values:
      MEASUREMENT_SELECTION_TYPE_UNSPECIFIED: Will be treated as
        LAST_MEASUREMENT.
      LAST_MEASUREMENT: Use the last measurement reported.
      BEST_MEASUREMENT: Use the best measurement reported.
    """
    MEASUREMENT_SELECTION_TYPE_UNSPECIFIED = 0
    LAST_MEASUREMENT = 1
    BEST_MEASUREMENT = 2

  class ObservationNoiseValueValuesEnum(_messages.Enum):
    r"""The observation noise level of the study. Currently only supported by
    the Vertex AI Vizier service. Not supported by HyperparameterTuningJob or
    TrainingPipeline.

    Values:
      OBSERVATION_NOISE_UNSPECIFIED: The default noise level chosen by Vertex
        AI.
      LOW: Vertex AI assumes that the objective function is (nearly) perfectly
        reproducible, and will never repeat the same Trial parameters.
      HIGH: Vertex AI will estimate the amount of noise in metric evaluations,
        it may repeat the same Trial parameters more than once.
    """
    OBSERVATION_NOISE_UNSPECIFIED = 0
    LOW = 1
    HIGH = 2

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  convexAutomatedStoppingSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecConvexAutomatedStoppingSpec', 2)
  decayCurveStoppingSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecDecayCurveAutomatedStoppingSpec', 3)
  measurementSelectionType = _messages.EnumField('MeasurementSelectionTypeValueValuesEnum', 4)
  medianAutomatedStoppingSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecMedianAutomatedStoppingSpec', 5)
  metrics = _messages.MessageField('GoogleCloudAiplatformV1StudySpecMetricSpec', 6, repeated=True)
  observationNoise = _messages.EnumField('ObservationNoiseValueValuesEnum', 7)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpec', 8, repeated=True)


class GoogleCloudAiplatformV1StudySpecConvexAutomatedStoppingSpec(_messages.Message):
  r"""Configuration for ConvexAutomatedStoppingSpec. When there are enough
  completed trials (configured by min_measurement_count), for pending trials
  with enough measurements and steps, the policy first computes an
  overestimate of the objective value at max_num_steps according to the slope
  of the incomplete objective value curve. No prediction can be made if the
  curve is completely flat. If the overestimation is worse than the best
  objective value of the completed trials, this pending trial will be early-
  stopped, but a last measurement will be added to the pending trial with
  max_num_steps and predicted objective value from the autoregression model.

  Fields:
    learningRateParameterName: The hyper-parameter name used in the tuning job
      that stands for learning rate. Leave it blank if learning rate is not in
      a parameter in tuning. The learning_rate is used to estimate the
      objective value of the ongoing trial.
    maxStepCount: Steps used in predicting the final objective for early
      stopped trials. In general, it's set to be the same as the defined steps
      in training / tuning. If not defined, it will learn it from the
      completed trials. When use_steps is false, this field is set to the
      maximum elapsed seconds.
    minMeasurementCount: The minimal number of measurements in a Trial. Early-
      stopping checks will not trigger if less than min_measurement_count+1
      completed trials or pending trials with less than min_measurement_count
      measurements. If not defined, the default value is 5.
    minStepCount: Minimum number of steps for a trial to complete. Trials
      which do not have a measurement with step_count > min_step_count won't
      be considered for early stopping. It's ok to set it to 0, and a trial
      can be early stopped at any stage. By default, min_step_count is set to
      be one-tenth of the max_step_count. When use_elapsed_duration is true,
      this field is set to the minimum elapsed seconds.
    updateAllStoppedTrials: ConvexAutomatedStoppingSpec by default only
      updates the trials that needs to be early stopped using a newly trained
      auto-regressive model. When this flag is set to True, all stopped trials
      from the beginning are potentially updated in terms of their
      `final_measurement`. Also, note that the training logic of
      autoregressive models is different in this case. Enabling this option
      has shown better results and this may be the default option in the
      future.
    useElapsedDuration: This bool determines whether or not the rule is
      applied based on elapsed_secs or steps. If use_elapsed_duration==false,
      the early stopping decision is made according to the predicted objective
      values according to the target steps. If use_elapsed_duration==true,
      elapsed_secs is used instead of steps. Also, in this case, the
      parameters max_num_steps and min_num_steps are overloaded to contain
      max_elapsed_seconds and min_elapsed_seconds.
  """

  learningRateParameterName = _messages.StringField(1)
  maxStepCount = _messages.IntegerField(2)
  minMeasurementCount = _messages.IntegerField(3)
  minStepCount = _messages.IntegerField(4)
  updateAllStoppedTrials = _messages.BooleanField(5)
  useElapsedDuration = _messages.BooleanField(6)


class GoogleCloudAiplatformV1StudySpecDecayCurveAutomatedStoppingSpec(_messages.Message):
  r"""The decay curve automated stopping rule builds a Gaussian Process
  Regressor to predict the final objective value of a Trial based on the
  already completed Trials and the intermediate measurements of the current
  Trial. Early stopping is requested for the current Trial if there is very
  low probability to exceed the optimal value found so far.

  Fields:
    useElapsedDuration: True if Measurement.elapsed_duration is used as the
      x-axis of each Trials Decay Curve. Otherwise, Measurement.step_count
      will be used as the x-axis.
  """

  useElapsedDuration = _messages.BooleanField(1)


class GoogleCloudAiplatformV1StudySpecMedianAutomatedStoppingSpec(_messages.Message):
  r"""The median automated stopping rule stops a pending Trial if the Trial's
  best objective_value is strictly below the median 'performance' of all
  completed Trials reported up to the Trial's last measurement. Currently,
  'performance' refers to the running average of the objective values reported
  by the Trial in each measurement.

  Fields:
    useElapsedDuration: True if median automated stopping rule applies on
      Measurement.elapsed_duration. It means that elapsed_duration field of
      latest measurement of current Trial is used to compute median objective
      value for each completed Trials.
  """

  useElapsedDuration = _messages.BooleanField(1)


class GoogleCloudAiplatformV1StudySpecMetricSpec(_messages.Message):
  r"""Represents a metric to optimize.

  Enums:
    GoalValueValuesEnum: Required. The optimization goal of the metric.

  Fields:
    goal: Required. The optimization goal of the metric.
    metricId: Required. The ID of the metric. Must not contain whitespaces and
      must be unique amongst all MetricSpecs.
    safetyConfig: Used for safe search. In the case, the metric will be a
      safety metric. You must provide a separate metric for objective metric.
  """

  class GoalValueValuesEnum(_messages.Enum):
    r"""Required. The optimization goal of the metric.

    Values:
      GOAL_TYPE_UNSPECIFIED: Goal Type will default to maximize.
      MAXIMIZE: Maximize the goal metric.
      MINIMIZE: Minimize the goal metric.
    """
    GOAL_TYPE_UNSPECIFIED = 0
    MAXIMIZE = 1
    MINIMIZE = 2

  goal = _messages.EnumField('GoalValueValuesEnum', 1)
  metricId = _messages.StringField(2)
  safetyConfig = _messages.MessageField('GoogleCloudAiplatformV1StudySpecMetricSpecSafetyMetricConfig', 3)


class GoogleCloudAiplatformV1StudySpecMetricSpecSafetyMetricConfig(_messages.Message):
  r"""Used in safe optimization to specify threshold levels and risk
  tolerance.

  Fields:
    desiredMinSafeTrialsFraction: Desired minimum fraction of safe trials
      (over total number of trials) that should be targeted by the algorithm
      at any time during the study (best effort). This should be between 0.0
      and 1.0 and a value of 0.0 means that there is no minimum and an
      algorithm proceeds without targeting any specific fraction. A value of
      1.0 means that the algorithm attempts to only Suggest safe Trials.
    safetyThreshold: Safety threshold (boundary value between safe and
      unsafe). NOTE that if you leave SafetyMetricConfig unset, a default
      value of 0 will be used.
  """

  desiredMinSafeTrialsFraction = _messages.FloatField(1)
  safetyThreshold = _messages.FloatField(2)


class GoogleCloudAiplatformV1StudySpecParameterSpec(_messages.Message):
  r"""Represents a single parameter to optimize.

  Enums:
    ScaleTypeValueValuesEnum: How the parameter should be scaled. Leave unset
      for `CATEGORICAL` parameters.

  Fields:
    categoricalValueSpec: The value spec for a 'CATEGORICAL' parameter.
    conditionalParameterSpecs: A conditional parameter node is active if the
      parameter's value matches the conditional node's parent_value_condition.
      If two items in conditional_parameter_specs have the same name, they
      must have disjoint parent_value_condition.
    discreteValueSpec: The value spec for a 'DISCRETE' parameter.
    doubleValueSpec: The value spec for a 'DOUBLE' parameter.
    integerValueSpec: The value spec for an 'INTEGER' parameter.
    parameterId: Required. The ID of the parameter. Must not contain
      whitespaces and must be unique amongst all ParameterSpecs.
    scaleType: How the parameter should be scaled. Leave unset for
      `CATEGORICAL` parameters.
  """

  class ScaleTypeValueValuesEnum(_messages.Enum):
    r"""How the parameter should be scaled. Leave unset for `CATEGORICAL`
    parameters.

    Values:
      SCALE_TYPE_UNSPECIFIED: By default, no scaling is applied.
      UNIT_LINEAR_SCALE: Scales the feasible space to (0, 1) linearly.
      UNIT_LOG_SCALE: Scales the feasible space logarithmically to (0, 1). The
        entire feasible space must be strictly positive.
      UNIT_REVERSE_LOG_SCALE: Scales the feasible space "reverse"
        logarithmically to (0, 1). The result is that values close to the top
        of the feasible space are spread out more than points near the bottom.
        The entire feasible space must be strictly positive.
    """
    SCALE_TYPE_UNSPECIFIED = 0
    UNIT_LINEAR_SCALE = 1
    UNIT_LOG_SCALE = 2
    UNIT_REVERSE_LOG_SCALE = 3

  categoricalValueSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecCategoricalValueSpec', 1)
  conditionalParameterSpecs = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpec', 2, repeated=True)
  discreteValueSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecDiscreteValueSpec', 3)
  doubleValueSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecDoubleValueSpec', 4)
  integerValueSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecIntegerValueSpec', 5)
  parameterId = _messages.StringField(6)
  scaleType = _messages.EnumField('ScaleTypeValueValuesEnum', 7)


class GoogleCloudAiplatformV1StudySpecParameterSpecCategoricalValueSpec(_messages.Message):
  r"""Value specification for a parameter in `CATEGORICAL` type.

  Fields:
    defaultValue: A default value for a `CATEGORICAL` parameter that is
      assumed to be a relatively good starting point. Unset value signals that
      there is no offered starting point. Currently only supported by the
      Vertex AI Vizier service. Not supported by HyperparameterTuningJob or
      TrainingPipeline.
    values: Required. The list of possible categories.
  """

  defaultValue = _messages.StringField(1)
  values = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpec(_messages.Message):
  r"""Represents a parameter spec with condition from its parent parameter.

  Fields:
    parameterSpec: Required. The spec for a conditional parameter.
    parentCategoricalValues: The spec for matching values from a parent
      parameter of `CATEGORICAL` type.
    parentDiscreteValues: The spec for matching values from a parent parameter
      of `DISCRETE` type.
    parentIntValues: The spec for matching values from a parent parameter of
      `INTEGER` type.
  """

  parameterSpec = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpec', 1)
  parentCategoricalValues = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecCategoricalValueCondition', 2)
  parentDiscreteValues = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecDiscreteValueCondition', 3)
  parentIntValues = _messages.MessageField('GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecIntValueCondition', 4)


class GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecCategoricalValueCondition(_messages.Message):
  r"""Represents the spec to match categorical values from parent parameter.

  Fields:
    values: Required. Matches values of the parent parameter of 'CATEGORICAL'
      type. All values must exist in `categorical_value_spec` of parent
      parameter.
  """

  values = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecDiscreteValueCondition(_messages.Message):
  r"""Represents the spec to match discrete values from parent parameter.

  Fields:
    values: Required. Matches values of the parent parameter of 'DISCRETE'
      type. All values must exist in `discrete_value_spec` of parent
      parameter. The Epsilon of the value matching is 1e-10.
  """

  values = _messages.FloatField(1, repeated=True)


class GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecIntValueCondition(_messages.Message):
  r"""Represents the spec to match integer values from parent parameter.

  Fields:
    values: Required. Matches values of the parent parameter of 'INTEGER'
      type. All values must lie in `integer_value_spec` of parent parameter.
  """

  values = _messages.IntegerField(1, repeated=True)


class GoogleCloudAiplatformV1StudySpecParameterSpecDiscreteValueSpec(_messages.Message):
  r"""Value specification for a parameter in `DISCRETE` type.

  Fields:
    defaultValue: A default value for a `DISCRETE` parameter that is assumed
      to be a relatively good starting point. Unset value signals that there
      is no offered starting point. It automatically rounds to the nearest
      feasible discrete point. Currently only supported by the Vertex AI
      Vizier service. Not supported by HyperparameterTuningJob or
      TrainingPipeline.
    values: Required. A list of possible values. The list should be in
      increasing order and at least 1e-10 apart. For instance, this parameter
      might have possible settings of 1.5, 2.5, and 4.0. This list should not
      contain more than 1,000 values.
  """

  defaultValue = _messages.FloatField(1)
  values = _messages.FloatField(2, repeated=True)


class GoogleCloudAiplatformV1StudySpecParameterSpecDoubleValueSpec(_messages.Message):
  r"""Value specification for a parameter in `DOUBLE` type.

  Fields:
    defaultValue: A default value for a `DOUBLE` parameter that is assumed to
      be a relatively good starting point. Unset value signals that there is
      no offered starting point. Currently only supported by the Vertex AI
      Vizier service. Not supported by HyperparameterTuningJob or
      TrainingPipeline.
    maxValue: Required. Inclusive maximum value of the parameter.
    minValue: Required. Inclusive minimum value of the parameter.
  """

  defaultValue = _messages.FloatField(1)
  maxValue = _messages.FloatField(2)
  minValue = _messages.FloatField(3)


class GoogleCloudAiplatformV1StudySpecParameterSpecIntegerValueSpec(_messages.Message):
  r"""Value specification for a parameter in `INTEGER` type.

  Fields:
    defaultValue: A default value for an `INTEGER` parameter that is assumed
      to be a relatively good starting point. Unset value signals that there
      is no offered starting point. Currently only supported by the Vertex AI
      Vizier service. Not supported by HyperparameterTuningJob or
      TrainingPipeline.
    maxValue: Required. Inclusive maximum value of the parameter.
    minValue: Required. Inclusive minimum value of the parameter.
  """

  defaultValue = _messages.IntegerField(1)
  maxValue = _messages.IntegerField(2)
  minValue = _messages.IntegerField(3)


class GoogleCloudAiplatformV1SuggestTrialsMetadata(_messages.Message):
  r"""Details of operations that perform Trials suggestion.

  Fields:
    clientId: The identifier of the client that is requesting the suggestion.
      If multiple SuggestTrialsRequests have the same `client_id`, the service
      will return the identical suggested Trial if the Trial is pending, and
      provide a new Trial if the last suggested Trial was completed.
    genericMetadata: Operation metadata for suggesting Trials.
  """

  clientId = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1SuggestTrialsRequest(_messages.Message):
  r"""Request message for VizierService.SuggestTrials.

  Fields:
    clientId: Required. The identifier of the client that is requesting the
      suggestion. If multiple SuggestTrialsRequests have the same `client_id`,
      the service will return the identical suggested Trial if the Trial is
      pending, and provide a new Trial if the last suggested Trial was
      completed.
    contexts: Optional. This allows you to specify the "context" for a Trial;
      a context is a slice (a subspace) of the search space. Typical uses for
      contexts: 1) You are using Vizier to tune a server for best performance,
      but there's a strong weekly cycle. The context specifies the day-of-
      week. This allows Tuesday to generalize from Wednesday without assuming
      that everything is identical. 2) Imagine you're optimizing some medical
      treatment for people. As they walk in the door, you know certain facts
      about them (e.g. sex, weight, height, blood-pressure). Put that
      information in the context, and Vizier will adapt its suggestions to the
      patient. 3) You want to do a fair A/B test efficiently. Specify the "A"
      and "B" conditions as contexts, and Vizier will generalize between "A"
      and "B" conditions. If they are similar, this will allow Vizier to
      converge to the optimum faster than if "A" and "B" were separate
      Studies. NOTE: You can also enter contexts as REQUESTED Trials, e.g. via
      the CreateTrial() RPC; that's the asynchronous option where you don't
      need a close association between contexts and suggestions. NOTE: All the
      Parameters you set in a context MUST be defined in the Study. NOTE: You
      must supply 0 or $suggestion_count contexts. If you don't supply any
      contexts, Vizier will make suggestions from the full search space
      specified in the StudySpec; if you supply a full set of context, each
      suggestion will match the corresponding context. NOTE: A Context with no
      features set matches anything, and allows suggestions from the full
      search space. NOTE: Contexts MUST lie within the search space specified
      in the StudySpec. It's an error if they don't. NOTE: Contexts
      preferentially match ACTIVE then REQUESTED trials before new suggestions
      are generated. NOTE: Generation of suggestions involves a match between
      a Context and (optionally) a REQUESTED trial; if that match is not fully
      specified, a suggestion will be geneated in the merged subspace.
    suggestionCount: Required. The number of suggestions requested. It must be
      positive.
  """

  clientId = _messages.StringField(1)
  contexts = _messages.MessageField('GoogleCloudAiplatformV1TrialContext', 2, repeated=True)
  suggestionCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1SuggestTrialsResponse(_messages.Message):
  r"""Response message for VizierService.SuggestTrials.

  Enums:
    StudyStateValueValuesEnum: The state of the Study.

  Fields:
    endTime: The time at which operation processing completed.
    startTime: The time at which the operation was started.
    studyState: The state of the Study.
    trials: A list of Trials.
  """

  class StudyStateValueValuesEnum(_messages.Enum):
    r"""The state of the Study.

    Values:
      STATE_UNSPECIFIED: The study state is unspecified.
      ACTIVE: The study is active.
      INACTIVE: The study is stopped due to an internal error.
      COMPLETED: The study is done when the service exhausts the parameter
        search space or max_trial_count is reached.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2
    COMPLETED = 3

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)
  studyState = _messages.EnumField('StudyStateValueValuesEnum', 3)
  trials = _messages.MessageField('GoogleCloudAiplatformV1Trial', 4, repeated=True)


class GoogleCloudAiplatformV1TFRecordDestination(_messages.Message):
  r"""The storage details for TFRecord output content.

  Fields:
    gcsDestination: Required. Google Cloud Storage location.
  """

  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1GcsDestination', 1)


class GoogleCloudAiplatformV1Tensorboard(_messages.Message):
  r"""Tensorboard is a physical database that stores users' training metrics.
  A default Tensorboard is provided in each region of a Google Cloud project.
  If needed users can also create extra Tensorboards in their projects.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Tensorboards. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Tensorboard (System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    blobStoragePathPrefix: Output only. Consumer project Cloud Storage path
      prefix used to store blob data, which can either be a bucket or
      directory. Does not end with a '/'.
    createTime: Output only. Timestamp when this Tensorboard was created.
    description: Description of this Tensorboard.
    displayName: Required. User provided name of this Tensorboard.
    encryptionSpec: Customer-managed encryption key spec for a Tensorboard. If
      set, this Tensorboard and all sub-resources of this Tensorboard will be
      secured by this key.
    etag: Used to perform a consistent read-modify-write updates. If not set,
      a blind "overwrite" update happens.
    isDefault: Used to indicate if the TensorBoard instance is the default
      one. Each project & region can have at most one default TensorBoard
      instance. Creation of a default TensorBoard instance and updating an
      existing TensorBoard instance to be default will mark all other
      TensorBoard instances (if any) as non default.
    labels: The labels with user-defined metadata to organize your
      Tensorboards. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Tensorboard (System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Output only. Name of the Tensorboard. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    runCount: Output only. The number of Runs stored in this Tensorboard.
    updateTime: Output only. Timestamp when this Tensorboard was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Tensorboards.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. No more than
    64 user labels can be associated with one Tensorboard (System labels are
    excluded). See https://goo.gl/xmQnxf for more information and examples of
    labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  blobStoragePathPrefix = _messages.StringField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 5)
  etag = _messages.StringField(6)
  isDefault = _messages.BooleanField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  runCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  updateTime = _messages.StringField(11)


class GoogleCloudAiplatformV1TensorboardBlob(_messages.Message):
  r"""One blob (e.g, image, graph) viewable on a blob metric plot.

  Fields:
    data: Optional. The bytes of the blob is not present unless it's returned
      by the ReadTensorboardBlobData endpoint.
    id: Output only. A URI safe key uniquely identifying a blob. Can be used
      to locate the blob stored in the Cloud Storage bucket of the consumer
      project.
  """

  data = _messages.BytesField(1)
  id = _messages.StringField(2)


class GoogleCloudAiplatformV1TensorboardBlobSequence(_messages.Message):
  r"""One point viewable on a blob metric plot, but mostly just a wrapper
  message to work around repeated fields can't be used directly within `oneof`
  fields.

  Fields:
    values: List of blobs contained within the sequence.
  """

  values = _messages.MessageField('GoogleCloudAiplatformV1TensorboardBlob', 1, repeated=True)


class GoogleCloudAiplatformV1TensorboardExperiment(_messages.Message):
  r"""A TensorboardExperiment is a group of TensorboardRuns, that are
  typically the results of a training job run, in a Tensorboard.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      TensorboardExperiment. Label keys and values cannot be longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Dataset
      (System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with `aiplatform.googleapis.com/` and are immutable. The
      following system labels exist for each Dataset: *
      `aiplatform.googleapis.com/dataset_metadata_schema`: output only. Its
      value is the metadata_schema's title.

  Fields:
    createTime: Output only. Timestamp when this TensorboardExperiment was
      created.
    description: Description of this TensorboardExperiment.
    displayName: User provided name of this TensorboardExperiment.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your
      TensorboardExperiment. Label keys and values cannot be longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Dataset
      (System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with `aiplatform.googleapis.com/` and are immutable. The
      following system labels exist for each Dataset: *
      `aiplatform.googleapis.com/dataset_metadata_schema`: output only. Its
      value is the metadata_schema's title.
    name: Output only. Name of the TensorboardExperiment. Format: `projects/{p
      roject}/locations/{location}/tensorboards/{tensorboard}/experiments/{exp
      eriment}`
    source: Immutable. Source of the TensorboardExperiment. Example: a custom
      training job.
    updateTime: Output only. Timestamp when this TensorboardExperiment was
      last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your
    TensorboardExperiment. Label keys and values cannot be longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. No more than 64 user labels can be associated with one Dataset
    (System labels are excluded). See https://goo.gl/xmQnxf for more
    information and examples of labels. System reserved label keys are
    prefixed with `aiplatform.googleapis.com/` and are immutable. The
    following system labels exist for each Dataset: *
    `aiplatform.googleapis.com/dataset_metadata_schema`: output only. Its
    value is the metadata_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  source = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1TensorboardRun(_messages.Message):
  r"""TensorboardRun maps to a specific execution of a training job with a
  given set of hyperparameter values, model definition, dataset, etc

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      TensorboardRuns. This field will be used to filter and visualize Runs in
      the Tensorboard UI. For example, a Vertex AI training job can set a
      label aiplatform.googleapis.com/training_job_id=xxxxx to all the runs
      created within that job. An end user can set a label experiment_id=xxxxx
      for all the runs produced in a Jupyter notebook. These runs can be
      grouped by a label value and visualized together in the Tensorboard UI.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one TensorboardRun (System
      labels are excluded). See https://goo.gl/xmQnxf for more information and
      examples of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this TensorboardRun was created.
    description: Description of this TensorboardRun.
    displayName: Required. User provided name of this TensorboardRun. This
      value must be unique among all TensorboardRuns belonging to the same
      parent TensorboardExperiment.
    etag: Used to perform a consistent read-modify-write updates. If not set,
      a blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your
      TensorboardRuns. This field will be used to filter and visualize Runs in
      the Tensorboard UI. For example, a Vertex AI training job can set a
      label aiplatform.googleapis.com/training_job_id=xxxxx to all the runs
      created within that job. An end user can set a label experiment_id=xxxxx
      for all the runs produced in a Jupyter notebook. These runs can be
      grouped by a label value and visualized together in the Tensorboard UI.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one TensorboardRun (System
      labels are excluded). See https://goo.gl/xmQnxf for more information and
      examples of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    name: Output only. Name of the TensorboardRun. Format: `projects/{project}
      /locations/{location}/tensorboards/{tensorboard}/experiments/{experiment
      }/runs/{run}`
    updateTime: Output only. Timestamp when this TensorboardRun was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your
    TensorboardRuns. This field will be used to filter and visualize Runs in
    the Tensorboard UI. For example, a Vertex AI training job can set a label
    aiplatform.googleapis.com/training_job_id=xxxxx to all the runs created
    within that job. An end user can set a label experiment_id=xxxxx for all
    the runs produced in a Jupyter notebook. These runs can be grouped by a
    label value and visualized together in the Tensorboard UI. Label keys and
    values can be no longer than 64 characters (Unicode codepoints), can only
    contain lowercase letters, numeric characters, underscores and dashes.
    International characters are allowed. No more than 64 user labels can be
    associated with one TensorboardRun (System labels are excluded). See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class GoogleCloudAiplatformV1TensorboardTensor(_messages.Message):
  r"""One point viewable on a tensor metric plot.

  Fields:
    value: Required. Serialized form of https://github.com/tensorflow/tensorfl
      ow/blob/master/tensorflow/core/framework/tensor.proto
    versionNumber: Optional. Version number of TensorProto used to serialize
      value.
  """

  value = _messages.BytesField(1)
  versionNumber = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1TensorboardTimeSeries(_messages.Message):
  r"""TensorboardTimeSeries maps to times series produced in training runs

  Enums:
    ValueTypeValueValuesEnum: Required. Immutable. Type of
      TensorboardTimeSeries value.

  Fields:
    createTime: Output only. Timestamp when this TensorboardTimeSeries was
      created.
    description: Description of this TensorboardTimeSeries.
    displayName: Required. User provided name of this TensorboardTimeSeries.
      This value should be unique among all TensorboardTimeSeries resources
      belonging to the same TensorboardRun resource (parent resource).
    etag: Used to perform a consistent read-modify-write updates. If not set,
      a blind "overwrite" update happens.
    metadata: Output only. Scalar, Tensor, or Blob metadata for this
      TensorboardTimeSeries.
    name: Output only. Name of the TensorboardTimeSeries.
    pluginData: Data of the current plugin, with the size limited to 65KB.
    pluginName: Immutable. Name of the plugin this time series pertain to.
      Such as Scalar, Tensor, Blob
    updateTime: Output only. Timestamp when this TensorboardTimeSeries was
      last updated.
    valueType: Required. Immutable. Type of TensorboardTimeSeries value.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. Type of TensorboardTimeSeries value.

    Values:
      VALUE_TYPE_UNSPECIFIED: The value type is unspecified.
      SCALAR: Used for TensorboardTimeSeries that is a list of scalars. E.g.
        accuracy of a model over epochs/time.
      TENSOR: Used for TensorboardTimeSeries that is a list of tensors. E.g.
        histograms of weights of layer in a model over epoch/time.
      BLOB_SEQUENCE: Used for TensorboardTimeSeries that is a list of blob
        sequences. E.g. set of sample images with labels over epochs/time.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    SCALAR = 1
    TENSOR = 2
    BLOB_SEQUENCE = 3

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1TensorboardTimeSeriesMetadata', 5)
  name = _messages.StringField(6)
  pluginData = _messages.BytesField(7)
  pluginName = _messages.StringField(8)
  updateTime = _messages.StringField(9)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 10)


class GoogleCloudAiplatformV1TensorboardTimeSeriesMetadata(_messages.Message):
  r"""Describes metadata for a TensorboardTimeSeries.

  Fields:
    maxBlobSequenceLength: Output only. The largest blob sequence length
      (number of blobs) of all data points in this time series, if its
      ValueType is BLOB_SEQUENCE.
    maxStep: Output only. Max step index of all data points within a
      TensorboardTimeSeries.
    maxWallTime: Output only. Max wall clock timestamp of all data points
      within a TensorboardTimeSeries.
  """

  maxBlobSequenceLength = _messages.IntegerField(1)
  maxStep = _messages.IntegerField(2)
  maxWallTime = _messages.StringField(3)


class GoogleCloudAiplatformV1ThresholdConfig(_messages.Message):
  r"""The config for feature monitoring threshold.

  Fields:
    value: Specify a threshold value that can trigger the alert. If this
      threshold config is for feature distribution distance: 1. For
      categorical feature, the distribution distance is calculated by
      L-inifinity norm. 2. For numerical feature, the distribution distance is
      calculated by Jensen\u2013Shannon divergence. Each feature must have a
      non-zero threshold if they need to be monitored. Otherwise no alert will
      be triggered for that feature.
  """

  value = _messages.FloatField(1)


class GoogleCloudAiplatformV1TimeSeriesData(_messages.Message):
  r"""All the data stored in a TensorboardTimeSeries.

  Enums:
    ValueTypeValueValuesEnum: Required. Immutable. The value type of this time
      series. All the values in this time series data must match this value
      type.

  Fields:
    tensorboardTimeSeriesId: Required. The ID of the TensorboardTimeSeries,
      which will become the final component of the TensorboardTimeSeries'
      resource name
    valueType: Required. Immutable. The value type of this time series. All
      the values in this time series data must match this value type.
    values: Required. Data points in this time series.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The value type of this time series. All the
    values in this time series data must match this value type.

    Values:
      VALUE_TYPE_UNSPECIFIED: The value type is unspecified.
      SCALAR: Used for TensorboardTimeSeries that is a list of scalars. E.g.
        accuracy of a model over epochs/time.
      TENSOR: Used for TensorboardTimeSeries that is a list of tensors. E.g.
        histograms of weights of layer in a model over epoch/time.
      BLOB_SEQUENCE: Used for TensorboardTimeSeries that is a list of blob
        sequences. E.g. set of sample images with labels over epochs/time.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    SCALAR = 1
    TENSOR = 2
    BLOB_SEQUENCE = 3

  tensorboardTimeSeriesId = _messages.StringField(1)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 2)
  values = _messages.MessageField('GoogleCloudAiplatformV1TimeSeriesDataPoint', 3, repeated=True)


class GoogleCloudAiplatformV1TimeSeriesDataPoint(_messages.Message):
  r"""A TensorboardTimeSeries data point.

  Fields:
    blobs: A blob sequence value.
    scalar: A scalar value.
    step: Step index of this data point within the run.
    tensor: A tensor value.
    wallTime: Wall clock timestamp when this data point is generated by the
      end user.
  """

  blobs = _messages.MessageField('GoogleCloudAiplatformV1TensorboardBlobSequence', 1)
  scalar = _messages.MessageField('GoogleCloudAiplatformV1Scalar', 2)
  step = _messages.IntegerField(3)
  tensor = _messages.MessageField('GoogleCloudAiplatformV1TensorboardTensor', 4)
  wallTime = _messages.StringField(5)


class GoogleCloudAiplatformV1TimestampSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on a
  provided timestamps. The youngest data pieces are assigned to training set,
  next to validation set, and the oldest to the test set. Supported only for
  tabular Datasets.

  Fields:
    key: Required. The key is a name of one of the Dataset's data columns. The
      values of the key (the values in the column) must be in RFC 3339 `date-
      time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z). If for a piece of data the key is not present
      or has an invalid value, that piece is ignored by the pipeline.
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  key = _messages.StringField(1)
  testFraction = _messages.FloatField(2)
  trainingFraction = _messages.FloatField(3)
  validationFraction = _messages.FloatField(4)


class GoogleCloudAiplatformV1TrainingConfig(_messages.Message):
  r"""CMLE training config. For every active learning labeling iteration,
  system will train a machine learning model on CMLE. The trained model will
  be used by data sampling algorithm to select DataItems.

  Fields:
    timeoutTrainingMilliHours: The timeout hours for the CMLE training job,
      expressed in milli hours i.e. 1,000 value in this field means 1 hour.
  """

  timeoutTrainingMilliHours = _messages.IntegerField(1)


class GoogleCloudAiplatformV1TrainingPipeline(_messages.Message):
  r"""The TrainingPipeline orchestrates tasks associated with training a
  Model. It always executes the training task, and optionally may also export
  data from Vertex AI's Dataset which becomes the training input, upload the
  Model to Vertex AI, and evaluate the Model.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the pipeline.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      TrainingPipelines. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Time when the TrainingPipeline was created.
    displayName: Required. The user-defined name of this TrainingPipeline.
    encryptionSpec: Customer-managed encryption key spec for a
      TrainingPipeline. If set, this TrainingPipeline will be secured by this
      key. Note: Model trained by this TrainingPipeline is also secured by
      this key if model_to_upload is not set separately.
    endTime: Output only. Time when the TrainingPipeline entered any of the
      following states: `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
      `PIPELINE_STATE_CANCELLED`.
    error: Output only. Only populated when the pipeline's state is
      `PIPELINE_STATE_FAILED` or `PIPELINE_STATE_CANCELLED`.
    inputDataConfig: Specifies Vertex AI owned input data that may be used for
      training the Model. The TrainingPipeline's training_task_definition
      should make clear whether this config is used and if there are any
      special requirements on how it should be filled. If nothing about this
      config is mentioned in the training_task_definition, then it should be
      assumed that the TrainingPipeline does not depend on this configuration.
    labels: The labels with user-defined metadata to organize
      TrainingPipelines. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    modelId: Optional. The ID to use for the uploaded Model, which will become
      the final component of the model resource name. This value may be up to
      63 characters, and valid characters are `[a-z0-9_-]`. The first
      character cannot be a number or hyphen.
    modelToUpload: Describes the Model that may be uploaded (via
      ModelService.UploadModel) by this TrainingPipeline. The
      TrainingPipeline's training_task_definition should make clear whether
      this Model description should be populated, and if there are any special
      requirements regarding how it should be filled. If nothing is mentioned
      in the training_task_definition, then it should be assumed that this
      field should not be filled and the training task either uploads the
      Model without a need of this information, or that training task does not
      support uploading a Model as part of the pipeline. When the Pipeline's
      state becomes `PIPELINE_STATE_SUCCEEDED` and the trained Model had been
      uploaded into Vertex AI, then the model_to_upload's resource name is
      populated. The Model is always uploaded into the Project and Location in
      which this pipeline is.
    name: Output only. Resource name of the TrainingPipeline.
    parentModel: Optional. When specify this field, the `model_to_upload` will
      not be uploaded as a new model, instead, it will become a new version of
      this `parent_model`.
    startTime: Output only. Time when the TrainingPipeline for the first time
      entered the `PIPELINE_STATE_RUNNING` state.
    state: Output only. The detailed state of the pipeline.
    trainingTaskDefinition: Required. A Google Cloud Storage path to the YAML
      file that defines the training task which is responsible for producing
      the model artifact, and may also include additional auxiliary work. The
      definition files that can be used here are found in gs://google-cloud-
      aiplatform/schema/trainingjob/definition/. Note: The URI given on output
      will be immutable and probably different, including the URI scheme, than
      the one given on input. The output URI will point to a location where
      the user only has a read access.
    trainingTaskInputs: Required. The training task's parameter(s), as
      specified in the training_task_definition's `inputs`.
    trainingTaskMetadata: Output only. The metadata information as specified
      in the training_task_definition's `metadata`. This metadata is an
      auxiliary runtime and final information about the training task. While
      the pipeline is running this information is populated only at a best
      effort basis. Only present if the pipeline's training_task_definition
      contains `metadata` object.
    updateTime: Output only. Time when the TrainingPipeline was most recently
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the pipeline.

    Values:
      PIPELINE_STATE_UNSPECIFIED: The pipeline state is unspecified.
      PIPELINE_STATE_QUEUED: The pipeline has been created or resumed, and
        processing has not yet begun.
      PIPELINE_STATE_PENDING: The service is preparing to run the pipeline.
      PIPELINE_STATE_RUNNING: The pipeline is in progress.
      PIPELINE_STATE_SUCCEEDED: The pipeline completed successfully.
      PIPELINE_STATE_FAILED: The pipeline failed.
      PIPELINE_STATE_CANCELLING: The pipeline is being cancelled. From this
        state, the pipeline may only go to either PIPELINE_STATE_SUCCEEDED,
        PIPELINE_STATE_FAILED or PIPELINE_STATE_CANCELLED.
      PIPELINE_STATE_CANCELLED: The pipeline has been cancelled.
      PIPELINE_STATE_PAUSED: The pipeline has been stopped, and can be
        resumed.
    """
    PIPELINE_STATE_UNSPECIFIED = 0
    PIPELINE_STATE_QUEUED = 1
    PIPELINE_STATE_PENDING = 2
    PIPELINE_STATE_RUNNING = 3
    PIPELINE_STATE_SUCCEEDED = 4
    PIPELINE_STATE_FAILED = 5
    PIPELINE_STATE_CANCELLING = 6
    PIPELINE_STATE_CANCELLED = 7
    PIPELINE_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize TrainingPipelines.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  inputDataConfig = _messages.MessageField('GoogleCloudAiplatformV1InputDataConfig', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  modelId = _messages.StringField(8)
  modelToUpload = _messages.MessageField('GoogleCloudAiplatformV1Model', 9)
  name = _messages.StringField(10)
  parentModel = _messages.StringField(11)
  startTime = _messages.StringField(12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  trainingTaskDefinition = _messages.StringField(14)
  trainingTaskInputs = _messages.MessageField('extra_types.JsonValue', 15)
  trainingTaskMetadata = _messages.MessageField('extra_types.JsonValue', 16)
  updateTime = _messages.StringField(17)


class GoogleCloudAiplatformV1Trial(_messages.Message):
  r"""A message representing a Trial. A Trial contains a unique set of
  Parameters that has been or will be evaluated, along with the objective
  metrics got by running the Trial.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the Trial.

  Messages:
    WebAccessUrisValue: Output only. URIs for accessing [interactive
      shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
      interactive-shell) (one URI for each training node). Only available if
      this trial is part of a HyperparameterTuningJob and the job's
      trial_job_spec.enable_web_access field is `true`. The keys are names of
      each node used for the trial; for example, `workerpool0-0` for the
      primary node, `workerpool1-0` for the first node in the second worker
      pool, and `workerpool1-1` for the second node in the second worker pool.
      The values are the URIs for each node's interactive shell.

  Fields:
    clientId: Output only. The identifier of the client that originally
      requested this Trial. Each client is identified by a unique client_id.
      When a client asks for a suggestion, Vertex AI Vizier will assign it a
      Trial. The client should evaluate the Trial, complete it, and report
      back to Vertex AI Vizier. If suggestion is asked again by same client_id
      before the Trial is completed, the same Trial will be returned. Multiple
      clients with different client_ids can ask for suggestions
      simultaneously, each of them will get their own Trial.
    customJob: Output only. The CustomJob name linked to the Trial. It's set
      for a HyperparameterTuningJob's Trial.
    endTime: Output only. Time when the Trial's status changed to `SUCCEEDED`
      or `INFEASIBLE`.
    finalMeasurement: Output only. The final measurement containing the
      objective value.
    id: Output only. The identifier of the Trial assigned by the service.
    infeasibleReason: Output only. A human readable string describing why the
      Trial is infeasible. This is set only if Trial state is `INFEASIBLE`.
    measurements: Output only. A list of measurements that are strictly
      lexicographically ordered by their induced tuples (steps,
      elapsed_duration). These are used for early stopping computations.
    name: Output only. Resource name of the Trial assigned by the service.
    parameters: Output only. The parameters of the Trial.
    startTime: Output only. Time when the Trial was started.
    state: Output only. The detailed state of the Trial.
    webAccessUris: Output only. URIs for accessing [interactive
      shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
      interactive-shell) (one URI for each training node). Only available if
      this trial is part of a HyperparameterTuningJob and the job's
      trial_job_spec.enable_web_access field is `true`. The keys are names of
      each node used for the trial; for example, `workerpool0-0` for the
      primary node, `workerpool1-0` for the first node in the second worker
      pool, and `workerpool1-1` for the second node in the second worker pool.
      The values are the URIs for each node's interactive shell.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the Trial.

    Values:
      STATE_UNSPECIFIED: The Trial state is unspecified.
      REQUESTED: Indicates that a specific Trial has been requested, but it
        has not yet been suggested by the service.
      ACTIVE: Indicates that the Trial has been suggested.
      STOPPING: Indicates that the Trial should stop according to the service.
      SUCCEEDED: Indicates that the Trial is completed successfully.
      INFEASIBLE: Indicates that the Trial should not be attempted again. The
        service will set a Trial to INFEASIBLE when it's done but missing the
        final_measurement.
    """
    STATE_UNSPECIFIED = 0
    REQUESTED = 1
    ACTIVE = 2
    STOPPING = 3
    SUCCEEDED = 4
    INFEASIBLE = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class WebAccessUrisValue(_messages.Message):
    r"""Output only. URIs for accessing [interactive
    shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
    interactive-shell) (one URI for each training node). Only available if
    this trial is part of a HyperparameterTuningJob and the job's
    trial_job_spec.enable_web_access field is `true`. The keys are names of
    each node used for the trial; for example, `workerpool0-0` for the primary
    node, `workerpool1-0` for the first node in the second worker pool, and
    `workerpool1-1` for the second node in the second worker pool. The values
    are the URIs for each node's interactive shell.

    Messages:
      AdditionalProperty: An additional property for a WebAccessUrisValue
        object.

    Fields:
      additionalProperties: Additional properties of type WebAccessUrisValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a WebAccessUrisValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clientId = _messages.StringField(1)
  customJob = _messages.StringField(2)
  endTime = _messages.StringField(3)
  finalMeasurement = _messages.MessageField('GoogleCloudAiplatformV1Measurement', 4)
  id = _messages.StringField(5)
  infeasibleReason = _messages.StringField(6)
  measurements = _messages.MessageField('GoogleCloudAiplatformV1Measurement', 7, repeated=True)
  name = _messages.StringField(8)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1TrialParameter', 9, repeated=True)
  startTime = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  webAccessUris = _messages.MessageField('WebAccessUrisValue', 12)


class GoogleCloudAiplatformV1TrialContext(_messages.Message):
  r"""Next ID: 3

  Fields:
    description: A human-readable field which can store a description of this
      context. This will become part of the resulting Trial's description
      field.
    parameters: If/when a Trial is generated or selected from this Context,
      its Parameters will match any parameters specified here. (I.e. if this
      context specifies parameter name:'a' int_value:3, then a resulting Trial
      will have int_value:3 for its parameter named 'a'.) Note that we first
      attempt to match existing REQUESTED Trials with contexts, and if there
      are no matches, we generate suggestions in the subspace defined by the
      parameters specified here. NOTE: a Context without any Parameters
      matches the entire feasible search space.
  """

  description = _messages.StringField(1)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1TrialParameter', 2, repeated=True)


class GoogleCloudAiplatformV1TrialParameter(_messages.Message):
  r"""A message representing a parameter to be tuned.

  Fields:
    parameterId: Output only. The ID of the parameter. The parameter should be
      defined in StudySpec's Parameters.
    value: Output only. The value of the parameter. `number_value` will be set
      if a parameter defined in StudySpec is in type 'INTEGER', 'DOUBLE' or
      'DISCRETE'. `string_value` will be set if a parameter defined in
      StudySpec is in type 'CATEGORICAL'.
  """

  parameterId = _messages.StringField(1)
  value = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1UndeployIndexOperationMetadata(_messages.Message):
  r"""Runtime operation information for IndexEndpointService.UndeployIndex.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1UndeployIndexRequest(_messages.Message):
  r"""Request message for IndexEndpointService.UndeployIndex.

  Fields:
    deployedIndexId: Required. The ID of the DeployedIndex to be undeployed
      from the IndexEndpoint.
  """

  deployedIndexId = _messages.StringField(1)


class GoogleCloudAiplatformV1UndeployIndexResponse(_messages.Message):
  r"""Response message for IndexEndpointService.UndeployIndex."""


class GoogleCloudAiplatformV1UndeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.UndeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1UndeployModelRequest(_messages.Message):
  r"""Request message for EndpointService.UndeployModel.

  Messages:
    TrafficSplitValue: If this field is provided, then the Endpoint's
      traffic_split will be overwritten with it. If last DeployedModel is
      being undeployed from the Endpoint, the [Endpoint.traffic_split] will
      always end up empty when this call returns. A DeployedModel will be
      successfully undeployed only if it doesn't have any traffic assigned to
      it when this method executes, or if this field unassigns any traffic to
      it.

  Fields:
    deployedModelId: Required. The ID of the DeployedModel to be undeployed
      from the Endpoint.
    trafficSplit: If this field is provided, then the Endpoint's traffic_split
      will be overwritten with it. If last DeployedModel is being undeployed
      from the Endpoint, the [Endpoint.traffic_split] will always end up empty
      when this call returns. A DeployedModel will be successfully undeployed
      only if it doesn't have any traffic assigned to it when this method
      executes, or if this field unassigns any traffic to it.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""If this field is provided, then the Endpoint's traffic_split will be
    overwritten with it. If last DeployedModel is being undeployed from the
    Endpoint, the [Endpoint.traffic_split] will always end up empty when this
    call returns. A DeployedModel will be successfully undeployed only if it
    doesn't have any traffic assigned to it when this method executes, or if
    this field unassigns any traffic to it.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deployedModelId = _messages.StringField(1)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 2)


class GoogleCloudAiplatformV1UndeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.UndeployModel."""


class GoogleCloudAiplatformV1UnmanagedContainerModel(_messages.Message):
  r"""Contains model information necessary to perform batch prediction without
  requiring a full model import.

  Fields:
    artifactUri: The path to the directory containing the Model artifact and
      any of its supporting files.
    containerSpec: Input only. The specification of the container that is to
      be used when deploying this Model.
    predictSchemata: Contains the schemata used in Model's predictions and
      explanations
  """

  artifactUri = _messages.StringField(1)
  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1ModelContainerSpec', 2)
  predictSchemata = _messages.MessageField('GoogleCloudAiplatformV1PredictSchemata', 3)


class GoogleCloudAiplatformV1UpdateExplanationDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for ModelService.UpdateExplanationDataset.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1UpdateExplanationDatasetRequest(_messages.Message):
  r"""Request message for ModelService.UpdateExplanationDataset.

  Fields:
    examples: The example config containing the location of the dataset.
  """

  examples = _messages.MessageField('GoogleCloudAiplatformV1Examples', 1)


class GoogleCloudAiplatformV1UpdateExplanationDatasetResponse(_messages.Message):
  r"""Response message of ModelService.UpdateExplanationDataset operation."""


class GoogleCloudAiplatformV1UpdateFeaturestoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform update Featurestore.

  Fields:
    genericMetadata: Operation metadata for Featurestore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1UpdateIndexOperationMetadata(_messages.Message):
  r"""Runtime operation information for IndexService.UpdateIndex.

  Fields:
    genericMetadata: The operation generic information.
    nearestNeighborSearchOperationMetadata: The operation metadata with regard
      to Matching Engine Index operation.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)
  nearestNeighborSearchOperationMetadata = _messages.MessageField('GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata', 2)


class GoogleCloudAiplatformV1UpdateModelDeploymentMonitoringJobOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  JobService.UpdateModelDeploymentMonitoringJob.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1UpdateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation metadata for
  SpecialistPoolService.UpdateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
    specialistPool: Output only. The name of the SpecialistPool to which the
      specialists are being added. Format: `projects/{project_id}/locations/{l
      ocation_id}/specialistPools/{specialist_pool}`
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)
  specialistPool = _messages.StringField(2)


class GoogleCloudAiplatformV1UpdateTensorboardOperationMetadata(_messages.Message):
  r"""Details of operations that perform update Tensorboard.

  Fields:
    genericMetadata: Operation metadata for Tensorboard.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1UploadModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.UploadModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1UploadModelRequest(_messages.Message):
  r"""Request message for ModelService.UploadModel.

  Fields:
    model: Required. The Model to create.
    modelId: Optional. The ID to use for the uploaded Model, which will become
      the final component of the model resource name. This value may be up to
      63 characters, and valid characters are `[a-z0-9_-]`. The first
      character cannot be a number or hyphen.
    parentModel: Optional. The resource name of the model into which to upload
      the version. Only specify this field when uploading a new version.
    serviceAccount: Optional. The user-provided custom service account to use
      to do the model upload. If empty, [Vertex AI Service
      Agent](https://cloud.google.com/vertex-ai/docs/general/access-
      control#service-agents) will be used. Users uploading the Model must
      have the `iam.serviceAccounts.actAs` permission on this service account.
      Also, this account must belong to the project specified in the `parent`
      field and have all necessary read permissions.
  """

  model = _messages.MessageField('GoogleCloudAiplatformV1Model', 1)
  modelId = _messages.StringField(2)
  parentModel = _messages.StringField(3)
  serviceAccount = _messages.StringField(4)


class GoogleCloudAiplatformV1UploadModelResponse(_messages.Message):
  r"""Response message of ModelService.UploadModel operation.

  Fields:
    model: The name of the uploaded Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
    modelVersionId: Output only. The version ID of the model that is uploaded.
  """

  model = _messages.StringField(1)
  modelVersionId = _messages.StringField(2)


class GoogleCloudAiplatformV1UpsertDatapointsRequest(_messages.Message):
  r"""Request message for IndexService.UpsertDatapoints

  Fields:
    datapoints: A list of datapoints to be created/updated.
  """

  datapoints = _messages.MessageField('GoogleCloudAiplatformV1IndexDatapoint', 1, repeated=True)


class GoogleCloudAiplatformV1UpsertDatapointsResponse(_messages.Message):
  r"""Response message for IndexService.UpsertDatapoints"""


class GoogleCloudAiplatformV1UserActionReference(_messages.Message):
  r"""References an API call. It contains more information about long running
  operation and Jobs that are triggered by the API call.

  Fields:
    dataLabelingJob: For API calls that start a LabelingJob. Resource name of
      the LabelingJob. Format: `projects/{project}/locations/{location}/dataLa
      belingJobs/{data_labeling_job}`
    method: The method name of the API RPC call. For example,
      "/google.cloud.aiplatform.{apiVersion}.DatasetService.CreateDataset"
    operation: For API calls that return a long running operation. Resource
      name of the long running operation. Format:
      `projects/{project}/locations/{location}/operations/{operation}`
  """

  dataLabelingJob = _messages.StringField(1)
  method = _messages.StringField(2)
  operation = _messages.StringField(3)


class GoogleCloudAiplatformV1Value(_messages.Message):
  r"""Value is the value of the field.

  Fields:
    doubleValue: A double value.
    intValue: An integer value.
    stringValue: A string value.
  """

  doubleValue = _messages.FloatField(1)
  intValue = _messages.IntegerField(2)
  stringValue = _messages.StringField(3)


class GoogleCloudAiplatformV1WorkerPoolSpec(_messages.Message):
  r"""Represents the spec of a worker pool in a job.

  Fields:
    containerSpec: The custom container task.
    diskSpec: Disk spec.
    machineSpec: Optional. Immutable. The specification of a single machine.
    nfsMounts: Optional. List of NFS mount spec.
    pythonPackageSpec: The Python packaged task.
    replicaCount: Optional. The number of worker replicas to use for this
      worker pool.
  """

  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1ContainerSpec', 1)
  diskSpec = _messages.MessageField('GoogleCloudAiplatformV1DiskSpec', 2)
  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1MachineSpec', 3)
  nfsMounts = _messages.MessageField('GoogleCloudAiplatformV1NfsMount', 4, repeated=True)
  pythonPackageSpec = _messages.MessageField('GoogleCloudAiplatformV1PythonPackageSpec', 5)
  replicaCount = _messages.IntegerField(6)


class GoogleCloudAiplatformV1WriteFeatureValuesPayload(_messages.Message):
  r"""Contains Feature values to be written for a specific entity.

  Messages:
    FeatureValuesValue: Required. Feature values to be written, mapping from
      Feature ID to value. Up to 100,000 `feature_values` entries may be
      written across all payloads. The feature generation time, aligned by
      days, must be no older than five years (1825 days) and no later than one
      year (366 days) in the future.

  Fields:
    entityId: Required. The ID of the entity.
    featureValues: Required. Feature values to be written, mapping from
      Feature ID to value. Up to 100,000 `feature_values` entries may be
      written across all payloads. The feature generation time, aligned by
      days, must be no older than five years (1825 days) and no later than one
      year (366 days) in the future.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FeatureValuesValue(_messages.Message):
    r"""Required. Feature values to be written, mapping from Feature ID to
    value. Up to 100,000 `feature_values` entries may be written across all
    payloads. The feature generation time, aligned by days, must be no older
    than five years (1825 days) and no later than one year (366 days) in the
    future.

    Messages:
      AdditionalProperty: An additional property for a FeatureValuesValue
        object.

    Fields:
      additionalProperties: Additional properties of type FeatureValuesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FeatureValuesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1FeatureValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1FeatureValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entityId = _messages.StringField(1)
  featureValues = _messages.MessageField('FeatureValuesValue', 2)


class GoogleCloudAiplatformV1WriteFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreOnlineServingService.WriteFeatureValues.

  Fields:
    payloads: Required. The entities to be written. Up to 100,000 feature
      values can be written across all `payloads`.
  """

  payloads = _messages.MessageField('GoogleCloudAiplatformV1WriteFeatureValuesPayload', 1, repeated=True)


class GoogleCloudAiplatformV1WriteFeatureValuesResponse(_messages.Message):
  r"""Response message for
  FeaturestoreOnlineServingService.WriteFeatureValues.
  """



class GoogleCloudAiplatformV1WriteTensorboardExperimentDataRequest(_messages.Message):
  r"""Request message for TensorboardService.WriteTensorboardExperimentData.

  Fields:
    writeRunDataRequests: Required. Requests containing per-run
      TensorboardTimeSeries data to write.
  """

  writeRunDataRequests = _messages.MessageField('GoogleCloudAiplatformV1WriteTensorboardRunDataRequest', 1, repeated=True)


class GoogleCloudAiplatformV1WriteTensorboardExperimentDataResponse(_messages.Message):
  r"""Response message for TensorboardService.WriteTensorboardExperimentData.
  """



class GoogleCloudAiplatformV1WriteTensorboardRunDataRequest(_messages.Message):
  r"""Request message for TensorboardService.WriteTensorboardRunData.

  Fields:
    tensorboardRun: Required. The resource name of the TensorboardRun to write
      data to. Format: `projects/{project}/locations/{location}/tensorboards/{
      tensorboard}/experiments/{experiment}/runs/{run}`
    timeSeriesData: Required. The TensorboardTimeSeries data to write. Values
      with in a time series are indexed by their step value. Repeated writes
      to the same step will overwrite the existing value for that step. The
      upper limit of data points per write request is 5000.
  """

  tensorboardRun = _messages.StringField(1)
  timeSeriesData = _messages.MessageField('GoogleCloudAiplatformV1TimeSeriesData', 2, repeated=True)


class GoogleCloudAiplatformV1WriteTensorboardRunDataResponse(_messages.Message):
  r"""Response message for TensorboardService.WriteTensorboardRunData."""


class GoogleCloudAiplatformV1XraiAttribution(_messages.Message):
  r"""An explanation method that redistributes Integrated Gradients
  attributions to segmented regions, taking advantage of the model's fully
  differentiable structure. Refer to this paper for more details:
  https://arxiv.org/abs/1906.02825 Supported only by image Models.

  Fields:
    blurBaselineConfig: Config for XRAI with blur baseline. When enabled, a
      linear path from the maximally blurred image to the input image is
      created. Using a blurred baseline instead of zero (black image) is
      motivated by the BlurIG approach explained here:
      https://arxiv.org/abs/2004.03383
    smoothGradConfig: Config for SmoothGrad approximation of gradients. When
      enabled, the gradients are approximated by averaging the gradients from
      noisy samples in the vicinity of the inputs. Adding noise can help
      improve the computed gradients. Refer to this paper for more details:
      https://arxiv.org/pdf/1706.03825.pdf
    stepCount: Required. The number of steps for approximating the path
      integral. A good value to start is 50 and gradually increase until the
      sum to diff property is met within the desired error range. Valid range
      of its value is [1, 100], inclusively.
  """

  blurBaselineConfig = _messages.MessageField('GoogleCloudAiplatformV1BlurBaselineConfig', 1)
  smoothGradConfig = _messages.MessageField('GoogleCloudAiplatformV1SmoothGradConfig', 2)
  stepCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('GoogleIamV1Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeColor(_messages.Message):
  r"""Represents a color in the RGBA color space. This representation is
  designed for simplicity of conversion to and from color representations in
  various languages over compactness. For example, the fields of this
  representation can be trivially provided to the constructor of
  `java.awt.Color` in Java; it can also be trivially provided to UIColor's
  `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little
  work, it can be easily formatted into a CSS `rgba()` string in JavaScript.
  This reference page doesn't have information about the absolute color space
  that should be used to interpret the RGB value-for example, sRGB, Adobe RGB,
  DCI-P3, and BT.2020. By default, applications should assume the sRGB color
  space. When color equality needs to be decided, implementations, unless
  documented otherwise, treat two colors as equal if all their red, green,
  blue, and alpha values each differ by at most `1e-5`. Example (Java): import
  com.google.type.Color; // ... public static java.awt.Color fromProto(Color
  protocolor) { float alpha = protocolor.hasAlpha() ?
  protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color(
  protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); }
  public static Color toProto(java.awt.Color color) { float red = (float)
  color.getRed(); float green = (float) color.getGreen(); float blue = (float)
  color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder =
  Color .newBuilder() .setRed(red / denominator) .setGreen(green /
  denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if
  (alpha != 255) { result.setAlpha( FloatValue .newBuilder()
  .setValue(((float) alpha) / denominator) .build()); } return
  resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static
  UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float
  green = [protocolor green]; float blue = [protocolor blue]; FloatValue*
  alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper !=
  nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red
  green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color)
  { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green
  blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc]
  init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
  if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; }
  [result autorelease]; return result; } // ... Example (JavaScript): // ...
  var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red ||
  0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue
  || 0.0; var red = Math.floor(redFrac * 255); var green =
  Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if
  (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); } var
  alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green,
  blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join('');
  }; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new
  Number((red << 16) | (green << 8) | blue); var hexString =
  rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var
  resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) {
  resultBuilder.push('0'); } resultBuilder.push(hexString); return
  resultBuilder.join(''); }; // ...

  Fields:
    alpha: The fraction of this color that should be applied to the pixel.
      That is, the final pixel color is defined by the equation: `pixel color
      = alpha * (this color) + (1.0 - alpha) * (background color)` This means
      that a value of 1.0 corresponds to a solid color, whereas a value of 0.0
      corresponds to a completely transparent color. This uses a wrapper
      message rather than a simple float scalar so that it is possible to
      distinguish between a default value and the value being unset. If
      omitted, this color object is rendered as a solid color (as if the alpha
      value had been explicitly given a value of 1.0).
    blue: The amount of blue in the color as a value in the interval [0, 1].
    green: The amount of green in the color as a value in the interval [0, 1].
    red: The amount of red in the color as a value in the interval [0, 1].
  """

  alpha = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  blue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  green = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  red = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleTypeInterval(_messages.Message):
  r"""Represents a time interval, encoded as a Timestamp start (inclusive) and
  a Timestamp end (exclusive). The start must be less than or equal to the
  end. When the start equals the end, the interval is empty (matches no time).
  When both start and end are unspecified, the interval matches any time.

  Fields:
    endTime: Optional. Exclusive end of the interval. If specified, a
      Timestamp matching this interval will have to be before the end.
    startTime: Required. Inclusive start of the interval. If specified, a
      Timestamp matching this interval will have to be the same or after the
      start.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class GoogleTypeMoney(_messages.Message):
  r"""Represents an amount of money with its currency type.

  Fields:
    currencyCode: The three-letter currency code defined in ISO 4217.
    nanos: Number of nano (10^-9) units of the amount. The value must be
      between -999,999,999 and +999,999,999 inclusive. If `units` is positive,
      `nanos` must be positive or zero. If `units` is zero, `nanos` can be
      positive, zero, or negative. If `units` is negative, `nanos` must be
      negative or zero. For example $-1.75 is represented as `units`=-1 and
      `nanos`=-750,000,000.
    units: The whole units of the amount. For example if `currencyCode` is
      `"USD"`, then 1 unit is one US dollar.
  """

  currencyCode = _messages.StringField(1)
  nanos = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  units = _messages.IntegerField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
