"""Generated message classes for apphub version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'apphub'


class ApphubProjectsLocationsApplicationsCreateRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsCreateRequest object.

  Fields:
    application: A Application resource to be passed as the request body.
    applicationId: Required. The application identifier
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  application = _messages.MessageField('Application', 1)
  applicationId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ApphubProjectsLocationsApplicationsDeleteRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsDeleteRequest object.

  Fields:
    force: Optional. Application is a parent resource and requires an optional
      force field per https://linter.aip.dev/135/force-field.
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ApphubProjectsLocationsApplicationsGetRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsApplicationsListRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListApplicationsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApphubProjectsLocationsApplicationsPatchRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsPatchRequest object.

  Fields:
    application: A Application resource to be passed as the request body.
    name: Optional. The resource name of an Application.
      projects//locations//applications/
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Application resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  application = _messages.MessageField('Application', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ApphubProjectsLocationsApplicationsServicesCreateRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsServicesCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    service: A Service resource to be passed as the request body.
    serviceId: Required. The service identifier
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  service = _messages.MessageField('Service', 3)
  serviceId = _messages.StringField(4)


class ApphubProjectsLocationsApplicationsServicesDeleteRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsServicesDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ApphubProjectsLocationsApplicationsServicesGetRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsServicesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsApplicationsServicesListRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsServicesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListServicesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApphubProjectsLocationsApplicationsServicesPatchRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsServicesPatchRequest object.

  Fields:
    name: Full resource identifier of a Service. 1. Registered service format:
      projects//locations//applications//services/ 2. Discovered service
      format: projects//locations//services/
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    service: A Service resource to be passed as the request body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Service resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then the fields provided in the request will be
      overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  service = _messages.MessageField('Service', 3)
  updateMask = _messages.StringField(4)


class ApphubProjectsLocationsApplicationsWorkloadsCreateRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsWorkloadsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    workload: A Workload resource to be passed as the request body.
    workloadId: Required. The workload identifier
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  workload = _messages.MessageField('Workload', 3)
  workloadId = _messages.StringField(4)


class ApphubProjectsLocationsApplicationsWorkloadsDeleteRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsWorkloadsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ApphubProjectsLocationsApplicationsWorkloadsGetRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsWorkloadsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsApplicationsWorkloadsListRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsWorkloadsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListWorkloadsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApphubProjectsLocationsApplicationsWorkloadsPatchRequest(_messages.Message):
  r"""A ApphubProjectsLocationsApplicationsWorkloadsPatchRequest object.

  Fields:
    name: Full resource identifier of a Workload 1. Registered workload
      format: projects//locations//applications//workloads/ 2. Discovered
      workload format: projects//locations//workloads/
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Workload resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then the fields provided in the request will be
      overwritten.
    workload: A Workload resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  updateMask = _messages.StringField(3)
  workload = _messages.MessageField('Workload', 4)


class ApphubProjectsLocationsGetRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsGetTelemetryRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGetTelemetryRequest object.

  Fields:
    name: Required. The full resource name of the telemetry object in the
      format of: "projects/{project}/locations/global/telemetry".
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsGetTopologyRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGetTopologyRequest object.

  Fields:
    name: Required. The full resource name of the topology object in the
      format of: "projects/{project}/locations/global/topology"
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsGlobalGetHostProjectRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGlobalGetHostProjectRequest object.

  Fields:
    name: Required. Host Project resource name with format:
      "projects/{project_id}/locations/global/hostProject".
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsGlobalServiceProjectAttachmentsCreateRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGlobalServiceProjectAttachmentsCreateRequest
  object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    serviceProjectAttachment: A ServiceProjectAttachment resource to be passed
      as the request body.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  serviceProjectAttachment = _messages.MessageField('ServiceProjectAttachment', 3)


class ApphubProjectsLocationsGlobalServiceProjectAttachmentsDeleteRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGlobalServiceProjectAttachmentsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ApphubProjectsLocationsGlobalServiceProjectAttachmentsGetRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGlobalServiceProjectAttachmentsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsGlobalServiceProjectAttachmentsListRequest(_messages.Message):
  r"""A ApphubProjectsLocationsGlobalServiceProjectAttachmentsListRequest
  object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListServiceProjectAttachmentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApphubProjectsLocationsListRequest(_messages.Message):
  r"""A ApphubProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApphubProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ApphubProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ApphubProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ApphubProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ApphubProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ApphubProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ApphubProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApphubProjectsLocationsUpdateTelemetryRequest(_messages.Message):
  r"""A ApphubProjectsLocationsUpdateTelemetryRequest object.

  Fields:
    name: The full resource name of the telemetry object in the format of:
      "projects/{project}/locations/global/telemetry".
    telemetry: A Telemetry resource to be passed as the request body.
    updateMask: Optional. The mask to control which fields of the telemetry
      get updated. If the mask is not present, all fields will be updated.
  """

  name = _messages.StringField(1, required=True)
  telemetry = _messages.MessageField('Telemetry', 2)
  updateMask = _messages.StringField(3)


class ApphubProjectsLocationsUpdateTopologyRequest(_messages.Message):
  r"""A ApphubProjectsLocationsUpdateTopologyRequest object.

  Fields:
    name: The full resource name of the topology object in the format of:
      "projects/{project}/locations/global/topology"
    topology: A Topology resource to be passed as the request body.
    updateMask: Optional. The mask to control which fields of the topology get
      updated. If the mask is not present, all fields will be updated.
  """

  name = _messages.StringField(1, required=True)
  topology = _messages.MessageField('Topology', 2)
  updateMask = _messages.StringField(3)


class Application(_messages.Message):
  r"""Application defines the governance boundary for App Hub Entities that
  perform a logical end-to-end business function. We support Application level
  IAM permission to align with governance requirements.

  Fields:
    attributes: Optional. Consumer Attributes that are configured by
      customers.
    createTime: Output only. Application creation time.
    description: Optional. User-provided description of an application.
    displayName: Optional. Human-friendly display name.
    name: Optional. The resource name of an Application.
      projects//locations//applications/
    scope: Defines which data can be included into this application. Limits
      which services and workloads can be registered.
    serviceAttachments: Collection of services owned by application (whether
      backed by workloads or opaque such as SaaS or CloudRun/GCF). Updated
      whenever new services are registered/unregistered under the application.
      Application can contain services from the same region. ex1. A us-
      central1 application can contain services from us-central1. ex2. A
      global application can contain services from global region.
    updateTime: Output only. Application update time.
    workloadAttachments: Collection of workloads owned by application Updated
      whenever new workloads are registered/unregistered under the
      application. Application can contain workloads from the same region.
      ex1. A us-central1 application can contain workloads from us-central1.
      ex2. A global application can contain workloads from global region.
  """

  attributes = _messages.MessageField('Attributes', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  name = _messages.StringField(5)
  scope = _messages.MessageField('Scope', 6)
  serviceAttachments = _messages.MessageField('ServiceAttachment', 7, repeated=True)
  updateTime = _messages.StringField(8)
  workloadAttachments = _messages.MessageField('WorkloadAttachment', 9, repeated=True)


class Attributes(_messages.Message):
  r"""Consumer provided attributes.

  Fields:
    businessOwners: Optional. Business owner such as managers, directors etc.
    criticality: Optional. Criticality.
    developerOwners: Optional. List of owner contacts. Development owner such
      as software Development Engineers
    environment: Optional. User-provided environment information.
    operatorOwners: Optional. Operation owner such as Site Reliability
      Engineers
  """

  businessOwners = _messages.MessageField('ContactInfo', 1, repeated=True)
  criticality = _messages.MessageField('Criticality', 2)
  developerOwners = _messages.MessageField('ContactInfo', 3, repeated=True)
  environment = _messages.MessageField('Environment', 4)
  operatorOwners = _messages.MessageField('ContactInfo', 5, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Channel(_messages.Message):
  r"""Separate message to accommodate custom formats across IRC, Slack etc.

  Fields:
    uri: Optional. IRC, Slack
  """

  uri = _messages.StringField(1)


class ContactInfo(_messages.Message):
  r"""Contact information of stakeholders

  Fields:
    channel: Optional. Communication channel of the contacts.
    displayName: Optional. Contact's name.
    email: Optional. Email address of the contacts.
  """

  channel = _messages.MessageField('Channel', 1)
  displayName = _messages.StringField(2)
  email = _messages.StringField(3)


class Criticality(_messages.Message):
  r"""Criticality of the application, serivice, or workload

  Fields:
    level: Required. Criticality level name.
    missionCritical: Required. Indicates mission-critical services and
      workloads.
  """

  level = _messages.StringField(1)
  missionCritical = _messages.BooleanField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Environment(_messages.Message):
  r"""User-defined environment information.

  Fields:
    environment: Optional. Environment name.
  """

  environment = _messages.StringField(1)


class HostProject(_messages.Message):
  r"""Message represents a host project. HostProject is a global resource.

  Fields:
    hostProject: Output only. Host project number with format:
      projects/{project_number}
    name: Required. Host Project resource name with format:
      "projects/{service-project-id}/locations/global/hostProject".
  """

  hostProject = _messages.StringField(1)
  name = _messages.StringField(2)


class ListApplicationsResponse(_messages.Message):
  r"""Message for response to listing Applications.

  Fields:
    applications: The list of Applications
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  applications = _messages.MessageField('Application', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListServiceProjectAttachmentsResponse(_messages.Message):
  r"""Message for response to listing service project attachments.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    serviceProjectAttachments: The list of service project attachments
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  serviceProjectAttachments = _messages.MessageField('ServiceProjectAttachment', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListServicesResponse(_messages.Message):
  r"""Message for response to listing Services

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    services: The list of Services
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  services = _messages.MessageField('Service', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListWorkloadsResponse(_messages.Message):
  r"""Message for response to listing Workloads

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
    workloads: The list of Telemetry
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  workloads = _messages.MessageField('Workload', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Scope(_messages.Message):
  r"""The scope of the Application

  Enums:
    TypeValueValuesEnum: Scope Type

  Fields:
    type: Scope Type
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Scope Type

    Values:
      TYPE_UNSPECIFIED: Unspecified type
      REGIONAL: Regional application
    """
    TYPE_UNSPECIFIED = 0
    REGIONAL = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class Service(_messages.Message):
  r"""Message represents a service.

  Fields:
    attributes: Optional. Customer Attributes.
    createTime: Output only. Service create time.
    description: Optional. User-provided description of a service.
    discoveredService: Required. Immutable. Resource name of the service
      before registration. Registered resource name of a Service is different
      from its discovered name. This field always contains discovered resource
      name, enabling IaC tools like Terraform to unambiguously map the two
      representations. projects//locations//services/
    displayName: Optional. Human-friendly display name
    name: Full resource identifier of a Service. 1. Registered service format:
      projects//locations//applications//services/ 2. Discovered service
      format: projects//locations//services/
    serviceProperties: Output only. Properties of an underlying compute
      resource that can comprise a service. These are immutable.
    serviceReference: Output only. Reference to an underlying networking
      resource that can comprise a service. These are immutable.
    updateTime: Output only. Service update time.
  """

  attributes = _messages.MessageField('Attributes', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  discoveredService = _messages.StringField(4)
  displayName = _messages.StringField(5)
  name = _messages.StringField(6)
  serviceProperties = _messages.MessageField('ServiceProperties', 7)
  serviceReference = _messages.MessageField('ServiceReference', 8)
  updateTime = _messages.StringField(9)


class ServiceAttachment(_messages.Message):
  r"""Collection of services owned by application (whether backed by workloads
  or opaque such as SaaS or CloudRun/GCF).

  Fields:
    service: Output only. Resource name of the registered service:
      projects//locations//applications//services/
  """

  service = _messages.StringField(1)


class ServiceProjectAttachment(_messages.Message):
  r"""Message represents a service project attachment.

  Fields:
    createTime: Output only. Service project attachment registration time.
    name: Full resource identifier of a service project attachment in the
      format of projects//locations/global/serviceProjectAttachments/
    serviceProject: Required. Immutable. Service project name with format:
      projects/abc or projects/123
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  serviceProject = _messages.StringField(3)


class ServiceProperties(_messages.Message):
  r"""Properties of an underlying GCP resource that can comprise a service.

  Fields:
    gcpProject: Optional. The service project identifier of the underlying GCP
      resource resides in.
    location: Optional. The location of the underlying resource resides in,
      i.e. us-west1.
    zone: Optional. The location of the underlying resource if it is zonal,
      i.e. us-west1-a.
  """

  gcpProject = _messages.StringField(1)
  location = _messages.StringField(2)
  zone = _messages.StringField(3)


class ServiceReference(_messages.Message):
  r"""Reference to an underlying networking resource that can comprise a
  service.

  Fields:
    path: Optional. Additional path under the resource uri (i.e.
      demultiplexing one resource uri into multiple entries). Smallest unit a
      policy can be attached to. Examples: URL Map path entry.
    uri: Output only. The underlying resource uri e.g. URI of Forwarding Rule,
      URL Map, Backend Service
  """

  path = _messages.StringField(1)
  uri = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Telemetry(_messages.Message):
  r"""Message describing Telemetry object.

  Fields:
    monitoringEnabled: Optional. Enablement status of the telemetry monitoring
      configuration.
    name: The full resource name of the telemetry object in the format of:
      "projects/{project}/locations/global/telemetry".
    project: Output only. Project number which the telemetry configuration is
      associated with Format: projects/{project}
  """

  monitoringEnabled = _messages.BooleanField(1)
  name = _messages.StringField(2)
  project = _messages.StringField(3)


class Topology(_messages.Message):
  r"""Message describing Topology object

  Fields:
    enabled: Optional. Whether or not Topology is enabled for the project
    name: The full resource name of the topology object in the format of:
      "projects/{project}/locations/global/topology"
    project: Output only. Project number which the topology configuration is
      associated with Format: projects/{project}
  """

  enabled = _messages.BooleanField(1)
  name = _messages.StringField(2)
  project = _messages.StringField(3)


class Workload(_messages.Message):
  r"""Message represents a workload.

  Fields:
    attributes: Optional. Consumer Attributes.
    createTime: Output only. Workload create time.
    description: Optional. User-provided description of a workload.
    discoveredWorkload: Required. Immutable. Resource name of the workload
      before registration. Registered resource name of a Workload is different
      from its discovered name. This field always contains discovered resource
      name, enabling IaC tools like Terraform to unambiguously map the two
      representations. projects//locations//workloads/
    displayName: Optional. Human-friendly display name
    name: Full resource identifier of a Workload 1. Registered workload
      format: projects//locations//applications//workloads/ 2. Discovered
      workload format: projects//locations//workloads/
    updateTime: Output only. Workload update time.
    workloadProperties: Output only. Properties of an underlying compute
      resource represented by the workload. These are immutable.
    workloadReference: Output only. References an underlying compute resource
      represented by the workload. These are immutable.
  """

  attributes = _messages.MessageField('Attributes', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  discoveredWorkload = _messages.StringField(4)
  displayName = _messages.StringField(5)
  name = _messages.StringField(6)
  updateTime = _messages.StringField(7)
  workloadProperties = _messages.MessageField('WorkloadProperties', 8)
  workloadReference = _messages.MessageField('WorkloadReference', 9)


class WorkloadAttachment(_messages.Message):
  r"""Collection of workloads owned by application Updated whenever new
  workloads are registered/unregistered under the application.

  Fields:
    workload: Output only. Resource name of the registered workload:
      projects//locations//applications//workloads/
  """

  workload = _messages.StringField(1)


class WorkloadProperties(_messages.Message):
  r"""Properties of an underlying compute resource that can comprise a
  workload.

  Fields:
    gcpProject: Optional. The service project identifier of the underlying GCP
      resource resides in. Empty for non-GCP resources.
    location: Optional. The location of the underlying compute resource
      resides in.
    zone: Optional. The location of the underlying compute resource if it is
      zonal.
  """

  gcpProject = _messages.StringField(1)
  location = _messages.StringField(2)
  zone = _messages.StringField(3)


class WorkloadReference(_messages.Message):
  r"""Reference of an underlying compute resource that can comprise a
  workload.

  Fields:
    uri: Optional. The underlying compute resource uri.
  """

  uri = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
