"""Generated message classes for telecomdatafabric version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'telecomdatafabric'


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CreateDeploymentRequest(_messages.Message):
  r"""Message for creating a Deployment

  Fields:
    deployment: Required. The resource being created
    deploymentId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and deployment_id from the
      method_signature of Create RPC
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  requestId = _messages.StringField(3)


class Deployment(_messages.Message):
  r"""Message describing Deployment object.

  Enums:
    StateValueValuesEnum: Output only. Current state of the Deployment.

  Messages:
    LabelsValue: Labels as key value pairs
    ParametersValue: Key/value pair that will be replaced in the template.

  Fields:
    createTime: Output only. [Output only] Create time stamp
    deploymentView: Output only. [Output only] Details about the deployment.
    fabricId: Fabric ID of the Deployment.
    labels: Labels as key value pairs
    lake: Dataplex Lake that the assets are attached to.
    lakeInfo: Input only. LakeInfo supplied by the consumer. TDF would create
      the Lake and Zones. Assets would be attached to the Zone based on the
      asset type.
    locationId: Location of project where template will be deployed, if not
      supplied the default is resource's location.
    name: name of resource
    parameters: Key/value pair that will be replaced in the template.
    projectId: Id of project where template will be deployed, if not supplied
      the default is resource's project.
    state: Output only. Current state of the Deployment.
    templateId: Required. Id of the template to use for deployment. This
      resource will be in the format "/projects/*/locations/*/template/"
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the Deployment.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
      SUSPENDED: Resource is suspended and no longer being managed actively.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6
    SUSPENDED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Key/value pair that will be replaced in the template.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deploymentView = _messages.MessageField('DeploymentView', 2)
  fabricId = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  lake = _messages.MessageField('DeploymentLake', 5)
  lakeInfo = _messages.MessageField('DeploymentLakeInfo', 6)
  locationId = _messages.StringField(7)
  name = _messages.StringField(8)
  parameters = _messages.MessageField('ParametersValue', 9)
  projectId = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  templateId = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class DeploymentAsset(_messages.Message):
  r"""DeploymentAsset represents the details about the different input/output
  data assets.

  Enums:
    OwnershipValueValuesEnum: Ownership will represent whether asset is Google
      owned or customer owned.
    TypeValueValuesEnum: Asset type defines dataplex zone of this resource.

  Fields:
    attachedZone: The Dataplex Zone to which this asset is attached.
    bigqueryDataset: BigQueryDataset represents the details of bigquery
      dataset asset.
    bigqueryTable: BigQueryTable represents the details of bigquery table
      asset.
    gcsBucket: Cloud Storage bucket represents the details of Cloud Storage
      bucket asset.
    id: Asset ID.
    ownership: Ownership will represent whether asset is Google owned or
      customer owned.
    pubsubSubscription: PubSubSubscription represents the details of pub/sub
      subscriptions asset.
    pubsubTopic: PubSubTopic represents the details of pub/sub topic asset.
    type: Asset type defines dataplex zone of this resource.
  """

  class OwnershipValueValuesEnum(_messages.Enum):
    r"""Ownership will represent whether asset is Google owned or customer
    owned.

    Values:
      OWNERSHIP_UNSPECIFIED: Default value. This value is unused.
      OWNED: Asset to be created in this deployment.
      EXTERNAL: External asset to be used in this deployment.
    """
    OWNERSHIP_UNSPECIFIED = 0
    OWNED = 1
    EXTERNAL = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Asset type defines dataplex zone of this resource.

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      LANDING: LANDING represents that the asset is a initial input to the
        process.
      INTERMEDIATE: INTERMEDIATE represents that the asset is an
        intermediatory asset.
      CURATED: CURATED represents that the asset will contain curated data in
        some specific format.
      TEMPORARY: TEMPORARY represents that the asset is a temporary asset.
    """
    TYPE_UNSPECIFIED = 0
    LANDING = 1
    INTERMEDIATE = 2
    CURATED = 3
    TEMPORARY = 4

  attachedZone = _messages.StringField(1)
  bigqueryDataset = _messages.MessageField('DeploymentAssetBigQueryDataset', 2)
  bigqueryTable = _messages.MessageField('DeploymentAssetBigQueryTable', 3)
  gcsBucket = _messages.MessageField('DeploymentAssetGcsBucket', 4)
  id = _messages.StringField(5)
  ownership = _messages.EnumField('OwnershipValueValuesEnum', 6)
  pubsubSubscription = _messages.MessageField('DeploymentAssetPubSubSubscription', 7)
  pubsubTopic = _messages.MessageField('DeploymentAssetPubSubTopic', 8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)


class DeploymentAssetBigQueryDataset(_messages.Message):
  r"""BigQueryDataset represents bigquery dataset data asset.

  Fields:
    name: BigQuery dataset name.
  """

  name = _messages.StringField(1)


class DeploymentAssetBigQueryTable(_messages.Message):
  r"""BigQueryTable represents bigquery table data asset.

  Fields:
    clusteringFields: Specifies column names to use for data clustering. Up to
      four top-level columns are allowed, and should be specified in
      descending priority order.
    dataset: BigQuery dataset name.
    expirationDays: The time when this table expires, in days. If not present,
      the table will persist indefinitely. Expired tables will be deleted and
      their storage reclaimed.
    name: BigQuery table name.
    schema: Json string defining BigQuery table schema.
    timePartitioning: Time partitioning information for the table.
  """

  clusteringFields = _messages.StringField(1, repeated=True)
  dataset = _messages.StringField(2)
  expirationDays = _messages.IntegerField(3)
  name = _messages.StringField(4)
  schema = _messages.StringField(5)
  timePartitioning = _messages.MessageField('DeploymentAssetBigQueryTableTimePartitioning', 6)


class DeploymentAssetBigQueryTableTimePartitioning(_messages.Message):
  r"""TimePartitioning configures time-based partitioning for the table.

  Fields:
    field: The field used to determine how to create a time-based partition.
      If time-based partitioning is enabled without this value, the table is
      partitioned based on the load time.
    type: Required. The supported types are DAY, HOUR, MONTH, and YEAR, which
      will generate one partition per day, hour, month, and year,
      respectively.
  """

  field = _messages.StringField(1)
  type = _messages.StringField(2)


class DeploymentAssetGcsBucket(_messages.Message):
  r"""Cloud Storage Bucket represents Cloud Storage bucket data asset.

  Fields:
    ageDays: Age in days after which you want to perform delete action.
    name: Cloud Storage bucket name.
    retentionDays: Specifies the days for which objects need to be retained.
  """

  ageDays = _messages.IntegerField(1)
  name = _messages.StringField(2)
  retentionDays = _messages.IntegerField(3)


class DeploymentAssetPubSubSubscription(_messages.Message):
  r"""PubSubSubscription represents pub/sub topic and its subscription data
  asset.

  Fields:
    name: Pub/Sub subscription name.
    topic: Pub/Sub topic name.
  """

  name = _messages.StringField(1)
  topic = _messages.StringField(2)


class DeploymentAssetPubSubTopic(_messages.Message):
  r"""Pub/Sub Topic represents pub/sub data asset.

  Fields:
    name: Pub/Sub topic name.
  """

  name = _messages.StringField(1)


class DeploymentLake(_messages.Message):
  r"""Lake represents a lake in Dataplex.

  Fields:
    lakeId: LakeID for the Dataplex Lake.
    metastore: Metastore service in the DataprocMetastore.
  """

  lakeId = _messages.StringField(1)
  metastore = _messages.MessageField('DeploymentMetastore', 2)


class DeploymentLakeInfo(_messages.Message):
  r"""LakeInfo contains Dataplex Lake to be created.

  Fields:
    lake: Lake in the Dataplex.
  """

  lake = _messages.MessageField('DeploymentLake', 1)


class DeploymentMetastore(_messages.Message):
  r"""Metastore represents a service in DataprocMetastore.

  Fields:
    serviceId: Service id for the DataprocMetastore service.
  """

  serviceId = _messages.StringField(1)


class DeploymentProcess(_messages.Message):
  r"""DeploymentProcess represents the process to be instantiated by template.

  Messages:
    ParametersValue: Process parameters.

  Fields:
    dataflowJob: DataflowJob represents the details about the dataflow job.
    id: Process ID.
    inputAssetIds: Input assets for process, used for recording dependency.
    outputAssetIds: Output assets for process, used for recording dependency.
    parameters: Process parameters.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Process parameters.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataflowJob = _messages.MessageField('DeploymentProcessDataflowJob', 1)
  id = _messages.StringField(2)
  inputAssetIds = _messages.StringField(3, repeated=True)
  outputAssetIds = _messages.StringField(4, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 5)


class DeploymentProcessDataflowJob(_messages.Message):
  r"""DataflowJob represents dataflow job and its configurations.

  Enums:
    TypeValueValuesEnum: Dataflow job type.

  Fields:
    schedule: schedule reprsents configuration to schedule dataflow job.
    templateGcsPath: Cloud Storage bucket path where flex template is present.
    type: Dataflow job type.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Dataflow job type.

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      CLASSIC: Classic dataflow job.
      FLEX: Flex dataflow job.
    """
    TYPE_UNSPECIFIED = 0
    CLASSIC = 1
    FLEX = 2

  schedule = _messages.StringField(1)
  templateGcsPath = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class DeploymentView(_messages.Message):
  r"""DeploymentView represents all details about template deployment.

  Fields:
    assets: Assets in deployment.
    processes: Processes in deployment.
  """

  assets = _messages.MessageField('DeploymentAsset', 1, repeated=True)
  processes = _messages.MessageField('DeploymentProcess', 2, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ListDeploymentsResponse(_messages.Message):
  r"""Message for response to listing Deployments

  Fields:
    deployments: The list of Deployment
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListPublicTemplatesResponse(_messages.Message):
  r"""Message for response to listing PublicTemplates

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    publicTemplates: The list of PublicTemplate
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  publicTemplates = _messages.MessageField('PublicTemplate', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class PublicTemplate(_messages.Message):
  r"""Message describing Template object

  Fields:
    name: Output only. name of resource
    parameters: Output only. Parameters will be used by template during
      provisioning.
  """

  name = _messages.StringField(1)
  parameters = _messages.MessageField('TemplateParameter', 2, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TelecomdatafabricProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and deployment_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDeploymentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Deployment resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  deployment = _messages.MessageField('Deployment', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDeploymentsPreviewRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsPreviewRequest object.

  Fields:
    createDeploymentRequest: A CreateDeploymentRequest resource to be passed
      as the request body.
    parent: Required. Value for parent.
  """

  createDeploymentRequest = _messages.MessageField('CreateDeploymentRequest', 1)
  parent = _messages.StringField(2, required=True)


class TelecomdatafabricProjectsLocationsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class TelecomdatafabricProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsPublicTemplatesGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsPublicTemplatesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsPublicTemplatesListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsPublicTemplatesListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListPublicTemplatesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TemplateParameter(_messages.Message):
  r"""Message describing TemplateParameter object.

  Fields:
    description: Parameter description.
    isRequired: True, if parameter is required.
    name: Parameter name.
    regexp: Regex to validate parameter value provided during provisioning.
  """

  description = _messages.StringField(1)
  isRequired = _messages.BooleanField(2)
  name = _messages.StringField(3)
  regexp = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
