"""Generated client library for marketplacesolutions version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.marketplacesolutions.v1alpha1 import marketplacesolutions_v1alpha1_messages as messages


class MarketplacesolutionsV1alpha1(base_api.BaseApiClient):
  """Generated client library for service marketplacesolutions version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://marketplacesolutions.googleapis.com/'
  MTLS_BASE_URL = 'https://marketplacesolutions.mtls.googleapis.com/'

  _PACKAGE = 'marketplacesolutions'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'MarketplacesolutionsV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new marketplacesolutions handle."""
    url = url or self.BASE_URL
    super(MarketplacesolutionsV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_convergeImages = self.ProjectsLocationsConvergeImagesService(self)
    self.projects_locations_convergeInstances = self.ProjectsLocationsConvergeInstancesService(self)
    self.projects_locations_convergeNetworks = self.ProjectsLocationsConvergeNetworksService(self)
    self.projects_locations_convergeSshKeys = self.ProjectsLocationsConvergeSshKeysService(self)
    self.projects_locations_convergeVolumes = self.ProjectsLocationsConvergeVolumesService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsConvergeImagesService(base_api.BaseApiService):
    """Service class for the projects_locations_convergeImages resource."""

    _NAME = 'projects_locations_convergeImages'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsLocationsConvergeImagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details about a single image from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeImagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConvergeImage) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeImages/{convergeImagesId}',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeImages.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeImagesGetRequest',
        response_type_name='ConvergeImage',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List Images in a given project and location from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeImagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConvergeImagesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeImages',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeImages.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/convergeImages',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeImagesListRequest',
        response_type_name='ListConvergeImagesResponse',
        supports_download=False,
    )

  class ProjectsLocationsConvergeInstancesService(base_api.BaseApiService):
    """Service class for the projects_locations_convergeInstances resource."""

    _NAME = 'projects_locations_convergeInstances'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsLocationsConvergeInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details about a single server from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConvergeInstance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeInstances/{convergeInstancesId}',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeInstances.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeInstancesGetRequest',
        response_type_name='ConvergeInstance',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List servers in a given project and location from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConvergeInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeInstances',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeInstances.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/convergeInstances',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeInstancesListRequest',
        response_type_name='ListConvergeInstancesResponse',
        supports_download=False,
    )

  class ProjectsLocationsConvergeNetworksService(base_api.BaseApiService):
    """Service class for the projects_locations_convergeNetworks resource."""

    _NAME = 'projects_locations_convergeNetworks'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsLocationsConvergeNetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details about a single network from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeNetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConvergeNetwork) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeNetworks/{convergeNetworksId}',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeNetworks.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeNetworksGetRequest',
        response_type_name='ConvergeNetwork',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List networks in a given project and location from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeNetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConvergeNetworksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeNetworks',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeNetworks.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/convergeNetworks',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeNetworksListRequest',
        response_type_name='ListConvergeNetworksResponse',
        supports_download=False,
    )

  class ProjectsLocationsConvergeSshKeysService(base_api.BaseApiService):
    """Service class for the projects_locations_convergeSshKeys resource."""

    _NAME = 'projects_locations_convergeSshKeys'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsLocationsConvergeSshKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details about a single Converge SSH Key.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeSshKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConvergeSSHKey) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeSshKeys/{convergeSshKeysId}',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeSshKeys.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeSshKeysGetRequest',
        response_type_name='ConvergeSSHKey',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List SSH Keys in a given project and location from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeSshKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConvergeSSHKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeSshKeys',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeSshKeys.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/convergeSshKeys',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeSshKeysListRequest',
        response_type_name='ListConvergeSSHKeysResponse',
        supports_download=False,
    )

  class ProjectsLocationsConvergeVolumesService(base_api.BaseApiService):
    """Service class for the projects_locations_convergeVolumes resource."""

    _NAME = 'projects_locations_convergeVolumes'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsLocationsConvergeVolumesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details about a single volume from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeVolumesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConvergeVolume) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeVolumes/{convergeVolumesId}',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeVolumes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeVolumesGetRequest',
        response_type_name='ConvergeVolume',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List servers in a given project and location from Converge.

      Args:
        request: (MarketplacesolutionsProjectsLocationsConvergeVolumesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConvergeVolumesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/convergeVolumes',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.convergeVolumes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/convergeVolumes',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsConvergeVolumesListRequest',
        response_type_name='ListConvergeVolumesResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (MarketplacesolutionsProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='marketplacesolutions.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='MarketplacesolutionsProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (MarketplacesolutionsProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='marketplacesolutions.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get details about an operation.

      Args:
        request: (MarketplacesolutionsProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (MarketplacesolutionsProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/operations',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (MarketplacesolutionsProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (MarketplacesolutionsProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='marketplacesolutions.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/locations',
        request_field='',
        request_type_name='MarketplacesolutionsProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(MarketplacesolutionsV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
