"""Generated message classes for batch version v1.

An API to manage the running of batch jobs on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'batch'


class Accelerator(_messages.Message):
  r"""Accelerator describes Compute Engine accelerators to be attached to the
  VM.

  Fields:
    count: The number of accelerators of this type.
    installGpuDrivers: Deprecated: please use instances[0].install_gpu_drivers
      instead.
    type: The accelerator type. For example, "nvidia-tesla-t4". See `gcloud
      compute accelerator-types list`.
  """

  count = _messages.IntegerField(1)
  installGpuDrivers = _messages.BooleanField(2)
  type = _messages.StringField(3)


class ActionCondition(_messages.Message):
  r"""Conditions for actions to deal with task failures.

  Fields:
    exitCodes: Exit codes of a task execution. If there are more than 1 exit
      codes, when task executes with any of the exit code in the list, the
      condition is met and the action will be executed.
  """

  exitCodes = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)


class AllocationPolicy(_messages.Message):
  r"""A Job's resource allocation policy describes when, where, and how
  compute resources should be allocated for the Job.

  Messages:
    LabelsValue: Labels applied to all VM instances and other resources
      created by AllocationPolicy. Labels could be user provided or system
      generated. You can assign up to 64 labels. [Google Compute Engine label
      restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) apply. Label names that start with "goog-" or
      "google-" are reserved.

  Fields:
    instances: Describe instances that can be created by this
      AllocationPolicy. Only instances[0] is supported now.
    labels: Labels applied to all VM instances and other resources created by
      AllocationPolicy. Labels could be user provided or system generated. You
      can assign up to 64 labels. [Google Compute Engine label
      restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) apply. Label names that start with "goog-" or
      "google-" are reserved.
    location: Location where compute resources should be allocated for the
      Job.
    network: The network policy.
    serviceAccount: Service account that VMs will run as.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels applied to all VM instances and other resources created by
    AllocationPolicy. Labels could be user provided or system generated. You
    can assign up to 64 labels. [Google Compute Engine label
    restrictions](https://cloud.google.com/compute/docs/labeling-
    resources#restrictions) apply. Label names that start with "goog-" or
    "google-" are reserved.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  instances = _messages.MessageField('InstancePolicyOrTemplate', 1, repeated=True)
  labels = _messages.MessageField('LabelsValue', 2)
  location = _messages.MessageField('LocationPolicy', 3)
  network = _messages.MessageField('NetworkPolicy', 4)
  serviceAccount = _messages.MessageField('ServiceAccount', 5)


class AttachedDisk(_messages.Message):
  r"""A new or an existing persistent disk (PD) or a local ssd attached to a
  VM instance.

  Fields:
    deviceName: Device name that the guest operating system will see. It is
      used by Runnable.volumes field to mount disks. So please specify the
      device_name if you want Batch to help mount the disk, and it should
      match the device_name field in volumes.
    existingDisk: Name of an existing PD.
    newDisk: A Disk attribute.
  """

  deviceName = _messages.StringField(1)
  existingDisk = _messages.StringField(2)
  newDisk = _messages.MessageField('Disk', 3)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Barrier(_messages.Message):
  r"""Barrier runnable blocks until all tasks in a taskgroup reach it.

  Fields:
    name: Barriers are identified by their index in runnable list. Names are
      not required, but if present should be an identifier.
  """

  name = _messages.StringField(1)


class BatchProjectsLocationsGetRequest(_messages.Message):
  r"""A BatchProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class BatchProjectsLocationsJobsCreateRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsCreateRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    jobId: ID used to uniquely identify the Job within its parent scope. This
      field should contain at most 63 characters and must start with lowercase
      characters. Only lowercase characters, numbers and '-' are accepted. The
      '-' character cannot be the first or the last one. A system generated ID
      will be used if the field is not set. The job.name field in the request
      will be ignored and the created resource name of the Job will be
      "{parent}/jobs/{job_id}".
    parent: Required. The parent resource name where the Job will be created.
      Pattern: "projects/{project}/locations/{location}"
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  job = _messages.MessageField('Job', 1)
  jobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class BatchProjectsLocationsJobsDeleteRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsDeleteRequest object.

  Fields:
    name: Job name.
    reason: Optional. Reason for this deletion.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  reason = _messages.StringField(2)
  requestId = _messages.StringField(3)


class BatchProjectsLocationsJobsGetIamPolicyRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BatchProjectsLocationsJobsGetRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsGetRequest object.

  Fields:
    name: Required. Job name.
  """

  name = _messages.StringField(1, required=True)


class BatchProjectsLocationsJobsListRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsListRequest object.

  Fields:
    filter: List filter.
    pageSize: Page size.
    pageToken: Page token.
    parent: Parent path.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BatchProjectsLocationsJobsSetIamPolicyRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BatchProjectsLocationsJobsTaskGroupsTasksGetRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsTaskGroupsTasksGetRequest object.

  Fields:
    name: Required. Task name.
  """

  name = _messages.StringField(1, required=True)


class BatchProjectsLocationsJobsTaskGroupsTasksListRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsTaskGroupsTasksListRequest object.

  Fields:
    filter: Task filter, null filter matches all Tasks. Filter string should
      be of the format State=TaskStatus.State e.g. State=RUNNING
    pageSize: Page size.
    pageToken: Page token.
    parent: Required. Name of a TaskGroup from which Tasks are being
      requested. Pattern: "projects/{project}/locations/{location}/jobs/{job}/
      taskGroups/{task_group}"
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BatchProjectsLocationsJobsTestIamPermissionsRequest(_messages.Message):
  r"""A BatchProjectsLocationsJobsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BatchProjectsLocationsListRequest(_messages.Message):
  r"""A BatchProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BatchProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A BatchProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class BatchProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A BatchProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class BatchProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A BatchProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BatchProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A BatchProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ComputeResource(_messages.Message):
  r"""Compute resource requirements

  Fields:
    bootDiskMib: Extra boot disk size in MiB for each task.
    cpuMilli: The milliCPU count.
    memoryMib: Memory in MiB.
  """

  bootDiskMib = _messages.IntegerField(1)
  cpuMilli = _messages.IntegerField(2)
  memoryMib = _messages.IntegerField(3)


class Container(_messages.Message):
  r"""Container runnable.

  Fields:
    blockExternalNetwork: If set to true, external network access to and from
      container will be blocked. The container will use the default internal
      network 'goog-internal'.
    commands: Overrides the `CMD` specified in the container. If there is an
      ENTRYPOINT (either in the container image or with the entrypoint field
      below) then commands are appended as arguments to the ENTRYPOINT.
    entrypoint: Overrides the `ENTRYPOINT` specified in the container.
    imageUri: The URI to pull the container image from.
    options: Arbitrary additional options to include in the "docker run"
      command when running this container, e.g. "--network host".
    password: Optional password for logging in to a docker registry. If
      password matches "projects/*/secrets/*/versions/*" then Batch will read
      the password from the Secret Manager;
    username: Optional username for logging in to a docker registry. If
      username matches "projects/*/secrets/*/versions/*" then Batch will read
      the username from the Secret Manager.
    volumes: Volumes to mount (bind mount) from the host machine files or
      directories into the container, formatted to match docker run's --volume
      option, e.g. /foo:/bar, or /foo:/bar:ro
  """

  blockExternalNetwork = _messages.BooleanField(1)
  commands = _messages.StringField(2, repeated=True)
  entrypoint = _messages.StringField(3)
  imageUri = _messages.StringField(4)
  options = _messages.StringField(5)
  password = _messages.StringField(6)
  username = _messages.StringField(7)
  volumes = _messages.StringField(8, repeated=True)


class Disk(_messages.Message):
  r"""A new persistent disk or a local ssd. A VM can only have one local SSD
  setting but multiple local SSD partitions.
  https://cloud.google.com/compute/docs/disks#pdspecs.
  https://cloud.google.com/compute/docs/disks#localssds.

  Fields:
    diskInterface: Local SSDs are available through both "SCSI" and "NVMe"
      interfaces. If not indicated, "NVMe" will be the default one for local
      ssds. We only support "SCSI" for persistent disks now.
    image: Name of a public or custom image used as the data source.
    sizeGb: Disk size in GB. This field is ignored if `data_source` is `disk`
      or `image`. If `type` is `local-ssd`, size_gb should be a multiple of
      375GB, otherwise, the final size will be the next greater multiple of
      375 GB.
    snapshot: Name of a snapshot used as the data source.
    type: Disk type as shown in `gcloud compute disk-types list` For example,
      "pd-ssd", "pd-standard", "pd-balanced", "local-ssd".
  """

  diskInterface = _messages.StringField(1)
  image = _messages.StringField(2)
  sizeGb = _messages.IntegerField(3)
  snapshot = _messages.StringField(4)
  type = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Environment(_messages.Message):
  r"""An Environment describes a collection of environment variables to set
  when executing Tasks.

  Messages:
    VariablesValue: A map of environment variable names to values.

  Fields:
    variables: A map of environment variable names to values.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class VariablesValue(_messages.Message):
    r"""A map of environment variable names to values.

    Messages:
      AdditionalProperty: An additional property for a VariablesValue object.

    Fields:
      additionalProperties: Additional properties of type VariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a VariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  variables = _messages.MessageField('VariablesValue', 1)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GCS(_messages.Message):
  r"""Represents a Google Cloud Storage volume.

  Fields:
    remotePath: Remote path, either a bucket name or a subdirectory of a
      bucket, e.g.: bucket_name, bucket_name/subdirectory/
  """

  remotePath = _messages.StringField(1)


class InstancePolicy(_messages.Message):
  r"""InstancePolicy describes an instance type and resources attached to each
  VM created by this InstancePolicy.

  Enums:
    ProvisioningModelValueValuesEnum: The provisioning model.

  Fields:
    accelerators: The accelerators attached to each VM instance.
    disks: Non-boot disks to be attached for each VM created by this
      InstancePolicy. New disks will be deleted when the VM is deleted.
    machineType: The Compute Engine machine type.
    minCpuPlatform: The minimum CPU platform. See
      `https://cloud.google.com/compute/docs/instances/specify-min-cpu-
      platform`. Not yet implemented.
    provisioningModel: The provisioning model.
  """

  class ProvisioningModelValueValuesEnum(_messages.Enum):
    r"""The provisioning model.

    Values:
      PROVISIONING_MODEL_UNSPECIFIED: Unspecified.
      STANDARD: Standard VM.
      SPOT: SPOT VM.
      PREEMPTIBLE: Preemptible VM (PVM). Above SPOT VM is the preferable model
        for preemptible VM instances: the old preemptible VM model (indicated
        by this field) is the older model, and has been migrated to use the
        SPOT model as the underlying technology. This old model will still be
        supported.
    """
    PROVISIONING_MODEL_UNSPECIFIED = 0
    STANDARD = 1
    SPOT = 2
    PREEMPTIBLE = 3

  accelerators = _messages.MessageField('Accelerator', 1, repeated=True)
  disks = _messages.MessageField('AttachedDisk', 2, repeated=True)
  machineType = _messages.StringField(3)
  minCpuPlatform = _messages.StringField(4)
  provisioningModel = _messages.EnumField('ProvisioningModelValueValuesEnum', 5)


class InstancePolicyOrTemplate(_messages.Message):
  r"""Either an InstancePolicy or an instance template.

  Fields:
    installGpuDrivers: Set this field true if users want Batch to help fetch
      drivers from a third party location and install them for GPUs specified
      in policy.accelerators or instance_template on their behalf. Default is
      false.
    instanceTemplate: Name of an instance template used to create VMs. Named
      the field as 'instance_template' instead of 'template' to avoid c++
      keyword conflict.
    policy: InstancePolicy.
  """

  installGpuDrivers = _messages.BooleanField(1)
  instanceTemplate = _messages.StringField(2)
  policy = _messages.MessageField('InstancePolicy', 3)


class InstanceStatus(_messages.Message):
  r"""VM instance status.

  Enums:
    ProvisioningModelValueValuesEnum: The VM instance provisioning model.

  Fields:
    machineType: The Compute Engine machine type.
    provisioningModel: The VM instance provisioning model.
    taskPack: The max number of tasks can be assigned to this instance type.
  """

  class ProvisioningModelValueValuesEnum(_messages.Enum):
    r"""The VM instance provisioning model.

    Values:
      PROVISIONING_MODEL_UNSPECIFIED: Unspecified.
      STANDARD: Standard VM.
      SPOT: SPOT VM.
      PREEMPTIBLE: Preemptible VM (PVM). Above SPOT VM is the preferable model
        for preemptible VM instances: the old preemptible VM model (indicated
        by this field) is the older model, and has been migrated to use the
        SPOT model as the underlying technology. This old model will still be
        supported.
    """
    PROVISIONING_MODEL_UNSPECIFIED = 0
    STANDARD = 1
    SPOT = 2
    PREEMPTIBLE = 3

  machineType = _messages.StringField(1)
  provisioningModel = _messages.EnumField('ProvisioningModelValueValuesEnum', 2)
  taskPack = _messages.IntegerField(3)


class Job(_messages.Message):
  r"""The Cloud Batch Job description.

  Messages:
    LabelsValue: Labels for the Job. Labels could be user provided or system
      generated. For example, "labels": { "department": "finance",
      "environment": "test" } You can assign up to 64 labels. [Google Compute
      Engine label
      restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) apply. Label names that start with "goog-" or
      "google-" are reserved.

  Fields:
    allocationPolicy: Compute resource allocation for all TaskGroups in the
      Job.
    createTime: Output only. When the Job was created.
    labels: Labels for the Job. Labels could be user provided or system
      generated. For example, "labels": { "department": "finance",
      "environment": "test" } You can assign up to 64 labels. [Google Compute
      Engine label
      restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) apply. Label names that start with "goog-" or
      "google-" are reserved.
    logsPolicy: Log preservation policy for the Job.
    name: Output only. Job name. For example: "projects/123456/locations/us-
      central1/jobs/job01".
    notifications: Notification configurations.
    priority: Priority of the Job. The valid value range is [0, 100). A job
      with higher priority value is more likely to run earlier if all other
      requirements are satisfied.
    status: Output only. Job status. It is read only for users.
    taskGroups: Required. TaskGroups in the Job. Only one TaskGroup is
      supported now.
    uid: Output only. A system generated unique ID (in UUID4 format) for the
      Job.
    updateTime: Output only. The last time the Job was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels for the Job. Labels could be user provided or system generated.
    For example, "labels": { "department": "finance", "environment": "test" }
    You can assign up to 64 labels. [Google Compute Engine label
    restrictions](https://cloud.google.com/compute/docs/labeling-
    resources#restrictions) apply. Label names that start with "goog-" or
    "google-" are reserved.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allocationPolicy = _messages.MessageField('AllocationPolicy', 1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  logsPolicy = _messages.MessageField('LogsPolicy', 4)
  name = _messages.StringField(5)
  notifications = _messages.MessageField('JobNotification', 6, repeated=True)
  priority = _messages.IntegerField(7)
  status = _messages.MessageField('JobStatus', 8)
  taskGroups = _messages.MessageField('TaskGroup', 9, repeated=True)
  uid = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class JobNotification(_messages.Message):
  r"""Notification configurations.

  Fields:
    message: The attribute requirements of messages to be sent to this Pub/Sub
      topic. Without this field, no message will be sent.
    pubsubTopic: The Pub/Sub topic where notifications like the job state
      changes will be published. This topic exist in the same project as the
      job and billings will be charged to this project. If not specified, no
      Pub/Sub messages will be sent. Topic format:
      `projects/{project}/topics/{topic}`.
  """

  message = _messages.MessageField('Message', 1)
  pubsubTopic = _messages.StringField(2)


class JobStatus(_messages.Message):
  r"""Job status.

  Enums:
    StateValueValuesEnum: Job state

  Messages:
    TaskGroupsValue: Aggregated task status for each TaskGroup in the Job. The
      map key is TaskGroup ID.

  Fields:
    runDuration: The duration of time that the Job spent in status RUNNING.
    state: Job state
    statusEvents: Job status events
    taskGroups: Aggregated task status for each TaskGroup in the Job. The map
      key is TaskGroup ID.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Job state

    Values:
      STATE_UNSPECIFIED: <no description>
      QUEUED: Job is admitted (validated and persisted) and waiting for
        resources.
      SCHEDULED: Job is scheduled to run as soon as resource allocation is
        ready. The resource allocation may happen at a later time but with a
        high chance to succeed.
      RUNNING: Resource allocation has been successful. At least one Task in
        the Job is RUNNING.
      SUCCEEDED: All Tasks in the Job have finished successfully.
      FAILED: At least one Task in the Job has failed.
      DELETION_IN_PROGRESS: The Job will be deleted, but has not been deleted
        yet. Typically this is because resources used by the Job are still
        being cleaned up.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    SCHEDULED = 2
    RUNNING = 3
    SUCCEEDED = 4
    FAILED = 5
    DELETION_IN_PROGRESS = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TaskGroupsValue(_messages.Message):
    r"""Aggregated task status for each TaskGroup in the Job. The map key is
    TaskGroup ID.

    Messages:
      AdditionalProperty: An additional property for a TaskGroupsValue object.

    Fields:
      additionalProperties: Additional properties of type TaskGroupsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TaskGroupsValue object.

      Fields:
        key: Name of the additional property.
        value: A TaskGroupStatus attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TaskGroupStatus', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  runDuration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  statusEvents = _messages.MessageField('StatusEvent', 3, repeated=True)
  taskGroups = _messages.MessageField('TaskGroupsValue', 4)


class LifecyclePolicy(_messages.Message):
  r"""LifecyclePolicy describes how to deal with task failures based on
  different conditions.

  Enums:
    ActionValueValuesEnum: Action to execute when ActionCondition is true.

  Fields:
    action: Action to execute when ActionCondition is true.
    actionCondition: Conditions that decide why a task failure is dealt with a
      specific action.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Action to execute when ActionCondition is true.

    Values:
      ACTION_UNSPECIFIED: Action unspecified.
      RETRY_TASK: Action that tasks in the group will be scheduled to re-
        execute.
      FAIL_TASK: Action that tasks in the group will be stopped immediately.
    """
    ACTION_UNSPECIFIED = 0
    RETRY_TASK = 1
    FAIL_TASK = 2

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  actionCondition = _messages.MessageField('ActionCondition', 2)


class ListJobsResponse(_messages.Message):
  r"""ListJob Response.

  Fields:
    jobs: Jobs.
    nextPageToken: Next page token.
    unreachable: Locations that could not be reached.
  """

  jobs = _messages.MessageField('Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListTasksResponse(_messages.Message):
  r"""ListTasks Response.

  Fields:
    nextPageToken: Next page token.
    tasks: Tasks.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  tasks = _messages.MessageField('Task', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationPolicy(_messages.Message):
  r"""A LocationPolicy object.

  Fields:
    allowedLocations: A list of allowed location names represented by internal
      URLs. Each location can be a region or a zone. Only one region or
      multiple zones in one region is supported now. For example,
      ["regions/us-central1"] allow VMs in any zones in region us-central1.
      ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs in zones
      us-central1-a and us-central1-c. All locations end up in different
      regions would cause errors. For example, ["regions/us-central1",
      "zones/us-central1-a", "zones/us-central1-b", "zones/us-west1-a"]
      contains 2 regions "us-central1" and "us-west1". An error is expected in
      this case.
  """

  allowedLocations = _messages.StringField(1, repeated=True)


class LogsPolicy(_messages.Message):
  r"""LogsPolicy describes how outputs from a Job's Tasks (stdout/stderr) will
  be preserved.

  Enums:
    DestinationValueValuesEnum: Where logs should be saved.

  Fields:
    destination: Where logs should be saved.
    logsPath: The path to which logs are saved when the destination = PATH.
      This can be a local file path on the VM, or under the mount point of a
      Persistent Disk or Filestore, or a Cloud Storage path.
  """

  class DestinationValueValuesEnum(_messages.Enum):
    r"""Where logs should be saved.

    Values:
      DESTINATION_UNSPECIFIED: Logs are not preserved.
      CLOUD_LOGGING: Logs are streamed to Cloud Logging.
      PATH: Logs are saved to a file path.
    """
    DESTINATION_UNSPECIFIED = 0
    CLOUD_LOGGING = 1
    PATH = 2

  destination = _messages.EnumField('DestinationValueValuesEnum', 1)
  logsPath = _messages.StringField(2)


class Message(_messages.Message):
  r"""Message details. Describe the attribute that a message should have.
  Without specified message attributes, no message will be sent by default.

  Enums:
    NewJobStateValueValuesEnum: The new job state.
    NewTaskStateValueValuesEnum: The new task state.
    TypeValueValuesEnum: The message type.

  Fields:
    newJobState: The new job state.
    newTaskState: The new task state.
    type: The message type.
  """

  class NewJobStateValueValuesEnum(_messages.Enum):
    r"""The new job state.

    Values:
      STATE_UNSPECIFIED: <no description>
      QUEUED: Job is admitted (validated and persisted) and waiting for
        resources.
      SCHEDULED: Job is scheduled to run as soon as resource allocation is
        ready. The resource allocation may happen at a later time but with a
        high chance to succeed.
      RUNNING: Resource allocation has been successful. At least one Task in
        the Job is RUNNING.
      SUCCEEDED: All Tasks in the Job have finished successfully.
      FAILED: At least one Task in the Job has failed.
      DELETION_IN_PROGRESS: The Job will be deleted, but has not been deleted
        yet. Typically this is because resources used by the Job are still
        being cleaned up.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    SCHEDULED = 2
    RUNNING = 3
    SUCCEEDED = 4
    FAILED = 5
    DELETION_IN_PROGRESS = 6

  class NewTaskStateValueValuesEnum(_messages.Enum):
    r"""The new task state.

    Values:
      STATE_UNSPECIFIED: unknown state
      PENDING: The Task is created and waiting for resources.
      ASSIGNED: The Task is assigned to at least one VM.
      RUNNING: The Task is running.
      FAILED: The Task has failed.
      SUCCEEDED: The Task has succeeded.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    ASSIGNED = 2
    RUNNING = 3
    FAILED = 4
    SUCCEEDED = 5

  class TypeValueValuesEnum(_messages.Enum):
    r"""The message type.

    Values:
      TYPE_UNSPECIFIED: Unspecified.
      JOB_STATE_CHANGED: Notify users that the job state has changed.
      TASK_STATE_CHANGED: Notify users that the task state has changed.
    """
    TYPE_UNSPECIFIED = 0
    JOB_STATE_CHANGED = 1
    TASK_STATE_CHANGED = 2

  newJobState = _messages.EnumField('NewJobStateValueValuesEnum', 1)
  newTaskState = _messages.EnumField('NewTaskStateValueValuesEnum', 2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class NFS(_messages.Message):
  r"""Represents an NFS volume.

  Fields:
    remotePath: Remote source path exported from the NFS, e.g., "/share".
    server: The IP address of the NFS.
  """

  remotePath = _messages.StringField(1)
  server = _messages.StringField(2)


class NetworkInterface(_messages.Message):
  r"""A network interface.

  Fields:
    network: The URL of the network resource.
    noExternalIpAddress: Default is false (with an external IP address).
      Required if no external public IP address is attached to the VM. If no
      external public IP address, additional configuration is required to
      allow the VM to access Google Services. See
      https://cloud.google.com/vpc/docs/configure-private-google-access and
      https://cloud.google.com/nat/docs/gce-example#create-nat for more
      information.
    subnetwork: The URL of the Subnetwork resource.
  """

  network = _messages.StringField(1)
  noExternalIpAddress = _messages.BooleanField(2)
  subnetwork = _messages.StringField(3)


class NetworkPolicy(_messages.Message):
  r"""NetworkPolicy describes VM instance network configurations.

  Fields:
    networkInterfaces: Network configurations.
  """

  networkInterfaces = _messages.MessageField('NetworkInterface', 1, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Runnable(_messages.Message):
  r"""Runnable describes instructions for executing a specific script or
  container as part of a Task.

  Fields:
    alwaysRun: By default, after a Runnable fails, no further Runnable are
      executed. This flag indicates that this Runnable must be run even if the
      Task has already failed. This is useful for Runnables that copy output
      files off of the VM or for debugging. The always_run flag does not
      override the Task's overall max_run_duration. If the max_run_duration
      has expired then no further Runnables will execute, not even always_run
      Runnables.
    background: This flag allows a Runnable to continue running in the
      background while the Task executes subsequent Runnables. This is useful
      to provide services to other Runnables (or to provide debugging support
      tools like SSH servers).
    barrier: Barrier runnable.
    container: Container runnable.
    environment: Environment variables for this Runnable (overrides variables
      set for the whole Task or TaskGroup).
    ignoreExitStatus: Normally, a non-zero exit status causes the Task to
      fail. This flag allows execution of other Runnables to continue instead.
    script: Script runnable.
    timeout: Timeout for this Runnable.
  """

  alwaysRun = _messages.BooleanField(1)
  background = _messages.BooleanField(2)
  barrier = _messages.MessageField('Barrier', 3)
  container = _messages.MessageField('Container', 4)
  environment = _messages.MessageField('Environment', 5)
  ignoreExitStatus = _messages.BooleanField(6)
  script = _messages.MessageField('Script', 7)
  timeout = _messages.StringField(8)


class Script(_messages.Message):
  r"""Script runnable.

  Fields:
    path: Script file path on the host VM.
    text: Shell script text.
  """

  path = _messages.StringField(1)
  text = _messages.StringField(2)


class ServiceAccount(_messages.Message):
  r"""Carries information about a Google Cloud service account.

  Fields:
    email: Email address of the service account. If not specified, the default
      Compute Engine service account for the project will be used. If instance
      template is being used, the service account has to be specified in the
      instance template and it has to match the email field here.
  """

  email = _messages.StringField(1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StatusEvent(_messages.Message):
  r"""Status event

  Fields:
    description: Description of the event.
    eventTime: The time this event occurred.
    taskExecution: Task Execution
    type: Type of the event.
  """

  description = _messages.StringField(1)
  eventTime = _messages.StringField(2)
  taskExecution = _messages.MessageField('TaskExecution', 3)
  type = _messages.StringField(4)


class Task(_messages.Message):
  r"""A Cloud Batch task.

  Fields:
    name: Task name. The name is generated from the parent TaskGroup name and
      'id' field. For example: "projects/123456/locations/us-
      west1/jobs/job01/taskGroups/group01/tasks/task01".
    status: Task Status.
  """

  name = _messages.StringField(1)
  status = _messages.MessageField('TaskStatus', 2)


class TaskExecution(_messages.Message):
  r"""This Task Execution field includes detail information for task execution
  procedures, based on StatusEvent types.

  Fields:
    exitCode: When task is completed as the status of FAILED or SUCCEEDED,
      exit code is for one task execution result, default is 0 as success.
  """

  exitCode = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class TaskGroup(_messages.Message):
  r"""A TaskGroup contains one or multiple Tasks that share the same Runnable
  but with different runtime parameters.

  Fields:
    name: Output only. TaskGroup name. The system generates this field based
      on parent Job name. For example: "projects/123456/locations/us-
      west1/jobs/job01/taskGroups/group01".
    parallelism: Max number of tasks that can run in parallel. Default to
      min(task_count, 1000).
    permissiveSsh: When true, Batch will configure SSH to allow passwordless
      login between VMs running the Batch tasks in the same TaskGroup.
    requireHostsFile: When true, Batch will populate a file with a list of all
      VMs assigned to the TaskGroup and set the BATCH_HOSTS_FILE environment
      variable to the path of that file. Defaults to false.
    taskCount: Number of Tasks in the TaskGroup. default is 1
    taskCountPerNode: Max number of tasks that can be run on a VM at the same
      time. If not specified, the system will decide a value based on
      available compute resources on a VM and task requirements.
    taskEnvironments: An array of environment variable mappings, which are
      passed to Tasks with matching indices. If task_environments is used then
      task_count should not be specified in the request (and will be ignored).
      Task count will be the length of task_environments. Tasks get a
      BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in addition
      to any environment variables set in task_environments, specifying the
      number of Tasks in the Task's parent TaskGroup, and the specific Task's
      index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
      task_environments supports up to 200 entries.
    taskSpec: Required. Tasks in the group share the same task spec.
  """

  name = _messages.StringField(1)
  parallelism = _messages.IntegerField(2)
  permissiveSsh = _messages.BooleanField(3)
  requireHostsFile = _messages.BooleanField(4)
  taskCount = _messages.IntegerField(5)
  taskCountPerNode = _messages.IntegerField(6)
  taskEnvironments = _messages.MessageField('Environment', 7, repeated=True)
  taskSpec = _messages.MessageField('TaskSpec', 8)


class TaskGroupStatus(_messages.Message):
  r"""Aggregated task status for a TaskGroup.

  Messages:
    CountsValue: Count of task in each state in the TaskGroup. The map key is
      task state name.

  Fields:
    counts: Count of task in each state in the TaskGroup. The map key is task
      state name.
    instances: Status of instances allocated for the TaskGroup.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CountsValue(_messages.Message):
    r"""Count of task in each state in the TaskGroup. The map key is task
    state name.

    Messages:
      AdditionalProperty: An additional property for a CountsValue object.

    Fields:
      additionalProperties: Additional properties of type CountsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a CountsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  counts = _messages.MessageField('CountsValue', 1)
  instances = _messages.MessageField('InstanceStatus', 2, repeated=True)


class TaskSpec(_messages.Message):
  r"""Spec of a task

  Messages:
    EnvironmentsValue: Environment variables to set before running the Task.
      You can set up to 100 environments.

  Fields:
    computeResource: ComputeResource requirements.
    environment: Environment variables to set before running the Task.
    environments: Environment variables to set before running the Task. You
      can set up to 100 environments.
    lifecyclePolicies: Lifecycle management schema when any task in a task
      group is failed. The valid size of lifecycle policies are [0, 10]. For
      each lifecycle policy, when the condition is met, the action in that
      policy will execute. If there are multiple policies that the task
      execution result matches, we use the action from the first matched
      policy. If task execution result does not meet with any of the defined
      lifecycle policy, we consider it as the default policy. Default policy
      means if the exit code is 0, exit task. If task ends with non-zero exit
      code, retry the task with max_retry_count.
    maxRetryCount: Maximum number of retries on failures. The default, 0,
      which means never retry. The valid value range is [0, 10].
    maxRunDuration: Maximum duration the task should run. The task will be
      killed and marked as FAILED if over this limit.
    runnables: The sequence of scripts or containers to run for this Task.
      Each Task using this TaskSpec executes its list of runnables in order.
      The Task succeeds if all of its runnables either exit with a zero status
      or any that exit with a non-zero status have the ignore_exit_status
      flag. Background runnables are killed automatically (if they have not
      already exited) a short time after all foreground runnables have
      completed. Even though this is likely to result in a non-zero exit
      status for the background runnable, these automatic kills are not
      treated as Task failures.
    volumes: Volumes to mount before running Tasks using this TaskSpec.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvironmentsValue(_messages.Message):
    r"""Environment variables to set before running the Task. You can set up
    to 100 environments.

    Messages:
      AdditionalProperty: An additional property for a EnvironmentsValue
        object.

    Fields:
      additionalProperties: Additional properties of type EnvironmentsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvironmentsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  computeResource = _messages.MessageField('ComputeResource', 1)
  environment = _messages.MessageField('Environment', 2)
  environments = _messages.MessageField('EnvironmentsValue', 3)
  lifecyclePolicies = _messages.MessageField('LifecyclePolicy', 4, repeated=True)
  maxRetryCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxRunDuration = _messages.StringField(6)
  runnables = _messages.MessageField('Runnable', 7, repeated=True)
  volumes = _messages.MessageField('Volume', 8, repeated=True)


class TaskStatus(_messages.Message):
  r"""Status of a task

  Enums:
    StateValueValuesEnum: Task state

  Fields:
    state: Task state
    statusEvents: Detailed info about why the state is reached.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Task state

    Values:
      STATE_UNSPECIFIED: unknown state
      PENDING: The Task is created and waiting for resources.
      ASSIGNED: The Task is assigned to at least one VM.
      RUNNING: The Task is running.
      FAILED: The Task has failed.
      SUCCEEDED: The Task has succeeded.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    ASSIGNED = 2
    RUNNING = 3
    FAILED = 4
    SUCCEEDED = 5

  state = _messages.EnumField('StateValueValuesEnum', 1)
  statusEvents = _messages.MessageField('StatusEvent', 2, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Volume(_messages.Message):
  r"""Volume describes a volume and parameters for it to be mounted to a VM.

  Fields:
    deviceName: Device name of an attached disk volume, which should align
      with a device_name specified by
      job.allocation_policy.instances[0].policy.disks[i].device_name or
      defined by the given instance template in
      job.allocation_policy.instances[0].instance_template.
    gcs: A Google Cloud Storage (GCS) volume.
    mountOptions: For Google Cloud Storage (GCS), mount options are the
      options supported by the gcsfuse tool
      (https://github.com/GoogleCloudPlatform/gcsfuse). For existing
      persistent disks, mount options provided by the mount command
      (https://man7.org/linux/man-pages/man8/mount.8.html) except writing are
      supported. This is due to restrictions of multi-writer mode
      (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
      For other attached disks and Network File System (NFS), mount options
      are these supported by the mount command (https://man7.org/linux/man-
      pages/man8/mount.8.html).
    mountPath: The mount path for the volume, e.g. /mnt/disks/share.
    nfs: A Network File System (NFS) volume. For example, a Filestore file
      share.
  """

  deviceName = _messages.StringField(1)
  gcs = _messages.MessageField('GCS', 2)
  mountOptions = _messages.StringField(3, repeated=True)
  mountPath = _messages.StringField(4)
  nfs = _messages.MessageField('NFS', 5)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
