"""Generated message classes for networkservices version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'networkservices'


class AWSV4Signature(_messages.Message):
  r"""The configuration needed to generate an AWS V4 Signature

  Fields:
    accessKeyId: Required. The access key ID your origin uses to identify the
      key.
    originRegion: Required. The name of the AWS region that your origin is in.
    secretAccessKeyVersion: Required. The Secret Manager secret version of the
      secret access key used by your origin. This is the resource name of the
      secret version in the format `projects/*/secrets/*/versions/*` where the
      `*` values are replaced by the project, secret, and version you require.
  """

  accessKeyId = _messages.StringField(1)
  originRegion = _messages.StringField(2)
  secretAccessKeyVersion = _messages.StringField(3)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CDNPolicy(_messages.Message):
  r"""The `CDNPolicy` to apply to the configured route.

  Enums:
    CacheModeValueValuesEnum: Optional. Set the CacheMode used by this route.
      BYPASS_CACHE and USE_ORIGIN_HEADERS proxy the origin's headers. Other
      cache modes pass Cache-Control to the client. Use client_ttl to override
      what is sent to the client.
    SignedRequestModeValueValuesEnum: Optional. Whether to enforce signed
      requests. The default value is DISABLED, which means all content is
      public, and does not authorize access. You must also set a
      signed_request_keyset to enable signed requests. When set to
      REQUIRE_SIGNATURES or REQUIRE_TOKENS, all matching requests get their
      signature validated. Requests that aren't signed with the corresponding
      private key, or that are otherwise invalid (such as expired or do not
      match the signature, IP address, or header) are rejected with a HTTP
      403. If logging is turned on, then invalid requests are also logged.

  Messages:
    NegativeCachingPolicyValue: Optional. Sets a cache TTL for the specified
      HTTP status code. negative_caching must be enabled to configure
      `negative_caching_policy`. The following limitations apply: - Omitting
      the policy and leaving `negative_caching` enabled uses the default TTLs
      for each status code, defined in `negative_caching`. - TTLs must be >=
      `0` (where `0` is "always revalidate") and <= `86400s` (1 day) Only the
      following status codes may be set: - HTTP redirection (3xx) - Client
      error (4xx) - Server error (5xx) When you specify an explicit
      `negative_caching_policy`, ensure that you also specify a cache TTL for
      all response codes that you wish to cache. The CDNPolicy doesn't apply
      any default negative caching when a policy exists.

  Fields:
    addSignatures: Optional. Enable signature generation or propagation on
      this route. This field may only be specified when signed_request_mode is
      set to REQUIRE_TOKENS.
    cacheKeyPolicy: Optional. Defines the request parameters that contribute
      to the cache key.
    cacheMode: Optional. Set the CacheMode used by this route. BYPASS_CACHE
      and USE_ORIGIN_HEADERS proxy the origin's headers. Other cache modes
      pass Cache-Control to the client. Use client_ttl to override what is
      sent to the client.
    clientTtl: Optional. Specifies a separate client (such as browser client)
      TTL, separate from the TTL used by the edge caches. Leaving this empty
      uses the same cache TTL for both the CDN and the client-facing response.
      - The TTL must be > `0` and <= `86400s` (1 day) - The `client_ttl`
      cannot be larger than the default_ttl (if set) - Fractions of a second
      are not allowed. Omit this field to use the `default_ttl`, or the max-
      age set by the origin, as the client-facing TTL. When the CacheMode is
      set to USE_ORIGIN_HEADERS or BYPASS_CACHE, you must omit this field.
    defaultTtl: Optional. Specifies the default TTL for cached content served
      by this origin for responses that do not have an existing valid TTL
      (max-age or s-max-age). Defaults to `3600s` (1 hour). - The TTL must be
      >= `0` and <= `31,536,000` seconds (1 year) - Setting a TTL of `0` means
      "always revalidate" (equivalent to must-revalidate) - The value of
      `default_ttl` cannot be set to a value greater than that of max_ttl. -
      Fractions of a second are not allowed. - When the CacheMode is set to
      FORCE_CACHE_ALL, the `default_ttl` overwrites the TTL set in all
      responses. Infrequently accessed objects may be evicted from the cache
      before the defined TTL. Objects that expire are revalidated with the
      origin. When the CacheMode is set to USE_ORIGIN_HEADERS or BYPASS_CACHE,
      you must omit this field.
    maxTtl: Optional. Specifies the maximum allowed TTL for cached content
      served by this origin. Defaults to `86400s` (1 day). Cache directives
      that attempt to set a max-age or s-maxage higher than this, or an
      Expires header more than `max_ttl` seconds in the future are capped at
      the value of `max_ttl`, as if it were the value of an s-maxage Cache-
      Control directive. - The TTL must be >= `0` and <= `31,536,000` seconds
      (1 year) - Setting a TTL of `0` means "always revalidate" - The value of
      `max_ttl` must be equal to or greater than default_ttl. - Fractions of a
      second are not allowed. When the CacheMode is set to
      [USE_ORIGIN_HEADERS].[CacheMode.USE_ORIGIN_HEADERS], FORCE_CACHE_ALL, or
      BYPASS_CACHE, you must omit this field.
    negativeCaching: Optional. Negative caching allows setting per-status code
      TTLs, in order to apply fine-grained caching for common errors or
      redirects. This can reduce the load on your origin and improve end-user
      experience by reducing response latency. By default, the CDNPolicy
      applies the following default TTLs to these status codes: - **10m**:
      HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects) - **120s**:
      HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons) -
      **60s**: HTTP 405 (Method Not Found), 501 (Not Implemented) These
      defaults can be overridden in negative_caching_policy
    negativeCachingPolicy: Optional. Sets a cache TTL for the specified HTTP
      status code. negative_caching must be enabled to configure
      `negative_caching_policy`. The following limitations apply: - Omitting
      the policy and leaving `negative_caching` enabled uses the default TTLs
      for each status code, defined in `negative_caching`. - TTLs must be >=
      `0` (where `0` is "always revalidate") and <= `86400s` (1 day) Only the
      following status codes may be set: - HTTP redirection (3xx) - Client
      error (4xx) - Server error (5xx) When you specify an explicit
      `negative_caching_policy`, ensure that you also specify a cache TTL for
      all response codes that you wish to cache. The CDNPolicy doesn't apply
      any default negative caching when a policy exists.
    signedRequestKeyset: Optional. The EdgeCacheKeyset containing the set of
      public keys used to validate signed requests at the edge. The following
      are both valid paths to an `EdgeCacheKeyset` resource: *
      `projects/project/locations/global/edgeCacheKeysets/yourKeyset` *
      `yourKeyset` SignedRequestMode must be set to a value other than
      DISABLED when a keyset is provided.
    signedRequestMaximumExpirationTtl: Optional. Limit how far into the future
      the expiration time of a signed request may be. When set, a signed
      request is rejected if its expiration time is later than `now` +
      `signed_request_maximum_expiration_ttl`, where `now` is the time at
      which the signed request is first handled by the CDN. - The TTL must be
      > 0. - Fractions of a second are not allowed. By default,
      `signed_requess_maximum_expiration_ttl` is not set and the expiration
      time of a signed request may be arbitrarily far into future.
    signedRequestMode: Optional. Whether to enforce signed requests. The
      default value is DISABLED, which means all content is public, and does
      not authorize access. You must also set a signed_request_keyset to
      enable signed requests. When set to REQUIRE_SIGNATURES or
      REQUIRE_TOKENS, all matching requests get their signature validated.
      Requests that aren't signed with the corresponding private key, or that
      are otherwise invalid (such as expired or do not match the signature, IP
      address, or header) are rejected with a HTTP 403. If logging is turned
      on, then invalid requests are also logged.
    signedTokenOptions: Optional. Additional options for signed tokens.
      `signed_token_options` may only be specified when `signed_request_mode`
      is `REQUIRE_TOKENS`.
  """

  class CacheModeValueValuesEnum(_messages.Enum):
    r"""Optional. Set the CacheMode used by this route. BYPASS_CACHE and
    USE_ORIGIN_HEADERS proxy the origin's headers. Other cache modes pass
    Cache-Control to the client. Use client_ttl to override what is sent to
    the client.

    Values:
      CACHE_MODE_UNSPECIFIED: Unspecified value. Defaults to
        `CACHE_ALL_STATIC`.
      CACHE_ALL_STATIC: Automatically cache static content, including common
        image formats, media (video & audio), web assets (JavaScript & CSS).
        Requests and responses that are marked as uncacheable, as well as
        dynamic content (including HTML), aren't cached.
      USE_ORIGIN_HEADERS: Only cache responses with valid HTTP caching
        directives. Responses without these headers aren't cached at Google's
        edge, and require a full trip to the origin on every request,
        potentially impacting performance and increasing load on the origin
        server.
      FORCE_CACHE_ALL: Cache all content, ignoring any `private`, `no-store`
        or `no-cache` directives in Cache-Control response headers.
        **Warning:** this may result in caching private, per-user (user
        identifiable) content. Only enable this on routes where the
        EdgeCacheOrigin doesn't serve private or dynamic content, such as
        storage buckets.
      BYPASS_CACHE: Bypass all caching for requests that match routes with
        this CDNPolicy applied. Enabling this causes the edge cache to ignore
        all HTTP caching directives. All responses are fulfilled from the
        origin.
    """
    CACHE_MODE_UNSPECIFIED = 0
    CACHE_ALL_STATIC = 1
    USE_ORIGIN_HEADERS = 2
    FORCE_CACHE_ALL = 3
    BYPASS_CACHE = 4

  class SignedRequestModeValueValuesEnum(_messages.Enum):
    r"""Optional. Whether to enforce signed requests. The default value is
    DISABLED, which means all content is public, and does not authorize
    access. You must also set a signed_request_keyset to enable signed
    requests. When set to REQUIRE_SIGNATURES or REQUIRE_TOKENS, all matching
    requests get their signature validated. Requests that aren't signed with
    the corresponding private key, or that are otherwise invalid (such as
    expired or do not match the signature, IP address, or header) are rejected
    with a HTTP 403. If logging is turned on, then invalid requests are also
    logged.

    Values:
      SIGNED_REQUEST_MODE_UNSPECIFIED: Unspecified value. Defaults to
        `DISABLED`.
      DISABLED: Do not enforce signed requests.
      REQUIRE_SIGNATURES: Enforce signed requests using query parameter, path
        component, or cookie signatures. All requests must have a valid
        signature. Requests that are missing the signature (URL or cookie-
        based) are rejected as if the signature was invalid.
      REQUIRE_TOKENS: Enforce signed requests using signed tokens. All
        requests must have a valid signed token. Requests that are missing a
        signed token (URL or cookie-based) are rejected as if the signed token
        was invalid.
    """
    SIGNED_REQUEST_MODE_UNSPECIFIED = 0
    DISABLED = 1
    REQUIRE_SIGNATURES = 2
    REQUIRE_TOKENS = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NegativeCachingPolicyValue(_messages.Message):
    r"""Optional. Sets a cache TTL for the specified HTTP status code.
    negative_caching must be enabled to configure `negative_caching_policy`.
    The following limitations apply: - Omitting the policy and leaving
    `negative_caching` enabled uses the default TTLs for each status code,
    defined in `negative_caching`. - TTLs must be >= `0` (where `0` is "always
    revalidate") and <= `86400s` (1 day) Only the following status codes may
    be set: - HTTP redirection (3xx) - Client error (4xx) - Server error (5xx)
    When you specify an explicit `negative_caching_policy`, ensure that you
    also specify a cache TTL for all response codes that you wish to cache.
    The CDNPolicy doesn't apply any default negative caching when a policy
    exists.

    Messages:
      AdditionalProperty: An additional property for a
        NegativeCachingPolicyValue object.

    Fields:
      additionalProperties: Additional properties of type
        NegativeCachingPolicyValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NegativeCachingPolicyValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  addSignatures = _messages.MessageField('CDNPolicyAddSignaturesOptions', 1)
  cacheKeyPolicy = _messages.MessageField('CDNPolicyCacheKeyPolicy', 2)
  cacheMode = _messages.EnumField('CacheModeValueValuesEnum', 3)
  clientTtl = _messages.StringField(4)
  defaultTtl = _messages.StringField(5)
  maxTtl = _messages.StringField(6)
  negativeCaching = _messages.BooleanField(7)
  negativeCachingPolicy = _messages.MessageField('NegativeCachingPolicyValue', 8)
  signedRequestKeyset = _messages.StringField(9)
  signedRequestMaximumExpirationTtl = _messages.StringField(10)
  signedRequestMode = _messages.EnumField('SignedRequestModeValueValuesEnum', 11)
  signedTokenOptions = _messages.MessageField('CDNPolicySignedTokenOptions', 12)


class CDNPolicyAddSignaturesOptions(_messages.Message):
  r"""Configuration options for adding signatures to responses.

  Enums:
    ActionsValueListEntryValuesEnum:

  Fields:
    actions: Required. The actions to take to add signatures to responses. You
      must specify exactly one action.
    copiedParameters: Optional. The parameters to copy from the verified token
      to the generated token. Only the following parameters may be copied: *
      `PathGlobs` * `paths` * `acl` * `URLPrefix` * `IPRanges` * `SessionID` *
      `id` * `Data` * `data` * `payload` * `Headers` You may specify up to 6
      parameters to copy. A given parameter is be copied only if the parameter
      exists in the verified token. Parameter names are matched exactly as
      specified. The order of the parameters does not matter. Duplicates are
      not allowed. This field may only be specified when the `GENERATE_COOKIE`
      or `GENERATE_TOKEN_HLS_COOKIELESS` actions are specified.
    keyset: Optional. The keyset to use for signature generation. The
      following are both valid paths to an EdgeCacheKeyset resource: *
      `projects/project/locations/global/edgeCacheKeysets/yourKeyset` *
      `yourKeyset` This must be specified when the `GENERATE_COOKIE` or
      `GENERATE_TOKEN_HLS_COOKIELESS` actions are specified. This field may
      not be specified otherwise.
    tokenQueryParameter: Optional. The query parameter in which to put the
      generated token. If not specified, defaults to `edge-cache-token`. If
      specified, the name must be 1-64 characters long and match the regular
      expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first character
      must be a letter, and all following characters must be a dash,
      underscore, letter or digit. This field may only be set when the
      `GENERATE_TOKEN_HLS_COOKIELESS` or `PROPAGATE_TOKEN_HLS_COOKIELESS`
      actions are specified.
    tokenTtl: Optional. The duration the token is valid starting from the
      moment the token is first generated. Defaults to `86400s` (1 day). The
      TTL must be >= 0 and <= 604,800 seconds (1 week). This field may only be
      specified when the `GENERATE_COOKIE` or `GENERATE_TOKEN_HLS_COOKIELESS`
      actions are specified.
  """

  class ActionsValueListEntryValuesEnum(_messages.Enum):
    r"""ActionsValueListEntryValuesEnum enum type.

    Values:
      SIGNATURE_ACTION_UNSPECIFIED: It is an error to specify `UNSPECIFIED`.
      GENERATE_COOKIE: Generate a new signed request cookie and return the
        cookie in a Set-Cookie header of the response. This action cannot be
        combined with the `PROPAGATE_TOKEN_HLS_COOKIELESS` action.
      GENERATE_TOKEN_HLS_COOKIELESS: Generate a new signed request
        authentication token and return the new token by manipulating URLs in
        an HTTP Live Stream (HLS) playlist. This action cannot be combined
        with the `PROPAGATE_TOKEN_HLS_COOKIELESS` action.
      PROPAGATE_TOKEN_HLS_COOKIELESS: Copy the authentication token used in
        the request to the URLs in an HTTP Live Stream (HLS) playlist. This
        action cannot be combined with either the `GENERATE_COOKIE` action or
        the `GENERATE_TOKEN_HLS_COOKIELESS` action.
    """
    SIGNATURE_ACTION_UNSPECIFIED = 0
    GENERATE_COOKIE = 1
    GENERATE_TOKEN_HLS_COOKIELESS = 2
    PROPAGATE_TOKEN_HLS_COOKIELESS = 3

  actions = _messages.EnumField('ActionsValueListEntryValuesEnum', 1, repeated=True)
  copiedParameters = _messages.StringField(2, repeated=True)
  keyset = _messages.StringField(3)
  tokenQueryParameter = _messages.StringField(4)
  tokenTtl = _messages.StringField(5)


class CDNPolicyCacheKeyPolicy(_messages.Message):
  r"""Defines the request parameters that contribute to the cache key.

  Fields:
    excludeHost: Optional. If `true`, requests to different hosts are cached
      separately. **Important:** Enable this only if the hosts share the same
      origin and content. Removing the host from the cache key may
      inadvertently result in different objects being cached than intended,
      depending on which route the first user matched.
    excludeQueryString: Optional. If `true`, exclude query string parameters
      from the cache key. If `false` (the default), include the query string
      parameters in the cache key according to included_query_parameters and
      excluded_query_parameters. If neither is set, the entire query string is
      included.
    excludedQueryParameters: Optional. Names of query string parameters to
      exclude from cache keys. All other parameters are included. Either
      specify included_query_parameters or excluded_query_parameters, not
      both. `&` and `=` are percent encoded and not treated as delimiters. You
      may exclude up to 10 query parameters. Each query parameter name must be
      between 1 and 32 characters long (inclusive).
    includeProtocol: Optional. If `true`, HTTP and HTTPS requests are cached
      separately.
    includedCookieNames: Optional. Names of cookies to include in cache keys.
      The cookie name and cookie value of each cookie named is used as part of
      the cache key. The following limitations apply: - Must be valid RFC 6265
      "cookie-name" tokens - Are case sensitive - Cannot start with "Edge-
      Cache-" (case insensitive) Specifying several cookies or cookies that
      have a large range of values, such as per-user, dramatically impacts the
      cache hit rate, and may result in a higher eviction rate and reduced
      performance. You may specify up to three cookie names.
    includedHeaderNames: Optional. Names of HTTP request headers to include in
      cache keys. The value of the header field is used as part of the cache
      key. The following limitations apply: - Header names must be valid HTTP
      RFC 7230 header field values. - Header field names are case insensitive
      - You may specify up to five header names. - To include the HTTP method,
      use `:method` Refer to the documentation for the allowed list of header
      names. Specifying several headers or headers that have a large range of
      values, such as per-user, dramatically impacts the cache hit rate, and
      may result in a higher eviction rate and reduced performance.
    includedQueryParameters: Optional. Names of query string parameters to
      include in cache keys. All other parameters are excluded. Either specify
      included_query_parameters or excluded_query_parameters, not both. `&`
      and `=` are percent encoded and not treated as delimiters. You may
      include up to 10 query parameters. Each query parameter name must be
      between 1 and 32 characters long (inclusive).
  """

  excludeHost = _messages.BooleanField(1)
  excludeQueryString = _messages.BooleanField(2)
  excludedQueryParameters = _messages.StringField(3, repeated=True)
  includeProtocol = _messages.BooleanField(4)
  includedCookieNames = _messages.StringField(5, repeated=True)
  includedHeaderNames = _messages.StringField(6, repeated=True)
  includedQueryParameters = _messages.StringField(7, repeated=True)


class CDNPolicySignedTokenOptions(_messages.Message):
  r"""Configuration options for signed tokens.

  Enums:
    AllowedSignatureAlgorithmsValueListEntryValuesEnum:

  Fields:
    allowedSignatureAlgorithms: Optional. The allowed signature algorithms to
      use. Defaults to using only ED25519. You may specify up to 3 signature
      algorithms to use.
    tokenQueryParameter: Optional. The query parameter in which to find the
      token. The name must be 1-64 characters long and match the regular
      expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first character
      must be a letter, and all following characters must be a dash,
      underscore, letter or digit. Defaults to `edge-cache-token`.
  """

  class AllowedSignatureAlgorithmsValueListEntryValuesEnum(_messages.Enum):
    r"""AllowedSignatureAlgorithmsValueListEntryValuesEnum enum type.

    Values:
      SIGNATURE_ALGORITHM_UNSPECIFIED: It is an error to specify
        ALGORITHM_UNSPECIFIED.
      ED25519: Use an Ed25519 signature scheme. The signature must be
        specified in the signature field of the token.
      HMAC_SHA_256: Use an HMAC based on a SHA-256 hash. The HMAC must be
        specified in the hmac field of the token.
      HMAC_SHA1: Use an HMAC based on a SHA1 hash. The HMAC must be specified
        in the hmac field of the token.
    """
    SIGNATURE_ALGORITHM_UNSPECIFIED = 0
    ED25519 = 1
    HMAC_SHA_256 = 2
    HMAC_SHA1 = 3

  allowedSignatureAlgorithms = _messages.EnumField('AllowedSignatureAlgorithmsValueListEntryValuesEnum', 1, repeated=True)
  tokenQueryParameter = _messages.StringField(2)


class CORSPolicy(_messages.Message):
  r"""`CORSPolicy` defines Cross-Origin-Resource-Sharing configuration,
  including which CORS response headers are set.

  Fields:
    allowCredentials: Optional. In response to a preflight request, setting
      this to `true` indicates that the actual request can include user
      credentials. This translates to the Access-Control-Allow-Credentials
      response header.
    allowHeaders: Optional. Specifies the content for the Access-Control-
      Allow-Headers response header. You may specify up to 5 headers to
      include in the Access-Control-Allow-Headers header.
    allowMethods: Optional. Specifies the content for the Access-Control-
      Allow-Methods response header. You may specify up to 5 allowed methods.
    allowOrigins: Optional. Specifies the list of origins that are allowed to
      do CORS requests. This translates to the Access-Control-Allow-Origin
      response header. You may specify up to 25 allowed origins.
    disabled: Optional. If `true`, specifies the CORS policy is disabled. The
      default value is `false`, which indicates that the CORS policy is in
      effect.
    exposeHeaders: Optional. Specifies the content for the Access-Control-
      Expose-Headers response header. You may specify up to 5 headers to
      expose in the Access-Control-Expose-Headers header.
    maxAge: Required. Specifies how long results of a preflight request can be
      cached by a client in seconds. Note that many browser clients enforce a
      maximum TTL of 600s (10 minutes). The following limitations apply: -
      Setting the value to `-1` forces a pre-flight check for all requests
      (not recommended) - A maximum TTL of `86400s` can be set, however, some
      clients may force pre-flight checks at a more regular interval. This
      translates to the Access-Control-Max-Age header.
  """

  allowCredentials = _messages.BooleanField(1)
  allowHeaders = _messages.StringField(2, repeated=True)
  allowMethods = _messages.StringField(3, repeated=True)
  allowOrigins = _messages.StringField(4, repeated=True)
  disabled = _messages.BooleanField(5)
  exposeHeaders = _messages.StringField(6, repeated=True)
  maxAge = _messages.StringField(7)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class EdgeCacheKeyset(_messages.Message):
  r"""EdgeCacheKeyset represents a collection of public keys used for
  validating signed requests.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the
      EdgeCacheKeyset resource.

  Fields:
    createTime: Output only. Creation timestamp in RFC3339 text format.
    description: Optional. A human-readable description of the resource.
    labels: Optional. Set of label tags associated with the EdgeCacheKeyset
      resource.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first
      character must be a letter, and all following characters must be a dash,
      underscore, letter or digit.
    publicKeys: Optional. An ordered list of Ed25519 public keys to use for
      validating signed requests. Ed25519 public keys are not secret, and only
      allow Google to validate a request was signed by your corresponding
      private key. Ensure that the private key is kept secret, and that only
      authorized users can add public keys to a keyset. You can rotate keys by
      appending (pushing) a new key to the list of public keys, and removing
      any superseded keys. You must specify `public_keys` or
      validation_shared_keys (or both). The keys in `public_keys` are checked
      first. You may specify no more than one Google-managed public key. If
      you specify `public_keys`, you must specify at least one key and may
      specify up to three keys.
    updateTime: Output only. Update timestamp in RFC3339 text format.
    validationSharedKeys: Optional. An ordered list of shared keys to use for
      validating signed requests. Shared keys are secret. Ensure that only
      authorized users can add `validation_shared_keys` to a keyset. You can
      rotate keys by appending (pushing) a new key to the list of
      `validation_shared_keys` and removing any superseded keys. You must
      specify public_keys or `validation_shared_keys` (or both). The keys in
      `public_keys` are checked first. If you specify
      `validation_shared_keys`, you must specify at least one key and may have
      up to three keys.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EdgeCacheKeyset
    resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  publicKeys = _messages.MessageField('PublicKey', 5, repeated=True)
  updateTime = _messages.StringField(6)
  validationSharedKeys = _messages.MessageField('Secret', 7, repeated=True)


class EdgeCacheOrigin(_messages.Message):
  r"""EdgeCacheOrigin represents a HTTP-reachable backend for an
  EdgeCacheService.

  Enums:
    ProtocolValueValuesEnum: Optional. The protocol to use to connect to the
      configured origin. Defaults to HTTP2, and it is strongly recommended
      that users use HTTP2 for both security & performance. When using HTTP2
      or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL)
      certificate must be presented by the origin server.
    RetryConditionsValueListEntryValuesEnum:

  Messages:
    LabelsValue: Optional. Set of label tags associated with the
      EdgeCacheOrigin resource.

  Fields:
    awsV4Authentication: Optional. Enable AWS Signature Version 4 origin
      authentication.
    createTime: Output only. Creation timestamp in RFC3339 text format.
    description: Optional. A human-readable description of the resource.
    failoverOrigin: Optional. The EdgeCacheOrigin resource to try when the
      current origin cannot be reached. After max_attempts is reached, the
      configured failover_origin is used to fulfil the request. The following
      are both valid paths to an `EdgeCacheOrigin` resource: * `projects/my-
      project/locations/global/edgeCacheOrigins/my-origin` * `my-origin` The
      value of max_attempts_timeout dictates the timeout across all origins.
    labels: Optional. Set of label tags associated with the EdgeCacheOrigin
      resource.
    maxAttempts: Optional. The maximum number of attempts to cache fill from
      this origin. Another attempt is made when a cache fill fails with one of
      the retry_conditions or following a redirect response matching one of
      the origin_redirect.redirect_conditions. Once max_attempts to this
      origin have failed the failover_origin is used, if one is specified.
      That `failover_origin` may specify its own `max_attempts`,
      `retry_conditions`, `redirect_conditions`, and `failover_origin` to
      control its own cache fill failures. The total number of allowed
      attempts to cache fill across this and failover origins is limited to
      four. The total time allowed for cache fill attempts across this and
      failover origins can be controlled with max_attempts_timeout. The last
      valid, non-retried response from all origins is returned to the client.
      If no origin returns a valid response, an HTTP 502 is returned to the
      client. Defaults to 1. Must be a value greater than 0 and less than 5.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first
      character must be a letter, and all following characters must be a dash,
      underscore, letter or digit.
    originAddress: Required. - **FQDN**: `media-backend.example.com` -
      **IPv4**: `35.218.1.1` - **IPv6**: `2607:f8b0:4012:809::200e` - **Google
      Cloud Storage**: `gs://bucketname` or
      `bucketname.storage.googleapis.com` The following limitations apply to
      fully-qualified domain names: * They must be resolvable through public
      DNS. * They must not contain a protocol (such as `https://`). * They
      must not contain any slashes. When providing an IP address, it must be
      publicly routable. IPv6 addresses must not be enclosed in square
      brackets.
    originOverrideAction: Optional. The override actions, including
      url_rewrites and header additions, for requests that use this origin.
    originRedirect: Optional. Follow redirects from this origin.
    port: Optional. The port to connect to the origin on. Defaults to port
      **443** for HTTP2 and HTTPS protocols, and port **80** for HTTP.
    protocol: Optional. The protocol to use to connect to the configured
      origin. Defaults to HTTP2, and it is strongly recommended that users use
      HTTP2 for both security & performance. When using HTTP2 or HTTPS as the
      protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must
      be presented by the origin server.
    retryConditions: Optional. Specifies one or more retry conditions for the
      configured origin. If the failure mode during a connection attempt to
      the origin matches the configured retryCondition(s), the origin request
      retries up to max_attempts times. The failover_origin, if configured, is
      then used to satisfy the request. The default `retry_conditions`
      condition is `CONNECT_FAILURE`. `retry_conditions` apply to this origin,
      and not to subsequent `failover_origin`s, which may specify their own
      `retry_conditions` and `max_attempts`. For a list of valid values, see
      RetryConditions.
    timeout: Optional. The connection and HTTP timeout configuration for this
      origin.
    updateTime: Output only. Update timestamp in RFC3339 text format.
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. The protocol to use to connect to the configured origin.
    Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for
    both security & performance. When using HTTP2 or HTTPS as the protocol, a
    valid, publicly-signed, unexpired TLS (SSL) certificate must be presented
    by the origin server.

    Values:
      PROTOCOL_UNSPECIFIED: Unspecified value. Will default to HTTP2.
      HTTP2: The HTTP/2 protocol. HTTP/2 refers to "h2", which requires TLS
        (HTTPS). Requires a valid (public, unexpired) TLS certificate present
        on the origin.
      HTTPS: HTTP/1.1 with TLS (SSL). Requires a valid (public, unexpired) TLS
        certificate present on the origin.
      HTTP: HTTP without TLS (SSL). This is not recommended, as communication
        outside of Google's network is unencrypted to the public endpoint
        (origin).
    """
    PROTOCOL_UNSPECIFIED = 0
    HTTP2 = 1
    HTTPS = 2
    HTTP = 3

  class RetryConditionsValueListEntryValuesEnum(_messages.Enum):
    r"""RetryConditionsValueListEntryValuesEnum enum type.

    Values:
      RETRY_CONDITIONS_UNSPECIFIED: Unspecified
      CONNECT_FAILURE: Retry on failures connecting to origins include
        routing, DNS and TLS handshake errors, and TCP/UDP timeouts.
      HTTP_5XX: Retry if the origin responds with any HTTP 5xx response code.
      GATEWAY_ERROR: Similar to 5xx, but only applies to HTTP response codes
        502, 503 or 504.
      RETRIABLE_4XX: Retry for retriable 4xx response codes, which include
        HTTP 409 (Conflict) and HTTP 429 (Too Many Requests).
      NOT_FOUND: Retry if the origin returns an HTTP 404 (Not Found). This can
        be useful when generating video content, and the segment is not
        available yet.
      FORBIDDEN: Retry if the origin returns an HTTP 403 (Forbidden). This can
        be useful for origins that return 403 (instead of 404) for missing
        content for security reasons.
    """
    RETRY_CONDITIONS_UNSPECIFIED = 0
    CONNECT_FAILURE = 1
    HTTP_5XX = 2
    GATEWAY_ERROR = 3
    RETRIABLE_4XX = 4
    NOT_FOUND = 5
    FORBIDDEN = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EdgeCacheOrigin
    resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  awsV4Authentication = _messages.MessageField('AWSV4Signature', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  failoverOrigin = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  maxAttempts = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  name = _messages.StringField(7)
  originAddress = _messages.StringField(8)
  originOverrideAction = _messages.MessageField('OriginOverrideAction', 9)
  originRedirect = _messages.MessageField('OriginRedirect', 10)
  port = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 12)
  retryConditions = _messages.EnumField('RetryConditionsValueListEntryValuesEnum', 13, repeated=True)
  timeout = _messages.MessageField('Timeout', 14)
  updateTime = _messages.StringField(15)


class EdgeCacheService(_messages.Message):
  r"""EdgeCacheService defines the IP addresses, protocols, security policies,
  cache policies and routing configuration.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the EdgeCache
      resource.

  Fields:
    createTime: Output only. Creation timestamp in RFC3339 text format.
    description: Optional. A human-readable description of the resource.
    disableHttp2: Optional. Disables HTTP/2. HTTP/2 (h2) is enabled by default
      and recommended for performance. HTTP/2 improves connection re-use and
      reduces connection setup overhead by sending multiple streams over the
      same connection. Some legacy HTTP clients may have issues with HTTP/2
      connections due to broken HTTP/2 implementations. Setting this to `true`
      prevents HTTP/2 from being advertised and negotiated.
    disableQuic: Optional. HTTP/3 (IETF QUIC) and Google QUIC are enabled by
      default.
    edgeSecurityPolicy: Optional. Resource URL that points at the Cloud Armor
      edge security policy that is applied on each request against the
      EdgeCacheService.
    edgeSslCertificates: Optional. Certificate resources that are used to
      authenticate connections between users and the EdgeCacheService. Note
      that only global certificates with a scope of `EDGE_CACHE` can be
      attached to an EdgeCacheService. The following are both valid paths to
      an `edge_ssl_certificates` resource: *
      `projects/project/locations/global/certificates/media-example-com-cert`
      * `media-example-com-cert` You may specify up to 5 SSL certificates.
    ipv4Addresses: Output only. The IPv4 addresses associated with this
      service. Addresses are static for the lifetime of the service. IP
      addresses provisioned via Bring-Your-Own-IP (BYOIP) are not supported.
    ipv6Addresses: Output only. The IPv6 addresses associated with this
      service. Addresses are static for the lifetime of the service. IP
      addresses provisioned via Bring-Your-Own-IP (BYOIP) are not supported.
    labels: Optional. Set of label tags associated with the EdgeCache
      resource.
    logConfig: Optional. Specifies the logging options for the traffic served
      by this service. If logging is enabled, logs are exported to Cloud
      Logging.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first
      character must be a letter, and all following characters must be a dash,
      underscore, letter or digit.
    requireTls: Optional. Require TLS (HTTPS) for all clients connecting to
      this service. Clients who connect over HTTP (port 80) receive an HTTP
      301 response to the same URL over HTTPS (port 443). You must have at
      least one edge_ssl_certificates specified to enable this.
    routing: Required. Defines how requests are routed, modified, cached, and
      which origin content is filled from.
    updateTime: Output only. Update timestamp in RFC3339 text format.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EdgeCache resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  disableHttp2 = _messages.BooleanField(3)
  disableQuic = _messages.BooleanField(4)
  edgeSecurityPolicy = _messages.StringField(5)
  edgeSslCertificates = _messages.StringField(6, repeated=True)
  ipv4Addresses = _messages.StringField(7, repeated=True)
  ipv6Addresses = _messages.StringField(8, repeated=True)
  labels = _messages.MessageField('LabelsValue', 9)
  logConfig = _messages.MessageField('LogConfig', 10)
  name = _messages.StringField(11)
  requireTls = _messages.BooleanField(12)
  routing = _messages.MessageField('Routing', 13)
  updateTime = _messages.StringField(14)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EndpointMatcher(_messages.Message):
  r"""A definition of a matcher that selects endpoints to which the policies
  should be applied.

  Fields:
    metadataLabelMatcher: The matcher is based on node metadata presented by
      xDS clients.
  """

  metadataLabelMatcher = _messages.MessageField('EndpointMatcherMetadataLabelMatcher', 1)


class EndpointMatcherMetadataLabelMatcher(_messages.Message):
  r"""The matcher that is based on node metadata presented by xDS clients.

  Enums:
    MetadataLabelMatchCriteriaValueValuesEnum: Specifies how matching should
      be done. Supported values are: MATCH_ANY: At least one of the Labels
      specified in the matcher should match the metadata presented by xDS
      client. MATCH_ALL: The metadata presented by the xDS client should
      contain all of the labels specified here. The selection is determined
      based on the best match. For example, suppose there are three
      EndpointPolicy resources P1, P2 and P3 and if P1 has a the matcher as
      MATCH_ANY , P2 has MATCH_ALL , and P3 has MATCH_ALL . If a client with
      label connects, the config from P1 will be selected. If a client with
      label connects, the config from P2 will be selected. If a client with
      label connects, the config from P3 will be selected. If there is more
      than one best match, (for example, if a config P4 with selector exists
      and if a client with label connects), an error will be thrown.

  Fields:
    metadataLabelMatchCriteria: Specifies how matching should be done.
      Supported values are: MATCH_ANY: At least one of the Labels specified in
      the matcher should match the metadata presented by xDS client.
      MATCH_ALL: The metadata presented by the xDS client should contain all
      of the labels specified here. The selection is determined based on the
      best match. For example, suppose there are three EndpointPolicy
      resources P1, P2 and P3 and if P1 has a the matcher as MATCH_ANY , P2
      has MATCH_ALL , and P3 has MATCH_ALL . If a client with label connects,
      the config from P1 will be selected. If a client with label connects,
      the config from P2 will be selected. If a client with label connects,
      the config from P3 will be selected. If there is more than one best
      match, (for example, if a config P4 with selector exists and if a client
      with label connects), an error will be thrown.
    metadataLabels: The list of label value pairs that must match labels in
      the provided metadata based on filterMatchCriteria This list can have at
      most 64 entries. The list can be empty if the match criteria is
      MATCH_ANY, to specify a wildcard match (i.e this matches any client).
  """

  class MetadataLabelMatchCriteriaValueValuesEnum(_messages.Enum):
    r"""Specifies how matching should be done. Supported values are:
    MATCH_ANY: At least one of the Labels specified in the matcher should
    match the metadata presented by xDS client. MATCH_ALL: The metadata
    presented by the xDS client should contain all of the labels specified
    here. The selection is determined based on the best match. For example,
    suppose there are three EndpointPolicy resources P1, P2 and P3 and if P1
    has a the matcher as MATCH_ANY , P2 has MATCH_ALL , and P3 has MATCH_ALL .
    If a client with label connects, the config from P1 will be selected. If a
    client with label connects, the config from P2 will be selected. If a
    client with label connects, the config from P3 will be selected. If there
    is more than one best match, (for example, if a config P4 with selector
    exists and if a client with label connects), an error will be thrown.

    Values:
      METADATA_LABEL_MATCH_CRITERIA_UNSPECIFIED: Default value. Should not be
        used.
      MATCH_ANY: At least one of the Labels specified in the matcher should
        match the metadata presented by xDS client.
      MATCH_ALL: The metadata presented by the xDS client should contain all
        of the labels specified here.
    """
    METADATA_LABEL_MATCH_CRITERIA_UNSPECIFIED = 0
    MATCH_ANY = 1
    MATCH_ALL = 2

  metadataLabelMatchCriteria = _messages.EnumField('MetadataLabelMatchCriteriaValueValuesEnum', 1)
  metadataLabels = _messages.MessageField('EndpointMatcherMetadataLabelMatcherMetadataLabels', 2, repeated=True)


class EndpointMatcherMetadataLabelMatcherMetadataLabels(_messages.Message):
  r"""Defines a name-pair value for a single label.

  Fields:
    labelName: Required. Label name presented as key in xDS Node Metadata.
    labelValue: Required. Label value presented as value corresponding to the
      above key, in xDS Node Metadata.
  """

  labelName = _messages.StringField(1)
  labelValue = _messages.StringField(2)


class EndpointPolicy(_messages.Message):
  r"""EndpointPolicy is a resource that helps apply desired configuration on
  the endpoints that match specific criteria. For example, this resource can
  be used to apply "authentication config" an all endpoints that serve on port
  8080.

  Enums:
    TypeValueValuesEnum: Required. The type of endpoint policy. This is
      primarily used to validate the configuration.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the
      EndpointPolicy resource.

  Fields:
    authorizationPolicy: Optional. This field specifies the URL of
      AuthorizationPolicy resource that applies authorization policies to the
      inbound traffic at the matched endpoints. Refer to Authorization. If
      this field is not specified, authorization is disabled(no authz checks)
      for this endpoint.
    clientTlsPolicy: Optional. A URL referring to a ClientTlsPolicy resource.
      ClientTlsPolicy can be set to specify the authentication for traffic
      from the proxy to the actual endpoints. More specifically, it is applied
      to the outgoing traffic from the proxy to the endpoint. This is
      typically used for sidecar model where the proxy identifies itself as
      endpoint to the control plane, with the connection between sidecar and
      endpoint requiring authentication. If this field is not set,
      authentication is disabled(open). Applicable only when
      EndpointPolicyType is SIDECAR_PROXY.
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    endpointMatcher: Required. A matcher that selects endpoints to which the
      policies should be applied.
    labels: Optional. Set of label tags associated with the EndpointPolicy
      resource.
    name: Required. Name of the EndpointPolicy resource. It matches pattern
      `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`
      .
    serverTlsPolicy: Optional. A URL referring to ServerTlsPolicy resource.
      ServerTlsPolicy is used to determine the authentication policy to be
      applied to terminate the inbound traffic at the identified backends. If
      this field is not set, authentication is disabled(open) for this
      endpoint.
    trafficPortSelector: Optional. Port selector for the (matched) endpoints.
      If no port selector is provided, the matched config is applied to all
      ports.
    type: Required. The type of endpoint policy. This is primarily used to
      validate the configuration.
    updateTime: Output only. The timestamp when the resource was updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of endpoint policy. This is primarily used to
    validate the configuration.

    Values:
      ENDPOINT_POLICY_TYPE_UNSPECIFIED: Default value. Must not be used.
      SIDECAR_PROXY: Represents a proxy deployed as a sidecar.
      GRPC_SERVER: Represents a proxyless gRPC backend.
    """
    ENDPOINT_POLICY_TYPE_UNSPECIFIED = 0
    SIDECAR_PROXY = 1
    GRPC_SERVER = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EndpointPolicy
    resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  authorizationPolicy = _messages.StringField(1)
  clientTlsPolicy = _messages.StringField(2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  endpointMatcher = _messages.MessageField('EndpointMatcher', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  serverTlsPolicy = _messages.StringField(8)
  trafficPortSelector = _messages.MessageField('TrafficPortSelector', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Gateway(_messages.Message):
  r"""Gateway represents the configuration for a proxy, typically a load
  balancer. It captures the ip:port over which the services are exposed by the
  proxy, along with any policy configurations. Routes have reference to to
  Gateways to dictate how requests should be routed by this Gateway.

  Enums:
    TypeValueValuesEnum: Immutable. The type of the customer managed gateway.
      This field is required. If unspecified, an error is returned.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the Gateway
      resource.

  Fields:
    addresses: Optional. Zero or one IPv4-address on which the Gateway will
      receive the traffic. When no address is provided, an IP from the
      subnetwork is allocated This field only applies to gateways of type
      'SECURE_WEB_GATEWAY'. Gateways of type 'OPEN_MESH' listen on 0.0.0.0.
    authorizationPolicy: Optional. A fully-qualified AuthorizationPolicy URL
      reference. Specifies how traffic is authorized. If empty, authorization
      checks are disabled.
    certificateUrls: Optional. A fully-qualified Certificates URL reference.
      The proxy presents a Certificate (selected based on SNI) when
      establishing a TLS connection. This feature only applies to gateways of
      type 'SECURE_WEB_GATEWAY'.
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    labels: Optional. Set of label tags associated with the Gateway resource.
    name: Required. Name of the Gateway resource. It matches pattern
      `projects/*/locations/*/gateways/`.
    network: Optional. The relative resource name identifying the VPC network
      that is using this configuration. For example:
      `projects/*/global/networks/network-1`. Currently, this field is
      specific to gateways of type 'SECURE_WEB_GATEWAY'.
    ports: Required. One or more port numbers (1-65535), on which the Gateway
      will receive traffic. The proxy binds to the specified ports. Gateways
      of type 'SECURE_WEB_GATEWAY' are limited to 1 port. Gateways of type
      'OPEN_MESH' listen on 0.0.0.0 and support multiple ports.
    scope: Required. Immutable. Scope determines how configuration across
      multiple Gateway instances are merged. The configuration for multiple
      Gateway instances with the same scope will be merged as presented as a
      single coniguration to the proxy/load balancer. Max length 64
      characters. Scope should start with a letter and can only have letters,
      numbers, hyphens.
    securityPolicy: Optional. A fully-qualified SecurityPolicy URL reference.
      Defines how a server should apply security policy to inbound (VM to
      Proxy) initiated connections. This policy is specific to gateways of
      type 'SECURE_WEB_GATEWAY'.
    selfLink: Output only. Server-defined URL of this resource
    serverTlsPolicy: Optional. A fully-qualified ServerTLSPolicy URL
      reference. Specifies how TLS traffic is terminated. If empty, TLS
      termination is disabled.
    subnetwork: Optional. The relative resource name identifying the
      subnetwork in which this SWG is allocated. For example:
      `projects/*/regions/us-central1/subnetworks/network-1` Currently, this
      field is specific to gateways of type 'SECURE_WEB_GATEWAY".
    type: Immutable. The type of the customer managed gateway. This field is
      required. If unspecified, an error is returned.
    updateTime: Output only. The timestamp when the resource was updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of the customer managed gateway. This field is
    required. If unspecified, an error is returned.

    Values:
      TYPE_UNSPECIFIED: The type of the customer managed gateway is
        unspecified.
      OPEN_MESH: The type of the customer managed gateway is TrafficDirector
        Open Mesh.
      SECURE_WEB_GATEWAY: The type of the customer managed gateway is
        SecureWebGateway (SWG).
    """
    TYPE_UNSPECIFIED = 0
    OPEN_MESH = 1
    SECURE_WEB_GATEWAY = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the Gateway resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  addresses = _messages.StringField(1, repeated=True)
  authorizationPolicy = _messages.StringField(2)
  certificateUrls = _messages.StringField(3, repeated=True)
  createTime = _messages.StringField(4)
  description = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  network = _messages.StringField(8)
  ports = _messages.IntegerField(9, repeated=True, variant=_messages.Variant.INT32)
  scope = _messages.StringField(10)
  securityPolicy = _messages.StringField(11)
  selfLink = _messages.StringField(12)
  serverTlsPolicy = _messages.StringField(13)
  subnetwork = _messages.StringField(14)
  type = _messages.EnumField('TypeValueValuesEnum', 15)
  updateTime = _messages.StringField(16)


class GrpcRoute(_messages.Message):
  r"""GrpcRoute is the resource defining how gRPC traffic routed by a Mesh or
  Gateway resource is routed.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the GrpcRoute
      resource.

  Fields:
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    gateways: Optional. Gateways defines a list of gateways this GrpcRoute is
      attached to, as one of the routing rules to route the requests served by
      the gateway. Each gateway reference should match the pattern:
      `projects/*/locations/global/gateways/`
    hostnames: Required. Service hostnames with an optional port for which
      this route describes traffic. Format: [:] Hostname is the fully
      qualified domain name of a network host. This matches the RFC 1123
      definition of a hostname with 2 notable exceptions: - IPs are not
      allowed. - A hostname may be prefixed with a wildcard label (*.). The
      wildcard label must appear by itself as the first label. Hostname can be
      "precise" which is a domain name without the terminating dot of a
      network host (e.g. "foo.example.com") or "wildcard", which is a domain
      name prefixed with a single wildcard label (e.g. *.example.com). Note
      that as per RFC1035 and RFC1123, a label must consist of lower case
      alphanumeric characters or '-', and must start and end with an
      alphanumeric character. No other punctuation is allowed. The routes
      associated with a Mesh or Gateway must have unique hostnames. If you
      attempt to attach multiple routes with conflicting hostnames, the
      configuration will be rejected. For example, while it is acceptable for
      routes for the hostnames "*.foo.bar.com" and "*.bar.com" to be
      associated with the same route, it is not possible to associate two
      routes both with "*.bar.com" or both with "bar.com". If a port is
      specified, then gRPC clients must use the channel URI with the port to
      match this rule (i.e. "xds:///service:123"), otherwise they must supply
      the URI without a port (i.e. "xds:///service").
    labels: Optional. Set of label tags associated with the GrpcRoute
      resource.
    meshes: Optional. Meshes defines a list of meshes this GrpcRoute is
      attached to, as one of the routing rules to route the requests served by
      the mesh. Each mesh reference should match the pattern:
      `projects/*/locations/global/meshes/`
    name: Required. Name of the GrpcRoute resource. It matches pattern
      `projects/*/locations/global/grpcRoutes/`
    rules: Required. A list of detailed rules defining how to route traffic.
      Within a single GrpcRoute, the GrpcRoute.RouteAction associated with the
      first matching GrpcRoute.RouteRule will be executed. At least one rule
      must be supplied.
    selfLink: Output only. Server-defined URL of this resource
    updateTime: Output only. The timestamp when the resource was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the GrpcRoute resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  gateways = _messages.StringField(3, repeated=True)
  hostnames = _messages.StringField(4, repeated=True)
  labels = _messages.MessageField('LabelsValue', 5)
  meshes = _messages.StringField(6, repeated=True)
  name = _messages.StringField(7)
  rules = _messages.MessageField('GrpcRouteRouteRule', 8, repeated=True)
  selfLink = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GrpcRouteDestination(_messages.Message):
  r"""The destination to which traffic will be routed.

  Fields:
    serviceName: Required. The URL of a destination service to which to route
      traffic. Must refer to either a BackendService or
      ServiceDirectoryService.
    weight: Optional. Specifies the proportion of requests forwarded to the
      backend referenced by the serviceName field. This is computed as:
      weight/Sum(weights in this destination list). For non-zero values, there
      may be some epsilon from the exact proportion defined here depending on
      the precision an implementation supports. If only one serviceName is
      specified and it has a weight greater than 0, 100% of the traffic is
      forwarded to that backend. If weights are specified for any one service
      name, they need to be specified for all of them. If weights are
      unspecified for all services, then, traffic is distributed in equal
      proportions to all of them.
  """

  serviceName = _messages.StringField(1)
  weight = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GrpcRouteFaultInjectionPolicy(_messages.Message):
  r"""The specification for fault injection introduced into traffic to test
  the resiliency of clients to destination service failure. As part of fault
  injection, when clients send requests to a destination, delays can be
  introduced on a percentage of requests before sending those requests to the
  destination service. Similarly requests from clients can be aborted by for a
  percentage of requests.

  Fields:
    abort: The specification for aborting to client requests.
    delay: The specification for injecting delay to client requests.
  """

  abort = _messages.MessageField('GrpcRouteFaultInjectionPolicyAbort', 1)
  delay = _messages.MessageField('GrpcRouteFaultInjectionPolicyDelay', 2)


class GrpcRouteFaultInjectionPolicyAbort(_messages.Message):
  r"""Specification of how client requests are aborted as part of fault
  injection before being sent to a destination.

  Fields:
    httpStatus: The HTTP status code used to abort the request. The value must
      be between 200 and 599 inclusive.
    percentage: The percentage of traffic which will be aborted. The value
      must be between [0, 100]
  """

  httpStatus = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  percentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GrpcRouteFaultInjectionPolicyDelay(_messages.Message):
  r"""Specification of how client requests are delayed as part of fault
  injection before being sent to a destination.

  Fields:
    fixedDelay: Specify a fixed delay before forwarding the request.
    percentage: The percentage of traffic on which delay will be injected. The
      value must be between [0, 100]
  """

  fixedDelay = _messages.StringField(1)
  percentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GrpcRouteHeaderMatch(_messages.Message):
  r"""A match against a collection of headers.

  Enums:
    TypeValueValuesEnum: Optional. Specifies how to match against the value of
      the header. If not specified, a default value of EXACT is used.

  Fields:
    key: Required. The key of the header.
    type: Optional. Specifies how to match against the value of the header. If
      not specified, a default value of EXACT is used.
    value: Required. The value of the header.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies how to match against the value of the header. If
    not specified, a default value of EXACT is used.

    Values:
      TYPE_UNSPECIFIED: Unspecified.
      EXACT: Will only match the exact value provided.
      REGULAR_EXPRESSION: Will match paths conforming to the prefix specified
        by value. RE2 syntax is supported.
    """
    TYPE_UNSPECIFIED = 0
    EXACT = 1
    REGULAR_EXPRESSION = 2

  key = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)
  value = _messages.StringField(3)


class GrpcRouteMethodMatch(_messages.Message):
  r"""Specifies a match against a method.

  Enums:
    TypeValueValuesEnum: Optional. Specifies how to match against the name. If
      not specified, a default value of "EXACT" is used.

  Fields:
    caseSensitive: Optional. Specifies that matches are case sensitive. The
      default value is true. case_sensitive must not be used with a type of
      REGULAR_EXPRESSION.
    grpcMethod: Required. Name of the method to match against. If unspecified,
      will match all methods.
    grpcService: Required. Name of the service to match against. If
      unspecified, will match all services.
    type: Optional. Specifies how to match against the name. If not specified,
      a default value of "EXACT" is used.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies how to match against the name. If not specified, a
    default value of "EXACT" is used.

    Values:
      TYPE_UNSPECIFIED: Unspecified.
      EXACT: Will only match the exact name provided.
      REGULAR_EXPRESSION: Will interpret grpc_method and grpc_service as
        regexes. RE2 syntax is supported.
    """
    TYPE_UNSPECIFIED = 0
    EXACT = 1
    REGULAR_EXPRESSION = 2

  caseSensitive = _messages.BooleanField(1)
  grpcMethod = _messages.StringField(2)
  grpcService = _messages.StringField(3)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class GrpcRouteRetryPolicy(_messages.Message):
  r"""The specifications for retries.

  Fields:
    numRetries: Specifies the allowed number of retries. This number must be >
      0. If not specified, default to 1.
    retryConditions: - connect-failure: Router will retry on failures
      connecting to Backend Services, for example due to connection timeouts.
      - refused-stream: Router will retry if the backend service resets the
      stream with a REFUSED_STREAM error code. This reset type indicates that
      it is safe to retry. - cancelled: Router will retry if the gRPC status
      code in the response header is set to cancelled - deadline-exceeded:
      Router will retry if the gRPC status code in the response header is set
      to deadline-exceeded - resource-exhausted: Router will retry if the gRPC
      status code in the response header is set to resource-exhausted -
      unavailable: Router will retry if the gRPC status code in the response
      header is set to unavailable
  """

  numRetries = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
  retryConditions = _messages.StringField(2, repeated=True)


class GrpcRouteRouteAction(_messages.Message):
  r"""Specifies how to route matched traffic.

  Fields:
    destinations: Optional. The destination services to which traffic should
      be forwarded. If multiple destinations are specified, traffic will be
      split between Backend Service(s) according to the weight field of these
      destinations.
    faultInjectionPolicy: Optional. The specification for fault injection
      introduced into traffic to test the resiliency of clients to destination
      service failure. As part of fault injection, when clients send requests
      to a destination, delays can be introduced on a percentage of requests
      before sending those requests to the destination service. Similarly
      requests from clients can be aborted by for a percentage of requests.
      timeout and retry_policy will be ignored by clients that are configured
      with a fault_injection_policy
    retryPolicy: Optional. Specifies the retry policy associated with this
      route.
    timeout: Optional. Specifies the timeout for selected route. Timeout is
      computed from the time the request has been fully processed (i.e. end of
      stream) up until the response has been completely processed. Timeout
      includes all retries.
  """

  destinations = _messages.MessageField('GrpcRouteDestination', 1, repeated=True)
  faultInjectionPolicy = _messages.MessageField('GrpcRouteFaultInjectionPolicy', 2)
  retryPolicy = _messages.MessageField('GrpcRouteRetryPolicy', 3)
  timeout = _messages.StringField(4)


class GrpcRouteRouteMatch(_messages.Message):
  r"""Criteria for matching traffic. A RouteMatch will be considered to match
  when all supplied fields match.

  Fields:
    headers: Optional. Specifies a collection of headers to match.
    method: Optional. A gRPC method to match against. If this field is empty
      or omitted, will match all methods.
  """

  headers = _messages.MessageField('GrpcRouteHeaderMatch', 1, repeated=True)
  method = _messages.MessageField('GrpcRouteMethodMatch', 2)


class GrpcRouteRouteRule(_messages.Message):
  r"""Describes how to route traffic.

  Fields:
    action: Required. A detailed rule defining how to route traffic. This
      field is required.
    matches: Optional. Matches define conditions used for matching the rule
      against incoming gRPC requests. Each match is independent, i.e. this
      rule will be matched if ANY one of the matches is satisfied. If no
      matches field is specified, this rule will unconditionally match
      traffic.
  """

  action = _messages.MessageField('GrpcRouteRouteAction', 1)
  matches = _messages.MessageField('GrpcRouteRouteMatch', 2, repeated=True)


class HeaderAction(_messages.Message):
  r"""`HeaderAction` defines the addition and removal of HTTP headers for
  requests / responses.

  Fields:
    requestHeadersToAdd: Optional. A list of headers to add to the request
      prior to forwarding the request to the origin. You may add a maximum of
      5 request headers.
    requestHeadersToRemove: Optional. A list of header names to remove from
      the request prior to forwarding the request to the origin. You may
      specify up to 10 request headers to remove.
    responseHeadersToAdd: Optional. A list of headers to add to the response
      prior to sending it back to the client. You may add a maximum of 5
      response headers. Response headers are only sent to the client, and do
      not have an effect on the cache serving the response.
    responseHeadersToRemove: Optional. A list of headers to remove from the
      response prior to sending it back to the client. Response headers are
      only sent to the client, and do not have an effect on the cache serving
      the response. You may specify up to 10 response headers to remove.
  """

  requestHeadersToAdd = _messages.MessageField('HeaderActionAddHeader', 1, repeated=True)
  requestHeadersToRemove = _messages.MessageField('HeaderActionRemoveHeader', 2, repeated=True)
  responseHeadersToAdd = _messages.MessageField('HeaderActionAddHeader', 3, repeated=True)
  responseHeadersToRemove = _messages.MessageField('HeaderActionRemoveHeader', 4, repeated=True)


class HeaderActionAddHeader(_messages.Message):
  r"""Describes a header to add.

  Fields:
    headerName: Required. The name of the header to add.
    headerValue: Required. The value of the header to add.
    replace: Optional. Whether to replace all existing headers with the same
      name.
  """

  headerName = _messages.StringField(1)
  headerValue = _messages.StringField(2)
  replace = _messages.BooleanField(3)


class HeaderActionRemoveHeader(_messages.Message):
  r"""Describes a header to remove.

  Fields:
    headerName: Required. The name of the header to remove.
  """

  headerName = _messages.StringField(1)


class HeaderMatch(_messages.Message):
  r"""`HeaderMatch` defines the match conditions for HTTP request headers.

  Fields:
    exactMatch: Optional. The value of the header must exactly match contents
      of `exact_match`. Only one of `exact_match`, prefix_match, suffix_match,
      or present_match must be set.
    headerName: Required. The header name to match on.
    invertMatch: Optional. If set to `false`, the HeaderMatch is considered a
      match if the match criteria above are met. If set to `true`, the
      `HeaderMatch` is considered a match if the match criteria above are NOT
      met. The default is `false`.
    prefixMatch: Optional. The value of the header must start with the
      contents of `prefix_match`. Only one of exact_match, `prefix_match`,
      suffix_match, or present_match must be set.
    presentMatch: Optional. A header with the contents of header_name must
      exist. The match takes place whether or not the request's header has a
      value. Only one of exact_match, prefix_match, suffix_match, or
      `present_match` must be set.
    suffixMatch: Optional. The value of the header must end with the contents
      of `suffix_match`. Only one of exact_match, prefix_match, `suffix_match`
      or present_match must be set.
  """

  exactMatch = _messages.StringField(1)
  headerName = _messages.StringField(2)
  invertMatch = _messages.BooleanField(3)
  prefixMatch = _messages.StringField(4)
  presentMatch = _messages.BooleanField(5)
  suffixMatch = _messages.StringField(6)


class HostRule(_messages.Message):
  r"""The hostname configured for the EdgeCacheService. A `HostRule`
  associates a hostname (or hostnames) with a set of routing rules, which
  define path- and header- based configuration.

  Fields:
    description: Optional. A human-readable description of the `HostRule`.
    hosts: Required. The list of host patterns to match. Host patterns must be
      valid hostnames. Ports are not allowed. Wildcard hosts are supported in
      the suffix or prefix form. `*` matches any string of `([a-z0-9-.]*)`. It
      does not match the empty string. When multiple hosts are specified,
      hosts are matched in the following priority: 1. Exact domain names:
      `www.foo.com`. 2. Suffix domain wildcards: `*.foo.com` or
      `*-bar.foo.com`. 3. Prefix domain wildcards: `foo.*` or `foo-*`. 4.
      Special wildcard `*` matching any domain. The wildcard doesn't match the
      empty string. For example, `*-bar.foo.com` matches `baz-bar.foo.com` but
      not `-bar.foo.com`. The longest wildcards match first. Only a single
      host in the entire service can match on ``*``. A domain must be unique
      across all configured hosts within a service. Hosts are matched against
      the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header,
      from the incoming request. You may specify up to 10 hosts.
    pathMatcher: Required. The name of the PathMatcher associated with this
      `HostRule`.
  """

  description = _messages.StringField(1)
  hosts = _messages.StringField(2, repeated=True)
  pathMatcher = _messages.StringField(3)


class HttpRoute(_messages.Message):
  r"""HttpRoute is the resource defining how HTTP traffic should be routed by
  a Mesh or Gateway resource.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the HttpRoute
      resource.

  Fields:
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    gateways: Optional. Gateways defines a list of gateways this HttpRoute is
      attached to, as one of the routing rules to route the requests served by
      the gateway. Each gateway reference should match the pattern:
      `projects/*/locations/global/gateways/`
    hostnames: Required. Hostnames define a set of hosts that should match
      against the HTTP host header to select a HttpRoute to process the
      request. Hostname is the fully qualified domain name of a network host,
      as defined by RFC 1123 with the exception that: - IPs are not allowed. -
      A hostname may be prefixed with a wildcard label (*.). The wildcard
      label must appear by itself as the first label. Hostname can be
      "precise" which is a domain name without the terminating dot of a
      network host (e.g. "foo.example.com") or "wildcard", which is a domain
      name prefixed with a single wildcard label (e.g. *.example.com). Note
      that as per RFC1035 and RFC1123, a label must consist of lower case
      alphanumeric characters or '-', and must start and end with an
      alphanumeric character. No other punctuation is allowed. The routes
      associated with a Mesh or Gateways must have unique hostnames. If you
      attempt to attach multiple routes with conflicting hostnames, the
      configuration will be rejected. For example, while it is acceptable for
      routes for the hostnames "*.foo.bar.com" and "*.bar.com" to be
      associated with the same Mesh (or Gateways under the same scope), it is
      not possible to associate two routes both with "*.bar.com" or both with
      "bar.com".
    labels: Optional. Set of label tags associated with the HttpRoute
      resource.
    meshes: Optional. Meshes defines a list of meshes this HttpRoute is
      attached to, as one of the routing rules to route the requests served by
      the mesh. Each mesh reference should match the pattern:
      `projects/*/locations/global/meshes/` The attached Mesh should be of a
      type SIDECAR
    name: Required. Name of the HttpRoute resource. It matches pattern
      `projects/*/locations/global/httpRoutes/http_route_name>`.
    rules: Required. Rules that define how traffic is routed and handled.
      Rules will be matched sequentially based on the RouteMatch specified for
      the rule.
    selfLink: Output only. Server-defined URL of this resource
    updateTime: Output only. The timestamp when the resource was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the HttpRoute resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  gateways = _messages.StringField(3, repeated=True)
  hostnames = _messages.StringField(4, repeated=True)
  labels = _messages.MessageField('LabelsValue', 5)
  meshes = _messages.StringField(6, repeated=True)
  name = _messages.StringField(7)
  rules = _messages.MessageField('HttpRouteRouteRule', 8, repeated=True)
  selfLink = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class HttpRouteCorsPolicy(_messages.Message):
  r"""The Specification for allowing client side cross-origin requests.

  Fields:
    allowCredentials: In response to a preflight request, setting this to true
      indicates that the actual request can include user credentials. This
      translates to the Access-Control-Allow-Credentials header. Default value
      is false.
    allowHeaders: Specifies the content for Access-Control-Allow-Headers
      header.
    allowMethods: Specifies the content for Access-Control-Allow-Methods
      header.
    allowOriginRegexes: Specifies the regular expression patterns that match
      allowed origins. For regular expression grammar, please see
      https://github.com/google/re2/wiki/Syntax.
    allowOrigins: Specifies the list of origins that will be allowed to do
      CORS requests. An origin is allowed if it matches either an item in
      allow_origins or an item in allow_origin_regexes.
    disabled: If true, the CORS policy is disabled. The default value is
      false, which indicates that the CORS policy is in effect.
    exposeHeaders: Specifies the content for Access-Control-Expose-Headers
      header.
    maxAge: Specifies how long result of a preflight request can be cached in
      seconds. This translates to the Access-Control-Max-Age header.
  """

  allowCredentials = _messages.BooleanField(1)
  allowHeaders = _messages.StringField(2, repeated=True)
  allowMethods = _messages.StringField(3, repeated=True)
  allowOriginRegexes = _messages.StringField(4, repeated=True)
  allowOrigins = _messages.StringField(5, repeated=True)
  disabled = _messages.BooleanField(6)
  exposeHeaders = _messages.StringField(7, repeated=True)
  maxAge = _messages.StringField(8)


class HttpRouteDestination(_messages.Message):
  r"""Specifications of a destination to which the request should be routed
  to.

  Fields:
    serviceName: The URL of a BackendService to route traffic to.
    weight: Specifies the proportion of requests forwarded to the backend
      referenced by the serviceName field. This is computed as:
      weight/Sum(weights in this destination list). For non-zero values, there
      may be some epsilon from the exact proportion defined here depending on
      the precision an implementation supports. If only one serviceName is
      specified and it has a weight greater than 0, 100% of the traffic is
      forwarded to that backend. If weights are specified for any one service
      name, they need to be specified for all of them. If weights are
      unspecified for all services, then, traffic is distributed in equal
      proportions to all of them.
  """

  serviceName = _messages.StringField(1)
  weight = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class HttpRouteFaultInjectionPolicy(_messages.Message):
  r"""The specification for fault injection introduced into traffic to test
  the resiliency of clients to destination service failure. As part of fault
  injection, when clients send requests to a destination, delays can be
  introduced by client proxy on a percentage of requests before sending those
  requests to the destination service. Similarly requests can be aborted by
  client proxy for a percentage of requests.

  Fields:
    abort: The specification for aborting to client requests.
    delay: The specification for injecting delay to client requests.
  """

  abort = _messages.MessageField('HttpRouteFaultInjectionPolicyAbort', 1)
  delay = _messages.MessageField('HttpRouteFaultInjectionPolicyDelay', 2)


class HttpRouteFaultInjectionPolicyAbort(_messages.Message):
  r"""Specification of how client requests are aborted as part of fault
  injection before being sent to a destination.

  Fields:
    httpStatus: The HTTP status code used to abort the request. The value must
      be between 200 and 599 inclusive.
    percentage: The percentage of traffic which will be aborted. The value
      must be between [0, 100]
  """

  httpStatus = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  percentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class HttpRouteFaultInjectionPolicyDelay(_messages.Message):
  r"""Specification of how client requests are delayed as part of fault
  injection before being sent to a destination.

  Fields:
    fixedDelay: Specify a fixed delay before forwarding the request.
    percentage: The percentage of traffic on which delay will be injected. The
      value must be between [0, 100]
  """

  fixedDelay = _messages.StringField(1)
  percentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class HttpRouteHeaderMatch(_messages.Message):
  r"""Specifies how to select a route rule based on HTTP request headers.

  Fields:
    exactMatch: The value of the header should match exactly the content of
      exact_match.
    header: The name of the HTTP header to match against.
    invertMatch: If specified, the match result will be inverted before
      checking. Default value is set to false.
    prefixMatch: The value of the header must start with the contents of
      prefix_match.
    presentMatch: A header with header_name must exist. The match takes place
      whether or not the header has a value.
    rangeMatch: If specified, the rule will match if the request header value
      is within the range.
    regexMatch: The value of the header must match the regular expression
      specified in regex_match. For regular expression grammar, please see:
      https://github.com/google/re2/wiki/Syntax
    suffixMatch: The value of the header must end with the contents of
      suffix_match.
  """

  exactMatch = _messages.StringField(1)
  header = _messages.StringField(2)
  invertMatch = _messages.BooleanField(3)
  prefixMatch = _messages.StringField(4)
  presentMatch = _messages.BooleanField(5)
  rangeMatch = _messages.MessageField('HttpRouteHeaderMatchIntegerRange', 6)
  regexMatch = _messages.StringField(7)
  suffixMatch = _messages.StringField(8)


class HttpRouteHeaderMatchIntegerRange(_messages.Message):
  r"""Represents an integer value range.

  Fields:
    end: End of the range (exclusive)
    start: Start of the range (inclusive)
  """

  end = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  start = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class HttpRouteHeaderModifier(_messages.Message):
  r"""The specification for modifying HTTP header in HTTP request and HTTP
  response.

  Messages:
    AddValue: Add the headers with given map where key is the name of the
      header, value is the value of the header.
    SetValue: Completely overwrite/replace the headers with given map where
      key is the name of the header, value is the value of the header.

  Fields:
    add: Add the headers with given map where key is the name of the header,
      value is the value of the header.
    remove: Remove headers (matching by header names) specified in the list.
    set: Completely overwrite/replace the headers with given map where key is
      the name of the header, value is the value of the header.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AddValue(_messages.Message):
    r"""Add the headers with given map where key is the name of the header,
    value is the value of the header.

    Messages:
      AdditionalProperty: An additional property for a AddValue object.

    Fields:
      additionalProperties: Additional properties of type AddValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AddValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SetValue(_messages.Message):
    r"""Completely overwrite/replace the headers with given map where key is
    the name of the header, value is the value of the header.

    Messages:
      AdditionalProperty: An additional property for a SetValue object.

    Fields:
      additionalProperties: Additional properties of type SetValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SetValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  add = _messages.MessageField('AddValue', 1)
  remove = _messages.StringField(2, repeated=True)
  set = _messages.MessageField('SetValue', 3)


class HttpRouteQueryParameterMatch(_messages.Message):
  r"""Specifications to match a query parameter in the request.

  Fields:
    exactMatch: The value of the query parameter must exactly match the
      contents of exact_match. Only one of exact_match, regex_match, or
      present_match must be set.
    presentMatch: Specifies that the QueryParameterMatcher matches if request
      contains query parameter, irrespective of whether the parameter has a
      value or not. Only one of exact_match, regex_match, or present_match
      must be set.
    queryParameter: The name of the query parameter to match.
    regexMatch: The value of the query parameter must match the regular
      expression specified by regex_match. For regular expression grammar,
      please see https://github.com/google/re2/wiki/Syntax Only one of
      exact_match, regex_match, or present_match must be set.
  """

  exactMatch = _messages.StringField(1)
  presentMatch = _messages.BooleanField(2)
  queryParameter = _messages.StringField(3)
  regexMatch = _messages.StringField(4)


class HttpRouteRedirect(_messages.Message):
  r"""The specification for redirecting traffic.

  Enums:
    ResponseCodeValueValuesEnum: The HTTP Status code to use for the redirect.

  Fields:
    hostRedirect: The host that will be used in the redirect response instead
      of the one that was supplied in the request.
    httpsRedirect: If set to true, the URL scheme in the redirected request is
      set to https. If set to false, the URL scheme of the redirected request
      will remain the same as that of the request. The default is set to
      false.
    pathRedirect: The path that will be used in the redirect response instead
      of the one that was supplied in the request. path_redirect can not be
      supplied together with prefix_redirect. Supply one alone or neither. If
      neither is supplied, the path of the original request will be used for
      the redirect.
    portRedirect: The port that will be used in the redirected request instead
      of the one that was supplied in the request.
    prefixRewrite: Indicates that during redirection, the matched prefix (or
      path) should be swapped with this value. This option allows URLs be
      dynamically created based on the request.
    responseCode: The HTTP Status code to use for the redirect.
    stripQuery: if set to true, any accompanying query portion of the original
      URL is removed prior to redirecting the request. If set to false, the
      query portion of the original URL is retained. The default is set to
      false.
  """

  class ResponseCodeValueValuesEnum(_messages.Enum):
    r"""The HTTP Status code to use for the redirect.

    Values:
      RESPONSE_CODE_UNSPECIFIED: Default value
      MOVED_PERMANENTLY_DEFAULT: Corresponds to 301.
      FOUND: Corresponds to 302.
      SEE_OTHER: Corresponds to 303.
      TEMPORARY_REDIRECT: Corresponds to 307. In this case, the request method
        will be retained.
      PERMANENT_REDIRECT: Corresponds to 308. In this case, the request method
        will be retained.
    """
    RESPONSE_CODE_UNSPECIFIED = 0
    MOVED_PERMANENTLY_DEFAULT = 1
    FOUND = 2
    SEE_OTHER = 3
    TEMPORARY_REDIRECT = 4
    PERMANENT_REDIRECT = 5

  hostRedirect = _messages.StringField(1)
  httpsRedirect = _messages.BooleanField(2)
  pathRedirect = _messages.StringField(3)
  portRedirect = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  prefixRewrite = _messages.StringField(5)
  responseCode = _messages.EnumField('ResponseCodeValueValuesEnum', 6)
  stripQuery = _messages.BooleanField(7)


class HttpRouteRequestMirrorPolicy(_messages.Message):
  r"""Specifies the policy on how requests are shadowed to a separate mirrored
  destination service. The proxy does not wait for responses from the shadow
  service. Prior to sending traffic to the shadow service, the host/authority
  header is suffixed with -shadow.

  Fields:
    destination: The destination the requests will be mirrored to. The weight
      of the destination will be ignored.
  """

  destination = _messages.MessageField('HttpRouteDestination', 1)


class HttpRouteRetryPolicy(_messages.Message):
  r"""The specifications for retries.

  Fields:
    numRetries: Specifies the allowed number of retries. This number must be >
      0. If not specified, default to 1.
    perTryTimeout: Specifies a non-zero timeout per retry attempt.
    retryConditions: Specifies one or more conditions when this retry policy
      applies. Valid values are: 5xx: Proxy will attempt a retry if the
      destination service responds with any 5xx response code, of if the
      destination service does not respond at all, example: disconnect, reset,
      read timeout, connection failure and refused streams. gateway-error:
      Similar to 5xx, but only applies to response codes 502, 503, 504. reset:
      Proxy will attempt a retry if the destination service does not respond
      at all (disconnect/reset/read timeout) connect-failure: Proxy will retry
      on failures connecting to destination for example due to connection
      timeouts. retriable-4xx: Proxy will retry fro retriable 4xx response
      codes. Currently the only retriable error supported is 409. refused-
      stream: Proxy will retry if the destination resets the stream with a
      REFUSED_STREAM error code. This reset type indicates that it is safe to
      retry.
  """

  numRetries = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  perTryTimeout = _messages.StringField(2)
  retryConditions = _messages.StringField(3, repeated=True)


class HttpRouteRouteAction(_messages.Message):
  r"""The specifications for routing traffic and applying associated policies.

  Fields:
    corsPolicy: The specification for allowing client side cross-origin
      requests.
    destinations: The destination to which traffic should be forwarded.
    faultInjectionPolicy: The specification for fault injection introduced
      into traffic to test the resiliency of clients to backend service
      failure. As part of fault injection, when clients send requests to a
      backend service, delays can be introduced on a percentage of requests
      before sending those requests to the backend service. Similarly requests
      from clients can be aborted for a percentage of requests. timeout and
      retry_policy will be ignored by clients that are configured with a
      fault_injection_policy
    redirect: If set, the request is directed as configured by this field.
    requestHeaderModifier: The specification for modifying the headers of a
      matching request prior to delivery of the request to the destination.
    requestMirrorPolicy: Specifies the policy on how requests intended for the
      routes destination are shadowed to a separate mirrored destination.
      Proxy will not wait for the shadow destination to respond before
      returning the response. Prior to sending traffic to the shadow service,
      the host/authority header is suffixed with -shadow.
    responseHeaderModifier: The specification for modifying the headers of a
      response prior to sending the response back to the client.
    retryPolicy: Specifies the retry policy associated with this route.
    timeout: Specifies the timeout for selected route. Timeout is computed
      from the time the request has been fully processed (i.e. end of stream)
      up until the response has been completely processed. Timeout includes
      all retries.
    urlRewrite: The specification for rewrite URL before forwarding requests
      to the destination.
  """

  corsPolicy = _messages.MessageField('HttpRouteCorsPolicy', 1)
  destinations = _messages.MessageField('HttpRouteDestination', 2, repeated=True)
  faultInjectionPolicy = _messages.MessageField('HttpRouteFaultInjectionPolicy', 3)
  redirect = _messages.MessageField('HttpRouteRedirect', 4)
  requestHeaderModifier = _messages.MessageField('HttpRouteHeaderModifier', 5)
  requestMirrorPolicy = _messages.MessageField('HttpRouteRequestMirrorPolicy', 6)
  responseHeaderModifier = _messages.MessageField('HttpRouteHeaderModifier', 7)
  retryPolicy = _messages.MessageField('HttpRouteRetryPolicy', 8)
  timeout = _messages.StringField(9)
  urlRewrite = _messages.MessageField('HttpRouteURLRewrite', 10)


class HttpRouteRouteMatch(_messages.Message):
  r"""RouteMatch defines specifications used to match requests. If multiple
  match types are set, this RouteMatch will match if ALL type of matches are
  matched.

  Fields:
    fullPathMatch: The HTTP request path value should exactly match this
      value. Only one of full_path_match, prefix_match, or regex_match should
      be used.
    headers: Specifies a list of HTTP request headers to match against. ALL of
      the supplied headers must be matched.
    ignoreCase: Specifies if prefix_match and full_path_match matches are case
      sensitive. The default value is false.
    prefixMatch: The HTTP request path value must begin with specified
      prefix_match. prefix_match must begin with a /. Only one of
      full_path_match, prefix_match, or regex_match should be used.
    queryParameters: Specifies a list of query parameters to match against.
      ALL of the query parameters must be matched.
    regexMatch: The HTTP request path value must satisfy the regular
      expression specified by regex_match after removing any query parameters
      and anchor supplied with the original URL. For regular expression
      grammar, please see https://github.com/google/re2/wiki/Syntax Only one
      of full_path_match, prefix_match, or regex_match should be used.
  """

  fullPathMatch = _messages.StringField(1)
  headers = _messages.MessageField('HttpRouteHeaderMatch', 2, repeated=True)
  ignoreCase = _messages.BooleanField(3)
  prefixMatch = _messages.StringField(4)
  queryParameters = _messages.MessageField('HttpRouteQueryParameterMatch', 5, repeated=True)
  regexMatch = _messages.StringField(6)


class HttpRouteRouteRule(_messages.Message):
  r"""Specifies how to match traffic and how to route traffic when traffic is
  matched.

  Fields:
    action: The detailed rule defining how to route matched traffic.
    matches: A list of matches define conditions used for matching the rule
      against incoming HTTP requests. Each match is independent, i.e. this
      rule will be matched if ANY one of the matches is satisfied. If no
      matches field is specified, this rule will unconditionally match
      traffic. If a default rule is desired to be configured, add a rule with
      no matches specified to the end of the rules list.
  """

  action = _messages.MessageField('HttpRouteRouteAction', 1)
  matches = _messages.MessageField('HttpRouteRouteMatch', 2, repeated=True)


class HttpRouteURLRewrite(_messages.Message):
  r"""The specification for modifying the URL of the request, prior to
  forwarding the request to the destination.

  Fields:
    hostRewrite: Prior to forwarding the request to the selected destination,
      the requests host header is replaced by this value.
    pathPrefixRewrite: Prior to forwarding the request to the selected
      destination, the matching portion of the requests path is replaced by
      this value.
  """

  hostRewrite = _messages.StringField(1)
  pathPrefixRewrite = _messages.StringField(2)


class InvalidateCacheRequest(_messages.Message):
  r"""Request used by the `InvalidateCache` method.

  Fields:
    cacheTags: A list of cache tags used to identify cached objects. Cache
      tags are specified when the response is first cached, by setting the
      "Cache-Tag" response header at the origin. By default, all objects have
      a cache tag representing the HTTP status code of the response, the MIME
      content-type, and the origin. Multiple cache tags in the same
      revalidation request are treated as Boolean `OR` - for example, `tag1 OR
      tag2 OR tag3`. If a host and path are also specified, these are treated
      as Boolean `AND` with any tags. Up to 10 tags may be specified in a
      single invalidation request.
    host: The hostname to invalidate against. You can specify an exact or
      wildcard host based on the host component. For example,
      `video.example.com` or `*.example.com`.
    path: The path to invalidate against. You can specify an exact or wildcard
      path based on the a path component. For example,
      `/videos/hls/139123.mp4` or `/manifests/*`.
  """

  cacheTags = _messages.StringField(1, repeated=True)
  host = _messages.StringField(2)
  path = _messages.StringField(3)


class InvalidateCacheResponse(_messages.Message):
  r"""Response used by the InvalidateCache method."""


class ListEdgeCacheKeysetsResponse(_messages.Message):
  r"""Response returned by the `ListEdgeCacheKeysets` method.

  Fields:
    edgeCacheKeysets: List of `EdgeCacheKeyset` resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      page_token.
  """

  edgeCacheKeysets = _messages.MessageField('EdgeCacheKeyset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEdgeCacheOriginsResponse(_messages.Message):
  r"""Response returned by the ListEdgeCacheOrigins method.

  Fields:
    edgeCacheOrigins: List of EdgeCacheOrigin resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      page_token.
  """

  edgeCacheOrigins = _messages.MessageField('EdgeCacheOrigin', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEdgeCacheServicesResponse(_messages.Message):
  r"""Response returned by the `list` method.

  Fields:
    edgeCacheServices: List of EdgeCacheService resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      page_token.
  """

  edgeCacheServices = _messages.MessageField('EdgeCacheService', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEndpointPoliciesResponse(_messages.Message):
  r"""Response returned by the ListEndpointPolicies method.

  Fields:
    endpointPolicies: List of EndpointPolicy resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  endpointPolicies = _messages.MessageField('EndpointPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGatewaysResponse(_messages.Message):
  r"""Response returned by the ListGateways method.

  Fields:
    gateways: List of Gateway resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  gateways = _messages.MessageField('Gateway', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGrpcRoutesResponse(_messages.Message):
  r"""Response returned by the ListGrpcRoutes method.

  Fields:
    grpcRoutes: List of GrpcRoute resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  grpcRoutes = _messages.MessageField('GrpcRoute', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListHttpRoutesResponse(_messages.Message):
  r"""Response returned by the ListHttpRoutes method.

  Fields:
    httpRoutes: List of HttpRoute resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  httpRoutes = _messages.MessageField('HttpRoute', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMeshesResponse(_messages.Message):
  r"""Response returned by the ListMeshes method.

  Fields:
    meshes: List of Mesh resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  meshes = _messages.MessageField('Mesh', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListServiceBindingsResponse(_messages.Message):
  r"""Response returned by the ListServiceBindings method.

  Fields:
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
    serviceBindings: List of ServiceBinding resources.
  """

  nextPageToken = _messages.StringField(1)
  serviceBindings = _messages.MessageField('ServiceBinding', 2, repeated=True)


class ListTcpRoutesResponse(_messages.Message):
  r"""Response returned by the ListTcpRoutes method.

  Fields:
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
    tcpRoutes: List of TcpRoute resources.
  """

  nextPageToken = _messages.StringField(1)
  tcpRoutes = _messages.MessageField('TcpRoute', 2, repeated=True)


class ListTlsRoutesResponse(_messages.Message):
  r"""Response returned by the ListTlsRoutes method.

  Fields:
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
    tlsRoutes: List of TlsRoute resources.
  """

  nextPageToken = _messages.StringField(1)
  tlsRoutes = _messages.MessageField('TlsRoute', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LogConfig(_messages.Message):
  r"""Specifies the logging options for the traffic served by this service. If
  logging is enabled, logs are exported to Cloud Logging.

  Fields:
    enable: Optional. Specifies whether to enable logging for traffic served
      by this service. Defaults to false.
    sampleRate: Optional. Configures the sampling rate of requests, where
      `1.0` means all logged requests are reported and `0.0` means no logged
      requests are reported. The default value is `1.0`, and the value of the
      field must be in `[0, 1]`. This field can only be specified if logging
      is enabled for this service.
  """

  enable = _messages.BooleanField(1)
  sampleRate = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class MatchRule(_messages.Message):
  r"""`MatchRule` is a collection of match conditions (such as query, header,
  or URI) for a request.

  Fields:
    fullPathMatch: Optional. For satisfying the `MatchRule` condition, the
      path of the request must exactly match the value specified in
      `full_path_match` after removing any query parameters and anchor that
      may be part of the original URL. `full_path_match` must begin with a
      `/`. The value must be between 1 and 1024 characters, (inclusive). One
      of prefix_match, `full_path_match`, or path_template_match must be
      specified.
    headerMatches: Optional. Specifies a list of HeaderMatch criteria, all of
      which must match corresponding headers in the request. You may specify
      up to 3 headers to match on.
    ignoreCase: Optional. Specifies that prefix_match and full_path_match
      matches are case sensitive. The default value is `false`.
    pathTemplateMatch: Optional. For satisfying the `MatchRule` condition, the
      path of the request must match the wildcard pattern specified in
      `path_template_match` after removing any query parameters and anchor
      that may be part of the original URL. `path_template_match` must be
      between 1 and 255 characters (inclusive). The pattern specified by
      `path_template_match` may have at most 5 wildcard operators and at most
      5 variable captures in total. One of prefix_match, full_path_match, or
      `path_template_match` must be specified.
    prefixMatch: Optional. For satisfying the `MatchRule` condition, the
      request's path must begin with the specified `prefix_match`.
      `prefix_match` must begin with a `/`. The value must be between 1 and
      1024 characters (inclusive). One of `prefix_match`, full_path_match, or
      path_template_match must be specified.
    queryParameterMatches: Optional. Specifies a list of QueryParameterMatcher
      criteria, all of which must match corresponding query parameters in the
      request. You may specify up to 5 query parameters to match on.
  """

  fullPathMatch = _messages.StringField(1)
  headerMatches = _messages.MessageField('HeaderMatch', 2, repeated=True)
  ignoreCase = _messages.BooleanField(3)
  pathTemplateMatch = _messages.StringField(4)
  prefixMatch = _messages.StringField(5)
  queryParameterMatches = _messages.MessageField('QueryParameterMatcher', 6, repeated=True)


class Mesh(_messages.Message):
  r"""Mesh represents a logical configuration grouping for workload to
  workload communication within a service mesh. Routes that point to mesh
  dictate how requests are routed within this logical mesh boundary.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the Mesh
      resource.

  Fields:
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    interceptionPort: Optional. If set to a valid TCP port (1-65535),
      instructs the SIDECAR proxy to listen on the specified port of localhost
      (127.0.0.1) address. The SIDECAR proxy will expect all traffic to be
      redirected to this port regardless of its actual ip:port destination. If
      unset, a port '15001' is used as the interception port. This will is
      applicable only for sidecar proxy deployments.
    labels: Optional. Set of label tags associated with the Mesh resource.
    name: Required. Name of the Mesh resource. It matches pattern
      `projects/*/locations/global/meshes/`.
    selfLink: Output only. Server-defined URL of this resource
    updateTime: Output only. The timestamp when the resource was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the Mesh resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  interceptionPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  selfLink = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsCreateRequest object.

  Fields:
    edgeCacheKeyset: A EdgeCacheKeyset resource to be passed as the request
      body.
    edgeCacheKeysetId: Required. Short name of the EdgeCacheKeyset resource to
      create, such as `MyEdgeCacheKeyset`.
    parent: Required. The parent resource of the EdgeCacheKeyset. Must be in
      the format `projects/*/locations/global`.
  """

  edgeCacheKeyset = _messages.MessageField('EdgeCacheKeyset', 1)
  edgeCacheKeysetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsDeleteRequest object.

  Fields:
    name: Required. A name of the EdgeCacheKeyset to delete. Must be in the
      format `projects/*/locations/global/edgeCacheKeysets/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsGetRequest object.

  Fields:
    name: Required. A name of the EdgeCacheKeyset to get. Must be in the
      format `projects/*/locations/global/edgeCacheKeysets/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsListRequest object.

  Fields:
    pageSize: Maximum number of EdgeCacheKeysets to return per call.
    pageToken: The value returned by the last ListEdgeCacheKeysetsResponse.
      Indicates that this is a continuation of a prior `ListEdgeCacheKeysets`
      call, and that the system can return the next page of data.
    parent: Required. The project and location to list EdgeCacheKeysets from,
      specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsPatchRequest object.

  Fields:
    edgeCacheKeyset: A EdgeCacheKeyset resource to be passed as the request
      body.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first
      character must be a letter, and all following characters must be a dash,
      underscore, letter or digit.
    updateMask: Optional. Field mask is used to specify the fields to
      overwrite in the EdgeCacheKeyset resource by the update. The fields
      specified in the `update_mask` are relative to the resource, not the
      full request. A field is overwritten if it is in the mask. If the user
      does not provide a mask then all fields are overwritten.
  """

  edgeCacheKeyset = _messages.MessageField('EdgeCacheKeyset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEdgeCacheKeysetsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheOriginsCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsCreateRequest object.

  Fields:
    edgeCacheOrigin: A EdgeCacheOrigin resource to be passed as the request
      body.
    edgeCacheOriginId: Required. Short name of the EdgeCacheOrigin resource to
      create, such as `MyEdgeCacheOrigin`.
    parent: Required. The parent resource of the EdgeCacheOrigin. Must be in
      the format `projects/*/locations/global`.
  """

  edgeCacheOrigin = _messages.MessageField('EdgeCacheOrigin', 1)
  edgeCacheOriginId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsDeleteRequest object.

  Fields:
    name: Required. A name of the EdgeCacheOrigin to delete. Must be in the
      format `projects/*/locations/global/edgeCacheOrigins/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsGetRequest object.

  Fields:
    name: Required. A name of the EdgeCacheOrigin to get. Must be in the
      format `projects/*/locations/global/edgeCacheOrigins/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsListRequest object.

  Fields:
    pageSize: Maximum number of EdgeCacheOrigins to return per call.
    pageToken: The value returned by the last `ListEdgeCacheOriginsResponse`
      Indicates that this is a continuation of a prior `ListEdgeCacheOrigins`
      call, and that the system can return the next page of data.
    parent: Required. The project and location to list EdgeCacheOrigins from,
      specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsPatchRequest object.

  Fields:
    edgeCacheOrigin: A EdgeCacheOrigin resource to be passed as the request
      body.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first
      character must be a letter, and all following characters must be a dash,
      underscore, letter or digit.
    updateMask: Optional. Field mask is used to specify the fields to
      overwrite in the EdgeCacheOrigin resource by the update. The fields
      specified in the `update_mask` are relative to the resource, not the
      full request. A field is overwritten if it is in the mask. If the user
      does not provide a mask then all fields are overwritten.
  """

  edgeCacheOrigin = _messages.MessageField('EdgeCacheOrigin', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEdgeCacheOriginsSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheOriginsTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEdgeCacheOriginsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheServicesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesCreateRequest object.

  Fields:
    edgeCacheService: A EdgeCacheService resource to be passed as the request
      body.
    edgeCacheServiceId: Required. Short name of the EdgeCacheService resource
      create, such as "MyEdgeService".
    parent: Required. The parent resource of the EdgeCacheService. Must be in
      the format `projects/*/locations/global`.
  """

  edgeCacheService = _messages.MessageField('EdgeCacheService', 1)
  edgeCacheServiceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesDeleteRequest object.

  Fields:
    name: Required. A name of the EdgeCacheService to delete. Must be in the
      format `projects/*/locations/global/edgeCacheServices/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesGetRequest object.

  Fields:
    name: Required. A name of the EdgeCacheService to get. Must be in the
      format `projects/*/locations/global/edgeCacheServices/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesInvalidateCacheRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEdgeCacheServicesInvalidateCacheRequest
  object.

  Fields:
    edgeCacheService: Required. A name of the EdgeCacheService to apply the
      invalidation request to. Must be in the format
      `projects/*/locations/global/edgeCacheServices/*`.
    invalidateCacheRequest: A InvalidateCacheRequest resource to be passed as
      the request body.
  """

  edgeCacheService = _messages.StringField(1, required=True)
  invalidateCacheRequest = _messages.MessageField('InvalidateCacheRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheServicesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesListRequest object.

  Fields:
    pageSize: Maximum number of EdgeCacheService items to return per call.
    pageToken: The value returned by the last `list` response. Indicates that
      this is a continuation of a prior `list` call, and that the system can
      return the next page of data.
    parent: Required. The project and location to list EdgeCacheService from,
      specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesPatchRequest object.

  Fields:
    edgeCacheService: A EdgeCacheService resource to be passed as the request
      body.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the first
      character must be a letter, and all following characters must be a dash,
      underscore, letter or digit.
    updateMask: Optional. Field mask is used to specify the fields to
      overwrite in the EdgeCacheService resource by the update. The fields
      specified in the `update_mask` are relative to the resource, not the
      full request. A field is overwritten if it is in the mask. If a mask is
      not provided, then all fields are overwritten.
  """

  edgeCacheService = _messages.MessageField('EdgeCacheService', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEdgeCacheServicesSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheServicesTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEdgeCacheServicesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsEndpointPoliciesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointPoliciesCreateRequest object.

  Fields:
    endpointPolicy: A EndpointPolicy resource to be passed as the request
      body.
    endpointPolicyId: Required. Short name of the EndpointPolicy resource to
      be created. E.g. "CustomECS".
    parent: Required. The parent resource of the EndpointPolicy. Must be in
      the format `projects/*/locations/global`.
  """

  endpointPolicy = _messages.MessageField('EndpointPolicy', 1)
  endpointPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEndpointPoliciesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointPoliciesDeleteRequest object.

  Fields:
    name: Required. A name of the EndpointPolicy to delete. Must be in the
      format `projects/*/locations/global/endpointPolicies/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEndpointPoliciesGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointPoliciesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEndpointPoliciesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointPoliciesGetRequest object.

  Fields:
    name: Required. A name of the EndpointPolicy to get. Must be in the format
      `projects/*/locations/global/endpointPolicies/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEndpointPoliciesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointPoliciesListRequest object.

  Fields:
    pageSize: Maximum number of EndpointPolicies to return per call.
    pageToken: The value returned by the last `ListEndpointPoliciesResponse`
      Indicates that this is a continuation of a prior `ListEndpointPolicies`
      call, and that the system should return the next page of data.
    parent: Required. The project and location from which the EndpointPolicies
      should be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEndpointPoliciesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointPoliciesPatchRequest object.

  Fields:
    endpointPolicy: A EndpointPolicy resource to be passed as the request
      body.
    name: Required. Name of the EndpointPolicy resource. It matches pattern
      `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`
      .
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the EndpointPolicy resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  endpointPolicy = _messages.MessageField('EndpointPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEndpointPoliciesSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointPoliciesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEndpointPoliciesTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEndpointPoliciesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsGatewaysCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysCreateRequest object.

  Fields:
    gateway: A Gateway resource to be passed as the request body.
    gatewayId: Required. Short name of the Gateway resource to be created.
    parent: Required. The parent resource of the Gateway. Must be in the
      format `projects/*/locations/*`.
  """

  gateway = _messages.MessageField('Gateway', 1)
  gatewayId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsGatewaysDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysDeleteRequest object.

  Fields:
    name: Required. A name of the Gateway to delete. Must be in the format
      `projects/*/locations/*/gateways/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsGatewaysGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsGatewaysGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysGetRequest object.

  Fields:
    name: Required. A name of the Gateway to get. Must be in the format
      `projects/*/locations/*/gateways/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsGatewaysListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysListRequest object.

  Fields:
    pageSize: Maximum number of Gateways to return per call.
    pageToken: The value returned by the last `ListGatewaysResponse` Indicates
      that this is a continuation of a prior `ListGateways` call, and that the
      system should return the next page of data.
    parent: Required. The project and location from which the Gateways should
      be listed, specified in the format `projects/*/locations/*`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsGatewaysPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysPatchRequest object.

  Fields:
    gateway: A Gateway resource to be passed as the request body.
    name: Required. Name of the Gateway resource. It matches pattern
      `projects/*/locations/*/gateways/`.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Gateway resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  gateway = _messages.MessageField('Gateway', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsGatewaysSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsGatewaysTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGatewaysTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsGrpcRoutesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGrpcRoutesCreateRequest object.

  Fields:
    grpcRoute: A GrpcRoute resource to be passed as the request body.
    grpcRouteId: Required. Short name of the GrpcRoute resource to be created.
    parent: Required. The parent resource of the GrpcRoute. Must be in the
      format `projects/*/locations/global`.
  """

  grpcRoute = _messages.MessageField('GrpcRoute', 1)
  grpcRouteId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsGrpcRoutesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGrpcRoutesDeleteRequest object.

  Fields:
    name: Required. A name of the GrpcRoute to delete. Must be in the format
      `projects/*/locations/global/grpcRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsGrpcRoutesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGrpcRoutesGetRequest object.

  Fields:
    name: Required. A name of the GrpcRoute to get. Must be in the format
      `projects/*/locations/global/grpcRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsGrpcRoutesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGrpcRoutesListRequest object.

  Fields:
    pageSize: Maximum number of GrpcRoutes to return per call.
    pageToken: The value returned by the last `ListGrpcRoutesResponse`
      Indicates that this is a continuation of a prior `ListGrpcRoutes` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the GrpcRoutes
      should be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsGrpcRoutesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGrpcRoutesPatchRequest object.

  Fields:
    grpcRoute: A GrpcRoute resource to be passed as the request body.
    name: Required. Name of the GrpcRoute resource. It matches pattern
      `projects/*/locations/global/grpcRoutes/`
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the GrpcRoute resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  grpcRoute = _messages.MessageField('GrpcRoute', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsHttpRoutesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpRoutesCreateRequest object.

  Fields:
    httpRoute: A HttpRoute resource to be passed as the request body.
    httpRouteId: Required. Short name of the HttpRoute resource to be created.
    parent: Required. The parent resource of the HttpRoute. Must be in the
      format `projects/*/locations/global`.
  """

  httpRoute = _messages.MessageField('HttpRoute', 1)
  httpRouteId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsHttpRoutesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpRoutesDeleteRequest object.

  Fields:
    name: Required. A name of the HttpRoute to delete. Must be in the format
      `projects/*/locations/global/httpRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsHttpRoutesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpRoutesGetRequest object.

  Fields:
    name: Required. A name of the HttpRoute to get. Must be in the format
      `projects/*/locations/global/httpRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsHttpRoutesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpRoutesListRequest object.

  Fields:
    pageSize: Maximum number of HttpRoutes to return per call.
    pageToken: The value returned by the last `ListHttpRoutesResponse`
      Indicates that this is a continuation of a prior `ListHttpRoutes` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the HttpRoutes
      should be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsHttpRoutesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpRoutesPatchRequest object.

  Fields:
    httpRoute: A HttpRoute resource to be passed as the request body.
    name: Required. Name of the HttpRoute resource. It matches pattern
      `projects/*/locations/global/httpRoutes/http_route_name>`.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the HttpRoute resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  httpRoute = _messages.MessageField('HttpRoute', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkservicesProjectsLocationsMeshesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesCreateRequest object.

  Fields:
    mesh: A Mesh resource to be passed as the request body.
    meshId: Required. Short name of the Mesh resource to be created.
    parent: Required. The parent resource of the Mesh. Must be in the format
      `projects/*/locations/global`.
  """

  mesh = _messages.MessageField('Mesh', 1)
  meshId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsMeshesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesDeleteRequest object.

  Fields:
    name: Required. A name of the Mesh to delete. Must be in the format
      `projects/*/locations/global/meshes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsMeshesGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsMeshesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesGetRequest object.

  Fields:
    name: Required. A name of the Mesh to get. Must be in the format
      `projects/*/locations/global/meshes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsMeshesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesListRequest object.

  Fields:
    pageSize: Maximum number of Meshes to return per call.
    pageToken: The value returned by the last `ListMeshesResponse` Indicates
      that this is a continuation of a prior `ListMeshes` call, and that the
      system should return the next page of data.
    parent: Required. The project and location from which the Meshes should be
      listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsMeshesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesPatchRequest object.

  Fields:
    mesh: A Mesh resource to be passed as the request body.
    name: Required. Name of the Mesh resource. It matches pattern
      `projects/*/locations/global/meshes/`.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Mesh resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  mesh = _messages.MessageField('Mesh', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsMeshesSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsMeshesTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsMeshesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkservicesProjectsLocationsServiceBindingsCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsServiceBindingsCreateRequest object.

  Fields:
    parent: Required. The parent resource of the ServiceBinding. Must be in
      the format `projects/*/locations/global`.
    serviceBinding: A ServiceBinding resource to be passed as the request
      body.
    serviceBindingId: Required. Short name of the ServiceBinding resource to
      be created.
  """

  parent = _messages.StringField(1, required=True)
  serviceBinding = _messages.MessageField('ServiceBinding', 2)
  serviceBindingId = _messages.StringField(3)


class NetworkservicesProjectsLocationsServiceBindingsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsServiceBindingsDeleteRequest object.

  Fields:
    name: Required. A name of the ServiceBinding to delete. Must be in the
      format `projects/*/locations/global/serviceBindings/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsServiceBindingsGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsServiceBindingsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsServiceBindingsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsServiceBindingsGetRequest object.

  Fields:
    name: Required. A name of the ServiceBinding to get. Must be in the format
      `projects/*/locations/global/serviceBindings/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsServiceBindingsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsServiceBindingsListRequest object.

  Fields:
    pageSize: Maximum number of ServiceBindings to return per call.
    pageToken: The value returned by the last `ListServiceBindingsResponse`
      Indicates that this is a continuation of a prior `ListRouters` call, and
      that the system should return the next page of data.
    parent: Required. The project and location from which the ServiceBindings
      should be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsServiceBindingsSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsServiceBindingsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsServiceBindingsTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsServiceBindingsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsTcpRoutesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTcpRoutesCreateRequest object.

  Fields:
    parent: Required. The parent resource of the TcpRoute. Must be in the
      format `projects/*/locations/global`.
    tcpRoute: A TcpRoute resource to be passed as the request body.
    tcpRouteId: Required. Short name of the TcpRoute resource to be created.
      E.g. TODO(Add an example).
  """

  parent = _messages.StringField(1, required=True)
  tcpRoute = _messages.MessageField('TcpRoute', 2)
  tcpRouteId = _messages.StringField(3)


class NetworkservicesProjectsLocationsTcpRoutesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTcpRoutesDeleteRequest object.

  Fields:
    name: Required. A name of the TcpRoute to delete. Must be in the format
      `projects/*/locations/global/tcpRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsTcpRoutesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTcpRoutesGetRequest object.

  Fields:
    name: Required. A name of the TcpRoute to get. Must be in the format
      `projects/*/locations/global/tcpRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsTcpRoutesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTcpRoutesListRequest object.

  Fields:
    pageSize: Maximum number of TcpRoutes to return per call.
    pageToken: The value returned by the last `ListTcpRoutesResponse`
      Indicates that this is a continuation of a prior `ListTcpRoutes` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the TcpRoutes should
      be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsTcpRoutesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTcpRoutesPatchRequest object.

  Fields:
    name: Required. Name of the TcpRoute resource. It matches pattern
      `projects/*/locations/global/tcpRoutes/tcp_route_name>`.
    tcpRoute: A TcpRoute resource to be passed as the request body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the TcpRoute resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  tcpRoute = _messages.MessageField('TcpRoute', 2)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsTlsRoutesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTlsRoutesCreateRequest object.

  Fields:
    parent: Required. The parent resource of the TlsRoute. Must be in the
      format `projects/*/locations/global`.
    tlsRoute: A TlsRoute resource to be passed as the request body.
    tlsRouteId: Required. Short name of the TlsRoute resource to be created.
      E.g. TODO(Add an example).
  """

  parent = _messages.StringField(1, required=True)
  tlsRoute = _messages.MessageField('TlsRoute', 2)
  tlsRouteId = _messages.StringField(3)


class NetworkservicesProjectsLocationsTlsRoutesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTlsRoutesDeleteRequest object.

  Fields:
    name: Required. A name of the TlsRoute to delete. Must be in the format
      `projects/*/locations/global/tlsRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsTlsRoutesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTlsRoutesGetRequest object.

  Fields:
    name: Required. A name of the TlsRoute to get. Must be in the format
      `projects/*/locations/global/tlsRoutes/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsTlsRoutesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTlsRoutesListRequest object.

  Fields:
    pageSize: Maximum number of TlsRoutes to return per call.
    pageToken: The value returned by the last `ListTlsRoutesResponse`
      Indicates that this is a continuation of a prior `ListTlsRoutes` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the TlsRoutes should
      be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsTlsRoutesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsTlsRoutesPatchRequest object.

  Fields:
    name: Required. Name of the TlsRoute resource. It matches pattern
      `projects/*/locations/global/tlsRoutes/tls_route_name>`.
    tlsRoute: A TlsRoute resource to be passed as the request body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the TlsRoute resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  tlsRoute = _messages.MessageField('TlsRoute', 2)
  updateMask = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class OriginHeaderAction(_messages.Message):
  r"""OriginHeaderAction defines the addition and removal of HTTP headers for
  requests/responses.

  Fields:
    requestHeadersToAdd: Optional. Describes a header to add. You may add a
      maximum of 5 request headers.
  """

  requestHeadersToAdd = _messages.MessageField('OriginHeaderActionAddHeader', 1, repeated=True)


class OriginHeaderActionAddHeader(_messages.Message):
  r"""Describes a header to add.

  Fields:
    headerName: Required. The name of the header to add.
    headerValue: Required. The value of the header to add.
    replace: Optional. Whether to replace all existing headers with the same
      name. By default, added header values are appended to the response or
      request headers with the same field names. The added values are
      separated by commas. To overwrite existing values, set `replace` to
      `true`.
  """

  headerName = _messages.StringField(1)
  headerValue = _messages.StringField(2)
  replace = _messages.BooleanField(3)


class OriginOverrideAction(_messages.Message):
  r"""OriginOverrideAction defines how requests and responses may be
  manipulated on cache fill to this origin.

  Fields:
    headerAction: Optional. The header actions, including adding & removing
      headers, for requests handled by this origin.
    urlRewrite: Optional. The URL rewrite configuration for requests that are
      handled by this origin.
  """

  headerAction = _messages.MessageField('OriginHeaderAction', 1)
  urlRewrite = _messages.MessageField('OriginUrlRewrite', 2)


class OriginRedirect(_messages.Message):
  r"""Options for following redirects from the origin.

  Enums:
    RedirectConditionsValueListEntryValuesEnum:

  Fields:
    redirectConditions: Optional. The set of HTTP redirect response codes that
      the CDN follows.
  """

  class RedirectConditionsValueListEntryValuesEnum(_messages.Enum):
    r"""RedirectConditionsValueListEntryValuesEnum enum type.

    Values:
      REDIRECT_CONDITIONS_UNSPECIFIED: It is an error to specify
        REDIRECT_CONDITIONS_UNSPECIFIED
      MOVED_PERMANENTLY: Follow redirect on an HTTP 301.
      FOUND: Follow redirect on an HTTP 302.
      SEE_OTHER: Follow redirect on an HTTP 303.
      TEMPORARY_REDIRECT: Follow redirect on an HTTP 307.
      PERMANENT_REDIRECT: Follow redirect on an HTTP 308.
    """
    REDIRECT_CONDITIONS_UNSPECIFIED = 0
    MOVED_PERMANENTLY = 1
    FOUND = 2
    SEE_OTHER = 3
    TEMPORARY_REDIRECT = 4
    PERMANENT_REDIRECT = 5

  redirectConditions = _messages.EnumField('RedirectConditionsValueListEntryValuesEnum', 1, repeated=True)


class OriginUrlRewrite(_messages.Message):
  r"""OriginUrlRewrite defines the URL rewrite configuration for a given
  request handled by this origin.

  Fields:
    hostRewrite: Optional. Prior to forwarding the request to the selected
      origin, the request's host header is replaced with contents of
      hostRewrite. The host value must be between 1 and 255 characters.
  """

  hostRewrite = _messages.StringField(1)


class PathMatcher(_messages.Message):
  r"""The name of the `PathMatcher` to use to match the path portion of the
  URL if the HostRule matches the URL's host portion.

  Fields:
    description: Optional. A human-readable description of the resource.
    name: Required. The name to which this `PathMatcher` is referred by the
      HostRule.
    routeRules: Required. A list of RouteRule rules to match against.
      `RouteRule` rules support advanced routing behavior, and can match on
      paths, headers and query parameters, as well as status codes and HTTP
      methods. You must specify at least one rule, and can specify a maximum
      of 64 rules. `RouteRule` rules must not have duplicate priority values.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  routeRules = _messages.MessageField('RouteRule', 3, repeated=True)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PublicKey(_messages.Message):
  r"""An Ed25519 public key used for validating signed requests.

  Fields:
    id: Required. The ID of the public key. The ID must be 1-64 characters
      long, and match the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which
      means the first character must be a letter, and all following characters
      must be a dash, underscore, letter or digit.
    managed: Optional. Set to true to have the CDN automatically manage this
      public key value. Either `value` or `managed` must be specified.
    value: Optional. The base64-encoded value of the Ed25519 public key. The
      base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
      Representations or encodings of the public key other than this are
      rejected with an error. Either `value` or `managed` must be specified.
  """

  id = _messages.StringField(1)
  managed = _messages.BooleanField(2)
  value = _messages.StringField(3)


class QueryParameterMatcher(_messages.Message):
  r"""`QueryParameterMatcher` defines the match conditions for URI query
  parameters.

  Fields:
    exactMatch: Optional. The QueryParameterMatcher matches if the value of
      the parameter exactly matches the contents of `exact_match`. The match
      value must be between 1 and 64 characters long (inclusive). Only one of
      present_match or `exact_match` must be set.
    name: Required. The name of the query parameter to match. The query
      parameter must exist in the request; if it doesn't, the request match
      fails. The name must be specified and be between 1 and 32 characters
      long (inclusive).
    presentMatch: Optional. Specifies that the QueryParameterMatcher matches
      if the request contains the query parameter. The match can succeed as
      long as the request contains the query parameter, regardless of whether
      the parameter has a value or not. Only one of `present_match` or
      exact_match must be set.
  """

  exactMatch = _messages.StringField(1)
  name = _messages.StringField(2)
  presentMatch = _messages.BooleanField(3)


class RouteAction(_messages.Message):
  r"""`RouteAction` defines the actions (such as rewrites, redirects, CORS
  header injection, or header modification) to take for a given route match.

  Fields:
    cdnPolicy: Optional. The policy to use for defining caching and signed
      request behavior for requests that match this route.
    corsPolicy: Optional. The CORS (Cross-Origin Resource Sharing) policy for
      requests that match this route.
    urlRewrite: Optional. The URL rewrite configuration for requests that
      match this route.
  """

  cdnPolicy = _messages.MessageField('CDNPolicy', 1)
  corsPolicy = _messages.MessageField('CORSPolicy', 2)
  urlRewrite = _messages.MessageField('UrlRewrite', 3)


class RouteRule(_messages.Message):
  r"""`RouteRule` defines the priority of a given "route", including its match
  conditions and the actions to take on a request that matches.

  Fields:
    description: Optional. A human-readable description of the `RouteRule`.
    headerAction: Optional. The header actions, including adding and removing
      headers, for requests that match this route.
    matchRules: Required. The list of criteria for matching attributes of a
      request to this `RouteRule`. This list has `OR` semantics: the request
      matches this `RouteRule` when any of the MatchRules are satisfied.
      However, predicates within a given `MatchRule` have `AND` semantics. All
      predicates within a `MatchRule` must match for the request to match the
      rule. You may specify up to 5 match rules.
    origin: Optional. Determines an alternate EdgeCacheOrigin resource that
      this route responds with when a matching response is not in the cache.
      The following are both valid paths to an `EdgeCacheOrigin` resource: *
      `projects/my-project/locations/global/edgeCacheOrigins/my-origin` * `my-
      origin` Only one of `origin` or url_redirect can be set.
    priority: Required. The priority of this route rule, where `1` is the
      highest priority. You cannot configure two or more `RouteRules` with the
      same priority. Priority for each rule must be set to a number between 1
      and 999 inclusive. Priority numbers can have gaps, which enable you to
      add or remove rules in the future without affecting the rest of the
      rules. For example, `1, 2, 3, 4, 5, 9, 12, 16` is a valid series of
      priority numbers to which you could add rules numbered from 6 to 8, 10
      to 11, and 13 to 15 in the future without any impact on existing rules.
    routeAction: Optional. In response to a matching path, the RouteAction
      performs advanced routing actions like URL rewrites, header
      transformations, and so forth prior to forwarding the request to the
      selected origin.
    urlRedirect: Optional. The URL redirect configuration for requests that
      match this route. Only one of origin or `url_redirect` can be set.
  """

  description = _messages.StringField(1)
  headerAction = _messages.MessageField('HeaderAction', 2)
  matchRules = _messages.MessageField('MatchRule', 3, repeated=True)
  origin = _messages.StringField(4)
  priority = _messages.IntegerField(5)
  routeAction = _messages.MessageField('RouteAction', 6)
  urlRedirect = _messages.MessageField('UrlRedirect', 7)


class Routing(_messages.Message):
  r"""Defines how requests are routed, modified, cached, and which origin
  content is filled from.

  Fields:
    hostRules: Required. A list of HostRule rules to match against.
      `RouteRule` rules support advanced routing behavior, and can match on
      paths, headers and query parameters, as well as status codes and HTTP
      methods. You may specify up to 5 host rules.
    pathMatchers: Required. The list of PathMatchers referenced via name by
      HostRules. `PathMatcher` is used to match the path portion of the URL
      when a `HostRule` matches the URL's host portion. You may specify up to
      10 path matchers.
  """

  hostRules = _messages.MessageField('HostRule', 1, repeated=True)
  pathMatchers = _messages.MessageField('PathMatcher', 2, repeated=True)


class Secret(_messages.Message):
  r"""A `Secret` is a secret key stored in Secret Manager.

  Fields:
    secretVersion: Required. The name of the secret in Secret Manager. The
      resource name of the secret version must be in the format
      `projects/*/secrets/*/versions/*` where the `*` values are replaced by
      the secrets themselves. The secrets must be at least 16 bytes large. The
      recommended secret size depends on the signature algorithm you are
      using. * If you are using HMAC-SHA1, we suggest 20-byte secrets. * If
      you are using HMAC-SHA256, we suggest 32-byte secrets. See RFC 2104,
      Section 3 for more details on these recommendations.
  """

  secretVersion = _messages.StringField(1)


class ServiceBinding(_messages.Message):
  r"""ServiceBinding is the resource that defines a Service Directory Service
  to be used in a BackendService resource.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the
      ServiceBinding resource.

  Fields:
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    labels: Optional. Set of label tags associated with the ServiceBinding
      resource.
    name: Required. Name of the ServiceBinding resource. It matches pattern
      `projects/*/locations/global/serviceBindings/service_binding_name`.
    service: Required. The full Service Directory Service name of the format
      projects/*/locations/*/namespaces/*/services/*
    updateTime: Output only. The timestamp when the resource was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the ServiceBinding
    resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  service = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TcpRoute(_messages.Message):
  r"""TcpRoute is the resource defining how TCP traffic should be routed by a
  Mesh/Gateway resource.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the TcpRoute
      resource.

  Fields:
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    gateways: Optional. Gateways defines a list of gateways this TcpRoute is
      attached to, as one of the routing rules to route the requests served by
      the gateway. Each gateway reference should match the pattern:
      `projects/*/locations/global/gateways/`
    labels: Optional. Set of label tags associated with the TcpRoute resource.
    meshes: Optional. Meshes defines a list of meshes this TcpRoute is
      attached to, as one of the routing rules to route the requests served by
      the mesh. Each mesh reference should match the pattern:
      `projects/*/locations/global/meshes/` The attached Mesh should be of a
      type SIDECAR
    name: Required. Name of the TcpRoute resource. It matches pattern
      `projects/*/locations/global/tcpRoutes/tcp_route_name>`.
    rules: Required. Rules that define how traffic is routed and handled. At
      least one RouteRule must be supplied. If there are multiple rules then
      the action taken will be the first rule to match.
    selfLink: Output only. Server-defined URL of this resource
    updateTime: Output only. The timestamp when the resource was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the TcpRoute resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  gateways = _messages.StringField(3, repeated=True)
  labels = _messages.MessageField('LabelsValue', 4)
  meshes = _messages.StringField(5, repeated=True)
  name = _messages.StringField(6)
  rules = _messages.MessageField('TcpRouteRouteRule', 7, repeated=True)
  selfLink = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class TcpRouteRouteAction(_messages.Message):
  r"""The specifications for routing traffic and applying associated policies.

  Fields:
    destinations: Optional. The destination services to which traffic should
      be forwarded. At least one destination service is required.
    originalDestination: Optional. If true, Router will use the destination IP
      and port of the original connection as the destination of the request.
      Default is false.
  """

  destinations = _messages.MessageField('TcpRouteRouteDestination', 1, repeated=True)
  originalDestination = _messages.BooleanField(2)


class TcpRouteRouteDestination(_messages.Message):
  r"""Describe the destination for traffic to be routed to.

  Fields:
    serviceName: Required. The URL of a BackendService to route traffic to.
    weight: Optional. Specifies the proportion of requests forwarded to the
      backend referenced by the serviceName field. This is computed as:
      weight/Sum(weights in this destination list). For non-zero values, there
      may be some epsilon from the exact proportion defined here depending on
      the precision an implementation supports. If only one serviceName is
      specified and it has a weight greater than 0, 100% of the traffic is
      forwarded to that backend. If weights are specified for any one service
      name, they need to be specified for all of them. If weights are
      unspecified for all services, then, traffic is distributed in equal
      proportions to all of them.
  """

  serviceName = _messages.StringField(1)
  weight = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class TcpRouteRouteMatch(_messages.Message):
  r"""RouteMatch defines the predicate used to match requests to a given
  action. Multiple match types are "OR"ed for evaluation. If no routeMatch
  field is specified, this rule will unconditionally match traffic.

  Fields:
    address: Required. Must be specified in the CIDR range format. A CIDR
      range consists of an IP Address and a prefix length to construct the
      subnet mask. By default, the prefix length is 32 (i.e. matches a single
      IP address). Only IPV4 addresses are supported. Examples: "10.0.0.1" -
      matches against this exact IP address. "10.0.0.0/8" - matches against
      any IP address within the 10.0.0.0 subnet and 255.255.255.0 mask.
      "0.0.0.0/0" - matches against any IP address'.
    port: Required. Specifies the destination port to match against.
  """

  address = _messages.StringField(1)
  port = _messages.StringField(2)


class TcpRouteRouteRule(_messages.Message):
  r"""Specifies how to match traffic and how to route traffic when traffic is
  matched.

  Fields:
    action: Required. The detailed rule defining how to route matched traffic.
    matches: Optional. RouteMatch defines the predicate used to match requests
      to a given action. Multiple match types are "OR"ed for evaluation. If no
      routeMatch field is specified, this rule will unconditionally match
      traffic.
  """

  action = _messages.MessageField('TcpRouteRouteAction', 1)
  matches = _messages.MessageField('TcpRouteRouteMatch', 2, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Timeout(_messages.Message):
  r"""The timeout configuration for this origin.

  Fields:
    connectTimeout: Optional. The maximum duration to wait for a single origin
      connection to be established, including DNS lookup, TLS handshake, and
      TCP/QUIC connection establishment. Defaults to 5 seconds. The timeout
      must be a value between 1s and 15s. The `connect_timeout` capped by the
      deadline set by the request's max_attempts_timeout. The last connection
      attempt may have a smaller `connect_timeout` in order to adhere to the
      overall `max_attempts_timeout`.
    maxAttemptsTimeout: Optional. The maximum time across all connection
      attempts to all origins, including failover origins, before returning an
      error to the client. A HTTP 504 is returned if the timeout is reached
      before a response is returned. Defaults to 15 seconds. The timeout must
      be a value between 1s and 30s. If a failover_origin is specified, the
      `max_attempts_timeout` of the first configured origin sets the deadline
      for all connection attempts across all failover_origins.
    readTimeout: Optional. The maximum duration to wait between reads of a
      single HTTP connection/stream. Defaults to 15 seconds. The timeout must
      be a value between 1s and 30s. The `read_timeout` is capped by the
      response_timeout. All reads of the HTTP connection/stream must be
      completed by the deadline set by the response_timeout. If the response
      headers have already been written to the connection, the response is
      truncated and logged.
    responseTimeout: Optional. The maximum duration to wait for the last byte
      of a response to arrive when reading from the HTTP connection/stream.
      Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
      The `response_timeout` starts after the connection has been established.
      Origins that take longer to write additional bytes to the response than
      the configured `response_timeout` result in an error returned to the
      client. If the response headers have already been written to the
      connection, the response is truncated and logged.
  """

  connectTimeout = _messages.StringField(1)
  maxAttemptsTimeout = _messages.StringField(2)
  readTimeout = _messages.StringField(3)
  responseTimeout = _messages.StringField(4)


class TlsRoute(_messages.Message):
  r"""TlsRoute defines how traffic should be routed based on SNI and other
  matching L3 attributes.

  Fields:
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    gateways: Optional. Gateways defines a list of gateways this TlsRoute is
      attached to, as one of the routing rules to route the requests served by
      the gateway. Each gateway reference should match the pattern:
      `projects/*/locations/global/gateways/`
    meshes: Optional. Meshes defines a list of meshes this TlsRoute is
      attached to, as one of the routing rules to route the requests served by
      the mesh. Each mesh reference should match the pattern:
      `projects/*/locations/global/meshes/` The attached Mesh should be of a
      type SIDECAR
    name: Required. Name of the TlsRoute resource. It matches pattern
      `projects/*/locations/global/tlsRoutes/tls_route_name>`.
    rules: Required. Rules that define how traffic is routed and handled. At
      least one RouteRule must be supplied. If there are multiple rules then
      the action taken will be the first rule to match.
    selfLink: Output only. Server-defined URL of this resource
    updateTime: Output only. The timestamp when the resource was updated.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  gateways = _messages.StringField(3, repeated=True)
  meshes = _messages.StringField(4, repeated=True)
  name = _messages.StringField(5)
  rules = _messages.MessageField('TlsRouteRouteRule', 6, repeated=True)
  selfLink = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class TlsRouteRouteAction(_messages.Message):
  r"""The specifications for routing traffic and applying associated policies.

  Fields:
    destinations: Required. The destination services to which traffic should
      be forwarded. At least one destination service is required.
  """

  destinations = _messages.MessageField('TlsRouteRouteDestination', 1, repeated=True)


class TlsRouteRouteDestination(_messages.Message):
  r"""Describe the destination for traffic to be routed to.

  Fields:
    serviceName: Required. The URL of a BackendService to route traffic to.
    weight: Optional. Specifies the proportion of requests forwareded to the
      backend referenced by the service_name field. This is computed as:
      weight/Sum(weights in destinations) Weights in all destinations does not
      need to sum up to 100.
  """

  serviceName = _messages.StringField(1)
  weight = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class TlsRouteRouteMatch(_messages.Message):
  r"""RouteMatch defines the predicate used to match requests to a given
  action. Multiple match types are "AND"ed for evaluation. If no routeMatch
  field is specified, this rule will unconditionally match traffic.

  Fields:
    alpn: Optional. ALPN (Application-Layer Protocol Negotiation) to match
      against. Examples: "http/1.1", "h2". At least one of sni_host and alpn
      is required. Up to 5 alpns across all matches can be set.
    sniHost: Optional. SNI (server name indicator) to match against. SNI will
      be matched against all wildcard domains, i.e. www.example.com will be
      first matched against www.example.com, then *.example.com, then *.com.
      Partial wildcards are not supported, and values like *w.example.com are
      invalid. At least one of sni_host and alpn is required. Up to 5 sni
      hosts across all matches can be set.
  """

  alpn = _messages.StringField(1, repeated=True)
  sniHost = _messages.StringField(2, repeated=True)


class TlsRouteRouteRule(_messages.Message):
  r"""Specifies how to match traffic and how to route traffic when traffic is
  matched.

  Fields:
    action: Required. The detailed rule defining how to route matched traffic.
    matches: Required. RouteMatch defines the predicate used to match requests
      to a given action. Multiple match types are "OR"ed for evaluation.
  """

  action = _messages.MessageField('TlsRouteRouteAction', 1)
  matches = _messages.MessageField('TlsRouteRouteMatch', 2, repeated=True)


class TrafficPortSelector(_messages.Message):
  r"""Specification of a port-based selector.

  Fields:
    ports: Optional. A list of ports. Can be port numbers or port range
      (example, [80-90] specifies all ports from 80 to 90, including 80 and
      90) or named ports or * to specify all ports. If the list is empty, all
      ports are selected.
  """

  ports = _messages.StringField(1, repeated=True)


class UrlRedirect(_messages.Message):
  r"""`UrlRedirect` defines HTTP redirect configuration for a given request.

  Enums:
    RedirectResponseCodeValueValuesEnum: Optional. The HTTP status code to use
      for this redirect action. For a list of supported values, see
      RedirectResponseCode.

  Fields:
    hostRedirect: Optional. The host that is used in the redirect response
      instead of the one that was supplied in the request. The value must be
      between 1 and 255 characters.
    httpsRedirect: Optional. Determines whether the URL scheme in the
      redirected request is adjusted to HTTPS or remains that of the request.
      If it is set to `true` and at least one edge_ssl_certificates is set on
      the service, then the URL scheme in the redirected request is set to
      HTTPS. If it is set to `false`, then the URL scheme of the redirected
      request remains the same as that of the request.
    pathRedirect: Optional. The path that is used in the redirect response
      instead of the one that was supplied in the request. `path_redirect`
      cannot be supplied together with prefix_redirect. Supply one alone or
      neither. If neither is supplied, the path of the original request is
      used for the redirect. The path value must be between 1 and 1024
      characters.
    prefixRedirect: Optional. The prefix that replaces the prefix_match
      specified in the RouteRule, retaining the remaining portion of the URL
      before redirecting the request. `prefix_redirect` cannot be supplied
      together with path_redirect. Supply one alone or neither. If neither is
      supplied, the path of the original request is used for the redirect. The
      prefix value must be between 1 and 1024 characters.
    redirectResponseCode: Optional. The HTTP status code to use for this
      redirect action. For a list of supported values, see
      RedirectResponseCode.
    stripQuery: Optional. Determines whether accompanying query portions of
      the original URL are removed prior to redirecting the request. If it is
      set to `true`, then the accompanying query portion of the original URL
      is removed prior to redirecting the request. If it is set to `false`,
      the query portion of the original URL is retained. The default is
      `false`.
  """

  class RedirectResponseCodeValueValuesEnum(_messages.Enum):
    r"""Optional. The HTTP status code to use for this redirect action. For a
    list of supported values, see RedirectResponseCode.

    Values:
      MOVED_PERMANENTLY_DEFAULT: HTTP 301 Moved Permanently
      FOUND: HTTP 302 Found
      SEE_OTHER: HTTP 303 See Other
      TEMPORARY_REDIRECT: HTTP 307 Temporary Redirect. In this case, the
        request method is retained.
      PERMANENT_REDIRECT: HTTP 308 Permanent Redirect. In this case, the
        request method is retained.
    """
    MOVED_PERMANENTLY_DEFAULT = 0
    FOUND = 1
    SEE_OTHER = 2
    TEMPORARY_REDIRECT = 3
    PERMANENT_REDIRECT = 4

  hostRedirect = _messages.StringField(1)
  httpsRedirect = _messages.BooleanField(2)
  pathRedirect = _messages.StringField(3)
  prefixRedirect = _messages.StringField(4)
  redirectResponseCode = _messages.EnumField('RedirectResponseCodeValueValuesEnum', 5)
  stripQuery = _messages.BooleanField(6)


class UrlRewrite(_messages.Message):
  r"""`UrlRewrite` defines URL rewrite configuration for a given request.

  Fields:
    hostRewrite: Optional. Prior to forwarding the request to the selected
      origin, the request's host header is replaced with contents of
      `host_rewrite`. The host value must be between 1 and 255 characters.
    pathPrefixRewrite: Optional. Prior to forwarding the request to the
      selected origin, the matching portion of the request's path is replaced
      by `path_prefix_rewrite`. If specified, the path value must start with a
      `/` and be between 1 and 1024 characters long (inclusive).
      `path_prefix_rewrite` may only be used when all of a route's match_rules
      specify prefix_match or full_path_match. Only one of
      `path_prefix_rewrite` and path_template_rewrite may be specified.
    pathTemplateRewrite: Optional. Prior to forwarding the request to the
      selected origin, if the request matched a path_template_match, the
      matching portion of the request's path is replaced re-written using the
      pattern specified by `path_template_rewrite`. `path_template_rewrite`
      must be between 1 and 255 characters (inclusive), must start with a `/`,
      and must only use variables captured by the route's
      `path_template_match`. `path_template_rewrite` may only be used when all
      of a route's match_rules specify `path_template_match`. Only one of
      path_prefix_rewrite and `path_template_rewrite` may be specified.
  """

  hostRewrite = _messages.StringField(1)
  pathPrefixRewrite = _messages.StringField(2)
  pathTemplateRewrite = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
