"""Generated message classes for netapp version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'netapp'


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ExportPolicy(_messages.Message):
  r"""ExportPolicy Defined the export policy for the volume.

  Fields:
    rules: Required. List of export policy rules
  """

  rules = _messages.MessageField('SimpleExportPolicyRule', 1, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListStoragePoolsResponse(_messages.Message):
  r"""ListStoragePoolsResponse

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    storagePools: The list of StoragePools
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  storagePools = _messages.MessageField('StoragePool', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListVolumesResponse(_messages.Message):
  r"""ListVolumesResponse Message for response to listing Volumes

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
    volumes: The list of Volume
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  volumes = _messages.MessageField('Volume', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MountOption(_messages.Message):
  r"""MountOption View only mount options for a volume.

  Enums:
    ProtocolTypeValueValuesEnum: Protocol type to mount with.

  Fields:
    export: Export string
    exportFull: Full export string
    instructions: Instructions for mounting
    protocolType: Protocol type to mount with.
  """

  class ProtocolTypeValueValuesEnum(_messages.Enum):
    r"""Protocol type to mount with.

    Values:
      PROTOCOL_TYPE_UNSPECIFIED: Unspecified protocol
      PROTOCOL_TYPE_NFSV3: NFS V3 protocol
      PROTOCOL_TYPE_NFSV4: NFS V4 protocol
      PROTOCOL_TYPE_SMB: SMB protocol
    """
    PROTOCOL_TYPE_UNSPECIFIED = 0
    PROTOCOL_TYPE_NFSV3 = 1
    PROTOCOL_TYPE_NFSV4 = 2
    PROTOCOL_TYPE_SMB = 3

  export = _messages.StringField(1)
  exportFull = _messages.StringField(2)
  instructions = _messages.StringField(3)
  protocolType = _messages.EnumField('ProtocolTypeValueValuesEnum', 4)


class NetappProjectsLocationsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetappProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class NetappProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetappProjectsLocationsStoragepoolsCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragepoolsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    storagePool: A StoragePool resource to be passed as the request body.
    storagePoolId: Required. Id of the requesting storage pool If auto-
      generating Id server-side, remove this field and storage_pool_id from
      the method_signature of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  storagePool = _messages.MessageField('StoragePool', 2)
  storagePoolId = _messages.StringField(3)


class NetappProjectsLocationsStoragepoolsDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragepoolsDeleteRequest object.

  Fields:
    name: Required. Name of the storage pool
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsStoragepoolsGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragepoolsGetRequest object.

  Fields:
    name: Required. Name of the storage pool
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsStoragepoolsListRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragepoolsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. Parent value
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsStoragepoolsPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsStoragepoolsPatchRequest object.

  Fields:
    name: Required. Name of the storage pool
    storagePool: A StoragePool resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the StoragePool resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  storagePool = _messages.MessageField('StoragePool', 2)
  updateMask = _messages.StringField(3)


class NetappProjectsLocationsVolumesCreateRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    volume: A Volume resource to be passed as the request body.
    volumeId: Required. Id of the requesting volume If auto-generating Id
      server-side, remove this field and volume_id from the method_signature
      of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  volume = _messages.MessageField('Volume', 2)
  volumeId = _messages.StringField(3)


class NetappProjectsLocationsVolumesDeleteRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesDeleteRequest object.

  Fields:
    name: Required. Name of the volume
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesGetRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesGetRequest object.

  Fields:
    name: Required. Name of the volume
  """

  name = _messages.StringField(1, required=True)


class NetappProjectsLocationsVolumesListRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListVolumesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetappProjectsLocationsVolumesPatchRequest(_messages.Message):
  r"""A NetappProjectsLocationsVolumesPatchRequest object.

  Fields:
    name: Required. Name of the volume
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Volume resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    volume: A Volume resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  volume = _messages.MessageField('Volume', 3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""OperationMetadata Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      canceled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class SimpleExportPolicyRule(_messages.Message):
  r"""SimpleExportPolicyRule An export policy rule describing various export
  options.

  Enums:
    AccessValueValuesEnum: Access type (ReadWrite, ReadOnly, None)

  Fields:
    access: Access type (ReadWrite, ReadOnly, None)
    allowedClients: List of allowed clients IP addresses
    hasRootAccess: Whether Unix root access will be granted.
    nfsV3: NFS V3 protocol
    nfsV4: NFS V4 protocol
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Access type (ReadWrite, ReadOnly, None)

    Values:
      ACCESS_TYPE_UNSPECIFIED: Unspecified Access Type
      ACCESS_TYPE_READ_ONLY: Read Only
      ACCESS_TYPE_READ_WRITE: Read Write
      ACCESS_TYPE_READ_NONE: None
    """
    ACCESS_TYPE_UNSPECIFIED = 0
    ACCESS_TYPE_READ_ONLY = 1
    ACCESS_TYPE_READ_WRITE = 2
    ACCESS_TYPE_READ_NONE = 3

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  allowedClients = _messages.StringField(2)
  hasRootAccess = _messages.StringField(3)
  nfsV3 = _messages.BooleanField(4)
  nfsV4 = _messages.BooleanField(5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StoragePool(_messages.Message):
  r"""Resources StoragePool StoragePool is a container for volumes with a
  service level and capacity. Volumes can be created in a storage pool of
  sufficient available capacity. StoragePool capacity is what you are billed
  for.

  Enums:
    ServiceLevelValueValuesEnum: Required. Service level of the storage pool
    StateValueValuesEnum: Output only. State of the storage pool

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    capacityGib: Required. Capacity in GIB of the storage pool
    createTime: Output only. Create time of the storage pool
    description: Description of the storage pool
    labels: Labels as key value pairs
    name: Required. Name of the storage pool
    serviceLevel: Required. Service level of the storage pool
    state: Output only. State of the storage pool
    stateDetails: Output only. State details of the storage pool
    storagePoolId: Required. Unique Id of the storage pool
    volumeCapacityGib: Output only. Allocated size of all volumes in GIB in
      the storage pool
    volumeCount: Output only. Volume count of the storage pool
  """

  class ServiceLevelValueValuesEnum(_messages.Enum):
    r"""Required. Service level of the storage pool

    Values:
      SERVICE_LEVEL_UNSPECIFIED: Unspecified service level
      SERVICE_LEVEL_PREMIUM: Premium
      SERVICE_LEVEL_EXTREME: Extreme
    """
    SERVICE_LEVEL_UNSPECIFIED = 0
    SERVICE_LEVEL_PREMIUM = 1
    SERVICE_LEVEL_EXTREME = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the storage pool

    Values:
      RESOURCE_STATE_UNSPECIFIED: Unspecified StoragePool State
      RESOURCE_STATE_READY: Ready
      RESOURCE_STATE_CREATING: Creating
      RESOURCE_STATE_DELETING: Deleting
      RESOURCE_STATE_UPDATING: Updating
    """
    RESOURCE_STATE_UNSPECIFIED = 0
    RESOURCE_STATE_READY = 1
    RESOURCE_STATE_CREATING = 2
    RESOURCE_STATE_DELETING = 3
    RESOURCE_STATE_UPDATING = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  capacityGib = _messages.IntegerField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  serviceLevel = _messages.EnumField('ServiceLevelValueValuesEnum', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  stateDetails = _messages.StringField(8)
  storagePoolId = _messages.StringField(9)
  volumeCapacityGib = _messages.IntegerField(10)
  volumeCount = _messages.IntegerField(11, variant=_messages.Variant.INT32)


class Volume(_messages.Message):
  r"""Volume Volume provides a filesystem that you can mount.

  Enums:
    ProtocolTypesValueListEntryValuesEnum:
    ServiceLevelValueValuesEnum: Output only. Service level of the volume
    StateValueValuesEnum: Output only. State of the volume

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    capacityGib: Required. Capacity in GIB of the volume
    createTime: Output only. Create time of the volume
    description: Description of the volume
    exportPolicy: Required. Export policy of the volume
    labels: Labels as key value pairs
    mountOptions: Output only. Mount options of this volume
    mountPoint: Required. MountPoint or share name of the volume
    name: Required. Name of the volume
    network: Required. VPC Network name
    protocolTypes: Required. Protocol types required for the volume
    psaRange: Name of the Private Service Access allocated range. This is
      optional. If not provided, any available range will be chosen.
    serviceLevel: Output only. Service level of the volume
    state: Output only. State of the volume
    stateDetails: Output only. State details of the volume
    storagePoolName: Required. StoragePool name of the volume
    unixPermissions: Default unix style permission (e.g. 777) the mount point
      will be created with. Applicable for NFS protocol types only.
    volumeId: Required. Unique Id of the volume
  """

  class ProtocolTypesValueListEntryValuesEnum(_messages.Enum):
    r"""ProtocolTypesValueListEntryValuesEnum enum type.

    Values:
      PROTOCOL_TYPE_UNSPECIFIED: Unspecified protocol
      PROTOCOL_TYPE_NFSV3: NFS V3 protocol
      PROTOCOL_TYPE_NFSV4: NFS V4 protocol
      PROTOCOL_TYPE_SMB: SMB protocol
    """
    PROTOCOL_TYPE_UNSPECIFIED = 0
    PROTOCOL_TYPE_NFSV3 = 1
    PROTOCOL_TYPE_NFSV4 = 2
    PROTOCOL_TYPE_SMB = 3

  class ServiceLevelValueValuesEnum(_messages.Enum):
    r"""Output only. Service level of the volume

    Values:
      SERVICE_LEVEL_UNSPECIFIED: Unspecified service level
      SERVICE_LEVEL_PREMIUM: Premium
      SERVICE_LEVEL_EXTREME: Extreme
    """
    SERVICE_LEVEL_UNSPECIFIED = 0
    SERVICE_LEVEL_PREMIUM = 1
    SERVICE_LEVEL_EXTREME = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the volume

    Values:
      VOLUME_STATE_UNSPECIFIED: Unspecified StoragePool State
      VOLUME_STATE_READY: Ready
      VOLUME_STATE_CREATING: Creating
      VOLUME_STATE_DELETING: Deleting
      VOLUME_STATE_UPDATING: Updating
      VOLUME_STATE_RESTORING: Restoring
      VOLUME_STATE_DISABLED: Disabled
    """
    VOLUME_STATE_UNSPECIFIED = 0
    VOLUME_STATE_READY = 1
    VOLUME_STATE_CREATING = 2
    VOLUME_STATE_DELETING = 3
    VOLUME_STATE_UPDATING = 4
    VOLUME_STATE_RESTORING = 5
    VOLUME_STATE_DISABLED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  capacityGib = _messages.IntegerField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  exportPolicy = _messages.MessageField('ExportPolicy', 4)
  labels = _messages.MessageField('LabelsValue', 5)
  mountOptions = _messages.MessageField('MountOption', 6, repeated=True)
  mountPoint = _messages.StringField(7)
  name = _messages.StringField(8)
  network = _messages.StringField(9)
  protocolTypes = _messages.EnumField('ProtocolTypesValueListEntryValuesEnum', 10, repeated=True)
  psaRange = _messages.StringField(11)
  serviceLevel = _messages.EnumField('ServiceLevelValueValuesEnum', 12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  stateDetails = _messages.StringField(14)
  storagePoolName = _messages.StringField(15)
  unixPermissions = _messages.StringField(16)
  volumeId = _messages.StringField(17)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
