"""Generated message classes for alloydb version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'alloydb'


class AlloydbProjectsLocationsBackupsCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsCreateRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    backupId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and backup_id from the method_signature
      of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  backup = _messages.MessageField('Backup', 1)
  backupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class AlloydbProjectsLocationsBackupsDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsDeleteRequest object.

  Fields:
    name: Required. Name of the resource. For the required format, see the
      comment on the Backup.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  validateOnly = _messages.BooleanField(3)


class AlloydbProjectsLocationsBackupsGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsBackupsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListBackupsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AlloydbProjectsLocationsBackupsPatchRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsBackupsPatchRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    name: Output only. The name of the backup resource with the format: *
      projects/{project}/locations/{region}/backups/{backup_id} where the
      cluster and backup ID segments should satisfy the regex expression
      "[a-z]([a-z0-9-]{0,61}[a-z0-9])?", e.g. 1-63 characters of lowercase
      letters, numbers, and dashes, starting with a letter, and ending with a
      letter or number. For more details see https://google.aip.dev/122. The
      prefix of the backup resource name is the name of the parent resource: *
      projects/{project}/locations/{region}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Backup resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  backup = _messages.MessageField('Backup', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class AlloydbProjectsLocationsClustersCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and cluster_id from the method_signature
      of Create RPC
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Cluster.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class AlloydbProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersDeleteRequest object.

  Fields:
    force: Optional. Whether to cascade delete child instances for given
      cluster.
    name: Required. The name of the resource. For the required format, see the
      comment on the Cluster.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class AlloydbProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersGetRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Cluster.name field.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsClustersInstancesCreateRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and instance_id from the method_signature
      of Create RPC
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Instance.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class AlloydbProjectsLocationsClustersInstancesDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesDeleteRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  validateOnly = _messages.BooleanField(3)


class AlloydbProjectsLocationsClustersInstancesFailoverRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesFailoverRequest object.

  Fields:
    failoverInstanceRequest: A FailoverInstanceRequest resource to be passed
      as the request body.
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
  """

  failoverInstanceRequest = _messages.MessageField('FailoverInstanceRequest', 1)
  name = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsClustersInstancesGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesGetRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsClustersInstancesListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Instance.name field. Additionally, you
      can perform an aggregated list operation by specifying a value with one
      of the following formats: * projects/{project}/locations/-/clusters/- *
      projects/{project}/locations/{region}/clusters/-
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AlloydbProjectsLocationsClustersInstancesPatchRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Output only. The name of the instance resource with the format: * pr
      ojects/{project}/locations/{region}/clusters/{cluster_id}/instances/{ins
      tance_id} where the cluster and instance ID segments should satisfy the
      regex expression "[a-z]([a-z0-9-]{0,61}[a-z0-9])?", e.g. 1-63 characters
      of lowercase letters, numbers, and dashes, starting with a letter, and
      ending with a letter or number. For more details see
      https://google.aip.dev/122. The prefix of the instance resource name is
      the name of the parent resource: *
      projects/{project}/locations/{region}/clusters/{cluster_id}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Instance resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class AlloydbProjectsLocationsClustersInstancesRestartRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersInstancesRestartRequest object.

  Fields:
    name: Required. The name of the resource. For the required format, see the
      comment on the Instance.name field.
    restartInstanceRequest: A RestartInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  restartInstanceRequest = _messages.MessageField('RestartInstanceRequest', 2)


class AlloydbProjectsLocationsClustersListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Cluster.name field. Additionally, you can
      perform an aggregated list operation by specifying a value with the
      following format: * projects/{project}/locations/-
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AlloydbProjectsLocationsClustersPatchRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Output only. The name of the cluster resource with the format: *
      projects/{project}/locations/{region}/clusters/{cluster_id} where the
      cluster ID segment should satisfy the regex expression
      "[a-z]([a-z0-9-]{0,61}[a-z0-9])?", e.g. 1-63 characters of lowercase
      letters, numbers, and dashes, starting with a letter, and ending with a
      letter or number. For more details see https://google.aip.dev/122. The
      prefix of the cluster resource name is the name of the parent resource:
      * projects/{project}/locations/{region}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Cluster resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class AlloydbProjectsLocationsClustersRestoreRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsClustersRestoreRequest object.

  Fields:
    parent: Required. The name of the parent resource. For the required
      format, see the comment on the Cluster.name field.
    restoreClusterRequest: A RestoreClusterRequest resource to be passed as
      the request body.
  """

  parent = _messages.StringField(1, required=True)
  restoreClusterRequest = _messages.MessageField('RestoreClusterRequest', 2)


class AlloydbProjectsLocationsGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AlloydbProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class AlloydbProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AlloydbProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AlloydbProjectsLocationsSupportedDatabaseFlagsListRequest(_messages.Message):
  r"""A AlloydbProjectsLocationsSupportedDatabaseFlagsListRequest object.

  Fields:
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. The name of the parent resource. The required format is:
      * projects/{project}/locations/{location} Regardless of the parent
      specified here, as long it is contains a valid project and location, the
      service will return a static list of supported flags resources. Note
      that we do not not yet support region-specific flags (see b/211502903).
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AutomatedBackupPolicy(_messages.Message):
  r"""Message describing the user-specified automated backup policy. NEXT_ID:
  9

  Messages:
    LabelsValue: Labels to apply to backups created using this configuration.

  Fields:
    backupWindow: Optional. The length of the time window during which a
      backup can be taken. If a backup does not succeed within this time
      window, it will be canceled and considered failed. The backup window
      must be at least 5 minutes long. There is no upper bound on the window.
      If not set, it will default to 1 hour.
    enabled: Whether automated automated backups are enabled.
    labels: Labels to apply to backups created using this configuration.
    location: The location where the backup will be stored. Currently, the
      only supported option is to store the backup in the same region as the
      cluster.
    quantityBasedRetention: A QuantityBasedRetention attribute.
    timeBasedRetention: A TimeBasedRetention attribute.
    weeklySchedule: A WeeklySchedule attribute.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to backups created using this configuration.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupWindow = _messages.StringField(1)
  enabled = _messages.BooleanField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  location = _messages.StringField(4)
  quantityBasedRetention = _messages.MessageField('QuantityBasedRetention', 5)
  timeBasedRetention = _messages.MessageField('TimeBasedRetention', 6)
  weeklySchedule = _messages.MessageField('WeeklySchedule', 7)


class Backup(_messages.Message):
  r"""Message describing Backup object NEXT ID: 13

  Enums:
    StateValueValuesEnum: Output only. The current state of the backup.
    TypeValueValuesEnum: The backup type, which suggests the trigger for the
      backup.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    clusterName: Required. The full resource name of the backup source cluster
      (e.g., projects//locations//clusters/).
    createTime: Output only. Create time stamp
    description: Optional. User-provided description of the backup.
    labels: Labels as key value pairs
    name: Output only. The name of the backup resource with the format: *
      projects/{project}/locations/{region}/backups/{backup_id} where the
      cluster and backup ID segments should satisfy the regex expression
      "[a-z]([a-z0-9-]{0,61}[a-z0-9])?", e.g. 1-63 characters of lowercase
      letters, numbers, and dashes, starting with a letter, and ending with a
      letter or number. For more details see https://google.aip.dev/122. The
      prefix of the backup resource name is the name of the parent resource: *
      projects/{project}/locations/{region}
    reconciling: Output only. Reconciling
      (https://google.aip.dev/128#reconciliation), if true, indicates that the
      service is actively updating the resource. This can happen due to user-
      triggered updates or system actions like failover or maintenance.
    state: Output only. The current state of the backup.
    type: The backup type, which suggests the trigger for the backup.
    uid: Output only. The system-generated UID of the resource. The UID is
      assigned when the resource is created, and it is retained until it is
      deleted.
    updateTime: Output only. Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the backup.

    Values:
      STATE_UNSPECIFIED: The state of the backup is unknown.
      READY: The backup is ready.
      CREATING: The backup is creating.
      FAILED: The backup failed.
      DELETING: The backup is being deleted.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    CREATING = 2
    FAILED = 3
    DELETING = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""The backup type, which suggests the trigger for the backup.

    Values:
      TYPE_UNSPECIFIED: <no description>
      ON_DEMAND: ON_DEMAND backups that were triggered by the customer (e.g.,
        not AUTOMATED).
      AUTOMATED: AUTOMATED backups triggered by the automated backups
        scheduler pursuant to an automated backup policy.
    """
    TYPE_UNSPECIFIED = 0
    ON_DEMAND = 1
    AUTOMATED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  reconciling = _messages.BooleanField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  type = _messages.EnumField('TypeValueValuesEnum', 8)
  uid = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class BackupSource(_messages.Message):
  r"""Message describing a BackupSource.

  Fields:
    backupName: Required. The name of the backup resource with the format: *
      projects/{project}/locations/{region}/backups/{backup_id}
  """

  backupName = _messages.StringField(1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Cluster(_messages.Message):
  r"""Message describing Cluster object NEXT_ID: 19

  Enums:
    DatabaseVersionValueValuesEnum: Output only. The database engine major
      version. This is an output-only field and it's populated at the Cluster
      creation time. This field cannot be changed after cluster creation.
    StateValueValuesEnum: Output only. The current serving state of the
      cluster.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    automatedBackupPolicy: Optional. The automated backup policy for this
      cluster. If no policy is provided then the default policy will be used.
      The default policy takes one backup a day, has a backup window of 1
      hour, and retains backups for 14 days.
    backupSource: A BackupSource attribute.
    createTime: Output only. Create time stamp
    databaseVersion: Output only. The database engine major version. This is
      an output-only field and it's populated at the Cluster creation time.
      This field cannot be changed after cluster creation.
    initialUser: Input only. Initial user to setup during cluster creation.
      Required. If used in `RestoreCluster` this is ignored. We intend to
      deprecate this post private preview, once we have separate User
      resources.
    labels: Labels as key value pairs
    migrationSource: A MigrationSource attribute.
    name: Output only. The name of the cluster resource with the format: *
      projects/{project}/locations/{region}/clusters/{cluster_id} where the
      cluster ID segment should satisfy the regex expression
      "[a-z]([a-z0-9-]{0,61}[a-z0-9])?", e.g. 1-63 characters of lowercase
      letters, numbers, and dashes, starting with a letter, and ending with a
      letter or number. For more details see https://google.aip.dev/122. The
      prefix of the cluster resource name is the name of the parent resource:
      * projects/{project}/locations/{region}
    network: The resource link for the VPC network in which cluster resources
      are created and from which they are accessible via Private IP. The
      network must belong to the same project as the cluster. It is specified
      in the form: "projects/{project_number}/global/networks/{network_id}".
      This is required to create a cluster. It can be updated, but it cannot
      be removed.
    reconciling: Output only. Reconciling
      (https://google.aip.dev/128#reconciliation), if true, indicates that the
      service is actively updating the resource. This can happen due to user-
      triggered updates or system actions like failover or maintenance.
    state: Output only. The current serving state of the cluster.
    uid: Output only. The system-generated UID of the resource. The UID is
      assigned when the resource is created, and it is retained until it is
      deleted.
    updateTime: Output only. Update time stamp
  """

  class DatabaseVersionValueValuesEnum(_messages.Enum):
    r"""Output only. The database engine major version. This is an output-only
    field and it's populated at the Cluster creation time. This field cannot
    be changed after cluster creation.

    Values:
      DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      POSTGRES_13: DEPRECATED - The database version is Postgres 13.
      POSTGRES_14: The database version is Postgres 14.
    """
    DATABASE_VERSION_UNSPECIFIED = 0
    POSTGRES_13 = 1
    POSTGRES_14 = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current serving state of the cluster.

    Values:
      STATE_UNSPECIFIED: The state of the cluster is unknown.
      READY: The cluster is active and running.
      STOPPED: The cluster is stopped. All instances in the cluster are
        stopped. Customers can start a stopped cluster at any point and all
        their instances will come back to life with same names and IP
        resources. In this state, customer pays for storage.
      EMPTY: The cluster is empty and has no associated resources. All
        instances, associated storage and backups have been deleted.
      CREATING: The cluster is being created.
      DELETING: The cluster is being deleted.
      FAILED: The creation of the cluster failed.
      BOOTSTRAPPING: The cluster is bootstrapping with data from some other
        source. Direct mutations to the cluster (e.g. adding read pool) are
        not allowed.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    STOPPED = 2
    EMPTY = 3
    CREATING = 4
    DELETING = 5
    FAILED = 6
    BOOTSTRAPPING = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  automatedBackupPolicy = _messages.MessageField('AutomatedBackupPolicy', 1)
  backupSource = _messages.MessageField('BackupSource', 2)
  createTime = _messages.StringField(3)
  databaseVersion = _messages.EnumField('DatabaseVersionValueValuesEnum', 4)
  initialUser = _messages.MessageField('UserPassword', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  migrationSource = _messages.MessageField('MigrationSource', 7)
  name = _messages.StringField(8)
  network = _messages.StringField(9)
  reconciling = _messages.BooleanField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  uid = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class FailoverInstanceRequest(_messages.Message):
  r"""Message for triggering failover on an Instance

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  requestId = _messages.StringField(1)
  validateOnly = _messages.BooleanField(2)


class Instance(_messages.Message):
  r"""Message describing Instance object NEXT ID: 17

  Enums:
    AvailabilityTypeValueValuesEnum: Availability type of an Instance.
      Defaults to REGIONAL for both primary and read instances. Note that
      primary and read instances can have different availability types.
    InstanceTypeValueValuesEnum:
    StateValueValuesEnum: Output only. The current serving state of the
      instance.

  Messages:
    DatabaseFlagsValue: Database flags. Set at instance level. * They are
      copied from primary instance on read instance creation. * Read instances
      can set new or override existing flags that are relevant for reads, e.g.
      for enabling columnar cache on a read instance. Flags set on read
      instance may or may not be present on primary.
    LabelsValue: Labels as key value pairs

  Fields:
    availabilityType: Availability type of an Instance. Defaults to REGIONAL
      for both primary and read instances. Note that primary and read
      instances can have different availability types.
    createTime: Output only. Create time stamp
    databaseFlags: Database flags. Set at instance level. * They are copied
      from primary instance on read instance creation. * Read instances can
      set new or override existing flags that are relevant for reads, e.g. for
      enabling columnar cache on a read instance. Flags set on read instance
      may or may not be present on primary.
    gceZone: The GCE zone that the instance should serve from. Optional. This
      can ONLY be specified for ZONAL instances. If present for a REGIONAL
      instance, an error will be thrown. If this is absent for a ZONAL
      instance, instance is created in a random zone with available capacity.
    instanceType: A InstanceTypeValueValuesEnum attribute.
    ipAddress: Output only. The IP address for the Instance. This is the
      connection endpoint for an end-user application.
    labels: Labels as key value pairs
    machineConfig: Configurations for the machines that host the underlying
      database engine.
    name: Output only. The name of the instance resource with the format: * pr
      ojects/{project}/locations/{region}/clusters/{cluster_id}/instances/{ins
      tance_id} where the cluster and instance ID segments should satisfy the
      regex expression "[a-z]([a-z0-9-]{0,61}[a-z0-9])?", e.g. 1-63 characters
      of lowercase letters, numbers, and dashes, starting with a letter, and
      ending with a letter or number. For more details see
      https://google.aip.dev/122. The prefix of the instance resource name is
      the name of the parent resource: *
      projects/{project}/locations/{region}/clusters/{cluster_id}
    readPoolConfig: Read pool specific config.
    reconciling: Output only. Reconciling
      (https://google.aip.dev/128#reconciliation), if true, indicates that the
      service is actively updating the resource. This can happen due to user-
      triggered updates or system actions like failover or maintenance.
    state: Output only. The current serving state of the instance.
    uid: Output only. The system-generated UID of the resource. The UID is
      assigned when the resource is created, and it is retained until it is
      deleted.
    updateTime: Output only. Update time stamp
  """

  class AvailabilityTypeValueValuesEnum(_messages.Enum):
    r"""Availability type of an Instance. Defaults to REGIONAL for both
    primary and read instances. Note that primary and read instances can have
    different availability types.

    Values:
      AVAILABILITY_TYPE_UNSPECIFIED: This is an unknown Availability type.
      ZONAL: Zonal available instance.
      REGIONAL: Regional (or Highly) available instance.
    """
    AVAILABILITY_TYPE_UNSPECIFIED = 0
    ZONAL = 1
    REGIONAL = 2

  class InstanceTypeValueValuesEnum(_messages.Enum):
    r"""InstanceTypeValueValuesEnum enum type.

    Values:
      INSTANCE_TYPE_UNSPECIFIED: <no description>
      PRIMARY: PRIMARY instances support read and write operations.
      READ_POOL: READ_POOL instances support read operations only. Each read
        pool instance consists of one or more homogeneous nodes. * Read pool
        of size 1 can only have zonal availability. * Read pools with node
        count of 2 or more can have regional availability (nodes are present
        in 2 or more zones in a region).
    """
    INSTANCE_TYPE_UNSPECIFIED = 0
    PRIMARY = 1
    READ_POOL = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current serving state of the instance.

    Values:
      STATE_UNSPECIFIED: The state of the instance is unknown.
      READY: The instance is active and running.
      STOPPED: The instance is stopped. Instance name and IP resources are
        preserved.
      CREATING: The instance is being created.
      DELETING: The instance is being deleted.
      MAINTENANCE: The instance is down for maintenance.
      FAILED: The creation of the instance failed or a fatal error occurred
        during an operation on the instance. Note: Instances in this state
        would tried to be auto-repaired. And Customers should be able to
        restart, update or delete these instances.
      BOOTSTRAPPING: Index 7 is used in the producer apis for ROLLED_BACK
        state. Keeping that index unused in case that state also needs to
        exposed via consumer apis in future. The instance has been configured
        to sync data from some other source.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    STOPPED = 2
    CREATING = 3
    DELETING = 4
    MAINTENANCE = 5
    FAILED = 6
    BOOTSTRAPPING = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DatabaseFlagsValue(_messages.Message):
    r"""Database flags. Set at instance level. * They are copied from primary
    instance on read instance creation. * Read instances can set new or
    override existing flags that are relevant for reads, e.g. for enabling
    columnar cache on a read instance. Flags set on read instance may or may
    not be present on primary.

    Messages:
      AdditionalProperty: An additional property for a DatabaseFlagsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DatabaseFlagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DatabaseFlagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  availabilityType = _messages.EnumField('AvailabilityTypeValueValuesEnum', 1)
  createTime = _messages.StringField(2)
  databaseFlags = _messages.MessageField('DatabaseFlagsValue', 3)
  gceZone = _messages.StringField(4)
  instanceType = _messages.EnumField('InstanceTypeValueValuesEnum', 5)
  ipAddress = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  machineConfig = _messages.MessageField('MachineConfig', 8)
  name = _messages.StringField(9)
  readPoolConfig = _messages.MessageField('ReadPoolConfig', 10)
  reconciling = _messages.BooleanField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  uid = _messages.StringField(13)
  updateTime = _messages.StringField(14)


class IntegerRestrictions(_messages.Message):
  r"""Restrictions on INTEGER type values.

  Fields:
    maxValue: The maximum value that can be specified, if applicable.
    minValue: The minimum value that can be specified, if applicable.
  """

  maxValue = _messages.IntegerField(1)
  minValue = _messages.IntegerField(2)


class ListBackupsResponse(_messages.Message):
  r"""Message for response to listing Backups

  Fields:
    backups: The list of Backup
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListClustersResponse(_messages.Message):
  r"""Message for response to listing Clusters

  Fields:
    clusters: The list of Cluster
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListInstancesResponse(_messages.Message):
  r"""Message for response to listing Instances

  Fields:
    instances: The list of Instance
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSupportedDatabaseFlagsResponse(_messages.Message):
  r"""Message for response to listing SupportedDatabaseFlags.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    supportedDatabaseFlags: The list of SupportedDatabaseFlags.
  """

  nextPageToken = _messages.StringField(1)
  supportedDatabaseFlags = _messages.MessageField('SupportedDatabaseFlag', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MachineConfig(_messages.Message):
  r"""MachineConfig describes the configuration of a machine.

  Fields:
    cpuCount: The number of CPU's in the VM instance.
  """

  cpuCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class MigrationSource(_messages.Message):
  r"""Subset of the source instance configuration that is available when
  reading the cluster resource. NEXT_ID: 4

  Enums:
    SourceTypeValueValuesEnum:

  Fields:
    hostPort: Output only. The host and port of the on-premises instance in
      host:port format
    referenceId: Output only. Place holder for the external source
      identifier(e.g DMS job name) that created the cluster.
    sourceType: A SourceTypeValueValuesEnum attribute.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""SourceTypeValueValuesEnum enum type.

    Values:
      MIGRATION_SOURCE_TYPE_UNSPECIFIED: <no description>
      DMS: DMS source means the cluster was created via DMS migration job.
    """
    MIGRATION_SOURCE_TYPE_UNSPECIFIED = 0
    DMS = 1

  hostPort = _messages.StringField(1)
  referenceId = _messages.StringField(2)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class QuantityBasedRetention(_messages.Message):
  r"""A quantity based policy specifies that a certain number of the most
  recent successful backups should be retained.

  Fields:
    count: The number of backups to retain.
  """

  count = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ReadPoolConfig(_messages.Message):
  r"""Configuration for a read pool instance.

  Fields:
    nodeCount: Read capacity, i.e. number of nodes in a read pool instance.
  """

  nodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class RestartInstanceRequest(_messages.Message):
  r"""A RestartInstanceRequest object.

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  requestId = _messages.StringField(1)
  validateOnly = _messages.BooleanField(2)


class RestoreClusterRequest(_messages.Message):
  r"""Message for restoring a Cluster from a backup

  Fields:
    backupSource: A BackupSource attribute.
    cluster: Required. The resource being created Passing initial_user is
      ignored by `RestoreCluster`
    clusterId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and cluster_id from the method_signature
      of Create RPC
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, the backend validates the request, but
      doesn't actually execute it.
  """

  backupSource = _messages.MessageField('BackupSource', 1)
  cluster = _messages.MessageField('Cluster', 2)
  clusterId = _messages.StringField(3)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StringRestrictions(_messages.Message):
  r"""Restrictions on STRING type values

  Fields:
    allowedValues: The list of allowed values, if bounded. This field will be
      empty if there is a unbounded number of allowed values.
  """

  allowedValues = _messages.StringField(1, repeated=True)


class SupportedDatabaseFlag(_messages.Message):
  r"""SupportedDatabaseFlag gives general information about a database flag,
  like type and allowed values. This is a static value that is defined on the
  server side, and it cannot be modified by callers. To set the Database flags
  on a particular Instance, a caller should modify the Instance.database_flags
  field.

  Enums:
    SupportedDbVersionsValueListEntryValuesEnum:
    ValueTypeValueValuesEnum:

  Fields:
    acceptsMultipleValues: Whether the database flag accepts multiple values.
      If true, a comma-separated list of stringified values may be specified.
    flagName: The name of the database flag, e.g. "max_allowed_packets". The
      is a possibly key for the Instance.database_flags map field.
    integerRestrictions: A IntegerRestrictions attribute.
    name: The name of the flag resource, following GCP conventions, e.g.: *
      projects/{project}/locations/{location}/flags/{flag_id} This field
      currently has no semantic meaning.
    requiresDbRestart: Whether setting or updating this flag on an Instance
      requires a database restart. If a flag that requires database restart is
      set, the backend will automatically restart the database (making sure to
      satisfy any availability SLO's).
    stringRestrictions: A StringRestrictions attribute.
    supportedDbVersions: Major database engine versions for which this flag is
      supported.
    valueType: A ValueTypeValueValuesEnum attribute.
  """

  class SupportedDbVersionsValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedDbVersionsValueListEntryValuesEnum enum type.

    Values:
      DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      POSTGRES_13: DEPRECATED - The database version is Postgres 13.
      POSTGRES_14: The database version is Postgres 14.
    """
    DATABASE_VERSION_UNSPECIFIED = 0
    POSTGRES_13 = 1
    POSTGRES_14 = 2

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""ValueTypeValueValuesEnum enum type.

    Values:
      TYPE_UNSPECIFIED: This is an unknown flag type.
      STRING: String type flag.
      INTEGER: Integer type flag.
      FLOAT: Float type flag.
      NONE: Denotes that the flag does not accept any values.
    """
    TYPE_UNSPECIFIED = 0
    STRING = 1
    INTEGER = 2
    FLOAT = 3
    NONE = 4

  acceptsMultipleValues = _messages.BooleanField(1)
  flagName = _messages.StringField(2)
  integerRestrictions = _messages.MessageField('IntegerRestrictions', 3)
  name = _messages.StringField(4)
  requiresDbRestart = _messages.BooleanField(5)
  stringRestrictions = _messages.MessageField('StringRestrictions', 6)
  supportedDbVersions = _messages.EnumField('SupportedDbVersionsValueListEntryValuesEnum', 7, repeated=True)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 8)


class TimeBasedRetention(_messages.Message):
  r"""A time based retention policy specifies that all backups within a
  certain time period should be retained.

  Fields:
    retentionPeriod: The retention period.
  """

  retentionPeriod = _messages.StringField(1)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class UserPassword(_messages.Message):
  r"""The username/password for a database user. Used for specifying initial
  users at cluster creation time.

  Fields:
    password: The initial password for the user.
    user: The database username.
  """

  password = _messages.StringField(1)
  user = _messages.StringField(2)


class WeeklySchedule(_messages.Message):
  r"""A weekly schedule starts a backup at prescribed start times within a
  day, for the specified days of the week. The weekly schedule message is
  flexible and can be used to create many types of schedules. For example, to
  have a daily backup that starts at 22:00, configure the `start_times` field
  to have one element "22:00" and the `days_of_week` field to have all seven
  days of the week.

  Enums:
    DaysOfWeekValueListEntryValuesEnum:

  Fields:
    daysOfWeek: The days of the week to perform a backup. At least one day of
      the week must be provided.
    startTimes: The times during the day to start a backup. At least one start
      time must be provided. The start times are assumed to be in UTC and
      required to be an exact hour (e.g., 04:00:00).
  """

  class DaysOfWeekValueListEntryValuesEnum(_messages.Enum):
    r"""DaysOfWeekValueListEntryValuesEnum enum type.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  daysOfWeek = _messages.EnumField('DaysOfWeekValueListEntryValuesEnum', 1, repeated=True)
  startTimes = _messages.MessageField('TimeOfDay', 2, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
