# -*- coding: utf-8 -*- #
# Copyright 2022 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Commands for interacting with the Network Connectivity API."""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from googlecloudsdk.api_lib.network_connectivity import networkconnectivity_util
from googlecloudsdk.calliope import base


class SpokesClient(object):
  """Client for spoke service in network connectivity API."""

  def __init__(self, release_track=base.ReleaseTrack.GA):
    self.release_track = release_track
    self.client = networkconnectivity_util.GetClientInstance(release_track)
    self.messages = networkconnectivity_util.GetMessagesModule(release_track)
    self.spoke_service = self.client.projects_locations_spokes
    self.operation_service = self.client.projects_locations_operations

  def Activate(self, spoke_ref):
    activate_req_type = (
        self.messages.NetworkconnectivityProjectsLocationsSpokesActivateRequest)
    activate_req = activate_req_type(name=spoke_ref.RelativeName())
    return self.spoke_service.Activate(activate_req)

  def Deactivate(self, spoke_ref):
    deactivate_req_type = (
        self.messages
        .NetworkconnectivityProjectsLocationsSpokesDeactivateRequest)
    deactivate_req = deactivate_req_type(name=spoke_ref.RelativeName())
    return self.spoke_service.Deactivate(deactivate_req)

  def Delete(self, spoke_ref):
    delete_req_type = (
        self.messages.NetworkconnectivityProjectsLocationsSpokesDeleteRequest)
    delete_req = delete_req_type(name=spoke_ref.RelativeName())
    return self.spoke_service.Delete(delete_req)

  def Get(self, spoke_ref):
    get_req_type = (
        self.messages.NetworkconnectivityProjectsLocationsSpokesGetRequest)
    get_req = get_req_type(name=spoke_ref.RelativeName())
    return self.spoke_service.Get(get_req)
