"""Generated message classes for securedlandingzone version v1beta.

WIP
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'securedlandingzone'


class GoogleCloudSecuredlandingzoneV1betaActivateOverwatchRequest(_messages.Message):
  r"""The request message for bringing the overwatch in active state."""


class GoogleCloudSecuredlandingzoneV1betaEnableOverwatchRequest(_messages.Message):
  r"""The request message for enabling Overwatch for an organization in a
  region.
  """



class GoogleCloudSecuredlandingzoneV1betaEnableOverwatchResponse(_messages.Message):
  r"""The response message for enabling Overwatch on an organization in a
  region.

  Fields:
    serviceAccount: Required. The service account created to grant the
      required permissions for Overwatch to create/manage resources.
  """

  serviceAccount = _messages.StringField(1)


class GoogleCloudSecuredlandingzoneV1betaListOverwatchesResponse(_messages.Message):
  r"""The response message for ListOverwatch.

  Fields:
    nextPageToken: A pagination token returned from a previous call to
      `ListOverwatches` that indicates where listing should continue.
    overwatches: List of Overwatch resources under the specified parent in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  overwatches = _messages.MessageField('GoogleCloudSecuredlandingzoneV1betaOverwatch', 2, repeated=True)


class GoogleCloudSecuredlandingzoneV1betaOverwatch(_messages.Message):
  r"""The Overwatch resource which holds all meta data related to an Overwatch
  instance.

  Enums:
    StateValueValuesEnum: Output only. The operation state of Overwatch
      resource that decides if response actions will be taken upon receiving
      drift or threat signals. This field is mutable by using
      ActivateOverwatch or SuspendOverwatch only.

  Fields:
    createTime: Output only. Creation time.
    name: Output only. The resource name of this overwatch resource. In the
      format of organizations/{org_id}/locations/{location_id}/overwatches/{ov
      erwatch_id}.
    planData: Input only. The terraform plan file passed as bytes.
    remediationServiceAccount: Output only. This service account will be used
      by overwatch for remediating drifts.
    state: Output only. The operation state of Overwatch resource that decides
      if response actions will be taken upon receiving drift or threat
      signals. This field is mutable by using ActivateOverwatch or
      SuspendOverwatch only.
    updateTime: Output only. Update time.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The operation state of Overwatch resource that decides if
    response actions will be taken upon receiving drift or threat signals.
    This field is mutable by using ActivateOverwatch or SuspendOverwatch only.

    Values:
      STATE_UNSPECIFIED: Unspecified operation state.
      SUSPENDED: The state where the Overwatch is suspended, and no response
        actions are taken.
      ACTIVE: The default state where the Overwatch is active, and response
        actions will be taken based on the playbook if signals are received.
      CREATING: The state in which the overwatch is not completely created.
      DELETING: The state in which the overwatch is not completely deleted.
      UPDATING: The state in which the overwatch is not completely updated.
    """
    STATE_UNSPECIFIED = 0
    SUSPENDED = 1
    ACTIVE = 2
    CREATING = 3
    DELETING = 4
    UPDATING = 5

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  planData = _messages.BytesField(3)
  remediationServiceAccount = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updateTime = _messages.StringField(6)


class GoogleCloudSecuredlandingzoneV1betaSuspendOverwatchRequest(_messages.Message):
  r"""The request message for bringing the overwatch in suspend state."""


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SecuredlandingzoneOrganizationsLocationsEnableOverwatchRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsEnableOverwatchRequest object.

  Fields:
    googleCloudSecuredlandingzoneV1betaEnableOverwatchRequest: A
      GoogleCloudSecuredlandingzoneV1betaEnableOverwatchRequest resource to be
      passed as the request body.
    organization: Required. Organization for which overwatch service has to be
      enabled. organizations/{org_id}
  """

  googleCloudSecuredlandingzoneV1betaEnableOverwatchRequest = _messages.MessageField('GoogleCloudSecuredlandingzoneV1betaEnableOverwatchRequest', 1)
  organization = _messages.StringField(2, required=True)


class SecuredlandingzoneOrganizationsLocationsOperationsGetRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SecuredlandingzoneOrganizationsLocationsOverwatchesActivateRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOverwatchesActivateRequest
  object.

  Fields:
    googleCloudSecuredlandingzoneV1betaActivateOverwatchRequest: A
      GoogleCloudSecuredlandingzoneV1betaActivateOverwatchRequest resource to
      be passed as the request body.
    name: Required. The resource name of the overwatch run. name:
      organizations/{org_id}/locations/{location_id}/overwatches/{overwatch_id
      }
  """

  googleCloudSecuredlandingzoneV1betaActivateOverwatchRequest = _messages.MessageField('GoogleCloudSecuredlandingzoneV1betaActivateOverwatchRequest', 1)
  name = _messages.StringField(2, required=True)


class SecuredlandingzoneOrganizationsLocationsOverwatchesCreateRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOverwatchesCreateRequest
  object.

  Fields:
    googleCloudSecuredlandingzoneV1betaOverwatch: A
      GoogleCloudSecuredlandingzoneV1betaOverwatch resource to be passed as
      the request body.
    overwatchId: Required. Unique id per organization for an overwatch
      instance
    parent: Required. The parent resource name of this Overwatch resource.
      Currently the only parent resource supported is an organization.
      organizations/{org_id}/locations/{location_id}
  """

  googleCloudSecuredlandingzoneV1betaOverwatch = _messages.MessageField('GoogleCloudSecuredlandingzoneV1betaOverwatch', 1)
  overwatchId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuredlandingzoneOrganizationsLocationsOverwatchesDeleteRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOverwatchesDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the overwatch to delete. name:
      organizations/{org_id}/locations/{location_id}/overwatches/{overwatch_id
      }
  """

  name = _messages.StringField(1, required=True)


class SecuredlandingzoneOrganizationsLocationsOverwatchesGetRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOverwatchesGetRequest object.

  Fields:
    name: Required. The resource name of the overwatch to get. name:
      organizations/{org_id}/locations/{location_id}/overwatches/{overwatch_id
      }
  """

  name = _messages.StringField(1, required=True)


class SecuredlandingzoneOrganizationsLocationsOverwatchesListRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOverwatchesListRequest object.

  Fields:
    pageSize: Optional. The page size for the list result. If unspecified, at
      most 50 Overwatches will be returned.
    pageToken: Optional. A pagination token indicates from where listing
      should continue in the next call.
    parent: Required. The parent name of the overwatches to list. parent:
      organizations/{org_id}/locations/{location_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuredlandingzoneOrganizationsLocationsOverwatchesPatchRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOverwatchesPatchRequest
  object.

  Fields:
    googleCloudSecuredlandingzoneV1betaOverwatch: A
      GoogleCloudSecuredlandingzoneV1betaOverwatch resource to be passed as
      the request body.
    name: Output only. The resource name of this overwatch resource. In the
      format of organizations/{org_id}/locations/{location_id}/overwatches/{ov
      erwatch_id}.
    updateMask: Optional. The FieldMask to use when updating the Overwatch.
      Only the fields specified here will be updated. This should not be
      empty. Updatable fields are: * blueprint_plan
  """

  googleCloudSecuredlandingzoneV1betaOverwatch = _messages.MessageField('GoogleCloudSecuredlandingzoneV1betaOverwatch', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuredlandingzoneOrganizationsLocationsOverwatchesSuspendRequest(_messages.Message):
  r"""A SecuredlandingzoneOrganizationsLocationsOverwatchesSuspendRequest
  object.

  Fields:
    googleCloudSecuredlandingzoneV1betaSuspendOverwatchRequest: A
      GoogleCloudSecuredlandingzoneV1betaSuspendOverwatchRequest resource to
      be passed as the request body.
    name: Required. The resource name of the overwatch to stop. name:
      organizations/{org_id}/locations/{location_id}/overwatches/{overwatch_id
      }
  """

  googleCloudSecuredlandingzoneV1betaSuspendOverwatchRequest = _messages.MessageField('GoogleCloudSecuredlandingzoneV1betaSuspendOverwatchRequest', 1)
  name = _messages.StringField(2, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
