"""Generated message classes for run version v1alpha1.

Deploy and manage user provided container images that scale automatically
based on incoming requests. The Cloud Run Admin API v1 follows the Knative
Serving API specification, while v2 is aligned with Google Cloud AIP-based API
standards, as described in https://google.aip.dev/.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'run'


class ConfigMapEnvSource(_messages.Message):
  r"""Not supported by Cloud Run ConfigMapEnvSource selects a ConfigMap to
  populate the environment variables with. The contents of the target
  ConfigMap's Data field will represent the key-value pairs as environment
  variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: The ConfigMap to select from.
    optional: (Optional) Specify whether the ConfigMap must be defined
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class ConfigMapKeySelector(_messages.Message):
  r"""Not supported by Cloud Run Selects a key from a ConfigMap.

  Fields:
    key: The key to select.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: The ConfigMap to select from.
    optional: (Optional) Specify whether the ConfigMap or its key must be
      defined
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class ConfigMapVolumeSource(_messages.Message):
  r"""Not supported by Cloud Run Adapts a ConfigMap into a volume. The
  contents of the target ConfigMap's Data field will be presented in a volume
  as files using the keys in the Data field as the file names, unless the
  items element is populated with specific mappings of keys to paths.

  Fields:
    defaultMode: (Optional) Integer representation of mode bits to use on
      created files by default. Must be a value between 01 and 0777 (octal).
      If 0 or not set, it will default to 0644. Directories within the path
      are not affected by this setting. Notes * Internally, a umask of 0222
      will be applied to any non-zero value. * This is an integer
      representation of the mode bits. So, the octal integer value should look
      exactly as the chmod numeric notation with a leading zero. Some
      examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10).
      For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For
      chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). *
      This might be in conflict with other options that affect the file mode,
      like fsGroup, and the result can be other mode bits set.
    items: (Optional) If unspecified, each key-value pair in the Data field of
      the referenced Secret will be projected into the volume as a file whose
      name is the key and content is the value. If specified, the listed keys
      will be projected into the specified paths, and unlisted keys will not
      be present. If a key is specified that is not present in the Secret, the
      volume setup will error unless it is marked optional.
    name: Name of the config.
    optional: (Optional) Specify whether the Secret or its keys must be
      defined.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class Container(_messages.Message):
  r"""A single application container. This specifies both the container to
  run, the command to run in the container and the arguments to supply to it.
  Note that additional arguments may be supplied by the system to the
  container at runtime.

  Fields:
    args: (Optional) Arguments to the entrypoint. The docker image's CMD is
      used if this is not provided. Variable references $(VAR_NAME) are
      expanded using the container's environment. If a variable cannot be
      resolved, the reference in the input string will be unchanged. The
      $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
      Escaped references will never be expanded, regardless of whether the
      variable exists or not. More info:
      https://kubernetes.io/docs/tasks/inject-data-application/define-command-
      argument-container/#running-a-command-in-a-shell
    command: A string attribute.
    env: (Optional) List of environment variables to set in the container.
    envFrom: (Optional) List of sources to populate environment variables in
      the container. The keys defined within a source must be a C_IDENTIFIER.
      All invalid keys will be reported as an event when the container is
      starting. When a key exists in multiple sources, the value associated
      with the last source will take precedence. Values defined by an Env with
      a duplicate key will take precedence. Cannot be updated.
    image: Only supports containers from Google Container Registry or Artifact
      Registry URL of the Container image. More info:
      https://kubernetes.io/docs/concepts/containers/images
    imagePullPolicy: (Optional) Image pull policy. One of Always, Never,
      IfNotPresent. Defaults to Always if :latest tag is specified, or
      IfNotPresent otherwise. More info:
      https://kubernetes.io/docs/concepts/containers/images#updating-images
    livenessProbe: (Optional) Periodic probe of container liveness. Container
      will be restarted if the probe fails. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
    name: (Optional) Name of the container specified as a DNS_LABEL. Currently
      unused in Cloud Run. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#dns-label-names
    ports: (Optional) List of ports to expose from the container. Only a
      single port can be specified. The specified ports must be listening on
      all interfaces (0.0.0.0) within the container to be accessible. If
      omitted, a port number will be chosen and passed to the container
      through the PORT environment variable for the container to listen on.
    readinessProbe: (Optional) Periodic probe of container service readiness.
      Container will be removed from service endpoints if the probe fails.
      More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
    resources: (Optional) Compute Resources required by this container. More
      info: https://kubernetes.io/docs/concepts/storage/persistent-
      volumes#resources
    securityContext: (Optional) Security options the pod should run with. More
      info: https://kubernetes.io/docs/concepts/policy/security-context/ More
      info: https://kubernetes.io/docs/tasks/configure-pod-container/security-
      context/
    startupProbe: (Optional) Startup probe of application within the
      container. All other probes are disabled if a startup probe is provided,
      until it succeeds. Container will not be added to service endpoints if
      the probe fails. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
    terminationMessagePath: (Optional) Path at which the file to which the
      container's termination message will be written is mounted into the
      container's filesystem. Message written is intended to be brief final
      status, such as an assertion failure message. Will be truncated by the
      node if greater than 4096 bytes. The total message length across all
      containers will be limited to 12kb. Defaults to /dev/termination-log.
    terminationMessagePolicy: (Optional) Indicate how the termination message
      should be populated. File will use the contents of
      terminationMessagePath to populate the container status message on both
      success and failure. FallbackToLogsOnError will use the last chunk of
      container log output if the termination message file is empty and the
      container exited with an error. The log output is limited to 2048 bytes
      or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    volumeMounts: (Optional) Volume to mount into the container's filesystem.
      Only supports SecretVolumeSources. Pod volumes to mount into the
      container's filesystem.
    workingDir: (Optional) Container's working directory. If not specified,
      the container runtime's default will be used, which might be configured
      in the container image.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('EnvVar', 3, repeated=True)
  envFrom = _messages.MessageField('EnvFromSource', 4, repeated=True)
  image = _messages.StringField(5)
  imagePullPolicy = _messages.StringField(6)
  livenessProbe = _messages.MessageField('Probe', 7)
  name = _messages.StringField(8)
  ports = _messages.MessageField('ContainerPort', 9, repeated=True)
  readinessProbe = _messages.MessageField('Probe', 10)
  resources = _messages.MessageField('ResourceRequirements', 11)
  securityContext = _messages.MessageField('SecurityContext', 12)
  startupProbe = _messages.MessageField('Probe', 13)
  terminationMessagePath = _messages.StringField(14)
  terminationMessagePolicy = _messages.StringField(15)
  volumeMounts = _messages.MessageField('VolumeMount', 16, repeated=True)
  workingDir = _messages.StringField(17)


class ContainerPort(_messages.Message):
  r"""ContainerPort represents a network port in a single container.

  Fields:
    containerPort: (Optional) Port number the container listens on. This must
      be a valid port number, 0 < x < 65536.
    name: (Optional) If specified, used to specify which protocol to use.
      Allowed values are "http1" and "h2c".
    protocol: (Optional) Protocol for port. Must be "TCP". Defaults to "TCP".
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  name = _messages.StringField(2)
  protocol = _messages.StringField(3)


class DomainMapping(_messages.Message):
  r"""Resource to hold the state and status of a user's domain mapping. NOTE:
  This resource is currently in Beta.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1alpha1".
    kind: The kind of resource, in this case "DomainMapping".
    metadata: Metadata associated with this BuildTemplate.
    spec: The spec for this DomainMapping.
    status: The current status of the DomainMapping.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('DomainMappingSpec', 4)
  status = _messages.MessageField('DomainMappingStatus', 5)


class DomainMappingCondition(_messages.Message):
  r"""DomainMappingCondition contains state information for a DomainMapping.

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human readable message indicating details about the current
      status. +optional
    reason: One-word CamelCase reason for the condition's current status.
      +optional
    severity: How to interpret failures of this condition, one of Error,
      Warning, Info +optional
    status: Status of the condition, one of True, False, Unknown.
    type: Type of domain mapping condition.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class DomainMappingSpec(_messages.Message):
  r"""The desired state of the Domain Mapping.

  Enums:
    CertificateModeValueValuesEnum: The mode of the certificate.

  Fields:
    certificateMode: The mode of the certificate.
    forceOverride: If set, the mapping will override any mapping set before
      this spec was set. It is recommended that the user leaves this empty to
      receive an error warning about a potential conflict and only set it once
      the respective UI has given such a warning.
    routeName: The name of the Knative Route that this DomainMapping applies
      to. The route must exist.
  """

  class CertificateModeValueValuesEnum(_messages.Enum):
    r"""The mode of the certificate.

    Values:
      CERTIFICATE_MODE_UNSPECIFIED: <no description>
      NONE: Do not provision an HTTPS certificate.
      AUTOMATIC: Automatically provisions an HTTPS certificate via GoogleCA or
        LetsEncrypt.
    """
    CERTIFICATE_MODE_UNSPECIFIED = 0
    NONE = 1
    AUTOMATIC = 2

  certificateMode = _messages.EnumField('CertificateModeValueValuesEnum', 1)
  forceOverride = _messages.BooleanField(2)
  routeName = _messages.StringField(3)


class DomainMappingStatus(_messages.Message):
  r"""The current state of the Domain Mapping.

  Fields:
    conditions: Array of observed DomainMappingConditions, indicating the
      current state of the DomainMapping.
    mappedRouteName: The name of the route that the mapping currently points
      to.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      DomainMapping that was last processed by the controller. Clients polling
      for completed reconciliation should poll until observedGeneration =
      metadata.generation and the Ready condition's status is True or False.
    resourceRecords: The resource records required to configure this domain
      mapping. These records must be added to the domain's DNS configuration
      in order to serve the application via this domain mapping.
    url: Cloud Run fully managed: not supported Cloud Run on GKE: supported
      Holds the URL that will serve the traffic of the DomainMapping.
      +optional
  """

  conditions = _messages.MessageField('DomainMappingCondition', 1, repeated=True)
  mappedRouteName = _messages.StringField(2)
  observedGeneration = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourceRecords = _messages.MessageField('ResourceRecord', 4, repeated=True)
  url = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EnvFromSource(_messages.Message):
  r"""Not supported by Cloud Run EnvFromSource represents the source of a set
  of ConfigMaps

  Fields:
    configMapRef: (Optional) The ConfigMap to select from
    prefix: (Optional) An optional identifier to prepend to each key in the
      ConfigMap. Must be a C_IDENTIFIER.
    secretRef: (Optional) The Secret to select from
  """

  configMapRef = _messages.MessageField('ConfigMapEnvSource', 1)
  prefix = _messages.StringField(2)
  secretRef = _messages.MessageField('SecretEnvSource', 3)


class EnvVar(_messages.Message):
  r"""EnvVar represents an environment variable present in a Container.

  Fields:
    name: Name of the environment variable. Must be a C_IDENTIFIER.
    value: (Optional) Variable references $(VAR_NAME) are expanded using the
      previous defined environment variables in the container and any route
      environment variables. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      Defaults to "".
    valueFrom: (Optional) Source for the environment variable's value. Only
      supports secret_key_ref. Source for the environment variable's value.
      Cannot be used if value is not empty.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)
  valueFrom = _messages.MessageField('EnvVarSource', 3)


class EnvVarSource(_messages.Message):
  r"""EnvVarSource represents a source for the value of an EnvVar.

  Fields:
    configMapKeyRef: (Optional) Not supported by Cloud Run Selects a key of a
      ConfigMap.
    secretKeyRef: (Optional) Selects a key (version) of a secret in Secret
      Manager.
  """

  configMapKeyRef = _messages.MessageField('ConfigMapKeySelector', 1)
  secretKeyRef = _messages.MessageField('SecretKeySelector', 2)


class ExecAction(_messages.Message):
  r"""Not supported by Cloud Run ExecAction describes a "run in container"
  action.

  Fields:
    command: (Optional) Command is the command line to execute inside the
      container, the working directory for the command is root ('/') in the
      container's filesystem. The command is simply exec'd, it is not run
      inside a shell, so traditional shell instructions ('|', etc) won't work.
      To use a shell, you need to explicitly call out to that shell. Exit
      status of 0 is treated as live/healthy and non-zero is unhealthy.
  """

  command = _messages.StringField(1, repeated=True)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class HTTPGetAction(_messages.Message):
  r"""Not supported by Cloud Run HTTPGetAction describes an action based on
  HTTP Get requests.

  Fields:
    host: (Optional) Host name to connect to, defaults to the pod IP. You
      probably want to set "Host" in httpHeaders instead.
    httpHeaders: (Optional) Custom headers to set in the request. HTTP allows
      repeated headers.
    path: (Optional) Path to access on the HTTP server.
    scheme: (Optional) Scheme to use for connecting to the host. Defaults to
      HTTP.
  """

  host = _messages.StringField(1)
  httpHeaders = _messages.MessageField('HTTPHeader', 2, repeated=True)
  path = _messages.StringField(3)
  scheme = _messages.StringField(4)


class HTTPHeader(_messages.Message):
  r"""Not supported by Cloud Run HTTPHeader describes a custom header to be
  used in HTTP probes

  Fields:
    name: The header field name
    value: The header field value
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class InstanceAttemptResult(_messages.Message):
  r"""Result of an instance attempt.

  Fields:
    exitCode: Optional. The exit code of this attempt. This may be unset if
      the container was unable to exit cleanly with a code due to some other
      failure. See status field for possible failure details.
    status: Optional. The status of this attempt. If the status code is OK,
      then the attempt succeeded.
  """

  exitCode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  status = _messages.MessageField('GoogleRpcStatus', 2)


class InstanceSpec(_messages.Message):
  r"""InstanceSpec is a description of an instance.

  Fields:
    activeDeadlineSeconds: Optional. Optional duration in seconds the instance
      may be active relative to StartTime before the system will actively try
      to mark it failed and kill associated containers. If set to zero, the
      system will never attempt to kill an instance based on time. Otherwise,
      value must be a positive integer. +optional
    containers: Optional. List of containers belonging to the instance. We
      disallow a number of fields on this Container. Only a single container
      may be provided.
    restartPolicy: Optional. Restart policy for all containers within the
      instance. Allowed values are: - OnFailure: Instances will always be
      restarted on failure if the backoffLimit has not been reached. - Never:
      Instances are never restarted and all failures are permanent. Cannot be
      used if backoffLimit is set. +optional
    serviceAccountName: Optional. Email address of the IAM service account
      associated with the instance of a Job. The service account represents
      the identity of the running instance, and determines what permissions
      the instance has. If not provided, the instance will use the project's
      default service account. +optional
    terminationGracePeriodSeconds: Optional. Optional duration in seconds the
      instance needs to terminate gracefully. Value must be non-negative
      integer. The value zero indicates delete immediately. The grace period
      is the duration in seconds after the processes running in the instance
      are sent a termination signal and the time when the processes are
      forcibly halted with a kill signal. Set this value longer than the
      expected cleanup time for your process. +optional
    volumes: Optional. List of volumes that can be mounted by containers
      belonging to the instance. More info:
      https://kubernetes.io/docs/concepts/storage/volumes +optional
  """

  activeDeadlineSeconds = _messages.IntegerField(1)
  containers = _messages.MessageField('Container', 2, repeated=True)
  restartPolicy = _messages.StringField(3)
  serviceAccountName = _messages.StringField(4)
  terminationGracePeriodSeconds = _messages.IntegerField(5)
  volumes = _messages.MessageField('Volume', 6, repeated=True)


class InstanceStatus(_messages.Message):
  r"""Instance represents the status of an instance of a Job.

  Fields:
    completionTime: Optional. Represents time when the instance was completed.
      It is not guaranteed to be set in happens-before order across separate
      operations. It is represented in RFC3339 form and is in UTC. +optional
    failed: Optional. The number of times this instance exited with code > 0;
      +optional
    index: Required. Index of the instance, unique per Job, and beginning at
      0.
    lastAttemptResult: Optional. Result of the last attempt of this instance.
      +optional
    lastExitCode: Optional. Last exit code seen for this instance. +optional
    restarted: Optional. The number of times this instance was restarted.
      Instances are restarted according the restartPolicy configured in the
      Job template. +optional
    startTime: Optional. Represents time when the instance was created by the
      job controller. It is not guaranteed to be set in happens-before order
      across separate operations. It is represented in RFC3339 form and is in
      UTC. +optional
    succeeded: Optional. The number of times this instance exited with code ==
      0. +optional
  """

  completionTime = _messages.StringField(1)
  failed = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  index = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  lastAttemptResult = _messages.MessageField('InstanceAttemptResult', 4)
  lastExitCode = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  restarted = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(7)
  succeeded = _messages.IntegerField(8, variant=_messages.Variant.INT32)


class InstanceTemplateSpec(_messages.Message):
  r"""InstanceTemplateSpec describes the data an instance should have when
  created from a template.

  Fields:
    spec: Optional. Specification of the desired behavior of the instance.
      More info: https://git.k8s.io/community/contributors/devel/sig-
      architecture/api-conventions.md#spec-and-status +optional
  """

  spec = _messages.MessageField('InstanceSpec', 1)


class Job(_messages.Message):
  r"""Job represents the configuration of a single job. A job an immutable
  resource that references a container image which is run to completion.

  Fields:
    apiVersion: Optional. APIVersion defines the versioned schema of this
      representation of an object. Servers should convert recognized schemas
      to the latest internal value, and may reject unrecognized values. More
      info: https://git.k8s.io/community/contributors/devel/sig-
      architecture/api-conventions.md#resources +optional
    kind: Optional. Kind is a string value representing the REST resource this
      object represents. Servers may infer this from the endpoint the client
      submits requests to. Cannot be updated. In CamelCase. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#types-kinds +optional
    metadata: Optional. Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    spec: Optional. Specification of the desired behavior of a job. More info:
      https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-
      and-status +optional
    status: Optional. Current status of a job. More info:
      https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-
      and-status +optional
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('JobSpec', 4)
  status = _messages.MessageField('JobStatus', 5)


class JobCondition(_messages.Message):
  r"""JobCondition defines a readiness condition for a Revision.

  Fields:
    lastTransitionTime: Optional. Last time the condition transitioned from
      one status to another.
    message: Optional. Human readable message indicating details about the
      current status.
    reason: Optional. One-word CamelCase reason for the condition's last
      transition.
    severity: Optional. How to interpret failures of this condition, one of
      Error, Warning, Info
    status: Required. Status of the condition, one of True, False, Unknown.
    type: Required. Type is used to communicate the status of the
      reconciliation process. See also:
      https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-
      conditions-and-reporting Types include: * "Completed": True when the Job
      has successfully completed. * "Started": True when the Job has
      successfully started running. * "ResourcesAvailable": True when
      underlying resources have been provisioned.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class JobSpec(_messages.Message):
  r"""JobSpec describes how the job execution will look like.

  Fields:
    activeDeadlineSeconds: Optional. Not supported. Specifies the duration in
      seconds relative to the startTime that the job may be active before the
      system tries to terminate it. If set to zero, the system will never
      attempt to terminate the job based on time. Otherwise, the value must be
      positive integer. +optional
    backoffLimit: Optional. Specifies the number of retries per instance,
      before marking this job failed. If set to zero, instances will never
      retry on failure. +optional
    completions: Optional. Specifies the desired number of successfully
      finished instances the job should be run with. Setting to 1 means that
      parallelism is limited to 1 and the success of that instance signals the
      success of the job. More info:
      https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-
      completion/ +optional
    parallelism: Optional. Specifies the maximum desired number of instances
      the job should run at any given time. Must be <= completions. The actual
      number of instances running in steady state will be less than this
      number when ((.spec.completions - .status.successful) <
      .spec.parallelism), i.e. when the work left to do is less than max
      parallelism. More info:
      https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-
      completion/ +optional
    template: Optional. Describes the instance that will be created when
      executing a job.
    ttlSecondsAfterFinished: Optional. Not supported. ttlSecondsAfterFinished
      limits the lifetime of a Job that has finished execution (either
      Complete or Failed). If this field is set, ttlSecondsAfterFinished after
      the Job finishes, it is eligible to be automatically deleted. When the
      Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be
      honored. If this field is set to zero, the Job won't be automatically
      deleted. +optional
  """

  activeDeadlineSeconds = _messages.IntegerField(1)
  backoffLimit = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  completions = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  parallelism = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  template = _messages.MessageField('InstanceTemplateSpec', 5)
  ttlSecondsAfterFinished = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class JobStatus(_messages.Message):
  r"""JobStatus represents the current state of a Job.

  Fields:
    active: Optional. The number of actively running instances. +optional
    completionTime: Optional. Represents time when the job was completed. It
      is not guaranteed to be set in happens-before order across separate
      operations. It is represented in RFC3339 form and is in UTC. +optional
    conditions: Optional. The latest available observations of a job's current
      state. More info:
      https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-
      completion/ +optional
    failed: Optional. The number of instances which reached phase Failed.
      +optional
    imageDigest: Optional. ImageDigest holds the resolved digest for the image
      specified within .Spec.Template.Spec.Container.Image. The digest is
      resolved during the creation of the Job. This field holds the digest
      value regardless of whether a tag or digest was originally specified in
      the Container object.
    instances: Optional. Status of completed, failed, and running instances.
      +optional
    observedGeneration: Optional. The 'generation' of the job that was last
      processed by the controller.
    startTime: Optional. Represents time when the job was acknowledged by the
      job controller. It is not guaranteed to be set in happens-before order
      across separate operations. It is represented in RFC3339 form and is in
      UTC. +optional
    succeeded: Optional. The number of instances which reached phase
      Succeeded. +optional
  """

  active = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  completionTime = _messages.StringField(2)
  conditions = _messages.MessageField('JobCondition', 3, repeated=True)
  failed = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  imageDigest = _messages.StringField(5)
  instances = _messages.MessageField('InstanceStatus', 6, repeated=True)
  observedGeneration = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(8)
  succeeded = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class KeyToPath(_messages.Message):
  r"""Maps a string key to a path within a volume.

  Fields:
    key: The Cloud Secret Manager secret version. Can be 'latest' for the
      latest value or an integer for a specific version. The key to project.
    mode: (Optional) Mode bits to use on this file, must be a value between 01
      and 0777 (octal). If 0 or not set, the Volume's default mode will be
      used. Notes * Internally, a umask of 0222 will be applied to any non-
      zero value. * This is an integer representation of the mode bits. So,
      the octal integer value should look exactly as the chmod numeric
      notation with a leading zero. Some examples: for chmod 777 (a=rwx), set
      to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640
      (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755
      (octal) or 493 (base-10). * This might be in conflict with other options
      that affect the file mode, like fsGroup, and the result can be other
      mode bits set.
    path: The relative path of the file to map the key to. May not be an
      absolute path. May not contain the path element '..'. May not start with
      the string '..'.
  """

  key = _messages.StringField(1)
  mode = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  path = _messages.StringField(3)


class ListDomainMappingsResponse(_messages.Message):
  r"""ListDomainMappingsResponse is a list of DomainMapping resources.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1alpha1".
    items: List of DomainMappings.
    kind: The kind of this resource, in this case "DomainMappingList".
    metadata: Metadata associated with this DomainMapping list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('DomainMapping', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListJobsResponse(_messages.Message):
  r"""ListJobsResponse is a list of Jobs resources.

  Fields:
    apiVersion: The API version for this call such as
      "run.googleapis.com/v1alpha1".
    items: List of Jobs.
    kind: The kind of this resource, in this case "JobsList".
    metadata: Metadata associated with this jobs list.
    nextPageToken: This field is equivalent to the metadata.continue field and
      is provided as a convenience for compatibility with
      https://google.aip.dev/158. The value is opaque and may be used to issue
      another request to the endpoint that served this list to retrieve the
      next set of available objects. Continuing a list may not be possible if
      the server configuration has changed or more than a few minutes have
      passed. The metadata.resourceVersion field returned when using this
      field will be identical to the value in the first response.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Job', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  nextPageToken = _messages.StringField(5)
  unreachable = _messages.StringField(6, repeated=True)


class ListMeta(_messages.Message):
  r"""ListMeta describes metadata that synthetic resources must have,
  including lists and various status objects. A resource may have only one of
  {ObjectMeta, ListMeta}.

  Fields:
    continue_: continue may be set if the user set a limit on the number of
      items returned, and indicates that the server has more data available.
      The value is opaque and may be used to issue another request to the
      endpoint that served this list to retrieve the next set of available
      objects. Continuing a list may not be possible if the server
      configuration has changed or more than a few minutes have passed. The
      resourceVersion field returned when using this continue value will be
      identical to the value in the first response.
    resourceVersion: String that identifies the server's internal version of
      this object that can be used by clients to determine when objects have
      changed. Value must be treated as opaque by clients and passed
      unmodified back to the server. Populated by the system. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
  """

  continue_ = _messages.StringField(1)
  resourceVersion = _messages.StringField(2)
  selfLink = _messages.StringField(3)


class LocalObjectReference(_messages.Message):
  r"""Not supported by Cloud Run LocalObjectReference contains enough
  information to let you locate the referenced object inside the same
  namespace.

  Fields:
    name: (Optional) Name of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#names
  """

  name = _messages.StringField(1)


class ObjectMeta(_messages.Message):
  r"""k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is metadata that all
  persisted resources must have, which includes all objects users must create.

  Messages:
    AnnotationsValue: (Optional) Annotations is an unstructured key value map
      stored with a resource that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. More info:
      https://kubernetes.io/docs/user-guide/annotations
    LabelsValue: (Optional) Map of string keys and values that can be used to
      organize and categorize (scope and select) objects. May match selectors
      of replication controllers and routes. More info:
      https://kubernetes.io/docs/user-guide/labels

  Fields:
    annotations: (Optional) Annotations is an unstructured key value map
      stored with a resource that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. More info:
      https://kubernetes.io/docs/user-guide/annotations
    clusterName: (Optional) Not supported by Cloud Run The name of the cluster
      which the object belongs to. This is used to distinguish resources with
      same name and namespace in different clusters. This field is not set
      anywhere right now and apiserver is going to ignore it if set in create
      or update request.
    creationTimestamp: (Optional) CreationTimestamp is a timestamp
      representing the server time when this object was created. It is not
      guaranteed to be set in happens-before order across separate operations.
      Clients may not set this value. It is represented in RFC3339 form and is
      in UTC. Populated by the system. Read-only. Null for lists. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    deletionGracePeriodSeconds: (Optional) Not supported by Cloud Run Number
      of seconds allowed for this object to gracefully terminate before it
      will be removed from the system. Only set when deletionTimestamp is also
      set. May only be shortened. Read-only.
    deletionTimestamp: (Optional) Not supported by Cloud Run DeletionTimestamp
      is RFC 3339 date and time at which this resource will be deleted. This
      field is set by the server when a graceful deletion is requested by the
      user, and is not directly settable by a client. The resource is expected
      to be deleted (no longer visible from resource lists, and not reachable
      by name) after the time in this field, once the finalizers list is
      empty. As long as the finalizers list contains items, deletion is
      blocked. Once the deletionTimestamp is set, this value may not be unset
      or be set further into the future, although it may be shortened or the
      resource may be deleted prior to this time. For example, a user may
      request that a pod is deleted in 30 seconds. The Kubelet will react by
      sending a graceful termination signal to the containers in the pod.
      After that 30 seconds, the Kubelet will send a hard termination signal
      (SIGKILL) to the container and after cleanup, remove the pod from the
      API. In the presence of network partitions, this object may still exist
      after this timestamp, until an administrator or automated process can
      determine the resource is fully terminated. If not set, graceful
      deletion of the object has not been requested. Populated by the system
      when a graceful deletion is requested. Read-only. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    finalizers: (Optional) Not supported by Cloud Run Must be empty before the
      object is deleted from the registry. Each entry is an identifier for the
      responsible component that will remove the entry from the list. If the
      deletionTimestamp of the object is non-nil, entries in this list can
      only be removed. +patchStrategy=merge
    generateName: (Optional) Not supported by Cloud Run GenerateName is an
      optional prefix, used by the server, to generate a unique name ONLY IF
      the Name field has not been provided. If this field is used, the name
      returned to the client will be different than the name passed. This
      value will also be combined with a unique suffix. The provided value has
      the same validation rules as the Name field, and may be truncated by the
      length of the suffix required to make the value unique on the server. If
      this field is specified and the generated name exists, the server will
      NOT return a 409 - instead, it will either return 201 Created or 500
      with Reason ServerTimeout indicating a unique name could not be found in
      the time allotted, and the client should retry (optionally after the
      time indicated in the Retry-After header). Applied only if Name is not
      specified. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#idempotency string generateName = 2;
    generation: (Optional) A sequence number representing a specific
      generation of the desired state. Populated by the system. Read-only.
    labels: (Optional) Map of string keys and values that can be used to
      organize and categorize (scope and select) objects. May match selectors
      of replication controllers and routes. More info:
      https://kubernetes.io/docs/user-guide/labels
    name: Name must be unique within a namespace, within a Cloud Run region.
      Is required when creating resources, although some resources may allow a
      client to request the generation of an appropriate name automatically.
      Name is primarily intended for creation idempotence and configuration
      definition. Cannot be updated. More info:
      https://kubernetes.io/docs/user-guide/identifiers#names +optional
    namespace: Namespace defines the space within each name must be unique,
      within a Cloud Run region. In Cloud Run the namespace must be equal to
      either the project ID or project number.
    ownerReferences: (Optional) Not supported by Cloud Run List of objects
      that own this object. If ALL objects in the list have been deleted, this
      object will be garbage collected.
    resourceVersion: Optional. An opaque value that represents the internal
      version of this object that can be used by clients to determine when
      objects have changed. May be used for optimistic concurrency, change
      detection, and the watch operation on a resource or set of resources.
      Clients must treat these values as opaque and passed unmodified back to
      the server or omit the value to disable conflict-detection. They may
      only be valid for a particular resource or set of resources. Populated
      by the system. Read-only. Value must be treated as opaque by clients or
      omitted. More info: https://git.k8s.io/community/contributors/devel/sig-
      architecture/api-conventions.md#concurrency-control-and-consistency
    selfLink: (Optional) SelfLink is a URL representing this object. Populated
      by the system. Read-only. string selfLink = 4;
    uid: (Optional) UID is the unique in time and space value for this object.
      It is typically generated by the server on successful creation of a
      resource and is not allowed to change on PUT operations. Populated by
      the system. Read-only. More info: https://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""(Optional) Annotations is an unstructured key value map stored with a
    resource that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. More info: https://kubernetes.io/docs/user-guide/annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""(Optional) Map of string keys and values that can be used to organize
    and categorize (scope and select) objects. May match selectors of
    replication controllers and routes. More info:
    https://kubernetes.io/docs/user-guide/labels

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  clusterName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  deletionGracePeriodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  deletionTimestamp = _messages.StringField(5)
  finalizers = _messages.StringField(6, repeated=True)
  generateName = _messages.StringField(7)
  generation = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  namespace = _messages.StringField(11)
  ownerReferences = _messages.MessageField('OwnerReference', 12, repeated=True)
  resourceVersion = _messages.StringField(13)
  selfLink = _messages.StringField(14)
  uid = _messages.StringField(15)


class OwnerReference(_messages.Message):
  r"""OwnerReference contains enough information to let you identify an owning
  object. Currently, an owning object must be in the same namespace, so there
  is no namespace field.

  Fields:
    apiVersion: API version of the referent.
    blockOwnerDeletion: If true, AND if the owner has the "foregroundDeletion"
      finalizer, then the owner cannot be deleted from the key-value store
      until this reference is removed. Defaults to false. To set this field, a
      user needs "delete" permission of the owner, otherwise 422
      (Unprocessable Entity) will be returned. +optional
    controller: If true, this reference points to the managing controller.
      +optional
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#types-kinds
    name: Name of the referent. More info: https://kubernetes.io/docs/user-
      guide/identifiers#names
    uid: UID of the referent. More info: https://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  apiVersion = _messages.StringField(1)
  blockOwnerDeletion = _messages.BooleanField(2)
  controller = _messages.BooleanField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  uid = _messages.StringField(6)


class Probe(_messages.Message):
  r"""Not supported by Cloud Run Probe describes a health check to be
  performed against a container to determine whether it is alive or ready to
  receive traffic.

  Fields:
    exec_: (Optional) One and only one of the following should be specified.
      Exec specifies the action to take. A field inlined from the Handler
      message.
    failureThreshold: (Optional) Minimum consecutive failures for the probe to
      be considered failed after having succeeded. Defaults to 3. Minimum
      value is 1.
    httpGet: (Optional) HTTPGet specifies the http request to perform. A field
      inlined from the Handler message.
    initialDelaySeconds: (Optional) Number of seconds after the container has
      started before liveness probes are initiated. Defaults to 0 seconds.
      Minimum value is 0. Max value for liveness probe is 3600. Max value for
      startup probe is 240. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
    periodSeconds: (Optional) How often (in seconds) to perform the probe.
      Default to 10 seconds. Minimum value is 1. Max value for liveness probe
      is 3600. Max value for startup probe is 240. Must be greater or equal
      than timeout_seconds.
    successThreshold: (Optional) Minimum consecutive successes for the probe
      to be considered successful after having failed. Defaults to 1. Must be
      1 for liveness and startup Probes.
    tcpSocket: (Optional) TCPSocket specifies an action involving a TCP port.
      TCP hooks not yet supported A field inlined from the Handler message.
    timeoutSeconds: (Optional) Number of seconds after which the probe times
      out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
      Must be smaller than period_seconds. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
  """

  exec_ = _messages.MessageField('ExecAction', 1)
  failureThreshold = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  httpGet = _messages.MessageField('HTTPGetAction', 3)
  initialDelaySeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  periodSeconds = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  successThreshold = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  tcpSocket = _messages.MessageField('TCPSocketAction', 7)
  timeoutSeconds = _messages.IntegerField(8, variant=_messages.Variant.INT32)


class ResourceRecord(_messages.Message):
  r"""A DNS resource record.

  Enums:
    TypeValueValuesEnum: Resource record type. Example: `AAAA`.

  Fields:
    name: Relative name of the object affected by this record. Only applicable
      for `CNAME` records. Example: 'www'.
    rrdata: Data for this record. Values vary by record type, as defined in
      RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
    type: Resource record type. Example: `AAAA`.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Resource record type. Example: `AAAA`.

    Values:
      RECORD_TYPE_UNSPECIFIED: An unknown resource record.
      A: An A resource record. Data is an IPv4 address.
      AAAA: An AAAA resource record. Data is an IPv6 address.
      CNAME: A CNAME resource record. Data is a domain name to be aliased.
    """
    RECORD_TYPE_UNSPECIFIED = 0
    A = 1
    AAAA = 2
    CNAME = 3

  name = _messages.StringField(1)
  rrdata = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class ResourceRequirements(_messages.Message):
  r"""ResourceRequirements describes the compute resource requirements.

  Messages:
    LimitsValue: (Optional) Only memory and CPU are supported. Limits
      describes the maximum amount of compute resources allowed. The values of
      the map is string form of the 'quantity' k8s type: https://github.com/ku
      bernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/
      resource/quantity.go
    RequestsValue: (Optional) Only memory and CPU are supported. Requests
      describes the minimum amount of compute resources required. If Requests
      is omitted for a container, it defaults to Limits if that is explicitly
      specified, otherwise to an implementation-defined value. The values of
      the map is string form of the 'quantity' k8s type: https://github.com/ku
      bernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/
      resource/quantity.go

  Fields:
    limits: (Optional) Only memory and CPU are supported. Limits describes the
      maximum amount of compute resources allowed. The values of the map is
      string form of the 'quantity' k8s type: https://github.com/kubernetes/ku
      bernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/qu
      antity.go
    requests: (Optional) Only memory and CPU are supported. Requests describes
      the minimum amount of compute resources required. If Requests is omitted
      for a container, it defaults to Limits if that is explicitly specified,
      otherwise to an implementation-defined value. The values of the map is
      string form of the 'quantity' k8s type: https://github.com/kubernetes/ku
      bernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/qu
      antity.go
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsValue(_messages.Message):
    r"""(Optional) Only memory and CPU are supported. Limits describes the
    maximum amount of compute resources allowed. The values of the map is
    string form of the 'quantity' k8s type: https://github.com/kubernetes/kube
    rnetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quanti
    ty.go

    Messages:
      AdditionalProperty: An additional property for a LimitsValue object.

    Fields:
      additionalProperties: Additional properties of type LimitsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsValue(_messages.Message):
    r"""(Optional) Only memory and CPU are supported. Requests describes the
    minimum amount of compute resources required. If Requests is omitted for a
    container, it defaults to Limits if that is explicitly specified,
    otherwise to an implementation-defined value. The values of the map is
    string form of the 'quantity' k8s type: https://github.com/kubernetes/kube
    rnetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quanti
    ty.go

    Messages:
      AdditionalProperty: An additional property for a RequestsValue object.

    Fields:
      additionalProperties: Additional properties of type RequestsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  limits = _messages.MessageField('LimitsValue', 1)
  requests = _messages.MessageField('RequestsValue', 2)


class RunNamespacesDomainmappingsCreateRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The project ID or project number in which this domain mapping
      should be created.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunNamespacesDomainmappingsGetRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesDomainmappingsListRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the domain mappings
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesDomainmappingsReplaceDomainMappingRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsReplaceDomainMappingRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  name = _messages.StringField(2, required=True)


class RunNamespacesJobsCreateRequest(_messages.Message):
  r"""A RunNamespacesJobsCreateRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    parent: Required. The namespace in which the job should be created.
      Replace {namespace_id} with the project ID or number.
  """

  job = _messages.MessageField('Job', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesJobsDeleteRequest(_messages.Message):
  r"""A RunNamespacesJobsDeleteRequest object.

  Fields:
    apiVersion: Optional. Cloud Run currently ignores this parameter.
    kind: Optional. Cloud Run currently ignores this parameter.
    name: Required. The name of the job to delete. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
    propagationPolicy: Optional. Specifies the propagation policy of delete.
      Cloud Run currently ignores this setting, and deletes in the background.
      Please see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesJobsGetRequest(_messages.Message):
  r"""A RunNamespacesJobsGetRequest object.

  Fields:
    name: Required. The name of the job to retrieve. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesJobsListRequest(_messages.Message):
  r"""A RunNamespacesJobsListRequest object.

  Fields:
    continue_: Optional. Optional encoded string to continue paging.
    fieldSelector: Optional. Allows to filter resources based on a specific
      value for a field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Optional. Not currently used by Cloud Run.
    labelSelector: Optional. Allows to filter resources based on a label.
      Supported operations are =, !=, exists, in, and notIn.
    limit: Optional. The maximum number of records that should be returned.
    parent: Required. The namespace from which the jobs should be listed.
      Replace {namespace_id} with the project ID or number.
    resourceVersion: Optional. The baseline resource version from which the
      list or watch operation should start. Not currently used by Cloud Run.
    watch: Optional. Flag that indicates that the client expects to watch this
      resource as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsDomainmappingsCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The project ID or project number in which this domain mapping
      should be created.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunProjectsLocationsDomainmappingsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsDomainmappingsListRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the domain mappings
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsDomainmappingsReplaceDomainMappingRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsReplaceDomainMappingRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  name = _messages.StringField(2, required=True)


class SecretEnvSource(_messages.Message):
  r"""Not supported by Cloud Run SecretEnvSource selects a Secret to populate
  the environment variables with. The contents of the target Secret's Data
  field will represent the key-value pairs as environment variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: The Secret to select from.
    optional: (Optional) Specify whether the Secret must be defined
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class SecretKeySelector(_messages.Message):
  r"""SecretKeySelector selects a key of a Secret.

  Fields:
    key: A Cloud Secret Manager secret version. Must be 'latest' for the
      latest version or an integer for a specific version. The key of the
      secret to select from. Must be a valid secret key.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: The name of the secret in Cloud Secret Manager. By default, the
      secret is assumed to be in the same project. If the secret is in another
      project, you must define an alias. An alias definition has the form:
      :projects//secrets/. If multiple alias definitions are needed, they must
      be separated by commas. The alias definitions must be set on the
      run.googleapis.com/secrets annotation. The name of the secret in the
      pod's namespace to select from.
    optional: (Optional) Specify whether the Secret or its key must be defined
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class SecretVolumeSource(_messages.Message):
  r"""The secret's value will be presented as the content of a file whose name
  is defined in the item path. If no items are defined, the name of the file
  is the secret_name. The contents of the target Secret's Data field will be
  presented in a volume as files using the keys in the Data field as the file
  names.

  Fields:
    defaultMode: Integer representation of mode bits to use on created files
      by default. Must be a value between 01 and 0777 (octal). If 0 or not
      set, it will default to 0644. Directories within the path are not
      affected by this setting. Notes * Internally, a umask of 0222 will be
      applied to any non-zero value. * This is an integer representation of
      the mode bits. So, the octal integer value should look exactly as the
      chmod numeric notation with a leading zero. Some examples: for chmod 777
      (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r),
      set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx),
      set to 0755 (octal) or 493 (base-10). * This might be in conflict with
      other options that affect the file mode, like fsGroup, and the result
      can be other mode bits set.
    items: (Optional) If unspecified, the volume will expose a file whose name
      is the secret_name. If specified, the key will be used as the version to
      fetch from Cloud Secret Manager and the path will be the name of the
      file exposed in the volume. When items are defined, they must specify a
      key and a path. If unspecified, each key-value pair in the Data field of
      the referenced Secret will be projected into the volume as a file whose
      name is the key and content is the value. If specified, the listed keys
      will be projected into the specified paths, and unlisted keys will not
      be present. If a key is specified that is not present in the Secret, the
      volume setup will error unless it is marked optional.
    optional: (Optional) Specify whether the Secret or its keys must be
      defined.
    secretName: The name of the secret in Cloud Secret Manager. By default,
      the secret is assumed to be in the same project. If the secret is in
      another project, you must define an alias. An alias definition has the
      form: :projects//secrets/. If multiple alias definitions are needed,
      they must be separated by commas. The alias definitions must be set on
      the run.googleapis.com/secrets annotation. Name of the secret in the
      container's namespace to use.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  optional = _messages.BooleanField(3)
  secretName = _messages.StringField(4)


class SecurityContext(_messages.Message):
  r"""Not supported by Cloud Run SecurityContext holds security configuration
  that will be applied to a container. Some fields are present in both
  SecurityContext and PodSecurityContext. When both are set, the values in
  SecurityContext take precedence.

  Fields:
    runAsUser: (Optional) The UID to run the entrypoint of the container
      process. Defaults to user specified in image metadata if unspecified.
      May also be set in PodSecurityContext. If set in both SecurityContext
      and PodSecurityContext, the value specified in SecurityContext takes
      precedence.
  """

  runAsUser = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TCPSocketAction(_messages.Message):
  r"""Not supported by Cloud Run TCPSocketAction describes an action based on
  opening a socket

  Fields:
    host: (Optional) Optional: Host name to connect to, defaults to the pod
      IP.
    port: Number or name of the port to access on the container. Number must
      be in the range 1 to 65535. Name must be an IANA_SVC_NAME. This field is
      currently limited to integer types only because of proto's inability to
      properly support the IntOrString golang type.
  """

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Volume(_messages.Message):
  r"""Volume represents a named volume in a container.

  Fields:
    configMap: A ConfigMapVolumeSource attribute.
    name: Volume's name. In Cloud Run Fully Managed, the name 'cloudsql' is
      reserved.
    secret: A SecretVolumeSource attribute.
  """

  configMap = _messages.MessageField('ConfigMapVolumeSource', 1)
  name = _messages.StringField(2)
  secret = _messages.MessageField('SecretVolumeSource', 3)


class VolumeMount(_messages.Message):
  r"""VolumeMount describes a mounting of a Volume within a container.

  Fields:
    mountPath: Path within the container at which the volume should be
      mounted. Must not contain ':'.
    name: The name of the volume. There must be a corresponding Volume with
      the same name.
    readOnly: (Optional) Only true is accepted. Defaults to true.
    subPath: (Optional) Path within the volume from which the container's
      volume should be mounted. Defaults to "" (volume's root).
  """

  mountPath = _messages.StringField(1)
  name = _messages.StringField(2)
  readOnly = _messages.BooleanField(3)
  subPath = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    ListMeta, 'continue_', 'continue')
encoding.AddCustomJsonFieldMapping(
    Probe, 'exec_', 'exec')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
