"""Generated message classes for securitycenter version v1beta2.

Security Command Center API provides access to temporal views of assets and
findings within an organization.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'securitycenter'


class Access(_messages.Message):
  r"""Represents an access event.

  Fields:
    callerIp: Caller's IP address, such as "1.1.1.1".
    callerIpGeo: The caller IP's geolocation, which identifies where the call
      came from.
    methodName: The method that the service account called, e.g.
      "SetIamPolicy".
    principalEmail: Associated email, such as "foo@google.com".
    serviceName: This is the API service that the service account made a call
      to, e.g. "iam.googleapis.com"
    userAgentFamily: What kind of user agent is associated, e.g. operating
      system shells, embedded or stand-alone applications, etc.
  """

  callerIp = _messages.StringField(1)
  callerIpGeo = _messages.MessageField('Geolocation', 2)
  methodName = _messages.StringField(3)
  principalEmail = _messages.StringField(4)
  serviceName = _messages.StringField(5)
  userAgentFamily = _messages.StringField(6)


class Config(_messages.Message):
  r"""Configuration of a module.

  Enums:
    ModuleEnablementStateValueValuesEnum: The state of enablement for the
      module at its level of the resource hierarchy.

  Messages:
    ValueValue: The configuration value for the module. The absence of this
      field implies its inheritance from the parent.

  Fields:
    moduleEnablementState: The state of enablement for the module at its level
      of the resource hierarchy.
    value: The configuration value for the module. The absence of this field
      implies its inheritance from the parent.
  """

  class ModuleEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the module at its level of the resource
    hierarchy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValueValue(_messages.Message):
    r"""The configuration value for the module. The absence of this field
    implies its inheritance from the parent.

    Messages:
      AdditionalProperty: An additional property for a ValueValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ValueValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  moduleEnablementState = _messages.EnumField('ModuleEnablementStateValueValuesEnum', 1)
  value = _messages.MessageField('ValueValue', 2)


class ContainerThreatDetectionSettings(_messages.Message):
  r"""Resource capturing the settings for the Container Threat Detection
  service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    serviceAccount: Output only. The service account used by Container Threat
      Detection for scanning. Service accounts are scoped at the project level
      meaning this field will be empty at any level above a project.
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceAccount = _messages.StringField(3)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class Cve(_messages.Message):
  r"""CVE stands for Common Vulnerabilities and Exposures. More information:
  https://cve.mitre.org

  Fields:
    cvssv3: Describe Common Vulnerability Scoring System specified at
      https://www.first.org/cvss/v3.1/specification-document
    id: The unique identifier for the vulnerability. e.g. CVE-2021-34527
    references: Additional information about the CVE. e.g.
      https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
    upstreamFixAvailable: Whether upstream fix is available for the CVE.
  """

  cvssv3 = _messages.MessageField('Cvssv3', 1)
  id = _messages.StringField(2)
  references = _messages.MessageField('Reference', 3, repeated=True)
  upstreamFixAvailable = _messages.BooleanField(4)


class Cvssv3(_messages.Message):
  r"""Common Vulnerability Scoring System version 3.

  Enums:
    AttackComplexityValueValuesEnum: This metric describes the conditions
      beyond the attacker's control that must exist in order to exploit the
      vulnerability.
    AttackVectorValueValuesEnum: Base Metrics Represents the intrinsic
      characteristics of a vulnerability that are constant over time and
      across user environments. This metric reflects the context by which
      vulnerability exploitation is possible.
    AvailabilityImpactValueValuesEnum: This metric measures the impact to the
      availability of the impacted component resulting from a successfully
      exploited vulnerability.
    ConfidentialityImpactValueValuesEnum: This metric measures the impact to
      the confidentiality of the information resources managed by a software
      component due to a successfully exploited vulnerability.
    IntegrityImpactValueValuesEnum: This metric measures the impact to
      integrity of a successfully exploited vulnerability.
    PrivilegesRequiredValueValuesEnum: This metric describes the level of
      privileges an attacker must possess before successfully exploiting the
      vulnerability.
    ScopeValueValuesEnum: The Scope metric captures whether a vulnerability in
      one vulnerable component impacts resources in components beyond its
      security scope.
    UserInteractionValueValuesEnum: This metric captures the requirement for a
      human user, other than the attacker, to participate in the successful
      compromise of the vulnerable component.

  Fields:
    attackComplexity: This metric describes the conditions beyond the
      attacker's control that must exist in order to exploit the
      vulnerability.
    attackVector: Base Metrics Represents the intrinsic characteristics of a
      vulnerability that are constant over time and across user environments.
      This metric reflects the context by which vulnerability exploitation is
      possible.
    availabilityImpact: This metric measures the impact to the availability of
      the impacted component resulting from a successfully exploited
      vulnerability.
    baseScore: The base score is a function of the base metric scores.
    confidentialityImpact: This metric measures the impact to the
      confidentiality of the information resources managed by a software
      component due to a successfully exploited vulnerability.
    integrityImpact: This metric measures the impact to integrity of a
      successfully exploited vulnerability.
    privilegesRequired: This metric describes the level of privileges an
      attacker must possess before successfully exploiting the vulnerability.
    scope: The Scope metric captures whether a vulnerability in one vulnerable
      component impacts resources in components beyond its security scope.
    userInteraction: This metric captures the requirement for a human user,
      other than the attacker, to participate in the successful compromise of
      the vulnerable component.
  """

  class AttackComplexityValueValuesEnum(_messages.Enum):
    r"""This metric describes the conditions beyond the attacker's control
    that must exist in order to exploit the vulnerability.

    Values:
      ATTACK_COMPLEXITY_UNSPECIFIED: Invalid value.
      ATTACK_COMPLEXITY_LOW: Specialized access conditions or extenuating
        circumstances do not exist. An attacker can expect repeatable success
        when attacking the vulnerable component.
      ATTACK_COMPLEXITY_HIGH: A successful attack depends on conditions beyond
        the attacker's control. That is, a successful attack cannot be
        accomplished at will, but requires the attacker to invest in some
        measurable amount of effort in preparation or execution against the
        vulnerable component before a successful attack can be expected.
    """
    ATTACK_COMPLEXITY_UNSPECIFIED = 0
    ATTACK_COMPLEXITY_LOW = 1
    ATTACK_COMPLEXITY_HIGH = 2

  class AttackVectorValueValuesEnum(_messages.Enum):
    r"""Base Metrics Represents the intrinsic characteristics of a
    vulnerability that are constant over time and across user environments.
    This metric reflects the context by which vulnerability exploitation is
    possible.

    Values:
      ATTACK_VECTOR_UNSPECIFIED: Invalid value.
      ATTACK_VECTOR_NETWORK: The vulnerable component is bound to the network
        stack and the set of possible attackers extends beyond the other
        options listed below, up to and including the entire Internet.
      ATTACK_VECTOR_ADJACENT: The vulnerable component is bound to the network
        stack, but the attack is limited at the protocol level to a logically
        adjacent topology.
      ATTACK_VECTOR_LOCAL: The vulnerable component is not bound to the
        network stack and the attacker's path is via read/write/execute
        capabilities.
      ATTACK_VECTOR_PHYSICAL: The attack requires the attacker to physically
        touch or manipulate the vulnerable component.
    """
    ATTACK_VECTOR_UNSPECIFIED = 0
    ATTACK_VECTOR_NETWORK = 1
    ATTACK_VECTOR_ADJACENT = 2
    ATTACK_VECTOR_LOCAL = 3
    ATTACK_VECTOR_PHYSICAL = 4

  class AvailabilityImpactValueValuesEnum(_messages.Enum):
    r"""This metric measures the impact to the availability of the impacted
    component resulting from a successfully exploited vulnerability.

    Values:
      IMPACT_UNSPECIFIED: Invalid value.
      IMPACT_HIGH: High impact.
      IMPACT_LOW: Low impact.
      IMPACT_NONE: No impact.
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class ConfidentialityImpactValueValuesEnum(_messages.Enum):
    r"""This metric measures the impact to the confidentiality of the
    information resources managed by a software component due to a
    successfully exploited vulnerability.

    Values:
      IMPACT_UNSPECIFIED: Invalid value.
      IMPACT_HIGH: High impact.
      IMPACT_LOW: Low impact.
      IMPACT_NONE: No impact.
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class IntegrityImpactValueValuesEnum(_messages.Enum):
    r"""This metric measures the impact to integrity of a successfully
    exploited vulnerability.

    Values:
      IMPACT_UNSPECIFIED: Invalid value.
      IMPACT_HIGH: High impact.
      IMPACT_LOW: Low impact.
      IMPACT_NONE: No impact.
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class PrivilegesRequiredValueValuesEnum(_messages.Enum):
    r"""This metric describes the level of privileges an attacker must possess
    before successfully exploiting the vulnerability.

    Values:
      PRIVILEGES_REQUIRED_UNSPECIFIED: Invalid value.
      PRIVILEGES_REQUIRED_NONE: The attacker is unauthorized prior to attack,
        and therefore does not require any access to settings or files of the
        vulnerable system to carry out an attack.
      PRIVILEGES_REQUIRED_LOW: The attacker requires privileges that provide
        basic user capabilities that could normally affect only settings and
        files owned by a user. Alternatively, an attacker with Low privileges
        has the ability to access only non-sensitive resources.
      PRIVILEGES_REQUIRED_HIGH: The attacker requires privileges that provide
        significant (e.g., administrative) control over the vulnerable
        component allowing access to component-wide settings and files.
    """
    PRIVILEGES_REQUIRED_UNSPECIFIED = 0
    PRIVILEGES_REQUIRED_NONE = 1
    PRIVILEGES_REQUIRED_LOW = 2
    PRIVILEGES_REQUIRED_HIGH = 3

  class ScopeValueValuesEnum(_messages.Enum):
    r"""The Scope metric captures whether a vulnerability in one vulnerable
    component impacts resources in components beyond its security scope.

    Values:
      SCOPE_UNSPECIFIED: Invalid value.
      SCOPE_UNCHANGED: An exploited vulnerability can only affect resources
        managed by the same security authority.
      SCOPE_CHANGED: An exploited vulnerability can affect resources beyond
        the security scope managed by the security authority of the vulnerable
        component.
    """
    SCOPE_UNSPECIFIED = 0
    SCOPE_UNCHANGED = 1
    SCOPE_CHANGED = 2

  class UserInteractionValueValuesEnum(_messages.Enum):
    r"""This metric captures the requirement for a human user, other than the
    attacker, to participate in the successful compromise of the vulnerable
    component.

    Values:
      USER_INTERACTION_UNSPECIFIED: Invalid value.
      USER_INTERACTION_NONE: The vulnerable system can be exploited without
        interaction from any user.
      USER_INTERACTION_REQUIRED: Successful exploitation of this vulnerability
        requires a user to take some action before the vulnerability can be
        exploited.
    """
    USER_INTERACTION_UNSPECIFIED = 0
    USER_INTERACTION_NONE = 1
    USER_INTERACTION_REQUIRED = 2

  attackComplexity = _messages.EnumField('AttackComplexityValueValuesEnum', 1)
  attackVector = _messages.EnumField('AttackVectorValueValuesEnum', 2)
  availabilityImpact = _messages.EnumField('AvailabilityImpactValueValuesEnum', 3)
  baseScore = _messages.FloatField(4)
  confidentialityImpact = _messages.EnumField('ConfidentialityImpactValueValuesEnum', 5)
  integrityImpact = _messages.EnumField('IntegrityImpactValueValuesEnum', 6)
  privilegesRequired = _messages.EnumField('PrivilegesRequiredValueValuesEnum', 7)
  scope = _messages.EnumField('ScopeValueValuesEnum', 8)
  userInteraction = _messages.EnumField('UserInteractionValueValuesEnum', 9)


class Details(_messages.Message):
  r"""Details of a subscription.

  Enums:
    TypeValueValuesEnum: The type of subscription

  Fields:
    endTime: The time the subscription has or will end.
    startTime: The time the subscription has or will start.
    type: The type of subscription
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of subscription

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      STANDARD: The standard subscription.
      TRIAL: The trial subscription.
      ALPHA: The alpha subscription.
      DEMO: The demo subscription for channel partners.
    """
    TYPE_UNSPECIFIED = 0
    STANDARD = 1
    TRIAL = 2
    ALPHA = 3
    DEMO = 4

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class EventThreatDetectionSettings(_messages.Message):
  r"""Resource capturing the settings for the Event Threat Detection service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


class Finding(_messages.Message):
  r"""Security Command Center finding. A finding is a record of assessment
  data like security, risk, health, or privacy, that is ingested into Security
  Command Center for presentation, notification, analysis, policy testing, and
  enforcement. For example, a cross-site scripting (XSS) vulnerability in an
  App Engine application is a finding.

  Enums:
    FindingClassValueValuesEnum: The class of the finding.
    MuteValueValuesEnum: Indicates the mute state of a finding (either muted,
      unmuted or undefined). Unlike other attributes of a finding, a finding
      provider shouldn't set the value of mute.
    SeverityValueValuesEnum: The severity of the finding. This field is
      managed by the source that writes the finding.
    StateValueValuesEnum: The state of the finding.

  Messages:
    ExternalSystemsValue: Output only. Third party SIEM/SOAR fields within
      SCC, contains external system information and external system finding
      fields.
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    access: Access details associated to the Finding, such as more information
      on the caller, which method was accessed, from where, etc.
    canonicalName: The canonical name of the finding. It's either "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}",
      "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
      "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
      depending on the closest CRM ancestor of the resource associated with
      the finding.
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    createTime: The time at which the finding was created in Security Command
      Center.
    eventTime: The time the finding was first detected. If an existing finding
      is updated, then this is the time the update occurred. For example, if
      the finding represents an open firewall, this property captures the time
      the detector believes the firewall became open. The accuracy is
      determined by the detector. If the finding is later resolved, then this
      time reflects when the finding was resolved. This must not be set to a
      value greater than the current timestamp.
    externalSystems: Output only. Third party SIEM/SOAR fields within SCC,
      contains external system information and external system finding fields.
    externalUri: The URI that, if available, points to a web page outside of
      Security Command Center where additional information about the finding
      can be found. This field is guaranteed to be either empty or a well
      formed URL.
    findingClass: The class of the finding.
    iamBindings: Represents IAM bindings associated with the Finding.
    indicator: Represents what's commonly known as an Indicator of compromise
      (IoC) in computer forensics. This is an artifact observed on a network
      or in an operating system that, with high confidence, indicates a
      computer intrusion. Reference:
      https://en.wikipedia.org/wiki/Indicator_of_compromise
    mitreAttack: MITRE ATT&CK tactics and techniques related to this finding.
      See: https://attack.mitre.org
    mute: Indicates the mute state of a finding (either muted, unmuted or
      undefined). Unlike other attributes of a finding, a finding provider
      shouldn't set the value of mute.
    muteInitiator: First known as mute_annotation. Records additional
      information about the mute operation e.g. mute config that muted the
      finding, user who muted the finding, etc. Unlike other attributes of a
      finding, a finding provider shouldn't set the value of mute.
    muteUpdateTime: Output only. The most recent time this finding was muted
      or unmuted.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    nextSteps: Next steps associate to the finding.
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/{organization_id}/sources/{source_id}"
    resourceName: For findings on Google Cloud resources, the full resource
      name of the Google Cloud resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      When the finding is for a non-Google Cloud resource, the resourceName
      can be a customer or partner defined string. This field is immutable
      after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    severity: The severity of the finding. This field is managed by the source
      that writes the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
    vulnerability: Represents vulnerability specific fields like cve, cvss
      scores etc. CVE stands for Common Vulnerabilities and Exposures
      (https://cve.mitre.org/about/)
  """

  class FindingClassValueValuesEnum(_messages.Enum):
    r"""The class of the finding.

    Values:
      FINDING_CLASS_UNSPECIFIED: Unspecified finding class.
      THREAT: Describes unwanted or malicious activity.
      VULNERABILITY: Describes a potential weakness in software that increases
        risk to Confidentiality & Integrity & Availability.
      MISCONFIGURATION: Describes a potential weakness in cloud resource/asset
        configuration that increases risk.
      OBSERVATION: Describes a security observation that is for informational
        purposes.
      SCC_ERROR: Describes an error that prevents some SCC functionality.
    """
    FINDING_CLASS_UNSPECIFIED = 0
    THREAT = 1
    VULNERABILITY = 2
    MISCONFIGURATION = 3
    OBSERVATION = 4
    SCC_ERROR = 5

  class MuteValueValuesEnum(_messages.Enum):
    r"""Indicates the mute state of a finding (either muted, unmuted or
    undefined). Unlike other attributes of a finding, a finding provider
    shouldn't set the value of mute.

    Values:
      MUTE_UNSPECIFIED: Unspecified.
      MUTED: Finding has been muted.
      UNMUTED: Finding has been unmuted.
      UNDEFINED: Finding has never been muted/unmuted.
    """
    MUTE_UNSPECIFIED = 0
    MUTED = 1
    UNMUTED = 2
    UNDEFINED = 3

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding. This field is managed by the source that
    writes the finding.

    Values:
      SEVERITY_UNSPECIFIED: This value is used for findings when a source
        doesn't write a severity value.
      CRITICAL: Vulnerability: A critical vulnerability is easily discoverable
        by an external actor, exploitable, and results in the direct ability
        to execute arbitrary code, exfiltrate data, and otherwise gain
        additional access and privileges to cloud resources and workloads.
        Examples include publicly accessible unprotected user data, public SSH
        access with weak or no passwords, etc. Threat: Indicates a threat that
        is able to access, modify, or delete data or execute unauthorized code
        within existing resources.
      HIGH: Vulnerability: A high risk vulnerability can be easily discovered
        and exploited in combination with other vulnerabilities in order to
        gain direct access and the ability to execute arbitrary code,
        exfiltrate data, and otherwise gain additional access and privileges
        to cloud resources and workloads. An example is a database with weak
        or no passwords that is only accessible internally. This database
        could easily be compromised by an actor that had access to the
        internal network. Threat: Indicates a threat that is able to create
        new computational resources in an environment but not able to access
        data or execute code in existing resources.
      MEDIUM: Vulnerability: A medium risk vulnerability could be used by an
        actor to gain access to resources or privileges that enable them to
        eventually (through multiple steps or a complex exploit) gain access
        and the ability to execute arbitrary code or exfiltrate data. An
        example is a service account with access to more projects than it
        should have. If an actor gains access to the service account, they
        could potentially use that access to manipulate a project the service
        account was not intended to. Threat: Indicates a threat that is able
        to cause operational impact but may not access data or execute
        unauthorized code.
      LOW: Vulnerability: A low risk vulnerability hampers a security
        organization's ability to detect vulnerabilities or active threats in
        their deployment, or prevents the root cause investigation of security
        issues. An example is monitoring and logs being disabled for resource
        configurations and access. Threat: Indicates a threat that has
        obtained minimal access to an environment but is not able to access
        data, execute code, or create resources.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExternalSystemsValue(_messages.Message):
    r"""Output only. Third party SIEM/SOAR fields within SCC, contains
    external system information and external system finding fields.

    Messages:
      AdditionalProperty: An additional property for a ExternalSystemsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ExternalSystemsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExternalSystemsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudSecuritycenterV1ExternalSystem attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudSecuritycenterV1ExternalSystem', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  access = _messages.MessageField('Access', 1)
  canonicalName = _messages.StringField(2)
  category = _messages.StringField(3)
  createTime = _messages.StringField(4)
  eventTime = _messages.StringField(5)
  externalSystems = _messages.MessageField('ExternalSystemsValue', 6)
  externalUri = _messages.StringField(7)
  findingClass = _messages.EnumField('FindingClassValueValuesEnum', 8)
  iamBindings = _messages.MessageField('IamBinding', 9, repeated=True)
  indicator = _messages.MessageField('Indicator', 10)
  mitreAttack = _messages.MessageField('MitreAttack', 11)
  mute = _messages.EnumField('MuteValueValuesEnum', 12)
  muteInitiator = _messages.StringField(13)
  muteUpdateTime = _messages.StringField(14)
  name = _messages.StringField(15)
  nextSteps = _messages.StringField(16)
  parent = _messages.StringField(17)
  resourceName = _messages.StringField(18)
  securityMarks = _messages.MessageField('SecurityMarks', 19)
  severity = _messages.EnumField('SeverityValueValuesEnum', 20)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 21)
  state = _messages.EnumField('StateValueValuesEnum', 22)
  vulnerability = _messages.MessageField('Vulnerability', 23)


class Folder(_messages.Message):
  r"""Message that contains the resource name and display name of a folder
  resource.

  Fields:
    resourceFolder: Full resource name of this folder. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceFolderDisplayName: The user defined display name for this folder.
  """

  resourceFolder = _messages.StringField(1)
  resourceFolderDisplayName = _messages.StringField(2)


class Geolocation(_messages.Message):
  r"""Represents a geographical location for a given access.

  Fields:
    regionCode: A CLDR.
  """

  regionCode = _messages.StringField(1)


class GoogleCloudSecuritycenterV1BigQueryExport(_messages.Message):
  r"""Configures how to deliver Findings to BigQuery Instance.

  Fields:
    createTime: Output only. The time at which the big query export was
      created. This field is set by the server and will be ignored if provided
      on export on creation.
    dataset: The dataset to write findings' updates to. Its format is
      "projects/[project_id]/datasets/[bigquery_dataset_id]". BigQuery Dataset
      unique ID must contain only letters (a-z, A-Z), numbers (0-9), or
      underscores (_).
    description: The description of the export (max of 1024 characters).
    filter: Expression that defines the filter to apply across create/update
      events of findings. The expression is a list of zero or more
      restrictions combined via logical operators `AND` and `OR`. Parentheses
      are supported, and `OR` has higher precedence than `AND`. Restrictions
      have the form ` ` and may have a `-` character in front of them to
      indicate negation. The fields map to those defined in the corresponding
      resource. The supported operators are: * `=` for all value types. * `>`,
      `<`, `>=`, `<=` for integer values. * `:`, meaning substring matching,
      for strings. The supported value types are: * string literals in quotes.
      * integer literals without quotes. * boolean literals `true` and `false`
      without quotes.
    mostRecentEditor: Output only. Email address of the user who last edited
      the big query export. This field is set by the server and will be
      ignored if provided on export creation or update.
    name: The relative resource name of this export. See: https://cloud.google
      .com/apis/design/resource_names#relative_resource_name. Example format:
      "organizations/{organization_id}/bigQueryExports/{export_id}" Example
      format: "folders/{folder_id}/bigQueryExports/{export_id}" Example
      format: "projects/{project_id}/bigQueryExports/{export_id}" This field
      is provided in responses, and is ignored when provided in create
      requests.
    principal: Output only. The service account that needs permission to
      create table, upload data to the big query dataset.
    updateTime: Output only. The most recent time at which the big export was
      updated. This field is set by the server and will be ignored if provided
      on export creation or update.
  """

  createTime = _messages.StringField(1)
  dataset = _messages.StringField(2)
  description = _messages.StringField(3)
  filter = _messages.StringField(4)
  mostRecentEditor = _messages.StringField(5)
  name = _messages.StringField(6)
  principal = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudSecuritycenterV1BulkMuteFindingsResponse(_messages.Message):
  r"""The response to a BulkMute request. Contains the LRO information."""


class GoogleCloudSecuritycenterV1ExternalSystem(_messages.Message):
  r"""Representation of third party SIEM/SOAR fields within SCC.

  Fields:
    assignees: References primary/secondary etc assignees in the external
      system.
    externalSystemUpdateTime: The most recent time when the corresponding
      finding's ticket/tracker was updated in the external system.
    externalUid: Identifier that's used to track the given finding in the
      external system.
    name: External System Name e.g. jira, demisto, etc. e.g.:
      `organizations/1234/sources/5678/findings/123456/externalSystems/jira`
      `folders/1234/sources/5678/findings/123456/externalSystems/jira`
      `projects/1234/sources/5678/findings/123456/externalSystems/jira`
    status: Most recent status of the corresponding finding's ticket/tracker
      in the external system.
  """

  assignees = _messages.StringField(1, repeated=True)
  externalSystemUpdateTime = _messages.StringField(2)
  externalUid = _messages.StringField(3)
  name = _messages.StringField(4)
  status = _messages.StringField(5)


class GoogleCloudSecuritycenterV1MuteConfig(_messages.Message):
  r"""A mute config is a Cloud SCC resource that contains the configuration to
  mute create/update events of findings.

  Fields:
    createTime: Output only. The time at which the mute config was created.
      This field is set by the server and will be ignored if provided on
      config creation.
    description: A description of the mute config.
    displayName: The human readable name to be displayed for the mute config.
    filter: Required. An expression that defines the filter to apply across
      create/update events of findings. While creating a filter string, be
      mindful of the scope in which the mute configuration is being created.
      E.g., If a filter contains project = X but is created under the project
      = Y scope, it might not match any findings. The following field and
      operator combinations are supported: * severity: `=`, `:` * category:
      `=`, `:` * resource.name: `=`, `:` * resource.project_name: `=`, `:` *
      resource.project_display_name: `=`, `:` *
      resource.folders.resource_folder: `=`, `:` * resource.parent_name: `=`,
      `:` * resource.parent_display_name: `=`, `:` * resource.type: `=`, `:` *
      finding_class: `=`, `:` * indicator.ip_addresses: `=`, `:` *
      indicator.domains: `=`, `:`
    mostRecentEditor: Output only. Email address of the user who last edited
      the mute config. This field is set by the server and will be ignored if
      provided on config creation or update.
    name: This field will be ignored if provided on config creation. Format
      "organizations/{organization}/muteConfigs/{mute_config}"
      "folders/{folder}/muteConfigs/{mute_config}"
      "projects/{project}/muteConfigs/{mute_config}"
    updateTime: Output only. The most recent time at which the mute config was
      updated. This field is set by the server and will be ignored if provided
      on config creation or update.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  filter = _messages.StringField(4)
  mostRecentEditor = _messages.StringField(5)
  name = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class GoogleCloudSecuritycenterV1NotificationMessage(_messages.Message):
  r"""Cloud SCC's Notification

  Fields:
    finding: If it's a Finding based notification config, this field will be
      populated.
    notificationConfigName: Name of the notification config that generated
      current notification.
    resource: The Cloud resource tied to this notification's Finding.
  """

  finding = _messages.MessageField('Finding', 1)
  notificationConfigName = _messages.StringField(2)
  resource = _messages.MessageField('GoogleCloudSecuritycenterV1Resource', 3)


class GoogleCloudSecuritycenterV1Resource(_messages.Message):
  r"""Information related to the Google Cloud resource.

  Fields:
    displayName: The human readable name of the resource.
    folders: Output only. Contains a Folder message for each folder in the
      assets ancestry. The first folder is the deepest nested folder, and the
      last folder is the folder directly under the Organization.
    name: The full resource name of the resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    parent: The full resource name of resource's parent.
    parentDisplayName: The human readable name of resource's parent.
    project: The full resource name of project that the resource belongs to.
    projectDisplayName: The project ID that the resource belongs to.
    type: The full resource type of the resource.
  """

  displayName = _messages.StringField(1)
  folders = _messages.MessageField('Folder', 2, repeated=True)
  name = _messages.StringField(3)
  parent = _messages.StringField(4)
  parentDisplayName = _messages.StringField(5)
  project = _messages.StringField(6)
  projectDisplayName = _messages.StringField(7)
  type = _messages.StringField(8)


class GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1p1beta1Finding(_messages.Message):
  r"""Security Command Center finding. A finding is a record of assessment
  data (security, risk, health or privacy) ingested into Security Command
  Center for presentation, notification, analysis, policy testing, and
  enforcement. For example, an XSS vulnerability in an App Engine application
  is a finding.

  Enums:
    SeverityValueValuesEnum: The severity of the finding. This field is
      managed by the source that writes the finding.
    StateValueValuesEnum: The state of the finding.

  Messages:
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    canonicalName: The canonical name of the finding. It's either "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}",
      "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
      "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
      depending on the closest CRM ancestor of the resource associated with
      the finding.
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    createTime: The time at which the finding was created in Security Command
      Center.
    eventTime: The time at which the event took place, or when an update to
      the finding occurred. For example, if the finding represents an open
      firewall it would capture the time the detector believes the firewall
      became open. The accuracy is determined by the detector. If the finding
      were to be resolved afterward, this time would reflect when the finding
      was resolved. Must not be set to a value greater than the current
      timestamp.
    externalUri: The URI that, if available, points to a web page outside of
      Security Command Center where additional information about the finding
      can be found. This field is guaranteed to be either empty or a well
      formed URL.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/{organization_id}/sources/{source_id}"
    resourceName: For findings on Google Cloud resources, the full resource
      name of the Google Cloud resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      When the finding is for a non-Google Cloud resource, the resourceName
      can be a customer or partner defined string. This field is immutable
      after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    severity: The severity of the finding. This field is managed by the source
      that writes the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding. This field is managed by the source that
    writes the finding.

    Values:
      SEVERITY_UNSPECIFIED: No severity specified. The default value.
      CRITICAL: Critical severity.
      HIGH: High severity.
      MEDIUM: Medium severity.
      LOW: Low severity.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  category = _messages.StringField(2)
  createTime = _messages.StringField(3)
  eventTime = _messages.StringField(4)
  externalUri = _messages.StringField(5)
  name = _messages.StringField(6)
  parent = _messages.StringField(7)
  resourceName = _messages.StringField(8)
  securityMarks = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1SecurityMarks', 9)
  severity = _messages.EnumField('SeverityValueValuesEnum', 10)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 11)
  state = _messages.EnumField('StateValueValuesEnum', 12)


class GoogleCloudSecuritycenterV1p1beta1Folder(_messages.Message):
  r"""Message that contains the resource name and display name of a folder
  resource.

  Fields:
    resourceFolder: Full resource name of this folder. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceFolderDisplayName: The user defined display name for this folder.
  """

  resourceFolder = _messages.StringField(1)
  resourceFolderDisplayName = _messages.StringField(2)


class GoogleCloudSecuritycenterV1p1beta1NotificationMessage(_messages.Message):
  r"""Security Command Center's Notification

  Fields:
    finding: If it's a Finding based notification config, this field will be
      populated.
    notificationConfigName: Name of the notification config that generated
      current notification.
    resource: The Cloud resource tied to the notification.
  """

  finding = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Finding', 1)
  notificationConfigName = _messages.StringField(2)
  resource = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Resource', 3)


class GoogleCloudSecuritycenterV1p1beta1Resource(_messages.Message):
  r"""Information related to the Google Cloud resource.

  Fields:
    folders: Output only. Contains a Folder message for each folder in the
      assets ancestry. The first folder is the deepest nested folder, and the
      last folder is the folder directly under the Organization.
    name: The full resource name of the resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    parent: The full resource name of resource's parent.
    parentDisplayName: The human readable name of resource's parent.
    project: The full resource name of project that the resource belongs to.
    projectDisplayName: The project id that the resource belongs to.
  """

  folders = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Folder', 1, repeated=True)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  parentDisplayName = _messages.StringField(4)
  project = _messages.StringField(5)
  projectDisplayName = _messages.StringField(6)


class GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1p1beta1SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Security
  Command Center resource. Security marks are scoped within a Security Command
  Center organization -- they can be modified and viewed by all users who have
  proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)

  Fields:
    canonicalName: The canonical name of the marks. Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks"
      "folders/{folder_id}/assets/{asset_id}/securityMarks"
      "projects/{project_number}/assets/{asset_id}/securityMarks" "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}/securityM
      arks" "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks" "projects/{project_number}/sources/{source_id}/findings/{fin
      ding_id}/securityMarks"
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows: * Keys and values are treated as
    case insensitive * Keys must be between 1 - 256 characters (inclusive) *
    Keys must be letters, numbers, underscores, or dashes * Values have
    leading and trailing whitespace trimmed, remaining characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  marks = _messages.MessageField('MarksValue', 2)
  name = _messages.StringField(3)


class IamBinding(_messages.Message):
  r"""Represents a particular IAM binding, which captures a member's role
  addition, removal, or state.

  Enums:
    ActionValueValuesEnum: The action that was performed on a Binding.

  Fields:
    action: The action that was performed on a Binding.
    member: A single identity requesting access for a Cloud Platform resource,
      e.g. "foo@google.com".
    role: Role that is assigned to "members". For example, "roles/viewer",
      "roles/editor", or "roles/owner".
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""The action that was performed on a Binding.

    Values:
      ACTION_UNSPECIFIED: Unspecified.
      ADD: Addition of a Binding.
      REMOVE: Removal of a Binding.
    """
    ACTION_UNSPECIFIED = 0
    ADD = 1
    REMOVE = 2

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  member = _messages.StringField(2)
  role = _messages.StringField(3)


class Indicator(_messages.Message):
  r"""Represents what's commonly known as an Indicator of compromise (IoC) in
  computer forensics. This is an artifact observed on a network or in an
  operating system that, with high confidence, indicates a computer intrusion.
  Reference: https://en.wikipedia.org/wiki/Indicator_of_compromise

  Fields:
    domains: List of domains associated to the Finding.
    ipAddresses: List of ip addresses associated to the Finding.
  """

  domains = _messages.StringField(1, repeated=True)
  ipAddresses = _messages.StringField(2, repeated=True)


class MitreAttack(_messages.Message):
  r"""MITRE ATT&CK tactics and techniques related to this finding. See:
  https://attack.mitre.org

  Enums:
    AdditionalTacticsValueListEntryValuesEnum:
    AdditionalTechniquesValueListEntryValuesEnum:
    PrimaryTacticValueValuesEnum: The MITRE ATT&CK tactic most closely
      represented by this finding, if any.
    PrimaryTechniquesValueListEntryValuesEnum:

  Fields:
    additionalTactics: Additional MITRE ATT&CK tactics related to this
      finding, if any.
    additionalTechniques: Additional MITRE ATT&CK techniques related to this
      finding, if any, along with any of their respective parent techniques.
    primaryTactic: The MITRE ATT&CK tactic most closely represented by this
      finding, if any.
    primaryTechniques: The MITRE ATT&CK technique most closely represented by
      this finding, if any. primary_techniques is a repeated field because
      there are multiple levels of MITRE ATT&CK techniques. If the technique
      most closely represented by this finding is a sub-technique (e.g.
      `SCANNING_IP_BLOCKS`), both the sub-technique and its parent
      technique(s) will be listed (e.g. `SCANNING_IP_BLOCKS`,
      `ACTIVE_SCANNING`).
    version: The MITRE ATT&CK version referenced by the above fields. E.g.
      "8".
  """

  class AdditionalTacticsValueListEntryValuesEnum(_messages.Enum):
    r"""AdditionalTacticsValueListEntryValuesEnum enum type.

    Values:
      TACTIC_UNSPECIFIED: Unspecified value.
      RECONNAISSANCE: TA0043
      RESOURCE_DEVELOPMENT: TA0042
      INITIAL_ACCESS: TA0001
      EXECUTION: TA0002
      PERSISTENCE: TA0003
      PRIVILEGE_ESCALATION: TA0004
      DEFENSE_EVASION: TA0005
      CREDENTIAL_ACCESS: TA0006
      DISCOVERY: TA0007
      LATERAL_MOVEMENT: TA0008
      COLLECTION: TA0009
      COMMAND_AND_CONTROL: TA0011
      EXFILTRATION: TA0010
      IMPACT: TA0040
    """
    TACTIC_UNSPECIFIED = 0
    RECONNAISSANCE = 1
    RESOURCE_DEVELOPMENT = 2
    INITIAL_ACCESS = 3
    EXECUTION = 4
    PERSISTENCE = 5
    PRIVILEGE_ESCALATION = 6
    DEFENSE_EVASION = 7
    CREDENTIAL_ACCESS = 8
    DISCOVERY = 9
    LATERAL_MOVEMENT = 10
    COLLECTION = 11
    COMMAND_AND_CONTROL = 12
    EXFILTRATION = 13
    IMPACT = 14

  class AdditionalTechniquesValueListEntryValuesEnum(_messages.Enum):
    r"""AdditionalTechniquesValueListEntryValuesEnum enum type.

    Values:
      TECHNIQUE_UNSPECIFIED: Unspecified value.
      ACTIVE_SCANNING: T1595
      SCANNING_IP_BLOCKS: T1595.001
      INGRESS_TOOL_TRANSFER: T1105
      NATIVE_API: T1106
      SHARED_MODULES: T1129
      COMMAND_AND_SCRIPTING_INTERPRETER: T1059
      UNIX_SHELL: T1059.004
      RESOURCE_HIJACKING: T1496
      PROXY: T1090
      EXTERNAL_PROXY: T1090.002
      MULTI_HOP_PROXY: T1090.003
      DYNAMIC_RESOLUTION: T1568
      UNSECURED_CREDENTIALS: T1552
      VALID_ACCOUNTS: T1078
      LOCAL_ACCOUNTS: T1078.003
      CLOUD_ACCOUNTS: T1078.004
      NETWORK_DENIAL_OF_SERVICE: T1498
      PERMISSION_GROUPS_DISCOVERY: T1069
      CLOUD_GROUPS: T1069.003
      EXFILTRATION_OVER_WEB_SERVICE: T1567
      EXFILTRATION_TO_CLOUD_STORAGE: T1567.002
      ACCOUNT_MANIPULATION: T1098
      SSH_AUTHORIZED_KEYS: T1098.004
      CREATE_OR_MODIFY_SYSTEM_PROCESS: T1543
      STEAL_WEB_SESSION_COOKIE: T1539
      MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE: T1578
      EXPLOIT_PUBLIC_FACING_APPLICATION: T1190
      MODIFY_AUTHENTICATION_PROCESS: T1556
      DATA_DESTRUCTION: T1485
      DOMAIN_POLICY_MODIFICATION: T1484
    """
    TECHNIQUE_UNSPECIFIED = 0
    ACTIVE_SCANNING = 1
    SCANNING_IP_BLOCKS = 2
    INGRESS_TOOL_TRANSFER = 3
    NATIVE_API = 4
    SHARED_MODULES = 5
    COMMAND_AND_SCRIPTING_INTERPRETER = 6
    UNIX_SHELL = 7
    RESOURCE_HIJACKING = 8
    PROXY = 9
    EXTERNAL_PROXY = 10
    MULTI_HOP_PROXY = 11
    DYNAMIC_RESOLUTION = 12
    UNSECURED_CREDENTIALS = 13
    VALID_ACCOUNTS = 14
    LOCAL_ACCOUNTS = 15
    CLOUD_ACCOUNTS = 16
    NETWORK_DENIAL_OF_SERVICE = 17
    PERMISSION_GROUPS_DISCOVERY = 18
    CLOUD_GROUPS = 19
    EXFILTRATION_OVER_WEB_SERVICE = 20
    EXFILTRATION_TO_CLOUD_STORAGE = 21
    ACCOUNT_MANIPULATION = 22
    SSH_AUTHORIZED_KEYS = 23
    CREATE_OR_MODIFY_SYSTEM_PROCESS = 24
    STEAL_WEB_SESSION_COOKIE = 25
    MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 26
    EXPLOIT_PUBLIC_FACING_APPLICATION = 27
    MODIFY_AUTHENTICATION_PROCESS = 28
    DATA_DESTRUCTION = 29
    DOMAIN_POLICY_MODIFICATION = 30

  class PrimaryTacticValueValuesEnum(_messages.Enum):
    r"""The MITRE ATT&CK tactic most closely represented by this finding, if
    any.

    Values:
      TACTIC_UNSPECIFIED: Unspecified value.
      RECONNAISSANCE: TA0043
      RESOURCE_DEVELOPMENT: TA0042
      INITIAL_ACCESS: TA0001
      EXECUTION: TA0002
      PERSISTENCE: TA0003
      PRIVILEGE_ESCALATION: TA0004
      DEFENSE_EVASION: TA0005
      CREDENTIAL_ACCESS: TA0006
      DISCOVERY: TA0007
      LATERAL_MOVEMENT: TA0008
      COLLECTION: TA0009
      COMMAND_AND_CONTROL: TA0011
      EXFILTRATION: TA0010
      IMPACT: TA0040
    """
    TACTIC_UNSPECIFIED = 0
    RECONNAISSANCE = 1
    RESOURCE_DEVELOPMENT = 2
    INITIAL_ACCESS = 3
    EXECUTION = 4
    PERSISTENCE = 5
    PRIVILEGE_ESCALATION = 6
    DEFENSE_EVASION = 7
    CREDENTIAL_ACCESS = 8
    DISCOVERY = 9
    LATERAL_MOVEMENT = 10
    COLLECTION = 11
    COMMAND_AND_CONTROL = 12
    EXFILTRATION = 13
    IMPACT = 14

  class PrimaryTechniquesValueListEntryValuesEnum(_messages.Enum):
    r"""PrimaryTechniquesValueListEntryValuesEnum enum type.

    Values:
      TECHNIQUE_UNSPECIFIED: Unspecified value.
      ACTIVE_SCANNING: T1595
      SCANNING_IP_BLOCKS: T1595.001
      INGRESS_TOOL_TRANSFER: T1105
      NATIVE_API: T1106
      SHARED_MODULES: T1129
      COMMAND_AND_SCRIPTING_INTERPRETER: T1059
      UNIX_SHELL: T1059.004
      RESOURCE_HIJACKING: T1496
      PROXY: T1090
      EXTERNAL_PROXY: T1090.002
      MULTI_HOP_PROXY: T1090.003
      DYNAMIC_RESOLUTION: T1568
      UNSECURED_CREDENTIALS: T1552
      VALID_ACCOUNTS: T1078
      LOCAL_ACCOUNTS: T1078.003
      CLOUD_ACCOUNTS: T1078.004
      NETWORK_DENIAL_OF_SERVICE: T1498
      PERMISSION_GROUPS_DISCOVERY: T1069
      CLOUD_GROUPS: T1069.003
      EXFILTRATION_OVER_WEB_SERVICE: T1567
      EXFILTRATION_TO_CLOUD_STORAGE: T1567.002
      ACCOUNT_MANIPULATION: T1098
      SSH_AUTHORIZED_KEYS: T1098.004
      CREATE_OR_MODIFY_SYSTEM_PROCESS: T1543
      STEAL_WEB_SESSION_COOKIE: T1539
      MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE: T1578
      EXPLOIT_PUBLIC_FACING_APPLICATION: T1190
      MODIFY_AUTHENTICATION_PROCESS: T1556
      DATA_DESTRUCTION: T1485
      DOMAIN_POLICY_MODIFICATION: T1484
    """
    TECHNIQUE_UNSPECIFIED = 0
    ACTIVE_SCANNING = 1
    SCANNING_IP_BLOCKS = 2
    INGRESS_TOOL_TRANSFER = 3
    NATIVE_API = 4
    SHARED_MODULES = 5
    COMMAND_AND_SCRIPTING_INTERPRETER = 6
    UNIX_SHELL = 7
    RESOURCE_HIJACKING = 8
    PROXY = 9
    EXTERNAL_PROXY = 10
    MULTI_HOP_PROXY = 11
    DYNAMIC_RESOLUTION = 12
    UNSECURED_CREDENTIALS = 13
    VALID_ACCOUNTS = 14
    LOCAL_ACCOUNTS = 15
    CLOUD_ACCOUNTS = 16
    NETWORK_DENIAL_OF_SERVICE = 17
    PERMISSION_GROUPS_DISCOVERY = 18
    CLOUD_GROUPS = 19
    EXFILTRATION_OVER_WEB_SERVICE = 20
    EXFILTRATION_TO_CLOUD_STORAGE = 21
    ACCOUNT_MANIPULATION = 22
    SSH_AUTHORIZED_KEYS = 23
    CREATE_OR_MODIFY_SYSTEM_PROCESS = 24
    STEAL_WEB_SESSION_COOKIE = 25
    MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 26
    EXPLOIT_PUBLIC_FACING_APPLICATION = 27
    MODIFY_AUTHENTICATION_PROCESS = 28
    DATA_DESTRUCTION = 29
    DOMAIN_POLICY_MODIFICATION = 30

  additionalTactics = _messages.EnumField('AdditionalTacticsValueListEntryValuesEnum', 1, repeated=True)
  additionalTechniques = _messages.EnumField('AdditionalTechniquesValueListEntryValuesEnum', 2, repeated=True)
  primaryTactic = _messages.EnumField('PrimaryTacticValueValuesEnum', 3)
  primaryTechniques = _messages.EnumField('PrimaryTechniquesValueListEntryValuesEnum', 4, repeated=True)
  version = _messages.StringField(5)


class OnboardingState(_messages.Message):
  r"""Resource capturing onboarding information for a given CRM resource.

  Enums:
    OnboardingLevelValueValuesEnum: Describes the level a given organization,
      folder, or project is onboarded with SCC. If the resource wasn't
      onboarded, NOT_FOUND would have been thrown.

  Fields:
    name: The resource name of the OnboardingState. Format:
      organizations/{organization}/onboardingState Format:
      folders/{folder}/onboardingState Format:
      projects/{project}/onboardingState
    onboardingLevel: Describes the level a given organization, folder, or
      project is onboarded with SCC. If the resource wasn't onboarded,
      NOT_FOUND would have been thrown.
  """

  class OnboardingLevelValueValuesEnum(_messages.Enum):
    r"""Describes the level a given organization, folder, or project is
    onboarded with SCC. If the resource wasn't onboarded, NOT_FOUND would have
    been thrown.

    Values:
      ONBOARDING_LEVEL_UNSPECIFIED: Unused.
      ONBOARDING_LEVEL_PROJECT: This resource is onboarded at the project
        level. Only possible for projects.
      ONBOARDING_LEVEL_ORGANIZATION: This resource is onboarded at the
        organization level. Possible for organizations, folders, and projects.
    """
    ONBOARDING_LEVEL_UNSPECIFIED = 0
    ONBOARDING_LEVEL_PROJECT = 1
    ONBOARDING_LEVEL_ORGANIZATION = 2

  name = _messages.StringField(1)
  onboardingLevel = _messages.EnumField('OnboardingLevelValueValuesEnum', 2)


class Reference(_messages.Message):
  r"""Additional Links

  Fields:
    source: Source of the reference e.g. NVD
    uri: Uri for the mentioned source e.g. https://cve.mitre.org/cgi-
      bin/cvename.cgi?name=CVE-2021-34527.
  """

  source = _messages.StringField(1)
  uri = _messages.StringField(2)


class SecurityCenterSettings(_messages.Message):
  r"""Resource capturing the settings for Security Center.

  Fields:
    logSinkProject: The resource name of the project to send logs to. This
      project must be part of the organization this resource resides in. The
      format is `projects/{project_id}`. An empty value disables logging. This
      value is only referenced by services that support log sink. Please refer
      to the documentation for an updated list of compatible services.
    name: The resource name of the SecurityCenterSettings. Format:
      organizations/{organization}/securityCenterSettings
    orgServiceAccount: The organization level service account to be used for
      security center components.
  """

  logSinkProject = _messages.StringField(1)
  name = _messages.StringField(2)
  orgServiceAccount = _messages.StringField(3)


class SecurityHealthAnalyticsSettings(_messages.Message):
  r"""Resource capturing the settings for the Security Health Analytics
  service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    serviceAccount: Output only. The service account used by Security Health
      Analytics detectors.
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceAccount = _messages.StringField(3)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Security
  Command Center resource. Security marks are scoped within a Security Command
  Center organization -- they can be modified and viewed by all users who have
  proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)

  Fields:
    canonicalName: The canonical name of the marks. Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks"
      "folders/{folder_id}/assets/{asset_id}/securityMarks"
      "projects/{project_number}/assets/{asset_id}/securityMarks" "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}/securityM
      arks" "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks" "projects/{project_number}/sources/{source_id}/findings/{fin
      ding_id}/securityMarks"
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows: * Keys and values are treated as
    case insensitive * Keys must be between 1 - 256 characters (inclusive) *
    Keys must be letters, numbers, underscores, or dashes * Values have
    leading and trailing whitespace trimmed, remaining characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  marks = _messages.MessageField('MarksValue', 2)
  name = _messages.StringField(3)


class SecuritycenterFoldersContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersContainerThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersEventThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersEventThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to calculate.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetContainerThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetEventThreatDetectionSettingsRequest object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to retrieve.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetOnboardingStateRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetOnboardingStateRequest object.

  Fields:
    name: Required. The name of the OnboardingState to retrieve. Formats: *
      organizations/{organization}/onboardingState *
      folders/{folder}/onboardingState * projects/{project}/onboardingState
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetSecurityHealthAnalyticsSettingsRequest object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      retrieve. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetVirtualMachineThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetVirtualMachineThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the VirtualMachineThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetWebSecurityScannerSettingsRequest object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to retrieve.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersSecurityHealthAnalyticsSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersSecurityHealthAnalyticsSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      calculate. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateContainerThreatDetectionSettingsRequest
  object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersUpdateEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateEventThreatDetectionSettingsRequest object.

  Fields:
    eventThreatDetectionSettings: A EventThreatDetectionSettings resource to
      be passed as the request body.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    updateMask: The list of fields to be updated.
  """

  eventThreatDetectionSettings = _messages.MessageField('EventThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersUpdateSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    securityHealthAnalyticsSettings: A SecurityHealthAnalyticsSettings
      resource to be passed as the request body.
    updateMask: The list of fields to be updated.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsSettings = _messages.MessageField('SecurityHealthAnalyticsSettings', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersUpdateVirtualMachineThreatDetectionSettingsRequest(_messages.Message):
  r"""A
  SecuritycenterFoldersUpdateVirtualMachineThreatDetectionSettingsRequest
  object.

  Fields:
    name: The resource name of the VirtualMachineThreatDetectionSettings.
      Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
    updateMask: The list of fields to be updated.
    virtualMachineThreatDetectionSettings: A
      VirtualMachineThreatDetectionSettings resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  virtualMachineThreatDetectionSettings = _messages.MessageField('VirtualMachineThreatDetectionSettings', 3)


class SecuritycenterFoldersUpdateWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateWebSecurityScannerSettingsRequest object.

  Fields:
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    updateMask: The list of fields to be updated.
    webSecurityScannerSettings: A WebSecurityScannerSettings resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  webSecurityScannerSettings = _messages.MessageField('WebSecurityScannerSettings', 3)


class SecuritycenterFoldersVirtualMachineThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterFoldersVirtualMachineThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the VirtualMachineThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersWebSecurityScannerSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersWebSecurityScannerSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to calculate.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsContainerThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsEventThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsEventThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to calculate.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetContainerThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetEventThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to retrieve.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetOnboardingStateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetOnboardingStateRequest object.

  Fields:
    name: Required. The name of the OnboardingState to retrieve. Formats: *
      organizations/{organization}/onboardingState *
      folders/{folder}/onboardingState * projects/{project}/onboardingState
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetSecurityCenterSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetSecurityCenterSettingsRequest object.

  Fields:
    name: Required. The name of the SecurityCenterSettings to retrieve.
      Format: organizations/{organization}/securityCenterSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      retrieve. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetSubscriptionRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetSubscriptionRequest object.

  Fields:
    name: Required. The name of the subscription to retrieve. Format:
      organizations/{organization}/subscription
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetVirtualMachineThreatDetectionSettingsRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsGetVirtualMachineThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the VirtualMachineThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetWebSecurityScannerSettingsRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to retrieve.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsSecurityHealthAnalyticsSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsSecurityHealthAnalyticsSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      calculate. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsUpdateContainerThreatDetectionSettingsRequest
  object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsUpdateEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsUpdateEventThreatDetectionSettingsRequest
  object.

  Fields:
    eventThreatDetectionSettings: A EventThreatDetectionSettings resource to
      be passed as the request body.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    updateMask: The list of fields to be updated.
  """

  eventThreatDetectionSettings = _messages.MessageField('EventThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsUpdateSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsUpdateSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    securityHealthAnalyticsSettings: A SecurityHealthAnalyticsSettings
      resource to be passed as the request body.
    updateMask: The list of fields to be updated.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsSettings = _messages.MessageField('SecurityHealthAnalyticsSettings', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsUpdateVirtualMachineThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsUpdateVirtualMachineThreatDetectionSettings
  Request object.

  Fields:
    name: The resource name of the VirtualMachineThreatDetectionSettings.
      Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
    updateMask: The list of fields to be updated.
    virtualMachineThreatDetectionSettings: A
      VirtualMachineThreatDetectionSettings resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  virtualMachineThreatDetectionSettings = _messages.MessageField('VirtualMachineThreatDetectionSettings', 3)


class SecuritycenterOrganizationsUpdateWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsUpdateWebSecurityScannerSettingsRequest
  object.

  Fields:
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    updateMask: The list of fields to be updated.
    webSecurityScannerSettings: A WebSecurityScannerSettings resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  webSecurityScannerSettings = _messages.MessageField('WebSecurityScannerSettings', 3)


class SecuritycenterOrganizationsVirtualMachineThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsVirtualMachineThreatDetectionSettingsCalcul
  ateRequest object.

  Fields:
    name: Required. The name of the VirtualMachineThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsWebSecurityScannerSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsWebSecurityScannerSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to calculate.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsContainerThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsEventThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsEventThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to calculate.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetContainerThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetEventThreatDetectionSettingsRequest object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to retrieve.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetOnboardingStateRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetOnboardingStateRequest object.

  Fields:
    name: Required. The name of the OnboardingState to retrieve. Formats: *
      organizations/{organization}/onboardingState *
      folders/{folder}/onboardingState * projects/{project}/onboardingState
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      retrieve. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetVirtualMachineThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetVirtualMachineThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the VirtualMachineThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetWebSecurityScannerSettingsRequest object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to retrieve.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsLocationsClustersContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsLocationsClustersContainerThreatDetectionSetting
  sCalculateRequest object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsLocationsClustersGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsLocationsClustersGetContainerThreatDetectionSett
  ingsRequest object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsLocationsClustersUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsLocationsClustersUpdateContainerThreatDetectionS
  ettingsRequest object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsSecurityHealthAnalyticsSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsSecurityHealthAnalyticsSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      calculate. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateContainerThreatDetectionSettingsRequest
  object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsUpdateEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateEventThreatDetectionSettingsRequest
  object.

  Fields:
    eventThreatDetectionSettings: A EventThreatDetectionSettings resource to
      be passed as the request body.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    updateMask: The list of fields to be updated.
  """

  eventThreatDetectionSettings = _messages.MessageField('EventThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsUpdateSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    securityHealthAnalyticsSettings: A SecurityHealthAnalyticsSettings
      resource to be passed as the request body.
    updateMask: The list of fields to be updated.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsSettings = _messages.MessageField('SecurityHealthAnalyticsSettings', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsUpdateVirtualMachineThreatDetectionSettingsRequest(_messages.Message):
  r"""A
  SecuritycenterProjectsUpdateVirtualMachineThreatDetectionSettingsRequest
  object.

  Fields:
    name: The resource name of the VirtualMachineThreatDetectionSettings.
      Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
    updateMask: The list of fields to be updated.
    virtualMachineThreatDetectionSettings: A
      VirtualMachineThreatDetectionSettings resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  virtualMachineThreatDetectionSettings = _messages.MessageField('VirtualMachineThreatDetectionSettings', 3)


class SecuritycenterProjectsUpdateWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateWebSecurityScannerSettingsRequest object.

  Fields:
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    updateMask: The list of fields to be updated.
    webSecurityScannerSettings: A WebSecurityScannerSettings resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  webSecurityScannerSettings = _messages.MessageField('WebSecurityScannerSettings', 3)


class SecuritycenterProjectsVirtualMachineThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterProjectsVirtualMachineThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the VirtualMachineThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsWebSecurityScannerSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsWebSecurityScannerSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to calculate.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Subscription(_messages.Message):
  r"""Resource capturing the state of an organization's subscription.

  Enums:
    TierValueValuesEnum: The tier of SCC features this organization currently
      has access to.

  Fields:
    details: The details of the most recent active subscription. If there has
      never been a subscription this will be empty.
    name: The resource name of the subscription. Format:
      organizations/{organization}/subscription
    tier: The tier of SCC features this organization currently has access to.
  """

  class TierValueValuesEnum(_messages.Enum):
    r"""The tier of SCC features this organization currently has access to.

    Values:
      TIER_UNSPECIFIED: Default value. This value is unused.
      STANDARD: The standard tier.
      PREMIUM: The premium tier.
    """
    TIER_UNSPECIFIED = 0
    STANDARD = 1
    PREMIUM = 2

  details = _messages.MessageField('Details', 1)
  name = _messages.StringField(2)
  tier = _messages.EnumField('TierValueValuesEnum', 3)


class VirtualMachineThreatDetectionSettings(_messages.Message):
  r"""Resource capturing the settings for the Virtual Machine Threat Detection
  service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the VirtualMachineThreatDetectionSettings.
      Formats: *
      organizations/{organization}/virtualMachineThreatDetectionSettings *
      folders/{folder}/virtualMachineThreatDetectionSettings *
      projects/{project}/virtualMachineThreatDetectionSettings
    serviceAccount: Output only. The service account used by Virtual Machine
      Threat Detection detectors.
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceAccount = _messages.StringField(3)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class Vulnerability(_messages.Message):
  r"""Refers to common vulnerability fields e.g. cve, cvss, cwe etc.

  Fields:
    cve: CVE stands for Common Vulnerabilities and Exposures
      (https://cve.mitre.org/about/)
  """

  cve = _messages.MessageField('Cve', 1)


class WebSecurityScannerSettings(_messages.Message):
  r"""Resource capturing the settings for the Web Security Scanner service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
