"""Generated message classes for testing version v1.

Allows developers to run automated tests for their mobile applications on
Google infrastructure.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'testing'


class Account(_messages.Message):
  r"""Identifies an account and how to log into it.

  Fields:
    googleAuto: An automatic google login account.
  """

  googleAuto = _messages.MessageField('GoogleAuto', 1)


class AndroidDevice(_messages.Message):
  r"""A single Android device.

  Fields:
    androidModelId: Required. The id of the Android device to be used. Use the
      TestEnvironmentDiscoveryService to get supported options.
    androidVersionId: Required. The id of the Android OS version to be used.
      Use the TestEnvironmentDiscoveryService to get supported options.
    locale: Required. The locale the test device used for testing. Use the
      TestEnvironmentDiscoveryService to get supported options.
    orientation: Required. How the device is oriented during the test. Use the
      TestEnvironmentDiscoveryService to get supported options.
  """

  androidModelId = _messages.StringField(1)
  androidVersionId = _messages.StringField(2)
  locale = _messages.StringField(3)
  orientation = _messages.StringField(4)


class AndroidDeviceCatalog(_messages.Message):
  r"""The currently supported Android devices.

  Fields:
    models: The set of supported Android device models.
    runtimeConfiguration: The set of supported runtime configurations.
    versions: The set of supported Android OS versions.
  """

  models = _messages.MessageField('AndroidModel', 1, repeated=True)
  runtimeConfiguration = _messages.MessageField('AndroidRuntimeConfiguration', 2)
  versions = _messages.MessageField('AndroidVersion', 3, repeated=True)


class AndroidDeviceList(_messages.Message):
  r"""A list of Android device configurations in which the test is to be
  executed.

  Fields:
    androidDevices: Required. A list of Android devices.
  """

  androidDevices = _messages.MessageField('AndroidDevice', 1, repeated=True)


class AndroidInstrumentationTest(_messages.Message):
  r"""A test of an Android application that can control an Android component
  independently of its normal lifecycle. Android instrumentation tests run an
  application APK and test APK inside the same process on a virtual or
  physical AndroidDevice. They also specify a test runner class, such as
  com.google.GoogleTestRunner, which can vary on the specific instrumentation
  framework chosen. See for more information on types of Android tests.

  Enums:
    OrchestratorOptionValueValuesEnum: The option of whether running each test
      within its own invocation of instrumentation with Android Test
      Orchestrator or not. ** Orchestrator is only compatible with
      AndroidJUnitRunner version 1.1 or higher! ** Orchestrator offers the
      following benefits: - No shared state - Crashes are isolated - Logs are
      scoped per test See for more information about Android Test
      Orchestrator. If not set, the test will be run without the orchestrator.

  Fields:
    appApk: The APK for the application under test.
    appBundle: A multi-apk app bundle for the application under test.
    appPackageId: The java package for the application under test. The default
      value is determined by examining the application's manifest.
    orchestratorOption: The option of whether running each test within its own
      invocation of instrumentation with Android Test Orchestrator or not. **
      Orchestrator is only compatible with AndroidJUnitRunner version 1.1 or
      higher! ** Orchestrator offers the following benefits: - No shared state
      - Crashes are isolated - Logs are scoped per test See for more
      information about Android Test Orchestrator. If not set, the test will
      be run without the orchestrator.
    shardingOption: The option to run tests in multiple shards in parallel.
    testApk: Required. The APK containing the test code to be executed.
    testPackageId: The java package for the test to be executed. The default
      value is determined by examining the application's manifest.
    testRunnerClass: The InstrumentationTestRunner class. The default value is
      determined by examining the application's manifest.
    testTargets: Each target must be fully qualified with the package name or
      class name, in one of these formats: - "package package_name" - "class
      package_name.class_name" - "class package_name.class_name#method_name"
      If empty, all targets in the module will be run.
  """

  class OrchestratorOptionValueValuesEnum(_messages.Enum):
    r"""The option of whether running each test within its own invocation of
    instrumentation with Android Test Orchestrator or not. ** Orchestrator is
    only compatible with AndroidJUnitRunner version 1.1 or higher! **
    Orchestrator offers the following benefits: - No shared state - Crashes
    are isolated - Logs are scoped per test See for more information about
    Android Test Orchestrator. If not set, the test will be run without the
    orchestrator.

    Values:
      ORCHESTRATOR_OPTION_UNSPECIFIED: Default value: the server will choose
        the mode. Currently implies that the test will run without the
        orchestrator. In the future, all instrumentation tests will be run
        with the orchestrator. Using the orchestrator is highly encouraged
        because of all the benefits it offers.
      USE_ORCHESTRATOR: Run test using orchestrator. ** Only compatible with
        AndroidJUnitRunner version 1.1 or higher! ** Recommended.
      DO_NOT_USE_ORCHESTRATOR: Run test without using orchestrator.
    """
    ORCHESTRATOR_OPTION_UNSPECIFIED = 0
    USE_ORCHESTRATOR = 1
    DO_NOT_USE_ORCHESTRATOR = 2

  appApk = _messages.MessageField('FileReference', 1)
  appBundle = _messages.MessageField('AppBundle', 2)
  appPackageId = _messages.StringField(3)
  orchestratorOption = _messages.EnumField('OrchestratorOptionValueValuesEnum', 4)
  shardingOption = _messages.MessageField('ShardingOption', 5)
  testApk = _messages.MessageField('FileReference', 6)
  testPackageId = _messages.StringField(7)
  testRunnerClass = _messages.StringField(8)
  testTargets = _messages.StringField(9, repeated=True)


class AndroidMatrix(_messages.Message):
  r"""A set of Android device configuration permutations is defined by the the
  cross-product of the given axes. Internally, the given AndroidMatrix will be
  expanded into a set of AndroidDevices. Only supported permutations will be
  instantiated. Invalid permutations (e.g., incompatible models/versions) are
  ignored.

  Fields:
    androidModelIds: Required. The ids of the set of Android device to be
      used. Use the TestEnvironmentDiscoveryService to get supported options.
    androidVersionIds: Required. The ids of the set of Android OS version to
      be used. Use the TestEnvironmentDiscoveryService to get supported
      options.
    locales: Required. The set of locales the test device will enable for
      testing. Use the TestEnvironmentDiscoveryService to get supported
      options.
    orientations: Required. The set of orientations to test with. Use the
      TestEnvironmentDiscoveryService to get supported options.
  """

  androidModelIds = _messages.StringField(1, repeated=True)
  androidVersionIds = _messages.StringField(2, repeated=True)
  locales = _messages.StringField(3, repeated=True)
  orientations = _messages.StringField(4, repeated=True)


class AndroidModel(_messages.Message):
  r"""A description of an Android device tests may be run on.

  Enums:
    FormValueValuesEnum: Whether this device is virtual or physical.
    FormFactorValueValuesEnum: Whether this device is a phone, tablet,
      wearable, etc.

  Fields:
    brand: The company that this device is branded with. Example: "Google",
      "Samsung".
    codename: The name of the industrial design. This corresponds to
      android.os.Build.DEVICE.
    form: Whether this device is virtual or physical.
    formFactor: Whether this device is a phone, tablet, wearable, etc.
    id: The unique opaque id for this model. Use this for invoking the
      TestExecutionService.
    lowFpsVideoRecording: True if and only if tests with this model are
      recorded by stitching together screenshots. See
      use_low_spec_video_recording in device config.
    manufacturer: The manufacturer of this device.
    name: The human-readable marketing name for this device model. Examples:
      "Nexus 5", "Galaxy S5".
    screenDensity: Screen density in DPI. This corresponds to
      ro.sf.lcd_density
    screenX: Screen size in the horizontal (X) dimension measured in pixels.
    screenY: Screen size in the vertical (Y) dimension measured in pixels.
    supportedAbis: The list of supported ABIs for this device. This
      corresponds to either android.os.Build.SUPPORTED_ABIS (for API level 21
      and above) or android.os.Build.CPU_ABI/CPU_ABI2. The most preferred ABI
      is the first element in the list. Elements are optionally prefixed by
      "version_id:" (where version_id is the id of an AndroidVersion),
      denoting an ABI that is supported only on a particular version.
    supportedVersionIds: The set of Android versions this device supports.
    tags: Tags for this dimension. Examples: "default", "preview",
      "deprecated".
    thumbnailUrl: URL of a thumbnail image (photo) of the device. e.g.
      https://lh3.googleusercontent.com/90WcauuJiCYABEl8U0lcZeuS5STUbf2yW...
  """

  class FormFactorValueValuesEnum(_messages.Enum):
    r"""Whether this device is a phone, tablet, wearable, etc.

    Values:
      DEVICE_FORM_FACTOR_UNSPECIFIED: Do not use. For proto versioning only.
      PHONE: This device has the shape of a phone.
      TABLET: This device has the shape of a tablet.
      WEARABLE: This device has the shape of a watch or other wearable.
    """
    DEVICE_FORM_FACTOR_UNSPECIFIED = 0
    PHONE = 1
    TABLET = 2
    WEARABLE = 3

  class FormValueValuesEnum(_messages.Enum):
    r"""Whether this device is virtual or physical.

    Values:
      DEVICE_FORM_UNSPECIFIED: Do not use. For proto versioning only.
      VIRTUAL: Android virtual device using Compute Engine native
        virtualization. Firebase Test Lab only.
      PHYSICAL: Actual hardware.
      EMULATOR: Android virtual device using emulator in nested
        virtualization. Equivalent to Android Studio.
    """
    DEVICE_FORM_UNSPECIFIED = 0
    VIRTUAL = 1
    PHYSICAL = 2
    EMULATOR = 3

  brand = _messages.StringField(1)
  codename = _messages.StringField(2)
  form = _messages.EnumField('FormValueValuesEnum', 3)
  formFactor = _messages.EnumField('FormFactorValueValuesEnum', 4)
  id = _messages.StringField(5)
  lowFpsVideoRecording = _messages.BooleanField(6)
  manufacturer = _messages.StringField(7)
  name = _messages.StringField(8)
  screenDensity = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  screenX = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  screenY = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  supportedAbis = _messages.StringField(12, repeated=True)
  supportedVersionIds = _messages.StringField(13, repeated=True)
  tags = _messages.StringField(14, repeated=True)
  thumbnailUrl = _messages.StringField(15)


class AndroidRoboTest(_messages.Message):
  r"""A test of an android application that explores the application on a
  virtual or physical Android Device, finding culprits and crashes as it goes.

  Enums:
    RoboModeValueValuesEnum: The mode in which Robo should run. Most clients
      should allow the server to populate this field automatically.

  Fields:
    appApk: The APK for the application under test.
    appBundle: A multi-apk app bundle for the application under test.
    appInitialActivity: The initial activity that should be used to start the
      app.
    appPackageId: The java package for the application under test. The default
      value is determined by examining the application's manifest.
    roboDirectives: A set of directives Robo should apply during the crawl.
      This allows users to customize the crawl. For example, the username and
      password for a test account can be provided.
    roboMode: The mode in which Robo should run. Most clients should allow the
      server to populate this field automatically.
    roboScript: A JSON file with a sequence of actions Robo should perform as
      a prologue for the crawl.
    startingIntents: The intents used to launch the app for the crawl. If none
      are provided, then the main launcher activity is launched. If some are
      provided, then only those provided are launched (the main launcher
      activity must be provided explicitly).
  """

  class RoboModeValueValuesEnum(_messages.Enum):
    r"""The mode in which Robo should run. Most clients should allow the
    server to populate this field automatically.

    Values:
      ROBO_MODE_UNSPECIFIED: This means that the server should choose the
        mode. Recommended.
      ROBO_VERSION_1: Runs Robo in UIAutomator-only mode without app resigning
      ROBO_VERSION_2: Runs Robo in standard Espresso with UIAutomator fallback
    """
    ROBO_MODE_UNSPECIFIED = 0
    ROBO_VERSION_1 = 1
    ROBO_VERSION_2 = 2

  appApk = _messages.MessageField('FileReference', 1)
  appBundle = _messages.MessageField('AppBundle', 2)
  appInitialActivity = _messages.StringField(3)
  appPackageId = _messages.StringField(4)
  roboDirectives = _messages.MessageField('RoboDirective', 5, repeated=True)
  roboMode = _messages.EnumField('RoboModeValueValuesEnum', 6)
  roboScript = _messages.MessageField('FileReference', 7)
  startingIntents = _messages.MessageField('RoboStartingIntent', 8, repeated=True)


class AndroidRuntimeConfiguration(_messages.Message):
  r"""Android configuration that can be selected at the time a test is run.

  Fields:
    locales: The set of available locales.
    orientations: The set of available orientations.
  """

  locales = _messages.MessageField('Locale', 1, repeated=True)
  orientations = _messages.MessageField('Orientation', 2, repeated=True)


class AndroidTestLoop(_messages.Message):
  r"""A test of an Android Application with a Test Loop. The intent \ will be
  implicitly added, since Games is the only user of this api, for the time
  being.

  Fields:
    appApk: The APK for the application under test.
    appBundle: A multi-apk app bundle for the application under test.
    appPackageId: The java package for the application under test. The default
      is determined by examining the application's manifest.
    scenarioLabels: The list of scenario labels that should be run during the
      test. The scenario labels should map to labels defined in the
      application's manifest. For example, player_experience and
      com.google.test.loops.player_experience add all of the loops labeled in
      the manifest with the com.google.test.loops.player_experience name to
      the execution. Scenarios can also be specified in the scenarios field.
    scenarios: The list of scenarios that should be run during the test. The
      default is all test loops, derived from the application's manifest.
  """

  appApk = _messages.MessageField('FileReference', 1)
  appBundle = _messages.MessageField('AppBundle', 2)
  appPackageId = _messages.StringField(3)
  scenarioLabels = _messages.StringField(4, repeated=True)
  scenarios = _messages.IntegerField(5, repeated=True, variant=_messages.Variant.INT32)


class AndroidVersion(_messages.Message):
  r"""A version of the Android OS.

  Fields:
    apiLevel: The API level for this Android version. Examples: 18, 19.
    codeName: The code name for this Android version. Examples: "JellyBean",
      "KitKat".
    distribution: Market share for this version.
    id: An opaque id for this Android version. Use this id to invoke the
      TestExecutionService.
    releaseDate: The date this Android version became available in the market.
    tags: Tags for this dimension. Examples: "default", "preview",
      "deprecated".
    versionString: A string representing this version of the Android OS.
      Examples: "4.3", "4.4".
  """

  apiLevel = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  codeName = _messages.StringField(2)
  distribution = _messages.MessageField('Distribution', 3)
  id = _messages.StringField(4)
  releaseDate = _messages.MessageField('Date', 5)
  tags = _messages.StringField(6, repeated=True)
  versionString = _messages.StringField(7)


class Apk(_messages.Message):
  r"""An Android package file to install.

  Fields:
    location: The path to an APK to be installed on the device before the test
      begins.
    packageName: The java package for the APK to be installed. Value is
      determined by examining the application's manifest.
  """

  location = _messages.MessageField('FileReference', 1)
  packageName = _messages.StringField(2)


class ApkDetail(_messages.Message):
  r"""Android application details based on application manifest and apk
  archive contents.

  Fields:
    apkManifest: A ApkManifest attribute.
  """

  apkManifest = _messages.MessageField('ApkManifest', 1)


class ApkManifest(_messages.Message):
  r"""An Android app manifest. See
  http://developer.android.com/guide/topics/manifest/manifest-intro.html

  Fields:
    applicationLabel: User-readable name for the application.
    intentFilters: A IntentFilter attribute.
    maxSdkVersion: Maximum API level on which the application is designed to
      run.
    minSdkVersion: Minimum API level required for the application to run.
    packageName: Full Java-style package name for this application, e.g.
      "com.example.foo".
    targetSdkVersion: Specifies the API Level on which the application is
      designed to run.
    usesPermission: Permissions declared to be used by the application
  """

  applicationLabel = _messages.StringField(1)
  intentFilters = _messages.MessageField('IntentFilter', 2, repeated=True)
  maxSdkVersion = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minSdkVersion = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  packageName = _messages.StringField(5)
  targetSdkVersion = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  usesPermission = _messages.StringField(7, repeated=True)


class AppBundle(_messages.Message):
  r"""An Android App Bundle file format, containing a BundleConfig.pb file, a
  base module directory, zero or more dynamic feature module directories. See
  https://developer.android.com/guide/app-bundle/build for guidance on
  building App Bundles.

  Fields:
    bundleLocation: .aab file representing the app bundle under test.
  """

  bundleLocation = _messages.MessageField('FileReference', 1)


class CancelTestMatrixResponse(_messages.Message):
  r"""Response containing the current state of the specified test matrix.

  Enums:
    TestStateValueValuesEnum: The current rolled-up state of the test matrix.
      If this state is already final, then the cancelation request will have
      no effect.

  Fields:
    testState: The current rolled-up state of the test matrix. If this state
      is already final, then the cancelation request will have no effect.
  """

  class TestStateValueValuesEnum(_messages.Enum):
    r"""The current rolled-up state of the test matrix. If this state is
    already final, then the cancelation request will have no effect.

    Values:
      TEST_STATE_UNSPECIFIED: Do not use. For proto versioning only.
      VALIDATING: The execution or matrix is being validated.
      PENDING: The execution or matrix is waiting for resources to become
        available.
      RUNNING: The execution is currently being processed. Can only be set on
        an execution.
      FINISHED: The execution or matrix has terminated normally. On a matrix
        this means that the matrix level processing completed normally, but
        individual executions may be in an ERROR state.
      ERROR: The execution or matrix has stopped because it encountered an
        infrastructure failure.
      UNSUPPORTED_ENVIRONMENT: The execution was not run because it
        corresponds to a unsupported environment. Can only be set on an
        execution.
      INCOMPATIBLE_ENVIRONMENT: The execution was not run because the provided
        inputs are incompatible with the requested environment. Example:
        requested AndroidVersion is lower than APK's minSdkVersion Can only be
        set on an execution.
      INCOMPATIBLE_ARCHITECTURE: The execution was not run because the
        provided inputs are incompatible with the requested architecture.
        Example: requested device does not support running the native code in
        the supplied APK Can only be set on an execution.
      CANCELLED: The user cancelled the execution. Can only be set on an
        execution.
      INVALID: The execution or matrix was not run because the provided inputs
        are not valid. Examples: input file is not of the expected type, is
        malformed/corrupt, or was flagged as malware
    """
    TEST_STATE_UNSPECIFIED = 0
    VALIDATING = 1
    PENDING = 2
    RUNNING = 3
    FINISHED = 4
    ERROR = 5
    UNSUPPORTED_ENVIRONMENT = 6
    INCOMPATIBLE_ENVIRONMENT = 7
    INCOMPATIBLE_ARCHITECTURE = 8
    CANCELLED = 9
    INVALID = 10

  testState = _messages.EnumField('TestStateValueValuesEnum', 1)


class ClientInfo(_messages.Message):
  r"""Information about the client which invoked the test.

  Fields:
    clientInfoDetails: The list of detailed information about client.
    name: Required. Client name, such as gcloud.
  """

  clientInfoDetails = _messages.MessageField('ClientInfoDetail', 1, repeated=True)
  name = _messages.StringField(2)


class ClientInfoDetail(_messages.Message):
  r"""Key-value pair of detailed information about the client which invoked
  the test. Examples: {'Version', '1.0'}, {'Release Track', 'BETA'}.

  Fields:
    key: Required. The key of detailed client information.
    value: Required. The value of detailed client information.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values. * A month and day, with a zero year (for example, an
  anniversary). * A year on its own, with a zero month and a zero day. * A
  year and month, with a zero day (for example, a credit card expiration
  date). Related types: * google.type.TimeOfDay * google.type.DateTime *
  google.protobuf.Timestamp

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class DeviceFile(_messages.Message):
  r"""A single device file description.

  Fields:
    obbFile: A reference to an opaque binary blob file.
    regularFile: A reference to a regular file.
  """

  obbFile = _messages.MessageField('ObbFile', 1)
  regularFile = _messages.MessageField('RegularFile', 2)


class DeviceIpBlock(_messages.Message):
  r"""A single device IP block

  Enums:
    FormValueValuesEnum: Whether this block is used by physical or virtual
      devices

  Fields:
    addedDate: The date this block was added to Firebase Test Lab
    block: An IP address block in CIDR notation eg: 34.68.194.64/29
    form: Whether this block is used by physical or virtual devices
  """

  class FormValueValuesEnum(_messages.Enum):
    r"""Whether this block is used by physical or virtual devices

    Values:
      DEVICE_FORM_UNSPECIFIED: Do not use. For proto versioning only.
      VIRTUAL: Android virtual device using Compute Engine native
        virtualization. Firebase Test Lab only.
      PHYSICAL: Actual hardware.
      EMULATOR: Android virtual device using emulator in nested
        virtualization. Equivalent to Android Studio.
    """
    DEVICE_FORM_UNSPECIFIED = 0
    VIRTUAL = 1
    PHYSICAL = 2
    EMULATOR = 3

  addedDate = _messages.MessageField('Date', 1)
  block = _messages.StringField(2)
  form = _messages.EnumField('FormValueValuesEnum', 3)


class DeviceIpBlockCatalog(_messages.Message):
  r"""List of IP blocks used by the Firebase Test Lab

  Fields:
    ipBlocks: The device IP blocks used by Firebase Test Lab
  """

  ipBlocks = _messages.MessageField('DeviceIpBlock', 1, repeated=True)


class Distribution(_messages.Message):
  r"""Data about the relative number of devices running a given configuration
  of the Android platform.

  Fields:
    marketShare: Output only. The estimated fraction (0-1) of the total market
      with this configuration.
    measurementTime: Output only. The time this distribution was measured.
  """

  marketShare = _messages.FloatField(1)
  measurementTime = _messages.StringField(2)


class Environment(_messages.Message):
  r"""The environment in which the test is run.

  Fields:
    androidDevice: An Android device which must be used with an Android test.
    iosDevice: An iOS device which must be used with an iOS test.
  """

  androidDevice = _messages.MessageField('AndroidDevice', 1)
  iosDevice = _messages.MessageField('IosDevice', 2)


class EnvironmentMatrix(_messages.Message):
  r"""The matrix of environments in which the test is to be executed.

  Fields:
    androidDeviceList: A list of Android devices; the test will be run only on
      the specified devices.
    androidMatrix: A matrix of Android devices.
    iosDeviceList: A list of iOS devices.
  """

  androidDeviceList = _messages.MessageField('AndroidDeviceList', 1)
  androidMatrix = _messages.MessageField('AndroidMatrix', 2)
  iosDeviceList = _messages.MessageField('IosDeviceList', 3)


class EnvironmentVariable(_messages.Message):
  r"""A key-value pair passed as an environment variable to the test.

  Fields:
    key: Key for the environment variable.
    value: Value for the environment variable.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class FileReference(_messages.Message):
  r"""A reference to a file, used for user inputs.

  Fields:
    gcsPath: A path to a file in Google Cloud Storage. Example: gs://build-
      app-1414623860166/app%40debug-unaligned.apk These paths are expected to
      be url encoded (percent encoding)
  """

  gcsPath = _messages.StringField(1)


class GetApkDetailsResponse(_messages.Message):
  r"""Response containing the details of the specified Android application
  APK.

  Fields:
    apkDetail: Details of the Android APK.
  """

  apkDetail = _messages.MessageField('ApkDetail', 1)


class GoogleAuto(_messages.Message):
  r"""Enables automatic Google account login. If set, the service
  automatically generates a Google test account and adds it to the device,
  before executing the test. Note that test accounts might be reused. Many
  applications show their full set of functionalities when an account is
  present on the device. Logging into the device with these generated accounts
  allows testing more functionalities.
  """



class GoogleCloudStorage(_messages.Message):
  r"""A storage location within Google cloud storage (GCS).

  Fields:
    gcsPath: Required. The path to a directory in GCS that will eventually
      contain the results for this test. The requesting user must have write
      access on the bucket in the supplied path.
  """

  gcsPath = _messages.StringField(1)


class IntentFilter(_messages.Message):
  r"""The section of an tag.
  https://developer.android.com/guide/topics/manifest/intent-filter-
  element.html

  Fields:
    actionNames: The android:name value of the tag.
    categoryNames: The android:name value of the tag.
    mimeType: The android:mimeType value of the tag.
  """

  actionNames = _messages.StringField(1, repeated=True)
  categoryNames = _messages.StringField(2, repeated=True)
  mimeType = _messages.StringField(3)


class IosDevice(_messages.Message):
  r"""A single iOS device.

  Fields:
    iosModelId: Required. The id of the iOS device to be used. Use the
      TestEnvironmentDiscoveryService to get supported options.
    iosVersionId: Required. The id of the iOS major software version to be
      used. Use the TestEnvironmentDiscoveryService to get supported options.
    locale: Required. The locale the test device used for testing. Use the
      TestEnvironmentDiscoveryService to get supported options.
    orientation: Required. How the device is oriented during the test. Use the
      TestEnvironmentDiscoveryService to get supported options.
  """

  iosModelId = _messages.StringField(1)
  iosVersionId = _messages.StringField(2)
  locale = _messages.StringField(3)
  orientation = _messages.StringField(4)


class IosDeviceCatalog(_messages.Message):
  r"""The currently supported iOS devices.

  Fields:
    models: The set of supported iOS device models.
    runtimeConfiguration: The set of supported runtime configurations.
    versions: The set of supported iOS software versions.
    xcodeVersions: The set of supported Xcode versions.
  """

  models = _messages.MessageField('IosModel', 1, repeated=True)
  runtimeConfiguration = _messages.MessageField('IosRuntimeConfiguration', 2)
  versions = _messages.MessageField('IosVersion', 3, repeated=True)
  xcodeVersions = _messages.MessageField('XcodeVersion', 4, repeated=True)


class IosDeviceFile(_messages.Message):
  r"""A file or directory to install on the device before the test starts.

  Fields:
    bundleId: The bundle id of the app where this file lives. iOS apps sandbox
      their own filesystem, so app files must specify which app installed on
      the device.
    content: The source file
    devicePath: Location of the file on the device, inside the app's sandboxed
      filesystem
  """

  bundleId = _messages.StringField(1)
  content = _messages.MessageField('FileReference', 2)
  devicePath = _messages.StringField(3)


class IosDeviceList(_messages.Message):
  r"""A list of iOS device configurations in which the test is to be executed.

  Fields:
    iosDevices: Required. A list of iOS devices.
  """

  iosDevices = _messages.MessageField('IosDevice', 1, repeated=True)


class IosModel(_messages.Message):
  r"""A description of an iOS device tests may be run on.

  Enums:
    FormFactorValueValuesEnum: Whether this device is a phone, tablet,
      wearable, etc.

  Fields:
    deviceCapabilities: Device capabilities. Copied from https://developer.app
      le.com/library/archive/documentation/DeviceInformation/Reference/iOSDevi
      ceCompatibility/DeviceCompatibilityMatrix/DeviceCompatibilityMatrix.html
    formFactor: Whether this device is a phone, tablet, wearable, etc.
    id: The unique opaque id for this model. Use this for invoking the
      TestExecutionService.
    name: The human-readable name for this device model. Examples: "iPhone
      4s", "iPad Mini 2".
    screenDensity: Screen density in DPI.
    screenX: Screen size in the horizontal (X) dimension measured in pixels.
    screenY: Screen size in the vertical (Y) dimension measured in pixels.
    supportedVersionIds: The set of iOS major software versions this device
      supports.
    tags: Tags for this dimension. Examples: "default", "preview",
      "deprecated".
  """

  class FormFactorValueValuesEnum(_messages.Enum):
    r"""Whether this device is a phone, tablet, wearable, etc.

    Values:
      DEVICE_FORM_FACTOR_UNSPECIFIED: Do not use. For proto versioning only.
      PHONE: This device has the shape of a phone.
      TABLET: This device has the shape of a tablet.
      WEARABLE: This device has the shape of a watch or other wearable.
    """
    DEVICE_FORM_FACTOR_UNSPECIFIED = 0
    PHONE = 1
    TABLET = 2
    WEARABLE = 3

  deviceCapabilities = _messages.StringField(1, repeated=True)
  formFactor = _messages.EnumField('FormFactorValueValuesEnum', 2)
  id = _messages.StringField(3)
  name = _messages.StringField(4)
  screenDensity = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  screenX = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  screenY = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  supportedVersionIds = _messages.StringField(8, repeated=True)
  tags = _messages.StringField(9, repeated=True)


class IosRuntimeConfiguration(_messages.Message):
  r"""iOS configuration that can be selected at the time a test is run.

  Fields:
    locales: The set of available locales.
    orientations: The set of available orientations.
  """

  locales = _messages.MessageField('Locale', 1, repeated=True)
  orientations = _messages.MessageField('Orientation', 2, repeated=True)


class IosTestLoop(_messages.Message):
  r"""A test of an iOS application that implements one or more game loop
  scenarios. This test type accepts an archived application (.ipa file) and a
  list of integer scenarios that will be executed on the app sequentially.

  Fields:
    appBundleId: Output only. The bundle id for the application under test.
    appIpa: Required. The .ipa of the application to test.
    scenarios: The list of scenarios that should be run during the test.
      Defaults to the single scenario 0 if unspecified.
  """

  appBundleId = _messages.StringField(1)
  appIpa = _messages.MessageField('FileReference', 2)
  scenarios = _messages.IntegerField(3, repeated=True, variant=_messages.Variant.INT32)


class IosTestSetup(_messages.Message):
  r"""A description of how to set up an iOS device prior to running the test.

  Fields:
    additionalIpas: iOS apps to install in addition to those being directly
      tested.
    networkProfile: The network traffic profile used for running the test.
      Available network profiles can be queried by using the
      NETWORK_CONFIGURATION environment type when calling
      TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
    pullDirectories: List of directories on the device to upload to Cloud
      Storage at the end of the test. Directories should either be in a shared
      directory (such as /private/var/mobile/Media) or within an accessible
      directory inside the app's filesystem (such as /Documents) by specifying
      the bundle ID.
    pushFiles: List of files to push to the device before starting the test.
  """

  additionalIpas = _messages.MessageField('FileReference', 1, repeated=True)
  networkProfile = _messages.StringField(2)
  pullDirectories = _messages.MessageField('IosDeviceFile', 3, repeated=True)
  pushFiles = _messages.MessageField('IosDeviceFile', 4, repeated=True)


class IosVersion(_messages.Message):
  r"""An iOS version.

  Fields:
    id: An opaque id for this iOS version. Use this id to invoke the
      TestExecutionService.
    majorVersion: An integer representing the major iOS version. Examples:
      "8", "9".
    minorVersion: An integer representing the minor iOS version. Examples:
      "1", "2".
    supportedXcodeVersionIds: The available Xcode versions for this version.
    tags: Tags for this dimension. Examples: "default", "preview",
      "deprecated".
  """

  id = _messages.StringField(1)
  majorVersion = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minorVersion = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  supportedXcodeVersionIds = _messages.StringField(4, repeated=True)
  tags = _messages.StringField(5, repeated=True)


class IosXcTest(_messages.Message):
  r"""A test of an iOS application that uses the XCTest framework. Xcode
  supports the option to "build for testing", which generates an .xctestrun
  file that contains a test specification (arguments, test methods, etc). This
  test type accepts a zip file containing the .xctestrun file and the
  corresponding contents of the Build/Products directory that contains all the
  binaries needed to run the tests.

  Fields:
    appBundleId: Output only. The bundle id for the application under test.
    testSpecialEntitlements: The option to test special app entitlements.
      Setting this would re-sign the app having special entitlements with an
      explicit application-identifier. Currently supports testing aps-
      environment entitlement.
    testsZip: Required. The .zip containing the .xctestrun file and the
      contents of the DerivedData/Build/Products directory. The .xctestrun
      file in this zip is ignored if the xctestrun field is specified.
    xcodeVersion: The Xcode version that should be used for the test. Use the
      TestEnvironmentDiscoveryService to get supported options. Defaults to
      the latest Xcode version Firebase Test Lab supports.
    xctestrun: An .xctestrun file that will override the .xctestrun file in
      the tests zip. Because the .xctestrun file contains environment
      variables along with test methods to run and/or ignore, this can be
      useful for sharding tests. Default is taken from the tests zip.
  """

  appBundleId = _messages.StringField(1)
  testSpecialEntitlements = _messages.BooleanField(2)
  testsZip = _messages.MessageField('FileReference', 3)
  xcodeVersion = _messages.StringField(4)
  xctestrun = _messages.MessageField('FileReference', 5)


class LauncherActivityIntent(_messages.Message):
  r"""Specifies an intent that starts the main launcher activity."""


class Locale(_messages.Message):
  r"""A location/region designation for language.

  Fields:
    id: The id for this locale. Example: "en_US".
    name: A human-friendly name for this language/locale. Example: "English".
    region: A human-friendly string representing the region for this locale.
      Example: "United States". Not present for every locale.
    tags: Tags for this dimension. Example: "default".
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  region = _messages.StringField(3)
  tags = _messages.StringField(4, repeated=True)


class ManualSharding(_messages.Message):
  r"""Shards test cases into the specified groups of packages, classes, and/or
  methods. With manual sharding enabled, specifying test targets via
  environment_variables or in InstrumentationTest is invalid.

  Fields:
    testTargetsForShard: Required. Group of packages, classes, and/or test
      methods to be run for each shard. When any physical devices are
      selected, the number of test_targets_for_shard must be >= 1 and <= 50.
      When no physical devices are selected, the number must be >= 1 and <=
      500.
  """

  testTargetsForShard = _messages.MessageField('TestTargetsForShard', 1, repeated=True)


class NetworkConfiguration(_messages.Message):
  r"""A NetworkConfiguration object.

  Fields:
    downRule: The emulation rule applying to the download traffic.
    id: The unique opaque id for this network traffic configuration.
    upRule: The emulation rule applying to the upload traffic.
  """

  downRule = _messages.MessageField('TrafficRule', 1)
  id = _messages.StringField(2)
  upRule = _messages.MessageField('TrafficRule', 3)


class NetworkConfigurationCatalog(_messages.Message):
  r"""A NetworkConfigurationCatalog object.

  Fields:
    configurations: A NetworkConfiguration attribute.
  """

  configurations = _messages.MessageField('NetworkConfiguration', 1, repeated=True)


class ObbFile(_messages.Message):
  r"""An opaque binary blob file to install on the device before the test
  starts.

  Fields:
    obb: Required. Opaque Binary Blob (OBB) file(s) to install on the device.
    obbFileName: Required. OBB file name which must conform to the format as
      specified by Android e.g. [main|patch].0300110.com.example.android.obb
      which will be installed into \/Android/obb/\/ on the device.
  """

  obb = _messages.MessageField('FileReference', 1)
  obbFileName = _messages.StringField(2)


class Orientation(_messages.Message):
  r"""Screen orientation of the device.

  Fields:
    id: The id for this orientation. Example: "portrait".
    name: A human-friendly name for this orientation. Example: "portrait".
    tags: Tags for this dimension. Example: "default".
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  tags = _messages.StringField(3, repeated=True)


class ProvidedSoftwareCatalog(_messages.Message):
  r"""The currently provided software environment on the devices under test.

  Fields:
    androidxOrchestratorVersion: A string representing the current version of
      AndroidX Test Orchestrator that is used in the environment. The package
      is available at
      https://maven.google.com/web/index.html#androidx.test:orchestrator.
    orchestratorVersion: Deprecated: Use AndroidX Test Orchestrator going
      forward. A string representing the current version of Android Test
      Orchestrator that is used in the environment. The package is available
      at https://maven.google.com/web/index.html#com.android.support.test:orch
      estrator.
  """

  androidxOrchestratorVersion = _messages.StringField(1)
  orchestratorVersion = _messages.StringField(2)


class RegularFile(_messages.Message):
  r"""A file or directory to install on the device before the test starts.

  Fields:
    content: Required. The source file.
    devicePath: Required. Where to put the content on the device. Must be an
      absolute, allowlisted path. If the file exists, it will be replaced. The
      following device-side directories and any of their subdirectories are
      allowlisted: ${EXTERNAL_STORAGE}, /sdcard, or /storage
      ${ANDROID_DATA}/local/tmp, or /data/local/tmp Specifying a path outside
      of these directory trees is invalid. The paths /sdcard and /data will be
      made available and treated as implicit path substitutions. E.g. if
      /sdcard on a particular device does not map to external storage, the
      system will replace it with the external storage path prefix for that
      device and copy the file there. It is strongly advised to use the
      Environment API in app and test code to access files on the device in a
      portable way.
  """

  content = _messages.MessageField('FileReference', 1)
  devicePath = _messages.StringField(2)


class ResultStorage(_messages.Message):
  r"""Locations where the results of running the test are stored.

  Fields:
    googleCloudStorage: Required.
    resultsUrl: Output only. URL to the results in the Firebase Web Console.
    toolResultsExecution: Output only. The tool results execution that results
      are written to.
    toolResultsHistory: The tool results history that contains the tool
      results execution that results are written to. If not provided, the
      service will choose an appropriate value.
  """

  googleCloudStorage = _messages.MessageField('GoogleCloudStorage', 1)
  resultsUrl = _messages.StringField(2)
  toolResultsExecution = _messages.MessageField('ToolResultsExecution', 3)
  toolResultsHistory = _messages.MessageField('ToolResultsHistory', 4)


class RoboDirective(_messages.Message):
  r"""Directs Robo to interact with a specific UI element if it is encountered
  during the crawl. Currently, Robo can perform text entry or element click.

  Enums:
    ActionTypeValueValuesEnum: Required. The type of action that Robo should
      perform on the specified element.

  Fields:
    actionType: Required. The type of action that Robo should perform on the
      specified element.
    inputText: The text that Robo is directed to set. If left empty, the
      directive will be treated as a CLICK on the element matching the
      resource_name.
    resourceName: Required. The android resource name of the target UI
      element. For example, in Java: R.string.foo in xml: @string/foo Only the
      "foo" part is needed. Reference doc:
      https://developer.android.com/guide/topics/resources/accessing-
      resources.html
  """

  class ActionTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of action that Robo should perform on the specified
    element.

    Values:
      ACTION_TYPE_UNSPECIFIED: DO NOT USE. For proto versioning only.
      SINGLE_CLICK: Direct Robo to click on the specified element. No-op if
        specified element is not clickable.
      ENTER_TEXT: Direct Robo to enter text on the specified element. No-op if
        specified element is not enabled or does not allow text entry.
      IGNORE: Direct Robo to ignore interactions with a specific element.
    """
    ACTION_TYPE_UNSPECIFIED = 0
    SINGLE_CLICK = 1
    ENTER_TEXT = 2
    IGNORE = 3

  actionType = _messages.EnumField('ActionTypeValueValuesEnum', 1)
  inputText = _messages.StringField(2)
  resourceName = _messages.StringField(3)


class RoboStartingIntent(_messages.Message):
  r"""Message for specifying the start activities to crawl.

  Fields:
    launcherActivity: An intent that starts the main launcher activity.
    startActivity: An intent that starts an activity with specific details.
    timeout: Timeout in seconds for each intent.
  """

  launcherActivity = _messages.MessageField('LauncherActivityIntent', 1)
  startActivity = _messages.MessageField('StartActivityIntent', 2)
  timeout = _messages.StringField(3)


class Shard(_messages.Message):
  r"""Output only. Details about the shard.

  Fields:
    numShards: Output only. The total number of shards.
    shardIndex: Output only. The index of the shard among all the shards.
    testTargetsForShard: Output only. Test targets for each shard.
  """

  numShards = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  shardIndex = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  testTargetsForShard = _messages.MessageField('TestTargetsForShard', 3)


class ShardingOption(_messages.Message):
  r"""Options for enabling sharding.

  Fields:
    manualSharding: Shards test cases into the specified groups of packages,
      classes, and/or methods.
    uniformSharding: Uniformly shards test cases given a total number of
      shards.
  """

  manualSharding = _messages.MessageField('ManualSharding', 1)
  uniformSharding = _messages.MessageField('UniformSharding', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StartActivityIntent(_messages.Message):
  r"""A starting intent specified by an action, uri, and categories.

  Fields:
    action: Action name. Required for START_ACTIVITY.
    categories: Intent categories to set on the intent.
    uri: URI for the action.
  """

  action = _messages.StringField(1)
  categories = _messages.StringField(2, repeated=True)
  uri = _messages.StringField(3)


class SystraceSetup(_messages.Message):
  r"""A SystraceSetup object.

  Fields:
    durationSeconds: Systrace duration in seconds. Should be between 1 and 30
      seconds. 0 disables systrace.
  """

  durationSeconds = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class TestDetails(_messages.Message):
  r"""Additional details about the progress of the running test.

  Fields:
    errorMessage: Output only. If the TestState is ERROR, then this string
      will contain human-readable details about the error.
    progressMessages: Output only. Human-readable, detailed descriptions of
      the test's progress. For example: "Provisioning a device", "Starting
      Test". During the course of execution new data may be appended to the
      end of progress_messages.
  """

  errorMessage = _messages.StringField(1)
  progressMessages = _messages.StringField(2, repeated=True)


class TestEnvironmentCatalog(_messages.Message):
  r"""A description of a test environment.

  Fields:
    androidDeviceCatalog: Supported Android devices.
    deviceIpBlockCatalog: The IP blocks used by devices in the test
      environment.
    iosDeviceCatalog: Supported iOS devices.
    networkConfigurationCatalog: Supported network configurations.
    softwareCatalog: The software test environment provided by
      TestExecutionService.
  """

  androidDeviceCatalog = _messages.MessageField('AndroidDeviceCatalog', 1)
  deviceIpBlockCatalog = _messages.MessageField('DeviceIpBlockCatalog', 2)
  iosDeviceCatalog = _messages.MessageField('IosDeviceCatalog', 3)
  networkConfigurationCatalog = _messages.MessageField('NetworkConfigurationCatalog', 4)
  softwareCatalog = _messages.MessageField('ProvidedSoftwareCatalog', 5)


class TestExecution(_messages.Message):
  r"""A single test executed in a single environment.

  Enums:
    StateValueValuesEnum: Output only. Indicates the current progress of the
      test execution (e.g., FINISHED).

  Fields:
    environment: Output only. How the host machine(s) are configured.
    id: Output only. Unique id set by the service.
    matrixId: Output only. Id of the containing TestMatrix.
    projectId: Output only. The cloud project that owns the test execution.
    shard: Output only. Details about the shard.
    state: Output only. Indicates the current progress of the test execution
      (e.g., FINISHED).
    testDetails: Output only. Additional details about the running test.
    testSpecification: Output only. How to run the test.
    timestamp: Output only. The time this test execution was initially
      created.
    toolResultsStep: Output only. Where the results for this execution are
      written.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Indicates the current progress of the test execution
    (e.g., FINISHED).

    Values:
      TEST_STATE_UNSPECIFIED: Do not use. For proto versioning only.
      VALIDATING: The execution or matrix is being validated.
      PENDING: The execution or matrix is waiting for resources to become
        available.
      RUNNING: The execution is currently being processed. Can only be set on
        an execution.
      FINISHED: The execution or matrix has terminated normally. On a matrix
        this means that the matrix level processing completed normally, but
        individual executions may be in an ERROR state.
      ERROR: The execution or matrix has stopped because it encountered an
        infrastructure failure.
      UNSUPPORTED_ENVIRONMENT: The execution was not run because it
        corresponds to a unsupported environment. Can only be set on an
        execution.
      INCOMPATIBLE_ENVIRONMENT: The execution was not run because the provided
        inputs are incompatible with the requested environment. Example:
        requested AndroidVersion is lower than APK's minSdkVersion Can only be
        set on an execution.
      INCOMPATIBLE_ARCHITECTURE: The execution was not run because the
        provided inputs are incompatible with the requested architecture.
        Example: requested device does not support running the native code in
        the supplied APK Can only be set on an execution.
      CANCELLED: The user cancelled the execution. Can only be set on an
        execution.
      INVALID: The execution or matrix was not run because the provided inputs
        are not valid. Examples: input file is not of the expected type, is
        malformed/corrupt, or was flagged as malware
    """
    TEST_STATE_UNSPECIFIED = 0
    VALIDATING = 1
    PENDING = 2
    RUNNING = 3
    FINISHED = 4
    ERROR = 5
    UNSUPPORTED_ENVIRONMENT = 6
    INCOMPATIBLE_ENVIRONMENT = 7
    INCOMPATIBLE_ARCHITECTURE = 8
    CANCELLED = 9
    INVALID = 10

  environment = _messages.MessageField('Environment', 1)
  id = _messages.StringField(2)
  matrixId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  shard = _messages.MessageField('Shard', 5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  testDetails = _messages.MessageField('TestDetails', 7)
  testSpecification = _messages.MessageField('TestSpecification', 8)
  timestamp = _messages.StringField(9)
  toolResultsStep = _messages.MessageField('ToolResultsStep', 10)


class TestMatrix(_messages.Message):
  r"""TestMatrix captures all details about a test. It contains the
  environment configuration, test specification, test executions and overall
  state and outcome.

  Enums:
    InvalidMatrixDetailsValueValuesEnum: Output only. Describes why the matrix
      is considered invalid. Only useful for matrices in the INVALID state.
    OutcomeSummaryValueValuesEnum: Output Only. The overall outcome of the
      test. Only set when the test matrix state is FINISHED.
    StateValueValuesEnum: Output only. Indicates the current progress of the
      test matrix.

  Fields:
    clientInfo: Information about the client which invoked the test.
    environmentMatrix: Required. The devices the tests are being executed on.
    failFast: If true, only a single attempt at most will be made to run each
      execution/shard in the matrix. Flaky test attempts are not affected.
      Normally, 2 or more attempts are made if a potential infrastructure
      issue is detected. This feature is for latency sensitive workloads. The
      incidence of execution failures may be significantly greater for fail-
      fast matrices and support is more limited because of that expectation.
    flakyTestAttempts: The number of times a TestExecution should be re-
      attempted if one or more of its test cases fail for any reason. The
      maximum number of reruns allowed is 10. Default is 0, which implies no
      reruns.
    invalidMatrixDetails: Output only. Describes why the matrix is considered
      invalid. Only useful for matrices in the INVALID state.
    outcomeSummary: Output Only. The overall outcome of the test. Only set
      when the test matrix state is FINISHED.
    projectId: The cloud project that owns the test matrix.
    resultStorage: Required. Where the results for the matrix are written.
    state: Output only. Indicates the current progress of the test matrix.
    testExecutions: Output only. The list of test executions that the service
      creates for this matrix.
    testMatrixId: Output only. Unique id set by the service.
    testSpecification: Required. How to run the test.
    timestamp: Output only. The time this test matrix was initially created.
  """

  class InvalidMatrixDetailsValueValuesEnum(_messages.Enum):
    r"""Output only. Describes why the matrix is considered invalid. Only
    useful for matrices in the INVALID state.

    Values:
      INVALID_MATRIX_DETAILS_UNSPECIFIED: Do not use. For proto versioning
        only.
      DETAILS_UNAVAILABLE: The matrix is INVALID, but there are no further
        details available.
      MALFORMED_APK: The input app APK could not be parsed.
      MALFORMED_TEST_APK: The input test APK could not be parsed.
      NO_MANIFEST: The AndroidManifest.xml could not be found.
      NO_PACKAGE_NAME: The APK manifest does not declare a package name.
      INVALID_PACKAGE_NAME: The APK application ID (aka package name) is
        invalid. See also
        https://developer.android.com/studio/build/application-id
      TEST_SAME_AS_APP: The test package and app package are the same.
      NO_INSTRUMENTATION: The test apk does not declare an instrumentation.
      NO_SIGNATURE: The input app apk does not have a signature.
      INSTRUMENTATION_ORCHESTRATOR_INCOMPATIBLE: The test runner class
        specified by user or in the test APK's manifest file is not compatible
        with Android Test Orchestrator. Orchestrator is only compatible with
        AndroidJUnitRunner version 1.1 or higher. Orchestrator can be disabled
        by using DO_NOT_USE_ORCHESTRATOR OrchestratorOption.
      NO_TEST_RUNNER_CLASS: The test APK does not contain the test runner
        class specified by user or in the manifest file. This can be caused by
        either of the following reasons: - the user provided a runner class
        name that's incorrect, or - the test runner isn't built into the test
        APK (might be in the app APK instead).
      NO_LAUNCHER_ACTIVITY: A main launcher activity could not be found.
      FORBIDDEN_PERMISSIONS: The app declares one or more permissions that are
        not allowed.
      INVALID_ROBO_DIRECTIVES: There is a conflict in the provided
        robo_directives.
      INVALID_RESOURCE_NAME: There is at least one invalid resource name in
        the provided robo directives
      INVALID_DIRECTIVE_ACTION: Invalid definition of action in the robo
        directives (e.g. a click or ignore action includes an input text
        field)
      TEST_LOOP_INTENT_FILTER_NOT_FOUND: There is no test loop intent filter,
        or the one that is given is not formatted correctly.
      SCENARIO_LABEL_NOT_DECLARED: The request contains a scenario label that
        was not declared in the manifest.
      SCENARIO_LABEL_MALFORMED: There was an error when parsing a label's
        value.
      SCENARIO_NOT_DECLARED: The request contains a scenario number that was
        not declared in the manifest.
      DEVICE_ADMIN_RECEIVER: Device administrator applications are not
        allowed.
      MALFORMED_XC_TEST_ZIP: The zipped XCTest was malformed. The zip did not
        contain a single .xctestrun file and the contents of the
        DerivedData/Build/Products directory.
      BUILT_FOR_IOS_SIMULATOR: The zipped XCTest was built for the iOS
        simulator rather than for a physical device.
      NO_TESTS_IN_XC_TEST_ZIP: The .xctestrun file did not specify any test
        targets.
      USE_DESTINATION_ARTIFACTS: One or more of the test targets defined in
        the .xctestrun file specifies "UseDestinationArtifacts", which is
        disallowed.
      TEST_NOT_APP_HOSTED: XC tests which run on physical devices must have
        "IsAppHostedTestBundle" == "true" in the xctestrun file.
      PLIST_CANNOT_BE_PARSED: An Info.plist file in the XCTest zip could not
        be parsed.
      TEST_ONLY_APK: The APK is marked as "testOnly". Deprecated and not
        currently used.
      MALFORMED_IPA: The input IPA could not be parsed.
      MISSING_URL_SCHEME: The application doesn't register the game loop URL
        scheme.
      MALFORMED_APP_BUNDLE: The iOS application bundle (.app) couldn't be
        processed.
      NO_CODE_APK: APK contains no code. See also
        https://developer.android.com/guide/topics/manifest/application-
        element.html#code
      INVALID_INPUT_APK: Either the provided input APK path was malformed, the
        APK file does not exist, or the user does not have permission to
        access the APK file.
      INVALID_APK_PREVIEW_SDK: APK is built for a preview SDK which is
        unsupported
    """
    INVALID_MATRIX_DETAILS_UNSPECIFIED = 0
    DETAILS_UNAVAILABLE = 1
    MALFORMED_APK = 2
    MALFORMED_TEST_APK = 3
    NO_MANIFEST = 4
    NO_PACKAGE_NAME = 5
    INVALID_PACKAGE_NAME = 6
    TEST_SAME_AS_APP = 7
    NO_INSTRUMENTATION = 8
    NO_SIGNATURE = 9
    INSTRUMENTATION_ORCHESTRATOR_INCOMPATIBLE = 10
    NO_TEST_RUNNER_CLASS = 11
    NO_LAUNCHER_ACTIVITY = 12
    FORBIDDEN_PERMISSIONS = 13
    INVALID_ROBO_DIRECTIVES = 14
    INVALID_RESOURCE_NAME = 15
    INVALID_DIRECTIVE_ACTION = 16
    TEST_LOOP_INTENT_FILTER_NOT_FOUND = 17
    SCENARIO_LABEL_NOT_DECLARED = 18
    SCENARIO_LABEL_MALFORMED = 19
    SCENARIO_NOT_DECLARED = 20
    DEVICE_ADMIN_RECEIVER = 21
    MALFORMED_XC_TEST_ZIP = 22
    BUILT_FOR_IOS_SIMULATOR = 23
    NO_TESTS_IN_XC_TEST_ZIP = 24
    USE_DESTINATION_ARTIFACTS = 25
    TEST_NOT_APP_HOSTED = 26
    PLIST_CANNOT_BE_PARSED = 27
    TEST_ONLY_APK = 28
    MALFORMED_IPA = 29
    MISSING_URL_SCHEME = 30
    MALFORMED_APP_BUNDLE = 31
    NO_CODE_APK = 32
    INVALID_INPUT_APK = 33
    INVALID_APK_PREVIEW_SDK = 34

  class OutcomeSummaryValueValuesEnum(_messages.Enum):
    r"""Output Only. The overall outcome of the test. Only set when the test
    matrix state is FINISHED.

    Values:
      OUTCOME_SUMMARY_UNSPECIFIED: Do not use. For proto versioning only.
      SUCCESS: The test matrix run was successful, for instance: - All the
        test cases passed. - Robo did not detect a crash of the application
        under test.
      FAILURE: A run failed, for instance: - One or more test case failed. - A
        test timed out. - The application under test crashed.
      INCONCLUSIVE: Something unexpected happened. The run should still be
        considered unsuccessful but this is likely a transient problem and re-
        running the test might be successful.
      SKIPPED: All tests were skipped, for instance: - All device
        configurations were incompatible.
    """
    OUTCOME_SUMMARY_UNSPECIFIED = 0
    SUCCESS = 1
    FAILURE = 2
    INCONCLUSIVE = 3
    SKIPPED = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Indicates the current progress of the test matrix.

    Values:
      TEST_STATE_UNSPECIFIED: Do not use. For proto versioning only.
      VALIDATING: The execution or matrix is being validated.
      PENDING: The execution or matrix is waiting for resources to become
        available.
      RUNNING: The execution is currently being processed. Can only be set on
        an execution.
      FINISHED: The execution or matrix has terminated normally. On a matrix
        this means that the matrix level processing completed normally, but
        individual executions may be in an ERROR state.
      ERROR: The execution or matrix has stopped because it encountered an
        infrastructure failure.
      UNSUPPORTED_ENVIRONMENT: The execution was not run because it
        corresponds to a unsupported environment. Can only be set on an
        execution.
      INCOMPATIBLE_ENVIRONMENT: The execution was not run because the provided
        inputs are incompatible with the requested environment. Example:
        requested AndroidVersion is lower than APK's minSdkVersion Can only be
        set on an execution.
      INCOMPATIBLE_ARCHITECTURE: The execution was not run because the
        provided inputs are incompatible with the requested architecture.
        Example: requested device does not support running the native code in
        the supplied APK Can only be set on an execution.
      CANCELLED: The user cancelled the execution. Can only be set on an
        execution.
      INVALID: The execution or matrix was not run because the provided inputs
        are not valid. Examples: input file is not of the expected type, is
        malformed/corrupt, or was flagged as malware
    """
    TEST_STATE_UNSPECIFIED = 0
    VALIDATING = 1
    PENDING = 2
    RUNNING = 3
    FINISHED = 4
    ERROR = 5
    UNSUPPORTED_ENVIRONMENT = 6
    INCOMPATIBLE_ENVIRONMENT = 7
    INCOMPATIBLE_ARCHITECTURE = 8
    CANCELLED = 9
    INVALID = 10

  clientInfo = _messages.MessageField('ClientInfo', 1)
  environmentMatrix = _messages.MessageField('EnvironmentMatrix', 2)
  failFast = _messages.BooleanField(3)
  flakyTestAttempts = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  invalidMatrixDetails = _messages.EnumField('InvalidMatrixDetailsValueValuesEnum', 5)
  outcomeSummary = _messages.EnumField('OutcomeSummaryValueValuesEnum', 6)
  projectId = _messages.StringField(7)
  resultStorage = _messages.MessageField('ResultStorage', 8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  testExecutions = _messages.MessageField('TestExecution', 10, repeated=True)
  testMatrixId = _messages.StringField(11)
  testSpecification = _messages.MessageField('TestSpecification', 12)
  timestamp = _messages.StringField(13)


class TestSetup(_messages.Message):
  r"""A description of how to set up the Android device prior to running the
  test.

  Fields:
    account: The device will be logged in on this account for the duration of
      the test.
    additionalApks: APKs to install in addition to those being directly
      tested. Currently capped at 100.
    directoriesToPull: List of directories on the device to upload to GCS at
      the end of the test; they must be absolute paths under /sdcard, /storage
      or /data/local/tmp. Path names are restricted to characters a-z A-Z 0-9
      _ - . + and / Note: The paths /sdcard and /data will be made available
      and treated as implicit path substitutions. E.g. if /sdcard on a
      particular device does not map to external storage, the system will
      replace it with the external storage path prefix for that device.
    dontAutograntPermissions: Whether to prevent all runtime permissions to be
      granted at app install
    environmentVariables: Environment variables to set for the test (only
      applicable for instrumentation tests).
    filesToPush: List of files to push to the device before starting the test.
    networkProfile: The network traffic profile used for running the test.
      Available network profiles can be queried by using the
      NETWORK_CONFIGURATION environment type when calling
      TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
    systrace: Deprecated: Systrace uses Python 2 which has been sunset
      2020-01-01. Support of Systrace may stop at any time, at which point no
      Systrace file will be provided in the results. Systrace configuration
      for the run. If set a systrace will be taken, starting on test start and
      lasting for the configured duration. The systrace file thus obtained is
      put in the results bucket together with the other artifacts from the
      run.
  """

  account = _messages.MessageField('Account', 1)
  additionalApks = _messages.MessageField('Apk', 2, repeated=True)
  directoriesToPull = _messages.StringField(3, repeated=True)
  dontAutograntPermissions = _messages.BooleanField(4)
  environmentVariables = _messages.MessageField('EnvironmentVariable', 5, repeated=True)
  filesToPush = _messages.MessageField('DeviceFile', 6, repeated=True)
  networkProfile = _messages.StringField(7)
  systrace = _messages.MessageField('SystraceSetup', 8)


class TestSpecification(_messages.Message):
  r"""A description of how to run the test.

  Fields:
    androidInstrumentationTest: An Android instrumentation test.
    androidRoboTest: An Android robo test.
    androidTestLoop: An Android Application with a Test Loop.
    disablePerformanceMetrics: Disables performance metrics recording. May
      reduce test latency.
    disableVideoRecording: Disables video recording. May reduce test latency.
    iosTestLoop: An iOS application with a test loop.
    iosTestSetup: Test setup requirements for iOS.
    iosXcTest: An iOS XCTest, via an .xctestrun file.
    testSetup: Test setup requirements for Android e.g. files to install,
      bootstrap scripts.
    testTimeout: Max time a test execution is allowed to run before it is
      automatically cancelled. The default value is 5 min.
  """

  androidInstrumentationTest = _messages.MessageField('AndroidInstrumentationTest', 1)
  androidRoboTest = _messages.MessageField('AndroidRoboTest', 2)
  androidTestLoop = _messages.MessageField('AndroidTestLoop', 3)
  disablePerformanceMetrics = _messages.BooleanField(4)
  disableVideoRecording = _messages.BooleanField(5)
  iosTestLoop = _messages.MessageField('IosTestLoop', 6)
  iosTestSetup = _messages.MessageField('IosTestSetup', 7)
  iosXcTest = _messages.MessageField('IosXcTest', 8)
  testSetup = _messages.MessageField('TestSetup', 9)
  testTimeout = _messages.StringField(10)


class TestTargetsForShard(_messages.Message):
  r"""Test targets for a shard.

  Fields:
    testTargets: Group of packages, classes, and/or test methods to be run for
      each shard. The targets need to be specified in AndroidJUnitRunner
      argument format. For example, "package com.my.packages" "class
      com.my.package.MyClass". The number of shard_test_targets must be
      greater than 0.
  """

  testTargets = _messages.StringField(1, repeated=True)


class TestingProjectsTestMatricesCancelRequest(_messages.Message):
  r"""A TestingProjectsTestMatricesCancelRequest object.

  Fields:
    projectId: Cloud project that owns the test.
    testMatrixId: Test matrix that will be canceled.
  """

  projectId = _messages.StringField(1, required=True)
  testMatrixId = _messages.StringField(2, required=True)


class TestingProjectsTestMatricesCreateRequest(_messages.Message):
  r"""A TestingProjectsTestMatricesCreateRequest object.

  Fields:
    projectId: The GCE project under which this job will run.
    requestId: A string id used to detect duplicated requests. Ids are
      automatically scoped to a project, so users should ensure the ID is
      unique per-project. A UUID is recommended. Optional, but strongly
      recommended.
    testMatrix: A TestMatrix resource to be passed as the request body.
  """

  projectId = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  testMatrix = _messages.MessageField('TestMatrix', 3)


class TestingProjectsTestMatricesGetRequest(_messages.Message):
  r"""A TestingProjectsTestMatricesGetRequest object.

  Fields:
    projectId: Cloud project that owns the test matrix.
    testMatrixId: Unique test matrix id which was assigned by the service.
  """

  projectId = _messages.StringField(1, required=True)
  testMatrixId = _messages.StringField(2, required=True)


class TestingTestEnvironmentCatalogGetRequest(_messages.Message):
  r"""A TestingTestEnvironmentCatalogGetRequest object.

  Enums:
    EnvironmentTypeValueValuesEnum: Required. The type of environment that
      should be listed.

  Fields:
    environmentType: Required. The type of environment that should be listed.
    projectId: For authorization, the cloud project requesting the
      TestEnvironmentCatalog.
  """

  class EnvironmentTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of environment that should be listed.

    Values:
      ENVIRONMENT_TYPE_UNSPECIFIED: Do not use. For proto versioning only.
      ANDROID: A device running a version of the Android OS.
      IOS: A device running a version of iOS.
      NETWORK_CONFIGURATION: A network configuration to use when running a
        test.
      PROVIDED_SOFTWARE: The software environment provided by
        TestExecutionService.
      DEVICE_IP_BLOCKS: The IP blocks used by devices in the test environment.
    """
    ENVIRONMENT_TYPE_UNSPECIFIED = 0
    ANDROID = 1
    IOS = 2
    NETWORK_CONFIGURATION = 3
    PROVIDED_SOFTWARE = 4
    DEVICE_IP_BLOCKS = 5

  environmentType = _messages.EnumField('EnvironmentTypeValueValuesEnum', 1, required=True)
  projectId = _messages.StringField(2)


class ToolResultsExecution(_messages.Message):
  r"""Represents a tool results execution resource. This has the results of a
  TestMatrix.

  Fields:
    executionId: Output only. A tool results execution ID.
    historyId: Output only. A tool results history ID.
    projectId: Output only. The cloud project that owns the tool results
      execution.
  """

  executionId = _messages.StringField(1)
  historyId = _messages.StringField(2)
  projectId = _messages.StringField(3)


class ToolResultsHistory(_messages.Message):
  r"""Represents a tool results history resource.

  Fields:
    historyId: Required. A tool results history ID.
    projectId: Required. The cloud project that owns the tool results history.
  """

  historyId = _messages.StringField(1)
  projectId = _messages.StringField(2)


class ToolResultsStep(_messages.Message):
  r"""Represents a tool results step resource. This has the results of a
  TestExecution.

  Fields:
    executionId: Output only. A tool results execution ID.
    historyId: Output only. A tool results history ID.
    projectId: Output only. The cloud project that owns the tool results step.
    stepId: Output only. A tool results step ID.
  """

  executionId = _messages.StringField(1)
  historyId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  stepId = _messages.StringField(4)


class TrafficRule(_messages.Message):
  r"""Network emulation parameters.

  Fields:
    bandwidth: Bandwidth in kbits/second.
    burst: Burst size in kbits.
    delay: Packet delay, must be >= 0.
    packetDuplicationRatio: Packet duplication ratio (0.0 - 1.0).
    packetLossRatio: Packet loss ratio (0.0 - 1.0).
  """

  bandwidth = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  burst = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  delay = _messages.StringField(3)
  packetDuplicationRatio = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  packetLossRatio = _messages.FloatField(5, variant=_messages.Variant.FLOAT)


class UniformSharding(_messages.Message):
  r"""Uniformly shards test cases given a total number of shards. For
  Instrumentation test, it will be translated to "-e numShard" "-e shardIndex"
  AndroidJUnitRunner arguments. Based on the sharding mechanism
  AndroidJUnitRunner uses, there is no guarantee that test cases will be
  distributed uniformly across all shards. With uniform sharding enabled,
  specifying these sharding arguments via environment_variables is invalid.

  Fields:
    numShards: Required. Total number of shards. When any physical devices are
      selected, the number must be >= 1 and <= 50. When no physical devices
      are selected, the number must be >= 1 and <= 500.
  """

  numShards = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class XcodeVersion(_messages.Message):
  r"""An Xcode version that an iOS version is compatible with.

  Fields:
    tags: Tags for this Xcode version. Example: "default".
    version: The id for this version. Example: "9.2".
  """

  tags = _messages.StringField(1, repeated=True)
  version = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
