"""Generated message classes for file version v1.

The Cloud Filestore API is used for creating and managing cloud file servers.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'file'


class Backup(_messages.Message):
  r"""A Cloud Filestore backup.

  Enums:
    SourceInstanceTierValueValuesEnum: Output only. The service tier of the
      source Cloud Filestore instance that this backup is created from.
    StateValueValuesEnum: Output only. The backup state.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    capacityGb: Output only. Capacity of the source file share when the backup
      was created.
    createTime: Output only. The time when the backup was created.
    description: A description of the backup with 2048 characters or less.
      Requests with longer descriptions will be rejected.
    downloadBytes: Output only. Amount of bytes that will be downloaded if the
      backup is restored. This may be different than storage bytes, since
      sequential backups of the same disk will share storage.
    labels: Resource labels to represent user provided metadata.
    name: Output only. The resource name of the backup, in the format
      `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
    satisfiesPzs: Output only. Reserved for future use.
    sourceFileShare: Name of the file share in the source Cloud Filestore
      instance that the backup is created from.
    sourceInstance: The resource name of the source Cloud Filestore instance,
      in the format `projects/{project_number}/locations/{location_id}/instanc
      es/{instance_id}`, used to create this backup.
    sourceInstanceTier: Output only. The service tier of the source Cloud
      Filestore instance that this backup is created from.
    state: Output only. The backup state.
    storageBytes: Output only. The size of the storage used by the backup. As
      backups share storage, this number is expected to change with backup
      creation/deletion.
  """

  class SourceInstanceTierValueValuesEnum(_messages.Enum):
    r"""Output only. The service tier of the source Cloud Filestore instance
    that this backup is created from.

    Values:
      TIER_UNSPECIFIED: Not set.
      STANDARD: STANDARD tier.
      PREMIUM: PREMIUM tier.
      BASIC_HDD: BASIC instances offer a maximum capacity of 63.9 TB.
        BASIC_HDD is an alias for STANDARD Tier, offering economical
        performance backed by HDD.
      BASIC_SSD: BASIC instances offer a maximum capacity of 63.9 TB.
        BASIC_SSD is an alias for PREMIUM Tier, and offers improved
        performance backed by SSD.
      HIGH_SCALE_SSD: HIGH_SCALE instances offer expanded capacity and
        performance scaling capabilities.
      ENTERPRISE: ENTERPRISE instances offer the features and availability
        needed for mission-critical workloads.
    """
    TIER_UNSPECIFIED = 0
    STANDARD = 1
    PREMIUM = 2
    BASIC_HDD = 3
    BASIC_SSD = 4
    HIGH_SCALE_SSD = 5
    ENTERPRISE = 6

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The backup state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: Backup is being created.
      FINALIZING: Backup has been taken and the operation is being finalized.
        At this point, changes to the file share will not be reflected in the
        backup.
      READY: Backup is available for use.
      DELETING: Backup is being deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    FINALIZING = 2
    READY = 3
    DELETING = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  capacityGb = _messages.IntegerField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  downloadBytes = _messages.IntegerField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  satisfiesPzs = _messages.BooleanField(7)
  sourceFileShare = _messages.StringField(8)
  sourceInstance = _messages.StringField(9)
  sourceInstanceTier = _messages.EnumField('SourceInstanceTierValueValuesEnum', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  storageBytes = _messages.IntegerField(12)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class DailyCycle(_messages.Message):
  r"""Time window specified for daily operations.

  Fields:
    duration: Output only. Duration of the time window, set by service
      producer.
    startTime: Time within the day to start the operations.
  """

  duration = _messages.StringField(1)
  startTime = _messages.MessageField('TimeOfDay', 2)


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values * A month and day, with a zero year (e.g., an anniversary) *
  A year on its own, with a zero month and a zero day * A year and month, with
  a zero day (e.g., a credit card expiration date) Related types: *
  google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class DenyMaintenancePeriod(_messages.Message):
  r"""DenyMaintenancePeriod definition. Maintenance is forbidden within the
  deny period. The start_date must be less than the end_date.

  Fields:
    endDate: Deny period end date. This can be: * A full date, with non-zero
      year, month and day values. * A month and day value, with a zero year.
      Allows recurring deny periods each year. Date matching this period will
      have to be before the end.
    startDate: Deny period start date. This can be: * A full date, with non-
      zero year, month and day values. * A month and day value, with a zero
      year. Allows recurring deny periods each year. Date matching this period
      will have to be the same or after the start.
    time: Time in UTC when the Blackout period starts on start_date and ends
      on end_date. This can be: * Full time. * All zeros for 00:00:00 UTC
  """

  endDate = _messages.MessageField('Date', 1)
  startDate = _messages.MessageField('Date', 2)
  time = _messages.MessageField('TimeOfDay', 3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class FileProjectsLocationsBackupsCreateRequest(_messages.Message):
  r"""A FileProjectsLocationsBackupsCreateRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    backupId: Required. The ID to use for the backup. The ID must be unique
      within the specified project and location. This value must start with a
      lowercase letter followed by up to 62 lowercase letters, numbers, or
      hyphens, and cannot end with a hyphen. Values that do not match this
      pattern will trigger an INVALID_ARGUMENT error.
    parent: Required. The backup's project and location, in the format
      `projects/{project_number}/locations/{location}`. In Cloud Filestore,
      backup locations map to GCP regions, for example **us-west1**.
  """

  backup = _messages.MessageField('Backup', 1)
  backupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class FileProjectsLocationsBackupsDeleteRequest(_messages.Message):
  r"""A FileProjectsLocationsBackupsDeleteRequest object.

  Fields:
    name: Required. The backup resource name, in the format
      `projects/{project_number}/locations/{location}/backups/{backup_id}`
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsBackupsGetRequest(_messages.Message):
  r"""A FileProjectsLocationsBackupsGetRequest object.

  Fields:
    name: Required. The backup resource name, in the format
      `projects/{project_number}/locations/{location}/backups/{backup_id}`.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsBackupsListRequest(_messages.Message):
  r"""A FileProjectsLocationsBackupsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The project and location for which to retrieve backup
      information, in the format
      `projects/{project_number}/locations/{location}`. In Cloud Filestore,
      backup locations map to GCP regions, for example **us-west1**. To
      retrieve backup information for all locations, use "-" for the
      `{location}` value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class FileProjectsLocationsBackupsPatchRequest(_messages.Message):
  r"""A FileProjectsLocationsBackupsPatchRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    name: Output only. The resource name of the backup, in the format
      `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field.
  """

  backup = _messages.MessageField('Backup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class FileProjectsLocationsGetRequest(_messages.Message):
  r"""A FileProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsInstancesCreateRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: Required. The name of the instance to create. The name must be
      unique for the specified project and location.
    parent: Required. The instance's project and location, in the format
      `projects/{project_id}/locations/{location}`. In Cloud Filestore,
      locations map to GCP zones, for example **us-west1-b**.
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class FileProjectsLocationsInstancesDeleteRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesDeleteRequest object.

  Fields:
    force: If set to true, all snapshots of the instance will also be deleted.
      (Otherwise, the request will only work if the instance has no
      snapshots.)
    name: Required. The instance resource name, in the format
      `projects/{project_id}/locations/{location}/instances/{instance_id}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class FileProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesGetRequest object.

  Fields:
    name: Required. The instance resource name, in the format
      `projects/{project_id}/locations/{location}/instances/{instance_id}`.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsInstancesListRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The project and location for which to retrieve instance
      information, in the format `projects/{project_id}/locations/{location}`.
      In Cloud Filestore, locations map to GCP zones, for example **us-
      west1-b**. To retrieve instance information for all locations, use "-"
      for the `{location}` value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class FileProjectsLocationsInstancesPatchRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Output only. The resource name of the instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`.
    updateMask: Mask of fields to update. At least one path must be supplied
      in this field. The elements of the repeated paths field may only include
      these fields: * "description" * "file_shares" * "labels"
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class FileProjectsLocationsInstancesRestoreRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesRestoreRequest object.

  Fields:
    name: Required. The resource name of the instance, in the format `projects
      /{project_number}/locations/{location_id}/instances/{instance_id}`.
    restoreInstanceRequest: A RestoreInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  restoreInstanceRequest = _messages.MessageField('RestoreInstanceRequest', 2)


class FileProjectsLocationsInstancesSnapshotsCreateRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesSnapshotsCreateRequest object.

  Fields:
    parent: Required. The Filestore Instance to create the snapshots of, in
      the format
      `projects/{project_id}/locations/{location}/instances/{instance_id}`
    snapshot: A Snapshot resource to be passed as the request body.
    snapshotId: Required. The ID to use for the snapshot. The ID must be
      unique within the specified instance. This value must start with a
      lowercase letter followed by up to 62 lowercase letters, numbers, or
      hyphens, and cannot end with a hyphen.
  """

  parent = _messages.StringField(1, required=True)
  snapshot = _messages.MessageField('Snapshot', 2)
  snapshotId = _messages.StringField(3)


class FileProjectsLocationsInstancesSnapshotsDeleteRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesSnapshotsDeleteRequest object.

  Fields:
    name: Required. The snapshot resource name, in the format `projects/{proje
      ct_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_
      id}`
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsInstancesSnapshotsGetRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesSnapshotsGetRequest object.

  Fields:
    name: Required. The snapshot resource name, in the format `projects/{proje
      ct_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_
      id}`
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsInstancesSnapshotsListRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesSnapshotsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The instance for which to retrieve snapshot information,
      in the format
      `projects/{project_id}/locations/{location}/instances/{instance_id}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class FileProjectsLocationsInstancesSnapshotsPatchRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesSnapshotsPatchRequest object.

  Fields:
    name: Output only. The resource name of the snapshot, in the format `proje
      cts/{project_id}/locations/{location_id}/instances/{instance_id}/snapsho
      ts/{snapshot_id}`.
    snapshot: A Snapshot resource to be passed as the request body.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field.
  """

  name = _messages.StringField(1, required=True)
  snapshot = _messages.MessageField('Snapshot', 2)
  updateMask = _messages.StringField(3)


class FileProjectsLocationsListRequest(_messages.Message):
  r"""A FileProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class FileProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class FileProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class FileShareConfig(_messages.Message):
  r"""File share configuration for the instance.

  Fields:
    capacityGb: File share capacity in gigabytes (GB). Cloud Filestore defines
      1 GB as 1024^3 bytes.
    name: The name of the file share (must be 16 characters or less).
    nfsExportOptions: Nfs Export Options. There is a limit of 10 export
      options per file share.
    sourceBackup: The resource name of the backup, in the format
      `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
      that this file share has been restored from.
  """

  capacityGb = _messages.IntegerField(1)
  name = _messages.StringField(2)
  nfsExportOptions = _messages.MessageField('NfsExportOptions', 3, repeated=True)
  sourceBackup = _messages.StringField(4)


class GoogleCloudSaasacceleratorManagementProvidersV1Instance(_messages.Message):
  r"""A GoogleCloudSaasacceleratorManagementProvidersV1Instance object.

  Enums:
    StateValueValuesEnum: Output only. Current lifecycle state of the resource
      (e.g. if it's being created or ready to use).

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Each label is a key-value pair, where both the key and the
      value are arbitrary strings provided by the user.
    MaintenancePolicyNamesValue: Deprecated. The MaintenancePolicies that have
      been attached to the instance. The key must be of the type name of the
      oneof policy name defined in MaintenancePolicy, and the referenced
      policy must define the same policy type. For complete details of
      MaintenancePolicy, please refer to go/cloud-saas-mw-ug.
    MaintenanceSchedulesValue: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule with same key as
      software_versions.
    NotificationParametersValue: Optional. notification_parameters are
      information that service producers may like to include that is not
      relevant to Rollout. This parameter will only be passed to Gamma and
      Cloud Logging for notification/logging purpose.
    ProducerMetadataValue: Output only. Custom string attributes used
      primarily to expose producer-specific information in monitoring
      dashboards. See go/get-instance-metadata.
    SoftwareVersionsValue: Software versions that are used to deploy this
      instance. This can be mutated by rollout services.

  Fields:
    consumerDefinedName: consumer_defined_name is the name that is set by the
      consumer. On the other hand Name field represents system-assigned id of
      an instance so consumers are not necessarily aware of it.
      consumer_defined_name is used for notification/UI purposes for consumer
      to recognize their instances.
    createTime: Output only. Timestamp when the resource was created.
    instanceType: Optional. The instance_type of this instance of format: proj
      ects/{project_id}/locations/{location_id}/instanceTypes/{instance_type_i
      d}. Instance Type represents a high-level tier or SKU of the service
      that this instance belong to. When enabled(eg: Maintenance Rollout),
      Rollout uses 'instance_type' along with 'software_versions' to determine
      whether instance needs an update or not.
    labels: Optional. Resource labels to represent user provided metadata.
      Each label is a key-value pair, where both the key and the value are
      arbitrary strings provided by the user.
    maintenancePolicyNames: Deprecated. The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the referenced policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug.
    maintenanceSchedules: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule with same key as
      software_versions.
    maintenanceSettings: Optional. The MaintenanceSettings associated with
      instance.
    name: Unique name of the resource. It uses the form: `projects/{project_id
      |project_number}/locations/{location_id}/instances/{instance_id}` Note:
      Either project_id or project_number can be used, but keep it consistent
      with other APIs (e.g. RescheduleUpdate)
    notificationParameters: Optional. notification_parameters are information
      that service producers may like to include that is not relevant to
      Rollout. This parameter will only be passed to Gamma and Cloud Logging
      for notification/logging purpose.
    producerMetadata: Output only. Custom string attributes used primarily to
      expose producer-specific information in monitoring dashboards. See
      go/get-instance-metadata.
    provisionedResources: Output only. The list of data plane resources
      provisioned for this instance, e.g. compute VMs. See go/get-instance-
      metadata.
    slmInstanceTemplate: Link to the SLM instance template. Only populated
      when updating SLM instances via SSA's Actuation service adaptor. Service
      producers with custom control plane (e.g. Cloud SQL) doesn't need to
      populate this field. Instead they should use software_versions.
    sloMetadata: Output only. SLO metadata for instance classification in the
      Standardized dataplane SLO platform. See go/cloud-ssa-standard-slo for
      feature description.
    softwareVersions: Software versions that are used to deploy this instance.
      This can be mutated by rollout services.
    state: Output only. Current lifecycle state of the resource (e.g. if it's
      being created or ready to use).
    tenantProjectId: Output only. ID of the associated GCP tenant project. See
      go/get-instance-metadata.
    updateTime: Output only. Timestamp when the resource was last modified.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current lifecycle state of the resource (e.g. if it's
    being created or ready to use).

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      CREATING: Instance is being created.
      READY: Instance has been created and is ready to use.
      UPDATING: Instance is being updated.
      REPAIRING: Instance is unheathy and under repair.
      DELETING: Instance is being deleted.
      ERROR: Instance encountered an error and is in indeterministic state.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    REPAIRING = 4
    DELETING = 5
    ERROR = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Each
    label is a key-value pair, where both the key and the value are arbitrary
    strings provided by the user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenancePolicyNamesValue(_messages.Message):
    r"""Deprecated. The MaintenancePolicies that have been attached to the
    instance. The key must be of the type name of the oneof policy name
    defined in MaintenancePolicy, and the referenced policy must define the
    same policy type. For complete details of MaintenancePolicy, please refer
    to go/cloud-saas-mw-ug.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenancePolicyNamesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenancePolicyNamesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenancePolicyNamesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenanceSchedulesValue(_messages.Message):
    r"""The MaintenanceSchedule contains the scheduling information of
    published maintenance schedule with same key as software_versions.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenanceSchedulesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenanceSchedulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenanceSchedulesValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NotificationParametersValue(_messages.Message):
    r"""Optional. notification_parameters are information that service
    producers may like to include that is not relevant to Rollout. This
    parameter will only be passed to Gamma and Cloud Logging for
    notification/logging purpose.

    Messages:
      AdditionalProperty: An additional property for a
        NotificationParametersValue object.

    Fields:
      additionalProperties: Additional properties of type
        NotificationParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NotificationParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProducerMetadataValue(_messages.Message):
    r"""Output only. Custom string attributes used primarily to expose
    producer-specific information in monitoring dashboards. See go/get-
    instance-metadata.

    Messages:
      AdditionalProperty: An additional property for a ProducerMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ProducerMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ProducerMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SoftwareVersionsValue(_messages.Message):
    r"""Software versions that are used to deploy this instance. This can be
    mutated by rollout services.

    Messages:
      AdditionalProperty: An additional property for a SoftwareVersionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SoftwareVersionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SoftwareVersionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  consumerDefinedName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  instanceType = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  maintenancePolicyNames = _messages.MessageField('MaintenancePolicyNamesValue', 5)
  maintenanceSchedules = _messages.MessageField('MaintenanceSchedulesValue', 6)
  maintenanceSettings = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSettings', 7)
  name = _messages.StringField(8)
  notificationParameters = _messages.MessageField('NotificationParametersValue', 9)
  producerMetadata = _messages.MessageField('ProducerMetadataValue', 10)
  provisionedResources = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource', 11, repeated=True)
  slmInstanceTemplate = _messages.StringField(12)
  sloMetadata = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata', 13)
  softwareVersions = _messages.MessageField('SoftwareVersionsValue', 14)
  state = _messages.EnumField('StateValueValuesEnum', 15)
  tenantProjectId = _messages.StringField(16)
  updateTime = _messages.StringField(17)


class GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule(_messages.Message):
  r"""Maintenance schedule which is exposed to customer and potentially end
  user, indicating published upcoming future maintenance schedule

  Fields:
    canReschedule: This field is deprecated, and will be always set to true
      since reschedule can happen multiple times now. This field should not be
      removed until all service producers remove this for their customers.
    endTime: The scheduled end time for the maintenance.
    rolloutManagementPolicy: The rollout management policy this maintenance
      schedule is associated with. When doing reschedule update request, the
      reschedule should be against this given policy.
    scheduleDeadlineTime: schedule_deadline_time is the time deadline any
      schedule start time cannot go beyond, including reschedule. It's
      normally the initial schedule start time plus maintenance window length
      (1 day or 1 week). Maintenance cannot be scheduled to start beyond this
      deadline.
    startTime: The scheduled start time for the maintenance.
  """

  canReschedule = _messages.BooleanField(1)
  endTime = _messages.StringField(2)
  rolloutManagementPolicy = _messages.StringField(3)
  scheduleDeadlineTime = _messages.StringField(4)
  startTime = _messages.StringField(5)


class GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSettings(_messages.Message):
  r"""Maintenance settings associated with instance. Allows service producers
  and end users to assign settings that controls maintenance on this instance.

  Messages:
    MaintenancePoliciesValue: Optional. The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the embedded policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug. If only the name is needed (like in
      the deprecated Instance.maintenance_policy_names field) then only
      populate MaintenancePolicy.name.

  Fields:
    exclude: Optional. Exclude instance from maintenance. When true, rollout
      service will not attempt maintenance on the instance. Rollout service
      will include the instance in reported rollout progress as not attempted.
    isRollback: Optional. If the update call is triggered from rollback, set
      the value as true.
    maintenancePolicies: Optional. The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the embedded policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug. If only the name is needed (like in
      the deprecated Instance.maintenance_policy_names field) then only
      populate MaintenancePolicy.name.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenancePoliciesValue(_messages.Message):
    r"""Optional. The MaintenancePolicies that have been attached to the
    instance. The key must be of the type name of the oneof policy name
    defined in MaintenancePolicy, and the embedded policy must define the same
    policy type. For complete details of MaintenancePolicy, please refer to
    go/cloud-saas-mw-ug. If only the name is needed (like in the deprecated
    Instance.maintenance_policy_names field) then only populate
    MaintenancePolicy.name.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenancePoliciesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenancePoliciesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenancePoliciesValue object.

      Fields:
        key: Name of the additional property.
        value: A MaintenancePolicy attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('MaintenancePolicy', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  exclude = _messages.BooleanField(1)
  isRollback = _messages.BooleanField(2)
  maintenancePolicies = _messages.MessageField('MaintenancePoliciesValue', 3)


class GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata(_messages.Message):
  r"""Node information for custom per-node SLO implementations. SSA does not
  support per-node SLO, but producers can populate per-node information in
  SloMetadata for custom precomputations. SSA Eligibility Exporter will emit
  per-node metric based on this information.

  Fields:
    location: The location of the node, if different from instance location.
    nodeId: The id of the node. This should be equal to
      SaasInstanceNode.node_id.
    perSliEligibility: If present, this will override eligibility for the node
      coming from instance or exclusions for specified SLIs.
  """

  location = _messages.StringField(1)
  nodeId = _messages.StringField(2)
  perSliEligibility = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1PerSliSloEligibility', 3)


class GoogleCloudSaasacceleratorManagementProvidersV1PerSliSloEligibility(_messages.Message):
  r"""PerSliSloEligibility is a mapping from an SLI name to eligibility.

  Messages:
    EligibilitiesValue: An entry in the eligibilities map specifies an
      eligibility for a particular SLI for the given instance. The SLI key in
      the name must be a valid SLI name specified in the Eligibility Exporter
      binary flags otherwise an error will be emitted by Eligibility Exporter
      and the oncaller will be alerted. If an SLI has been defined in the
      binary flags but the eligibilities map does not contain it, the
      corresponding SLI time series will not be emitted by the Eligibility
      Exporter. This ensures a smooth rollout and compatibility between the
      data produced by different versions of the Eligibility Exporters. If
      eligibilities map contains a key for an SLI which has not been declared
      in the binary flags, there will be an error message emitted in the
      Eligibility Exporter log and the metric for the SLI in question will not
      be emitted.

  Fields:
    eligibilities: An entry in the eligibilities map specifies an eligibility
      for a particular SLI for the given instance. The SLI key in the name
      must be a valid SLI name specified in the Eligibility Exporter binary
      flags otherwise an error will be emitted by Eligibility Exporter and the
      oncaller will be alerted. If an SLI has been defined in the binary flags
      but the eligibilities map does not contain it, the corresponding SLI
      time series will not be emitted by the Eligibility Exporter. This
      ensures a smooth rollout and compatibility between the data produced by
      different versions of the Eligibility Exporters. If eligibilities map
      contains a key for an SLI which has not been declared in the binary
      flags, there will be an error message emitted in the Eligibility
      Exporter log and the metric for the SLI in question will not be emitted.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EligibilitiesValue(_messages.Message):
    r"""An entry in the eligibilities map specifies an eligibility for a
    particular SLI for the given instance. The SLI key in the name must be a
    valid SLI name specified in the Eligibility Exporter binary flags
    otherwise an error will be emitted by Eligibility Exporter and the
    oncaller will be alerted. If an SLI has been defined in the binary flags
    but the eligibilities map does not contain it, the corresponding SLI time
    series will not be emitted by the Eligibility Exporter. This ensures a
    smooth rollout and compatibility between the data produced by different
    versions of the Eligibility Exporters. If eligibilities map contains a key
    for an SLI which has not been declared in the binary flags, there will be
    an error message emitted in the Eligibility Exporter log and the metric
    for the SLI in question will not be emitted.

    Messages:
      AdditionalProperty: An additional property for a EligibilitiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type EligibilitiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EligibilitiesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  eligibilities = _messages.MessageField('EligibilitiesValue', 1)


class GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource(_messages.Message):
  r"""Describes provisioned dataplane resources.

  Fields:
    resourceType: Type of the resource. This can be either a GCP resource or a
      custom one (e.g. another cloud provider's VM). For GCP compute resources
      use singular form of the names listed in GCP compute API documentation
      (https://cloud.google.com/compute/docs/reference/rest/v1/), prefixed
      with 'compute-', for example: 'compute-instance', 'compute-disk',
      'compute-autoscaler'.
    resourceUrl: URL identifying the resource, e.g.
      "https://www.googleapis.com/compute/v1/projects/...)".
  """

  resourceType = _messages.StringField(1)
  resourceUrl = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility(_messages.Message):
  r"""SloEligibility is a tuple containing eligibility value: true if an
  instance is eligible for SLO calculation or false if it should be excluded
  from all SLO-related calculations along with a user-defined reason.

  Fields:
    eligible: Whether an instance is eligible or ineligible.
    reason: User-defined reason for the current value of instance eligibility.
      Usually, this can be directly mapped to the internal state. An empty
      reason is allowed.
  """

  eligible = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata(_messages.Message):
  r"""SloMetadata contains resources required for proper SLO classification of
  the instance.

  Fields:
    nodes: Optional. List of nodes. Some producers need to use per-node
      metadata to calculate SLO. This field allows such producers to publish
      per-node SLO meta data, which will be consumed by SSA Eligibility
      Exporter and published in the form of per node metric to Monarch.
    perSliEligibility: Optional. Multiple per-instance SLI eligibilities which
      apply for individual SLIs.
    tier: Name of the SLO tier the Instance belongs to. This name will be
      expected to match the tiers specified in the service SLO configuration.
      Field is mandatory and must not be empty.
  """

  nodes = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata', 1, repeated=True)
  perSliEligibility = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1PerSliSloEligibility', 2)
  tier = _messages.StringField(3)


class Instance(_messages.Message):
  r"""A Cloud Filestore instance.

  Enums:
    StateValueValuesEnum: Output only. The instance state.
    SuspensionReasonsValueListEntryValuesEnum:
    TierValueValuesEnum: The service tier of the instance.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    createTime: Output only. The time when the instance was created.
    description: The description of the instance (2048 characters or less).
    etag: Server-specified ETag for the instance resource to prevent
      simultaneous updates from overwriting each other.
    fileShares: File system shares on the instance. For this version, only a
      single file share is supported.
    kmsKeyName: KMS key name used for data encryption.
    labels: Resource labels to represent user provided metadata.
    name: Output only. The resource name of the instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`.
    networks: VPC networks to which the instance is connected. For this
      version, only a single network is supported.
    satisfiesPzs: Output only. Reserved for future use.
    state: Output only. The instance state.
    statusMessage: Output only. Additional information about the instance
      state, if available.
    suspensionReasons: Output only. field indicates all the reasons the
      instance is in "SUSPENDED" state.
    tier: The service tier of the instance.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The instance state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The instance is being created.
      READY: The instance is available for use.
      REPAIRING: Work is being done on the instance. You can get further
        details from the `statusMessage` field of the `Instance` resource.
      DELETING: The instance is shutting down.
      ERROR: The instance is experiencing an issue and might be unusable. You
        can get further details from the `statusMessage` field of the
        `Instance` resource.
      RESTORING: The instance is restoring a backup to an existing file share
        and may be unusable during this time.
      SUSPENDED: The instance is suspended. You can get further details from
        the `suspension_reasons` field of the `Instance` resource.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    REPAIRING = 3
    DELETING = 4
    ERROR = 5
    RESTORING = 6
    SUSPENDED = 7

  class SuspensionReasonsValueListEntryValuesEnum(_messages.Enum):
    r"""SuspensionReasonsValueListEntryValuesEnum enum type.

    Values:
      SUSPENSION_REASON_UNSPECIFIED: Not set.
      KMS_KEY_ISSUE: The KMS key used by the instance is either revoked or
        denied access to.
    """
    SUSPENSION_REASON_UNSPECIFIED = 0
    KMS_KEY_ISSUE = 1

  class TierValueValuesEnum(_messages.Enum):
    r"""The service tier of the instance.

    Values:
      TIER_UNSPECIFIED: Not set.
      STANDARD: STANDARD tier.
      PREMIUM: PREMIUM tier.
      BASIC_HDD: BASIC instances offer a maximum capacity of 63.9 TB.
        BASIC_HDD is an alias for STANDARD Tier, offering economical
        performance backed by HDD.
      BASIC_SSD: BASIC instances offer a maximum capacity of 63.9 TB.
        BASIC_SSD is an alias for PREMIUM Tier, and offers improved
        performance backed by SSD.
      HIGH_SCALE_SSD: HIGH_SCALE instances offer expanded capacity and
        performance scaling capabilities.
      ENTERPRISE: ENTERPRISE instances offer the features and availability
        needed for mission-critical workloads.
    """
    TIER_UNSPECIFIED = 0
    STANDARD = 1
    PREMIUM = 2
    BASIC_HDD = 3
    BASIC_SSD = 4
    HIGH_SCALE_SSD = 5
    ENTERPRISE = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  etag = _messages.StringField(3)
  fileShares = _messages.MessageField('FileShareConfig', 4, repeated=True)
  kmsKeyName = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  networks = _messages.MessageField('NetworkConfig', 8, repeated=True)
  satisfiesPzs = _messages.BooleanField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  statusMessage = _messages.StringField(11)
  suspensionReasons = _messages.EnumField('SuspensionReasonsValueListEntryValuesEnum', 12, repeated=True)
  tier = _messages.EnumField('TierValueValuesEnum', 13)


class ListBackupsResponse(_messages.Message):
  r"""ListBackupsResponse is the result of ListBackupsRequest.

  Fields:
    backups: A list of backups in the project for the specified location. If
      the `{location}` value in the request is "-", the response contains a
      list of backups from all locations. If any location is unreachable, the
      response will only return backups in reachable locations and the
      "unreachable" field will be populated with a list of unreachable
      locations.
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListInstancesResponse(_messages.Message):
  r"""ListInstancesResponse is the result of ListInstancesRequest.

  Fields:
    instances: A list of instances in the project for the specified location.
      If the `{location}` value in the request is "-", the response contains a
      list of instances from all locations. If any location is unreachable,
      the response will only return instances in reachable locations and the
      "unreachable" field will be populated with a list of unreachable
      locations.
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSnapshotsResponse(_messages.Message):
  r"""ListSnapshotsResponse is the result of ListSnapshotsRequest.

  Fields:
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    snapshots: A list of snapshots in the project for the specified instance.
  """

  nextPageToken = _messages.StringField(1)
  snapshots = _messages.MessageField('Snapshot', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MaintenancePolicy(_messages.Message):
  r"""Defines policies to service maintenance events.

  Enums:
    StateValueValuesEnum: Optional. The state of the policy.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Each label is a key-value pair, where both the key and the
      value are arbitrary strings provided by the user.

  Fields:
    createTime: Output only. The time when the resource was created.
    description: Optional. Description of what this policy is for.
      Create/Update methods return INVALID_ARGUMENT if the length is greater
      than 512.
    labels: Optional. Resource labels to represent user provided metadata.
      Each label is a key-value pair, where both the key and the value are
      arbitrary strings provided by the user.
    name: Required. MaintenancePolicy name using the form: `projects/{project_
      id}/locations/{location_id}/maintenancePolicies/{maintenance_policy_id}`
      where {project_id} refers to a GCP consumer project ID, {location_id}
      refers to a GCP region/zone, {maintenance_policy_id} must be 1-63
      characters long and match the regular expression
      `[a-z0-9]([-a-z0-9]*[a-z0-9])?`.
    state: Optional. The state of the policy.
    updatePolicy: Maintenance policy applicable to instance update.
    updateTime: Output only. The time when the resource was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Optional. The state of the policy.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      READY: Resource is ready to be used.
      DELETING: Resource is being deleted. It can no longer be attached to
        instances.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    DELETING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Each
    label is a key-value pair, where both the key and the value are arbitrary
    strings provided by the user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updatePolicy = _messages.MessageField('UpdatePolicy', 6)
  updateTime = _messages.StringField(7)


class MaintenanceWindow(_messages.Message):
  r"""MaintenanceWindow definition.

  Fields:
    dailyCycle: Daily cycle.
    weeklyCycle: Weekly cycle.
  """

  dailyCycle = _messages.MessageField('DailyCycle', 1)
  weeklyCycle = _messages.MessageField('WeeklyCycle', 2)


class NetworkConfig(_messages.Message):
  r"""Network configuration for the instance.

  Enums:
    ConnectModeValueValuesEnum: The network connect mode of the Filestore
      instance. If not provided, the connect mode defaults to DIRECT_PEERING.
    ModesValueListEntryValuesEnum:

  Fields:
    connectMode: The network connect mode of the Filestore instance. If not
      provided, the connect mode defaults to DIRECT_PEERING.
    ipAddresses: Output only. IPv4 addresses in the format
      `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format `{
      block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
    modes: Internet protocol versions for which the instance has IP addresses
      assigned. For this version, only MODE_IPV4 is supported.
    network: The name of the Google Compute Engine [VPC
      network](https://cloud.google.com/vpc/docs/vpc) to which the instance is
      connected.
    reservedIpRange: Optional, reserved_ip_range can have one of the following
      two types of values. * CIDR range value when using DIRECT_PEERING
      connect mode. * [Allocated IP address
      range](https://cloud.google.com/compute/docs/ip-addresses/reserve-
      static-internal-ip-address) when using PRIVATE_SERVICE_ACCESS connect
      mode. When the name of an allocated IP address range is specified, it
      must be one of the ranges associated with the private service access
      connection. When specified as a direct CIDR value, it must be a /29 CIDR
      block for Basic tier or a /24 CIDR block for High Scale or Enterprise
      tier in one of the [internal IP address ranges](https://www.arin.net/ref
      erence/research/statistics/address_filters/) that identifies the range
      of IP addresses reserved for this instance. For example, 10.0.0.0/29 or
      192.168.0.0/24. The range you specify can't overlap with either existing
      subnets or assigned IP address ranges for other Cloud Filestore
      instances in the selected VPC network.
  """

  class ConnectModeValueValuesEnum(_messages.Enum):
    r"""The network connect mode of the Filestore instance. If not provided,
    the connect mode defaults to DIRECT_PEERING.

    Values:
      CONNECT_MODE_UNSPECIFIED: Not set.
      DIRECT_PEERING: Connect via direct peering to the Filestore service.
      PRIVATE_SERVICE_ACCESS: Connect to your Filestore instance using Private
        Service Access. Private services access provides an IP address range
        for multiple Google Cloud services, including Filestore.
    """
    CONNECT_MODE_UNSPECIFIED = 0
    DIRECT_PEERING = 1
    PRIVATE_SERVICE_ACCESS = 2

  class ModesValueListEntryValuesEnum(_messages.Enum):
    r"""ModesValueListEntryValuesEnum enum type.

    Values:
      ADDRESS_MODE_UNSPECIFIED: Internet protocol not set.
      MODE_IPV4: Use the IPv4 internet protocol.
    """
    ADDRESS_MODE_UNSPECIFIED = 0
    MODE_IPV4 = 1

  connectMode = _messages.EnumField('ConnectModeValueValuesEnum', 1)
  ipAddresses = _messages.StringField(2, repeated=True)
  modes = _messages.EnumField('ModesValueListEntryValuesEnum', 3, repeated=True)
  network = _messages.StringField(4)
  reservedIpRange = _messages.StringField(5)


class NfsExportOptions(_messages.Message):
  r"""NFS export options specifications.

  Enums:
    AccessModeValueValuesEnum: Either READ_ONLY, for allowing only read
      requests on the exported directory, or READ_WRITE, for allowing both
      read and write requests. The default is READ_WRITE.
    SquashModeValueValuesEnum: Either NO_ROOT_SQUASH, for allowing root access
      on the exported directory, or ROOT_SQUASH, for not allowing root access.
      The default is NO_ROOT_SQUASH.

  Fields:
    accessMode: Either READ_ONLY, for allowing only read requests on the
      exported directory, or READ_WRITE, for allowing both read and write
      requests. The default is READ_WRITE.
    anonGid: An integer representing the anonymous group id with a default
      value of 65534. Anon_gid may only be set with squash_mode of
      ROOT_SQUASH. An error will be returned if this field is specified for
      other squash_mode settings.
    anonUid: An integer representing the anonymous user id with a default
      value of 65534. Anon_uid may only be set with squash_mode of
      ROOT_SQUASH. An error will be returned if this field is specified for
      other squash_mode settings.
    ipRanges: List of either an IPv4 addresses in the format
      `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
      `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
      file share. Overlapping IP ranges are not allowed, both within and
      across NfsExportOptions. An error will be returned. The limit is 64 IP
      ranges/addresses for each FileShareConfig among all NfsExportOptions.
    squashMode: Either NO_ROOT_SQUASH, for allowing root access on the
      exported directory, or ROOT_SQUASH, for not allowing root access. The
      default is NO_ROOT_SQUASH.
  """

  class AccessModeValueValuesEnum(_messages.Enum):
    r"""Either READ_ONLY, for allowing only read requests on the exported
    directory, or READ_WRITE, for allowing both read and write requests. The
    default is READ_WRITE.

    Values:
      ACCESS_MODE_UNSPECIFIED: AccessMode not set.
      READ_ONLY: The client can only read the file share.
      READ_WRITE: The client can read and write the file share (default).
    """
    ACCESS_MODE_UNSPECIFIED = 0
    READ_ONLY = 1
    READ_WRITE = 2

  class SquashModeValueValuesEnum(_messages.Enum):
    r"""Either NO_ROOT_SQUASH, for allowing root access on the exported
    directory, or ROOT_SQUASH, for not allowing root access. The default is
    NO_ROOT_SQUASH.

    Values:
      SQUASH_MODE_UNSPECIFIED: SquashMode not set.
      NO_ROOT_SQUASH: The Root user has root access to the file share
        (default).
      ROOT_SQUASH: The Root user has squashed access to the anonymous uid/gid.
    """
    SQUASH_MODE_UNSPECIFIED = 0
    NO_ROOT_SQUASH = 1
    ROOT_SQUASH = 2

  accessMode = _messages.EnumField('AccessModeValueValuesEnum', 1)
  anonGid = _messages.IntegerField(2)
  anonUid = _messages.IntegerField(3)
  ipRanges = _messages.StringField(4, repeated=True)
  squashMode = _messages.EnumField('SquashModeValueValuesEnum', 5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    cancelRequested: Output only. Identifies whether the user has requested
      cancellation of the operation. Operations that have been cancelled
      successfully have Operation.error value with a google.rpc.Status.code of
      1, corresponding to `Code.CANCELLED`.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    statusDetail: Output only. Human-readable status of the operation, if any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class RestoreInstanceRequest(_messages.Message):
  r"""RestoreInstanceRequest restores an existing instance's file share from a
  backup.

  Fields:
    fileShare: Required. Name of the file share in the Cloud Filestore
      instance that the backup is being restored to.
    sourceBackup: The resource name of the backup, in the format
      `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
  """

  fileShare = _messages.StringField(1)
  sourceBackup = _messages.StringField(2)


class Schedule(_messages.Message):
  r"""Configure the schedule.

  Enums:
    DayValueValuesEnum: Allows to define schedule that runs specified day of
      the week.

  Fields:
    day: Allows to define schedule that runs specified day of the week.
    duration: Output only. Duration of the time window, set by service
      producer.
    startTime: Time within the window to start the operations.
  """

  class DayValueValuesEnum(_messages.Enum):
    r"""Allows to define schedule that runs specified day of the week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  day = _messages.EnumField('DayValueValuesEnum', 1)
  duration = _messages.StringField(2)
  startTime = _messages.MessageField('TimeOfDay', 3)


class Snapshot(_messages.Message):
  r"""A Filestore snapshot.

  Enums:
    StateValueValuesEnum: Output only. The snapshot state.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    createTime: Output only. The time when the snapshot was created.
    description: A description of the snapshot with 2048 characters or less.
      Requests with longer descriptions will be rejected.
    filesystemUsedBytes: Output only. The amount of bytes needed to allocate a
      full copy of the snapshot content
    labels: Resource labels to represent user provided metadata.
    name: Output only. The resource name of the snapshot, in the format `proje
      cts/{project_id}/locations/{location_id}/instances/{instance_id}/snapsho
      ts/{snapshot_id}`.
    state: Output only. The snapshot state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The snapshot state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: Snapshot is being created.
      READY: Snapshot is available for use.
      DELETING: Snapshot is being deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  filesystemUsedBytes = _messages.IntegerField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class UpdatePolicy(_messages.Message):
  r"""Maintenance policy applicable to instance updates.

  Enums:
    ChannelValueValuesEnum: Optional. Relative scheduling channel applied to
      resource.

  Fields:
    channel: Optional. Relative scheduling channel applied to resource.
    denyMaintenancePeriods: Deny Maintenance Period that is applied to
      resource to indicate when maintenance is forbidden. User can specify
      zero or more non-overlapping deny periods. Maximum number of
      deny_maintenance_periods expected is one.
    window: Optional. Maintenance window that is applied to resources covered
      by this policy.
  """

  class ChannelValueValuesEnum(_messages.Enum):
    r"""Optional. Relative scheduling channel applied to resource.

    Values:
      UPDATE_CHANNEL_UNSPECIFIED: Unspecified channel.
      EARLIER: Early channel within a customer project.
      LATER: Later channel within a customer project.
    """
    UPDATE_CHANNEL_UNSPECIFIED = 0
    EARLIER = 1
    LATER = 2

  channel = _messages.EnumField('ChannelValueValuesEnum', 1)
  denyMaintenancePeriods = _messages.MessageField('DenyMaintenancePeriod', 2, repeated=True)
  window = _messages.MessageField('MaintenanceWindow', 3)


class WeeklyCycle(_messages.Message):
  r"""Time window specified for weekly operations.

  Fields:
    schedule: User can specify multiple windows in a week. Minimum of 1
      window.
  """

  schedule = _messages.MessageField('Schedule', 1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
