# -*- coding: utf-8 -*- #
# Copyright 2015 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Resource definitions for cloud platform apis."""

import enum


BASE_URL = 'https://vmwareengine.googleapis.com/v1/'
DOCS_URL = 'https://cloud.google.com/solutions/vmware-as-a-service'


class Collections(enum.Enum):
  """Collections for all supported apis."""

  PROJECTS = (
      'projects',
      'projects/{projectsId}',
      {},
      ['projectsId'],
      True
  )
  PROJECTS_LOCATIONS = (
      'projects.locations',
      '{+name}',
      {
          '':
              'projects/{projectsId}/locations/{locationsId}',
      },
      ['name'],
      True
  )
  PROJECTS_LOCATIONS_NETWORKPOLICIES = (
      'projects.locations.networkPolicies',
      '{+name}',
      {
          '':
              'projects/{projectsId}/locations/{locationsId}/networkPolicies/'
              '{networkPoliciesId}',
      },
      ['name'],
      True
  )
  PROJECTS_LOCATIONS_NODETYPES = (
      'projects.locations.nodeTypes',
      '{+name}',
      {
          '':
              'projects/{projectsId}/locations/{locationsId}/nodeTypes/'
              '{nodeTypesId}',
      },
      ['name'],
      True
  )
  PROJECTS_LOCATIONS_OPERATIONS = (
      'projects.locations.operations',
      '{+name}',
      {
          '':
              'projects/{projectsId}/locations/{locationsId}/operations/'
              '{operationsId}',
      },
      ['name'],
      True
  )
  PROJECTS_LOCATIONS_PRIVATECLOUDS = (
      'projects.locations.privateClouds',
      '{+name}',
      {
          '':
              'projects/{projectsId}/locations/{locationsId}/privateClouds/'
              '{privateCloudsId}',
      },
      ['name'],
      True
  )
  PROJECTS_LOCATIONS_PRIVATECLOUDS_CLUSTERS = (
      'projects.locations.privateClouds.clusters',
      '{+name}',
      {
          '':
              'projects/{projectsId}/locations/{locationsId}/privateClouds/'
              '{privateCloudsId}/clusters/{clustersId}',
      },
      ['name'],
      True
  )
  PROJECTS_LOCATIONS_PRIVATECLOUDS_HCXACTIVATIONKEYS = (
      'projects.locations.privateClouds.hcxActivationKeys',
      '{+name}',
      {
          '':
              'projects/{projectsId}/locations/{locationsId}/privateClouds/'
              '{privateCloudsId}/hcxActivationKeys/{hcxActivationKeysId}',
      },
      ['name'],
      True
  )

  def __init__(self, collection_name, path, flat_paths, params,
               enable_uri_parsing):
    self.collection_name = collection_name
    self.path = path
    self.flat_paths = flat_paths
    self.params = params
    self.enable_uri_parsing = enable_uri_parsing
