"""Generated message classes for gkehub version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'gkehub'


class ApigeeMembershipSpec(_messages.Message):
  r"""**Apigee**: Per-Membership Feature spec.

  Fields:
    location: Location of the cluster. This is used by Apigee management plane
      for making location-based routing decisions.
    organizationProjects: In Apigee hybrid install, a project can contain
      memberships that serve multiple Apigee org projects. This is the list of
      Apigee org projects that the membership serves. E.g., In order to get
      the memberships that serve a specific organization project, Consumers
      can filter based on this field.
  """

  location = _messages.StringField(1)
  organizationProjects = _messages.StringField(2, repeated=True)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Authority(_messages.Message):
  r"""Authority encodes how Google will recognize identities from this
  Membership. See the workload identity documentation for more details:
  https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity

  Fields:
    identityProvider: Output only. An identity provider that reflects the
      `issuer` in the workload identity pool.
    issuer: Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start
      with `https://` and be a valid URL with length <2000 characters. If set,
      then Google will allow valid OIDC tokens from this issuer to
      authenticate within the workload_identity_pool. OIDC discovery will be
      performed on this URI to validate tokens from the issuer. Clearing
      `issuer` disables Workload Identity. `issuer` cannot be directly
      modified; it must be cleared (and Workload Identity disabled) before
      using a new issuer (and re-enabling Workload Identity).
    oidcJwks: Optional. OIDC verification keys for this Membership in JWKS
      format (RFC 7517). When this field is set, OIDC discovery will NOT be
      performed on `issuer`, and instead OIDC tokens will be validated using
      this field.
    workloadIdentityPool: Output only. The name of the workload identity pool
      in which `issuer` will be recognized. There is a single Workload
      Identity Pool per Hub that is shared between all Memberships that belong
      to that Hub. For a Hub hosted in {PROJECT_ID}, the workload pool format
      is `{PROJECT_ID}.hub.id.goog`, although this is subject to change in
      newer versions of this API.
  """

  identityProvider = _messages.StringField(1)
  issuer = _messages.StringField(2)
  oidcJwks = _messages.BytesField(3)
  workloadIdentityPool = _messages.StringField(4)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudAuditLoggingFeatureSpec(_messages.Message):
  r"""**Cloud Audit Logging**: Spec for Audit Logging Allowlisting.

  Fields:
    allowlistedServiceAccounts: Service account that should be allowlisted to
      send the audit logs; eg cloudauditlogging@gcp-
      project.iam.gserviceaccount.com. These accounts must already exist, but
      do not need to have any permissions granted to them. The customer's
      entitlements will be checked prior to allowlisting (i.e. the customer
      must be an Anthos customer.)
  """

  allowlistedServiceAccounts = _messages.StringField(1, repeated=True)


class CommonFeatureSpec(_messages.Message):
  r"""CommonFeatureSpec contains Hub-wide configuration information

  Fields:
    cloudauditlogging: Cloud Audit Logging-specific spec.
    helloworld: Hello World-specific spec.
    multiclusteringress: Multicluster Ingress-specific spec.
  """

  cloudauditlogging = _messages.MessageField('CloudAuditLoggingFeatureSpec', 1)
  helloworld = _messages.MessageField('HelloWorldFeatureSpec', 2)
  multiclusteringress = _messages.MessageField('MultiClusterIngressFeatureSpec', 3)


class CommonFeatureState(_messages.Message):
  r"""CommonFeatureState contains Hub-wide Feature status information.

  Fields:
    helloworld: Hello World-specific state.
    servicemesh: Service Mesh-specific state.
    state: Output only. The "running state" of the Feature in this Hub.
  """

  helloworld = _messages.MessageField('HelloWorldFeatureState', 1)
  servicemesh = _messages.MessageField('ServiceMeshFeatureState', 2)
  state = _messages.MessageField('FeatureState', 3)


class ConfigManagementBinauthzConfig(_messages.Message):
  r"""Configuration for Binauthz

  Fields:
    enabled: Whether binauthz is enabled in this cluster.
  """

  enabled = _messages.BooleanField(1)


class ConfigManagementBinauthzState(_messages.Message):
  r"""State for Binauthz

  Enums:
    WebhookValueValuesEnum: The state of the binauthz webhook.

  Fields:
    version: The version of binauthz that is installed.
    webhook: The state of the binauthz webhook.
  """

  class WebhookValueValuesEnum(_messages.Enum):
    r"""The state of the binauthz webhook.

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  version = _messages.MessageField('ConfigManagementBinauthzVersion', 1)
  webhook = _messages.EnumField('WebhookValueValuesEnum', 2)


class ConfigManagementBinauthzVersion(_messages.Message):
  r"""The version of binauthz.

  Fields:
    webhookVersion: The version of the binauthz webhook.
  """

  webhookVersion = _messages.StringField(1)


class ConfigManagementConfigSync(_messages.Message):
  r"""Configuration for Config Sync

  Fields:
    git: Git repo configuration for the cluster.
    sourceFormat: Specifies whether the Config Sync Repo is in "hierarchical"
      or "unstructured" mode.
  """

  git = _messages.MessageField('ConfigManagementGitConfig', 1)
  sourceFormat = _messages.StringField(2)


class ConfigManagementConfigSyncDeploymentState(_messages.Message):
  r"""The state of ConfigSync's deployment on a cluster

  Enums:
    GitSyncValueValuesEnum: Deployment state of the git-sync pod
    ImporterValueValuesEnum: Deployment state of the importer pod
    MonitorValueValuesEnum: Deployment state of the monitor pod
    ReconcilerManagerValueValuesEnum: Deployment state of reconciler-manager
      pod
    RootReconcilerValueValuesEnum: Deployment state of root-reconciler
    SyncerValueValuesEnum: Deployment state of the syncer pod

  Fields:
    gitSync: Deployment state of the git-sync pod
    importer: Deployment state of the importer pod
    monitor: Deployment state of the monitor pod
    reconcilerManager: Deployment state of reconciler-manager pod
    rootReconciler: Deployment state of root-reconciler
    syncer: Deployment state of the syncer pod
  """

  class GitSyncValueValuesEnum(_messages.Enum):
    r"""Deployment state of the git-sync pod

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class ImporterValueValuesEnum(_messages.Enum):
    r"""Deployment state of the importer pod

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class MonitorValueValuesEnum(_messages.Enum):
    r"""Deployment state of the monitor pod

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class ReconcilerManagerValueValuesEnum(_messages.Enum):
    r"""Deployment state of reconciler-manager pod

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class RootReconcilerValueValuesEnum(_messages.Enum):
    r"""Deployment state of root-reconciler

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class SyncerValueValuesEnum(_messages.Enum):
    r"""Deployment state of the syncer pod

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  gitSync = _messages.EnumField('GitSyncValueValuesEnum', 1)
  importer = _messages.EnumField('ImporterValueValuesEnum', 2)
  monitor = _messages.EnumField('MonitorValueValuesEnum', 3)
  reconcilerManager = _messages.EnumField('ReconcilerManagerValueValuesEnum', 4)
  rootReconciler = _messages.EnumField('RootReconcilerValueValuesEnum', 5)
  syncer = _messages.EnumField('SyncerValueValuesEnum', 6)


class ConfigManagementConfigSyncState(_messages.Message):
  r"""State information for ConfigSync

  Fields:
    deploymentState: Information about the deployment of ConfigSync, including
      the version of the various Pods deployed
    syncState: The state of ConfigSync's process to sync configs to a cluster
    version: The version of ConfigSync deployed
  """

  deploymentState = _messages.MessageField('ConfigManagementConfigSyncDeploymentState', 1)
  syncState = _messages.MessageField('ConfigManagementSyncState', 2)
  version = _messages.MessageField('ConfigManagementConfigSyncVersion', 3)


class ConfigManagementConfigSyncVersion(_messages.Message):
  r"""Specific versioning information pertaining to ConfigSync's Pods

  Fields:
    gitSync: Version of the deployed git-sync pod
    importer: Version of the deployed importer pod
    monitor: Version of the deployed monitor pod
    reconcilerManager: Version of the deployed reconciler-manager pod
    rootReconciler: Version of the deployed reconciler container in root-
      reconciler pod
    syncer: Version of the deployed syncer pod
  """

  gitSync = _messages.StringField(1)
  importer = _messages.StringField(2)
  monitor = _messages.StringField(3)
  reconcilerManager = _messages.StringField(4)
  rootReconciler = _messages.StringField(5)
  syncer = _messages.StringField(6)


class ConfigManagementErrorResource(_messages.Message):
  r"""Model for a config file in the git repo with an associated Sync error

  Fields:
    resourceGvk: Group/version/kind of the resource that is causing an error
    resourceName: Metadata name of the resource that is causing an error
    resourceNamespace: Namespace of the resource that is causing an error
    sourcePath: Path in the git repo of the erroneous config
  """

  resourceGvk = _messages.MessageField('ConfigManagementGroupVersionKind', 1)
  resourceName = _messages.StringField(2)
  resourceNamespace = _messages.StringField(3)
  sourcePath = _messages.StringField(4)


class ConfigManagementGatekeeperDeploymentState(_messages.Message):
  r"""State of Policy Controller installation.

  Enums:
    GatekeeperAuditValueValuesEnum: Status of gatekeeper-audit deployment.
    GatekeeperControllerManagerStateValueValuesEnum: Status of gatekeeper-
      controller-manager pod.
    GatekeeperMutationValueValuesEnum: Status of the pod serving the mutation
      webhook.

  Fields:
    gatekeeperAudit: Status of gatekeeper-audit deployment.
    gatekeeperControllerManagerState: Status of gatekeeper-controller-manager
      pod.
    gatekeeperMutation: Status of the pod serving the mutation webhook.
  """

  class GatekeeperAuditValueValuesEnum(_messages.Enum):
    r"""Status of gatekeeper-audit deployment.

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class GatekeeperControllerManagerStateValueValuesEnum(_messages.Enum):
    r"""Status of gatekeeper-controller-manager pod.

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class GatekeeperMutationValueValuesEnum(_messages.Enum):
    r"""Status of the pod serving the mutation webhook.

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  gatekeeperAudit = _messages.EnumField('GatekeeperAuditValueValuesEnum', 1)
  gatekeeperControllerManagerState = _messages.EnumField('GatekeeperControllerManagerStateValueValuesEnum', 2)
  gatekeeperMutation = _messages.EnumField('GatekeeperMutationValueValuesEnum', 3)


class ConfigManagementGitConfig(_messages.Message):
  r"""Git repo configuration for a single cluster.

  Fields:
    gcpServiceAccountEmail: The GCP Service Account Email used for auth when
      secret_type is gcpServiceAccount.
    httpsProxy: URL for the HTTPS proxy to be used when communicating with the
      Git repo.
    policyDir: The path within the Git repository that represents the top
      level of the repo to sync. Default: the root directory of the
      repository.
    secretType: Type of secret configured for access to the Git repo.
    syncBranch: The branch of the repository to sync from. Default: master.
    syncRepo: The URL of the Git repository to use as the source of truth.
    syncRev: Git revision (tag or hash) to check out. Default HEAD.
    syncWaitSecs: Period in seconds between consecutive syncs. Default: 15.
  """

  gcpServiceAccountEmail = _messages.StringField(1)
  httpsProxy = _messages.StringField(2)
  policyDir = _messages.StringField(3)
  secretType = _messages.StringField(4)
  syncBranch = _messages.StringField(5)
  syncRepo = _messages.StringField(6)
  syncRev = _messages.StringField(7)
  syncWaitSecs = _messages.IntegerField(8)


class ConfigManagementGroupVersionKind(_messages.Message):
  r"""A Kubernetes object's GVK

  Fields:
    group: Kubernetes Group
    kind: Kubernetes Kind
    version: Kubernetes Version
  """

  group = _messages.StringField(1)
  kind = _messages.StringField(2)
  version = _messages.StringField(3)


class ConfigManagementHierarchyControllerConfig(_messages.Message):
  r"""Configuration for Hierarchy Controller

  Fields:
    enableHierarchicalResourceQuota: Whether hierarchical resource quota is
      enabled in this cluster.
    enablePodTreeLabels: Whether pod tree labels are enabled in this cluster.
    enabled: Whether Hierarchy Controller is enabled in this cluster.
  """

  enableHierarchicalResourceQuota = _messages.BooleanField(1)
  enablePodTreeLabels = _messages.BooleanField(2)
  enabled = _messages.BooleanField(3)


class ConfigManagementHierarchyControllerDeploymentState(_messages.Message):
  r"""Deployment state for Hierarchy Controller

  Enums:
    ExtensionValueValuesEnum: The deployment state for Hierarchy Controller
      extension (e.g. v0.7.0-hc.1)
    HncValueValuesEnum: The deployment state for open source HNC (e.g.
      v0.7.0-hc.0)

  Fields:
    extension: The deployment state for Hierarchy Controller extension (e.g.
      v0.7.0-hc.1)
    hnc: The deployment state for open source HNC (e.g. v0.7.0-hc.0)
  """

  class ExtensionValueValuesEnum(_messages.Enum):
    r"""The deployment state for Hierarchy Controller extension (e.g.
    v0.7.0-hc.1)

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  class HncValueValuesEnum(_messages.Enum):
    r"""The deployment state for open source HNC (e.g. v0.7.0-hc.0)

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  extension = _messages.EnumField('ExtensionValueValuesEnum', 1)
  hnc = _messages.EnumField('HncValueValuesEnum', 2)


class ConfigManagementHierarchyControllerState(_messages.Message):
  r"""State for Hierarchy Controller

  Fields:
    state: The deployment state for Hierarchy Controller
    version: The version for Hierarchy Controller
  """

  state = _messages.MessageField('ConfigManagementHierarchyControllerDeploymentState', 1)
  version = _messages.MessageField('ConfigManagementHierarchyControllerVersion', 2)


class ConfigManagementHierarchyControllerVersion(_messages.Message):
  r"""Version for Hierarchy Controller

  Fields:
    extension: Version for Hierarchy Controller extension
    hnc: Version for open source HNC
  """

  extension = _messages.StringField(1)
  hnc = _messages.StringField(2)


class ConfigManagementInstallError(_messages.Message):
  r"""Errors pertaining to the installation of ACM

  Fields:
    errorMessage: A string representing the user facing error message
  """

  errorMessage = _messages.StringField(1)


class ConfigManagementMembershipSpec(_messages.Message):
  r"""**Anthos Config Management**: Configuration for a single cluster.
  Intended to parallel the ConfigManagement CR.

  Fields:
    binauthz: Binauthz conifguration for the cluster.
    configSync: Config Sync configuration for the cluster.
    hierarchyController: Hierarchy Controller configuration for the cluster.
    policyController: Policy Controller configuration for the cluster.
    version: Version of ACM installed.
  """

  binauthz = _messages.MessageField('ConfigManagementBinauthzConfig', 1)
  configSync = _messages.MessageField('ConfigManagementConfigSync', 2)
  hierarchyController = _messages.MessageField('ConfigManagementHierarchyControllerConfig', 3)
  policyController = _messages.MessageField('ConfigManagementPolicyController', 4)
  version = _messages.StringField(5)


class ConfigManagementMembershipState(_messages.Message):
  r"""**Anthos Config Management**: State for a single cluster.

  Fields:
    binauthzState: Binauthz status
    clusterName: The user-defined name for the cluster used by
      ClusterSelectors to group clusters together. This should match
      Membership's membership_name, unless the user installed ACM on the
      cluster manually prior to enabling the ACM hub feature. Unique within a
      Anthos Config Management installation.
    configSyncState: Current sync status
    hierarchyControllerState: Hierarchy Controller status
    membershipSpec: Membership configuration in the cluster. This represents
      the actual state in the cluster, while the MembershipSpec in the
      FeatureSpec represents the intended state
    operatorState: Current install status of ACM's Operator
    policyControllerState: PolicyController status
  """

  binauthzState = _messages.MessageField('ConfigManagementBinauthzState', 1)
  clusterName = _messages.StringField(2)
  configSyncState = _messages.MessageField('ConfigManagementConfigSyncState', 3)
  hierarchyControllerState = _messages.MessageField('ConfigManagementHierarchyControllerState', 4)
  membershipSpec = _messages.MessageField('ConfigManagementMembershipSpec', 5)
  operatorState = _messages.MessageField('ConfigManagementOperatorState', 6)
  policyControllerState = _messages.MessageField('ConfigManagementPolicyControllerState', 7)


class ConfigManagementOperatorState(_messages.Message):
  r"""State information for an ACM's Operator

  Enums:
    DeploymentStateValueValuesEnum: The state of the Operator's deployment

  Fields:
    deploymentState: The state of the Operator's deployment
    errors: Install errors.
    version: The semenatic version number of the operator
  """

  class DeploymentStateValueValuesEnum(_messages.Enum):
    r"""The state of the Operator's deployment

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Deployment's state cannot be determined
      NOT_INSTALLED: Deployment is not installed
      INSTALLED: Deployment is installed
      ERROR: Deployment was attempted to be installed, but has errors
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    NOT_INSTALLED = 1
    INSTALLED = 2
    ERROR = 3

  deploymentState = _messages.EnumField('DeploymentStateValueValuesEnum', 1)
  errors = _messages.MessageField('ConfigManagementInstallError', 2, repeated=True)
  version = _messages.StringField(3)


class ConfigManagementPolicyController(_messages.Message):
  r"""Configuration for Policy Controller

  Fields:
    auditIntervalSeconds: Sets the interval for Policy Controller Audit Scans
      (in seconds). When set to 0, this disables audit functionality
      altogether.
    enabled: Enables the installation of Policy Controller. If false, the rest
      of PolicyController fields take no effect.
    exemptableNamespaces: The set of namespaces that are excluded from Policy
      Controller checks. Namespaces do not need to currently exist on the
      cluster.
    logDeniesEnabled: Logs all denies and dry run failures.
    mutationEnabled: Enable users to try out mutation for PolicyController.
    referentialRulesEnabled: Enables the ability to use Constraint Templates
      that reference to objects other than the object currently being
      evaluated.
    templateLibraryInstalled: Installs the default template library along with
      Policy Controller.
  """

  auditIntervalSeconds = _messages.IntegerField(1)
  enabled = _messages.BooleanField(2)
  exemptableNamespaces = _messages.StringField(3, repeated=True)
  logDeniesEnabled = _messages.BooleanField(4)
  mutationEnabled = _messages.BooleanField(5)
  referentialRulesEnabled = _messages.BooleanField(6)
  templateLibraryInstalled = _messages.BooleanField(7)


class ConfigManagementPolicyControllerState(_messages.Message):
  r"""State for PolicyControllerState.

  Fields:
    deploymentState: The state about the policy controller installation.
    version: The version of Gatekeeper Policy Controller deployed.
  """

  deploymentState = _messages.MessageField('ConfigManagementGatekeeperDeploymentState', 1)
  version = _messages.MessageField('ConfigManagementPolicyControllerVersion', 2)


class ConfigManagementPolicyControllerVersion(_messages.Message):
  r"""The build version of Gatekeeper Policy Controller is using.

  Fields:
    version: The gatekeeper image tag that is composed of ACM version, git
      tag, build number.
  """

  version = _messages.StringField(1)


class ConfigManagementSyncError(_messages.Message):
  r"""An ACM created error representing a problem syncing configurations

  Fields:
    code: An ACM defined error code
    errorMessage: A description of the error
    errorResources: A list of config(s) associated with the error, if any
  """

  code = _messages.StringField(1)
  errorMessage = _messages.StringField(2)
  errorResources = _messages.MessageField('ConfigManagementErrorResource', 3, repeated=True)


class ConfigManagementSyncState(_messages.Message):
  r"""State indicating an ACM's progress syncing configurations to a cluster

  Enums:
    CodeValueValuesEnum: Sync status code

  Fields:
    code: Sync status code
    errors: A list of errors resulting from problematic configs. This list
      will be truncated after 100 errors, although it is unlikely for that
      many errors to simultaneously exist.
    importToken: Token indicating the state of the importer.
    lastSync: Deprecated: use last_sync_time instead. Timestamp of when ACM
      last successfully synced the repo The time format is specified in
      https://golang.org/pkg/time/#Time.String
    lastSyncTime: Timestamp type of when ACM last successfully synced the repo
    sourceToken: Token indicating the state of the repo.
    syncToken: Token indicating the state of the syncer.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""Sync status code

    Values:
      SYNC_CODE_UNSPECIFIED: ACM cannot determine a sync code
      SYNCED: ACM successfully synced the git Repo with the cluster
      PENDING: ACM is in the progress of syncing a new change
      ERROR: Indicates an error configuring ACM, and user action is required
      NOT_CONFIGURED: ACM has been installed (operator manifest deployed), but
        not configured.
      NOT_INSTALLED: ACM has not been installed (no operator pod found)
      UNAUTHORIZED: Error authorizing with the cluster
      UNREACHABLE: Cluster could not be reached
    """
    SYNC_CODE_UNSPECIFIED = 0
    SYNCED = 1
    PENDING = 2
    ERROR = 3
    NOT_CONFIGURED = 4
    NOT_INSTALLED = 5
    UNAUTHORIZED = 6
    UNREACHABLE = 7

  code = _messages.EnumField('CodeValueValuesEnum', 1)
  errors = _messages.MessageField('ConfigManagementSyncError', 2, repeated=True)
  importToken = _messages.StringField(3)
  lastSync = _messages.StringField(4)
  lastSyncTime = _messages.StringField(5)
  sourceToken = _messages.StringField(6)
  syncToken = _messages.StringField(7)


class ConnectAgentResource(_messages.Message):
  r"""ConnectAgentResource represents a Kubernetes resource manifest for
  Connect Agent deployment.

  Fields:
    manifest: YAML manifest of the resource.
    type: Kubernetes type of the resource.
  """

  manifest = _messages.StringField(1)
  type = _messages.MessageField('TypeMeta', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Feature(_messages.Message):
  r"""Feature represents the settings and status of any Hub Feature.

  Messages:
    LabelsValue: GCP labels for this Feature.
    MembershipSpecsValue: Optional. Membership-specific configuration for this
      Feature. If this Feature does not support any per-Membership
      configuration, this field may be unused. The keys indicate which
      Membership the configuration is for, in the form:
      projects/{p}/locations/{l}/memberships/{m} Where {p} is the project, {l}
      is a valid location and {m} is a valid Membership in this project at
      that location. {p} WILL match the Feature's project. {p} will always be
      returned as the project number, but the project ID is also accepted
      during input. If the same Membership is specified in the map twice
      (using the project ID form, and the project number form), exactly ONE of
      the entries will be saved, with no guarantees as to which. For this
      reason, it is recommended the same format be used for all entries when
      mutating a Feature.
    MembershipStatesValue: Output only. Membership-specific Feature status. If
      this Feature does report any per-Membership status, this field may be
      unused. The keys indicate which Membership the state is for, in the
      form: projects/{p}/locations/{l}/memberships/{m} Where {p} is the
      project number, {l} is a valid location and {m} is a valid Membership in
      this project at that location. {p} MUST match the Feature's project
      number.

  Fields:
    createTime: Output only. When the Feature resource was created.
    deleteTime: Output only. When the Feature resource was deleted.
    labels: GCP labels for this Feature.
    membershipSpecs: Optional. Membership-specific configuration for this
      Feature. If this Feature does not support any per-Membership
      configuration, this field may be unused. The keys indicate which
      Membership the configuration is for, in the form:
      projects/{p}/locations/{l}/memberships/{m} Where {p} is the project, {l}
      is a valid location and {m} is a valid Membership in this project at
      that location. {p} WILL match the Feature's project. {p} will always be
      returned as the project number, but the project ID is also accepted
      during input. If the same Membership is specified in the map twice
      (using the project ID form, and the project number form), exactly ONE of
      the entries will be saved, with no guarantees as to which. For this
      reason, it is recommended the same format be used for all entries when
      mutating a Feature.
    membershipStates: Output only. Membership-specific Feature status. If this
      Feature does report any per-Membership status, this field may be unused.
      The keys indicate which Membership the state is for, in the form:
      projects/{p}/locations/{l}/memberships/{m} Where {p} is the project
      number, {l} is a valid location and {m} is a valid Membership in this
      project at that location. {p} MUST match the Feature's project number.
    name: Output only. The full, unique name of this Feature resource in the
      format `projects/*/locations/*/features/*`.
    resourceState: Output only. State of the Feature resource itself.
    spec: Optional. Hub-wide Feature configuration. If this Feature does not
      support any Hub-wide configuration, this field may be unused.
    state: Output only. The Hub-wide Feature state.
    updateTime: Output only. When the Feature resource was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""GCP labels for this Feature.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MembershipSpecsValue(_messages.Message):
    r"""Optional. Membership-specific configuration for this Feature. If this
    Feature does not support any per-Membership configuration, this field may
    be unused. The keys indicate which Membership the configuration is for, in
    the form: projects/{p}/locations/{l}/memberships/{m} Where {p} is the
    project, {l} is a valid location and {m} is a valid Membership in this
    project at that location. {p} WILL match the Feature's project. {p} will
    always be returned as the project number, but the project ID is also
    accepted during input. If the same Membership is specified in the map
    twice (using the project ID form, and the project number form), exactly
    ONE of the entries will be saved, with no guarantees as to which. For this
    reason, it is recommended the same format be used for all entries when
    mutating a Feature.

    Messages:
      AdditionalProperty: An additional property for a MembershipSpecsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MembershipSpecsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MembershipSpecsValue object.

      Fields:
        key: Name of the additional property.
        value: A MembershipFeatureSpec attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('MembershipFeatureSpec', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MembershipStatesValue(_messages.Message):
    r"""Output only. Membership-specific Feature status. If this Feature does
    report any per-Membership status, this field may be unused. The keys
    indicate which Membership the state is for, in the form:
    projects/{p}/locations/{l}/memberships/{m} Where {p} is the project
    number, {l} is a valid location and {m} is a valid Membership in this
    project at that location. {p} MUST match the Feature's project number.

    Messages:
      AdditionalProperty: An additional property for a MembershipStatesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        MembershipStatesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MembershipStatesValue object.

      Fields:
        key: Name of the additional property.
        value: A MembershipFeatureState attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('MembershipFeatureState', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deleteTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  membershipSpecs = _messages.MessageField('MembershipSpecsValue', 4)
  membershipStates = _messages.MessageField('MembershipStatesValue', 5)
  name = _messages.StringField(6)
  resourceState = _messages.MessageField('FeatureResourceState', 7)
  spec = _messages.MessageField('CommonFeatureSpec', 8)
  state = _messages.MessageField('CommonFeatureState', 9)
  updateTime = _messages.StringField(10)


class FeatureResourceState(_messages.Message):
  r"""FeatureResourceState describes the state of a Feature *resource* in the
  GkeHub API. See `FeatureState` for the "running state" of the Feature in the
  Hub and across Memberships.

  Enums:
    StateValueValuesEnum: The current state of the Feature resource in the Hub
      API.

  Fields:
    state: The current state of the Feature resource in the Hub API.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the Feature resource in the Hub API.

    Values:
      STATE_UNSPECIFIED: State is unknown or not set.
      ENABLING: The Feature is being enabled, and the Feature resource is
        being created. Once complete, the corresponding Feature will be
        enabled in this Hub.
      ACTIVE: The Feature is enabled in this Hub, and the Feature resource is
        fully available.
      DISABLING: The Feature is being disabled in this Hub, and the Feature
        resource is being deleted.
      UPDATING: The Feature resource is being updated.
      SERVICE_UPDATING: The Feature resource is being updated by the Hub
        Service.
    """
    STATE_UNSPECIFIED = 0
    ENABLING = 1
    ACTIVE = 2
    DISABLING = 3
    UPDATING = 4
    SERVICE_UPDATING = 5

  state = _messages.EnumField('StateValueValuesEnum', 1)


class FeatureState(_messages.Message):
  r"""FeatureState describes the high-level state of a Feature. It may be used
  to describe a Feature's state at the environ-level, or per-membershop,
  depending on the context.

  Enums:
    CodeValueValuesEnum: The high-level, machine-readable status of this
      Feature.

  Fields:
    code: The high-level, machine-readable status of this Feature.
    description: A human-readable description of the current status.
    updateTime: The time this status and any related Feature-specific details
      were updated.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""The high-level, machine-readable status of this Feature.

    Values:
      CODE_UNSPECIFIED: Unknown or not set.
      OK: The Feature is operating normally.
      WARNING: The Feature has encountered an issue, and is operating in a
        degraded state. The Feature may need intervention to return to normal
        operation. See the description and any associated Feature-specific
        details for more information.
      ERROR: The Feature is not operating or is in a severely degraded state.
        The Feature may need intervention to return to normal operation. See
        the description and any associated Feature-specific details for more
        information.
    """
    CODE_UNSPECIFIED = 0
    OK = 1
    WARNING = 2
    ERROR = 3

  code = _messages.EnumField('CodeValueValuesEnum', 1)
  description = _messages.StringField(2)
  updateTime = _messages.StringField(3)


class Fleet(_messages.Message):
  r"""Contains the information of fleet resource.

  Fields:
    fleetName: The name for the fleet. The name must meet the following
      constraints: + The name of a fleet should be unique within the
      organization; + It must consist of lower case alphanumeric characters or
      `-`; + The length of the name must be less than or equal to 63; +
      Unicode names must be expressed in Punycode format (rfc3492). Examples:
      + prod-fleet + xn--wlq33vhyw9jb \uff08Punycode form for
      "\u751f\u4ea7\u73af\u5883")
    name: Output only. The full, unique resource name of this fleet in the
      format of `projects/{project}/locations/{location}/fleet`. Each GCP
      project can have at most one fleet resource.
  """

  fleetName = _messages.StringField(1)
  name = _messages.StringField(2)


class GenerateConnectManifestResponse(_messages.Message):
  r"""GenerateConnectManifestResponse contains manifest information for
  installing/upgrading a Connect agent.

  Fields:
    manifest: The ordered list of Kubernetes resources that need to be applied
      to the cluster for GKE Connect agent installation/upgrade.
  """

  manifest = _messages.MessageField('ConnectAgentResource', 1, repeated=True)


class GkeCluster(_messages.Message):
  r"""GkeCluster contains information specific to GKE clusters.

  Fields:
    clusterMissing: Output only. If cluster_missing is set then it denotes
      that the GKE cluster no longer exists in the GKE Control Plane.
    resourceLink: Immutable. Self-link of the GCP resource for the GKE
      cluster. For example: //container.googleapis.com/projects/my-
      project/locations/us-west1-a/clusters/my-cluster Zonal clusters are also
      supported.
  """

  clusterMissing = _messages.BooleanField(1)
  resourceLink = _messages.StringField(2)


class GkehubProjectsLocationsFeaturesCreateRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesCreateRequest object.

  Fields:
    feature: A Feature resource to be passed as the request body.
    featureId: The ID of the feature to create.
    parent: The parent (project and location) where the Feature will be
      created. Specified in the format `projects/*/locations/*`.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  feature = _messages.MessageField('Feature', 1)
  featureId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class GkehubProjectsLocationsFeaturesDeleteRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesDeleteRequest object.

  Fields:
    force: If set to true, the delete will ignore any outstanding resources
      for this Feature (that is, `FeatureState.has_resources` is set to true).
      These resources will NOT be cleaned up or modified in any way.
    name: The Feature resource name in the format
      `projects/*/locations/*/features/*`.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class GkehubProjectsLocationsFeaturesGetIamPolicyRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkehubProjectsLocationsFeaturesGetRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesGetRequest object.

  Fields:
    name: The Feature resource name in the format
      `projects/*/locations/*/features/*`
  """

  name = _messages.StringField(1, required=True)


class GkehubProjectsLocationsFeaturesListRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesListRequest object.

  Fields:
    filter: Lists Features that match the filter expression, following the
      syntax outlined in https://google.aip.dev/160. Examples: - Feature with
      the name "servicemesh" in project "foo-proj": name = "projects/foo-
      proj/locations/global/features/servicemesh" - Features that have a label
      called `foo`: labels.foo:* - Features that have a label called `foo`
      whose value is `bar`: labels.foo = bar
    orderBy: One or more fields to compare and use to sort the output. See
      https://google.aip.dev/132#ordering.
    pageSize: When requesting a 'page' of resources, `page_size` specifies
      number of resources to return. If unspecified or set to 0, all resources
      will be returned.
    pageToken: Token returned by previous call to `ListFeatures` which
      specifies the position in the list from where to continue listing the
      resources.
    parent: The parent (project and location) where the Features will be
      listed. Specified in the format `projects/*/locations/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GkehubProjectsLocationsFeaturesPatchRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesPatchRequest object.

  Fields:
    feature: A Feature resource to be passed as the request body.
    name: The Feature resource name in the format
      `projects/*/locations/*/features/*`.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Mask of fields to update.
  """

  feature = _messages.MessageField('Feature', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class GkehubProjectsLocationsFeaturesSetIamPolicyRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkehubProjectsLocationsFeaturesTestIamPermissionsRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFeaturesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkehubProjectsLocationsFleetCreateRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFleetCreateRequest object.

  Fields:
    fleet: A Fleet resource to be passed as the request body.
    parent: Required. The parent (fleet-hosting project) under which the fleet
      will be created. Format: `projects/{project}/locations/{location}`.
  """

  fleet = _messages.MessageField('Fleet', 1)
  parent = _messages.StringField(2, required=True)


class GkehubProjectsLocationsFleetSearchFleetsRequest(_messages.Message):
  r"""A GkehubProjectsLocationsFleetSearchFleetsRequest object.

  Fields:
    locationsId: A string attribute.
    projectsId: A string attribute.
    query: Required. A query string for searching for fleets. The currently
      supported query field is `ancestor`. Use
      "ancestor=organizations/{org_id}" to search for fleets in an
      organization, and "ancestor=folders/{folder_id}" to search for fleets in
      a folder. Search expressions are case insensitive.
  """

  locationsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)
  query = _messages.StringField(3)


class GkehubProjectsLocationsGetFleetRequest(_messages.Message):
  r"""A GkehubProjectsLocationsGetFleetRequest object.

  Fields:
    name: Required. The resource name of the fleet to retrieve. Format:
      projects/{project}/locations/{location}/fleet.
  """

  name = _messages.StringField(1, required=True)


class GkehubProjectsLocationsGetRequest(_messages.Message):
  r"""A GkehubProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class GkehubProjectsLocationsListRequest(_messages.Message):
  r"""A GkehubProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkehubProjectsLocationsMembershipsCreateRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsCreateRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    membershipId: Required. Client chosen ID for the membership.
      `membership_id` must be a valid RFC 1123 compliant DNS label: 1. At most
      63 characters in length 2. It must consist of lower case alphanumeric
      characters or `-` 3. It must start and end with an alphanumeric
      character Which can be expressed as the regex:
      `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
    parent: Required. The parent (project and location) where the Memberships
      will be created. Specified in the format `projects/*/locations/*`.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  membership = _messages.MessageField('Membership', 1)
  membershipId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class GkehubProjectsLocationsMembershipsDeleteRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsDeleteRequest object.

  Fields:
    name: Required. The Membership resource name in the format
      `projects/*/locations/*/memberships/*`.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class GkehubProjectsLocationsMembershipsGenerateConnectManifestRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsGenerateConnectManifestRequest
  object.

  Fields:
    imagePullSecretContent: Optional. The image pull secret content for the
      registry, if not public.
    isUpgrade: Optional. If true, generate the resources for upgrade only.
      Some resources generated only for installation (e.g. secrets) will be
      excluded.
    name: Required. The Membership resource name the Agent will associate
      with, in the format `projects/*/locations/*/memberships/*`.
    namespace: Optional. Namespace for GKE Connect agent resources. Defaults
      to `gke-connect`. The Connect Agent is authorized automatically when run
      in the default namespace. Otherwise, explicit authorization must be
      granted with an additional IAM binding.
    proxy: Optional. URI of a proxy if connectivity from the agent to
      gkeconnect.googleapis.com requires the use of a proxy. Format must be in
      the form `http(s)://{proxy_address}`, depending on the HTTP/HTTPS
      protocol supported by the proxy. This will direct the connect agent's
      outbound traffic through a HTTP(S) proxy.
    registry: Optional. The registry to fetch the connect agent image from.
      Defaults to gcr.io/gkeconnect.
    version: Optional. The Connect agent version to use. Defaults to the most
      current version.
  """

  imagePullSecretContent = _messages.BytesField(1)
  isUpgrade = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  namespace = _messages.StringField(4)
  proxy = _messages.BytesField(5)
  registry = _messages.StringField(6)
  version = _messages.StringField(7)


class GkehubProjectsLocationsMembershipsGetIamPolicyRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkehubProjectsLocationsMembershipsGetRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsGetRequest object.

  Fields:
    name: Required. The Membership resource name in the format
      `projects/*/locations/*/memberships/*`.
  """

  name = _messages.StringField(1, required=True)


class GkehubProjectsLocationsMembershipsListRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsListRequest object.

  Fields:
    filter: Optional. Lists Memberships that match the filter expression,
      following the syntax outlined in https://google.aip.dev/160. Examples: -
      Name is `bar` in project `foo-proj` and location `global`: name =
      "projects/foo-proj/locations/global/membership/bar" - Memberships that
      have a label called `foo`: labels.foo:* - Memberships that have a label
      called `foo` whose value is `bar`: labels.foo = bar - Memberships in the
      CREATING state: state = CREATING
    orderBy: Optional. One or more fields to compare and use to sort the
      output. See https://google.aip.dev/132#ordering.
    pageSize: Optional. When requesting a 'page' of resources, `page_size`
      specifies number of resources to return. If unspecified or set to 0, all
      resources will be returned.
    pageToken: Optional. Token returned by previous call to `ListMemberships`
      which specifies the position in the list from where to continue listing
      the resources.
    parent: Required. The parent (project and location) where the Memberships
      will be listed. Specified in the format `projects/*/locations/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GkehubProjectsLocationsMembershipsPatchRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsPatchRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    name: Required. The Membership resource name in the format
      `projects/*/locations/*/memberships/*`.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Mask of fields to update.
  """

  membership = _messages.MessageField('Membership', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class GkehubProjectsLocationsMembershipsSetIamPolicyRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkehubProjectsLocationsMembershipsTestIamPermissionsRequest(_messages.Message):
  r"""A GkehubProjectsLocationsMembershipsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkehubProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A GkehubProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GkehubProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A GkehubProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class GkehubProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A GkehubProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkehubProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A GkehubProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkehubProjectsLocationsUpdateFleetRequest(_messages.Message):
  r"""A GkehubProjectsLocationsUpdateFleetRequest object.

  Fields:
    fleet: A Fleet resource to be passed as the request body.
    name: Output only. The full, unique resource name of this fleet in the
      format of `projects/{project}/locations/{location}/fleet`. Each GCP
      project can have at most one fleet resource.
    updateMask: The fields to be updated;
  """

  fleet = _messages.MessageField('Fleet', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class HelloWorldFeatureSpec(_messages.Message):
  r"""**Hello World**: The Hub-wide input for the HelloWorld feature.

  Fields:
    customConfig: Custom config for the HelloWorld controller codelab. This
      should be a textpb string.
    featureTest: Message to hold fields to use in feature e2e create/mutate
      testing.
  """

  customConfig = _messages.StringField(1)
  featureTest = _messages.MessageField('HelloWorldFeatureTest', 2)


class HelloWorldFeatureState(_messages.Message):
  r"""**Hello World**: An empty state left as an example Hub-wide Feature
  state.
  """



class HelloWorldFeatureTest(_messages.Message):
  r"""Represents message used in feature e2e create/mutate testing.

  Enums:
    ThirdValueValuesEnum:

  Messages:
    FifthValue: A FifthValue object.
    NinthValue: Map field.

  Fields:
    eighth: Repeated field.
    fifth: A FifthValue attribute.
    first: Singular scaler field.
    fourth: Singular Message fields.
    ninth: Map field.
    second: Singular scaler field.
    seventh: A string attribute.
    sixth: A string attribute.
    third: A ThirdValueValuesEnum attribute.
  """

  class ThirdValueValuesEnum(_messages.Enum):
    r"""ThirdValueValuesEnum enum type.

    Values:
      BAR_UNSPECIFIED: <no description>
      FIRST: <no description>
      SECOND: <no description>
    """
    BAR_UNSPECIFIED = 0
    FIRST = 1
    SECOND = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FifthValue(_messages.Message):
    r"""A FifthValue object.

    Messages:
      AdditionalProperty: An additional property for a FifthValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FifthValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NinthValue(_messages.Message):
    r"""Map field.

    Messages:
      AdditionalProperty: An additional property for a NinthValue object.

    Fields:
      additionalProperties: Additional properties of type NinthValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NinthValue object.

      Fields:
        key: Name of the additional property.
        value: A HelloWorldFooBar attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('HelloWorldFooBar', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  eighth = _messages.MessageField('HelloWorldFooBar', 1, repeated=True)
  fifth = _messages.MessageField('FifthValue', 2)
  first = _messages.StringField(3)
  fourth = _messages.StringField(4)
  ninth = _messages.MessageField('NinthValue', 5)
  second = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  seventh = _messages.StringField(7)
  sixth = _messages.IntegerField(8)
  third = _messages.EnumField('ThirdValueValuesEnum', 9)


class HelloWorldFooBar(_messages.Message):
  r"""Nested Message.

  Fields:
    first: A string attribute.
    second: A integer attribute.
  """

  first = _messages.StringField(1)
  second = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class HelloWorldMembershipSpec(_messages.Message):
  r"""**Hello World**: The membership-specific input for HelloWorld feature.

  Fields:
    customConfig: Custom config for individual memberships. This should be a
      textpb string.
    featureTest: Message to hold fields to use in feature e2e create/mutate
      testing.
  """

  customConfig = _messages.StringField(1)
  featureTest = _messages.MessageField('HelloWorldFeatureTest', 2)


class HelloWorldMembershipState(_messages.Message):
  r"""**Hello World**: An empty state left as an example membership-specific
  Feature state.
  """



class IdentityServiceAuthMethod(_messages.Message):
  r"""Configuration of an auth method for a member/cluster. Only one
  authentication method (e.g., OIDC and LDAP) can be set per AuthMethod.

  Fields:
    name: Identifier for auth config.
    oidcConfig: OIDC specific configuration.
    proxy: Proxy server address to use for auth method.
  """

  name = _messages.StringField(1)
  oidcConfig = _messages.MessageField('IdentityServiceOidcConfig', 2)
  proxy = _messages.StringField(3)


class IdentityServiceMembershipSpec(_messages.Message):
  r"""**Anthos Identity Service**: Configuration for a single Membership.

  Fields:
    authMethods: A member may support multiple auth methods.
  """

  authMethods = _messages.MessageField('IdentityServiceAuthMethod', 1, repeated=True)


class IdentityServiceMembershipState(_messages.Message):
  r"""**Anthos Identity Service**: State for a single Membership.

  Enums:
    StateValueValuesEnum: Deployment state on this member

  Fields:
    failureReason: The reason of the failure.
    installedVersion: Installed AIS version. This is the AIS version installed
      on this member. The values makes sense iff state is OK.
    memberConfig: Last reconciled membership configuration
    state: Deployment state on this member
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Deployment state on this member

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Unspecified state
      OK: deployment succeeds
      ERROR: Failure with error.
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    OK = 1
    ERROR = 2

  failureReason = _messages.StringField(1)
  installedVersion = _messages.StringField(2)
  memberConfig = _messages.MessageField('IdentityServiceMembershipSpec', 3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class IdentityServiceOidcConfig(_messages.Message):
  r"""Configuration for OIDC Auth flow.

  Fields:
    certificateAuthorityData: PEM-encoded CA for OIDC provider.
    clientId: ID for OIDC client application.
    deployCloudConsoleProxy: Flag to denote if reverse proxy is used to
      connect to auth provider. This flag should be set to true when provider
      is not reachable by Google Cloud Console.
    extraParams: Comma-separated list of key-value pairs.
    groupPrefix: Prefix to prepend to group name.
    groupsClaim: Claim in OIDC ID token that holds group information.
    issuerUri: URI for the OIDC provider. This should point to the level below
      .well-known/openid-configuration.
    kubectlRedirectUri: Registered redirect uri to redirect users going
      through OAuth flow using kubectl plugin.
    scopes: Comma-separated list of identifiers.
    userClaim: Claim in OIDC ID token that holds username.
    userPrefix: Prefix to prepend to user name.
  """

  certificateAuthorityData = _messages.StringField(1)
  clientId = _messages.StringField(2)
  deployCloudConsoleProxy = _messages.BooleanField(3)
  extraParams = _messages.StringField(4)
  groupPrefix = _messages.StringField(5)
  groupsClaim = _messages.StringField(6)
  issuerUri = _messages.StringField(7)
  kubectlRedirectUri = _messages.StringField(8)
  scopes = _messages.StringField(9)
  userClaim = _messages.StringField(10)
  userPrefix = _messages.StringField(11)


class KubernetesMetadata(_messages.Message):
  r"""KubernetesMetadata provides informational metadata for Memberships
  representing Kubernetes clusters.

  Fields:
    kubernetesApiServerVersion: Output only. Kubernetes API server version
      string as reported by `/version`.
    memoryMb: Output only. The total memory capacity as reported by the sum of
      all Kubernetes nodes resources, defined in MB.
    nodeCount: Output only. Node count as reported by Kubernetes nodes
      resources.
    nodeProviderId: Output only. Node providerID as reported by the first node
      in the list of nodes on the Kubernetes endpoint. On Kubernetes platforms
      that support zero-node clusters (like GKE-on-GCP), the node_count will
      be zero and the node_provider_id will be empty.
    updateTime: Output only. The time at which these details were last
      updated. This update_time is different from the Membership-level
      update_time since EndpointDetails are updated internally for API
      consumers.
    vcpuCount: Output only. vCPU count as reported by Kubernetes nodes
      resources.
  """

  kubernetesApiServerVersion = _messages.StringField(1)
  memoryMb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  nodeProviderId = _messages.StringField(4)
  updateTime = _messages.StringField(5)
  vcpuCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class KubernetesResource(_messages.Message):
  r"""KubernetesResource contains the YAML manifests and configuration for
  Membership Kubernetes resources in the cluster. After CreateMembership or
  UpdateMembership, these resources should be re-applied in the cluster.

  Fields:
    connectResources: Output only. The Kubernetes resources for installing the
      GKE Connect agent This field is only populated in the Membership
      returned from a successful long-running operation from CreateMembership
      or UpdateMembership. It is not populated during normal GetMembership or
      ListMemberships requests. To get the resource manifest after the initial
      registration, the caller should make a UpdateMembership call with an
      empty field mask.
    membershipCrManifest: Input only. The YAML representation of the
      Membership CR. This field is ignored for GKE clusters where Hub can read
      the CR directly. Callers should provide the CR that is currently present
      in the cluster during CreateMembership or UpdateMembership, or leave
      this field empty if none exists. The CR manifest is used to validate the
      cluster has not been registered with another Membership.
    membershipResources: Output only. Additional Kubernetes resources that
      need to be applied to the cluster after Membership creation, and after
      every update. This field is only populated in the Membership returned
      from a successful long-running operation from CreateMembership or
      UpdateMembership. It is not populated during normal GetMembership or
      ListMemberships requests. To get the resource manifest after the initial
      registration, the caller should make a UpdateMembership call with an
      empty field mask.
    resourceOptions: Optional. Options for Kubernetes resource generation.
  """

  connectResources = _messages.MessageField('ResourceManifest', 1, repeated=True)
  membershipCrManifest = _messages.StringField(2)
  membershipResources = _messages.MessageField('ResourceManifest', 3, repeated=True)
  resourceOptions = _messages.MessageField('ResourceOptions', 4)


class ListFeaturesResponse(_messages.Message):
  r"""Response message for the `GkeHub.ListFeatures` method.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      `ListFeatures` method. The value of an empty string means that there are
      no more resources to return.
    resources: The list of matching Features
  """

  nextPageToken = _messages.StringField(1)
  resources = _messages.MessageField('Feature', 2, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMembershipsResponse(_messages.Message):
  r"""Response message for the `GkeHub.ListMemberships` method.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      `ListMemberships` method. The value of an empty string means that there
      are no more resources to return.
    resources: The list of matching Memberships.
    unreachable: List of locations that could not be reached while fetching
      this list.
  """

  nextPageToken = _messages.StringField(1)
  resources = _messages.MessageField('Membership', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Membership(_messages.Message):
  r"""Membership contains information about a member cluster.

  Enums:
    InfrastructureTypeValueValuesEnum: Optional. The infrastructure type this
      Membership is running on.

  Messages:
    LabelsValue: Optional. GCP labels for this membership.

  Fields:
    authority: Optional. How to identify workloads from this Membership. See
      the documentation on Workload Identity for more details:
      https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
    createTime: Output only. When the Membership was created.
    deleteTime: Output only. When the Membership was deleted.
    description: Output only. Description of this membership, limited to 63
      characters. Must match the regex: `a-zA-Z0-9*` This field is present for
      legacy purposes.
    endpoint: Optional. Endpoint information to reach this member.
    externalId: Optional. An externally-generated and managed ID for this
      Membership. This ID may be modified after creation, but this is not
      recommended. The ID must match the regex: `a-zA-Z0-9*` If this
      Membership represents a Kubernetes cluster, this value should be set to
      the UID of the `kube-system` namespace object.
    infrastructureType: Optional. The infrastructure type this Membership is
      running on.
    labels: Optional. GCP labels for this membership.
    lastConnectionTime: Output only. For clusters using Connect, the timestamp
      of the most recent connection established with Google Cloud. This time
      is updated every several minutes, not continuously. For clusters that do
      not use GKE Connect, or that have never connected successfully, this
      field will be unset.
    name: Output only. The full, unique name of this Membership resource in
      the format `projects/*/locations/*/memberships/{membership_id}`, set
      during creation. `membership_id` must be a valid RFC 1123 compliant DNS
      label: 1. At most 63 characters in length 2. It must consist of lower
      case alphanumeric characters or `-` 3. It must start and end with an
      alphanumeric character Which can be expressed as the regex:
      `[a-z0-9]([-a-z0-9]*[a-z0-9])?`, with a maximum length of 63 characters.
    state: Output only. State of the Membership resource.
    uniqueId: Output only. Google-generated UUID for this resource. This is
      unique across all Membership resources. If a Membership resource is
      deleted and another resource with the same name is created, it gets a
      different unique_id.
    updateTime: Output only. When the Membership was last updated.
  """

  class InfrastructureTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The infrastructure type this Membership is running on.

    Values:
      INFRASTRUCTURE_TYPE_UNSPECIFIED: No type was specified. Some Hub
        functionality may require a type be specified, and will not support
        Memberships with this value.
      ON_PREM: Private infrastructure that is owned or operated by customer.
        This includes GKE distributions such as GKE-OnPrem and GKE-
        OnBareMetal.
      MULTI_CLOUD: Public cloud infrastructure.
    """
    INFRASTRUCTURE_TYPE_UNSPECIFIED = 0
    ON_PREM = 1
    MULTI_CLOUD = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. GCP labels for this membership.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  authority = _messages.MessageField('Authority', 1)
  createTime = _messages.StringField(2)
  deleteTime = _messages.StringField(3)
  description = _messages.StringField(4)
  endpoint = _messages.MessageField('MembershipEndpoint', 5)
  externalId = _messages.StringField(6)
  infrastructureType = _messages.EnumField('InfrastructureTypeValueValuesEnum', 7)
  labels = _messages.MessageField('LabelsValue', 8)
  lastConnectionTime = _messages.StringField(9)
  name = _messages.StringField(10)
  state = _messages.MessageField('MembershipState', 11)
  uniqueId = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class MembershipEndpoint(_messages.Message):
  r"""MembershipEndpoint contains information needed to contact a Kubernetes
  API, endpoint and any additional Kubernetes metadata.

  Fields:
    gkeCluster: Optional. GKE-specific information. Only present if this
      Membership is a GKE cluster.
    kubernetesMetadata: Output only. Useful Kubernetes-specific metadata.
    kubernetesResource: Optional. The in-cluster Kubernetes Resources that
      should be applied for a correctly registered cluster, in the steady
      state. These resources: * Ensure that the cluster is exclusively
      registered to one and only one Hub Membership. * Propagate Workload Pool
      Information available in the Membership Authority field. * Ensure proper
      initial configuration of default Hub Features.
  """

  gkeCluster = _messages.MessageField('GkeCluster', 1)
  kubernetesMetadata = _messages.MessageField('KubernetesMetadata', 2)
  kubernetesResource = _messages.MessageField('KubernetesResource', 3)


class MembershipFeatureSpec(_messages.Message):
  r"""MembershipFeatureSpec contains configuration information for a single
  Membership.

  Fields:
    apigee: Apigee-specific spec.
    configmanagement: Config Management-specific spec.
    helloworld: Hello World-specific spec.
    identityservice: Identity Service-specific spec.
  """

  apigee = _messages.MessageField('ApigeeMembershipSpec', 1)
  configmanagement = _messages.MessageField('ConfigManagementMembershipSpec', 2)
  helloworld = _messages.MessageField('HelloWorldMembershipSpec', 3)
  identityservice = _messages.MessageField('IdentityServiceMembershipSpec', 4)


class MembershipFeatureState(_messages.Message):
  r"""MembershipFeatureState contains Feature status information for a single
  Membership.

  Fields:
    configmanagement: Config Management-specific state.
    helloworld: Hello World-specific state.
    identityservice: Identity Service-specific state.
    metering: Metering-specific spec.
    servicemesh: Service Mesh-specific state.
    state: The high-level state of this Feature for a single membership.
  """

  configmanagement = _messages.MessageField('ConfigManagementMembershipState', 1)
  helloworld = _messages.MessageField('HelloWorldMembershipState', 2)
  identityservice = _messages.MessageField('IdentityServiceMembershipState', 3)
  metering = _messages.MessageField('MeteringMembershipState', 4)
  servicemesh = _messages.MessageField('ServiceMeshMembershipState', 5)
  state = _messages.MessageField('FeatureState', 6)


class MembershipState(_messages.Message):
  r"""MembershipState describes the state of a Membership resource.

  Enums:
    CodeValueValuesEnum: Output only. The current state of the Membership
      resource.

  Fields:
    code: Output only. The current state of the Membership resource.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the Membership resource.

    Values:
      CODE_UNSPECIFIED: The code is not set.
      CREATING: The cluster is being registered.
      READY: The cluster is registered.
      DELETING: The cluster is being unregistered.
      UPDATING: The Membership is being updated.
      SERVICE_UPDATING: The Membership is being updated by the Hub Service.
    """
    CODE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3
    UPDATING = 4
    SERVICE_UPDATING = 5

  code = _messages.EnumField('CodeValueValuesEnum', 1)


class MeteringMembershipState(_messages.Message):
  r"""**Metering**: Per-Membership Feature State.

  Fields:
    lastMeasurementTime: The time stamp of the most recent measurement of the
      number of vCPUs in the cluster.
    preciseLastMeasuredClusterVcpuCapacity: The vCPUs capacity in the cluster
      according to the most recent measurement (1/1000 precision).
  """

  lastMeasurementTime = _messages.StringField(1)
  preciseLastMeasuredClusterVcpuCapacity = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class MultiClusterIngressFeatureSpec(_messages.Message):
  r"""**Multi-cluster Ingress**: The configuration for the MultiClusterIngress
  feature.

  Enums:
    BillingValueValuesEnum: Deprecated: This field will be ignored and should
      not be set. Customer's billing structure.

  Fields:
    billing: Deprecated: This field will be ignored and should not be set.
      Customer's billing structure.
    configMembership: Fully-qualified Membership name which hosts the
      MultiClusterIngress CRD. Example: `projects/foo-
      proj/locations/global/memberships/bar`
  """

  class BillingValueValuesEnum(_messages.Enum):
    r"""Deprecated: This field will be ignored and should not be set.
    Customer's billing structure.

    Values:
      BILLING_UNSPECIFIED: Unknown
      PAY_AS_YOU_GO: User pays a fee per-endpoint.
      ANTHOS_LICENSE: User is paying for Anthos as a whole.
    """
    BILLING_UNSPECIFIED = 0
    PAY_AS_YOU_GO = 1
    ANTHOS_LICENSE = 2

  billing = _messages.EnumField('BillingValueValuesEnum', 1)
  configMembership = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    cancelRequested: Output only. Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    statusDetail: Output only. Human-readable status of the operation, if any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ResourceManifest(_messages.Message):
  r"""ResourceManifest represents a single Kubernetes resource to be applied
  to the cluster.

  Fields:
    clusterScoped: Whether the resource provided in the manifest is
      `cluster_scoped`. If unset, the manifest is assumed to be namespace
      scoped. This field is used for REST mapping when applying the resource
      in a cluster.
    manifest: YAML manifest of the resource.
  """

  clusterScoped = _messages.BooleanField(1)
  manifest = _messages.StringField(2)


class ResourceOptions(_messages.Message):
  r"""ResourceOptions represent options for Kubernetes resource generation.

  Fields:
    connectVersion: Optional. The Connect agent version to use for
      connect_resources. Defaults to the latest GKE Connect version. The
      version must be a currently supported version, obsolete versions will be
      rejected.
    v1beta1Crd: Optional. Use `apiextensions/v1beta1` instead of
      `apiextensions/v1` for CustomResourceDefinition resources. This option
      should be set for clusters with Kubernetes apiserver versions <1.16.
  """

  connectVersion = _messages.StringField(1)
  v1beta1Crd = _messages.BooleanField(2)


class SearchFleetsResponse(_messages.Message):
  r"""Response message for the `FleetService.SearchFleetsResponse` method.

  Fields:
    fleets: The list of matching fleets.
  """

  fleets = _messages.MessageField('Fleet', 1, repeated=True)


class ServiceMeshAnalysisMessage(_messages.Message):
  r"""AnalysisMessage is a single message produced by an analyzer, and it used
  to communicate to the end user about the state of their Service Mesh
  configuration.

  Messages:
    ArgsValue: A UI can combine these args with a template (based on
      message_base.type) to produce an internationalized message.

  Fields:
    args: A UI can combine these args with a template (based on
      message_base.type) to produce an internationalized message.
    description: A human readable description of what the error means. It is
      suitable for non-internationalize display purposes.
    messageBase: Details common to all types of Istio and ServiceMesh analysis
      messages.
    resourcePaths: A list of strings specifying the resource identifiers that
      were the cause of message generation. A "path" here may be: *
      MEMBERSHIP_ID if the cause is a specific member cluster *
      MEMBERSHIP_ID/(NAMESPACE\/)?RESOURCETYPE/NAME if the cause is a resource
      in a cluster
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ArgsValue(_messages.Message):
    r"""A UI can combine these args with a template (based on
    message_base.type) to produce an internationalized message.

    Messages:
      AdditionalProperty: An additional property for a ArgsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ArgsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  args = _messages.MessageField('ArgsValue', 1)
  description = _messages.StringField(2)
  messageBase = _messages.MessageField('ServiceMeshAnalysisMessageBase', 3)
  resourcePaths = _messages.StringField(4, repeated=True)


class ServiceMeshAnalysisMessageBase(_messages.Message):
  r"""AnalysisMessageBase describes some common information that is needed for
  all messages.

  Enums:
    LevelValueValuesEnum: Represents how severe a message is.

  Fields:
    documentationUrl: A url pointing to the Service Mesh or Istio
      documentation for this specific error type.
    level: Represents how severe a message is.
    type: Represents the specific type of a message.
  """

  class LevelValueValuesEnum(_messages.Enum):
    r"""Represents how severe a message is.

    Values:
      LEVEL_UNSPECIFIED: Illegal. Same
        istio.analysis.v1alpha1.AnalysisMessageBase.Level.UNKNOWN.
      ERROR: ERROR represents a misconfiguration that must be fixed.
      WARNING: WARNING represents a misconfiguration that should be fixed.
      INFO: INFO represents an informational finding.
    """
    LEVEL_UNSPECIFIED = 0
    ERROR = 1
    WARNING = 2
    INFO = 3

  documentationUrl = _messages.StringField(1)
  level = _messages.EnumField('LevelValueValuesEnum', 2)
  type = _messages.MessageField('ServiceMeshType', 3)


class ServiceMeshFeatureState(_messages.Message):
  r"""**Service Mesh**: State for the whole Hub, as analyzed by the Service
  Mesh Hub Controller.

  Fields:
    analysisMessages: Output only. Results of running Service Mesh analyzers.
  """

  analysisMessages = _messages.MessageField('ServiceMeshAnalysisMessage', 1, repeated=True)


class ServiceMeshMembershipState(_messages.Message):
  r"""**Service Mesh**: State for a single Membership, as analyzed by the
  Service Mesh Hub Controller.

  Fields:
    analysisMessages: Output only. Results of running Service Mesh analyzers.
  """

  analysisMessages = _messages.MessageField('ServiceMeshAnalysisMessage', 1, repeated=True)


class ServiceMeshType(_messages.Message):
  r"""A unique identifier for the type of message. Display_name is intended to
  be human-readable, code is intended to be machine readable. There should be
  a one-to-one mapping between display_name and code. (i.e. do not re-use
  display_names or codes between message types.) See
  istio.analysis.v1alpha1.AnalysisMessageBase.Type

  Fields:
    code: A 7 character code matching `^IST[0-9]{4}$` or `^ASM[0-9]{4}$`,
      intended to uniquely identify the message type. (e.g. "IST0001" is
      mapped to the "InternalError" message type.)
    displayName: A human-readable name for the message type. e.g.
      "InternalError", "PodMissingProxy". This should be the same for all
      messages of the same type. (This corresponds to the `name` field in
      open-source Istio.)
  """

  code = _messages.StringField(1)
  displayName = _messages.StringField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TypeMeta(_messages.Message):
  r"""TypeMeta is the type information needed for content unmarshalling of
  Kubernetes resources in the manifest.

  Fields:
    apiVersion: APIVersion of the resource (e.g. v1).
    kind: Kind of the resource (e.g. Deployment).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
