"""Generated message classes for mediaasset version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'mediaasset'


class Action(_messages.Message):
  r"""An action resource. Action is a read-only resource and is nested under
  an asset. It contains the status of the actions associated with an Asset.

  Messages:
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.

  Fields:
    assetTransformation: Status of asset transformation, if this action is for
      asset transformation.
    createTime: The creation time.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    name: Required. The resource name of the action, in the following form: `p
      rojects/{project}/locations/{location}/assetTypes/{type}/assets/{asset}/
      actions/{action}`.
    rule: The resource name of the rule, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}/rule/{rule}`.
    updateTime: The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assetTransformation = _messages.MessageField('TransformationStatus', 1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  rule = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class Annotation(_messages.Message):
  r"""An annotation resource is associated with an AnnotationSet and
  represents timed-metadata that can be modified and searched at a high
  throughput.

  Messages:
    DataValue: Required. Data held by the annotation.
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.

  Fields:
    createTime: Output only. The creation time of the annotation.
    data: Required. Data held by the annotation.
    etag: Etag of the resource used in output and update requests.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    name: Output only. An automatically-generated resource name of the
      annotation `projects/{project}/locations/{location}/assetTypes/{asset_ty
      pe}/assets/{asset}/annotationSets/{annotation_set}/annotations/{annotati
      on}`.
    updateTime: Output only. The latest update time of the annotation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""Required. Data held by the annotation.

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  data = _messages.MessageField('DataValue', 2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class AnnotationSet(_messages.Message):
  r"""An annotationSet resource is associated with an Asset and is a
  collection of timed-metadata that can be modified and searched at a high
  throughput.

  Messages:
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.

  Fields:
    createTime: Output only. The creation time of the annotationSet.
    etag: Etag of the resource used in output and update requests.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    name: A user-specified resource name of the annotationSet `projects/{proje
      ct}/locations/{location}/assetTypes/{asset_type}/assets/{asset}/annotati
      onSets/{annotation_set}`.
    updateTime: Output only. The latest update time of the annotationSet.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class AnnotationSetConfig(_messages.Message):
  r"""Configuration of an annotationSet.

  Messages:
    IndexedFieldConfigsValue: List of indexed fields (e.g. "data.start") to
      make available in searches with their corresponding properties.

  Fields:
    complexType: Reference to the complex type name, in the following form:
      `projects/{project}/locations/{location}/complexTypes/{name}`.
    indexedFieldConfigs: List of indexed fields (e.g. "data.start") to make
      available in searches with their corresponding properties.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class IndexedFieldConfigsValue(_messages.Message):
    r"""List of indexed fields (e.g. "data.start") to make available in
    searches with their corresponding properties.

    Messages:
      AdditionalProperty: An additional property for a
        IndexedFieldConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type
        IndexedFieldConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a IndexedFieldConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A IndexedFieldConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('IndexedFieldConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  complexType = _messages.StringField(1)
  indexedFieldConfigs = _messages.MessageField('IndexedFieldConfigsValue', 2)


class Asset(_messages.Message):
  r"""An asset resource. An asset is a core resource that represents a media
  entity. An Asset has an asset type associated with it which specifies the
  schema of the asset.

  Enums:
    StateValueValuesEnum: State of the asset

  Messages:
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.
    LinkSetsValue: Named collections of Link Sets, each having qualified
      links.
    LinksValue: Links to other assets.
    MetadataValue: List of metadata for this asset.
    MetadataInfoValue: Information about the metadata fields.

  Fields:
    createTime: The creation time.
    etag: Etag of the resource used in output and update requests.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    linkSets: Named collections of Link Sets, each having qualified links.
    links: Links to other assets.
    metadata: List of metadata for this asset.
    metadataInfo: Information about the metadata fields.
    name: The resource name of the asset, in the following form: `projects/{pr
      oject}/locations/{location}/assetTypes/{type}/assets/{asset}`.
    state: State of the asset
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the asset

    Values:
      STATE_UNSPECIFIED: STATE_UNSPECIFIED maps with UNKNOWN or CREATING in
        AssetStatus_State in status.proto
      ACTIVE: ACTIVE maps with READY in AssetStatus_State in status.proto
      DELETING: DELETING maps with DELETING in AssetStatus_State in
        status.proto
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DELETING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LinkSetsValue(_messages.Message):
    r"""Named collections of Link Sets, each having qualified links.

    Messages:
      AdditionalProperty: An additional property for a LinkSetsValue object.

    Fields:
      additionalProperties: Additional properties of type LinkSetsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LinkSetsValue object.

      Fields:
        key: Name of the additional property.
        value: A LinkSet attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('LinkSet', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LinksValue(_messages.Message):
    r"""Links to other assets.

    Messages:
      AdditionalProperty: An additional property for a LinksValue object.

    Fields:
      additionalProperties: Additional properties of type LinksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LinksValue object.

      Fields:
        key: Name of the additional property.
        value: A Asset attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Asset', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataInfoValue(_messages.Message):
    r"""Information about the metadata fields.

    Messages:
      AdditionalProperty: An additional property for a MetadataInfoValue
        object.

    Fields:
      additionalProperties: Additional properties of type MetadataInfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A MetadataInfo attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('MetadataInfo', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""List of metadata for this asset.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Messages:
        ValueValue: A ValueValue object.

      Fields:
        key: Name of the additional property.
        value: A ValueValue attribute.
      """

      @encoding.MapUnrecognizedFields('additionalProperties')
      class ValueValue(_messages.Message):
        r"""A ValueValue object.

        Messages:
          AdditionalProperty: An additional property for a ValueValue object.

        Fields:
          additionalProperties: Properties of the object.
        """

        class AdditionalProperty(_messages.Message):
          r"""An additional property for a ValueValue object.

          Fields:
            key: Name of the additional property.
            value: A extra_types.JsonValue attribute.
          """

          key = _messages.StringField(1)
          value = _messages.MessageField('extra_types.JsonValue', 2)

        additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

      key = _messages.StringField(1)
      value = _messages.MessageField('ValueValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  linkSets = _messages.MessageField('LinkSetsValue', 4)
  links = _messages.MessageField('LinksValue', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  metadataInfo = _messages.MessageField('MetadataInfoValue', 7)
  name = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)


class AssetTransformation(_messages.Message):
  r"""An asset transformation resource. Asset transformation is a read-only
  resource and is nested under an asset. It contains the status of the
  transformations associated with an Asset. Each field contains the current
  status of transformation execution, last invocation time and any error
  information for the last execution.

  Enums:
    StateValueValuesEnum: State of the asset transformation.

  Messages:
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.

  Fields:
    createTime: The creation time.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    lastRunStatus: Status of the last asset transformation run.
    lastRunTime: Time at which the asset transformation was last run.
    name: The resource name of the asset transformation, in the following
      form: `projects/{project}/locations/{location}/assetTypes/{type}/assets/
      {asset}/transformations/{transformation}`.
    state: State of the asset transformation.
    updateTime: The last-modified time.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the asset transformation.

    Values:
      STATE_UNKNOWN: <no description>
      QUEUED: <no description>
      RUNNING: <no description>
      COMPLETED: <no description>
    """
    STATE_UNKNOWN = 0
    QUEUED = 1
    RUNNING = 2
    COMPLETED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  lastRunStatus = _messages.MessageField('Status', 3)
  lastRunTime = _messages.StringField(4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class AssetType(_messages.Message):
  r"""An asset type resource. An asset type defines the schema for the
  assets.It specifies configuration of all the fields present on the asset.

  Messages:
    AnnotationSetConfigsValue: Mapping of annotationSet name to its
      configuration.
    IndexedFieldConfigsValue: List of indexed fields (e.g.
      "metadata.file.url") to make available in searches with their
      corresponding properties.
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.
    LinkConfigsValue: Mapping of a link field name to its configuration.
    LinkSetConfigsValue: Mapping of a collection of link sets to the set
      configuration.
    MetadataConfigsValue: Mapping of field name to its configuration.
    TransformationConfigsValue: Mapping of a transformation name to its
      configuration.

  Fields:
    annotationSetConfigs: Mapping of annotationSet name to its configuration.
    createTime: The creation time.
    indexedFieldConfigs: List of indexed fields (e.g. "metadata.file.url") to
      make available in searches with their corresponding properties.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    linkConfigs: Mapping of a link field name to its configuration.
    linkSetConfigs: Mapping of a collection of link sets to the set
      configuration.
    metadataConfigs: Mapping of field name to its configuration.
    name: The resource name of the asset type, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}`.
    sortOrder: Specifies sort order for all assets of the type. If not
      specified, assets are sorted in reverse create_time order (newest
      first).
    transformationConfigs: Mapping of a transformation name to its
      configuration.
    updateTime: The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationSetConfigsValue(_messages.Message):
    r"""Mapping of annotationSet name to its configuration.

    Messages:
      AdditionalProperty: An additional property for a
        AnnotationSetConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AnnotationSetConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationSetConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A AnnotationSetConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AnnotationSetConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class IndexedFieldConfigsValue(_messages.Message):
    r"""List of indexed fields (e.g. "metadata.file.url") to make available in
    searches with their corresponding properties.

    Messages:
      AdditionalProperty: An additional property for a
        IndexedFieldConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type
        IndexedFieldConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a IndexedFieldConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A IndexedFieldConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('IndexedFieldConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LinkConfigsValue(_messages.Message):
    r"""Mapping of a link field name to its configuration.

    Messages:
      AdditionalProperty: An additional property for a LinkConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type LinkConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LinkConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A LinkConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('LinkConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LinkSetConfigsValue(_messages.Message):
    r"""Mapping of a collection of link sets to the set configuration.

    Messages:
      AdditionalProperty: An additional property for a LinkSetConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type LinkSetConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LinkSetConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A LinkSetConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('LinkSetConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataConfigsValue(_messages.Message):
    r"""Mapping of field name to its configuration.

    Messages:
      AdditionalProperty: An additional property for a MetadataConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MetadataConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A MetadataConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('MetadataConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TransformationConfigsValue(_messages.Message):
    r"""Mapping of a transformation name to its configuration.

    Messages:
      AdditionalProperty: An additional property for a
        TransformationConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type
        TransformationConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TransformationConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A TransformationConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TransformationConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationSetConfigs = _messages.MessageField('AnnotationSetConfigsValue', 1)
  createTime = _messages.StringField(2)
  indexedFieldConfigs = _messages.MessageField('IndexedFieldConfigsValue', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  linkConfigs = _messages.MessageField('LinkConfigsValue', 5)
  linkSetConfigs = _messages.MessageField('LinkSetConfigsValue', 6)
  metadataConfigs = _messages.MessageField('MetadataConfigsValue', 7)
  name = _messages.StringField(8)
  sortOrder = _messages.MessageField('SortOrderConfig', 9)
  transformationConfigs = _messages.MessageField('TransformationConfigsValue', 10)
  updateTime = _messages.StringField(11)


class AuthorizationLoggingOptions(_messages.Message):
  r"""Authorization-related information used by Cloud Audit Logging.

  Enums:
    PermissionTypeValueValuesEnum: The type of the permission that was
      checked.

  Fields:
    permissionType: The type of the permission that was checked.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the permission that was checked.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: A read of admin (meta) data.
      ADMIN_WRITE: A write of admin (meta) data.
      DATA_READ: A read of standard data.
      DATA_WRITE: A write of standard data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class CancelActionRequest(_messages.Message):
  r"""Request message for ActionsService.CancelAction."""


class CancelActionResponse(_messages.Message):
  r"""Response message of ActionsService.CancelAction."""


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudPubSubNotificationConfig(_messages.Message):
  r"""A CloudPubSubNotificationConfig configure Pub/Sub support for an
  AssetType that this Rule attached to.

  Fields:
    pubsubTopic: Required. A Pub/Sub topic to which messages are sent by GCMA.
      https://cloud.google.com/pubsub/docs/overview
  """

  pubsubTopic = _messages.StringField(1)


class ComplexFieldAllowedValues(_messages.Message):
  r"""A ComplexFieldAllowedValues object.

  Fields:
    values: A extra_types.JsonValue attribute.
  """

  values = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)


class ComplexFieldType(_messages.Message):
  r"""A ComplexFieldType object.

  Fields:
    allowedValues: If present, metadata values of ComplexFieldType must be
      within the constraints of allowedValues.
    required: If true, a value of this complex type must contain this field.
    type: Type for this field. The type could be one of: - Primitive types
      ("string", "number", "bool") - Custom complex type. Format:
      "p/p/l/l/complexTypes/*" - Collections of the above - list(), dict()
  """

  allowedValues = _messages.MessageField('ComplexFieldAllowedValues', 1)
  required = _messages.BooleanField(2)
  type = _messages.StringField(3)


class ComplexType(_messages.Message):
  r"""A complex type resource. A complex type describes the schema for asset
  metadata.

  Messages:
    FieldsValue: Mapping of a field name to its type.
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.

  Fields:
    allowUndefinedFields: Allow fields that aren't in complex type schema.
    createTime: The creation time.
    fields: Mapping of a field name to its type.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    name: The resource name of the complex type, in the following form:
      `projects/{project}/locations/{location}/complexTypes/{type}`.
    updateTime: The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Mapping of a field name to its type.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A ComplexFieldType attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ComplexFieldType', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allowUndefinedFields = _messages.BooleanField(1)
  createTime = _messages.StringField(2)
  fields = _messages.MessageField('FieldsValue', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    ignoreChildExemptions: A boolean attribute.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  ignoreChildExemptions = _messages.BooleanField(2)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 3)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    bindingId: A string attribute.
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  bindingId = _messages.StringField(1)
  condition = _messages.MessageField('Expr', 2)
  members = _messages.StringField(3, repeated=True)
  role = _messages.StringField(4)


class GoogleIamV1Condition(_messages.Message):
  r"""A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    values: The objects of the condition.
  """

  class IamValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      SECURITY_REALM: Any of the security realms in the IAMContext
        (go/security-realms). When used with IN, the condition indicates "any
        of the request's realms match one of the given values; with NOT_IN,
        "none of the realms match any of the given values". Note that a value
        can be: - 'self' (i.e., allow connections from clients that are in the
        same security realm) - 'self:metro' (i.e., clients that are in the
        same metro) - 'self:cloud-region' (i.e., allow connections from
        clients that are in the same cloud region) - 'guardians' (i.e., allow
        connections from its guardian realms. See go/security-realms-
        glossary#guardian for more information.) - a realm (e.g., 'campus-
        abc') - a realm group (e.g., 'realms-for-borg-cell-xx', see: go/realm-
        groups) A match is determined by a realm group membership check
        performed by a RealmAclRep object (go/realm-acl-howto). It is not
        permitted to grant access based on the *absence* of a realm, so realm
        conditions can only be used in a "positive" context (e.g., ALLOW/IN or
        DENY/NOT_IN).
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        security.credentials.JustificationType, e.g. "MANUAL_STRING". It is
        not permitted to grant access based on the *absence* of a
        justification, so justification conditions can only be used in a
        "positive" context (e.g., ALLOW/IN or DENY/NOT_IN). Multiple
        justifications, e.g., a Buganizer ID and a manually-entered reason,
        are normal and supported.
      CREDENTIALS_TYPE: What type of credentials have been supplied with this
        request. String values should match enum names from
        security_loas_l2.CredentialsType - currently, only
        CREDS_TYPE_EMERGENCY is supported. It is not permitted to grant access
        based on the *absence* of a credentials type, so the conditions can
        only be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
      CREDS_ASSERTION: EXPERIMENTAL -- DO NOT USE. The conditions can only be
        used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    SECURITY_REALM = 3
    APPROVER = 4
    JUSTIFICATION_TYPE = 5
    CREDENTIALS_TYPE = 6
    CREDS_ASSERTION = 7

  class OpValueValuesEnum(_messages.Enum):
    r"""An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by any service that owns resources and
    uses the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  values = _messages.StringField(5, repeated=True)


class GoogleIamV1LogConfig(_messages.Message):
  r"""Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('GoogleIamV1LogConfigCloudAuditOptions', 1)
  counter = _messages.MessageField('GoogleIamV1LogConfigCounterOptions', 2)
  dataAccess = _messages.MessageField('GoogleIamV1LogConfigDataAccessOptions', 3)


class GoogleIamV1LogConfigCloudAuditOptions(_messages.Message):
  r"""Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.

  Fields:
    authorizationLoggingOptions: Information used by the Cloud Audit Logging
      pipeline.
    logName: The log_name to populate in the Cloud Audit Record.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    r"""The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  authorizationLoggingOptions = _messages.MessageField('AuthorizationLoggingOptions', 1)
  logName = _messages.EnumField('LogNameValueValuesEnum', 2)


class GoogleIamV1LogConfigCounterOptions(_messages.Message):
  r"""Increment a streamz counter with the specified metric and field names.
  Metric names should start with a '/', generally be lowercase-only, and end
  in "_count". Field names should not contain an initial slash. The actual
  exported metric names will have "/iam/policy" prepended. Field names
  correspond to IAM request parameters and field values are their respective
  values. Supported field names: - "authority", which is "[token]" if
  IAMContext.token is present, otherwise the value of
  IAMContext.authority_selector if present, and otherwise a representation of
  IAMContext.principal; or - "iam_principal", a representation of
  IAMContext.principal even if a token or authority selector is present; or -
  "" (empty string), resulting in a counter with no fields. Examples: counter
  { metric: "/debug_access_count" field: "iam_principal" } ==> increment
  counter /iam/policy/debug_access_count {iam_principal=[value of
  IAMContext.principal]}

  Fields:
    customFields: Custom fields.
    field: The field value to attribute.
    metric: The metric to update.
  """

  customFields = _messages.MessageField('GoogleIamV1LogConfigCounterOptionsCustomField', 1, repeated=True)
  field = _messages.StringField(2)
  metric = _messages.StringField(3)


class GoogleIamV1LogConfigCounterOptionsCustomField(_messages.Message):
  r"""Custom fields. These can be used to create a counter with arbitrary
  field/value pairs. See: go/rpcsp-custom-fields.

  Fields:
    name: Name is the field name.
    value: Value is the field value. It is important that in contrast to the
      CounterOptions.field, the value here is a constant that is not derived
      from the IAMContext.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleIamV1LogConfigDataAccessOptions(_messages.Message):
  r"""Write a Data Access (Gin) log

  Enums:
    LogModeValueValuesEnum:

  Fields:
    logMode: A LogModeValueValuesEnum attribute.
  """

  class LogModeValueValuesEnum(_messages.Enum):
    r"""LogModeValueValuesEnum enum type.

    Values:
      LOG_MODE_UNSPECIFIED: Client is not required to write a partial Gin log
        immediately after the authorization check. If client chooses to write
        one and it fails, client may either fail open (allow the operation to
        continue) or fail closed (handle as a DENY outcome).
      LOG_FAIL_CLOSED: The application's operation in the context of which
        this authorization check is being made may only be performed if it is
        successfully logged to Gin. For instance, the authorization library
        may satisfy this obligation by emitting a partial log entry at
        authorization check time and only returning ALLOW to the application
        if it succeeds. If a matching Rule has this directive, but the client
        has not indicated that it will honor such requirements, then the IAM
        check will result in authorization failure by setting
        CheckPolicyResponse.success=false.
    """
    LOG_MODE_UNSPECIFIED = 0
    LOG_FAIL_CLOSED = 1

  logMode = _messages.EnumField('LogModeValueValuesEnum', 1)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging
      will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('GoogleIamV1Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class GoogleIamV1Rule(_messages.Message):
  r"""A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met. All conditions must
      pass for the rule to match.
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries can be found at in the Local IAM documentation
      (see go/local-iam#features).
    permissions: A permission is a string of form '..' (e.g.,
      'storage.buckets.list'). A value of '*' matches all permissions, and a
      verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('GoogleIamV1Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('GoogleIamV1LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)
  updateMask = _messages.StringField(2)


class GoogleIamV1TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class IndexedFieldConfig(_messages.Message):
  r"""A IndexedFieldConfig object.

  Fields:
    expression: Expression to evaluate in the context of an indexed property
      defaults to the property name.
    fullTextSearch: Enable full text search - strings only.
  """

  expression = _messages.StringField(1)
  fullTextSearch = _messages.BooleanField(2)


class LinkConfig(_messages.Message):
  r"""A LinkConfig object.

  Fields:
    assetType: Reference to the asset type name of the linked asset, in the
      following form:
      `projects/{project}/locations/{location}/assetTypes/{name}`.
    required: If true, this asset link is required during asset creation.
  """

  assetType = _messages.StringField(1)
  required = _messages.BooleanField(2)


class LinkSet(_messages.Message):
  r"""A LinkSet object.

  Messages:
    LinksValue: Mapping of a qualifier to an asset link. Asset Link Format:
      "p/p/l/l/assets/"

  Fields:
    links: Mapping of a qualifier to an asset link. Asset Link Format:
      "p/p/l/l/assets/"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LinksValue(_messages.Message):
    r"""Mapping of a qualifier to an asset link. Asset Link Format:
    "p/p/l/l/assets/"

    Messages:
      AdditionalProperty: An additional property for a LinksValue object.

    Fields:
      additionalProperties: Additional properties of type LinksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LinksValue object.

      Fields:
        key: Name of the additional property.
        value: A Asset attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Asset', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  links = _messages.MessageField('LinksValue', 1)


class LinkSetConfig(_messages.Message):
  r"""A LinkSetConfig object.

  Fields:
    assetType: Reference to the asset type name for the type of the assets in
      this set, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{name}`.
  """

  assetType = _messages.StringField(1)


class ListActionsResponse(_messages.Message):
  r"""Response message for ActionsService.ListActions.

  Fields:
    actions: The list of actions.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  actions = _messages.MessageField('Action', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAnnotationSetsResponse(_messages.Message):
  r"""Response message for AnnotationSetsService.ListAnnotationSets.

  Fields:
    annotationSets: The annotationSets from the specified asset.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  annotationSets = _messages.MessageField('AnnotationSet', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAnnotationsResponse(_messages.Message):
  r"""Response message for AnnotationsService.ListAnnotations.

  Fields:
    annotations: The annotations from the specified asset.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  annotations = _messages.MessageField('Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAssetTransformationsResponse(_messages.Message):
  r"""Response message for
  AssetTransformationsService.ListAssetTransformations.

  Fields:
    assetTransformations: The list of transformations.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  assetTransformations = _messages.MessageField('AssetTransformation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAssetTypesResponse(_messages.Message):
  r"""Response message for AssetTypesService.ListAssetTypes.

  Fields:
    assetTypes: The list of asset types.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  assetTypes = _messages.MessageField('AssetType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListAssetsResponse(_messages.Message):
  r"""Response message for AssetsService.ListAssets.

  Fields:
    assets: The list of assets.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  assets = _messages.MessageField('Asset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListComplexTypesResponse(_messages.Message):
  r"""Response message for ComplexTypesService.ListComplexTypes.

  Fields:
    complexTypes: The list of complex types.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  complexTypes = _messages.MessageField('ComplexType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRulesResponse(_messages.Message):
  r"""Response message for RulesService.ListRules.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    rules: The rules from the specified assetType.
  """

  nextPageToken = _messages.StringField(1)
  rules = _messages.MessageField('Rule', 2, repeated=True)


class ListTransformersResponse(_messages.Message):
  r"""Response message for TransformersService.ListTransformers.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    transformers: The list of transformers.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  transformers = _messages.MessageField('Transformer', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MediaassetProjectsLocationsAssetTypesAssetsActionsCancelRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsActionsCancelRequest
  object.

  Fields:
    cancelActionRequest: A CancelActionRequest resource to be passed as the
      request body.
    name: Required. The name of the action to cancel. Format: `projects/{proje
      ct}/locations/{location}/assetTypes/{type}/assets/{asset}/actions/{actio
      n}`
  """

  cancelActionRequest = _messages.MessageField('CancelActionRequest', 1)
  name = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsActionsGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsActionsGetRequest object.

  Fields:
    name: Required. The name of the action to retrieve, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}/assets/{asset
      }/actions/{action}`.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsActionsListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsActionsListRequest object.

  Fields:
    filter: The filter to apply to list results.
    orderBy: Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: The maximum number of items to return. If unspecified, server
      will pick an appropriate default. Server may return fewer items than
      requested. A caller should only rely on response's next_page_token to
      determine if there are more realms left to be queried.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. The parent resource name, in the following form: `projec
      ts/{project}/locations/{location}/assetTypes/{type}/assets/{asset}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsActionsTriggerRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsActionsTriggerRequest
  object.

  Fields:
    name: Required. The name of the action to Trigger. Format: `projects/{proj
      ect}/locations/{location}/assetTypes/{type}/assets/{asset}/actions/{acti
      on}`
    triggerActionRequest: A TriggerActionRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  triggerActionRequest = _messages.MessageField('TriggerActionRequest', 2)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsCr
  eateRequest object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    parent: Required. The parent resource where this Annotation will be
      created. Format: `projects/{project}/locations/{location}/assetTypes/{as
      set_type}/assets/{asset}/annotationSets/{annotation_set}`
  """

  annotation = _messages.MessageField('Annotation', 1)
  parent = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsDe
  leteRequest object.

  Fields:
    etag: The current etag of the annotation. If an etag is provided and does
      not match the current etag of the annotation, deletion will be blocked
      and a FAILED_PRECONDITION error will be returned.
    name: Required. The name of the annotation to delete. Format: `projects/{p
      roject}/locations/{location}/assetTypes/{asset_type}/assets/{asset}/anno
      tationSets/{annotation_set}/annotations/{annotation}`
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsGe
  tRequest object.

  Fields:
    name: Required. The name of the Annotation to retrieve. Format: `projects/
      {project}/locations/{location}/assetTypes/{asset_type}/assets/{asset}/an
      notationSets/{annotation_set}/annotations/{annotation}`
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsLi
  stRequest object.

  Fields:
    filter: The filter to apply to list results.
    pageSize: The maximum number of annotations to return. The service may
      return fewer than this value. If unspecified, at most 50 annotations
      will be returned. The maximum value is 100; values above 100 will be
      coerced to 100.
    pageToken: A page token, received from a previous `ListAnnotations` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListAnnotations` must match the call that
      provided the page token.
    parent: Required. The parent, which owns this collection of annotations.
      Format: `projects/{project}/locations/{location}/assetTypes/{asset_type}
      /assets/{asset}/annotationSets/{annotation_set}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsPatchRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsAnnotationsPa
  tchRequest object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    name: Output only. An automatically-generated resource name of the
      annotation `projects/{project}/locations/{location}/assetTypes/{asset_ty
      pe}/assets/{asset}/annotationSets/{annotation_set}/annotations/{annotati
      on}`.
    updateMask: Required. The list of fields to be updated.
  """

  annotation = _messages.MessageField('Annotation', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsCreateRequest
  object.

  Fields:
    annotationSet: A AnnotationSet resource to be passed as the request body.
    annotationSetId: The ID of the annotationSet resource to be created.
    parent: Required. The parent resource where this AnnotationSet will be
      created. Format: `projects/{project}/locations/{location}/assetTypes/{as
      set_type}/assets/{asset}`
  """

  annotationSet = _messages.MessageField('AnnotationSet', 1)
  annotationSetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsDeleteRequest
  object.

  Fields:
    etag: The current etag of the annotationSet. If an etag is provided and
      does not match the current etag of the annotationSet, deletion will be
      blocked and a FAILED_PRECONDITION error will be returned.
    name: Required. The name of the annotationSet to delete. Format: `projects
      /{project}/locations/{location}/assetTypes/{asset_type}/assets/{asset}/a
      nnotationSets/{annotation_set}`
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsGetRequest
  object.

  Fields:
    name: Required. The name of the AnnotationSet to retrieve. Format: `projec
      ts/{project}/locations/{location}/assetTypes/{asset_type}/assets/{asset}
      /annotationSets/{annotation_set}`
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsListRequest
  object.

  Fields:
    filter: The filter to apply to list results.
    pageSize: The maximum number of annotationSets to return. The service may
      return fewer than this value. If unspecified, at most 50 annotationSets
      will be returned. The maximum value is 100; values above 100 will be
      coerced to 100.
    pageToken: A page token, received from a previous `ListAnnotationSets`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListAnnotationSets` must match the call
      that provided the page token.
    parent: Required. The name of the asset that owns this collection of
      annotationSets. Format: `projects/{project}/locations/{location}/assetTy
      pes/{asset_type}/assets/{asset}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsPatchRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsAnnotationSetsPatchRequest
  object.

  Fields:
    annotationSet: A AnnotationSet resource to be passed as the request body.
    name: A user-specified resource name of the annotationSet `projects/{proje
      ct}/locations/{location}/assetTypes/{asset_type}/assets/{asset}/annotati
      onSets/{annotation_set}`.
    updateMask: Required. The list of fields to be updated.
  """

  annotationSet = _messages.MessageField('AnnotationSet', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MediaassetProjectsLocationsAssetTypesAssetsCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsCreateRequest object.

  Fields:
    asset: A Asset resource to be passed as the request body.
    assetId: The ID of the asset resource to be created.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}`.
  """

  asset = _messages.MessageField('Asset', 1)
  assetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsDeleteRequest object.

  Fields:
    etag: The current etag of the asset. If an etag is provided and does not
      match the current etag of the asset, deletion will be blocked and a
      FAILED_PRECONDITION error will be returned.
    name: The name of the asset to delete, in the following form: `projects/{p
      roject}/locations/{location}/assetTypes/{type}/assets/{asset}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class MediaassetProjectsLocationsAssetTypesAssetsGetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsGetRequest object.

  Fields:
    name: The name of the asset to retrieve, in the following form: `projects/
      {project}/locations/{location}/assetTypes/{type}/assets/{asset}`.
    readMask: Extra fields to be poplulated as part of the asset resource in
      the response. Currently, this only supports populating asset metadata
      (no wildcards and no contents of the entire asset).
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class MediaassetProjectsLocationsAssetTypesAssetsListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsListRequest object.

  Fields:
    filter: The filter to apply to list results.
    pageSize: The maximum number of items to return. If unspecified, server
      will pick an appropriate default. Server may return fewer items than
      requested. A caller should only rely on response's next_page_token to
      determine if there are more realms left to be queried.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}`.
    readMask: Extra fields to be poplulated as part of the asset resource in
      the response. Currently, this only supports populating asset metadata
      (no wildcards and no contents of the entire asset).
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class MediaassetProjectsLocationsAssetTypesAssetsLroCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsLroCreateRequest object.

  Fields:
    asset: A Asset resource to be passed as the request body.
    assetId: The ID of the asset resource to be created.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}`.
  """

  asset = _messages.MessageField('Asset', 1)
  assetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsLroDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsLroDeleteRequest object.

  Fields:
    etag: The current etag of the asset. If an etag is provided and does not
      match the current etag of the asset, deletion will be blocked and a
      FAILED_PRECONDITION error will be returned.
    name: The name of the asset to delete, in the following form: `projects/{p
      roject}/locations/{location}/assetTypes/{type}/assets/{asset}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class MediaassetProjectsLocationsAssetTypesAssetsLroUpdateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsLroUpdateRequest object.

  Fields:
    asset: A Asset resource to be passed as the request body.
    name: The resource name of the asset, in the following form: `projects/{pr
      oject}/locations/{location}/assetTypes/{type}/assets/{asset}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Asset resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  asset = _messages.MessageField('Asset', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class MediaassetProjectsLocationsAssetTypesAssetsPatchRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsPatchRequest object.

  Fields:
    asset: A Asset resource to be passed as the request body.
    name: The resource name of the asset, in the following form: `projects/{pr
      oject}/locations/{location}/assetTypes/{type}/assets/{asset}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Asset resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  asset = _messages.MessageField('Asset', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class MediaassetProjectsLocationsAssetTypesAssetsSetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsTestIamPermissionsRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsTransformationsGetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsTransformationsGetIamPolicy
  Request object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsTransformationsGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsTransformationsGetRequest
  object.

  Fields:
    name: The name of the asset transformation to retrieve, in the following
      form: `projects/{project}/locations/{location}/assetTypes/{type}/assets/
      {asset}/transformations/{transformation}`.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsTransformationsListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsTransformationsListRequest
  object.

  Fields:
    filter: The filter to apply to list results.
    orderBy: Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: The maximum number of items to return. If unspecified, server
      will pick an appropriate default. Server may return fewer items than
      requested. A caller should only rely on response's next_page_token to
      determine if there are more realms left to be queried.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: The parent resource name, in the following form: `projects/{projec
      t}/locations/{location}/assetTypes/{type}/assets/{asset}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsTransformationsSetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsTransformationsSetIamPolicy
  Request object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesAssetsTransformationsTestIamPermissionsRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesAssetsTransformationsTestIamPermi
  ssionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesCreateRequest object.

  Fields:
    assetType: A AssetType resource to be passed as the request body.
    assetTypeId: The ID of the asset type resource to be created.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  assetType = _messages.MessageField('AssetType', 1)
  assetTypeId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class MediaassetProjectsLocationsAssetTypesDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesDeleteRequest object.

  Fields:
    name: The name of the asset type to delete, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class MediaassetProjectsLocationsAssetTypesGetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesGetRequest object.

  Fields:
    name: The name of the asset type to retrieve, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}`.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsAssetTypesListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesListRequest object.

  Fields:
    filter: The filter to apply to list results.
    orderBy: Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: The maximum number of items to return. If unspecified, server
      will pick an appropriate default. Server may return fewer items than
      requested. A caller should only rely on response's next_page_token to
      determine if there are more realms left to be queried.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MediaassetProjectsLocationsAssetTypesPatchRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesPatchRequest object.

  Fields:
    assetType: A AssetType resource to be passed as the request body.
    name: The resource name of the asset type, in the following form:
      `projects/{project}/locations/{location}/assetTypes/{type}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Field mask is used to specify the fields to be overwritten in
      the AssetType resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then all fields will be overwritten.
  """

  assetType = _messages.MessageField('AssetType', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class MediaassetProjectsLocationsAssetTypesRulesCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesRulesCreateRequest object.

  Fields:
    parent: Required. The parent resource where this Rule will be created.
      Format: `projects/{project}/locations/{location}/assetTypes/{type}`
    rule: A Rule resource to be passed as the request body.
    ruleId: Required. The ID to use for the Rule, which will become the final
      component of the rule's resource name. This value should be 4-63
      characters, and valid characters are /a-z-/.
  """

  parent = _messages.StringField(1, required=True)
  rule = _messages.MessageField('Rule', 2)
  ruleId = _messages.StringField(3)


class MediaassetProjectsLocationsAssetTypesRulesDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesRulesDeleteRequest object.

  Fields:
    etag: The current etag of the rule. If an etag is provided and does not
      match the current etag of the rule, deletion will be blocked and a
      FAILED_PRECONDITION error will be returned.
    name: Required. The name of the rule to delete. Format:
      `projects/{project}/locations/{location}/assetTypes/{type}/rules/{rule}`
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesRulesGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesRulesGetRequest object.

  Fields:
    name: Required. The name of the Rule to retrieve. Format:
      `projects/{project}/locations/{location}/assetTypes/{type}/rules/{rule}`
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsAssetTypesRulesListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesRulesListRequest object.

  Fields:
    pageSize: The maximum number of rules to return. The service may return
      fewer than this value. If unspecified, at most 50 books will be
      returned. The maximum value is 100; values above 100 will be coerced to
      100.
    pageToken: A page token, received from a previous `ListRules` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListRules` must match the call that provided the
      page token.
    parent: Required. The parent, which owns this collection of rules. Format:
      `projects/{project}/locations/{location}/assetTypes/{type}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MediaassetProjectsLocationsAssetTypesRulesPatchRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesRulesPatchRequest object.

  Fields:
    name: A user-specified resource name of the rule
      `projects/{project}/locations/{location}/assetTypes/{type}/rules/{rule}`
      .
    rule: A Rule resource to be passed as the request body.
    updateMask: Required. The list of fields to be updated.
  """

  name = _messages.StringField(1, required=True)
  rule = _messages.MessageField('Rule', 2)
  updateMask = _messages.StringField(3)


class MediaassetProjectsLocationsAssetTypesSetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsAssetTypesTestIamPermissionsRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsAssetTypesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsComplexTypesCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesCreateRequest object.

  Fields:
    complexType: A ComplexType resource to be passed as the request body.
    complexTypeId: The ID of the complex type resource to be created.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  complexType = _messages.MessageField('ComplexType', 1)
  complexTypeId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class MediaassetProjectsLocationsComplexTypesDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesDeleteRequest object.

  Fields:
    name: The name of the complex type to delete, in the following form:
      `projects/{project}/locations/{location}/complexTypes/{type}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class MediaassetProjectsLocationsComplexTypesGetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsComplexTypesGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesGetRequest object.

  Fields:
    name: The name of the complex type to retrieve, in the following form:
      `projects/{project}/locations/{location}/complexTypes/{type}`.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsComplexTypesListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesListRequest object.

  Fields:
    filter: The filter to apply to list results.
    orderBy: Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: The maximum number of items to return. If unspecified, server
      will pick an appropriate default. Server may return fewer items than
      requested. A caller should only rely on response's next_page_token to
      determine if there are more realms left to be queried
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MediaassetProjectsLocationsComplexTypesPatchRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesPatchRequest object.

  Fields:
    complexType: A ComplexType resource to be passed as the request body.
    name: The resource name of the complex type, in the following form:
      `projects/{project}/locations/{location}/complexTypes/{type}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Field mask is used to specify the fields to be overwritten in
      the ComplexType resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then all fields will be overwritten.
  """

  complexType = _messages.MessageField('ComplexType', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class MediaassetProjectsLocationsComplexTypesSetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsComplexTypesTestIamPermissionsRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsComplexTypesTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class MediaassetProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MediaassetProjectsLocationsTransformersCreateRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersCreateRequest object.

  Fields:
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    transformer: A Transformer resource to be passed as the request body.
    transformerId: The ID of the transformer resource to be created.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  transformer = _messages.MessageField('Transformer', 3)
  transformerId = _messages.StringField(4)


class MediaassetProjectsLocationsTransformersDeleteRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersDeleteRequest object.

  Fields:
    name: The name of the transformer to delete, in the following form:
      `projects/{project}/locations/{location}/transformer/{type}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class MediaassetProjectsLocationsTransformersGetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsTransformersGetRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersGetRequest object.

  Fields:
    name: The name of the transformer to retrieve, in the following form:
      `projects/{project}/locations/{location}/transformers/{transformer}`.
  """

  name = _messages.StringField(1, required=True)


class MediaassetProjectsLocationsTransformersListRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersListRequest object.

  Fields:
    filter: The filter to apply to list results.
    orderBy: Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: The maximum number of items to return. If unspecified, server
      will pick an appropriate default. Server may return fewer items than
      requested. A caller should only rely on response's next_page_token to
      determine if there are more realms left to be queried
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: The parent resource name, in the following form:
      `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MediaassetProjectsLocationsTransformersPatchRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersPatchRequest object.

  Fields:
    name: The resource name of the transformer, in the following form:
      `projects/{project}/locations/{location}/transformer/{transformer}`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    transformer: A Transformer resource to be passed as the request body.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Transformer resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  transformer = _messages.MessageField('Transformer', 3)
  updateMask = _messages.StringField(4)


class MediaassetProjectsLocationsTransformersSetIamPolicyRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MediaassetProjectsLocationsTransformersTestIamPermissionsRequest(_messages.Message):
  r"""A MediaassetProjectsLocationsTransformersTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MetadataConfig(_messages.Message):
  r"""A MetadataConfig object.

  Fields:
    complexType: Reference to the complex type name, in the following form:
      `projects/{project}/locations/{location}/complexTypes/{name}`.
    required: If true, this asset metadata is required to be specified during
      asset creation.
  """

  complexType = _messages.StringField(1)
  required = _messages.BooleanField(2)


class MetadataInfo(_messages.Message):
  r"""A MetadataInfo object.

  Fields:
    updateTime: Time at which this field was updated.
  """

  updateTime = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Rule(_messages.Message):
  r"""A rule resource is associated with an AssetType and manages the workflow
  pipelines of a collection of Assets under that AssetType.

  Messages:
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.

  Fields:
    createTime: Output only. The creation time of the rule.
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    name: A user-specified resource name of the rule
      `projects/{project}/locations/{location}/assetTypes/{type}/rules/{rule}`
      .
    pubsubNotification: https://cloud.google.com/pubsub/docs/overview
      Configure the associated AssetType to publish event messages using
      Pub/Sub.
    transformation: Configure the associated AssetType to invoke transformers.
    updateTime: Output only. The latest update time of the rule.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  pubsubNotification = _messages.MessageField('CloudPubSubNotificationConfig', 4)
  transformation = _messages.MessageField('RuleTransformationConfig', 5)
  updateTime = _messages.StringField(6)


class RuleTransformationConfig(_messages.Message):
  r"""A RuleTransformationConfig configure the associated AssetType to invoke
  transformers on its Assets.

  Messages:
    InputsValue: Key-value pairs representing input parameters to the
      transformers. The key maps to the transformer input parameter name. The
      value is interpreted as a literal or a path within asset if it's
      prefixed by "$asset.", e.g. "$asset.file.url".
    OutputsValue: Key-value pairs representing output parameters from the
      transformers. The key maps to the transformer output parameter name. The
      value will be the path to the metadata in the asset to which this output
      should be assigned.

  Fields:
    inputs: Key-value pairs representing input parameters to the transformers.
      The key maps to the transformer input parameter name. The value is
      interpreted as a literal or a path within asset if it's prefixed by
      "$asset.", e.g. "$asset.file.url".
    outputs: Key-value pairs representing output parameters from the
      transformers. The key maps to the transformer output parameter name. The
      value will be the path to the metadata in the asset to which this output
      should be assigned.
    transformer: Required. Reference to a transformer to execute, in the
      following form:
      `projects/{project}/locations/{location}/transformers/{name}`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Key-value pairs representing input parameters to the transformers. The
    key maps to the transformer input parameter name. The value is interpreted
    as a literal or a path within asset if it's prefixed by "$asset.", e.g.
    "$asset.file.url".

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Key-value pairs representing output parameters from the transformers.
    The key maps to the transformer output parameter name. The value will be
    the path to the metadata in the asset to which this output should be
    assigned.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  inputs = _messages.MessageField('InputsValue', 1)
  outputs = _messages.MessageField('OutputsValue', 2)
  transformer = _messages.StringField(3)


class SortOrderConfig(_messages.Message):
  r"""A SortOrderConfig object.

  Fields:
    descending: Sort in descending order.
    field: Field to sort by. Must be: - required - numeric, datetime or
      duration field - within the asset itself and not in any linked assets.
  """

  descending = _messages.BooleanField(1)
  field = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TransformationConfig(_messages.Message):
  r"""A TransformationConfig object.

  Messages:
    InputsValue: Key-value pairs representing input parameters to the
      transformers. The key maps to the transformer input parameter name. The
      value is interpreted as a literal or a path within asset if it's
      prefixed by "$asset.", e.g. "$asset.file.url".
    OutputsValue: Key-value pairs representing output parameters from the
      transformers. The key maps to the transformer output parameter name. The
      value will be the path to the metadata in the asset to which this output
      should be assigned.

  Fields:
    inputs: Key-value pairs representing input parameters to the transformers.
      The key maps to the transformer input parameter name. The value is
      interpreted as a literal or a path within asset if it's prefixed by
      "$asset.", e.g. "$asset.file.url".
    outputs: Key-value pairs representing output parameters from the
      transformers. The key maps to the transformer output parameter name. The
      value will be the path to the metadata in the asset to which this output
      should be assigned.
    transformer: Reference to a transformer to execute, in the following form:
      `projects/{project}/locations/{location}/transformers/{name}`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Key-value pairs representing input parameters to the transformers. The
    key maps to the transformer input parameter name. The value is interpreted
    as a literal or a path within asset if it's prefixed by "$asset.", e.g.
    "$asset.file.url".

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Key-value pairs representing output parameters from the transformers.
    The key maps to the transformer output parameter name. The value will be
    the path to the metadata in the asset to which this output should be
    assigned.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  inputs = _messages.MessageField('InputsValue', 1)
  outputs = _messages.MessageField('OutputsValue', 2)
  transformer = _messages.StringField(3)


class TransformationStatus(_messages.Message):
  r"""Status of Asset transformation.

  Enums:
    StateValueValuesEnum: State of the asset transformation.

  Fields:
    lastInvocationStatus: Status of the last invocation of the asset
      transformation.
    lastInvocationTime: Time at which the last invocation of the asset
      transformation occurred.
    state: State of the asset transformation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the asset transformation.

    Values:
      STATE_UNSPECIFIED: Transformation state is unspecified.
      QUEUED: Transformation is queued.
      RUNNING: Transformation is in running state.
      COMPLETED: Transformation has been completed.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    RUNNING = 2
    COMPLETED = 3

  lastInvocationStatus = _messages.MessageField('Status', 1)
  lastInvocationTime = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)


class Transformer(_messages.Message):
  r"""A transformer resource. Transformers are functions that process a set of
  input parameters and generate outputs. They provide the mechanism to enrich
  asset information by processing asset contents.

  Messages:
    InputsValue: Mapping of the input parameter name to its type. The type
      could be one of: - Primitive types ("string", "number", "bool") - Custom
      complex type. Format: "p/p/l/l/complexTypes/*" - Collections of the
      above - list(), dict()
    LabelsValue: The labels associated with this resource. Each label is a
      key-value pair.
    OutputsValue: Mapping of the output parameter name to its type. The type
      could be one of: - Primitive types ("string", "number", "bool") - Custom
      complex type. Format: "p/p/l/l/complexTypes/*" - Collections of the
      above - list(), dict()

  Fields:
    createTime: The creation time.
    endpoint: URI endpoint that the Transformer is listening for its
      invocation through the documented Transformer protocol.
    inputs: Mapping of the input parameter name to its type. The type could be
      one of: - Primitive types ("string", "number", "bool") - Custom complex
      type. Format: "p/p/l/l/complexTypes/*" - Collections of the above -
      list(), dict()
    labels: The labels associated with this resource. Each label is a key-
      value pair.
    name: The resource name of the transformer, in the following form:
      `projects/{project}/locations/{location}/transformer/{transformer}`.
    outputs: Mapping of the output parameter name to its type. The type could
      be one of: - Primitive types ("string", "number", "bool") - Custom
      complex type. Format: "p/p/l/l/complexTypes/*" - Collections of the
      above - list(), dict()
    updateTime: The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Mapping of the input parameter name to its type. The type could be one
    of: - Primitive types ("string", "number", "bool") - Custom complex type.
    Format: "p/p/l/l/complexTypes/*" - Collections of the above - list(),
    dict()

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this resource. Each label is a key-value
    pair.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Mapping of the output parameter name to its type. The type could be
    one of: - Primitive types ("string", "number", "bool") - Custom complex
    type. Format: "p/p/l/l/complexTypes/*" - Collections of the above -
    list(), dict()

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  endpoint = _messages.StringField(2)
  inputs = _messages.MessageField('InputsValue', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  outputs = _messages.MessageField('OutputsValue', 6)
  updateTime = _messages.StringField(7)


class TriggerActionRequest(_messages.Message):
  r"""Request message for ActionsService.TriggerAction."""


class TriggerActionResponse(_messages.Message):
  r"""Response message for ActionsService.TriggerAction."""


encoding.AddCustomJsonFieldMapping(
    GoogleIamV1Rule, 'in_', 'in')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
