"""Generated message classes for datacatalog version v1.

A fully managed and highly scalable data discovery and metadata management
service.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'datacatalog'


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class DatacatalogEntriesLookupRequest(_messages.Message):
  r"""A DatacatalogEntriesLookupRequest object.

  Fields:
    fullyQualifiedName: Fully qualified name (FQN) of the resource. FQNs take
      two forms: * For non-regionalized resources:
      `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` * For
      regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOU
      RCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metastore:
      project_id.location_id.instance_id.database_id.table_id`
    linkedResource: The full name of the Google Cloud Platform resource the
      Data Catalog entry represents. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name.
      Full names are case-sensitive. Examples: * //bigquery.googleapis.com/pro
      jects/projectId/datasets/datasetId/tables/tableId *
      //pubsub.googleapis.com/projects/projectId/topics/topicId
    sqlResource: The SQL name of the entry. SQL names are case-sensitive.
      Examples: * `pubsub.project_id.topic_id` *
      ``pubsub.project_id.`topic.id.with.dots` `` *
      `bigquery.table.project_id.dataset_id.table_id` *
      `bigquery.dataset.project_id.dataset_id` *
      `datacatalog.entry.project_id.location_id.entry_group_id.entry_id`
      `*_id`s should satisfy the standard SQL rules for identifiers.
      https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical.
  """

  fullyQualifiedName = _messages.StringField(1)
  linkedResource = _messages.StringField(2)
  sqlResource = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsCreateRequest object.

  Fields:
    entryGroupId: Required. The ID of the entry group to create. The ID must
      contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and
      must start with a letter or underscore. The maximum size is 64 bytes
      when encoded in UTF-8.
    googleCloudDatacatalogV1EntryGroup: A GoogleCloudDatacatalogV1EntryGroup
      resource to be passed as the request body.
    parent: Required. The name of the project this entry group belongs to.
      Example: `projects/{project_id}/locations/{location}` Note: The entry
      group itself and its child resources might not be stored in the location
      specified in its name.
  """

  entryGroupId = _messages.StringField(1)
  googleCloudDatacatalogV1EntryGroup = _messages.MessageField('GoogleCloudDatacatalogV1EntryGroup', 2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsDeleteRequest object.

  Fields:
    force: Optional. If true, deletes all entries in the entry group.
    name: Required. The name of the entry group. For example,
      `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
      `.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest object.

  Fields:
    entryId: Required. The ID of the entry to create. The ID must contain only
      letters (a-z, A-Z), numbers (0-9), and underscores (_). The maximum size
      is 64 bytes when encoded in UTF-8.
    googleCloudDatacatalogV1Entry: A GoogleCloudDatacatalogV1Entry resource to
      be passed as the request body.
    parent: Required. The name of the entry group this entry belongs to.
      Example: `projects/{project_id}/locations/{location}/entryGroups/{entry_
      group_id}` Note: The entry itself and its child resources might not be
      stored in the location specified in its name.
  """

  entryId = _messages.StringField(1)
  googleCloudDatacatalogV1Entry = _messages.MessageField('GoogleCloudDatacatalogV1Entry', 2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest object.

  Fields:
    name: Required. The name of the entry. Example: * projects/{project_id}/lo
      cations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest
  object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest object.

  Fields:
    name: Required. The name of the entry. Example: * projects/{project_id}/lo
      cations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesListRequest object.

  Fields:
    pageSize: The maximum number of items to return. Default is 10. Max limit
      is 1000. Throws an invalid argument for `page_size > 1000`.
    pageToken: Token that specifies which page is requested. If empty, the
      first page is returned.
    parent: Required. The name of the entry group that contains the entries,
      which can be provided in URL format. Example: *
      projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
    readMask: The fields to return for each Entry. If not set or empty, all
      fields are returned. For example, setting read_mask to contain only one
      path "name" will cause ListEntries to return a list of Entries with only
      "name" field.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  readMask = _messages.StringField(4)


class DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Entry: A GoogleCloudDatacatalogV1Entry resource to
      be passed as the request body.
    name: Output only. The resource name of an entry in URL format. Example: `
      projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/
      entries/{entry_id}` Note: The entry itself and its child resources might
      not be stored in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on an entry. If this
      parameter is absent or empty, all modifiable fields are overwritten. If
      such fields are non-required and omitted in the request body, their
      values are emptied. The following fields are modifiable: * For entries
      with type `DATA_STREAM`: * `schema` * For entries with type `FILESET`: *
      `schema` * `display_name` * `description` * `gcs_fileset_spec` *
      `gcs_fileset_spec.file_patterns` * For entries with
      `user_specified_type`: * `schema` * `display_name` * `description` *
      `user_specified_type` * `user_specified_system` * `linked_resource` *
      `source_system_timestamps`
  """

  googleCloudDatacatalogV1Entry = _messages.MessageField('GoogleCloudDatacatalogV1Entry', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest
  object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    parent: Required. The name of the resource to attach this tag to. Tags can
      be attached to entries. An entry can have up to 1000 attached tags.
      Example: `projects/{project_id}/locations/{location}/entryGroups/{entry_
      group_id}/entries/{entry_id}` Note: The tag and its child resources
      might not be stored in the location specified in its name.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest
  object.

  Fields:
    name: Required. The name of the tag to delete. Example: * projects/{projec
      t_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_i
      d}/tags/{tag_id}
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest object.

  Fields:
    pageSize: The maximum number of tags to return. Default is 10. Max limit
      is 1000.
    pageToken: Token that specifies which page is requested. If empty, the
      first page is returned.
    parent: Required. The name of the Data Catalog resource to list the tags
      of. The resource could be an Entry or an EntryGroup. Examples: *
      projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
      * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id
      }/entries/{entry_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    name: The resource name of the tag in URL format. Example: `projects/{proj
      ect_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry
      _id}/tags/{tag_id}` where `tag_id` is a system-generated identifier.
      Note: The tag itself might not be stored in the location specified in
      its name.
    updateMask: Names of fields whose values to overwrite on a tag. Currently,
      a tag has the only modifiable field with the name `fields`. In general,
      if this parameter is absent or empty, all modifiable fields are
      overwritten. If such fields are non-required and omitted in the request
      body, their values are emptied.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest(_messages.Message):
  r"""A
  DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsGetRequest object.

  Fields:
    name: Required. The name of the entry group. For example,
      `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
      `.
    readMask: The fields to return. If not set or empty, all fields are
      returned.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class DatacatalogProjectsLocationsEntryGroupsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. Default is 10.
      Max limit is 1000. Throws an invalid argument for `page_size > 1000`.
    pageToken: Optional. Token that specifies which page is requested. If
      empty, the first page is returned.
    parent: Required. The name of the location that contains the entry groups,
      which can be provided in URL format. Example: *
      projects/{project_id}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1EntryGroup: A GoogleCloudDatacatalogV1EntryGroup
      resource to be passed as the request body.
    name: The resource name of the entry group in URL format. Example:
      `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
      ` Note: The entry group itself and its child resources might not be
      stored in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on an entry group.
      If this parameter is absent or empty, all modifiable fields are
      overwritten. If such fields are non-required and omitted in the request
      body, their values are emptied.
  """

  googleCloudDatacatalogV1EntryGroup = _messages.MessageField('GoogleCloudDatacatalogV1EntryGroup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    parent: Required. The name of the resource to attach this tag to. Tags can
      be attached to entries. An entry can have up to 1000 attached tags.
      Example: `projects/{project_id}/locations/{location}/entryGroups/{entry_
      group_id}/entries/{entry_id}` Note: The tag and its child resources
      might not be stored in the location specified in its name.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest object.

  Fields:
    name: Required. The name of the tag to delete. Example: * projects/{projec
      t_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_i
      d}/tags/{tag_id}
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsTagsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsListRequest object.

  Fields:
    pageSize: The maximum number of tags to return. Default is 10. Max limit
      is 1000.
    pageToken: Token that specifies which page is requested. If empty, the
      first page is returned.
    parent: Required. The name of the Data Catalog resource to list the tags
      of. The resource could be an Entry or an EntryGroup. Examples: *
      projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
      * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id
      }/entries/{entry_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Tag: A GoogleCloudDatacatalogV1Tag resource to be
      passed as the request body.
    name: The resource name of the tag in URL format. Example: `projects/{proj
      ect_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry
      _id}/tags/{tag_id}` where `tag_id` is a system-generated identifier.
      Note: The tag itself might not be stored in the location specified in
      its name.
    updateMask: Names of fields whose values to overwrite on a tag. Currently,
      a tag has the only modifiable field with the name `fields`. In general,
      if this parameter is absent or empty, all modifiable fields are
      overwritten. If such fields are non-required and omitted in the request
      body, their values are emptied.
  """

  googleCloudDatacatalogV1Tag = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsTagTemplatesCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesCreateRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplate: A GoogleCloudDatacatalogV1TagTemplate
      resource to be passed as the request body.
    parent: Required. The name of the project and the template location
      [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
      Example: * projects/{project_id}/locations/us-central1
    tagTemplateId: Required. The ID of the tag template to create. The ID must
      contain only lowercase letters (a-z), numbers (0-9), or underscores (_),
      and must start with a letter or underscore. The maximum size is 64 bytes
      when encoded in UTF-8.
  """

  googleCloudDatacatalogV1TagTemplate = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplate', 1)
  parent = _messages.StringField(2, required=True)
  tagTemplateId = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesDeleteRequest object.

  Fields:
    force: Required. Currently, this field must always be set to `true`. This
      confirms the deletion of any possible tags using this template. `force =
      false` will be supported in the future.
    name: Required. The name of the tag template to delete. Example: *
      projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id
      }
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplateField: A
      GoogleCloudDatacatalogV1TagTemplateField resource to be passed as the
      request body.
    parent: Required. The name of the project and the template location
      [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
      Example: * projects/{project_id}/locations/us-
      central1/tagTemplates/{tag_template_id}
    tagTemplateFieldId: Required. The ID of the tag template field to create.
      Note: Adding a required field to an existing template is *not* allowed.
      Field IDs can contain letters (both uppercase and lowercase), numbers
      (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
      character long and at most 128 characters long. Field IDs must also be
      unique within their template.
  """

  googleCloudDatacatalogV1TagTemplateField = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplateField', 1)
  parent = _messages.StringField(2, required=True)
  tagTemplateFieldId = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest object.

  Fields:
    force: Required. Currently, this field must always be set to `true`. This
      confirms the deletion of this field from any tags using this field.
      `force = false` will be supported in the future.
    name: Required. The name of the tag template field to delete. Example: * p
      rojects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
      /fields/{tag_template_field_id}
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest
  object.

  Fields:
    googleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest: A
      GoogleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest resource
      to be passed as the request body.
    name: Required. The name of the enum field value. Example: * projects/{pro
      ject_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag
      _template_field_id}/enumValues/{enum_value_display_name}
  """

  googleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest = _messages.MessageField('GoogleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplateField: A
      GoogleCloudDatacatalogV1TagTemplateField resource to be passed as the
      request body.
    name: Required. The name of the tag template field. Example: * projects/{p
      roject_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{t
      ag_template_field_id}
    updateMask: Optional. Names of fields whose values to overwrite on an
      individual field of a tag template. The following fields are modifiable:
      * `display_name` * `type.enum_type` * `is_required` If this parameter is
      absent or empty, all modifiable fields are overwritten. If such fields
      are non-required and omitted in the request body, their values are
      emptied with one exception: when updating an enum type, the provided
      values are merged with the existing values. Therefore, enum values can
      only be added, existing enum values cannot be deleted or renamed.
      Additionally, updating a template field from optional to required is
      *not* allowed.
  """

  googleCloudDatacatalogV1TagTemplateField = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplateField', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest object.

  Fields:
    googleCloudDatacatalogV1RenameTagTemplateFieldRequest: A
      GoogleCloudDatacatalogV1RenameTagTemplateFieldRequest resource to be
      passed as the request body.
    name: Required. The name of the tag template. Example: * projects/{project
      _id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_tem
      plate_field_id}
  """

  googleCloudDatacatalogV1RenameTagTemplateFieldRequest = _messages.MessageField('GoogleCloudDatacatalogV1RenameTagTemplateFieldRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesGetRequest object.

  Fields:
    name: Required. The name of the tag template. Example: *
      projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id
      }
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTagTemplatesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1TagTemplate: A GoogleCloudDatacatalogV1TagTemplate
      resource to be passed as the request body.
    name: The resource name of the tag template in URL format. Example: `proje
      cts/{project_id}/locations/{location}/tagTemplates/{tag_template_id}`
      Note: The tag template itself and its child resources might not be
      stored in the location specified in its name.
    updateMask: Names of fields whose values to overwrite on a tag template.
      Currently, only `display_name` can be overwritten. In general, if this
      parameter is absent or empty, all modifiable fields are overwritten. If
      such fields are non-required and omitted in the request body, their
      values are emptied.
  """

  googleCloudDatacatalogV1TagTemplate = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplate', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesCreateRequest object.

  Fields:
    googleCloudDatacatalogV1Taxonomy: A GoogleCloudDatacatalogV1Taxonomy
      resource to be passed as the request body.
    parent: Required. Resource name of the project that the taxonomy will
      belong to.
  """

  googleCloudDatacatalogV1Taxonomy = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesDeleteRequest object.

  Fields:
    name: Required. Resource name of the taxonomy to be deleted. All policy
      tags in this taxonomy will also be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesExportRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesExportRequest object.

  Fields:
    parent: Required. Resource name of the project that the exported
      taxonomies belong to.
    serializedTaxonomies: Export taxonomies as serialized taxonomies, which
      contain all the policy tags as nested protos.
    taxonomies: Required. Resource names of the taxonomies to be exported.
  """

  parent = _messages.StringField(1, required=True)
  serializedTaxonomies = _messages.BooleanField(2)
  taxonomies = _messages.StringField(3, repeated=True)


class DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesGetRequest object.

  Fields:
    name: Required. Resource name of the requested taxonomy.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesImportRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesImportRequest object.

  Fields:
    googleCloudDatacatalogV1ImportTaxonomiesRequest: A
      GoogleCloudDatacatalogV1ImportTaxonomiesRequest resource to be passed as
      the request body.
    parent: Required. Resource name of project that the imported taxonomies
      will belong to.
  """

  googleCloudDatacatalogV1ImportTaxonomiesRequest = _messages.MessageField('GoogleCloudDatacatalogV1ImportTaxonomiesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesListRequest object.

  Fields:
    pageSize: The maximum number of items to return. Must be a value between 1
      and 1000. If not set, defaults to 50.
    pageToken: The next_page_token value returned from a previous list
      request, if any. If not set, defaults to an empty string.
    parent: Required. Resource name of the project to list the taxonomies of.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsTaxonomiesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1Taxonomy: A GoogleCloudDatacatalogV1Taxonomy
      resource to be passed as the request body.
    name: Output only. Resource name of this taxonomy in format: "projects/{pr
      oject_number}/locations/{location_id}/taxonomies/{taxonomy_id}". Note
      that taxonomy_id's are unique and generated by Policy Tag Manager.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask If not set, defaults to
      all of the fields that are allowed to update.
  """

  googleCloudDatacatalogV1Taxonomy = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest object.

  Fields:
    googleCloudDatacatalogV1PolicyTag: A GoogleCloudDatacatalogV1PolicyTag
      resource to be passed as the request body.
    parent: Required. Resource name of the taxonomy that the policy tag will
      belong to.
  """

  googleCloudDatacatalogV1PolicyTag = _messages.MessageField('GoogleCloudDatacatalogV1PolicyTag', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest object.

  Fields:
    name: Required. Resource name of the policy tag to be deleted. All of its
      descendant policy tags will also be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest
  object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest object.

  Fields:
    name: Required. Resource name of the requested policy tag.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest object.

  Fields:
    pageSize: The maximum number of items to return. Must be a value between 1
      and 1000. If not set, defaults to 50.
    pageToken: The next_page_token value returned from a previous List
      request, if any. If not set, defaults to an empty string.
    parent: Required. Resource name of the taxonomy to list the policy tags
      of.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1PolicyTag: A GoogleCloudDatacatalogV1PolicyTag
      resource to be passed as the request body.
    name: Output only. Resource name of this policy tag in format: "projects/{
      project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyT
      ags/{policy_tag_id}". Both taxonomy_ids and policy_tag_ids are unique
      and generated by Policy Tag Manager.
    updateMask: The update mask applies to the resource. Only display_name,
      description and parent_policy_tag can be updated and thus can be listed
      in the mask. If update_mask is not provided, all allowed fields (i.e.
      display_name, description and parent) will be updated. For more
      information including the `FieldMask` definition, see
      https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask If not set, defaults to
      all of the fields that are allowed to update.
  """

  googleCloudDatacatalogV1PolicyTag = _messages.MessageField('GoogleCloudDatacatalogV1PolicyTag', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest(_messages.Message):
  r"""A
  DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesReplaceRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesReplaceRequest object.

  Fields:
    googleCloudDatacatalogV1ReplaceTaxonomyRequest: A
      GoogleCloudDatacatalogV1ReplaceTaxonomyRequest resource to be passed as
      the request body.
    name: Required. Resource name of the taxonomy to be updated.
  """

  googleCloudDatacatalogV1ReplaceTaxonomyRequest = _messages.MessageField('GoogleCloudDatacatalogV1ReplaceTaxonomyRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudDatacatalogV1BigQueryDateShardedSpec(_messages.Message):
  r"""Spec for a group of BigQuery tables with name pattern
  `[prefix]YYYYMMDD`. Context:
  https://cloud.google.com/bigquery/docs/partitioned-
  tables#partitioning_versus_sharding

  Fields:
    dataset: Output only. The Data Catalog resource name of the dataset entry
      the current table belongs to, for example, `projects/{project_id}/locati
      ons/{location}/entrygroups/{entry_group_id}/entries/{entry_id}`.
    shardCount: Output only. Total number of shards.
    tablePrefix: Output only. The table name prefix of the shards. The name of
      any given shard is `[table_prefix]YYYYMMDD`, for example, for shard
      `MyTable20180101`, the `table_prefix` is `MyTable`.
  """

  dataset = _messages.StringField(1)
  shardCount = _messages.IntegerField(2)
  tablePrefix = _messages.StringField(3)


class GoogleCloudDatacatalogV1BigQueryTableSpec(_messages.Message):
  r"""Describes a BigQuery table.

  Enums:
    TableSourceTypeValueValuesEnum: Output only. The table source type.

  Fields:
    tableSourceType: Output only. The table source type.
    tableSpec: Spec of a BigQuery table. This field should only be populated
      if `table_source_type` is `BIGQUERY_TABLE`.
    viewSpec: Table view specification. This field should only be populated if
      `table_source_type` is `BIGQUERY_VIEW`.
  """

  class TableSourceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The table source type.

    Values:
      TABLE_SOURCE_TYPE_UNSPECIFIED: Default unknown type.
      BIGQUERY_VIEW: Table view.
      BIGQUERY_TABLE: BigQuery native table.
      BIGQUERY_MATERIALIZED_VIEW: BigQuery materialized view.
    """
    TABLE_SOURCE_TYPE_UNSPECIFIED = 0
    BIGQUERY_VIEW = 1
    BIGQUERY_TABLE = 2
    BIGQUERY_MATERIALIZED_VIEW = 3

  tableSourceType = _messages.EnumField('TableSourceTypeValueValuesEnum', 1)
  tableSpec = _messages.MessageField('GoogleCloudDatacatalogV1TableSpec', 2)
  viewSpec = _messages.MessageField('GoogleCloudDatacatalogV1ViewSpec', 3)


class GoogleCloudDatacatalogV1ClusterSpec(_messages.Message):
  r"""Additional specification of a cluster.

  Fields:
    kafkaCluster: Fields specific to a Kafka cluster. Present only on entries
      representing Kafka clusters.
  """

  kafkaCluster = _messages.MessageField('GoogleCloudDatacatalogV1KafkaClusterSpec', 1)


class GoogleCloudDatacatalogV1ColumnSchema(_messages.Message):
  r"""Representation of a column within a schema. Columns could be nested
  inside other columns.

  Fields:
    column: Required. Name of the column. Must be a UTF-8 string without dots
      (.). The maximum size is 64 bytes.
    description: Optional. Description of the column. Default value is an
      empty string. The description must be a UTF-8 string with the maximum
      size of 2000 bytes.
    mode: Optional. A column's mode indicates if values in this column are
      required, nullable, or repeated. Only `NULLABLE`, `REQUIRED`, and
      `REPEATED` values are supported. Default mode is `NULLABLE`.
    subcolumns: Optional. Schema of sub-columns. A column can have zero or
      more sub-columns.
    type: Required. Type of the column. Must be a UTF-8 string with the
      maximum size of 128 bytes.
  """

  column = _messages.StringField(1)
  description = _messages.StringField(2)
  mode = _messages.StringField(3)
  subcolumns = _messages.MessageField('GoogleCloudDatacatalogV1ColumnSchema', 4, repeated=True)
  type = _messages.StringField(5)


class GoogleCloudDatacatalogV1CrossRegionalSource(_messages.Message):
  r"""Cross-regional source used to import an existing taxonomy into a
  different region.

  Fields:
    taxonomy: Required. The resource name of the source taxonomy to be
      imported.
  """

  taxonomy = _messages.StringField(1)


class GoogleCloudDatacatalogV1DataSource(_messages.Message):
  r"""Describes the physical location of an entry.

  Enums:
    ServiceValueValuesEnum: Service in which the data is physically stored.

  Fields:
    resource: Full name of the resource as defined by the service, e.g. //bigq
      uery.googleapis.com/projects/{project_id}/locations/{location}/datasets/
      {dataset_id}/tables/{table_id}
    service: Service in which the data is physically stored.
  """

  class ServiceValueValuesEnum(_messages.Enum):
    r"""Service in which the data is physically stored.

    Values:
      SERVICE_UNSPECIFIED: Default unknown service.
      CLOUD_STORAGE: Google Cloud Storage service.
      BIGQUERY: BigQuery service.
    """
    SERVICE_UNSPECIFIED = 0
    CLOUD_STORAGE = 1
    BIGQUERY = 2

  resource = _messages.StringField(1)
  service = _messages.EnumField('ServiceValueValuesEnum', 2)


class GoogleCloudDatacatalogV1DataStreamSpec(_messages.Message):
  r"""Additional specification of a data stream.

  Fields:
    kafkaTopic: Fields specific to a Kafka topic. Present only on entries
      representing Kafka topics.
  """

  kafkaTopic = _messages.MessageField('GoogleCloudDatacatalogV1KafkaTopicSpec', 1)


class GoogleCloudDatacatalogV1DatabaseTableSpec(_messages.Message):
  r"""Specification that applies to a table resource. Only valid for entries
  of `TABLE` type.

  Enums:
    TypeValueValuesEnum: Type of this table.

  Fields:
    type: Type of this table.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of this table.

    Values:
      TABLE_TYPE_UNSPECIFIED: Default unknown table type.
      NATIVE: Native table.
      EXTERNAL: External table.
    """
    TABLE_TYPE_UNSPECIFIED = 0
    NATIVE = 1
    EXTERNAL = 2

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class GoogleCloudDatacatalogV1Entry(_messages.Message):
  r"""Entry Metadata. A Data Catalog Entry resource represents another
  resource in Google Cloud Platform (such as a BigQuery dataset or a Pub/Sub
  topic) or outside of Google Cloud Platform. Clients can use the
  `linked_resource` field in the Entry resource to refer to the original
  resource ID of the source system. An Entry resource contains resource
  details, such as its schema. An Entry can also be used to attach flexible
  metadata, such as a Tag.

  Enums:
    IntegratedSystemValueValuesEnum: Output only. This field indicates the
      entry's source system that Data Catalog integrates with, such as
      BigQuery or Pub/Sub.
    TypeValueValuesEnum: The type of the entry. Only used for Entries with
      types in the EntryType enum.

  Fields:
    bigqueryDateShardedSpec: Specification for a group of BigQuery tables with
      name pattern `[prefix]YYYYMMDD`. Context:
      https://cloud.google.com/bigquery/docs/partitioned-
      tables#partitioning_versus_sharding.
    bigqueryTableSpec: Specification that applies to a BigQuery table. This is
      only valid on entries of type `TABLE`.
    clusterSpec: Additional specification of a cluster. Present on entries
      representing clusters.
    dataSource: Output only. Physical location of the entry.
    dataStreamSpec: Additional specification of a data stream. Present on
      entries representing non-pubsub data streams.
    databaseTableSpec: Specification that applies to a table resource. Only
      valid for entries of `TABLE` type.
    description: Entry description that can consist of several sentences or
      paragraphs that describe entry contents. The description must not
      contain Unicode non-characters as well as C0 and C1 control codes except
      tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
      The maximum size is 2000 bytes when encoded in UTF-8. Default value is
      an empty string.
    displayName: Display name of an entry. The name must contain only Unicode
      letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and
      can't start or end with spaces. The maximum size is 200 bytes when
      encoded in UTF-8. Default value is an empty string.
    fullyQualifiedName: Fully qualified name (FQN) of the resource. Set
      automatically for entries representing resources from synced systems.
      Settable only during creation and read-only afterwards. Can be used for
      search and lookup of the entries. FQNs take two forms: * For non-
      regionalized resources:
      `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` * For
      regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOU
      RCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metastore:
      project_id.location_id.instance_id.database_id.table_id`
    gcsFilesetSpec: Specification that applies to a Cloud Storage fileset.
      This is only valid on entries of type FILESET.
    integratedSystem: Output only. This field indicates the entry's source
      system that Data Catalog integrates with, such as BigQuery or Pub/Sub.
    linkedResource: The resource this metadata entry refers to. For Google
      Cloud Platform resources, `linked_resource` is the [full name of the res
      ource](https://cloud.google.com/apis/design/resource_names#full_resource
      _name). For example, the `linked_resource` for a table resource from
      BigQuery is: `//bigquery.googleapis.com/projects/{projectId}/datasets/{d
      atasetId}/tables/{tableId}` Output only when entry is one of the types
      in the `EntryType` enum. For entries with a `user_specified_type`, this
      field is optional and defaults to an empty string. The resource string
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      periods (.), colons (:), slashes (/), dashes (-), and hashes (#). The
      maximum size is 200 bytes when encoded in UTF-8.
    name: Output only. The resource name of an entry in URL format. Example: `
      projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/
      entries/{entry_id}` Note: The entry itself and its child resources might
      not be stored in the location specified in its name.
    schema: Schema of the entry. An entry might not have any schema attached
      to it.
    sourceSystemTimestamps: Timestamps about the underlying resource, not
      about this Data Catalog entry. Output only when Entry is of type in the
      EntryType enum. For entries with user_specified_type, this field is
      optional and defaults to an empty timestamp.
    type: The type of the entry. Only used for Entries with types in the
      EntryType enum.
    userSpecifiedSystem: This field indicates the entry's source system that
      Data Catalog does not integrate with. `user_specified_system` strings
      must begin with a letter or underscore and can only contain letters,
      numbers, and underscores; are case insensitive; must be at least 1
      character and at most 64 characters long.
    userSpecifiedType: Entry type if it does not fit any of the input-allowed
      values listed in `EntryType` enum above. When creating an entry, users
      should check the enum values first, if nothing matches the entry to be
      created, then provide a custom value, for example "my_special_type".
      `user_specified_type` strings must begin with a letter or underscore and
      can only contain letters, numbers, and underscores; are case
      insensitive; must be at least 1 character and at most 64 characters
      long. Currently, only FILESET enum value is allowed. All other entries
      created through Data Catalog must use `user_specified_type`.
  """

  class IntegratedSystemValueValuesEnum(_messages.Enum):
    r"""Output only. This field indicates the entry's source system that Data
    Catalog integrates with, such as BigQuery or Pub/Sub.

    Values:
      INTEGRATED_SYSTEM_UNSPECIFIED: Default unknown system.
      BIGQUERY: BigQuery.
      CLOUD_PUBSUB: Cloud Pub/Sub.
      DATAPROC_METASTORE: Dataproc Metastore.
    """
    INTEGRATED_SYSTEM_UNSPECIFIED = 0
    BIGQUERY = 1
    CLOUD_PUBSUB = 2
    DATAPROC_METASTORE = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the entry. Only used for Entries with types in the
    EntryType enum.

    Values:
      ENTRY_TYPE_UNSPECIFIED: Default unknown type.
      TABLE: Output only. The type of entry that has a GoogleSQL schema,
        including logical views.
      MODEL: Output only. The type of models, examples include
        https://cloud.google.com/bigquery-ml/docs/bigqueryml-intro
      DATA_STREAM: An entry type which is used for streaming entries. Example:
        Pub/Sub topic.
      FILESET: An entry type which is a set of files or objects. Example:
        Cloud Storage fileset.
      CLUSTER: A group of servers that work together. Example: Kafka cluster.
      DATABASE: A database.
      SERVICE: A service, for example, a Dataproc Metastore service.
    """
    ENTRY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    MODEL = 2
    DATA_STREAM = 3
    FILESET = 4
    CLUSTER = 5
    DATABASE = 6
    SERVICE = 7

  bigqueryDateShardedSpec = _messages.MessageField('GoogleCloudDatacatalogV1BigQueryDateShardedSpec', 1)
  bigqueryTableSpec = _messages.MessageField('GoogleCloudDatacatalogV1BigQueryTableSpec', 2)
  clusterSpec = _messages.MessageField('GoogleCloudDatacatalogV1ClusterSpec', 3)
  dataSource = _messages.MessageField('GoogleCloudDatacatalogV1DataSource', 4)
  dataStreamSpec = _messages.MessageField('GoogleCloudDatacatalogV1DataStreamSpec', 5)
  databaseTableSpec = _messages.MessageField('GoogleCloudDatacatalogV1DatabaseTableSpec', 6)
  description = _messages.StringField(7)
  displayName = _messages.StringField(8)
  fullyQualifiedName = _messages.StringField(9)
  gcsFilesetSpec = _messages.MessageField('GoogleCloudDatacatalogV1GcsFilesetSpec', 10)
  integratedSystem = _messages.EnumField('IntegratedSystemValueValuesEnum', 11)
  linkedResource = _messages.StringField(12)
  name = _messages.StringField(13)
  schema = _messages.MessageField('GoogleCloudDatacatalogV1Schema', 14)
  sourceSystemTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 15)
  type = _messages.EnumField('TypeValueValuesEnum', 16)
  userSpecifiedSystem = _messages.StringField(17)
  userSpecifiedType = _messages.StringField(18)


class GoogleCloudDatacatalogV1EntryGroup(_messages.Message):
  r"""EntryGroup Metadata. An EntryGroup resource represents a logical
  grouping of zero or more Data Catalog Entry resources.

  Fields:
    dataCatalogTimestamps: Output only. Timestamps about this EntryGroup.
      Default value is empty timestamps.
    description: Entry group description, which can consist of several
      sentences or paragraphs that describe entry group contents. Default
      value is an empty string.
    displayName: A short name to identify the entry group, for example,
      "analytics data - jan 2011". Default value is an empty string.
    name: The resource name of the entry group in URL format. Example:
      `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
      ` Note: The entry group itself and its child resources might not be
      stored in the location specified in its name.
  """

  dataCatalogTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)


class GoogleCloudDatacatalogV1ExportTaxonomiesResponse(_messages.Message):
  r"""Response message for ExportTaxonomies.

  Fields:
    taxonomies: List of taxonomies and policy tags as nested protos.
  """

  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1SerializedTaxonomy', 1, repeated=True)


class GoogleCloudDatacatalogV1FieldType(_messages.Message):
  r"""A GoogleCloudDatacatalogV1FieldType object.

  Enums:
    PrimitiveTypeValueValuesEnum: Represents primitive types - string, bool
      etc.

  Fields:
    enumType: Represents an enum type.
    primitiveType: Represents primitive types - string, bool etc.
  """

  class PrimitiveTypeValueValuesEnum(_messages.Enum):
    r"""Represents primitive types - string, bool etc.

    Values:
      PRIMITIVE_TYPE_UNSPECIFIED: This is the default invalid value for a
        type.
      DOUBLE: A double precision number.
      STRING: An UTF-8 string.
      BOOL: A boolean value.
      TIMESTAMP: A timestamp.
    """
    PRIMITIVE_TYPE_UNSPECIFIED = 0
    DOUBLE = 1
    STRING = 2
    BOOL = 3
    TIMESTAMP = 4

  enumType = _messages.MessageField('GoogleCloudDatacatalogV1FieldTypeEnumType', 1)
  primitiveType = _messages.EnumField('PrimitiveTypeValueValuesEnum', 2)


class GoogleCloudDatacatalogV1FieldTypeEnumType(_messages.Message):
  r"""A GoogleCloudDatacatalogV1FieldTypeEnumType object.

  Fields:
    allowedValues: The set of allowed values for this enum. This set must not
      be empty and can include up to 100 allowed values. The display names of
      the values in this set must not be empty and must be case-insensitively
      unique within this set. The order of items in this set is preserved.
      This field can be used to create, remove and reorder enum values. To
      rename enum values, use the `RenameTagTemplateFieldEnumValue` method.
  """

  allowedValues = _messages.MessageField('GoogleCloudDatacatalogV1FieldTypeEnumTypeEnumValue', 1, repeated=True)


class GoogleCloudDatacatalogV1FieldTypeEnumTypeEnumValue(_messages.Message):
  r"""A GoogleCloudDatacatalogV1FieldTypeEnumTypeEnumValue object.

  Fields:
    displayName: Required. The display name of the enum value. Must not be an
      empty string. The name must contain only Unicode letters, numbers (0-9),
      underscores (_), dashes (-), spaces ( ), and can't start or end with
      spaces. The maximum length is 200 characters.
  """

  displayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1GcsFileSpec(_messages.Message):
  r"""Specifications of a single file in Cloud Storage.

  Fields:
    filePath: Required. The full file path. Example:
      `gs://bucket_name/a/b.txt`.
    gcsTimestamps: Output only. Timestamps about the Cloud Storage file.
    sizeBytes: Output only. The size of the file, in bytes.
  """

  filePath = _messages.StringField(1)
  gcsTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 2)
  sizeBytes = _messages.IntegerField(3)


class GoogleCloudDatacatalogV1GcsFilesetSpec(_messages.Message):
  r"""Describes a Cloud Storage fileset entry.

  Fields:
    filePatterns: Required. Patterns to identify a set of files in Google
      Cloud Storage. See [Cloud Storage documentation](https://cloud.google.co
      m/storage/docs/gsutil/addlhelp/WildcardNames) for more information. Note
      that bucket wildcards are currently not supported. Examples of valid
      file_patterns: * `gs://bucket_name/dir/*`: matches all files within
      `bucket_name/dir` directory. * `gs://bucket_name/dir/**`: matches all
      files in `bucket_name/dir` spanning all subdirectories. *
      `gs://bucket_name/file*`: matches files prefixed by `file` in
      `bucket_name` * `gs://bucket_name/??.txt`: matches files with two
      characters followed by `.txt` in `bucket_name` *
      `gs://bucket_name/[aeiou].txt`: matches files that contain a single
      vowel character followed by `.txt` in `bucket_name` *
      `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
      or `m` followed by `.txt` in `bucket_name` * `gs://bucket_name/a/*/b`:
      matches all files in `bucket_name` that match `a/*/b` pattern, such as
      `a/c/b`, `a/d/b` * `gs://another_bucket/a.txt`: matches
      `gs://another_bucket/a.txt` You can combine wildcards to provide more
      powerful matches, for example: * `gs://bucket_name/[a-m]??.j*g`
    sampleGcsFileSpecs: Output only. Sample files contained in this fileset,
      not all files contained in this fileset are represented here.
  """

  filePatterns = _messages.StringField(1, repeated=True)
  sampleGcsFileSpecs = _messages.MessageField('GoogleCloudDatacatalogV1GcsFileSpec', 2, repeated=True)


class GoogleCloudDatacatalogV1ImportTaxonomiesRequest(_messages.Message):
  r"""Request message for ImportTaxonomies.

  Fields:
    crossRegionalSource: Cross-regional source taxonomy to be imported.
    inlineSource: Inline source used for taxonomies import.
  """

  crossRegionalSource = _messages.MessageField('GoogleCloudDatacatalogV1CrossRegionalSource', 1)
  inlineSource = _messages.MessageField('GoogleCloudDatacatalogV1InlineSource', 2)


class GoogleCloudDatacatalogV1ImportTaxonomiesResponse(_messages.Message):
  r"""Response message for ImportTaxonomies.

  Fields:
    taxonomies: Taxonomies that were imported.
  """

  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 1, repeated=True)


class GoogleCloudDatacatalogV1InlineSource(_messages.Message):
  r"""Inline source containing taxonomies to import.

  Fields:
    taxonomies: Required. Taxonomies to be imported.
  """

  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1SerializedTaxonomy', 1, repeated=True)


class GoogleCloudDatacatalogV1KafkaClusterSpec(_messages.Message):
  r"""Entry spec describing a Kafka cluster.

  Fields:
    bootstrapServers: Required. A comma-separated list of host and port pairs
      that are the addresses of the Kafka brokers in a "bootstrap" Kafka
      cluster that a Kafka client connects to initially to bootstrap itself.
      Format is the same that is used for bootstrap.servers configuration
      property for Kafka clients. Example:
      host1:port1,host2:port2,host3:port3. See
      https://kafka.apache.org/documentation/#bootstrap.servers
    propertiesGcsUri: URI to Google Cloud Storage properties file with
      additional properties needed to connect to the cluster represented by
      this Entry. Properties stored in the file are passed to Kafka Consumer
      by query engines wishing to connect to the cluster. The full range of
      properties supported by query engines is dependant on the engine. The
      properties file should be a valid Kafka consumer config file, see
      https://kafka.apache.org/documentation/#consumerconfigs. For SSL
      authorization, if supported by the query engine, keystore and truststore
      paths will be interpreted relative to the properties file. Example:
      gs://my_bucket/kafka/consumer.properties
  """

  bootstrapServers = _messages.StringField(1)
  propertiesGcsUri = _messages.StringField(2)


class GoogleCloudDatacatalogV1KafkaTopicSpec(_messages.Message):
  r"""Entry spec describing a Kafka topic.

  Fields:
    clusterEntry: Required. Name of the entry representing Kafka cluster this
      topic is a part of. Example:
      'projects/my_project/locations/us/entryGroups/kafka/entries/my_cluster'.
    topic: Required. Name of the Kafka topic this Entry represents. Example:
      'my_topic'.
  """

  clusterEntry = _messages.StringField(1)
  topic = _messages.StringField(2)


class GoogleCloudDatacatalogV1ListEntriesResponse(_messages.Message):
  r"""Response message for ListEntries.

  Fields:
    entries: Entry details.
    nextPageToken: Token to retrieve the next page of results. It is set to
      empty if no items remain in results.
  """

  entries = _messages.MessageField('GoogleCloudDatacatalogV1Entry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDatacatalogV1ListEntryGroupsResponse(_messages.Message):
  r"""Response message for ListEntryGroups.

  Fields:
    entryGroups: EntryGroup details.
    nextPageToken: Token to retrieve the next page of results. It is set to
      empty if no items remain in results.
  """

  entryGroups = _messages.MessageField('GoogleCloudDatacatalogV1EntryGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDatacatalogV1ListPolicyTagsResponse(_messages.Message):
  r"""Response message for ListPolicyTags.

  Fields:
    nextPageToken: Token used to retrieve the next page of results, or empty
      if there are no more results in the list.
    policyTags: The policy tags that are in the requested taxonomy.
  """

  nextPageToken = _messages.StringField(1)
  policyTags = _messages.MessageField('GoogleCloudDatacatalogV1PolicyTag', 2, repeated=True)


class GoogleCloudDatacatalogV1ListTagsResponse(_messages.Message):
  r"""Response message for ListTags.

  Fields:
    nextPageToken: Token to retrieve the next page of results. It is set to
      empty if no items remain in results.
    tags: Tag details.
  """

  nextPageToken = _messages.StringField(1)
  tags = _messages.MessageField('GoogleCloudDatacatalogV1Tag', 2, repeated=True)


class GoogleCloudDatacatalogV1ListTaxonomiesResponse(_messages.Message):
  r"""Response message for ListTaxonomies.

  Fields:
    nextPageToken: Token used to retrieve the next page of results, or empty
      if there are no more results in the list.
    taxonomies: Taxonomies that the project contains.
  """

  nextPageToken = _messages.StringField(1)
  taxonomies = _messages.MessageField('GoogleCloudDatacatalogV1Taxonomy', 2, repeated=True)


class GoogleCloudDatacatalogV1PhysicalSchema(_messages.Message):
  r"""Native schema used by a resource represented as an entry. Used by query
  engines for deserializing and parsing source data.

  Fields:
    avro: Schema in Avro JSON format.
    csv: Marks a CSV-encoded data source.
    orc: Marks an ORC-encoded data source.
    parquet: Marks a Parquet-encoded data source.
    protobuf: Schema in Protobuf format.
    thrift: Schema in Thrift format.
  """

  avro = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaAvroSchema', 1)
  csv = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaCsvSchema', 2)
  orc = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaOrcSchema', 3)
  parquet = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaParquetSchema', 4)
  protobuf = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchema', 5)
  thrift = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchemaThriftSchema', 6)


class GoogleCloudDatacatalogV1PhysicalSchemaAvroSchema(_messages.Message):
  r"""Schema in Avro JSON format.

  Fields:
    text: Required. JSON source of the Avro schema.
  """

  text = _messages.StringField(1)


class GoogleCloudDatacatalogV1PhysicalSchemaCsvSchema(_messages.Message):
  r"""Marks a CSV-encoded data source."""


class GoogleCloudDatacatalogV1PhysicalSchemaOrcSchema(_messages.Message):
  r"""Marks an ORC-encoded data source."""


class GoogleCloudDatacatalogV1PhysicalSchemaParquetSchema(_messages.Message):
  r"""Marks a Parquet-encoded data source."""


class GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchema(_messages.Message):
  r"""Schema in Protobuf format.

  Fields:
    text: Required. proto source of the schema.
  """

  text = _messages.StringField(1)


class GoogleCloudDatacatalogV1PhysicalSchemaThriftSchema(_messages.Message):
  r"""Schema in Thrift format.

  Fields:
    text: Required. Thrift IDL source of the schema.
  """

  text = _messages.StringField(1)


class GoogleCloudDatacatalogV1PolicyTag(_messages.Message):
  r"""Denotes one policy tag in a taxonomy (e.g. ssn). Policy tags can be
  defined in a hierarchy. For example, consider the following hierarchy: ``` +
  Geolocation + LatLong + City + ZipCode ``` Policy tag "Geolocation" contains
  3 child policy tags: "LatLong", "City", and "ZipCode".

  Fields:
    childPolicyTags: Output only. Resource names of child policy tags of this
      policy tag.
    description: Description of this policy tag. It must: contain only unicode
      characters, tabs, newlines, carriage returns and page breaks; and be at
      most 2000 bytes long when encoded in UTF-8. If not set, defaults to an
      empty description. If not set, defaults to an empty description.
    displayName: Required. User-defined name of this policy tag. It must: be
      unique within the parent taxonomy; contain only unicode letters,
      numbers, underscores, dashes and spaces; not start or end with spaces;
      and be at most 200 bytes long when encoded in UTF-8.
    name: Output only. Resource name of this policy tag in format: "projects/{
      project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyT
      ags/{policy_tag_id}". Both taxonomy_ids and policy_tag_ids are unique
      and generated by Policy Tag Manager.
    parentPolicyTag: Resource name of this policy tag's parent policy tag
      (e.g. for the "LatLong" policy tag in the example above, this field
      contains the resource name of the "Geolocation" policy tag). If empty,
      it means this policy tag is a top level policy tag (e.g. this field is
      empty for the "Geolocation" policy tag in the example above). If not
      set, defaults to an empty string.
  """

  childPolicyTags = _messages.StringField(1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  parentPolicyTag = _messages.StringField(5)


class GoogleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest(_messages.Message):
  r"""Request message for RenameTagTemplateFieldEnumValue.

  Fields:
    newEnumValueDisplayName: Required. The new display name of the enum value.
      For example, `my_new_enum_value`.
  """

  newEnumValueDisplayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1RenameTagTemplateFieldRequest(_messages.Message):
  r"""Request message for RenameTagTemplateField.

  Fields:
    newTagTemplateFieldId: Required. The new ID of this tag template field.
      For example, `my_new_field`.
  """

  newTagTemplateFieldId = _messages.StringField(1)


class GoogleCloudDatacatalogV1ReplaceTaxonomyRequest(_messages.Message):
  r"""Request message for ReplaceTaxonomy.

  Fields:
    serializedTaxonomy: Required. Taxonomy to update along with its child
      policy tags.
  """

  serializedTaxonomy = _messages.MessageField('GoogleCloudDatacatalogV1SerializedTaxonomy', 1)


class GoogleCloudDatacatalogV1Schema(_messages.Message):
  r"""Represents a schema (e.g. BigQuery, GoogleSQL, Avro schema).

  Fields:
    columns: The unified GoogleSQL-like schema of columns. The overall maximum
      number of columns and nested columns is 10,000. The maximum nested depth
      is 15 levels.
    physicalSchema: Physical Schema is the native schema used to encode the
      data represented by this entry.
  """

  columns = _messages.MessageField('GoogleCloudDatacatalogV1ColumnSchema', 1, repeated=True)
  physicalSchema = _messages.MessageField('GoogleCloudDatacatalogV1PhysicalSchema', 2)


class GoogleCloudDatacatalogV1SearchCatalogRequest(_messages.Message):
  r"""Request message for SearchCatalog.

  Fields:
    orderBy: Specifies the ordering of results, currently supported case-
      sensitive choices are: * `relevance`, only supports descending *
      `last_modified_timestamp [asc|desc]`, defaults to descending if not
      specified If not specified, defaults to `relevance` descending.
    pageSize: Number of results in the search page. If <=0 then defaults to
      10. Max limit for page_size is 1000. Throws an invalid argument for
      page_size > 1000.
    pageToken: Optional. Pagination token returned in an earlier
      SearchCatalogResponse.next_page_token, which indicates that this is a
      continuation of a prior SearchCatalogRequest call, and that the system
      should return the next page of data. If empty, the first page is
      returned.
    query: Optional. The query string in search query syntax. An empty query
      string will result in all data assets (in the specified scope) that the
      user has access to. Query strings can be simple as "x" or more qualified
      as: * name:x * column:x * description:y Note: Query tokens need to have
      a minimum of 3 characters for substring matching to work correctly. See
      [Data Catalog Search Syntax](https://cloud.google.com/data-
      catalog/docs/how-to/search-reference) for more information.
    scope: Required. The scope of this search request. A `scope` that has
      empty `include_org_ids`, `include_project_ids` AND false
      `include_gcp_public_datasets` is considered invalid. Data Catalog will
      return an error in such a case.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  query = _messages.StringField(4)
  scope = _messages.MessageField('GoogleCloudDatacatalogV1SearchCatalogRequestScope', 5)


class GoogleCloudDatacatalogV1SearchCatalogRequestScope(_messages.Message):
  r"""The criteria that select the subspace used for query matching.

  Fields:
    includeGcpPublicDatasets: If `true`, include Google Cloud Platform (GCP)
      public datasets in the search results. Info on GCP public datasets is
      available at https://cloud.google.com/public-datasets/. By default, GCP
      public datasets are excluded.
    includeOrgIds: The list of organization IDs to search within. To find your
      organization ID, follow instructions in
      https://cloud.google.com/resource-manager/docs/creating-managing-
      organization.
    includeProjectIds: The list of project IDs to search within. To learn more
      about the distinction between project names/IDs/numbers, go to
      https://cloud.google.com/docs/overview/#projects.
    restrictedLocations: Optional. The list of locations to search within. 1.
      If empty, search will be performed in all locations; 2. If any of the
      locations are NOT [supported regions](https://cloud.google.com/data-
      catalog/docs/concepts/regions#supported_regions), error will be
      returned; 3. Otherwise, search only the given locations for matching
      results. Typical usage is to leave this field empty. When a location is
      unreachable as returned in the `SearchCatalogResponse.unreachable`
      field, users can repeat the search request with this parameter set to
      get additional information on the error.
  """

  includeGcpPublicDatasets = _messages.BooleanField(1)
  includeOrgIds = _messages.StringField(2, repeated=True)
  includeProjectIds = _messages.StringField(3, repeated=True)
  restrictedLocations = _messages.StringField(4, repeated=True)


class GoogleCloudDatacatalogV1SearchCatalogResponse(_messages.Message):
  r"""Response message for SearchCatalog.

  Fields:
    nextPageToken: The token that can be used to retrieve the next page of
      results.
    results: Search results.
    unreachable: Unreachable locations. Search result does not include data
      from those locations. Users can get additional information on the error
      by repeating the search request with a more restrictive parameter --
      setting the value for
      `SearchDataCatalogRequest.scope.restricted_locations`.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('GoogleCloudDatacatalogV1SearchCatalogResult', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudDatacatalogV1SearchCatalogResult(_messages.Message):
  r"""A result that appears in the response of a search request. Each result
  captures details of one entry that matches the search.

  Enums:
    IntegratedSystemValueValuesEnum: Output only. This field indicates the
      entry's source system that Data Catalog integrates with, such as
      BigQuery or Cloud Pub/Sub.
    SearchResultTypeValueValuesEnum: Type of the search result. This field can
      be used to determine which Get method to call to fetch the full
      resource.

  Fields:
    fullyQualifiedName: Fully Qualified Name of the resource. There are two
      main forms of FQNs: {system}:{project}.{dot-separated path to resource}
      for non-regionalized resources {system}:{project}.{location id}.{dot-
      separated path to resource} for regionalized resources Examples: *
      dataproc_metastore:projectId.locationId.instanceId.databaseId.tableId *
      bigquery:table.project_id.dataset_id.table_id
    integratedSystem: Output only. This field indicates the entry's source
      system that Data Catalog integrates with, such as BigQuery or Cloud
      Pub/Sub.
    linkedResource: The full name of the cloud resource the entry belongs to.
      See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name.
      Example: * `//bigquery.googleapis.com/projects/projectId/datasets/datase
      tId/tables/tableId`
    modifyTime: Last-modified timestamp of the entry from the managing system.
    relativeResourceName: The relative resource name of the resource in URL
      format. Examples: * `projects/{project_id}/locations/{location_id}/entry
      Groups/{entry_group_id}/entries/{entry_id}` *
      `projects/{project_id}/tagTemplates/{tag_template_id}`
    searchResultSubtype: Sub-type of the search result. This is a dot-
      delimited description of the resource's full type, and is the same as
      the value callers would provide in the "type" search facet. Examples:
      `entry.table`, `entry.dataStream`, `tagTemplate`.
    searchResultType: Type of the search result. This field can be used to
      determine which Get method to call to fetch the full resource.
    userSpecifiedSystem: This field indicates the entry's source system that
      Data Catalog does not integrate with.
  """

  class IntegratedSystemValueValuesEnum(_messages.Enum):
    r"""Output only. This field indicates the entry's source system that Data
    Catalog integrates with, such as BigQuery or Cloud Pub/Sub.

    Values:
      INTEGRATED_SYSTEM_UNSPECIFIED: Default unknown system.
      BIGQUERY: BigQuery.
      CLOUD_PUBSUB: Cloud Pub/Sub.
      DATAPROC_METASTORE: Dataproc Metastore.
    """
    INTEGRATED_SYSTEM_UNSPECIFIED = 0
    BIGQUERY = 1
    CLOUD_PUBSUB = 2
    DATAPROC_METASTORE = 3

  class SearchResultTypeValueValuesEnum(_messages.Enum):
    r"""Type of the search result. This field can be used to determine which
    Get method to call to fetch the full resource.

    Values:
      SEARCH_RESULT_TYPE_UNSPECIFIED: Default unknown type.
      ENTRY: An Entry.
      TAG_TEMPLATE: A TagTemplate.
      ENTRY_GROUP: An EntryGroup.
    """
    SEARCH_RESULT_TYPE_UNSPECIFIED = 0
    ENTRY = 1
    TAG_TEMPLATE = 2
    ENTRY_GROUP = 3

  fullyQualifiedName = _messages.StringField(1)
  integratedSystem = _messages.EnumField('IntegratedSystemValueValuesEnum', 2)
  linkedResource = _messages.StringField(3)
  modifyTime = _messages.StringField(4)
  relativeResourceName = _messages.StringField(5)
  searchResultSubtype = _messages.StringField(6)
  searchResultType = _messages.EnumField('SearchResultTypeValueValuesEnum', 7)
  userSpecifiedSystem = _messages.StringField(8)


class GoogleCloudDatacatalogV1SerializedPolicyTag(_messages.Message):
  r"""Message representing one policy tag, including all its descendant policy
  tags, as a nested proto.

  Fields:
    childPolicyTags: Children of the policy tag, if any.
    description: Description of the serialized policy tag. The length of the
      description is limited to 2000 bytes when encoded in UTF-8. If not set,
      defaults to an empty description.
    displayName: Required. Display name of the policy tag. At most 200 bytes
      when encoded in UTF-8.
    policyTag: Resource name of the policy tag. This field will be ignored
      when calling ImportTaxonomies.
  """

  childPolicyTags = _messages.MessageField('GoogleCloudDatacatalogV1SerializedPolicyTag', 1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  policyTag = _messages.StringField(4)


class GoogleCloudDatacatalogV1SerializedTaxonomy(_messages.Message):
  r"""Message representing a taxonomy, including its policy tags in hierarchy,
  as a nested proto. Used for taxonomy replacement, import, and export.

  Enums:
    ActivatedPolicyTypesValueListEntryValuesEnum:

  Fields:
    activatedPolicyTypes: A list of policy types that are activated per
      taxonomy.
    description: Description of the serialized taxonomy. At most 2000 bytes
      when encoded in UTF-8. If not set, defaults to an empty description.
    displayName: Required. Display name of the taxonomy. At most 200 bytes
      when encoded in UTF-8.
    policyTags: Top level policy tags associated with the taxonomy, if any.
  """

  class ActivatedPolicyTypesValueListEntryValuesEnum(_messages.Enum):
    r"""ActivatedPolicyTypesValueListEntryValuesEnum enum type.

    Values:
      POLICY_TYPE_UNSPECIFIED: Unspecified policy type.
      FINE_GRAINED_ACCESS_CONTROL: Fine-grained access control policy, which
        enables access control on tagged sub-resources.
    """
    POLICY_TYPE_UNSPECIFIED = 0
    FINE_GRAINED_ACCESS_CONTROL = 1

  activatedPolicyTypes = _messages.EnumField('ActivatedPolicyTypesValueListEntryValuesEnum', 1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  policyTags = _messages.MessageField('GoogleCloudDatacatalogV1SerializedPolicyTag', 4, repeated=True)


class GoogleCloudDatacatalogV1SystemTimestamps(_messages.Message):
  r"""Timestamps about this resource according to a particular system.

  Fields:
    createTime: The creation time of the resource within the given system.
    expireTime: Output only. The expiration time of the resource within the
      given system. Currently only apllicable to BigQuery resources.
    updateTime: The last-modified time of the resource within the given
      system.
  """

  createTime = _messages.StringField(1)
  expireTime = _messages.StringField(2)
  updateTime = _messages.StringField(3)


class GoogleCloudDatacatalogV1TableSpec(_messages.Message):
  r"""Normal BigQuery table spec.

  Fields:
    groupedEntry: Output only. If the table is a dated shard, i.e., with name
      pattern `[prefix]YYYYMMDD`, `grouped_entry` is the Data Catalog resource
      name of the date sharded grouped entry, for example, `projects/{project_
      id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}
      `. Otherwise, `grouped_entry` is empty.
  """

  groupedEntry = _messages.StringField(1)


class GoogleCloudDatacatalogV1Tag(_messages.Message):
  r"""Tags are used to attach custom metadata to Data Catalog resources. Tags
  conform to the specifications within their tag template. See [Data Catalog
  IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for
  information on the permissions needed to create or view tags.

  Messages:
    FieldsValue: Required. This maps the ID of a tag field to the value of and
      additional information about that field. Valid field IDs are defined by
      the tag's template. A tag must have at least 1 field and at most 500
      fields.

  Fields:
    column: Resources like entry can have schemas associated with them. This
      scope allows users to attach tags to an individual column based on that
      schema. To attach a tag to a nested column, separate column names with a
      dot (`.`). Example: `column.nested_column`.
    fields: Required. This maps the ID of a tag field to the value of and
      additional information about that field. Valid field IDs are defined by
      the tag's template. A tag must have at least 1 field and at most 500
      fields.
    name: The resource name of the tag in URL format. Example: `projects/{proj
      ect_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry
      _id}/tags/{tag_id}` where `tag_id` is a system-generated identifier.
      Note: The tag itself might not be stored in the location specified in
      its name.
    template: Required. The resource name of the tag template that this tag
      uses. Example: `projects/{project_id}/locations/{location}/tagTemplates/
      {tag_template_id}` This field cannot be modified after creation.
    templateDisplayName: Output only. The display name of the tag template.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Required. This maps the ID of a tag field to the value of and
    additional information about that field. Valid field IDs are defined by
    the tag's template. A tag must have at least 1 field and at most 500
    fields.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1TagField attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1TagField', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  column = _messages.StringField(1)
  fields = _messages.MessageField('FieldsValue', 2)
  name = _messages.StringField(3)
  template = _messages.StringField(4)
  templateDisplayName = _messages.StringField(5)


class GoogleCloudDatacatalogV1TagField(_messages.Message):
  r"""Contains the value and supporting information for a field within a Tag.

  Fields:
    boolValue: Holds the value for a tag field with boolean type.
    displayName: Output only. The display name of this field.
    doubleValue: Holds the value for a tag field with double type.
    enumValue: Holds the value for a tag field with enum type. This value must
      be one of the allowed values in the definition of this enum.
    order: Output only. The order of this field with respect to other fields
      in this tag. It can be set in Tag. For example, a higher value can
      indicate a more important field. The value can be negative. Multiple
      fields can have the same order, and field orders within a tag do not
      have to be sequential.
    stringValue: Holds the value for a tag field with string type. The maximum
      length is 2000 UTF-8 characters.
    timestampValue: Holds the value for a tag field with timestamp type.
  """

  boolValue = _messages.BooleanField(1)
  displayName = _messages.StringField(2)
  doubleValue = _messages.FloatField(3)
  enumValue = _messages.MessageField('GoogleCloudDatacatalogV1TagFieldEnumValue', 4)
  order = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  stringValue = _messages.StringField(6)
  timestampValue = _messages.StringField(7)


class GoogleCloudDatacatalogV1TagFieldEnumValue(_messages.Message):
  r"""Holds an enum value.

  Fields:
    displayName: The display name of the enum value.
  """

  displayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1TagTemplate(_messages.Message):
  r"""A tag template defines a tag, which can have one or more typed fields.
  The template is used to create and attach the tag to GCP resources. [Tag
  template roles](https://cloud.google.com/iam/docs/understanding-roles#data-
  catalog-roles) provide permissions to create, edit, and use the template.
  See, for example, the [TagTemplate User](https://cloud.google.com/data-
  catalog/docs/how-to/template-user) role, which includes permission to use
  the tag template to tag resources.

  Messages:
    FieldsValue: Required. Map of tag template field IDs to the settings for
      the field. This map is an exhaustive list of the allowed fields. This
      map must contain at least one field and at most 500 fields. The keys to
      this map are tag template field IDs. Field IDs can contain letters (both
      uppercase and lowercase), numbers (0-9) and underscores (_). Field IDs
      must be at least 1 character long and at most 64 characters long. Field
      IDs must start with a letter or underscore.

  Fields:
    displayName: Display name for this template. Defaults to an empty string.
      The name must contain only Unicode letters, numbers (0-9), underscores
      (_), dashes (-), spaces ( ), and can't start or end with spaces. The
      maximum length is 200 characters.
    fields: Required. Map of tag template field IDs to the settings for the
      field. This map is an exhaustive list of the allowed fields. This map
      must contain at least one field and at most 500 fields. The keys to this
      map are tag template field IDs. Field IDs can contain letters (both
      uppercase and lowercase), numbers (0-9) and underscores (_). Field IDs
      must be at least 1 character long and at most 64 characters long. Field
      IDs must start with a letter or underscore.
    name: The resource name of the tag template in URL format. Example: `proje
      cts/{project_id}/locations/{location}/tagTemplates/{tag_template_id}`
      Note: The tag template itself and its child resources might not be
      stored in the location specified in its name.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Required. Map of tag template field IDs to the settings for the field.
    This map is an exhaustive list of the allowed fields. This map must
    contain at least one field and at most 500 fields. The keys to this map
    are tag template field IDs. Field IDs can contain letters (both uppercase
    and lowercase), numbers (0-9) and underscores (_). Field IDs must be at
    least 1 character long and at most 64 characters long. Field IDs must
    start with a letter or underscore.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1TagTemplateField attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1TagTemplateField', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  fields = _messages.MessageField('FieldsValue', 2)
  name = _messages.StringField(3)


class GoogleCloudDatacatalogV1TagTemplateField(_messages.Message):
  r"""The template for an individual field within a tag template.

  Fields:
    description: The description for this field. Defaults to an empty string.
    displayName: The display name for this field. Defaults to an empty string.
      The name must contain only Unicode letters, numbers (0-9), underscores
      (_), dashes (-), spaces ( ), and can't start or end with spaces. The
      maximum length is 200 characters.
    isRequired: Whether this is a required field. Defaults to false.
    name: Output only. The resource name of the tag template field in URL
      format. Example: `projects/{project_id}/locations/{location}/tagTemplate
      s/{tag_template}/fields/{field}` Note: The `TagTemplateField` itself
      might not be stored in the location specified in its name. The name must
      contain only letters (a-z, A-Z), numbers (0-9), or underscores (_), and
      must start with a letter or underscore. The maximum length is 64
      characters.
    order: The order of this field with respect to other fields in this tag
      template. For example, a higher value can indicate a more important
      field. The value can be negative. Multiple fields can have the same
      order, and field orders within a tag do not have to be sequential.
    type: Required. The type of value this tag field can contain.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  isRequired = _messages.BooleanField(3)
  name = _messages.StringField(4)
  order = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  type = _messages.MessageField('GoogleCloudDatacatalogV1FieldType', 6)


class GoogleCloudDatacatalogV1Taxonomy(_messages.Message):
  r"""A taxonomy is a collection of hierarchical policy tags that classify
  data along a common axis. For instance a "data sensitivity" taxonomy could
  contain the following policy tags: ``` + PII + Account number + Age + SSN +
  Zipcode + Financials + Revenue ``` A "data origin" taxonomy could contain
  the following policy tags: ``` + User data + Employee data + Partner data +
  Public data ```

  Enums:
    ActivatedPolicyTypesValueListEntryValuesEnum:

  Fields:
    activatedPolicyTypes: Optional. A list of policy types that are activated
      for this taxonomy. If not set, defaults to an empty list.
    description: Optional. Description of this taxonomy. It must: contain only
      unicode characters, tabs, newlines, carriage returns and page breaks;
      and be at most 2000 bytes long when encoded in UTF-8. If not set,
      defaults to an empty description.
    displayName: Required. User-defined name of this taxonomy. It must:
      contain only unicode letters, numbers, underscores, dashes and spaces;
      not start or end with spaces; and be at most 200 bytes long when encoded
      in UTF-8.
    name: Output only. Resource name of this taxonomy in format: "projects/{pr
      oject_number}/locations/{location_id}/taxonomies/{taxonomy_id}". Note
      that taxonomy_id's are unique and generated by Policy Tag Manager.
    policyTagCount: Output only. Number of policy tags contained in this
      taxonomy.
    taxonomyTimestamps: Output only. Timestamps about this taxonomy. Only
      create_time and update_time are used.
  """

  class ActivatedPolicyTypesValueListEntryValuesEnum(_messages.Enum):
    r"""ActivatedPolicyTypesValueListEntryValuesEnum enum type.

    Values:
      POLICY_TYPE_UNSPECIFIED: Unspecified policy type.
      FINE_GRAINED_ACCESS_CONTROL: Fine-grained access control policy, which
        enables access control on tagged sub-resources.
    """
    POLICY_TYPE_UNSPECIFIED = 0
    FINE_GRAINED_ACCESS_CONTROL = 1

  activatedPolicyTypes = _messages.EnumField('ActivatedPolicyTypesValueListEntryValuesEnum', 1, repeated=True)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  policyTagCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  taxonomyTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1SystemTimestamps', 6)


class GoogleCloudDatacatalogV1ViewSpec(_messages.Message):
  r"""Table view specification.

  Fields:
    viewQuery: Output only. The query that defines the table view.
  """

  viewQuery = _messages.StringField(1)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
