"""Generated message classes for cloudfunctions version v2alpha.

Manages lightweight user-provided functions executed in response to events.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudfunctions'


class BuildConfig(_messages.Message):
  r"""Describes the Build step of the function that builds a container from
  the given source.

  Messages:
    EnvironmentVariablesValue: User-provided build-time environment variables
      for the function

  Fields:
    build: Output only. The Cloud Build name of the latest successful
      deployment of the function.
    entryPoint: The name of the function (as defined in source code) that will
      be executed. Defaults to the resource name suffix, if not specified. For
      backward compatibility, if function with given name is not found, then
      the system will try to use function named "function". For Node.js this
      is name of a function exported by the module specified in
      `source_location`.
    environmentVariables: User-provided build-time environment variables for
      the function
    runtime: The runtime in which to run the function. Required when deploying
      a new function, optional when updating an existing function. For a
      complete list of possible choices, see the [`gcloud` command reference](
      https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime
      ).
    source: The location of the function source code.
    workerPool: Name of the Cloud Build Custom Worker Pool that should be used
      to build the function. The format of this field is
      `projects/{project}/locations/{region}/workerPools/{workerPool}` where
      {project} and {region} are the project id and region respectively where
      the worker pool is defined and {workerPool} is the short name of the
      worker pool. If the project id is not the same as the function, then the
      Cloud Functions Service Agent (service-@gcf-admin-
      robot.iam.gserviceaccount.com) must be granted the role Cloud Build
      Custom Workers Builder (roles/cloudbuild.customworkers.builder) in the
      project.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvironmentVariablesValue(_messages.Message):
    r"""User-provided build-time environment variables for the function

    Messages:
      AdditionalProperty: An additional property for a
        EnvironmentVariablesValue object.

    Fields:
      additionalProperties: Additional properties of type
        EnvironmentVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvironmentVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  build = _messages.StringField(1)
  entryPoint = _messages.StringField(2)
  environmentVariables = _messages.MessageField('EnvironmentVariablesValue', 3)
  runtime = _messages.StringField(4)
  source = _messages.MessageField('Source', 5)
  workerPool = _messages.StringField(6)


class CloudfunctionsProjectsLocationsFunctionsCreateRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsFunctionsCreateRequest object.

  Fields:
    function: A Function resource to be passed as the request body.
    functionId: The ID to use for the function, which will become the final
      component of the function's resource name. This value should be 4-63
      characters, and valid characters are /a-z-/.
    parent: Required. The project and location in which the function should be
      created, specified in the format `projects/*/locations/*`
  """

  function = _messages.MessageField('Function', 1)
  functionId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudfunctionsProjectsLocationsFunctionsDeleteRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsFunctionsDeleteRequest object.

  Fields:
    name: Required. The name of the function which should be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudfunctionsProjectsLocationsFunctionsGenerateDownloadUrlRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsFunctionsGenerateDownloadUrlRequest
  object.

  Fields:
    generateDownloadUrlRequest: A GenerateDownloadUrlRequest resource to be
      passed as the request body.
    name: Required. The name of function for which source code Google Cloud
      Storage signed URL should be generated.
  """

  generateDownloadUrlRequest = _messages.MessageField('GenerateDownloadUrlRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudfunctionsProjectsLocationsFunctionsGenerateUploadUrlRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsFunctionsGenerateUploadUrlRequest
  object.

  Fields:
    generateUploadUrlRequest: A GenerateUploadUrlRequest resource to be passed
      as the request body.
    parent: Required. The project and location in which the Google Cloud
      Storage signed URL should be generated, specified in the format
      `projects/*/locations/*`.
  """

  generateUploadUrlRequest = _messages.MessageField('GenerateUploadUrlRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudfunctionsProjectsLocationsFunctionsGetRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsFunctionsGetRequest object.

  Fields:
    name: Required. The name of the function which details should be obtained.
  """

  name = _messages.StringField(1, required=True)


class CloudfunctionsProjectsLocationsFunctionsListRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsFunctionsListRequest object.

  Fields:
    pageSize: Maximum number of functions to return per call.
    pageToken: The value returned by the last `ListFunctionsResponse`;
      indicates that this is a continuation of a prior `ListFunctions` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the function should
      be listed, specified in the format `projects/*/locations/*` If you want
      to list functions in all locations, use "-" in place of a location. When
      listing functions in all locations, if one or more location(s) are
      unreachable, the response will contain functions from all reachable
      locations along with the names of any unreachable locations.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudfunctionsProjectsLocationsFunctionsPatchRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsFunctionsPatchRequest object.

  Fields:
    function: A Function resource to be passed as the request body.
    name: A user-defined name of the function. Function names must be unique
      globally and match pattern `projects/*/locations/*/functions/*`
    updateMask: The list of fields to be updated. If no field mask is
      provided, all provided fields in the request will be updated. To update
      all fields, provide a field mask of "*".
  """

  function = _messages.MessageField('Function', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudfunctionsProjectsLocationsListRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      will select a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudfunctionsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudfunctionsProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A CloudfunctionsProjectsLocationsOperationsListRequest object.

  Fields:
    filter: Required. A filter for matching the requested operations. The
      supported formats of *filter* are: To query for a specific function:
      project:*,location:*,function:* To query for all of the latest
      operations for a project: project:*,latest:true
    name: Must not be set.
    pageSize: The maximum number of records that should be returned. Requested
      page size cannot exceed 100. If not set, the default page size is 100.
      Pagination is only supported when querying for a specific function.
    pageToken: Token identifying which result to start with, which is returned
      by a previous list call. Pagination is only supported when querying for
      a specific function.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class EventFilter(_messages.Message):
  r"""Filters events based on exact matches on the CloudEvents attributes.

  Fields:
    attribute: Required. The name of a CloudEvents attribute.
    value: Required. The value for the attribute.
  """

  attribute = _messages.StringField(1)
  value = _messages.StringField(2)


class EventTrigger(_messages.Message):
  r"""Describes EventTrigger, used to request events to be sent from another
  service.

  Fields:
    eventFilters: Criteria used to filter events.
    eventType: Required. The type of event to observe. For example:
      `google.cloud.audit.log.v1.written` or
      `google.cloud.pubsub.topic.v1.messagePublished`.
    pubsubTopic: Optional. The name of a Pub/Sub topic in the same project
      that will be used as the transport topic for the event delivery. Format:
      `projects/{project}/topics/{topic}`. This is only valid for events of
      type `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided
      here will not be deleted at function deletion.
    serviceAccountEmail: Optional. The email of the trigger's service account.
      The service account must have permission to invoke Cloud Run services,
      the permission is `run.routes.invoke`. If empty, defaults to the Compute
      Engine default service account:
      `{project_number}-compute@developer.gserviceaccount.com`.
    trigger: Output only. The resource name of the Eventarc trigger. The
      format of this field is
      `projects/{project}/locations/{region}/triggers/{trigger}`.
    triggerRegion: The region that the trigger will be in. The trigger will
      only receive events originating in this region. It can be the same
      region as the function, a multi-region, or the global region. Cross-
      regional triggers are not permitted, i.e. triggers that are in a single-
      region location that is different than the function's region. If not
      provided, defaults to the same region as the function.
  """

  eventFilters = _messages.MessageField('EventFilter', 1, repeated=True)
  eventType = _messages.StringField(2)
  pubsubTopic = _messages.StringField(3)
  serviceAccountEmail = _messages.StringField(4)
  trigger = _messages.StringField(5)
  triggerRegion = _messages.StringField(6)


class Function(_messages.Message):
  r"""Describes a Cloud Function that contains user computation executed in
  response to an event. It encapsulate function and triggers configurations.

  Enums:
    StateValueValuesEnum: Output only. State of the function.

  Messages:
    LabelsValue: Labels associated with this Cloud Function.

  Fields:
    buildConfig: Describes the Build step of the function that builds a
      container from the given source.
    description: User-provided description of a function.
    eventTrigger: An Eventarc trigger managed by Google Cloud Functions that
      fires events in response to a condition in another service.
    labels: Labels associated with this Cloud Function.
    name: A user-defined name of the function. Function names must be unique
      globally and match pattern `projects/*/locations/*/functions/*`
    serviceConfig: Describes the Service being deployed. Currently deploys
      services to Cloud Run (fully managed).
    state: Output only. State of the function.
    updateTime: Output only. The last update timestamp of a Cloud Function.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the function.

    Values:
      STATE_UNSPECIFIED: Not specified. Invalid state.
      ACTIVE: Function has been successfully deployed and is serving.
      FAILED: Function deployment failed and the function isn't serving.
      DEPLOYING: Function is being created or updated.
      DELETING: Function is being deleted.
      UNKNOWN: Function deployment failed and the function serving state is
        undefined. The function should be updated or deleted to move it out of
        this state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    FAILED = 2
    DEPLOYING = 3
    DELETING = 4
    UNKNOWN = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels associated with this Cloud Function.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  buildConfig = _messages.MessageField('BuildConfig', 1)
  description = _messages.StringField(2)
  eventTrigger = _messages.MessageField('EventTrigger', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  serviceConfig = _messages.MessageField('ServiceConfig', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  updateTime = _messages.StringField(8)


class GenerateDownloadUrlRequest(_messages.Message):
  r"""Request of `GenerateDownloadUrl` method.

  Fields:
    versionId: The optional version of function. If not set, default, current
      version is used.
  """

  versionId = _messages.IntegerField(1, variant=_messages.Variant.UINT64)


class GenerateDownloadUrlResponse(_messages.Message):
  r"""Response of `GenerateDownloadUrl` method.

  Fields:
    downloadUrl: The generated Google Cloud Storage signed URL that should be
      used for function source code download.
  """

  downloadUrl = _messages.StringField(1)


class GenerateUploadUrlRequest(_messages.Message):
  r"""Request of `GenerateSourceUploadUrl` method."""


class GenerateUploadUrlResponse(_messages.Message):
  r"""Response of `GenerateSourceUploadUrl` method.

  Fields:
    storageSource: The location of the source code in the upload bucket. Once
      the archive is uploaded using the `upload_url` use this field to set the
      `function.build_config.source.storage_source` during CreateFunction and
      UpdateFunction. Generation defaults to 0, as Cloud Storage provides a
      new generation only upon uploading a new object or version of an object.
    uploadUrl: The generated Google Cloud Storage signed URL that should be
      used for a function source code upload. The uploaded file should be a
      zip archive which contains a function.
  """

  storageSource = _messages.MessageField('StorageSource', 1)
  uploadUrl = _messages.StringField(2)


class ListFunctionsResponse(_messages.Message):
  r"""Response for the `ListFunctions` method.

  Fields:
    functions: The functions that match the request.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations that could not be reached. The response does not
      include any functions from these locations.
  """

  functions = _messages.MessageField('Function', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: API version used to start the operation.
    cancelRequested: Identifies whether the user has requested cancellation of
      the operation. Operations that have successfully been cancelled have
      Operation.error value with a google.rpc.Status.code of 1, corresponding
      to `Code.CANCELLED`.
    createTime: The time the operation was created.
    endTime: The time the operation finished running.
    statusDetail: Human-readable status of the operation, if any.
    target: Server-defined resource path for the target of the operation.
    verb: Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class OperationMetadataV1(_messages.Message):
  r"""Metadata describing an Operation

  Enums:
    TypeValueValuesEnum: Type of operation.

  Messages:
    RequestValue: The original request that started the operation.

  Fields:
    buildId: The Cloud Build ID of the function created or updated by an API
      call. This field is only populated for Create and Update operations.
    request: The original request that started the operation.
    sourceToken: An identifier for Firebase function sources. Disclaimer: This
      field is only supported for Firebase function deployments.
    target: Target of the operation - for example
      projects/project-1/locations/region-1/functions/function-1
    type: Type of operation.
    updateTime: The last update timestamp of the operation.
    versionId: Version id of the function created or updated by an API call.
      This field is only populated for Create and Update operations.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of operation.

    Values:
      OPERATION_UNSPECIFIED: Unknown operation type.
      CREATE_FUNCTION: Triggered by CreateFunction call
      UPDATE_FUNCTION: Triggered by UpdateFunction call
      DELETE_FUNCTION: Triggered by DeleteFunction call.
    """
    OPERATION_UNSPECIFIED = 0
    CREATE_FUNCTION = 1
    UPDATE_FUNCTION = 2
    DELETE_FUNCTION = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestValue(_messages.Message):
    r"""The original request that started the operation.

    Messages:
      AdditionalProperty: An additional property for a RequestValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  buildId = _messages.StringField(1)
  request = _messages.MessageField('RequestValue', 2)
  sourceToken = _messages.StringField(3)
  target = _messages.StringField(4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)
  updateTime = _messages.StringField(6)
  versionId = _messages.IntegerField(7)


class RepoSource(_messages.Message):
  r"""Location of the source in a Google Cloud Source Repository.

  Fields:
    branchName: Regex matching branches to build. The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
    commitSha: Explicit commit SHA to build.
    dir: Directory, relative to the source root, in which to run the build.
      This must be a relative path. If a step's `dir` is specified and is an
      absolute path, this value is ignored for that step's execution. eg.
      helloworld (no leading slash allowed)
    invertRegex: Only trigger a build if the revision regex does NOT match the
      revision regex.
    projectId: ID of the project that owns the Cloud Source Repository. If
      omitted, the project ID requesting the build is assumed.
    repoName: Name of the Cloud Source Repository.
    tagName: Regex matching tags to build. The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
  """

  branchName = _messages.StringField(1)
  commitSha = _messages.StringField(2)
  dir = _messages.StringField(3)
  invertRegex = _messages.BooleanField(4)
  projectId = _messages.StringField(5)
  repoName = _messages.StringField(6)
  tagName = _messages.StringField(7)


class ServiceConfig(_messages.Message):
  r"""Describes the Service being deployed. Currently Supported : Cloud Run
  (fully managed).

  Enums:
    IngressSettingsValueValuesEnum: The ingress settings for the function,
      controlling what traffic can reach it.
    VpcConnectorEgressSettingsValueValuesEnum: The egress settings for the
      connector, controlling what traffic is diverted through it.

  Messages:
    EnvironmentVariablesValue: Environment variables that shall be available
      during function execution.

  Fields:
    availableMemoryMb: The amount of memory in MB available for a function.
      Defaults to 256MB.
    environmentVariables: Environment variables that shall be available during
      function execution.
    ingressSettings: The ingress settings for the function, controlling what
      traffic can reach it.
    maxInstanceCount: The limit on the maximum number of function instances
      that may coexist at a given time. In some cases, such as rapid traffic
      surges, Cloud Functions may, for a short period of time, create more
      instances than the specified max instances limit. If your function
      cannot tolerate this temporary behavior, you may want to factor in a
      safety margin and set a lower max instances value than your function can
      tolerate. See the [Max
      Instances](https://cloud.google.com/functions/docs/max-instances) Guide
      for more details.
    minInstanceCount: The limit on the minimum number of function instances
      that may coexist at a given time. Function instances are kept in idle
      state for a short period after they finished executing the request to
      reduce cold start time for subsequent requests. Setting a minimum
      instance count will ensure that the given number of instances are kept
      running in idle state always. This can help with cold start times when
      jump in incoming request count occurs after the idle instance would have
      been stopped in the default case.
    service: Output only. Name of the service associated with a Function. The
      format of this field is
      `projects/{project}/locations/{region}/services/{service}`
    serviceAccountEmail: The email of the service's service account. If empty,
      defaults to `{project_number}-compute@developer.gserviceaccount.com`.
    timeoutSeconds: The function execution timeout. Execution is considered
      failed and can be terminated if the function is not completed at the end
      of the timeout period. Defaults to 60 seconds.
    uri: Output only. URI of the Service deployed.
    vpcConnector: The Serverless VPC Access connector that this cloud function
      can connect to. The format of this field is
      `projects/*/locations/*/connectors/*`.
    vpcConnectorEgressSettings: The egress settings for the connector,
      controlling what traffic is diverted through it.
  """

  class IngressSettingsValueValuesEnum(_messages.Enum):
    r"""The ingress settings for the function, controlling what traffic can
    reach it.

    Values:
      INGRESS_SETTINGS_UNSPECIFIED: Unspecified.
      ALLOW_ALL: Allow HTTP traffic from public and private sources.
      ALLOW_INTERNAL_ONLY: Allow HTTP traffic from only private VPC sources.
      ALLOW_INTERNAL_AND_GCLB: Allow HTTP traffic from private VPC sources and
        through GCLB.
    """
    INGRESS_SETTINGS_UNSPECIFIED = 0
    ALLOW_ALL = 1
    ALLOW_INTERNAL_ONLY = 2
    ALLOW_INTERNAL_AND_GCLB = 3

  class VpcConnectorEgressSettingsValueValuesEnum(_messages.Enum):
    r"""The egress settings for the connector, controlling what traffic is
    diverted through it.

    Values:
      VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED: Unspecified.
      PRIVATE_RANGES_ONLY: Use the VPC Access Connector only for private IP
        space from RFC1918.
      ALL_TRAFFIC: Force the use of VPC Access Connector for all egress
        traffic from the function.
    """
    VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0
    PRIVATE_RANGES_ONLY = 1
    ALL_TRAFFIC = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvironmentVariablesValue(_messages.Message):
    r"""Environment variables that shall be available during function
    execution.

    Messages:
      AdditionalProperty: An additional property for a
        EnvironmentVariablesValue object.

    Fields:
      additionalProperties: Additional properties of type
        EnvironmentVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvironmentVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  availableMemoryMb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  environmentVariables = _messages.MessageField('EnvironmentVariablesValue', 2)
  ingressSettings = _messages.EnumField('IngressSettingsValueValuesEnum', 3)
  maxInstanceCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  minInstanceCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  service = _messages.StringField(6)
  serviceAccountEmail = _messages.StringField(7)
  timeoutSeconds = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  uri = _messages.StringField(9)
  vpcConnector = _messages.StringField(10)
  vpcConnectorEgressSettings = _messages.EnumField('VpcConnectorEgressSettingsValueValuesEnum', 11)


class Source(_messages.Message):
  r"""The location of the function source code.

  Fields:
    repoSource: If provided, get the source from this location in a Cloud
      Source Repository.
    storageSource: If provided, get the source from this location in Google
      Cloud Storage.
  """

  repoSource = _messages.MessageField('RepoSource', 1)
  storageSource = _messages.MessageField('StorageSource', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageSource(_messages.Message):
  r"""Location of the source in an archive file in Google Cloud Storage.

  Fields:
    bucket: Google Cloud Storage bucket containing the source (see [Bucket
      Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object. If the
      generation is omitted, the latest generation will be used.
    object: Google Cloud Storage object containing the source. This object
      must be a gzipped archive file (`.tar.gz`) containing source to build.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
