# -*- coding: utf-8 -*- #
# Copyright 2020 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


"""Common flags for some of the Lux commands.

Flags are specified with functions that take in a single argument, the parser,
and add the newly constructed flag to that parser.

Example:

def AddFlagName(parser):
  parser.add_argument(
    '--flag-name',
    ... // Other flag details.
  )
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


CLUSTER_FORMAT = """
    table(
        name,
        region:label=LOCATION,
        status
    )
"""


def GetClusterListFormat():
  """Returns the table format for listing clusters."""
  return CLUSTER_FORMAT


def AddCluster(parser):
  """Adds a positional cluster argument to parser.

  Args:
    parser: argparse parser.
  """
  parser.add_argument(
      'cluster',
      type=str,
      help='Lux cluster ID')


def AddRegion(parser, required=True):
  """Adds --region flag to parser.

  Args:
    parser: argparse parser.
    required: whether or not --region is required
  """
  parser.add_argument(
      '--region',
      required=required,
      type=str,
      help='Regional location (e.g. asia-east1, us-east1). See the full '
            'list of regions at '
            'https://cloud.google.com/sql/docs/instance-locations.')
