"""Generated client library for orgpolicy version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.orgpolicy.v2 import orgpolicy_v2_messages as messages


class OrgpolicyV2(base_api.BaseApiClient):
  """Generated client library for service orgpolicy version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://orgpolicy.googleapis.com/'
  MTLS_BASE_URL = 'https://orgpolicy.mtls.googleapis.com/'

  _PACKAGE = 'orgpolicy'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'OrgpolicyV2'
  _URL_VERSION = 'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new orgpolicy handle."""
    url = url or self.BASE_URL
    super(OrgpolicyV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.constraints = self.ConstraintsService(self)
    self.policies = self.PoliciesService(self)

  class ConstraintsService(base_api.BaseApiService):
    """Service class for the constraints resource."""

    _NAME = 'constraints'

    def __init__(self, client):
      super(OrgpolicyV2.ConstraintsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists `Constraints` that could be applied on the specified resource.

      Args:
        request: (OrgpolicyConstraintsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudOrgpolicyV2ListConstraintsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/constraints',
        http_method='GET',
        method_id='orgpolicy.constraints.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/constraints',
        request_field='',
        request_type_name='OrgpolicyConstraintsListRequest',
        response_type_name='GoogleCloudOrgpolicyV2ListConstraintsResponse',
        supports_download=False,
    )

  class PoliciesService(base_api.BaseApiService):
    """Service class for the policies resource."""

    _NAME = 'policies'

    def __init__(self, client):
      super(OrgpolicyV2.PoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the policy already exists on the given Cloud resource.

      Args:
        request: (OrgpolicyPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudOrgpolicyV2Policy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/policies',
        http_method='POST',
        method_id='orgpolicy.policies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/policies',
        request_field='googleCloudOrgpolicyV2Policy',
        request_type_name='OrgpolicyPoliciesCreateRequest',
        response_type_name='GoogleCloudOrgpolicyV2Policy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or Org Policy does not exist.

      Args:
        request: (OrgpolicyPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/policies/{policiesId}',
        http_method='DELETE',
        method_id='orgpolicy.policies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='OrgpolicyPoliciesDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a `Policy` on a resource. If no `Policy` is set on the resource, NOT_FOUND is returned. The `etag` value can be used with `UpdatePolicy()` to update a `Policy` during read-modify-write.

      Args:
        request: (OrgpolicyPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudOrgpolicyV2Policy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/policies/{policiesId}',
        http_method='GET',
        method_id='orgpolicy.policies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='OrgpolicyPoliciesGetRequest',
        response_type_name='GoogleCloudOrgpolicyV2Policy',
        supports_download=False,
    )

    def GetEffectivePolicy(self, request, global_params=None):
      r"""Gets the effective `Policy` on a resource. This is the result of merging `Policies` in the resource hierarchy and evaluating conditions. The returned `Policy` will not have an `etag` or `condition` set because it is a computed `Policy` across multiple resources. Subtrees of Resource Manager resource hierarchy with 'under:' prefix will not be expanded.

      Args:
        request: (OrgpolicyPoliciesGetEffectivePolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudOrgpolicyV2Policy) The response message.
      """
      config = self.GetMethodConfig('GetEffectivePolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectivePolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/policies/{policiesId}:getEffectivePolicy',
        http_method='GET',
        method_id='orgpolicy.policies.getEffectivePolicy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:getEffectivePolicy',
        request_field='',
        request_type_name='OrgpolicyPoliciesGetEffectivePolicyRequest',
        response_type_name='GoogleCloudOrgpolicyV2Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves all of the `Policies` that exist on a particular resource.

      Args:
        request: (OrgpolicyPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudOrgpolicyV2ListPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/policies',
        http_method='GET',
        method_id='orgpolicy.policies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/policies',
        request_field='',
        request_type_name='OrgpolicyPoliciesListRequest',
        response_type_name='GoogleCloudOrgpolicyV2ListPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or the policy do not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag supplied in the request does not match the persisted etag of the policy Note: the supplied policy will perform a full overwrite of all fields.

      Args:
        request: (GoogleCloudOrgpolicyV2Policy) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudOrgpolicyV2Policy) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/policies/{policiesId}',
        http_method='PATCH',
        method_id='orgpolicy.policies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudOrgpolicyV2Policy',
        response_type_name='GoogleCloudOrgpolicyV2Policy',
        supports_download=False,
    )
