"""Generated client library for sddc version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.sddc.v1alpha1 import sddc_v1alpha1_messages as messages


class SddcV1alpha1(base_api.BaseApiClient):
  """Generated client library for service sddc version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://sddc.googleapis.com/'
  MTLS_BASE_URL = 'https://sddc.mtls.googleapis.com/'

  _PACKAGE = 'sddc'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'SddcV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new sddc handle."""
    url = url or self.BASE_URL
    super(SddcV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_clusterGroupBackups = self.ProjectsLocationsClusterGroupBackupsService(self)
    self.projects_locations_clusterGroups_clusters = self.ProjectsLocationsClusterGroupsClustersService(self)
    self.projects_locations_clusterGroups_ipAddresses = self.ProjectsLocationsClusterGroupsIpAddressesService(self)
    self.projects_locations_clusterGroups = self.ProjectsLocationsClusterGroupsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_privateClouds_ipAddresses = self.ProjectsLocationsPrivateCloudsIpAddressesService(self)
    self.projects_locations_privateClouds = self.ProjectsLocationsPrivateCloudsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsClusterGroupBackupsService(base_api.BaseApiService):
    """Service class for the projects_locations_clusterGroupBackups resource."""

    _NAME = 'projects_locations_clusterGroupBackups'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsClusterGroupBackupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ClusterGroupBackup in a given project and location(region). The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the new ClusterGroupBackup will be functional. Completed longrunning.Operation will contain the new ClusterGroupBackup object in the response field. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

      Args:
        request: (SddcProjectsLocationsClusterGroupBackupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroupBackups',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroupBackups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['clusterGroupBackupId', 'requestId'],
        relative_path='v1alpha1/{+parent}/clusterGroupBackups',
        request_field='clusterGroupBackup',
        request_type_name='SddcProjectsLocationsClusterGroupBackupsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a ClusterGroupBackup.

      Args:
        request: (SddcProjectsLocationsClusterGroupBackupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroupBackups/{clusterGroupBackupsId}',
        http_method='DELETE',
        method_id='sddc.projects.locations.clusterGroupBackups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupBackupsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single ClusterGroupBackup.

      Args:
        request: (SddcProjectsLocationsClusterGroupBackupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ClusterGroupBackup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroupBackups/{clusterGroupBackupsId}',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroupBackups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupBackupsGetRequest',
        response_type_name='ClusterGroupBackup',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ClusterGroupBackups in a given project and location(region).

      Args:
        request: (SddcProjectsLocationsClusterGroupBackupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClusterGroupBackupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroupBackups',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroupBackups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/clusterGroupBackups',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupBackupsListRequest',
        response_type_name='ListClusterGroupBackupsResponse',
        supports_download=False,
    )

  class ProjectsLocationsClusterGroupsClustersService(base_api.BaseApiService):
    """Service class for the projects_locations_clusterGroups_clusters resource."""

    _NAME = 'projects_locations_clusterGroups_clusters'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsClusterGroupsClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def AddNodes(self, request, global_params=None):
      r"""Add bare metal nodes to a cluster.

      Args:
        request: (SddcProjectsLocationsClusterGroupsClustersAddNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('AddNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddNodes.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/clusters/{clustersId}:addNodes',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.clusters.addNodes',
        ordered_params=['cluster'],
        path_params=['cluster'],
        query_params=[],
        relative_path='v1alpha1/{+cluster}:addNodes',
        request_field='addNodesRequest',
        request_type_name='SddcProjectsLocationsClusterGroupsClustersAddNodesRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new cluster in a given cluster group. The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the cluster will be fully functional. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

      Args:
        request: (SddcProjectsLocationsClusterGroupsClustersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/clusters',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.clusters.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['clusterId', 'managementCluster'],
        relative_path='v1alpha1/{+parent}/clusters',
        request_field='cluster',
        request_type_name='SddcProjectsLocationsClusterGroupsClustersCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a Cluster.

      Args:
        request: (SddcProjectsLocationsClusterGroupsClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/clusters/{clustersId}',
        http_method='DELETE',
        method_id='sddc.projects.locations.clusterGroups.clusters.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsClustersDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Cluster.

      Args:
        request: (SddcProjectsLocationsClusterGroupsClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Cluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/clusters/{clustersId}',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroups.clusters.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsClustersGetRequest',
        response_type_name='Cluster',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Clusters in a given cluster group.

      Args:
        request: (SddcProjectsLocationsClusterGroupsClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/clusters',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroups.clusters.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/clusters',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsClustersListRequest',
        response_type_name='ListClustersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates labels of a specific cluster.

      Args:
        request: (SddcProjectsLocationsClusterGroupsClustersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/clusters/{clustersId}',
        http_method='PATCH',
        method_id='sddc.projects.locations.clusterGroups.clusters.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='cluster',
        request_type_name='SddcProjectsLocationsClusterGroupsClustersPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def RemoveNodes(self, request, global_params=None):
      r"""Remove bare metal nodes from a cluster.

      Args:
        request: (SddcProjectsLocationsClusterGroupsClustersRemoveNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('RemoveNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveNodes.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/clusters/{clustersId}:removeNodes',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.clusters.removeNodes',
        ordered_params=['cluster'],
        path_params=['cluster'],
        query_params=[],
        relative_path='v1alpha1/{+cluster}:removeNodes',
        request_field='removeNodesRequest',
        request_type_name='SddcProjectsLocationsClusterGroupsClustersRemoveNodesRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class ProjectsLocationsClusterGroupsIpAddressesService(base_api.BaseApiService):
    """Service class for the projects_locations_clusterGroups_ipAddresses resource."""

    _NAME = 'projects_locations_clusterGroups_ipAddresses'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsClusterGroupsIpAddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new IpAddress in a given ClusterGroup. The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the cluster will be fully functional. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

      Args:
        request: (SddcProjectsLocationsClusterGroupsIpAddressesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/ipAddresses',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.ipAddresses.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['ipAddressId'],
        relative_path='v1alpha1/{+parent}/ipAddresses',
        request_field='ipAddress',
        request_type_name='SddcProjectsLocationsClusterGroupsIpAddressesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an IpAddress in a given ClusterGroup.

      Args:
        request: (SddcProjectsLocationsClusterGroupsIpAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/ipAddresses/{ipAddressesId}',
        http_method='DELETE',
        method_id='sddc.projects.locations.clusterGroups.ipAddresses.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsIpAddressesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details of a single IpAddress.

      Args:
        request: (SddcProjectsLocationsClusterGroupsIpAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IpAddress) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/ipAddresses/{ipAddressesId}',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroups.ipAddresses.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsIpAddressesGetRequest',
        response_type_name='IpAddress',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists IpAddresses in a given ClusterGroup.

      Args:
        request: (SddcProjectsLocationsClusterGroupsIpAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListIpAddressesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}/ipAddresses',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroups.ipAddresses.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/ipAddresses',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsIpAddressesListRequest',
        response_type_name='ListIpAddressesResponse',
        supports_download=False,
    )

  class ProjectsLocationsClusterGroupsService(base_api.BaseApiService):
    """Service class for the projects_locations_clusterGroups resource."""

    _NAME = 'projects_locations_clusterGroups'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsClusterGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ClusterGroup in a given project and location(region). The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the new ClusterGroup will be fully functional. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

      Args:
        request: (SddcProjectsLocationsClusterGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['clusterGroupId'],
        relative_path='v1alpha1/{+parent}/clusterGroups',
        request_field='clusterGroup',
        request_type_name='SddcProjectsLocationsClusterGroupsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a ClusterGroup.

      Args:
        request: (SddcProjectsLocationsClusterGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}',
        http_method='DELETE',
        method_id='sddc.projects.locations.clusterGroups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single ClusterGroup.

      Args:
        request: (SddcProjectsLocationsClusterGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ClusterGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsGetRequest',
        response_type_name='ClusterGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (SddcProjectsLocationsClusterGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}:getIamPolicy',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroups.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ClusterGroups in a given project and location(region).

      Args:
        request: (SddcProjectsLocationsClusterGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClusterGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups',
        http_method='GET',
        method_id='sddc.projects.locations.clusterGroups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/clusterGroups',
        request_field='',
        request_type_name='SddcProjectsLocationsClusterGroupsListRequest',
        response_type_name='ListClusterGroupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates description, labels, and network config of a specific clusterGroup.

      Args:
        request: (SddcProjectsLocationsClusterGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}',
        http_method='PATCH',
        method_id='sddc.projects.locations.clusterGroups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='clusterGroup',
        request_type_name='SddcProjectsLocationsClusterGroupsPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def ResetCloudAdminCredentials(self, request, global_params=None):
      r"""Reset the vCenter or NSX cloudadmin accounts.

      Args:
        request: (SddcProjectsLocationsClusterGroupsResetCloudAdminCredentialsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('ResetCloudAdminCredentials')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResetCloudAdminCredentials.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}:resetCloudAdminCredentials',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.resetCloudAdminCredentials',
        ordered_params=['clusterGroup'],
        path_params=['clusterGroup'],
        query_params=[],
        relative_path='v1alpha1/{+clusterGroup}:resetCloudAdminCredentials',
        request_field='resetCloudAdminCredentialsRequest',
        request_type_name='SddcProjectsLocationsClusterGroupsResetCloudAdminCredentialsRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (SddcProjectsLocationsClusterGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}:setIamPolicy',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='SddcProjectsLocationsClusterGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (SddcProjectsLocationsClusterGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusterGroups/{clusterGroupsId}:testIamPermissions',
        http_method='POST',
        method_id='sddc.projects.locations.clusterGroups.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='SddcProjectsLocationsClusterGroupsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (SddcProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='sddc.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:cancel',
        request_field='googleLongrunningCancelOperationRequest',
        request_type_name='SddcProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SddcProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='sddc.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (SddcProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='sddc.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `"/v1/{name=users/*}/operations"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.

      Args:
        request: (SddcProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='sddc.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/operations',
        request_field='',
        request_type_name='SddcProjectsLocationsOperationsListRequest',
        response_type_name='GoogleLongrunningListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsPrivateCloudsIpAddressesService(base_api.BaseApiService):
    """Service class for the projects_locations_privateClouds_ipAddresses resource."""

    _NAME = 'projects_locations_privateClouds_ipAddresses'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsPrivateCloudsIpAddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new IpAddress in a given PrivateCloud. The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the cluster will be fully functional. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsIpAddressesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/ipAddresses',
        http_method='POST',
        method_id='sddc.projects.locations.privateClouds.ipAddresses.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['ipAddressId'],
        relative_path='v1alpha1/{+parent}/ipAddresses',
        request_field='ipAddress',
        request_type_name='SddcProjectsLocationsPrivateCloudsIpAddressesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an IpAddress in a given PrivateCloud.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsIpAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/ipAddresses/{ipAddressesId}',
        http_method='DELETE',
        method_id='sddc.projects.locations.privateClouds.ipAddresses.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsPrivateCloudsIpAddressesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details of a single IpAddress.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsIpAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IpAddress) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/ipAddresses/{ipAddressesId}',
        http_method='GET',
        method_id='sddc.projects.locations.privateClouds.ipAddresses.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsPrivateCloudsIpAddressesGetRequest',
        response_type_name='IpAddress',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists IpAddresses in a given PrivateCloud.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsIpAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListIpAddressesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/ipAddresses',
        http_method='GET',
        method_id='sddc.projects.locations.privateClouds.ipAddresses.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/ipAddresses',
        request_field='',
        request_type_name='SddcProjectsLocationsPrivateCloudsIpAddressesListRequest',
        response_type_name='ListIpAddressesResponse',
        supports_download=False,
    )

  class ProjectsLocationsPrivateCloudsService(base_api.BaseApiService):
    """Service class for the projects_locations_privateClouds resource."""

    _NAME = 'projects_locations_privateClouds'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsPrivateCloudsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new PrivateCloud in a given project and location(region). The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the new PrivateCloud will be fully functional. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds',
        http_method='POST',
        method_id='sddc.projects.locations.privateClouds.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['privateCloudId'],
        relative_path='v1alpha1/{+parent}/privateClouds',
        request_field='privateCloud',
        request_type_name='SddcProjectsLocationsPrivateCloudsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a PrivateCloud.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}',
        http_method='DELETE',
        method_id='sddc.projects.locations.privateClouds.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsPrivateCloudsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single PrivateCloud.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PrivateCloud) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}',
        http_method='GET',
        method_id='sddc.projects.locations.privateClouds.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsPrivateCloudsGetRequest',
        response_type_name='PrivateCloud',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists PrivateClouds in a given project and location(region).

      Args:
        request: (SddcProjectsLocationsPrivateCloudsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPrivateCloudsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds',
        http_method='GET',
        method_id='sddc.projects.locations.privateClouds.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/privateClouds',
        request_field='',
        request_type_name='SddcProjectsLocationsPrivateCloudsListRequest',
        response_type_name='ListPrivateCloudsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates description, labels and network config of a specific privateCloud.

      Args:
        request: (SddcProjectsLocationsPrivateCloudsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}',
        http_method='PATCH',
        method_id='sddc.projects.locations.privateClouds.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='privateCloud',
        request_type_name='SddcProjectsLocationsPrivateCloudsPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (SddcProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='sddc.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='SddcProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (SddcProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='sddc.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'includeUnrevealedLocations', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/locations',
        request_field='',
        request_type_name='SddcProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(SddcV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
