"""Generated message classes for aiplatform version v1beta1.

Train high-quality custom machine learning models with minimum effort and
machine learning expertise.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'aiplatform'


class AiplatformProjectsLocationsBatchPredictionJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelBatchPredictionJobRequest: A
      GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest resource to
      be passed as the request body.
    name: Required. The name of the BatchPredictionJob to cancel. Format: `pro
      jects/{project}/locations/{location}/batchPredictionJobs/{batch_predicti
      on_job}`
  """

  googleCloudAiplatformV1beta1CancelBatchPredictionJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1BatchPredictionJob: A
      GoogleCloudAiplatformV1beta1BatchPredictionJob resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      BatchPredictionJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1BatchPredictionJob = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource to be deleted.
      Format: `projects/{project}/locations/{location}/batchPredictionJobs/{ba
      tch_prediction_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsGetRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource. Format: `proj
      ects/{project}/locations/{location}/batchPredictionJobs/{batch_predictio
      n_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="JOB_STATE_SUCCEEDED" AND
      display_name="my_job"` * `state="JOB_STATE_RUNNING" OR
      display_name="my_job"` * `NOT display_name="my_job"` *
      `state="JOB_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListBatchPredictionJobsResponse.next_page_token of the previous
      JobService.ListBatchPredictionJobs call.
    parent: Required. The resource name of the Location to list the
      BatchPredictionJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsCustomJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelCustomJobRequest: A
      GoogleCloudAiplatformV1beta1CancelCustomJobRequest resource to be passed
      as the request body.
    name: Required. The name of the CustomJob to cancel. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  googleCloudAiplatformV1beta1CancelCustomJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelCustomJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1CustomJob: A
      GoogleCloudAiplatformV1beta1CustomJob resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      CustomJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1CustomJob = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsDeleteRequest object.

  Fields:
    name: Required. The name of the CustomJob resource to be deleted. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsGetRequest object.

  Fields:
    name: Required. The name of the CustomJob resource. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="JOB_STATE_SUCCEEDED" AND
      display_name="my_job"` * `state="JOB_STATE_RUNNING" OR
      display_name="my_job"` * `NOT display_name="my_job"` *
      `state="JOB_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListCustomJobsResponse.next_page_token of the previous
      JobService.ListCustomJobs call.
    parent: Required. The resource name of the Location to list the CustomJobs
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsCustomJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsCustomJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDataLabelingJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDataLabelingJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest object.

  Fields:
    name: Required. The name of the AnnotationSpec resource. Format: `projects
      /{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{anno
      tation_spec}`
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Dataset: A GoogleCloudAiplatformV1beta1Dataset
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the Dataset
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Dataset = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the DataItem to list Annotations
      from. Format: `projects/{project}/locations/{location}/datasets/{dataset
      }/dataItems/{data_item}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsCance
  lRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsDelet
  eRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDataItemsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsListRequest object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the Dataset to list DataItems from.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDeleteRequest object.

  Fields:
    name: Required. The resource name of the Dataset to delete. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsExportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ExportDataRequest: A
      GoogleCloudAiplatformV1beta1ExportDataRequest resource to be passed as
      the request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1beta1ExportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsGetRequest object.

  Fields:
    name: Required. The name of the Dataset resource.
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsImportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ImportDataRequest: A
      GoogleCloudAiplatformV1beta1ImportDataRequest resource to be passed as
      the request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1beta1ImportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsListRequest object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `display_name` * `data_item_count` * `create_time` * `update_time`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The name of the Dataset's parent resource. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Dataset: A GoogleCloudAiplatformV1beta1Dataset
      resource to be passed as the request body.
    name: Output only. The resource name of the Dataset.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see [FieldMask](https: //tinyurl.com/dev-google-
      protobuf#google.protobuf.FieldMask). Updatable fields: * `display_name`
      * `description` * `labels`
  """

  googleCloudAiplatformV1beta1Dataset = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsEndpointsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Endpoint: A
      GoogleCloudAiplatformV1beta1Endpoint resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the Endpoint
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1beta1Endpoint', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEndpointsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeleteRequest object.

  Fields:
    name: Required. The name of the Endpoint resource to be deleted. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsDeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource into which to deploy
      a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1DeployModelRequest: A
      GoogleCloudAiplatformV1beta1DeployModelRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1DeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployModelRequest', 2)


class AiplatformProjectsLocationsEndpointsExplainRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsExplainRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      explanation. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1ExplainRequest: A
      GoogleCloudAiplatformV1beta1ExplainRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ExplainRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplainRequest', 2)


class AiplatformProjectsLocationsEndpointsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsGetRequest object.

  Fields:
    name: Required. The name of the Endpoint resource. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `endpoint` supports = and !=. `endpoint` represents the Endpoint ID, ie.
      the last segment of the Endpoint's resource name. * `display_name`
      supports =, != and regex() (uses
      [re2](https://github.com/google/re2/wiki/Syntax) syntax) * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* or labels:key - key existence A key including a
      space must be quoted. `labels."a key"`. Some examples: * `endpoint=1` *
      `displayName="myDisplayName"` * `regex(display_name, "^A") -> The
      display name starts with an A. * `labels.myKey="myValue"`
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListEndpointsResponse.next_page_token of the previous
      EndpointService.ListEndpoints call.
    parent: Required. The resource name of the Location from which to list the
      Endpoints. Format: `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsEndpointsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsEndpointsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsEndpointsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Endpoint: A
      GoogleCloudAiplatformV1beta1Endpoint resource to be passed as the
      request body.
    name: Output only. The resource name of the Endpoint.
    updateMask: Required. The update mask applies to the resource.
  """

  googleCloudAiplatformV1beta1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1beta1Endpoint', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsEndpointsPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1PredictRequest: A
      GoogleCloudAiplatformV1beta1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictRequest', 2)


class AiplatformProjectsLocationsEndpointsUndeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsUndeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource from which to
      undeploy a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1UndeployModelRequest: A
      GoogleCloudAiplatformV1beta1UndeployModelRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1UndeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UndeployModelRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsC
  ancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsD
  eleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsG
  etRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsL
  istRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsW
  aitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeaturestoresOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHumanInTheLoopsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHumanInTheLoopsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHumanInTheLoopsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHumanInTheLoopsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHumanInTheLoopsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHumanInTheLoopsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHumanInTheLoopsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHumanInTheLoopsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsHumanInTheLoopsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHumanInTheLoopsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest: A
      GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest
      resource to be passed as the request body.
    name: Required. The name of the HyperparameterTuningJob to cancel. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  googleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1HyperparameterTuningJob: A
      GoogleCloudAiplatformV1beta1HyperparameterTuningJob resource to be
      passed as the request body.
    parent: Required. The resource name of the Location to create the
      HyperparameterTuningJob in. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1HyperparameterTuningJob = _messages.MessageField('GoogleCloudAiplatformV1beta1HyperparameterTuningJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest
  object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource to be
      deleted. Format: `projects/{project}/locations/{location}/hyperparameter
      TuningJobs/{hyperparameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="JOB_STATE_SUCCEEDED" AND
      display_name="my_job"` * `state="JOB_STATE_RUNNING" OR
      display_name="my_job"` * `NOT display_name="my_job"` *
      `state="JOB_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListHyperparameterTuningJobsResponse.next_page_token of the previous
      JobService.ListHyperparameterTuningJobs call.
    parent: Required. The resource name of the Location to list the
      HyperparameterTuningJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1BatchMigrateResourcesRequest: A
      GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest resource to be
      passed as the request body.
    parent: Required. The location of the migrated resource will live in.
      Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1BatchMigrateResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMigratableResourcesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsMigratableResourcesSearchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesSearchRequest object.

  Fields:
    googleCloudAiplatformV1beta1SearchMigratableResourcesRequest: A
      GoogleCloudAiplatformV1beta1SearchMigratableResourcesRequest resource to
      be passed as the request body.
    parent: Required. The location that the migratable resources should be
      searched from. It's the AI Platform location that the resources can be
      migrated to, not the resources' original location. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1SearchMigratableResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SearchMigratableResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsCanc
  elRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsDele
  teRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsList
  Request object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsWait
  Request object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsDeleteRequest object.

  Fields:
    name: Required. The name of the Model resource to be deleted. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluation resource. Format: `project
      s/{project}/locations/{location}/models/{model}/evaluations/{evaluation}
      `
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationsResponse.next_page_token of the previous
      ModelService.ListModelEvaluations call.
    parent: Required. The resource name of the Model to list the
      ModelEvaluations from. Format:
      `projects/{project}/locations/{location}/models/{model}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsEvaluationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelsEvaluationsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluationSlice resource. Format: `pr
      ojects/{project}/locations/{location}/models/{model}/evaluations/{evalua
      tion}/slices/{slice}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest object.

  Fields:
    filter: The standard list filter. * `slice.dimension` - for =.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationSlicesResponse.next_page_token of the previous
      ModelService.ListModelEvaluationSlices call.
    parent: Required. The resource name of the ModelEvaluation to list the
      ModelEvaluationSlices from. Format: `projects/{project}/locations/{locat
      ion}/models/{model}/evaluations/{evaluation}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsExportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ExportModelRequest: A
      GoogleCloudAiplatformV1beta1ExportModelRequest resource to be passed as
      the request body.
    name: Required. The resource name of the Model to export. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  googleCloudAiplatformV1beta1ExportModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportModelRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsGetRequest object.

  Fields:
    name: Required. The name of the Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelsResponse.next_page_token of the previous
      ModelService.ListModels call.
    parent: Required. The resource name of the Location to list the Models
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Model: A GoogleCloudAiplatformV1beta1Model
      resource to be passed as the request body.
    name: The resource name of the Model.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see [FieldMask](https:
      //developers.google.com/protocol-buffers //
      /docs/reference/google.protobuf#fieldmask).
  """

  googleCloudAiplatformV1beta1Model = _messages.MessageField('GoogleCloudAiplatformV1beta1Model', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsModelsUploadRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsUploadRequest object.

  Fields:
    googleCloudAiplatformV1beta1UploadModelRequest: A
      GoogleCloudAiplatformV1beta1UploadModelRequest resource to be passed as
      the request body.
    parent: Required. The resource name of the Location into which to upload
      the Model. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1UploadModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UploadModelRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsPipelineJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsPipelineJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsSpecialistPoolsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1SpecialistPool: A
      GoogleCloudAiplatformV1beta1SpecialistPool resource to be passed as the
      request body.
    parent: Required. The parent Project name for the new SpecialistPool. The
      form is `projects/{project}/locations/{location}`.
  """

  googleCloudAiplatformV1beta1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1beta1SpecialistPool', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsDeleteRequest object.

  Fields:
    force: If set to true, any specialist managers in this SpecialistPool will
      also be deleted. (Otherwise, the request will only work if the
      SpecialistPool has no specialist managers.)
    name: Required. The resource name of the SpecialistPool to delete. Format:
      `projects/{project}/locations/{location}/specialistPools/{specialist_poo
      l}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsGetRequest object.

  Fields:
    name: Required. The name of the SpecialistPool resource. The form is `proj
      ects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsListRequest object.

  Fields:
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained by
      ListSpecialistPoolsResponse.next_page_token of the previous
      SpecialistPoolService.ListSpecialistPools call. Return first page if
      empty.
    parent: Required. The name of the SpecialistPool's parent resource.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read. FieldMask represents a set
      of
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  readMask = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsSpecialistPoolsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1SpecialistPool: A
      GoogleCloudAiplatformV1beta1SpecialistPool resource to be passed as the
      request body.
    name: Required. The resource name of the SpecialistPool.
    updateMask: Required. The update mask applies to the resource.
  """

  googleCloudAiplatformV1beta1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1beta1SpecialistPool', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsStudiesTrialsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsStudiesTrialsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsCancel
  Request object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsDelete
  Request object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTrainingPipelinesCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelTrainingPipelineRequest: A
      GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest resource to be
      passed as the request body.
    name: Required. The name of the TrainingPipeline to cancel. Format: `proje
      cts/{project}/locations/{location}/trainingPipelines/{training_pipeline}
      `
  """

  googleCloudAiplatformV1beta1CancelTrainingPipelineRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1TrainingPipeline: A
      GoogleCloudAiplatformV1beta1TrainingPipeline resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      TrainingPipeline in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1TrainingPipeline = _messages.MessageField('GoogleCloudAiplatformV1beta1TrainingPipeline', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesDeleteRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource to be deleted.
      Format: `projects/{project}/locations/{location}/trainingPipelines/{trai
      ning_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesGetRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource. Format: `projec
      ts/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="PIPELINE_STATE_SUCCEEDED" AND
      display_name="my_pipeline"` * `state="PIPELINE_STATE_RUNNING" OR
      display_name="my_pipeline"` * `NOT display_name="my_pipeline"` *
      `state="PIPELINE_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListTrainingPipelinesResponse.next_page_token of the previous
      PipelineService.ListTrainingPipelines call.
    parent: Required. The resource name of the Location to list the
      TrainingPipelines from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsTrainingPipelinesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTrainingPipelinesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class GoogleCloudAiplatformUiAnnotationSpecStats(_messages.Message):
  r"""Stats of DataItems annotated by the specified AnnotationSpec and
  Annotations with the AnnotationSpec in a SavedQuery.

  Fields:
    annotationSpecDisplayName: Output only. The user-defined name of the
      AnnotationSpec.
    annotationSpecId: Output only. ID of an AnnotationSpec. Counters in the
      stats are for DataItems annotated by this anntoation spec and
      Annotations have this AnnotationSpec in the SavedQuery.
    annotationsCount: Output only. Count on Annotations with AnnotationSpec
      identified by annotation_spec_id.
    dataItemsCount: Output only. Count on DataItems that are annotated with
      the AnnotationSpec identified by annotation_spec_id.
    testAnnotationsCount: Output only. Count on Annotations with
      AnnotationSpec identified by annotation_spec_id and under all DataItems
      that match test_filter and do not match training_filter and
      validation_filter.
    testDataItemsCount: Output only. Count on DataItems that match test_filter
      and do not match training_filter and validation_filter and are annotated
      with the AnnotationSpec identified by annotation_spec_id.
    trainingAnnotationsCount: Output only. Count on Annotations with
      AnnotationSpec identified by annotation_spec_id and under all DataItems
      that match training_filter.
    trainingDataItemsCount: Output only. Count on DataItems that match
      training_filter and annotated with the AnnotationSpec identified by
      annotation_spec_id.
    validationAnnotationsCount: Output only. Count on Annotations with
      AnnotationSpec identified by annotation_spec_id and under all DataItems
      that match validation_filter and do not match training_filter.
    validationDataItemsCount: Output only. Count on DataItems that match
      validation_filter and do not match training_filter and are annotated
      with the AnnotationSpec identified by annotation_spec_id.
  """

  annotationSpecDisplayName = _messages.StringField(1)
  annotationSpecId = _messages.IntegerField(2)
  annotationsCount = _messages.IntegerField(3)
  dataItemsCount = _messages.IntegerField(4)
  testAnnotationsCount = _messages.IntegerField(5)
  testDataItemsCount = _messages.IntegerField(6)
  trainingAnnotationsCount = _messages.IntegerField(7)
  trainingDataItemsCount = _messages.IntegerField(8)
  validationAnnotationsCount = _messages.IntegerField(9)
  validationDataItemsCount = _messages.IntegerField(10)


class GoogleCloudAiplatformUiAutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by AI
  Platform, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      a no upper bound for scaling under heavy traffic will be assume, though
      AI Platform may be unable to scale beyond certain replica number.
    minReplicaCount: Immutable. The minimum number of replicas this
      DeployedModel will be always deployed on. If traffic against it
      increases, it may dynamically be deployed onto more replicas up to
      max_replica_count, and as traffic decreases, some of these extra
      replicas may be freed. If requested value is too large, the deployment
      will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiBatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiBatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformUiMigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformUiCalculateSavedQueryStatsOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  DatasetService.CalculateSavedQueryStats.

  Fields:
    calculateStatsConfig: Whether calculate the stats by MlUse and the
      standard filters by MlUse.
    genericMetadata: The common part of the operation metadata.
  """

  calculateStatsConfig = _messages.MessageField('GoogleCloudAiplatformUiCalculateStatsConfig', 1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 2)


class GoogleCloudAiplatformUiCalculateSavedQueryStatsResponse(_messages.Message):
  r"""Response message for DatasetService.CalculateSavedQueryStats.

  Fields:
    annotatedDataItemsCount: Count on DataItems that are annotated with at
      least one AnnotationSpec in this SavedQuery.
    annotationSpecStats: A list of per AnnotationSpec stats of the SavedQuery.
      This list contains stats of each AnnotationSpec that is associated with
      the SavedQuery even if there is no DataItem annotated with the
      AnnotationSpec.
    dataItemsCount: Count on DataItems in the SavedQuery.
    testDataItemsCount: Output only. Count on DataItems that match
      test_filter.
    trainingDataItemsCount: Output only. Count on DataItems that match
      training_filter.
    validationDataItemsCount: Output only. Count on DataItems that match
      validation_filter.
  """

  annotatedDataItemsCount = _messages.IntegerField(1)
  annotationSpecStats = _messages.MessageField('GoogleCloudAiplatformUiAnnotationSpecStats', 2, repeated=True)
  dataItemsCount = _messages.IntegerField(3)
  testDataItemsCount = _messages.IntegerField(4)
  trainingDataItemsCount = _messages.IntegerField(5)
  validationDataItemsCount = _messages.IntegerField(6)


class GoogleCloudAiplatformUiCalculateStatsConfig(_messages.Message):
  r"""Describes how the stats of a SavedQuery will be calculated.

  Fields:
    annotationFilter: A filter on Annotations. If this field is set, all of
      the stats will be restricted to the DataItems with the Annotations that
      match this filter. Supported filter: `data_labeling_job_id` - for =.
      Filters by the specified data_labeling_job.
    testFilter: A filter on DataItems of the Dataset. Test set stats will be
      calculated from DataItems that match this filter and does not match the
      filters specified in training_filter and validation_filter. The filter
      only support filtering by at most one resource label.
    trainingFilter: A filter on DataItems of the Dataset. Training set stats
      will be calculated from DataItems that match this filter. The filter
      only support filtering by at most one resource label.
    validationFilter: A filter on DataItems of the Dataset. Validation set
      stats will be calculated from DataItems that match this filter and does
      not match the filter specified in training_filter. The filter only
      support filtering by at most one resource label.
  """

  annotationFilter = _messages.StringField(1)
  testFilter = _messages.StringField(2)
  trainingFilter = _messages.StringField(3)
  validationFilter = _messages.StringField(4)


class GoogleCloudAiplatformUiCreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiCreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiCreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiDataLabelingJobRef(_messages.Message):
  r"""DataLabelingJob's names needed by SpecialistPools it associates with.

  Fields:
    dataLabelingJob: Output only. Resource name of the DataLabelingJob, same
      as DataLabelingJob.name.
    dataLabelingJobDisplayName: Output only. The user-defined name of the
      DataLabelingJob, same as DataLabelingJob.display_name.
    dataLabelingJobObjective: Output only. The objective of the
      DataLabelingJob, same as SavedQuery.problem_type.
    dataLabelingJobProgress: Output only. The progress of the DataLabelingJob,
      same as DataLabelingJob.labeling_progress.
  """

  dataLabelingJob = _messages.StringField(1)
  dataLabelingJobDisplayName = _messages.StringField(2)
  dataLabelingJobObjective = _messages.StringField(3)
  dataLabelingJobProgress = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiDedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel, and
  that need a higher degree of manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine
      used by the prediction.
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      will use min_replica_count as the default value.
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas this DeployedModel will be always deployed on. If traffic
      against it increases, it may dynamically be deployed onto more replicas,
      and as traffic decreases, some of these extra replicas may be freed.
      Note: if machine_spec.accelerator_count is above 0, currently the model
      will be always deployed precisely on min_replica_count.
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformUiMachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiDeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiDeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiDeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformUiDeployedModel', 1)


class GoogleCloudAiplatformUiDeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Enums:
    UiStateValueValuesEnum: Output only. The state of the model deployment.
      Different from public API, BEING_DEPLOYED and FAILED deployment state
      model will also be returned in Ui ListEndpoints.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by AI Platform, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    enableAccessLogging: These logs are like standard server access logs,
      containing information like timestamp and latency for each prediction
      request. Note that Stackdriver logs may incur a cost, especially if your
      project receives prediction requests at a high queries per second rate
      (QPS). Estimate your costs before enabling this option.
    enableContainerLogging: If true, the container of the DeployedModel
      instances will send `stderr` and `stdout` streams to Stackdriver
      Logging. Only supported for custom-trained Models and AutoML Tables
      Models.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. The corresponding
      Model.explanation_spec must be populated, otherwise explanation for this
      Model is not allowed. Currently, only AutoML tabular Models support
      explanation_spec.
    id: Output only. The ID of the DeployedModel.
    model: Required. The name of the Model this is the deployment of. Note
      that the Model may be in a different location than the DeployedModel's
      Endpoint.
    modelDisplayName: Output only. The display name of the Model this
      DeployedModel was created from.
    modelObjective: Output only. The objective of the Model this DeployedModel
      was created from.
    uiState: Output only. The state of the model deployment. Different from
      public API, BEING_DEPLOYED and FAILED deployment state model will also
      be returned in Ui ListEndpoints.
  """

  class UiStateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the model deployment. Different from public
    API, BEING_DEPLOYED and FAILED deployment state model will also be
    returned in Ui ListEndpoints.

    Values:
      UI_DEPLOYMENT_STATE_UNSPECIFIED: Should not be used.
      UI_DEPLOYMENT_STATE_BEING_DEPLOYED: The deployment of the model is
        ongoing and not ready for use yet. The resource is not usable at this
        state.
      UI_DEPLOYMENT_STATE_DEPLOYED: The model is deployed.
      UI_DEPLOYMENT_STATE_BEING_UNDEPLOYED: The model is being undeployed. The
        resource is not usable at this state.
      UI_DEPLOYMENT_STATE_FAILED: The model is failed to deploy or undeploy.
        The resource is not usable at this state.
    """
    UI_DEPLOYMENT_STATE_UNSPECIFIED = 0
    UI_DEPLOYMENT_STATE_BEING_DEPLOYED = 1
    UI_DEPLOYMENT_STATE_DEPLOYED = 2
    UI_DEPLOYMENT_STATE_BEING_UNDEPLOYED = 3
    UI_DEPLOYMENT_STATE_FAILED = 4

  automaticResources = _messages.MessageField('GoogleCloudAiplatformUiAutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformUiDedicatedResources', 3)
  displayName = _messages.StringField(4)
  enableAccessLogging = _messages.BooleanField(5)
  enableContainerLogging = _messages.BooleanField(6)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformUiExplanationSpec', 7)
  id = _messages.StringField(8)
  model = _messages.StringField(9)
  modelDisplayName = _messages.StringField(10)
  modelObjective = _messages.StringField(11)
  uiState = _messages.EnumField('UiStateValueValuesEnum', 12)


class GoogleCloudAiplatformUiExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform.
    OutputsValue: Required. Map from output names to output metadata. Keys are
      the name of the output field in the prediction to be explained.
      Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML tabular
      Models always have this field populated by AI Platform. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform.
    outputs: Required. Map from output names to output metadata. Keys are the
      name of the output field in the prediction to be explained. Currently
      only one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by AI Platform.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformUiExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. Keys are the name
    of the output field in the prediction to be explained. Currently only one
    key is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformUiExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  outputs = _messages.MessageField('OutputsValue', 3)


class GoogleCloudAiplatformUiExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature.

  Fields:
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, AI Platform chooses the baseline for this feature. If
      multiple baselines are specified, AI Platform returns the average
      attributions across them in Attributions.baseline_attribution. The
      element of the baselines must be in the same format as the feature's
      input in the instance[]. The schema of any single instance may be
      specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
  """

  inputBaselines = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)


class GoogleCloudAiplatformUiExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimentions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformUiExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features.
  """

  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformUiSampledShapleyAttribution', 1)


class GoogleCloudAiplatformUiExplanationSpec(_messages.Message):
  r"""Specification of Model explanation. Currently, only AutoML tabular
  Models support explanation.

  Fields:
    metadata: Required. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformUiExplanationParameters', 2)


class GoogleCloudAiplatformUiExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 2)


class GoogleCloudAiplatformUiExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation.
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportEvaluatedDataItems operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      operation.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes this operation's output. Supplements
  ExportEvaluatedDataItemsRequest.output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in bq://projectId.bqDatasetId.tableId format, into which the
      evaluated DataItems are exported.
  """

  bigqueryOutputDataset = _messages.StringField(1)


class GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationResponse(_messages.Message):
  r"""Response of ModelService.ExportEvaluatedDataItems operation."""


class GoogleCloudAiplatformUiExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformUiExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformUiExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    artifactOutputUri: Output only. If the Model artifact is being exported to
      Google Cloud Storage this is the full path of the directory created,
      into which the Model files are being written to.
    gcsOutputDirectory: Output only. If the Model is being exported to Google
      Cloud Storage this is the full path of the directory created, into which
      the Model files are being written to.
    imageOutputUri: Output only. If the Model image is being exported to
      Google Container Registry or Artifact Registry this is the full path of
      the image created.
  """

  artifactOutputUri = _messages.StringField(1)
  gcsOutputDirectory = _messages.StringField(2)
  imageOutputUri = _messages.StringField(3)


class GoogleCloudAiplatformUiExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformUiGenerateDatasetStatsOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.GenerateDatasetStats.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiGenerateDatasetStatsResponse(_messages.Message):
  r"""Response message for DatasetService.GenerateDatasetStats."""


class GoogleCloudAiplatformUiGenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Enums:
    StateValueValuesEnum: Output only. Used only when Operation.done field is
      false. This field can indicate the pending state of operation and will
      be set to DONE when operation is done.

  Fields:
    cancellable: Output only. True if operation can be cancelled. If false,
      calling CancelOperation will return UNIMPLEMENTED error.
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard GCP error details.
    state: Output only. Used only when Operation.done field is false. This
      field can indicate the pending state of operation and will be set to
      DONE when operation is done.
    updateTime: Output only. Time when the operation was updated for the last
      time.
    worksOn: Output only. List of resource names that the operation is working
      on.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Used only when Operation.done field is false. This field
    can indicate the pending state of operation and will be set to DONE when
    operation is done.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      RUNNING: Operation is still running.
      CANCELLING: Operation is being cancelled.
      DONE: Operation is done.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    CANCELLING = 2
    DONE = 3

  cancellable = _messages.BooleanField(1)
  createTime = _messages.StringField(2)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 3, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)
  worksOn = _messages.StringField(6, repeated=True)


class GoogleCloudAiplatformUiImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformUiMachineSpec(_messages.Message):
  r"""Specification of a single machine.

  Enums:
    AcceleratorTypeValueValuesEnum: Immutable. The type of accelerator(s) that
      may be attached to the machine as per accelerator_count.

  Fields:
    acceleratorCount: The number of accelerators to attach to the machine.
    acceleratorType: Immutable. The type of accelerator(s) that may be
      attached to the machine as per accelerator_count.
    machineType: Immutable. The type of the machine. Following machine types
      are supported: * `n1-standard-2` * `n1-standard-4` * `n1-standard-8` *
      `n1-standard-16` * `n1-standard-32` * `n1-highmem-2` * `n1-highmem-4` *
      `n1-highmem-8` * `n1-highmem-16` * `n1-highmem-32` * `n1-highcpu-2` *
      `n1-highcpu-4` * `n1-highcpu-8` * `n1-highcpu-16` * `n1-highcpu-32` When
      used for DeployedMode this field is optional and the default value is
      `n1-standard-2`. If used for BatchPredictionJob or as part of
      WorkerPoolSpec this field is required.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of accelerator(s) that may be attached to the
    machine as per accelerator_count.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type, which means
        no accelerator.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 2)
  machineType = _messages.StringField(3)


class GoogleCloudAiplatformUiMigratableResource(_messages.Message):
  r"""Represents one resource that exists in automl.googleapis.com,
  datalabeling.googleapis.com or ml.googleapis.com.

  Fields:
    automlDataset: Output only. Represents one Dataset in
      automl.googleapis.com.
    automlModel: Output only. Represents one Model in automl.googleapis.com.
    dataLabelingDataset: Output only. Represents one Dataset in
      datalabeling.googleapis.com.
    lastMigrateTime: Output only. Timestamp when last migrate attempt on this
      MigratableResource started. Will not be set if there's no migrate
      attempt on this MigratableResource.
    lastUpdateTime: Output only. Timestamp when this MigratableResource was
      last updated.
    mlEngineModelVersion: Output only. Represents one Version in
      ml.googleapis.com.
  """

  automlDataset = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceAutomlDataset', 1)
  automlModel = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceAutomlModel', 2)
  dataLabelingDataset = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceDataLabelingDataset', 3)
  lastMigrateTime = _messages.StringField(4)
  lastUpdateTime = _messages.StringField(5)
  mlEngineModelVersion = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceMlEngineModelVersion', 6)


class GoogleCloudAiplatformUiMigratableResourceAutomlDataset(_messages.Message):
  r"""Represents one Dataset in automl.googleapis.com.

  Fields:
    dataset: Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in automl.googleapis.com.
    suggestedDatasetDisplayName: Suggested display name of the Dataset in AI
      Platform.
    suggestedSavedQueryDisplayName: Suggested display name of the SavedQuery
      in AI Platform.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)
  suggestedDatasetDisplayName = _messages.StringField(3)
  suggestedSavedQueryDisplayName = _messages.StringField(4)


class GoogleCloudAiplatformUiMigratableResourceAutomlModel(_messages.Message):
  r"""Represents one Model in automl.googleapis.com.

  Fields:
    model: Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: The Model's display name in automl.googleapis.com.
    suggestedModelDisplayName: Suggested display name of the model in AI
      Platform.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)
  suggestedModelDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformUiMigratableResourceDataLabelingDataset(_messages.Message):
  r"""Represents one Dataset in datalabeling.googleapis.com.

  Fields:
    dataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
      datalabeling.googleapis.com belongs to the data labeling Dataset.
    dataset: Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in
      datalabeling.googleapis.com.
    suggestedDatasetDisplayName: Suggested display name of the Dataset in AI
      Platform.
  """

  dataLabelingAnnotatedDatasets = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset', 1, repeated=True)
  dataset = _messages.StringField(2)
  datasetDisplayName = _messages.StringField(3)
  suggestedDatasetDisplayName = _messages.StringField(4)


class GoogleCloudAiplatformUiMigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset(_messages.Message):
  r"""Represents one AnnotatedDataset in datalabeling.googleapis.com.

  Fields:
    annotatedDataset: Full resource name of data labeling AnnotatedDataset.
      Format: `projects/{project}/datasets/{dataset}/annotatedDatasets/{annota
      ted_dataset}`.
    annotatedDatasetDisplayName: The AnnotatedDataset's display name in
      datalabeling.googleapis.com.
    suggestedSavedQueryDisplayName: Suggested display name of the SavedQuery
      in AI Platform.
  """

  annotatedDataset = _messages.StringField(1)
  annotatedDatasetDisplayName = _messages.StringField(2)
  suggestedSavedQueryDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformUiMigratableResourceMlEngineModelVersion(_messages.Message):
  r"""Represents one model Version in ml.googleapis.com.

  Fields:
    endpoint: The ml.googleapis.com endpoint that this model Version currently
      lives in. Example values: * ml.googleapis.com * us-centrall-
      ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    suggestedModelDisplayName: Suggested display name of the model in AI
      Platform.
    version: Full resource name of ml engine model Version. Format:
      `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  suggestedModelDisplayName = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudAiplatformUiMigrateResourceResponse(_messages.Message):
  r"""Describes a successfully migrated resource.

  Fields:
    dataset: Migrated Dataset's resource name.
    migratableResource: Before migration, the identifier in ml.googleapis.com,
      automl.googleapis.com or datalabeling.googleapis.com.
    model: Migrated Model's resource name.
  """

  dataset = _messages.StringField(1)
  migratableResource = _messages.MessageField('GoogleCloudAiplatformUiMigratableResource', 2)
  model = _messages.StringField(3)


class GoogleCloudAiplatformUiRemoveAnnotationSpecFromSavedQueryOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  DatasetService.RemoveAnnotationSpecFromSavedQuery.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiSampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    pathCount: Required. The number of feature permutations to consider when
      approximating the Shapley values. Valid range of its value is [1, 50],
      inclusively.
  """

  pathCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaAnnotationSpecColor(_messages.Message):
  r"""An entry of mapping between color and AnnotationSpec. The mapping is
  used in segmentation mask.

  Fields:
    color: The color of the AnnotationSpec in a segmentation mask.
    displayName: The display name of the AnnotationSpec represented by the
      color in the segmentation mask.
    id: The ID of the AnnotationSpec represented by the color in the
      segmentation mask.
  """

  color = _messages.MessageField('GoogleTypeColor', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)


class GoogleCloudAiplatformUiSchemaImageBoundingBoxAnnotation(_messages.Message):
  r"""Annotation details specific to image object detection.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  xMax = _messages.FloatField(3)
  xMin = _messages.FloatField(4)
  yMax = _messages.FloatField(5)
  yMin = _messages.FloatField(6)


class GoogleCloudAiplatformUiSchemaImageClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to image classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaImageDataItem(_messages.Message):
  r"""Payload of Image DataItem.

  Fields:
    contentUri: Output only. Signed HTTP URI points to the normalized image,
      expires in 10 minutes.
    gcsUri: Required. Google Cloud Storage URI points to the original image in
      user's bucket. The image is up to 30MB in size.
    mimeType: Output only. The mime type of the content of the image. Only the
      images in below listed mime types are supported. - image/jpeg -
      image/gif - image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
    resolution: Output only. The resolution of the original image.
    thumbnailUri: Output only. Signed HTTP URI points to the thumbnail image,
      expires in 10 minutes.
  """

  contentUri = _messages.StringField(1)
  gcsUri = _messages.StringField(2)
  mimeType = _messages.StringField(3)
  resolution = _messages.MessageField('GoogleCloudAiplatformUiSchemaResolution', 4)
  thumbnailUri = _messages.StringField(5)


class GoogleCloudAiplatformUiSchemaImageDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Image DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Image DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaImageSegmentationAnnotation(_messages.Message):
  r"""Annotation details specific to image segmentation.

  Fields:
    annotationSpecColors: The mapping between color and AnnotationSpec for
      this Annotation.
    maskGcsUri: Google Cloud Storage URI that points to the mask image. The
      image must be in PNG format. It must have the same size as the
      DataItem's image. Each pixel in the image mask represents the
      AnnotationSpec which the pixel in the image DataItem belong to. Each
      color is mapped to one AnnotationSpec based on annotation_spec_colors.
  """

  annotationSpecColors = _messages.MessageField('GoogleCloudAiplatformUiSchemaAnnotationSpecColor', 1, repeated=True)
  maskGcsUri = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaResolution(_messages.Message):
  r"""Represents the resolution of an image or a video frame.

  Fields:
    height: Number of pixels in the vertical dimension.
    width: Number of pixels in the horizontal dimension.
  """

  height = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  width = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain tables data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformUiSchemaTablesDatasetMetadataInputConfig attribute.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformUiSchemaTablesDatasetMetadataInputConfig', 1)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource object.

  Fields:
    uri: Google Cloud Storage URI to a input file, only .csv file is
      supported.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadataInputConfig(_messages.Message):
  r"""The tables Dataset's data source. The Dataset doesn't store the data
  directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformUiSchemaTextClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to text classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaTextDataItem(_messages.Message):
  r"""Payload of Text DataItem.

  Fields:
    content: Output only. It is only returned in GetDataItem response. The
      content of the text snippet as a string.
    gcsUri: Output only. Google Cloud Storage URI points to the original text
      in user's bucket. The text file is up to 10MB in size.
    trucatedContent: Output only. It is only returned in ListDataItems
      response. Same as content if content has up to 100 characters. Otherwise
      this field contains first 100 characters of the content.
    truncated: Output only. It is only returned in ListDataItems response.
      True if and only if the truncated_content is different from the full
      content.
  """

  content = _messages.StringField(1)
  gcsUri = _messages.StringField(2)
  trucatedContent = _messages.StringField(3)
  truncated = _messages.BooleanField(4)


class GoogleCloudAiplatformUiSchemaTextDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Text DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Text DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaTextExtractionAnnotation(_messages.Message):
  r"""Annotation details specific to text extraction.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    textSegment: The segment of the text content.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  textSegment = _messages.MessageField('GoogleCloudAiplatformUiSchemaTextSegment', 3)


class GoogleCloudAiplatformUiSchemaTextSegment(_messages.Message):
  r"""The text segment inside of DataItem.

  Fields:
    content: The text content in the segment for output only.
    endOffset: Zero-based character index of the first character past the end
      of the text segment (counting character from the beginning of the text).
      The character at the end_offset is NOT included in the text segment.
    startOffset: Zero-based character index of the first character of the text
      segment (counting characters from the beginning of the text).
  """

  content = _messages.StringField(1)
  endOffset = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  startOffset = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class GoogleCloudAiplatformUiSchemaTextSentimentAnnotation(_messages.Message):
  r"""Annotation details specific to text sentiment.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    sentiment: The sentiment score for text.
    sentimentMax: The sentiment max score for text.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sentiment = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sentimentMax = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaTextSentimentSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains TextSentiment Annotations.

  Fields:
    sentimentMax: The maximum sentiment of sentiment Anntoation in this
      SavedQuery.
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaTimeSegment(_messages.Message):
  r"""A time period inside of a DataItem that has a time dimension (e.g.
  video).

  Fields:
    endTimeOffset: End of the time segment (exclusive), represented as the
      duration since the start of the DataItem.
    startTimeOffset: Start of the time segment (inclusive), represented as the
      duration since the start of the DataItem.
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain time series data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataInputConfig
      attribute.
    timeColumn: The column name of the time column that identifies time order
      in the time series.
    timeSeriesIdentifierColumn: The column name of the time series identifier
      column that identifies the time series.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataInputConfig', 1)
  timeColumn = _messages.StringField(2)
  timeSeriesIdentifierColumn = _messages.StringField(3)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Google Cloud Storage URI to a input file, only .csv file is
      supported.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataInputConfig(_messages.Message):
  r"""The time series Dataset's data source. The Dataset doesn't store the
  data directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A
      GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformUiSchemaVideoActionRecognitionAnnotation(_messages.Message):
  r"""Annotation details specific to video action recognition.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSegment', 3)


class GoogleCloudAiplatformUiSchemaVideoClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to video classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSegment', 3)


class GoogleCloudAiplatformUiSchemaVideoDataItem(_messages.Message):
  r"""Payload of Video DataItem.

  Fields:
    contentUri: Output only. Signed HTTP URI points to the transcoded video,
      expires in 1 hour.
    duration: Output only. The duration of the video.
    frameRate: Output only. The number of frames per second of the video.
    gcsUri: Required. Google Cloud Storage URI points to the original video in
      user's bucket. The video is up to 50 GB in size and up to 3 hour in
      duration.
    mimeType: Output only. The mime type of the content of the video. Only the
      videos in below listed mime types are supported. Supported mime_type: -
      video/mp4 - video/avi - video/quicktime
    resolution: Output only. The resolution of the video.
    thumbnailUri: Output only. Signed HTTP URI point to thumbnail image of the
      video, expires in 1 hour.
  """

  contentUri = _messages.StringField(1)
  duration = _messages.StringField(2)
  frameRate = _messages.FloatField(3)
  gcsUri = _messages.StringField(4)
  mimeType = _messages.StringField(5)
  resolution = _messages.MessageField('GoogleCloudAiplatformUiSchemaResolution', 6)
  thumbnailUri = _messages.StringField(7)


class GoogleCloudAiplatformUiSchemaVideoDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Video DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Video DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaVideoObjectTrackingAnnotation(_messages.Message):
  r"""Annotation details specific to video object tracking.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    instanceId: The instance of the object, expressed as a positive integer.
      Used to track the same object across different frames.
    timeOffset: A time (frame) of a video to which this annotation pertains.
      Represented as the duration since the video's start.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  instanceId = _messages.IntegerField(3)
  timeOffset = _messages.StringField(4)
  xMax = _messages.FloatField(5)
  xMin = _messages.FloatField(6)
  yMax = _messages.FloatField(7)
  yMin = _messages.FloatField(8)


class GoogleCloudAiplatformUiSchemaVisualInspectionClassificationLabelSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaVisualInspectionClassificationLabelSavedQ
  ueryMetadata object.

  Fields:
    multiLabel: Whether or not the classification label is multi_label.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformUiSchemaVisualInspectionMaskSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaVisualInspectionMaskSavedQueryMetadata
  object.

  Fields:
    colorMap: The mapping between color and AnnotationSpec for this
      SavedQuery.
  """

  colorMap = _messages.MessageField('GoogleCloudAiplatformUiSchemaAnnotationSpecColor', 1, repeated=True)


class GoogleCloudAiplatformUiSpecialistPool(_messages.Message):
  r"""SpecialistPool represents customers' own workforce to work on their data
  labeling jobs. It includes a group of specialist managers who are
  responsible for managing the labelers in this pool as well as customers'
  data labeling jobs associated with this pool. Customers create specialist
  pool as well as start data labeling jobs on Cloud, managers and labelers
  work with the jobs using CrowdCompute console.

  Fields:
    displayName: Required. The user-defined name of the SpecialistPool. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. This field should be unique on project-level.
    name: Required. The resource name of the SpecialistPool.
    pendingDataLabelingJobObjects: Output only. The DataLabelingJobs' metadata
      in JOB_STATE_RUNNING using this SpecialistPool.
    pendingDataLabelingJobs: Output only. The resource name of the pending
      data labeling jobs.
    specialistManagerEmails: The email addresses of the specialists in the
      SpecialistPool.
    specialistManagersCount: Output only. The number of Specialists in this
      SpecialistPool.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  pendingDataLabelingJobObjects = _messages.MessageField('GoogleCloudAiplatformUiDataLabelingJobRef', 3, repeated=True)
  pendingDataLabelingJobs = _messages.StringField(4, repeated=True)
  specialistManagerEmails = _messages.StringField(5, repeated=True)
  specialistManagersCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiUndeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.UndeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiUndeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.UndeployModel."""


class GoogleCloudAiplatformUiUpdateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation metadata for
  SpecialistPoolService.UpdateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
    specialistPool: Output only. The name of the SpecialistPool to which the
      specialists are being added. Format: `projects/{project_id}/locations/{l
      ocation_id}/specialistPools/{specialist_pool}`
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)
  specialistPool = _messages.StringField(2)


class GoogleCloudAiplatformUiUploadModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.UploadModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiUploadModelResponse(_messages.Message):
  r"""Response message of ModelService.UploadModel operation.

  Fields:
    model: The name of the uploaded Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  model = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1AutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by AI
  Platform, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      a no upper bound for scaling under heavy traffic will be assume, though
      AI Platform may be unable to scale beyond certain replica number.
    minReplicaCount: Immutable. The minimum number of replicas this
      DeployedModel will be always deployed on. If traffic against it
      increases, it may dynamically be deployed onto more replicas up to
      max_replica_count, and as traffic decreases, some of these extra
      replicas may be freed. If requested value is too large, the deployment
      will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1BatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1BatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1CreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1CreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1CreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1DedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel, and
  that need a higher degree of manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine
      used by the prediction.
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas this DeployedModel will be always deployed on. If traffic
      against it increases, it may dynamically be deployed onto more replicas,
      and as traffic decreases, some of these extra replicas may be freed.
      Note: if machine_spec.accelerator_count is above 0, currently the model
      will be always deployed precisely on min_replica_count.
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1MachineSpec', 1)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1DeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1DeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1DeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1alpha1DeployedModel', 1)


class GoogleCloudAiplatformV1alpha1DeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by AI Platform, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. The corresponding
      Model.explanation_spec must be populated, otherwise explanation for this
      Model is not allowed. Currently, only AutoML tabular Models support
      explanation_spec.
    id: Output only. The ID of the DeployedModel.
    model: Required. The name of the Model this is the deployment of. Note
      that the Model may be in a different location than the DeployedModel's
      Endpoint.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1alpha1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1alpha1DedicatedResources', 3)
  displayName = _messages.StringField(4)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationSpec', 5)
  id = _messages.StringField(6)
  model = _messages.StringField(7)


class GoogleCloudAiplatformV1alpha1ExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform.
    OutputsValue: Required. Map from output names to output metadata. Keys are
      the name of the output field in the prediction to be explained.
      Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML tabular
      Models always have this field populated by AI Platform. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform.
    outputs: Required. Map from output names to output metadata. Keys are the
      name of the output field in the prediction to be explained. Currently
      only one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by AI Platform.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1alpha1ExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. Keys are the name
    of the output field in the prediction to be explained. Currently only one
    key is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudAiplatformV1alpha1ExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  outputs = _messages.MessageField('OutputsValue', 3)


class GoogleCloudAiplatformV1alpha1ExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature.

  Fields:
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, AI Platform chooses the baseline for this feature. If
      multiple baselines are specified, AI Platform returns the average
      attributions across them in Attributions.baseline_attribution. The
      element of the baselines must be in the same format as the feature's
      input in the instance[]. The schema of any single instance may be
      specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
  """

  inputBaselines = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1ExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimentions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1alpha1ExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features.
  """

  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformV1alpha1SampledShapleyAttribution', 1)


class GoogleCloudAiplatformV1alpha1ExplanationSpec(_messages.Message):
  r"""Specification of Model explanation. Currently, only AutoML tabular
  Models support explanation.

  Fields:
    metadata: Required. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationParameters', 2)


class GoogleCloudAiplatformV1alpha1ExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1alpha1ExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation.
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportEvaluatedDataItems operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      operation.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes this operation's output. Supplements
  ExportEvaluatedDataItemsRequest.output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in bq://projectId.bqDatasetId.tableId format, into which the
      evaluated DataItems are exported.
  """

  bigqueryOutputDataset = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationResponse(_messages.Message):
  r"""Response of ModelService.ExportEvaluatedDataItems operation."""


class GoogleCloudAiplatformV1alpha1ExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1alpha1ExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    gcsOutputDirectory: Output only. If the Model is being exported to Google
      Cloud Storage this is the full path of the directory created, into which
      the Model files are being written to.
  """

  gcsOutputDirectory = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1ExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformV1alpha1GenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Fields:
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard GCP error details.
    updateTime: Output only. Time when the operation was updated for the last
      time.
  """

  createTime = _messages.StringField(1)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1ImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1ImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformV1alpha1MachineSpec(_messages.Message):
  r"""Specification of a single machine.

  Enums:
    AcceleratorTypeValueValuesEnum: Immutable. The type of accelerator(s) that
      may be attached to the machine as per accelerator_count.

  Fields:
    acceleratorCount: The number of accelerators to attach to the machine.
    acceleratorType: Immutable. The type of accelerator(s) that may be
      attached to the machine as per accelerator_count.
    machineType: Immutable. The type of the machine. Following machine types
      are supported: * `n1-standard-2` * `n1-standard-4` * `n1-standard-8` *
      `n1-standard-16` * `n1-standard-32` * `n1-highmem-2` * `n1-highmem-4` *
      `n1-highmem-8` * `n1-highmem-16` * `n1-highmem-32` * `n1-highcpu-2` *
      `n1-highcpu-4` * `n1-highcpu-8` * `n1-highcpu-16` * `n1-highcpu-32` When
      used for DeployedMode this field is optional and the default value is
      `n1-standard-2`. If used for BatchPredictionJob or as part of
      WorkerPoolSpec this field is required.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of accelerator(s) that may be attached to the
    machine as per accelerator_count.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type, which means
        no accelerator.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 2)
  machineType = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1MigratableResource(_messages.Message):
  r"""Represents one resource that exists in automl.googleapis.com,
  datalabeling.googleapis.com or ml.googleapis.com.

  Fields:
    automlDataset: Output only. Represents one Dataset in
      automl.googleapis.com.
    automlModel: Output only. Represents one Model in automl.googleapis.com.
    dataLabelingDataset: Output only. Represents one Dataset in
      datalabeling.googleapis.com.
    lastMigrateTime: Output only. Timestamp when last migrate attempt on this
      MigratableResource started. Will not be set if there's no migrate
      attempt on this MigratableResource.
    lastUpdateTime: Output only. Timestamp when this MigratableResource was
      last updated.
    mlEngineModelVersion: Output only. Represents one Version in
      ml.googleapis.com.
  """

  automlDataset = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceAutomlDataset', 1)
  automlModel = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceAutomlModel', 2)
  dataLabelingDataset = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDataset', 3)
  lastMigrateTime = _messages.StringField(4)
  lastUpdateTime = _messages.StringField(5)
  mlEngineModelVersion = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceMlEngineModelVersion', 6)


class GoogleCloudAiplatformV1alpha1MigratableResourceAutomlDataset(_messages.Message):
  r"""Represents one Dataset in automl.googleapis.com.

  Fields:
    dataset: Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in automl.googleapis.com.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigratableResourceAutomlModel(_messages.Message):
  r"""Represents one Model in automl.googleapis.com.

  Fields:
    model: Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: The Model's display name in automl.googleapis.com.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDataset(_messages.Message):
  r"""Represents one Dataset in datalabeling.googleapis.com.

  Fields:
    dataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
      datalabeling.googleapis.com belongs to the data labeling Dataset.
    dataset: Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in
      datalabeling.googleapis.com.
  """

  dataLabelingAnnotatedDatasets = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset', 1, repeated=True)
  dataset = _messages.StringField(2)
  datasetDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset(_messages.Message):
  r"""Represents one AnnotatedDataset in datalabeling.googleapis.com.

  Fields:
    annotatedDataset: Full resource name of data labeling AnnotatedDataset.
      Format: `projects/{project}/datasets/{dataset}/annotatedDatasets/{annota
      ted_dataset}`.
    annotatedDatasetDisplayName: The AnnotatedDataset's display name in
      datalabeling.googleapis.com.
  """

  annotatedDataset = _messages.StringField(1)
  annotatedDatasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigratableResourceMlEngineModelVersion(_messages.Message):
  r"""Represents one model Version in ml.googleapis.com.

  Fields:
    endpoint: The ml.googleapis.com endpoint that this model Version currently
      lives in. Example values: * ml.googleapis.com * us-centrall-
      ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    version: Full resource name of ml engine model Version. Format:
      `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  version = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigrateResourceResponse(_messages.Message):
  r"""Describes a successfully migrated resource.

  Fields:
    dataset: Migrated Dataset's resource name.
    migratableResource: Before migration, the identifier in ml.googleapis.com,
      automl.googleapis.com or datalabeling.googleapis.com.
    model: Migrated Model's resource name.
  """

  dataset = _messages.StringField(1)
  migratableResource = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResource', 2)
  model = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1SampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    pathCount: Required. The number of feature permutations to consider when
      approximating the Shapley values. Valid range of its value is [1, 50],
      inclusively.
  """

  pathCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1SchemaAnnotationSpecColor(_messages.Message):
  r"""An entry of mapping between color and AnnotationSpec. The mapping is
  used in segmentation mask.

  Fields:
    color: The color of the AnnotationSpec in a segmentation mask.
    displayName: The display name of the AnnotationSpec represented by the
      color in the segmentation mask.
    id: The ID of the AnnotationSpec represented by the color in the
      segmentation mask.
  """

  color = _messages.MessageField('GoogleTypeColor', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1SchemaImageBoundingBoxAnnotation(_messages.Message):
  r"""Annotation details specific to image object detection.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  xMax = _messages.FloatField(3)
  xMin = _messages.FloatField(4)
  yMax = _messages.FloatField(5)
  yMin = _messages.FloatField(6)


class GoogleCloudAiplatformV1alpha1SchemaImageClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to image classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaImageDataItem(_messages.Message):
  r"""Payload of Image DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original image in
      user's bucket. The image is up to 30MB in size.
    mimeType: Output only. The mime type of the content of the image. Only the
      images in below listed mime types are supported. - image/jpeg -
      image/gif - image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaImageDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Image DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Image DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotation(_messages.Message):
  r"""Annotation details specific to image segmentation.

  Fields:
    annotationSpecColors: The mapping between color and AnnotationSpec for
      this Annotation.
    maskGcsUri: Google Cloud Storage URI that points to the mask image. The
      image must be in PNG format. It must have the same size as the
      DataItem's image. Each pixel in the image mask represents the
      AnnotationSpec which the pixel in the image DataItem belong to. Each
      color is mapped to one AnnotationSpec based on annotation_spec_colors.
  """

  annotationSpecColors = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaAnnotationSpecColor', 1, repeated=True)
  maskGcsUri = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain tables data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataInputConfig
      attribute.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataInputConfig', 1)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Google Cloud Storage URI to a input file, only .csv file is
      supported.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataInputConfig(_messages.Message):
  r"""The tables Dataset's data source. The Dataset doesn't store the data
  directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A
      GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1alpha1SchemaTextClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to text classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaTextDataItem(_messages.Message):
  r"""Payload of Text DataItem.

  Fields:
    gcsUri: Output only. Google Cloud Storage URI points to the original text
      in user's bucket. The text file is up to 10MB in size.
  """

  gcsUri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1SchemaTextDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Text DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Text DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaTextExtractionAnnotation(_messages.Message):
  r"""Annotation details specific to text extraction.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    textSegment: The segment of the text content.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  textSegment = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTextSegment', 3)


class GoogleCloudAiplatformV1alpha1SchemaTextSegment(_messages.Message):
  r"""The text segment inside of DataItem.

  Fields:
    content: The text content in the segment for output only.
    endOffset: Zero-based character index of the first character past the end
      of the text segment (counting character from the beginning of the text).
      The character at the end_offset is NOT included in the text segment.
    startOffset: Zero-based character index of the first character of the text
      segment (counting characters from the beginning of the text).
  """

  content = _messages.StringField(1)
  endOffset = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  startOffset = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class GoogleCloudAiplatformV1alpha1SchemaTextSentimentAnnotation(_messages.Message):
  r"""Annotation details specific to text sentiment.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    sentiment: The sentiment score for text.
    sentimentMax: The sentiment max score for text.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sentiment = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sentimentMax = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1SchemaTextSentimentSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains TextSentiment Annotations.

  Fields:
    sentimentMax: The maximum sentiment of sentiment Anntoation in this
      SavedQuery.
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1SchemaTimeSegment(_messages.Message):
  r"""A time period inside of a DataItem that has a time dimension (e.g.
  video).

  Fields:
    endTimeOffset: End of the time segment (exclusive), represented as the
      duration since the start of the DataItem.
    startTimeOffset: Start of the time segment (inclusive), represented as the
      duration since the start of the DataItem.
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain time series data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataInputConfig
      attribute.
    timeColumn: The column name of the time column that identifies time order
      in the time series.
    timeSeriesIdentifierColumn: The column name of the time series identifier
      column that identifies the time series.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataInputConfig', 1)
  timeColumn = _messages.StringField(2)
  timeSeriesIdentifierColumn = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Google Cloud Storage URI to a input file, only .csv file is
      supported.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataInputConfig(_messages.Message):
  r"""The time series Dataset's data source. The Dataset doesn't store the
  data directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySour
      ce attribute.
    gcsSource: A
      GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1alpha1SchemaVideoActionRecognitionAnnotation(_messages.Message):
  r"""Annotation details specific to video action recognition.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1alpha1SchemaVideoClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to video classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1alpha1SchemaVideoDataItem(_messages.Message):
  r"""Payload of Video DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original video in
      user's bucket. The video is up to 50 GB in size and up to 3 hour in
      duration.
    mimeType: Output only. The mime type of the content of the video. Only the
      videos in below listed mime types are supported. Supported mime_type: -
      video/mp4 - video/avi - video/quicktime
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaVideoDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Video DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Video DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaVideoObjectTrackingAnnotation(_messages.Message):
  r"""Annotation details specific to video object tracking.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    instanceId: The instance of the object, expressed as a positive integer.
      Used to track the same object across different frames.
    timeOffset: A time (frame) of a video to which this annotation pertains.
      Represented as the duration since the video's start.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  instanceId = _messages.IntegerField(3)
  timeOffset = _messages.StringField(4)
  xMax = _messages.FloatField(5)
  xMin = _messages.FloatField(6)
  yMax = _messages.FloatField(7)
  yMin = _messages.FloatField(8)


class GoogleCloudAiplatformV1alpha1SchemaVisualInspectionClassificationLabelSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaVisualInspectionClassificationLabel
  SavedQueryMetadata object.

  Fields:
    multiLabel: Whether or not the classification label is multi_label.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformV1alpha1SchemaVisualInspectionMaskSavedQueryMetadata(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1alpha1SchemaVisualInspectionMaskSavedQueryMetadata
  object.

  Fields:
    colorMap: The mapping between color and AnnotationSpec for this
      SavedQuery.
  """

  colorMap = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaAnnotationSpecColor', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1SpecialistPool(_messages.Message):
  r"""SpecialistPool represents customers' own workforce to work on their data
  labeling jobs. It includes a group of specialist managers who are
  responsible for managing the labelers in this pool as well as customers'
  data labeling jobs associated with this pool. Customers create specialist
  pool as well as start data labeling jobs on Cloud, managers and labelers
  work with the jobs using CrowdCompute console.

  Fields:
    displayName: Required. The user-defined name of the SpecialistPool. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. This field should be unique on project-level.
    name: Required. The resource name of the SpecialistPool.
    pendingDataLabelingJobs: Output only. The resource name of the pending
      data labeling jobs.
    specialistManagerEmails: The email addresses of the specialists in the
      SpecialistPool.
    specialistManagersCount: Output only. The number of Specialists in this
      SpecialistPool.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  pendingDataLabelingJobs = _messages.StringField(3, repeated=True)
  specialistManagerEmails = _messages.StringField(4, repeated=True)
  specialistManagersCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1UndeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.UndeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1UndeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.UndeployModel."""


class GoogleCloudAiplatformV1alpha1UpdateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation metadata for
  SpecialistPoolService.UpdateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
    specialistPool: Output only. The name of the SpecialistPool to which the
      specialists are being added. Format: `projects/{project_id}/locations/{l
      ocation_id}/specialistPools/{specialist_pool}`
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)
  specialistPool = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1UploadModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.UploadModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1UploadModelResponse(_messages.Message):
  r"""Response message of ModelService.UploadModel operation.

  Fields:
    model: The name of the uploaded Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  model = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1Annotation(_messages.Message):
  r"""Used to assign specific AnnotationSpec to a particular area of a
  DataItem or the whole part of the DataItem.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Annotations. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.

  Fields:
    annotationSource: Output only. The source of the Annotation.
    createTime: Output only. Timestamp when this Annotation was created.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      Annotations. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.
    name: Output only. Resource name of the Annotation.
    payload: Required. The schema of the payload can be found in
      payload_schema.
    payloadSchemaUri: Required. Google Cloud Storage URI points to a YAML file
      describing payload. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://tinyurl.com/y538mdwt). The schema files that can be used
      here are found in gs://google-cloud-
      aiplatform/schema/dataset/annotation/, note that the chosen schema must
      be consistent with the parent Dataset's metadata.
    updateTime: Output only. Timestamp when this Annotation was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Annotations. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one Annotation(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each Annotation: *
    "aiplatform.googleapis.com/annotation_set_name": optional, name of the
    UI's annotation set this Annotation belongs to. If not set the Annotation
    is not visible in the UI. * "aiplatform.googleapis.com/payload_schema":
    output only, its value is the payload_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationSource = _messages.MessageField('GoogleCloudAiplatformV1beta1UserActionReference', 1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  payload = _messages.MessageField('extra_types.JsonValue', 6)
  payloadSchemaUri = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1beta1AnnotationSpec(_messages.Message):
  r"""Identifies a concept with which DataItems may be annotated with.

  Fields:
    createTime: Output only. Timestamp when this AnnotationSpec was created.
    displayName: Required. The user-defined name of the AnnotationSpec. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    name: Output only. Resource name of the AnnotationSpec.
    updateTime: Output only. Timestamp when AnnotationSpec was last updated.
  """

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleCloudAiplatformV1beta1Attribution(_messages.Message):
  r"""Attribution that explains a particular prediction output.

  Fields:
    approximationError: Output only. Error of feature_attributions caused by
      approximation used in the explanation method. Lower value means more
      precise attributions. For Sampled Shapley attribution, increasing
      path_count might reduce the error.
    baselineOutputValue: Output only. Model predicted output if the input
      instance is constructed from the baselines of all the features defined
      in ExplanationMetadata.inputs. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model
      predicted output is a tensor value (for example, an ndarray), this is
      the value in the output located by output_index. If there are multiple
      baselines, their output values are averaged.
    featureAttributions: Output only. Attributions of each explained feature.
      Features are extracted from the prediction instances according to
      explanation input metadata. The value is a struct, whose keys are the
      name of the feature. The values are how much the feature in the instance
      contributed to the predicted result. The format of the value is
      determined by the feature's input format: * If the feature is a scalar
      value, the attribution value is a floating number. * If the feature is
      an array of scalar values, the attribution value is an array. * If the
      feature is a struct, the attribution value is a struct. The keys in the
      attribution value struct are the same as the keys in the feature struct.
      The formats of the values in the attribution struct are determined by
      the formats of the values in the feature struct. The
      ExplanationMetadata.feature_attributions_schema_uri field, pointed to by
      the ExplanationSpec field of the Endpoint.deployed_models object, points
      to the schema file that describes the features and their attribution
      values (if it is populated).
    instanceOutputValue: Output only. Model predicted output on the
      corresponding explanation instance. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model
      predicted output is a tensor value (for example, an ndarray), this is
      the value in the output located by output_index.
    outputDisplayName: Output only. The display name of the output identified
      by output_index, e.g. the predicted class name by a multi-classification
      Model. This field is only populated iff the Model predicts display names
      as a separate field along with the explained output. The predicted
      display name must has the same shape of the explained output, and can be
      located using output_index.
    outputIndex: Output only. The index that locates the explained prediction
      output. If the prediction output is a scalar value, output_index is not
      populated. If the prediction output is a tensor value (for example, an
      ndarray), the length of output_index is the same as the number of
      dimensions of the output. The i-th element in output_index is the
      element index of the i-th dimension of the output vector. Indexes start
      from 0.
  """

  approximationError = _messages.FloatField(1)
  baselineOutputValue = _messages.FloatField(2)
  featureAttributions = _messages.MessageField('extra_types.JsonValue', 3)
  instanceOutputValue = _messages.FloatField(4)
  outputDisplayName = _messages.StringField(5)
  outputIndex = _messages.IntegerField(6, repeated=True, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1AutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by AI
  Platform, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      a no upper bound for scaling under heavy traffic will be assume, though
      AI Platform may be unable to scale beyond certain replica number.
    minReplicaCount: Immutable. The minimum number of replicas this
      DeployedModel will be always deployed on. If traffic against it
      increases, it may dynamically be deployed onto more replicas up to
      max_replica_count, and as traffic decreases, some of these extra
      replicas may be freed. If requested value is too large, the deployment
      will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1BatchDedicatedResources(_messages.Message):
  r"""A description of resources that are used for performing batch
  operations, are dedicated to a Model, and need manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine.
    maxReplicaCount: Immutable. The maximum number of machine replicas the
      batch operation may be scaled to. The default value is 10.
    startingReplicaCount: Immutable. The number of machine replicas used at
      the start of the batch operation. If not set, AI Platform decides
      starting number, not greater than max_replica_count
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1MachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startingReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest(_messages.Message):
  r"""Request message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceRequests: Required. The request messages specifying the
      resources to migrate. They must be in the same location as the
      destination. Up to 50 resources can be migrated in one batch.
  """

  migrateResourceRequests = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequest', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchPredictionJob(_messages.Message):
  r"""A job that uses a Model to produce predictions on multiple input
  instances. If predictions for significant portion of the instances fail, the
  job may finish without attempting predictions for all remaining instances.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    completionStats: Output only. Statistics on completed and failed
      prediction instances.
    createTime: Output only. Time when the BatchPredictionJob was created.
    dedicatedResources: The config of resources used by the Model during the
      batch prediction. If the Model supports DEDICATED_RESOURCES this config
      may be provided (and the job will use these resources), if the Model
      doesn't support AUTOMATIC_RESOURCES, this config must be provided.
    displayName: Required. The user-defined name of this BatchPredictionJob.
    endTime: Output only. Time when the BatchPredictionJob entered any of the
      following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when the job's state is
      JOB_STATE_FAILED or JOB_STATE_CANCELLED.
    generateExplanation: Generate explanation along with the batch prediction
      results. This can only be set to true for AutoML tabular Models, and
      only when the output destination is BigQuery. When it's true, the batch
      prediction output will include a column named `feature_attributions`.
      For AutoML tabular Models, the value of the `feature_attributions`
      column is a struct that maps from string to number. The keys in the map
      are the names of the features. The values in the map are the how much
      the features contribute to the predicted result. Features are defined as
      follows: * A scalar column defines a feature of the same name as the
      column. * A struct column defines multiple features, one feature per
      leaf field. The feature name is the fully qualified path for the leaf
      field, separated by ".". For example a column `key1` in the format of
      {"value1": {"prop1": number}, "value2": number} defines two features:
      `key1.value1.prop1` and `key1.value2` Attributions of each feature is
      represented as an extra column in the batch prediction output BigQuery
      table.
    inputConfig: Required. Input configuration of the instances on which
      predictions are performed. The schema of any single instance may be
      specified via the Model's PredictSchemata's instance_schema_uri.
    labels: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    manualBatchTuningParameters: Immutable. Parameters configuring the batch
      behavior. Currently only applicable when dedicated_resources are used
      (in other cases AI Platform does the tuning itself).
    model: Required. The name of the Model that produces the predictions via
      this job, must share the same ancestor Location. Starting this job has
      no impact on any existing deployments of the Model and their resources.
    modelParameters: The parameters that govern the predictions. The schema of
      the parameters may be specified via the Model's PredictSchemata's
      parameters_schema_uri.
    name: Output only. Resource name of the BatchPredictionJob.
    outputConfig: Required. The Configuration specifying where output
      predictions should be written. The schema of any single prediction may
      be specified as a concatenation of Model's PredictSchemata's
      instance_schema_uri and prediction_schema_uri.
    outputInfo: Output only. Information further describing the output of this
      job.
    partialFailures: Output only. Partial failures encountered. For example,
      single files that can't be read. This field never exceeds 20 entries.
      Status details fields contain standard GCP error details.
    resourcesConsumed: Output only. Information about resources that had been
      consumed by this job. Provided in real time at best effort basis, as
      well as a final value once the job completes. Note: This field currently
      may be not populated for batch predictions that use AutoML Models.
    startTime: Output only. Time when the BatchPredictionJob for the first
      time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Time when the BatchPredictionJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize BatchPredictionJobs.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  completionStats = _messages.MessageField('GoogleCloudAiplatformV1beta1CompletionStats', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchDedicatedResources', 3)
  displayName = _messages.StringField(4)
  endTime = _messages.StringField(5)
  error = _messages.MessageField('GoogleRpcStatus', 6)
  generateExplanation = _messages.BooleanField(7)
  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig', 8)
  labels = _messages.MessageField('LabelsValue', 9)
  manualBatchTuningParameters = _messages.MessageField('GoogleCloudAiplatformV1beta1ManualBatchTuningParameters', 10)
  model = _messages.StringField(11)
  modelParameters = _messages.MessageField('extra_types.JsonValue', 12)
  name = _messages.StringField(13)
  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig', 14)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo', 15)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 16, repeated=True)
  resourcesConsumed = _messages.MessageField('GoogleCloudAiplatformV1beta1ResourcesConsumed', 17)
  startTime = _messages.StringField(18)
  state = _messages.EnumField('StateValueValuesEnum', 19)
  updateTime = _messages.StringField(20)


class GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig(_messages.Message):
  r"""Configures the input to BatchPredictionJob. See
  Model.supported_input_storage_formats for Model's supported input formats,
  and how instances should be expressed via any of them.

  Fields:
    bigquerySource: The BigQuery location of the input table. The schema of
      the table should be in the format described by the given context OpenAPI
      Schema, if one is provided. The table may contain additional columns
      that are not described by the schema, and they will be ignored.
    gcsSource: The Google Cloud Storage location for the input instances.
    instancesFormat: Required. The format in which instances are given, must
      be one of the Model's supported_input_storage_formats.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 2)
  instancesFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig(_messages.Message):
  r"""Configures the output of BatchPredictionJob. See
  Model.supported_output_storage_formats for supported output formats, and how
  predictions are expressed via any of them.

  Fields:
    bigqueryDestination: The BigQuery project location where the output is to
      be written to. In the given project a new dataset is created with name
      `prediction__` where is made BigQuery-dataset-name compatible (for
      example, most special characters become underscores), and timestamp is
      in YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
      two tables will be created, `predictions`, and `errors`. If the Model
      has both instance and prediction schemata defined then the tables have
      columns as follows: The `predictions` table contains instances for which
      the prediction succeeded, it has columns as per a concatenation of the
      Model's instance and prediction schemata. The `errors` table contains
      rows for which the prediction has failed, it has instance columns, as
      per the instance schema, followed by a single "errors" column, which as
      values has [`google.rpc.Status`](Status) represented as a STRUCT, and
      containing only `code` and `message`.
    gcsDestination: The Google Cloud Storage location of the directory where
      the output is to be written to. In the given directory a new directory
      is created. Its name is `prediction--`, where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format. Inside of it files
      `predictions_0001.`, `predictions_0002.`, ..., `predictions_N.` are
      created where `` depends on chosen predictions_format, and N may equal
      0001 and depends on the total number of successfully predicted
      instances. If the Model has both instance and prediction schemata
      defined then each such file contains predictions as per the
      predictions_format. If prediction for any instance failed (partially or
      completely), then an additional `errors_0001.`, `errors_0002.`,...,
      `errors_N.` files are created (N depends on total number of failed
      predictions). These files contain the failed instances, as per their
      schema, followed by an additional `error` field which as value has
      [`google.rpc.Status`](Status) containing only `code` and `message`
      fields.
    predictionsFormat: Required. The format in which AI Platform gives the
      predictions, must be one of the Model's
      supported_output_storage_formats.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 2)
  predictionsFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo(_messages.Message):
  r"""Further describes this job's output. Supplements output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in `bq://projectId.bqDatasetId` format, into which the
      prediction output is written.
    gcsOutputDirectory: Output only. The full path of the Google Cloud Storage
      directory created, into which the prediction output is written.
  """

  bigqueryOutputDataset = _messages.StringField(1)
  gcsOutputDirectory = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1BigQueryDestination(_messages.Message):
  r"""The BigQuery location for the output content.

  Fields:
    outputUri: Required. BigQuery URI to a project, up to 2000 characters
      long. Accepted forms: * BigQuery path. For example: `bq://projectId`.
  """

  outputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1BigQuerySource(_messages.Message):
  r"""The BigQuery location for the input content.

  Fields:
    inputUri: Required. BigQuery URI to a table, up to 2000 characters long.
      Accepted forms: * BigQuery path. For example:
      `bq://projectId.bqDatasetId.bqTableId`.
  """

  inputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest(_messages.Message):
  r"""Request message for JobService.CancelBatchPredictionJob."""


class GoogleCloudAiplatformV1beta1CancelCustomJobRequest(_messages.Message):
  r"""Request message for JobService.CancelCustomJob."""


class GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest(_messages.Message):
  r"""Request message for JobService.CancelHyperparameterTuningJob."""


class GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest(_messages.Message):
  r"""Request message for PipelineService.CancelTrainingPipeline."""


class GoogleCloudAiplatformV1beta1CompletionStats(_messages.Message):
  r"""Success and error statistics of processing multiple entities (for
  example, DataItems or structured data rows) in batch.

  Fields:
    failedCount: Output only. The number of entities for which any error was
      encountered.
    incompleteCount: Output only. In cases when enough errors are encountered
      a job, pipeline, or operation may be failed as a whole. Below is the
      number of entities for which the processing had not been finished
      (either in successful or failed state). Set to -1 if the number is
      unknown (for example, the operation failed before the total entity
      number could be collected).
    successfulCount: Output only. The number of entities that had been
      processed successfully.
  """

  failedCount = _messages.IntegerField(1)
  incompleteCount = _messages.IntegerField(2)
  successfulCount = _messages.IntegerField(3)


class GoogleCloudAiplatformV1beta1ContainerRegistryDestination(_messages.Message):
  r"""The Container Regsitry location for the container image.

  Fields:
    outputUri: Required. Container Registry URI of a container image. Only
      Google Container Registry and Artifact Registry are supported now.
      Accepted forms: * Google Container Registry path. For example:
      `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For example:
      `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a tag
      is not specified, "latest" will be used as the default tag.
  """

  outputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1ContainerSpec(_messages.Message):
  r"""The spec of a Container.

  Fields:
    args: The arguments to be passed when starting the container.
    command: The command to be invoked when the container is started. It
      overrides the entrypoint instruction in Dockerfile when provided.
    imageUri: Required. The URI of a container image in the Container Registry
      that is to be run on each worker replica.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  imageUri = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CustomJob(_messages.Message):
  r"""Represents a job that runs custom workloads such as a Docker container
  or a Python package. A CustomJob can have multiple worker pools and each
  worker pool can have its own machine and input spec. A CustomJob will be
  cleaned up once the job enters terminal state (failed or succeeded).

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.

  Fields:
    createTime: Output only. Time when the CustomJob was created.
    displayName: Required. The display name of the CustomJob. The name can be
      up to 128 characters long and can be consist of any UTF-8 characters.
    endTime: Output only. Time when the CustomJob entered any of the following
      states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is `JOB_STATE_FAILED`
      or `JOB_STATE_CANCELLED`.
    jobSpec: Required. Job spec.
    labels: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    name: Output only. Resource name of a CustomJob.
    startTime: Output only. Time when the CustomJob for the first time entered
      the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Time when the CustomJob was most recently
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize CustomJobs. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  endTime = _messages.StringField(3)
  error = _messages.MessageField('GoogleRpcStatus', 4)
  jobSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJobSpec', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  startTime = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class GoogleCloudAiplatformV1beta1CustomJobSpec(_messages.Message):
  r"""Represents the spec of a CustomJob.

  Fields:
    baseOutputDirectory: The Google Cloud Storage location to store the output
      of this CustomJob or HyperparameterTuningJob. For
      HyperparameterTuningJob, base_output_directory of each child CustomJob
      backing a Trial is set to a subdirectory of name id under parent
      HyperparameterTuningJob's base_output_directory. Following AI Platform
      environment variables will be passed to containers or python modules
      when this field is set: For CustomJob: * AIP_MODEL_DIR = `/model/` *
      AIP_CHECKPOINT_DIR = `/checkpoints/` * AIP_TENSORBOARD_LOG_DIR =
      `/logs/` For CustomJob backing a Trial of HyperparameterTuningJob: *
      AIP_MODEL_DIR = `//model/` * AIP_CHECKPOINT_DIR = `//checkpoints/` *
      AIP_TENSORBOARD_LOG_DIR = `//logs/`
    scheduling: Scheduling options for a CustomJob.
    workerPoolSpecs: Required. The spec of the worker pools including machine
      type and Docker image.
  """

  baseOutputDirectory = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 1)
  scheduling = _messages.MessageField('GoogleCloudAiplatformV1beta1Scheduling', 2)
  workerPoolSpecs = _messages.MessageField('GoogleCloudAiplatformV1beta1WorkerPoolSpec', 3, repeated=True)


class GoogleCloudAiplatformV1beta1DataItem(_messages.Message):
  r"""A piece of data in a Dataset. Could be an image, a video, a document or
  plain text.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your DataItems. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this DataItem was created.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      DataItems. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Output only. The resource name of the DataItem.
    payload: Required. The data that the DataItem represents (for example, an
      image or a text snippet). The schema of the payload is stored in the
      parent Dataset's metadata schema's dataItemSchemaUri field.
    updateTime: Output only. Timestamp when this DataItem was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    DataItems. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one DataItem(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  payload = _messages.MessageField('extra_types.JsonValue', 5)
  updateTime = _messages.StringField(6)


class GoogleCloudAiplatformV1beta1Dataset(_messages.Message):
  r"""A collection of DataItems and Annotations on them.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Datasets. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Dataset
      (System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.

  Fields:
    createTime: Output only. Timestamp when this Dataset was created.
    displayName: Required. The user-defined name of the Dataset. The name can
      be up to 128 characters long and can be consist of any UTF-8 characters.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Datasets.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Dataset (System labels
      are excluded). See https://goo.gl/xmQnxf for more information and
      examples of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.
    metadata: Required. Additional information about the Dataset.
    metadataSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Dataset. The schema
      is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can
      be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/metadata/.
    name: Output only. The resource name of the Dataset.
    updateTime: Output only. Timestamp when this Dataset was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Datasets. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Dataset (System labels are excluded). See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable. Following system labels exist for each Dataset: *
    "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
    value is the metadata_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  metadata = _messages.MessageField('extra_types.JsonValue', 5)
  metadataSchemaUri = _messages.StringField(6)
  name = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1beta1DedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel, and
  that need a higher degree of manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine
      used by the prediction.
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      will use min_replica_count as the default value.
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas this DeployedModel will be always deployed on. If traffic
      against it increases, it may dynamically be deployed onto more replicas,
      and as traffic decreases, some of these extra replicas may be freed.
      Note: if machine_spec.accelerator_count is above 0, currently the model
      will be always deployed precisely on min_replica_count.
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1MachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1DeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeployModelRequest(_messages.Message):
  r"""Request message for EndpointService.DeployModel.

  Messages:
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.

  Fields:
    deployedModel: Required. The DeployedModel to be created within the
      Endpoint. Note that Endpoint.traffic_split must be updated for the
      DeployedModel to start receiving traffic, either as part of this call,
      or via EndpointService.UpdateEndpoint.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If
      this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If this field is
    non-empty, then the Endpoint's traffic_split will be overwritten with it.
    To refer to the ID of the just being deployed Model, a "0" should be used,
    and the actual ID of the new DeployedModel will be filled in its place by
    this method. The traffic percentage values must add up to 100. If this
    field is empty, then the Endpoint's traffic_split is not updated.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModel', 1)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 2)


class GoogleCloudAiplatformV1beta1DeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModel', 1)


class GoogleCloudAiplatformV1beta1DeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by AI Platform, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    enableAccessLogging: These logs are like standard server access logs,
      containing information like timestamp and latency for each prediction
      request. Note that Stackdriver logs may incur a cost, especially if your
      project receives prediction requests at a high queries per second rate
      (QPS). Estimate your costs before enabling this option.
    enableContainerLogging: If true, the container of the DeployedModel
      instances will send `stderr` and `stdout` streams to Stackdriver
      Logging. Only supported for custom-trained Models and AutoML Tables
      Models.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. The corresponding
      Model.explanation_spec must be populated, otherwise explanation for this
      Model is not allowed. Currently, only AutoML tabular Models support
      explanation_spec.
    id: Output only. The ID of the DeployedModel.
    model: Required. The name of the Model this is the deployment of. Note
      that the Model may be in a different location than the DeployedModel's
      Endpoint.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1beta1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1DedicatedResources', 3)
  displayName = _messages.StringField(4)
  enableAccessLogging = _messages.BooleanField(5)
  enableContainerLogging = _messages.BooleanField(6)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationSpec', 7)
  id = _messages.StringField(8)
  model = _messages.StringField(9)


class GoogleCloudAiplatformV1beta1DeployedModelRef(_messages.Message):
  r"""Points to a DeployedModel.

  Fields:
    deployedModelId: Immutable. An ID of a DeployedModel in the above
      Endpoint.
    endpoint: Immutable. A resource name of an Endpoint.
  """

  deployedModelId = _messages.StringField(1)
  endpoint = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1Endpoint(_messages.Message):
  r"""Models are deployed into it, and afterwards Endpoint is called to obtain
  predictions and explanations.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Endpoints. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If a DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.

  Fields:
    createTime: Output only. Timestamp when this Endpoint was created.
    deployedModels: Output only. The models deployed in this Endpoint. To add
      or remove DeployedModels use EndpointService.DeployModel and
      EndpointService.UndeployModel respectively.
    description: The description of the Endpoint.
    displayName: Required. The display name of the Endpoint. The name can be
      up to 128 characters long and can be consist of any UTF-8 characters.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Endpoints.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    name: Output only. The resource name of the Endpoint.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If a
      DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.
    updateTime: Output only. Timestamp when this Endpoint was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Endpoints.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If a
    DeployedModel's ID is not listed in this map, then it receives no traffic.
    The traffic percentage values must add up to 100, or map must be empty if
    the Endpoint is to not accept any traffic at a moment.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deployedModels = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModel', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 8)
  updateTime = _messages.StringField(9)


class GoogleCloudAiplatformV1beta1EnvVar(_messages.Message):
  r"""Represents an environment variable present in a Container or Python
  Module.

  Fields:
    name: Required. Name of the environment variable. Must be a valid C
      identifier.
    value: Variables that reference a $(VAR_NAME) are expanded using the
      previous defined environment variables in the container and any service
      environment variables. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExplainRequest(_messages.Message):
  r"""Request message for PredictionService.Explain.

  Fields:
    deployedModelId: If specified, this ExplainRequest will be served by the
      chosen DeployedModel, overriding Endpoint.traffic_split.
    instances: Required. The instances that are the input to the explanation
      call. A DeployedModel may have an upper limit on the number of instances
      it supports per request, and when it is exceeded the explanation call
      errors in case of AutoML Models, or, in case of customer created Models,
      the behaviour is as documented by that Model. The schema of any single
      instance may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's instance_schema_uri.
    parameters: The parameters that govern the prediction. The schema of the
      parameters may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's parameters_schema_uri.
  """

  deployedModelId = _messages.StringField(1)
  instances = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  parameters = _messages.MessageField('extra_types.JsonValue', 3)


class GoogleCloudAiplatformV1beta1ExplainResponse(_messages.Message):
  r"""Response message for PredictionService.Explain.

  Fields:
    deployedModelId: ID of the Endpoint's DeployedModel that served this
      explanation.
    explanations: The explanations of the Model's PredictResponse.predictions.
      It has the same number of elements as instances to be explained.
  """

  deployedModelId = _messages.StringField(1)
  explanations = _messages.MessageField('GoogleCloudAiplatformV1beta1Explanation', 2, repeated=True)


class GoogleCloudAiplatformV1beta1Explanation(_messages.Message):
  r"""Explanation of a prediction (provided in PredictResponse.predictions )
  produced by the Model on a given instance. Currently, only AutoML tabular
  Models support explanation.

  Fields:
    attributions: Output only. Feature attributions grouped by predicted
      outputs. For Models that predict only one output, such as regression
      Models that predict only one score, there is only one attibution that
      explains the predicted output. For Models that predict multiple outputs,
      such as multiclass Models that predict multiple classes, each element
      explains one specific item. Attribution.output_index can be used to
      identify which output this attribution is explaining.
  """

  attributions = _messages.MessageField('GoogleCloudAiplatformV1beta1Attribution', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform.
    OutputsValue: Required. Map from output names to output metadata. Keys are
      the name of the output field in the prediction to be explained.
      Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML tabular
      Models always have this field populated by AI Platform. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform.
    outputs: Required. Map from output names to output metadata. Keys are the
      name of the output field in the prediction to be explained. Currently
      only one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by AI Platform.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. Keys are the name
    of the output field in the prediction to be explained. Currently only one
    key is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  outputs = _messages.MessageField('OutputsValue', 3)


class GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature.

  Fields:
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, AI Platform chooses the baseline for this feature. If
      multiple baselines are specified, AI Platform returns the average
      attributions across them in Attributions.baseline_attribution. The
      element of the baselines must be in the same format as the feature's
      input in the instance[]. The schema of any single instance may be
      specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
  """

  inputBaselines = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimentions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1beta1ExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features.
  """

  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformV1beta1SampledShapleyAttribution', 1)


class GoogleCloudAiplatformV1beta1ExplanationSpec(_messages.Message):
  r"""Specification of Model explanation. Currently, only AutoML tabular
  Models support explanation.

  Fields:
    metadata: Required. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationParameters', 2)


class GoogleCloudAiplatformV1beta1ExportDataConfig(_messages.Message):
  r"""Describes what part of the Dataset is to be exported, the destination of
  the export and how to export.

  Fields:
    annotationsFilter: A filter on Annotations of the Dataset. Only
      Annotations on to-be-exported DataItems(specified by data_items_filter)
      that match this filter will be exported. The filter syntax is the same
      as in ListAnnotations.
    gcsDestination: The Google Cloud Storage location where the output is to
      be written to. In the given directory a new directory will be created
      with name: `export-data--` where timestamp is in YYYYMMDDHHMMSS format.
      All export output will be written into that directory. Inside that
      directory, annotations with the same schema will be grouped into sub
      directories which are named with the corresponding annotations' schema
      title. Inside these sub directories, a schema.yaml will be created to
      describe the output format.
  """

  annotationsFilter = _messages.StringField(1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 2)


class GoogleCloudAiplatformV1beta1ExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1beta1ExportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ExportData.

  Fields:
    exportConfig: Required. The desired output location.
  """

  exportConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportDataConfig', 1)


class GoogleCloudAiplatformV1beta1ExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation.
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1ExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    artifactOutputUri: Output only. If the Model artifact is being exported to
      Google Cloud Storage this is the full path of the directory created,
      into which the Model files are being written to.
    imageOutputUri: Output only. If the Model image is being exported to
      Google Container Registry or Artifact Registry this is the full path of
      the image created.
  """

  artifactOutputUri = _messages.StringField(1)
  imageOutputUri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExportModelRequest(_messages.Message):
  r"""Request message for ModelService.ExportModel.

  Fields:
    outputConfig: Required. The desired output location and configuration.
  """

  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig', 1)


class GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig(_messages.Message):
  r"""Output configuration for the Model export.

  Fields:
    artifactDestination: The Google Cloud Storage location where the Model
      artifact is to be written to. Under the directory given as the
      destination a new one with name "`model-export--`", where timestamp is
      in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format, will be created. Inside,
      the Model and any of its supporting files will be written. This field
      should only be set when
      [Models.supported_export_formats.exportable_contents] contains ARTIFACT.
    exportFormatId: The ID of the format in which the Model must be exported.
      Each Model lists the export formats it supports. If no value is provided
      here, then the first from the list of the Model's supported formats is
      used by default.
    imageDestination: The Google Container Registry or Artifact Registry uri
      where the Model container image will be copied to. This field should
      only be set when [Models.supported_export_formats.exportable_contents]
      contains IMAGE.
  """

  artifactDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 1)
  exportFormatId = _messages.StringField(2)
  imageDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1ContainerRegistryDestination', 3)


class GoogleCloudAiplatformV1beta1ExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformV1beta1FilterSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on the
  given filters, data pieces not matched by any filter are ignored. Currently
  only supported for Datasets containing DataItems. If any of the filters in
  this message are to match nothing, then they can be set as '-' (the minus
  sign).

  Fields:
    testFilter: Required. A filter on DataItems of the Dataset. DataItems that
      match this filter are used to test the Model. A filter with same syntax
      as the one used in DatasetService.ListDataItems may be used. If a single
      DataItem is matched by more than one of the FilterSplit filters, then it
      will be assigned to the first set that applies to it in the training,
      validation, test order.
    trainingFilter: Required. A filter on DataItems of the Dataset. DataItems
      that match this filter are used to train the Model. A filter with same
      syntax as the one used in DatasetService.ListDataItems may be used. If a
      single DataItem is matched by more than one of the FilterSplit filters,
      then it will be assigned to the first set that applies to it in the
      training, validation, test order.
    validationFilter: Required. A filter on DataItems of the Dataset.
      DataItems that match this filter are used to validate the Model. A
      filter with same syntax as the one used in DatasetService.ListDataItems
      may be used. If a single DataItem is matched by more than one of the
      FilterSplit filters, then it will be assigned to the first set that
      applies to it in the training, validation, test order.
  """

  testFilter = _messages.StringField(1)
  trainingFilter = _messages.StringField(2)
  validationFilter = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1FractionSplit(_messages.Message):
  r"""Assigns the input data to training, validation, and test sets as per the
  given fractions. Any of `training_fraction`, `validation_fraction` and
  `test_fraction` may optionally be provided, they must sum to up to 1. If the
  provided ones sum to less than 1, the remainder is assigned to sets as
  decided by AI Platform. If none of the fractions are set, by default roughly
  80% of data will be used for training, 10% for validation, and 10% for test.

  Fields:
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  testFraction = _messages.FloatField(1)
  trainingFraction = _messages.FloatField(2)
  validationFraction = _messages.FloatField(3)


class GoogleCloudAiplatformV1beta1GcsDestination(_messages.Message):
  r"""The Google Cloud Storage location where the output is to be written to.

  Fields:
    outputUriPrefix: Required. Google Cloud Storage URI to output directory.
      If the uri doesn't end with '/', a '/' will be automatically appended.
      The directory is created if it doesn't exist.
  """

  outputUriPrefix = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1GcsSource(_messages.Message):
  r"""The Google Cloud Storage location for the input content.

  Fields:
    uris: Required. Google Cloud Storage URI(-s) to the input file(s). May
      contain wildcards. For more information on wildcards, see
      https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
  """

  uris = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1GenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Fields:
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard GCP error details.
    updateTime: Output only. Time when the operation was updated for the last
      time.
  """

  createTime = _messages.StringField(1)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1HyperparameterTuningJob(_messages.Message):
  r"""Represents a HyperparameterTuningJob. A HyperparameterTuningJob has a
  Study specification and multiple CustomJobs with identical CustomJob
  specification.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Time when the HyperparameterTuningJob was
      created.
    displayName: Required. The display name of the HyperparameterTuningJob.
      The name can be up to 128 characters long and can be consist of any
      UTF-8 characters.
    endTime: Output only. Time when the HyperparameterTuningJob entered any of
      the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is JOB_STATE_FAILED or
      JOB_STATE_CANCELLED.
    labels: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    maxFailedTrialCount: The number of failed Trials that need to be seen
      before failing the HyperparameterTuningJob. If set to 0, AI Platform
      decides how many Trials must fail before the whole job fails.
    maxTrialCount: Required. The desired total number of Trials.
    name: Output only. Resource name of the HyperparameterTuningJob.
    parallelTrialCount: Required. The desired number of Trials to run in
      parallel.
    startTime: Output only. Time when the HyperparameterTuningJob for the
      first time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    studySpec: Required. Study configuration of the HyperparameterTuningJob.
    trialJobSpec: Required. The spec of a trial job. The same spec applies to
      the CustomJobs created in all the trials.
    trials: Output only. Trials of the HyperparameterTuningJob.
    updateTime: Output only. Time when the HyperparameterTuningJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize
    HyperparameterTuningJobs. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  endTime = _messages.StringField(3)
  error = _messages.MessageField('GoogleRpcStatus', 4)
  labels = _messages.MessageField('LabelsValue', 5)
  maxFailedTrialCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  maxTrialCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  name = _messages.StringField(8)
  parallelTrialCount = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  studySpec = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpec', 12)
  trialJobSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJobSpec', 13)
  trials = _messages.MessageField('GoogleCloudAiplatformV1beta1Trial', 14, repeated=True)
  updateTime = _messages.StringField(15)


class GoogleCloudAiplatformV1beta1ImportDataConfig(_messages.Message):
  r"""Describes the location from where we import data into a Dataset,
  together with the labels that will be applied to the DataItems and the
  Annotations.

  Messages:
    DataItemLabelsValue: Labels that will be applied to newly imported
      DataItems. If an identical DataItem as one being imported already exists
      in the Dataset, then these labels will be appended to these of the
      already existing one, and if labels with identical key is imported
      before, the old label value will be overwritten. If two DataItems are
      identical in the same import data operation, the labels will be combined
      and if key collision happens in this case, one of the values will be
      picked randomly. Two DataItems are considered identical if their content
      bytes are identical (e.g. image bytes or pdf bytes). These labels will
      be overridden by Annotation labels specified inside index file refenced
      by import_schema_uri, e.g. jsonl file.

  Fields:
    dataItemLabels: Labels that will be applied to newly imported DataItems.
      If an identical DataItem as one being imported already exists in the
      Dataset, then these labels will be appended to these of the already
      existing one, and if labels with identical key is imported before, the
      old label value will be overwritten. If two DataItems are identical in
      the same import data operation, the labels will be combined and if key
      collision happens in this case, one of the values will be picked
      randomly. Two DataItems are considered identical if their content bytes
      are identical (e.g. image bytes or pdf bytes). These labels will be
      overridden by Annotation labels specified inside index file refenced by
      import_schema_uri, e.g. jsonl file.
    gcsSource: The Google Cloud Storage location for the input content.
    importSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing the import format. Validation will be done against
      the schema. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://tinyurl.com/y538mdwt).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataItemLabelsValue(_messages.Message):
    r"""Labels that will be applied to newly imported DataItems. If an
    identical DataItem as one being imported already exists in the Dataset,
    then these labels will be appended to these of the already existing one,
    and if labels with identical key is imported before, the old label value
    will be overwritten. If two DataItems are identical in the same import
    data operation, the labels will be combined and if key collision happens
    in this case, one of the values will be picked randomly. Two DataItems are
    considered identical if their content bytes are identical (e.g. image
    bytes or pdf bytes). These labels will be overridden by Annotation labels
    specified inside index file refenced by import_schema_uri, e.g. jsonl
    file.

    Messages:
      AdditionalProperty: An additional property for a DataItemLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DataItemLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataItemLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataItemLabels = _messages.MessageField('DataItemLabelsValue', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 2)
  importSchemaUri = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1ImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1ImportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ImportData.

  Fields:
    importConfigs: Required. The desired input locations. The contents of all
      input locations will be imported in one batch.
  """

  importConfigs = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportDataConfig', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformV1beta1InputDataConfig(_messages.Message):
  r"""Specifies AI Platform owned input data to be used for training, and
  possibly evaluating, the Model.

  Fields:
    annotationSchemaUri: Only applicable to custom training. Google Cloud
      Storage URI points to a YAML file describing annotation schema. The
      schema is defined as an OpenAPI 3.0.2 [Schema Object]( https:
      //github.com/OAI/OpenAPI-Specification/b //
      lob/master/versions/3.0.2.md#schema-object) The schema files that can be
      used here are found in gs://google-cloud-
      aiplatform/schema/dataset/annotation/, note that the chosen schema must
      be consistent with metadata of the Dataset specified by dataset_id. Only
      Annotations that both match this schema and belong to DataItems not
      ignored by the split method are used in respectively training,
      validation or test role, depending on the role of the DataItem they are
      on. When used in conjunction with annotations_filter, the Annotations
      used for training are filtered by both annotations_filter and
      annotation_schema_uri.
    annotationsFilter: Only applicable to Datasets that have DataItems and
      Annotations. A filter on Annotations of the Dataset. Only Annotations
      that both match this filter and belong to DataItems not ignored by the
      split method are used in respectively training, validation or test role,
      depending on the role of the DataItem they are on (for the auto-assigned
      that role is decided by AI Platform). A filter with same syntax as the
      one used in ListAnnotations may be used, but note here it filters across
      all Annotations of the Dataset, and not just within a single DataItem.
    datasetId: Required. The ID of the Dataset in the same Project and
      Location which data will be used to train the Model. The Dataset must
      use schema compatible with Model being trained, and what is compatible
      should be described in the used TrainingPipeline's
      training_task_definition. For tabular Datasets, all their data is
      exported to training, to pick and choose from.
    filterSplit: Split based on the provided filters for each set.
    fractionSplit: Split based on fractions defining the size of each set.
    gcsDestination: The Google Cloud Storage location. The AI Platform
      environment variables representing Google Cloud Storage data URIs will
      always be represented in the Google Cloud Storage wildcard format to
      support sharded data. e.g.: "gs://.../training-* * AIP_DATA_FORMAT =
      "jsonl". * AIP_TRAINING_DATA_URI = "gcs_destination/training-*" *
      AIP_VALIDATION_DATA_URI = "gcs_destination/validation-*" *
      AIP_TEST_DATA_URI = "gcs_destination/test-*"
    predefinedSplit: Supported only for tabular Datasets. Split based on a
      predefined key.
    timestampSplit: Supported only for tabular Datasets. Split based on the
      timestamp of the input data pieces.
  """

  annotationSchemaUri = _messages.StringField(1)
  annotationsFilter = _messages.StringField(2)
  datasetId = _messages.StringField(3)
  filterSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1FilterSplit', 4)
  fractionSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1FractionSplit', 5)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 6)
  predefinedSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1PredefinedSplit', 7)
  timestampSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1TimestampSplit', 8)


class GoogleCloudAiplatformV1beta1ListAnnotationsResponse(_messages.Message):
  r"""Response message for DatasetService.ListAnnotations.

  Fields:
    annotations: A list of Annotations that matches the specified filter in
      the request.
    nextPageToken: The standard List next-page token.
  """

  annotations = _messages.MessageField('GoogleCloudAiplatformV1beta1Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListBatchPredictionJobsResponse(_messages.Message):
  r"""Response message for JobService.ListBatchPredictionJobs

  Fields:
    batchPredictionJobs: List of BatchPredictionJobs in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListBatchPredictionJobsRequest.page_token to obtain that page.
  """

  batchPredictionJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListCustomJobsResponse(_messages.Message):
  r"""Response message for JobService.ListCustomJobs

  Fields:
    customJobs: List of CustomJobs in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListCustomJobsRequest.page_token to obtain that page.
  """

  customJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListDataItemsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDataItems.

  Fields:
    dataItems: A list of DataItems that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  dataItems = _messages.MessageField('GoogleCloudAiplatformV1beta1DataItem', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListDatasetsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDatasets.

  Fields:
    datasets: A list of Datasets that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  datasets = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListEndpointsResponse(_messages.Message):
  r"""Response message for EndpointService.ListEndpoints.

  Fields:
    endpoints: List of Endpoints in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListEndpointsRequest.page_token to obtain that page.
  """

  endpoints = _messages.MessageField('GoogleCloudAiplatformV1beta1Endpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListHyperparameterTuningJobsResponse(_messages.Message):
  r"""Response message for JobService.ListHyperparameterTuningJobs

  Fields:
    hyperparameterTuningJobs: List of HyperparameterTuningJobs in the
      requested page. HyperparameterTuningJob.trials of the jobs will be not
      be returned.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListHyperparameterTuningJobsRequest.page_token to obtain that page.
  """

  hyperparameterTuningJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1HyperparameterTuningJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListModelEvaluationSlicesResponse(_messages.Message):
  r"""Response message for ModelService.ListModelEvaluationSlices.

  Fields:
    modelEvaluationSlices: List of ModelEvaluations in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelEvaluationSlicesRequest.page_token to obtain that page.
  """

  modelEvaluationSlices = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelEvaluationSlice', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListModelEvaluationsResponse(_messages.Message):
  r"""Response message for ModelService.ListModelEvaluations.

  Fields:
    modelEvaluations: List of ModelEvaluations in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelEvaluationsRequest.page_token to obtain that page.
  """

  modelEvaluations = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelEvaluation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListModelsResponse(_messages.Message):
  r"""Response message for ModelService.ListModels

  Fields:
    models: List of Models in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelsRequest.page_token to obtain that page.
  """

  models = _messages.MessageField('GoogleCloudAiplatformV1beta1Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListSpecialistPoolsResponse(_messages.Message):
  r"""Response message for SpecialistPoolService.ListSpecialistPools.

  Fields:
    nextPageToken: The standard List next-page token.
    specialistPools: A list of SpecialistPools that matches the specified
      filter in the request.
  """

  nextPageToken = _messages.StringField(1)
  specialistPools = _messages.MessageField('GoogleCloudAiplatformV1beta1SpecialistPool', 2, repeated=True)


class GoogleCloudAiplatformV1beta1ListTrainingPipelinesResponse(_messages.Message):
  r"""Response message for PipelineService.ListTrainingPipelines

  Fields:
    nextPageToken: A token to retrieve next page of results. Pass to
      ListTrainingPipelinesRequest.page_token to obtain that page.
    trainingPipelines: List of TrainingPipelines in the requested page.
  """

  nextPageToken = _messages.StringField(1)
  trainingPipelines = _messages.MessageField('GoogleCloudAiplatformV1beta1TrainingPipeline', 2, repeated=True)


class GoogleCloudAiplatformV1beta1MachineSpec(_messages.Message):
  r"""Specification of a single machine.

  Enums:
    AcceleratorTypeValueValuesEnum: Immutable. The type of accelerator(s) that
      may be attached to the machine as per accelerator_count.

  Fields:
    acceleratorCount: The number of accelerators to attach to the machine.
    acceleratorType: Immutable. The type of accelerator(s) that may be
      attached to the machine as per accelerator_count.
    machineType: Immutable. The type of the machine. Following machine types
      are supported: * `n1-standard-2` * `n1-standard-4` * `n1-standard-8` *
      `n1-standard-16` * `n1-standard-32` * `n1-highmem-2` * `n1-highmem-4` *
      `n1-highmem-8` * `n1-highmem-16` * `n1-highmem-32` * `n1-highcpu-2` *
      `n1-highcpu-4` * `n1-highcpu-8` * `n1-highcpu-16` * `n1-highcpu-32` When
      used for DeployedMode this field is optional and the default value is
      `n1-standard-2`. If used for BatchPredictionJob or as part of
      WorkerPoolSpec this field is required.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of accelerator(s) that may be attached to the
    machine as per accelerator_count.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type, which means
        no accelerator.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 2)
  machineType = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1ManualBatchTuningParameters(_messages.Message):
  r"""Manual batch tuning parameters.

  Fields:
    batchSize: Immutable. The number of the records (e.g. instances) of the
      operation given in each batch to a machine replica. Machine type, and
      size of a single record should be considered when setting this
      parameter, higher value speeds up the batch operation's execution, but
      too high value will result in a whole batch not fitting in a machine's
      memory, and the whole operation will fail. The default value is 4.
  """

  batchSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1Measurement(_messages.Message):
  r"""A message representing a Measurement of a Trial. A Measurement contains
  the Metrics got by executing a Trial using suggested hyperparameter values.

  Fields:
    metrics: Output only. A list of metrics got by evaluating the objective
      functions using suggested Parameter values.
    stepCount: Output only. The number of steps the machine learning model has
      been trained for. Must be non-negative.
  """

  metrics = _messages.MessageField('GoogleCloudAiplatformV1beta1MeasurementMetric', 1, repeated=True)
  stepCount = _messages.IntegerField(2)


class GoogleCloudAiplatformV1beta1MeasurementMetric(_messages.Message):
  r"""A message representing a metric in the measurement.

  Fields:
    metricId: Output only. The ID of the Metric. The Metric should be defined
      in StudySpec's Metrics.
    value: Output only. The value for this metric.
  """

  metricId = _messages.StringField(1)
  value = _messages.FloatField(2)


class GoogleCloudAiplatformV1beta1MigratableResource(_messages.Message):
  r"""Represents one resource that exists in automl.googleapis.com,
  datalabeling.googleapis.com or ml.googleapis.com.

  Fields:
    automlDataset: Output only. Represents one Dataset in
      automl.googleapis.com.
    automlModel: Output only. Represents one Model in automl.googleapis.com.
    dataLabelingDataset: Output only. Represents one Dataset in
      datalabeling.googleapis.com.
    lastMigrateTime: Output only. Timestamp when last migrate attempt on this
      MigratableResource started. Will not be set if there's no migrate
      attempt on this MigratableResource.
    lastUpdateTime: Output only. Timestamp when this MigratableResource was
      last updated.
    mlEngineModelVersion: Output only. Represents one Version in
      ml.googleapis.com.
  """

  automlDataset = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceAutomlDataset', 1)
  automlModel = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceAutomlModel', 2)
  dataLabelingDataset = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDataset', 3)
  lastMigrateTime = _messages.StringField(4)
  lastUpdateTime = _messages.StringField(5)
  mlEngineModelVersion = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceMlEngineModelVersion', 6)


class GoogleCloudAiplatformV1beta1MigratableResourceAutomlDataset(_messages.Message):
  r"""Represents one Dataset in automl.googleapis.com.

  Fields:
    dataset: Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in automl.googleapis.com.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigratableResourceAutomlModel(_messages.Message):
  r"""Represents one Model in automl.googleapis.com.

  Fields:
    model: Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: The Model's display name in automl.googleapis.com.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDataset(_messages.Message):
  r"""Represents one Dataset in datalabeling.googleapis.com.

  Fields:
    dataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
      datalabeling.googleapis.com belongs to the data labeling Dataset.
    dataset: Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in
      datalabeling.googleapis.com.
  """

  dataLabelingAnnotatedDatasets = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset', 1, repeated=True)
  dataset = _messages.StringField(2)
  datasetDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset(_messages.Message):
  r"""Represents one AnnotatedDataset in datalabeling.googleapis.com.

  Fields:
    annotatedDataset: Full resource name of data labeling AnnotatedDataset.
      Format: `projects/{project}/datasets/{dataset}/annotatedDatasets/{annota
      ted_dataset}`.
    annotatedDatasetDisplayName: The AnnotatedDataset's display name in
      datalabeling.googleapis.com.
  """

  annotatedDataset = _messages.StringField(1)
  annotatedDatasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigratableResourceMlEngineModelVersion(_messages.Message):
  r"""Represents one model Version in ml.googleapis.com.

  Fields:
    endpoint: The ml.googleapis.com endpoint that this model Version currently
      lives in. Example values: * ml.googleapis.com * us-centrall-
      ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    version: Full resource name of ml engine model Version. Format:
      `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  version = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigrateResourceRequest(_messages.Message):
  r"""Config of migrating one resource from automl.googleapis.com,
  datalabeling.googleapis.com and ml.googleapis.com to AI Platform.

  Fields:
    migrateAutomlDatasetConfig: Config for migrating Dataset in
      automl.googleapis.com to AI Platform's Dataset.
    migrateAutomlModelConfig: Config for migrating Model in
      automl.googleapis.com to AI Platform's Model.
    migrateDataLabelingDatasetConfig: Config for migrating Dataset in
      datalabeling.googleapis.com to AI Platform's Dataset.
    migrateMlEngineModelVersionConfig: Config for migrating Version in
      ml.googleapis.com to AI Platform's Model.
  """

  migrateAutomlDatasetConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateAutomlDatasetConfig', 1)
  migrateAutomlModelConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateAutomlModelConfig', 2)
  migrateDataLabelingDatasetConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateDataLabelingDatasetConfig', 3)
  migrateMlEngineModelVersionConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateMlEngineModelVersionConfig', 4)


class GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateAutomlDatasetConfig(_messages.Message):
  r"""Config for migrating Dataset in automl.googleapis.com to AI Platform's
  Dataset.

  Fields:
    dataset: Required. Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: Required. Display name of the Dataset in AI Platform.
      System will pick a display name if unspecified.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateAutomlModelConfig(_messages.Message):
  r"""Config for migrating Model in automl.googleapis.com to AI Platform's
  Model.

  Fields:
    model: Required. Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: Optional. Display name of the model in AI Platform.
      System will pick a display name if unspecified.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateDataLabelingDatasetConfig(_messages.Message):
  r"""Config for migrating Dataset in datalabeling.googleapis.com to AI
  Platform's Dataset.

  Fields:
    dataset: Required. Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: Optional. Display name of the Dataset in AI Platform.
      System will pick a display name if unspecified.
    migrateDataLabelingAnnotatedDatasetConfigs: Optional. Configs for
      migrating AnnotatedDataset in datalabeling.googleapis.com to AI
      Platform's SavedQuery. The specified AnnotatedDatasets have to belong to
      the datalabeling Dataset.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)
  migrateDataLabelingAnnotatedDatasetConfigs = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig', 3, repeated=True)


class GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig(_messages.Message):
  r"""Config for migrating AnnotatedDataset in datalabeling.googleapis.com to
  AI Platform's SavedQuery.

  Fields:
    annotatedDataset: Required. Full resource name of data labeling
      AnnotatedDataset. Format: `projects/{project}/datasets/{dataset}/annotat
      edDatasets/{annotated_dataset}`.
  """

  annotatedDataset = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1MigrateResourceRequestMigrateMlEngineModelVersionConfig(_messages.Message):
  r"""Config for migrating version in ml.googleapis.com to AI Platform's
  Model.

  Fields:
    endpoint: Required. The ml.googleapis.com endpoint that this model version
      should be migrated from. Example values: * ml.googleapis.com * us-
      centrall-ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    modelDisplayName: Required. Display name of the model in AI Platform.
      System will pick a display name if unspecified.
    modelVersion: Required. Full resource name of ml engine model version.
      Format: `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)
  modelVersion = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1MigrateResourceResponse(_messages.Message):
  r"""Describes a successfully migrated resource.

  Fields:
    dataset: Migrated Dataset's resource name.
    migratableResource: Before migration, the identifier in ml.googleapis.com,
      automl.googleapis.com or datalabeling.googleapis.com.
    model: Migrated Model's resource name.
  """

  dataset = _messages.StringField(1)
  migratableResource = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResource', 2)
  model = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1Model(_messages.Message):
  r"""A trained machine learning Model.

  Enums:
    SupportedDeploymentResourcesTypesValueListEntryValuesEnum:

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Models. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    artifactUri: Immutable. The path to the directory containing the Model
      artifact and any of its supporting files. Not present for AutoML Models.
    containerSpec: Input only. The specification of the container that is to
      be used when deploying this Model. The specification is ingested upon
      ModelService.UploadModel, and all binaries it contains are copied and
      stored internally by AI Platform. Not present for AutoML Models.
    createTime: Output only. Timestamp when this Model was uploaded into AI
      Platform.
    deployedModels: Output only. The pointers to DeployedModels created from
      this Model. Note that Model could have been deployed to Endpoints in
      different Locations.
    description: The description of the Model.
    displayName: Required. The display name of the Model. The name can be up
      to 128 characters long and can be consist of any UTF-8 characters.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    explanationSpec: Output only. The default explanation specification for
      this Model. Model can be used for requesting explanation after being
      deployed iff it is populated. All fields of the explanation_spec can be
      overridden by explanation_spec of DeployModelRequest.deployed_model.
      This field is populated only for tabular AutoML Models. Specifying it
      with ModelService.UploadModel is not supported.
    labels: The labels with user-defined metadata to organize your Models.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    metadata: Immutable. An additional information about the Model; the schema
      of the metadata can be found in metadata_schema. Unset if the Model does
      not have any additional information.
    metadataSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Model, that is
      specific to it. Unset if the Model does not have any additional
      information. The schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML Models
      always have this field populated by AI Platform, if no additional
      metadata is needed this field is set to an empty string. Note: The URI
      given on output will be immutable and probably different, including the
      URI scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    name: The resource name of the Model.
    predictSchemata: The schemata that describe formats of the Model's
      predictions and explanations as given and returned via
      PredictionService.Predict and PredictionService.Explain.
    supportedDeploymentResourcesTypes: Output only. When this Model is
      deployed, its prediction resources are described by the
      `prediction_resources` field of the Endpoint.deployed_models object.
      Because not all Models support all resource configuration types, the
      configuration types this Model supports are listed here. If no
      configuration types are listed, the Model cannot be deployed to an
      Endpoint and does not support online predictions
      (PredictionService.Predict or PredictionService.Explain). Such a Model
      can serve predictions by using a BatchPredictionJob, if it has at least
      one entry each in supported_input_storage_formats and
      supported_output_storage_formats.
    supportedExportFormats: Output only. The formats in which this Model may
      be exported. If empty, this Model is not avaiable for export.
    supportedInputStorageFormats: Output only. The formats this Model supports
      in BatchPredictionJob.input_config. If
      PredictSchemata.instance_schema_uri exists, the instances should be
      given as per that schema. The possible formats are: * `jsonl` The JSON
      Lines format, where each instance is a single line. Uses GcsSource. *
      `csv` The CSV format, where each instance is a single comma-separated
      line. The first line in the file is the header, containing comma-
      separated field names. Uses GcsSource. * `tf-record` The TFRecord
      format, where each instance is a single record in tfrecord syntax. Uses
      GcsSource. * `tf-record-gzip` Similar to `tf-record`, but the file is
      gzipped. Uses GcsSource. * `bigquery` Each instance is a single row in
      BigQuery. Uses BigQuerySource. If this Model doesn't support any of
      these formats it means it cannot be used with a BatchPredictionJob.
      However, if it has supported_deployment_resources_types, it could serve
      online predictions by using PredictionService.Predict or
      PredictionService.Explain.
    supportedOutputStorageFormats: Output only. The formats this Model
      supports in BatchPredictionJob.output_config. If both
      PredictSchemata.instance_schema_uri and
      PredictSchemata.prediction_schema_uri exist, the predictions are
      returned together with their instances. In other words, the prediction
      has the original instance data first, followed by the actual prediction
      content (as per the schema). The possible formats are: * `jsonl` The
      JSON Lines format, where each prediction is a single line. Uses
      GcsDestination. * `csv` The CSV format, where each prediction is a
      single comma-separated line. The first line in the file is the header,
      containing comma-separated field names. Uses GcsDestination. *
      `bigquery` Each prediction is a single row in a BigQuery table, uses
      BigQueryDestination . If this Model doesn't support any of these formats
      it means it cannot be used with a BatchPredictionJob. However, if it has
      supported_deployment_resources_types, it could serve online predictions
      by using PredictionService.Predict or PredictionService.Explain.
    trainingPipeline: Output only. The resource name of the TrainingPipeline
      that uploaded this Model, if any.
    updateTime: Output only. Timestamp when this Model was most recently
      updated.
  """

  class SupportedDeploymentResourcesTypesValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedDeploymentResourcesTypesValueListEntryValuesEnum enum type.

    Values:
      DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED: Should not be used.
      DEDICATED_RESOURCES: Resources that are dedicated to the DeployedModel,
        and that need a higher degree of manual configuration.
      AUTOMATIC_RESOURCES: Resources that to large degree are decided by AI
        Platform, and require only a modest additional configuration.
    """
    DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED = 0
    DEDICATED_RESOURCES = 1
    AUTOMATIC_RESOURCES = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Models. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifactUri = _messages.StringField(1)
  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelContainerSpec', 2)
  createTime = _messages.StringField(3)
  deployedModels = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModelRef', 4, repeated=True)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  etag = _messages.StringField(7)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationSpec', 8)
  labels = _messages.MessageField('LabelsValue', 9)
  metadata = _messages.MessageField('extra_types.JsonValue', 10)
  metadataSchemaUri = _messages.StringField(11)
  name = _messages.StringField(12)
  predictSchemata = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictSchemata', 13)
  supportedDeploymentResourcesTypes = _messages.EnumField('SupportedDeploymentResourcesTypesValueListEntryValuesEnum', 14, repeated=True)
  supportedExportFormats = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelExportFormat', 15, repeated=True)
  supportedInputStorageFormats = _messages.StringField(16, repeated=True)
  supportedOutputStorageFormats = _messages.StringField(17, repeated=True)
  trainingPipeline = _messages.StringField(18)
  updateTime = _messages.StringField(19)


class GoogleCloudAiplatformV1beta1ModelContainerSpec(_messages.Message):
  r"""Specification of the container to be deployed for this Model. The
  ModelContainerSpec is based on the Kubernetes Container
  [specification](https://tinyurl.com/k8s-io-api/v1.10/#container-v1-core).

  Fields:
    args: Immutable. The arguments to the command. The Docker image's CMD is
      used if this is not provided. Variable references $(VAR_NAME) are
      expanded using the container's environment. If a variable cannot be
      resolved, the reference in the input string will be unchanged. The
      $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
      Escaped references will never be expanded, regardless of whether the
      variable exists or not. More info: https://tinyurl.com/y42hmlxe
    command: Immutable. The command with which the container is run. Not
      executed within a shell. The Docker image's ENTRYPOINT is used if this
      is not provided. Variable references $(VAR_NAME) are expanded using the
      container's environment. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      More info: https://tinyurl.com/y42hmlxe
    env: Immutable. The environment variables that are to be present in the
      container.
    healthRoute: Immutable. An HTTP path to send health check requests to the
      container, and which must be supported by it. If not specified a
      standard HTTP path will be used by AI Platform.
    imageUri: Required. Immutable. The URI of the Model serving container file
      in the Container Registry. The container image is ingested upon
      ModelService.UploadModel, stored internally, and this original path is
      afterwards not used.
    ports: Immutable. Declaration of ports that are exposed by the container.
      This field is primarily informational, it gives AI Platform information
      about the network connections the container uses. Listing or not a port
      here has no impact on whether the port is actually exposed, any port
      listening on the default "0.0.0.0" address inside a container will be
      accessible from the network.
    predictRoute: Immutable. An HTTP path to send prediction requests to the
      container, and which must be supported by it. If not specified a default
      HTTP path will be used by AI Platform.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('GoogleCloudAiplatformV1beta1EnvVar', 3, repeated=True)
  healthRoute = _messages.StringField(4)
  imageUri = _messages.StringField(5)
  ports = _messages.MessageField('GoogleCloudAiplatformV1beta1Port', 6, repeated=True)
  predictRoute = _messages.StringField(7)


class GoogleCloudAiplatformV1beta1ModelEvaluation(_messages.Message):
  r"""A collection of metrics calculated by comparing Model's predictions on
  all of the test data against annotations from the test data.

  Fields:
    createTime: Output only. Timestamp when this ModelEvaluation was created.
    metrics: Output only. Evaluation metrics of the Model. The schema of the
      metrics is stored in metrics_schema_uri
    metricsSchemaUri: Output only. Points to a YAML file stored on Google
      Cloud Storage describing the metrics of this ModelEvaluation. The schema
      is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object).
    modelExplanation: Output only. Aggregated explanation metrics for the
      Model's prediction output over the data this ModelEvaluation uses. This
      field is populated only if the Model is evaluated with explanations, and
      only for AutoML tabular Models.
    name: Output only. The resource name of the ModelEvaluation.
    sliceDimensions: Output only. All possible dimensions of
      ModelEvaluationSlices. The dimensions can be used as the filter of the
      ModelService.ListModelEvaluationSlices request, in the form of
      `slice.dimension = `.
  """

  createTime = _messages.StringField(1)
  metrics = _messages.MessageField('extra_types.JsonValue', 2)
  metricsSchemaUri = _messages.StringField(3)
  modelExplanation = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelExplanation', 4)
  name = _messages.StringField(5)
  sliceDimensions = _messages.StringField(6, repeated=True)


class GoogleCloudAiplatformV1beta1ModelEvaluationSlice(_messages.Message):
  r"""A collection of metrics calculated by comparing Model's predictions on a
  slice of the test data against ground truth annotations.

  Fields:
    createTime: Output only. Timestamp when this ModelEvaluationSlice was
      created.
    metrics: Output only. Sliced evaluation metrics of the Model. The schema
      of the metrics is stored in metrics_schema_uri
    metricsSchemaUri: Output only. Points to a YAML file stored on Google
      Cloud Storage describing the metrics of this ModelEvaluationSlice. The
      schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object).
    name: Output only. The resource name of the ModelEvaluationSlice.
    slice: Output only. The slice of the test data that is used to evaluate
      the Model.
  """

  createTime = _messages.StringField(1)
  metrics = _messages.MessageField('extra_types.JsonValue', 2)
  metricsSchemaUri = _messages.StringField(3)
  name = _messages.StringField(4)
  slice = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelEvaluationSliceSlice', 5)


class GoogleCloudAiplatformV1beta1ModelEvaluationSliceSlice(_messages.Message):
  r"""Definition of a slice.

  Fields:
    dimension: Output only. The dimension of the slice. Well-known dimensions
      are: * `annotationSpec`: This slice is on the test data that has either
      ground truth or prediction with AnnotationSpec.display_name equals to
      value.
    value: Output only. The value of the dimension in this slice.
  """

  dimension = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ModelExplanation(_messages.Message):
  r"""Aggregated explanation metrics for a Model over a set of instances.
  Currently, only AutoML tabular Models support aggregated explanation.

  Fields:
    meanAttributions: Output only. Aggregated attributions explaning the
      Model's prediction outputs over the set of instances. The attributions
      are grouped by outputs. For Models that predict only one output, such as
      regression Models that predict only one score, there is only one
      attibution that explains the predicted output. For Models that predict
      multiple outputs, such as multiclass Models that predict multiple
      classes, each element explains one specific item.
      Attribution.output_index can be used to identify which output this
      attribution is explaining. The baselineOutputValue, instanceOutputValue
      and featureAttributions fields are averaged over the test data. NOTE:
      Currently AutoML tabular classification Models produce only one
      attribution, which averages attributions over all the classes it
      predicts. Attribution.approximation_error is not populated.
  """

  meanAttributions = _messages.MessageField('GoogleCloudAiplatformV1beta1Attribution', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ModelExportFormat(_messages.Message):
  r"""Represents a supported by the Model export format. All formats export to
  Google Cloud Storage.

  Enums:
    ExportableContentsValueListEntryValuesEnum:

  Fields:
    exportableContents: Output only. The content of this Model that may be
      exported.
    id: Output only. The ID of the export format. The possible format IDs are:
      * `tflite` Used for Android mobile devices. * `edgetpu-tflite` Used for
      [Edge TPU](https://cloud.google.com/edge-tpu/) devices. * `tf-saved-
      model` A tensorflow model in SavedModel format. * `tf-js` A
      [TensorFlow.js](https://www.tensorflow.org/js) model that can be used in
      the browser and in Node.js using JavaScript. * `core-ml` Used for iOS
      mobile devices. * `custom-trained` A Model that was uploaded or trained
      by custom code.
  """

  class ExportableContentsValueListEntryValuesEnum(_messages.Enum):
    r"""ExportableContentsValueListEntryValuesEnum enum type.

    Values:
      EXPORTABLE_CONTENT_UNSPECIFIED: Should not be used.
      ARTIFACT: Model artifact and any of its supported files. Will be
        exported to the specified
        [ExportModelRequest.output_config.artifact_destination]
      IMAGE: The container image that is to be used when deploying this Model.
        Will be exported to the specified
        [ExportModelRequest.output_config.image_destination]
    """
    EXPORTABLE_CONTENT_UNSPECIFIED = 0
    ARTIFACT = 1
    IMAGE = 2

  exportableContents = _messages.EnumField('ExportableContentsValueListEntryValuesEnum', 1, repeated=True)
  id = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1Port(_messages.Message):
  r"""Represents a network port in a container.

  Fields:
    containerPort: The number of the port to expose on the pod's IP address.
      Must be a valid port number, between 1 and 65535 inclusive.
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1PredefinedSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on the
  value of a provided key. Supported only for tabular Datasets.

  Fields:
    key: Required. The key is a name of one of the Dataset's data columns. The
      value of the key (either the label's value or value in the column) must
      be one of {`training`, `validation`, `test`}, and it defines to which
      set the given piece of data is assigned. If for a piece of data the key
      is not present or has an invalid value, that piece is ignored by the
      pipeline.
  """

  key = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1PredictRequest(_messages.Message):
  r"""Request message for PredictionService.Predict.

  Fields:
    instances: Required. The instances that are the input to the prediction
      call. A DeployedModel may have an upper limit on the number of instances
      it supports per request, and when it is exceeded the prediction call
      errors in case of AutoML Models, or, in case of customer created Models,
      the behaviour is as documented by that Model. The schema of any single
      instance may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's instance_schema_uri.
    parameters: The parameters that govern the prediction. The schema of the
      parameters may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's parameters_schema_uri.
  """

  instances = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)
  parameters = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1beta1PredictResponse(_messages.Message):
  r"""Response message for PredictionService.Predict.

  Fields:
    deployedModelId: ID of the Endpoint's DeployedModel that served this
      prediction.
    predictions: The predictions that are the output of the predictions call.
      The schema of any single prediction may be specified via Endpoint's
      DeployedModels' Model's PredictSchemata's prediction_schema_uri.
  """

  deployedModelId = _messages.StringField(1)
  predictions = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)


class GoogleCloudAiplatformV1beta1PredictSchemata(_messages.Message):
  r"""Contains the schemata used in Model's predictions and explanations via
  PredictionService.Predict, PredictionService.Explain and BatchPredictionJob.

  Fields:
    instanceSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing the format of a single instance, which are used in
      PredictRequest.instances, ExplainRequest.instances and
      BatchPredictionJob.input_config. The schema is defined as an OpenAPI
      3.0.2 [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
      AutoML Models always have this field populated by AI Platform. Note: The
      URI given on output will be immutable and probably different, including
      the URI scheme, than the one given on input. The output URI will point
      to a location where the user only has a read access.
    parametersSchemaUri: Immutable. Points to a YAML file stored on Google
      Cloud Storage describing the parameters of prediction and explanation
      via PredictRequest.parameters, ExplainRequest.parameters and
      BatchPredictionJob.model_parameters. The schema is defined as an OpenAPI
      3.0.2 [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
      AutoML Models always have this field populated by AI Platform, if no
      parameters are supported it is set to an empty string. Note: The URI
      given on output will be immutable and probably different, including the
      URI scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    predictionSchemaUri: Immutable. Points to a YAML file stored on Google
      Cloud Storage describing the format of a single prediction produced by
      this Model, which are returned via PredictResponse.predictions,
      ExplainResponse.explanations, and BatchPredictionJob.output_config. The
      schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML Models
      always have this field populated by AI Platform. Note: The URI given on
      output will be immutable and probably different, including the URI
      scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
  """

  instanceSchemaUri = _messages.StringField(1)
  parametersSchemaUri = _messages.StringField(2)
  predictionSchemaUri = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1PythonPackageSpec(_messages.Message):
  r"""The spec of a Python packaged code.

  Fields:
    args: Command line arguments to be passed to the Python task.
    executorImageUri: Required. The URI of a container image in the Container
      Registry that will run the provided python package. AI Platform provides
      wide range of executor images with pre-installed packages to meet users'
      various use cases. Only one of the provided images can be set here.
    packageUris: Required. The Google Cloud Storage location of the Python
      package files which are the training program and its dependent packages.
      The maximum number of package URIs is 100.
    pythonModule: Required. The Python module name to run after installing the
      packages.
  """

  args = _messages.StringField(1, repeated=True)
  executorImageUri = _messages.StringField(2)
  packageUris = _messages.StringField(3, repeated=True)
  pythonModule = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1ResourcesConsumed(_messages.Message):
  r"""Statistics information about resource consumption.

  Fields:
    replicaHours: Output only. The number of replica hours used. Note that
      many replicas may run in parallel, and additionally any given work may
      be queued for some time. Therefore this value is not strictly related to
      wall time.
  """

  replicaHours = _messages.FloatField(1)


class GoogleCloudAiplatformV1beta1SampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    pathCount: Required. The number of feature permutations to consider when
      approximating the Shapley values. Valid range of its value is [1, 50],
      inclusively.
  """

  pathCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1Scheduling(_messages.Message):
  r"""All parameters related to queuing and scheduling of custom jobs.

  Fields:
    restartJobOnWorkerRestart: Restarts the entire CustomJob if a worker gets
      restarted. This feature can be used by distributed training jobs that
      are not resilient to workers leaving and joining a job.
    timeout: The maximum job running time. The default is 7 days.
  """

  restartJobOnWorkerRestart = _messages.BooleanField(1)
  timeout = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaAnnotationSpecColor(_messages.Message):
  r"""An entry of mapping between color and AnnotationSpec. The mapping is
  used in segmentation mask.

  Fields:
    color: The color of the AnnotationSpec in a segmentation mask.
    displayName: The display name of the AnnotationSpec represented by the
      color in the segmentation mask.
    id: The ID of the AnnotationSpec represented by the color in the
      segmentation mask.
  """

  color = _messages.MessageField('GoogleTypeColor', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SchemaImageBoundingBoxAnnotation(_messages.Message):
  r"""Annotation details specific to image object detection.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  xMax = _messages.FloatField(3)
  xMin = _messages.FloatField(4)
  yMax = _messages.FloatField(5)
  yMin = _messages.FloatField(6)


class GoogleCloudAiplatformV1beta1SchemaImageClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to image classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaImageDataItem(_messages.Message):
  r"""Payload of Image DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original image in
      user's bucket. The image is up to 30MB in size.
    mimeType: Output only. The mime type of the content of the image. Only the
      images in below listed mime types are supported. - image/jpeg -
      image/gif - image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaImageDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Image DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Image DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotation(_messages.Message):
  r"""Annotation details specific to image segmentation.

  Fields:
    annotationSpecColors: The mapping between color and AnnotationSpec for
      this Annotation.
    maskGcsUri: Google Cloud Storage URI that points to the mask image. The
      image must be in PNG format. It must have the same size as the
      DataItem's image. Each pixel in the image mask represents the
      AnnotationSpec which the pixel in the image DataItem belong to. Each
      color is mapped to one AnnotationSpec based on annotation_spec_colors.
  """

  annotationSpecColors = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaAnnotationSpecColor', 1, repeated=True)
  maskGcsUri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain tables data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataInputConfig
      attribute.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataInputConfig', 1)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Google Cloud Storage URI to a input file, only .csv file is
      supported.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataInputConfig(_messages.Message):
  r"""The tables Dataset's data source. The Dataset doesn't store the data
  directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A
      GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1beta1SchemaTextClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to text classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTextDataItem(_messages.Message):
  r"""Payload of Text DataItem.

  Fields:
    gcsUri: Output only. Google Cloud Storage URI points to the original text
      in user's bucket. The text file is up to 10MB in size.
  """

  gcsUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTextDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Text DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Text DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTextExtractionAnnotation(_messages.Message):
  r"""Annotation details specific to text extraction.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    textSegment: The segment of the text content.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  textSegment = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTextSegment', 3)


class GoogleCloudAiplatformV1beta1SchemaTextSegment(_messages.Message):
  r"""The text segment inside of DataItem.

  Fields:
    content: The text content in the segment for output only.
    endOffset: Zero-based character index of the first character past the end
      of the text segment (counting character from the beginning of the text).
      The character at the end_offset is NOT included in the text segment.
    startOffset: Zero-based character index of the first character of the text
      segment (counting characters from the beginning of the text).
  """

  content = _messages.StringField(1)
  endOffset = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  startOffset = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class GoogleCloudAiplatformV1beta1SchemaTextSentimentAnnotation(_messages.Message):
  r"""Annotation details specific to text sentiment.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    sentiment: The sentiment score for text.
    sentimentMax: The sentiment max score for text.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sentiment = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sentimentMax = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaTextSentimentSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains TextSentiment Annotations.

  Fields:
    sentimentMax: The maximum sentiment of sentiment Anntoation in this
      SavedQuery.
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaTimeSegment(_messages.Message):
  r"""A time period inside of a DataItem that has a time dimension (e.g.
  video).

  Fields:
    endTimeOffset: End of the time segment (exclusive), represented as the
      duration since the start of the DataItem.
    startTimeOffset: Start of the time segment (inclusive), represented as the
      duration since the start of the DataItem.
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain time series data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataInputConfig
      attribute.
    timeColumn: The column name of the time column that identifies time order
      in the time series.
    timeSeriesIdentifierColumn: The column name of the time series identifier
      column that identifies the time series.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataInputConfig', 1)
  timeColumn = _messages.StringField(2)
  timeSeriesIdentifierColumn = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Google Cloud Storage URI to a input file, only .csv file is
      supported.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataInputConfig(_messages.Message):
  r"""The time series Dataset's data source. The Dataset doesn't store the
  data directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySourc
      e attribute.
    gcsSource: A
      GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1beta1SchemaVideoActionRecognitionAnnotation(_messages.Message):
  r"""Annotation details specific to video action recognition.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1beta1SchemaVideoClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to video classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1beta1SchemaVideoDataItem(_messages.Message):
  r"""Payload of Video DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original video in
      user's bucket. The video is up to 50 GB in size and up to 3 hour in
      duration.
    mimeType: Output only. The mime type of the content of the video. Only the
      videos in below listed mime types are supported. Supported mime_type: -
      video/mp4 - video/avi - video/quicktime
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaVideoDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Video DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Video DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaVideoObjectTrackingAnnotation(_messages.Message):
  r"""Annotation details specific to video object tracking.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    instanceId: The instance of the object, expressed as a positive integer.
      Used to track the same object across different frames.
    timeOffset: A time (frame) of a video to which this annotation pertains.
      Represented as the duration since the video's start.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  instanceId = _messages.IntegerField(3)
  timeOffset = _messages.StringField(4)
  xMax = _messages.FloatField(5)
  xMin = _messages.FloatField(6)
  yMax = _messages.FloatField(7)
  yMin = _messages.FloatField(8)


class GoogleCloudAiplatformV1beta1SchemaVisualInspectionClassificationLabelSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaVisualInspectionClassificationLabelS
  avedQueryMetadata object.

  Fields:
    multiLabel: Whether or not the classification label is multi_label.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1SchemaVisualInspectionMaskSavedQueryMetadata(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1beta1SchemaVisualInspectionMaskSavedQueryMetadata
  object.

  Fields:
    colorMap: The mapping between color and AnnotationSpec for this
      SavedQuery.
  """

  colorMap = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaAnnotationSpecColor', 1, repeated=True)


class GoogleCloudAiplatformV1beta1SearchMigratableResourcesRequest(_messages.Message):
  r"""Request message for MigrationService.SearchMigratableResources.

  Fields:
    pageSize: The standard page size. The default and maximum value is 100.
    pageToken: The standard page token.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SearchMigratableResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.SearchMigratableResources.

  Fields:
    migratableResources: All migratable resources that can be migrated to the
      location specified in the request.
    nextPageToken: The standard next-page token. The migratable_resources may
      not fill page_size in SearchMigratableResourcesRequest even when there
      are subsequent pages.
  """

  migratableResources = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResource', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SpecialistPool(_messages.Message):
  r"""SpecialistPool represents customers' own workforce to work on their data
  labeling jobs. It includes a group of specialist managers who are
  responsible for managing the labelers in this pool as well as customers'
  data labeling jobs associated with this pool. Customers create specialist
  pool as well as start data labeling jobs on Cloud, managers and labelers
  work with the jobs using CrowdCompute console.

  Fields:
    displayName: Required. The user-defined name of the SpecialistPool. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. This field should be unique on project-level.
    name: Required. The resource name of the SpecialistPool.
    pendingDataLabelingJobs: Output only. The resource name of the pending
      data labeling jobs.
    specialistManagerEmails: The email addresses of the specialists in the
      SpecialistPool.
    specialistManagersCount: Output only. The number of Specialists in this
      SpecialistPool.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  pendingDataLabelingJobs = _messages.StringField(3, repeated=True)
  specialistManagerEmails = _messages.StringField(4, repeated=True)
  specialistManagersCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1StudySpec(_messages.Message):
  r"""Represents specification of a Study.

  Enums:
    AlgorithmValueValuesEnum: The search algorithm specified for the Study.

  Fields:
    algorithm: The search algorithm specified for the Study.
    metrics: Required. Metric specs for the Study.
    parameters: Required. The set of parameters to tune.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""The search algorithm specified for the Study.

    Values:
      ALGORITHM_UNSPECIFIED: The default algorithm used by AI Platform
        Optimization service.
      GRID_SEARCH: Simple grid search within the feasible space. To use grid
        search, all parameters must be `INTEGER`, `CATEGORICAL`, or
        `DISCRETE`.
      RANDOM_SEARCH: Simple random search within the feasible space.
    """
    ALGORITHM_UNSPECIFIED = 0
    GRID_SEARCH = 1
    RANDOM_SEARCH = 2

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  metrics = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpecMetricSpec', 2, repeated=True)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpecParameterSpec', 3, repeated=True)


class GoogleCloudAiplatformV1beta1StudySpecMetricSpec(_messages.Message):
  r"""Represents a metric to optimize.

  Enums:
    GoalValueValuesEnum: Required. The optimization goal of the metric.

  Fields:
    goal: Required. The optimization goal of the metric.
    metricId: Required. The ID of the metric. Must not contain whitespaces and
      must be unique amongst all MetricSpecs.
  """

  class GoalValueValuesEnum(_messages.Enum):
    r"""Required. The optimization goal of the metric.

    Values:
      GOAL_TYPE_UNSPECIFIED: Goal Type will default to maximize.
      MAXIMIZE: Maximize the goal metric.
      MINIMIZE: Minimize the goal metric.
    """
    GOAL_TYPE_UNSPECIFIED = 0
    MAXIMIZE = 1
    MINIMIZE = 2

  goal = _messages.EnumField('GoalValueValuesEnum', 1)
  metricId = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1StudySpecParameterSpec(_messages.Message):
  r"""Represents a single parameter to optimize.

  Enums:
    ScaleTypeValueValuesEnum: How the parameter should be scaled. Leave unset
      for `CATEGORICAL` parameters.

  Fields:
    categoricalValueSpec: The value spec for a 'CATEGORICAL' parameter.
    discreteValueSpec: The value spec for a 'DISCRETE' parameter.
    doubleValueSpec: The value spec for a 'DOUBLE' parameter.
    integerValueSpec: The value spec for an 'INTEGER' parameter.
    parameterId: Required. The ID of the parameter. Must not contain
      whitespaces and must be unique amongst all ParameterSpecs.
    scaleType: How the parameter should be scaled. Leave unset for
      `CATEGORICAL` parameters.
  """

  class ScaleTypeValueValuesEnum(_messages.Enum):
    r"""How the parameter should be scaled. Leave unset for `CATEGORICAL`
    parameters.

    Values:
      SCALE_TYPE_UNSPECIFIED: By default, no scaling is applied.
      UNIT_LINEAR_SCALE: Scales the feasible space to (0, 1) linearly.
      UNIT_LOG_SCALE: Scales the feasible space logarithmically to (0, 1). The
        entire feasible space must be strictly positive.
      UNIT_REVERSE_LOG_SCALE: Scales the feasible space "reverse"
        logarithmically to (0, 1). The result is that values close to the top
        of the feasible space are spread out more than points near the bottom.
        The entire feasible space must be strictly positive.
    """
    SCALE_TYPE_UNSPECIFIED = 0
    UNIT_LINEAR_SCALE = 1
    UNIT_LOG_SCALE = 2
    UNIT_REVERSE_LOG_SCALE = 3

  categoricalValueSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpecParameterSpecCategoricalValueSpec', 1)
  discreteValueSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpecParameterSpecDiscreteValueSpec', 2)
  doubleValueSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpecParameterSpecDoubleValueSpec', 3)
  integerValueSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpecParameterSpecIntegerValueSpec', 4)
  parameterId = _messages.StringField(5)
  scaleType = _messages.EnumField('ScaleTypeValueValuesEnum', 6)


class GoogleCloudAiplatformV1beta1StudySpecParameterSpecCategoricalValueSpec(_messages.Message):
  r"""Value specification for a parameter in `CATEGORICAL` type.

  Fields:
    values: Required. The list of possible categories.
  """

  values = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1StudySpecParameterSpecDiscreteValueSpec(_messages.Message):
  r"""Value specification for a parameter in `DISCRETE` type.

  Fields:
    values: Required. A list of possible values. The list should be in
      increasing order and at least 1e-10 apart. For instance, this parameter
      might have possible settings of 1.5, 2.5, and 4.0. This list should not
      contain more than 1,000 values.
  """

  values = _messages.FloatField(1, repeated=True)


class GoogleCloudAiplatformV1beta1StudySpecParameterSpecDoubleValueSpec(_messages.Message):
  r"""Value specification for a parameter in `DOUBLE` type.

  Fields:
    maxValue: Required. Inclusive maximum value of the parameter.
    minValue: Required. Inclusive minimum value of the parameter.
  """

  maxValue = _messages.FloatField(1)
  minValue = _messages.FloatField(2)


class GoogleCloudAiplatformV1beta1StudySpecParameterSpecIntegerValueSpec(_messages.Message):
  r"""Value specification for a parameter in `INTEGER` type.

  Fields:
    maxValue: Required. Inclusive maximum value of the parameter.
    minValue: Required. Inclusive minimum value of the parameter.
  """

  maxValue = _messages.IntegerField(1)
  minValue = _messages.IntegerField(2)


class GoogleCloudAiplatformV1beta1TimestampSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on a
  provided timestamps. The youngest data pieces are assigned to training set,
  next to validation set, and the oldest to the test set. Supported only for
  tabular Datasets.

  Fields:
    key: Required. The key is a name of one of the Dataset's data columns. The
      values of the key (the values in the column) must be in RFC 3339 `date-
      time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z). If for a piece of data the key is not present
      or has an invalid value, that piece is ignored by the pipeline.
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  key = _messages.StringField(1)
  testFraction = _messages.FloatField(2)
  trainingFraction = _messages.FloatField(3)
  validationFraction = _messages.FloatField(4)


class GoogleCloudAiplatformV1beta1TrainingPipeline(_messages.Message):
  r"""The TrainingPipeline orchestrates tasks associated with training a
  Model. It always executes the training task, and optionally may also export
  data from AI Platform's Dataset which becomes the training input, upload the
  Model to AI Platform, and evaluate the Model.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the pipeline.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      TrainingPipelines. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Time when the TrainingPipeline was created.
    displayName: Required. The user-defined name of this TrainingPipeline.
    endTime: Output only. Time when the TrainingPipeline entered any of the
      following states: `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
      `PIPELINE_STATE_CANCELLED`.
    error: Output only. Only populated when the pipeline's state is
      `PIPELINE_STATE_FAILED` or `PIPELINE_STATE_CANCELLED`.
    inputDataConfig: Specifies AI Platform owned input data that may be used
      for training the Model. The TrainingPipeline's training_task_definition
      should make clear whether this config is used and if there are any
      special requirements on how it should be filled. If nothing about this
      config is mentioned in the training_task_definition, then it should be
      assumed that the TrainingPipeline does not depend on this configuration.
    labels: The labels with user-defined metadata to organize
      TrainingPipelines. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    modelToUpload: Describes the Model that may be uploaded (via
      ModelService.UploadMode) by this TrainingPipeline. The
      TrainingPipeline's training_task_definition should make clear whether
      this Model description should be populated, and if there are any special
      requirements regarding how it should be filled. If nothing is mentioned
      in the training_task_definition, then it should be assumed that this
      field should not be filled and the training task either uploads the
      Model without a need of this information, or that training task does not
      support uploading a Model as part of the pipeline. When the Pipeline's
      state becomes `PIPELINE_STATE_SUCCEEDED` and the trained Model had been
      uploaded into AI Platform, then the model_to_upload's resource name is
      populated. The Model is always uploaded into the Project and Location in
      which this pipeline is.
    name: Output only. Resource name of the TrainingPipeline.
    startTime: Output only. Time when the TrainingPipeline for the first time
      entered the `PIPELINE_STATE_RUNNING` state.
    state: Output only. The detailed state of the pipeline.
    trainingTaskDefinition: Required. A Google Cloud Storage path to the YAML
      file that defines the training task which is responsible for producing
      the model artifact, and may also include additional auxiliary work. The
      definition files that can be used here are found in gs://google-cloud-
      aiplatform/schema/trainingjob/definition/. Note: The URI given on output
      will be immutable and probably different, including the URI scheme, than
      the one given on input. The output URI will point to a location where
      the user only has a read access.
    trainingTaskInputs: Required. The training task's parameter(s), as
      specified in the training_task_definition's `inputs`.
    trainingTaskMetadata: Output only. The metadata information as specified
      in the training_task_definition's `metadata`. This metadata is an
      auxiliary runtime and final information about the training task. While
      the pipeline is running this information is populated only at a best
      effort basis. Only present if the pipeline's training_task_definition
      contains `metadata` object.
    updateTime: Output only. Time when the TrainingPipeline was most recently
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the pipeline.

    Values:
      PIPELINE_STATE_UNSPECIFIED: The pipeline state is unspecified.
      PIPELINE_STATE_QUEUED: The pipeline has been just created or resumed and
        processing has not yet begun.
      PIPELINE_STATE_PENDING: The service is preparing to run the pipeline.
      PIPELINE_STATE_RUNNING: The pipeline is in progress.
      PIPELINE_STATE_SUCCEEDED: The pipeline completed successfully.
      PIPELINE_STATE_FAILED: The pipeline failed.
      PIPELINE_STATE_CANCELLING: The pipeline is being cancelled. From this
        state the pipeline may only go to either PIPELINE_STATE_SUCCEEDED,
        PIPELINE_STATE_FAILED or PIPELINE_STATE_CANCELLED.
      PIPELINE_STATE_CANCELLED: The pipeline has been cancelled.
      PIPELINE_STATE_PAUSED: The pipeline has been stopped, and can be
        resumed.
    """
    PIPELINE_STATE_UNSPECIFIED = 0
    PIPELINE_STATE_QUEUED = 1
    PIPELINE_STATE_PENDING = 2
    PIPELINE_STATE_RUNNING = 3
    PIPELINE_STATE_SUCCEEDED = 4
    PIPELINE_STATE_FAILED = 5
    PIPELINE_STATE_CANCELLING = 6
    PIPELINE_STATE_CANCELLED = 7
    PIPELINE_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize TrainingPipelines.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  endTime = _messages.StringField(3)
  error = _messages.MessageField('GoogleRpcStatus', 4)
  inputDataConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1InputDataConfig', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  modelToUpload = _messages.MessageField('GoogleCloudAiplatformV1beta1Model', 7)
  name = _messages.StringField(8)
  startTime = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  trainingTaskDefinition = _messages.StringField(11)
  trainingTaskInputs = _messages.MessageField('extra_types.JsonValue', 12)
  trainingTaskMetadata = _messages.MessageField('extra_types.JsonValue', 13)
  updateTime = _messages.StringField(14)


class GoogleCloudAiplatformV1beta1Trial(_messages.Message):
  r"""A message representing a Trial. A Trial contains a unique set of
  Parameters that has been or will be evaluated, along with the objective
  metrics got by running the Trial.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the Trial.

  Fields:
    customJob: Output only. The CustomJob name linked to the Trial. It's set
      for a HyperparameterTuningJob's Trial.
    endTime: Output only. Time when the Trial's status changed to `SUCCEEDED`
      or `INFEASIBLE`.
    finalMeasurement: Output only. The final measurement containing the
      objective value.
    id: Output only. The identifier of the Trial assigned by the service.
    parameters: Output only. The parameters of the Trial.
    startTime: Output only. Time when the Trial was started.
    state: Output only. The detailed state of the Trial.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the Trial.

    Values:
      STATE_UNSPECIFIED: The Trial state is unspecified.
      REQUESTED: Indicates that a specific Trial has been requested, but it
        has not yet been suggested by the service.
      ACTIVE: Indicates that the Trial has been suggested.
      STOPPING: Indicates that the Trial should stop according to the service.
      SUCCEEDED: Indicates that the Trial is completed successfully.
      INFEASIBLE: Indicates that the Trial should not be attempted again. The
        service will set a Trial to INFEASIBLE when it's done but missing the
        final_measurement.
    """
    STATE_UNSPECIFIED = 0
    REQUESTED = 1
    ACTIVE = 2
    STOPPING = 3
    SUCCEEDED = 4
    INFEASIBLE = 5

  customJob = _messages.StringField(1)
  endTime = _messages.StringField(2)
  finalMeasurement = _messages.MessageField('GoogleCloudAiplatformV1beta1Measurement', 3)
  id = _messages.StringField(4)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1TrialParameter', 5, repeated=True)
  startTime = _messages.StringField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)


class GoogleCloudAiplatformV1beta1TrialParameter(_messages.Message):
  r"""A message representing a parameter to be tuned.

  Fields:
    parameterId: Output only. The ID of the parameter. The parameter should be
      defined in StudySpec's Parameters.
    value: Output only. The value of the parameter. `number_value` will be set
      if a parameter defined in StudySpec is in type 'INTEGER', 'DOUBLE' or
      'DISCRETE'. `string_value` will be set if a parameter defined in
      StudySpec is in type 'CATEGORICAL'.
  """

  parameterId = _messages.StringField(1)
  value = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1beta1UndeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.UndeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1UndeployModelRequest(_messages.Message):
  r"""Request message for EndpointService.UndeployModel.

  Messages:
    TrafficSplitValue: If this field is provided, then the Endpoint's
      traffic_split will be overwritten with it. If last DeployedModel is
      being undeployed from the Endpoint, the [Endpoint.traffic_split] will
      always end up empty when this call returns. A DeployedModel will be
      successfully undeployed only if it doesn't have any traffic assigned to
      it when this method executes, or if this field unassigns any traffic to
      it.

  Fields:
    deployedModelId: Required. The ID of the DeployedModel to be undeployed
      from the Endpoint.
    trafficSplit: If this field is provided, then the Endpoint's traffic_split
      will be overwritten with it. If last DeployedModel is being undeployed
      from the Endpoint, the [Endpoint.traffic_split] will always end up empty
      when this call returns. A DeployedModel will be successfully undeployed
      only if it doesn't have any traffic assigned to it when this method
      executes, or if this field unassigns any traffic to it.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""If this field is provided, then the Endpoint's traffic_split will be
    overwritten with it. If last DeployedModel is being undeployed from the
    Endpoint, the [Endpoint.traffic_split] will always end up empty when this
    call returns. A DeployedModel will be successfully undeployed only if it
    doesn't have any traffic assigned to it when this method executes, or if
    this field unassigns any traffic to it.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deployedModelId = _messages.StringField(1)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 2)


class GoogleCloudAiplatformV1beta1UndeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.UndeployModel."""


class GoogleCloudAiplatformV1beta1UpdateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation metadata for
  SpecialistPoolService.UpdateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
    specialistPool: Output only. The name of the SpecialistPool to which the
      specialists are being added. Format: `projects/{project_id}/locations/{l
      ocation_id}/specialistPools/{specialist_pool}`
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  specialistPool = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1UploadModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.UploadModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1UploadModelRequest(_messages.Message):
  r"""Request message for ModelService.UploadModel.

  Fields:
    model: Required. The Model to create.
  """

  model = _messages.MessageField('GoogleCloudAiplatformV1beta1Model', 1)


class GoogleCloudAiplatformV1beta1UploadModelResponse(_messages.Message):
  r"""Response message of ModelService.UploadModel operation.

  Fields:
    model: The name of the uploaded Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  model = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1UserActionReference(_messages.Message):
  r"""References an API call. It contains more information about long running
  operation and Jobs that are triggered by the API call.

  Fields:
    dataLabelingJob: For API calls that start a LabelingJob. Resource name of
      the LabelingJob. Format: 'projects/{project}/locations/{location}/dataLa
      belingJobs/{data_labeling_job}'
    method: The method name of the API call. For example,
      "/google.cloud.aiplatform.v1alpha1.DatasetService.CreateDataset"
    operation: For API calls that return a long running operation. Resource
      name of the long running operation. Format:
      'projects/{project}/locations/{location}/operations/{operation}'
  """

  dataLabelingJob = _messages.StringField(1)
  method = _messages.StringField(2)
  operation = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1WorkerPoolSpec(_messages.Message):
  r"""Represents the spec of a worker pool in a job.

  Fields:
    containerSpec: The custom container task.
    machineSpec: Required. Immutable. The specification of a single machine.
    pythonPackageSpec: The Python packaged task.
    replicaCount: Required. The number of worker replicas to use for this
      worker pool.
  """

  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ContainerSpec', 1)
  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1MachineSpec', 2)
  pythonPackageSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1PythonPackageSpec', 3)
  replicaCount = _messages.IntegerField(4)


class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeColor(_messages.Message):
  r"""Represents a color in the RGBA color space. This representation is
  designed for simplicity of conversion to/from color representations in
  various languages over compactness; for example, the fields of this
  representation can be trivially provided to the constructor of
  "java.awt.Color" in Java; it can also be trivially provided to UIColor's
  "+colorWithRed:green:blue:alpha" method in iOS; and, with just a little
  work, it can be easily formatted into a CSS "rgba()" string in JavaScript,
  as well. Note: this proto does not carry information about the absolute
  color space that should be used to interpret the RGB value (e.g. sRGB, Adobe
  RGB, DCI-P3, BT.2020, etc.). By default, applications SHOULD assume the sRGB
  color space. Note: when color equality needs to be decided, implementations,
  unless documented otherwise, will treat two colors to be equal if all their
  red, green, blue and alpha values each differ by at most 1e-5. Example
  (Java): import com.google.type.Color; // ... public static java.awt.Color
  fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ?
  protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color(
  protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); }
  public static Color toProto(java.awt.Color color) { float red = (float)
  color.getRed(); float green = (float) color.getGreen(); float blue = (float)
  color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder =
  Color .newBuilder() .setRed(red / denominator) .setGreen(green /
  denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if
  (alpha != 255) { result.setAlpha( FloatValue .newBuilder()
  .setValue(((float) alpha) / denominator) .build()); } return
  resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static
  UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float
  green = [protocolor green]; float blue = [protocolor blue]; FloatValue*
  alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper !=
  nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red
  green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color)
  { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green
  blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc]
  init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
  if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; }
  [result autorelease]; return result; } // ... Example (JavaScript): // ...
  var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red ||
  0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue
  || 0.0; var red = Math.floor(redFrac * 255); var green =
  Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if
  (!('alpha' in rgb_color)) { return rgbToCssColor_(red, green, blue); } var
  alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green,
  blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join('');
  }; var rgbToCssColor_ = function(red, green, blue) { var rgbNumber = new
  Number((red << 16) | (green << 8) | blue); var hexString =
  rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var
  resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) {
  resultBuilder.push('0'); } resultBuilder.push(hexString); return
  resultBuilder.join(''); }; // ...

  Fields:
    alpha: The fraction of this color that should be applied to the pixel.
      That is, the final pixel color is defined by the equation: pixel color =
      alpha * (this color) + (1.0 - alpha) * (background color) This means
      that a value of 1.0 corresponds to a solid color, whereas a value of 0.0
      corresponds to a completely transparent color. This uses a wrapper
      message rather than a simple float scalar so that it is possible to
      distinguish between a default value and the value being unset. If
      omitted, this color object is to be rendered as a solid color (as if the
      alpha value had been explicitly given with a value of 1.0).
    blue: The amount of blue in the color as a value in the interval [0, 1].
    green: The amount of green in the color as a value in the interval [0, 1].
    red: The amount of red in the color as a value in the interval [0, 1].
  """

  alpha = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  blue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  green = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  red = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
