# -*- coding: utf-8 -*- #
# Copyright 2020 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Create-auto cluster command."""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from googlecloudsdk.calliope import base
from surface.container.clusters import create

auto_flags = [
    'args', 'masterauth', 'nodeidentity',
    'releasechannel', 'privatecluster', 'ipalias_additional',
]

flag_overrides = {}  # Change default flag values in create-auto
auto_flag_defaults = dict(list(create.base_flag_defaults.items()) + \
                          list(flag_overrides.items()))


@base.Hidden
@base.ReleaseTracks(base.ReleaseTrack.BETA)
class CreateBeta(create.CreateBeta):
  autogke = True
  default_flag_values = auto_flag_defaults

  @staticmethod
  def Args(parser):
    create.AddFlags(create.BETA, parser, auto_flag_defaults, auto_flags)


@base.Hidden
@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class CreateAlpha(create.CreateAlpha):
  autogke = True
  auto_flag_defaults = auto_flag_defaults

  @staticmethod
  def Args(parser):
    create.AddFlags(create.ALPHA, parser, auto_flag_defaults, auto_flags)
