"""Generated message classes for monitoring version v3.

Manages your Stackdriver Monitoring data and configurations. Most projects
must be associated with a Stackdriver account, with a few exceptions as noted
on the individual method pages.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'monitoring'


class Aggregation(_messages.Message):
  r"""Describes how to combine multiple time series to provide different views
  of the data. Aggregation consists of an alignment step on individual time
  series (alignment_period and per_series_aligner) followed by an optional
  reduction step of the data across the aligned time series
  (cross_series_reducer and group_by_fields). For more details, see
  Aggregation.

  Enums:
    CrossSeriesReducerValueValuesEnum: The approach to be used to combine time
      series. Not all reducer functions may be applied to all time series,
      depending on the metric type and the value type of the original time
      series. Reduction may change the metric type of value type of the time
      series.Time series data must be aligned in order to perform cross-time
      series reduction. If crossSeriesReducer is specified, then
      perSeriesAligner must be specified and not equal ALIGN_NONE and
      alignmentPeriod must be specified; otherwise, an error is returned.
    PerSeriesAlignerValueValuesEnum: The approach to be used to align
      individual time series. Not all alignment functions may be applied to
      all time series, depending on the metric type and value type of the
      original time series. Alignment may change the metric type or the value
      type of the time series.Time series data must be aligned in order to
      perform cross-time series reduction. If crossSeriesReducer is specified,
      then perSeriesAligner must be specified and not equal ALIGN_NONE and
      alignmentPeriod must be specified; otherwise, an error is returned.

  Fields:
    alignmentPeriod: The alignment period for per-time series alignment. If
      present, alignmentPeriod must be at least 60 seconds. After per-time
      series alignment, each time series will contain data points only on the
      period boundaries. If perSeriesAligner is not specified or equals
      ALIGN_NONE, then this field is ignored. If perSeriesAligner is specified
      and does not equal ALIGN_NONE, then this field must be defined;
      otherwise an error is returned.
    crossSeriesReducer: The approach to be used to combine time series. Not
      all reducer functions may be applied to all time series, depending on
      the metric type and the value type of the original time series.
      Reduction may change the metric type of value type of the time
      series.Time series data must be aligned in order to perform cross-time
      series reduction. If crossSeriesReducer is specified, then
      perSeriesAligner must be specified and not equal ALIGN_NONE and
      alignmentPeriod must be specified; otherwise, an error is returned.
    groupByFields: The set of fields to preserve when crossSeriesReducer is
      specified. The groupByFields determine how the time series are
      partitioned into subsets prior to applying the aggregation function.
      Each subset contains time series that have the same value for each of
      the grouping fields. Each individual time series is a member of exactly
      one subset. The crossSeriesReducer is applied to each subset of time
      series. It is not possible to reduce across different resource types, so
      this field implicitly contains resource.type. Fields not specified in
      groupByFields are aggregated away. If groupByFields is not specified and
      all the time series have the same resource type, then the time series
      are aggregated into a single output time series. If crossSeriesReducer
      is not defined, this field is ignored.
    perSeriesAligner: The approach to be used to align individual time series.
      Not all alignment functions may be applied to all time series, depending
      on the metric type and value type of the original time series. Alignment
      may change the metric type or the value type of the time series.Time
      series data must be aligned in order to perform cross-time series
      reduction. If crossSeriesReducer is specified, then perSeriesAligner
      must be specified and not equal ALIGN_NONE and alignmentPeriod must be
      specified; otherwise, an error is returned.
  """

  class CrossSeriesReducerValueValuesEnum(_messages.Enum):
    r"""The approach to be used to combine time series. Not all reducer
    functions may be applied to all time series, depending on the metric type
    and the value type of the original time series. Reduction may change the
    metric type of value type of the time series.Time series data must be
    aligned in order to perform cross-time series reduction. If
    crossSeriesReducer is specified, then perSeriesAligner must be specified
    and not equal ALIGN_NONE and alignmentPeriod must be specified; otherwise,
    an error is returned.

    Values:
      REDUCE_NONE: No cross-time series reduction. The output of the aligner
        is returned.
      REDUCE_MEAN: Reduce by computing the mean across time series for each
        alignment period. This reducer is valid for delta and gauge metrics
        with numeric or distribution values. The value type of the output is
        DOUBLE.
      REDUCE_MIN: Reduce by computing the minimum across time series for each
        alignment period. This reducer is valid for delta and gauge metrics
        with numeric values. The value type of the output is the same as the
        value type of the input.
      REDUCE_MAX: Reduce by computing the maximum across time series for each
        alignment period. This reducer is valid for delta and gauge metrics
        with numeric values. The value type of the output is the same as the
        value type of the input.
      REDUCE_SUM: Reduce by computing the sum across time series for each
        alignment period. This reducer is valid for delta and gauge metrics
        with numeric and distribution values. The value type of the output is
        the same as the value type of the input.
      REDUCE_STDDEV: Reduce by computing the standard deviation across time
        series for each alignment period. This reducer is valid for delta and
        gauge metrics with numeric or distribution values. The value type of
        the output is DOUBLE.
      REDUCE_COUNT: Reduce by computing the count of data points across time
        series for each alignment period. This reducer is valid for delta and
        gauge metrics of numeric, Boolean, distribution, and string value
        type. The value type of the output is INT64.
      REDUCE_COUNT_TRUE: Reduce by computing the count of True-valued data
        points across time series for each alignment period. This reducer is
        valid for delta and gauge metrics of Boolean value type. The value
        type of the output is INT64.
      REDUCE_COUNT_FALSE: Reduce by computing the count of False-valued data
        points across time series for each alignment period. This reducer is
        valid for delta and gauge metrics of Boolean value type. The value
        type of the output is INT64.
      REDUCE_FRACTION_TRUE: Reduce by computing the fraction of True-valued
        data points across time series for each alignment period. This reducer
        is valid for delta and gauge metrics of Boolean value type. The output
        value is in the range 0, 1 and has value type DOUBLE.
      REDUCE_PERCENTILE_99: Reduce by computing 99th percentile of data points
        across time series for each alignment period. This reducer is valid
        for gauge and delta metrics of numeric and distribution type. The
        value of the output is DOUBLE
      REDUCE_PERCENTILE_95: Reduce by computing 95th percentile of data points
        across time series for each alignment period. This reducer is valid
        for gauge and delta metrics of numeric and distribution type. The
        value of the output is DOUBLE
      REDUCE_PERCENTILE_50: Reduce by computing 50th percentile of data points
        across time series for each alignment period. This reducer is valid
        for gauge and delta metrics of numeric and distribution type. The
        value of the output is DOUBLE
      REDUCE_PERCENTILE_05: Reduce by computing 5th percentile of data points
        across time series for each alignment period. This reducer is valid
        for gauge and delta metrics of numeric and distribution type. The
        value of the output is DOUBLE
    """
    REDUCE_NONE = 0
    REDUCE_MEAN = 1
    REDUCE_MIN = 2
    REDUCE_MAX = 3
    REDUCE_SUM = 4
    REDUCE_STDDEV = 5
    REDUCE_COUNT = 6
    REDUCE_COUNT_TRUE = 7
    REDUCE_COUNT_FALSE = 8
    REDUCE_FRACTION_TRUE = 9
    REDUCE_PERCENTILE_99 = 10
    REDUCE_PERCENTILE_95 = 11
    REDUCE_PERCENTILE_50 = 12
    REDUCE_PERCENTILE_05 = 13

  class PerSeriesAlignerValueValuesEnum(_messages.Enum):
    r"""The approach to be used to align individual time series. Not all
    alignment functions may be applied to all time series, depending on the
    metric type and value type of the original time series. Alignment may
    change the metric type or the value type of the time series.Time series
    data must be aligned in order to perform cross-time series reduction. If
    crossSeriesReducer is specified, then perSeriesAligner must be specified
    and not equal ALIGN_NONE and alignmentPeriod must be specified; otherwise,
    an error is returned.

    Values:
      ALIGN_NONE: No alignment. Raw data is returned. Not valid if cross-time
        series reduction is requested. The value type of the result is the
        same as the value type of the input.
      ALIGN_DELTA: Align and convert to delta metric type. This alignment is
        valid for cumulative metrics and delta metrics. Aligning an existing
        delta metric to a delta metric requires that the alignment period be
        increased. The value type of the result is the same as the value type
        of the input.One can think of this aligner as a rate but without time
        units; that is, the output is conceptually (second_point -
        first_point).
      ALIGN_RATE: Align and convert to a rate. This alignment is valid for
        cumulative metrics and delta metrics with numeric values. The output
        is a gauge metric with value type DOUBLE.One can think of this aligner
        as conceptually providing the slope of the line that passes through
        the value at the start and end of the window. In other words, this is
        conceptually ((y1 - y0)/(t1 - t0)), and the output unit is one that
        has a "/time" dimension.If, by rate, you are looking for percentage
        change, see the ALIGN_PERCENT_CHANGE aligner option.
      ALIGN_INTERPOLATE: Align by interpolating between adjacent points around
        the period boundary. This alignment is valid for gauge metrics with
        numeric values. The value type of the result is the same as the value
        type of the input.
      ALIGN_NEXT_OLDER: Align by shifting the oldest data point before the
        period boundary to the boundary. This alignment is valid for gauge
        metrics. The value type of the result is the same as the value type of
        the input.
      ALIGN_MIN: Align time series via aggregation. The resulting data point
        in the alignment period is the minimum of all data points in the
        period. This alignment is valid for gauge and delta metrics with
        numeric values. The value type of the result is the same as the value
        type of the input.
      ALIGN_MAX: Align time series via aggregation. The resulting data point
        in the alignment period is the maximum of all data points in the
        period. This alignment is valid for gauge and delta metrics with
        numeric values. The value type of the result is the same as the value
        type of the input.
      ALIGN_MEAN: Align time series via aggregation. The resulting data point
        in the alignment period is the average or arithmetic mean of all data
        points in the period. This alignment is valid for gauge and delta
        metrics with numeric values. The value type of the output is DOUBLE.
      ALIGN_COUNT: Align time series via aggregation. The resulting data point
        in the alignment period is the count of all data points in the period.
        This alignment is valid for gauge and delta metrics with numeric or
        Boolean values. The value type of the output is INT64.
      ALIGN_SUM: Align time series via aggregation. The resulting data point
        in the alignment period is the sum of all data points in the period.
        This alignment is valid for gauge and delta metrics with numeric and
        distribution values. The value type of the output is the same as the
        value type of the input.
      ALIGN_STDDEV: Align time series via aggregation. The resulting data
        point in the alignment period is the standard deviation of all data
        points in the period. This alignment is valid for gauge and delta
        metrics with numeric values. The value type of the output is DOUBLE.
      ALIGN_COUNT_TRUE: Align time series via aggregation. The resulting data
        point in the alignment period is the count of True-valued data points
        in the period. This alignment is valid for gauge metrics with Boolean
        values. The value type of the output is INT64.
      ALIGN_COUNT_FALSE: Align time series via aggregation. The resulting data
        point in the alignment period is the count of False-valued data points
        in the period. This alignment is valid for gauge metrics with Boolean
        values. The value type of the output is INT64.
      ALIGN_FRACTION_TRUE: Align time series via aggregation. The resulting
        data point in the alignment period is the fraction of True-valued data
        points in the period. This alignment is valid for gauge metrics with
        Boolean values. The output value is in the range 0, 1 and has value
        type DOUBLE.
      ALIGN_PERCENTILE_99: Align time series via aggregation. The resulting
        data point in the alignment period is the 99th percentile of all data
        points in the period. This alignment is valid for gauge and delta
        metrics with distribution values. The output is a gauge metric with
        value type DOUBLE.
      ALIGN_PERCENTILE_95: Align time series via aggregation. The resulting
        data point in the alignment period is the 95th percentile of all data
        points in the period. This alignment is valid for gauge and delta
        metrics with distribution values. The output is a gauge metric with
        value type DOUBLE.
      ALIGN_PERCENTILE_50: Align time series via aggregation. The resulting
        data point in the alignment period is the 50th percentile of all data
        points in the period. This alignment is valid for gauge and delta
        metrics with distribution values. The output is a gauge metric with
        value type DOUBLE.
      ALIGN_PERCENTILE_05: Align time series via aggregation. The resulting
        data point in the alignment period is the 5th percentile of all data
        points in the period. This alignment is valid for gauge and delta
        metrics with distribution values. The output is a gauge metric with
        value type DOUBLE.
      ALIGN_PERCENT_CHANGE: Align and convert to a percentage change. This
        alignment is valid for gauge and delta metrics with numeric values.
        This alignment conceptually computes the equivalent of "((current -
        previous)/previous)*100" where previous value is determined based on
        the alignmentPeriod. In the event that previous is 0 the calculated
        value is infinity with the exception that if both (current - previous)
        and previous are 0 the calculated value is 0. A 10 minute moving mean
        is computed at each point of the time window prior to the above
        calculation to smooth the metric and prevent false positives from very
        short lived spikes. Only applicable for data that is >= 0. Any values
        < 0 are treated as no data. While delta metrics are accepted by this
        alignment special care should be taken that the values for the metric
        will always be positive. The output is a gauge metric with value type
        DOUBLE.
    """
    ALIGN_NONE = 0
    ALIGN_DELTA = 1
    ALIGN_RATE = 2
    ALIGN_INTERPOLATE = 3
    ALIGN_NEXT_OLDER = 4
    ALIGN_MIN = 5
    ALIGN_MAX = 6
    ALIGN_MEAN = 7
    ALIGN_COUNT = 8
    ALIGN_SUM = 9
    ALIGN_STDDEV = 10
    ALIGN_COUNT_TRUE = 11
    ALIGN_COUNT_FALSE = 12
    ALIGN_FRACTION_TRUE = 13
    ALIGN_PERCENTILE_99 = 14
    ALIGN_PERCENTILE_95 = 15
    ALIGN_PERCENTILE_50 = 16
    ALIGN_PERCENTILE_05 = 17
    ALIGN_PERCENT_CHANGE = 18

  alignmentPeriod = _messages.StringField(1)
  crossSeriesReducer = _messages.EnumField('CrossSeriesReducerValueValuesEnum', 2)
  groupByFields = _messages.StringField(3, repeated=True)
  perSeriesAligner = _messages.EnumField('PerSeriesAlignerValueValuesEnum', 4)


class AlertPolicy(_messages.Message):
  r"""A description of the conditions under which some aspect of your system
  is considered to be "unhealthy" and the ways to notify people or services
  about this state. For an overview of alert policies, see Introduction to
  Alerting.

  Enums:
    CombinerValueValuesEnum: How to combine the results of multiple conditions
      to determine if an incident should be opened.

  Messages:
    UserLabelsValue: User-supplied key/value data to be used for organizing
      and identifying the AlertPolicy objects.The field can contain up to 64
      entries. Each key and value is limited to 63 Unicode characters or 128
      bytes, whichever is smaller. Labels and values can contain only
      lowercase letters, numerals, underscores, and dashes. Keys must begin
      with a letter.

  Fields:
    combiner: How to combine the results of multiple conditions to determine
      if an incident should be opened.
    conditions: A list of conditions for the policy. The conditions are
      combined by AND or OR according to the combiner field. If the combined
      conditions evaluate to true, then an incident is created. A policy can
      have from one to six conditions.
    creationRecord: A read-only record of the creation of the alerting policy.
      If provided in a call to create or update, this field will be ignored.
    displayName: A short name or phrase used to identify the policy in
      dashboards, notifications, and incidents. To avoid confusion, don't use
      the same display name for multiple policies in the same project. The
      name is limited to 512 Unicode characters.
    documentation: Documentation that is included with notifications and
      incidents related to this policy. Best practice is for the documentation
      to include information to help responders understand, mitigate,
      escalate, and correct the underlying problems detected by the alerting
      policy. Notification channels that have limited capacity might not show
      this documentation.
    enabled: Whether or not the policy is enabled. On write, the default
      interpretation if unset is that the policy is enabled. On read, clients
      should not make any assumption about the state if it has not been
      populated. The field should always be populated on List and Get
      operations, unless a field projection has been specified that strips it
      out.
    mutationRecord: A read-only record of the most recent change to the
      alerting policy. If provided in a call to create or update, this field
      will be ignored.
    name: Required if the policy exists. The resource name for this policy.
      The syntax is: projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
      [ALERT_POLICY_ID] is assigned by Stackdriver Monitoring when the policy
      is created. When calling the alertPolicies.create method, do not include
      the name field in the alerting policy passed as part of the request.
    notificationChannels: Identifies the notification channels to which
      notifications should be sent when incidents are opened or closed or when
      new violations occur on an already opened incident. Each element of this
      array corresponds to the name field in each of the NotificationChannel
      objects that are returned from the ListNotificationChannels method. The
      syntax of the entries in this field is:
      projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
    userLabels: User-supplied key/value data to be used for organizing and
      identifying the AlertPolicy objects.The field can contain up to 64
      entries. Each key and value is limited to 63 Unicode characters or 128
      bytes, whichever is smaller. Labels and values can contain only
      lowercase letters, numerals, underscores, and dashes. Keys must begin
      with a letter.
  """

  class CombinerValueValuesEnum(_messages.Enum):
    r"""How to combine the results of multiple conditions to determine if an
    incident should be opened.

    Values:
      COMBINE_UNSPECIFIED: An unspecified combiner.
      AND: Combine conditions using the logical AND operator. An incident is
        created only if all conditions are met simultaneously. This combiner
        is satisfied if all conditions are met, even if they are met on
        completely different resources.
      OR: Combine conditions using the logical OR operator. An incident is
        created if any of the listed conditions is met.
      AND_WITH_MATCHING_RESOURCE: Combine conditions using logical AND
        operator, but unlike the regular AND option, an incident is created
        only if all conditions are met simultaneously on at least one
        resource.
    """
    COMBINE_UNSPECIFIED = 0
    AND = 1
    OR = 2
    AND_WITH_MATCHING_RESOURCE = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    r"""User-supplied key/value data to be used for organizing and identifying
    the AlertPolicy objects.The field can contain up to 64 entries. Each key
    and value is limited to 63 Unicode characters or 128 bytes, whichever is
    smaller. Labels and values can contain only lowercase letters, numerals,
    underscores, and dashes. Keys must begin with a letter.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type UserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  combiner = _messages.EnumField('CombinerValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  creationRecord = _messages.MessageField('MutationRecord', 3)
  displayName = _messages.StringField(4)
  documentation = _messages.MessageField('Documentation', 5)
  enabled = _messages.BooleanField(6)
  mutationRecord = _messages.MessageField('MutationRecord', 7)
  name = _messages.StringField(8)
  notificationChannels = _messages.StringField(9, repeated=True)
  userLabels = _messages.MessageField('UserLabelsValue', 10)


class BasicAuthentication(_messages.Message):
  r"""A type of authentication to perform against the specified resource or
  URL that uses username and password. Currently, only Basic authentication is
  supported in Uptime Monitoring.

  Fields:
    password: The password to authenticate.
    username: The username to authenticate.
  """

  password = _messages.StringField(1)
  username = _messages.StringField(2)


class BucketOptions(_messages.Message):
  r"""BucketOptions describes the bucket boundaries used to create a histogram
  for the distribution. The buckets can be in a linear sequence, an
  exponential sequence, or each bucket can be specified explicitly.
  BucketOptions does not include the number of values in each bucket.A bucket
  has an inclusive lower bound and exclusive upper bound for the values that
  are counted for that bucket. The upper bound of a bucket must be strictly
  greater than the lower bound. The sequence of N buckets for a distribution
  consists of an underflow bucket (number 0), zero or more finite buckets
  (number 1 through N - 2) and an overflow bucket (number N - 1). The buckets
  are contiguous: the lower bound of bucket i (i > 0) is the same as the upper
  bound of bucket i - 1. The buckets span the whole range of finite values:
  lower bound of the underflow bucket is -infinity and the upper bound of the
  overflow bucket is +infinity. The finite buckets are so-called because both
  bounds are finite.

  Fields:
    explicitBuckets: The explicit buckets.
    exponentialBuckets: The exponential buckets.
    linearBuckets: The linear bucket.
  """

  explicitBuckets = _messages.MessageField('Explicit', 1)
  exponentialBuckets = _messages.MessageField('Exponential', 2)
  linearBuckets = _messages.MessageField('Linear', 3)


class CollectdPayload(_messages.Message):
  r"""A collection of data points sent from a collectd-based plugin. See the
  collectd documentation for more information.

  Messages:
    MetadataValue: The measurement metadata. Example: "process_id" -> 12345

  Fields:
    endTime: The end time of the interval.
    metadata: The measurement metadata. Example: "process_id" -> 12345
    plugin: The name of the plugin. Example: "disk".
    pluginInstance: The instance name of the plugin Example: "hdcl".
    startTime: The start time of the interval.
    type: The measurement type. Example: "memory".
    typeInstance: The measurement type instance. Example: "used".
    values: The measured values during this time interval. Each value must
      have a different dataSourceName.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The measurement metadata. Example: "process_id" -> 12345

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A TypedValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TypedValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  metadata = _messages.MessageField('MetadataValue', 2)
  plugin = _messages.StringField(3)
  pluginInstance = _messages.StringField(4)
  startTime = _messages.StringField(5)
  type = _messages.StringField(6)
  typeInstance = _messages.StringField(7)
  values = _messages.MessageField('CollectdValue', 8, repeated=True)


class CollectdPayloadError(_messages.Message):
  r"""Describes the error status for payloads that were not written.

  Fields:
    error: Records the error status for the payload. If this field is present,
      the partial errors for nested values won't be populated.
    index: The zero-based index in
      CreateCollectdTimeSeriesRequest.collectd_payloads.
    valueErrors: Records the error status for values that were not written due
      to an error.Failed payloads for which nothing is written will not
      include partial value errors.
  """

  error = _messages.MessageField('Status', 1)
  index = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  valueErrors = _messages.MessageField('CollectdValueError', 3, repeated=True)


class CollectdValue(_messages.Message):
  r"""A single data point from a collectd-based plugin.

  Enums:
    DataSourceTypeValueValuesEnum: The type of measurement.

  Fields:
    dataSourceName: The data source for the collectd value. For example there
      are two data sources for network measurements: "rx" and "tx".
    dataSourceType: The type of measurement.
    value: The measurement value.
  """

  class DataSourceTypeValueValuesEnum(_messages.Enum):
    r"""The type of measurement.

    Values:
      UNSPECIFIED_DATA_SOURCE_TYPE: An unspecified data source type. This
        corresponds to
        google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.
      GAUGE: An instantaneous measurement of a varying quantity. This
        corresponds to google.api.MetricDescriptor.MetricKind.GAUGE.
      COUNTER: A cumulative value over time. This corresponds to
        google.api.MetricDescriptor.MetricKind.CUMULATIVE.
      DERIVE: A rate of change of the measurement.
      ABSOLUTE: An amount of change since the last measurement interval. This
        corresponds to google.api.MetricDescriptor.MetricKind.DELTA.
    """
    UNSPECIFIED_DATA_SOURCE_TYPE = 0
    GAUGE = 1
    COUNTER = 2
    DERIVE = 3
    ABSOLUTE = 4

  dataSourceName = _messages.StringField(1)
  dataSourceType = _messages.EnumField('DataSourceTypeValueValuesEnum', 2)
  value = _messages.MessageField('TypedValue', 3)


class CollectdValueError(_messages.Message):
  r"""Describes the error status for values that were not written.

  Fields:
    error: Records the error status for the value.
    index: The zero-based index in CollectdPayload.values within the parent
      CreateCollectdTimeSeriesRequest.collectd_payloads.
  """

  error = _messages.MessageField('Status', 1)
  index = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Condition(_messages.Message):
  r"""A condition is a true/false test that determines when an alerting policy
  should open an incident. If a condition evaluates to true, it signifies that
  something is wrong.

  Fields:
    conditionAbsent: A condition that checks that a time series continues to
      receive new data points.
    conditionThreshold: A condition that compares a time series against a
      threshold.
    displayName: A short name or phrase used to identify the condition in
      dashboards, notifications, and incidents. To avoid confusion, don't use
      the same display name for multiple conditions in the same policy.
    name: Required if the condition exists. The unique resource name for this
      condition. Its syntax is: projects/[PROJECT_ID]/alertPolicies/[POLICY_ID
      ]/conditions/[CONDITION_ID] [CONDITION_ID] is assigned by Stackdriver
      Monitoring when the condition is created as part of a new or updated
      alerting policy.When calling the alertPolicies.create method, do not
      include the name field in the conditions of the requested alerting
      policy. Stackdriver Monitoring creates the condition identifiers and
      includes them in the new policy.When calling the alertPolicies.update
      method to update a policy, including a condition name causes the
      existing condition to be updated. Conditions without names are added to
      the updated policy. Existing conditions are deleted if they are not
      updated.Best practice is to preserve [CONDITION_ID] if you make only
      small changes, such as those to condition thresholds, durations, or
      trigger values. Otherwise, treat the change as a new condition and let
      the existing condition be deleted.
  """

  conditionAbsent = _messages.MessageField('MetricAbsence', 1)
  conditionThreshold = _messages.MessageField('MetricThreshold', 2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)


class ContentMatcher(_messages.Message):
  r"""Used to perform string matching. Currently, this matches on the exact
  content. In the future, it can be expanded to allow for regular expressions
  and more complex matching.

  Fields:
    content: String content to match (max 1024 bytes)
  """

  content = _messages.StringField(1)


class CreateCollectdTimeSeriesRequest(_messages.Message):
  r"""The CreateCollectdTimeSeries request.

  Fields:
    collectdPayloads: The collectd payloads representing the time series data.
      You must not include more than a single point for each time series, so
      no two payloads can have the same values for all of the fields plugin,
      plugin_instance, type, and type_instance.
    collectdVersion: The version of collectd that collected the data. Example:
      "5.3.0-192.el6".
    resource: The monitored resource associated with the time series.
  """

  collectdPayloads = _messages.MessageField('CollectdPayload', 1, repeated=True)
  collectdVersion = _messages.StringField(2)
  resource = _messages.MessageField('MonitoredResource', 3)


class CreateCollectdTimeSeriesResponse(_messages.Message):
  r"""The CreateCollectdTimeSeries response.

  Fields:
    payloadErrors: Records the error status for points that were not written
      due to an error.Failed requests for which nothing is written will return
      an error response instead.
  """

  payloadErrors = _messages.MessageField('CollectdPayloadError', 1, repeated=True)


class CreateTimeSeriesRequest(_messages.Message):
  r"""The CreateTimeSeries request.

  Fields:
    timeSeries: The new data to be added to a list of time series. Adds at
      most one data point to each of several time series. The new data point
      must be more recent than any other point in its time series. Each
      TimeSeries value must fully specify a unique time series by supplying
      all label values for the metric and the monitored resource.
  """

  timeSeries = _messages.MessageField('TimeSeries', 1, repeated=True)


class Distribution(_messages.Message):
  r"""Distribution contains summary statistics for a population of values. It
  optionally contains a histogram representing the distribution of those
  values across a set of buckets.The summary statistics are the count, mean,
  sum of the squared deviation from the mean, the minimum, and the maximum of
  the set of population of values. The histogram is based on a sequence of
  buckets and gives a count of values that fall into each bucket. The
  boundaries of the buckets are given either explicitly or by formulas for
  buckets of fixed or exponentially increasing widths.Although it is not
  forbidden, it is generally a bad idea to include non-finite values
  (infinities or NaNs) in the population of values, as this will render the
  mean and sum_of_squared_deviation fields meaningless.

  Fields:
    bucketCounts: Required in the Stackdriver Monitoring API v3. The values
      for each bucket specified in bucket_options. The sum of the values in
      bucketCounts must equal the value in the count field of the Distribution
      object. The order of the bucket counts follows the numbering schemes
      described for the three bucket types. The underflow bucket has number 0;
      the finite buckets, if any, have numbers 1 through N-2; and the overflow
      bucket has number N-1. The size of bucket_counts must not be greater
      than N. If the size is less than N, then the remaining buckets are
      assigned values of zero.
    bucketOptions: Required in the Stackdriver Monitoring API v3. Defines the
      histogram bucket boundaries.
    count: The number of values in the population. Must be non-negative. This
      value must equal the sum of the values in bucket_counts if a histogram
      is provided.
    mean: The arithmetic mean of the values in the population. If count is
      zero then this field must be zero.
    range: If specified, contains the range of the population values. The
      field must not be present if the count is zero. This field is presently
      ignored by the Stackdriver Monitoring API v3.
    sumOfSquaredDeviation: The sum of squared deviations from the mean of the
      values in the population. For values x_i this is: Sum[i=1..n]((x_i -
      mean)^2) Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd
      edition describes Welford's method for accumulating this sum in one
      pass.If count is zero then this field must be zero.
  """

  bucketCounts = _messages.IntegerField(1, repeated=True)
  bucketOptions = _messages.MessageField('BucketOptions', 2)
  count = _messages.IntegerField(3)
  mean = _messages.FloatField(4)
  range = _messages.MessageField('Range', 5)
  sumOfSquaredDeviation = _messages.FloatField(6)


class Documentation(_messages.Message):
  r"""A content string and a MIME type that describes the content string's
  format.

  Fields:
    content: The text of the documentation, interpreted according to
      mime_type. The content may not exceed 8,192 Unicode characters and may
      not exceed more than 10,240 bytes when encoded in UTF-8 format,
      whichever is smaller.
    mimeType: The format of the content field. Presently, only the value
      "text/markdown" is supported. See Markdown
      (https://en.wikipedia.org/wiki/Markdown) for more information.
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo {   rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for Empty is empty JSON object {}.
  """



class Explicit(_messages.Message):
  r"""Specifies a set of buckets with arbitrary widths.There are size(bounds)
  + 1 (= N) buckets. Bucket i has the following boundaries:Upper bound (0 <= i
  < N-1): boundsi  Lower bound (1 <= i < N); boundsi - 1The bounds field must
  contain at least one element. If bounds has only one element, then there are
  no finite buckets, and that single element is the common boundary of the
  overflow and underflow buckets.

  Fields:
    bounds: The values must be monotonically increasing.
  """

  bounds = _messages.FloatField(1, repeated=True)


class Exponential(_messages.Message):
  r"""Specifies an exponential sequence of buckets that have a width that is
  proportional to the value of the lower bound. Each bucket represents a
  constant relative uncertainty on a specific value in the bucket.There are
  num_finite_buckets + 2 (= N) buckets. Bucket i has the following
  boundaries:Upper bound (0 <= i < N-1): scale * (growth_factor ^ i).  Lower
  bound (1 <= i < N): scale * (growth_factor ^ (i - 1)).

  Fields:
    growthFactor: Must be greater than 1.
    numFiniteBuckets: Must be greater than 0.
    scale: Must be greater than 0.
  """

  growthFactor = _messages.FloatField(1)
  numFiniteBuckets = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  scale = _messages.FloatField(3)


class Field(_messages.Message):
  r"""A single field of a message type.

  Enums:
    CardinalityValueValuesEnum: The field cardinality.
    KindValueValuesEnum: The field type.

  Fields:
    cardinality: The field cardinality.
    defaultValue: The string value of the default value of this field. Proto2
      syntax only.
    jsonName: The field JSON name.
    kind: The field type.
    name: The field name.
    number: The field number.
    oneofIndex: The index of the field type in Type.oneofs, for message or
      enumeration types. The first type has index 1; zero means the type is
      not in the list.
    options: The protocol buffer options.
    packed: Whether to use alternative packed wire representation.
    typeUrl: The field type URL, without the scheme, for message or
      enumeration types. Example:
      "type.googleapis.com/google.protobuf.Timestamp".
  """

  class CardinalityValueValuesEnum(_messages.Enum):
    r"""The field cardinality.

    Values:
      CARDINALITY_UNKNOWN: For fields with unknown cardinality.
      CARDINALITY_OPTIONAL: For optional fields.
      CARDINALITY_REQUIRED: For required fields. Proto2 syntax only.
      CARDINALITY_REPEATED: For repeated fields.
    """
    CARDINALITY_UNKNOWN = 0
    CARDINALITY_OPTIONAL = 1
    CARDINALITY_REQUIRED = 2
    CARDINALITY_REPEATED = 3

  class KindValueValuesEnum(_messages.Enum):
    r"""The field type.

    Values:
      TYPE_UNKNOWN: Field type unknown.
      TYPE_DOUBLE: Field type double.
      TYPE_FLOAT: Field type float.
      TYPE_INT64: Field type int64.
      TYPE_UINT64: Field type uint64.
      TYPE_INT32: Field type int32.
      TYPE_FIXED64: Field type fixed64.
      TYPE_FIXED32: Field type fixed32.
      TYPE_BOOL: Field type bool.
      TYPE_STRING: Field type string.
      TYPE_GROUP: Field type group. Proto2 syntax only, and deprecated.
      TYPE_MESSAGE: Field type message.
      TYPE_BYTES: Field type bytes.
      TYPE_UINT32: Field type uint32.
      TYPE_ENUM: Field type enum.
      TYPE_SFIXED32: Field type sfixed32.
      TYPE_SFIXED64: Field type sfixed64.
      TYPE_SINT32: Field type sint32.
      TYPE_SINT64: Field type sint64.
    """
    TYPE_UNKNOWN = 0
    TYPE_DOUBLE = 1
    TYPE_FLOAT = 2
    TYPE_INT64 = 3
    TYPE_UINT64 = 4
    TYPE_INT32 = 5
    TYPE_FIXED64 = 6
    TYPE_FIXED32 = 7
    TYPE_BOOL = 8
    TYPE_STRING = 9
    TYPE_GROUP = 10
    TYPE_MESSAGE = 11
    TYPE_BYTES = 12
    TYPE_UINT32 = 13
    TYPE_ENUM = 14
    TYPE_SFIXED32 = 15
    TYPE_SFIXED64 = 16
    TYPE_SINT32 = 17
    TYPE_SINT64 = 18

  cardinality = _messages.EnumField('CardinalityValueValuesEnum', 1)
  defaultValue = _messages.StringField(2)
  jsonName = _messages.StringField(3)
  kind = _messages.EnumField('KindValueValuesEnum', 4)
  name = _messages.StringField(5)
  number = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  oneofIndex = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  options = _messages.MessageField('Option', 8, repeated=True)
  packed = _messages.BooleanField(9)
  typeUrl = _messages.StringField(10)


class GetNotificationChannelVerificationCodeRequest(_messages.Message):
  r"""The GetNotificationChannelVerificationCode request.

  Fields:
    expireTime: The desired expiration time. If specified, the API will
      guarantee that the returned code will not be valid after the specified
      timestamp; however, the API cannot guarantee that the returned code will
      be valid for at least as long as the requested time (the API puts an
      upper bound on the amount of time for which a code may be valid). If
      omitted, a default expiration will be used, which may be less than the
      max permissible expiration (so specifying an expiration may extend the
      code's lifetime over omitting an expiration, even though the API does
      impose an upper limit on the maximum expiration that is permitted).
  """

  expireTime = _messages.StringField(1)


class GetNotificationChannelVerificationCodeResponse(_messages.Message):
  r"""The GetNotificationChannelVerificationCode request.

  Fields:
    code: The verification code, which may be used to verify other channels
      that have an equivalent identity (i.e. other channels of the same type
      with the same fingerprint such as other email channels with the same
      email address or other sms channels with the same number).
    expireTime: The expiration time associated with the code that was
      returned. If an expiration was provided in the request, this is the
      minimum of the requested expiration in the request and the max permitted
      expiration.
  """

  code = _messages.StringField(1)
  expireTime = _messages.StringField(2)


class Group(_messages.Message):
  r"""The description of a dynamic collection of monitored resources. Each
  group has a filter that is matched against monitored resources and their
  associated metadata. If a group's filter matches an available monitored
  resource, then that resource is a member of that group. Groups can contain
  any number of monitored resources, and each monitored resource can be a
  member of any number of groups.Groups can be nested in parent-child
  hierarchies. The parentName field identifies an optional parent for each
  group. If a group has a parent, then the only monitored resources available
  to be matched by the group's filter are the resources contained in the
  parent group. In other words, a group contains the monitored resources that
  match its filter and the filters of all the group's ancestors. A group
  without a parent can contain any monitored resource.For example, consider an
  infrastructure running a set of instances with two user-defined tags:
  "environment" and "role". A parent group has a filter,
  environment="production". A child of that parent group has a filter,
  role="transcoder". The parent group contains all instances in the production
  environment, regardless of their roles. The child group contains instances
  that have the transcoder role and are in the production environment.The
  monitored resources contained in a group can change at any moment, depending
  on what resources exist and what filters are associated with the group and
  its ancestors.

  Fields:
    displayName: A user-assigned name for this group, used only for display
      purposes.
    filter: The filter used to determine which monitored resources belong to
      this group.
    isCluster: If true, the members of this group are considered to be a
      cluster. The system can perform additional analysis on groups that are
      clusters.
    name: Output only. The name of this group. The format is
      "projects/{project_id_or_number}/groups/{group_id}". When creating a
      group, this field is ignored and a new name is created consisting of the
      project specified in the call to CreateGroup and a unique {group_id}
      that is generated automatically.
    parentName: The name of the group's parent, if it has one. The format is
      "projects/{project_id_or_number}/groups/{group_id}". For groups with no
      parent, parentName is the empty string, "".
  """

  displayName = _messages.StringField(1)
  filter = _messages.StringField(2)
  isCluster = _messages.BooleanField(3)
  name = _messages.StringField(4)
  parentName = _messages.StringField(5)


class HttpCheck(_messages.Message):
  r"""Information involved in an HTTP/HTTPS uptime check request.

  Messages:
    HeadersValue: The list of headers to send as part of the uptime check
      request. If two headers have the same key and different values, they
      should be entered as a single header, with the value being a comma-
      separated list of all the desired values as described at
      https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two
      separate headers with the same key in a Create call will cause the first
      to be overwritten by the second. The maximum number of headers allowed
      is 100.

  Fields:
    authInfo: The authentication information. Optional when creating an HTTP
      check; defaults to empty.
    headers: The list of headers to send as part of the uptime check request.
      If two headers have the same key and different values, they should be
      entered as a single header, with the value being a comma-separated list
      of all the desired values as described at
      https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two
      separate headers with the same key in a Create call will cause the first
      to be overwritten by the second. The maximum number of headers allowed
      is 100.
    maskHeaders: Boolean specifiying whether to encrypt the header
      information. Encryption should be specified for any headers related to
      authentication that you do not wish to be seen when retrieving the
      configuration. The server will be responsible for encrypting the
      headers. On Get/List calls, if mask_headers is set to True then the
      headers will be obscured with ******.
    path: The path to the page to run the check against. Will be combined with
      the host (specified within the MonitoredResource) and port to construct
      the full URL. Optional (defaults to "/").
    port: The port to the page to run the check against. Will be combined with
      host (specified within the MonitoredResource) and path to construct the
      full URL. Optional (defaults to 80 without SSL, or 443 with SSL).
    useSsl: If true, use HTTPS instead of HTTP to run the check.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HeadersValue(_messages.Message):
    r"""The list of headers to send as part of the uptime check request. If
    two headers have the same key and different values, they should be entered
    as a single header, with the value being a comma-separated list of all the
    desired values as described at
    https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two
    separate headers with the same key in a Create call will cause the first
    to be overwritten by the second. The maximum number of headers allowed is
    100.

    Messages:
      AdditionalProperty: An additional property for a HeadersValue object.

    Fields:
      additionalProperties: Additional properties of type HeadersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  authInfo = _messages.MessageField('BasicAuthentication', 1)
  headers = _messages.MessageField('HeadersValue', 2)
  maskHeaders = _messages.BooleanField(3)
  path = _messages.StringField(4)
  port = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  useSsl = _messages.BooleanField(6)


class InternalChecker(_messages.Message):
  r"""Nimbus InternalCheckers.

  Fields:
    checkerId: The checker ID.
    displayName: The checker's human-readable name.
    gcpZone: The GCP zone the uptime check should egress from. Only respected
      for internal uptime checks, where internal_network is specified.
    network: The internal network to perform this uptime check on.
    projectId: The GCP project ID. Not necessarily the same as the project_id
      for the config.
  """

  checkerId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  gcpZone = _messages.StringField(3)
  network = _messages.StringField(4)
  projectId = _messages.StringField(5)


class LabelDescriptor(_messages.Message):
  r"""A description of a label.

  Enums:
    ValueTypeValueValuesEnum: The type of data that can be assigned to the
      label.

  Fields:
    description: A human-readable description for the label.
    key: The label key.
    valueType: The type of data that can be assigned to the label.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""The type of data that can be assigned to the label.

    Values:
      STRING: A variable-length string. This is the default.
      BOOL: Boolean; true or false.
      INT64: A 64-bit signed integer.
    """
    STRING = 0
    BOOL = 1
    INT64 = 2

  description = _messages.StringField(1)
  key = _messages.StringField(2)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 3)


class Linear(_messages.Message):
  r"""Specifies a linear sequence of buckets that all have the same width
  (except overflow and underflow). Each bucket represents a constant absolute
  uncertainty on the specific value in the bucket.There are num_finite_buckets
  + 2 (= N) buckets. Bucket i has the following boundaries:Upper bound (0 <= i
  < N-1): offset + (width * i).  Lower bound (1 <= i < N): offset + (width *
  (i - 1)).

  Fields:
    numFiniteBuckets: Must be greater than 0.
    offset: Lower bound of the first bucket.
    width: Must be greater than 0.
  """

  numFiniteBuckets = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  offset = _messages.FloatField(2)
  width = _messages.FloatField(3)


class ListAlertPoliciesResponse(_messages.Message):
  r"""The protocol for the ListAlertPolicies response.

  Fields:
    alertPolicies: The returned alert policies.
    nextPageToken: If there might be more results than were returned, then
      this field is set to a non-empty value. To see the additional results,
      use that value as pageToken in the next call to this method.
  """

  alertPolicies = _messages.MessageField('AlertPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGroupMembersResponse(_messages.Message):
  r"""The ListGroupMembers response.

  Fields:
    members: A set of monitored resources in the group.
    nextPageToken: If there are more results than have been returned, then
      this field is set to a non-empty value. To see the additional results,
      use that value as pageToken in the next call to this method.
    totalSize: The total number of elements matching this request.
  """

  members = _messages.MessageField('MonitoredResource', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  totalSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ListGroupsResponse(_messages.Message):
  r"""The ListGroups response.

  Fields:
    group: The groups that match the specified filters.
    nextPageToken: If there are more results than have been returned, then
      this field is set to a non-empty value. To see the additional results,
      use that value as pageToken in the next call to this method.
  """

  group = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMetricDescriptorsResponse(_messages.Message):
  r"""The ListMetricDescriptors response.

  Fields:
    metricDescriptors: The metric descriptors that are available to the
      project and that match the value of filter, if present.
    nextPageToken: If there are more results than have been returned, then
      this field is set to a non-empty value. To see the additional results,
      use that value as pageToken in the next call to this method.
  """

  metricDescriptors = _messages.MessageField('MetricDescriptor', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMonitoredResourceDescriptorsResponse(_messages.Message):
  r"""The ListMonitoredResourceDescriptors response.

  Fields:
    nextPageToken: If there are more results than have been returned, then
      this field is set to a non-empty value. To see the additional results,
      use that value as pageToken in the next call to this method.
    resourceDescriptors: The monitored resource descriptors that are available
      to this project and that match filter, if present.
  """

  nextPageToken = _messages.StringField(1)
  resourceDescriptors = _messages.MessageField('MonitoredResourceDescriptor', 2, repeated=True)


class ListNotificationChannelDescriptorsResponse(_messages.Message):
  r"""The ListNotificationChannelDescriptors response.

  Fields:
    channelDescriptors: The monitored resource descriptors supported for the
      specified project, optionally filtered.
    nextPageToken: If not empty, indicates that there may be more results that
      match the request. Use the value in the page_token field in a subsequent
      request to fetch the next set of results. If empty, all results have
      been returned.
  """

  channelDescriptors = _messages.MessageField('NotificationChannelDescriptor', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListNotificationChannelsResponse(_messages.Message):
  r"""The ListNotificationChannels response.

  Fields:
    nextPageToken: If not empty, indicates that there may be more results that
      match the request. Use the value in the page_token field in a subsequent
      request to fetch the next set of results. If empty, all results have
      been returned.
    notificationChannels: The notification channels defined for the specified
      project.
  """

  nextPageToken = _messages.StringField(1)
  notificationChannels = _messages.MessageField('NotificationChannel', 2, repeated=True)


class ListTimeSeriesResponse(_messages.Message):
  r"""The ListTimeSeries response.

  Fields:
    nextPageToken: If there are more results than have been returned, then
      this field is set to a non-empty value. To see the additional results,
      use that value as pageToken in the next call to this method.
    timeSeries: One or more time series that match the filter included in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  timeSeries = _messages.MessageField('TimeSeries', 2, repeated=True)


class ListUptimeCheckConfigsResponse(_messages.Message):
  r"""The protocol for the ListUptimeCheckConfigs response.

  Fields:
    nextPageToken: This field represents the pagination token to retrieve the
      next page of results. If the value is empty, it means no further results
      for the request. To retrieve the next page of results, the value of the
      next_page_token is passed to the subsequent List method call (in the
      request message's page_token field).
    totalSize: The total number of uptime check configurations for the
      project, irrespective of any pagination.
    uptimeCheckConfigs: The returned uptime check configurations.
  """

  nextPageToken = _messages.StringField(1)
  totalSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  uptimeCheckConfigs = _messages.MessageField('UptimeCheckConfig', 3, repeated=True)


class ListUptimeCheckIpsResponse(_messages.Message):
  r"""The protocol for the ListUptimeCheckIps response.

  Fields:
    nextPageToken: This field represents the pagination token to retrieve the
      next page of results. If the value is empty, it means no further results
      for the request. To retrieve the next page of results, the value of the
      next_page_token is passed to the subsequent List method call (in the
      request message's page_token field). NOTE: this field is not yet
      implemented
    uptimeCheckIps: The returned list of IP addresses (including region and
      location) that the checkers run from.
  """

  nextPageToken = _messages.StringField(1)
  uptimeCheckIps = _messages.MessageField('UptimeCheckIp', 2, repeated=True)


class Metric(_messages.Message):
  r"""A specific metric, identified by specifying values for all of the labels
  of a MetricDescriptor.

  Messages:
    LabelsValue: The set of label values that uniquely identify this metric.
      All labels listed in the MetricDescriptor must be assigned values.

  Fields:
    labels: The set of label values that uniquely identify this metric. All
      labels listed in the MetricDescriptor must be assigned values.
    type: An existing metric type, see google.api.MetricDescriptor. For
      example, custom.googleapis.com/invoice/paid/amount.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The set of label values that uniquely identify this metric. All labels
    listed in the MetricDescriptor must be assigned values.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  type = _messages.StringField(2)


class MetricAbsence(_messages.Message):
  r"""A condition type that checks that monitored resources are reporting
  data. The configuration defines a metric and a set of monitored resources.
  The predicate is considered in violation when a time series for the
  specified metric of a monitored resource does not include any data in the
  specified duration.

  Fields:
    aggregations: Specifies the alignment of data points in individual time
      series as well as how to combine the retrieved time series together
      (such as when aggregating multiple streams on each resource to a single
      stream for each resource or when aggregating streams across all members
      of a group of resrouces). Multiple aggregations are applied in the order
      specified.This field is similar to the one in the
      MetricService.ListTimeSeries request. It is advisable to use the
      ListTimeSeries method when debugging this field.
    duration: The amount of time that a time series must fail to report new
      data to be considered failing. Currently, only values that are a
      multiple of a minute--e.g. 60, 120, or 300 seconds--are supported. If an
      invalid value is given, an error will be returned. The Duration.nanos
      field is ignored.
    filter: A filter that identifies which time series should be compared with
      the threshold.The filter is similar to the one that is specified in the
      MetricService.ListTimeSeries request (that call is useful to verify the
      time series that will be retrieved / processed) and must specify the
      metric type and optionally may contain restrictions on resource type,
      resource labels, and metric labels. This field may not exceed 2048
      Unicode characters in length.
    trigger: The number/percent of time series for which the comparison must
      hold in order for the condition to trigger. If unspecified, then the
      condition will trigger if the comparison is true for any of the time
      series that have been identified by filter and aggregations.
  """

  aggregations = _messages.MessageField('Aggregation', 1, repeated=True)
  duration = _messages.StringField(2)
  filter = _messages.StringField(3)
  trigger = _messages.MessageField('Trigger', 4)


class MetricDescriptor(_messages.Message):
  r"""Defines a metric type and its schema. Once a metric descriptor is
  created, deleting or altering it stops data collection and makes the metric
  type's existing data unusable.

  Enums:
    MetricKindValueValuesEnum: Whether the metric records instantaneous
      values, changes to a value, etc. Some combinations of metric_kind and
      value_type might not be supported.
    ValueTypeValueValuesEnum: Whether the measurement is an integer, a
      floating-point number, etc. Some combinations of metric_kind and
      value_type might not be supported.

  Fields:
    description: A detailed description of the metric, which can be used in
      documentation.
    displayName: A concise name for the metric, which can be displayed in user
      interfaces. Use sentence case without an ending period, for example
      "Request count". This field is optional but it is recommended to be set
      for any metrics associated with user-visible concepts, such as Quota.
    labels: The set of labels that can be used to describe a specific instance
      of this metric type. For example, the
      appengine.googleapis.com/http/server/response_latencies metric type has
      a label for the HTTP response code, response_code, so you can look at
      latencies for successful responses or just for responses that failed.
    metricKind: Whether the metric records instantaneous values, changes to a
      value, etc. Some combinations of metric_kind and value_type might not be
      supported.
    name: The resource name of the metric descriptor.
    type: The metric type, including its DNS name prefix. The type is not URL-
      encoded. All user-defined custom metric types have the DNS name
      custom.googleapis.com. Metric types should use a natural hierarchical
      grouping. For example: "custom.googleapis.com/invoice/paid/amount"
      "appengine.googleapis.com/http/server/response_latencies"
    unit: Optional. The unit in which the metric value is reported. For
      example, kBy/s means kilobytes/sec, and 1 is the dimensionless unit. The
      supported units are a subset of The Unified Code for Units of Measure
      standard (http://unitsofmeasure.org/ucum.html).<br><br> This field is
      part of the metric's documentation, but it is ignored by Stackdriver.
    valueType: Whether the measurement is an integer, a floating-point number,
      etc. Some combinations of metric_kind and value_type might not be
      supported.
  """

  class MetricKindValueValuesEnum(_messages.Enum):
    r"""Whether the metric records instantaneous values, changes to a value,
    etc. Some combinations of metric_kind and value_type might not be
    supported.

    Values:
      METRIC_KIND_UNSPECIFIED: Do not use this default value.
      GAUGE: An instantaneous measurement of a value.
      DELTA: The change in a value during a time interval.
      CUMULATIVE: A value accumulated over a time interval. Cumulative
        measurements in a time series should have the same start time and
        increasing end times, until an event resets the cumulative value to
        zero and sets a new start time for the following points.
    """
    METRIC_KIND_UNSPECIFIED = 0
    GAUGE = 1
    DELTA = 2
    CUMULATIVE = 3

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Whether the measurement is an integer, a floating-point number, etc.
    Some combinations of metric_kind and value_type might not be supported.

    Values:
      VALUE_TYPE_UNSPECIFIED: Do not use this default value.
      BOOL: The value is a boolean. This value type can be used only if the
        metric kind is GAUGE.
      INT64: The value is a signed 64-bit integer.
      DOUBLE: The value is a double precision floating point number.
      STRING: The value is a text string. This value type can be used only if
        the metric kind is GAUGE.
      DISTRIBUTION: The value is a Distribution.
      MONEY: The value is money.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    BOOL = 1
    INT64 = 2
    DOUBLE = 3
    STRING = 4
    DISTRIBUTION = 5
    MONEY = 6

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  metricKind = _messages.EnumField('MetricKindValueValuesEnum', 4)
  name = _messages.StringField(5)
  type = _messages.StringField(6)
  unit = _messages.StringField(7)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 8)


class MetricThreshold(_messages.Message):
  r"""A condition type that compares a collection of time series against a
  threshold.

  Enums:
    ComparisonValueValuesEnum: The comparison to apply between the time series
      (indicated by filter and aggregation) and the threshold (indicated by
      threshold_value). The comparison is applied on each time series, with
      the time series on the left-hand side and the threshold on the right-
      hand side.Only COMPARISON_LT and COMPARISON_GT are supported currently.

  Fields:
    aggregations: Specifies the alignment of data points in individual time
      series as well as how to combine the retrieved time series together
      (such as when aggregating multiple streams on each resource to a single
      stream for each resource or when aggregating streams across all members
      of a group of resrouces). Multiple aggregations are applied in the order
      specified.This field is similar to the one in the
      MetricService.ListTimeSeries request. It is advisable to use the
      ListTimeSeries method when debugging this field.
    comparison: The comparison to apply between the time series (indicated by
      filter and aggregation) and the threshold (indicated by
      threshold_value). The comparison is applied on each time series, with
      the time series on the left-hand side and the threshold on the right-
      hand side.Only COMPARISON_LT and COMPARISON_GT are supported currently.
    denominatorAggregations: Specifies the alignment of data points in
      individual time series selected by denominatorFilter as well as how to
      combine the retrieved time series together (such as when aggregating
      multiple streams on each resource to a single stream for each resource
      or when aggregating streams across all members of a group of
      resources).When computing ratios, the aggregations and
      denominator_aggregations fields must use the same alignment period and
      produce time series that have the same periodicity and labels.This field
      is similar to the one in the MetricService.ListTimeSeries request. It is
      advisable to use the ListTimeSeries method when debugging this field.
    denominatorFilter: A filter that identifies a time series that should be
      used as the denominator of a ratio that will be compared with the
      threshold. If a denominator_filter is specified, the time series
      specified by the filter field will be used as the numerator.The filter
      is similar to the one that is specified in the
      MetricService.ListTimeSeries request (that call is useful to verify the
      time series that will be retrieved / processed) and must specify the
      metric type and optionally may contain restrictions on resource type,
      resource labels, and metric labels. This field may not exceed 2048
      Unicode characters in length.
    duration: The amount of time that a time series must violate the threshold
      to be considered failing. Currently, only values that are a multiple of
      a minute--e.g. 60, 120, or 300 seconds--are supported. If an invalid
      value is given, an error will be returned. The Duration.nanos field is
      ignored. When choosing a duration, it is useful to keep in mind the
      frequency of the underlying time series data (which may also be affected
      by any alignments specified in the aggregation field); a good duration
      is long enough so that a single outlier does not generate spurious
      alerts, but short enough that unhealthy states are detected and alerted
      on quickly.
    filter: A filter that identifies which time series should be compared with
      the threshold.The filter is similar to the one that is specified in the
      MetricService.ListTimeSeries request (that call is useful to verify the
      time series that will be retrieved / processed) and must specify the
      metric type and optionally may contain restrictions on resource type,
      resource labels, and metric labels. This field may not exceed 2048
      Unicode characters in length.
    thresholdValue: A value against which to compare the time series.
    trigger: The number/percent of time series for which the comparison must
      hold in order for the condition to trigger. If unspecified, then the
      condition will trigger if the comparison is true for any of the time
      series that have been identified by filter and aggregations, or by the
      ratio, if denominator_filter and denominator_aggregations are specified.
  """

  class ComparisonValueValuesEnum(_messages.Enum):
    r"""The comparison to apply between the time series (indicated by filter
    and aggregation) and the threshold (indicated by threshold_value). The
    comparison is applied on each time series, with the time series on the
    left-hand side and the threshold on the right-hand side.Only COMPARISON_LT
    and COMPARISON_GT are supported currently.

    Values:
      COMPARISON_UNSPECIFIED: No ordering relationship is specified.
      COMPARISON_GT: The left argument is greater than the right argument.
      COMPARISON_GE: The left argument is greater than or equal to the right
        argument.
      COMPARISON_LT: The left argument is less than the right argument.
      COMPARISON_LE: The left argument is less than or equal to the right
        argument.
      COMPARISON_EQ: The left argument is equal to the right argument.
      COMPARISON_NE: The left argument is not equal to the right argument.
    """
    COMPARISON_UNSPECIFIED = 0
    COMPARISON_GT = 1
    COMPARISON_GE = 2
    COMPARISON_LT = 3
    COMPARISON_LE = 4
    COMPARISON_EQ = 5
    COMPARISON_NE = 6

  aggregations = _messages.MessageField('Aggregation', 1, repeated=True)
  comparison = _messages.EnumField('ComparisonValueValuesEnum', 2)
  denominatorAggregations = _messages.MessageField('Aggregation', 3, repeated=True)
  denominatorFilter = _messages.StringField(4)
  duration = _messages.StringField(5)
  filter = _messages.StringField(6)
  thresholdValue = _messages.FloatField(7)
  trigger = _messages.MessageField('Trigger', 8)


class MonitoredResource(_messages.Message):
  r"""An object representing a resource that can be used for monitoring,
  logging, billing, or other purposes. Examples include virtual machine
  instances, databases, and storage devices such as disks. The type field
  identifies a MonitoredResourceDescriptor object that describes the
  resource's schema. Information in the labels field identifies the actual
  resource and its attributes according to the schema. For example, a
  particular Compute Engine VM instance could be represented by the following
  object, because the MonitoredResourceDescriptor for "gce_instance" has
  labels "instance_id" and "zone": { "type": "gce_instance",   "labels": {
  "instance_id": "12345678901234",               "zone": "us-central1-a" }}

  Messages:
    LabelsValue: Required. Values for all of the labels listed in the
      associated monitored resource descriptor. For example, Compute Engine VM
      instances use the labels "project_id", "instance_id", and "zone".

  Fields:
    labels: Required. Values for all of the labels listed in the associated
      monitored resource descriptor. For example, Compute Engine VM instances
      use the labels "project_id", "instance_id", and "zone".
    type: Required. The monitored resource type. This field must match the
      type field of a MonitoredResourceDescriptor object. For example, the
      type of a Compute Engine VM instance is gce_instance.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Required. Values for all of the labels listed in the associated
    monitored resource descriptor. For example, Compute Engine VM instances
    use the labels "project_id", "instance_id", and "zone".

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  type = _messages.StringField(2)


class MonitoredResourceDescriptor(_messages.Message):
  r"""An object that describes the schema of a MonitoredResource object using
  a type name and a set of labels. For example, the monitored resource
  descriptor for Google Compute Engine VM instances has a type of
  "gce_instance" and specifies the use of the labels "instance_id" and "zone"
  to identify particular VM instances.Different APIs can support different
  monitored resource types. APIs generally provide a list method that returns
  the monitored resource descriptors used by the API.

  Fields:
    description: Optional. A detailed description of the monitored resource
      type that might be used in documentation.
    displayName: Optional. A concise name for the monitored resource type that
      might be displayed in user interfaces. It should be a Title Cased Noun
      Phrase, without any article or other determiners. For example, "Google
      Cloud SQL Database".
    labels: Required. A set of labels used to describe instances of this
      monitored resource type. For example, an individual Google Cloud SQL
      database is identified by values for the labels "database_id" and
      "zone".
    name: Optional. The resource name of the monitored resource descriptor:
      "projects/{project_id}/monitoredResourceDescriptors/{type}" where {type}
      is the value of the type field in this object and {project_id} is a
      project ID that provides API-specific context for accessing the type.
      APIs that do not use project information can use the resource name
      format "monitoredResourceDescriptors/{type}".
    type: Required. The monitored resource type. For example, the type
      "cloudsql_database" represents databases in Google Cloud SQL. The
      maximum length of this value is 256 characters.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  name = _messages.StringField(4)
  type = _messages.StringField(5)


class MonitoredResourceMetadata(_messages.Message):
  r"""Auxiliary metadata for a MonitoredResource object. MonitoredResource
  objects contain the minimum set of information to uniquely identify a
  monitored resource instance. There is some other useful auxiliary metadata.
  Google Stackdriver Monitoring & Logging uses an ingestion pipeline to
  extract metadata for cloud resources of all types , and stores the metadata
  in this message.

  Messages:
    SystemLabelsValue: Output only. Values for predefined system metadata
      labels. System labels are a kind of metadata extracted by Google
      Stackdriver. Stackdriver determines what system labels are useful and
      how to obtain their values. Some examples: "machine_image", "vpc",
      "subnet_id", "security_group", "name", etc. System label values can be
      only strings, Boolean values, or a list of strings. For example: {
      "name": "my-test-instance",   "security_group": ["a", "b", "c"],
      "spot_instance": false }
    UserLabelsValue: Output only. A map of user-defined metadata labels.

  Fields:
    systemLabels: Output only. Values for predefined system metadata labels.
      System labels are a kind of metadata extracted by Google Stackdriver.
      Stackdriver determines what system labels are useful and how to obtain
      their values. Some examples: "machine_image", "vpc", "subnet_id",
      "security_group", "name", etc. System label values can be only strings,
      Boolean values, or a list of strings. For example: { "name": "my-test-
      instance",   "security_group": ["a", "b", "c"],   "spot_instance": false
      }
    userLabels: Output only. A map of user-defined metadata labels.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SystemLabelsValue(_messages.Message):
    r"""Output only. Values for predefined system metadata labels. System
    labels are a kind of metadata extracted by Google Stackdriver. Stackdriver
    determines what system labels are useful and how to obtain their values.
    Some examples: "machine_image", "vpc", "subnet_id", "security_group",
    "name", etc. System label values can be only strings, Boolean values, or a
    list of strings. For example: { "name": "my-test-instance",
    "security_group": ["a", "b", "c"],   "spot_instance": false }

    Messages:
      AdditionalProperty: An additional property for a SystemLabelsValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SystemLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    r"""Output only. A map of user-defined metadata labels.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type UserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  systemLabels = _messages.MessageField('SystemLabelsValue', 1)
  userLabels = _messages.MessageField('UserLabelsValue', 2)


class MonitoringProjectsAlertPoliciesCreateRequest(_messages.Message):
  r"""A MonitoringProjectsAlertPoliciesCreateRequest object.

  Fields:
    alertPolicy: A AlertPolicy resource to be passed as the request body.
    name: The project in which to create the alerting policy. The format is
      projects/[PROJECT_ID].Note that this field names the parent container in
      which the alerting policy will be written, not the name of the created
      policy. The alerting policy that is returned will have a name that
      contains a normalized representation of this name as a prefix but adds a
      suffix of the form /alertPolicies/[POLICY_ID], identifying the policy in
      the container.
  """

  alertPolicy = _messages.MessageField('AlertPolicy', 1)
  name = _messages.StringField(2, required=True)


class MonitoringProjectsAlertPoliciesDeleteRequest(_messages.Message):
  r"""A MonitoringProjectsAlertPoliciesDeleteRequest object.

  Fields:
    name: The alerting policy to delete. The format is:
      projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] For more
      information, see AlertPolicy.
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsAlertPoliciesGetRequest(_messages.Message):
  r"""A MonitoringProjectsAlertPoliciesGetRequest object.

  Fields:
    name: The alerting policy to retrieve. The format is
      projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsAlertPoliciesListRequest(_messages.Message):
  r"""A MonitoringProjectsAlertPoliciesListRequest object.

  Fields:
    filter: If provided, this field specifies the criteria that must be met by
      alert policies to be included in the response.For more details, see
      sorting and filtering.
    name: The project whose alert policies are to be listed. The format is
      projects/[PROJECT_ID] Note that this field names the parent container in
      which the alerting policies to be listed are stored. To retrieve a
      single alerting policy by name, use the GetAlertPolicy operation,
      instead.
    orderBy: A comma-separated list of fields by which to sort the result.
      Supports the same set of field references as the filter field. Entries
      can be prefixed with a minus sign to sort by the field in descending
      order.For more details, see sorting and filtering.
    pageSize: The maximum number of results to return in a single response.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return more results from the previous
      method call.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class MonitoringProjectsAlertPoliciesPatchRequest(_messages.Message):
  r"""A MonitoringProjectsAlertPoliciesPatchRequest object.

  Fields:
    alertPolicy: A AlertPolicy resource to be passed as the request body.
    name: Required if the policy exists. The resource name for this policy.
      The syntax is: projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
      [ALERT_POLICY_ID] is assigned by Stackdriver Monitoring when the policy
      is created. When calling the alertPolicies.create method, do not include
      the name field in the alerting policy passed as part of the request.
    updateMask: Optional. A list of alerting policy field names. If this field
      is not empty, each listed field in the existing alerting policy is set
      to the value of the corresponding field in the supplied policy
      (alert_policy), or to the field's default value if the field is not in
      the supplied alerting policy. Fields not listed retain their previous
      value.Examples of valid field masks include display_name, documentation,
      documentation.content, documentation.mime_type, user_labels,
      user_label.nameofkey, enabled, conditions, combiner, etc.If this field
      is empty, then the supplied alerting policy replaces the existing
      policy. It is the same as deleting the existing policy and adding the
      supplied policy, except for the following: The new policy will have the
      same [ALERT_POLICY_ID] as the former policy. This gives you continuity
      with the former policy in your notifications and incidents. Conditions
      in the new policy will keep their former [CONDITION_ID] if the supplied
      condition includes the name field with that [CONDITION_ID]. If the
      supplied condition omits the name field, then a new [CONDITION_ID] is
      created.
  """

  alertPolicy = _messages.MessageField('AlertPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MonitoringProjectsCollectdTimeSeriesCreateRequest(_messages.Message):
  r"""A MonitoringProjectsCollectdTimeSeriesCreateRequest object.

  Fields:
    createCollectdTimeSeriesRequest: A CreateCollectdTimeSeriesRequest
      resource to be passed as the request body.
    name: The project in which to create the time series. The format is
      "projects/PROJECT_ID_OR_NUMBER".
  """

  createCollectdTimeSeriesRequest = _messages.MessageField('CreateCollectdTimeSeriesRequest', 1)
  name = _messages.StringField(2, required=True)


class MonitoringProjectsGroupsCreateRequest(_messages.Message):
  r"""A MonitoringProjectsGroupsCreateRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    name: The project in which to create the group. The format is
      "projects/{project_id_or_number}".
    validateOnly: If true, validate this request but do not create the group.
  """

  group = _messages.MessageField('Group', 1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class MonitoringProjectsGroupsDeleteRequest(_messages.Message):
  r"""A MonitoringProjectsGroupsDeleteRequest object.

  Fields:
    name: The group to delete. The format is
      "projects/{project_id_or_number}/groups/{group_id}".
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsGroupsGetRequest(_messages.Message):
  r"""A MonitoringProjectsGroupsGetRequest object.

  Fields:
    name: The group to retrieve. The format is
      "projects/{project_id_or_number}/groups/{group_id}".
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsGroupsListRequest(_messages.Message):
  r"""A MonitoringProjectsGroupsListRequest object.

  Fields:
    ancestorsOfGroup: A group name:
      "projects/{project_id_or_number}/groups/{group_id}". Returns groups that
      are ancestors of the specified group. The groups are returned in order,
      starting with the immediate parent and ending with the most distant
      ancestor. If the specified group has no immediate parent, the results
      are empty.
    childrenOfGroup: A group name:
      "projects/{project_id_or_number}/groups/{group_id}". Returns groups
      whose parentName field contains the group name. If no groups have this
      parent, the results are empty.
    descendantsOfGroup: A group name:
      "projects/{project_id_or_number}/groups/{group_id}". Returns the
      descendants of the specified group. This is a superset of the results
      returned by the childrenOfGroup filter, and includes children-of-
      children, and so forth.
    name: The project whose groups are to be listed. The format is
      "projects/{project_id_or_number}".
    pageSize: A positive number that is the maximum number of results to
      return.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return additional results from the
      previous method call.
  """

  ancestorsOfGroup = _messages.StringField(1)
  childrenOfGroup = _messages.StringField(2)
  descendantsOfGroup = _messages.StringField(3)
  name = _messages.StringField(4, required=True)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)


class MonitoringProjectsGroupsMembersListRequest(_messages.Message):
  r"""A MonitoringProjectsGroupsMembersListRequest object.

  Fields:
    filter: An optional list filter describing the members to be returned. The
      filter may reference the type, labels, and metadata of monitored
      resources that comprise the group. For example, to return only resources
      representing Compute Engine VM instances, use this filter: resource.type
      = "gce_instance"
    interval_endTime: Required. The end of the time interval.
    interval_startTime: Optional. The beginning of the time interval. The
      default value for the start time is the end time. The start time must
      not be later than the end time.
    name: The group whose members are listed. The format is
      "projects/{project_id_or_number}/groups/{group_id}".
    pageSize: A positive number that is the maximum number of results to
      return.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return additional results from the
      previous method call.
  """

  filter = _messages.StringField(1)
  interval_endTime = _messages.StringField(2)
  interval_startTime = _messages.StringField(3)
  name = _messages.StringField(4, required=True)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)


class MonitoringProjectsGroupsUpdateRequest(_messages.Message):
  r"""A MonitoringProjectsGroupsUpdateRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    name: Output only. The name of this group. The format is
      "projects/{project_id_or_number}/groups/{group_id}". When creating a
      group, this field is ignored and a new name is created consisting of the
      project specified in the call to CreateGroup and a unique {group_id}
      that is generated automatically.
    validateOnly: If true, validate this request but do not update the
      existing group.
  """

  group = _messages.MessageField('Group', 1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class MonitoringProjectsMetricDescriptorsDeleteRequest(_messages.Message):
  r"""A MonitoringProjectsMetricDescriptorsDeleteRequest object.

  Fields:
    name: The metric descriptor on which to execute the request. The format is
      "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An
      example of {metric_id} is: "custom.googleapis.com/my_test_metric".
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsMetricDescriptorsGetRequest(_messages.Message):
  r"""A MonitoringProjectsMetricDescriptorsGetRequest object.

  Fields:
    name: The metric descriptor on which to execute the request. The format is
      "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An
      example value of {metric_id} is
      "compute.googleapis.com/instance/disk/read_bytes_count".
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsMetricDescriptorsListRequest(_messages.Message):
  r"""A MonitoringProjectsMetricDescriptorsListRequest object.

  Fields:
    filter: If this field is empty, all custom and system-defined metric
      descriptors are returned. Otherwise, the filter specifies which metric
      descriptors are to be returned. For example, the following filter
      matches all custom metrics: metric.type =
      starts_with("custom.googleapis.com/")
    name: The project on which to execute the request. The format is
      "projects/{project_id_or_number}".
    pageSize: A positive number that is the maximum number of results to
      return.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return additional results from the
      previous method call.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MonitoringProjectsMonitoredResourceDescriptorsGetRequest(_messages.Message):
  r"""A MonitoringProjectsMonitoredResourceDescriptorsGetRequest object.

  Fields:
    name: The monitored resource descriptor to get. The format is "projects/{p
      roject_id_or_number}/monitoredResourceDescriptors/{resource_type}". The
      {resource_type} is a predefined type, such as cloudsql_database.
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsMonitoredResourceDescriptorsListRequest(_messages.Message):
  r"""A MonitoringProjectsMonitoredResourceDescriptorsListRequest object.

  Fields:
    filter: An optional filter describing the descriptors to be returned. The
      filter can reference the descriptor's type and labels. For example, the
      following filter returns only Google Compute Engine descriptors that
      have an id label: resource.type = starts_with("gce_") AND
      resource.label:id
    name: The project on which to execute the request. The format is
      "projects/{project_id_or_number}".
    pageSize: A positive number that is the maximum number of results to
      return.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return additional results from the
      previous method call.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MonitoringProjectsNotificationChannelDescriptorsGetRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelDescriptorsGetRequest object.

  Fields:
    name: The channel type for which to execute the request. The format is
      projects/[PROJECT_ID]/notificationChannelDescriptors/{channel_type}.
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsNotificationChannelDescriptorsListRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelDescriptorsListRequest object.

  Fields:
    name: The REST resource name of the parent from which to retrieve the
      notification channel descriptors. The expected syntax is:
      projects/[PROJECT_ID] Note that this names the parent container in which
      to look for the descriptors; to retrieve a single descriptor by name,
      use the GetNotificationChannelDescriptor operation, instead.
    pageSize: The maximum number of results to return in a single response. If
      not set to a positive number, a reasonable value will be chosen by the
      service.
    pageToken: If non-empty, page_token must contain a value returned as the
      next_page_token in a previous response to request the next set of
      results.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class MonitoringProjectsNotificationChannelsCreateRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsCreateRequest object.

  Fields:
    name: The project on which to execute the request. The format is:
      projects/[PROJECT_ID] Note that this names the container into which the
      channel will be written. This does not name the newly created channel.
      The resulting channel's name will have a normalized version of this
      field as a prefix, but will add /notificationChannels/[CHANNEL_ID] to
      identify the channel.
    notificationChannel: A NotificationChannel resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  notificationChannel = _messages.MessageField('NotificationChannel', 2)


class MonitoringProjectsNotificationChannelsDeleteRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsDeleteRequest object.

  Fields:
    force: If true, the notification channel will be deleted regardless of its
      use in alert policies (the policies will be updated to remove the
      channel). If false, channels that are still referenced by an existing
      alerting policy will fail to be deleted in a delete operation.
    name: The channel for which to execute the request. The format is
      projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class MonitoringProjectsNotificationChannelsGetRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsGetRequest object.

  Fields:
    name: The channel for which to execute the request. The format is
      projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsNotificationChannelsGetVerificationCodeRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsGetVerificationCodeRequest
  object.

  Fields:
    getNotificationChannelVerificationCodeRequest: A
      GetNotificationChannelVerificationCodeRequest resource to be passed as
      the request body.
    name: The notification channel for which a verification code is to be
      generated and retrieved. This must name a channel that is already
      verified; if the specified channel is not verified, the request will
      fail.
  """

  getNotificationChannelVerificationCodeRequest = _messages.MessageField('GetNotificationChannelVerificationCodeRequest', 1)
  name = _messages.StringField(2, required=True)


class MonitoringProjectsNotificationChannelsListRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsListRequest object.

  Fields:
    filter: If provided, this field specifies the criteria that must be met by
      notification channels to be included in the response.For more details,
      see sorting and filtering.
    name: The project on which to execute the request. The format is
      projects/[PROJECT_ID]. That is, this names the container in which to
      look for the notification channels; it does not name a specific channel.
      To query a specific channel by REST resource name, use the
      GetNotificationChannel operation.
    orderBy: A comma-separated list of fields by which to sort the result.
      Supports the same set of fields as in filter. Entries can be prefixed
      with a minus sign to sort in descending rather than ascending order.For
      more details, see sorting and filtering.
    pageSize: The maximum number of results to return in a single response. If
      not set to a positive number, a reasonable value will be chosen by the
      service.
    pageToken: If non-empty, page_token must contain a value returned as the
      next_page_token in a previous response to request the next set of
      results.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class MonitoringProjectsNotificationChannelsPatchRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsPatchRequest object.

  Fields:
    name: The full REST resource name for this channel. The syntax is:
      projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID] The [CHANNEL_ID]
      is automatically assigned by the server on creation.
    notificationChannel: A NotificationChannel resource to be passed as the
      request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  notificationChannel = _messages.MessageField('NotificationChannel', 2)
  updateMask = _messages.StringField(3)


class MonitoringProjectsNotificationChannelsSendVerificationCodeRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsSendVerificationCodeRequest
  object.

  Fields:
    name: The notification channel to which to send a verification code.
    sendNotificationChannelVerificationCodeRequest: A
      SendNotificationChannelVerificationCodeRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  sendNotificationChannelVerificationCodeRequest = _messages.MessageField('SendNotificationChannelVerificationCodeRequest', 2)


class MonitoringProjectsNotificationChannelsVerifyRequest(_messages.Message):
  r"""A MonitoringProjectsNotificationChannelsVerifyRequest object.

  Fields:
    name: The notification channel to verify.
    verifyNotificationChannelRequest: A VerifyNotificationChannelRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  verifyNotificationChannelRequest = _messages.MessageField('VerifyNotificationChannelRequest', 2)


class MonitoringProjectsTimeSeriesCreateRequest(_messages.Message):
  r"""A MonitoringProjectsTimeSeriesCreateRequest object.

  Fields:
    createTimeSeriesRequest: A CreateTimeSeriesRequest resource to be passed
      as the request body.
    name: The project on which to execute the request. The format is
      "projects/{project_id_or_number}".
  """

  createTimeSeriesRequest = _messages.MessageField('CreateTimeSeriesRequest', 1)
  name = _messages.StringField(2, required=True)


class MonitoringProjectsTimeSeriesListRequest(_messages.Message):
  r"""A MonitoringProjectsTimeSeriesListRequest object.

  Enums:
    AggregationCrossSeriesReducerValueValuesEnum: The approach to be used to
      combine time series. Not all reducer functions may be applied to all
      time series, depending on the metric type and the value type of the
      original time series. Reduction may change the metric type of value type
      of the time series.Time series data must be aligned in order to perform
      cross-time series reduction. If crossSeriesReducer is specified, then
      perSeriesAligner must be specified and not equal ALIGN_NONE and
      alignmentPeriod must be specified; otherwise, an error is returned.
    AggregationPerSeriesAlignerValueValuesEnum: The approach to be used to
      align individual time series. Not all alignment functions may be applied
      to all time series, depending on the metric type and value type of the
      original time series. Alignment may change the metric type or the value
      type of the time series.Time series data must be aligned in order to
      perform cross-time series reduction. If crossSeriesReducer is specified,
      then perSeriesAligner must be specified and not equal ALIGN_NONE and
      alignmentPeriod must be specified; otherwise, an error is returned.
    ViewValueValuesEnum: Specifies which information is returned about the
      time series.

  Fields:
    aggregation_alignmentPeriod: The alignment period for per-time series
      alignment. If present, alignmentPeriod must be at least 60 seconds.
      After per-time series alignment, each time series will contain data
      points only on the period boundaries. If perSeriesAligner is not
      specified or equals ALIGN_NONE, then this field is ignored. If
      perSeriesAligner is specified and does not equal ALIGN_NONE, then this
      field must be defined; otherwise an error is returned.
    aggregation_crossSeriesReducer: The approach to be used to combine time
      series. Not all reducer functions may be applied to all time series,
      depending on the metric type and the value type of the original time
      series. Reduction may change the metric type of value type of the time
      series.Time series data must be aligned in order to perform cross-time
      series reduction. If crossSeriesReducer is specified, then
      perSeriesAligner must be specified and not equal ALIGN_NONE and
      alignmentPeriod must be specified; otherwise, an error is returned.
    aggregation_groupByFields: The set of fields to preserve when
      crossSeriesReducer is specified. The groupByFields determine how the
      time series are partitioned into subsets prior to applying the
      aggregation function. Each subset contains time series that have the
      same value for each of the grouping fields. Each individual time series
      is a member of exactly one subset. The crossSeriesReducer is applied to
      each subset of time series. It is not possible to reduce across
      different resource types, so this field implicitly contains
      resource.type. Fields not specified in groupByFields are aggregated
      away. If groupByFields is not specified and all the time series have the
      same resource type, then the time series are aggregated into a single
      output time series. If crossSeriesReducer is not defined, this field is
      ignored.
    aggregation_perSeriesAligner: The approach to be used to align individual
      time series. Not all alignment functions may be applied to all time
      series, depending on the metric type and value type of the original time
      series. Alignment may change the metric type or the value type of the
      time series.Time series data must be aligned in order to perform cross-
      time series reduction. If crossSeriesReducer is specified, then
      perSeriesAligner must be specified and not equal ALIGN_NONE and
      alignmentPeriod must be specified; otherwise, an error is returned.
    filter: A monitoring filter that specifies which time series should be
      returned. The filter must specify a single metric type, and can
      additionally specify metric labels and other information. For example:
      metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
      metric.label.instance_name = "my-instance-name"
    interval_endTime: Required. The end of the time interval.
    interval_startTime: Optional. The beginning of the time interval. The
      default value for the start time is the end time. The start time must
      not be later than the end time.
    name: The project on which to execute the request. The format is
      "projects/{project_id_or_number}".
    orderBy: Unsupported: must be left blank. The points in each time series
      are returned in reverse time order.
    pageSize: A positive number that is the maximum number of results to
      return. When view field sets to FULL, it limits the number of Points
      server will return; if view field is HEADERS, it limits the number of
      TimeSeries server will return.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return additional results from the
      previous method call.
    view: Specifies which information is returned about the time series.
  """

  class AggregationCrossSeriesReducerValueValuesEnum(_messages.Enum):
    r"""The approach to be used to combine time series. Not all reducer
    functions may be applied to all time series, depending on the metric type
    and the value type of the original time series. Reduction may change the
    metric type of value type of the time series.Time series data must be
    aligned in order to perform cross-time series reduction. If
    crossSeriesReducer is specified, then perSeriesAligner must be specified
    and not equal ALIGN_NONE and alignmentPeriod must be specified; otherwise,
    an error is returned.

    Values:
      REDUCE_NONE: <no description>
      REDUCE_MEAN: <no description>
      REDUCE_MIN: <no description>
      REDUCE_MAX: <no description>
      REDUCE_SUM: <no description>
      REDUCE_STDDEV: <no description>
      REDUCE_COUNT: <no description>
      REDUCE_COUNT_TRUE: <no description>
      REDUCE_COUNT_FALSE: <no description>
      REDUCE_FRACTION_TRUE: <no description>
      REDUCE_PERCENTILE_99: <no description>
      REDUCE_PERCENTILE_95: <no description>
      REDUCE_PERCENTILE_50: <no description>
      REDUCE_PERCENTILE_05: <no description>
    """
    REDUCE_NONE = 0
    REDUCE_MEAN = 1
    REDUCE_MIN = 2
    REDUCE_MAX = 3
    REDUCE_SUM = 4
    REDUCE_STDDEV = 5
    REDUCE_COUNT = 6
    REDUCE_COUNT_TRUE = 7
    REDUCE_COUNT_FALSE = 8
    REDUCE_FRACTION_TRUE = 9
    REDUCE_PERCENTILE_99 = 10
    REDUCE_PERCENTILE_95 = 11
    REDUCE_PERCENTILE_50 = 12
    REDUCE_PERCENTILE_05 = 13

  class AggregationPerSeriesAlignerValueValuesEnum(_messages.Enum):
    r"""The approach to be used to align individual time series. Not all
    alignment functions may be applied to all time series, depending on the
    metric type and value type of the original time series. Alignment may
    change the metric type or the value type of the time series.Time series
    data must be aligned in order to perform cross-time series reduction. If
    crossSeriesReducer is specified, then perSeriesAligner must be specified
    and not equal ALIGN_NONE and alignmentPeriod must be specified; otherwise,
    an error is returned.

    Values:
      ALIGN_NONE: <no description>
      ALIGN_DELTA: <no description>
      ALIGN_RATE: <no description>
      ALIGN_INTERPOLATE: <no description>
      ALIGN_NEXT_OLDER: <no description>
      ALIGN_MIN: <no description>
      ALIGN_MAX: <no description>
      ALIGN_MEAN: <no description>
      ALIGN_COUNT: <no description>
      ALIGN_SUM: <no description>
      ALIGN_STDDEV: <no description>
      ALIGN_COUNT_TRUE: <no description>
      ALIGN_COUNT_FALSE: <no description>
      ALIGN_FRACTION_TRUE: <no description>
      ALIGN_PERCENTILE_99: <no description>
      ALIGN_PERCENTILE_95: <no description>
      ALIGN_PERCENTILE_50: <no description>
      ALIGN_PERCENTILE_05: <no description>
      ALIGN_PERCENT_CHANGE: <no description>
    """
    ALIGN_NONE = 0
    ALIGN_DELTA = 1
    ALIGN_RATE = 2
    ALIGN_INTERPOLATE = 3
    ALIGN_NEXT_OLDER = 4
    ALIGN_MIN = 5
    ALIGN_MAX = 6
    ALIGN_MEAN = 7
    ALIGN_COUNT = 8
    ALIGN_SUM = 9
    ALIGN_STDDEV = 10
    ALIGN_COUNT_TRUE = 11
    ALIGN_COUNT_FALSE = 12
    ALIGN_FRACTION_TRUE = 13
    ALIGN_PERCENTILE_99 = 14
    ALIGN_PERCENTILE_95 = 15
    ALIGN_PERCENTILE_50 = 16
    ALIGN_PERCENTILE_05 = 17
    ALIGN_PERCENT_CHANGE = 18

  class ViewValueValuesEnum(_messages.Enum):
    r"""Specifies which information is returned about the time series.

    Values:
      FULL: <no description>
      HEADERS: <no description>
    """
    FULL = 0
    HEADERS = 1

  aggregation_alignmentPeriod = _messages.StringField(1)
  aggregation_crossSeriesReducer = _messages.EnumField('AggregationCrossSeriesReducerValueValuesEnum', 2)
  aggregation_groupByFields = _messages.StringField(3, repeated=True)
  aggregation_perSeriesAligner = _messages.EnumField('AggregationPerSeriesAlignerValueValuesEnum', 4)
  filter = _messages.StringField(5)
  interval_endTime = _messages.StringField(6)
  interval_startTime = _messages.StringField(7)
  name = _messages.StringField(8, required=True)
  orderBy = _messages.StringField(9)
  pageSize = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(11)
  view = _messages.EnumField('ViewValueValuesEnum', 12)


class MonitoringProjectsUptimeCheckConfigsCreateRequest(_messages.Message):
  r"""A MonitoringProjectsUptimeCheckConfigsCreateRequest object.

  Fields:
    parent: The project in which to create the uptime check. The format  is
      projects/[PROJECT_ID].
    uptimeCheckConfig: A UptimeCheckConfig resource to be passed as the
      request body.
  """

  parent = _messages.StringField(1, required=True)
  uptimeCheckConfig = _messages.MessageField('UptimeCheckConfig', 2)


class MonitoringProjectsUptimeCheckConfigsDeleteRequest(_messages.Message):
  r"""A MonitoringProjectsUptimeCheckConfigsDeleteRequest object.

  Fields:
    name: The uptime check configuration to delete. The format  is
      projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsUptimeCheckConfigsGetRequest(_messages.Message):
  r"""A MonitoringProjectsUptimeCheckConfigsGetRequest object.

  Fields:
    name: The uptime check configuration to retrieve. The format  is
      projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsUptimeCheckConfigsListRequest(_messages.Message):
  r"""A MonitoringProjectsUptimeCheckConfigsListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single response.
      The server may further constrain the maximum number of results returned
      in a single page. If the page_size is <=0, the server will decide the
      number of results to be returned.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return more results from the previous
      method call.
    parent: The project whose uptime check configurations are listed. The
      format  is projects/[PROJECT_ID].
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MonitoringProjectsUptimeCheckConfigsPatchRequest(_messages.Message):
  r"""A MonitoringProjectsUptimeCheckConfigsPatchRequest object.

  Fields:
    name: A unique resource name for this UptimeCheckConfig. The format
      is:projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].This field
      should be omitted when creating the uptime check configuration; on
      create, the resource name is assigned by the server and included in the
      response.
    updateMask: Optional. If present, only the listed fields in the current
      uptime check configuration are updated with values from the new
      configuration. If this field is empty, then the current configuration is
      completely replaced with the new configuration.
    uptimeCheckConfig: A UptimeCheckConfig resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  uptimeCheckConfig = _messages.MessageField('UptimeCheckConfig', 3)


class MonitoringUptimeCheckIpsListRequest(_messages.Message):
  r"""A MonitoringUptimeCheckIpsListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single response.
      The server may further constrain the maximum number of results returned
      in a single page. If the page_size is <=0, the server will decide the
      number of results to be returned. NOTE: this field is not yet
      implemented
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return more results from the previous
      method call. NOTE: this field is not yet implemented
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)


class MutationRecord(_messages.Message):
  r"""Describes a change made to a configuration.

  Fields:
    mutateTime: When the change occurred.
    mutatedBy: The email address of the user making the change.
  """

  mutateTime = _messages.StringField(1)
  mutatedBy = _messages.StringField(2)


class NotificationChannel(_messages.Message):
  r"""A NotificationChannel is a medium through which an alert is delivered
  when a policy violation is detected. Examples of channels include email,
  SMS, and third-party messaging applications. Fields containing sensitive
  information like authentication tokens or contact info are only partially
  populated on retrieval.

  Enums:
    VerificationStatusValueValuesEnum: Indicates whether this channel has been
      verified or not. On a ListNotificationChannels or GetNotificationChannel
      operation, this field is expected to be populated.If the value is
      UNVERIFIED, then it indicates that the channel is non-functioning (it
      both requires verification and lacks verification); otherwise, it is
      assumed that the channel works.If the channel is neither VERIFIED nor
      UNVERIFIED, it implies that the channel is of a type that does not
      require verification or that this specific channel has been exempted
      from verification because it was created prior to verification being
      required for channels of this type.This field cannot be modified using a
      standard UpdateNotificationChannel operation. To change the value of
      this field, you must call VerifyNotificationChannel.

  Messages:
    LabelsValue: Configuration fields that define the channel and its
      behavior. The permissible and required labels are specified in the
      NotificationChannelDescriptor.labels of the
      NotificationChannelDescriptor corresponding to the type field.
    UserLabelsValue: User-supplied key/value data that does not need to
      conform to the corresponding NotificationChannelDescriptor's schema,
      unlike the labels field. This field is intended to be used for
      organizing and identifying the NotificationChannel objects.The field can
      contain up to 64 entries. Each key and value is limited to 63 Unicode
      characters or 128 bytes, whichever is smaller. Labels and values can
      contain only lowercase letters, numerals, underscores, and dashes. Keys
      must begin with a letter.

  Fields:
    description: An optional human-readable description of this notification
      channel. This description may provide additional details, beyond the
      display name, for the channel. This may not exceeed 1024 Unicode
      characters.
    displayName: An optional human-readable name for this notification
      channel. It is recommended that you specify a non-empty and unique name
      in order to make it easier to identify the channels in your project,
      though this is not enforced. The display name is limited to 512 Unicode
      characters.
    enabled: Whether notifications are forwarded to the described channel.
      This makes it possible to disable delivery of notifications to a
      particular channel without removing the channel from all alerting
      policies that reference the channel. This is a more convenient approach
      when the change is temporary and you want to receive notifications from
      the same set of alerting policies on the channel at some point in the
      future.
    labels: Configuration fields that define the channel and its behavior. The
      permissible and required labels are specified in the
      NotificationChannelDescriptor.labels of the
      NotificationChannelDescriptor corresponding to the type field.
    name: The full REST resource name for this channel. The syntax is:
      projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID] The [CHANNEL_ID]
      is automatically assigned by the server on creation.
    type: The type of the notification channel. This field matches the value
      of the NotificationChannelDescriptor.type field.
    userLabels: User-supplied key/value data that does not need to conform to
      the corresponding NotificationChannelDescriptor's schema, unlike the
      labels field. This field is intended to be used for organizing and
      identifying the NotificationChannel objects.The field can contain up to
      64 entries. Each key and value is limited to 63 Unicode characters or
      128 bytes, whichever is smaller. Labels and values can contain only
      lowercase letters, numerals, underscores, and dashes. Keys must begin
      with a letter.
    verificationStatus: Indicates whether this channel has been verified or
      not. On a ListNotificationChannels or GetNotificationChannel operation,
      this field is expected to be populated.If the value is UNVERIFIED, then
      it indicates that the channel is non-functioning (it both requires
      verification and lacks verification); otherwise, it is assumed that the
      channel works.If the channel is neither VERIFIED nor UNVERIFIED, it
      implies that the channel is of a type that does not require verification
      or that this specific channel has been exempted from verification
      because it was created prior to verification being required for channels
      of this type.This field cannot be modified using a standard
      UpdateNotificationChannel operation. To change the value of this field,
      you must call VerifyNotificationChannel.
  """

  class VerificationStatusValueValuesEnum(_messages.Enum):
    r"""Indicates whether this channel has been verified or not. On a
    ListNotificationChannels or GetNotificationChannel operation, this field
    is expected to be populated.If the value is UNVERIFIED, then it indicates
    that the channel is non-functioning (it both requires verification and
    lacks verification); otherwise, it is assumed that the channel works.If
    the channel is neither VERIFIED nor UNVERIFIED, it implies that the
    channel is of a type that does not require verification or that this
    specific channel has been exempted from verification because it was
    created prior to verification being required for channels of this
    type.This field cannot be modified using a standard
    UpdateNotificationChannel operation. To change the value of this field,
    you must call VerifyNotificationChannel.

    Values:
      VERIFICATION_STATUS_UNSPECIFIED: Sentinel value used to indicate that
        the state is unknown, omitted, or is not applicable (as in the case of
        channels that neither support nor require verification in order to
        function).
      UNVERIFIED: The channel has yet to be verified and requires verification
        to function. Note that this state also applies to the case where the
        verification process has been initiated by sending a verification code
        but where the verification code has not been submitted to complete the
        process.
      VERIFIED: It has been proven that notifications can be received on this
        notification channel and that someone on the project has access to
        messages that are delivered to that channel.
    """
    VERIFICATION_STATUS_UNSPECIFIED = 0
    UNVERIFIED = 1
    VERIFIED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Configuration fields that define the channel and its behavior. The
    permissible and required labels are specified in the
    NotificationChannelDescriptor.labels of the NotificationChannelDescriptor
    corresponding to the type field.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    r"""User-supplied key/value data that does not need to conform to the
    corresponding NotificationChannelDescriptor's schema, unlike the labels
    field. This field is intended to be used for organizing and identifying
    the NotificationChannel objects.The field can contain up to 64 entries.
    Each key and value is limited to 63 Unicode characters or 128 bytes,
    whichever is smaller. Labels and values can contain only lowercase
    letters, numerals, underscores, and dashes. Keys must begin with a letter.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type UserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  enabled = _messages.BooleanField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  type = _messages.StringField(6)
  userLabels = _messages.MessageField('UserLabelsValue', 7)
  verificationStatus = _messages.EnumField('VerificationStatusValueValuesEnum', 8)


class NotificationChannelDescriptor(_messages.Message):
  r"""A description of a notification channel. The descriptor includes the
  properties of the channel and the set of labels or fields that must be
  specified to configure channels of a given type.

  Enums:
    SupportedTiersValueListEntryValuesEnum:

  Fields:
    description: A human-readable description of the notification channel
      type. The description may include a description of the properties of the
      channel and pointers to external documentation.
    displayName: A human-readable name for the notification channel type. This
      form of the name is suitable for a user interface.
    labels: The set of labels that must be defined to identify a particular
      channel of the corresponding type. Each label includes a description for
      how that field should be populated.
    name: The full REST resource name for this descriptor. The syntax is:
      projects/[PROJECT_ID]/notificationChannelDescriptors/[TYPE] In the
      above, [TYPE] is the value of the type field.
    supportedTiers: The tiers that support this notification channel; the
      project service tier must be one of the supported_tiers.
    type: The type of notification channel, such as "email", "sms", etc.
      Notification channel types are globally unique.
  """

  class SupportedTiersValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedTiersValueListEntryValuesEnum enum type.

    Values:
      SERVICE_TIER_UNSPECIFIED: <no description>
      SERVICE_TIER_BASIC: <no description>
      SERVICE_TIER_PREMIUM: <no description>
    """
    SERVICE_TIER_UNSPECIFIED = 0
    SERVICE_TIER_BASIC = 1
    SERVICE_TIER_PREMIUM = 2

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  name = _messages.StringField(4)
  supportedTiers = _messages.EnumField('SupportedTiersValueListEntryValuesEnum', 5, repeated=True)
  type = _messages.StringField(6)


class Option(_messages.Message):
  r"""A protocol buffer option, which can be attached to a message, field,
  enumeration, etc.

  Messages:
    ValueValue: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.

  Fields:
    name: The option's name. For protobuf built-in options (options defined in
      descriptor.proto), this is the short name. For example, "map_entry". For
      custom options, it should be the fully-qualified name. For example,
      "google.api.http".
    value: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValueValue(_messages.Message):
    r"""The option's value packed in an Any message. If the value is a
    primitive, the corresponding wrapper type defined in
    google/protobuf/wrappers.proto should be used. If the value is an enum, it
    should be stored as an int32 value using the google.protobuf.Int32Value
    type.

    Messages:
      AdditionalProperty: An additional property for a ValueValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ValueValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  name = _messages.StringField(1)
  value = _messages.MessageField('ValueValue', 2)


class Point(_messages.Message):
  r"""A single data point in a time series.

  Fields:
    interval: The time interval to which the data point applies. For GAUGE
      metrics, only the end time of the interval is used. For DELTA metrics,
      the start and end time should specify a non-zero interval, with
      subsequent points specifying contiguous and non-overlapping intervals.
      For CUMULATIVE metrics, the start and end time should specify a non-zero
      interval, with subsequent points specifying the same start time and
      increasing end times, until an event resets the cumulative value to zero
      and sets a new start time for the following points.
    value: The value of the data point.
  """

  interval = _messages.MessageField('TimeInterval', 1)
  value = _messages.MessageField('TypedValue', 2)


class Range(_messages.Message):
  r"""The range of the population values.

  Fields:
    max: The maximum of the population values.
    min: The minimum of the population values.
  """

  max = _messages.FloatField(1)
  min = _messages.FloatField(2)


class ResourceGroup(_messages.Message):
  r"""The resource submessage for group checks. It can be used instead of a
  monitored resource, when multiple resources are being monitored.

  Enums:
    ResourceTypeValueValuesEnum: The resource type of the group members.

  Fields:
    groupId: The group of resources being monitored. Should be only the
      group_id, not projects/<project_id>/groups/<group_id>.
    resourceType: The resource type of the group members.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""The resource type of the group members.

    Values:
      RESOURCE_TYPE_UNSPECIFIED: Default value (not valid).
      INSTANCE: A group of instances from Google Cloud Platform (GCP) or
        Amazon Web Services (AWS).
      AWS_ELB_LOAD_BALANCER: A group of Amazon ELB load balancers.
    """
    RESOURCE_TYPE_UNSPECIFIED = 0
    INSTANCE = 1
    AWS_ELB_LOAD_BALANCER = 2

  groupId = _messages.StringField(1)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 2)


class SendNotificationChannelVerificationCodeRequest(_messages.Message):
  r"""The SendNotificationChannelVerificationCode request."""


class SourceContext(_messages.Message):
  r"""SourceContext represents information about the source of a protobuf
  element, like the file in which it is defined.

  Fields:
    fileName: The path-qualified name of the .proto file that contained the
      associated protobuf element. For example:
      "google/protobuf/source_context.proto".
  """

  fileName = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  r"""The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). The error model is designed to be:
  Simple to use and understand for most users Flexible enough to meet
  unexpected needsOverviewThe Status message contains three pieces of data:
  error code, error message, and error details. The error code should be an
  enum value of google.rpc.Code, but it may accept additional error codes if
  needed. The error message should be a developer-facing English message that
  helps developers understand and resolve the error. If a localized user-
  facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package google.rpc that can be used for common error
  conditions.Language mappingThe Status message is the logical representation
  of the error model, but it is not necessarily the actual wire format. When
  the Status message is exposed in different client libraries and different
  wire protocols, it can be mapped differently. For example, it will likely be
  mapped to some exceptions in Java, but more likely mapped to some error
  codes in C.Other usesThe error model and the Status message can be used in a
  variety of environments, either with or without APIs, to provide a
  consistent developer experience across different environments.Example uses
  of this error model include: Partial errors. If a service needs to return
  partial errors to the client, it may embed the Status in the normal response
  to indicate the partial errors. Workflow errors. A typical workflow has
  multiple steps. Each step may have a Status message for error reporting.
  Batch operations. If a client uses batch request and batch response, the
  Status message should be used directly inside batch response, one for each
  error sub-response. Asynchronous operations. If an API call embeds
  asynchronous operation results in its response, the status of those
  operations should be represented directly using the Status message. Logging.
  If some API errors are stored in logs, the message Status could be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TcpCheck(_messages.Message):
  r"""Information required for a TCP uptime check request.

  Fields:
    port: The port to the page to run the check against. Will be combined with
      host (specified within the MonitoredResource) to construct the full URL.
      Required.
  """

  port = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class TimeInterval(_messages.Message):
  r"""A time interval extending just after a start time through an end time.
  If the start time is the same as the end time, then the interval represents
  a single point in time.

  Fields:
    endTime: Required. The end of the time interval.
    startTime: Optional. The beginning of the time interval. The default value
      for the start time is the end time. The start time must not be later
      than the end time.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class TimeSeries(_messages.Message):
  r"""A collection of data points that describes the time-varying values of a
  metric. A time series is identified by a combination of a fully-specified
  monitored resource and a fully-specified metric. This type is used for both
  listing and creating time series.

  Enums:
    MetricKindValueValuesEnum: The metric kind of the time series. When
      listing time series, this metric kind might be different from the metric
      kind of the associated metric if this time series is an alignment or
      reduction of other time series.When creating a time series, this field
      is optional. If present, it must be the same as the metric kind of the
      associated metric. If the associated metric's descriptor must be auto-
      created, then this field specifies the metric kind of the new descriptor
      and must be either GAUGE (the default) or CUMULATIVE.
    ValueTypeValueValuesEnum: The value type of the time series. When listing
      time series, this value type might be different from the value type of
      the associated metric if this time series is an alignment or reduction
      of other time series.When creating a time series, this field is
      optional. If present, it must be the same as the type of the data in the
      points field.

  Fields:
    metadata: Output only. The associated monitored resource metadata. When
      reading a a timeseries, this field will include metadata labels that are
      explicitly named in the reduction. When creating a timeseries, this
      field is ignored.
    metric: The associated metric. A fully-specified metric used to identify
      the time series.
    metricKind: The metric kind of the time series. When listing time series,
      this metric kind might be different from the metric kind of the
      associated metric if this time series is an alignment or reduction of
      other time series.When creating a time series, this field is optional.
      If present, it must be the same as the metric kind of the associated
      metric. If the associated metric's descriptor must be auto-created, then
      this field specifies the metric kind of the new descriptor and must be
      either GAUGE (the default) or CUMULATIVE.
    points: The data points of this time series. When listing time series,
      points are returned in reverse time order.When creating a time series,
      this field must contain exactly one point and the point's type must be
      the same as the value type of the associated metric. If the associated
      metric's descriptor must be auto-created, then the value type of the
      descriptor is determined by the point's type, which must be BOOL, INT64,
      DOUBLE, or DISTRIBUTION.
    resource: The associated monitored resource. Custom metrics can use only
      certain monitored resource types in their time series data.
    valueType: The value type of the time series. When listing time series,
      this value type might be different from the value type of the associated
      metric if this time series is an alignment or reduction of other time
      series.When creating a time series, this field is optional. If present,
      it must be the same as the type of the data in the points field.
  """

  class MetricKindValueValuesEnum(_messages.Enum):
    r"""The metric kind of the time series. When listing time series, this
    metric kind might be different from the metric kind of the associated
    metric if this time series is an alignment or reduction of other time
    series.When creating a time series, this field is optional. If present, it
    must be the same as the metric kind of the associated metric. If the
    associated metric's descriptor must be auto-created, then this field
    specifies the metric kind of the new descriptor and must be either GAUGE
    (the default) or CUMULATIVE.

    Values:
      METRIC_KIND_UNSPECIFIED: Do not use this default value.
      GAUGE: An instantaneous measurement of a value.
      DELTA: The change in a value during a time interval.
      CUMULATIVE: A value accumulated over a time interval. Cumulative
        measurements in a time series should have the same start time and
        increasing end times, until an event resets the cumulative value to
        zero and sets a new start time for the following points.
    """
    METRIC_KIND_UNSPECIFIED = 0
    GAUGE = 1
    DELTA = 2
    CUMULATIVE = 3

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""The value type of the time series. When listing time series, this
    value type might be different from the value type of the associated metric
    if this time series is an alignment or reduction of other time series.When
    creating a time series, this field is optional. If present, it must be the
    same as the type of the data in the points field.

    Values:
      VALUE_TYPE_UNSPECIFIED: Do not use this default value.
      BOOL: The value is a boolean. This value type can be used only if the
        metric kind is GAUGE.
      INT64: The value is a signed 64-bit integer.
      DOUBLE: The value is a double precision floating point number.
      STRING: The value is a text string. This value type can be used only if
        the metric kind is GAUGE.
      DISTRIBUTION: The value is a Distribution.
      MONEY: The value is money.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    BOOL = 1
    INT64 = 2
    DOUBLE = 3
    STRING = 4
    DISTRIBUTION = 5
    MONEY = 6

  metadata = _messages.MessageField('MonitoredResourceMetadata', 1)
  metric = _messages.MessageField('Metric', 2)
  metricKind = _messages.EnumField('MetricKindValueValuesEnum', 3)
  points = _messages.MessageField('Point', 4, repeated=True)
  resource = _messages.MessageField('MonitoredResource', 5)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 6)


class Trigger(_messages.Message):
  r"""Specifies how many time series must fail a predicate to trigger a
  condition. If not specified, then a {count: 1} trigger is used.

  Fields:
    count: The absolute number of time series that must fail the predicate for
      the condition to be triggered.
    percent: The percentage of time series that must fail the predicate for
      the condition to be triggered.
  """

  count = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  percent = _messages.FloatField(2)


class Type(_messages.Message):
  r"""A protocol buffer message type.

  Enums:
    SyntaxValueValuesEnum: The source syntax.

  Fields:
    fields: The list of fields.
    name: The fully qualified message name.
    oneofs: The list of types appearing in oneof definitions in this type.
    options: The protocol buffer options.
    sourceContext: The source context.
    syntax: The source syntax.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    r"""The source syntax.

    Values:
      SYNTAX_PROTO2: Syntax proto2.
      SYNTAX_PROTO3: Syntax proto3.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1

  fields = _messages.MessageField('Field', 1, repeated=True)
  name = _messages.StringField(2)
  oneofs = _messages.StringField(3, repeated=True)
  options = _messages.MessageField('Option', 4, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 5)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 6)


class TypedValue(_messages.Message):
  r"""A single strongly-typed value.

  Fields:
    boolValue: A Boolean value: true or false.
    distributionValue: A distribution value.
    doubleValue: A 64-bit double-precision floating-point number. Its
      magnitude is approximately &plusmn;10<sup>&plusmn;300</sup> and it has
      16 significant digits of precision.
    int64Value: A 64-bit integer. Its range is approximately
      &plusmn;9.2x10<sup>18</sup>.
    stringValue: A variable-length string value.
  """

  boolValue = _messages.BooleanField(1)
  distributionValue = _messages.MessageField('Distribution', 2)
  doubleValue = _messages.FloatField(3)
  int64Value = _messages.IntegerField(4)
  stringValue = _messages.StringField(5)


class UptimeCheckConfig(_messages.Message):
  r"""This message configures which resources and services to monitor for
  availability.

  Enums:
    SelectedRegionsValueListEntryValuesEnum:

  Fields:
    contentMatchers: The expected content on the page the check is run
      against. Currently, only the first entry in the list is supported, and
      other entries will be ignored. The server will look for an exact match
      of the string in the page response's content. This field is optional and
      should only be specified if a content match is required.
    displayName: A human-friendly name for the uptime check configuration. The
      display name should be unique within a Stackdriver Account in order to
      make it easier to identify; however, uniqueness is not enforced.
      Required.
    httpCheck: Contains information needed to make an HTTP or HTTPS check.
    internalCheckers: The internal checkers that this check will egress from.
      If is_internal is true and this list is empty, the check will egress
      from all InternalCheckers configured for the project that owns this
      CheckConfig.
    isInternal: Denotes whether this is a check that egresses from
      InternalCheckers.
    monitoredResource: The monitored resource
      (https://cloud.google.com/monitoring/api/resources) associated with the
      configuration. The following monitored resource types are supported for
      uptime checks:  uptime_url  gce_instance  gae_app  aws_ec2_instance
      aws_elb_load_balancer
    name: A unique resource name for this UptimeCheckConfig. The format
      is:projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].This field
      should be omitted when creating the uptime check configuration; on
      create, the resource name is assigned by the server and included in the
      response.
    period: How often, in seconds, the uptime check is performed. Currently,
      the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10
      minutes), and 900s (15 minutes). Optional, defaults to 300s.
    resourceGroup: The group resource associated with the configuration.
    selectedRegions: The list of regions from which the check will be run. If
      this field is specified, enough regions to include a minimum of 3
      locations must be provided, or an error message is returned. Not
      specifying this field will result in uptime checks running from all
      regions.
    tcpCheck: Contains information needed to make a TCP check.
    timeout: The maximum amount of time to wait for the request to complete
      (must be between 1 and 60 seconds). Required.
  """

  class SelectedRegionsValueListEntryValuesEnum(_messages.Enum):
    r"""SelectedRegionsValueListEntryValuesEnum enum type.

    Values:
      REGION_UNSPECIFIED: <no description>
      USA: <no description>
      EUROPE: <no description>
      SOUTH_AMERICA: <no description>
      ASIA_PACIFIC: <no description>
    """
    REGION_UNSPECIFIED = 0
    USA = 1
    EUROPE = 2
    SOUTH_AMERICA = 3
    ASIA_PACIFIC = 4

  contentMatchers = _messages.MessageField('ContentMatcher', 1, repeated=True)
  displayName = _messages.StringField(2)
  httpCheck = _messages.MessageField('HttpCheck', 3)
  internalCheckers = _messages.MessageField('InternalChecker', 4, repeated=True)
  isInternal = _messages.BooleanField(5)
  monitoredResource = _messages.MessageField('MonitoredResource', 6)
  name = _messages.StringField(7)
  period = _messages.StringField(8)
  resourceGroup = _messages.MessageField('ResourceGroup', 9)
  selectedRegions = _messages.EnumField('SelectedRegionsValueListEntryValuesEnum', 10, repeated=True)
  tcpCheck = _messages.MessageField('TcpCheck', 11)
  timeout = _messages.StringField(12)


class UptimeCheckIp(_messages.Message):
  r"""Contains the region, location, and list of IP addresses where checkers
  in the location run from.

  Enums:
    RegionValueValuesEnum: A broad region category in which the IP address is
      located.

  Fields:
    ipAddress: The IP address from which the uptime check originates. This is
      a full IP address (not an IP address range). Most IP addresses, as of
      this publication, are in IPv4 format; however, one should not rely on
      the IP addresses being in IPv4 format indefinitely and should support
      interpreting this field in either IPv4 or IPv6 format.
    location: A more specific location within the region that typically
      encodes a particular city/town/metro (and its containing state/province
      or country) within the broader umbrella region category.
    region: A broad region category in which the IP address is located.
  """

  class RegionValueValuesEnum(_messages.Enum):
    r"""A broad region category in which the IP address is located.

    Values:
      REGION_UNSPECIFIED: Default value if no region is specified. Will result
        in uptime checks running from all regions.
      USA: Allows checks to run from locations within the United States of
        America.
      EUROPE: Allows checks to run from locations within the continent of
        Europe.
      SOUTH_AMERICA: Allows checks to run from locations within the continent
        of South America.
      ASIA_PACIFIC: Allows checks to run from locations within the Asia
        Pacific area (ex: Singapore).
    """
    REGION_UNSPECIFIED = 0
    USA = 1
    EUROPE = 2
    SOUTH_AMERICA = 3
    ASIA_PACIFIC = 4

  ipAddress = _messages.StringField(1)
  location = _messages.StringField(2)
  region = _messages.EnumField('RegionValueValuesEnum', 3)


class VerifyNotificationChannelRequest(_messages.Message):
  r"""The VerifyNotificationChannel request.

  Fields:
    code: The verification code that was delivered to the channel as a result
      of invoking the SendNotificationChannelVerificationCode API method or
      that was retrieved from a verified channel via
      GetNotificationChannelVerificationCode. For example, one might have
      "G-123456" or "TKNZGhhd2EyN3I1MnRnMjRv" (in general, one is only
      guaranteed that the code is valid UTF-8; one should not make any
      assumptions regarding the structure or format of the code).
  """

  code = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
