"""Generated client library for cloudtrace version v2beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.cloudtrace.v2beta1 import cloudtrace_v2beta1_messages as messages


class CloudtraceV2beta1(base_api.BaseApiClient):
  """Generated client library for service cloudtrace version v2beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudtrace.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudtrace.mtls.googleapis.com/'

  _PACKAGE = 'cloudtrace'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/trace.append', 'https://www.googleapis.com/auth/trace.readonly']
  _VERSION = 'v2beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudtraceV2beta1'
  _URL_VERSION = 'v2beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudtrace handle."""
    url = url or self.BASE_URL
    super(CloudtraceV2beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_traceSinks = self.ProjectsTraceSinksService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsTraceSinksService(base_api.BaseApiService):
    """Service class for the projects_traceSinks resource."""

    _NAME = 'projects_traceSinks'

    def __init__(self, client):
      super(CloudtraceV2beta1.ProjectsTraceSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports trace spans to a destination.  The.
export of newly-ingested traces begins immediately, unless the sink's
`writer_identity` is not permitted to write to the destination.  A sink can
export traces only from the resource owning the sink (the 'parent').

      Args:
        request: (CloudtraceProjectsTraceSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TraceSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta1/projects/{projectsId}/traceSinks',
        http_method='POST',
        method_id='cloudtrace.projects.traceSinks.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2beta1/{+parent}/traceSinks',
        request_field='traceSink',
        request_type_name='CloudtraceProjectsTraceSinksCreateRequest',
        response_type_name='TraceSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink.

      Args:
        request: (CloudtraceProjectsTraceSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta1/projects/{projectsId}/traceSinks/{traceSinksId}',
        http_method='DELETE',
        method_id='cloudtrace.projects.traceSinks.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta1/{+name}',
        request_field='',
        request_type_name='CloudtraceProjectsTraceSinksDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get a trace sink by name under the parent resource (GCP project).

      Args:
        request: (CloudtraceProjectsTraceSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TraceSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta1/projects/{projectsId}/traceSinks/{traceSinksId}',
        http_method='GET',
        method_id='cloudtrace.projects.traceSinks.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta1/{+name}',
        request_field='',
        request_type_name='CloudtraceProjectsTraceSinksGetRequest',
        response_type_name='TraceSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all sinks for the parent resource (GCP project).

      Args:
        request: (CloudtraceProjectsTraceSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTraceSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta1/projects/{projectsId}/traceSinks',
        http_method='GET',
        method_id='cloudtrace.projects.traceSinks.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2beta1/{+parent}/traceSinks',
        request_field='',
        request_type_name='CloudtraceProjectsTraceSinksListRequest',
        response_type_name='ListTraceSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink.  This method updates fields in the existing sink according.
to the provided update mask. The sink's name cannot be changed nor any
output-only fields (e.g. the writer_identity).

      Args:
        request: (CloudtraceProjectsTraceSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TraceSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta1/projects/{projectsId}/traceSinks/{traceSinksId}',
        http_method='PATCH',
        method_id='cloudtrace.projects.traceSinks.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2beta1/{+name}',
        request_field='traceSink',
        request_type_name='CloudtraceProjectsTraceSinksPatchRequest',
        response_type_name='TraceSink',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudtraceV2beta1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
