"""Generated message classes for videointelligence version v1.

Detects objects, explicit content, and scene changes in videos. It also
specifies the region for annotation and transcribes speech to text. Supports
both asynchronous API and streaming API.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'videointelligence'


class GoogleCloudVideointelligenceV1AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1AnnotateVideoRequest(_messages.Message):
  r"""Video annotation request.

  Enums:
    FeaturesValueListEntryValuesEnum:

  Fields:
    features: Required. Requested video annotation features.
    inputContent: The video data bytes. If unset, the input video(s) should be
      specified via the `input_uri`. If set, `input_uri` must be unset.
    inputUri: Input video location. Currently, only [Cloud
      Storage](https://cloud.google.com/storage/) URIs are supported. URIs
      must be specified in the following format: `gs://bucket-id/object-id`
      (other URI formats return google.rpc.Code.INVALID_ARGUMENT). For more
      information, see [Request URIs](https://cloud.google.com/storage/docs
      /request-endpoints). To identify multiple videos, a video URI may
      include wildcards in the `object-id`. Supported wildcards: '*' to match
      0 or more characters; '?' to match 1 character. If unset, the input
      video should be embedded in the request as `input_content`. If set,
      `input_content` must be unset.
    locationId: Optional. Cloud region where annotation should take place.
      Supported cloud regions are: `us-east1`, `us-west1`, `europe-west1`,
      `asia-east1`. If no region is specified, the region will be determined
      based on video file location.
    outputUri: Optional. Location where the output (in JSON format) should be
      stored. Currently, only [Cloud
      Storage](https://cloud.google.com/storage/) URIs are supported. These
      must be specified in the following format: `gs://bucket-id/object-id`
      (other URI formats return google.rpc.Code.INVALID_ARGUMENT). For more
      information, see [Request URIs](https://cloud.google.com/storage/docs
      /request-endpoints).
    videoContext: Additional video context and/or feature-specific parameters.
  """

  class FeaturesValueListEntryValuesEnum(_messages.Enum):
    r"""FeaturesValueListEntryValuesEnum enum type.

    Values:
      FEATURE_UNSPECIFIED: <no description>
      LABEL_DETECTION: <no description>
      SHOT_CHANGE_DETECTION: <no description>
      EXPLICIT_CONTENT_DETECTION: <no description>
      SPEECH_TRANSCRIPTION: <no description>
      TEXT_DETECTION: <no description>
      OBJECT_TRACKING: <no description>
      LOGO_RECOGNITION: <no description>
    """
    FEATURE_UNSPECIFIED = 0
    LABEL_DETECTION = 1
    SHOT_CHANGE_DETECTION = 2
    EXPLICIT_CONTENT_DETECTION = 3
    SPEECH_TRANSCRIPTION = 4
    TEXT_DETECTION = 5
    OBJECT_TRACKING = 6
    LOGO_RECOGNITION = 7

  features = _messages.EnumField('FeaturesValueListEntryValuesEnum', 1, repeated=True)
  inputContent = _messages.BytesField(2)
  inputUri = _messages.StringField(3)
  locationId = _messages.StringField(4)
  outputUri = _messages.StringField(5)
  videoContext = _messages.MessageField('GoogleCloudVideointelligenceV1VideoContext', 6)


class GoogleCloudVideointelligenceV1AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1DetectedAttribute(_messages.Message):
  r"""A generic detected attribute represented by name in string format.

  Fields:
    confidence: Detected attribute confidence. Range [0, 1].
    name: The name of the attribute, for example, glasses, dark_glasses,
      mouth_open. A full list of supported type names will be provided in the
      document.
    value: Text value of the detection result. For example, the value for
      "HairColor" can be "black", "blonde", etc.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  value = _messages.StringField(3)


class GoogleCloudVideointelligenceV1DetectedLandmark(_messages.Message):
  r"""A generic detected landmark represented by name in string format and a
  2D location.

  Fields:
    confidence: The confidence score of the detected landmark. Range [0, 1].
    name: The name of this landmark, for example, left_hand, right_shoulder.
    point: The 2D point of the detected landmark using the normalized image
      coordindate system. The normalized coordinates have the range from 0 to
      1.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  point = _messages.MessageField('GoogleCloudVideointelligenceV1NormalizedVertex', 3)


class GoogleCloudVideointelligenceV1Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g., `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
    version: Feature version.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1ExplicitContentFrame', 1, repeated=True)
  version = _messages.StringField(2)


class GoogleCloudVideointelligenceV1ExplicitContentDetectionConfig(_messages.Message):
  r"""Config for EXPLICIT_CONTENT_DETECTION.

  Fields:
    model: Model to use for explicit content detection. Supported values:
      "builtin/stable" (the default if unset) and "builtin/latest".
  """

  model = _messages.StringField(1)


class GoogleCloudVideointelligenceV1ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. For example,
      when the label is `Terrier`, the category is likely `dog`. And in some
      cases there might be more than one categories e.g., `Terrier` could also
      be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
    version: Feature version.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1LabelSegment', 4, repeated=True)
  version = _messages.StringField(5)


class GoogleCloudVideointelligenceV1LabelDetectionConfig(_messages.Message):
  r"""Config for LABEL_DETECTION.

  Enums:
    LabelDetectionModeValueValuesEnum: What labels should be detected with
      LABEL_DETECTION, in addition to video-level labels or segment-level
      labels. If unspecified, defaults to `SHOT_MODE`.

  Fields:
    frameConfidenceThreshold: The confidence threshold we perform filtering on
      the labels from frame-level detection. If not set, it is set to 0.4 by
      default. The valid range for this threshold is [0.1, 0.9]. Any value set
      outside of this range will be clipped. Note: For best results, follow
      the default threshold. We will update the default threshold everytime
      when we release a new model.
    labelDetectionMode: What labels should be detected with LABEL_DETECTION,
      in addition to video-level labels or segment-level labels. If
      unspecified, defaults to `SHOT_MODE`.
    model: Model to use for label detection. Supported values:
      "builtin/stable" (the default if unset) and "builtin/latest".
    stationaryCamera: Whether the video has been shot from a stationary (i.e.,
      non-moving) camera. When set to true, might improve detection accuracy
      for moving objects. Should be used with `SHOT_AND_FRAME_MODE` enabled.
    videoConfidenceThreshold: The confidence threshold we perform filtering on
      the labels from video-level and shot-level detections. If not set, it's
      set to 0.3 by default. The valid range for this threshold is [0.1, 0.9].
      Any value set outside of this range will be clipped. Note: For best
      results, follow the default threshold. We will update the default
      threshold everytime when we release a new model.
  """

  class LabelDetectionModeValueValuesEnum(_messages.Enum):
    r"""What labels should be detected with LABEL_DETECTION, in addition to
    video-level labels or segment-level labels. If unspecified, defaults to
    `SHOT_MODE`.

    Values:
      LABEL_DETECTION_MODE_UNSPECIFIED: Unspecified.
      SHOT_MODE: Detect shot-level labels.
      FRAME_MODE: Detect frame-level labels.
      SHOT_AND_FRAME_MODE: Detect both shot-level and frame-level labels.
    """
    LABEL_DETECTION_MODE_UNSPECIFIED = 0
    SHOT_MODE = 1
    FRAME_MODE = 2
    SHOT_AND_FRAME_MODE = 3

  frameConfidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  labelDetectionMode = _messages.EnumField('LabelDetectionModeValueValuesEnum', 2)
  model = _messages.StringField(3)
  stationaryCamera = _messages.BooleanField(4)
  videoConfidenceThreshold = _messages.FloatField(5, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 2)


class GoogleCloudVideointelligenceV1LogoRecognitionAnnotation(_messages.Message):
  r"""Annotation corresponding to one detected, tracked and recognized logo
  class.

  Fields:
    entity: Entity category information to specify the logo class that all the
      logo tracks within this LogoRecognitionAnnotation are recognized as.
    segments: All video segments where the recognized logo appears. There
      might be multiple instances of the same logo class appearing in one
      VideoSegment.
    tracks: All logo tracks where the recognized logo appears. Each track
      corresponds to one logo instance appearing in consecutive frames.
  """

  entity = _messages.MessageField('GoogleCloudVideointelligenceV1Entity', 1)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 2, repeated=True)
  tracks = _messages.MessageField('GoogleCloudVideointelligenceV1Track', 3, repeated=True)


class GoogleCloudVideointelligenceV1NormalizedBoundingBox(_messages.Message):
  r"""Normalized bounding box. The normalized vertex coordinates are relative
  to the original image. Range: [0, 1].

  Fields:
    bottom: Bottom Y coordinate.
    left: Left X coordinate.
    right: Right X coordinate.
    top: Top Y coordinate.
  """

  bottom = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  left = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  right = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  top = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1NormalizedBoundingPoly(_messages.Message):
  r"""Normalized bounding polygon for text (that might not be aligned with
  axis). Contains list of the corner points in clockwise order starting from
  top-left corner. For example, for a rectangular bounding box: When the text
  is horizontal it might look like:         0----1         |    |         3
  ----2  When it's clockwise rotated 180 degrees around the top-left corner it
  becomes:         2----3         |    |         1----0  and the vertex order
  will still be (0, 1, 2, 3). Note that values can be less than 0, or greater
  than 1 due to trignometric calculations for location of the box.

  Fields:
    vertices: Normalized vertices of the bounding polygon.
  """

  vertices = _messages.MessageField('GoogleCloudVideointelligenceV1NormalizedVertex', 1, repeated=True)


class GoogleCloudVideointelligenceV1NormalizedVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1ObjectTrackingAnnotation(_messages.Message):
  r"""Annotations corresponding to one tracked object.

  Fields:
    confidence: Object category's labeling confidence of this track.
    entity: Entity to specify the object category that this track is labeled
      as.
    frames: Information corresponding to all frames where this object track
      appears. Non-streaming batch mode: it may be one or multiple
      ObjectTrackingFrame messages in frames. Streaming mode: it can only be
      one ObjectTrackingFrame message in frames.
    segment: Non-streaming batch mode ONLY. Each object track corresponds to
      one video segment where it appears.
    trackId: Streaming mode ONLY. In streaming mode, we do not know the end
      time of a tracked object before it is completed. Hence, there is no
      VideoSegment info returned. Instead, we provide a unique identifiable
      integer track_id so that the customers can correlate the results of the
      ongoing ObjectTrackAnnotation of the same track_id over time.
    version: Feature version.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1ObjectTrackingFrame', 3, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 4)
  trackId = _messages.IntegerField(5)
  version = _messages.StringField(6)


class GoogleCloudVideointelligenceV1ObjectTrackingConfig(_messages.Message):
  r"""Config for OBJECT_TRACKING.

  Fields:
    model: Model to use for object tracking. Supported values:
      "builtin/stable" (the default if unset) and "builtin/latest".
  """

  model = _messages.StringField(1)


class GoogleCloudVideointelligenceV1ObjectTrackingFrame(_messages.Message):
  r"""Video frame level annotations for object detection and tracking. This
  field stores per frame location, time offset, and confidence.

  Fields:
    normalizedBoundingBox: The normalized bounding box location of this object
      track for the frame.
    timeOffset: The timestamp of the frame in microseconds.
  """

  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1NormalizedBoundingBox', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1ShotChangeDetectionConfig(_messages.Message):
  r"""Config for SHOT_CHANGE_DETECTION.

  Fields:
    model: Model to use for shot change detection. Supported values:
      "builtin/stable" (the default if unset) and "builtin/latest".
  """

  model = _messages.StringField(1)


class GoogleCloudVideointelligenceV1SpeechContext(_messages.Message):
  r"""Provides "hints" to the speech recognizer to favor specific words and
  phrases in the results.

  Fields:
    phrases: Optional. A list of strings containing words and phrases "hints"
      so that the speech recognition is more likely to recognize them. This
      can be used to improve the accuracy for specific words and phrases, for
      example, if specific commands are typically spoken by the user. This can
      also be used to add additional words to the vocabulary of the
      recognizer. See [usage
      limits](https://cloud.google.com/speech/limits#content).
  """

  phrases = _messages.StringField(1, repeated=True)


class GoogleCloudVideointelligenceV1SpeechRecognitionAlternative(_messages.Message):
  r"""Alternative hypotheses (a.k.a. n-best list).

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    transcript: Transcript text representing the words that the user spoke.
    words: Output only. A list of word-specific information for each
      recognized word. Note: When `enable_speaker_diarization` is set to true,
      you will see all the words from the beginning of the audio.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  transcript = _messages.StringField(2)
  words = _messages.MessageField('GoogleCloudVideointelligenceV1WordInfo', 3, repeated=True)


class GoogleCloudVideointelligenceV1SpeechTranscription(_messages.Message):
  r"""A speech recognition result corresponding to a portion of the audio.

  Fields:
    alternatives: May contain one or more recognition hypotheses (up to the
      maximum specified in `max_alternatives`).  These alternatives are
      ordered in terms of accuracy, with the top (first) alternative being the
      most probable, as ranked by the recognizer.
    languageCode: Output only. The [BCP-47](https://www.rfc-
      editor.org/rfc/bcp/bcp47.txt) language tag of the language in this
      result. This language code was detected to have the most likelihood of
      being spoken in the audio.
  """

  alternatives = _messages.MessageField('GoogleCloudVideointelligenceV1SpeechRecognitionAlternative', 1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudVideointelligenceV1SpeechTranscriptionConfig(_messages.Message):
  r"""Config for SPEECH_TRANSCRIPTION.

  Fields:
    audioTracks: Optional. For file formats, such as MXF or MKV, supporting
      multiple audio tracks, specify up to two tracks. Default: track 0.
    diarizationSpeakerCount: Optional. If set, specifies the estimated number
      of speakers in the conversation. If not set, defaults to '2'. Ignored
      unless enable_speaker_diarization is set to true.
    enableAutomaticPunctuation: Optional. If 'true', adds punctuation to
      recognition result hypotheses. This feature is only available in select
      languages. Setting this for requests in other languages has no effect at
      all. The default 'false' value does not add punctuation to result
      hypotheses. NOTE: "This is currently offered as an experimental service,
      complimentary to all users. In the future this may be exclusively
      available as a premium feature."
    enableSpeakerDiarization: Optional. If 'true', enables speaker detection
      for each recognized word in the top alternative of the recognition
      result using a speaker_tag provided in the WordInfo. Note: When this is
      true, we send all the words from the beginning of the audio for the top
      alternative in every consecutive response. This is done in order to
      improve our speaker tags as our models learn to identify the speakers in
      the conversation over time.
    enableWordConfidence: Optional. If `true`, the top result includes a list
      of words and the confidence for those words. If `false`, no word-level
      confidence information is returned. The default is `false`.
    filterProfanity: Optional. If set to `true`, the server will attempt to
      filter out profanities, replacing all but the initial character in each
      filtered word with asterisks, e.g. "f***". If set to `false` or omitted,
      profanities won't be filtered out.
    languageCode: Required. *Required* The language of the supplied audio as a
      [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
      Example: "en-US". See [Language
      Support](https://cloud.google.com/speech/docs/languages) for a list of
      the currently supported language codes.
    maxAlternatives: Optional. Maximum number of recognition hypotheses to be
      returned. Specifically, the maximum number of
      `SpeechRecognitionAlternative` messages within each
      `SpeechTranscription`. The server may return fewer than
      `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1`
      will return a maximum of one. If omitted, will return a maximum of one.
    speechContexts: Optional. A means to provide context to assist the speech
      recognition.
  """

  audioTracks = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  diarizationSpeakerCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  enableAutomaticPunctuation = _messages.BooleanField(3)
  enableSpeakerDiarization = _messages.BooleanField(4)
  enableWordConfidence = _messages.BooleanField(5)
  filterProfanity = _messages.BooleanField(6)
  languageCode = _messages.StringField(7)
  maxAlternatives = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  speechContexts = _messages.MessageField('GoogleCloudVideointelligenceV1SpeechContext', 9, repeated=True)


class GoogleCloudVideointelligenceV1TextAnnotation(_messages.Message):
  r"""Annotations related to one detected OCR text snippet. This will contain
  the corresponding text, confidence value, and frame level information for
  each detection.

  Fields:
    segments: All video segments where OCR detected text appears.
    text: The detected text.
    version: Feature version.
  """

  segments = _messages.MessageField('GoogleCloudVideointelligenceV1TextSegment', 1, repeated=True)
  text = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudVideointelligenceV1TextDetectionConfig(_messages.Message):
  r"""Config for TEXT_DETECTION.

  Fields:
    languageHints: Language hint can be specified if the language to be
      detected is known a priori. It can increase the accuracy of the
      detection. Language hint must be language code in BCP-47 format.
      Automatic language detection is performed if no hint is provided.
    model: Model to use for text detection. Supported values: "builtin/stable"
      (the default if unset) and "builtin/latest".
  """

  languageHints = _messages.StringField(1, repeated=True)
  model = _messages.StringField(2)


class GoogleCloudVideointelligenceV1TextFrame(_messages.Message):
  r"""Video frame level annotation results for text annotation (OCR). Contains
  information regarding timestamp and bounding box locations for the frames
  containing detected OCR text snippets.

  Fields:
    rotatedBoundingBox: Bounding polygon of the detected text for this frame.
    timeOffset: Timestamp of this frame.
  """

  rotatedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1NormalizedBoundingPoly', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1TextSegment(_messages.Message):
  r"""Video segment level annotation results for text detection.

  Fields:
    confidence: Confidence for the track of detected text. It is calculated as
      the highest over all frames where OCR detected text appears.
    frames: Information related to the frames where OCR detected text appears.
    segment: Video segment where a text snippet was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1TextFrame', 2, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 3)


class GoogleCloudVideointelligenceV1TimestampedObject(_messages.Message):
  r"""For tracking related features. An object at time_offset with attributes,
  and located with normalized_bounding_box.

  Fields:
    attributes: Optional. The attributes of the object in the bounding box.
    landmarks: Optional. The detected landmarks.
    normalizedBoundingBox: Normalized Bounding box in a frame, where the
      object is located.
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this object.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1DetectedAttribute', 1, repeated=True)
  landmarks = _messages.MessageField('GoogleCloudVideointelligenceV1DetectedLandmark', 2, repeated=True)
  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1NormalizedBoundingBox', 3)
  timeOffset = _messages.StringField(4)


class GoogleCloudVideointelligenceV1Track(_messages.Message):
  r"""A track of an object instance.

  Fields:
    attributes: Optional. Attributes in the track level.
    confidence: Optional. The confidence score of the tracked object.
    segment: Video segment of a track.
    timestampedObjects: The object with timestamp and attributes per frame in
      the track.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1DetectedAttribute', 1, repeated=True)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 3)
  timestampedObjects = _messages.MessageField('GoogleCloudVideointelligenceV1TimestampedObject', 4, repeated=True)


class GoogleCloudVideointelligenceV1VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Enums:
    FeatureValueValuesEnum: Specifies which feature is being tracked if the
      request contains more than one feature.

  Fields:
    feature: Specifies which feature is being tracked if the request contains
      more than one feature.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    segment: Specifies which segment is being tracked if the request contains
      more than one segment.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  class FeatureValueValuesEnum(_messages.Enum):
    r"""Specifies which feature is being tracked if the request contains more
    than one feature.

    Values:
      FEATURE_UNSPECIFIED: Unspecified.
      LABEL_DETECTION: Label detection. Detect objects, such as dog or flower.
      SHOT_CHANGE_DETECTION: Shot change detection.
      EXPLICIT_CONTENT_DETECTION: Explicit content detection.
      SPEECH_TRANSCRIPTION: Speech transcription.
      TEXT_DETECTION: OCR text detection and tracking.
      OBJECT_TRACKING: Object detection and tracking.
      LOGO_RECOGNITION: Logo detection, tracking, and recognition.
    """
    FEATURE_UNSPECIFIED = 0
    LABEL_DETECTION = 1
    SHOT_CHANGE_DETECTION = 2
    EXPLICIT_CONTENT_DETECTION = 3
    SPEECH_TRANSCRIPTION = 4
    TEXT_DETECTION = 5
    OBJECT_TRACKING = 6
    LOGO_RECOGNITION = 7

  feature = _messages.EnumField('FeatureValueValuesEnum', 1)
  inputUri = _messages.StringField(2)
  progressPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 4)
  startTime = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudVideointelligenceV1VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    logoRecognitionAnnotations: Annotations for list of logos detected,
      tracked and recognized in video.
    objectAnnotations: Annotations for list of objects detected and tracked in
      video.
    segment: Video segment on which the annotation is run.
    segmentLabelAnnotations: Topical label annotations on video level or user-
      specified segment level. There is exactly one element for each unique
      label.
    segmentPresenceLabelAnnotations: Presence label annotations on video level
      or user-specified segment level. There is exactly one element for each
      unique label. Compared to the existing topical
      `segment_label_annotations`, this field presents more fine-grained,
      segment-level labels detected in video content and is made available
      only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Topical label annotations on shot level. There is
      exactly one element for each unique label.
    shotPresenceLabelAnnotations: Presence label annotations on shot level.
      There is exactly one element for each unique label. Compared to the
      existing topical `shot_label_annotations`, this field presents more
      fine-grained, shot-level labels detected in video content and is made
      available only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    speechTranscriptions: Speech transcription.
    textAnnotations: OCR text detection and tracking. Annotations for list of
      detected text snippets. Each will have list of frame information
      associated with it.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  logoRecognitionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LogoRecognitionAnnotation', 5, repeated=True)
  objectAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1ObjectTrackingAnnotation', 6, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 7)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 8, repeated=True)
  segmentPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 9, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 10, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 11, repeated=True)
  shotPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 12, repeated=True)
  speechTranscriptions = _messages.MessageField('GoogleCloudVideointelligenceV1SpeechTranscription', 13, repeated=True)
  textAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1TextAnnotation', 14, repeated=True)


class GoogleCloudVideointelligenceV1VideoContext(_messages.Message):
  r"""Video context and/or feature-specific parameters.

  Fields:
    explicitContentDetectionConfig: Config for EXPLICIT_CONTENT_DETECTION.
    labelDetectionConfig: Config for LABEL_DETECTION.
    objectTrackingConfig: Config for OBJECT_TRACKING.
    segments: Video segments to annotate. The segments may overlap and are not
      required to be contiguous or span the whole video. If unspecified, each
      video is treated as a single segment.
    shotChangeDetectionConfig: Config for SHOT_CHANGE_DETECTION.
    speechTranscriptionConfig: Config for SPEECH_TRANSCRIPTION.
    textDetectionConfig: Config for TEXT_DETECTION.
  """

  explicitContentDetectionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1ExplicitContentDetectionConfig', 1)
  labelDetectionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1LabelDetectionConfig', 2)
  objectTrackingConfig = _messages.MessageField('GoogleCloudVideointelligenceV1ObjectTrackingConfig', 3)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 4, repeated=True)
  shotChangeDetectionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1ShotChangeDetectionConfig', 5)
  speechTranscriptionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1SpeechTranscriptionConfig', 6)
  textDetectionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1TextDetectionConfig', 7)


class GoogleCloudVideointelligenceV1VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1WordInfo(_messages.Message):
  r"""Word-specific information for recognized words. Word information is only
  included in the response when certain request parameters are set, such as
  `enable_word_time_offsets`.

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    endTime: Time offset relative to the beginning of the audio, and
      corresponding to the end of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    speakerTag: Output only. A distinct integer value is assigned for every
      speaker within the audio. This field specifies which one of those
      speakers was detected to have spoken this word. Value ranges from 1 up
      to diarization_speaker_count, and is only set if speaker diarization is
      enabled.
    startTime: Time offset relative to the beginning of the audio, and
      corresponding to the start of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    word: The word corresponding to this set of information.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  endTime = _messages.StringField(2)
  speakerTag = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(4)
  word = _messages.StringField(5)


class GoogleCloudVideointelligenceV1beta2AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1beta2AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1beta2DetectedAttribute(_messages.Message):
  r"""A generic detected attribute represented by name in string format.

  Fields:
    confidence: Detected attribute confidence. Range [0, 1].
    name: The name of the attribute, for example, glasses, dark_glasses,
      mouth_open. A full list of supported type names will be provided in the
      document.
    value: Text value of the detection result. For example, the value for
      "HairColor" can be "black", "blonde", etc.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  value = _messages.StringField(3)


class GoogleCloudVideointelligenceV1beta2DetectedLandmark(_messages.Message):
  r"""A generic detected landmark represented by name in string format and a
  2D location.

  Fields:
    confidence: The confidence score of the detected landmark. Range [0, 1].
    name: The name of this landmark, for example, left_hand, right_shoulder.
    point: The 2D point of the detected landmark using the normalized image
      coordindate system. The normalized coordinates have the range from 0 to
      1.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  point = _messages.MessageField('GoogleCloudVideointelligenceV1beta2NormalizedVertex', 3)


class GoogleCloudVideointelligenceV1beta2Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g., `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1beta2ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
    version: Feature version.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1beta2ExplicitContentFrame', 1, repeated=True)
  version = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. For example,
      when the label is `Terrier`, the category is likely `dog`. And in some
      cases there might be more than one categories e.g., `Terrier` could also
      be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
    version: Feature version.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1beta2Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1beta2Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelSegment', 4, repeated=True)
  version = _messages.StringField(5)


class GoogleCloudVideointelligenceV1beta2LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 2)


class GoogleCloudVideointelligenceV1beta2LogoRecognitionAnnotation(_messages.Message):
  r"""Annotation corresponding to one detected, tracked and recognized logo
  class.

  Fields:
    entity: Entity category information to specify the logo class that all the
      logo tracks within this LogoRecognitionAnnotation are recognized as.
    segments: All video segments where the recognized logo appears. There
      might be multiple instances of the same logo class appearing in one
      VideoSegment.
    tracks: All logo tracks where the recognized logo appears. Each track
      corresponds to one logo instance appearing in consecutive frames.
  """

  entity = _messages.MessageField('GoogleCloudVideointelligenceV1beta2Entity', 1)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 2, repeated=True)
  tracks = _messages.MessageField('GoogleCloudVideointelligenceV1beta2Track', 3, repeated=True)


class GoogleCloudVideointelligenceV1beta2NormalizedBoundingBox(_messages.Message):
  r"""Normalized bounding box. The normalized vertex coordinates are relative
  to the original image. Range: [0, 1].

  Fields:
    bottom: Bottom Y coordinate.
    left: Left X coordinate.
    right: Right X coordinate.
    top: Top Y coordinate.
  """

  bottom = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  left = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  right = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  top = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1beta2NormalizedBoundingPoly(_messages.Message):
  r"""Normalized bounding polygon for text (that might not be aligned with
  axis). Contains list of the corner points in clockwise order starting from
  top-left corner. For example, for a rectangular bounding box: When the text
  is horizontal it might look like:         0----1         |    |         3
  ----2  When it's clockwise rotated 180 degrees around the top-left corner it
  becomes:         2----3         |    |         1----0  and the vertex order
  will still be (0, 1, 2, 3). Note that values can be less than 0, or greater
  than 1 due to trignometric calculations for location of the box.

  Fields:
    vertices: Normalized vertices of the bounding polygon.
  """

  vertices = _messages.MessageField('GoogleCloudVideointelligenceV1beta2NormalizedVertex', 1, repeated=True)


class GoogleCloudVideointelligenceV1beta2NormalizedVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1beta2ObjectTrackingAnnotation(_messages.Message):
  r"""Annotations corresponding to one tracked object.

  Fields:
    confidence: Object category's labeling confidence of this track.
    entity: Entity to specify the object category that this track is labeled
      as.
    frames: Information corresponding to all frames where this object track
      appears. Non-streaming batch mode: it may be one or multiple
      ObjectTrackingFrame messages in frames. Streaming mode: it can only be
      one ObjectTrackingFrame message in frames.
    segment: Non-streaming batch mode ONLY. Each object track corresponds to
      one video segment where it appears.
    trackId: Streaming mode ONLY. In streaming mode, we do not know the end
      time of a tracked object before it is completed. Hence, there is no
      VideoSegment info returned. Instead, we provide a unique identifiable
      integer track_id so that the customers can correlate the results of the
      ongoing ObjectTrackAnnotation of the same track_id over time.
    version: Feature version.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1beta2Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1beta2ObjectTrackingFrame', 3, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 4)
  trackId = _messages.IntegerField(5)
  version = _messages.StringField(6)


class GoogleCloudVideointelligenceV1beta2ObjectTrackingFrame(_messages.Message):
  r"""Video frame level annotations for object detection and tracking. This
  field stores per frame location, time offset, and confidence.

  Fields:
    normalizedBoundingBox: The normalized bounding box location of this object
      track for the frame.
    timeOffset: The timestamp of the frame in microseconds.
  """

  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1beta2NormalizedBoundingBox', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2SpeechRecognitionAlternative(_messages.Message):
  r"""Alternative hypotheses (a.k.a. n-best list).

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    transcript: Transcript text representing the words that the user spoke.
    words: Output only. A list of word-specific information for each
      recognized word. Note: When `enable_speaker_diarization` is set to true,
      you will see all the words from the beginning of the audio.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  transcript = _messages.StringField(2)
  words = _messages.MessageField('GoogleCloudVideointelligenceV1beta2WordInfo', 3, repeated=True)


class GoogleCloudVideointelligenceV1beta2SpeechTranscription(_messages.Message):
  r"""A speech recognition result corresponding to a portion of the audio.

  Fields:
    alternatives: May contain one or more recognition hypotheses (up to the
      maximum specified in `max_alternatives`).  These alternatives are
      ordered in terms of accuracy, with the top (first) alternative being the
      most probable, as ranked by the recognizer.
    languageCode: Output only. The [BCP-47](https://www.rfc-
      editor.org/rfc/bcp/bcp47.txt) language tag of the language in this
      result. This language code was detected to have the most likelihood of
      being spoken in the audio.
  """

  alternatives = _messages.MessageField('GoogleCloudVideointelligenceV1beta2SpeechRecognitionAlternative', 1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2TextAnnotation(_messages.Message):
  r"""Annotations related to one detected OCR text snippet. This will contain
  the corresponding text, confidence value, and frame level information for
  each detection.

  Fields:
    segments: All video segments where OCR detected text appears.
    text: The detected text.
    version: Feature version.
  """

  segments = _messages.MessageField('GoogleCloudVideointelligenceV1beta2TextSegment', 1, repeated=True)
  text = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudVideointelligenceV1beta2TextFrame(_messages.Message):
  r"""Video frame level annotation results for text annotation (OCR). Contains
  information regarding timestamp and bounding box locations for the frames
  containing detected OCR text snippets.

  Fields:
    rotatedBoundingBox: Bounding polygon of the detected text for this frame.
    timeOffset: Timestamp of this frame.
  """

  rotatedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1beta2NormalizedBoundingPoly', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2TextSegment(_messages.Message):
  r"""Video segment level annotation results for text detection.

  Fields:
    confidence: Confidence for the track of detected text. It is calculated as
      the highest over all frames where OCR detected text appears.
    frames: Information related to the frames where OCR detected text appears.
    segment: Video segment where a text snippet was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1beta2TextFrame', 2, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 3)


class GoogleCloudVideointelligenceV1beta2TimestampedObject(_messages.Message):
  r"""For tracking related features. An object at time_offset with attributes,
  and located with normalized_bounding_box.

  Fields:
    attributes: Optional. The attributes of the object in the bounding box.
    landmarks: Optional. The detected landmarks.
    normalizedBoundingBox: Normalized Bounding box in a frame, where the
      object is located.
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this object.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1beta2DetectedAttribute', 1, repeated=True)
  landmarks = _messages.MessageField('GoogleCloudVideointelligenceV1beta2DetectedLandmark', 2, repeated=True)
  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1beta2NormalizedBoundingBox', 3)
  timeOffset = _messages.StringField(4)


class GoogleCloudVideointelligenceV1beta2Track(_messages.Message):
  r"""A track of an object instance.

  Fields:
    attributes: Optional. Attributes in the track level.
    confidence: Optional. The confidence score of the tracked object.
    segment: Video segment of a track.
    timestampedObjects: The object with timestamp and attributes per frame in
      the track.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1beta2DetectedAttribute', 1, repeated=True)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 3)
  timestampedObjects = _messages.MessageField('GoogleCloudVideointelligenceV1beta2TimestampedObject', 4, repeated=True)


class GoogleCloudVideointelligenceV1beta2VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Enums:
    FeatureValueValuesEnum: Specifies which feature is being tracked if the
      request contains more than one feature.

  Fields:
    feature: Specifies which feature is being tracked if the request contains
      more than one feature.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    segment: Specifies which segment is being tracked if the request contains
      more than one segment.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  class FeatureValueValuesEnum(_messages.Enum):
    r"""Specifies which feature is being tracked if the request contains more
    than one feature.

    Values:
      FEATURE_UNSPECIFIED: Unspecified.
      LABEL_DETECTION: Label detection. Detect objects, such as dog or flower.
      SHOT_CHANGE_DETECTION: Shot change detection.
      EXPLICIT_CONTENT_DETECTION: Explicit content detection.
      SPEECH_TRANSCRIPTION: Speech transcription.
      TEXT_DETECTION: OCR text detection and tracking.
      OBJECT_TRACKING: Object detection and tracking.
      LOGO_RECOGNITION: Logo detection, tracking, and recognition.
    """
    FEATURE_UNSPECIFIED = 0
    LABEL_DETECTION = 1
    SHOT_CHANGE_DETECTION = 2
    EXPLICIT_CONTENT_DETECTION = 3
    SPEECH_TRANSCRIPTION = 4
    TEXT_DETECTION = 5
    OBJECT_TRACKING = 6
    LOGO_RECOGNITION = 7

  feature = _messages.EnumField('FeatureValueValuesEnum', 1)
  inputUri = _messages.StringField(2)
  progressPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 4)
  startTime = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudVideointelligenceV1beta2VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    logoRecognitionAnnotations: Annotations for list of logos detected,
      tracked and recognized in video.
    objectAnnotations: Annotations for list of objects detected and tracked in
      video.
    segment: Video segment on which the annotation is run.
    segmentLabelAnnotations: Topical label annotations on video level or user-
      specified segment level. There is exactly one element for each unique
      label.
    segmentPresenceLabelAnnotations: Presence label annotations on video level
      or user-specified segment level. There is exactly one element for each
      unique label. Compared to the existing topical
      `segment_label_annotations`, this field presents more fine-grained,
      segment-level labels detected in video content and is made available
      only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Topical label annotations on shot level. There is
      exactly one element for each unique label.
    shotPresenceLabelAnnotations: Presence label annotations on shot level.
      There is exactly one element for each unique label. Compared to the
      existing topical `shot_label_annotations`, this field presents more
      fine-grained, shot-level labels detected in video content and is made
      available only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    speechTranscriptions: Speech transcription.
    textAnnotations: OCR text detection and tracking. Annotations for list of
      detected text snippets. Each will have list of frame information
      associated with it.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1beta2ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  logoRecognitionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LogoRecognitionAnnotation', 5, repeated=True)
  objectAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2ObjectTrackingAnnotation', 6, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 7)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 8, repeated=True)
  segmentPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 9, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 10, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 11, repeated=True)
  shotPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 12, repeated=True)
  speechTranscriptions = _messages.MessageField('GoogleCloudVideointelligenceV1beta2SpeechTranscription', 13, repeated=True)
  textAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2TextAnnotation', 14, repeated=True)


class GoogleCloudVideointelligenceV1beta2VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2WordInfo(_messages.Message):
  r"""Word-specific information for recognized words. Word information is only
  included in the response when certain request parameters are set, such as
  `enable_word_time_offsets`.

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    endTime: Time offset relative to the beginning of the audio, and
      corresponding to the end of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    speakerTag: Output only. A distinct integer value is assigned for every
      speaker within the audio. This field specifies which one of those
      speakers was detected to have spoken this word. Value ranges from 1 up
      to diarization_speaker_count, and is only set if speaker diarization is
      enabled.
    startTime: Time offset relative to the beginning of the audio, and
      corresponding to the start of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    word: The word corresponding to this set of information.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  endTime = _messages.StringField(2)
  speakerTag = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(4)
  word = _messages.StringField(5)


class GoogleCloudVideointelligenceV1p1beta1AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1DetectedAttribute(_messages.Message):
  r"""A generic detected attribute represented by name in string format.

  Fields:
    confidence: Detected attribute confidence. Range [0, 1].
    name: The name of the attribute, for example, glasses, dark_glasses,
      mouth_open. A full list of supported type names will be provided in the
      document.
    value: Text value of the detection result. For example, the value for
      "HairColor" can be "black", "blonde", etc.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  value = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p1beta1DetectedLandmark(_messages.Message):
  r"""A generic detected landmark represented by name in string format and a
  2D location.

  Fields:
    confidence: The confidence score of the detected landmark. Range [0, 1].
    name: The name of this landmark, for example, left_hand, right_shoulder.
    point: The 2D point of the detected landmark using the normalized image
      coordindate system. The normalized coordinates have the range from 0 to
      1.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  point = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1NormalizedVertex', 3)


class GoogleCloudVideointelligenceV1p1beta1Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g., `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p1beta1ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
    version: Feature version.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1ExplicitContentFrame', 1, repeated=True)
  version = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. For example,
      when the label is `Terrier`, the category is likely `dog`. And in some
      cases there might be more than one categories e.g., `Terrier` could also
      be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
    version: Feature version.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelSegment', 4, repeated=True)
  version = _messages.StringField(5)


class GoogleCloudVideointelligenceV1p1beta1LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 2)


class GoogleCloudVideointelligenceV1p1beta1LogoRecognitionAnnotation(_messages.Message):
  r"""Annotation corresponding to one detected, tracked and recognized logo
  class.

  Fields:
    entity: Entity category information to specify the logo class that all the
      logo tracks within this LogoRecognitionAnnotation are recognized as.
    segments: All video segments where the recognized logo appears. There
      might be multiple instances of the same logo class appearing in one
      VideoSegment.
    tracks: All logo tracks where the recognized logo appears. Each track
      corresponds to one logo instance appearing in consecutive frames.
  """

  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1Entity', 1)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 2, repeated=True)
  tracks = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1Track', 3, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1NormalizedBoundingBox(_messages.Message):
  r"""Normalized bounding box. The normalized vertex coordinates are relative
  to the original image. Range: [0, 1].

  Fields:
    bottom: Bottom Y coordinate.
    left: Left X coordinate.
    right: Right X coordinate.
    top: Top Y coordinate.
  """

  bottom = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  left = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  right = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  top = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p1beta1NormalizedBoundingPoly(_messages.Message):
  r"""Normalized bounding polygon for text (that might not be aligned with
  axis). Contains list of the corner points in clockwise order starting from
  top-left corner. For example, for a rectangular bounding box: When the text
  is horizontal it might look like:         0----1         |    |         3
  ----2  When it's clockwise rotated 180 degrees around the top-left corner it
  becomes:         2----3         |    |         1----0  and the vertex order
  will still be (0, 1, 2, 3). Note that values can be less than 0, or greater
  than 1 due to trignometric calculations for location of the box.

  Fields:
    vertices: Normalized vertices of the bounding polygon.
  """

  vertices = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1NormalizedVertex', 1, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1NormalizedVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p1beta1ObjectTrackingAnnotation(_messages.Message):
  r"""Annotations corresponding to one tracked object.

  Fields:
    confidence: Object category's labeling confidence of this track.
    entity: Entity to specify the object category that this track is labeled
      as.
    frames: Information corresponding to all frames where this object track
      appears. Non-streaming batch mode: it may be one or multiple
      ObjectTrackingFrame messages in frames. Streaming mode: it can only be
      one ObjectTrackingFrame message in frames.
    segment: Non-streaming batch mode ONLY. Each object track corresponds to
      one video segment where it appears.
    trackId: Streaming mode ONLY. In streaming mode, we do not know the end
      time of a tracked object before it is completed. Hence, there is no
      VideoSegment info returned. Instead, we provide a unique identifiable
      integer track_id so that the customers can correlate the results of the
      ongoing ObjectTrackAnnotation of the same track_id over time.
    version: Feature version.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1ObjectTrackingFrame', 3, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 4)
  trackId = _messages.IntegerField(5)
  version = _messages.StringField(6)


class GoogleCloudVideointelligenceV1p1beta1ObjectTrackingFrame(_messages.Message):
  r"""Video frame level annotations for object detection and tracking. This
  field stores per frame location, time offset, and confidence.

  Fields:
    normalizedBoundingBox: The normalized bounding box location of this object
      track for the frame.
    timeOffset: The timestamp of the frame in microseconds.
  """

  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1NormalizedBoundingBox', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1SpeechRecognitionAlternative(_messages.Message):
  r"""Alternative hypotheses (a.k.a. n-best list).

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    transcript: Transcript text representing the words that the user spoke.
    words: Output only. A list of word-specific information for each
      recognized word. Note: When `enable_speaker_diarization` is set to true,
      you will see all the words from the beginning of the audio.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  transcript = _messages.StringField(2)
  words = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1WordInfo', 3, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1SpeechTranscription(_messages.Message):
  r"""A speech recognition result corresponding to a portion of the audio.

  Fields:
    alternatives: May contain one or more recognition hypotheses (up to the
      maximum specified in `max_alternatives`).  These alternatives are
      ordered in terms of accuracy, with the top (first) alternative being the
      most probable, as ranked by the recognizer.
    languageCode: Output only. The [BCP-47](https://www.rfc-
      editor.org/rfc/bcp/bcp47.txt) language tag of the language in this
      result. This language code was detected to have the most likelihood of
      being spoken in the audio.
  """

  alternatives = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1SpeechRecognitionAlternative', 1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1TextAnnotation(_messages.Message):
  r"""Annotations related to one detected OCR text snippet. This will contain
  the corresponding text, confidence value, and frame level information for
  each detection.

  Fields:
    segments: All video segments where OCR detected text appears.
    text: The detected text.
    version: Feature version.
  """

  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1TextSegment', 1, repeated=True)
  text = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p1beta1TextFrame(_messages.Message):
  r"""Video frame level annotation results for text annotation (OCR). Contains
  information regarding timestamp and bounding box locations for the frames
  containing detected OCR text snippets.

  Fields:
    rotatedBoundingBox: Bounding polygon of the detected text for this frame.
    timeOffset: Timestamp of this frame.
  """

  rotatedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1NormalizedBoundingPoly', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1TextSegment(_messages.Message):
  r"""Video segment level annotation results for text detection.

  Fields:
    confidence: Confidence for the track of detected text. It is calculated as
      the highest over all frames where OCR detected text appears.
    frames: Information related to the frames where OCR detected text appears.
    segment: Video segment where a text snippet was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1TextFrame', 2, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 3)


class GoogleCloudVideointelligenceV1p1beta1TimestampedObject(_messages.Message):
  r"""For tracking related features. An object at time_offset with attributes,
  and located with normalized_bounding_box.

  Fields:
    attributes: Optional. The attributes of the object in the bounding box.
    landmarks: Optional. The detected landmarks.
    normalizedBoundingBox: Normalized Bounding box in a frame, where the
      object is located.
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this object.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1DetectedAttribute', 1, repeated=True)
  landmarks = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1DetectedLandmark', 2, repeated=True)
  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1NormalizedBoundingBox', 3)
  timeOffset = _messages.StringField(4)


class GoogleCloudVideointelligenceV1p1beta1Track(_messages.Message):
  r"""A track of an object instance.

  Fields:
    attributes: Optional. Attributes in the track level.
    confidence: Optional. The confidence score of the tracked object.
    segment: Video segment of a track.
    timestampedObjects: The object with timestamp and attributes per frame in
      the track.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1DetectedAttribute', 1, repeated=True)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 3)
  timestampedObjects = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1TimestampedObject', 4, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Enums:
    FeatureValueValuesEnum: Specifies which feature is being tracked if the
      request contains more than one feature.

  Fields:
    feature: Specifies which feature is being tracked if the request contains
      more than one feature.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    segment: Specifies which segment is being tracked if the request contains
      more than one segment.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  class FeatureValueValuesEnum(_messages.Enum):
    r"""Specifies which feature is being tracked if the request contains more
    than one feature.

    Values:
      FEATURE_UNSPECIFIED: Unspecified.
      LABEL_DETECTION: Label detection. Detect objects, such as dog or flower.
      SHOT_CHANGE_DETECTION: Shot change detection.
      EXPLICIT_CONTENT_DETECTION: Explicit content detection.
      SPEECH_TRANSCRIPTION: Speech transcription.
      TEXT_DETECTION: OCR text detection and tracking.
      OBJECT_TRACKING: Object detection and tracking.
      LOGO_RECOGNITION: Logo detection, tracking, and recognition.
    """
    FEATURE_UNSPECIFIED = 0
    LABEL_DETECTION = 1
    SHOT_CHANGE_DETECTION = 2
    EXPLICIT_CONTENT_DETECTION = 3
    SPEECH_TRANSCRIPTION = 4
    TEXT_DETECTION = 5
    OBJECT_TRACKING = 6
    LOGO_RECOGNITION = 7

  feature = _messages.EnumField('FeatureValueValuesEnum', 1)
  inputUri = _messages.StringField(2)
  progressPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 4)
  startTime = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudVideointelligenceV1p1beta1VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    logoRecognitionAnnotations: Annotations for list of logos detected,
      tracked and recognized in video.
    objectAnnotations: Annotations for list of objects detected and tracked in
      video.
    segment: Video segment on which the annotation is run.
    segmentLabelAnnotations: Topical label annotations on video level or user-
      specified segment level. There is exactly one element for each unique
      label.
    segmentPresenceLabelAnnotations: Presence label annotations on video level
      or user-specified segment level. There is exactly one element for each
      unique label. Compared to the existing topical
      `segment_label_annotations`, this field presents more fine-grained,
      segment-level labels detected in video content and is made available
      only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Topical label annotations on shot level. There is
      exactly one element for each unique label.
    shotPresenceLabelAnnotations: Presence label annotations on shot level.
      There is exactly one element for each unique label. Compared to the
      existing topical `shot_label_annotations`, this field presents more
      fine-grained, shot-level labels detected in video content and is made
      available only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    speechTranscriptions: Speech transcription.
    textAnnotations: OCR text detection and tracking. Annotations for list of
      detected text snippets. Each will have list of frame information
      associated with it.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  logoRecognitionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LogoRecognitionAnnotation', 5, repeated=True)
  objectAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1ObjectTrackingAnnotation', 6, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 7)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 8, repeated=True)
  segmentPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 9, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 10, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 11, repeated=True)
  shotPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 12, repeated=True)
  speechTranscriptions = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1SpeechTranscription', 13, repeated=True)
  textAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1TextAnnotation', 14, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1WordInfo(_messages.Message):
  r"""Word-specific information for recognized words. Word information is only
  included in the response when certain request parameters are set, such as
  `enable_word_time_offsets`.

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    endTime: Time offset relative to the beginning of the audio, and
      corresponding to the end of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    speakerTag: Output only. A distinct integer value is assigned for every
      speaker within the audio. This field specifies which one of those
      speakers was detected to have spoken this word. Value ranges from 1 up
      to diarization_speaker_count, and is only set if speaker diarization is
      enabled.
    startTime: Time offset relative to the beginning of the audio, and
      corresponding to the start of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    word: The word corresponding to this set of information.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  endTime = _messages.StringField(2)
  speakerTag = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(4)
  word = _messages.StringField(5)


class GoogleCloudVideointelligenceV1p2beta1AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1DetectedAttribute(_messages.Message):
  r"""A generic detected attribute represented by name in string format.

  Fields:
    confidence: Detected attribute confidence. Range [0, 1].
    name: The name of the attribute, for example, glasses, dark_glasses,
      mouth_open. A full list of supported type names will be provided in the
      document.
    value: Text value of the detection result. For example, the value for
      "HairColor" can be "black", "blonde", etc.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  value = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p2beta1DetectedLandmark(_messages.Message):
  r"""A generic detected landmark represented by name in string format and a
  2D location.

  Fields:
    confidence: The confidence score of the detected landmark. Range [0, 1].
    name: The name of this landmark, for example, left_hand, right_shoulder.
    point: The 2D point of the detected landmark using the normalized image
      coordindate system. The normalized coordinates have the range from 0 to
      1.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  point = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedVertex', 3)


class GoogleCloudVideointelligenceV1p2beta1Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g., `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p2beta1ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
    version: Feature version.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ExplicitContentFrame', 1, repeated=True)
  version = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. For example,
      when the label is `Terrier`, the category is likely `dog`. And in some
      cases there might be more than one categories e.g., `Terrier` could also
      be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
    version: Feature version.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelSegment', 4, repeated=True)
  version = _messages.StringField(5)


class GoogleCloudVideointelligenceV1p2beta1LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 2)


class GoogleCloudVideointelligenceV1p2beta1LogoRecognitionAnnotation(_messages.Message):
  r"""Annotation corresponding to one detected, tracked and recognized logo
  class.

  Fields:
    entity: Entity category information to specify the logo class that all the
      logo tracks within this LogoRecognitionAnnotation are recognized as.
    segments: All video segments where the recognized logo appears. There
      might be multiple instances of the same logo class appearing in one
      VideoSegment.
    tracks: All logo tracks where the recognized logo appears. Each track
      corresponds to one logo instance appearing in consecutive frames.
  """

  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Entity', 1)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 2, repeated=True)
  tracks = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Track', 3, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingBox(_messages.Message):
  r"""Normalized bounding box. The normalized vertex coordinates are relative
  to the original image. Range: [0, 1].

  Fields:
    bottom: Bottom Y coordinate.
    left: Left X coordinate.
    right: Right X coordinate.
    top: Top Y coordinate.
  """

  bottom = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  left = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  right = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  top = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingPoly(_messages.Message):
  r"""Normalized bounding polygon for text (that might not be aligned with
  axis). Contains list of the corner points in clockwise order starting from
  top-left corner. For example, for a rectangular bounding box: When the text
  is horizontal it might look like:         0----1         |    |         3
  ----2  When it's clockwise rotated 180 degrees around the top-left corner it
  becomes:         2----3         |    |         1----0  and the vertex order
  will still be (0, 1, 2, 3). Note that values can be less than 0, or greater
  than 1 due to trignometric calculations for location of the box.

  Fields:
    vertices: Normalized vertices of the bounding polygon.
  """

  vertices = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedVertex', 1, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1NormalizedVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p2beta1ObjectTrackingAnnotation(_messages.Message):
  r"""Annotations corresponding to one tracked object.

  Fields:
    confidence: Object category's labeling confidence of this track.
    entity: Entity to specify the object category that this track is labeled
      as.
    frames: Information corresponding to all frames where this object track
      appears. Non-streaming batch mode: it may be one or multiple
      ObjectTrackingFrame messages in frames. Streaming mode: it can only be
      one ObjectTrackingFrame message in frames.
    segment: Non-streaming batch mode ONLY. Each object track corresponds to
      one video segment where it appears.
    trackId: Streaming mode ONLY. In streaming mode, we do not know the end
      time of a tracked object before it is completed. Hence, there is no
      VideoSegment info returned. Instead, we provide a unique identifiable
      integer track_id so that the customers can correlate the results of the
      ongoing ObjectTrackAnnotation of the same track_id over time.
    version: Feature version.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ObjectTrackingFrame', 3, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 4)
  trackId = _messages.IntegerField(5)
  version = _messages.StringField(6)


class GoogleCloudVideointelligenceV1p2beta1ObjectTrackingFrame(_messages.Message):
  r"""Video frame level annotations for object detection and tracking. This
  field stores per frame location, time offset, and confidence.

  Fields:
    normalizedBoundingBox: The normalized bounding box location of this object
      track for the frame.
    timeOffset: The timestamp of the frame in microseconds.
  """

  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingBox', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1SpeechRecognitionAlternative(_messages.Message):
  r"""Alternative hypotheses (a.k.a. n-best list).

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    transcript: Transcript text representing the words that the user spoke.
    words: Output only. A list of word-specific information for each
      recognized word. Note: When `enable_speaker_diarization` is set to true,
      you will see all the words from the beginning of the audio.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  transcript = _messages.StringField(2)
  words = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1WordInfo', 3, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1SpeechTranscription(_messages.Message):
  r"""A speech recognition result corresponding to a portion of the audio.

  Fields:
    alternatives: May contain one or more recognition hypotheses (up to the
      maximum specified in `max_alternatives`).  These alternatives are
      ordered in terms of accuracy, with the top (first) alternative being the
      most probable, as ranked by the recognizer.
    languageCode: Output only. The [BCP-47](https://www.rfc-
      editor.org/rfc/bcp/bcp47.txt) language tag of the language in this
      result. This language code was detected to have the most likelihood of
      being spoken in the audio.
  """

  alternatives = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1SpeechRecognitionAlternative', 1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1TextAnnotation(_messages.Message):
  r"""Annotations related to one detected OCR text snippet. This will contain
  the corresponding text, confidence value, and frame level information for
  each detection.

  Fields:
    segments: All video segments where OCR detected text appears.
    text: The detected text.
    version: Feature version.
  """

  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1TextSegment', 1, repeated=True)
  text = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p2beta1TextFrame(_messages.Message):
  r"""Video frame level annotation results for text annotation (OCR). Contains
  information regarding timestamp and bounding box locations for the frames
  containing detected OCR text snippets.

  Fields:
    rotatedBoundingBox: Bounding polygon of the detected text for this frame.
    timeOffset: Timestamp of this frame.
  """

  rotatedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingPoly', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1TextSegment(_messages.Message):
  r"""Video segment level annotation results for text detection.

  Fields:
    confidence: Confidence for the track of detected text. It is calculated as
      the highest over all frames where OCR detected text appears.
    frames: Information related to the frames where OCR detected text appears.
    segment: Video segment where a text snippet was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1TextFrame', 2, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 3)


class GoogleCloudVideointelligenceV1p2beta1TimestampedObject(_messages.Message):
  r"""For tracking related features. An object at time_offset with attributes,
  and located with normalized_bounding_box.

  Fields:
    attributes: Optional. The attributes of the object in the bounding box.
    landmarks: Optional. The detected landmarks.
    normalizedBoundingBox: Normalized Bounding box in a frame, where the
      object is located.
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this object.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1DetectedAttribute', 1, repeated=True)
  landmarks = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1DetectedLandmark', 2, repeated=True)
  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingBox', 3)
  timeOffset = _messages.StringField(4)


class GoogleCloudVideointelligenceV1p2beta1Track(_messages.Message):
  r"""A track of an object instance.

  Fields:
    attributes: Optional. Attributes in the track level.
    confidence: Optional. The confidence score of the tracked object.
    segment: Video segment of a track.
    timestampedObjects: The object with timestamp and attributes per frame in
      the track.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1DetectedAttribute', 1, repeated=True)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 3)
  timestampedObjects = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1TimestampedObject', 4, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Enums:
    FeatureValueValuesEnum: Specifies which feature is being tracked if the
      request contains more than one feature.

  Fields:
    feature: Specifies which feature is being tracked if the request contains
      more than one feature.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    segment: Specifies which segment is being tracked if the request contains
      more than one segment.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  class FeatureValueValuesEnum(_messages.Enum):
    r"""Specifies which feature is being tracked if the request contains more
    than one feature.

    Values:
      FEATURE_UNSPECIFIED: Unspecified.
      LABEL_DETECTION: Label detection. Detect objects, such as dog or flower.
      SHOT_CHANGE_DETECTION: Shot change detection.
      EXPLICIT_CONTENT_DETECTION: Explicit content detection.
      SPEECH_TRANSCRIPTION: Speech transcription.
      TEXT_DETECTION: OCR text detection and tracking.
      OBJECT_TRACKING: Object detection and tracking.
      LOGO_RECOGNITION: Logo detection, tracking, and recognition.
    """
    FEATURE_UNSPECIFIED = 0
    LABEL_DETECTION = 1
    SHOT_CHANGE_DETECTION = 2
    EXPLICIT_CONTENT_DETECTION = 3
    SPEECH_TRANSCRIPTION = 4
    TEXT_DETECTION = 5
    OBJECT_TRACKING = 6
    LOGO_RECOGNITION = 7

  feature = _messages.EnumField('FeatureValueValuesEnum', 1)
  inputUri = _messages.StringField(2)
  progressPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 4)
  startTime = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudVideointelligenceV1p2beta1VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    logoRecognitionAnnotations: Annotations for list of logos detected,
      tracked and recognized in video.
    objectAnnotations: Annotations for list of objects detected and tracked in
      video.
    segment: Video segment on which the annotation is run.
    segmentLabelAnnotations: Topical label annotations on video level or user-
      specified segment level. There is exactly one element for each unique
      label.
    segmentPresenceLabelAnnotations: Presence label annotations on video level
      or user-specified segment level. There is exactly one element for each
      unique label. Compared to the existing topical
      `segment_label_annotations`, this field presents more fine-grained,
      segment-level labels detected in video content and is made available
      only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Topical label annotations on shot level. There is
      exactly one element for each unique label.
    shotPresenceLabelAnnotations: Presence label annotations on shot level.
      There is exactly one element for each unique label. Compared to the
      existing topical `shot_label_annotations`, this field presents more
      fine-grained, shot-level labels detected in video content and is made
      available only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    speechTranscriptions: Speech transcription.
    textAnnotations: OCR text detection and tracking. Annotations for list of
      detected text snippets. Each will have list of frame information
      associated with it.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  logoRecognitionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LogoRecognitionAnnotation', 5, repeated=True)
  objectAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ObjectTrackingAnnotation', 6, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 7)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 8, repeated=True)
  segmentPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 9, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 10, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 11, repeated=True)
  shotPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 12, repeated=True)
  speechTranscriptions = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1SpeechTranscription', 13, repeated=True)
  textAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1TextAnnotation', 14, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1WordInfo(_messages.Message):
  r"""Word-specific information for recognized words. Word information is only
  included in the response when certain request parameters are set, such as
  `enable_word_time_offsets`.

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    endTime: Time offset relative to the beginning of the audio, and
      corresponding to the end of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    speakerTag: Output only. A distinct integer value is assigned for every
      speaker within the audio. This field specifies which one of those
      speakers was detected to have spoken this word. Value ranges from 1 up
      to diarization_speaker_count, and is only set if speaker diarization is
      enabled.
    startTime: Time offset relative to the beginning of the audio, and
      corresponding to the start of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    word: The word corresponding to this set of information.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  endTime = _messages.StringField(2)
  speakerTag = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(4)
  word = _messages.StringField(5)


class GoogleCloudVideointelligenceV1p3beta1AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1Celebrity(_messages.Message):
  r"""Celebrity definition.

  Fields:
    description: Textual description of additional information about the
      celebrity, if applicable.
    displayName: The celebrity name.
    name: The resource name of the celebrity. Have the format `video-
      intelligence/kg-mid` indicates a celebrity from preloaded gallery. kg-
      mid is the id in Google knowledge graph, which is unique for the
      celebrity.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  name = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p3beta1CelebrityRecognitionAnnotation(_messages.Message):
  r"""Celebrity recognition annotation per video.

  Fields:
    celebrityTracks: The tracks detected from the input video, including
      recognized celebrities and other detected faces in the video.
    version: Feature version.
  """

  celebrityTracks = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1CelebrityTrack', 1, repeated=True)
  version = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1CelebrityTrack(_messages.Message):
  r"""The annotation result of a celebrity face track. RecognizedCelebrity
  field could be empty if the face track does not have any matched
  celebrities.

  Fields:
    celebrities: Top N match of the celebrities for the face in this track.
    faceTrack: A track of a person's face.
  """

  celebrities = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1RecognizedCelebrity', 1, repeated=True)
  faceTrack = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Track', 2)


class GoogleCloudVideointelligenceV1p3beta1DetectedAttribute(_messages.Message):
  r"""A generic detected attribute represented by name in string format.

  Fields:
    confidence: Detected attribute confidence. Range [0, 1].
    name: The name of the attribute, for example, glasses, dark_glasses,
      mouth_open. A full list of supported type names will be provided in the
      document.
    value: Text value of the detection result. For example, the value for
      "HairColor" can be "black", "blonde", etc.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  value = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p3beta1DetectedLandmark(_messages.Message):
  r"""A generic detected landmark represented by name in string format and a
  2D location.

  Fields:
    confidence: The confidence score of the detected landmark. Range [0, 1].
    name: The name of this landmark, for example, left_hand, right_shoulder.
    point: The 2D point of the detected landmark using the normalized image
      coordindate system. The normalized coordinates have the range from 0 to
      1.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  name = _messages.StringField(2)
  point = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1NormalizedVertex', 3)


class GoogleCloudVideointelligenceV1p3beta1Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g., `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p3beta1ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
    version: Feature version.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1ExplicitContentFrame', 1, repeated=True)
  version = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1FaceDetectionAnnotation(_messages.Message):
  r"""Face detection annotation.

  Fields:
    thumbnail: The thumbnail of a person's face.
    tracks: The face tracks with attributes.
    version: Feature version.
  """

  thumbnail = _messages.BytesField(1)
  tracks = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Track', 2, repeated=True)
  version = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p3beta1LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. For example,
      when the label is `Terrier`, the category is likely `dog`. And in some
      cases there might be more than one categories e.g., `Terrier` could also
      be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
    version: Feature version.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelSegment', 4, repeated=True)
  version = _messages.StringField(5)


class GoogleCloudVideointelligenceV1p3beta1LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 2)


class GoogleCloudVideointelligenceV1p3beta1LogoRecognitionAnnotation(_messages.Message):
  r"""Annotation corresponding to one detected, tracked and recognized logo
  class.

  Fields:
    entity: Entity category information to specify the logo class that all the
      logo tracks within this LogoRecognitionAnnotation are recognized as.
    segments: All video segments where the recognized logo appears. There
      might be multiple instances of the same logo class appearing in one
      VideoSegment.
    tracks: All logo tracks where the recognized logo appears. Each track
      corresponds to one logo instance appearing in consecutive frames.
  """

  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Entity', 1)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 2, repeated=True)
  tracks = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Track', 3, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1NormalizedBoundingBox(_messages.Message):
  r"""Normalized bounding box. The normalized vertex coordinates are relative
  to the original image. Range: [0, 1].

  Fields:
    bottom: Bottom Y coordinate.
    left: Left X coordinate.
    right: Right X coordinate.
    top: Top Y coordinate.
  """

  bottom = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  left = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  right = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  top = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p3beta1NormalizedBoundingPoly(_messages.Message):
  r"""Normalized bounding polygon for text (that might not be aligned with
  axis). Contains list of the corner points in clockwise order starting from
  top-left corner. For example, for a rectangular bounding box: When the text
  is horizontal it might look like:         0----1         |    |         3
  ----2  When it's clockwise rotated 180 degrees around the top-left corner it
  becomes:         2----3         |    |         1----0  and the vertex order
  will still be (0, 1, 2, 3). Note that values can be less than 0, or greater
  than 1 due to trignometric calculations for location of the box.

  Fields:
    vertices: Normalized vertices of the bounding polygon.
  """

  vertices = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1NormalizedVertex', 1, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1NormalizedVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p3beta1ObjectTrackingAnnotation(_messages.Message):
  r"""Annotations corresponding to one tracked object.

  Fields:
    confidence: Object category's labeling confidence of this track.
    entity: Entity to specify the object category that this track is labeled
      as.
    frames: Information corresponding to all frames where this object track
      appears. Non-streaming batch mode: it may be one or multiple
      ObjectTrackingFrame messages in frames. Streaming mode: it can only be
      one ObjectTrackingFrame message in frames.
    segment: Non-streaming batch mode ONLY. Each object track corresponds to
      one video segment where it appears.
    trackId: Streaming mode ONLY. In streaming mode, we do not know the end
      time of a tracked object before it is completed. Hence, there is no
      VideoSegment info returned. Instead, we provide a unique identifiable
      integer track_id so that the customers can correlate the results of the
      ongoing ObjectTrackAnnotation of the same track_id over time.
    version: Feature version.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1ObjectTrackingFrame', 3, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 4)
  trackId = _messages.IntegerField(5)
  version = _messages.StringField(6)


class GoogleCloudVideointelligenceV1p3beta1ObjectTrackingFrame(_messages.Message):
  r"""Video frame level annotations for object detection and tracking. This
  field stores per frame location, time offset, and confidence.

  Fields:
    normalizedBoundingBox: The normalized bounding box location of this object
      track for the frame.
    timeOffset: The timestamp of the frame in microseconds.
  """

  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1NormalizedBoundingBox', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1PersonDetectionAnnotation(_messages.Message):
  r"""Person detection annotation per video.

  Fields:
    tracks: The detected tracks of a person.
    version: Feature version.
  """

  tracks = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Track', 1, repeated=True)
  version = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1RecognizedCelebrity(_messages.Message):
  r"""The recognized celebrity with confidence score.

  Fields:
    celebrity: The recognized celebrity.
    confidence: Recognition confidence. Range [0, 1].
  """

  celebrity = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1Celebrity', 1)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p3beta1SpeechRecognitionAlternative(_messages.Message):
  r"""Alternative hypotheses (a.k.a. n-best list).

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    transcript: Transcript text representing the words that the user spoke.
    words: Output only. A list of word-specific information for each
      recognized word. Note: When `enable_speaker_diarization` is set to true,
      you will see all the words from the beginning of the audio.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  transcript = _messages.StringField(2)
  words = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1WordInfo', 3, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1SpeechTranscription(_messages.Message):
  r"""A speech recognition result corresponding to a portion of the audio.

  Fields:
    alternatives: May contain one or more recognition hypotheses (up to the
      maximum specified in `max_alternatives`).  These alternatives are
      ordered in terms of accuracy, with the top (first) alternative being the
      most probable, as ranked by the recognizer.
    languageCode: Output only. The [BCP-47](https://www.rfc-
      editor.org/rfc/bcp/bcp47.txt) language tag of the language in this
      result. This language code was detected to have the most likelihood of
      being spoken in the audio.
  """

  alternatives = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1SpeechRecognitionAlternative', 1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1StreamingAnnotateVideoResponse(_messages.Message):
  r"""`StreamingAnnotateVideoResponse` is the only message returned to the
  client by `StreamingAnnotateVideo`. A series of zero or more
  `StreamingAnnotateVideoResponse` messages are streamed back to the client.

  Fields:
    annotationResults: Streaming annotation results.
    annotationResultsUri: Google Cloud Storage(GCS) URI that stores annotation
      results of one streaming session in JSON format. It is the
      annotation_result_storage_directory from the request followed by
      '/cloud_project_number-session_id'.
    error: If set, returns a google.rpc.Status message that specifies the
      error for the operation.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1StreamingVideoAnnotationResults', 1)
  annotationResultsUri = _messages.StringField(2)
  error = _messages.MessageField('GoogleRpcStatus', 3)


class GoogleCloudVideointelligenceV1p3beta1StreamingVideoAnnotationResults(_messages.Message):
  r"""Streaming annotation results corresponding to a portion of the video
  that is currently being processed.

  Fields:
    explicitAnnotation: Explicit content annotation results.
    labelAnnotations: Label annotation results.
    objectAnnotations: Object tracking results.
    shotAnnotations: Shot annotation results. Each shot is represented as a
      video segment.
  """

  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1ExplicitContentAnnotation', 1)
  labelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelAnnotation', 2, repeated=True)
  objectAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1ObjectTrackingAnnotation', 3, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 4, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1TextAnnotation(_messages.Message):
  r"""Annotations related to one detected OCR text snippet. This will contain
  the corresponding text, confidence value, and frame level information for
  each detection.

  Fields:
    segments: All video segments where OCR detected text appears.
    text: The detected text.
    version: Feature version.
  """

  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1TextSegment', 1, repeated=True)
  text = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p3beta1TextFrame(_messages.Message):
  r"""Video frame level annotation results for text annotation (OCR). Contains
  information regarding timestamp and bounding box locations for the frames
  containing detected OCR text snippets.

  Fields:
    rotatedBoundingBox: Bounding polygon of the detected text for this frame.
    timeOffset: Timestamp of this frame.
  """

  rotatedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1NormalizedBoundingPoly', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1TextSegment(_messages.Message):
  r"""Video segment level annotation results for text detection.

  Fields:
    confidence: Confidence for the track of detected text. It is calculated as
      the highest over all frames where OCR detected text appears.
    frames: Information related to the frames where OCR detected text appears.
    segment: Video segment where a text snippet was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1TextFrame', 2, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 3)


class GoogleCloudVideointelligenceV1p3beta1TimestampedObject(_messages.Message):
  r"""For tracking related features. An object at time_offset with attributes,
  and located with normalized_bounding_box.

  Fields:
    attributes: Optional. The attributes of the object in the bounding box.
    landmarks: Optional. The detected landmarks.
    normalizedBoundingBox: Normalized Bounding box in a frame, where the
      object is located.
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this object.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1DetectedAttribute', 1, repeated=True)
  landmarks = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1DetectedLandmark', 2, repeated=True)
  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1NormalizedBoundingBox', 3)
  timeOffset = _messages.StringField(4)


class GoogleCloudVideointelligenceV1p3beta1Track(_messages.Message):
  r"""A track of an object instance.

  Fields:
    attributes: Optional. Attributes in the track level.
    confidence: Optional. The confidence score of the tracked object.
    segment: Video segment of a track.
    timestampedObjects: The object with timestamp and attributes per frame in
      the track.
  """

  attributes = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1DetectedAttribute', 1, repeated=True)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 3)
  timestampedObjects = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1TimestampedObject', 4, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Enums:
    FeatureValueValuesEnum: Specifies which feature is being tracked if the
      request contains more than one feature.

  Fields:
    feature: Specifies which feature is being tracked if the request contains
      more than one feature.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    segment: Specifies which segment is being tracked if the request contains
      more than one segment.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  class FeatureValueValuesEnum(_messages.Enum):
    r"""Specifies which feature is being tracked if the request contains more
    than one feature.

    Values:
      FEATURE_UNSPECIFIED: Unspecified.
      LABEL_DETECTION: Label detection. Detect objects, such as dog or flower.
      SHOT_CHANGE_DETECTION: Shot change detection.
      EXPLICIT_CONTENT_DETECTION: Explicit content detection.
      FACE_DETECTION: Human face detection.
      SPEECH_TRANSCRIPTION: Speech transcription.
      TEXT_DETECTION: OCR text detection and tracking.
      OBJECT_TRACKING: Object detection and tracking.
      LOGO_RECOGNITION: Logo detection, tracking, and recognition.
      CELEBRITY_RECOGNITION: Celebrity recognition.
      PERSON_DETECTION: Person detection.
    """
    FEATURE_UNSPECIFIED = 0
    LABEL_DETECTION = 1
    SHOT_CHANGE_DETECTION = 2
    EXPLICIT_CONTENT_DETECTION = 3
    FACE_DETECTION = 4
    SPEECH_TRANSCRIPTION = 5
    TEXT_DETECTION = 6
    OBJECT_TRACKING = 7
    LOGO_RECOGNITION = 8
    CELEBRITY_RECOGNITION = 9
    PERSON_DETECTION = 10

  feature = _messages.EnumField('FeatureValueValuesEnum', 1)
  inputUri = _messages.StringField(2)
  progressPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 4)
  startTime = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudVideointelligenceV1p3beta1VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    celebrityRecognitionAnnotations: Celebrity recognition annotations.
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    faceDetectionAnnotations: Face detection annotations.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Cloud
      Storage](https://cloud.google.com/storage/).
    logoRecognitionAnnotations: Annotations for list of logos detected,
      tracked and recognized in video.
    objectAnnotations: Annotations for list of objects detected and tracked in
      video.
    personDetectionAnnotations: Person detection annotations.
    segment: Video segment on which the annotation is run.
    segmentLabelAnnotations: Topical label annotations on video level or user-
      specified segment level. There is exactly one element for each unique
      label.
    segmentPresenceLabelAnnotations: Presence label annotations on video level
      or user-specified segment level. There is exactly one element for each
      unique label. Compared to the existing topical
      `segment_label_annotations`, this field presents more fine-grained,
      segment-level labels detected in video content and is made available
      only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Topical label annotations on shot level. There is
      exactly one element for each unique label.
    shotPresenceLabelAnnotations: Presence label annotations on shot level.
      There is exactly one element for each unique label. Compared to the
      existing topical `shot_label_annotations`, this field presents more
      fine-grained, shot-level labels detected in video content and is made
      available only when the client sets `LabelDetectionConfig.model` to
      "builtin/latest" in the request.
    speechTranscriptions: Speech transcription.
    textAnnotations: OCR text detection and tracking. Annotations for list of
      detected text snippets. Each will have list of frame information
      associated with it.
  """

  celebrityRecognitionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1CelebrityRecognitionAnnotation', 1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1ExplicitContentAnnotation', 3)
  faceDetectionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1FaceDetectionAnnotation', 4, repeated=True)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelAnnotation', 5, repeated=True)
  inputUri = _messages.StringField(6)
  logoRecognitionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LogoRecognitionAnnotation', 7, repeated=True)
  objectAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1ObjectTrackingAnnotation', 8, repeated=True)
  personDetectionAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1PersonDetectionAnnotation', 9, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 10)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelAnnotation', 11, repeated=True)
  segmentPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelAnnotation', 12, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1VideoSegment', 13, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelAnnotation', 14, repeated=True)
  shotPresenceLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1LabelAnnotation', 15, repeated=True)
  speechTranscriptions = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1SpeechTranscription', 16, repeated=True)
  textAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p3beta1TextAnnotation', 17, repeated=True)


class GoogleCloudVideointelligenceV1p3beta1VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p3beta1WordInfo(_messages.Message):
  r"""Word-specific information for recognized words. Word information is only
  included in the response when certain request parameters are set, such as
  `enable_word_time_offsets`.

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    endTime: Time offset relative to the beginning of the audio, and
      corresponding to the end of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    speakerTag: Output only. A distinct integer value is assigned for every
      speaker within the audio. This field specifies which one of those
      speakers was detected to have spoken this word. Value ranges from 1 up
      to diarization_speaker_count, and is only set if speaker diarization is
      enabled.
    startTime: Time offset relative to the beginning of the audio, and
      corresponding to the start of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    word: The word corresponding to this set of information.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  endTime = _messages.StringField(2)
  speakerTag = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(4)
  word = _messages.StringField(5)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class VideointelligenceOperationsProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A VideointelligenceOperationsProjectsLocationsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class VideointelligenceOperationsProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A VideointelligenceOperationsProjectsLocationsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class VideointelligenceOperationsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A VideointelligenceOperationsProjectsLocationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class VideointelligenceProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A VideointelligenceProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class VideointelligenceProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A VideointelligenceProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class VideointelligenceProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A VideointelligenceProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class VideointelligenceProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A VideointelligenceProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
