"""Generated message classes for cloudasset version v1.

The cloud asset API manages the history and inventory of cloud resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudasset'


class Asset(_messages.Message):
  r"""An asset in Google Cloud. An asset can be any resource in the Google
  Cloud [resource hierarchy](https://cloud.google.com/resource-manager/docs
  /cloud-platform-resource-hierarchy), a resource outside the Google Cloud
  resource hierarchy (such as Google Kubernetes Engine clusters and objects),
  or a Cloud IAM policy.

  Fields:
    accessLevel: A GoogleIdentityAccesscontextmanagerV1AccessLevel attribute.
    accessPolicy: A GoogleIdentityAccesscontextmanagerV1AccessPolicy
      attribute.
    ancestors: The ancestry path of an asset in Google Cloud [resource
      hierarchy](https://cloud.google.com/resource-manager/docs/cloud-
      platform-resource-hierarchy), represented as a list of relative resource
      names. An ancestry path starts with the closest ancestor in the
      hierarchy and ends at root. If the asset is a project, folder, or
      organization, the ancestry path starts from the asset itself.  For
      example: `["projects/123456789", "folders/5432", "organizations/1234"]`
    assetType: The type of the asset. For example:
      "compute.googleapis.com/Disk"  See [Supported asset
      types](https://cloud.google.com/asset-inventory/docs/supported-asset-
      types) for more information.
    iamPolicy: A representation of the Cloud IAM policy set on a Google Cloud
      resource. There can be a maximum of one Cloud IAM policy set on any
      given resource. In addition, Cloud IAM policies inherit their granted
      access scope from any policies set on parent resources in the resource
      hierarchy. Therefore, the effectively policy is the union of both the
      policy set on this resource and each policy set on all of the resource's
      ancestry resource levels in the hierarchy. See [this
      topic](https://cloud.google.com/iam/docs/policies#inheritance) for more
      information.
    name: The full name of the asset. For example: "//compute.googleapis.com/p
      rojects/my_project_123/zones/zone1/instances/instance1"  See [Resource n
      ames](https://cloud.google.com/apis/design/resource_names#full_resource_
      name) for more information.
    orgPolicy: A representation of an [organization
      policy](https://cloud.google.com/resource-manager/docs/organization-
      policy/overview#organization_policy). There can be more than one
      organization policy with different constraints set on a given resource.
    resource: A representation of the resource.
    servicePerimeter: A GoogleIdentityAccesscontextmanagerV1ServicePerimeter
      attribute.
  """

  accessLevel = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1AccessLevel', 1)
  accessPolicy = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1AccessPolicy', 2)
  ancestors = _messages.StringField(3, repeated=True)
  assetType = _messages.StringField(4)
  iamPolicy = _messages.MessageField('Policy', 5)
  name = _messages.StringField(6)
  orgPolicy = _messages.MessageField('GoogleCloudOrgpolicyV1Policy', 7, repeated=True)
  resource = _messages.MessageField('Resource', 8)
  servicePerimeter = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ServicePerimeter', 9)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "sampleservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BatchGetAssetsHistoryResponse(_messages.Message):
  r"""Batch get assets history response.

  Fields:
    assets: A list of assets with valid time windows.
  """

  assets = _messages.MessageField('TemporalAsset', 1, repeated=True)


class BigQueryDestination(_messages.Message):
  r"""A BigQuery destination.

  Fields:
    dataset: Required. The BigQuery dataset in format
      "projects/projectId/datasets/datasetId", to which the snapshot result
      should be exported. If this dataset does not exist, the export call
      returns an error.
    force: If the destination table already exists and this flag is `TRUE`,
      the table will be overwritten by the contents of assets snapshot. If the
      flag is not set and the destination table already exists, the export
      call returns an error.
    table: Required. The BigQuery table to which the snapshot result should be
      written. If this table does not exist, a new table with the given name
      will be created.
  """

  dataset = _messages.StringField(1)
  force = _messages.BooleanField(2)
  table = _messages.StringField(3)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CloudassetBatchGetAssetsHistoryRequest(_messages.Message):
  r"""A CloudassetBatchGetAssetsHistoryRequest object.

  Enums:
    ContentTypeValueValuesEnum: Optional. The content type.

  Fields:
    assetNames: A list of the full names of the assets. For example: `//comput
      e.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1
      `. See [Resource Names](https://cloud.google.com/apis/design/resource_na
      mes#full_resource_name) and [Resource Name
      Format](https://cloud.google.com/asset-inventory/docs/resource-name-
      format) for more info.  The request becomes a no-op if the asset name
      list is empty, and the max size of the asset name list is 100 in one
      request.
    contentType: Optional. The content type.
    parent: Required. The relative name of the root asset. It can only be an
      organization number (such as "organizations/123"), a project ID (such as
      "projects/my-project-id")", or a project number (such as
      "projects/12345").
    readTimeWindow_endTime: End time of the time window (inclusive). If not
      specified, the current timestamp is used instead.
    readTimeWindow_startTime: Start time of the time window (exclusive).
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The content type.

    Values:
      CONTENT_TYPE_UNSPECIFIED: <no description>
      RESOURCE: <no description>
      IAM_POLICY: <no description>
      ORG_POLICY: <no description>
      ACCESS_POLICY: <no description>
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4

  assetNames = _messages.StringField(1, repeated=True)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 2)
  parent = _messages.StringField(3, required=True)
  readTimeWindow_endTime = _messages.StringField(4)
  readTimeWindow_startTime = _messages.StringField(5)


class CloudassetExportAssetsRequest(_messages.Message):
  r"""A CloudassetExportAssetsRequest object.

  Fields:
    exportAssetsRequest: A ExportAssetsRequest resource to be passed as the
      request body.
    parent: Required. The relative name of the root asset. This can only be an
      organization number (such as "organizations/123"), a project ID (such as
      "projects/my-project-id"), or a project number (such as
      "projects/12345"), or a folder number (such as "folders/123").
  """

  exportAssetsRequest = _messages.MessageField('ExportAssetsRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudassetFeedsCreateRequest(_messages.Message):
  r"""A CloudassetFeedsCreateRequest object.

  Fields:
    createFeedRequest: A CreateFeedRequest resource to be passed as the
      request body.
    parent: Required. The name of the project/folder/organization where this
      feed should be created in. It can only be an organization number (such
      as "organizations/123"), a folder number (such as "folders/123"), a
      project ID (such as "projects/my-project-id")", or a project number
      (such as "projects/12345").
  """

  createFeedRequest = _messages.MessageField('CreateFeedRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudassetFeedsDeleteRequest(_messages.Message):
  r"""A CloudassetFeedsDeleteRequest object.

  Fields:
    name: Required. The name of the feed and it must be in the format of:
      projects/project_number/feeds/feed_id
      folders/folder_number/feeds/feed_id
      organizations/organization_number/feeds/feed_id
  """

  name = _messages.StringField(1, required=True)


class CloudassetFeedsGetRequest(_messages.Message):
  r"""A CloudassetFeedsGetRequest object.

  Fields:
    name: Required. The name of the Feed and it must be in the format of:
      projects/project_number/feeds/feed_id
      folders/folder_number/feeds/feed_id
      organizations/organization_number/feeds/feed_id
  """

  name = _messages.StringField(1, required=True)


class CloudassetFeedsListRequest(_messages.Message):
  r"""A CloudassetFeedsListRequest object.

  Fields:
    parent: Required. The parent project/folder/organization whose feeds are
      to be listed. It can only be using project/folder/organization number
      (such as "folders/12345")", or a project ID (such as "projects/my-
      project-id").
  """

  parent = _messages.StringField(1, required=True)


class CloudassetFeedsPatchRequest(_messages.Message):
  r"""A CloudassetFeedsPatchRequest object.

  Fields:
    name: Required. The format will be projects/{project_number}/feeds
      /{client-assigned_feed_identifier} or folders/{folder_number}/feeds
      /{client-assigned_feed_identifier} or
      organizations/{organization_number}/feeds/{client-
      assigned_feed_identifier}  The client-assigned feed identifier must be
      unique within the parent project/folder/organization.
    updateFeedRequest: A UpdateFeedRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateFeedRequest = _messages.MessageField('UpdateFeedRequest', 2)


class CloudassetOperationsGetRequest(_messages.Message):
  r"""A CloudassetOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CreateFeedRequest(_messages.Message):
  r"""Create asset feed request.

  Fields:
    feed: Required. The feed details. The field `name` must be empty and it
      will be generated in the format of:
      projects/project_number/feeds/feed_id
      folders/folder_number/feeds/feed_id
      organizations/organization_number/feeds/feed_id
    feedId: Required. This is the client-assigned asset feed identifier and it
      needs to be unique under a specific parent project/folder/organization.
  """

  feed = _messages.MessageField('Feed', 1)
  feedId = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ExportAssetsRequest(_messages.Message):
  r"""Export asset request.

  Enums:
    ContentTypeValueValuesEnum: Asset content type. If not specified, no
      content but the asset name will be returned.

  Fields:
    assetTypes: A list of asset types of which to take a snapshot for. For
      example: "compute.googleapis.com/Disk". If specified, only matching
      assets will be returned. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types.
    contentType: Asset content type. If not specified, no content but the
      asset name will be returned.
    outputConfig: Required. Output configuration indicating where the results
      will be output to. All results will be in newline delimited JSON format.
    readTime: Timestamp to take an asset snapshot. This can only be set to a
      timestamp between the current time and the current time minus 35 days
      (inclusive). If not specified, the current time will be used. Due to
      delays in resource data collection and indexing, there is a volatile
      window during which running the same query may get different results.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Asset content type. If not specified, no content but the asset name
    will be returned.

    Values:
      CONTENT_TYPE_UNSPECIFIED: Unspecified content type.
      RESOURCE: Resource metadata.
      IAM_POLICY: The actual IAM policy set on a resource.
      ORG_POLICY: The Cloud Organization Policy set on an asset.
      ACCESS_POLICY: The Cloud Access context mananger Policy set on an asset.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4

  assetTypes = _messages.StringField(1, repeated=True)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 2)
  outputConfig = _messages.MessageField('OutputConfig', 3)
  readTime = _messages.StringField(4)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.  Example (Comparison):
  title: "Summary size limit"     description: "Determines if a summary is
  less than 100 chars"     expression: "document.summary.size() < 100"
  Example (Equality):      title: "Requestor is owner"     description:
  "Determines if requestor is the document owner"     expression:
  "document.owner == request.auth.claims.email"  Example (Logic):      title:
  "Public documents"     description: "Determine whether the document should
  be publicly visible"     expression: "document.type != 'private' &&
  document.type != 'internal'"  Example (Data Manipulation):      title:
  "Notification string"     description: "Create a notification string with a
  timestamp."     expression: "'New message received at ' +
  string(document.create_time)"  The exact variables and functions that may be
  referenced within an expression are determined by the service that evaluates
  it. See the service documentation for additional information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Feed(_messages.Message):
  r"""An asset feed used to export asset updates to a destinations. An asset
  feed filter controls what updates are exported. The asset feed must be
  created within a project, organization, or folder. Supported destinations
  are: Cloud Pub/Sub topics.

  Enums:
    ContentTypeValueValuesEnum: Asset content type. If not specified, no
      content but the asset name and type will be returned.

  Fields:
    assetNames: A list of the full names of the assets to receive updates. You
      must specify either or both of asset_names and asset_types. Only asset
      updates matching specified asset_names and asset_types are exported to
      the feed. For example: `//compute.googleapis.com/projects/my_project_123
      /zones/zone1/instances/instance1`. See [Resource Names](https://cloud.go
      ogle.com/apis/design/resource_names#full_resource_name) for more info.
    assetTypes: A list of types of the assets to receive updates. You must
      specify either or both of asset_names and asset_types. Only asset
      updates matching specified asset_names and asset_types are exported to
      the feed. For example: `"compute.googleapis.com/Disk"`  See [this
      topic](https://cloud.google.com/asset-inventory/docs/supported-asset-
      types) for a list of all supported asset types.
    contentType: Asset content type. If not specified, no content but the
      asset name and type will be returned.
    feedOutputConfig: Required. Feed output configuration defining where the
      asset updates are published to.
    name: Required. The format will be projects/{project_number}/feeds
      /{client-assigned_feed_identifier} or folders/{folder_number}/feeds
      /{client-assigned_feed_identifier} or
      organizations/{organization_number}/feeds/{client-
      assigned_feed_identifier}  The client-assigned feed identifier must be
      unique within the parent project/folder/organization.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Asset content type. If not specified, no content but the asset name
    and type will be returned.

    Values:
      CONTENT_TYPE_UNSPECIFIED: Unspecified content type.
      RESOURCE: Resource metadata.
      IAM_POLICY: The actual IAM policy set on a resource.
      ORG_POLICY: The Cloud Organization Policy set on an asset.
      ACCESS_POLICY: The Cloud Access context mananger Policy set on an asset.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4

  assetNames = _messages.StringField(1, repeated=True)
  assetTypes = _messages.StringField(2, repeated=True)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 3)
  feedOutputConfig = _messages.MessageField('FeedOutputConfig', 4)
  name = _messages.StringField(5)


class FeedOutputConfig(_messages.Message):
  r"""Output configuration for asset feed destination.

  Fields:
    pubsubDestination: Destination on Cloud Pubsub.
  """

  pubsubDestination = _messages.MessageField('PubsubDestination', 1)


class GcsDestination(_messages.Message):
  r"""A Cloud Storage location.

  Fields:
    uri: The uri of the Cloud Storage object. It's the same uri that is used
      by gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
      Editing Object Metadata](https://cloud.google.com/storage/docs/viewing-
      editing-metadata) for more information.
    uriPrefix: The uri prefix of all generated Cloud Storage objects. For
      example: "gs://bucket_name/object_name_prefix". Each object uri is in
      format: "gs://bucket_name/object_name_prefix/<asset type>/<shard number>
      and only contains assets for that type. <shard number> starts from 0.
      For example:
      "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
      the first shard of output objects containing all
      compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
      returned if file with the same name
      "gs://bucket_name/object_name_prefix" already exists.
  """

  uri = _messages.StringField(1)
  uriPrefix = _messages.StringField(2)


class GoogleCloudOrgpolicyV1BooleanPolicy(_messages.Message):
  r"""Used in `policy_type` to specify how `boolean_policy` will behave at
  this resource.

  Fields:
    enforced: If `true`, then the `Policy` is enforced. If `false`, then any
      configuration is acceptable.  Suppose you have a `Constraint`
      `constraints/compute.disableSerialPortAccess` with `constraint_default`
      set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
      behavior:   - If the `Policy` at this resource has enforced set to
      `false`, serial     port connection attempts will be allowed.   - If the
      `Policy` at this resource has enforced set to `true`, serial     port
      connection attempts will be refused.   - If the `Policy` at this
      resource is `RestoreDefault`, serial port     connection attempts will
      be allowed.   - If no `Policy` is set at this resource or anywhere
      higher in the     resource hierarchy, serial port connection attempts
      will be allowed.   - If no `Policy` is set at this resource, but one
      exists higher in the     resource hierarchy, the behavior is as if
      the`Policy` were set at     this resource.  The following examples
      demonstrate the different possible layerings:  Example 1 (nearest
      `Constraint` wins):   `organizations/foo` has a `Policy` with:
      {enforced: false}   `projects/bar` has no `Policy` set. The constraint
      at `projects/bar` and `organizations/foo` will not be enforced.  Example
      2 (enforcement gets replaced):   `organizations/foo` has a `Policy`
      with:     {enforced: false}   `projects/bar` has a `Policy` with:
      {enforced: true} The constraint at `organizations/foo` is not enforced.
      The constraint at `projects/bar` is enforced.  Example 3
      (RestoreDefault):   `organizations/foo` has a `Policy` with:
      {enforced: true}   `projects/bar` has a `Policy` with:
      {RestoreDefault: {}} The constraint at `organizations/foo` is enforced.
      The constraint at `projects/bar` is not enforced, because
      `constraint_default` for the `Constraint` is `ALLOW`.
  """

  enforced = _messages.BooleanField(1)


class GoogleCloudOrgpolicyV1ListPolicy(_messages.Message):
  r"""Used in `policy_type` to specify how `list_policy` behaves at this
  resource.  `ListPolicy` can define specific values and subtrees of Cloud
  Resource Manager resource hierarchy (`Organizations`, `Folders`, `Projects`)
  that are allowed or denied by setting the `allowed_values` and
  `denied_values` fields. This is achieved by using the `under:` and optional
  `is:` prefixes. The `under:` prefix is used to denote resource subtree
  values. The `is:` prefix is used to denote specific values, and is required
  only if the value contains a ":". Values prefixed with "is:" are treated the
  same as values with no prefix. Ancestry subtrees must be in one of the
  following formats:     - "projects/<project-id>", e.g. "projects/tokyo-
  rain-123"     - "folders/<folder-id>", e.g. "folders/1234"     -
  "organizations/<organization-id>", e.g. "organizations/1234" The
  `supports_under` field of the associated `Constraint`  defines whether
  ancestry prefixes can be used. You can set `allowed_values` and
  `denied_values` in the same `Policy` if `all_values` is
  `ALL_VALUES_UNSPECIFIED`. `ALLOW` or `DENY` are used to allow or deny all
  values. If `all_values` is set to either `ALLOW` or `DENY`, `allowed_values`
  and `denied_values` must be unset.

  Enums:
    AllValuesValueValuesEnum: The policy all_values state.

  Fields:
    allValues: The policy all_values state.
    allowedValues: List of values allowed  at this resource. Can only be set
      if `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
    deniedValues: List of values denied at this resource. Can only be set if
      `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
    inheritFromParent: Determines the inheritance behavior for this `Policy`.
      By default, a `ListPolicy` set at a resource supercedes any `Policy` set
      anywhere up the resource hierarchy. However, if `inherit_from_parent` is
      set to `true`, then the values from the effective `Policy` of the parent
      resource are inherited, meaning the values set in this `Policy` are
      added to the values inherited up the hierarchy.  Setting `Policy`
      hierarchies that inherit both allowed values and denied values isn't
      recommended in most circumstances to keep the configuration simple and
      understandable. However, it is possible to set a `Policy` with
      `allowed_values` set that inherits a `Policy` with `denied_values` set.
      In this case, the values that are allowed must be in `allowed_values`
      and not present in `denied_values`.  For example, suppose you have a
      `Constraint` `constraints/serviceuser.services`, which has a
      `constraint_type` of `list_constraint`, and with `constraint_default`
      set to `ALLOW`. Suppose that at the Organization level, a `Policy` is
      applied that restricts the allowed API activations to {`E1`, `E2`}.
      Then, if a `Policy` is applied to a project below the Organization that
      has `inherit_from_parent` set to `false` and field all_values set to
      DENY, then an attempt to activate any API will be denied.  The following
      examples demonstrate different possible layerings for `projects/bar`
      parented by `organizations/foo`:  Example 1 (no inherited values):
      `organizations/foo` has a `Policy` with values:     {allowed_values:
      "E1" allowed_values:"E2"}   `projects/bar` has `inherit_from_parent`
      `false` and values:     {allowed_values: "E3" allowed_values: "E4"} The
      accepted values at `organizations/foo` are `E1`, `E2`. The accepted
      values at `projects/bar` are `E3`, and `E4`.  Example 2 (inherited
      values):   `organizations/foo` has a `Policy` with values:
      {allowed_values: "E1" allowed_values:"E2"}   `projects/bar` has a
      `Policy` with values:     {value: "E3" value: "E4" inherit_from_parent:
      true} The accepted values at `organizations/foo` are `E1`, `E2`. The
      accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
      Example 3 (inheriting both allowed and denied values):
      `organizations/foo` has a `Policy` with values:     {allowed_values:
      "E1" allowed_values: "E2"}   `projects/bar` has a `Policy` with:
      {denied_values: "E1"} The accepted values at `organizations/foo` are
      `E1`, `E2`. The value accepted at `projects/bar` is `E2`.  Example 4
      (RestoreDefault):   `organizations/foo` has a `Policy` with values:
      {allowed_values: "E1" allowed_values:"E2"}   `projects/bar` has a
      `Policy` with values:     {RestoreDefault: {}} The accepted values at
      `organizations/foo` are `E1`, `E2`. The accepted values at
      `projects/bar` are either all or none depending on the value of
      `constraint_default` (if `ALLOW`, all; if `DENY`, none).  Example 5 (no
      policy inherits parent policy):   `organizations/foo` has no `Policy`
      set.   `projects/bar` has no `Policy` set. The accepted values at both
      levels are either all or none depending on the value of
      `constraint_default` (if `ALLOW`, all; if `DENY`, none).  Example 6
      (ListConstraint allowing all):   `organizations/foo` has a `Policy` with
      values:     {allowed_values: "E1" allowed_values: "E2"}   `projects/bar`
      has a `Policy` with:     {all: ALLOW} The accepted values at
      `organizations/foo` are `E1`, E2`. Any value is accepted at
      `projects/bar`.  Example 7 (ListConstraint allowing none):
      `organizations/foo` has a `Policy` with values:     {allowed_values:
      "E1" allowed_values: "E2"}   `projects/bar` has a `Policy` with:
      {all: DENY} The accepted values at `organizations/foo` are `E1`, E2`. No
      value is accepted at `projects/bar`.  Example 10 (allowed and denied
      subtrees of Resource Manager hierarchy): Given the following resource
      hierarchy   O1->{F1, F2}; F1->{P1}; F2->{P2, P3},   `organizations/foo`
      has a `Policy` with values:     {allowed_values:
      "under:organizations/O1"}   `projects/bar` has a `Policy` with:
      {allowed_values: "under:projects/P3"}     {denied_values:
      "under:folders/F2"} The accepted values at `organizations/foo` are
      `organizations/O1`,   `folders/F1`, `folders/F2`, `projects/P1`,
      `projects/P2`,   `projects/P3`. The accepted values at `projects/bar`
      are `organizations/O1`,   `folders/F1`, `projects/P1`.
    suggestedValue: Optional. The Google Cloud Console will try to default to
      a configuration that matches the value specified in this `Policy`. If
      `suggested_value` is not set, it will inherit the value specified higher
      in the hierarchy, unless `inherit_from_parent` is `false`.
  """

  class AllValuesValueValuesEnum(_messages.Enum):
    r"""The policy all_values state.

    Values:
      ALL_VALUES_UNSPECIFIED: Indicates that allowed_values or denied_values
        must be set.
      ALLOW: A policy with this set allows all values.
      DENY: A policy with this set denies all values.
    """
    ALL_VALUES_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  allValues = _messages.EnumField('AllValuesValueValuesEnum', 1)
  allowedValues = _messages.StringField(2, repeated=True)
  deniedValues = _messages.StringField(3, repeated=True)
  inheritFromParent = _messages.BooleanField(4)
  suggestedValue = _messages.StringField(5)


class GoogleCloudOrgpolicyV1Policy(_messages.Message):
  r"""Defines a Cloud Organization `Policy` which is used to specify
  `Constraints` for configurations of Cloud Platform resources.

  Fields:
    booleanPolicy: For boolean `Constraints`, whether to enforce the
      `Constraint` or not.
    constraint: The name of the `Constraint` the `Policy` is configuring, for
      example, `constraints/serviceuser.services`.  Immutable after creation.
    etag: An opaque tag indicating the current version of the `Policy`, used
      for concurrency control.  When the `Policy` is returned from either a
      `GetPolicy` or a `ListOrgPolicy` request, this `etag` indicates the
      version of the current `Policy` to use when executing a read-modify-
      write loop.  When the `Policy` is returned from a `GetEffectivePolicy`
      request, the `etag` will be unset.  When the `Policy` is used in a
      `SetOrgPolicy` method, use the `etag` value that was returned from a
      `GetOrgPolicy` request as part of a read-modify-write loop for
      concurrency control. Not setting the `etag`in a `SetOrgPolicy` request
      will result in an unconditional write of the `Policy`.
    listPolicy: List of values either allowed or disallowed.
    restoreDefault: Restores the default behavior of the constraint;
      independent of `Constraint` type.
    updateTime: The time stamp the `Policy` was previously updated. This is
      set by the server, not specified by the caller, and represents the last
      time a call to `SetOrgPolicy` was made for that `Policy`. Any value set
      by the client will be ignored.
    version: Version of the `Policy`. Default version is 0;
  """

  booleanPolicy = _messages.MessageField('GoogleCloudOrgpolicyV1BooleanPolicy', 1)
  constraint = _messages.StringField(2)
  etag = _messages.BytesField(3)
  listPolicy = _messages.MessageField('GoogleCloudOrgpolicyV1ListPolicy', 4)
  restoreDefault = _messages.MessageField('GoogleCloudOrgpolicyV1RestoreDefault', 5)
  updateTime = _messages.StringField(6)
  version = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class GoogleCloudOrgpolicyV1RestoreDefault(_messages.Message):
  r"""Ignores policies set above this resource and restores the
  `constraint_default` enforcement behavior of the specific `Constraint` at
  this resource.  Suppose that `constraint_default` is set to `ALLOW` for the
  `Constraint` `constraints/serviceuser.services`. Suppose that organization
  foo.com sets a `Policy` at their Organization resource node that restricts
  the allowed service activations to deny all service activations. They could
  then set a `Policy` with the `policy_type` `restore_default` on several
  experimental projects, restoring the `constraint_default` enforcement of the
  `Constraint` for only those projects, allowing those projects to have all
  services activated.
  """



class GoogleIdentityAccesscontextmanagerV1AccessLevel(_messages.Message):
  r"""An `AccessLevel` is a label that can be applied to requests to Google
  Cloud services, along with a list of requirements necessary for the label to
  be applied.

  Fields:
    basic: A `BasicLevel` composed of `Conditions`.
    createTime: Output only. Time the `AccessLevel` was created in UTC.
    custom: A `CustomLevel` written in the Common Expression Language.
    description: Description of the `AccessLevel` and its use. Does not affect
      behavior.
    name: Required. Resource name for the Access Level. The `short_name`
      component must begin with a letter and only include alphanumeric and
      '_'. Format: `accessPolicies/{policy_id}/accessLevels/{short_name}`. The
      maximum length of the `short_name` component is 50 characters.
    title: Human readable title. Must be unique within the Policy.
    updateTime: Output only. Time the `AccessLevel` was updated in UTC.
  """

  basic = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1BasicLevel', 1)
  createTime = _messages.StringField(2)
  custom = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1CustomLevel', 3)
  description = _messages.StringField(4)
  name = _messages.StringField(5)
  title = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class GoogleIdentityAccesscontextmanagerV1AccessPolicy(_messages.Message):
  r"""`AccessPolicy` is a container for `AccessLevels` (which define the
  necessary attributes to use Google Cloud services) and `ServicePerimeters`
  (which define regions of services able to freely pass data within a
  perimeter). An access policy is globally visible within an organization, and
  the restrictions it specifies apply to all projects within an organization.

  Fields:
    createTime: Output only. Time the `AccessPolicy` was created in UTC.
    etag: Output only. An opaque identifier for the current version of the
      `AccessPolicy`. This will always be a strongly validated etag, meaning
      that two Access Polices will be identical if and only if their etags are
      identical. Clients should not expect this to be in any specific format.
    name: Output only. Resource name of the `AccessPolicy`. Format:
      `accessPolicies/{policy_id}`
    parent: Required. The parent of this `AccessPolicy` in the Cloud Resource
      Hierarchy. Currently immutable once created. Format:
      `organizations/{organization_id}`
    title: Required. Human readable title. Does not affect behavior.
    updateTime: Output only. Time the `AccessPolicy` was updated in UTC.
  """

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3)
  parent = _messages.StringField(4)
  title = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleIdentityAccesscontextmanagerV1BasicLevel(_messages.Message):
  r"""`BasicLevel` is an `AccessLevel` using a set of recommended features.

  Enums:
    CombiningFunctionValueValuesEnum: How the `conditions` list should be
      combined to determine if a request is granted this `AccessLevel`. If AND
      is used, each `Condition` in `conditions` must be satisfied for the
      `AccessLevel` to be applied. If OR is used, at least one `Condition` in
      `conditions` must be satisfied for the `AccessLevel` to be applied.
      Default behavior is AND.

  Fields:
    combiningFunction: How the `conditions` list should be combined to
      determine if a request is granted this `AccessLevel`. If AND is used,
      each `Condition` in `conditions` must be satisfied for the `AccessLevel`
      to be applied. If OR is used, at least one `Condition` in `conditions`
      must be satisfied for the `AccessLevel` to be applied. Default behavior
      is AND.
    conditions: Required. A list of requirements for the `AccessLevel` to be
      granted.
  """

  class CombiningFunctionValueValuesEnum(_messages.Enum):
    r"""How the `conditions` list should be combined to determine if a request
    is granted this `AccessLevel`. If AND is used, each `Condition` in
    `conditions` must be satisfied for the `AccessLevel` to be applied. If OR
    is used, at least one `Condition` in `conditions` must be satisfied for
    the `AccessLevel` to be applied. Default behavior is AND.

    Values:
      AND: All `Conditions` must be true for the `BasicLevel` to be true.
      OR: If at least one `Condition` is true, then the `BasicLevel` is true.
    """
    AND = 0
    OR = 1

  combiningFunction = _messages.EnumField('CombiningFunctionValueValuesEnum', 1)
  conditions = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1Condition', 2, repeated=True)


class GoogleIdentityAccesscontextmanagerV1Condition(_messages.Message):
  r"""A condition necessary for an `AccessLevel` to be granted. The Condition
  is an AND over its fields. So a Condition is true if: 1) the request IP is
  from one of the listed subnetworks AND 2) the originating device complies
  with the listed device policy AND 3) all listed access levels are granted
  AND 4) the request was sent at a time allowed by the DateTimeRestriction.

  Fields:
    devicePolicy: Device specific restrictions, all restrictions must hold for
      the Condition to be true. If not specified, all devices are allowed.
    ipSubnetworks: CIDR block IP subnetwork specification. May be IPv4 or
      IPv6. Note that for a CIDR IP address block, the specified IP address
      portion must be properly truncated (i.e. all the host bits must be zero)
      or the input is considered malformed. For example, "192.0.2.0/24" is
      accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32"
      is accepted whereas "2001:db8::1/32" is not. The originating IP of a
      request must be in one of the listed subnets in order for this Condition
      to be true. If empty, all IP addresses are allowed.
    members: The request must be made by one of the provided user or service
      accounts. Groups are not supported. Syntax: `user:{emailid}`
      `serviceAccount:{emailid}` If not specified, a request may come from any
      user.
    negate: Whether to negate the Condition. If true, the Condition becomes a
      NAND over its non-empty fields, each field must be false for the
      Condition overall to be satisfied. Defaults to false.
    regions: The request must originate from one of the provided
      countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
    requiredAccessLevels: A list of other access levels defined in the same
      `Policy`, referenced by resource name. Referencing an `AccessLevel`
      which does not exist is an error. All access levels listed must be
      granted for the Condition to be true. Example:
      "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
  """

  devicePolicy = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1DevicePolicy', 1)
  ipSubnetworks = _messages.StringField(2, repeated=True)
  members = _messages.StringField(3, repeated=True)
  negate = _messages.BooleanField(4)
  regions = _messages.StringField(5, repeated=True)
  requiredAccessLevels = _messages.StringField(6, repeated=True)


class GoogleIdentityAccesscontextmanagerV1CustomLevel(_messages.Message):
  r"""`CustomLevel` is an `AccessLevel` using the Cloud Common Expression
  Language to represent the necessary conditions for the level to apply to a
  request. See CEL spec at: https://github.com/google/cel-spec

  Fields:
    expr: Required. A Cloud CEL expression evaluating to a boolean.
  """

  expr = _messages.MessageField('Expr', 1)


class GoogleIdentityAccesscontextmanagerV1DevicePolicy(_messages.Message):
  r"""`DevicePolicy` specifies device specific restrictions necessary to
  acquire a given access level. A `DevicePolicy` specifies requirements for
  requests from devices to be granted access levels, it does not do any
  enforcement on the device. `DevicePolicy` acts as an AND over all specified
  fields, and each repeated field is an OR over its elements. Any unset fields
  are ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS,
  os_type : DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the
  DevicePolicy will be true for requests originating from encrypted Linux
  desktops and encrypted Windows desktops.

  Enums:
    AllowedDeviceManagementLevelsValueListEntryValuesEnum:
    AllowedEncryptionStatusesValueListEntryValuesEnum:

  Fields:
    allowedDeviceManagementLevels: Allowed device management levels, an empty
      list allows all management levels.
    allowedEncryptionStatuses: Allowed encryptions statuses, an empty list
      allows all statuses.
    osConstraints: Allowed OS versions, an empty list allows all types and all
      versions.
    requireAdminApproval: Whether the device needs to be approved by the
      customer admin.
    requireCorpOwned: Whether the device needs to be corp owned.
    requireScreenlock: Whether or not screenlock is required for the
      DevicePolicy to be true. Defaults to `false`.
  """

  class AllowedDeviceManagementLevelsValueListEntryValuesEnum(_messages.Enum):
    r"""AllowedDeviceManagementLevelsValueListEntryValuesEnum enum type.

    Values:
      MANAGEMENT_UNSPECIFIED: <no description>
      NONE: <no description>
      BASIC: <no description>
      COMPLETE: <no description>
    """
    MANAGEMENT_UNSPECIFIED = 0
    NONE = 1
    BASIC = 2
    COMPLETE = 3

  class AllowedEncryptionStatusesValueListEntryValuesEnum(_messages.Enum):
    r"""AllowedEncryptionStatusesValueListEntryValuesEnum enum type.

    Values:
      ENCRYPTION_UNSPECIFIED: <no description>
      ENCRYPTION_UNSUPPORTED: <no description>
      UNENCRYPTED: <no description>
      ENCRYPTED: <no description>
    """
    ENCRYPTION_UNSPECIFIED = 0
    ENCRYPTION_UNSUPPORTED = 1
    UNENCRYPTED = 2
    ENCRYPTED = 3

  allowedDeviceManagementLevels = _messages.EnumField('AllowedDeviceManagementLevelsValueListEntryValuesEnum', 1, repeated=True)
  allowedEncryptionStatuses = _messages.EnumField('AllowedEncryptionStatusesValueListEntryValuesEnum', 2, repeated=True)
  osConstraints = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1OsConstraint', 3, repeated=True)
  requireAdminApproval = _messages.BooleanField(4)
  requireCorpOwned = _messages.BooleanField(5)
  requireScreenlock = _messages.BooleanField(6)


class GoogleIdentityAccesscontextmanagerV1OsConstraint(_messages.Message):
  r"""A restriction on the OS type and version of devices making requests.

  Enums:
    OsTypeValueValuesEnum: Required. The allowed OS type.

  Fields:
    minimumVersion: The minimum allowed OS version. If not set, any version of
      this OS satisfies the constraint. Format: `"major.minor.patch"`.
      Examples: `"10.5.301"`, `"9.2.1"`.
    osType: Required. The allowed OS type.
    requireVerifiedChromeOs: Only allows requests from devices with a verified
      Chrome OS. Verifications includes requirements that the device is
      enterprise-managed, conformant to domain policies, and the caller has
      permission to call the API targeted by the request.
  """

  class OsTypeValueValuesEnum(_messages.Enum):
    r"""Required. The allowed OS type.

    Values:
      OS_UNSPECIFIED: The operating system of the device is not specified or
        not known.
      DESKTOP_MAC: A desktop Mac operating system.
      DESKTOP_WINDOWS: A desktop Windows operating system.
      DESKTOP_LINUX: A desktop Linux operating system.
      DESKTOP_CHROME_OS: A desktop ChromeOS operating system.
      ANDROID: An Android operating system.
      IOS: An iOS operating system.
    """
    OS_UNSPECIFIED = 0
    DESKTOP_MAC = 1
    DESKTOP_WINDOWS = 2
    DESKTOP_LINUX = 3
    DESKTOP_CHROME_OS = 4
    ANDROID = 5
    IOS = 6

  minimumVersion = _messages.StringField(1)
  osType = _messages.EnumField('OsTypeValueValuesEnum', 2)
  requireVerifiedChromeOs = _messages.BooleanField(3)


class GoogleIdentityAccesscontextmanagerV1ServicePerimeter(_messages.Message):
  r"""`ServicePerimeter` describes a set of Google Cloud resources which can
  freely import and export data amongst themselves, but not export outside of
  the `ServicePerimeter`. If a request with a source within this
  `ServicePerimeter` has a target outside of the `ServicePerimeter`, the
  request will be blocked. Otherwise the request is allowed. There are two
  types of Service Perimeter - Regular and Bridge. Regular Service Perimeters
  cannot overlap, a single Google Cloud project can only belong to a single
  regular Service Perimeter. Service Perimeter Bridges can contain only Google
  Cloud projects as members, a single Google Cloud project may belong to
  multiple Service Perimeter Bridges.

  Enums:
    PerimeterTypeValueValuesEnum: Perimeter type indicator. A single project
      is allowed to be a member of single regular perimeter, but multiple
      service perimeter bridges. A project cannot be a included in a perimeter
      bridge without being included in regular perimeter. For perimeter
      bridges, the restricted service list as well as access level lists must
      be empty.

  Fields:
    createTime: Output only. Time the `ServicePerimeter` was created in UTC.
    description: Description of the `ServicePerimeter` and its use. Does not
      affect behavior.
    name: Required. Resource name for the ServicePerimeter.  The `short_name`
      component must begin with a letter and only include alphanumeric and
      '_'. Format: `accessPolicies/{policy_id}/servicePerimeters/{short_name}`
    perimeterType: Perimeter type indicator. A single project is allowed to be
      a member of single regular perimeter, but multiple service perimeter
      bridges. A project cannot be a included in a perimeter bridge without
      being included in regular perimeter. For perimeter bridges, the
      restricted service list as well as access level lists must be empty.
    spec: Proposed (or dry run) ServicePerimeter configuration. This
      configuration allows to specify and test ServicePerimeter configuration
      without enforcing actual access restrictions. Only allowed to be set
      when the "use_explicit_dry_run_spec" flag is set.
    status: Current ServicePerimeter configuration. Specifies sets of
      resources, restricted services and access levels that determine
      perimeter content and boundaries.
    title: Human readable title. Must be unique within the Policy.
    updateTime: Output only. Time the `ServicePerimeter` was updated in UTC.
    useExplicitDryRunSpec: Use explicit dry run spec flag. Ordinarily, a dry-
      run spec implicitly exists  for all Service Perimeters, and that spec is
      identical to the status for those Service Perimeters. When this flag is
      set, it inhibits the generation of the implicit spec, thereby allowing
      the user to explicitly provide a configuration ("spec") to use in a dry-
      run version of the Service Perimeter. This allows the user to test
      changes to the enforced config ("status") without actually enforcing
      them. This testing is done through analyzing the differences between
      currently enforced and suggested restrictions. use_explicit_dry_run_spec
      must bet set to True if any of the fields in the spec are set to non-
      default values.
  """

  class PerimeterTypeValueValuesEnum(_messages.Enum):
    r"""Perimeter type indicator. A single project is allowed to be a member
    of single regular perimeter, but multiple service perimeter bridges. A
    project cannot be a included in a perimeter bridge without being included
    in regular perimeter. For perimeter bridges, the restricted service list
    as well as access level lists must be empty.

    Values:
      PERIMETER_TYPE_REGULAR: Regular Perimeter.
      PERIMETER_TYPE_BRIDGE: Perimeter Bridge.
    """
    PERIMETER_TYPE_REGULAR = 0
    PERIMETER_TYPE_BRIDGE = 1

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  name = _messages.StringField(3)
  perimeterType = _messages.EnumField('PerimeterTypeValueValuesEnum', 4)
  spec = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig', 5)
  status = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig', 6)
  title = _messages.StringField(7)
  updateTime = _messages.StringField(8)
  useExplicitDryRunSpec = _messages.BooleanField(9)


class GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig(_messages.Message):
  r"""`ServicePerimeterConfig` specifies a set of Google Cloud resources that
  describe specific Service Perimeter configuration.

  Fields:
    accessLevels: A list of `AccessLevel` resource names that allow resources
      within the `ServicePerimeter` to be accessed from the internet.
      `AccessLevels` listed must be in the same policy as this
      `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax
      error. If no `AccessLevel` names are listed, resources within the
      perimeter can only be accessed via Google Cloud calls with request
      origins within the perimeter. Example:
      `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service
      Perimeter Bridge, must be empty.
    resources: A list of Google Cloud resources that are inside of the service
      perimeter. Currently only projects are allowed. Format:
      `projects/{project_number}`
    restrictedServices: Google Cloud services that are subject to the Service
      Perimeter restrictions. For example, if `storage.googleapis.com` is
      specified, access to the storage buckets inside the perimeter must meet
      the perimeter's access restrictions.
    vpcAccessibleServices: Configuration for APIs allowed within Perimeter.
  """

  accessLevels = _messages.StringField(1, repeated=True)
  resources = _messages.StringField(2, repeated=True)
  restrictedServices = _messages.StringField(3, repeated=True)
  vpcAccessibleServices = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices', 4)


class GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices(_messages.Message):
  r"""Specifies how APIs are allowed to communicate within the Service
  Perimeter.

  Fields:
    allowedServices: The list of APIs usable within the Service Perimeter.
      Must be empty unless 'enable_restriction' is True.
    enableRestriction: Whether to restrict API calls within the Service
      Perimeter to the list of APIs specified in 'allowed_services'.
  """

  allowedServices = _messages.StringField(1, repeated=True)
  enableRestriction = _messages.BooleanField(2)


class ListFeedsResponse(_messages.Message):
  r"""A ListFeedsResponse object.

  Fields:
    feeds: A list of feeds.
  """

  feeds = _messages.MessageField('Feed', 1, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OutputConfig(_messages.Message):
  r"""Output configuration for export assets destination.

  Fields:
    bigqueryDestination: Destination on BigQuery. The output table stores the
      fields in asset proto as columns in BigQuery. The resource/iam_policy
      field is converted to a record with each field to a column, except
      metadata to a single JSON string.
    gcsDestination: Destination on Cloud Storage.
  """

  bigqueryDestination = _messages.MessageField('BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GcsDestination', 2)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.   A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role.  Optionally, a
  `binding` can specify a `condition`, which is a logical expression that
  allows access to a resource only if the expression evaluates to `true`. A
  condition can add constraints based on attributes of the request, the
  resource, or both.  **JSON example:**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members":
  ["user:eve@example.com"],           "condition": {             "title":
  "expirable access",             "description": "Does not grant access after
  Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ],
  "etag": "BwWWja0YfJA=",       "version": 3     }  **YAML example:**
  bindings:     - members:       - user:mike@example.com       -
  group:admins@example.com       - domain:google.com       - serviceAccount
  :my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')     - etag: BwWWja0YfJA=     -
  version: 3  For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy.  Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected.  Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations:  * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy   that includes conditions  **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost.  If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PubsubDestination(_messages.Message):
  r"""A Cloud Pubsub destination.

  Fields:
    topic: The name of the Cloud Pub/Sub topic to publish to. For example:
      `projects/PROJECT_ID/topics/TOPIC_ID`.
  """

  topic = _messages.StringField(1)


class Resource(_messages.Message):
  r"""A representation of a Google Cloud resource.

  Messages:
    DataValue: The content of the resource, in which some sensitive fields are
      removed and may not be present.

  Fields:
    data: The content of the resource, in which some sensitive fields are
      removed and may not be present.
    discoveryDocumentUri: The URL of the discovery document containing the
      resource's JSON schema. For example:
      "https://www.googleapis.com/discovery/v1/apis/compute/v1/rest"  This
      value is unspecified for resources that do not have an API based on a
      discovery document, such as Cloud Bigtable.
    discoveryName: The JSON schema name listed in the discovery document. For
      example: "Project"  This value is unspecified for resources that do not
      have an API based on a discovery document, such as Cloud Bigtable.
    parent: The full name of the immediate parent of this resource. See
      [Resource Names](https://cloud.google.com/apis/design/resource_names#ful
      l_resource_name) for more information.  For Google Cloud assets, this
      value is the parent resource defined in the [Cloud IAM policy
      hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
      For example:
      "//cloudresourcemanager.googleapis.com/projects/my_project_123"  For
      third-party assets, this field may be set differently.
    resourceUrl: The REST URL for accessing the resource. An HTTP `GET`
      request using this URL returns the resource itself. For example:
      "https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123"
      This value is unspecified for resources without a REST API.
    version: The API version. For example: "v1"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""The content of the resource, in which some sensitive fields are
    removed and may not be present.

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  data = _messages.MessageField('DataValue', 1)
  discoveryDocumentUri = _messages.StringField(2)
  discoveryName = _messages.StringField(3)
  parent = _messages.StringField(4)
  resourceUrl = _messages.StringField(5)
  version = _messages.StringField(6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TemporalAsset(_messages.Message):
  r"""An asset in Google Cloud and its temporal metadata, including the time
  window when it was observed and its status during that window.

  Fields:
    asset: An asset in Google Cloud.
    deleted: Whether the asset has been deleted or not.
    window: The time window when the asset data and state was observed.
  """

  asset = _messages.MessageField('Asset', 1)
  deleted = _messages.BooleanField(2)
  window = _messages.MessageField('TimeWindow', 3)


class TimeWindow(_messages.Message):
  r"""A time window specified by its "start_time" and "end_time".

  Fields:
    endTime: End time of the time window (inclusive). If not specified, the
      current timestamp is used instead.
    startTime: Start time of the time window (exclusive).
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class UpdateFeedRequest(_messages.Message):
  r"""Update asset feed request.

  Fields:
    feed: Required. The new values of feed details. It must match an existing
      feed and the field `name` must be in the format of:
      projects/project_number/feeds/feed_id or
      folders/folder_number/feeds/feed_id or
      organizations/organization_number/feeds/feed_id.
    updateMask: Required. Only updates the `feed` fields indicated by this
      mask. The field mask must not be empty, and it must not contain fields
      that are immutable or only set by the server.
  """

  feed = _messages.MessageField('Feed', 1)
  updateMask = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
