"""Generated client library for bigquerydatatransfer version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.bigquerydatatransfer.v1 import bigquerydatatransfer_v1_messages as messages


class BigquerydatatransferV1(base_api.BaseApiClient):
  """Generated client library for service bigquerydatatransfer version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://bigquerydatatransfer.googleapis.com/'
  MTLS_BASE_URL = u'https://bigquerydatatransfer.mtls.googleapis.com/'

  _PACKAGE = u'bigquerydatatransfer'
  _SCOPES = [u'https://www.googleapis.com/auth/bigquery', u'https://www.googleapis.com/auth/bigquery.readonly', u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'BigquerydatatransferV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new bigquerydatatransfer handle."""
    url = url or self.BASE_URL
    super(BigquerydatatransferV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_dataSources = self.ProjectsDataSourcesService(self)
    self.projects_locations_dataSources = self.ProjectsLocationsDataSourcesService(self)
    self.projects_locations_transferConfigs_runs_transferLogs = self.ProjectsLocationsTransferConfigsRunsTransferLogsService(self)
    self.projects_locations_transferConfigs_runs = self.ProjectsLocationsTransferConfigsRunsService(self)
    self.projects_locations_transferConfigs = self.ProjectsLocationsTransferConfigsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_transferConfigs_runs_transferLogs = self.ProjectsTransferConfigsRunsTransferLogsService(self)
    self.projects_transferConfigs_runs = self.ProjectsTransferConfigsRunsService(self)
    self.projects_transferConfigs = self.ProjectsTransferConfigsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsDataSourcesService(base_api.BaseApiService):
    """Service class for the projects_dataSources resource."""

    _NAME = u'projects_dataSources'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsDataSourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckValidCreds(self, request, global_params=None):
      r"""Returns true if valid credentials exist for the given data source and.
requesting user.
Some data sources doesn't support service account, so we need to talk to
them on behalf of the end user. This API just checks whether we have OAuth
token for the particular user, which is a pre-requisite before user can
create a transfer config.

      Args:
        request: (BigquerydatatransferProjectsDataSourcesCheckValidCredsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckValidCredsResponse) The response message.
      """
      config = self.GetMethodConfig('CheckValidCreds')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckValidCreds.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/dataSources/{dataSourcesId}:checkValidCreds',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.dataSources.checkValidCreds',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:checkValidCreds',
        request_field=u'checkValidCredsRequest',
        request_type_name=u'BigquerydatatransferProjectsDataSourcesCheckValidCredsRequest',
        response_type_name=u'CheckValidCredsResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a supported data source and returns its settings,.
which can be used for UI rendering.

      Args:
        request: (BigquerydatatransferProjectsDataSourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/dataSources/{dataSourcesId}',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.dataSources.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsDataSourcesGetRequest',
        response_type_name=u'DataSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists supported data sources and returns their settings,.
which can be used for UI rendering.

      Args:
        request: (BigquerydatatransferProjectsDataSourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/dataSources',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.dataSources.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/dataSources',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsDataSourcesListRequest',
        response_type_name=u'ListDataSourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsDataSourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_dataSources resource."""

    _NAME = u'projects_locations_dataSources'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsDataSourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckValidCreds(self, request, global_params=None):
      r"""Returns true if valid credentials exist for the given data source and.
requesting user.
Some data sources doesn't support service account, so we need to talk to
them on behalf of the end user. This API just checks whether we have OAuth
token for the particular user, which is a pre-requisite before user can
create a transfer config.

      Args:
        request: (BigquerydatatransferProjectsLocationsDataSourcesCheckValidCredsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckValidCredsResponse) The response message.
      """
      config = self.GetMethodConfig('CheckValidCreds')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckValidCreds.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/dataSources/{dataSourcesId}:checkValidCreds',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.locations.dataSources.checkValidCreds',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:checkValidCreds',
        request_field=u'checkValidCredsRequest',
        request_type_name=u'BigquerydatatransferProjectsLocationsDataSourcesCheckValidCredsRequest',
        response_type_name=u'CheckValidCredsResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a supported data source and returns its settings,.
which can be used for UI rendering.

      Args:
        request: (BigquerydatatransferProjectsLocationsDataSourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/dataSources/{dataSourcesId}',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.dataSources.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsDataSourcesGetRequest',
        response_type_name=u'DataSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists supported data sources and returns their settings,.
which can be used for UI rendering.

      Args:
        request: (BigquerydatatransferProjectsLocationsDataSourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/dataSources',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.dataSources.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/dataSources',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsDataSourcesListRequest',
        response_type_name=u'ListDataSourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsTransferConfigsRunsTransferLogsService(base_api.BaseApiService):
    """Service class for the projects_locations_transferConfigs_runs_transferLogs resource."""

    _NAME = u'projects_locations_transferConfigs_runs_transferLogs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsTransferConfigsRunsTransferLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns user facing log messages for the data transfer run.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsTransferLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}/transferLogs',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.runs.transferLogs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'messageTypes', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/transferLogs',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsRunsTransferLogsListRequest',
        response_type_name=u'ListTransferLogsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTransferConfigsRunsService(base_api.BaseApiService):
    """Service class for the projects_locations_transferConfigs_runs resource."""

    _NAME = u'projects_locations_transferConfigs_runs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsTransferConfigsRunsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified transfer run.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method=u'DELETE',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.runs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsRunsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about the particular transfer run.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferRun) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.runs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsRunsGetRequest',
        response_type_name=u'TransferRun',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about running and completed jobs.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.runs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'runAttempt', u'states'],
        relative_path=u'v1/{+parent}/runs',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsRunsListRequest',
        response_type_name=u'ListTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTransferConfigsService(base_api.BaseApiService):
    """Service class for the projects_locations_transferConfigs resource."""

    _NAME = u'projects_locations_transferConfigs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsTransferConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new data transfer configuration.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'authorizationCode', u'serviceAccountName', u'versionInfo'],
        relative_path=u'v1/{+parent}/transferConfigs',
        request_field=u'transferConfig',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsCreateRequest',
        response_type_name=u'TransferConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a data transfer configuration,.
including any associated transfer runs and logs.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}',
        http_method=u'DELETE',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about a data transfer config.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsGetRequest',
        response_type_name=u'TransferConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about all data transfers in the project.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'dataSourceIds', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/transferConfigs',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsListRequest',
        response_type_name=u'ListTransferConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a data transfer configuration.
All fields must be set, even if they are not updated.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}',
        http_method=u'PATCH',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'authorizationCode', u'serviceAccountName', u'updateMask', u'versionInfo'],
        relative_path=u'v1/{+name}',
        request_field=u'transferConfig',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsPatchRequest',
        response_type_name=u'TransferConfig',
        supports_download=False,
    )

    def ScheduleRuns(self, request, global_params=None):
      r"""Creates transfer runs for a time range [start_time, end_time].
For each date - or whatever granularity the data source supports - in the
range, one transfer run is created.
Note that runs are created per UTC time in the time range.
DEPRECATED: use StartManualTransferRuns instead.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsScheduleRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScheduleTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('ScheduleRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    ScheduleRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}:scheduleRuns',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.scheduleRuns',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}:scheduleRuns',
        request_field=u'scheduleTransferRunsRequest',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsScheduleRunsRequest',
        response_type_name=u'ScheduleTransferRunsResponse',
        supports_download=False,
    )

    def StartManualRuns(self, request, global_params=None):
      r"""Start manual transfer runs to be executed now with schedule_time equal to.
current time. The transfer runs can be created for a time range where the
run_time is between start_time (inclusive) and end_time (exclusive), or for
a specific run_time.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsStartManualRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StartManualTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('StartManualRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartManualRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}:startManualRuns',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.locations.transferConfigs.startManualRuns',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}:startManualRuns',
        request_field=u'startManualTransferRunsRequest',
        request_type_name=u'BigquerydatatransferProjectsLocationsTransferConfigsStartManualRunsRequest',
        response_type_name=u'StartManualTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (BigquerydatatransferProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (BigquerydatatransferProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+name}/locations',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsTransferConfigsRunsTransferLogsService(base_api.BaseApiService):
    """Service class for the projects_transferConfigs_runs_transferLogs resource."""

    _NAME = u'projects_transferConfigs_runs_transferLogs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsTransferConfigsRunsTransferLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns user facing log messages for the data transfer run.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsTransferLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}/transferLogs',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.runs.transferLogs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'messageTypes', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/transferLogs',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsRunsTransferLogsListRequest',
        response_type_name=u'ListTransferLogsResponse',
        supports_download=False,
    )

  class ProjectsTransferConfigsRunsService(base_api.BaseApiService):
    """Service class for the projects_transferConfigs_runs resource."""

    _NAME = u'projects_transferConfigs_runs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsTransferConfigsRunsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified transfer run.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method=u'DELETE',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.runs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsRunsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about the particular transfer run.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferRun) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.runs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsRunsGetRequest',
        response_type_name=u'TransferRun',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about running and completed jobs.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.runs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'runAttempt', u'states'],
        relative_path=u'v1/{+parent}/runs',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsRunsListRequest',
        response_type_name=u'ListTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsTransferConfigsService(base_api.BaseApiService):
    """Service class for the projects_transferConfigs resource."""

    _NAME = u'projects_transferConfigs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsTransferConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new data transfer configuration.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'authorizationCode', u'serviceAccountName', u'versionInfo'],
        relative_path=u'v1/{+parent}/transferConfigs',
        request_field=u'transferConfig',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsCreateRequest',
        response_type_name=u'TransferConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a data transfer configuration,.
including any associated transfer runs and logs.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}',
        http_method=u'DELETE',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about a data transfer config.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsGetRequest',
        response_type_name=u'TransferConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about all data transfers in the project.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs',
        http_method=u'GET',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'dataSourceIds', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/transferConfigs',
        request_field='',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsListRequest',
        response_type_name=u'ListTransferConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a data transfer configuration.
All fields must be set, even if they are not updated.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}',
        http_method=u'PATCH',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'authorizationCode', u'serviceAccountName', u'updateMask', u'versionInfo'],
        relative_path=u'v1/{+name}',
        request_field=u'transferConfig',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsPatchRequest',
        response_type_name=u'TransferConfig',
        supports_download=False,
    )

    def ScheduleRuns(self, request, global_params=None):
      r"""Creates transfer runs for a time range [start_time, end_time].
For each date - or whatever granularity the data source supports - in the
range, one transfer run is created.
Note that runs are created per UTC time in the time range.
DEPRECATED: use StartManualTransferRuns instead.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsScheduleRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScheduleTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('ScheduleRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    ScheduleRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}:scheduleRuns',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.scheduleRuns',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}:scheduleRuns',
        request_field=u'scheduleTransferRunsRequest',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsScheduleRunsRequest',
        response_type_name=u'ScheduleTransferRunsResponse',
        supports_download=False,
    )

    def StartManualRuns(self, request, global_params=None):
      r"""Start manual transfer runs to be executed now with schedule_time equal to.
current time. The transfer runs can be created for a time range where the
run_time is between start_time (inclusive) and end_time (exclusive), or for
a specific run_time.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsStartManualRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StartManualTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('StartManualRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartManualRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/transferConfigs/{transferConfigsId}:startManualRuns',
        http_method=u'POST',
        method_id=u'bigquerydatatransfer.projects.transferConfigs.startManualRuns',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}:startManualRuns',
        request_field=u'startManualTransferRunsRequest',
        request_type_name=u'BigquerydatatransferProjectsTransferConfigsStartManualRunsRequest',
        response_type_name=u'StartManualTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
