"""Generated client library for apikeys version v2alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.apikeys.v2alpha1 import apikeys_v2alpha1_messages as messages


class ApikeysV2alpha1(base_api.BaseApiClient):
  """Generated client library for service apikeys version v2alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://apikeys.googleapis.com/'
  MTLS_BASE_URL = u'https://apikeys.mtls.googleapis.com/'

  _PACKAGE = u'apikeys'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = u'v2alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ApikeysV2alpha1'
  _URL_VERSION = u'v2alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new apikeys handle."""
    url = url or self.BASE_URL
    super(ApikeysV2alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.operations = self.OperationsService(self)
    self.projects_keys = self.ProjectsKeysService(self)
    self.projects = self.ProjectsService(self)
    self.v2alpha1 = self.V2alpha1Service(self)

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(ApikeysV2alpha1.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (ApikeysOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'apikeys.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2alpha1/{+name}',
        request_field='',
        request_type_name=u'ApikeysOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsKeysService(base_api.BaseApiService):
    """Service class for the projects_keys resource."""

    _NAME = u'projects_keys'

    def __init__(self, client):
      super(ApikeysV2alpha1.ProjectsKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Clone(self, request, global_params=None):
      r"""Clones the existing key's restriction, display name to a new Api Key.

      Args:
        request: (ApikeysProjectsKeysCloneRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Clone')
      return self._RunMethod(
          config, request, global_params=global_params)

    Clone.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys/{keysId}:clone',
        http_method=u'POST',
        method_id=u'apikeys.projects.keys.clone',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2alpha1/{+name}:clone',
        request_field=u'v2alpha1CloneKeyRequest',
        request_type_name=u'ApikeysProjectsKeysCloneRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new API key.

      Args:
        request: (ApikeysProjectsKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys',
        http_method=u'POST',
        method_id=u'apikeys.projects.keys.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2alpha1/{+parent}/keys',
        request_field=u'v2alpha1ApiKey',
        request_type_name=u'ApikeysProjectsKeysCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an API key.

      Args:
        request: (ApikeysProjectsKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys/{keysId}',
        http_method=u'DELETE',
        method_id=u'apikeys.projects.keys.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2alpha1/{+name}',
        request_field='',
        request_type_name=u'ApikeysProjectsKeysDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the metadata for an API key. Key string will not be set in the.
response.

      Args:
        request: (ApikeysProjectsKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1ApiKey) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys/{keysId}',
        http_method=u'GET',
        method_id=u'apikeys.projects.keys.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2alpha1/{+name}',
        request_field='',
        request_type_name=u'ApikeysProjectsKeysGetRequest',
        response_type_name=u'V2alpha1ApiKey',
        supports_download=False,
    )

    def GetKeyString(self, request, global_params=None):
      r"""Get key string for an API key.

      Args:
        request: (ApikeysProjectsKeysGetKeyStringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1GetKeyStringResponse) The response message.
      """
      config = self.GetMethodConfig('GetKeyString')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetKeyString.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys/{keysId}/keyString',
        http_method=u'GET',
        method_id=u'apikeys.projects.keys.getKeyString',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2alpha1/{+name}/keyString',
        request_field='',
        request_type_name=u'ApikeysProjectsKeysGetKeyStringRequest',
        response_type_name=u'V2alpha1GetKeyStringResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the API keys owned by a project. Key string of ApiKey will not be.
set.

      Args:
        request: (ApikeysProjectsKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1ListKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys',
        http_method=u'GET',
        method_id=u'apikeys.projects.keys.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v2alpha1/{+parent}/keys',
        request_field='',
        request_type_name=u'ApikeysProjectsKeysListRequest',
        response_type_name=u'V2alpha1ListKeysResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the modifiable fields of an API key.
Key string will not be set in the ApiKey response of the long running
operation.

      Args:
        request: (ApikeysProjectsKeysPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys/{keysId}',
        http_method=u'PATCH',
        method_id=u'apikeys.projects.keys.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2alpha1/{+name}',
        request_field=u'v2alpha1ApiKey',
        request_type_name=u'ApikeysProjectsKeysPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Undeletes an API key which was deleted within 30 days.

      Args:
        request: (ApikeysProjectsKeysUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2alpha1/projects/{projectsId}/keys/{keysId}:undelete',
        http_method=u'POST',
        method_id=u'apikeys.projects.keys.undelete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2alpha1/{+name}:undelete',
        request_field=u'v2alpha1UndeleteKeyRequest',
        request_type_name=u'ApikeysProjectsKeysUndeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ApikeysV2alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class V2alpha1Service(base_api.BaseApiService):
    """Service class for the v2alpha1 resource."""

    _NAME = u'v2alpha1'

    def __init__(self, client):
      super(ApikeysV2alpha1.V2alpha1Service, self).__init__(client)
      self._upload_configs = {
          }

    def GetKeyStringName(self, request, global_params=None):
      r"""Get parent and name of the Api Key which has the key string.
Permission `apikeys.keys.getKeyStringName` is required on the parent.

      Args:
        request: (ApikeysGetKeyStringNameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1GetKeyStringNameResponse) The response message.
      """
      config = self.GetMethodConfig('GetKeyStringName')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetKeyStringName.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'apikeys.getKeyStringName',
        ordered_params=[],
        path_params=[],
        query_params=[u'keyString'],
        relative_path=u'v2alpha1/keyStringName',
        request_field='',
        request_type_name=u'ApikeysGetKeyStringNameRequest',
        response_type_name=u'V2alpha1GetKeyStringNameResponse',
        supports_download=False,
    )
