"""Generated client library for cloudidentity version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.cloudidentity.v1beta1 import cloudidentity_v1beta1_messages as messages


class CloudidentityV1beta1(base_api.BaseApiClient):
  """Generated client library for service cloudidentity version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://cloudidentity.googleapis.com/'
  MTLS_BASE_URL = u'https://cloudidentity.mtls.googleapis.com/'

  _PACKAGE = u'cloudidentity'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-identity.groups', u'https://www.googleapis.com/auth/cloud-identity.groups.readonly', u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'CloudidentityV1beta1'
  _URL_VERSION = u'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudidentity handle."""
    url = url or self.BASE_URL
    super(CloudidentityV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.devices_account = self.DevicesAccountService(self)
    self.devices = self.DevicesService(self)
    self.groups_memberships = self.GroupsMembershipsService(self)
    self.groups = self.GroupsService(self)

  class DevicesAccountService(base_api.BaseApiService):
    """Service class for the devices_account resource."""

    _NAME = u'devices_account'

    def __init__(self, client):
      super(CloudidentityV1beta1.DevicesAccountService, self).__init__(client)
      self._upload_configs = {
          }

    def Wipe(self, request, global_params=None):
      r"""Wipe the account on a device.

      Args:
        request: (CloudidentityDevicesAccountWipeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Wipe')
      return self._RunMethod(
          config, request, global_params=global_params)

    Wipe.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}/account:wipe',
        http_method=u'POST',
        method_id=u'cloudidentity.devices.account.wipe',
        ordered_params=[u'device'],
        path_params=[u'device'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+device}/account:wipe',
        request_field='',
        request_type_name=u'CloudidentityDevicesAccountWipeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class DevicesService(base_api.BaseApiService):
    """Service class for the devices resource."""

    _NAME = u'devices'

    def __init__(self, client):
      super(CloudidentityV1beta1.DevicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Approve(self, request, global_params=None):
      r"""Approve device to access account data.

      Args:
        request: (CloudidentityDevicesApproveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Approve')
      return self._RunMethod(
          config, request, global_params=global_params)

    Approve.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}:approve',
        http_method=u'POST',
        method_id=u'cloudidentity.devices.approve',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+name}:approve',
        request_field='',
        request_type_name=u'CloudidentityDevicesApproveRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Block(self, request, global_params=None):
      r"""Block device from accessing account data.

      Args:
        request: (CloudidentityDevicesBlockRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Block')
      return self._RunMethod(
          config, request, global_params=global_params)

    Block.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}:block',
        http_method=u'POST',
        method_id=u'cloudidentity.devices.block',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+name}:block',
        request_field='',
        request_type_name=u'CloudidentityDevicesBlockRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def CancelWipe(self, request, global_params=None):
      r"""Cancel an unfinished device wipe.
This operation can be used to cancel device wipe in the gap between the
wipe operation returning success and the device being wiped.

      Args:
        request: (CloudidentityDevicesCancelWipeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CancelWipe')
      return self._RunMethod(
          config, request, global_params=global_params)

    CancelWipe.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}:cancelWipe',
        http_method=u'POST',
        method_id=u'cloudidentity.devices.cancelWipe',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+name}:cancelWipe',
        request_field='',
        request_type_name=u'CloudidentityDevicesCancelWipeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a device.

      Args:
        request: (CloudidentityDevicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}',
        http_method=u'DELETE',
        method_id=u'cloudidentity.devices.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'CloudidentityDevicesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a device.

      Args:
        request: (CloudidentityDevicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Device) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}',
        http_method=u'GET',
        method_id=u'cloudidentity.devices.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'CloudidentityDevicesGetRequest',
        response_type_name=u'Device',
        supports_download=False,
    )

    def GetSettings(self, request, global_params=None):
      r"""Returns the effective settings compiled for the requested entity.

      Args:
        request: (CloudidentityDevicesGetSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetEffectiveSettingsResponse) The response message.
      """
      config = self.GetMethodConfig('GetSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}/settings',
        http_method=u'GET',
        method_id=u'cloudidentity.devices.getSettings',
        ordered_params=[u'resourceId'],
        path_params=[u'resourceId'],
        query_params=[u'clientContext_appId', u'clientContext_clientVersion', u'clientContext_iosVendorId', u'clientContext_osVersion'],
        relative_path=u'v1beta1/{+resourceId}/settings',
        request_field='',
        request_type_name=u'CloudidentityDevicesGetSettingsRequest',
        response_type_name=u'GetEffectiveSettingsResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List/Search devices.

      Args:
        request: (CloudidentityDevicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDevicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudidentity.devices.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'customer', u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/devices',
        request_field='',
        request_type_name=u'CloudidentityDevicesListRequest',
        response_type_name=u'ListDevicesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a device.

      Args:
        request: (CloudidentityDevicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}',
        http_method=u'PATCH',
        method_id=u'cloudidentity.devices.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field=u'updateDeviceRequest',
        request_type_name=u'CloudidentityDevicesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Ring(self, request, global_params=None):
      r"""Ring device.

      Args:
        request: (CloudidentityDevicesRingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Ring')
      return self._RunMethod(
          config, request, global_params=global_params)

    Ring.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}:ring',
        http_method=u'POST',
        method_id=u'cloudidentity.devices.ring',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+name}:ring',
        request_field='',
        request_type_name=u'CloudidentityDevicesRingRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Settings(self, request, global_params=None):
      r"""Returns the effective settings compiled for the requested entity.

      Args:
        request: (CloudidentityDevicesSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetEffectiveSettingsResponse) The response message.
      """
      config = self.GetMethodConfig('Settings')
      return self._RunMethod(
          config, request, global_params=global_params)

    Settings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}/settings',
        http_method=u'POST',
        method_id=u'cloudidentity.devices.settings',
        ordered_params=[u'resourceId'],
        path_params=[u'resourceId'],
        query_params=[],
        relative_path=u'v1beta1/{+resourceId}/settings',
        request_field=u'getEffectiveSettingsRequest',
        request_type_name=u'CloudidentityDevicesSettingsRequest',
        response_type_name=u'GetEffectiveSettingsResponse',
        supports_download=False,
    )

    def Wipe(self, request, global_params=None):
      r"""Wipe all data on a device.

      Args:
        request: (CloudidentityDevicesWipeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Wipe')
      return self._RunMethod(
          config, request, global_params=global_params)

    Wipe.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/devices/{devicesId}:wipe',
        http_method=u'POST',
        method_id=u'cloudidentity.devices.wipe',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'customer'],
        relative_path=u'v1beta1/{+name}:wipe',
        request_field='',
        request_type_name=u'CloudidentityDevicesWipeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class GroupsMembershipsService(base_api.BaseApiService):
    """Service class for the groups_memberships resource."""

    _NAME = u'groups_memberships'

    def __init__(self, client):
      super(CloudidentityV1beta1.GroupsMembershipsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}/memberships',
        http_method=u'POST',
        method_id=u'cloudidentity.groups.memberships.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/memberships',
        request_field=u'membership',
        request_type_name=u'CloudidentityGroupsMembershipsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}/memberships/{membershipsId}',
        http_method=u'DELETE',
        method_id=u'cloudidentity.groups.memberships.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'CloudidentityGroupsMembershipsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Membership) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}/memberships/{membershipsId}',
        http_method=u'GET',
        method_id=u'cloudidentity.groups.memberships.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'CloudidentityGroupsMembershipsGetRequest',
        response_type_name=u'Membership',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the `Membership`s within a `Group`.

      Args:
        request: (CloudidentityGroupsMembershipsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMembershipsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}/memberships',
        http_method=u'GET',
        method_id=u'cloudidentity.groups.memberships.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'view'],
        relative_path=u'v1beta1/{+parent}/memberships',
        request_field='',
        request_type_name=u'CloudidentityGroupsMembershipsListRequest',
        response_type_name=u'ListMembershipsResponse',
        supports_download=False,
    )

    def Lookup(self, request, global_params=None):
      r"""Looks up the [resource.
name](https://cloud.google.com/apis/design/resource_names) of a
`Membership` by its `EntityKey`.

      Args:
        request: (CloudidentityGroupsMembershipsLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LookupMembershipNameResponse) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}/memberships:lookup',
        http_method=u'GET',
        method_id=u'cloudidentity.groups.memberships.lookup',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'memberKey_id', u'memberKey_namespace'],
        relative_path=u'v1beta1/{+parent}/memberships:lookup',
        request_field='',
        request_type_name=u'CloudidentityGroupsMembershipsLookupRequest',
        response_type_name=u'LookupMembershipNameResponse',
        supports_download=False,
    )

    def ModifyMembershipRoles(self, request, global_params=None):
      r"""Modifies the `MembershipRole`s of a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsModifyMembershipRolesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ModifyMembershipRolesResponse) The response message.
      """
      config = self.GetMethodConfig('ModifyMembershipRoles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ModifyMembershipRoles.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}/memberships/{membershipsId}:modifyMembershipRoles',
        http_method=u'POST',
        method_id=u'cloudidentity.groups.memberships.modifyMembershipRoles',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:modifyMembershipRoles',
        request_field=u'modifyMembershipRolesRequest',
        request_type_name=u'CloudidentityGroupsMembershipsModifyMembershipRolesRequest',
        response_type_name=u'ModifyMembershipRolesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}/memberships/{membershipsId}',
        http_method=u'PATCH',
        method_id=u'cloudidentity.groups.memberships.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'membership',
        request_type_name=u'CloudidentityGroupsMembershipsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class GroupsService(base_api.BaseApiService):
    """Service class for the groups resource."""

    _NAME = u'groups'

    def __init__(self, client):
      super(CloudidentityV1beta1.GroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a `Group`.

      Args:
        request: (CloudidentityGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudidentity.groups.create',
        ordered_params=[],
        path_params=[],
        query_params=[u'initialGroupConfig'],
        relative_path=u'v1beta1/groups',
        request_field=u'group',
        request_type_name=u'CloudidentityGroupsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a `Group`.

      Args:
        request: (CloudidentityGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}',
        http_method=u'DELETE',
        method_id=u'cloudidentity.groups.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'CloudidentityGroupsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a `Group`.

      Args:
        request: (CloudidentityGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}',
        http_method=u'GET',
        method_id=u'cloudidentity.groups.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'CloudidentityGroupsGetRequest',
        response_type_name=u'Group',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the `Group`s under a customer or namespace.

      Args:
        request: (CloudidentityGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudidentity.groups.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken', u'parent', u'view'],
        relative_path=u'v1beta1/groups',
        request_field='',
        request_type_name=u'CloudidentityGroupsListRequest',
        response_type_name=u'ListGroupsResponse',
        supports_download=False,
    )

    def Lookup(self, request, global_params=None):
      r"""Looks up the [resource.
name](https://cloud.google.com/apis/design/resource_names) of a `Group` by
its `EntityKey`.

      Args:
        request: (CloudidentityGroupsLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LookupGroupNameResponse) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudidentity.groups.lookup',
        ordered_params=[],
        path_params=[],
        query_params=[u'groupKey_id', u'groupKey_namespace'],
        relative_path=u'v1beta1/groups:lookup',
        request_field='',
        request_type_name=u'CloudidentityGroupsLookupRequest',
        response_type_name=u'LookupGroupNameResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a `Group`.

      Args:
        request: (CloudidentityGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/groups/{groupsId}',
        http_method=u'PATCH',
        method_id=u'cloudidentity.groups.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'group',
        request_type_name=u'CloudidentityGroupsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for `Group`s matching a specified query.

      Args:
        request: (CloudidentityGroupsSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudidentity.groups.search',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken', u'query', u'view'],
        relative_path=u'v1beta1/groups:search',
        request_field='',
        request_type_name=u'CloudidentityGroupsSearchRequest',
        response_type_name=u'SearchGroupsResponse',
        supports_download=False,
    )
