"""Generated client library for datacatalog version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.datacatalog.v1beta1 import datacatalog_v1beta1_messages as messages


class DatacatalogV1beta1(base_api.BaseApiClient):
  """Generated client library for service datacatalog version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://datacatalog.googleapis.com/'
  MTLS_BASE_URL = u'https://datacatalog.mtls.googleapis.com/'

  _PACKAGE = u'datacatalog'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'DatacatalogV1beta1'
  _URL_VERSION = u'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new datacatalog handle."""
    url = url or self.BASE_URL
    super(DatacatalogV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.catalog = self.CatalogService(self)
    self.entries = self.EntriesService(self)
    self.projects_locations_entryGroups_entries_tags = self.ProjectsLocationsEntryGroupsEntriesTagsService(self)
    self.projects_locations_entryGroups_entries = self.ProjectsLocationsEntryGroupsEntriesService(self)
    self.projects_locations_entryGroups_tags = self.ProjectsLocationsEntryGroupsTagsService(self)
    self.projects_locations_entryGroups = self.ProjectsLocationsEntryGroupsService(self)
    self.projects_locations_tagTemplates_fields = self.ProjectsLocationsTagTemplatesFieldsService(self)
    self.projects_locations_tagTemplates = self.ProjectsLocationsTagTemplatesService(self)
    self.projects_locations_taxonomies_policyTags = self.ProjectsLocationsTaxonomiesPolicyTagsService(self)
    self.projects_locations_taxonomies = self.ProjectsLocationsTaxonomiesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class CatalogService(base_api.BaseApiService):
    """Service class for the catalog resource."""

    _NAME = u'catalog'

    def __init__(self, client):
      super(DatacatalogV1beta1.CatalogService, self).__init__(client)
      self._upload_configs = {
          }

    def Search(self, request, global_params=None):
      r"""Searches Data Catalog for multiple resources like entries, tags that.
match a query.

This is a custom method
(https://cloud.google.com/apis/design/custom_methods) and does not return
the complete resource, only the resource identifier and high level
fields. Clients can subsequentally call `Get` methods.

Note that Data Catalog search queries do not guarantee full recall. Query
results that match your query may not be returned, even in subsequent
result pages. Also note that results returned (and not returned) can vary
across repeated search queries.

See [Data Catalog Search
Syntax](/data-catalog/docs/how-to/search-reference) for more information.

      Args:
        request: (GoogleCloudDatacatalogV1beta1SearchCatalogRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1SearchCatalogResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'datacatalog.catalog.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1beta1/catalog:search',
        request_field='<request>',
        request_type_name=u'GoogleCloudDatacatalogV1beta1SearchCatalogRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1SearchCatalogResponse',
        supports_download=False,
    )

  class EntriesService(base_api.BaseApiService):
    """Service class for the entries resource."""

    _NAME = u'entries'

    def __init__(self, client):
      super(DatacatalogV1beta1.EntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Lookup(self, request, global_params=None):
      r"""Get an entry by target resource name. This method allows clients to use.
the resource name from the source Google Cloud Platform service to get the
Data Catalog Entry.

      Args:
        request: (DatacatalogEntriesLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Entry) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'datacatalog.entries.lookup',
        ordered_params=[],
        path_params=[],
        query_params=[u'linkedResource', u'sqlResource'],
        relative_path=u'v1beta1/entries:lookup',
        request_field='',
        request_type_name=u'DatacatalogEntriesLookupRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Entry',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsEntriesTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_entries_tags resource."""

    _NAME = u'projects_locations_entryGroups_entries_tags'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsEntryGroupsEntriesTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag on an Entry.
Note: The project identified by the `parent` parameter for the
[tag](/data-catalog/docs/reference/rest/v1beta1/projects.locations.entryGroups.entries.tags/create#path-parameters)
and the
[tag
template](/data-catalog/docs/reference/rest/v1beta1/projects.locations.tagTemplates/create#path-parameters)
used to create the tag must be from the same organization.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Tag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.tags.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/tags',
        request_field=u'googleCloudDatacatalogV1beta1Tag',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Tag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags/{tagsId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.tags.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the tags on an Entry.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ListTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.tags.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/tags',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ListTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Tag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags/{tagsId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.tags.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1Tag',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Tag',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsEntriesService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_entries resource."""

    _NAME = u'projects_locations_entryGroups_entries'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsEntryGroupsEntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an entry. Only entries of 'FILESET' type or user-specified type can.
be created.

Users should enable the Data Catalog API in the project identified by
the `parent` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

A maximum of 100,000 entries may be created per entry group.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Entry) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'entryId'],
        relative_path=u'v1beta1/{+parent}/entries',
        request_field=u'googleCloudDatacatalogV1beta1Entry',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Entry',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing entry. Only entries created through.
CreateEntry
method can be deleted.
Users should enable the Data Catalog API in the project identified by
the `name` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an entry.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Entry) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Entry',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error.
is returned if the resource does not exist. An empty policy is returned
if the resource exists but does not have a policy set on it.

Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

Callers must have following Google IAM permission
  - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
    templates.
  - `datacatalog.entries.getIamPolicy` to get policies on entries.
  - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists entries.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ListEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'readMask'],
        relative_path=u'v1beta1/{+parent}/entries',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesListRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ListEntriesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing entry.
Users should enable the Data Catalog API in the project identified by
the `entry.name` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Entry) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1Entry',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Entry',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the caller's permissions on a resource.
If the resource does not exist, an empty set of permissions is returned
(We don't return a `NOT_FOUND` error).

Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

A caller is not required to have Google IAM permission to make this
request.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.entries.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_tags resource."""

    _NAME = u'projects_locations_entryGroups_tags'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsEntryGroupsTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag on an Entry.
Note: The project identified by the `parent` parameter for the
[tag](/data-catalog/docs/reference/rest/v1beta1/projects.locations.entryGroups.entries.tags/create#path-parameters)
and the
[tag
template](/data-catalog/docs/reference/rest/v1beta1/projects.locations.tagTemplates/create#path-parameters)
used to create the tag must be from the same organization.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Tag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.tags.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/tags',
        request_field=u'googleCloudDatacatalogV1beta1Tag',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Tag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags/{tagsId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.entryGroups.tags.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the tags on an Entry.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ListTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.entryGroups.tags.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/tags',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsTagsListRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ListTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Tag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags/{tagsId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.entryGroups.tags.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1Tag',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Tag',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups resource."""

    _NAME = u'projects_locations_entryGroups'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsEntryGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""A maximum of 10,000 entry groups may be created per organization across all.
locations.

Users should enable the Data Catalog API in the project identified by
the `parent` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'entryGroupId'],
        relative_path=u'v1beta1/{+parent}/entryGroups',
        request_field=u'googleCloudDatacatalogV1beta1EntryGroup',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1EntryGroup',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an EntryGroup. Only entry groups that do not contain entries can be.
deleted. Users should enable the Data Catalog API in the project
identified by the `name` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.entryGroups.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'force'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an EntryGroup.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.entryGroups.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'readMask'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsGetRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1EntryGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error.
is returned if the resource does not exist. An empty policy is returned
if the resource exists but does not have a policy set on it.

Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

Callers must have following Google IAM permission
  - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
    templates.
  - `datacatalog.entries.getIamPolicy` to get policies on entries.
  - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an EntryGroup. The user should enable the Data Catalog API in the.
project identified by the `entry_group.name` parameter (see [Data Catalog
Resource Project] (/data-catalog/docs/concepts/resource-project) for more
information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.entryGroups.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1EntryGroup',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1EntryGroup',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy for a resource. Replaces any existing.
policy.
Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

Callers must have following Google IAM permission
  - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
    templates.
  - `datacatalog.entries.setIamPolicy` to set policies on entries.
  - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the caller's permissions on a resource.
If the resource does not exist, an empty set of permissions is returned
(We don't return a `NOT_FOUND` error).

Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

A caller is not required to have Google IAM permission to make this
request.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.entryGroups.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesFieldsService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates_fields resource."""

    _NAME = u'projects_locations_tagTemplates_fields'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsTagTemplatesFieldsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a field in a tag template. The user should enable the Data Catalog.
API in the project identified by the `parent` parameter (see
[Data Catalog Resource
Project](/data-catalog/docs/concepts/resource-project) for more
information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.tagTemplates.fields.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'tagTemplateFieldId'],
        relative_path=u'v1beta1/{+parent}/fields',
        request_field=u'googleCloudDatacatalogV1beta1TagTemplateField',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplateField',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a field in a tag template and all uses of that field.
Users should enable the Data Catalog API in the project identified by
the `name` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.tagTemplates.fields.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'force'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a field in a tag template. This method cannot be used to update the.
field type. Users should enable the Data Catalog API in the project
identified by the `name` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.tagTemplates.fields.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1TagTemplateField',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplateField',
        supports_download=False,
    )

    def Rename(self, request, global_params=None):
      r"""Renames a field in a tag template. The user should enable the Data Catalog.
API in the project identified by the `name` parameter (see [Data Catalog
Resource Project](/data-catalog/docs/concepts/resource-project) for more
information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Rename')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rename.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}:rename',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.tagTemplates.fields.rename',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:rename',
        request_field=u'googleCloudDatacatalogV1beta1RenameTagTemplateFieldRequest',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplateField',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates resource."""

    _NAME = u'projects_locations_tagTemplates'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsTagTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag template. The user should enable the Data Catalog API in.
the project identified by the `parent` parameter (see [Data Catalog
Resource Project](/data-catalog/docs/concepts/resource-project) for more
information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.tagTemplates.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'tagTemplateId'],
        relative_path=u'v1beta1/{+parent}/tagTemplates',
        request_field=u'googleCloudDatacatalogV1beta1TagTemplate',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag template and all tags using the template.
Users should enable the Data Catalog API in the project identified by
the `name` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.tagTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'force'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a tag template.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.tagTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesGetRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error.
is returned if the resource does not exist. An empty policy is returned
if the resource exists but does not have a policy set on it.

Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

Callers must have following Google IAM permission
  - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
    templates.
  - `datacatalog.entries.getIamPolicy` to get policies on entries.
  - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.tagTemplates.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a tag template. This method cannot be used to update the fields of.
a template. The tag template fields are represented as separate resources
and should be updated using their own create/update/delete methods.
Users should enable the Data Catalog API in the project identified by
the `tag_template.name` parameter (see [Data Catalog Resource Project]
(/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.tagTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1TagTemplate',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplate',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy for a resource. Replaces any existing.
policy.
Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

Callers must have following Google IAM permission
  - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
    templates.
  - `datacatalog.entries.setIamPolicy` to set policies on entries.
  - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.tagTemplates.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the caller's permissions on a resource.
If the resource does not exist, an empty set of permissions is returned
(We don't return a `NOT_FOUND` error).

Supported resources are:
  - Tag templates.
  - Entries.
  - Entry groups.
Note, this method cannot be used to manage policies for BigQuery, Cloud
Pub/Sub and any external Google Cloud Platform resources synced to Cloud
Data Catalog.

A caller is not required to have Google IAM permission to make this
request.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.tagTemplates.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTaxonomiesPolicyTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_taxonomies_policyTags resource."""

    _NAME = u'projects_locations_taxonomies_policyTags'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsTaxonomiesPolicyTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy tag in the specified taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1PolicyTag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/policyTags',
        request_field=u'googleCloudDatacatalogV1beta1PolicyTag',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1PolicyTag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy tag. Also deletes all of its descendant policy tags.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1PolicyTag) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1PolicyTag',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for a taxonomy or a policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all policy tags in a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ListPolicyTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/policyTags',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsListRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ListPolicyTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1PolicyTag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1PolicyTag',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1PolicyTag',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for a taxonomy or a policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified taxonomy or.
policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}/policyTags/{policyTagsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.policyTags.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPolicyTagsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTaxonomiesService(base_api.BaseApiService):
    """Service class for the projects_locations_taxonomies resource."""

    _NAME = u'projects_locations_taxonomies'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a taxonomy in the specified project.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/taxonomies',
        request_field=u'googleCloudDatacatalogV1beta1Taxonomy',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Taxonomy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a taxonomy. This operation will also delete all.
policy tags in this taxonomy along with their associated policies.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.locations.taxonomies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports all taxonomies and their policy tags in a project.

This method generates SerializedTaxonomy protos with nested policy tags
that can be used as an input for future ImportTaxonomies calls.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ExportTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies:export',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.taxonomies.export',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'serializedTaxonomies', u'taxonomies'],
        relative_path=u'v1beta1/{+parent}/taxonomies:export',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesExportRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ExportTaxonomiesResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.taxonomies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesGetRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Taxonomy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for a taxonomy or a policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Imports all taxonomies and their policy tags to a project as new.
taxonomies.

This method provides a bulk taxonomy / policy tag creation using nested
proto structure.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ImportTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies:import',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.import',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/taxonomies:import',
        request_field=u'googleCloudDatacatalogV1beta1ImportTaxonomiesRequest',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesImportRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ImportTaxonomiesResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all taxonomies in a project in a particular location that the caller.
has permission to view.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ListTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies',
        http_method=u'GET',
        method_id=u'datacatalog.projects.locations.taxonomies.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/taxonomies',
        request_field='',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesListRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ListTaxonomiesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a taxonomy.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.locations.taxonomies.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1Taxonomy',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Taxonomy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for a taxonomy or a policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified taxonomy or.
policy tag.

      Args:
        request: (DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/taxonomies/{taxonomiesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'datacatalog.projects.locations.taxonomies.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'DatacatalogProjectsLocationsTaxonomiesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
