"""Generated message classes for ml version v1.

An API to enable creating and using machine learning models.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'ml'


class GoogleApiHttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page.   This message can be used both in streaming and non-streaming
  API methods in the request as well as the response.  It can be used as a
  top-level request field, which is convenient if one wants to extract
  parameters from either the URL or HTTP template into the request fields and
  also want access to the raw HTTP body.  Example:      message
  GetResourceRequest {       // A unique request id.       string request_id =
  1;        // The raw HTTP body is bound to this field.
  google.api.HttpBody http_body = 2;     }      service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);       rpc
  UpdateResource(google.api.HttpBody) returns       (google.protobuf.Empty);
  }  Example with streaming methods:      service CaldavService {       rpc
  GetCalendar(stream google.api.HttpBody)         returns (stream
  google.api.HttpBody);       rpc UpdateCalendar(stream google.api.HttpBody)
  returns (stream google.api.HttpBody);     }  Use of this type only changes
  how the request and response bodies are handled, all other features will
  continue to work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class GoogleCloudMlV1AblationAttribution(_messages.Message):
  r"""Attributes credit to model inputs by ablating features (ie. setting them
  to their default/missing values) and computing corresponding model score
  delta per feature. The term "ablation" is in reference to running an
  "ablation study" to analyze input effects on the outcome of interest, which
  in this case is the model's output. This attribution method is supported for
  TensorFlow and XGBoost models.

  Fields:
    numFeatureInteractions: Number of feature interactions to account for in
      the ablation process, capped at the maximum number of provided input
      features. Currently, only the value 1 is supported.
  """

  numFeatureInteractions = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1AcceleratorConfig(_messages.Message):
  r"""Represents a hardware accelerator request config. Note that the
  AcceleratorConfig can be used in both Jobs and Versions. Learn more about
  [accelerators for training](/ml-engine/docs/using-gpus) and [accelerators
  for online prediction](/ml-engine/docs/machine-types-online-
  prediction#gpus).

  Enums:
    TypeValueValuesEnum: The type of accelerator to use.

  Fields:
    count: The number of accelerators to attach to each machine running the
      job.
    type: The type of accelerator to use.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of accelerator to use.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type. Default to
        no GPU.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
      TPU_V2_POD: TPU v2 POD.
      TPU_V3_POD: TPU v3 POD.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7
    TPU_V2_POD = 8
    TPU_V3_POD = 9

  count = _messages.IntegerField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudMlV1AutoScaling(_messages.Message):
  r"""Options for automatically scaling a model.

  Fields:
    minNodes: Optional. The minimum number of nodes to allocate for this
      model. These nodes are always up, starting from the time the model is
      deployed. Therefore, the cost of operating this model will be at least
      `rate` * `min_nodes` * number of hours since last billing cycle, where
      `rate` is the cost per node-hour as documented in the [pricing guide
      ](/ml-engine/docs/pricing), even if no predictions are performed. There
      is additional cost for each prediction performed.  Unlike manual
      scaling, if the load gets too heavy for the nodes that are up, the
      service will automatically add nodes to handle the increased load as
      well as scale back as traffic drops, always maintaining at least
      `min_nodes`. You will be charged for the time in which additional nodes
      are used.  If `min_nodes` is not specified and AutoScaling is used with
      a [legacy (MLS1) machine type](/ml-engine/docs/machine-types-online-
      prediction), `min_nodes` defaults to 0, in which case, when traffic to a
      model stops (and after a cool-down period), nodes will be shut down and
      no charges will be incurred until traffic to the model resumes.  If
      `min_nodes` is not specified and AutoScaling is used with a [Compute
      Engine (N1) machine type](/ml-engine/docs/machine-types-online-
      prediction), `min_nodes` defaults to 1. `min_nodes` must be at least 1
      for use with a Compute Engine machine type.  Note that you cannot use
      AutoScaling if your version uses
      [GPUs](#Version.FIELDS.accelerator_config). Instead, you must use
      ManualScaling.  You can set `min_nodes` when creating the model version,
      and you can also update `min_nodes` for an existing version: <pre>
      update_body.json: {   'autoScaling': {     'minNodes': 5   } } </pre>
      HTTP request: <pre style="max-width: 626px;"> PATCH https://ml.googleapi
      s.com/v1/{name=projects/*/models/*/versions/*}?update_mask=autoScaling.m
      inNodes -d @./update_body.json </pre>
  """

  minNodes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1BuiltInAlgorithmOutput(_messages.Message):
  r"""Represents output related to a built-in algorithm Job.

  Fields:
    framework: Framework on which the built-in algorithm was trained.
    modelPath: The Cloud Storage path to the `model/` directory where the
      training job saves the trained model. Only set for successful jobs that
      don't use hyperparameter tuning.
    pythonVersion: Python version on which the built-in algorithm was trained.
    runtimeVersion: AI Platform runtime version on which the built-in
      algorithm was trained.
  """

  framework = _messages.StringField(1)
  modelPath = _messages.StringField(2)
  pythonVersion = _messages.StringField(3)
  runtimeVersion = _messages.StringField(4)


class GoogleCloudMlV1CancelJobRequest(_messages.Message):
  r"""Request message for the CancelJob method."""


class GoogleCloudMlV1Capability(_messages.Message):
  r"""A GoogleCloudMlV1Capability object.

  Enums:
    AvailableAcceleratorsValueListEntryValuesEnum:
    TypeValueValuesEnum:

  Fields:
    availableAccelerators: Available accelerators for the capability.
    type: A TypeValueValuesEnum attribute.
  """

  class AvailableAcceleratorsValueListEntryValuesEnum(_messages.Enum):
    r"""AvailableAcceleratorsValueListEntryValuesEnum enum type.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: <no description>
      NVIDIA_TESLA_K80: <no description>
      NVIDIA_TESLA_P100: <no description>
      NVIDIA_TESLA_V100: <no description>
      NVIDIA_TESLA_P4: <no description>
      NVIDIA_TESLA_T4: <no description>
      TPU_V2: <no description>
      TPU_V3: <no description>
      TPU_V2_POD: <no description>
      TPU_V3_POD: <no description>
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7
    TPU_V2_POD = 8
    TPU_V3_POD = 9

  class TypeValueValuesEnum(_messages.Enum):
    r"""TypeValueValuesEnum enum type.

    Values:
      TYPE_UNSPECIFIED: <no description>
      TRAINING: <no description>
      BATCH_PREDICTION: <no description>
      ONLINE_PREDICTION: <no description>
    """
    TYPE_UNSPECIFIED = 0
    TRAINING = 1
    BATCH_PREDICTION = 2
    ONLINE_PREDICTION = 3

  availableAccelerators = _messages.EnumField('AvailableAcceleratorsValueListEntryValuesEnum', 1, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudMlV1Config(_messages.Message):
  r"""A GoogleCloudMlV1Config object.

  Fields:
    tpuServiceAccount: The service account Cloud ML uses to run on TPU node.
  """

  tpuServiceAccount = _messages.StringField(1)


class GoogleCloudMlV1ContainerPort(_messages.Message):
  r"""ContainerPort represents a network port in a single container.

  Fields:
    containerPort: Number of port to expose on the pod's IP address. This must
      be a valid port number, 0 < x < 65536.
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1ContainerSpec(_messages.Message):
  r"""Specify a custom container to deploy. Our ContainerSpec is a subset of
  the Kubernetes Container specification.
  https://kubernetes.io/docs/reference/generated/kubernetes-
  api/v1.10/#container-v1-core

  Fields:
    args: Arguments to the entrypoint. The docker image's CMD is used if this
      is not provided. Variable references $(VAR_NAME) are expanded using the
      container's environment. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-
      data-application/define-command-argument-container/#running-a-command-
      in-a-shell
    command: Entrypoint array. Not executed within a shell. The docker image's
      ENTRYPOINT is used if this is not provided. Variable references
      $(VAR_NAME) are expanded using the container's environment. If a
      variable cannot be resolved, the reference in the input string will be
      unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie:
      $$(VAR_NAME). Escaped references will never be expanded, regardless of
      whether the variable exists or not. Cannot be updated. More info:
      https://kubernetes.io/docs/tasks/inject-data-application/define-command-
      argument-container/#running-a-command-in-a-shell
    env: List of environment variables to set in the container. Cannot be
      updated.
    image: Docker image name. More info:
      https://kubernetes.io/docs/concepts/containers/images
    ports: List of ports to expose from the container. Exposing a port here
      gives the system additional information about the network connections a
      container uses, but is primarily informational. Not specifying a port
      here DOES NOT prevent that port from being exposed. Any port which is
      listening on the default "0.0.0.0" address inside a container will be
      accessible from the network. Cannot be updated.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('GoogleCloudMlV1EnvVar', 3, repeated=True)
  image = _messages.StringField(4)
  ports = _messages.MessageField('GoogleCloudMlV1ContainerPort', 5, repeated=True)


class GoogleCloudMlV1EnvVar(_messages.Message):
  r"""EnvVar represents an environment variable present in a Container.

  Fields:
    name: Name of the environment variable. Must be a C_IDENTIFIER.
    value: Variable references $(VAR_NAME) are expanded using the previous
      defined environment variables in the container and any service
      environment variables. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      Defaults to "".
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleCloudMlV1ExplainRequest(_messages.Message):
  r"""Request for explanations to be issued against a trained model.

  Fields:
    httpBody: Required. The explanation request body.
  """

  httpBody = _messages.MessageField('GoogleApiHttpBody', 1)


class GoogleCloudMlV1ExplanationConfig(_messages.Message):
  r"""Message holding configuration options for explaining model predictions.
  There are two feature attribution methods supported for TensorFlow models:
  integrated gradients and sampled Shapley. <a href="/ml-engine/docs/ai-
  explanations/overview">Learn more about feature attributions</a>.

  Fields:
    ablationAttribution: TensorFlow framework explanation methods.
    integratedGradientsAttribution: A
      GoogleCloudMlV1IntegratedGradientsAttribution attribute.
    saabasAttribution: A GoogleCloudMlV1SaabasAttribution attribute.
    sampledShapleyAttribution: A GoogleCloudMlV1SampledShapleyAttribution
      attribute.
    treeShapAttribution: XGBoost framework explanation methods.
    xraiAttribution: A GoogleCloudMlV1XraiAttribution attribute.
  """

  ablationAttribution = _messages.MessageField('GoogleCloudMlV1AblationAttribution', 1)
  integratedGradientsAttribution = _messages.MessageField('GoogleCloudMlV1IntegratedGradientsAttribution', 2)
  saabasAttribution = _messages.MessageField('GoogleCloudMlV1SaabasAttribution', 3)
  sampledShapleyAttribution = _messages.MessageField('GoogleCloudMlV1SampledShapleyAttribution', 4)
  treeShapAttribution = _messages.MessageField('GoogleCloudMlV1TreeShapAttribution', 5)
  xraiAttribution = _messages.MessageField('GoogleCloudMlV1XraiAttribution', 6)


class GoogleCloudMlV1ExplanationInput(_messages.Message):
  r"""Represents input parameters for a model explanation job.

  Enums:
    DataFormatValueValuesEnum: Required. The format of the input data.
    FrameworkValueValuesEnum: Optional. The framework used to train this
      model. Only needed if model_version is a GCS path. Otherwise the
      framework specified during version creation will be used.
    OutputDataFormatValueValuesEnum: Optional. The format of the output data,
      defaults to BIGQUERY.

  Fields:
    accelerator: Optional. The type and number of accelerators to be attached
      to each machine running the job.
    batchSize: Optional. Number of records per batch, defaults to 64. The
      service will buffer batch_size number of records in memory before
      invoking one Tensorflow prediction call internally. So take the record
      size and memory available into consideration when setting this
      parameter.
    dataFormat: Required. The format of the input data.
    explanationConfig: Required only if model_version is specified through a
      uri, otherwise the same explanation config specified at model version
      creation will be used. Configures explainability features on the model's
      version. Some explanation features require additional metadata to be
      loaded as part of the model payload.
    framework: Optional. The framework used to train this model. Only needed
      if model_version is a GCS path. Otherwise the framework specified during
      version creation will be used.
    initialWorkerCount: Optional. The initial number of workers to be used for
      parallel processing. Defaults to 0 if one wants the service to figure
      out the number. The actual number of workers being used may change after
      the job starts depending on the autoscaling policy.
    inputPaths: Required when data_format is JSON. The Cloud Storage location
      of the input data. May contain <a
      href="/storage/docs/gsutil/addlhelp/WildcardNames">wildcards</a>.
    maxWorkerCount: Optional. The maximum number of workers to be used for
      parallel processing. Defaults to 10 if not specified.
    modelName: Use this field if you want to use the default version for the
      specified model. The string must use the following format:
      `"projects/YOUR_PROJECT/models/YOUR_MODEL"`
    outputBigqueryTable: Required when output_data_format is BIGQUERY. The
      output fully qualified BigQuery table name in the format of
      "[project_id].[dataset_name].[table_name]".
    outputDataFormat: Optional. The format of the output data, defaults to
      BIGQUERY.
    region: Required. The Compute Engine region to run the explanation job in.
      See the <a href="/ml-engine/docs/tensorflow/regions">available
      regions</a> for AI Platform services.
    runtimeVersion: Required. The AI Platform runtime version to use for the
      explanation job. See <a href="https://cloud.google.com/ml-
      engine/docs/tensorflow/runtime-version-list</a> for available runtime
      versions. Must be >=1.12.
    signatureName: Optional. The name of the signature defined in the
      SavedModel to use for this job. Please refer to
      [SavedModel](https://tensorflow.github.io/serving/serving_basic.html)
      for information about how to use signatures.  Defaults to [DEFAULT_SERVI
      NG_SIGNATURE_DEF_KEY](https://www.tensorflow.org/api_docs/python/tf/save
      d_model/signature_constants) , which is "serving_default".
    tagsOverride: Optional. The set of tags to select which meta graph defined
      in the SavedModel to use for this job. Please refer to
      [SavedModel](https://www.tensorflow.org/serving/serving_basic) for
      information about how to use tags.  Overrides the default tags when
      predicting from a deployed model version.  When predicting from a model
      directory, the tag defaults to [SERVING](https://www.tensorflow.org/api_
      docs/python/tf/saved_model/tag_constants) , which is "serve".
    uri: Use this field if you want to specify a Google Cloud Storage path for
      the model to use, e.g. gs://{BUCKET}/{MODEL_DIR}/{MODEL_NAME}.
    versionName: Use this field if you want to specify a version of the model
      to use. The string is formatted the same way as `model_version`, with
      the addition of the version information:
      `"projects/YOUR_PROJECT/models/YOUR_MODEL/versions/YOUR_VERSION"`
    workerType: Optional. The type of virtual machine to use for the
      explanation job's worker nodes. It supports all machine types available
      on GCP ( https://cloud.google.com/compute/docs/machine-types), subject
      to the availability in the specific region the job runs.
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""Required. The format of the input data.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format.
      JSON: Each line of the file is a JSON dictionary representing one
        record. Currently available only for input data.
      BIGQUERY: Values are rows in a BigQuery table given its associated
        schema. Currently available only for output data.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSON = 1
    BIGQUERY = 2

  class FrameworkValueValuesEnum(_messages.Enum):
    r"""Optional. The framework used to train this model. Only needed if
    model_version is a GCS path. Otherwise the framework specified during
    version creation will be used.

    Values:
      FRAMEWORK_UNSPECIFIED: Unspecified framework. Assigns a value based on
        the file suffix.
      TENSORFLOW: Tensorflow framework.
      SCIKIT_LEARN: Scikit-learn framework.
      XGBOOST: XGBoost framework.
    """
    FRAMEWORK_UNSPECIFIED = 0
    TENSORFLOW = 1
    SCIKIT_LEARN = 2
    XGBOOST = 3

  class OutputDataFormatValueValuesEnum(_messages.Enum):
    r"""Optional. The format of the output data, defaults to BIGQUERY.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format.
      JSON: Each line of the file is a JSON dictionary representing one
        record. Currently available only for input data.
      BIGQUERY: Values are rows in a BigQuery table given its associated
        schema. Currently available only for output data.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSON = 1
    BIGQUERY = 2

  accelerator = _messages.MessageField('GoogleCloudMlV1AcceleratorConfig', 1)
  batchSize = _messages.IntegerField(2)
  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 3)
  explanationConfig = _messages.MessageField('GoogleCloudMlV1ExplanationConfig', 4)
  framework = _messages.EnumField('FrameworkValueValuesEnum', 5)
  initialWorkerCount = _messages.IntegerField(6)
  inputPaths = _messages.StringField(7, repeated=True)
  maxWorkerCount = _messages.IntegerField(8)
  modelName = _messages.StringField(9)
  outputBigqueryTable = _messages.StringField(10)
  outputDataFormat = _messages.EnumField('OutputDataFormatValueValuesEnum', 11)
  region = _messages.StringField(12)
  runtimeVersion = _messages.StringField(13)
  signatureName = _messages.StringField(14)
  tagsOverride = _messages.StringField(15, repeated=True)
  uri = _messages.StringField(16)
  versionName = _messages.StringField(17)
  workerType = _messages.StringField(18)


class GoogleCloudMlV1ExplanationOutput(_messages.Message):
  r"""Represents results of an explanation job.

  Fields:
    errorCount: The number of data instances which resulted in errors.
    explanationCount: The number of generated explanations.
    nodeHours: Node hours used by the batch explanation job.
    outputBigqueryTable: The output BigQuery table name provided at the job
      creation time.
  """

  errorCount = _messages.IntegerField(1)
  explanationCount = _messages.IntegerField(2)
  nodeHours = _messages.FloatField(3)
  outputBigqueryTable = _messages.StringField(4)


class GoogleCloudMlV1GetConfigResponse(_messages.Message):
  r"""Returns service account information associated with a project.

  Fields:
    config: A GoogleCloudMlV1Config attribute.
    serviceAccount: The service account Cloud ML uses to access resources in
      the project.
    serviceAccountProject: The project number for `service_account`.
  """

  config = _messages.MessageField('GoogleCloudMlV1Config', 1)
  serviceAccount = _messages.StringField(2)
  serviceAccountProject = _messages.IntegerField(3)


class GoogleCloudMlV1HyperparameterOutput(_messages.Message):
  r"""Represents the result of a single hyperparameter tuning trial from a
  training job. The TrainingOutput object that is returned on successful
  completion of a training job with hyperparameter tuning includes a list of
  HyperparameterOutput objects, one for each successful trial.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the trial.

  Messages:
    HyperparametersValue: The hyperparameters given to this trial.

  Fields:
    allMetrics: All recorded object metrics for this trial. This field is not
      currently populated.
    builtInAlgorithmOutput: Details related to built-in algorithms jobs. Only
      set for trials of built-in algorithms jobs that have succeeded.
    endTime: Output only. End time for the trial.
    finalMetric: The final objective metric seen for this trial.
    hyperparameters: The hyperparameters given to this trial.
    isTrialStoppedEarly: True if the trial is stopped early.
    startTime: Output only. Start time for the trial.
    state: Output only. The detailed state of the trial.
    trialId: The trial id for these results.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the trial.

    Values:
      STATE_UNSPECIFIED: The job state is unspecified.
      QUEUED: The job has been just created and processing has not yet begun.
      PREPARING: The service is preparing to run the job.
      RUNNING: The job is in progress.
      SUCCEEDED: The job completed successfully.
      FAILED: The job failed. `error_message` should contain the details of
        the failure.
      CANCELLING: The job is being cancelled. `error_message` should describe
        the reason for the cancellation.
      CANCELLED: The job has been cancelled. `error_message` should describe
        the reason for the cancellation.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    PREPARING = 2
    RUNNING = 3
    SUCCEEDED = 4
    FAILED = 5
    CANCELLING = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HyperparametersValue(_messages.Message):
    r"""The hyperparameters given to this trial.

    Messages:
      AdditionalProperty: An additional property for a HyperparametersValue
        object.

    Fields:
      additionalProperties: Additional properties of type HyperparametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HyperparametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allMetrics = _messages.MessageField('GoogleCloudMlV1HyperparameterOutputHyperparameterMetric', 1, repeated=True)
  builtInAlgorithmOutput = _messages.MessageField('GoogleCloudMlV1BuiltInAlgorithmOutput', 2)
  endTime = _messages.StringField(3)
  finalMetric = _messages.MessageField('GoogleCloudMlV1HyperparameterOutputHyperparameterMetric', 4)
  hyperparameters = _messages.MessageField('HyperparametersValue', 5)
  isTrialStoppedEarly = _messages.BooleanField(6)
  startTime = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  trialId = _messages.StringField(9)


class GoogleCloudMlV1HyperparameterOutputHyperparameterMetric(_messages.Message):
  r"""An observed value of a metric.

  Fields:
    objectiveValue: The objective value at this training step.
    trainingStep: The global training step for this metric.
  """

  objectiveValue = _messages.FloatField(1)
  trainingStep = _messages.IntegerField(2)


class GoogleCloudMlV1HyperparameterSpec(_messages.Message):
  r"""Represents a set of hyperparameters to optimize.

  Enums:
    AlgorithmValueValuesEnum: Optional. The search algorithm specified for the
      hyperparameter tuning job. Uses the default AI Platform hyperparameter
      tuning algorithm if unspecified.
    GoalValueValuesEnum: Required. The type of goal to use for tuning.
      Available types are `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.

  Fields:
    algorithm: Optional. The search algorithm specified for the hyperparameter
      tuning job. Uses the default AI Platform hyperparameter tuning algorithm
      if unspecified.
    enableTrialEarlyStopping: Optional. Indicates if the hyperparameter tuning
      job enables auto trial early stopping.
    goal: Required. The type of goal to use for tuning. Available types are
      `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.
    hyperparameterMetricTag: Optional. The TensorFlow summary tag name to use
      for optimizing trials. For current versions of TensorFlow, this tag name
      should exactly match what is shown in TensorBoard, including all scopes.
      For versions of TensorFlow prior to 0.12, this should be only the tag
      passed to tf.Summary. By default, "training/hptuning/metric" will be
      used.
    maxFailedTrials: Optional. The number of failed trials that need to be
      seen before failing the hyperparameter tuning job. You can specify this
      field to override the default failing criteria for AI Platform
      hyperparameter tuning jobs.  Defaults to zero, which means the service
      decides when a hyperparameter job should fail.
    maxParallelTrials: Optional. The number of training trials to run
      concurrently. You can reduce the time it takes to perform hyperparameter
      tuning by adding trials in parallel. However, each trail only benefits
      from the information gained in completed trials. That means that a trial
      does not get access to the results of trials running at the same time,
      which could reduce the quality of the overall optimization.  Each trial
      will use the same scale tier and machine types.  Defaults to one.
    maxTrials: Optional. How many training trials should be attempted to
      optimize the specified hyperparameters.  Defaults to one.
    params: Required. The set of parameters to tune.
    resumePreviousJobId: Optional. The prior hyperparameter tuning job id that
      users hope to continue with. The job id will be used to find the
      corresponding vizier study guid and resume the study.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""Optional. The search algorithm specified for the hyperparameter tuning
    job. Uses the default AI Platform hyperparameter tuning algorithm if
    unspecified.

    Values:
      ALGORITHM_UNSPECIFIED: The default algorithm used by the hyperparameter
        tuning service. This is a Bayesian optimization algorithm.
      GRID_SEARCH: Simple grid search within the feasible space. To use grid
        search, all parameters must be `INTEGER`, `CATEGORICAL`, or
        `DISCRETE`.
      RANDOM_SEARCH: Simple random search within the feasible space.
      POPULATION_BASED_TRAINING: Population Based Training Algorithm.
    """
    ALGORITHM_UNSPECIFIED = 0
    GRID_SEARCH = 1
    RANDOM_SEARCH = 2
    POPULATION_BASED_TRAINING = 3

  class GoalValueValuesEnum(_messages.Enum):
    r"""Required. The type of goal to use for tuning. Available types are
    `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.

    Values:
      GOAL_TYPE_UNSPECIFIED: Goal Type will default to maximize.
      MAXIMIZE: Maximize the goal metric.
      MINIMIZE: Minimize the goal metric.
    """
    GOAL_TYPE_UNSPECIFIED = 0
    MAXIMIZE = 1
    MINIMIZE = 2

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  enableTrialEarlyStopping = _messages.BooleanField(2)
  goal = _messages.EnumField('GoalValueValuesEnum', 3)
  hyperparameterMetricTag = _messages.StringField(4)
  maxFailedTrials = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxParallelTrials = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  maxTrials = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  params = _messages.MessageField('GoogleCloudMlV1ParameterSpec', 8, repeated=True)
  resumePreviousJobId = _messages.StringField(9)


class GoogleCloudMlV1IntegratedGradientsAttribution(_messages.Message):
  r"""Attributes credit by computing the Aumann-Shapley value taking advantage
  of the model's fully differentiable structure. Refer to this paper for more
  details: http://proceedings.mlr.press/v70/sundararajan17a.html

  Fields:
    numIntegralSteps: Number of steps for approximating the path integral. A
      good value to start is 50 and gradually increase until the sum to diff
      property is met within the desired error range.
  """

  numIntegralSteps = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1Job(_messages.Message):
  r"""Represents a training or prediction job.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of a job.

  Messages:
    LabelsValue: Optional. One or more labels that you can add, to organize
      your jobs. Each label is a key-value pair, where both the key and the
      value are arbitrary strings that you supply. For more information, see
      the documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.

  Fields:
    createTime: Output only. When the job was created.
    endTime: Output only. When the job processing was completed.
    errorMessage: Output only. The details of a failure or a cancellation.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a job from overwriting each other. It is
      strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform job updates in order to avoid race
      conditions: An `etag` is returned in the response to `GetJob`, and
      systems are expected to put that etag in the request to `UpdateJob` to
      ensure that their change will be applied to the same version of the job.
    explanationInput: Input parameters to create an explanation job.
    explanationOutput: The current explanation job result.
    jobId: Required. The user-specified id of the job.
    labels: Optional. One or more labels that you can add, to organize your
      jobs. Each label is a key-value pair, where both the key and the value
      are arbitrary strings that you supply. For more information, see the
      documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.
    predictionInput: Input parameters to create a prediction job.
    predictionOutput: The current prediction job result.
    startTime: Output only. When the job processing was started.
    state: Output only. The detailed state of a job.
    trainingInput: Input parameters to create a training job.
    trainingOutput: The current training job result.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of a job.

    Values:
      STATE_UNSPECIFIED: The job state is unspecified.
      QUEUED: The job has been just created and processing has not yet begun.
      PREPARING: The service is preparing to run the job.
      RUNNING: The job is in progress.
      SUCCEEDED: The job completed successfully.
      FAILED: The job failed. `error_message` should contain the details of
        the failure.
      CANCELLING: The job is being cancelled. `error_message` should describe
        the reason for the cancellation.
      CANCELLED: The job has been cancelled. `error_message` should describe
        the reason for the cancellation.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    PREPARING = 2
    RUNNING = 3
    SUCCEEDED = 4
    FAILED = 5
    CANCELLING = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. One or more labels that you can add, to organize your jobs.
    Each label is a key-value pair, where both the key and the value are
    arbitrary strings that you supply. For more information, see the
    documentation on <a href="/ml-engine/docs/tensorflow/resource-
    labels">using labels</a>.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  errorMessage = _messages.StringField(3)
  etag = _messages.BytesField(4)
  explanationInput = _messages.MessageField('GoogleCloudMlV1ExplanationInput', 5)
  explanationOutput = _messages.MessageField('GoogleCloudMlV1ExplanationOutput', 6)
  jobId = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  predictionInput = _messages.MessageField('GoogleCloudMlV1PredictionInput', 9)
  predictionOutput = _messages.MessageField('GoogleCloudMlV1PredictionOutput', 10)
  startTime = _messages.StringField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  trainingInput = _messages.MessageField('GoogleCloudMlV1TrainingInput', 13)
  trainingOutput = _messages.MessageField('GoogleCloudMlV1TrainingOutput', 14)


class GoogleCloudMlV1ListJobsResponse(_messages.Message):
  r"""Response message for the ListJobs method.

  Fields:
    jobs: The list of jobs.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  jobs = _messages.MessageField('GoogleCloudMlV1Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1ListLocationsResponse(_messages.Message):
  r"""A GoogleCloudMlV1ListLocationsResponse object.

  Fields:
    locations: Locations where at least one type of CMLE capability is
      available.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  locations = _messages.MessageField('GoogleCloudMlV1Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1ListModelsResponse(_messages.Message):
  r"""Response message for the ListModels method.

  Fields:
    models: The list of models.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  models = _messages.MessageField('GoogleCloudMlV1Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1ListVersionsResponse(_messages.Message):
  r"""Response message for the ListVersions method.

  Fields:
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
    versions: The list of versions.
  """

  nextPageToken = _messages.StringField(1)
  versions = _messages.MessageField('GoogleCloudMlV1Version', 2, repeated=True)


class GoogleCloudMlV1Location(_messages.Message):
  r"""A GoogleCloudMlV1Location object.

  Fields:
    capabilities: Capabilities available in the location.
    name: A string attribute.
  """

  capabilities = _messages.MessageField('GoogleCloudMlV1Capability', 1, repeated=True)
  name = _messages.StringField(2)


class GoogleCloudMlV1ManualScaling(_messages.Message):
  r"""Options for manually scaling a model.

  Fields:
    nodes: The number of nodes to allocate for this model. These nodes are
      always up, starting from the time the model is deployed, so the cost of
      operating this model will be proportional to `nodes` * number of hours
      since last billing cycle plus the cost for each prediction performed.
  """

  nodes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1Model(_messages.Message):
  r"""Represents a machine learning solution.  A model can have multiple
  versions, each of which is a deployed, trained model ready to receive
  prediction requests. The model itself is just a container.

  Messages:
    LabelsValue: Optional. One or more labels that you can add, to organize
      your models. Each label is a key-value pair, where both the key and the
      value are arbitrary strings that you supply. For more information, see
      the documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.

  Fields:
    defaultVersion: Output only. The default version of the model. This
      version will be used to handle prediction requests that do not specify a
      version.  You can change the default version by calling
      projects.models.versions.setDefault.
    description: Optional. The description specified for the model when it was
      created.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a model from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform model updates in order to avoid race
      conditions: An `etag` is returned in the response to `GetModel`, and
      systems are expected to put that etag in the request to `UpdateModel` to
      ensure that their change will be applied to the model as intended.
    labels: Optional. One or more labels that you can add, to organize your
      models. Each label is a key-value pair, where both the key and the value
      are arbitrary strings that you supply. For more information, see the
      documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.
    name: Required. The name specified for the model when it was created.  The
      model name must be unique within the project it is created in.
    onlinePredictionConsoleLogging: Optional. If true, online prediction nodes
      send `stderr` and `stdout` streams to Stackdriver Logging. These can be
      more verbose than the standard access logs (see
      `onlinePredictionLogging`) and can incur higher cost. However, they are
      helpful for debugging. Note that [Stackdriver logs may incur a
      cost](/stackdriver/pricing), especially if your project receives
      prediction requests at a high QPS. Estimate your costs before enabling
      this option.  Default is false.
    onlinePredictionLogging: Optional. If true, online prediction access logs
      are sent to StackDriver Logging. These logs are like standard server
      access logs, containing information like timestamp and latency for each
      request. Note that [Stackdriver logs may incur a
      cost](/stackdriver/pricing), especially if your project receives
      prediction requests at a high queries per second rate (QPS). Estimate
      your costs before enabling this option.  Default is false.
    regions: Optional. The list of regions where the model is going to be
      deployed. Currently only one region per model is supported. Defaults to
      'us-central1' if nothing is set. See the <a href="/ml-
      engine/docs/tensorflow/regions">available regions</a> for AI Platform
      services. Note: *   No matter where a model is deployed, it can always
      be accessed by     users from anywhere, both for online and batch
      prediction. *   The region for a batch prediction job is set by the
      region field when     submitting the batch prediction job and does not
      take its value from     this field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. One or more labels that you can add, to organize your
    models. Each label is a key-value pair, where both the key and the value
    are arbitrary strings that you supply. For more information, see the
    documentation on <a href="/ml-engine/docs/tensorflow/resource-
    labels">using labels</a>.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  defaultVersion = _messages.MessageField('GoogleCloudMlV1Version', 1)
  description = _messages.StringField(2)
  etag = _messages.BytesField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  onlinePredictionConsoleLogging = _messages.BooleanField(6)
  onlinePredictionLogging = _messages.BooleanField(7)
  regions = _messages.StringField(8, repeated=True)


class GoogleCloudMlV1NasJobOutput(_messages.Message):
  r"""The output of Neural Archhitecture Search (NAS) jobs.

  Fields:
    multiTrialJobOutputs: The output of a multi-trial Neural Architecture
      Search (NAS) job.
  """

  multiTrialJobOutputs = _messages.MessageField('GoogleCloudMlV1NasJobOutputMultiTrialJobOutputs', 1)


class GoogleCloudMlV1NasJobOutputMultiTrialJobOutput(_messages.Message):
  r"""The output of Multi-trial Neural Architecture Search (NAS) jobs.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the trial.

  Fields:
    allMetrics: All objective metrics for this Neural Architecture Search
      (NAS) job.
    endTime: Output only. End time for the trial.
    finalMetric: The final objective metric seen for this Neural Architecture
      Search (NAS) job.
    nasParamsStr: The parameters that are associated with this Neural
      Architecture Search (NAS) job.
    startTime: Output only. Start time for the trial.
    state: Output only. The detailed state of the trial.
    trialId: The trial id for these results.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the trial.

    Values:
      STATE_UNSPECIFIED: The job state is unspecified.
      QUEUED: The job has been just created and processing has not yet begun.
      PREPARING: The service is preparing to run the job.
      RUNNING: The job is in progress.
      SUCCEEDED: The job completed successfully.
      FAILED: The job failed. `error_message` should contain the details of
        the failure.
      CANCELLING: The job is being cancelled. `error_message` should describe
        the reason for the cancellation.
      CANCELLED: The job has been cancelled. `error_message` should describe
        the reason for the cancellation.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    PREPARING = 2
    RUNNING = 3
    SUCCEEDED = 4
    FAILED = 5
    CANCELLING = 6
    CANCELLED = 7

  allMetrics = _messages.MessageField('GoogleCloudMlV1NasJobOutputMultiTrialJobOutputNasParameterMetric', 1, repeated=True)
  endTime = _messages.StringField(2)
  finalMetric = _messages.MessageField('GoogleCloudMlV1NasJobOutputMultiTrialJobOutputNasParameterMetric', 3)
  nasParamsStr = _messages.StringField(4)
  startTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  trialId = _messages.StringField(7)


class GoogleCloudMlV1NasJobOutputMultiTrialJobOutputNasParameterMetric(_messages.Message):
  r"""An observed value of a metric of the trial.

  Fields:
    objectiveValue: The objective value at this training step.
    trainingStep: The global training step for this metric.
  """

  objectiveValue = _messages.FloatField(1)
  trainingStep = _messages.IntegerField(2)


class GoogleCloudMlV1NasJobOutputMultiTrialJobOutputs(_messages.Message):
  r"""The list of all MultiTrialJobOutput.

  Fields:
    multiTrialJobOutput: A GoogleCloudMlV1NasJobOutputMultiTrialJobOutput
      attribute.
  """

  multiTrialJobOutput = _messages.MessageField('GoogleCloudMlV1NasJobOutputMultiTrialJobOutput', 1, repeated=True)


class GoogleCloudMlV1NasSpec(_messages.Message):
  r"""Spec for Neural Architecture Search (NAS) jobs.

  Fields:
    multiTrialAlgorithmSpec: The spec of multi-trial algorithms.
    oneShotAlgorithmSpec: The spec of one-shot algorithms.
    searchSpaceSpec: Required. It defines the search space for Neural
      Architecture Search (NAS).
  """

  multiTrialAlgorithmSpec = _messages.MessageField('GoogleCloudMlV1NasSpecMultiTrialAlgorithmSpec', 1)
  oneShotAlgorithmSpec = _messages.MessageField('GoogleCloudMlV1NasSpecOneShotAlgorithmSpec', 2)
  searchSpaceSpec = _messages.StringField(3)


class GoogleCloudMlV1NasSpecMultiTrialAlgorithmSpec(_messages.Message):
  r"""The spec of multi-trial Neural Architecture Search (NAS).

  Enums:
    MultiTrialAlgorithmValueValuesEnum: Optional. The multi-trial Neural
      Architecture Search (NAS) algorithm type. Defaults to
      `NAS_MULTI_TRIAL_ALGORITHM_REINFORCEMENT_LEARNING`.

  Fields:
    maxFailedNasTrials: Optional. It decides when a Neural Architecture Search
      (NAS) job should fail. Defaults to zero.
    maxNasTrials: Optional. How many Neural Architecture Search (NAS) trials
      should be attempted.
    maxParallelNasTrials: Required. The number of Neural Architecture Search
      (NAS) trials to run concurrently.
    multiTrialAlgorithm: Optional. The multi-trial Neural Architecture Search
      (NAS) algorithm type. Defaults to
      `NAS_MULTI_TRIAL_ALGORITHM_REINFORCEMENT_LEARNING`.
    nasTargetRewardMetric: Required. The TensorFlow summary tag that the
      controller tries to optimize. Its value needs to be consistent with the
      TensorFlow summary tag that is reported by trainer (customer provided
      dockers).
  """

  class MultiTrialAlgorithmValueValuesEnum(_messages.Enum):
    r"""Optional. The multi-trial Neural Architecture Search (NAS) algorithm
    type. Defaults to `NAS_MULTI_TRIAL_ALGORITHM_REINFORCEMENT_LEARNING`.

    Values:
      MULTI_TRIAL_ALGORITHM_UNSPECIFIED: <no description>
      REINFORCEMENT_LEARNING: The Reinforcement Learning Algorithm for Multi-
        trial Neural Architecture Search (NAS).
    """
    MULTI_TRIAL_ALGORITHM_UNSPECIFIED = 0
    REINFORCEMENT_LEARNING = 1

  maxFailedNasTrials = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxNasTrials = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  maxParallelNasTrials = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  multiTrialAlgorithm = _messages.EnumField('MultiTrialAlgorithmValueValuesEnum', 4)
  nasTargetRewardMetric = _messages.StringField(5)


class GoogleCloudMlV1NasSpecOneShotAlgorithmSpec(_messages.Message):
  r"""The spec of one shot Neural Architecture Search (NAS).

  Enums:
    OneShotAlgorithmValueValuesEnum: Optional. The one-shot Neural
      Architecture Search (NAS) algorithm type. Defaults to
      `ONE_SHOT_ALGORITHM_REINFORCEMENT_LEARNING`.

  Fields:
    oneShotAlgorithm: Optional. The one-shot Neural Architecture Search (NAS)
      algorithm type. Defaults to `ONE_SHOT_ALGORITHM_REINFORCEMENT_LEARNING`.
  """

  class OneShotAlgorithmValueValuesEnum(_messages.Enum):
    r"""Optional. The one-shot Neural Architecture Search (NAS) algorithm
    type. Defaults to `ONE_SHOT_ALGORITHM_REINFORCEMENT_LEARNING`.

    Values:
      ONE_SHOT_ALGORITHM_UNSPECIFIED: <no description>
      REINFORCEMENT_LEARNING: The Reinforcement Learning Algorithm for one-
        shot Neural Architecture Search (NAS).
    """
    ONE_SHOT_ALGORITHM_UNSPECIFIED = 0
    REINFORCEMENT_LEARNING = 1

  oneShotAlgorithm = _messages.EnumField('OneShotAlgorithmValueValuesEnum', 1)


class GoogleCloudMlV1OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Enums:
    OperationTypeValueValuesEnum: The operation type.

  Messages:
    LabelsValue: The user labels, inherited from the model or the model
      version being operated on.

  Fields:
    createTime: The time the operation was submitted.
    endTime: The time operation processing completed.
    isCancellationRequested: Indicates whether a request to cancel this
      operation has been made.
    labels: The user labels, inherited from the model or the model version
      being operated on.
    modelName: Contains the name of the model associated with the operation.
    operationType: The operation type.
    projectNumber: Contains the project number associated with the operation.
    startTime: The time operation processing started.
    version: Contains the version associated with the operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The operation type.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified operation type.
      CREATE_VERSION: An operation to create a new version.
      DELETE_VERSION: An operation to delete an existing version.
      DELETE_MODEL: An operation to delete an existing model.
      UPDATE_MODEL: An operation to update an existing model.
      UPDATE_VERSION: An operation to update an existing version.
      UPDATE_CONFIG: An operation to update project configuration.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    CREATE_VERSION = 1
    DELETE_VERSION = 2
    DELETE_MODEL = 3
    UPDATE_MODEL = 4
    UPDATE_VERSION = 5
    UPDATE_CONFIG = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The user labels, inherited from the model or the model version being
    operated on.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  isCancellationRequested = _messages.BooleanField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  modelName = _messages.StringField(5)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 6)
  projectNumber = _messages.IntegerField(7)
  startTime = _messages.StringField(8)
  version = _messages.MessageField('GoogleCloudMlV1Version', 9)


class GoogleCloudMlV1ParameterSpec(_messages.Message):
  r"""Represents a single hyperparameter to optimize.

  Enums:
    ScaleTypeValueValuesEnum: Optional. How the parameter should be scaled to
      the hypercube. Leave unset for categorical parameters. Some kind of
      scaling is strongly recommended for real or integral parameters (e.g.,
      `UNIT_LINEAR_SCALE`).
    TypeValueValuesEnum: Required. The type of the parameter.

  Fields:
    categoricalValues: Required if type is `CATEGORICAL`. The list of possible
      categories.
    discreteValues: Required if type is `DISCRETE`. A list of feasible points.
      The list should be in strictly increasing order. For instance, this
      parameter might have possible settings of 1.5, 2.5, and 4.0. This list
      should not contain more than 1,000 values.
    maxValue: Required if type is `DOUBLE` or `INTEGER`. This field should be
      unset if type is `CATEGORICAL`. This value should be integers if type is
      `INTEGER`.
    minValue: Required if type is `DOUBLE` or `INTEGER`. This field should be
      unset if type is `CATEGORICAL`. This value should be integers if type is
      INTEGER.
    parameterName: Required. The parameter name must be unique amongst all
      ParameterConfigs in a HyperparameterSpec message. E.g., "learning_rate".
    scaleType: Optional. How the parameter should be scaled to the hypercube.
      Leave unset for categorical parameters. Some kind of scaling is strongly
      recommended for real or integral parameters (e.g., `UNIT_LINEAR_SCALE`).
    type: Required. The type of the parameter.
  """

  class ScaleTypeValueValuesEnum(_messages.Enum):
    r"""Optional. How the parameter should be scaled to the hypercube. Leave
    unset for categorical parameters. Some kind of scaling is strongly
    recommended for real or integral parameters (e.g., `UNIT_LINEAR_SCALE`).

    Values:
      NONE: By default, no scaling is applied.
      UNIT_LINEAR_SCALE: Scales the feasible space to (0, 1) linearly.
      UNIT_LOG_SCALE: Scales the feasible space logarithmically to (0, 1). The
        entire feasible space must be strictly positive.
      UNIT_REVERSE_LOG_SCALE: Scales the feasible space "reverse"
        logarithmically to (0, 1). The result is that values close to the top
        of the feasible space are spread out more than points near the bottom.
        The entire feasible space must be strictly positive.
    """
    NONE = 0
    UNIT_LINEAR_SCALE = 1
    UNIT_LOG_SCALE = 2
    UNIT_REVERSE_LOG_SCALE = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the parameter.

    Values:
      PARAMETER_TYPE_UNSPECIFIED: You must specify a valid type. Using this
        unspecified type will result in an error.
      DOUBLE: Type for real-valued parameters.
      INTEGER: Type for integral parameters.
      CATEGORICAL: The parameter is categorical, with a value chosen from the
        categories field.
      DISCRETE: The parameter is real valued, with a fixed set of feasible
        points. If `type==DISCRETE`, feasible_points must be provided, and
        {`min_value`, `max_value`} will be ignored.
    """
    PARAMETER_TYPE_UNSPECIFIED = 0
    DOUBLE = 1
    INTEGER = 2
    CATEGORICAL = 3
    DISCRETE = 4

  categoricalValues = _messages.StringField(1, repeated=True)
  discreteValues = _messages.FloatField(2, repeated=True)
  maxValue = _messages.FloatField(3)
  minValue = _messages.FloatField(4)
  parameterName = _messages.StringField(5)
  scaleType = _messages.EnumField('ScaleTypeValueValuesEnum', 6)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class GoogleCloudMlV1PredictRequest(_messages.Message):
  r"""Request for predictions to be issued against a trained model.

  Fields:
    httpBody:  Required. The prediction request body. Refer to the [request
      body details section](#request-body-details) for more information on how
      to structure your request.
  """

  httpBody = _messages.MessageField('GoogleApiHttpBody', 1)


class GoogleCloudMlV1PredictionInput(_messages.Message):
  r"""Represents input parameters for a prediction job.

  Enums:
    DataFormatValueValuesEnum: Required. The format of the input data files.
    FrameworkValueValuesEnum: Optional. The framework used to train this
      model. Only needed if model_version is a GCS path. Otherwise the
      framework specified during version creation will be used.
    OutputDataFormatValueValuesEnum: Optional. Format of the output data
      files, defaults to JSON.

  Fields:
    accelerator: Optional. The type and number of accelerators to be attached
      to each machine running the job.
    batchSize: Optional. Number of records per batch, defaults to 64. The
      service will buffer batch_size number of records in memory before
      invoking one Tensorflow prediction call internally. So take the record
      size and memory available into consideration when setting this
      parameter.
    dataFormat: Required. The format of the input data files.
    framework: Optional. The framework used to train this model. Only needed
      if model_version is a GCS path. Otherwise the framework specified during
      version creation will be used.
    initialWorkerCount: Optional. The initial number of workers to be used for
      parallel processing. Defaults to 0 if one wants the service to figure
      out the number. The actual number of workers being used may change after
      the job starts depending on the autoscaling policy.
    inputPaths: Required. The Cloud Storage location of the input data files.
      May contain <a
      href="/storage/docs/gsutil/addlhelp/WildcardNames">wildcards</a>.
    maxWorkerCount: Optional. The maximum number of workers to be used for
      parallel processing. Defaults to 10 if not specified.
    modelName: Use this field if you want to use the default version for the
      specified model. The string must use the following format:
      `"projects/YOUR_PROJECT/models/YOUR_MODEL"`
    outputDataFormat: Optional. Format of the output data files, defaults to
      JSON.
    outputPath: Required. The output Google Cloud Storage location.
    region: Required. The Google Compute Engine region to run the prediction
      job in. See the <a href="/ml-engine/docs/tensorflow/regions">available
      regions</a> for AI Platform services.
    runtimeVersion: Optional. The AI Platform runtime version to use for this
      batch prediction. If not set, AI Platform will pick the runtime version
      used during the CreateVersion request for this model version, or choose
      the latest stable version when model version information is not
      available such as when the model is specified by uri.
    signatureName: Optional. The name of the signature defined in the
      SavedModel to use for this job. Please refer to
      [SavedModel](https://tensorflow.github.io/serving/serving_basic.html)
      for information about how to use signatures.  Defaults to [DEFAULT_SERVI
      NG_SIGNATURE_DEF_KEY](https://www.tensorflow.org/api_docs/python/tf/save
      d_model/signature_constants) , which is "serving_default".
    tagsOverride: Optional. The set of tags to select which meta graph defined
      in the SavedModel to use for this job. Please refer to
      [SavedModel](https://www.tensorflow.org/serving/serving_basic) for
      information about how to use tags.  Overrides the default tags when
      predicting from a deployed model version.  When predicting from a model
      directory, the tag defaults to [SERVING](https://www.tensorflow.org/api_
      docs/python/tf/saved_model/tag_constants) , which is "serve".
    uri: Use this field if you want to specify a Google Cloud Storage path for
      the model to use.
    versionName: Use this field if you want to specify a version of the model
      to use. The string is formatted the same way as `model_version`, with
      the addition of the version information:
      `"projects/YOUR_PROJECT/models/YOUR_MODEL/versions/YOUR_VERSION"`
    workerType: Optional. The type of virtual machine to use for batch
      prediction job's worker nodes. It supports all machine types available
      on GCP ( https://cloud.google.com/compute/docs/machine-types), subject
      to the availability in the specific region the job runs.
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""Required. The format of the input data files.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format.
      JSON: Each line of the file is a JSON dictionary representing one
        record.
      TEXT: Deprecated. Use JSON instead.
      TF_RECORD: The source file is a TFRecord file. Currently available only
        for input data.
      TF_RECORD_GZIP: The source file is a GZIP-compressed TFRecord file.
        Currently available only for input data.
      FILE_LIST: Each line of the file is the location of an instance to
        process. Currently available only for input data.
      CSV: Values are comma-separated rows, with keys in a separate file.
        Currently available only for output data.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSON = 1
    TEXT = 2
    TF_RECORD = 3
    TF_RECORD_GZIP = 4
    FILE_LIST = 5
    CSV = 6

  class FrameworkValueValuesEnum(_messages.Enum):
    r"""Optional. The framework used to train this model. Only needed if
    model_version is a GCS path. Otherwise the framework specified during
    version creation will be used.

    Values:
      FRAMEWORK_UNSPECIFIED: Unspecified framework. Assigns a value based on
        the file suffix.
      TENSORFLOW: Tensorflow framework.
      SCIKIT_LEARN: Scikit-learn framework.
      XGBOOST: XGBoost framework.
    """
    FRAMEWORK_UNSPECIFIED = 0
    TENSORFLOW = 1
    SCIKIT_LEARN = 2
    XGBOOST = 3

  class OutputDataFormatValueValuesEnum(_messages.Enum):
    r"""Optional. Format of the output data files, defaults to JSON.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format.
      JSON: Each line of the file is a JSON dictionary representing one
        record.
      TEXT: Deprecated. Use JSON instead.
      TF_RECORD: The source file is a TFRecord file. Currently available only
        for input data.
      TF_RECORD_GZIP: The source file is a GZIP-compressed TFRecord file.
        Currently available only for input data.
      FILE_LIST: Each line of the file is the location of an instance to
        process. Currently available only for input data.
      CSV: Values are comma-separated rows, with keys in a separate file.
        Currently available only for output data.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSON = 1
    TEXT = 2
    TF_RECORD = 3
    TF_RECORD_GZIP = 4
    FILE_LIST = 5
    CSV = 6

  accelerator = _messages.MessageField('GoogleCloudMlV1AcceleratorConfig', 1)
  batchSize = _messages.IntegerField(2)
  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 3)
  framework = _messages.EnumField('FrameworkValueValuesEnum', 4)
  initialWorkerCount = _messages.IntegerField(5)
  inputPaths = _messages.StringField(6, repeated=True)
  maxWorkerCount = _messages.IntegerField(7)
  modelName = _messages.StringField(8)
  outputDataFormat = _messages.EnumField('OutputDataFormatValueValuesEnum', 9)
  outputPath = _messages.StringField(10)
  region = _messages.StringField(11)
  runtimeVersion = _messages.StringField(12)
  signatureName = _messages.StringField(13)
  tagsOverride = _messages.StringField(14, repeated=True)
  uri = _messages.StringField(15)
  versionName = _messages.StringField(16)
  workerType = _messages.StringField(17)


class GoogleCloudMlV1PredictionOutput(_messages.Message):
  r"""Represents results of a prediction job.

  Fields:
    errorCount: The number of data instances which resulted in errors.
    nodeHours: Node hours used by the batch prediction job.
    outputPath: The output Google Cloud Storage location provided at the job
      creation time.
    predictionCount: The number of generated predictions.
  """

  errorCount = _messages.IntegerField(1)
  nodeHours = _messages.FloatField(2)
  outputPath = _messages.StringField(3)
  predictionCount = _messages.IntegerField(4)


class GoogleCloudMlV1ReplicaConfig(_messages.Message):
  r"""Represents the configuration for a replica in a cluster.

  Fields:
    acceleratorConfig: Represents the type and number of accelerators used by
      the replica. [Learn about restrictions on accelerator configurations for
      training.](/ml-engine/docs/tensorflow/using-gpus#compute-engine-machine-
      types-with-gpu)
    imageUri: The Docker image to run on the replica. This image must be in
      Container Registry. Learn more about [configuring custom containers
      ](/ml-engine/docs/distributed-training-containers).
    tpuTfVersion: The AI Platform runtime version that includes a TensorFlow
      version matching the one used in the custom container. This field is
      required if the replica is a TPU worker that uses a custom container.
      Otherwise, do not specify this field. This must be a [runtime version
      that currently supports training with TPUs](/ml-engine/docs/tensorflow
      /runtime-version-list#tpu-support).  Note that the version of TensorFlow
      included in a runtime version may differ from the numbering of the
      runtime version itself, because it may have a different [patch version](
      https://www.tensorflow.org/guide/version_compat#semantic_versioning_20).
      In this field, you must specify the runtime version (TensorFlow minor
      version). For example, if your custom container runs TensorFlow `1.x.y`,
      specify `1.x`.
  """

  acceleratorConfig = _messages.MessageField('GoogleCloudMlV1AcceleratorConfig', 1)
  imageUri = _messages.StringField(2)
  tpuTfVersion = _messages.StringField(3)


class GoogleCloudMlV1RequestLoggingConfig(_messages.Message):
  r"""Configuration for logging request-response pairs to a BigQuery table.
  Online prediction requests to a model version and the responses to these
  requests are converted to raw strings and saved to the specified BigQuery
  table. Logging is constrained by [BigQuery quotas and
  limits](/bigquery/quotas). If your project exceeds BigQuery quotas or
  limits, AI Platform Prediction does not log request-response pairs, but it
  continues to serve predictions.  If you are using [continuous evaluation
  ](/ml-engine/docs/continuous-evaluation/), you do not need to specify this
  configuration manually. Setting up continuous evaluation automatically
  enables logging of request-response pairs.

  Fields:
    bigqueryTableName: Required. Fully qualified BigQuery table name in the
      following format:
      "<var>project_id</var>.<var>dataset_name</var>.<var>table_name</var>"
      The specified table must already exist, and the "Cloud ML Service Agent"
      for your project must have permission to write to it. The table must
      have the following [schema](/bigquery/docs/schemas):  <table>
      <tr><th>Field name</th><th style="display: table-cell">Type</th>     <th
      style="display: table-cell">Mode</th></tr>
      <tr><td>model</td><td>STRING</td><td>REQUIRED</td></tr>
      <tr><td>model_version</td><td>STRING</td><td>REQUIRED</td></tr>
      <tr><td>time</td><td>TIMESTAMP</td><td>REQUIRED</td></tr>
      <tr><td>raw_data</td><td>STRING</td><td>REQUIRED</td></tr>
      <tr><td>raw_prediction</td><td>STRING</td><td>NULLABLE</td></tr>
      <tr><td>groundtruth</td><td>STRING</td><td>NULLABLE</td></tr> </table>
    samplingPercentage: Percentage of requests to be logged, expressed as a
      fraction from 0 to 1. For example, if you want to log 10% of requests,
      enter `0.1`. The sampling window is the lifetime of the model version.
      Defaults to 0.
  """

  bigqueryTableName = _messages.StringField(1)
  samplingPercentage = _messages.FloatField(2)


class GoogleCloudMlV1RouteMap(_messages.Message):
  r"""RouteMap is used to override HTTP paths sent to a Custom Container. If
  specified, the HTTP server implemented in the ContainerSpec must support the
  route. If unspecified, standard HTTP paths will be used.

  Fields:
    health: HTTP path to send health check requests.
    predict: HTTP path to send prediction requests.
  """

  health = _messages.StringField(1)
  predict = _messages.StringField(2)


class GoogleCloudMlV1SaabasAttribution(_messages.Message):
  r"""Attributes credit by running a faster aproximation to the TreeShap
  method. Please refer to this link for more details:
  https://blog.datadive.net/interpreting-random-forests/ This attribution
  method is only supported for XGBoost models.
  """



class GoogleCloudMlV1SampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    numPaths: The number of feature permutations to consider when
      approximating the Shapley values.
  """

  numPaths = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1Scheduling(_messages.Message):
  r"""All parameters related to scheduling of training jobs.

  Fields:
    maxRunningTime: Optional. The maximum job running time, expressed in
      seconds. The field can contain up to nine fractional digits, terminated
      by `s`. By default there is no limit to the running time.  If the
      training job is still running after this duration, AI Platform Training
      cancels it.  For example, if you want to ensure your job runs for no
      more than 2 hours, set this field to `7200s` (2 hours * 60 minutes /
      hour * 60 seconds / minute).  If you submit your training job using the
      `gcloud` tool, you can [provide this field in a `config.yaml` file](/ai-
      platform/training/docs/training-
      jobs#formatting_your_configuration_parameters). For example:  ```yaml
      trainingInput:   ...   scheduling:     maxRunningTime: 7200s   ... ```
  """

  maxRunningTime = _messages.StringField(1)


class GoogleCloudMlV1SetDefaultVersionRequest(_messages.Message):
  r"""Request message for the SetDefaultVersion request."""


class GoogleCloudMlV1TrainingInput(_messages.Message):
  r"""Represents input parameters for a training job. When using the gcloud
  command to submit your training job, you can specify the input parameters as
  command-line arguments and/or in a YAML configuration file referenced from
  the --config command-line argument. For details, see the guide to <a href
  ="/ml-engine/docs/tensorflow/training-jobs">submitting a training job</a>.

  Enums:
    ScaleTierValueValuesEnum: Required. Specifies the machine types, the
      number of replicas for workers and parameter servers.

  Fields:
    args: Optional. Command line arguments to pass to the program.
    hyperparameters: Optional. The set of Hyperparameters to tune.
    jobDir: Optional. A Google Cloud Storage path in which to store training
      outputs and other data needed for training. This path is passed to your
      TensorFlow program as the '--job-dir' command-line argument. The benefit
      of specifying this field is that Cloud ML validates the path for use in
      training.
    masterConfig: Optional. The configuration for your master worker.  You
      should only set `masterConfig.acceleratorConfig` if `masterType` is set
      to a Compute Engine machine type. Learn about [restrictions on
      accelerator configurations for training.](/ml-engine/docs/tensorflow
      /using-gpus#compute-engine-machine-types-with-gpu)  Set
      `masterConfig.imageUri` only if you build a custom image. Only one of
      `masterConfig.imageUri` and `runtimeVersion` should be set. Learn more
      about [configuring custom containers](/ml-engine/docs/distributed-
      training-containers).
    masterType: Optional. Specifies the type of virtual machine to use for
      your training job's master worker. You must specify this field when
      `scaleTier` is set to `CUSTOM`.  You can use certain Compute Engine
      machine types directly in this field. The following types are supported:
      - `n1-standard-4` - `n1-standard-8` - `n1-standard-16` -
      `n1-standard-32` - `n1-standard-64` - `n1-standard-96` - `n1-highmem-2`
      - `n1-highmem-4` - `n1-highmem-8` - `n1-highmem-16` - `n1-highmem-32` -
      `n1-highmem-64` - `n1-highmem-96` - `n1-highcpu-16` - `n1-highcpu-32` -
      `n1-highcpu-64` - `n1-highcpu-96`  Learn more about [using Compute
      Engine machine types](/ml-engine/docs/machine-types#compute-engine-
      machine-types).  Alternatively, you can use the following legacy machine
      types:  - `standard` - `large_model` - `complex_model_s` -
      `complex_model_m` - `complex_model_l` - `standard_gpu` -
      `complex_model_m_gpu` - `complex_model_l_gpu` - `standard_p100` -
      `complex_model_m_p100` - `standard_v100` - `large_model_v100` -
      `complex_model_m_v100` - `complex_model_l_v100`  Learn more about [using
      legacy machine types](/ml-engine/docs/machine-types#legacy-machine-
      types).  Finally, if you want to use a TPU for training, specify
      `cloud_tpu` in this field. Learn more about the [special configuration
      options for training with TPUs](/ml-engine/docs/tensorflow/using-
      tpus#configuring_a_custom_tpu_machine).
    nasJobSpec: Optional. The spec of a Neural Architecture Search (NAS) job.
    packageUris: Required. The Google Cloud Storage location of the packages
      with the training program and any additional dependencies. The maximum
      number of package URIs is 100.
    parameterServerConfig: Optional. The configuration for parameter servers.
      You should only set `parameterServerConfig.acceleratorConfig` if
      `parameterServerConfigType` is set to a Compute Engine machine type.
      [Learn about restrictions on accelerator configurations for training
      .](/ml-engine/docs/tensorflow/using-gpus#compute-engine-machine-types-
      with-gpu)  Set `parameterServerConfig.imageUri` only if you build a
      custom image for your parameter server. If
      `parameterServerConfig.imageUri` has not been set, AI Platform uses the
      value of `masterConfig.imageUri`. Learn more about [configuring custom
      containers](/ml-engine/docs/distributed-training-containers).
    parameterServerCount: Optional. The number of parameter server replicas to
      use for the training job. Each replica in the cluster will be of the
      type specified in `parameter_server_type`.  This value can only be used
      when `scale_tier` is set to `CUSTOM`.If you set this value, you must
      also set `parameter_server_type`.  The default value is zero.
    parameterServerType: Optional. Specifies the type of virtual machine to
      use for your training job's parameter server.  The supported values are
      the same as those described in the entry for `master_type`.  This value
      must be consistent with the category of machine type that `masterType`
      uses. In other words, both must be Compute Engine machine types or both
      must be legacy machine types.  This value must be present when
      `scaleTier` is set to `CUSTOM` and `parameter_server_count` is greater
      than zero.
    pythonModule: Required. The Python module name to run after installing the
      packages.
    pythonVersion: Optional. The version of Python used in training. If not
      set, the default version is '2.7'. Starting [January 13, 2020](/ml-
      engine/docs/release-notes#december_10_2019), this field is required.
      The following Python versions are available:  * Python '3.7' is
      available when `runtime_version` is set to '1.15' or   later. * Python
      '3.5' is available when `runtime_version` is set to a version   from
      '1.4' to '1.14'. * Python '2.7' is available when `runtime_version` is
      set to '1.15' or   earlier. (Runtime versions released [after January 1,
      2020](/ml-engine/docs/release-notes#december_10_2019) do not support
      Python 2.7.)  Read more about the Python versions available for [each
      runtime version](/ml-engine/docs/runtime-version-list).
    region: Required. The Google Compute Engine region to run the training job
      in. See the <a href="/ml-engine/docs/tensorflow/regions">available
      regions</a> for AI Platform services.
    runtimeVersion: Optional. The AI Platform runtime version to use for
      training. If not set, AI Platform uses the default stable version, 1.0.
      Starting [January 13, 2020](/ml-engine/docs/release-
      notes#december_10_2019), this field is required.  For more information,
      see the <a href="/ml-engine/docs/runtime-version-list">runtime version
      list</a> and <a href="/ml-engine/docs/versioning">how to manage runtime
      versions</a>.
    scaleTier: Required. Specifies the machine types, the number of replicas
      for workers and parameter servers.
    scheduling: Optional. Scheduling options for a training job.
    useChiefInTfConfig: Optional. Use 'chief' instead of 'master' in TF_CONFIG
      when Custom Container is used and evaluator is not specified.  Defaults
      to false.
    workerConfig: Optional. The configuration for workers.  You should only
      set `workerConfig.acceleratorConfig` if `workerType` is set to a Compute
      Engine machine type. [Learn about restrictions on accelerator
      configurations for training.](/ml-engine/docs/tensorflow/using-gpus
      #compute-engine-machine-types-with-gpu)  Set `workerConfig.imageUri`
      only if you build a custom image for your worker. If
      `workerConfig.imageUri` has not been set, AI Platform uses the value of
      `masterConfig.imageUri`. Learn more about [configuring custom containers
      ](/ml-engine/docs/distributed-training-containers).
    workerCount: Optional. The number of worker replicas to use for the
      training job. Each replica in the cluster will be of the type specified
      in `worker_type`.  This value can only be used when `scale_tier` is set
      to `CUSTOM`. If you set this value, you must also set `worker_type`.
      The default value is zero.
    workerType: Optional. Specifies the type of virtual machine to use for
      your training job's worker nodes.  The supported values are the same as
      those described in the entry for `masterType`.  This value must be
      consistent with the category of machine type that `masterType` uses. In
      other words, both must be Compute Engine machine types or both must be
      legacy machine types.  If you use `cloud_tpu` for this value, see
      special instructions for [configuring a custom TPU machine](/ml-
      engine/docs/tensorflow/using-tpus#configuring_a_custom_tpu_machine).
      This value must be present when `scaleTier` is set to `CUSTOM` and
      `workerCount` is greater than zero.
  """

  class ScaleTierValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the machine types, the number of replicas for
    workers and parameter servers.

    Values:
      BASIC: A single worker instance. This tier is suitable for learning how
        to use Cloud ML, and for experimenting with new models using small
        datasets.
      STANDARD_1: Many workers and a few parameter servers.
      PREMIUM_1: A large number of workers with many parameter servers.
      BASIC_GPU: A single worker instance [with a GPU](/ml-
        engine/docs/tensorflow/using-gpus).
      BASIC_TPU: A single worker instance with a [Cloud TPU](/ml-
        engine/docs/tensorflow/using-tpus).
      CUSTOM: The CUSTOM tier is not a set tier, but rather enables you to use
        your own cluster specification. When you use this tier, set values to
        configure your processing cluster according to these guidelines:  *
        You _must_ set `TrainingInput.masterType` to specify the type     of
        machine to use for your master node. This is the only required
        setting.  *   You _may_ set `TrainingInput.workerCount` to specify the
        number of     workers to use. If you specify one or more workers, you
        _must_ also     set `TrainingInput.workerType` to specify the type of
        machine to use     for your worker nodes.  *   You _may_ set
        `TrainingInput.parameterServerCount` to specify the     number of
        parameter servers to use. If you specify one or more     parameter
        servers, you _must_ also set     `TrainingInput.parameterServerType`
        to specify the type of machine to     use for your parameter servers.
        Note that all of your workers must use the same machine type, which
        can be different from your parameter server type and master type. Your
        parameter servers must likewise use the same machine type, which can
        be different from your worker type and master type.
    """
    BASIC = 0
    STANDARD_1 = 1
    PREMIUM_1 = 2
    BASIC_GPU = 3
    BASIC_TPU = 4
    CUSTOM = 5

  args = _messages.StringField(1, repeated=True)
  hyperparameters = _messages.MessageField('GoogleCloudMlV1HyperparameterSpec', 2)
  jobDir = _messages.StringField(3)
  masterConfig = _messages.MessageField('GoogleCloudMlV1ReplicaConfig', 4)
  masterType = _messages.StringField(5)
  nasJobSpec = _messages.MessageField('GoogleCloudMlV1NasSpec', 6)
  packageUris = _messages.StringField(7, repeated=True)
  parameterServerConfig = _messages.MessageField('GoogleCloudMlV1ReplicaConfig', 8)
  parameterServerCount = _messages.IntegerField(9)
  parameterServerType = _messages.StringField(10)
  pythonModule = _messages.StringField(11)
  pythonVersion = _messages.StringField(12)
  region = _messages.StringField(13)
  runtimeVersion = _messages.StringField(14)
  scaleTier = _messages.EnumField('ScaleTierValueValuesEnum', 15)
  scheduling = _messages.MessageField('GoogleCloudMlV1Scheduling', 16)
  useChiefInTfConfig = _messages.BooleanField(17)
  workerConfig = _messages.MessageField('GoogleCloudMlV1ReplicaConfig', 18)
  workerCount = _messages.IntegerField(19)
  workerType = _messages.StringField(20)


class GoogleCloudMlV1TrainingOutput(_messages.Message):
  r"""Represents results of a training job. Output only.

  Fields:
    builtInAlgorithmOutput: Details related to built-in algorithms jobs. Only
      set for built-in algorithms jobs.
    completedTrialCount: The number of hyperparameter tuning trials that
      completed successfully. Only set for hyperparameter tuning jobs.
    consumedMLUnits: The amount of ML units consumed by the job.
    hyperparameterMetricTag: The TensorFlow summary tag name used for
      optimizing hyperparameter tuning trials. See [`HyperparameterSpec.hyperp
      arameterMetricTag`](#HyperparameterSpec.FIELDS.hyperparameter_metric_tag
      ) for more information. Only set for hyperparameter tuning jobs.
    isBuiltInAlgorithmJob: Whether this job is a built-in Algorithm job.
    isHyperparameterTuningJob: Whether this job is a hyperparameter tuning
      job.
    nasJobOutput: The output of a Neural Architecture Search (NAS) job.
    trials: Results for individual Hyperparameter trials. Only set for
      hyperparameter tuning jobs.
  """

  builtInAlgorithmOutput = _messages.MessageField('GoogleCloudMlV1BuiltInAlgorithmOutput', 1)
  completedTrialCount = _messages.IntegerField(2)
  consumedMLUnits = _messages.FloatField(3)
  hyperparameterMetricTag = _messages.StringField(4)
  isBuiltInAlgorithmJob = _messages.BooleanField(5)
  isHyperparameterTuningJob = _messages.BooleanField(6)
  nasJobOutput = _messages.MessageField('GoogleCloudMlV1NasJobOutput', 7)
  trials = _messages.MessageField('GoogleCloudMlV1HyperparameterOutput', 8, repeated=True)


class GoogleCloudMlV1TreeShapAttribution(_messages.Message):
  r"""Attributes credit by computing the Shapley value taking advantage of the
  model's tree ensemble structure. Refer to this paper for more details:
  http://papers.nips.cc/paper/7062-a-unified-approach-to-interpreting-model-
  predictions.pdf. This attribution method is supported for XGBoost models.
  """



class GoogleCloudMlV1Version(_messages.Message):
  r"""Represents a version of the model.  Each version is a trained model
  deployed in the cloud, ready to handle prediction requests. A model can have
  multiple versions. You can get information about all of the versions of a
  given model by calling projects.models.versions.list.

  Enums:
    FrameworkValueValuesEnum: Optional. The machine learning framework AI
      Platform uses to train this version of the model. Valid values are
      `TENSORFLOW`, `SCIKIT_LEARN`, `XGBOOST`. If you do not specify a
      framework, AI Platform will analyze files in the deployment_uri to
      determine a framework. If you choose `SCIKIT_LEARN` or `XGBOOST`, you
      must also set the runtime version of the model to 1.4 or greater.  Do
      **not** specify a framework if you're deploying a [custom prediction
      routine](/ml-engine/docs/tensorflow/custom-prediction-routines).  If you
      specify a [Compute Engine (N1) machine type](/ml-engine/docs/machine-
      types-online-prediction) in the `machineType` field, you must specify
      `TENSORFLOW` for the framework.
    StateValueValuesEnum: Output only. The state of a version.

  Messages:
    LabelsValue: Optional. One or more labels that you can add, to organize
      your model versions. Each label is a key-value pair, where both the key
      and the value are arbitrary strings that you supply. For more
      information, see the documentation on <a href="/ml-
      engine/docs/tensorflow/resource-labels">using labels</a>.

  Fields:
    acceleratorConfig: Optional. Accelerator config for using GPUs for online
      prediction (beta). Only specify this field if you have specified a
      Compute Engine (N1) machine type in the `machineType` field. Learn more
      about [using GPUs for online prediction](/ml-engine/docs/machine-types-
      online-prediction#gpus).
    autoScaling: Automatically scale the number of nodes used to serve the
      model in response to increases and decreases in traffic. Care should be
      taken to ramp up traffic according to the model's ability to scale or
      you will start seeing increases in latency and 429 response codes.  Note
      that you cannot use AutoScaling if your version uses
      [GPUs](#Version.FIELDS.accelerator_config). Instead, you must use
      specify `manual_scaling`.
    container: A GoogleCloudMlV1ContainerSpec attribute.
    createTime: Output only. The time the version was created.
    deploymentUri: Required. The Cloud Storage location of the trained model
      used to create the version. See the [guide to model deployment](/ml-
      engine/docs/tensorflow/deploying-models) for more information.  When
      passing Version to projects.models.versions.create the model service
      uses the specified location as the source of the model. Once deployed,
      the model version is hosted by the prediction service, so this location
      is useful only as a historical record. The total number of model files
      can't exceed 1000.
    description: Optional. The description specified for the version when it
      was created.
    errorMessage: Output only. The details of a failure or a cancellation.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a model from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform model updates in order to avoid race
      conditions: An `etag` is returned in the response to `GetVersion`, and
      systems are expected to put that etag in the request to `UpdateVersion`
      to ensure that their change will be applied to the model as intended.
    explanationConfig: Optional. Configures explainability features on the
      model's version. Some explanation features require additional metadata
      to be loaded as part of the model payload.
    framework: Optional. The machine learning framework AI Platform uses to
      train this version of the model. Valid values are `TENSORFLOW`,
      `SCIKIT_LEARN`, `XGBOOST`. If you do not specify a framework, AI
      Platform will analyze files in the deployment_uri to determine a
      framework. If you choose `SCIKIT_LEARN` or `XGBOOST`, you must also set
      the runtime version of the model to 1.4 or greater.  Do **not** specify
      a framework if you're deploying a [custom prediction routine](/ml-
      engine/docs/tensorflow/custom-prediction-routines).  If you specify a
      [Compute Engine (N1) machine type](/ml-engine/docs/machine-types-online-
      prediction) in the `machineType` field, you must specify `TENSORFLOW`
      for the framework.
    imageUri: Optional. The docker image to run for custom serving container.
      This image must be in Google Container Registry.
    isDefault: Output only. If true, this version will be used to handle
      prediction requests that do not specify a version.  You can change the
      default version by calling projects.methods.versions.setDefault.
    labels: Optional. One or more labels that you can add, to organize your
      model versions. Each label is a key-value pair, where both the key and
      the value are arbitrary strings that you supply. For more information,
      see the documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.
    lastUseTime: Output only. The time the version was last used for
      prediction.
    machineType: Optional. The type of machine on which to serve the model.
      Currently only applies to online prediction service. If this field is
      not specified, it defaults to `mls1-c1-m2`.  Online prediction supports
      the following machine types:  * `mls1-c1-m2` * `mls1-c4-m2` *
      `n1-standard-2` * `n1-standard-4` * `n1-standard-8` * `n1-standard-16` *
      `n1-standard-32` * `n1-highmem-2` * `n1-highmem-4` * `n1-highmem-8` *
      `n1-highmem-16` * `n1-highmem-32` * `n1-highcpu-2` * `n1-highcpu-4` *
      `n1-highcpu-8` * `n1-highcpu-16` * `n1-highcpu-32`  `mls1-c1-m2` is
      generally available. All other machine types are available in beta.
      Learn more about the [differences between machine types](/ml-engine/docs
      /machine-types-online-prediction).
    manualScaling: Manually select the number of nodes to use for serving the
      model. You should generally use `auto_scaling` with an appropriate
      `min_nodes` instead, but this option is available if you want more
      predictable billing. Beware that latency and error rates will increase
      if the traffic exceeds that capability of the system to serve it based
      on the selected number of nodes.
    modelClass: A string attribute.
    name: Required. The name specified for the version when it was created.
      The version name must be unique within the model it is created in.
    packageUris: Optional. Cloud Storage paths (`gs://...`) of packages for
      [custom prediction routines](/ml-engine/docs/tensorflow/custom-
      prediction-routines) or [scikit-learn pipelines with custom code](/ml-
      engine/docs/scikit/exporting-for-prediction#custom-pipeline-code).  For
      a custom prediction routine, one of these packages must contain your
      Predictor class (see
      [`predictionClass`](#Version.FIELDS.prediction_class)). Additionally,
      include any dependencies used by your Predictor or scikit-learn pipeline
      uses that are not already included in your selected [runtime version
      ](/ml-engine/docs/tensorflow/runtime-version-list).  If you specify this
      field, you must also set
      [`runtimeVersion`](#Version.FIELDS.runtime_version) to 1.4 or greater.
    predictionClass: Optional. The fully qualified name
      (<var>module_name</var>.<var>class_name</var>) of a class that
      implements the Predictor interface described in this reference field.
      The module containing this class should be included in a package
      provided to the [`packageUris` field](#Version.FIELDS.package_uris).
      Specify this field if and only if you are deploying a [custom prediction
      routine (beta)](/ml-engine/docs/tensorflow/custom-prediction-routines).
      If you specify this field, you must set
      [`runtimeVersion`](#Version.FIELDS.runtime_version) to 1.4 or greater
      and you must set `machineType` to a [legacy (MLS1) machine type](/ml-
      engine/docs/machine-types-online-prediction).  The following code sample
      provides the Predictor interface:  <pre style="max-width: 626px;"> class
      Predictor(object): " " "Interface for constructing custom predictors." "
      "  def predict(self, instances, **kwargs):     " " "Performs custom
      prediction.      Instances are the decoded values from the request. They
      have already     been deserialized from JSON.      Args:
      instances: A list of prediction input instances.         **kwargs: A
      dictionary of keyword args provided as additional             fields on
      the predict request body.      Returns:         A list of outputs
      containing the prediction results. This list must         be JSON
      serializable.     " " "     raise NotImplementedError()  @classmethod
      def from_path(cls, model_dir):     " " "Creates an instance of Predictor
      using the given path.      Loading of the predictor should be done in
      this method.      Args:         model_dir: The local directory that
      contains the exported model             file along with any additional
      files uploaded when creating the             version resource.
      Returns:         An instance implementing this Predictor class.     " "
      "     raise NotImplementedError() </pre>  Learn more about [the
      Predictor interface and custom prediction routines](/ml-
      engine/docs/tensorflow/custom-prediction-routines).
    pythonVersion: Optional. The version of Python used in prediction. If not
      set, the default version is '2.7'. Starting [January 13, 2020](/ml-
      engine/docs/release-notes#december_10_2019), this field is required.
      The following Python versions are available:  * Python '3.7' is
      available when `runtime_version` is set to '1.15' or   later. * Python
      '3.5' is available when `runtime_version` is set to a version   from
      '1.4' to '1.14'. * Python '2.7' is available when `runtime_version` is
      set to '1.15' or   earlier. (Runtime versions released [after January 1,
      2020](/ml-engine/docs/release-notes#december_10_2019) do not support
      Python 2.7.)  Read more about the Python versions available for [each
      runtime version](/ml-engine/docs/runtime-version-list).
    requestLoggingConfig: Optional. *Only* specify this field in a
      projects.models.versions.patch request. Specifying it in a
      projects.models.versions.create request has no effect.  Configures the
      request-response pair logging on predictions from this Version.
    routes: A GoogleCloudMlV1RouteMap attribute.
    runtimeVersion: Optional. The AI Platform runtime version to use for this
      deployment. If not set, AI Platform uses the default stable version,
      1.0. Starting [January 13, 2020](/ml-engine/docs/release-
      notes#december_10_2019), this field is required.  For more information,
      see the [runtime version list](/ml-engine/docs/runtime-version-list) and
      [how to manage runtime versions](/ml-engine/docs/versioning).
    serviceAccount: Optional. Specifies the service account for resource
      access control.
    state: Output only. The state of a version.
  """

  class FrameworkValueValuesEnum(_messages.Enum):
    r"""Optional. The machine learning framework AI Platform uses to train
    this version of the model. Valid values are `TENSORFLOW`, `SCIKIT_LEARN`,
    `XGBOOST`. If you do not specify a framework, AI Platform will analyze
    files in the deployment_uri to determine a framework. If you choose
    `SCIKIT_LEARN` or `XGBOOST`, you must also set the runtime version of the
    model to 1.4 or greater.  Do **not** specify a framework if you're
    deploying a [custom prediction routine](/ml-engine/docs/tensorflow/custom-
    prediction-routines).  If you specify a [Compute Engine (N1) machine type
    ](/ml-engine/docs/machine-types-online-prediction) in the `machineType`
    field, you must specify `TENSORFLOW` for the framework.

    Values:
      FRAMEWORK_UNSPECIFIED: Unspecified framework. Assigns a value based on
        the file suffix.
      TENSORFLOW: Tensorflow framework.
      SCIKIT_LEARN: Scikit-learn framework.
      XGBOOST: XGBoost framework.
    """
    FRAMEWORK_UNSPECIFIED = 0
    TENSORFLOW = 1
    SCIKIT_LEARN = 2
    XGBOOST = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of a version.

    Values:
      UNKNOWN: The version state is unspecified.
      READY: The version is ready for prediction.
      CREATING: The version is being created. New UpdateVersion and
        DeleteVersion requests will fail if a version is in the CREATING
        state.
      FAILED: The version failed to be created, possibly cancelled.
        `error_message` should contain the details of the failure.
      DELETING: The version is being deleted. New UpdateVersion and
        DeleteVersion requests will fail if a version is in the DELETING
        state.
      UPDATING: The version is being updated. New UpdateVersion and
        DeleteVersion requests will fail if a version is in the UPDATING
        state.
    """
    UNKNOWN = 0
    READY = 1
    CREATING = 2
    FAILED = 3
    DELETING = 4
    UPDATING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. One or more labels that you can add, to organize your model
    versions. Each label is a key-value pair, where both the key and the value
    are arbitrary strings that you supply. For more information, see the
    documentation on <a href="/ml-engine/docs/tensorflow/resource-
    labels">using labels</a>.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  acceleratorConfig = _messages.MessageField('GoogleCloudMlV1AcceleratorConfig', 1)
  autoScaling = _messages.MessageField('GoogleCloudMlV1AutoScaling', 2)
  container = _messages.MessageField('GoogleCloudMlV1ContainerSpec', 3)
  createTime = _messages.StringField(4)
  deploymentUri = _messages.StringField(5)
  description = _messages.StringField(6)
  errorMessage = _messages.StringField(7)
  etag = _messages.BytesField(8)
  explanationConfig = _messages.MessageField('GoogleCloudMlV1ExplanationConfig', 9)
  framework = _messages.EnumField('FrameworkValueValuesEnum', 10)
  imageUri = _messages.StringField(11)
  isDefault = _messages.BooleanField(12)
  labels = _messages.MessageField('LabelsValue', 13)
  lastUseTime = _messages.StringField(14)
  machineType = _messages.StringField(15)
  manualScaling = _messages.MessageField('GoogleCloudMlV1ManualScaling', 16)
  modelClass = _messages.StringField(17)
  name = _messages.StringField(18)
  packageUris = _messages.StringField(19, repeated=True)
  predictionClass = _messages.StringField(20)
  pythonVersion = _messages.StringField(21)
  requestLoggingConfig = _messages.MessageField('GoogleCloudMlV1RequestLoggingConfig', 22)
  routes = _messages.MessageField('GoogleCloudMlV1RouteMap', 23)
  runtimeVersion = _messages.StringField(24)
  serviceAccount = _messages.StringField(25)
  state = _messages.EnumField('StateValueValuesEnum', 26)


class GoogleCloudMlV1XraiAttribution(_messages.Message):
  r"""Attributes credit by computing the XRAI taking advantage of the model's
  fully differentiable structure. Refer to this paper for more details:
  https://arxiv.org/abs/1906.02825 Currently only implemented for models with
  natural image inputs.

  Fields:
    numIntegralSteps: Number of steps for approximating the path integral. A
      good value to start is 50 and gradually increase until the sum to diff
      property is met within the desired error range.
  """

  numIntegralSteps = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "sampleservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.   A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role.  Optionally, a
  `binding` can specify a `condition`, which is a logical expression that
  allows access to a resource only if the expression evaluates to `true`. A
  condition can add constraints based on attributes of the request, the
  resource, or both.  **JSON example:**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members":
  ["user:eve@example.com"],           "condition": {             "title":
  "expirable access",             "description": "Does not grant access after
  Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ],
  "etag": "BwWWja0YfJA=",       "version": 3     }  **YAML example:**
  bindings:     - members:       - user:mike@example.com       -
  group:admins@example.com       - domain:google.com       - serviceAccount
  :my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')     - etag: BwWWja0YfJA=     -
  version: 3  For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy.  Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected.  Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations:  * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy   that includes conditions  **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost.  If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset.
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)
  updateMask = _messages.StringField(2)


class GoogleIamV1TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.  Example (Comparison):
  title: "Summary size limit"     description: "Determines if a summary is
  less than 100 chars"     expression: "document.summary.size() < 100"
  Example (Equality):      title: "Requestor is owner"     description:
  "Determines if requestor is the document owner"     expression:
  "document.owner == request.auth.claims.email"  Example (Logic):      title:
  "Public documents"     description: "Determine whether the document should
  be publicly visible"     expression: "document.type != 'private' &&
  document.type != 'internal'"  Example (Data Manipulation):      title:
  "Notification string"     description: "Create a notification string with a
  timestamp."     expression: "'New message received at ' +
  string(document.create_time)"  The exact variables and functions that may be
  referenced within an expression are determined by the service that evaluates
  it. See the service documentation for additional information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class MlProjectsExplainRequest(_messages.Message):
  r"""A MlProjectsExplainRequest object.

  Fields:
    googleCloudMlV1ExplainRequest: A GoogleCloudMlV1ExplainRequest resource to
      be passed as the request body.
    name: Required. The resource name of a model or a version.  Authorization:
      requires the `predict` permission on the specified resource.
  """

  googleCloudMlV1ExplainRequest = _messages.MessageField('GoogleCloudMlV1ExplainRequest', 1)
  name = _messages.StringField(2, required=True)


class MlProjectsGetConfigRequest(_messages.Message):
  r"""A MlProjectsGetConfigRequest object.

  Fields:
    name: Required. The project name.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsJobsCancelRequest(_messages.Message):
  r"""A MlProjectsJobsCancelRequest object.

  Fields:
    googleCloudMlV1CancelJobRequest: A GoogleCloudMlV1CancelJobRequest
      resource to be passed as the request body.
    name: Required. The name of the job to cancel.
  """

  googleCloudMlV1CancelJobRequest = _messages.MessageField('GoogleCloudMlV1CancelJobRequest', 1)
  name = _messages.StringField(2, required=True)


class MlProjectsJobsCreateRequest(_messages.Message):
  r"""A MlProjectsJobsCreateRequest object.

  Fields:
    googleCloudMlV1Job: A GoogleCloudMlV1Job resource to be passed as the
      request body.
    parent: Required. The project name.
  """

  googleCloudMlV1Job = _messages.MessageField('GoogleCloudMlV1Job', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsJobsGetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsJobsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MlProjectsJobsGetRequest(_messages.Message):
  r"""A MlProjectsJobsGetRequest object.

  Fields:
    name: Required. The name of the job to get the description of.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsJobsListRequest(_messages.Message):
  r"""A MlProjectsJobsListRequest object.

  Fields:
    filter: Optional. Specifies the subset of jobs to retrieve. You can filter
      on the value of one or more attributes of the job object. For example,
      retrieve jobs with a job identifier that starts with 'census':
      <p><code>gcloud ai-platform jobs list --filter='jobId:census*'</code>
      <p>List all failed jobs with names that start with 'rnn':
      <p><code>gcloud ai-platform jobs list --filter='jobId:rnn* AND
      state:FAILED'</code> <p>For more examples, see the guide to <a href
      ="/ml-engine/docs/tensorflow/monitor-training">monitoring jobs</a>.
    pageSize: Optional. The number of jobs to retrieve per "page" of results.
      If there are more remaining results than this number, the response
      message will contain a valid value in the `next_page_token` field.  The
      default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project for which to list jobs.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MlProjectsJobsPatchRequest(_messages.Message):
  r"""A MlProjectsJobsPatchRequest object.

  Fields:
    googleCloudMlV1Job: A GoogleCloudMlV1Job resource to be passed as the
      request body.
    name: Required. The job name.
    updateMask: Required. Specifies the path, relative to `Job`, of the field
      to update. To adopt etag mechanism, include `etag` field in the mask,
      and include the `etag` value in your job resource.  For example, to
      change the labels of a job, the `update_mask` parameter would be
      specified as `labels`, `etag`, and the `PATCH` request body would
      specify the new value, as follows:     {       "labels": {
      "owner": "Google",          "color": "Blue"       }       "etag":
      "33a64df551425fcc55e4d42a148795d9f25f89d4"     } If `etag` matches the
      one on the server, the labels of the job will be replaced with the given
      ones, and the server end `etag` will be recalculated.  Currently the
      only supported update masks are `labels` and `etag`.
  """

  googleCloudMlV1Job = _messages.MessageField('GoogleCloudMlV1Job', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MlProjectsJobsSetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsJobsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsJobsTestIamPermissionsRequest(_messages.Message):
  r"""A MlProjectsJobsTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsLocationsGetRequest(_messages.Message):
  r"""A MlProjectsLocationsGetRequest object.

  Fields:
    name: Required. The name of the location.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsLocationsListRequest(_messages.Message):
  r"""A MlProjectsLocationsListRequest object.

  Fields:
    pageSize: Optional. The number of locations to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project for which available locations
      are to be listed (since some locations might be whitelisted for specific
      projects).
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MlProjectsModelsCreateRequest(_messages.Message):
  r"""A MlProjectsModelsCreateRequest object.

  Fields:
    googleCloudMlV1Model: A GoogleCloudMlV1Model resource to be passed as the
      request body.
    parent: Required. The project name.
  """

  googleCloudMlV1Model = _messages.MessageField('GoogleCloudMlV1Model', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsModelsDeleteRequest(_messages.Message):
  r"""A MlProjectsModelsDeleteRequest object.

  Fields:
    name: Required. The name of the model.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsGetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsModelsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MlProjectsModelsGetRequest(_messages.Message):
  r"""A MlProjectsModelsGetRequest object.

  Fields:
    name: Required. The name of the model.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsListRequest(_messages.Message):
  r"""A MlProjectsModelsListRequest object.

  Fields:
    filter: Optional. Specifies the subset of models to retrieve.
    pageSize: Optional. The number of models to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project whose models are to be listed.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MlProjectsModelsPatchRequest(_messages.Message):
  r"""A MlProjectsModelsPatchRequest object.

  Fields:
    googleCloudMlV1Model: A GoogleCloudMlV1Model resource to be passed as the
      request body.
    name: Required. The project name.
    updateMask: Required. Specifies the path, relative to `Model`, of the
      field to update.  For example, to change the description of a model to
      "foo" and set its default version to "version_1", the `update_mask`
      parameter would be specified as `description`, `default_version.name`,
      and the `PATCH` request body would specify the new value, as follows:
      {       "description": "foo",       "defaultVersion": {
      "name":"version_1"       }     }  Currently the supported update masks
      are `description` and `default_version.name`.
  """

  googleCloudMlV1Model = _messages.MessageField('GoogleCloudMlV1Model', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MlProjectsModelsSetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsModelsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsModelsTestIamPermissionsRequest(_messages.Message):
  r"""A MlProjectsModelsTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsModelsVersionsCreateRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsCreateRequest object.

  Fields:
    googleCloudMlV1Version: A GoogleCloudMlV1Version resource to be passed as
      the request body.
    parent: Required. The name of the model.
  """

  googleCloudMlV1Version = _messages.MessageField('GoogleCloudMlV1Version', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsModelsVersionsDeleteRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsDeleteRequest object.

  Fields:
    name: Required. The name of the version. You can get the names of all the
      versions of a model by calling projects.models.versions.list.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsVersionsGetRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsGetRequest object.

  Fields:
    name: Required. The name of the version.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsVersionsListRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsListRequest object.

  Fields:
    filter: Optional. Specifies the subset of versions to retrieve.
    pageSize: Optional. The number of versions to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the model for which to list the version.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MlProjectsModelsVersionsPatchRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsPatchRequest object.

  Fields:
    googleCloudMlV1Version: A GoogleCloudMlV1Version resource to be passed as
      the request body.
    name: Required. The name of the model.
    updateMask: Required. Specifies the path, relative to `Version`, of the
      field to update. Must be present and non-empty.  For example, to change
      the description of a version to "foo", the `update_mask` parameter would
      be specified as `description`, and the `PATCH` request body would
      specify the new value, as follows:  ``` {   "description": "foo" } ```
      Currently the only supported update mask fields are `description`,
      `requestLoggingConfig`, `autoScaling.minNodes`, and
      `manualScaling.nodes`. However, you can only update
      `manualScaling.nodes` if the version uses a [Compute Engine (N1) machine
      type](/ml-engine/docs/machine-types-online-prediction).
  """

  googleCloudMlV1Version = _messages.MessageField('GoogleCloudMlV1Version', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MlProjectsModelsVersionsSetDefaultRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsSetDefaultRequest object.

  Fields:
    googleCloudMlV1SetDefaultVersionRequest: A
      GoogleCloudMlV1SetDefaultVersionRequest resource to be passed as the
      request body.
    name: Required. The name of the version to make the default for the model.
      You can get the names of all the versions of a model by calling
      projects.models.versions.list.
  """

  googleCloudMlV1SetDefaultVersionRequest = _messages.MessageField('GoogleCloudMlV1SetDefaultVersionRequest', 1)
  name = _messages.StringField(2, required=True)


class MlProjectsOperationsCancelRequest(_messages.Message):
  r"""A MlProjectsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsGetRequest(_messages.Message):
  r"""A MlProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsListRequest(_messages.Message):
  r"""A MlProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MlProjectsPredictRequest(_messages.Message):
  r"""A MlProjectsPredictRequest object.

  Fields:
    googleCloudMlV1PredictRequest: A GoogleCloudMlV1PredictRequest resource to
      be passed as the request body.
    name: Required. The resource name of a model or a version.  Authorization:
      requires the `predict` permission on the specified resource.
  """

  googleCloudMlV1PredictRequest = _messages.MessageField('GoogleCloudMlV1PredictRequest', 1)
  name = _messages.StringField(2, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
