"""Generated client library for gameservices version v1beta."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.gameservices.v1beta import gameservices_v1beta_messages as messages


class GameservicesV1beta(base_api.BaseApiClient):
  """Generated client library for service gameservices version v1beta."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://gameservices.googleapis.com/'
  MTLS_BASE_URL = u'https://gameservices.mtls.googleapis.com/'

  _PACKAGE = u'gameservices'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1beta'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'GameservicesV1beta'
  _URL_VERSION = u'v1beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new gameservices handle."""
    url = url or self.BASE_URL
    super(GameservicesV1beta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_gameServerDeployments_configs = self.ProjectsLocationsGameServerDeploymentsConfigsService(self)
    self.projects_locations_gameServerDeployments = self.ProjectsLocationsGameServerDeploymentsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_realms_gameServerClusters = self.ProjectsLocationsRealmsGameServerClustersService(self)
    self.projects_locations_realms = self.ProjectsLocationsRealmsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsGameServerDeploymentsConfigsService(base_api.BaseApiService):
    """Service class for the projects_locations_gameServerDeployments_configs resource."""

    _NAME = u'projects_locations_gameServerDeployments_configs'

    def __init__(self, client):
      super(GameservicesV1beta.ProjectsLocationsGameServerDeploymentsConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Game Server Config in a given project, Location, and Game.
Server Deployment. Game Server Configs are immutable, and are not applied
until referenced in the Game Server Deployment Rollout resource.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}/configs',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.configs.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'configId'],
        relative_path=u'v1beta/{+parent}/configs',
        request_field=u'gameServerConfig',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsConfigsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Game Server Config. The deletion will fail if the Game.
Server Config is referenced in a Game Server Deployment Rollout.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}/configs/{configsId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.gameServerDeployments.configs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsConfigsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Game Server Config.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GameServerConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}/configs/{configsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.configs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsConfigsGetRequest',
        response_type_name=u'GameServerConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Game Server Configs in a given project, Location, and Game Server.
Deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGameServerConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}/configs',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.configs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1beta/{+parent}/configs',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsConfigsListRequest',
        response_type_name=u'ListGameServerConfigsResponse',
        supports_download=False,
    )

  class ProjectsLocationsGameServerDeploymentsService(base_api.BaseApiService):
    """Service class for the projects_locations_gameServerDeployments resource."""

    _NAME = u'projects_locations_gameServerDeployments'

    def __init__(self, client):
      super(GameservicesV1beta.ProjectsLocationsGameServerDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Game Server Deployment in a given project and Location.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'deploymentId'],
        relative_path=u'v1beta/{+parent}/gameServerDeployments',
        request_field=u'gameServerDeployment',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Game Server Deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.gameServerDeployments.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def FetchDeploymentState(self, request, global_params=None):
      r"""Retrieves information about the current state of the Game Server.
Ddeployment. Gathers all the Agones fleets and Agones autoscalers,
including fleets running an older version of the Game Server Deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsFetchDeploymentStateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchDeploymentStateResponse) The response message.
      """
      config = self.GetMethodConfig('FetchDeploymentState')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchDeploymentState.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:fetchDeploymentState',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.fetchDeploymentState',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}:fetchDeploymentState',
        request_field=u'fetchDeploymentStateRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsFetchDeploymentStateRequest',
        response_type_name=u'FetchDeploymentStateResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Game Server Deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GameServerDeployment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsGetRequest',
        response_type_name=u'GameServerDeployment',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1beta/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def GetRollout(self, request, global_params=None):
      r"""Gets details a single Game Server Deployment Rollout.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsGetRolloutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GameServerDeploymentRollout) The response message.
      """
      config = self.GetMethodConfig('GetRollout')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRollout.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}/rollout',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.getRollout',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}/rollout',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsGetRolloutRequest',
        response_type_name=u'GameServerDeploymentRollout',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Game Server Deployments in a given project and Location.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGameServerDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1beta/{+parent}/gameServerDeployments',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsListRequest',
        response_type_name=u'ListGameServerDeploymentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a Game Server Deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.gameServerDeployments.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta/{+name}',
        request_field=u'gameServerDeployment',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def PreviewRollout(self, request, global_params=None):
      r"""Previews the Game Server Deployment Rollout. This API does not mutate the.
Rollout resource.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsPreviewRolloutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PreviewGameServerDeploymentRolloutResponse) The response message.
      """
      config = self.GetMethodConfig('PreviewRollout')
      return self._RunMethod(
          config, request, global_params=global_params)

    PreviewRollout.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}/rollout:preview',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.gameServerDeployments.previewRollout',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'previewTime', u'updateMask'],
        relative_path=u'v1beta/{+name}/rollout:preview',
        request_field=u'gameServerDeploymentRollout',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsPreviewRolloutRequest',
        response_type_name=u'PreviewGameServerDeploymentRolloutResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def UpdateRollout(self, request, global_params=None):
      r"""Patches a single Game Server Deployment Rollout.
The method will not return an error if the update does not affect any
existing realms. For example - if the default_game_server_config is changed
but all existing realms use the override, that is valid. Similarly, if a
non existing realm is explicitly called out in game_server_config_overrides
field, that will also not result in an error.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsUpdateRolloutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateRollout')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateRollout.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}/rollout',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.gameServerDeployments.updateRollout',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta/{+name}/rollout',
        request_field=u'gameServerDeploymentRollout',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsUpdateRolloutRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = u'projects_locations_operations'

    def __init__(self, client):
      super(GameservicesV1beta.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (GameservicesProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}:cancel',
        request_field=u'cancelOperationRequest',
        request_type_name=u'GameservicesProjectsLocationsOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is.
no longer interested in the operation result. It does not cancel the
operation. If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (GameservicesProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.operations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsOperationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (GameservicesProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (GameservicesProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/operations',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1beta/{+name}/operations',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRealmsGameServerClustersService(base_api.BaseApiService):
    """Service class for the projects_locations_realms_gameServerClusters resource."""

    _NAME = u'projects_locations_realms_gameServerClusters'

    def __init__(self, client):
      super(GameservicesV1beta.ProjectsLocationsRealmsGameServerClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new game server cluster in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'gameServerClusterId'],
        relative_path=u'v1beta/{+parent}/gameServerClusters',
        request_field=u'gameServerCluster',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single game server cluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single game server cluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GameServerCluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersGetRequest',
        response_type_name=u'GameServerCluster',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Game Server Clusters in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGameServerClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1beta/{+parent}/gameServerClusters',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersListRequest',
        response_type_name=u'ListGameServerClustersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a single game server cluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta/{+name}',
        request_field=u'gameServerCluster',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def PreviewCreate(self, request, global_params=None):
      r"""Previews creation of a new game server cluster in a given project and.
location.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersPreviewCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PreviewCreateGameServerClusterResponse) The response message.
      """
      config = self.GetMethodConfig('PreviewCreate')
      return self._RunMethod(
          config, request, global_params=global_params)

    PreviewCreate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters:previewCreate',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.previewCreate',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'gameServerClusterId', u'previewTime'],
        relative_path=u'v1beta/{+parent}/gameServerClusters:previewCreate',
        request_field=u'gameServerCluster',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersPreviewCreateRequest',
        response_type_name=u'PreviewCreateGameServerClusterResponse',
        supports_download=False,
    )

    def PreviewDelete(self, request, global_params=None):
      r"""Previews deletion of a single game server cluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersPreviewDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PreviewDeleteGameServerClusterResponse) The response message.
      """
      config = self.GetMethodConfig('PreviewDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    PreviewDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}:previewDelete',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.previewDelete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'previewTime'],
        relative_path=u'v1beta/{+name}:previewDelete',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersPreviewDeleteRequest',
        response_type_name=u'PreviewDeleteGameServerClusterResponse',
        supports_download=False,
    )

    def PreviewUpdate(self, request, global_params=None):
      r"""Previews updating a GameServerCluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersPreviewUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PreviewUpdateGameServerClusterResponse) The response message.
      """
      config = self.GetMethodConfig('PreviewUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    PreviewUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}:previewUpdate',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.previewUpdate',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'previewTime', u'updateMask'],
        relative_path=u'v1beta/{+name}:previewUpdate',
        request_field=u'gameServerCluster',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersPreviewUpdateRequest',
        response_type_name=u'PreviewUpdateGameServerClusterResponse',
        supports_download=False,
    )

  class ProjectsLocationsRealmsService(base_api.BaseApiService):
    """Service class for the projects_locations_realms resource."""

    _NAME = u'projects_locations_realms'

    def __init__(self, client):
      super(GameservicesV1beta.ProjectsLocationsRealmsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Realm in a given project and Location.

      Args:
        request: (GameservicesProjectsLocationsRealmsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.realms.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'realmId'],
        relative_path=u'v1beta/{+parent}/realms',
        request_field=u'realm',
        request_type_name=u'GameservicesProjectsLocationsRealmsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Realm.

      Args:
        request: (GameservicesProjectsLocationsRealmsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.realms.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Realm.

      Args:
        request: (GameservicesProjectsLocationsRealmsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Realm) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGetRequest',
        response_type_name=u'Realm',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Realms in a given project and Location.

      Args:
        request: (GameservicesProjectsLocationsRealmsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRealmsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1beta/{+parent}/realms',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsListRequest',
        response_type_name=u'ListRealmsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a single Realm.

      Args:
        request: (GameservicesProjectsLocationsRealmsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.realms.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta/{+name}',
        request_field=u'realm',
        request_type_name=u'GameservicesProjectsLocationsRealmsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def PreviewUpdate(self, request, global_params=None):
      r"""Previews patches to a single Realm.

      Args:
        request: (GameservicesProjectsLocationsRealmsPreviewUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PreviewRealmUpdateResponse) The response message.
      """
      config = self.GetMethodConfig('PreviewUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    PreviewUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}:previewUpdate',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.realms.previewUpdate',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'previewTime', u'updateMask'],
        relative_path=u'v1beta/{+name}:previewUpdate',
        request_field=u'realm',
        request_type_name=u'GameservicesProjectsLocationsRealmsPreviewUpdateRequest',
        response_type_name=u'PreviewRealmUpdateResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(GameservicesV1beta.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (GameservicesProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (GameservicesProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'includeUnrevealedLocations', u'pageSize', u'pageToken'],
        relative_path=u'v1beta/{+name}/locations',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(GameservicesV1beta.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
