"""Generated client library for composerflex version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.composerflex.v1alpha1 import composerflex_v1alpha1_messages as messages


class ComposerflexV1alpha1(base_api.BaseApiClient):
  """Generated client library for service composerflex version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://composerflex.googleapis.com/'
  MTLS_BASE_URL = u''

  _PACKAGE = u'composerflex'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ComposerflexV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new composerflex handle."""
    url = url or self.BASE_URL
    super(ComposerflexV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_contexts = self.ProjectsLocationsContextsService(self)
    self.projects_locations_workflows_runs = self.ProjectsLocationsWorkflowsRunsService(self)
    self.projects_locations_workflows = self.ProjectsLocationsWorkflowsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsContextsService(base_api.BaseApiService):
    """Service class for the projects_locations_contexts resource."""

    _NAME = u'projects_locations_contexts'

    def __init__(self, client):
      super(ComposerflexV1alpha1.ProjectsLocationsContextsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new context.

      Args:
        request: (ComposerflexProjectsLocationsContextsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/contexts',
        http_method=u'POST',
        method_id=u'composerflex.projects.locations.contexts.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/contexts',
        request_field=u'context',
        request_type_name=u'ComposerflexProjectsLocationsContextsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a context. A context cannot be deleted if any workflows are bound.
to it.

      Args:
        request: (ComposerflexProjectsLocationsContextsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/contexts/{contextsId}',
        http_method=u'DELETE',
        method_id=u'composerflex.projects.locations.contexts.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsContextsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a context.

      Args:
        request: (ComposerflexProjectsLocationsContextsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Context) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/contexts/{contextsId}',
        http_method=u'GET',
        method_id=u'composerflex.projects.locations.contexts.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsContextsGetRequest',
        response_type_name=u'Context',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists contexts within a project and location.

      Args:
        request: (ComposerflexProjectsLocationsContextsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListContextsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/contexts',
        http_method=u'GET',
        method_id=u'composerflex.projects.locations.contexts.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/contexts',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsContextsListRequest',
        response_type_name=u'ListContextsResponse',
        supports_download=False,
    )

  class ProjectsLocationsWorkflowsRunsService(base_api.BaseApiService):
    """Service class for the projects_locations_workflows_runs resource."""

    _NAME = u'projects_locations_workflows_runs'

    def __init__(self, client):
      super(ComposerflexV1alpha1.ProjectsLocationsWorkflowsRunsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Retrieves a workflow run.

      Args:
        request: (ComposerflexProjectsLocationsWorkflowsRunsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WorkflowRun) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/runs/{runsId}',
        http_method=u'GET',
        method_id=u'composerflex.projects.locations.workflows.runs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsWorkflowsRunsGetRequest',
        response_type_name=u'WorkflowRun',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists runs of a workflow in a project and location.
If the workflow is set to the wildcard "-", then workflow runs from all
workflows in the project and location will be listed.

      Args:
        request: (ComposerflexProjectsLocationsWorkflowsRunsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkflowRunsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/runs',
        http_method=u'GET',
        method_id=u'composerflex.projects.locations.workflows.runs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/runs',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsWorkflowsRunsListRequest',
        response_type_name=u'ListWorkflowRunsResponse',
        supports_download=False,
    )

  class ProjectsLocationsWorkflowsService(base_api.BaseApiService):
    """Service class for the projects_locations_workflows resource."""

    _NAME = u'projects_locations_workflows'

    def __init__(self, client):
      super(ComposerflexV1alpha1.ProjectsLocationsWorkflowsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a workflow from an Airflow DAG.

      Args:
        request: (ComposerflexProjectsLocationsWorkflowsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/workflows',
        http_method=u'POST',
        method_id=u'composerflex.projects.locations.workflows.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/workflows',
        request_field=u'workflow',
        request_type_name=u'ComposerflexProjectsLocationsWorkflowsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a workflow, forcefully stopping any pending workflow runs and task.
instances. Long-running operations executing in external systems will
continue.

      Args:
        request: (ComposerflexProjectsLocationsWorkflowsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}',
        http_method=u'DELETE',
        method_id=u'composerflex.projects.locations.workflows.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsWorkflowsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a workflow.

      Args:
        request: (ComposerflexProjectsLocationsWorkflowsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workflow) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}',
        http_method=u'GET',
        method_id=u'composerflex.projects.locations.workflows.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsWorkflowsGetRequest',
        response_type_name=u'Workflow',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists workflows in a project and location.

      Args:
        request: (ComposerflexProjectsLocationsWorkflowsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkflowsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/workflows',
        http_method=u'GET',
        method_id=u'composerflex.projects.locations.workflows.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/workflows',
        request_field='',
        request_type_name=u'ComposerflexProjectsLocationsWorkflowsListRequest',
        response_type_name=u'ListWorkflowsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(ComposerflexV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ComposerflexV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
