"""Generated message classes for cloudidentity version v1beta1.

API for provisioning and managing identity resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudidentity'


class AndroidAttributes(_messages.Message):
  r"""A AndroidAttributes object.

  Enums:
    EncryptionStateValueValuesEnum: Device encryption state.
    OwnershipPrivilegeValueValuesEnum: Ownership privileges on device.

  Fields:
    basebandVersion: Baseband version of Android device.
    bootloaderVersion: Device bootloader version. Example: 0.6.7.
    buildNumber: Build number of Android device.
    enabledDeveloperOptions: Whether developer options is enabled on device.
    enabledUnknownSources: Whether applications from unknown sources can be
      installed on device.
    enabledUsbDebugging: Whether adb (USB debugging) is enabled on device.
    encryptionState: Device encryption state.
    hardware: Device hardware. Example: Sprout.
    kernelVersion: Kernel version of Android device.
    otherAccounts: Domain name for Google accounts on device. Type for other
      accounts on device. Will only be populated if |ownership_privilege| is
      |PROFILE_OWNER| or |DEVICE_OWNER|. Does not include the account signed
      in to the device policy app if that account's domain has only one
      account. Examples: "com.example", "xyz.com".
    ownerProfileAccount: Whether this account is on an owner/primary profile.
      For phones, only true for owner profiles. Tablets above JB_MR can have
      secondary or restricted user profiles.
    ownershipPrivilege: Ownership privileges on device.
    securityPatchTime: OS security patch update time on device.
    supportsWorkProfile: Whether device supports Android work profiles. If
      false, this service will not block access to corp data even if an
      administrator turns on the "Enforce Work Profile" policy.
  """

  class EncryptionStateValueValuesEnum(_messages.Enum):
    r"""Device encryption state.

    Values:
      ENCRYPTION_STATE_UNSPECIFIED: Encryption Status is not set.
      UNSUPPORTED_BY_DEVICE: Device doesn't support encryption.
      ENCRYPTED: Device is encrypted.
      NOT_ENCRYPTED: Device is not encrypted.
    """
    ENCRYPTION_STATE_UNSPECIFIED = 0
    UNSUPPORTED_BY_DEVICE = 1
    ENCRYPTED = 2
    NOT_ENCRYPTED = 3

  class OwnershipPrivilegeValueValuesEnum(_messages.Enum):
    r"""Ownership privileges on device.

    Values:
      OWNERSHIP_PRIVILEGE_UNSPECIFIED: Ownership privilege is not set.
      DEVICE_ADMINISTRATOR: Active device administrator privileges on the
        device.
      PROFILE_OWNER: Profile Owner privileges. The account is in a managed
        corporate profile.
      DEVICE_OWNER: Device Owner privileges on the device.
    """
    OWNERSHIP_PRIVILEGE_UNSPECIFIED = 0
    DEVICE_ADMINISTRATOR = 1
    PROFILE_OWNER = 2
    DEVICE_OWNER = 3

  basebandVersion = _messages.StringField(1)
  bootloaderVersion = _messages.StringField(2)
  buildNumber = _messages.StringField(3)
  enabledDeveloperOptions = _messages.BooleanField(4)
  enabledUnknownSources = _messages.BooleanField(5)
  enabledUsbDebugging = _messages.BooleanField(6)
  encryptionState = _messages.EnumField('EncryptionStateValueValuesEnum', 7)
  hardware = _messages.StringField(8)
  kernelVersion = _messages.StringField(9)
  otherAccounts = _messages.StringField(10, repeated=True)
  ownerProfileAccount = _messages.BooleanField(11)
  ownershipPrivilege = _messages.EnumField('OwnershipPrivilegeValueValuesEnum', 12)
  securityPatchTime = _messages.StringField(13)
  supportsWorkProfile = _messages.BooleanField(14)


class ClientContext(_messages.Message):
  r"""Information related to the caller client.

  Fields:
    appId: [Optional] Identifier of the application. e.g., "com.google.Drive"
    clientVersion: The name and the version of the client. e.g. "DXP 1.0"
    iosVendorId: Vendor id of the ios device.
    osVersion: [Optional] OS version on which the client app is running. e.g.,
      "iOS 12.1"
  """

  appId = _messages.StringField(1)
  clientVersion = _messages.StringField(2)
  iosVendorId = _messages.StringField(3)
  osVersion = _messages.StringField(4)


class CloudidentityDevicesAccountWipeRequest(_messages.Message):
  r"""A CloudidentityDevicesAccountWipeRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    device: [Device resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_resource_id}`, where device_resource_id is
      the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  device = _messages.StringField(2, required=True)


class CloudidentityDevicesApproveRequest(_messages.Message):
  r"""A CloudidentityDevicesApproveRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Device in format: `devices/{device_resource_id}`, where
      device_resource_id is the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesBlockRequest(_messages.Message):
  r"""A CloudidentityDevicesBlockRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Device in format: `devices/{device_resource_id}`, where
      device_resource_id is the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesCancelWipeRequest(_messages.Message):
  r"""A CloudidentityDevicesCancelWipeRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Device in format: `devices/{device_resource_id}`, where
      device_resource_id is the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeleteRequest(_messages.Message):
  r"""A CloudidentityDevicesDeleteRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Device in format: `devices/{device_resource_id}`, where
      device_resource_id is the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesGetRequest(_messages.Message):
  r"""A CloudidentityDevicesGetRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Device in format: `devices/{device_resource_id}`, where
      device_resource_id is the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesGetSettingsRequest(_messages.Message):
  r"""A CloudidentityDevicesGetSettingsRequest object.

  Fields:
    clientContext_appId: [Optional] Identifier of the application. e.g.,
      "com.google.Drive"
    clientContext_clientVersion: The name and the version of the client. e.g.
      "DXP 1.0"
    clientContext_iosVendorId: Vendor id of the ios device.
    clientContext_osVersion: [Optional] OS version on which the client app is
      running. e.g., "iOS 12.1"
    resourceId: Resource id of the entity for which the settings are
      requested.
  """

  clientContext_appId = _messages.StringField(1)
  clientContext_clientVersion = _messages.StringField(2)
  clientContext_iosVendorId = _messages.StringField(3)
  clientContext_osVersion = _messages.StringField(4)
  resourceId = _messages.StringField(5, required=True)


class CloudidentityDevicesListRequest(_messages.Message):
  r"""A CloudidentityDevicesListRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer who owns the devices being listed. For querying your own
      customer, pass `customers/my_customer`
    filter: Additional restrictions when fetching list of devices. HC article:
      {@link https://support.google.com/a/answer/7549103}
    orderBy: Order specification for devices in the response.
    pageSize: Maximum number of devices to list. If zero, a default page size
      is used.
    pageToken: page_token to get subsequent pages in the response starting at
      this token. This should be filled with the value provided by a previous
      call to ListDevices.
  """

  customer = _messages.StringField(1)
  filter = _messages.StringField(2)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class CloudidentityDevicesPatchRequest(_messages.Message):
  r"""A CloudidentityDevicesPatchRequest object.

  Fields:
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_resource_id}`, where device_resource_id is
      the unique id assigned to the Device.  Must be left blank while creating
      a Device.
    updateDeviceRequest: A UpdateDeviceRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateDeviceRequest = _messages.MessageField('UpdateDeviceRequest', 2)


class CloudidentityDevicesRingRequest(_messages.Message):
  r"""A CloudidentityDevicesRingRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Device in format: `devices/{device_resource_id}`, where
      device_resource_id is the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesSettingsRequest(_messages.Message):
  r"""A CloudidentityDevicesSettingsRequest object.

  Fields:
    getEffectiveSettingsRequest: A GetEffectiveSettingsRequest resource to be
      passed as the request body.
    resourceId: Resource id of the entity for which the settings are
      requested.
  """

  getEffectiveSettingsRequest = _messages.MessageField('GetEffectiveSettingsRequest', 1)
  resourceId = _messages.StringField(2, required=True)


class CloudidentityDevicesWipeRequest(_messages.Message):
  r"""A CloudidentityDevicesWipeRequest object.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Device in format: `devices/{device_resource_id}`, where
      device_resource_id is the unique ID assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityGroupsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsCreateRequest object.

  Enums:
    InitialGroupConfigValueValuesEnum: Required. The initial configuration
      option for the `Group`.

  Fields:
    group: A Group resource to be passed as the request body.
    initialGroupConfig: Required. The initial configuration option for the
      `Group`.
  """

  class InitialGroupConfigValueValuesEnum(_messages.Enum):
    r"""Required. The initial configuration option for the `Group`.

    Values:
      INITIAL_GROUP_CONFIG_UNSPECIFIED: <no description>
      WITH_INITIAL_OWNER: <no description>
      EMPTY: <no description>
    """
    INITIAL_GROUP_CONFIG_UNSPECIFIED = 0
    WITH_INITIAL_OWNER = 1
    EMPTY = 2

  group = _messages.MessageField('Group', 1)
  initialGroupConfig = _messages.EnumField('InitialGroupConfigValueValuesEnum', 2)


class CloudidentityGroupsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsDeleteRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group` to retrieve.  Must be of the form `groups/{group_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsGetRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group` to retrieve.  Must be of the form `groups/{group_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsListRequest(_messages.Message):
  r"""A CloudidentityGroupsListRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned.  If unspecified,
      defaults to `View.BASIC`.

  Fields:
    pageSize: The maximum number of results to return.  Note that the number
      of results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`.  If unspecified, defaults to 200 for `View.BASIC` and
      to 50 for `View.FULL`.  Must not be greater than 1000 for `View.BASIC`
      or 500 for `View.FULL`.
    pageToken: The `next_page_token` value returned from a previous list
      request, if any.
    parent: Required. The parent resource under which to list all `Group`s.
      Must be of the form `identitysources/{identity_source_id}` for external-
      identity-mapped groups or `customers/{customer_id}` for Google Groups.
    view: The level of detail to be returned.  If unspecified, defaults to
      `View.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned.  If unspecified, defaults to
    `View.BASIC`.

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsLookupRequest object.

  Fields:
    groupKey_id: The ID of the entity.  For Google-managed entities, the `id`
      must be the email address of an existing group or user.  For external-
      identity-mapped entities, the `id` must be a string conforming to the
      Identity Source's requirements.  Must be unique within a `namespace`.
    groupKey_namespace: The namespace in which the entity exists.  If not
      specified, the `EntityKey` represents a Google-managed entity such as a
      Google user or a Google Group.  If specified, the `EntityKey` represents
      an external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console. Must be of the form
      `identitysources/{identity_source_id}.
  """

  groupKey_id = _messages.StringField(1)
  groupKey_namespace = _messages.StringField(2)


class CloudidentityGroupsMembershipsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsCreateRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    parent: Required. The parent `Group` resource under which to create the
      `Membership`.  Must be of the form `groups/{group_id}`.
  """

  membership = _messages.MessageField('Membership', 1)
  parent = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsDeleteRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` to delete.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsGetRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` to retrieve.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsListRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsListRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned.  If unspecified,
      defaults to `MembershipView.BASIC`.

  Fields:
    pageSize: The maximum number of results to return.  Note that the number
      of results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`.  If unspecified, defaults to 200 for
      `GroupView.BASIC` and to 50 for `GroupView.FULL`.  Must not be greater
      than 1000 for `GroupView.BASIC` or 500 for `GroupView.FULL`.
    pageToken: The `next_page_token` value returned from a previous search
      request, if any.
    parent: Required. The parent `Group` resource under which to lookup the
      `Membership` name.  Must be of the form `groups/{group_id}`.
    view: The level of detail to be returned.  If unspecified, defaults to
      `MembershipView.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned.  If unspecified, defaults to
    `MembershipView.BASIC`.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsMembershipsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsLookupRequest object.

  Fields:
    memberKey_id: The ID of the entity.  For Google-managed entities, the `id`
      must be the email address of an existing group or user.  For external-
      identity-mapped entities, the `id` must be a string conforming to the
      Identity Source's requirements.  Must be unique within a `namespace`.
    memberKey_namespace: The namespace in which the entity exists.  If not
      specified, the `EntityKey` represents a Google-managed entity such as a
      Google user or a Google Group.  If specified, the `EntityKey` represents
      an external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console. Must be of the form
      `identitysources/{identity_source_id}.
    parent: Required. The parent `Group` resource under which to lookup the
      `Membership` name.  Must be of the form `groups/{group_id}`.
  """

  memberKey_id = _messages.StringField(1)
  memberKey_namespace = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudidentityGroupsMembershipsModifyMembershipRolesRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsModifyMembershipRolesRequest object.

  Fields:
    modifyMembershipRolesRequest: A ModifyMembershipRolesRequest resource to
      be passed as the request body.
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` whose roles are to be modified.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  modifyMembershipRolesRequest = _messages.MessageField('ModifyMembershipRolesRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsPatchRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership`.  Shall be of the form
      `groups/{group_id}/memberships/{membership_id}`.
    updateMask: Required. The fully-qualified names of fields to update.
  """

  membership = _messages.MessageField('Membership', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsPatchRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group`.  Shall be of the form `groups/{group_id}`.
    updateMask: Required. The fully-qualified names of fields to update.  May
      only contain the following fields: `display_name`, `description`.
  """

  group = _messages.MessageField('Group', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsSearchRequest(_messages.Message):
  r"""A CloudidentityGroupsSearchRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned.  If unspecified,
      defaults to `View.BASIC`.

  Fields:
    pageSize: The maximum number of results to return.  Note that the number
      of results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`.  If unspecified, defaults to 200 for
      `GroupView.BASIC` and to 50 for `GroupView.FULL`.  Must not be greater
      than 1000 for `GroupView.BASIC` or 500 for `GroupView.FULL`.
    pageToken: The `next_page_token` value returned from a previous search
      request, if any.
    query: Required. The search query.  Must be specified in [Common
      Expression Language](https://opensource.google/projects/cel). May only
      contain equality operators on the parent and inclusion operators on
      labels (e.g., `parent == 'customers/{customer_id}' &&
      'cloudidentity.googleapis.com/groups.discussion_forum' in labels`).
    view: The level of detail to be returned.  If unspecified, defaults to
      `View.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned.  If unspecified, defaults to
    `View.BASIC`.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  query = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CustomDeviceAttributeValue(_messages.Message):
  r"""A CustomDeviceAttributeValue object.

  Fields:
    boolValue: Represents a boolean value.
    numberValue: Represents a double value.
    stringValue: Represents a string value.
  """

  boolValue = _messages.BooleanField(1)
  numberValue = _messages.FloatField(2)
  stringValue = _messages.StringField(3)


class CustomDeviceAttributes(_messages.Message):
  r"""A CustomDeviceAttributes object.

  Enums:
    CompositeScoreValueValuesEnum:

  Messages:
    AttributesValue: The map of key-value attributes stored by a third-party
      specific to a device. The total serialized length of this map may not
      exceed 100KB. No limit is placed on the number of attributes in a map.

  Fields:
    attributes: The map of key-value attributes stored by a third-party
      specific to a device. The total serialized length of this map may not
      exceed 100KB. No limit is placed on the number of attributes in a map.
    compositeScore: A CompositeScoreValueValuesEnum attribute.
    customDeviceId: The device identifier provided by the caller.
    scoreReason: A descriptive cause of the score.
  """

  class CompositeScoreValueValuesEnum(_messages.Enum):
    r"""CompositeScoreValueValuesEnum enum type.

    Values:
      UNKNOWN: <no description>
      EXTREME: <no description>
      VERY_HIGH: <no description>
      HIGH: <no description>
      MEDIUM: <no description>
      MODERATE: <no description>
      LOW: <no description>
      VERY_LOW: <no description>
      NONE: <no description>
    """
    UNKNOWN = 0
    EXTREME = 1
    VERY_HIGH = 2
    HIGH = 3
    MEDIUM = 4
    MODERATE = 5
    LOW = 6
    VERY_LOW = 7
    NONE = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""The map of key-value attributes stored by a third-party specific to a
    device. The total serialized length of this map may not exceed 100KB. No
    limit is placed on the number of attributes in a map.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A CustomDeviceAttributeValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('CustomDeviceAttributeValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)
  compositeScore = _messages.EnumField('CompositeScoreValueValuesEnum', 2)
  customDeviceId = _messages.StringField(3)
  scoreReason = _messages.StringField(4)


class CustomDeviceData(_messages.Message):
  r"""A CustomDeviceData object.

  Fields:
    createdTime: Output only. The time the custom device data was created.
    customDeviceAttributes: Custom attributes of the device.
    lastUpdatedTime: Output only. The time the custom device data was last
      updated.
  """

  createdTime = _messages.StringField(1)
  customDeviceAttributes = _messages.MessageField('CustomDeviceAttributes', 2)
  lastUpdatedTime = _messages.StringField(3)


class Device(_messages.Message):
  r"""Resource representing a Device. Next ID to use: 23

  Enums:
    CompromisedStateValueValuesEnum: Output only. Whether the device is
      rooted.
    DevicePasswordStateValueValuesEnum: Output only. Whether device is
      secured, either with a PIN or with a password.
    ManagementStateValueValuesEnum: Output only. Management state of device.
    TypeValueValuesEnum: Output only. Type of device.

  Fields:
    androidSpecificAttributes: Output only.
    brand: Output only. Device brand. Example: Samsung.
    compromisedState: Output only. Whether the device is rooted.
    customDeviceData: Custom data about the device containing attributes that
      may be updated.
    devicePasswordState: Output only. Whether device is secured, either with a
      PIN or with a password.
    firstSyncTime: Output only. Most recent time when device was "registered"
      with this service.
    imei: Output only. IMEI number of device if GSM device; empty otherwise.
      Example: 358240051111110.
    languageCode: Output only. Default locale used on device.
    lastSyncTime: Output only. Last time that device is synced with policies.
    managementState: Output only. Management state of device.
    manufacturer: Output only. Device manufacturer. Example: Motorola.
    meid: Output only. MEID number of device if CDMA device; empty otherwise.
    model: Output only. Model name of device. Example: Pixel 3.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_resource_id}`, where device_resource_id is
      the unique id assigned to the Device.  Must be left blank while creating
      a Device.
    networkOperator: Output only. Mobile or network operator of device, if
      available.
    os: Output only. Operating system of device. Examples: iOS 11.2, Android
      8.1.0.
    releaseVersion: Output only. OS release version. Example: 6.0.
    serialNumber: Output only. Serial Number of device. Example: HT82V1A01076.
    type: Output only. Type of device.
    userAgent: Output only. User Agent. Example for iOS: Apple-
      iPhone1C2/808.7,gzip(gfe). Example for android: Google Apps Device
      Policy 4.08.
    userEmail: Output only. E-mail address of user logged into device.
    wifiMacAddresses: Output only. WiFi MAC address of device.
  """

  class CompromisedStateValueValuesEnum(_messages.Enum):
    r"""Output only. Whether the device is rooted.

    Values:
      COMPROMISED_STATE_UNSPECIFIED: <no description>
      COMPROMISED: <no description>
      NOT_COMPROMISED: <no description>
    """
    COMPROMISED_STATE_UNSPECIFIED = 0
    COMPROMISED = 1
    NOT_COMPROMISED = 2

  class DevicePasswordStateValueValuesEnum(_messages.Enum):
    r"""Output only. Whether device is secured, either with a PIN or with a
    password.

    Values:
      PASSWORD_STATE_UNSPECIFIED: Password state not set.
      PASSWORD_SET: Password set in device.
      PASSWORD_NOT_SET: Password not set in device.
    """
    PASSWORD_STATE_UNSPECIFIED = 0
    PASSWORD_SET = 1
    PASSWORD_NOT_SET = 2

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. Management state of device.

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: <no description>
      ACCOUNT_WIPED: <no description>
      ACCOUNT_WIPING: <no description>
      APPROVED: <no description>
      BLOCKED: <no description>
      PENDING: <no description>
      UNPROVISIONED: <no description>
      DEVICE_WIPED: <no description>
      DEVICE_WIPING: <no description>
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    ACCOUNT_WIPED = 1
    ACCOUNT_WIPING = 2
    APPROVED = 3
    BLOCKED = 4
    PENDING = 5
    UNPROVISIONED = 6
    DEVICE_WIPED = 7
    DEVICE_WIPING = 8

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of device.

    Values:
      TYPE_UNSPECIFIED: <no description>
      ANDROID: <no description>
      IOS: <no description>
      GOOGLE_SYNC: <no description>
      WINDOWS: <no description>
      MAC_OS: <no description>
      LINUX: <no description>
      CHROME_OS: <no description>
    """
    TYPE_UNSPECIFIED = 0
    ANDROID = 1
    IOS = 2
    GOOGLE_SYNC = 3
    WINDOWS = 4
    MAC_OS = 5
    LINUX = 6
    CHROME_OS = 7

  androidSpecificAttributes = _messages.MessageField('AndroidAttributes', 1)
  brand = _messages.StringField(2)
  compromisedState = _messages.EnumField('CompromisedStateValueValuesEnum', 3)
  customDeviceData = _messages.MessageField('CustomDeviceData', 4)
  devicePasswordState = _messages.EnumField('DevicePasswordStateValueValuesEnum', 5)
  firstSyncTime = _messages.StringField(6)
  imei = _messages.StringField(7)
  languageCode = _messages.StringField(8)
  lastSyncTime = _messages.StringField(9)
  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 10)
  manufacturer = _messages.StringField(11)
  meid = _messages.StringField(12)
  model = _messages.StringField(13)
  name = _messages.StringField(14)
  networkOperator = _messages.StringField(15)
  os = _messages.StringField(16)
  releaseVersion = _messages.StringField(17)
  serialNumber = _messages.StringField(18)
  type = _messages.EnumField('TypeValueValuesEnum', 19)
  userAgent = _messages.StringField(20)
  userEmail = _messages.StringField(21)
  wifiMacAddresses = _messages.StringField(22, repeated=True)


class EffectiveSetting(_messages.Message):
  r"""A EffectiveSetting object.

  Fields:
    mamDataProtectionSetting: A MamDataProtectionSetting attribute.
  """

  mamDataProtectionSetting = _messages.MessageField('MamDataProtectionSetting', 1)


class EntityKey(_messages.Message):
  r"""A unique identifier for an entity in the Cloud Identity Groups API.  An
  entity can represent either a group with an optional `namespace` or a user
  without a `namespace`. The combination of `id` and `namespace` must be
  unique; however, the same `id` can be used with different `namespace`s.

  Fields:
    id: The ID of the entity.  For Google-managed entities, the `id` must be
      the email address of an existing group or user.  For external-identity-
      mapped entities, the `id` must be a string conforming to the Identity
      Source's requirements.  Must be unique within a `namespace`.
    namespace: The namespace in which the entity exists.  If not specified,
      the `EntityKey` represents a Google-managed entity such as a Google user
      or a Google Group.  If specified, the `EntityKey` represents an
      external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console. Must be of the form
      `identitysources/{identity_source_id}.
  """

  id = _messages.StringField(1)
  namespace = _messages.StringField(2)


class ExpiryDetail(_messages.Message):
  r"""The `MembershipRole` expiry details.

  Fields:
    expireTime: The time at which the `MembershipRole` will expire.
  """

  expireTime = _messages.StringField(1)


class GetEffectiveSettingsRequest(_messages.Message):
  r"""A GetEffectiveSettingsRequest object.

  Fields:
    clientContext: Context of the caller client.
  """

  clientContext = _messages.MessageField('ClientContext', 1)


class GetEffectiveSettingsResponse(_messages.Message):
  r"""A GetEffectiveSettingsResponse object.

  Fields:
    effectiveSetting: A EffectiveSetting attribute.
    resourceId: Resource id of the device.
  """

  effectiveSetting = _messages.MessageField('EffectiveSetting', 1)
  resourceId = _messages.StringField(2)


class Group(_messages.Message):
  r"""A group within the Cloud Identity Groups API.  A `Group` is a collection
  of entities, where each entity is either a user or another group.

  Messages:
    LabelsValue: Required. The labels that apply to the `Group`.  Must not
      contain more than one entry. Must contain the entry
      `'cloudidentity.googleapis.com/groups.discussion_forum': ''` if the
      `Group` is a Google Group or `'system/groups/external': ''` if the
      `Group` is an external-identity-mapped group.

  Fields:
    additionalGroupKeys: Optional. Additional entity key aliases for a Group.
    createTime: Output only. The time when the `Group` was created.
    description: An extended description to help users determine the purpose
      of a `Group`.  Must not be longer than 4,096 characters.
    displayName: The display name of the `Group`.
    groupKey: Required. Immutable. The `EntityKey` of the `Group`.
    labels: Required. The labels that apply to the `Group`.  Must not contain
      more than one entry. Must contain the entry
      `'cloudidentity.googleapis.com/groups.discussion_forum': ''` if the
      `Group` is a Google Group or `'system/groups/external': ''` if the
      `Group` is an external-identity-mapped group.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group`.  Shall be of the form `groups/{group_id}`.
    parent: Required. Immutable. The resource name of the entity under which
      this `Group` resides in the Cloud Identity resource hierarchy.  Must be
      of the form `identitysources/{identity_source_id}` for external-
      identity-mapped groups or `customers/{customer_id}` for Google Groups.
    updateTime: Output only. The time when the `Group` was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Required. The labels that apply to the `Group`.  Must not contain more
    than one entry. Must contain the entry
    `'cloudidentity.googleapis.com/groups.discussion_forum': ''` if the
    `Group` is a Google Group or `'system/groups/external': ''` if the `Group`
    is an external-identity-mapped group.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalGroupKeys = _messages.MessageField('EntityKey', 1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  groupKey = _messages.MessageField('EntityKey', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  parent = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class ListDevicesResponse(_messages.Message):
  r"""Response message that is returned in LRO result of ListDevices
  Operation.

  Fields:
    devices: Devices meeting the list restrictions.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  devices = _messages.MessageField('Device', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGroupsResponse(_messages.Message):
  r"""The response message for GroupsService.ListGroups.

  Fields:
    groups: The `Group`s under the specified `parent`.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMembershipsResponse(_messages.Message):
  r"""The response message for MembershipsService.ListMemberships.

  Fields:
    memberships: The `Membership`s under the specified `parent`.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  memberships = _messages.MessageField('Membership', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class LookupGroupNameResponse(_messages.Message):
  r"""The response message for GroupsService.LookupGroupName.

  Fields:
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      looked-up `Group`.
  """

  name = _messages.StringField(1)


class LookupMembershipNameResponse(_messages.Message):
  r"""The response message for MembershipsService.LookupMembershipName.

  Fields:
    name: The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      looked-up `Membership`.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1)


class MamDataProtectionSetting(_messages.Message):
  r"""Data protection setting for enforcing data leak restrictions on user's
  device.

  Fields:
    copyPasteProtected: Whether user's data on the device is protected for
      cut/copy/paste.
    obfuscatedCustomerId: Obfuscated customer ID of the user in hex with at
      most 16 chars.
    sharingProtected: Whether the user's data on the device is protected for
      native sharing.
  """

  copyPasteProtected = _messages.BooleanField(1)
  obfuscatedCustomerId = _messages.StringField(2)
  sharingProtected = _messages.BooleanField(3)


class Membership(_messages.Message):
  r"""A membership within the Cloud Identity Groups API.  A `Membership`
  defines a relationship between a `Group` and an entity belonging to that
  `Group`, referred to as a "member".

  Fields:
    createTime: Output only. The time when the `Membership` was created.
    memberKey: Immutable. The `EntityKey` of the member.  Either `member_key`
      or `preferred_member_key` must be set when calling
      MembershipsService.CreateMembership but not both; both shall be set when
      returned.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership`.  Shall be of the form
      `groups/{group_id}/memberships/{membership_id}`.
    preferredMemberKey: Required. Immutable. The `EntityKey` of the member.
      Either `member_key` or `preferred_member_key` must be set when calling
      MembershipsService.CreateMembership but not both; both shall be set when
      returned.
    roles: The `MembershipRole`s that apply to the `Membership`.  If
      unspecified, defaults to a single `MembershipRole` with `name` `MEMBER`.
      Must not contain duplicate `MembershipRole`s with the same `name`.
    updateTime: Output only. The time when the `Membership` was last updated.
  """

  createTime = _messages.StringField(1)
  memberKey = _messages.MessageField('EntityKey', 2)
  name = _messages.StringField(3)
  preferredMemberKey = _messages.MessageField('EntityKey', 4)
  roles = _messages.MessageField('MembershipRole', 5, repeated=True)
  updateTime = _messages.StringField(6)


class MembershipRole(_messages.Message):
  r"""A membership role within the Cloud Identity Groups API.  A
  `MembershipRole` defines the privileges granted to a `Membership`.

  Fields:
    expiryDetail: The expiry details of the `MembershipRole`.  Expiry details
      are only supported for `MEMBER` `MembershipRoles`.  May be set if `name`
      is `MEMBER`. Must not be set if `name` is any other value.
    name: The name of the `MembershipRole`.  Must be one of `OWNER`,
      `MANAGER`, `MEMBER`.
  """

  expiryDetail = _messages.MessageField('ExpiryDetail', 1)
  name = _messages.StringField(2)


class ModifyMembershipRolesRequest(_messages.Message):
  r"""The request message for MembershipsService.ModifyMembershipRoles.

  Fields:
    addRoles: The `MembershipRole`s to be added.  Adding or removing roles in
      the same request as updating roles is not supported.  Must not be set if
      `update_roles_params` is set.
    removeRoles: The `name`s of the `MembershipRole`s to be removed.  Adding
      or removing roles in the same request as updating roles is not
      supported.  It is not possible to remove the `MEMBER` `MembershipRole`.
      If you wish to delete a `Membership`, call
      MembershipsService.DeleteMembership instead.  Must not contain `MEMBER`.
      Must not be set if `update_roles_params` is set.
    updateRolesParams: The `MembershipRole`s to be updated.  Updating roles in
      the same request as adding or removing roles is not supported.  Must not
      be set if either `add_roles` or `remove_roles` is set.
  """

  addRoles = _messages.MessageField('MembershipRole', 1, repeated=True)
  removeRoles = _messages.StringField(2, repeated=True)
  updateRolesParams = _messages.MessageField('UpdateMembershipRolesParams', 3, repeated=True)


class ModifyMembershipRolesResponse(_messages.Message):
  r"""The response message for MembershipsService.ModifyMembershipRoles.

  Fields:
    membership: The `Membership` resource after modifying its
      `MembershipRole`s.
  """

  membership = _messages.MessageField('Membership', 1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class SearchGroupsResponse(_messages.Message):
  r"""The response message for GroupsService.SearchGroups.

  Fields:
    groups: The `Group`s that match the search query.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class UpdateDeviceRequest(_messages.Message):
  r"""Request message for updating a Device resource.

  Fields:
    customer: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs. For querying your own customer,
      pass `customers/my_customer`
    device: Updated device information.
    updateMask: Required. Fully qualified names of fields to update.
  """

  customer = _messages.StringField(1)
  device = _messages.MessageField('Device', 2)
  updateMask = _messages.StringField(3)


class UpdateMembershipRolesParams(_messages.Message):
  r"""The details of an update to a `MembershipRole`.

  Fields:
    fieldMask: The fully-qualified names of fields to update.  May only
      contain the field `expiry_detail`.
    membershipRole: The `MembershipRole`s to be updated.  Only `MEMBER`
      `MembershipRoles` can currently be updated.  May only contain a
      `MembershipRole` with `name` `MEMBER`.
  """

  fieldMask = _messages.StringField(1)
  membershipRole = _messages.MessageField('MembershipRole', 2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
