"""Generated message classes for file version v1beta1.

The Cloud Filestore API is used for creating and managing cloud file servers.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'file'


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class FileProjectsLocationsGetRequest(_messages.Message):
  r"""A FileProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsInstancesCreateRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: The name of the instance to create. The name must be unique
      for the specified project and location.
    parent: The instance's project and location, in the format
      projects/{project_id}/locations/{location}. In Cloud Filestore,
      locations map to GCP zones, for example **us-west1-b**.
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class FileProjectsLocationsInstancesDeleteRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesDeleteRequest object.

  Fields:
    name: The instance resource name, in the format
      projects/{project_id}/locations/{location}/instances/{instance_id}
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesGetRequest object.

  Fields:
    name: The instance resource name, in the format
      projects/{project_id}/locations/{location}/instances/{instance_id}.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsInstancesListRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc" or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: The project and location for which to retrieve instance
      information, in the format projects/{project_id}/locations/{location}.
      In Cloud Filestore, locations map to GCP zones, for example **us-
      west1-b**. To retrieve instance information for all locations, use "-"
      for the {location} value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class FileProjectsLocationsInstancesPatchRequest(_messages.Message):
  r"""A FileProjectsLocationsInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Output only. The resource name of the instance, in the format
      projects/{project_id}/locations/{location_id}/instances/{instance_id}.
    updateMask: Mask of fields to update.  At least one path must be supplied
      in this field.  The elements of the repeated paths field may only
      include these fields:  * "description" * "file_shares" * "labels"
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class FileProjectsLocationsListRequest(_messages.Message):
  r"""A FileProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class FileProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class FileProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class FileProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A FileProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class FileShareConfig(_messages.Message):
  r"""File share configuration for the instance.

  Fields:
    capacityGb: File share capacity in gigabytes (GB). Cloud Filestore defines
      1 GB as 1024^3 bytes.
    name: The name of the file share (must be 16 characters or less).
  """

  capacityGb = _messages.IntegerField(1)
  name = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1Instance(_messages.Message):
  r"""Instance represents the interface for SLM services to actuate the state
  of control plane resources.  Example Instance in JSON, where   consumer-
  project=snapchat,   producer-project=cloud-sql:  ```json Instance: {
  "name":   "projects/snapchat/locations/us-east1/instances/prod-instance",
  "create_time": {     "seconds": 1526406431,   },   "labels": {     "env":
  "prod",     "foo": "bar"   },   "state": READY,   "software_versions": {
  "software_update": "cloud-sql-09-28-2018",   },
  "maintenance_policy_names": {     "UpdatePolicy":
  "projects/snapchat/locations/us-east1/maintenancePolicies/prod-update-
  policy",   }   "rollout_metadata": {     "projects/cloud-
  sql/locations/global/rolloutTypes/software_update": {       "release":
  "projects/cloud-sql/locations/global/releases/cloud-sql-09-28-2018",
  "rollout":       "projects/cloud-sql/locations/us-east1/rollouts/cloud-
  sql-09-28-2018-canary",     },     "projects/cloud-
  sql/locations/global/rolloutTypes/instance_restart": {       "release":
  "projects/cloud-sql/locations/global/releases/cloud-sql-09-20-repair",
  "rollout":       "projects/cloud-sql/locations/us-east1/rollouts/cloud-
  sql-09-20-repair-100-percent",     }   }   "tenant_project_id": "cloud-sql-
  test-tenant",   "producer_metadata": {     "cloud-sql-tier": "basic",
  "cloud-sql-instance-size": "1G",   },   "provisioned_resources": [     {
  "resource-type": "compute-instance",       "resource-url":
  "https://www.googleapis.com/compute/v1/projects/cloud-sql/zones/us-
  east1-b/instances/vm-1",     }   ],   "maintenance_schedules": {
  "csa_rollout": {        "start_time": {           "seconds": 1526406431,
  },        "end_time": {           "seconds": 1535406431,        },     },
  "ncsa_rollout": {        "start_time": {           "seconds": 1526406431,
  },        "end_time": {           "seconds": 1535406431,        },     }
  },   "consumer_defined_name": "my-sql-instance1", } ```

  Enums:
    StateValueValuesEnum: Output only. Current lifecycle state of the resource
      (e.g. if it's being created or ready to use).

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Each label is a key-value pair, where both the key and the
      value are arbitrary strings provided by the user.
    MaintenancePolicyNamesValue: The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the referenced policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug.
    MaintenanceSchedulesValue: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule.
    ProducerMetadataValue: Output only. Custom string attributes used
      primarily to expose producer-specific information in monitoring
      dashboards. See go/get-instance-metadata.
    RolloutMetadataValue: The map between RolloutType and the corresponding
      RolloutMetadata. This is only mutated by rollout service. For actuation
      implementation, this information is pass-through for Rollout management.
      Producer shall not modify by itself. For update of a single entry in
      this map, the update field mask shall follow this sementics: go
      /advanced-field-masks
    SoftwareVersionsValue: Software versions that are used to deploy this
      instance. This can be mutated by rollout services.

  Fields:
    consumerDefinedName: consumer_defined_name is the name that is set by the
      consumer. On the other hand Name field represents system-assigned id of
      an instance so consumers are not necessarily aware of it.
      consumer_defined_name is used for notification/UI purposes for consumer
      to recognize their instances.
    createTime: Output only. Timestamp when the resource was created.
    labels: Optional. Resource labels to represent user provided metadata.
      Each label is a key-value pair, where both the key and the value are
      arbitrary strings provided by the user.
    maintenancePolicyNames: The MaintenancePolicies that have been attached to
      the instance. The key must be of the type name of the oneof policy name
      defined in MaintenancePolicy, and the referenced policy must define the
      same policy type. For complete details of MaintenancePolicy, please
      refer to go/cloud-saas-mw-ug.
    maintenanceSchedules: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule.
    name: Unique name of the resource. It uses the form:
      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
    producerMetadata: Output only. Custom string attributes used primarily to
      expose producer-specific information in monitoring dashboards. See go
      /get-instance-metadata.
    provisionedResources: Output only. The list of data plane resources
      provisioned for this instance, e.g. compute VMs. See go/get-instance-
      metadata.
    rolloutMetadata: The map between RolloutType and the corresponding
      RolloutMetadata. This is only mutated by rollout service. For actuation
      implementation, this information is pass-through for Rollout management.
      Producer shall not modify by itself. For update of a single entry in
      this map, the update field mask shall follow this sementics: go
      /advanced-field-masks
    slmInstanceTemplate: Link to the SLM instance template. Only populated
      when updating SLM instances via SSA's Actuation service adaptor. Service
      producers with custom control plane (e.g. Cloud SQL) doesn't need to
      populate this field. Instead they should use software_versions.
    sloMetadata: Output only. SLO metadata for instance classification in the
      Standardized dataplane SLO platform. See go/cloud-ssa-standard-slo for
      feature description.
    softwareVersions: Software versions that are used to deploy this instance.
      This can be mutated by rollout services.
    state: Output only. Current lifecycle state of the resource (e.g. if it's
      being created or ready to use).
    tenantProjectId: Output only. ID of the associated GCP tenant project. See
      go/get-instance-metadata.
    updateTime: Output only. Timestamp when the resource was last modified.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current lifecycle state of the resource (e.g. if it's
    being created or ready to use).

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      CREATING: Instance is being created.
      READY: Instance has been created and is ready to use.
      UPDATING: Instance is being updated.
      REPAIRING: Instance is unheathy and under repair.
      DELETING: Instance is being deleted.
      ERROR: Instance encountered an error and is in indeterministic state.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    REPAIRING = 4
    DELETING = 5
    ERROR = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Each
    label is a key-value pair, where both the key and the value are arbitrary
    strings provided by the user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenancePolicyNamesValue(_messages.Message):
    r"""The MaintenancePolicies that have been attached to the instance. The
    key must be of the type name of the oneof policy name defined in
    MaintenancePolicy, and the referenced policy must define the same policy
    type. For complete details of MaintenancePolicy, please refer to go/cloud-
    saas-mw-ug.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenancePolicyNamesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenancePolicyNamesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenancePolicyNamesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenanceSchedulesValue(_messages.Message):
    r"""The MaintenanceSchedule contains the scheduling information of
    published maintenance schedule.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenanceSchedulesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenanceSchedulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenanceSchedulesValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProducerMetadataValue(_messages.Message):
    r"""Output only. Custom string attributes used primarily to expose
    producer-specific information in monitoring dashboards. See go/get-
    instance-metadata.

    Messages:
      AdditionalProperty: An additional property for a ProducerMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ProducerMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ProducerMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RolloutMetadataValue(_messages.Message):
    r"""The map between RolloutType and the corresponding RolloutMetadata.
    This is only mutated by rollout service. For actuation implementation,
    this information is pass-through for Rollout management. Producer shall
    not modify by itself. For update of a single entry in this map, the update
    field mask shall follow this sementics: go/advanced-field-masks

    Messages:
      AdditionalProperty: An additional property for a RolloutMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type RolloutMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RolloutMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudSaasacceleratorManagementProvidersV1RolloutMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1RolloutMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SoftwareVersionsValue(_messages.Message):
    r"""Software versions that are used to deploy this instance. This can be
    mutated by rollout services.

    Messages:
      AdditionalProperty: An additional property for a SoftwareVersionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SoftwareVersionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SoftwareVersionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  consumerDefinedName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  maintenancePolicyNames = _messages.MessageField('MaintenancePolicyNamesValue', 4)
  maintenanceSchedules = _messages.MessageField('MaintenanceSchedulesValue', 5)
  name = _messages.StringField(6)
  producerMetadata = _messages.MessageField('ProducerMetadataValue', 7)
  provisionedResources = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource', 8, repeated=True)
  rolloutMetadata = _messages.MessageField('RolloutMetadataValue', 9)
  slmInstanceTemplate = _messages.StringField(10)
  sloMetadata = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata', 11)
  softwareVersions = _messages.MessageField('SoftwareVersionsValue', 12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  tenantProjectId = _messages.StringField(14)
  updateTime = _messages.StringField(15)


class GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule(_messages.Message):
  r"""Maintenance schedule which is exposed to customer and potentially end
  user, indicating published upcoming future maintenance schedule

  Fields:
    canReschedule: Can this scheduled update be rescheduled? By default, it's
      true and API needs to do explicitly check whether it's set, if it's set
      as false explicitly, it's false
    endTime: The scheduled end time for the maintenance.
    rolloutManagementPolicy: The rollout management policy this maintenance
      schedule is associated with. When doing reschedule update request, the
      reschedule should be against this given policy.
    startTime: The scheduled start time for the maintenance.
  """

  canReschedule = _messages.BooleanField(1)
  endTime = _messages.StringField(2)
  rolloutManagementPolicy = _messages.StringField(3)
  startTime = _messages.StringField(4)


class GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata(_messages.Message):
  r"""Node information for custom per-node SLO implementations. SSA does not
  support per-node SLO, but producers can populate per-node information in
  SloMetadata for custom precomputations. SSA Eligibility Exporter will emit
  per-node metric based on this information.

  Fields:
    exclusions: By default node is eligible if instance is eligible. But
      individual node might be excluded from SLO by adding entry here. For
      semantic see SloMetadata.exclusions. If both instance and node level
      exclusions are present for time period, the node level's reason will be
      reported by Eligibility Exporter.
    location: The location of the node, if different from instance location.
    nodeId: The id of the node. This should be equal to
      SaasInstanceNode.node_id.
  """

  exclusions = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion', 1, repeated=True)
  location = _messages.StringField(2)
  nodeId = _messages.StringField(3)


class GoogleCloudSaasacceleratorManagementProvidersV1NotificationMetadata(_messages.Message):
  r"""NotificationMetadata is the notification state for an instance.

  Fields:
    rescheduled: Whether the instance update has been rescheduled.
    scheduledEndTime: The scheduled end time for the maintenance window during
      which update can be performed on the instance.
    scheduledStartTime: The scheduled start time for the maintenance window
      during which update can be performed on the instance.
    targetRelease: The target release to be applied to the instance.
  """

  rescheduled = _messages.BooleanField(1)
  scheduledEndTime = _messages.StringField(2)
  scheduledStartTime = _messages.StringField(3)
  targetRelease = _messages.StringField(4)


class GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource(_messages.Message):
  r"""Describes provisioned dataplane resources.

  Fields:
    resourceType: Type of the resource. This can be either a GCP resource or a
      custom one (e.g. another cloud provider's VM). For GCP compute resources
      use singular form of the names listed in GCP compute API documentation
      (https://cloud.google.com/compute/docs/reference/rest/v1/), prefixed
      with 'compute-', for example: 'compute-instance', 'compute-disk',
      'compute-autoscaler'.
    resourceUrl: URL identifying the resource, e.g.
      "https://www.googleapis.com/compute/v1/projects/...)".
  """

  resourceType = _messages.StringField(1)
  resourceUrl = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1RolloutMetadata(_messages.Message):
  r"""RolloutMetadata for an actuation instance. It maps to a single
  RolloutType.

  Fields:
    notification: Instance level notification metadata.
    releaseName: The last Release that has been applied to the instance.
    rolloutName: The last rollout that has been applied to the instance.
  """

  notification = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1NotificationMetadata', 1)
  releaseName = _messages.StringField(2)
  rolloutName = _messages.StringField(3)


class GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility(_messages.Message):
  r"""SloEligibility is a tuple containing eligibility value: true if an
  instance is eligible for SLO calculation or false if it should be excluded
  from all SLO-related calculations along with a user-defined reason.

  Fields:
    eligible: Whether an instance is eligible or ineligible.
    reason: User-defined reason for the current value of instance eligibility.
      Usually, this can be directly mapped to the internal state. An empty
      reason is allowed.
  """

  eligible = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion(_messages.Message):
  r"""SloExclusion represents an exclusion in SLI calculation applies to all
  SLOs.

  Fields:
    duration: Exclusion duration. No restrictions on the possible values.
      When an ongoing operation is taking longer than initially expected, an
      existing entry in the exclusion list can be updated by extending the
      duration. This is supported by the subsystem exporting eligibility data
      as long as such extension is committed at least 10 minutes before the
      original exclusion expiration - otherwise it is possible that there will
      be "gaps" in the exclusion application in the exported timeseries.
    reason: Human-readable reason for the exclusion. This should be a static
      string (e.g. "Disruptive update in progress") and should not contain
      dynamically generated data (e.g. instance name). Can be left empty.
    sliName: Name of an SLI that this exclusion applies to. Can be left empty,
      signaling that the instance should be excluded from all SLIs defined in
      the service SLO configuration.
    startTime: Start time of the exclusion. No alignment (e.g. to a full
      minute) needed.
  """

  duration = _messages.StringField(1)
  reason = _messages.StringField(2)
  sliName = _messages.StringField(3)
  startTime = _messages.StringField(4)


class GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata(_messages.Message):
  r"""SloMetadata contains resources required for proper SLO classification of
  the instance.

  Fields:
    eligibility: Optional. User-defined instance eligibility.
    exclusions: List of SLO exclusion windows. When multiple entries in the
      list match (matching the exclusion time-window against current time
      point) the exclusion reason used in the first matching entry will be
      published.  It is not needed to include expired exclusion in this list,
      as only the currently applicable exclusions are taken into account by
      the eligibility exporting subsystem (the historical state of exclusions
      will be reflected in the historically produced timeseries regardless of
      the current state).  This field can be used to mark the instance as
      temporary ineligible for the purpose of SLO calculation. For permanent
      instance SLO exclusion, use of custom instance eligibility is
      recommended. See 'eligibility' field below.
    nodes: Optional. List of nodes. Some producers need to use per-node
      metadata to calculate SLO. This field allows such producers to publish
      per-node SLO meta data, which will be consumed by SSA Eligibility
      Exporter and published in the form of per node metric to Monarch.
    tier: Name of the SLO tier the Instance belongs to. This name will be
      expected to match the tiers specified in the service SLO configuration.
      Field is mandatory and must not be empty.
  """

  eligibility = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility', 1)
  exclusions = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion', 2, repeated=True)
  nodes = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata', 3, repeated=True)
  tier = _messages.StringField(4)


class Instance(_messages.Message):
  r"""A Cloud Filestore instance.

  Enums:
    StateValueValuesEnum: Output only. The instance state.
    TierValueValuesEnum: The service tier of the instance.

  Messages:
    LabelsValue: Resource labels to represent user provided metadata.

  Fields:
    createTime: Output only. The time when the instance was created.
    description: Optional. The description of the instance (2048 characters or
      less).
    etag: Server-specified ETag for the instance resource to prevent
      simultaneous updates from overwriting each other.
    fileShares: File system shares on the instance. For this version, only a
      single file share is supported.
    labels: Resource labels to represent user provided metadata.
    name: Output only. The resource name of the instance, in the format
      projects/{project_id}/locations/{location_id}/instances/{instance_id}.
    networks: VPC networks to which the instance is connected. For this
      version, only a single network is supported.
    state: Output only. The instance state.
    statusMessage: Output only. Additional information about the instance
      state, if available.
    tier: The service tier of the instance.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The instance state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The instance is being created.
      READY: The instance is available for use.
      REPAIRING: Work is being done on the instance. You can get further
        details from the `statusMessage` field of the `Instance` resource.
      DELETING: The instance is shutting down.
      ERROR: The instance is experiencing an issue and might be unusable. You
        can get further details from the `statusMessage` field of the
        `Instance` resource.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    REPAIRING = 3
    DELETING = 4
    ERROR = 5

  class TierValueValuesEnum(_messages.Enum):
    r"""The service tier of the instance.

    Values:
      TIER_UNSPECIFIED: Not set.
      STANDARD: STANDARD tier. BASIC_HDD is the preferred term for this tier.
      PREMIUM: PREMIUM tier. BASIC_SSD is the preferred term for this tier.
      BASIC_HDD: BASIC instances offer a maximum capacity of 63.9 TB.
        BASIC_HDD is an alias for STANDARD Tier, offering economical
        performance backed by Persistent Disk HDD.
      BASIC_SSD: BASIC instances offer a maximum capacity of 63.9 TB.
        BASIC_SSD is an alias for PREMIUM Tier, and offers improved
        performance backed by Persistent Disk SSD.
      HIGH_SCALE_SSD: HIGH_SCALE instances offer larger capacity and
        professional performance backed by Persistent Disk SSD.
    """
    TIER_UNSPECIFIED = 0
    STANDARD = 1
    PREMIUM = 2
    BASIC_HDD = 3
    BASIC_SSD = 4
    HIGH_SCALE_SSD = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  etag = _messages.StringField(3)
  fileShares = _messages.MessageField('FileShareConfig', 4, repeated=True)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  networks = _messages.MessageField('NetworkConfig', 7, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  statusMessage = _messages.StringField(9)
  tier = _messages.EnumField('TierValueValuesEnum', 10)


class ListInstancesResponse(_messages.Message):
  r"""ListInstancesResponse is the result of ListInstancesRequest.

  Fields:
    instances: A list of instances in the project for the specified location.
      If the {location} value in the request is "-", the response contains a
      list of instances from all locations. If any location is unreachable,
      the response will only return instances in reachable locations and the
      "unreachable" field will be populated with a list of unreachable
      locations.
    nextPageToken: The token you can use to retrieve the next page of results.
      Not returned if there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class NetworkConfig(_messages.Message):
  r"""Network configuration for the instance.

  Enums:
    ModesValueListEntryValuesEnum:

  Fields:
    ipAddresses: Output only. IPv4 addresses in the format {octet 1}.{octet
      2}.{octet 3}.{octet 4} or IPv6 addresses in the format {block 1}:{block
      2}:{block 3}:{block 4}:{block 5}:{block 6}:{block 7}:{block 8}.
    modes: Internet protocol versions for which the instance has IP addresses
      assigned. For this version, only MODE_IPV4 is supported.
    network: The name of the Google Compute Engine [VPC network](/compute/docs
      /networks-and-firewalls#networks) to which the instance is connected.
    reservedIpRange: A /29 CIDR block in one of the [internal IP address
      ranges](https://www.arin.net/knowledge/address_filters.html) that
      identifies the range of IP addresses reserved for this instance. For
      example, 10.0.0.0/29 or 192.168.0.0/29. The range you specify can't
      overlap with either existing subnets or assigned IP address ranges for
      other Cloud Filestore instances in the selected VPC network.
  """

  class ModesValueListEntryValuesEnum(_messages.Enum):
    r"""ModesValueListEntryValuesEnum enum type.

    Values:
      ADDRESS_MODE_UNSPECIFIED: <no description>
      MODE_IPV4: <no description>
    """
    ADDRESS_MODE_UNSPECIFIED = 0
    MODE_IPV4 = 1

  ipAddresses = _messages.StringField(1, repeated=True)
  modes = _messages.EnumField('ModesValueListEntryValuesEnum', 2, repeated=True)
  network = _messages.StringField(3)
  reservedIpRange = _messages.StringField(4)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: [Output only] API version used to start the operation.
    cancelRequested: [Output only] Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    createTime: [Output only] The time the operation was created.
    endTime: [Output only] The time the operation finished running.
    statusDetail: [Output only] Human-readable status of the operation, if
      any.
    target: [Output only] Server-defined resource path for the target of the
      operation.
    verb: [Output only] Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
