"""Generated client library for run version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.run.v1 import run_v1_messages as messages


class RunV1(base_api.BaseApiClient):
  """Generated client library for service run version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://run.googleapis.com/'

  _PACKAGE = u'run'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'RunV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new run handle."""
    url = url or self.BASE_URL
    super(RunV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.namespaces_authorizeddomains = self.NamespacesAuthorizeddomainsService(self)
    self.namespaces_configurations = self.NamespacesConfigurationsService(self)
    self.namespaces_domainmappings = self.NamespacesDomainmappingsService(self)
    self.namespaces_revisions = self.NamespacesRevisionsService(self)
    self.namespaces_routes = self.NamespacesRoutesService(self)
    self.namespaces_services = self.NamespacesServicesService(self)
    self.namespaces = self.NamespacesService(self)
    self.projects_locations_authorizeddomains = self.ProjectsLocationsAuthorizeddomainsService(self)
    self.projects_locations_configurations = self.ProjectsLocationsConfigurationsService(self)
    self.projects_locations_domainmappings = self.ProjectsLocationsDomainmappingsService(self)
    self.projects_locations_revisions = self.ProjectsLocationsRevisionsService(self)
    self.projects_locations_routes = self.ProjectsLocationsRoutesService(self)
    self.projects_locations_services = self.ProjectsLocationsServicesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class NamespacesAuthorizeddomainsService(base_api.BaseApiService):
    """Service class for the namespaces_authorizeddomains resource."""

    _NAME = u'namespaces_authorizeddomains'

    def __init__(self, client):
      super(RunV1.NamespacesAuthorizeddomainsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List authorized domains.

      Args:
        request: (RunNamespacesAuthorizeddomainsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAuthorizedDomainsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1/namespaces/{namespacesId}/authorizeddomains',
        http_method=u'GET',
        method_id=u'run.namespaces.authorizeddomains.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'apis/domains.cloudrun.com/v1/{+parent}/authorizeddomains',
        request_field='',
        request_type_name=u'RunNamespacesAuthorizeddomainsListRequest',
        response_type_name=u'ListAuthorizedDomainsResponse',
        supports_download=False,
    )

  class NamespacesConfigurationsService(base_api.BaseApiService):
    """Service class for the namespaces_configurations resource."""

    _NAME = u'namespaces_configurations'

    def __init__(self, client):
      super(RunV1.NamespacesConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get information about a configuration.

      Args:
        request: (RunNamespacesConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/configurations/{configurationsId}',
        http_method=u'GET',
        method_id=u'run.namespaces.configurations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesConfigurationsGetRequest',
        response_type_name=u'Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List configurations.

      Args:
        request: (RunNamespacesConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/configurations',
        http_method=u'GET',
        method_id=u'run.namespaces.configurations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1/{+parent}/configurations',
        request_field='',
        request_type_name=u'RunNamespacesConfigurationsListRequest',
        response_type_name=u'ListConfigurationsResponse',
        supports_download=False,
    )

  class NamespacesDomainmappingsService(base_api.BaseApiService):
    """Service class for the namespaces_domainmappings resource."""

    _NAME = u'namespaces_domainmappings'

    def __init__(self, client):
      super(RunV1.NamespacesDomainmappingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a new domain mapping.

      Args:
        request: (RunNamespacesDomainmappingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1/namespaces/{namespacesId}/domainmappings',
        http_method=u'POST',
        method_id=u'run.namespaces.domainmappings.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'apis/domains.cloudrun.com/v1/{+parent}/domainmappings',
        request_field=u'domainMapping',
        request_type_name=u'RunNamespacesDomainmappingsCreateRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a domain mapping.

      Args:
        request: (RunNamespacesDomainmappingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Status) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1/namespaces/{namespacesId}/domainmappings/{domainmappingsId}',
        http_method=u'DELETE',
        method_id=u'run.namespaces.domainmappings.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'apiVersion', u'kind', u'propagationPolicy'],
        relative_path=u'apis/domains.cloudrun.com/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesDomainmappingsDeleteRequest',
        response_type_name=u'Status',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about a domain mapping.

      Args:
        request: (RunNamespacesDomainmappingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1/namespaces/{namespacesId}/domainmappings/{domainmappingsId}',
        http_method=u'GET',
        method_id=u'run.namespaces.domainmappings.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/domains.cloudrun.com/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesDomainmappingsGetRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List domain mappings.

      Args:
        request: (RunNamespacesDomainmappingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDomainMappingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1/namespaces/{namespacesId}/domainmappings',
        http_method=u'GET',
        method_id=u'run.namespaces.domainmappings.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/domains.cloudrun.com/v1/{+parent}/domainmappings',
        request_field='',
        request_type_name=u'RunNamespacesDomainmappingsListRequest',
        response_type_name=u'ListDomainMappingsResponse',
        supports_download=False,
    )

  class NamespacesRevisionsService(base_api.BaseApiService):
    """Service class for the namespaces_revisions resource."""

    _NAME = u'namespaces_revisions'

    def __init__(self, client):
      super(RunV1.NamespacesRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Delete a revision.

      Args:
        request: (RunNamespacesRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Status) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method=u'DELETE',
        method_id=u'run.namespaces.revisions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'apiVersion', u'kind', u'propagationPolicy'],
        relative_path=u'apis/serving.knative.dev/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesRevisionsDeleteRequest',
        response_type_name=u'Status',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about a revision.

      Args:
        request: (RunNamespacesRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method=u'GET',
        method_id=u'run.namespaces.revisions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesRevisionsGetRequest',
        response_type_name=u'Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List revisions.

      Args:
        request: (RunNamespacesRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/revisions',
        http_method=u'GET',
        method_id=u'run.namespaces.revisions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1/{+parent}/revisions',
        request_field='',
        request_type_name=u'RunNamespacesRevisionsListRequest',
        response_type_name=u'ListRevisionsResponse',
        supports_download=False,
    )

  class NamespacesRoutesService(base_api.BaseApiService):
    """Service class for the namespaces_routes resource."""

    _NAME = u'namespaces_routes'

    def __init__(self, client):
      super(RunV1.NamespacesRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get information about a route.

      Args:
        request: (RunNamespacesRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/routes/{routesId}',
        http_method=u'GET',
        method_id=u'run.namespaces.routes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesRoutesGetRequest',
        response_type_name=u'Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List routes.

      Args:
        request: (RunNamespacesRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/routes',
        http_method=u'GET',
        method_id=u'run.namespaces.routes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1/{+parent}/routes',
        request_field='',
        request_type_name=u'RunNamespacesRoutesListRequest',
        response_type_name=u'ListRoutesResponse',
        supports_download=False,
    )

  class NamespacesServicesService(base_api.BaseApiService):
    """Service class for the namespaces_services resource."""

    _NAME = u'namespaces_services'

    def __init__(self, client):
      super(RunV1.NamespacesServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a service.

      Args:
        request: (RunNamespacesServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/services',
        http_method=u'POST',
        method_id=u'run.namespaces.services.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1/{+parent}/services',
        request_field=u'service',
        request_type_name=u'RunNamespacesServicesCreateRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (RunNamespacesServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Status) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'DELETE',
        method_id=u'run.namespaces.services.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'apiVersion', u'kind', u'propagationPolicy'],
        relative_path=u'apis/serving.knative.dev/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesServicesDeleteRequest',
        response_type_name=u'Status',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about a service.

      Args:
        request: (RunNamespacesServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'GET',
        method_id=u'run.namespaces.services.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1/{+name}',
        request_field='',
        request_type_name=u'RunNamespacesServicesGetRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List services.

      Args:
        request: (RunNamespacesServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/services',
        http_method=u'GET',
        method_id=u'run.namespaces.services.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1/{+parent}/services',
        request_field='',
        request_type_name=u'RunNamespacesServicesListRequest',
        response_type_name=u'ListServicesResponse',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Replace a service.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunNamespacesServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'PUT',
        method_id=u'run.namespaces.services.replaceService',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1/{+name}',
        request_field=u'service',
        request_type_name=u'RunNamespacesServicesReplaceServiceRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

  class NamespacesService(base_api.BaseApiService):
    """Service class for the namespaces resource."""

    _NAME = u'namespaces'

    def __init__(self, client):
      super(RunV1.NamespacesService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsAuthorizeddomainsService(base_api.BaseApiService):
    """Service class for the projects_locations_authorizeddomains resource."""

    _NAME = u'projects_locations_authorizeddomains'

    def __init__(self, client):
      super(RunV1.ProjectsLocationsAuthorizeddomainsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List authorized domains.

      Args:
        request: (RunProjectsLocationsAuthorizeddomainsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAuthorizedDomainsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/authorizeddomains',
        http_method=u'GET',
        method_id=u'run.projects.locations.authorizeddomains.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/authorizeddomains',
        request_field='',
        request_type_name=u'RunProjectsLocationsAuthorizeddomainsListRequest',
        response_type_name=u'ListAuthorizedDomainsResponse',
        supports_download=False,
    )

  class ProjectsLocationsConfigurationsService(base_api.BaseApiService):
    """Service class for the projects_locations_configurations resource."""

    _NAME = u'projects_locations_configurations'

    def __init__(self, client):
      super(RunV1.ProjectsLocationsConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get information about a configuration.

      Args:
        request: (RunProjectsLocationsConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/configurations/{configurationsId}',
        http_method=u'GET',
        method_id=u'run.projects.locations.configurations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsConfigurationsGetRequest',
        response_type_name=u'Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List configurations.

      Args:
        request: (RunProjectsLocationsConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/configurations',
        http_method=u'GET',
        method_id=u'run.projects.locations.configurations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1/{+parent}/configurations',
        request_field='',
        request_type_name=u'RunProjectsLocationsConfigurationsListRequest',
        response_type_name=u'ListConfigurationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDomainmappingsService(base_api.BaseApiService):
    """Service class for the projects_locations_domainmappings resource."""

    _NAME = u'projects_locations_domainmappings'

    def __init__(self, client):
      super(RunV1.ProjectsLocationsDomainmappingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a new domain mapping.

      Args:
        request: (RunProjectsLocationsDomainmappingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/domainmappings',
        http_method=u'POST',
        method_id=u'run.projects.locations.domainmappings.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/domainmappings',
        request_field=u'domainMapping',
        request_type_name=u'RunProjectsLocationsDomainmappingsCreateRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a domain mapping.

      Args:
        request: (RunProjectsLocationsDomainmappingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Status) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/domainmappings/{domainmappingsId}',
        http_method=u'DELETE',
        method_id=u'run.projects.locations.domainmappings.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'apiVersion', u'kind', u'propagationPolicy'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsDomainmappingsDeleteRequest',
        response_type_name=u'Status',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about a domain mapping.

      Args:
        request: (RunProjectsLocationsDomainmappingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/domainmappings/{domainmappingsId}',
        http_method=u'GET',
        method_id=u'run.projects.locations.domainmappings.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsDomainmappingsGetRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List domain mappings.

      Args:
        request: (RunProjectsLocationsDomainmappingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDomainMappingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/domainmappings',
        http_method=u'GET',
        method_id=u'run.projects.locations.domainmappings.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1/{+parent}/domainmappings',
        request_field='',
        request_type_name=u'RunProjectsLocationsDomainmappingsListRequest',
        response_type_name=u'ListDomainMappingsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_revisions resource."""

    _NAME = u'projects_locations_revisions'

    def __init__(self, client):
      super(RunV1.ProjectsLocationsRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Delete a revision.

      Args:
        request: (RunProjectsLocationsRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Status) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method=u'DELETE',
        method_id=u'run.projects.locations.revisions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'apiVersion', u'kind', u'propagationPolicy'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsRevisionsDeleteRequest',
        response_type_name=u'Status',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about a revision.

      Args:
        request: (RunProjectsLocationsRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method=u'GET',
        method_id=u'run.projects.locations.revisions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsRevisionsGetRequest',
        response_type_name=u'Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List revisions.

      Args:
        request: (RunProjectsLocationsRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/revisions',
        http_method=u'GET',
        method_id=u'run.projects.locations.revisions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1/{+parent}/revisions',
        request_field='',
        request_type_name=u'RunProjectsLocationsRevisionsListRequest',
        response_type_name=u'ListRevisionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_routes resource."""

    _NAME = u'projects_locations_routes'

    def __init__(self, client):
      super(RunV1.ProjectsLocationsRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get information about a route.

      Args:
        request: (RunProjectsLocationsRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/routes/{routesId}',
        http_method=u'GET',
        method_id=u'run.projects.locations.routes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsRoutesGetRequest',
        response_type_name=u'Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List routes.

      Args:
        request: (RunProjectsLocationsRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/routes',
        http_method=u'GET',
        method_id=u'run.projects.locations.routes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1/{+parent}/routes',
        request_field='',
        request_type_name=u'RunProjectsLocationsRoutesListRequest',
        response_type_name=u'ListRoutesResponse',
        supports_download=False,
    )

  class ProjectsLocationsServicesService(base_api.BaseApiService):
    """Service class for the projects_locations_services resource."""

    _NAME = u'projects_locations_services'

    def __init__(self, client):
      super(RunV1.ProjectsLocationsServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a service.

      Args:
        request: (RunProjectsLocationsServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services',
        http_method=u'POST',
        method_id=u'run.projects.locations.services.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/services',
        request_field=u'service',
        request_type_name=u'RunProjectsLocationsServicesCreateRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (RunProjectsLocationsServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Status) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'DELETE',
        method_id=u'run.projects.locations.services.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'apiVersion', u'kind', u'propagationPolicy'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsServicesDeleteRequest',
        response_type_name=u'Status',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about a service.

      Args:
        request: (RunProjectsLocationsServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'GET',
        method_id=u'run.projects.locations.services.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsServicesGetRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Get the IAM Access Control policy currently in effect for the given.
Cloud Run service. This result does not include any inherited policies.

      Args:
        request: (RunProjectsLocationsServicesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'run.projects.locations.services.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'RunProjectsLocationsServicesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List services.

      Args:
        request: (RunProjectsLocationsServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services',
        http_method=u'GET',
        method_id=u'run.projects.locations.services.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1/{+parent}/services',
        request_field='',
        request_type_name=u'RunProjectsLocationsServicesListRequest',
        response_type_name=u'ListServicesResponse',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Replace a service.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunProjectsLocationsServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'PUT',
        method_id=u'run.projects.locations.services.replaceService',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field=u'service',
        request_type_name=u'RunProjectsLocationsServicesReplaceServiceRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM Access control policy for the specified Service. Overwrites.
any existing policy.

      Args:
        request: (RunProjectsLocationsServicesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'run.projects.locations.services.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'RunProjectsLocationsServicesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified Project.

There are no permissions required for making this API call.

      Args:
        request: (RunProjectsLocationsServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'run.projects.locations.services.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'RunProjectsLocationsServicesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(RunV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (RunProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'run.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RunProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (RunProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'run.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+name}/locations',
        request_field='',
        request_type_name=u'RunProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(RunV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
