"""Generated client library for healthcare version v1alpha2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.healthcare.v1alpha2 import healthcare_v1alpha2_messages as messages


class HealthcareV1alpha2(base_api.BaseApiClient):
  """Generated client library for service healthcare version v1alpha2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://healthcare.googleapis.com/'

  _PACKAGE = u'healthcare'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'HealthcareV1alpha2'
  _URL_VERSION = u'v1alpha2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new healthcare handle."""
    url = url or self.BASE_URL
    super(HealthcareV1alpha2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_datasets_annotationStores_annotations = self.ProjectsLocationsDatasetsAnnotationStoresAnnotationsService(self)
    self.projects_locations_datasets_annotationStores = self.ProjectsLocationsDatasetsAnnotationStoresService(self)
    self.projects_locations_datasets_dicomStores_dicomWeb_studies_series_instances_frames = self.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesFramesService(self)
    self.projects_locations_datasets_dicomStores_dicomWeb_studies_series_instances = self.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService(self)
    self.projects_locations_datasets_dicomStores_dicomWeb_studies_series = self.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService(self)
    self.projects_locations_datasets_dicomStores_dicomWeb_studies = self.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService(self)
    self.projects_locations_datasets_dicomStores_dicomWeb = self.ProjectsLocationsDatasetsDicomStoresDicomWebService(self)
    self.projects_locations_datasets_dicomStores = self.ProjectsLocationsDatasetsDicomStoresService(self)
    self.projects_locations_datasets_fhirStores_fhir = self.ProjectsLocationsDatasetsFhirStoresFhirService(self)
    self.projects_locations_datasets_fhirStores = self.ProjectsLocationsDatasetsFhirStoresService(self)
    self.projects_locations_datasets_hl7V2Stores_messages = self.ProjectsLocationsDatasetsHl7V2StoresMessagesService(self)
    self.projects_locations_datasets_hl7V2Stores = self.ProjectsLocationsDatasetsHl7V2StoresService(self)
    self.projects_locations_datasets_operations = self.ProjectsLocationsDatasetsOperationsService(self)
    self.projects_locations_datasets = self.ProjectsLocationsDatasetsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsDatasetsAnnotationStoresAnnotationsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_annotationStores_annotations resource."""

    _NAME = u'projects_locations_datasets_annotationStores_annotations'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsAnnotationStoresAnnotationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Annotation record. It is.
valid to create Annotation objects for the same source more than once since
a unique ID is assigned to each record by this service.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}/annotations',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.annotations.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/annotations',
        request_field=u'annotation',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an Annotation or returns.
NOT_FOUND if it does not exist.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}/annotations/{annotationsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.annotations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an Annotation.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}/annotations/{annotationsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.annotations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsGetRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Annotations in the given.
Annotation store for a source
resource.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}/annotations',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.annotations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/annotations',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsListRequest',
        response_type_name=u'ListAnnotationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the Annotation.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}/annotations/{annotationsId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.annotations.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'annotation',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsAnnotationStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_annotationStores resource."""

    _NAME = u'projects_locations_datasets_annotationStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsAnnotationStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Annotation store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'annotationStoreId'],
        relative_path=u'v1alpha2/{+parent}/annotationStores',
        request_field=u'annotationStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresCreateRequest',
        response_type_name=u'AnnotationStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Annotation store and removes all annotations that are.
contained within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Evaluate(self, request, global_params=None):
      r"""Evaluate an Annotation store against a.
ground truth Annotation store.
When the operation finishes successfully, a detailed response is returned
of type EvaluateAnnotationStoreResponse, contained in the response. The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresEvaluateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Evaluate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Evaluate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:evaluate',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.evaluate',
        ordered_params=[u'evalStore'],
        path_params=[u'evalStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+evalStore}:evaluate',
        request_field=u'evaluateAnnotationStoreRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresEvaluateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Export.
Annotations from
the Annotation
store.
Errors are noted in the error
field. Otherwise, a detailed response is returned of type
ExportAnnotationsResponse, contained in the
response field when the
operation finishes. The metadata
field type is OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.export',
        ordered_params=[u'annotationStore'],
        path_params=[u'annotationStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+annotationStore}:export',
        request_field=u'exportAnnotationsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified Annotation store or returns NOT_FOUND if it does not.
exist.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresGetRequest',
        response_type_name=u'AnnotationStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Import.
Annotations to
the Annotation
store by
loading data from the specified sources.
Errors are noted in the error
field. Otherwise, a detailed response is returned as of type
ImportAnnotationsResponse contained in the
response field when the
operation finishes.
The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.import',
        ordered_params=[u'annotationStore'],
        path_params=[u'annotationStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+annotationStore}:import',
        request_field=u'importAnnotationsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Annotation stores in the given dataset for a source store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/annotationStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresListRequest',
        response_type_name=u'ListAnnotationStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified Annotation store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'annotationStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresPatchRequest',
        response_type_name=u'AnnotationStore',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesFramesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_dicomWeb_studies_series_instances_frames resource."""

    _NAME = u'projects_locations_datasets_dicomStores_dicomWeb_studies_series_instances_frames'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesFramesService, self).__init__(client)
      self._upload_configs = {
          }

    def Rendered(self, request, global_params=None):
      r"""RetrieveRenderedFrames returns instances associated with the given study,.
series, SOP Instance UID and frame numbers in an acceptable Rendered Media
Type. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesFramesRenderedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Rendered')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rendered.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/frames/{framesId}/rendered',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.frames.rendered',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesFramesRenderedRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveFrames(self, request, global_params=None):
      r"""RetrieveFrames returns instances associated with the given study, series,.
SOP Instance UID and frame numbers. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesFramesRetrieveFramesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveFrames')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveFrames.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/frames/{framesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.frames.retrieveFrames',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesFramesRetrieveFramesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_dicomWeb_studies_series_instances resource."""

    _NAME = u'projects_locations_datasets_dicomStores_dicomWeb_studies_series_instances'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""DeleteInstance deletes an instance associated with the given study, series,.
and SOP Instance UID. Delete requests are equivalent to the GET requests
specified in the WADO-RS standard.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.delete',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Metadata(self, request, global_params=None):
      r"""RetrieveInstanceMetadata returns instance associated with the given study,.
series, and SOP Instance UID presented as metadata with the bulk data
removed. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Metadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    Metadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.metadata',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesMetadataRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Rendered(self, request, global_params=None):
      r"""RetrieveRenderedInstance returns instance associated with the given study,.
series, and SOP Instance UID in an acceptable Rendered Media Type. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesRenderedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Rendered')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rendered.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/rendered',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.rendered',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesRenderedRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveInstance(self, request, global_params=None):
      r"""RetrieveInstance returns instance associated with the given study, series,.
and SOP Instance UID. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesRetrieveInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveInstance.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.retrieveInstance',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesRetrieveInstanceRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_dicomWeb_studies_series resource."""

    _NAME = u'projects_locations_datasets_dicomStores_dicomWeb_studies_series'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""DeleteSeries deletes all instances within the given study and series.
Delete requests are equivalent to the GET requests specified in the WADO-RS
standard.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.delete',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Metadata(self, request, global_params=None):
      r"""RetrieveSeriesMetadata returns instance associated with the given study and.
series, presented as metadata with the bulk data removed. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Metadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    Metadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.metadata',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesMetadataRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveSeries(self, request, global_params=None):
      r"""RetrieveSeries returns all instances within the given study and series. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesRetrieveSeriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveSeries')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveSeries.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.retrieveSeries',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesRetrieveSeriesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForInstances(self, request, global_params=None):
      r"""SearchForInstances returns a list of matching instances. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesSearchForInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.searchForInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesSearchForInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_dicomWeb_studies resource."""

    _NAME = u'projects_locations_datasets_dicomStores_dicomWeb_studies'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""DeleteStudy deletes all instances within the given study. Delete requests.
are equivalent to the GET requests specified in the WADO-RS standard.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.delete',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Metadata(self, request, global_params=None):
      r"""RetrieveStudyMetadata returns instance associated with the given study.
presented as metadata with the bulk data removed. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Metadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    Metadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.metadata',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesMetadataRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveStudy(self, request, global_params=None):
      r"""RetrieveStudy returns all instances within the given study. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesRetrieveStudyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveStudy')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveStudy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.retrieveStudy',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesRetrieveStudyRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForInstances(self, request, global_params=None):
      r"""SearchForInstances returns a list of matching instances. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSearchForInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/instances',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.searchForInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSearchForInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForSeries(self, request, global_params=None):
      r"""SearchForSeries returns a list of matching series. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSearchForSeriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForSeries')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForSeries.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.searchForSeries',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesSearchForSeriesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def StoreInstances(self, request, global_params=None):
      r"""StoreInstances stores DICOM instances associated with study instance unique.
identifiers (SUID). See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesStoreInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('StoreInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StoreInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.storeInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStudiesStoreInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresDicomWebService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_dicomWeb resource."""

    _NAME = u'projects_locations_datasets_dicomStores_dicomWeb'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDicomStoresDicomWebService, self).__init__(client)
      self._upload_configs = {
          }

    def SearchForInstances(self, request, global_params=None):
      r"""SearchForInstances returns a list of matching instances. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebSearchForInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/instances',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.searchForInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebSearchForInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForSeries(self, request, global_params=None):
      r"""SearchForSeries returns a list of matching series. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebSearchForSeriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForSeries')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForSeries.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/series',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.searchForSeries',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebSearchForSeriesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForStudies(self, request, global_params=None):
      r"""SearchForStudies returns a list of matching studies. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebSearchForStudiesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForStudies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForStudies.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.searchForStudies',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebSearchForStudiesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def StoreInstances(self, request, global_params=None):
      r"""StoreInstances stores DICOM instances associated with study instance unique.
identifiers (SUID). See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStoreInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('StoreInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StoreInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.dicomWeb.storeInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDicomWebStoreInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores resource."""

    _NAME = u'projects_locations_datasets_dicomStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDicomStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DICOM store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'dicomStoreId'],
        relative_path=u'v1alpha2/{+parent}/dicomStores',
        request_field=u'dicomStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified DICOM store and removes all images that are contained.
within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports data to the specified destination by copying it from the DICOM.
store.
The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.export',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:export',
        request_field=u'exportDicomDataRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified DICOM store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresGetRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Imports data into the DICOM store by copying it from the specified source.
For errors, the Operation is populated with error details (in the form
of ImportDicomDataErrorDetails in error.details), which holds
finer-grained error information. Errors are also logged to Stackdriver
Logging. For more information, see
[Viewing logs](/healthcare/docs/how-tos/stackdriver-logging).
The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.import',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:import',
        request_field=u'importDicomDataRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the DICOM stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDicomStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/dicomStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresListRequest',
        response_type_name=u'ListDicomStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified DICOM store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'dicomStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsFhirStoresFhirService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_fhirStores_fhir resource."""

    _NAME = u'projects_locations_datasets_fhirStores_fhir'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsFhirStoresFhirService, self).__init__(client)
      self._upload_configs = {
          }

    def Observation_lastn(self, request, global_params=None):
      r"""Retrieves the N most recent `Observation` resources for a subject matching.
search criteria specified as query parameters, grouped by
`Observation.code`, sorted from most recent to oldest.

Implements the FHIR extended operation Observation-lastn
([STU3](http://hl7.org/implement/standards/fhir/STU3/observation-operations.html#lastn)
or
[R4](http://hl7.org/implement/standards/fhir/R4/observation-operations.html#lastn)).

DSTU2 doesn't define the Observation-lastn method, but the server supports
it the same way it supports STU3.

Search terms are provided as query parameters following the same pattern as
the search method. The following search parameters must
be provided:

    - `subject` or `patient` to specify a subject for the Observation.
    - `code`, `category` or any of the composite parameters that include
      `code`.

Any other valid Observation search parameters can also be provided. This
operation accepts an additional query parameter `max`, which specifies N,
the maximum number of Observations to return from each group, with a
default of 1.

Searches with over 1000 results are rejected. Results are counted before
grouping and limiting the results with `max`. To stay within the limit,
constrain these searches using Observation search parameters such as
`_lastUpdated` or `date`.

On success, the response body contains a JSON-encoded representation
of a `Bundle` resource of type `searchset`, containing the results of the
operation.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirObservationLastnRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Observation_lastn')
      return self._RunMethod(
          config, request, global_params=global_params)

    Observation_lastn.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/Observation/$lastn',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.Observation-lastn',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/fhir/Observation/$lastn',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirObservationLastnRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Patient_everything(self, request, global_params=None):
      r"""Retrieves all the resources directly referenced by a patient, as well as.
all of the resources in the patient compartment.

Implements the FHIR extended operation Patient-everything
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/patient-operations.html#everything),
[STU3](http://hl7.org/implement/standards/fhir/STU3/patient-operations.html#everything),
or
[R4](http://hl7.org/implement/standards/fhir/R4/patient-operations.html#everything)).

On success, the response body contains a JSON-encoded representation
of a `Bundle` resource of type `searchset`, containing the results of the
operation.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirPatientEverythingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Patient_everything')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patient_everything.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/Patient/{PatientId}/$everything',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.Patient-everything',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'_count', u'_page_token', u'end', u'start'],
        relative_path=u'v1alpha2/{+name}/$everything',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirPatientEverythingRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Resource_purge(self, request, global_params=None):
      r"""Deletes all the historical versions of a resource (excluding the current.
version) from the FHIR store. To remove all versions of a resource, first
delete the current version and then call this method.

This is not a FHIR standard operation.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirResourcePurgeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Resource_purge')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resource_purge.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}/$purge',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.Resource-purge',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}/$purge',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirResourcePurgeRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Capabilities(self, request, global_params=None):
      r"""Gets the.
[FHIR STU3 capability
statement](http://hl7.org/implement/standards/fhir/STU3/capabilitystatement.html),
the [FHIR DSTU2 conformance
statement](http://hl7.org/implement/standards/fhir/DSTU2/conformance.html),
or the [FHIR R4 capability
statement](http://hl7.org/implement/standards/fhir/R4/capabilitystatement.html)
for the store. Each statement contains a description of the
functionality supported by the server.

Implements the
[FHIR STU3 standard capabilities
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#capabilities),
the [FHIR DSTU2 conformance
interaction](http://hl7.org/implement/standards/fhir/DSTU2/http.html#conformance),
or the [FHIR R4 standard capabilities
interaction](http://hl7.org/implement/standards/fhir/R4/http.html#capabilities).

On success, the response body contains a JSON-encoded representation
of a `CapabilityStatement` resource.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirCapabilitiesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Capabilities')
      return self._RunMethod(
          config, request, global_params=global_params)

    Capabilities.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.capabilities',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}/fhir/metadata',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirCapabilitiesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def ConditionalDelete(self, request, global_params=None):
      r"""Deletes FHIR resources that match a search query.

Implements the FHIR standard conditional delete interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.12.1),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.13.1),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#2.21.0.13.1)).
If multiple resources match, all of them are deleted.

Search terms are provided as query parameters following the same pattern as
the search method.

Note: Unless resource versioning is disabled by setting the
disable_resource_versioning flag
on the FHIR store, the deleted resources are moved to a history
repository that can still be retrieved through vread
and related methods, unless they are removed by the
purge method.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('ConditionalDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConditionalDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.conditionalDelete',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/fhir/{+type}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def ConditionalPatch(self, request, global_params=None):
      r"""If a resource is found based on the search criteria specified in the query.
parameters, updates part of that resource by applying the operations
specified in a [JSON Patch](http://jsonpatch.com/) document.

Implements the FHIR standard conditional patch interaction
([STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#patch) or
[R4](http://hl7.org/implement/standards/fhir/R4/http.html#patch)).

DSTU2 doesn't define a conditional patch method, but the server supports it
in the same way it supports STU3.

Search terms are provided as query parameters following the same pattern as
the search method.

If the search criteria identify more than one match, the request returns a
`412 Precondition Failed` error.

The request body must contain a JSON Patch document, and the request
headers must contain `Content-Type: application/json-patch+json`.

On success, the response body contains a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('ConditionalPatch')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConditionalPatch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.conditionalPatch',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/fhir/{+type}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalPatchRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def ConditionalUpdate(self, request, global_params=None):
      r"""If a resource is found based on the search criteria specified in the query.
parameters, updates the entire contents of that resource.

Implements the FHIR standard conditional update interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.10.2),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#cond-update),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#cond-update)).

Search terms are provided as query parameters following the same pattern as
the search method.

If the search criteria identify more than one match, the request
returns a `412 Precondition Failed` error.
If the search criteria identify zero matches, the supplied resource
body contains an `id`, and the FHIR store has
enable_update_create set, creates the
resource with the client-specified ID. If the search criteria identify zero
matches and the supplied resource body does not contain an `id`, the
resource is created with a server-assigned ID as per the
create method.

The request body must contain a JSON-encoded FHIR resource and the request
headers must contain `Content-Type: application/fhir+json`.

On success, the response body contains a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('ConditionalUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConditionalUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'PUT',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.conditionalUpdate',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/fhir/{+type}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a FHIR resource.

Implements the FHIR standard create interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#create),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#create),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#create)),
which creates a new resource with a server-assigned resource ID.

Also supports the FHIR standard conditional create interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#ccreate),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#ccreate),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#ccreate)),
specified by supplying an `If-None-Exist` header containing a FHIR search
query. If no resources match this search query, the server processes the
create operation as normal.

The request body must contain a JSON-encoded FHIR resource, and the request
headers must contain `Content-Type: application/fhir+json`.

On success, the response body contains a JSON-encoded representation
of the resource as it was created on the server, including the
server-assigned resource ID and version ID.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.create',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/fhir/{+type}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirCreateRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a FHIR resource.

Implements the FHIR standard delete interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#delete),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#delete),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#delete)).

Note: Unless resource versioning is disabled by setting the
disable_resource_versioning flag
on the FHIR store, the deleted resources are moved to a history
repository that can still be retrieved through vread
and related methods, unless they are removed by the
purge method.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirDeleteRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def ExecuteBundle(self, request, global_params=None):
      r"""Executes all the requests in the given Bundle.

Implements the FHIR standard batch/transaction interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#transaction),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#transaction),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#transaction)).

Supports all interactions in a bundle except search. This method
accepts Bundles of type `batch` and `transaction`, processing them
according to the batch processing rules
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.16.1),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.1),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#2.21.0.17.1))
and transaction processing rules
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.16.2),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.2),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#2.21.0.17.2)).

The request body must contain a JSON-encoded FHIR `Bundle` resource, and
the request headers must contain `Content-Type: application/fhir+json`.

For a batch bundle or a successful transaction, the response body
contains a JSON-encoded representation of a `Bundle` resource of type
`batch-response` or `transaction-response`. The resource contains one entry
for each entry in the request with the outcome of processing the entry.

In the case of an error for a transaction bundle, the response body
contains a JSON-encoded `OperationOutcome` resource describing the reason
for the error. If the request cannot be mapped to a valid API method on a
FHIR store, a generic GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirExecuteBundleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('ExecuteBundle')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExecuteBundle.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.executeBundle',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/fhir',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirExecuteBundleRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def History(self, request, global_params=None):
      r"""Lists all the versions of a resource (including the current version and.
deleted versions) from the FHIR store.

Implements the per-resource form of the FHIR standard history interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#history),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#history),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#history)).

On success, the response body contains a JSON-encoded representation
of a `Bundle` resource of type `history`, containing the version history
sorted from most recent to oldest versions.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirHistoryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('History')
      return self._RunMethod(
          config, request, global_params=global_params)

    History.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}/_history',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.history',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'_at', u'_count', u'_since'],
        relative_path=u'v1alpha2/{+name}/_history',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirHistoryRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates part of an existing resource by applying the operations specified.
in a [JSON Patch](http://jsonpatch.com/) document.

Implements the FHIR standard patch interaction
([STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#patch) or
[R4](http://hl7.org/implement/standards/fhir/R4/http.html#patch)).

DSTU2 doesn't define a patch method, but the server supports it in the same
way it supports STU3.

The request body must contain a JSON Patch document, and the request
headers must contain `Content-Type: application/json-patch+json`.

On success, the response body contains a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirPatchRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Read(self, request, global_params=None):
      r"""Gets the contents of a FHIR resource.

Implements the FHIR standard read interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#read),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#read),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#read)).

Also supports the FHIR standard conditional read interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#cread),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#cread),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#cread))
specified by supplying an `If-Modified-Since` header with a date/time value
or an `If-None-Match` header with an ETag value.

On success, the response body contains a JSON-encoded representation
of the resource.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Read')
      return self._RunMethod(
          config, request, global_params=global_params)

    Read.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.read',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirReadRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for resources in the given FHIR store according to criteria.
specified as query parameters.

Implements the FHIR standard search interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#search),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#search),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#search))
using the search semantics described in the FHIR Search specification
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/search.html),
[STU3](http://hl7.org/implement/standards/fhir/STU3/search.html),
or [R4](http://hl7.org/implement/standards/fhir/R4/search.html)).

Supports three methods of search defined by the specification:

*  `GET [base]?[parameters]` to search across all resources.
*  `GET [base]/[type]?[parameters]` to search resources of a specified
type.
*  `POST [base]/[type]/_search?[parameters]` as an alternate form having
the same semantics as the `GET` method.

The `GET` methods do not support compartment searches. The `POST` method
does not support `application/x-www-form-urlencoded` search parameters.

On success, the response body contains a JSON-encoded representation
of a `Bundle` resource of type `searchset`, containing the results of the
search.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

The server's capability statement, retrieved through
capabilities, indicates the search parameters
that are supported on each FHIR resource. For the list of search
parameters, see the
[STU3 FHIR Search Parameter
Registry](http://hl7.org/implement/standards/fhir/STU3/searchparameter-registry.html)
or [R4 FHIR Search Parameter
Registry](http://hl7.org/implement/standards/fhir/R4/searchparameter-registry.html).
For the FHIR search parameters for DSTU2, see each resource's definition
page.

Supported search modifiers: `:missing`, `:exact`, `:contains`, `:text`,
`:in`, `:not-in`, `:above`, `:below`, `:[type]`, `:not`, and `:recurse`.

Supported search result parameters: `_sort`, `_count`, `_include`,
`_revinclude`, `_summary=text`, `_summary=data`, and `_elements`.

The maximum number of search results returned defaults to 100, which can
be overridden by the `_count` parameter up to a maximum limit of 1000. If
there are additional results, the returned `Bundle` contains
pagination links.

Resources with a total size larger than 5MB or a field count larger than
50,000 might not be fully searchable as the server might trim its generated
search index in those cases.

Note: FHIR resources are indexed asynchronously, so there might be a slight
delay between the time a resource is created or changes and when the change
is reflected in search results.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/_search',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.search',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/fhir/_search',
        request_field=u'searchResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirSearchRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the entire contents of a resource.

Implements the FHIR standard update interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#update),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#update),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#update)).

If the specified resource does
not exist and the FHIR store has
enable_update_create set, creates the
resource with the client-specified ID.

The request body must contain a JSON-encoded FHIR resource, and the request
headers must contain `Content-Type: application/fhir+json`. The resource
must contain an `id` element having an identical value to the ID in the
REST path of the request.

On success, the response body contains a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'PUT',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirUpdateRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Vread(self, request, global_params=None):
      r"""Gets the contents of a version (current or historical) of a FHIR resource.
by version ID.

Implements the FHIR standard vread interaction
([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#vread),
[STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#vread),
or [R4](http://hl7.org/implement/standards/fhir/R4/http.html#vread)).

On success, the response body contains a JSON-encoded representation
of the resource.
Errors generated by the FHIR store contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirVreadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Vread')
      return self._RunMethod(
          config, request, global_params=global_params)

    Vread.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}/_history/{_historyId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.vread',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirVreadRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsFhirStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_fhirStores resource."""

    _NAME = u'projects_locations_datasets_fhirStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsFhirStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new FHIR store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'fhirStoreId'],
        relative_path=u'v1alpha2/{+parent}/fhirStores',
        request_field=u'fhirStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified FHIR store and removes all resources within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Export resources from the FHIR store to the specified destination.

This method returns an Operation that can
be used to track the status of the export by calling
GetOperation.

Immediate fatal errors appear in the
error field, errors are also logged
to Stackdriver (see [Viewing
logs](/healthcare/docs/how-tos/stackdriver-logging)).
Otherwise, when the operation finishes, a detailed response of type
ExportResourcesResponse is returned in the
response field.
The metadata field type for this
operation is OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.export',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:export',
        request_field=u'exportResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the configuration of the specified FHIR store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresGetRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Import resources to the FHIR store by loading data from the specified.
sources. This method is optimized to load large quantities of data using
import semantics that ignore some FHIR store configuration options and are
not suitable for all use cases. It is primarily intended to load data into
an empty FHIR store that is not being used by other clients. In cases
where this method is not appropriate, consider using ExecuteBundle to
load data.

Every resource in the input must contain a client-supplied ID and is
stored using that ID regardless of the
enable_update_create setting on the FHIR
store.

The import process does not enforce referential integrity, regardless of
the
disable_referential_integrity
setting on the FHIR store. This allows the import of resources with
arbitrary interdependencies without considering grouping or ordering, but
if the input data contains invalid references or if some resources fail to
be imported, the FHIR store might be left in a state that violates
referential integrity.

If a resource with the specified ID already exists, the most recent
version of the resource is overwritten without creating a new historical
version, regardless of the
disable_resource_versioning
setting on the FHIR store. If transient failures occur during the import,
successfully imported resources could be overwritten more than once.

The import operation is idempotent unless the input data contains multiple
valid resources with the same ID but different contents. In that case,
after the import completes, the store contains exactly one resource
with that ID but there is no ordering guarantee on which version of the
contents it has. The operation result counters do not count
duplicate IDs as an error and count one success for each resource in
the input, which might result in a success count larger than the number
of resources in the FHIR store. This often occurs when importing data
organized in bundles produced by Patient-everything
where each bundle contains its own copy of a resource such as Practitioner
that might be referred to by many patients.

If some resources fail to import, for example due to parsing errors,
successfully imported resources are not rolled back.

The location and format of the input data is specified by the parameters
below. Note that if no format is specified, this method assumes the
`BUNDLE` format. When using the `BUNDLE` format this method ignores the
`Bundle.type` field, except that `history` bundles are rejected, and does
not apply any of the bundle processing semantics for batch or transaction
bundles. Unlike in ExecuteBundle, transaction bundles are not executed
as a single transaction and bundle-internal references are not rewritten.
The bundle is treated as a collection of resources to be written as
provided in `Bundle.entry.resource`, ignoring `Bundle.entry.request`. As
an example, this allows the import of `searchset` bundles produced by a
FHIR search or
Patient-everything operation.

This method returns an Operation that can
be used to track the status of the import by calling
GetOperation.

Immediate fatal errors appear in the
error field, errors are also logged
to Stackdriver (see [Viewing
logs](/healthcare/docs/how-tos/stackdriver-logging)). Otherwise, when the
operation finishes, a detailed response of type ImportResourcesResponse
is returned in the response field.
The metadata field type for this
operation is OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.import',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:import',
        request_field=u'importResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the FHIR stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFhirStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/fhirStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresListRequest',
        response_type_name=u'ListFhirStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the configuration of the specified FHIR store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'fhirStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsHl7V2StoresMessagesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_hl7V2Stores_messages resource."""

    _NAME = u'projects_locations_datasets_hl7V2Stores_messages'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsHl7V2StoresMessagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a message and sends a notification to the Cloud Pub/Sub topic. If.
configured, the MLLP adapter listens to messages created by this method and
sends those back to the hospital. A successful response indicates the
message has been persisted to storage and a Cloud Pub/Sub notification has
been sent. Sending to the hospital by the MLLP adapter happens
asynchronously.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Message) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/messages',
        request_field=u'createMessageRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest',
        response_type_name=u'Message',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an HL7v2 message.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages/{messagesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an HL7v2 message.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Message) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages/{messagesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'view'],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest',
        response_type_name=u'Message',
        supports_download=False,
    )

    def Ingest(self, request, global_params=None):
      r"""Ingests a new HL7v2 message from the hospital and sends a notification to.
the Cloud Pub/Sub topic. Return is an HL7v2 ACK message if the message was
successfully stored. Otherwise an error is returned.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IngestMessageResponse) The response message.
      """
      config = self.GetMethodConfig('Ingest')
      return self._RunMethod(
          config, request, global_params=global_params)

    Ingest.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages:ingest',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.ingest',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/messages:ingest',
        request_field=u'ingestMessageRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest',
        response_type_name=u'IngestMessageResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the messages in the given HL7v2 store with support for filtering.

Note: HL7v2 messages are indexed asynchronously, so there might be a slight
delay between the time a message is created and when it can be found
through a filter.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMessagesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/messages',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest',
        response_type_name=u'ListMessagesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update the message.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Message) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages/{messagesId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'message',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest',
        response_type_name=u'Message',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsHl7V2StoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_hl7V2Stores resource."""

    _NAME = u'projects_locations_datasets_hl7V2Stores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsHl7V2StoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new HL7v2 store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'hl7V2StoreId'],
        relative_path=u'v1alpha2/{+parent}/hl7V2Stores',
        request_field=u'hl7V2Store',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HL7v2 store and removes all messages that are.
contained within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified HL7v2 store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the HL7v2 stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListHl7V2StoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/hl7V2Stores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest',
        response_type_name=u'ListHl7V2StoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the HL7v2 store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'hl7V2Store',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_operations resource."""

    _NAME = u'projects_locations_datasets_operations'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (HealthcareProjectsLocationsDatasetsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (HealthcareProjectsLocationsDatasetsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/operations',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+name}/operations',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets resource."""

    _NAME = u'projects_locations_datasets'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new health dataset. Results are returned through the.
Operation interface which returns either an
`Operation.response` which contains a Dataset or
`Operation.error`. The metadata
field type is OperationMetadata.
A Google Cloud Platform project can contain up to 500 datasets across all
regions.

      Args:
        request: (HealthcareProjectsLocationsDatasetsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'datasetId'],
        relative_path=u'v1alpha2/{+parent}/datasets',
        request_field=u'dataset',
        request_type_name=u'HealthcareProjectsLocationsDatasetsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Deidentify(self, request, global_params=None):
      r"""Creates a new dataset containing de-identified data from the source.
dataset. The metadata field type
is OperationMetadata.
If the request is successful, the
response field type is
DeidentifySummary.
If errors occur, the
error
details field type is
DeidentifyErrorDetails.
Errors are also logged to Stackdriver Logging. For more information, see
[Viewing logs](/healthcare/docs/how-tos/stackdriver-logging).

      Args:
        request: (HealthcareProjectsLocationsDatasetsDeidentifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Deidentify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deidentify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:deidentify',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.deidentify',
        ordered_params=[u'sourceDataset'],
        path_params=[u'sourceDataset'],
        query_params=[],
        relative_path=u'v1alpha2/{+sourceDataset}:deidentify',
        request_field=u'deidentifyDatasetRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDeidentifyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified health dataset and all data contained in the dataset.
Deleting a dataset does not affect the sources from which the dataset was
imported (if any).

      Args:
        request: (HealthcareProjectsLocationsDatasetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets any metadata associated with a dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsGetRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the health datasets in the current project.

      Args:
        request: (HealthcareProjectsLocationsDatasetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatasetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/datasets',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsListRequest',
        response_type_name=u'ListDatasetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates dataset metadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'dataset',
        request_type_name=u'HealthcareProjectsLocationsDatasetsPatchRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (HealthcareProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (HealthcareProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+name}/locations',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
