"""Generated message classes for cloudidentity version v1alpha1.

API for provisioning and managing identity resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudidentity'


class CloudidentityGroupsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsCreateRequest object.

  Enums:
    InitialGroupConfigValueValuesEnum: Initial configuration for creating the
      Group.

  Fields:
    group: A Group resource to be passed as the request body.
    initialGroupConfig: Initial configuration for creating the Group.
  """

  class InitialGroupConfigValueValuesEnum(_messages.Enum):
    r"""Initial configuration for creating the Group.

    Values:
      INITIAL_GROUP_CONFIG_UNSPECIFIED: <no description>
      WITH_INITIAL_OWNER: <no description>
      EMPTY: <no description>
    """
    INITIAL_GROUP_CONFIG_UNSPECIFIED = 0
    WITH_INITIAL_OWNER = 1
    EMPTY = 2

  group = _messages.MessageField('Group', 1)
  initialGroupConfig = _messages.EnumField('InitialGroupConfigValueValuesEnum', 2)


class CloudidentityGroupsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsDeleteRequest object.

  Fields:
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Group in the format: `groups/{group_id}`, where `group_id` is the
      unique ID assigned to the Group.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsGetRequest object.

  Fields:
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Group in the format: `groups/{group_id}`, where `group_id` is the
      unique ID assigned to the Group.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsListRequest(_messages.Message):
  r"""A CloudidentityGroupsListRequest object.

  Enums:
    ViewValueValuesEnum: Group resource view to be returned. Defaults to
      [View.BASIC]().

  Fields:
    pageSize: The default page size is 200 (max 1000) for the BASIC view, and
      50 (max 500) for the FULL view.
    pageToken: The next_page_token value returned from a previous list
      request, if any.
    parent: `Required`. May be made Optional in the future. Customer ID to
      list all groups from.
    view: Group resource view to be returned. Defaults to [View.BASIC]().
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Group resource view to be returned. Defaults to [View.BASIC]().

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsLookupRequest object.

  Fields:
    groupKey_id: The ID of the entity within the given namespace. The ID must
      be unique within its namespace.
    groupKey_namespace: Namespaces provide isolation for IDs, so an ID only
      needs to be unique within its namespace.  Namespaces are currently only
      created as part of IdentitySource creation from Admin Console. A
      namespace `"identitysources/{identity_source_id}"` is created
      corresponding to every Identity Source `identity_source_id`.
  """

  groupKey_id = _messages.StringField(1)
  groupKey_namespace = _messages.StringField(2)


class CloudidentityGroupsMembershipsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsCreateRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    parent: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Group
      to create Membership within. Format: `groups/{group_id}`, where
      `group_id` is the unique ID assigned to the Group.
  """

  membership = _messages.MessageField('Membership', 1)
  parent = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsDeleteRequest object.

  Fields:
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Membership to be deleted.  Format:
      `groups/{group_id}/memberships/{member_id}`, where `group_id` is the
      unique ID assigned to the Group to which Membership belongs to, and
      member_id is the unique ID assigned to the member.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsGetRequest object.

  Fields:
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Membership to be retrieved.  Format:
      `groups/{group_id}/memberships/{member_id}`, where `group_id` is the
      unique id assigned to the Group to which Membership belongs to, and
      `member_id` is the unique ID assigned to the member.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsListRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsListRequest object.

  Enums:
    ViewValueValuesEnum: Membership resource view to be returned. Defaults to
      View.BASIC.

  Fields:
    pageSize: The default page size is 200 (max 1000) for the BASIC view, and
      50 (max 500) for the FULL view.
    pageToken: The next_page_token value returned from a previous list
      request, if any.
    parent: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Group
      to list Memberships within.  Format: `groups/{group_id}`, where
      `group_id` is the unique ID assigned to the Group.
    view: Membership resource view to be returned. Defaults to View.BASIC.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Membership resource view to be returned. Defaults to View.BASIC.

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsMembershipsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsLookupRequest object.

  Fields:
    memberKey_id: The ID of the entity within the given namespace. The ID must
      be unique within its namespace.
    memberKey_namespace: Namespaces provide isolation for IDs, so an ID only
      needs to be unique within its namespace.  Namespaces are currently only
      created as part of IdentitySource creation from Admin Console. A
      namespace `"identitysources/{identity_source_id}"` is created
      corresponding to every Identity Source `identity_source_id`.
    parent: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Group
      to lookup Membership within.  Format: `groups/{group_id}`, where
      `group_id` is the unique ID assigned to the Group.
  """

  memberKey_id = _messages.StringField(1)
  memberKey_namespace = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudidentityGroupsMembershipsModifyMembershipRolesRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsModifyMembershipRolesRequest object.

  Fields:
    modifyMembershipRolesRequest: A ModifyMembershipRolesRequest resource to
      be passed as the request body.
    name: [membership resource name]
      (https://cloud.google.com/apis/design/resource_names) of the Membership
      in the format: `groups/{group_id}/memberships/{member_id}`, where
      group_id is the unique ID assigned to the Group to which Membership
      belongs to, and member_id is the unique ID assigned to the member.
  """

  modifyMembershipRolesRequest = _messages.MessageField('ModifyMembershipRolesRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsPatchRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Membership in the format: `groups/{group_id}/memberships/{member_id}`,
      where group_id is the unique ID assigned to the Group to which
      Membership belongs to, and member_id is the unique ID assigned to the
      member  Must be left blank while creating a Membership.
    updateMask: A string attribute.
  """

  membership = _messages.MessageField('Membership', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsPatchRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Group
      in the format: `groups/{group_id}`, where group_id is the unique ID
      assigned to the Group.  Must be left blank while creating a Group.
    updateMask: Editable fields: `display_name`, `description`
  """

  group = _messages.MessageField('Group', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsSearchRequest(_messages.Message):
  r"""A CloudidentityGroupsSearchRequest object.

  Enums:
    ViewValueValuesEnum: Group resource view to be returned. Defaults to
      [View.BASIC]().

  Fields:
    pageSize: The default page size is 200 (max 1000) for the BASIC view, and
      50 (max 500) for the FULL view.
    pageToken: The next_page_token value returned from a previous search
      request, if any.
    query: `Required`. Query string for performing search on groups. Users can
      search on parent and label attributes of groups. EXACT match ('==') is
      supported on parent, and CONTAINS match ('in') is supported on labels.
    view: Group resource view to be returned. Defaults to [View.BASIC]().
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Group resource view to be returned. Defaults to [View.BASIC]().

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  query = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class DynamicGroupMetadata(_messages.Message):
  r"""Dynamic group metadata like queries and status.

  Fields:
    queries: Only one entry is supported for now. Memberships will be the
      union of all queries.
    status: Status of the dynamic group. Output only.
  """

  queries = _messages.MessageField('DynamicGroupQuery', 1, repeated=True)
  status = _messages.MessageField('DynamicGroupStatus', 2)


class DynamicGroupQuery(_messages.Message):
  r"""Defines a query on a resource.

  Enums:
    ResourceTypeValueValuesEnum:

  Fields:
    query: Query that determines the memberships of the dynamic group.
    resourceType: A ResourceTypeValueValuesEnum attribute.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""ResourceTypeValueValuesEnum enum type.

    Values:
      RESOURCE_TYPE_UNSPECIFIED: <no description>
      USER: <no description>
    """
    RESOURCE_TYPE_UNSPECIFIED = 0
    USER = 1

  query = _messages.StringField(1)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 2)


class DynamicGroupStatus(_messages.Message):
  r"""The current status of a dynamic group along with timestamp.

  Enums:
    StatusValueValuesEnum: Status of the dynamic group.

  Fields:
    status: Status of the dynamic group.
    statusTime: The latest time at which the dynamic group is guaranteed to be
      in the given status. For example, if status is: UP_TO_DATE - The latest
      time at which this dynamic group was confirmed to be up to date.
      UPDATING_MEMBERSHIPS - The time at which dynamic group was created.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the dynamic group.

    Values:
      STATUS_UNSPECIFIED: Default.
      UP_TO_DATE: The dynamic group is up-to-date.
      UPDATING_MEMBERSHIPS: The dynamic group has just been created and
        memberships are being updated.
    """
    STATUS_UNSPECIFIED = 0
    UP_TO_DATE = 1
    UPDATING_MEMBERSHIPS = 2

  status = _messages.EnumField('StatusValueValuesEnum', 1)
  statusTime = _messages.StringField(2)


class EntityKey(_messages.Message):
  r"""An EntityKey uniquely identifies an Entity. Namespaces are used to
  provide isolation for IDs. A single ID can be reused across namespaces but
  the combination of a namespace and an ID must be unique.

  Fields:
    id: The ID of the entity within the given namespace. The ID must be unique
      within its namespace.
    namespace: Namespaces provide isolation for IDs, so an ID only needs to be
      unique within its namespace.  Namespaces are currently only created as
      part of IdentitySource creation from Admin Console. A namespace
      `"identitysources/{identity_source_id}"` is created corresponding to
      every Identity Source `identity_source_id`.
  """

  id = _messages.StringField(1)
  namespace = _messages.StringField(2)


class Group(_messages.Message):
  r"""Resource representing a Group.

  Messages:
    LabelsValue: Required. `Required` while Group creation. Labels for Group
      resource. Use values ('system/groups/external','') and
      ('system/groups/discussion_forum', '') for creating an external or
      discussion forum Group respectively.

  Fields:
    createTime: Output only. The time when the Group was created. Output only.
    description: An extended description to help users determine the purpose
      of a Group. For example, you can include information about who should
      join the Group, the types of messages to send to the Group, links to
      FAQs about the Group, or related Groups. Maximum length is 4,096
      characters.
    displayName: The Group's display name.
    dynamicGroupMetadata: Dynamic group metadata like queries and status.
    groupKey: Required. Immutable. EntityKey of the Group.  Must be set when
      creating a Group, read-only afterwards.
    labels: Required. `Required` while Group creation. Labels for Group
      resource. Use values ('system/groups/external','') and
      ('system/groups/discussion_forum', '') for creating an external or
      discussion forum Group respectively.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Group
      in the format: `groups/{group_id}`, where group_id is the unique ID
      assigned to the Group.  Must be left blank while creating a Group.
    parent: Required. Immutable. The entity under which this Group resides in
      Cloud Identity resource hierarchy. Must be set when creating a Group,
      read-only afterwards.  Currently allowed types: `identitysources` and
      `customers`.
    updateTime: Output only. The time when the Group was last updated. Output
      only.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Required. `Required` while Group creation. Labels for Group resource.
    Use values ('system/groups/external','') and
    ('system/groups/discussion_forum', '') for creating an external or
    discussion forum Group respectively.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  dynamicGroupMetadata = _messages.MessageField('DynamicGroupMetadata', 4)
  groupKey = _messages.MessageField('EntityKey', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  parent = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class ListGroupsResponse(_messages.Message):
  r"""Response message for ListGroups operation.

  Fields:
    groups: Groups returned in response to list request. The results are not
      sorted.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results available for listing.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMembershipsResponse(_messages.Message):
  r"""A ListMembershipsResponse object.

  Fields:
    memberships: List of Memberships.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results available for listing.
  """

  memberships = _messages.MessageField('Membership', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class LookupGroupNameResponse(_messages.Message):
  r"""A LookupGroupNameResponse object.

  Fields:
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Group in the format: `groups/{group_id}`, where `group_id` is the
      unique ID assigned to the Group.
  """

  name = _messages.StringField(1)


class LookupMembershipNameResponse(_messages.Message):
  r"""A LookupMembershipNameResponse object.

  Fields:
    name: [Resource name](https://cloud.google.com/apis/design/resource_names)
      of the Membership being looked up.  Format:
      `groups/{group_id}/memberships/{member_id}`, where `group_id` is the
      unique ID assigned to the Group to which Membership belongs to, and
      `member_id` is the unique ID assigned to the member.
  """

  name = _messages.StringField(1)


class Membership(_messages.Message):
  r"""Resource representing a Membership within a Group

  Fields:
    createTime: Output only. Creation timestamp of the Membership. Output
      only.
    expiryDetail: Expiry details of the Membership. It can be set only during
      the Membership creation/update time.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Membership in the format: `groups/{group_id}/memberships/{member_id}`,
      where group_id is the unique ID assigned to the Group to which
      Membership belongs to, and member_id is the unique ID assigned to the
      member  Must be left blank while creating a Membership.
    preferredMemberKey: Required. Immutable. EntityKey of the entity to be
      added as the member. Must be set while creating a Membership, read-only
      afterwards.  Currently allowed entity types: `Users`, `Groups`.
    roles: Roles for a member within the Group.  Currently supported
      MembershipRoles: `"MEMBER"`.
    updateTime: Output only. Last updated timestamp of the Membership. Output
      only.
  """

  createTime = _messages.StringField(1)
  expiryDetail = _messages.MessageField('MembershipExpiryDetail', 2)
  name = _messages.StringField(3)
  preferredMemberKey = _messages.MessageField('EntityKey', 4)
  roles = _messages.MessageField('MembershipRole', 5, repeated=True)
  updateTime = _messages.StringField(6)


class MembershipExpiryDetail(_messages.Message):
  r"""Specifies Membership expiry attributes.

  Fields:
    expireTime: Expiration time for the Membership.
  """

  expireTime = _messages.StringField(1)


class MembershipRole(_messages.Message):
  r"""Resource representing a role within a Membership.

  Fields:
    expiryDetail: Expiry details of the MembershipRole. Currently supported
      MembershipRoles: `"MEMBER"`.
    name: MembershipRole in string format. Currently supported
      MembershipRoles: `"MEMBER", "OWNER", "MANAGER"`.
  """

  expiryDetail = _messages.MessageField('MembershipRoleExpiryDetail', 1)
  name = _messages.StringField(2)


class MembershipRoleExpiryDetail(_messages.Message):
  r"""Specifies Membership expiry attributes.

  Fields:
    expireTime: Expiration time for the Membership.
  """

  expireTime = _messages.StringField(1)


class ModifyMembershipRolesRequest(_messages.Message):
  r"""A ModifyMembershipRolesRequest object.

  Fields:
    addRoles: Membership roles to be added. Currently supported
      MembershipRole: 'MEMBER', 'OWNER', 'MANAGER'.
    removeRoles: Membership role name to be removed. Currently supported
      MembershipRole: 'OWNER', 'MANAGER'. If removing all roles is needed,
      please use DeleteMembership to delete the whole membership resource.
      MEMBER-less owner is not supported so removing just MEMBER role won't be
      possible.
    updateRolesParams: Parameters to update membership roles.
  """

  addRoles = _messages.MessageField('MembershipRole', 1, repeated=True)
  removeRoles = _messages.StringField(2, repeated=True)
  updateRolesParams = _messages.MessageField('ModifyMembershipRolesRequestUpdateMembershipRolesParams', 3, repeated=True)


class ModifyMembershipRolesRequestUpdateMembershipRolesParams(_messages.Message):
  r"""Resource representing the parameters to update membership roles.

  Fields:
    fieldMask: Comma-separated list of fully qualified names of fields to be
      updated. See: http://shortn/_WfViTS7z9e for detail. Currently only
      support expiry_detail.
    membershipRole: Membership roles to be updated. Currently only support to
      update expiry_detail for 'MEMBER' role.
  """

  fieldMask = _messages.StringField(1)
  membershipRole = _messages.MessageField('MembershipRole', 2)


class ModifyMembershipRolesResponse(_messages.Message):
  r"""A ModifyMembershipRolesResponse object.

  Fields:
    membership: The membership resource after modifying the membership roles.
  """

  membership = _messages.MessageField('Membership', 1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class SearchGroupsResponse(_messages.Message):
  r"""A SearchGroupsResponse object.

  Fields:
    groups: List of Groups satisfying the search query.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results available for specified query.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
