"""Generated client library for healthcare version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.healthcare.v1beta1 import healthcare_v1beta1_messages as messages


class HealthcareV1beta1(base_api.BaseApiClient):
  """Generated client library for service healthcare version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://healthcare.googleapis.com/'

  _PACKAGE = u'healthcare'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'HealthcareV1beta1'
  _URL_VERSION = u'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new healthcare handle."""
    url = url or self.BASE_URL
    super(HealthcareV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_datasets_dicomStores_studies_series_instances_frames = self.ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService(self)
    self.projects_locations_datasets_dicomStores_studies_series_instances = self.ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService(self)
    self.projects_locations_datasets_dicomStores_studies_series = self.ProjectsLocationsDatasetsDicomStoresStudiesSeriesService(self)
    self.projects_locations_datasets_dicomStores_studies = self.ProjectsLocationsDatasetsDicomStoresStudiesService(self)
    self.projects_locations_datasets_dicomStores = self.ProjectsLocationsDatasetsDicomStoresService(self)
    self.projects_locations_datasets_fhirStores_fhir = self.ProjectsLocationsDatasetsFhirStoresFhirService(self)
    self.projects_locations_datasets_fhirStores = self.ProjectsLocationsDatasetsFhirStoresService(self)
    self.projects_locations_datasets_hl7V2Stores_messages = self.ProjectsLocationsDatasetsHl7V2StoresMessagesService(self)
    self.projects_locations_datasets_hl7V2Stores = self.ProjectsLocationsDatasetsHl7V2StoresService(self)
    self.projects_locations_datasets_operations = self.ProjectsLocationsDatasetsOperationsService(self)
    self.projects_locations_datasets = self.ProjectsLocationsDatasetsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_studies_series_instances_frames resource."""

    _NAME = u'projects_locations_datasets_dicomStores_studies_series_instances_frames'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService, self).__init__(client)
      self._upload_configs = {
          }

    def RetrieveFrames(self, request, global_params=None):
      r"""RetrieveFrames returns instances associated with the given study, series,.
SOP Instance UID and frame numbers. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveFrames')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveFrames.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/frames/{framesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveFrames',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveRendered(self, request, global_params=None):
      r"""RetrieveRenderedFrames returns instances associated with the given study,.
series, SOP Instance UID and frame numbers in an acceptable Rendered Media
Type. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveRendered')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveRendered.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/frames/{framesId}/rendered',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveRendered',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_studies_series_instances resource."""

    _NAME = u'projects_locations_datasets_dicomStores_studies_series_instances'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""DeleteInstance deletes an instance associated with the given study, series,.
and SOP Instance UID. Delete requests are equivalent to the GET requests
specified in the WADO-RS standard.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.instances.delete',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def RetrieveInstance(self, request, global_params=None):
      r"""RetrieveInstance returns instance associated with the given study, series,.
and SOP Instance UID. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveInstance.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveInstance',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveMetadata(self, request, global_params=None):
      r"""RetrieveInstanceMetadata returns instance associated with the given study,.
series, and SOP Instance UID presented as metadata with the bulk data
removed. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveMetadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveMetadata',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveRendered(self, request, global_params=None):
      r"""RetrieveRenderedInstance returns instance associated with the given study,.
series, and SOP Instance UID in an acceptable Rendered Media Type. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveRendered')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveRendered.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances/{instancesId}/rendered',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveRendered',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresStudiesSeriesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_studies_series resource."""

    _NAME = u'projects_locations_datasets_dicomStores_studies_series'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsDicomStoresStudiesSeriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""DeleteSeries deletes all instances within the given study and series.
Delete requests are equivalent to the GET requests specified in the WADO-RS
standard.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.delete',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def RetrieveMetadata(self, request, global_params=None):
      r"""RetrieveSeriesMetadata returns instance associated with the given study and.
series, presented as metadata with the bulk data removed. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveMetadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveMetadata',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveSeries(self, request, global_params=None):
      r"""RetrieveSeries returns all instances within the given study and series. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveSeries')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveSeries.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveSeries',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForInstances(self, request, global_params=None):
      r"""SearchForInstances returns a list of matching instances. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series/{seriesId}/instances',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.series.searchForInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresStudiesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores_studies resource."""

    _NAME = u'projects_locations_datasets_dicomStores_studies'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsDicomStoresStudiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""DeleteStudy deletes all instances within the given study. Delete requests.
are equivalent to the GET requests specified in the WADO-RS standard.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.delete',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def RetrieveMetadata(self, request, global_params=None):
      r"""RetrieveStudyMetadata returns instance associated with the given study.
presented as metadata with the bulk data removed. See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveMetadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.retrieveMetadata',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def RetrieveStudy(self, request, global_params=None):
      r"""RetrieveStudy returns all instances within the given study. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('RetrieveStudy')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveStudy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.retrieveStudy',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForInstances(self, request, global_params=None):
      r"""SearchForInstances returns a list of matching instances. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/instances',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.searchForInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForSeries(self, request, global_params=None):
      r"""SearchForSeries returns a list of matching series. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForSeries')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForSeries.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}/series',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.searchForSeries',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def StoreInstances(self, request, global_params=None):
      r"""StoreInstances stores DICOM instances associated with study instance unique.
identifiers (SUID). See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('StoreInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StoreInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies/{studiesId}',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.studies.storeInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores resource."""

    _NAME = u'projects_locations_datasets_dicomStores'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsDicomStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DICOM store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'dicomStoreId'],
        relative_path=u'v1beta1/{+parent}/dicomStores',
        request_field=u'dicomStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified DICOM store and removes all images that are contained.
within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports data to the specified destination by copying it from the DICOM.
store.
The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.export',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:export',
        request_field=u'exportDicomDataRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified DICOM store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresGetRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Imports data into the DICOM store by copying it from the specified source.
For errors, the Operation will be populated with error details (in the form
of ImportDicomDataErrorDetails in error.details), which will hold
finer-grained error information. Errors are also logged to Stackdriver
(see [Viewing logs](/healthcare/docs/how-tos/stackdriver-logging)).
The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.import',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:import',
        request_field=u'importDicomDataRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the DICOM stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDicomStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/dicomStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresListRequest',
        response_type_name=u'ListDicomStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified DICOM store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'dicomStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def SearchForInstances(self, request, global_params=None):
      r"""SearchForInstances returns a list of matching instances. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresSearchForInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/instances',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.searchForInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresSearchForInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForSeries(self, request, global_params=None):
      r"""SearchForSeries returns a list of matching series. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresSearchForSeriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForSeries')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForSeries.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/series',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.searchForSeries',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresSearchForSeriesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SearchForStudies(self, request, global_params=None):
      r"""SearchForStudies returns a list of matching studies. See.
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresSearchForStudiesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('SearchForStudies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchForStudies.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.searchForStudies',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresSearchForStudiesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def StoreInstances(self, request, global_params=None):
      r"""StoreInstances stores DICOM instances associated with study instance unique.
identifiers (SUID). See
http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresStoreInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('StoreInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StoreInstances.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}/dicomWeb/studies',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.storeInstances',
        ordered_params=[u'parent', u'dicomWebPath'],
        path_params=[u'dicomWebPath', u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/dicomWeb/{+dicomWebPath}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresStoreInstancesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsFhirStoresFhirService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_fhirStores_fhir resource."""

    _NAME = u'projects_locations_datasets_fhirStores_fhir'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsFhirStoresFhirService, self).__init__(client)
      self._upload_configs = {
          }

    def Observation_lastn(self, request, global_params=None):
      r"""Retrieves the N most recent `Observation` resources for a subject matching.
search criteria specified as query parameters, grouped by
`Observation.code`, sorted from most recent to oldest.

Implements the FHIR extended operation
[Observation-lastn](http://hl7.org/implement/standards/fhir/STU3/observation-operations.html#lastn).

Search terms are provided as query parameters following the same pattern as
the search method. This operation accepts an additional
query parameter `max`, which specifies N, the maximum number of
Observations to return from each group, with a default of 1.

On success, the response body will contain a JSON-encoded representation
of a `Bundle` resource of type `searchset`, containing the results of the
operation.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirObservationLastnRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Observation_lastn')
      return self._RunMethod(
          config, request, global_params=global_params)

    Observation_lastn.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/Observation/$lastn',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.Observation-lastn',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/fhir/Observation/$lastn',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirObservationLastnRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Patient_everything(self, request, global_params=None):
      r"""Retrieves all the resources directly referenced by a patient, as well as.
all of the resources in the patient compartment.

Implements the FHIR extended operation
[Patient-everything](http://hl7.org/implement/standards/fhir/STU3/patient-operations.html#everything).

On success, the response body will contain a JSON-encoded representation
of a `Bundle` resource of type `searchset`, containing the results of the
operation.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirPatientEverythingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Patient_everything')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patient_everything.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/Patient/{PatientId}/$everything',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.Patient-everything',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'_count', u'end', u'pageToken', u'start'],
        relative_path=u'v1beta1/{+name}/$everything',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirPatientEverythingRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Resource_purge(self, request, global_params=None):
      r"""Deletes all the historical versions of a resource (excluding the current.
version) from the FHIR store. To remove all versions of a resource, first
delete the current version and then call this method.

This is not a FHIR standard operation.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirResourcePurgeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Resource_purge')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resource_purge.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}/$purge',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.Resource-purge',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}/$purge',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirResourcePurgeRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Capabilities(self, request, global_params=None):
      r"""Gets the FHIR [capability.
statement](http://hl7.org/implement/standards/fhir/STU3/capabilitystatement.html)
for the store, which contains a description of functionality supported by
the server.

Implements the FHIR standard [capabilities
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#capabilities).

On success, the response body will contain a JSON-encoded representation
of a `CapabilityStatement` resource.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirCapabilitiesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Capabilities')
      return self._RunMethod(
          config, request, global_params=global_params)

    Capabilities.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/metadata',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.capabilities',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}/fhir/metadata',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirCapabilitiesRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def ConditionalDelete(self, request, global_params=None):
      r"""Deletes FHIR resources that match a search query.

Implements the FHIR standard [conditional delete
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.13.1).
If multiple resources match, all of them will be deleted.

Search terms are provided as query parameters following the same pattern as
the search method.

Note: Unless resource versioning is disabled by setting the
disable_resource_versioning flag
on the FHIR store, the deleted resources will be moved to a history
repository that can still be retrieved through vread
and related methods, unless they are removed by the
purge method.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('ConditionalDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConditionalDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.conditionalDelete',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/fhir/{+type}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def ConditionalPatch(self, request, global_params=None):
      r"""If a resource is found based on the search criteria specified in the query.
parameters, updates part of that resource by applying the operations
specified in a [JSON Patch](http://jsonpatch.com/) document.

Implements the FHIR standard [conditional patch
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#patch).

Search terms are provided as query parameters following the same pattern as
the search method.

If the search criteria identify more than one match, the request will
return a `412 Precondition Failed` error.

The request body must contain a JSON Patch document, and the request
headers must contain `Content-Type: application/json-patch+json`.

On success, the response body will contain a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('ConditionalPatch')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConditionalPatch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.conditionalPatch',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/fhir/{+type}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalPatchRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def ConditionalUpdate(self, request, global_params=None):
      r"""If a resource is found based on the search criteria specified in the query.
parameters, updates the entire contents of that resource.

Implements the FHIR standard [conditional update
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#cond-update).

Search terms are provided as query parameters following the same pattern as
the search method.

If the search criteria identify more than one match, the request will
return a `412 Precondition Failed` error.
If the search criteria identify zero matches, and the supplied resource
body contains an `id`, and the FHIR store has
enable_update_create set, creates the
resource with the client-specified ID. If the search criteria identify zero
matches, and the supplied resource body does not contain an `id`, the
resource will be created with a server-assigned ID as per the
create method.

The request body must contain a JSON-encoded FHIR resource, and the request
headers must contain `Content-Type: application/fhir+json`.

On success, the response body will contain a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('ConditionalUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConditionalUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'PUT',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.conditionalUpdate',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/fhir/{+type}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a FHIR resource.

Implements the FHIR standard [create
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#create),
which creates a new resource with a server-assigned resource ID.

Also supports the FHIR standard [conditional create
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#ccreate),
specified by supplying an `If-None-Exist` header containing a FHIR search
query. If no resources match this search query, the server processes the
create operation as normal.

The request body must contain a JSON-encoded FHIR resource, and the request
headers must contain `Content-Type: application/fhir+json`.

On success, the response body will contain a JSON-encoded representation
of the resource as it was created on the server, including the
server-assigned resource ID and version ID.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.create',
        ordered_params=[u'parent', u'type'],
        path_params=[u'parent', u'type'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/fhir/{+type}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirCreateRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a FHIR resource.

Implements the FHIR standard [delete
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#delete).

Note: Unless resource versioning is disabled by setting the
disable_resource_versioning flag
on the FHIR store, the deleted resources will be moved to a history
repository that can still be retrieved through vread
and related methods, unless they are removed by the
purge method.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirDeleteRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def ExecuteBundle(self, request, global_params=None):
      r"""Executes all the requests in the given Bundle.

Implements the FHIR standard [batch/transaction
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#transaction).

Supports all interactions within a bundle, except search. This method
accepts Bundles of type `batch` and `transaction`, processing them
according to the [batch processing
rules](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.1)
and [transaction processing
rules](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.2).

The request body must contain a JSON-encoded FHIR `Bundle` resource, and
the request headers must contain `Content-Type: application/fhir+json`.

For a batch bundle or a successful transaction the response body will
contain a JSON-encoded representation of a `Bundle` resource of type
`batch-response` or `transaction-response` containing one entry for each
entry in the request, with the outcome of processing the entry. In the
case of an error for a transaction bundle, the response body will contain
a JSON-encoded `OperationOutcome` resource describing the reason for the
error. If the request cannot be mapped to a valid API method on a FHIR
store, a generic GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirExecuteBundleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('ExecuteBundle')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExecuteBundle.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.executeBundle',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/fhir',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirExecuteBundleRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def History(self, request, global_params=None):
      r"""Lists all the versions of a resource (including the current version and.
deleted versions) from the FHIR store.

Implements the per-resource form of the FHIR standard [history
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#history).

On success, the response body will contain a JSON-encoded representation
of a `Bundle` resource of type `history`, containing the version history
sorted from most recent to oldest versions.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirHistoryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('History')
      return self._RunMethod(
          config, request, global_params=global_params)

    History.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}/_history',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.history',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'_at', u'_count', u'_page', u'_since'],
        relative_path=u'v1beta1/{+name}/_history',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirHistoryRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates part of an existing resource by applying the operations specified.
in a [JSON Patch](http://jsonpatch.com/) document.

Implements the FHIR standard [patch
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#patch).

The request body must contain a JSON Patch document, and the request
headers must contain `Content-Type: application/json-patch+json`.

On success, the response body will contain a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirPatchRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Read(self, request, global_params=None):
      r"""Gets the contents of a FHIR resource.

Implements the FHIR standard [read
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#read).

Also supports the FHIR standard [conditional read
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#cread)
specified by supplying an `If-Modified-Since` header with a date/time value
or an `If-None-Match` header with an ETag value.

On success, the response body will contain a JSON-encoded representation
of the resource.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Read')
      return self._RunMethod(
          config, request, global_params=global_params)

    Read.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.read',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirReadRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for resources in the given FHIR store according to criteria.
specified as query parameters.

Implements the FHIR standard [search
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#search)
using the search semantics described in the [FHIR Search
specification](http://hl7.org/implement/standards/fhir/STU3/search.html).

Supports three methods of search defined by the specification:

*  `GET [base]?[parameters]` to search across all resources.
*  `GET [base]/[type]?[parameters]` to search resources of a specified
type.
*  `POST [base]/[type]/_search?[parameters]` as an alternate form having
the same semantics as the `GET` method.

The `GET` methods do not support compartment searches. The `POST` method
does not support `application/x-www-form-urlencoded` search parameters.

On success, the response body will contain a JSON-encoded representation
of a `Bundle` resource of type `searchset`, containing the results of the
search.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

The server's capability statement, retrieved through
capabilities, indicates what search parameters
are supported on each FHIR resource. A list of all search parameters
defined by the specification can be found in the [FHIR Search Parameter
Registry](http://hl7.org/implement/standards/fhir/STU3/searchparameter-registry.html).

Supported search modifiers: `:missing`, `:exact`, `:contains`, `:text`,
`:in`, `:not-in`, `:above`, `:below`, `:[type]`, `:not`, and `:recurse`.

Supported search result parameters: `_sort`, `_count`, `_include`,
`_revinclude`, `_summary=text`, `_summary=data`, and `_elements`.

The maximum number of search results returned defaults to 100, which can
be overridden by the `_count` parameter up to a maximum limit of 1000. If
there are additional results, the returned `Bundle` will contain
pagination links.

Resources with a total size larger than 5MB or a field count larger than
50,000 might not be fully searchable as the server might trim its generated
search index in those cases.

Note: FHIR resources are indexed asynchronously, so there might be a slight
delay between the time a resource is created or changes and when the change
is reflected in search results.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/_search',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.search',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/fhir/_search',
        request_field=u'searchResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirSearchRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the entire contents of a resource.

Implements the FHIR standard [update
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#update).

If the specified resource does
not exist and the FHIR store has
enable_update_create set, creates the
resource with the client-specified ID.

The request body must contain a JSON-encoded FHIR resource, and the request
headers must contain `Content-Type: application/fhir+json`. The resource
must contain an `id` element having an identical value to the ID in the
REST path of the request.

On success, the response body will contain a JSON-encoded representation
of the updated resource, including the server-assigned version ID.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}',
        http_method=u'PUT',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field=u'httpBody',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirUpdateRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

    def Vread(self, request, global_params=None):
      r"""Gets the contents of a version (current or historical) of a FHIR resource.
by version ID.

Implements the FHIR standard [vread
interaction](http://hl7.org/implement/standards/fhir/STU3/http.html#vread).

On success, the response body will contain a JSON-encoded representation
of the resource.
Errors generated by the FHIR store will contain a JSON-encoded
`OperationOutcome` resource describing the reason for the error. If the
request cannot be mapped to a valid API method on a FHIR store, a generic
GCP error might be returned instead.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresFhirVreadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Vread')
      return self._RunMethod(
          config, request, global_params=global_params)

    Vread.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}/fhir/{fhirId}/{fhirId1}/_history/{_historyId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.fhir.vread',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresFhirVreadRequest',
        response_type_name=u'HttpBody',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsFhirStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_fhirStores resource."""

    _NAME = u'projects_locations_datasets_fhirStores'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsFhirStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new FHIR store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'fhirStoreId'],
        relative_path=u'v1beta1/{+parent}/fhirStores',
        request_field=u'fhirStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified FHIR store and removes all resources within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Export resources from the FHIR store to the specified destination.

This method returns an Operation that can
be used to track the status of the export by calling
GetOperation.

Immediate fatal errors appear in the
error field, errors are also logged
to Stackdriver (see [Viewing
logs](/healthcare/docs/how-tos/stackdriver-logging)).
Otherwise, when the operation finishes, a detailed response of type
ExportResourcesResponse is returned in the
response field.
The metadata field type for this
operation is OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.export',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:export',
        request_field=u'exportResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the configuration of the specified FHIR store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresGetRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Import resources to the FHIR store by loading data from the specified.
sources. This method is optimized to load large quantities of data using
import semantics that ignore some FHIR store configuration options and are
not suitable for all use cases. It is primarily intended to load data into
an empty FHIR store that is not being used by other clients. In cases
where this method is not appropriate, consider using ExecuteBundle to
load data.

Every resource in the input must contain a client-supplied ID, and will be
stored using that ID regardless of the
enable_update_create setting on the FHIR
store.

The import process does not enforce referential integrity, regardless of
the
disable_referential_integrity
setting on the FHIR store. This allows the import of resources with
arbitrary interdependencies without considering grouping or ordering, but
if the input data contains invalid references or if some resources fail to
be imported, the FHIR store might be left in a state that violates
referential integrity.

If a resource with the specified ID already exists, the most recent
version of the resource is overwritten without creating a new historical
version, regardless of the
disable_resource_versioning
setting on the FHIR store. If transient failures occur during the import,
it is possible that successfully imported resources will be overwritten
more than once.

The import operation is idempotent unless the input data contains multiple
valid resources with the same ID but different contents. In that case,
after the import completes, the store will contain exactly one resource
with that ID but there is no ordering guarantee on which version of the
contents it will have. The operation result counters do not count
duplicate IDs as an error and will count one success for each resource in
the input, which might result in a success count larger than the number
of resources in the FHIR store. This often occurs when importing data
organized in bundles produced by Patient-everything
where each bundle contains its own copy of a resource such as Practitioner
that might be referred to by many patients.

If some resources fail to import, for example due to parsing errors,
successfully imported resources are not rolled back.

The location and format of the input data is specified by the parameters
below. Note that if no format is specified, this method assumes the
`BUNDLE` format. When using the `BUNDLE` format this method ignores the
`Bundle.type` field, except for the special case of `history`, and does
not apply any of the bundle processing semantics for batch or transaction
bundles. Unlike in ExecuteBundle, transaction bundles are not executed
as a single transaction and bundle-internal references are not rewritten.
The bundle is treated as a collection of resources to be written as
provided in `Bundle.entry.resource`, ignoring `Bundle.entry.request`. As
an example, this allows the import of `searchset` bundles produced by a
FHIR search or
Patient-everything operation.

If history imports are enabled by setting
enable_history_import in the FHIR
store's configuration, this method can import historical versions
of a resource by supplying a bundle of type `history` and using the
`BUNDLE` format. The historical versions in the bundle must have
`lastUpdated` timestamps, and the resulting resource history on the server
will appear as if the versions had been created at those timestamps. If a
current or historical version with the supplied resource ID already
exists, the bundle is rejected to avoid creating an inconsistent sequence
of resource versions.

This method returns an Operation that can
be used to track the status of the import by calling
GetOperation.

Immediate fatal errors appear in the
error field, errors are also logged
to Stackdriver (see [Viewing
logs](/healthcare/docs/how-tos/stackdriver-logging)). Otherwise, when the
operation finishes, a detailed response of type ImportResourcesResponse
is returned in the response field.
The metadata field type for this
operation is OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.import',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:import',
        request_field=u'importResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the FHIR stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFhirStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/fhirStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresListRequest',
        response_type_name=u'ListFhirStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the configuration of the specified FHIR store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'fhirStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsHl7V2StoresMessagesService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_hl7V2Stores_messages resource."""

    _NAME = u'projects_locations_datasets_hl7V2Stores_messages'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsHl7V2StoresMessagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a message and sends a notification to the Cloud Pub/Sub topic. If.
configured, the MLLP adapter listens to messages created by this method and
sends those back to the hospital. A successful response indicates the
message has been persisted to storage and a Cloud Pub/Sub notification has
been sent. Sending to the hospital by the MLLP adapter happens
asynchronously.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Message) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/messages',
        request_field=u'createMessageRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest',
        response_type_name=u'Message',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an HL7v2 message.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages/{messagesId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an HL7v2 message.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Message) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages/{messagesId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'view'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest',
        response_type_name=u'Message',
        supports_download=False,
    )

    def Ingest(self, request, global_params=None):
      r"""Ingests a new HL7v2 message from the hospital and sends a notification to.
the Cloud Pub/Sub topic. Return is an HL7v2 ACK message if the message was
successfully stored. Otherwise an error is returned.  If an identical
HL7v2 message is created twice only one resource is created on the server
and no error is reported.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IngestMessageResponse) The response message.
      """
      config = self.GetMethodConfig('Ingest')
      return self._RunMethod(
          config, request, global_params=global_params)

    Ingest.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages:ingest',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.ingest',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/messages:ingest',
        request_field=u'ingestMessageRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest',
        response_type_name=u'IngestMessageResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the messages in the given HL7v2 store with support for filtering.

Note: HL7v2 messages are indexed asynchronously, so there might be a slight
delay between the time a message is created and when it can be found
through a filter.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMessagesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/messages',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest',
        response_type_name=u'ListMessagesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update the message.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Message) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}/messages/{messagesId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.messages.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'message',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest',
        response_type_name=u'Message',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsHl7V2StoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_hl7V2Stores resource."""

    _NAME = u'projects_locations_datasets_hl7V2Stores'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsHl7V2StoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new HL7v2 store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'hl7V2StoreId'],
        relative_path=u'v1beta1/{+parent}/hl7V2Stores',
        request_field=u'hl7V2Store',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HL7v2 store and removes all messages that are.
contained within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified HL7v2 store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the HL7v2 stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListHl7V2StoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/hl7V2Stores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest',
        response_type_name=u'ListHl7V2StoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the HL7v2 store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'hl7V2Store',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_operations resource."""

    _NAME = u'projects_locations_datasets_operations'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (HealthcareProjectsLocationsDatasetsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (HealthcareProjectsLocationsDatasetsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/operations',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+name}/operations',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets resource."""

    _NAME = u'projects_locations_datasets'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsDatasetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new health dataset. Results are returned through the.
Operation interface which returns either an
`Operation.response` which contains a Dataset or
`Operation.error`. The metadata
field type is OperationMetadata.
A Google Cloud Platform project can contain up to 500 datasets across all
regions.

      Args:
        request: (HealthcareProjectsLocationsDatasetsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'datasetId'],
        relative_path=u'v1beta1/{+parent}/datasets',
        request_field=u'dataset',
        request_type_name=u'HealthcareProjectsLocationsDatasetsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Deidentify(self, request, global_params=None):
      r"""Creates a new dataset containing de-identified data from the source.
dataset. The metadata field type
is OperationMetadata.
If the request is successful, the
response field type is
DeidentifySummary.
If errors occur,
details field type is
DeidentifyErrorDetails.
Errors are also logged to Stackdriver
(see [Viewing logs](/healthcare/docs/how-tos/stackdriver-logging)).

      Args:
        request: (HealthcareProjectsLocationsDatasetsDeidentifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Deidentify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deidentify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:deidentify',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.deidentify',
        ordered_params=[u'sourceDataset'],
        path_params=[u'sourceDataset'],
        query_params=[],
        relative_path=u'v1beta1/{+sourceDataset}:deidentify',
        request_field=u'deidentifyDatasetRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDeidentifyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified health dataset and all data contained in the dataset.
Deleting a dataset does not affect the sources from which the dataset was
imported (if any).

      Args:
        request: (HealthcareProjectsLocationsDatasetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets any metadata associated with a dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsGetRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the health datasets in the current project.

      Args:
        request: (HealthcareProjectsLocationsDatasetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatasetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/datasets',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsListRequest',
        response_type_name=u'ListDatasetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates dataset metadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'dataset',
        request_type_name=u'HealthcareProjectsLocationsDatasetsPatchRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

      Args:
        request: (HealthcareProjectsLocationsDatasetsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (HealthcareProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (HealthcareProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+name}/locations',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(HealthcareV1beta1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
