"""Generated message classes for datacatalog version v1beta1.

A fully managed and highly scalable data discovery and metadata management
service.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'datacatalog'


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class DatacatalogEntriesLookupRequest(_messages.Message):
  r"""A DatacatalogEntriesLookupRequest object.

  Fields:
    linkedResource: The full name of the Google Cloud Platform resource the
      Data Catalog entry represents. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name.
      Full names are case-sensitive.  Examples:   * //bigquery.googleapis.com/
      projects/projectId/datasets/datasetId/tables/tableId  *
      //pubsub.googleapis.com/projects/projectId/topics/topicId
    sqlResource: The SQL name of the entry. SQL names are case-sensitive.
      Examples:    * `cloud_pubsub.project_id.topic_id`   *
      ``pubsub.project_id.`topic.id.with.dots` ``   *
      `bigquery.project_id.dataset_id.table_id`   *
      `datacatalog.project_id.location_id.entry_group_id.entry_id`  `*_id`s
      shoud satisfy the standard SQL rules for identifiers.
      https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical.
  """

  linkedResource = _messages.StringField(1)
  sqlResource = _messages.StringField(2)


class DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest object.

  Fields:
    name: Required. The name of the entry. Example:  * projects/{project_id}/l
      ocations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
      Entry groups are logical groupings of entries. Currently, users cannot
      create/modify entry groups. They are created by Data Catalog; they
      include `@bigquery` for all BigQuery entries, and `@pubsub` for all
      Cloud Pub/Sub entries.
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1beta1Entry: A GoogleCloudDatacatalogV1beta1Entry
      resource to be passed as the request body.
    name: Required when used in UpdateEntryRequest. The Data Catalog resource
      name of the entry in URL format. Example:  * projects/{project_id}/locat
      ions/{location}/entryGroups/{entry_group_id}/entries/{entry_id}  Note
      that this Entry and its child resources may not actually be stored in
      the location in this name.
    updateMask: Optional. The fields to update on the entry. If absent or
      empty, all modifiable fields are updated.  Currently only `schema` field
      in Cloud Pub/Sub topic entries is modifiable.
  """

  googleCloudDatacatalogV1beta1Entry = _messages.MessageField('GoogleCloudDatacatalogV1beta1Entry', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest
  object.

  Fields:
    googleCloudDatacatalogV1beta1Tag: A GoogleCloudDatacatalogV1beta1Tag
      resource to be passed as the request body.
    parent: Required. The name of the resource to attach this tag to. Tags can
      be attached to Entries. Example:  * projects/{project_id}/locations/{loc
      ation}/entryGroups/{entry_group_id}/entries/{entry_id}  Note that this
      Tag and its child resources may not actually be stored in the location
      in this name.
  """

  googleCloudDatacatalogV1beta1Tag = _messages.MessageField('GoogleCloudDatacatalogV1beta1Tag', 1)
  parent = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest
  object.

  Fields:
    name: Required. The name of the tag to delete. Example:  * projects/{proje
      ct_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_
      id}/tags/{tag_id}
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of tags to return. Default is 10.
      Max limit is 1000.
    pageToken: Optional. Token that specifies which page is requested. If
      empty, the first page is returned.
    parent: Required. The name of the Data Catalog resource to list the tags
      of. The resource could be an Entry.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1beta1Tag: A GoogleCloudDatacatalogV1beta1Tag
      resource to be passed as the request body.
    name: Required when used in UpdateTagRequest. The resource name of the tag
      in URL format. Example:  * projects/{project_id}/locations/{location}/en
      trygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}  where
      `tag_id` is a system-generated identifier. Note that this Tag may not
      actually be stored in the location in this name.
    updateMask: Optional. The fields to update on the Tag. If absent or empty,
      all modifiable fields are updated. Currently the only modifiable field
      is the field `fields`.
  """

  googleCloudDatacatalogV1beta1Tag = _messages.MessageField('GoogleCloudDatacatalogV1beta1Tag', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesCreateRequest object.

  Fields:
    googleCloudDatacatalogV1beta1TagTemplate: A
      GoogleCloudDatacatalogV1beta1TagTemplate resource to be passed as the
      request body.
    parent: Required. The name of the project and the location this template
      is in. Example:  * projects/{project_id}/locations/{location}
      TagTemplate and its child resources may not actually be stored in the
      location in this name.
    tagTemplateId: Required. The id of the tag template to create.
  """

  googleCloudDatacatalogV1beta1TagTemplate = _messages.MessageField('GoogleCloudDatacatalogV1beta1TagTemplate', 1)
  parent = _messages.StringField(2, required=True)
  tagTemplateId = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesDeleteRequest object.

  Fields:
    force: Required. Currently, this field must always be set to `true`. This
      confirms the deletion of any possible tags using this template. `force =
      false` will be supported in the future.
    name: Required. The name of the tag template to delete. Example:  *
      projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id
      }
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest object.

  Fields:
    googleCloudDatacatalogV1beta1TagTemplateField: A
      GoogleCloudDatacatalogV1beta1TagTemplateField resource to be passed as
      the request body.
    parent: Required. The name of the project this template is in. Example:  *
      projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id
      }  Note that this TagTemplateField may not actually be stored in the
      location in this name.
    tagTemplateFieldId: Required. The ID of the tag template field to create.
      Field ids can contain letters (both uppercase and lowercase), numbers
      (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
      character long and at most 128 characters long. Field IDs must also be
      unique within their template.
  """

  googleCloudDatacatalogV1beta1TagTemplateField = _messages.MessageField('GoogleCloudDatacatalogV1beta1TagTemplateField', 1)
  parent = _messages.StringField(2, required=True)
  tagTemplateFieldId = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest object.

  Fields:
    force: Required. Currently, this field must always be set to `true`. This
      confirms the deletion of this field from any tags using this field.
      `force = false` will be supported in the future.
    name: Required. The name of the tag template field to delete. Example:  *
      projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id
      }/fields/{tag_template_field_id}
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest object.

  Fields:
    googleCloudDatacatalogV1beta1TagTemplateField: A
      GoogleCloudDatacatalogV1beta1TagTemplateField resource to be passed as
      the request body.
    name: Required. The name of the tag template field. Example:  * projects/{
      project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{
      tag_template_field_id}
    updateMask: Optional. The field mask specifies the parts of the template
      to be updated. Allowed fields:    * `display_name`   * `type.enum_type`
      If `update_mask` is not set or empty, all of the allowed fields above
      will be updated.  When updating an enum type, the provided values will
      be merged with the existing values. Therefore, enum values can only be
      added, existing enum values cannot be deleted nor renamed.
  """

  googleCloudDatacatalogV1beta1TagTemplateField = _messages.MessageField('GoogleCloudDatacatalogV1beta1TagTemplateField', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest object.

  Fields:
    googleCloudDatacatalogV1beta1RenameTagTemplateFieldRequest: A
      GoogleCloudDatacatalogV1beta1RenameTagTemplateFieldRequest resource to
      be passed as the request body.
    name: Required. The name of the tag template. Example:  * projects/{projec
      t_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_te
      mplate_field_id}
  """

  googleCloudDatacatalogV1beta1RenameTagTemplateFieldRequest = _messages.MessageField('GoogleCloudDatacatalogV1beta1RenameTagTemplateFieldRequest', 1)
  name = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatacatalogProjectsLocationsTagTemplatesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesGetRequest object.

  Fields:
    name: Required. The name of the tag template. Example:  *
      projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id
      }
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsTagTemplatesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1beta1TagTemplate: A
      GoogleCloudDatacatalogV1beta1TagTemplate resource to be passed as the
      request body.
    name: Required when used in UpdateTagTemplateRequest. The resource name of
      the tag template in URL format. Example:  * projects/{project_id}/locati
      ons/{location}/tagTemplates/{tag_template_id}  Note that this
      TagTemplate and its child resources may not actually be stored in the
      location in this name.
    updateMask: Optional. The field mask specifies the parts of the template
      to overwrite.  Allowed fields:    * `display_name`  If absent or empty,
      all of the allowed fields above will be updated.
  """

  googleCloudDatacatalogV1beta1TagTemplate = _messages.MessageField('GoogleCloudDatacatalogV1beta1TagTemplate', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`. This field is only used by Cloud IAM.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned. Acceptable values are 0 and 1. If the value is 0, or the field
      is omitted, policy format version 1 will be returned.
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudDatacatalogV1beta1BigQueryDateShardedSpec(_messages.Message):
  r"""Spec for a group of BigQuery tables with name pattern
  `[prefix]YYYYMMDD`. Context: https://cloud.google.com/bigquery/docs
  /partitioned-tables#partitioning_versus_sharding

  Fields:
    dataset: Output only. The Data Catalog resource name of the dataset entry
      the current table belongs to, for example, `projects/{project_id}/locati
      ons/{location}/entrygroups/{entry_group_id}/entries/{entry_id}`.
    shardCount: Output only. Total number of shards.
    tablePrefix: Output only. The table name prefix of the shards. The name of
      any given shard is `[table_prefix]YYYYMMDD`, for example, for shard
      `MyTable20180101`, the `table_prefix` is `MyTable`.
  """

  dataset = _messages.StringField(1)
  shardCount = _messages.IntegerField(2)
  tablePrefix = _messages.StringField(3)


class GoogleCloudDatacatalogV1beta1BigQueryTableSpec(_messages.Message):
  r"""Describes a BigQuery table.

  Enums:
    TableSourceTypeValueValuesEnum: Output only. The table source type.

  Fields:
    tableSourceType: Output only. The table source type.
    tableSpec: Spec of a BigQuery table. This field should only be populated
      if `table_source_type` is `BIGQUERY_TABLE`.
    viewSpec: Table view specification. This field should only be populated if
      `table_source_type` is `BIGQUERY_VIEW`.
  """

  class TableSourceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The table source type.

    Values:
      TABLE_SOURCE_TYPE_UNSPECIFIED: Default unknown type.
      BIGQUERY_VIEW: Table view.
      BIGQUERY_TABLE: BigQuery native table.
    """
    TABLE_SOURCE_TYPE_UNSPECIFIED = 0
    BIGQUERY_VIEW = 1
    BIGQUERY_TABLE = 2

  tableSourceType = _messages.EnumField('TableSourceTypeValueValuesEnum', 1)
  tableSpec = _messages.MessageField('GoogleCloudDatacatalogV1beta1TableSpec', 2)
  viewSpec = _messages.MessageField('GoogleCloudDatacatalogV1beta1ViewSpec', 3)


class GoogleCloudDatacatalogV1beta1ColumnSchema(_messages.Message):
  r"""Representation of a column within a schema. Columns could be nested
  inside other columns.

  Fields:
    column: Required. Name of the column.
    description: Optional. Description of the column. Default value is an
      empty string.
    mode: Optional. A column's mode indicates whether the values in this
      column are required, nullable, etc. Only `NULLABLE`, `REQUIRED` and
      `REPEATED` are supported. Default mode is `NULLABLE`.
    subcolumns: Optional. Schema of sub-columns. A column can have zero or
      more sub-columns.
    type: Required. Type of the column.
  """

  column = _messages.StringField(1)
  description = _messages.StringField(2)
  mode = _messages.StringField(3)
  subcolumns = _messages.MessageField('GoogleCloudDatacatalogV1beta1ColumnSchema', 4, repeated=True)
  type = _messages.StringField(5)


class GoogleCloudDatacatalogV1beta1Entry(_messages.Message):
  r"""Entry Metadata.  A Data Catalog Entry resource represents another
  resource in Google Cloud Platform, such as a BigQuery dataset or a Cloud
  Pub/Sub topic. Clients can use the `linked_resource` field in the Entry
  resource to refer to the original resource ID of the source system.  An
  Entry resource contains resource details, such as its schema. An Entry can
  also be used to attach flexible metadata, such as a Tag.

  Enums:
    TypeValueValuesEnum: The type of the entry.

  Fields:
    bigqueryDateShardedSpec: Specification for a group of BigQuery tables with
      name pattern `[prefix]YYYYMMDD`. Context:
      https://cloud.google.com/bigquery/docs/partitioned-
      tables#partitioning_versus_sharding.
    bigqueryTableSpec: Specification that applies to a BigQuery table. This is
      only valid on entries of type `TABLE`.
    description: Optional. Entry description, which can consist of several
      sentences or paragraphs that describe entry contents. Default value is
      an empty string.
    displayName: Optional. Display information such as title and description.
      A short name to identify the entry, for example, "Analytics Data - Jan
      2011". Default value is an empty string.
    linkedResource: Output only. The full name of the cloud resource the entry
      belongs to. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      Data Catalog supports resources from select Google Cloud Platform
      systems. `linked_resource` is the full name of the Google Cloud Platform
      resource. For example, the `linked_resource` for a table resource from
      BigQuery is:  * //bigquery.googleapis.com/projects/projectId/datasets/da
      tasetId/tables/tableId
    name: Required when used in UpdateEntryRequest. The Data Catalog resource
      name of the entry in URL format. Example:  * projects/{project_id}/locat
      ions/{location}/entryGroups/{entry_group_id}/entries/{entry_id}  Note
      that this Entry and its child resources may not actually be stored in
      the location in this name.
    schema: Optional. Schema of the entry. An entry might not have any schema
      attached to it.
    sourceSystemTimestamps: Output only. Timestamps about the underlying
      Google Cloud Platform resource -- not about this Data Catalog Entry.
    type: The type of the entry.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the entry.

    Values:
      ENTRY_TYPE_UNSPECIFIED: Default unknown type
      TABLE: Output only. The type of entry that has a GoogleSQL schema,
        including logical views.
      DATA_STREAM: Output only. An entry type which is used for streaming
        entries. Example: Cloud Pub/Sub topic.
    """
    ENTRY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    DATA_STREAM = 2

  bigqueryDateShardedSpec = _messages.MessageField('GoogleCloudDatacatalogV1beta1BigQueryDateShardedSpec', 1)
  bigqueryTableSpec = _messages.MessageField('GoogleCloudDatacatalogV1beta1BigQueryTableSpec', 2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  linkedResource = _messages.StringField(5)
  name = _messages.StringField(6)
  schema = _messages.MessageField('GoogleCloudDatacatalogV1beta1Schema', 7)
  sourceSystemTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1beta1SystemTimestamps', 8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)


class GoogleCloudDatacatalogV1beta1FieldType(_messages.Message):
  r"""A GoogleCloudDatacatalogV1beta1FieldType object.

  Enums:
    PrimitiveTypeValueValuesEnum: Represents primitive types - string, bool
      etc.

  Fields:
    enumType: Represents an enum type.
    primitiveType: Represents primitive types - string, bool etc.
  """

  class PrimitiveTypeValueValuesEnum(_messages.Enum):
    r"""Represents primitive types - string, bool etc.

    Values:
      PRIMITIVE_TYPE_UNSPECIFIED: This is the default invalid value for a
        type.
      DOUBLE: A double precision number.
      STRING: An UTF-8 string.
      BOOL: A boolean value.
      TIMESTAMP: A timestamp.
    """
    PRIMITIVE_TYPE_UNSPECIFIED = 0
    DOUBLE = 1
    STRING = 2
    BOOL = 3
    TIMESTAMP = 4

  enumType = _messages.MessageField('GoogleCloudDatacatalogV1beta1FieldTypeEnumType', 1)
  primitiveType = _messages.EnumField('PrimitiveTypeValueValuesEnum', 2)


class GoogleCloudDatacatalogV1beta1FieldTypeEnumType(_messages.Message):
  r"""A GoogleCloudDatacatalogV1beta1FieldTypeEnumType object.

  Fields:
    allowedValues: Required on create; optional on update. The set of allowed
      values for this enum. This set must not be empty, the display names of
      the values in this set must not be empty and the display names of the
      values must be case-insensitively unique within this set. Currently,
      enum values can only be added to the list of allowed values. Deletion
      and renaming of enum values are not supported. Can have up to 500
      allowed values.
  """

  allowedValues = _messages.MessageField('GoogleCloudDatacatalogV1beta1FieldTypeEnumTypeEnumValue', 1, repeated=True)


class GoogleCloudDatacatalogV1beta1FieldTypeEnumTypeEnumValue(_messages.Message):
  r"""A GoogleCloudDatacatalogV1beta1FieldTypeEnumTypeEnumValue object.

  Fields:
    displayName: Required. The display name of the enum value. Must not be an
      empty string.
  """

  displayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1beta1ListTagsResponse(_messages.Message):
  r"""Response message for ListTags.

  Fields:
    nextPageToken: Token to retrieve the next page of results. It is set to
      empty if no items remain in results.
    tags: Tag details.
  """

  nextPageToken = _messages.StringField(1)
  tags = _messages.MessageField('GoogleCloudDatacatalogV1beta1Tag', 2, repeated=True)


class GoogleCloudDatacatalogV1beta1RenameTagTemplateFieldRequest(_messages.Message):
  r"""Request message for RenameTagTemplateField.

  Fields:
    newTagTemplateFieldId: Required. The new ID of this tag template field.
      For example, `my_new_field`.
  """

  newTagTemplateFieldId = _messages.StringField(1)


class GoogleCloudDatacatalogV1beta1Schema(_messages.Message):
  r"""Represents a schema (e.g. BigQuery, GoogleSQL, Avro schema).

  Fields:
    columns: Required. Schema of columns. A maximum of 10,000 columns and sub-
      columns can be specified.
  """

  columns = _messages.MessageField('GoogleCloudDatacatalogV1beta1ColumnSchema', 1, repeated=True)


class GoogleCloudDatacatalogV1beta1SearchCatalogRequest(_messages.Message):
  r"""Request message for SearchCatalog.

  Fields:
    orderBy: Specifies the ordering of results, currently supported case-
      sensitive choices are:    * `relevance`, only supports desecending   *
      `last_access_timestamp [asc|desc]`, defaults to descending if not
      specified   * `last_modified_timestamp [asc|desc]`, defaults to
      descending if not     specified  If not specified, defaults to
      `relevance` descending.
    pageSize: Number of results in the search page. If <=0 then defaults to
      10. Max limit for page_size is 1000. Throws an invalid argument for
      page_size > 1000.
    pageToken: Optional pagination token returned in an earlier
      SearchCatalogResponse.next_page_token, which indicates that this is a
      continuation of a prior SearchCatalogRequest call, and that the system
      should return the next page of data. If empty, the first page is
      returned.
    query: Required. The query string in search query syntax. The query must
      be non-empty.  Query strings can be simple as "x" or more qualified as:
      * name:x * column:x * description:y  Note: Query tokens need to have a
      minimum of 3 characters for substring matching to work correctly. See
      [Data Catalog Search Syntax](/data-catalog/docs/how-to/search-reference)
      for more information.
    scope: Required. The scope of this search request.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  query = _messages.StringField(4)
  scope = _messages.MessageField('GoogleCloudDatacatalogV1beta1SearchCatalogRequestScope', 5)


class GoogleCloudDatacatalogV1beta1SearchCatalogRequestScope(_messages.Message):
  r"""A GoogleCloudDatacatalogV1beta1SearchCatalogRequestScope object.

  Fields:
    includeGcpPublicDatasets: If `true`, include Google Cloud Platform (GCP)
      public datasets in the search results. Info on GCP public datasets is
      available at https://cloud.google.com/public-datasets/. By default, GCP
      public datasets are excluded.
    includeOrgIds: Data Catalog tries to automatically choose the right corpus
      of data to search through. You can ensure an organization is included by
      adding it to `include_org_ids`. You can ensure a project's org is
      included with `include_project_ids`. You must specify at least one
      organization using `include_org_ids` or `include_project_ids` in all
      search requests.  List of organization IDs to search within. To find
      your organization ID, follow instructions in https://cloud.google.com
      /resource-manager/docs/creating-managing-organization.
    includeProjectIds: List of project IDs to search within. To learn more
      about the distinction between project names/IDs/numbers, go to
      https://cloud.google.com/docs/overview/#projects.
  """

  includeGcpPublicDatasets = _messages.BooleanField(1)
  includeOrgIds = _messages.StringField(2, repeated=True)
  includeProjectIds = _messages.StringField(3, repeated=True)


class GoogleCloudDatacatalogV1beta1SearchCatalogResponse(_messages.Message):
  r"""Response message for SearchCatalog.

  Fields:
    nextPageToken: The token that can be used to retrieve the next page of
      results.
    results: Search results.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('GoogleCloudDatacatalogV1beta1SearchCatalogResult', 2, repeated=True)


class GoogleCloudDatacatalogV1beta1SearchCatalogResult(_messages.Message):
  r"""A result that appears in the response of a search request. Each result
  captures details of one entry that matches the search.

  Enums:
    SearchResultTypeValueValuesEnum: Type of the search result. This field can
      be used to determine which Get method to call to fetch the full
      resource.

  Fields:
    linkedResource: The full name of the cloud resource the entry belongs to.
      See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name.
      Example:   * `//bigquery.googleapis.com/projects/projectId/datasets/data
      setId/tables/tableId`
    relativeResourceName: The relative resource name of the resource in URL
      format. Examples:   * `projects/{project_id}/locations/{location_id}/ent
      ryGroups/{entry_group_id}/entries/{entry_id}`  *
      `projects/{project_id}/tagTemplates/{tag_template_id}`
    searchResultSubtype: Sub-type of the search result. This is a dot-
      delimited description of the resource's full type, and is the same as
      the value callers would provide in the "type" search facet.  Examples:
      `entry.table`, `entry.dataStream`, `tagTemplate`.
    searchResultType: Type of the search result. This field can be used to
      determine which Get method to call to fetch the full resource.
  """

  class SearchResultTypeValueValuesEnum(_messages.Enum):
    r"""Type of the search result. This field can be used to determine which
    Get method to call to fetch the full resource.

    Values:
      SEARCH_RESULT_TYPE_UNSPECIFIED: Default unknown type.
      ENTRY: An Entry.
      TAG_TEMPLATE: A TagTemplate.
    """
    SEARCH_RESULT_TYPE_UNSPECIFIED = 0
    ENTRY = 1
    TAG_TEMPLATE = 2

  linkedResource = _messages.StringField(1)
  relativeResourceName = _messages.StringField(2)
  searchResultSubtype = _messages.StringField(3)
  searchResultType = _messages.EnumField('SearchResultTypeValueValuesEnum', 4)


class GoogleCloudDatacatalogV1beta1SystemTimestamps(_messages.Message):
  r"""Timestamps about this resource according to a particular system.

  Fields:
    createTime: Output only. The creation time of the resource within the
      given system.
    expireTime: Output only. The expiration time of the resource within the
      given system.
    updateTime: Output only. The last-modified time of the resource within the
      given system.
  """

  createTime = _messages.StringField(1)
  expireTime = _messages.StringField(2)
  updateTime = _messages.StringField(3)


class GoogleCloudDatacatalogV1beta1TableSpec(_messages.Message):
  r"""Normal BigQuery table spec.

  Fields:
    groupedEntry: Output only. If the table is a dated shard, i.e., with name
      pattern `[prefix]YYYYMMDD`, `grouped_entry` is the Data Catalog resource
      name of the date sharded grouped entry, for example, `projects/{project_
      id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}
      `. Otherwise, `grouped_entry` is empty.
  """

  groupedEntry = _messages.StringField(1)


class GoogleCloudDatacatalogV1beta1Tag(_messages.Message):
  r"""Tags are used to attach custom metadata to Data Catalog resources. Tags
  conform to the specifications within their tag template.

  Messages:
    FieldsValue: Required. This maps the ID of a tag field to the value of and
      additional information about that field. Valid field IDs are defined by
      the tag's template. A tag must have at least 1 field and at most 500
      fields.

  Fields:
    column: Resources like Entry can have schemas associated with them. This
      scope allows users to attach tags to an individual column based on that
      schema.  For attaching a tag to a nested column, use `.` to separate the
      column names. Example:  * `outer_column.inner_column`
    fields: Required. This maps the ID of a tag field to the value of and
      additional information about that field. Valid field IDs are defined by
      the tag's template. A tag must have at least 1 field and at most 500
      fields.
    name: Required when used in UpdateTagRequest. The resource name of the tag
      in URL format. Example:  * projects/{project_id}/locations/{location}/en
      trygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}  where
      `tag_id` is a system-generated identifier. Note that this Tag may not
      actually be stored in the location in this name.
    template: Required. The resource name of the tag template that this tag
      uses. Example:  * projects/{project_id}/locations/{location}/tagTemplate
      s/{tag_template_id}  This field cannot be modified after creation.
    templateDisplayName: Output only. The display name of the tag template.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Required. This maps the ID of a tag field to the value of and
    additional information about that field. Valid field IDs are defined by
    the tag's template. A tag must have at least 1 field and at most 500
    fields.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1beta1TagField attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1beta1TagField', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  column = _messages.StringField(1)
  fields = _messages.MessageField('FieldsValue', 2)
  name = _messages.StringField(3)
  template = _messages.StringField(4)
  templateDisplayName = _messages.StringField(5)


class GoogleCloudDatacatalogV1beta1TagField(_messages.Message):
  r"""Contains the value and supporting information for a field within a Tag.

  Fields:
    boolValue: Holds the value for a tag field with boolean type.
    displayName: Output only. The display name of this field.
    doubleValue: Holds the value for a tag field with double type.
    enumValue: Holds the value for a tag field with enum type. This value must
      be one of the allowed values in the definition of this enum.
    stringValue: Holds the value for a tag field with string type.
    timestampValue: Holds the value for a tag field with timestamp type.
  """

  boolValue = _messages.BooleanField(1)
  displayName = _messages.StringField(2)
  doubleValue = _messages.FloatField(3)
  enumValue = _messages.MessageField('GoogleCloudDatacatalogV1beta1TagFieldEnumValue', 4)
  stringValue = _messages.StringField(5)
  timestampValue = _messages.StringField(6)


class GoogleCloudDatacatalogV1beta1TagFieldEnumValue(_messages.Message):
  r"""Holds an enum value.

  Fields:
    displayName: The display name of the enum value.
  """

  displayName = _messages.StringField(1)


class GoogleCloudDatacatalogV1beta1TagTemplate(_messages.Message):
  r"""A tag template defines the schema of the tags used to attach to Data
  Catalog resources. It defines the mapping of accepted field names and types
  that can be used within the tag. The tag template also controls the access
  to the tag.

  Messages:
    FieldsValue: Required. Map of tag template field IDs to the settings for
      the field. This map is an exhaustive list of the allowed fields. This
      map must contain at least one field and at most 500 fields.  The keys to
      this map are tag template field IDs. Field IDs can contain letters (both
      uppercase and lowercase), numbers (0-9) and underscores (_). Field IDs
      must be at least 1 character long and at most 64 characters long. Field
      IDs must start with a letter or underscore.

  Fields:
    displayName: Optional. The display name for this template. Defaults to an
      empty string.
    fields: Required. Map of tag template field IDs to the settings for the
      field. This map is an exhaustive list of the allowed fields. This map
      must contain at least one field and at most 500 fields.  The keys to
      this map are tag template field IDs. Field IDs can contain letters (both
      uppercase and lowercase), numbers (0-9) and underscores (_). Field IDs
      must be at least 1 character long and at most 64 characters long. Field
      IDs must start with a letter or underscore.
    name: Required when used in UpdateTagTemplateRequest. The resource name of
      the tag template in URL format. Example:  * projects/{project_id}/locati
      ons/{location}/tagTemplates/{tag_template_id}  Note that this
      TagTemplate and its child resources may not actually be stored in the
      location in this name.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""Required. Map of tag template field IDs to the settings for the field.
    This map is an exhaustive list of the allowed fields. This map must
    contain at least one field and at most 500 fields.  The keys to this map
    are tag template field IDs. Field IDs can contain letters (both uppercase
    and lowercase), numbers (0-9) and underscores (_). Field IDs must be at
    least 1 character long and at most 64 characters long. Field IDs must
    start with a letter or underscore.

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDatacatalogV1beta1TagTemplateField attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDatacatalogV1beta1TagTemplateField', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  fields = _messages.MessageField('FieldsValue', 2)
  name = _messages.StringField(3)


class GoogleCloudDatacatalogV1beta1TagTemplateField(_messages.Message):
  r"""The template for an individual field within a tag template.

  Fields:
    displayName: Optional. The display name for this field. Defaults to an
      empty string.
    type: Required. The type of value this tag field can contain.
  """

  displayName = _messages.StringField(1)
  type = _messages.MessageField('GoogleCloudDatacatalogV1beta1FieldType', 2)


class GoogleCloudDatacatalogV1beta1ViewSpec(_messages.Message):
  r"""Table view specification.

  Fields:
    viewQuery: Required. Output only. The query that defines the table view.
  """

  viewQuery = _messages.StringField(1)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten.
    version: Deprecated.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
