"""Generated client library for compute version beta."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.compute.beta import compute_beta_messages as messages


class ComputeBeta(base_api.BaseApiClient):
  """Generated client library for service compute version beta."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://www.googleapis.com/compute/beta/'

  _PACKAGE = u'compute'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/compute', u'https://www.googleapis.com/auth/compute.readonly', u'https://www.googleapis.com/auth/devstorage.full_control', u'https://www.googleapis.com/auth/devstorage.read_only', u'https://www.googleapis.com/auth/devstorage.read_write']
  _VERSION = u'beta'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ComputeBeta'
  _URL_VERSION = u'beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new compute handle."""
    url = url or self.BASE_URL
    super(ComputeBeta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.acceleratorTypes = self.AcceleratorTypesService(self)
    self.addresses = self.AddressesService(self)
    self.autoscalers = self.AutoscalersService(self)
    self.backendBuckets = self.BackendBucketsService(self)
    self.backendServices = self.BackendServicesService(self)
    self.diskTypes = self.DiskTypesService(self)
    self.disks = self.DisksService(self)
    self.externalVpnGateways = self.ExternalVpnGatewaysService(self)
    self.firewalls = self.FirewallsService(self)
    self.forwardingRules = self.ForwardingRulesService(self)
    self.globalAddresses = self.GlobalAddressesService(self)
    self.globalForwardingRules = self.GlobalForwardingRulesService(self)
    self.globalOperations = self.GlobalOperationsService(self)
    self.healthChecks = self.HealthChecksService(self)
    self.httpHealthChecks = self.HttpHealthChecksService(self)
    self.httpsHealthChecks = self.HttpsHealthChecksService(self)
    self.images = self.ImagesService(self)
    self.instanceGroupManagers = self.InstanceGroupManagersService(self)
    self.instanceGroups = self.InstanceGroupsService(self)
    self.instanceTemplates = self.InstanceTemplatesService(self)
    self.instances = self.InstancesService(self)
    self.interconnectAttachments = self.InterconnectAttachmentsService(self)
    self.interconnectLocations = self.InterconnectLocationsService(self)
    self.interconnects = self.InterconnectsService(self)
    self.licenseCodes = self.LicenseCodesService(self)
    self.licenses = self.LicensesService(self)
    self.machineTypes = self.MachineTypesService(self)
    self.networkEndpointGroups = self.NetworkEndpointGroupsService(self)
    self.networks = self.NetworksService(self)
    self.nodeGroups = self.NodeGroupsService(self)
    self.nodeTemplates = self.NodeTemplatesService(self)
    self.nodeTypes = self.NodeTypesService(self)
    self.projects = self.ProjectsService(self)
    self.regionAutoscalers = self.RegionAutoscalersService(self)
    self.regionBackendServices = self.RegionBackendServicesService(self)
    self.regionCommitments = self.RegionCommitmentsService(self)
    self.regionDiskTypes = self.RegionDiskTypesService(self)
    self.regionDisks = self.RegionDisksService(self)
    self.regionHealthChecks = self.RegionHealthChecksService(self)
    self.regionInstanceGroupManagers = self.RegionInstanceGroupManagersService(self)
    self.regionInstanceGroups = self.RegionInstanceGroupsService(self)
    self.regionOperations = self.RegionOperationsService(self)
    self.regionSslCertificates = self.RegionSslCertificatesService(self)
    self.regionTargetHttpProxies = self.RegionTargetHttpProxiesService(self)
    self.regionTargetHttpsProxies = self.RegionTargetHttpsProxiesService(self)
    self.regionUrlMaps = self.RegionUrlMapsService(self)
    self.regions = self.RegionsService(self)
    self.reservations = self.ReservationsService(self)
    self.resourcePolicies = self.ResourcePoliciesService(self)
    self.routers = self.RoutersService(self)
    self.routes = self.RoutesService(self)
    self.securityPolicies = self.SecurityPoliciesService(self)
    self.snapshots = self.SnapshotsService(self)
    self.sslCertificates = self.SslCertificatesService(self)
    self.sslPolicies = self.SslPoliciesService(self)
    self.subnetworks = self.SubnetworksService(self)
    self.targetHttpProxies = self.TargetHttpProxiesService(self)
    self.targetHttpsProxies = self.TargetHttpsProxiesService(self)
    self.targetInstances = self.TargetInstancesService(self)
    self.targetPools = self.TargetPoolsService(self)
    self.targetSslProxies = self.TargetSslProxiesService(self)
    self.targetTcpProxies = self.TargetTcpProxiesService(self)
    self.targetVpnGateways = self.TargetVpnGatewaysService(self)
    self.urlMaps = self.UrlMapsService(self)
    self.vpnGateways = self.VpnGatewaysService(self)
    self.vpnTunnels = self.VpnTunnelsService(self)
    self.zoneOperations = self.ZoneOperationsService(self)
    self.zones = self.ZonesService(self)

  class AcceleratorTypesService(base_api.BaseApiService):
    """Service class for the acceleratorTypes resource."""

    _NAME = u'acceleratorTypes'

    def __init__(self, client):
      super(ComputeBeta.AcceleratorTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of accelerator types.

      Args:
        request: (ComputeAcceleratorTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.acceleratorTypes.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/acceleratorTypes',
        request_field='',
        request_type_name=u'ComputeAcceleratorTypesAggregatedListRequest',
        response_type_name=u'AcceleratorTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified accelerator type.

      Args:
        request: (ComputeAcceleratorTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.acceleratorTypes.get',
        ordered_params=[u'project', u'zone', u'acceleratorType'],
        path_params=[u'acceleratorType', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/acceleratorTypes/{acceleratorType}',
        request_field='',
        request_type_name=u'ComputeAcceleratorTypesGetRequest',
        response_type_name=u'AcceleratorType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of accelerator types available to the specified project.

      Args:
        request: (ComputeAcceleratorTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.acceleratorTypes.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/acceleratorTypes',
        request_field='',
        request_type_name=u'ComputeAcceleratorTypesListRequest',
        response_type_name=u'AcceleratorTypeList',
        supports_download=False,
    )

  class AddressesService(base_api.BaseApiService):
    """Service class for the addresses resource."""

    _NAME = u'addresses'

    def __init__(self, client):
      super(ComputeBeta.AddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of addresses.

      Args:
        request: (ComputeAddressesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.addresses.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/addresses',
        request_field='',
        request_type_name=u'ComputeAddressesAggregatedListRequest',
        response_type_name=u'AddressAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified address resource.

      Args:
        request: (ComputeAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.addresses.delete',
        ordered_params=[u'project', u'region', u'address'],
        path_params=[u'address', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/addresses/{address}',
        request_field='',
        request_type_name=u'ComputeAddressesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified address resource.

      Args:
        request: (ComputeAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Address) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.addresses.get',
        ordered_params=[u'project', u'region', u'address'],
        path_params=[u'address', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/addresses/{address}',
        request_field='',
        request_type_name=u'ComputeAddressesGetRequest',
        response_type_name=u'Address',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an address resource in the specified project by using the data included in the request.

      Args:
        request: (ComputeAddressesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.addresses.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/addresses',
        request_field=u'address',
        request_type_name=u'ComputeAddressesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of addresses contained within the specified region.

      Args:
        request: (ComputeAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.addresses.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/addresses',
        request_field='',
        request_type_name=u'ComputeAddressesListRequest',
        response_type_name=u'AddressList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an Address. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeAddressesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.addresses.setLabels',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/addresses/{resource}/setLabels',
        request_field=u'regionSetLabelsRequest',
        request_type_name=u'ComputeAddressesSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeAddressesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.addresses.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/addresses/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeAddressesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class AutoscalersService(base_api.BaseApiService):
    """Service class for the autoscalers resource."""

    _NAME = u'autoscalers'

    def __init__(self, client):
      super(ComputeBeta.AutoscalersService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of autoscalers.

      Args:
        request: (ComputeAutoscalersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AutoscalerAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.autoscalers.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/autoscalers',
        request_field='',
        request_type_name=u'ComputeAutoscalersAggregatedListRequest',
        response_type_name=u'AutoscalerAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified autoscaler.

      Args:
        request: (ComputeAutoscalersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.autoscalers.delete',
        ordered_params=[u'project', u'zone', u'autoscaler'],
        path_params=[u'autoscaler', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name=u'ComputeAutoscalersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified autoscaler resource. Gets a list of available autoscalers by making a list() request.

      Args:
        request: (ComputeAutoscalersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Autoscaler) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.autoscalers.get',
        ordered_params=[u'project', u'zone', u'autoscaler'],
        path_params=[u'autoscaler', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name=u'ComputeAutoscalersGetRequest',
        response_type_name=u'Autoscaler',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeAutoscalersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.autoscalers.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/autoscalers',
        request_field=u'autoscaler',
        request_type_name=u'ComputeAutoscalersInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of autoscalers contained within the specified zone.

      Args:
        request: (ComputeAutoscalersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AutoscalerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.autoscalers.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/autoscalers',
        request_field='',
        request_type_name=u'ComputeAutoscalersListRequest',
        response_type_name=u'AutoscalerList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeAutoscalersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.autoscalers.patch',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'autoscaler', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/autoscalers',
        request_field=u'autoscalerResource',
        request_type_name=u'ComputeAutoscalersPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeAutoscalersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.autoscalers.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/autoscalers/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeAutoscalersTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeAutoscalersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.autoscalers.update',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'autoscaler', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/autoscalers',
        request_field=u'autoscalerResource',
        request_type_name=u'ComputeAutoscalersUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class BackendBucketsService(base_api.BaseApiService):
    """Service class for the backendBuckets resource."""

    _NAME = u'backendBuckets'

    def __init__(self, client):
      super(ComputeBeta.BackendBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddSignedUrlKey(self, request, global_params=None):
      r"""Adds a key for validating requests with signed URLs for this backend bucket.

      Args:
        request: (ComputeBackendBucketsAddSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendBuckets.addSignedUrlKey',
        ordered_params=[u'project', u'backendBucket'],
        path_params=[u'backendBucket', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendBuckets/{backendBucket}/addSignedUrlKey',
        request_field=u'signedUrlKey',
        request_type_name=u'ComputeBackendBucketsAddSignedUrlKeyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified BackendBucket resource.

      Args:
        request: (ComputeBackendBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.backendBuckets.delete',
        ordered_params=[u'project', u'backendBucket'],
        path_params=[u'backendBucket', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name=u'ComputeBackendBucketsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DeleteSignedUrlKey(self, request, global_params=None):
      r"""Deletes a key for validating requests with signed URLs for this backend bucket.

      Args:
        request: (ComputeBackendBucketsDeleteSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendBuckets.deleteSignedUrlKey',
        ordered_params=[u'project', u'backendBucket', u'keyName'],
        path_params=[u'backendBucket', u'project'],
        query_params=[u'keyName', u'requestId'],
        relative_path=u'projects/{project}/global/backendBuckets/{backendBucket}/deleteSignedUrlKey',
        request_field='',
        request_type_name=u'ComputeBackendBucketsDeleteSignedUrlKeyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified BackendBucket resource. Gets a list of available backend buckets by making a list() request.

      Args:
        request: (ComputeBackendBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.backendBuckets.get',
        ordered_params=[u'project', u'backendBucket'],
        path_params=[u'backendBucket', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name=u'ComputeBackendBucketsGetRequest',
        response_type_name=u'BackendBucket',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a BackendBucket resource in the specified project using the data included in the request.

      Args:
        request: (ComputeBackendBucketsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendBuckets.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendBuckets',
        request_field=u'backendBucket',
        request_type_name=u'ComputeBackendBucketsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of BackendBucket resources available to the specified project.

      Args:
        request: (ComputeBackendBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucketList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.backendBuckets.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/backendBuckets',
        request_field='',
        request_type_name=u'ComputeBackendBucketsListRequest',
        response_type_name=u'BackendBucketList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified BackendBucket resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeBackendBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.backendBuckets.patch',
        ordered_params=[u'project', u'backendBucket'],
        path_params=[u'backendBucket', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendBuckets/{backendBucket}',
        request_field=u'backendBucketResource',
        request_type_name=u'ComputeBackendBucketsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified BackendBucket resource with the data included in the request.

      Args:
        request: (ComputeBackendBucketsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.backendBuckets.update',
        ordered_params=[u'project', u'backendBucket'],
        path_params=[u'backendBucket', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendBuckets/{backendBucket}',
        request_field=u'backendBucketResource',
        request_type_name=u'ComputeBackendBucketsUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class BackendServicesService(base_api.BaseApiService):
    """Service class for the backendServices resource."""

    _NAME = u'backendServices'

    def __init__(self, client):
      super(ComputeBeta.BackendServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddSignedUrlKey(self, request, global_params=None):
      r"""Adds a key for validating requests with signed URLs for this backend service.

      Args:
        request: (ComputeBackendServicesAddSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendServices.addSignedUrlKey',
        ordered_params=[u'project', u'backendService'],
        path_params=[u'backendService', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendServices/{backendService}/addSignedUrlKey',
        request_field=u'signedUrlKey',
        request_type_name=u'ComputeBackendServicesAddSignedUrlKeyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all BackendService resources, regional and global, available to the specified project.

      Args:
        request: (ComputeBackendServicesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.backendServices.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/backendServices',
        request_field='',
        request_type_name=u'ComputeBackendServicesAggregatedListRequest',
        response_type_name=u'BackendServiceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified BackendService resource.

      Args:
        request: (ComputeBackendServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.backendServices.delete',
        ordered_params=[u'project', u'backendService'],
        path_params=[u'backendService', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendServices/{backendService}',
        request_field='',
        request_type_name=u'ComputeBackendServicesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DeleteSignedUrlKey(self, request, global_params=None):
      r"""Deletes a key for validating requests with signed URLs for this backend service.

      Args:
        request: (ComputeBackendServicesDeleteSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendServices.deleteSignedUrlKey',
        ordered_params=[u'project', u'backendService', u'keyName'],
        path_params=[u'backendService', u'project'],
        query_params=[u'keyName', u'requestId'],
        relative_path=u'projects/{project}/global/backendServices/{backendService}/deleteSignedUrlKey',
        request_field='',
        request_type_name=u'ComputeBackendServicesDeleteSignedUrlKeyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified BackendService resource. Gets a list of available backend services.

      Args:
        request: (ComputeBackendServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.backendServices.get',
        ordered_params=[u'project', u'backendService'],
        path_params=[u'backendService', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/backendServices/{backendService}',
        request_field='',
        request_type_name=u'ComputeBackendServicesGetRequest',
        response_type_name=u'BackendService',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for this BackendService.

      Args:
        request: (ComputeBackendServicesGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceGroupHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendServices.getHealth',
        ordered_params=[u'project', u'backendService'],
        path_params=[u'backendService', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/backendServices/{backendService}/getHealth',
        request_field=u'resourceGroupReference',
        request_type_name=u'ComputeBackendServicesGetHealthRequest',
        response_type_name=u'BackendServiceGroupHealth',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a BackendService resource in the specified project using the data included in the request. There are several restrictions and guidelines to keep in mind when creating a backend service. Read  Restrictions and Guidelines for more information.

      Args:
        request: (ComputeBackendServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendServices.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendServices',
        request_field=u'backendService',
        request_type_name=u'ComputeBackendServicesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of BackendService resources available to the specified project.

      Args:
        request: (ComputeBackendServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.backendServices.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/backendServices',
        request_field='',
        request_type_name=u'ComputeBackendServicesListRequest',
        response_type_name=u'BackendServiceList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified BackendService resource with the data included in the request. There are several restrictions and guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for more information. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeBackendServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.backendServices.patch',
        ordered_params=[u'project', u'backendService'],
        path_params=[u'backendService', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendServices/{backendService}',
        request_field=u'backendServiceResource',
        request_type_name=u'ComputeBackendServicesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetSecurityPolicy(self, request, global_params=None):
      r"""Sets the security policy for the specified backend service.

      Args:
        request: (ComputeBackendServicesSetSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendServices.setSecurityPolicy',
        ordered_params=[u'project', u'backendService'],
        path_params=[u'backendService', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendServices/{backendService}/setSecurityPolicy',
        request_field=u'securityPolicyReference',
        request_type_name=u'ComputeBackendServicesSetSecurityPolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeBackendServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.backendServices.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/backendServices/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeBackendServicesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified BackendService resource with the data included in the request. There are several restrictions and guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for more information.

      Args:
        request: (ComputeBackendServicesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.backendServices.update',
        ordered_params=[u'project', u'backendService'],
        path_params=[u'backendService', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/backendServices/{backendService}',
        request_field=u'backendServiceResource',
        request_type_name=u'ComputeBackendServicesUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class DiskTypesService(base_api.BaseApiService):
    """Service class for the diskTypes resource."""

    _NAME = u'diskTypes'

    def __init__(self, client):
      super(ComputeBeta.DiskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of disk types.

      Args:
        request: (ComputeDiskTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.diskTypes.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/diskTypes',
        request_field='',
        request_type_name=u'ComputeDiskTypesAggregatedListRequest',
        response_type_name=u'DiskTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified disk type. Gets a list of available disk types by making a list() request.

      Args:
        request: (ComputeDiskTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.diskTypes.get',
        ordered_params=[u'project', u'zone', u'diskType'],
        path_params=[u'diskType', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/diskTypes/{diskType}',
        request_field='',
        request_type_name=u'ComputeDiskTypesGetRequest',
        response_type_name=u'DiskType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of disk types available to the specified project.

      Args:
        request: (ComputeDiskTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.diskTypes.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/diskTypes',
        request_field='',
        request_type_name=u'ComputeDiskTypesListRequest',
        response_type_name=u'DiskTypeList',
        supports_download=False,
    )

  class DisksService(base_api.BaseApiService):
    """Service class for the disks resource."""

    _NAME = u'disks'

    def __init__(self, client):
      super(ComputeBeta.DisksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to a disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.

      Args:
        request: (ComputeDisksAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.addResourcePolicies',
        ordered_params=[u'project', u'zone', u'disk'],
        path_params=[u'disk', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/disks/{disk}/addResourcePolicies',
        request_field=u'disksAddResourcePoliciesRequest',
        request_type_name=u'ComputeDisksAddResourcePoliciesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of persistent disks.

      Args:
        request: (ComputeDisksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.disks.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/disks',
        request_field='',
        request_type_name=u'ComputeDisksAggregatedListRequest',
        response_type_name=u'DiskAggregatedList',
        supports_download=False,
    )

    def CreateSnapshot(self, request, global_params=None):
      r"""Creates a snapshot of a specified persistent disk.

      Args:
        request: (ComputeDisksCreateSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateSnapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateSnapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.createSnapshot',
        ordered_params=[u'project', u'zone', u'disk'],
        path_params=[u'disk', u'project', u'zone'],
        query_params=[u'guestFlush', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/disks/{disk}/createSnapshot',
        request_field=u'snapshot',
        request_type_name=u'ComputeDisksCreateSnapshotRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified persistent disk. Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.

      Args:
        request: (ComputeDisksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.disks.delete',
        ordered_params=[u'project', u'zone', u'disk'],
        path_params=[u'disk', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/disks/{disk}',
        request_field='',
        request_type_name=u'ComputeDisksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a specified persistent disk. Gets a list of available persistent disks by making a list() request.

      Args:
        request: (ComputeDisksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Disk) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.disks.get',
        ordered_params=[u'project', u'zone', u'disk'],
        path_params=[u'disk', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/disks/{disk}',
        request_field='',
        request_type_name=u'ComputeDisksGetRequest',
        response_type_name=u'Disk',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeDisksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.disks.getIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/disks/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeDisksGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a persistent disk in the specified project using the data in the request. You can create a disk with a sourceImage, a sourceSnapshot, or create an empty 500 GB data disk by omitting all properties. You can also create a disk that is larger than the default size by specifying the sizeGb property.

      Args:
        request: (ComputeDisksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId', u'sourceImage'],
        relative_path=u'projects/{project}/zones/{zone}/disks',
        request_field=u'disk',
        request_type_name=u'ComputeDisksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of persistent disks contained within the specified zone.

      Args:
        request: (ComputeDisksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.disks.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/disks',
        request_field='',
        request_type_name=u'ComputeDisksListRequest',
        response_type_name=u'DiskList',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from a disk.

      Args:
        request: (ComputeDisksRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.removeResourcePolicies',
        ordered_params=[u'project', u'zone', u'disk'],
        path_params=[u'disk', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/disks/{disk}/removeResourcePolicies',
        request_field=u'disksRemoveResourcePoliciesRequest',
        request_type_name=u'ComputeDisksRemoveResourcePoliciesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the specified persistent disk. You can only increase the size of the disk.

      Args:
        request: (ComputeDisksResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.resize',
        ordered_params=[u'project', u'zone', u'disk'],
        path_params=[u'disk', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/disks/{disk}/resize',
        request_field=u'disksResizeRequest',
        request_type_name=u'ComputeDisksResizeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeDisksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.setIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/disks/{resource}/setIamPolicy',
        request_field=u'zoneSetPolicyRequest',
        request_type_name=u'ComputeDisksSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeDisksSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.setLabels',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/disks/{resource}/setLabels',
        request_field=u'zoneSetLabelsRequest',
        request_type_name=u'ComputeDisksSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeDisksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.disks.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/disks/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeDisksTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class ExternalVpnGatewaysService(base_api.BaseApiService):
    """Service class for the externalVpnGateways resource."""

    _NAME = u'externalVpnGateways'

    def __init__(self, client):
      super(ComputeBeta.ExternalVpnGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified externalVpnGateway.

      Args:
        request: (ComputeExternalVpnGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.externalVpnGateways.delete',
        ordered_params=[u'project', u'externalVpnGateway'],
        path_params=[u'externalVpnGateway', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/externalVpnGateways/{externalVpnGateway}',
        request_field='',
        request_type_name=u'ComputeExternalVpnGatewaysDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a list() request.

      Args:
        request: (ComputeExternalVpnGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExternalVpnGateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.externalVpnGateways.get',
        ordered_params=[u'project', u'externalVpnGateway'],
        path_params=[u'externalVpnGateway', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/externalVpnGateways/{externalVpnGateway}',
        request_field='',
        request_type_name=u'ComputeExternalVpnGatewaysGetRequest',
        response_type_name=u'ExternalVpnGateway',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a ExternalVpnGateway in the specified project using the data included in the request.

      Args:
        request: (ComputeExternalVpnGatewaysInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.externalVpnGateways.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/externalVpnGateways',
        request_field=u'externalVpnGateway',
        request_type_name=u'ComputeExternalVpnGatewaysInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of ExternalVpnGateway available to the specified project.

      Args:
        request: (ComputeExternalVpnGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExternalVpnGatewayList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.externalVpnGateways.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/externalVpnGateways',
        request_field='',
        request_type_name=u'ComputeExternalVpnGatewaysListRequest',
        response_type_name=u'ExternalVpnGatewayList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeExternalVpnGatewaysSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.externalVpnGateways.setLabels',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/externalVpnGateways/{resource}/setLabels',
        request_field=u'globalSetLabelsRequest',
        request_type_name=u'ComputeExternalVpnGatewaysSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeExternalVpnGatewaysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.externalVpnGateways.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/externalVpnGateways/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeExternalVpnGatewaysTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class FirewallsService(base_api.BaseApiService):
    """Service class for the firewalls resource."""

    _NAME = u'firewalls'

    def __init__(self, client):
      super(ComputeBeta.FirewallsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified firewall.

      Args:
        request: (ComputeFirewallsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.firewalls.delete',
        ordered_params=[u'project', u'firewall'],
        path_params=[u'firewall', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/firewalls/{firewall}',
        request_field='',
        request_type_name=u'ComputeFirewallsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified firewall.

      Args:
        request: (ComputeFirewallsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Firewall) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.firewalls.get',
        ordered_params=[u'project', u'firewall'],
        path_params=[u'firewall', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/firewalls/{firewall}',
        request_field='',
        request_type_name=u'ComputeFirewallsGetRequest',
        response_type_name=u'Firewall',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a firewall rule in the specified project using the data included in the request.

      Args:
        request: (ComputeFirewallsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.firewalls.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/firewalls',
        request_field=u'firewall',
        request_type_name=u'ComputeFirewallsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of firewall rules available to the specified project.

      Args:
        request: (ComputeFirewallsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.firewalls.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/firewalls',
        request_field='',
        request_type_name=u'ComputeFirewallsListRequest',
        response_type_name=u'FirewallList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified firewall rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeFirewallsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.firewalls.patch',
        ordered_params=[u'project', u'firewall'],
        path_params=[u'firewall', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/firewalls/{firewall}',
        request_field=u'firewallResource',
        request_type_name=u'ComputeFirewallsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeFirewallsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.firewalls.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/firewalls/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeFirewallsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified firewall rule with the data included in the request. The PUT method can only update the following fields of firewall rule: allowed, description, sourceRanges, sourceTags, targetTags.

      Args:
        request: (ComputeFirewallsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.firewalls.update',
        ordered_params=[u'project', u'firewall'],
        path_params=[u'firewall', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/firewalls/{firewall}',
        request_field=u'firewallResource',
        request_type_name=u'ComputeFirewallsUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ForwardingRulesService(base_api.BaseApiService):
    """Service class for the forwardingRules resource."""

    _NAME = u'forwardingRules'

    def __init__(self, client):
      super(ComputeBeta.ForwardingRulesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of forwarding rules.

      Args:
        request: (ComputeForwardingRulesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.forwardingRules.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/forwardingRules',
        request_field='',
        request_type_name=u'ComputeForwardingRulesAggregatedListRequest',
        response_type_name=u'ForwardingRuleAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified ForwardingRule resource.

      Args:
        request: (ComputeForwardingRulesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.forwardingRules.delete',
        ordered_params=[u'project', u'region', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name=u'ComputeForwardingRulesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified ForwardingRule resource.

      Args:
        request: (ComputeForwardingRulesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRule) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.forwardingRules.get',
        ordered_params=[u'project', u'region', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name=u'ComputeForwardingRulesGetRequest',
        response_type_name=u'ForwardingRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a ForwardingRule resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeForwardingRulesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.forwardingRules.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules',
        request_field=u'forwardingRule',
        request_type_name=u'ComputeForwardingRulesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of ForwardingRule resources available to the specified project and region.

      Args:
        request: (ComputeForwardingRulesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.forwardingRules.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules',
        request_field='',
        request_type_name=u'ComputeForwardingRulesListRequest',
        response_type_name=u'ForwardingRuleList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.

      Args:
        request: (ComputeForwardingRulesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.forwardingRules.patch',
        ordered_params=[u'project', u'region', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field=u'forwardingRuleResource',
        request_type_name=u'ComputeForwardingRulesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the specified resource. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeForwardingRulesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.forwardingRules.setLabels',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules/{resource}/setLabels',
        request_field=u'regionSetLabelsRequest',
        request_type_name=u'ComputeForwardingRulesSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetTarget(self, request, global_params=None):
      r"""Changes target URL for forwarding rule. The new target should be of the same type as the old target.

      Args:
        request: (ComputeForwardingRulesSetTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTarget.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.forwardingRules.setTarget',
        ordered_params=[u'project', u'region', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget',
        request_field=u'targetReference',
        request_type_name=u'ComputeForwardingRulesSetTargetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeForwardingRulesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.forwardingRules.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/forwardingRules/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeForwardingRulesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalAddressesService(base_api.BaseApiService):
    """Service class for the globalAddresses resource."""

    _NAME = u'globalAddresses'

    def __init__(self, client):
      super(ComputeBeta.GlobalAddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified address resource.

      Args:
        request: (ComputeGlobalAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.globalAddresses.delete',
        ordered_params=[u'project', u'address'],
        path_params=[u'address', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/addresses/{address}',
        request_field='',
        request_type_name=u'ComputeGlobalAddressesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified address resource. Gets a list of available addresses by making a list() request.

      Args:
        request: (ComputeGlobalAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Address) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.globalAddresses.get',
        ordered_params=[u'project', u'address'],
        path_params=[u'address', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/addresses/{address}',
        request_field='',
        request_type_name=u'ComputeGlobalAddressesGetRequest',
        response_type_name=u'Address',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an address resource in the specified project by using the data included in the request.

      Args:
        request: (ComputeGlobalAddressesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.globalAddresses.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/addresses',
        request_field=u'address',
        request_type_name=u'ComputeGlobalAddressesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of global addresses.

      Args:
        request: (ComputeGlobalAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.globalAddresses.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/addresses',
        request_field='',
        request_type_name=u'ComputeGlobalAddressesListRequest',
        response_type_name=u'AddressList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a GlobalAddress. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeGlobalAddressesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.globalAddresses.setLabels',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/addresses/{resource}/setLabels',
        request_field=u'globalSetLabelsRequest',
        request_type_name=u'ComputeGlobalAddressesSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeGlobalAddressesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.globalAddresses.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/addresses/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeGlobalAddressesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalForwardingRulesService(base_api.BaseApiService):
    """Service class for the globalForwardingRules resource."""

    _NAME = u'globalForwardingRules'

    def __init__(self, client):
      super(ComputeBeta.GlobalForwardingRulesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified GlobalForwardingRule resource.

      Args:
        request: (ComputeGlobalForwardingRulesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.globalForwardingRules.delete',
        ordered_params=[u'project', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name=u'ComputeGlobalForwardingRulesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by making a list() request.

      Args:
        request: (ComputeGlobalForwardingRulesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRule) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.globalForwardingRules.get',
        ordered_params=[u'project', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name=u'ComputeGlobalForwardingRulesGetRequest',
        response_type_name=u'ForwardingRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a GlobalForwardingRule resource in the specified project using the data included in the request.

      Args:
        request: (ComputeGlobalForwardingRulesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.globalForwardingRules.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/forwardingRules',
        request_field=u'forwardingRule',
        request_type_name=u'ComputeGlobalForwardingRulesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of GlobalForwardingRule resources available to the specified project.

      Args:
        request: (ComputeGlobalForwardingRulesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.globalForwardingRules.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/forwardingRules',
        request_field='',
        request_type_name=u'ComputeGlobalForwardingRulesListRequest',
        response_type_name=u'ForwardingRuleList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.

      Args:
        request: (ComputeGlobalForwardingRulesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.globalForwardingRules.patch',
        ordered_params=[u'project', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field=u'forwardingRuleResource',
        request_type_name=u'ComputeGlobalForwardingRulesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the specified resource. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeGlobalForwardingRulesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.globalForwardingRules.setLabels',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/forwardingRules/{resource}/setLabels',
        request_field=u'globalSetLabelsRequest',
        request_type_name=u'ComputeGlobalForwardingRulesSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetTarget(self, request, global_params=None):
      r"""Changes target URL for the GlobalForwardingRule resource. The new target should be of the same type as the old target.

      Args:
        request: (ComputeGlobalForwardingRulesSetTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTarget.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.globalForwardingRules.setTarget',
        ordered_params=[u'project', u'forwardingRule'],
        path_params=[u'forwardingRule', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/forwardingRules/{forwardingRule}/setTarget',
        request_field=u'targetReference',
        request_type_name=u'ComputeGlobalForwardingRulesSetTargetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeGlobalForwardingRulesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.globalForwardingRules.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/forwardingRules/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeGlobalForwardingRulesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalOperationsService(base_api.BaseApiService):
    """Service class for the globalOperations resource."""

    _NAME = u'globalOperations'

    def __init__(self, client):
      super(ComputeBeta.GlobalOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of all operations.

      Args:
        request: (ComputeGlobalOperationsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.globalOperations.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/operations',
        request_field='',
        request_type_name=u'ComputeGlobalOperationsAggregatedListRequest',
        response_type_name=u'OperationAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Operations resource.

      Args:
        request: (ComputeGlobalOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeGlobalOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.globalOperations.delete',
        ordered_params=[u'project', u'operation'],
        path_params=[u'operation', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/operations/{operation}',
        request_field='',
        request_type_name=u'ComputeGlobalOperationsDeleteRequest',
        response_type_name=u'ComputeGlobalOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified Operations resource. Gets a list of operations by making a list() request.

      Args:
        request: (ComputeGlobalOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.globalOperations.get',
        ordered_params=[u'project', u'operation'],
        path_params=[u'operation', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/operations/{operation}',
        request_field='',
        request_type_name=u'ComputeGlobalOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified project.

      Args:
        request: (ComputeGlobalOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.globalOperations.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/operations',
        request_field='',
        request_type_name=u'ComputeGlobalOperationsListRequest',
        response_type_name=u'OperationList',
        supports_download=False,
    )

  class HealthChecksService(base_api.BaseApiService):
    """Service class for the healthChecks resource."""

    _NAME = u'healthChecks'

    def __init__(self, client):
      super(ComputeBeta.HealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all HealthCheck resources, regional and global, available to the specified project.

      Args:
        request: (ComputeHealthChecksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthChecksAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.healthChecks.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/healthChecks',
        request_field='',
        request_type_name=u'ComputeHealthChecksAggregatedListRequest',
        response_type_name=u'HealthChecksAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthCheck resource.

      Args:
        request: (ComputeHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.healthChecks.delete',
        ordered_params=[u'project', u'healthCheck'],
        path_params=[u'healthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/healthChecks/{healthCheck}',
        request_field='',
        request_type_name=u'ComputeHealthChecksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthCheck resource. Gets a list of available health checks by making a list() request.

      Args:
        request: (ComputeHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.healthChecks.get',
        ordered_params=[u'project', u'healthCheck'],
        path_params=[u'healthCheck', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/healthChecks/{healthCheck}',
        request_field='',
        request_type_name=u'ComputeHealthChecksGetRequest',
        response_type_name=u'HealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.healthChecks.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/healthChecks',
        request_field=u'healthCheck',
        request_type_name=u'ComputeHealthChecksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HealthCheck resources available to the specified project.

      Args:
        request: (ComputeHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.healthChecks.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/healthChecks',
        request_field='',
        request_type_name=u'ComputeHealthChecksListRequest',
        response_type_name=u'HealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.healthChecks.patch',
        ordered_params=[u'project', u'healthCheck'],
        path_params=[u'healthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/healthChecks/{healthCheck}',
        request_field=u'healthCheckResource',
        request_type_name=u'ComputeHealthChecksPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.healthChecks.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/healthChecks/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeHealthChecksTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.healthChecks.update',
        ordered_params=[u'project', u'healthCheck'],
        path_params=[u'healthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/healthChecks/{healthCheck}',
        request_field=u'healthCheckResource',
        request_type_name=u'ComputeHealthChecksUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class HttpHealthChecksService(base_api.BaseApiService):
    """Service class for the httpHealthChecks resource."""

    _NAME = u'httpHealthChecks'

    def __init__(self, client):
      super(ComputeBeta.HttpHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HttpHealthCheck resource.

      Args:
        request: (ComputeHttpHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.httpHealthChecks.delete',
        ordered_params=[u'project', u'httpHealthCheck'],
        path_params=[u'httpHealthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='',
        request_type_name=u'ComputeHttpHealthChecksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HttpHealthCheck resource. Gets a list of available HTTP health checks by making a list() request.

      Args:
        request: (ComputeHttpHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpHealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.httpHealthChecks.get',
        ordered_params=[u'project', u'httpHealthCheck'],
        path_params=[u'httpHealthCheck', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='',
        request_type_name=u'ComputeHttpHealthChecksGetRequest',
        response_type_name=u'HttpHealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HttpHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.httpHealthChecks.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpHealthChecks',
        request_field=u'httpHealthCheck',
        request_type_name=u'ComputeHttpHealthChecksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HttpHealthCheck resources available to the specified project.

      Args:
        request: (ComputeHttpHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpHealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.httpHealthChecks.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/httpHealthChecks',
        request_field='',
        request_type_name=u'ComputeHttpHealthChecksListRequest',
        response_type_name=u'HttpHealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HttpHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHttpHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.httpHealthChecks.patch',
        ordered_params=[u'project', u'httpHealthCheck'],
        path_params=[u'httpHealthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field=u'httpHealthCheckResource',
        request_type_name=u'ComputeHttpHealthChecksPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHttpHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.httpHealthChecks.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/httpHealthChecks/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeHttpHealthChecksTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HttpHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.httpHealthChecks.update',
        ordered_params=[u'project', u'httpHealthCheck'],
        path_params=[u'httpHealthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field=u'httpHealthCheckResource',
        request_type_name=u'ComputeHttpHealthChecksUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class HttpsHealthChecksService(base_api.BaseApiService):
    """Service class for the httpsHealthChecks resource."""

    _NAME = u'httpsHealthChecks'

    def __init__(self, client):
      super(ComputeBeta.HttpsHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HttpsHealthCheck resource.

      Args:
        request: (ComputeHttpsHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.httpsHealthChecks.delete',
        ordered_params=[u'project', u'httpsHealthCheck'],
        path_params=[u'httpsHealthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='',
        request_type_name=u'ComputeHttpsHealthChecksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HttpsHealthCheck resource. Gets a list of available HTTPS health checks by making a list() request.

      Args:
        request: (ComputeHttpsHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpsHealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.httpsHealthChecks.get',
        ordered_params=[u'project', u'httpsHealthCheck'],
        path_params=[u'httpsHealthCheck', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='',
        request_type_name=u'ComputeHttpsHealthChecksGetRequest',
        response_type_name=u'HttpsHealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HttpsHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpsHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.httpsHealthChecks.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpsHealthChecks',
        request_field=u'httpsHealthCheck',
        request_type_name=u'ComputeHttpsHealthChecksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HttpsHealthCheck resources available to the specified project.

      Args:
        request: (ComputeHttpsHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpsHealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.httpsHealthChecks.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/httpsHealthChecks',
        request_field='',
        request_type_name=u'ComputeHttpsHealthChecksListRequest',
        response_type_name=u'HttpsHealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HttpsHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHttpsHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.httpsHealthChecks.patch',
        ordered_params=[u'project', u'httpsHealthCheck'],
        path_params=[u'httpsHealthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field=u'httpsHealthCheckResource',
        request_type_name=u'ComputeHttpsHealthChecksPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHttpsHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.httpsHealthChecks.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/httpsHealthChecks/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeHttpsHealthChecksTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HttpsHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpsHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.httpsHealthChecks.update',
        ordered_params=[u'project', u'httpsHealthCheck'],
        path_params=[u'httpsHealthCheck', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field=u'httpsHealthCheckResource',
        request_type_name=u'ComputeHttpsHealthChecksUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ImagesService(base_api.BaseApiService):
    """Service class for the images resource."""

    _NAME = u'images'

    def __init__(self, client):
      super(ComputeBeta.ImagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified image.

      Args:
        request: (ComputeImagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.images.delete',
        ordered_params=[u'project', u'image'],
        path_params=[u'image', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/images/{image}',
        request_field='',
        request_type_name=u'ComputeImagesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Deprecate(self, request, global_params=None):
      r"""Sets the deprecation status of an image.

If an empty request body is given, clears the deprecation status instead.

      Args:
        request: (ComputeImagesDeprecateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Deprecate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deprecate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.images.deprecate',
        ordered_params=[u'project', u'image'],
        path_params=[u'image', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/images/{image}/deprecate',
        request_field=u'deprecationStatus',
        request_type_name=u'ComputeImagesDeprecateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified image. Gets a list of available images by making a list() request.

      Args:
        request: (ComputeImagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Image) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.images.get',
        ordered_params=[u'project', u'image'],
        path_params=[u'image', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/images/{image}',
        request_field='',
        request_type_name=u'ComputeImagesGetRequest',
        response_type_name=u'Image',
        supports_download=False,
    )

    def GetFromFamily(self, request, global_params=None):
      r"""Returns the latest image that is part of an image family and is not deprecated.

      Args:
        request: (ComputeImagesGetFromFamilyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Image) The response message.
      """
      config = self.GetMethodConfig('GetFromFamily')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetFromFamily.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.images.getFromFamily',
        ordered_params=[u'project', u'family'],
        path_params=[u'family', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/images/family/{family}',
        request_field='',
        request_type_name=u'ComputeImagesGetFromFamilyRequest',
        response_type_name=u'Image',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeImagesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.images.getIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/images/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeImagesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an image in the specified project using the data included in the request.

      Args:
        request: (ComputeImagesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.images.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'forceCreate', u'requestId'],
        relative_path=u'projects/{project}/global/images',
        request_field=u'image',
        request_type_name=u'ComputeImagesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of custom images available to the specified project. Custom images are images you create that belong to your project. This method does not get any images that belong to other projects, including publicly-available images, like Debian 8. If you want to get a list of publicly-available images, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud.

      Args:
        request: (ComputeImagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImageList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.images.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/images',
        request_field='',
        request_type_name=u'ComputeImagesListRequest',
        response_type_name=u'ImageList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeImagesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.images.setIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/images/{resource}/setIamPolicy',
        request_field=u'globalSetPolicyRequest',
        request_type_name=u'ComputeImagesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an image. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeImagesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.images.setLabels',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/images/{resource}/setLabels',
        request_field=u'globalSetLabelsRequest',
        request_type_name=u'ComputeImagesSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeImagesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.images.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/images/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeImagesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class InstanceGroupManagersService(base_api.BaseApiService):
    """Service class for the instanceGroupManagers resource."""

    _NAME = u'instanceGroupManagers'

    def __init__(self, client):
      super(ComputeBeta.InstanceGroupManagersService, self).__init__(client)
      self._upload_configs = {
          }

    def AbandonInstances(self, request, global_params=None):
      r"""Flags the specified instances to be removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersAbandonInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AbandonInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AbandonInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.abandonInstances',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/abandonInstances',
        request_field=u'instanceGroupManagersAbandonInstancesRequest',
        request_type_name=u'ComputeInstanceGroupManagersAbandonInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of managed instance groups and groups them by zone.

      Args:
        request: (ComputeInstanceGroupManagersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceGroupManagers.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/instanceGroupManagers',
        request_field='',
        request_type_name=u'ComputeInstanceGroupManagersAggregatedListRequest',
        response_type_name=u'InstanceGroupManagerAggregatedList',
        supports_download=False,
    )

    def ApplyUpdatesToInstances(self, request, global_params=None):
      r"""Apply changes to selected instances on the managed instance group. This method can be used to apply new overrides and/or new versions.

      Args:
        request: (ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ApplyUpdatesToInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyUpdatesToInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.applyUpdatesToInstances',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances',
        request_field=u'instanceGroupManagersApplyUpdatesRequest',
        request_type_name=u'ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified managed instance group and all of the instances in that group. Note that the instance group must not belong to a backend service. Read  Deleting an instance group for more information.

      Args:
        request: (ComputeInstanceGroupManagersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.instanceGroupManagers.delete',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name=u'ComputeInstanceGroupManagersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DeleteInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group for immediate deletion. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. This operation is marked as DONE when the action is scheduled even if the instances are still being deleted. You must separately verify the status of the deleting action with the listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersDeleteInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.deleteInstances',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deleteInstances',
        request_field=u'instanceGroupManagersDeleteInstancesRequest',
        request_type_name=u'ComputeInstanceGroupManagersDeleteInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified managed instance group. Gets a list of available managed instance groups by making a list() request.

      Args:
        request: (ComputeInstanceGroupManagersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManager) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceGroupManagers.get',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name=u'ComputeInstanceGroupManagersGetRequest',
        response_type_name=u'InstanceGroupManager',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method.

A managed instance group can have up to 1000 VM instances per group. Please contact Cloud Support if you need an increase in this limit.

      Args:
        request: (ComputeInstanceGroupManagersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers',
        request_field=u'instanceGroupManager',
        request_type_name=u'ComputeInstanceGroupManagersInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of managed instance groups that are contained within the specified project and zone.

      Args:
        request: (ComputeInstanceGroupManagersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceGroupManagers.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers',
        request_field='',
        request_type_name=u'ComputeInstanceGroupManagersListRequest',
        response_type_name=u'InstanceGroupManagerList',
        supports_download=False,
    )

    def ListManagedInstances(self, request, global_params=None):
      r"""Lists all of the instances in the managed instance group. Each instance in the list has a currentAction, which indicates the action that the managed instance group is performing on the instance. For example, if the group is still creating an instance, the currentAction is CREATING. If a previous action failed, the list displays the errors for that failed action.

      Args:
        request: (ComputeInstanceGroupManagersListManagedInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersListManagedInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('ListManagedInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListManagedInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.listManagedInstances',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'order_by', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances',
        request_field='',
        request_type_name=u'ComputeInstanceGroupManagersListManagedInstancesRequest',
        response_type_name=u'InstanceGroupManagersListManagedInstancesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listManagedInstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstanceGroupManagersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.instanceGroupManagers.patch',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field=u'instanceGroupManagerResource',
        request_type_name=u'ComputeInstanceGroupManagersPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RecreateInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately recreated. The instances are deleted and recreated using the current instance template for the managed instance group. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of the recreating action with the listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersRecreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RecreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RecreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.recreateInstances',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/recreateInstances',
        request_field=u'instanceGroupManagersRecreateInstancesRequest',
        request_type_name=u'ComputeInstanceGroupManagersRecreateInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method.

When resizing down, the instance group arbitrarily chooses the order in which VMs are deleted. The group takes into account some VM attributes when making the selection including:

+ The status of the VM instance. + The health of the VM instance. + The instance template version the VM is based on. + For regional managed instance groups, the location of the VM instance.

This list is subject to change.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupManagersResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.resize',
        ordered_params=[u'project', u'zone', u'instanceGroupManager', u'size'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId', u'size'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resize',
        request_field='',
        request_type_name=u'ComputeInstanceGroupManagersResizeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ResizeAdvanced(self, request, global_params=None):
      r"""Resizes the managed instance group with advanced configuration options like disabling creation retries. This is an extended version of the resize method.

If you increase the size of the instance group, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating, creatingWithoutRetries, or deleting actions with the get or listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupManagersResizeAdvancedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResizeAdvanced')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResizeAdvanced.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.resizeAdvanced',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeAdvanced',
        request_field=u'instanceGroupManagersResizeAdvancedRequest',
        request_type_name=u'ComputeInstanceGroupManagersResizeAdvancedRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetAutoHealingPolicies(self, request, global_params=None):
      r"""Modifies the autohealing policies. [Deprecated] This method is deprecated. Please use Patch instead.

      Args:
        request: (ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoHealingPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoHealingPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.setAutoHealingPolicies',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setAutoHealingPolicies',
        request_field=u'instanceGroupManagersSetAutoHealingRequest',
        request_type_name=u'ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetInstanceTemplate(self, request, global_params=None):
      r"""Specifies the instance template to use when creating new instances in this group. The templates for existing instances in the group do not change unless you recreate them.

      Args:
        request: (ComputeInstanceGroupManagersSetInstanceTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetInstanceTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetInstanceTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.setInstanceTemplate',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate',
        request_field=u'instanceGroupManagersSetInstanceTemplateRequest',
        request_type_name=u'ComputeInstanceGroupManagersSetInstanceTemplateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetTargetPools(self, request, global_params=None):
      r"""Modifies the target pools to which all instances in this managed instance group are assigned. The target pools automatically apply to all of the instances in the managed instance group. This operation is marked DONE when you make the request even if the instances have not yet been added to their target pools. The change might take some time to apply to all of the instances in the group depending on the size of the group.

      Args:
        request: (ComputeInstanceGroupManagersSetTargetPoolsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTargetPools')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTargetPools.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.setTargetPools',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setTargetPools',
        request_field=u'instanceGroupManagersSetTargetPoolsRequest',
        request_type_name=u'ComputeInstanceGroupManagersSetTargetPoolsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceGroupManagersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroupManagers.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeInstanceGroupManagersTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listManagedInstances method.

      Args:
        request: (ComputeInstanceGroupManagersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.instanceGroupManagers.update',
        ordered_params=[u'project', u'zone', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field=u'instanceGroupManagerResource',
        request_type_name=u'ComputeInstanceGroupManagersUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class InstanceGroupsService(base_api.BaseApiService):
    """Service class for the instanceGroups resource."""

    _NAME = u'instanceGroups'

    def __init__(self, client):
      super(ComputeBeta.InstanceGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddInstances(self, request, global_params=None):
      r"""Adds a list of instances to the specified instance group. All of the instances in the instance group must be in the same network/subnetwork. Read  Adding instances for more information.

      Args:
        request: (ComputeInstanceGroupsAddInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroups.addInstances',
        ordered_params=[u'project', u'zone', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/addInstances',
        request_field=u'instanceGroupsAddInstancesRequest',
        request_type_name=u'ComputeInstanceGroupsAddInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of instance groups and sorts them by zone.

      Args:
        request: (ComputeInstanceGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceGroups.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/instanceGroups',
        request_field='',
        request_type_name=u'ComputeInstanceGroupsAggregatedListRequest',
        response_type_name=u'InstanceGroupAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified instance group. The instances in the group are not deleted. Note that instance group must not belong to a backend service. Read  Deleting an instance group for more information.

      Args:
        request: (ComputeInstanceGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.instanceGroups.delete',
        ordered_params=[u'project', u'zone', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name=u'ComputeInstanceGroupsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified instance group. Gets a list of available instance groups by making a list() request.

      Args:
        request: (ComputeInstanceGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceGroups.get',
        ordered_params=[u'project', u'zone', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name=u'ComputeInstanceGroupsGetRequest',
        response_type_name=u'InstanceGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeInstanceGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroups.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups',
        request_field=u'instanceGroup',
        request_type_name=u'ComputeInstanceGroupsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of instance groups that are located in the specified project and zone.

      Args:
        request: (ComputeInstanceGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceGroups.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups',
        request_field='',
        request_type_name=u'ComputeInstanceGroupsListRequest',
        response_type_name=u'InstanceGroupList',
        supports_download=False,
    )

    def ListInstances(self, request, global_params=None):
      r"""Lists the instances in the specified instance group.

      Args:
        request: (ComputeInstanceGroupsListInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupsListInstances) The response message.
      """
      config = self.GetMethodConfig('ListInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroups.listInstances',
        ordered_params=[u'project', u'zone', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/listInstances',
        request_field=u'instanceGroupsListInstancesRequest',
        request_type_name=u'ComputeInstanceGroupsListInstancesRequest',
        response_type_name=u'InstanceGroupsListInstances',
        supports_download=False,
    )

    def RemoveInstances(self, request, global_params=None):
      r"""Removes one or more instances from the specified instance group, but does not delete those instances.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupsRemoveInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroups.removeInstances',
        ordered_params=[u'project', u'zone', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/removeInstances',
        request_field=u'instanceGroupsRemoveInstancesRequest',
        request_type_name=u'ComputeInstanceGroupsRemoveInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetNamedPorts(self, request, global_params=None):
      r"""Sets the named ports for the specified instance group.

      Args:
        request: (ComputeInstanceGroupsSetNamedPortsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNamedPorts')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNamedPorts.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroups.setNamedPorts',
        ordered_params=[u'project', u'zone', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/setNamedPorts',
        request_field=u'instanceGroupsSetNamedPortsRequest',
        request_type_name=u'ComputeInstanceGroupsSetNamedPortsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceGroups.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instanceGroups/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeInstanceGroupsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class InstanceTemplatesService(base_api.BaseApiService):
    """Service class for the instanceTemplates resource."""

    _NAME = u'instanceTemplates'

    def __init__(self, client):
      super(ComputeBeta.InstanceTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone. It is not possible to delete templates that are already in use by a managed instance group.

      Args:
        request: (ComputeInstanceTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.instanceTemplates.delete',
        ordered_params=[u'project', u'instanceTemplate'],
        path_params=[u'instanceTemplate', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name=u'ComputeInstanceTemplatesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified instance template. Gets a list of available instance templates by making a list() request.

      Args:
        request: (ComputeInstanceTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceTemplates.get',
        ordered_params=[u'project', u'instanceTemplate'],
        path_params=[u'instanceTemplate', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name=u'ComputeInstanceTemplatesGetRequest',
        response_type_name=u'InstanceTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstanceTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceTemplates.getIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/instanceTemplates/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeInstanceTemplatesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance template in the specified project using the data that is included in the request. If you are creating a new template to update an existing instance group, your new instance template must use the same network or, if applicable, the same subnetwork as the original template.

      Args:
        request: (ComputeInstanceTemplatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceTemplates.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/instanceTemplates',
        request_field=u'instanceTemplate',
        request_type_name=u'ComputeInstanceTemplatesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of instance templates that are contained within the specified project.

      Args:
        request: (ComputeInstanceTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instanceTemplates.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/instanceTemplates',
        request_field='',
        request_type_name=u'ComputeInstanceTemplatesListRequest',
        response_type_name=u'InstanceTemplateList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstanceTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceTemplates.setIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/instanceTemplates/{resource}/setIamPolicy',
        request_field=u'globalSetPolicyRequest',
        request_type_name=u'ComputeInstanceTemplatesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instanceTemplates.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/instanceTemplates/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeInstanceTemplatesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class InstancesService(base_api.BaseApiService):
    """Service class for the instances resource."""

    _NAME = u'instances'

    def __init__(self, client):
      super(ComputeBeta.InstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAccessConfig(self, request, global_params=None):
      r"""Adds an access config to an instance's network interface.

      Args:
        request: (ComputeInstancesAddAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.addAccessConfig',
        ordered_params=[u'project', u'zone', u'instance', u'networkInterface'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'networkInterface', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/addAccessConfig',
        request_field=u'accessConfig',
        request_type_name=u'ComputeInstancesAddAccessConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves aggregated list of all of the instances in your project across all regions and zones.

      Args:
        request: (ComputeInstancesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/instances',
        request_field='',
        request_type_name=u'ComputeInstancesAggregatedListRequest',
        response_type_name=u'InstanceAggregatedList',
        supports_download=False,
    )

    def AttachDisk(self, request, global_params=None):
      r"""Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.

      Args:
        request: (ComputeInstancesAttachDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.attachDisk',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'forceAttach', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/attachDisk',
        request_field=u'attachedDisk',
        request_type_name=u'ComputeInstancesAttachDiskRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Instance resource. For more information, see Stopping or Deleting an Instance.

      Args:
        request: (ComputeInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.instances.delete',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}',
        request_field='',
        request_type_name=u'ComputeInstancesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DeleteAccessConfig(self, request, global_params=None):
      r"""Deletes an access config from an instance's network interface.

      Args:
        request: (ComputeInstancesDeleteAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.deleteAccessConfig',
        ordered_params=[u'project', u'zone', u'instance', u'accessConfig', u'networkInterface'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'accessConfig', u'networkInterface', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/deleteAccessConfig',
        request_field='',
        request_type_name=u'ComputeInstancesDeleteAccessConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DetachDisk(self, request, global_params=None):
      r"""Detaches a disk from an instance.

      Args:
        request: (ComputeInstancesDetachDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.detachDisk',
        ordered_params=[u'project', u'zone', u'instance', u'deviceName'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'deviceName', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/detachDisk',
        request_field='',
        request_type_name=u'ComputeInstancesDetachDiskRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Instance resource. Gets a list of available instances by making a list() request.

      Args:
        request: (ComputeInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.get',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}',
        request_field='',
        request_type_name=u'ComputeInstancesGetRequest',
        response_type_name=u'Instance',
        supports_download=False,
    )

    def GetGuestAttributes(self, request, global_params=None):
      r"""Returns the specified guest attributes entry.

      Args:
        request: (ComputeInstancesGetGuestAttributesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GuestAttributes) The response message.
      """
      config = self.GetMethodConfig('GetGuestAttributes')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetGuestAttributes.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.getGuestAttributes',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'queryPath', u'variableKey'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/getGuestAttributes',
        request_field='',
        request_type_name=u'ComputeInstancesGetGuestAttributesRequest',
        response_type_name=u'GuestAttributes',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstancesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.getIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instances/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeInstancesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def GetSerialPortOutput(self, request, global_params=None):
      r"""Returns the last 1 MB of serial port output from the specified instance.

      Args:
        request: (ComputeInstancesGetSerialPortOutputRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SerialPortOutput) The response message.
      """
      config = self.GetMethodConfig('GetSerialPortOutput')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSerialPortOutput.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.getSerialPortOutput',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'port', u'start'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/serialPort',
        request_field='',
        request_type_name=u'ComputeInstancesGetSerialPortOutputRequest',
        response_type_name=u'SerialPortOutput',
        supports_download=False,
    )

    def GetShieldedInstanceIdentity(self, request, global_params=None):
      r"""Returns the Shielded Instance Identity of an instance.

      Args:
        request: (ComputeInstancesGetShieldedInstanceIdentityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShieldedInstanceIdentity) The response message.
      """
      config = self.GetMethodConfig('GetShieldedInstanceIdentity')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetShieldedInstanceIdentity.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.getShieldedInstanceIdentity',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/getShieldedInstanceIdentity',
        request_field='',
        request_type_name=u'ComputeInstancesGetShieldedInstanceIdentityRequest',
        response_type_name=u'ShieldedInstanceIdentity',
        supports_download=False,
    )

    def GetShieldedVmIdentity(self, request, global_params=None):
      r"""Returns the Shielded VM Identity of an instance.

      Args:
        request: (ComputeInstancesGetShieldedVmIdentityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShieldedVmIdentity) The response message.
      """
      config = self.GetMethodConfig('GetShieldedVmIdentity')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetShieldedVmIdentity.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.getShieldedVmIdentity',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/getShieldedVmIdentity',
        request_field='',
        request_type_name=u'ComputeInstancesGetShieldedVmIdentityRequest',
        response_type_name=u'ShieldedVmIdentity',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance resource in the specified project using the data included in the request.

      Args:
        request: (ComputeInstancesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId', u'sourceInstanceTemplate'],
        relative_path=u'projects/{project}/zones/{zone}/instances',
        request_field=u'instance',
        request_type_name=u'ComputeInstancesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of instances contained within the specified zone.

      Args:
        request: (ComputeInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/instances',
        request_field='',
        request_type_name=u'ComputeInstancesListRequest',
        response_type_name=u'InstanceList',
        supports_download=False,
    )

    def ListReferrers(self, request, global_params=None):
      r"""Retrieves the list of referrers to instances contained within the specified zone. For more information, read Viewing Referrers to VM Instances.

      Args:
        request: (ComputeInstancesListReferrersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceListReferrers) The response message.
      """
      config = self.GetMethodConfig('ListReferrers')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListReferrers.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.instances.listReferrers',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/referrers',
        request_field='',
        request_type_name=u'ComputeInstancesListReferrersRequest',
        response_type_name=u'InstanceListReferrers',
        supports_download=False,
    )

    def Reset(self, request, global_params=None):
      r"""Performs a reset on the instance. This is a hard reset the VM does not do a graceful shutdown. For more information, see Resetting an instance.

      Args:
        request: (ComputeInstancesResetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Reset')
      return self._RunMethod(
          config, request, global_params=global_params)

    Reset.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.reset',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/reset',
        request_field='',
        request_type_name=u'ComputeInstancesResetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Resume(self, request, global_params=None):
      r"""Resumes an instance that was suspended using the instances().suspend method.

      Args:
        request: (ComputeInstancesResumeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resume')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resume.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.resume',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/resume',
        request_field=u'instancesResumeRequest',
        request_type_name=u'ComputeInstancesResumeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetDeletionProtection(self, request, global_params=None):
      r"""Sets deletion protection on the instance.

      Args:
        request: (ComputeInstancesSetDeletionProtectionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDeletionProtection')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDeletionProtection.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setDeletionProtection',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[u'deletionProtection', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{resource}/setDeletionProtection',
        request_field='',
        request_type_name=u'ComputeInstancesSetDeletionProtectionRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetDiskAutoDelete(self, request, global_params=None):
      r"""Sets the auto-delete flag for a disk attached to an instance.

      Args:
        request: (ComputeInstancesSetDiskAutoDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDiskAutoDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDiskAutoDelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setDiskAutoDelete',
        ordered_params=[u'project', u'zone', u'instance', u'autoDelete', u'deviceName'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'autoDelete', u'deviceName', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setDiskAutoDelete',
        request_field='',
        request_type_name=u'ComputeInstancesSetDiskAutoDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstancesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instances/{resource}/setIamPolicy',
        request_field=u'zoneSetPolicyRequest',
        request_type_name=u'ComputeInstancesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInstancesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setLabels',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setLabels',
        request_field=u'instancesSetLabelsRequest',
        request_type_name=u'ComputeInstancesSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMachineResources(self, request, global_params=None):
      r"""Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.

      Args:
        request: (ComputeInstancesSetMachineResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMachineResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMachineResources.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setMachineResources',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setMachineResources',
        request_field=u'instancesSetMachineResourcesRequest',
        request_type_name=u'ComputeInstancesSetMachineResourcesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMachineType(self, request, global_params=None):
      r"""Changes the machine type for a stopped instance to the machine type specified in the request.

      Args:
        request: (ComputeInstancesSetMachineTypeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMachineType')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMachineType.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setMachineType',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setMachineType',
        request_field=u'instancesSetMachineTypeRequest',
        request_type_name=u'ComputeInstancesSetMachineTypeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMetadata(self, request, global_params=None):
      r"""Sets metadata for the specified instance to the data included in the request.

      Args:
        request: (ComputeInstancesSetMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setMetadata',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setMetadata',
        request_field=u'metadata',
        request_type_name=u'ComputeInstancesSetMetadataRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetMinCpuPlatform(self, request, global_params=None):
      r"""Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.

      Args:
        request: (ComputeInstancesSetMinCpuPlatformRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMinCpuPlatform')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMinCpuPlatform.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setMinCpuPlatform',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setMinCpuPlatform',
        request_field=u'instancesSetMinCpuPlatformRequest',
        request_type_name=u'ComputeInstancesSetMinCpuPlatformRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetScheduling(self, request, global_params=None):
      r"""Sets an instance's scheduling options.

      Args:
        request: (ComputeInstancesSetSchedulingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetScheduling')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetScheduling.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setScheduling',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setScheduling',
        request_field=u'scheduling',
        request_type_name=u'ComputeInstancesSetSchedulingRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetServiceAccount(self, request, global_params=None):
      r"""Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.

      Args:
        request: (ComputeInstancesSetServiceAccountRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetServiceAccount')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetServiceAccount.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setServiceAccount',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setServiceAccount',
        request_field=u'instancesSetServiceAccountRequest',
        request_type_name=u'ComputeInstancesSetServiceAccountRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetShieldedInstanceIntegrityPolicy(self, request, global_params=None):
      r"""Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetShieldedInstanceIntegrityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetShieldedInstanceIntegrityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.instances.setShieldedInstanceIntegrityPolicy',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setShieldedInstanceIntegrityPolicy',
        request_field=u'shieldedInstanceIntegrityPolicy',
        request_type_name=u'ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetShieldedVmIntegrityPolicy(self, request, global_params=None):
      r"""Sets the Shielded VM integrity policy for a VM instance. You can only use this method on a running VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesSetShieldedVmIntegrityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetShieldedVmIntegrityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetShieldedVmIntegrityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.instances.setShieldedVmIntegrityPolicy',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setShieldedVmIntegrityPolicy',
        request_field=u'shieldedVmIntegrityPolicy',
        request_type_name=u'ComputeInstancesSetShieldedVmIntegrityPolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetTags(self, request, global_params=None):
      r"""Sets network tags for the specified instance to the data included in the request.

      Args:
        request: (ComputeInstancesSetTagsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTags')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTags.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.setTags',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/setTags',
        request_field=u'tags',
        request_type_name=u'ComputeInstancesSetTagsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SimulateMaintenanceEvent(self, request, global_params=None):
      r"""Simulates a maintenance event on the instance.

      Args:
        request: (ComputeInstancesSimulateMaintenanceEventRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SimulateMaintenanceEvent')
      return self._RunMethod(
          config, request, global_params=global_params)

    SimulateMaintenanceEvent.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.simulateMaintenanceEvent',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/simulateMaintenanceEvent',
        request_field='',
        request_type_name=u'ComputeInstancesSimulateMaintenanceEventRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Start(self, request, global_params=None):
      r"""Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.

      Args:
        request: (ComputeInstancesStartRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Start')
      return self._RunMethod(
          config, request, global_params=global_params)

    Start.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.start',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/start',
        request_field='',
        request_type_name=u'ComputeInstancesStartRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def StartWithEncryptionKey(self, request, global_params=None):
      r"""Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.

      Args:
        request: (ComputeInstancesStartWithEncryptionKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartWithEncryptionKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartWithEncryptionKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.startWithEncryptionKey',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/startWithEncryptionKey',
        request_field=u'instancesStartWithEncryptionKeyRequest',
        request_type_name=u'ComputeInstancesStartWithEncryptionKeyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Stop(self, request, global_params=None):
      r"""Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.

      Args:
        request: (ComputeInstancesStopRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Stop')
      return self._RunMethod(
          config, request, global_params=global_params)

    Stop.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.stop',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/stop',
        request_field='',
        request_type_name=u'ComputeInstancesStopRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Suspend(self, request, global_params=None):
      r"""This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances incur reduced per-minute, virtual machine usage charges while they are suspended. Any resources the virtual machine is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted.

      Args:
        request: (ComputeInstancesSuspendRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Suspend')
      return self._RunMethod(
          config, request, global_params=global_params)

    Suspend.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.suspend',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'discardLocalSsd', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/suspend',
        request_field='',
        request_type_name=u'ComputeInstancesSuspendRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/instances/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeInstancesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def UpdateAccessConfig(self, request, global_params=None):
      r"""Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.instances.updateAccessConfig',
        ordered_params=[u'project', u'zone', u'instance', u'networkInterface'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'networkInterface', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/updateAccessConfig',
        request_field=u'accessConfig',
        request_type_name=u'ComputeInstancesUpdateAccessConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def UpdateDisplayDevice(self, request, global_params=None):
      r"""Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateDisplayDeviceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateDisplayDevice')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDisplayDevice.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.instances.updateDisplayDevice',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/updateDisplayDevice',
        request_field=u'displayDevice',
        request_type_name=u'ComputeInstancesUpdateDisplayDeviceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def UpdateNetworkInterface(self, request, global_params=None):
      r"""Updates an instance's network interface. This method follows PATCH semantics.

      Args:
        request: (ComputeInstancesUpdateNetworkInterfaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateNetworkInterface')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateNetworkInterface.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.instances.updateNetworkInterface',
        ordered_params=[u'project', u'zone', u'instance', u'networkInterface'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'networkInterface', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/updateNetworkInterface',
        request_field=u'networkInterfaceResource',
        request_type_name=u'ComputeInstancesUpdateNetworkInterfaceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def UpdateShieldedInstanceConfig(self, request, global_params=None):
      r"""Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateShieldedInstanceConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateShieldedInstanceConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateShieldedInstanceConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.instances.updateShieldedInstanceConfig',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/updateShieldedInstanceConfig',
        request_field=u'shieldedInstanceConfig',
        request_type_name=u'ComputeInstancesUpdateShieldedInstanceConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def UpdateShieldedVmConfig(self, request, global_params=None):
      r"""Updates the Shielded VM config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateShieldedVmConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateShieldedVmConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateShieldedVmConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.instances.updateShieldedVmConfig',
        ordered_params=[u'project', u'zone', u'instance'],
        path_params=[u'instance', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/instances/{instance}/updateShieldedVmConfig',
        request_field=u'shieldedVmConfig',
        request_type_name=u'ComputeInstancesUpdateShieldedVmConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class InterconnectAttachmentsService(base_api.BaseApiService):
    """Service class for the interconnectAttachments resource."""

    _NAME = u'interconnectAttachments'

    def __init__(self, client):
      super(ComputeBeta.InterconnectAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of interconnect attachments.

      Args:
        request: (ComputeInterconnectAttachmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnectAttachments.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/interconnectAttachments',
        request_field='',
        request_type_name=u'ComputeInterconnectAttachmentsAggregatedListRequest',
        response_type_name=u'InterconnectAttachmentAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified interconnect attachment.

      Args:
        request: (ComputeInterconnectAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.interconnectAttachments.delete',
        ordered_params=[u'project', u'region', u'interconnectAttachment'],
        path_params=[u'interconnectAttachment', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='',
        request_type_name=u'ComputeInterconnectAttachmentsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified interconnect attachment.

      Args:
        request: (ComputeInterconnectAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnectAttachments.get',
        ordered_params=[u'project', u'region', u'interconnectAttachment'],
        path_params=[u'interconnectAttachment', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='',
        request_type_name=u'ComputeInterconnectAttachmentsGetRequest',
        response_type_name=u'InterconnectAttachment',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an InterconnectAttachment in the specified project using the data included in the request.

      Args:
        request: (ComputeInterconnectAttachmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.interconnectAttachments.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/interconnectAttachments',
        request_field=u'interconnectAttachment',
        request_type_name=u'ComputeInterconnectAttachmentsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect attachments contained within the specified region.

      Args:
        request: (ComputeInterconnectAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnectAttachments.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/interconnectAttachments',
        request_field='',
        request_type_name=u'ComputeInterconnectAttachmentsListRequest',
        response_type_name=u'InterconnectAttachmentList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified interconnect attachment with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectAttachmentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.interconnectAttachments.patch',
        ordered_params=[u'project', u'region', u'interconnectAttachment'],
        path_params=[u'interconnectAttachment', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field=u'interconnectAttachmentResource',
        request_type_name=u'ComputeInterconnectAttachmentsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an InterconnectAttachment. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInterconnectAttachmentsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.interconnectAttachments.setLabels',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/interconnectAttachments/{resource}/setLabels',
        request_field=u'regionSetLabelsRequest',
        request_type_name=u'ComputeInterconnectAttachmentsSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectAttachmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.interconnectAttachments.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/interconnectAttachments/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeInterconnectAttachmentsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class InterconnectLocationsService(base_api.BaseApiService):
    """Service class for the interconnectLocations resource."""

    _NAME = u'interconnectLocations'

    def __init__(self, client):
      super(ComputeBeta.InterconnectLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the details for the specified interconnect location. Gets a list of available interconnect locations by making a list() request.

      Args:
        request: (ComputeInterconnectLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectLocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnectLocations.get',
        ordered_params=[u'project', u'interconnectLocation'],
        path_params=[u'interconnectLocation', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/interconnectLocations/{interconnectLocation}',
        request_field='',
        request_type_name=u'ComputeInterconnectLocationsGetRequest',
        response_type_name=u'InterconnectLocation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect locations available to the specified project.

      Args:
        request: (ComputeInterconnectLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectLocationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnectLocations.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/interconnectLocations',
        request_field='',
        request_type_name=u'ComputeInterconnectLocationsListRequest',
        response_type_name=u'InterconnectLocationList',
        supports_download=False,
    )

  class InterconnectsService(base_api.BaseApiService):
    """Service class for the interconnects resource."""

    _NAME = u'interconnects'

    def __init__(self, client):
      super(ComputeBeta.InterconnectsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified interconnect.

      Args:
        request: (ComputeInterconnectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.interconnects.delete',
        ordered_params=[u'project', u'interconnect'],
        path_params=[u'interconnect', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/interconnects/{interconnect}',
        request_field='',
        request_type_name=u'ComputeInterconnectsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified interconnect. Get a list of available interconnects by making a list() request.

      Args:
        request: (ComputeInterconnectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Interconnect) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnects.get',
        ordered_params=[u'project', u'interconnect'],
        path_params=[u'interconnect', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/interconnects/{interconnect}',
        request_field='',
        request_type_name=u'ComputeInterconnectsGetRequest',
        response_type_name=u'Interconnect',
        supports_download=False,
    )

    def GetDiagnostics(self, request, global_params=None):
      r"""Returns the interconnectDiagnostics for the specified interconnect.

      Args:
        request: (ComputeInterconnectsGetDiagnosticsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectsGetDiagnosticsResponse) The response message.
      """
      config = self.GetMethodConfig('GetDiagnostics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDiagnostics.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnects.getDiagnostics',
        ordered_params=[u'project', u'interconnect'],
        path_params=[u'interconnect', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/interconnects/{interconnect}/getDiagnostics',
        request_field='',
        request_type_name=u'ComputeInterconnectsGetDiagnosticsRequest',
        response_type_name=u'InterconnectsGetDiagnosticsResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a Interconnect in the specified project using the data included in the request.

      Args:
        request: (ComputeInterconnectsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.interconnects.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/interconnects',
        request_field=u'interconnect',
        request_type_name=u'ComputeInterconnectsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect available to the specified project.

      Args:
        request: (ComputeInterconnectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.interconnects.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/interconnects',
        request_field='',
        request_type_name=u'ComputeInterconnectsListRequest',
        response_type_name=u'InterconnectList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified interconnect with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.interconnects.patch',
        ordered_params=[u'project', u'interconnect'],
        path_params=[u'interconnect', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/interconnects/{interconnect}',
        request_field=u'interconnectResource',
        request_type_name=u'ComputeInterconnectsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an Interconnect. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInterconnectsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.interconnects.setLabels',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/interconnects/{resource}/setLabels',
        request_field=u'globalSetLabelsRequest',
        request_type_name=u'ComputeInterconnectsSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.interconnects.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/interconnects/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeInterconnectsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class LicenseCodesService(base_api.BaseApiService):
    """Service class for the licenseCodes resource."""

    _NAME = u'licenseCodes'

    def __init__(self, client):
      super(ComputeBeta.LicenseCodesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Return a specified license code. License codes are mirrored across all projects that have permissions to read the License Code.

      Args:
        request: (ComputeLicenseCodesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LicenseCode) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.licenseCodes.get',
        ordered_params=[u'project', u'licenseCode'],
        path_params=[u'licenseCode', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/licenseCodes/{licenseCode}',
        request_field='',
        request_type_name=u'ComputeLicenseCodesGetRequest',
        response_type_name=u'LicenseCode',
        supports_download=False,
    )

  class LicensesService(base_api.BaseApiService):
    """Service class for the licenses resource."""

    _NAME = u'licenses'

    def __init__(self, client):
      super(ComputeBeta.LicensesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified license.

      Args:
        request: (ComputeLicensesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.licenses.delete',
        ordered_params=[u'project', u'license'],
        path_params=[u'license', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/licenses/{license}',
        request_field='',
        request_type_name=u'ComputeLicensesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified License resource.

      Args:
        request: (ComputeLicensesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (License) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.licenses.get',
        ordered_params=[u'project', u'license'],
        path_params=[u'license', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/licenses/{license}',
        request_field='',
        request_type_name=u'ComputeLicensesGetRequest',
        response_type_name=u'License',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeLicensesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.licenses.getIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/licenses/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeLicensesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a License resource in the specified project.

      Args:
        request: (ComputeLicensesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.licenses.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/licenses',
        request_field=u'license',
        request_type_name=u'ComputeLicensesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of licenses available in the specified project. This method does not get any licenses that belong to other projects, including licenses attached to publicly-available images, like Debian 9. If you want to get a list of publicly-available licenses, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud.

      Args:
        request: (ComputeLicensesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LicensesListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.licenses.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/licenses',
        request_field='',
        request_type_name=u'ComputeLicensesListRequest',
        response_type_name=u'LicensesListResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeLicensesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.licenses.setIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/licenses/{resource}/setIamPolicy',
        request_field=u'globalSetPolicyRequest',
        request_type_name=u'ComputeLicensesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

  class MachineTypesService(base_api.BaseApiService):
    """Service class for the machineTypes resource."""

    _NAME = u'machineTypes'

    def __init__(self, client):
      super(ComputeBeta.MachineTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of machine types.

      Args:
        request: (ComputeMachineTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.machineTypes.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/machineTypes',
        request_field='',
        request_type_name=u'ComputeMachineTypesAggregatedListRequest',
        response_type_name=u'MachineTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified machine type. Gets a list of available machine types by making a list() request.

      Args:
        request: (ComputeMachineTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.machineTypes.get',
        ordered_params=[u'project', u'zone', u'machineType'],
        path_params=[u'machineType', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/machineTypes/{machineType}',
        request_field='',
        request_type_name=u'ComputeMachineTypesGetRequest',
        response_type_name=u'MachineType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of machine types available to the specified project.

      Args:
        request: (ComputeMachineTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.machineTypes.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/machineTypes',
        request_field='',
        request_type_name=u'ComputeMachineTypesListRequest',
        response_type_name=u'MachineTypeList',
        supports_download=False,
    )

  class NetworkEndpointGroupsService(base_api.BaseApiService):
    """Service class for the networkEndpointGroups resource."""

    _NAME = u'networkEndpointGroups'

    def __init__(self, client):
      super(ComputeBeta.NetworkEndpointGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups and sorts them by zone.

      Args:
        request: (ComputeNetworkEndpointGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.networkEndpointGroups.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/networkEndpointGroups',
        request_field='',
        request_type_name=u'ComputeNetworkEndpointGroupsAggregatedListRequest',
        response_type_name=u'NetworkEndpointGroupAggregatedList',
        supports_download=False,
    )

    def AttachNetworkEndpoints(self, request, global_params=None):
      r"""Attach a list of network endpoints to the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networkEndpointGroups.attachNetworkEndpoints',
        ordered_params=[u'project', u'zone', u'networkEndpointGroup'],
        path_params=[u'networkEndpointGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints',
        request_field=u'networkEndpointGroupsAttachEndpointsRequest',
        request_type_name=u'ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network endpoint group. The network endpoints in the NEG and the VM instances they belong to are not terminated when the NEG is deleted. Note that the NEG cannot be deleted if there are backend services referencing it.

      Args:
        request: (ComputeNetworkEndpointGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.networkEndpointGroups.delete',
        ordered_params=[u'project', u'zone', u'networkEndpointGroup'],
        path_params=[u'networkEndpointGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name=u'ComputeNetworkEndpointGroupsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DetachNetworkEndpoints(self, request, global_params=None):
      r"""Detach a list of network endpoints from the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networkEndpointGroups.detachNetworkEndpoints',
        ordered_params=[u'project', u'zone', u'networkEndpointGroup'],
        path_params=[u'networkEndpointGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints',
        request_field=u'networkEndpointGroupsDetachEndpointsRequest',
        request_type_name=u'ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network endpoint group. Gets a list of available network endpoint groups by making a list() request.

      Args:
        request: (ComputeNetworkEndpointGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.networkEndpointGroups.get',
        ordered_params=[u'project', u'zone', u'networkEndpointGroup'],
        path_params=[u'networkEndpointGroup', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name=u'ComputeNetworkEndpointGroupsGetRequest',
        response_type_name=u'NetworkEndpointGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network endpoint group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeNetworkEndpointGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networkEndpointGroups.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups',
        request_field=u'networkEndpointGroup',
        request_type_name=u'ComputeNetworkEndpointGroupsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups that are located in the specified project and zone.

      Args:
        request: (ComputeNetworkEndpointGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.networkEndpointGroups.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups',
        request_field='',
        request_type_name=u'ComputeNetworkEndpointGroupsListRequest',
        response_type_name=u'NetworkEndpointGroupList',
        supports_download=False,
    )

    def ListNetworkEndpoints(self, request, global_params=None):
      r"""Lists the network endpoints in the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsListNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupsListNetworkEndpoints) The response message.
      """
      config = self.GetMethodConfig('ListNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networkEndpointGroups.listNetworkEndpoints',
        ordered_params=[u'project', u'zone', u'networkEndpointGroup'],
        path_params=[u'networkEndpointGroup', u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints',
        request_field=u'networkEndpointGroupsListEndpointsRequest',
        request_type_name=u'ComputeNetworkEndpointGroupsListNetworkEndpointsRequest',
        response_type_name=u'NetworkEndpointGroupsListNetworkEndpoints',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworkEndpointGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networkEndpointGroups.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/networkEndpointGroups/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeNetworkEndpointGroupsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class NetworksService(base_api.BaseApiService):
    """Service class for the networks resource."""

    _NAME = u'networks'

    def __init__(self, client):
      super(ComputeBeta.NetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddPeering(self, request, global_params=None):
      r"""Adds a peering to the specified network.

      Args:
        request: (ComputeNetworksAddPeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddPeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddPeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networks.addPeering',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/networks/{network}/addPeering',
        request_field=u'networksAddPeeringRequest',
        request_type_name=u'ComputeNetworksAddPeeringRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network.

      Args:
        request: (ComputeNetworksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.networks.delete',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/networks/{network}',
        request_field='',
        request_type_name=u'ComputeNetworksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network. Gets a list of available networks by making a list() request.

      Args:
        request: (ComputeNetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Network) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.networks.get',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/global/networks/{network}',
        request_field='',
        request_type_name=u'ComputeNetworksGetRequest',
        response_type_name=u'Network',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network in the specified project using the data included in the request.

      Args:
        request: (ComputeNetworksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networks.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/networks',
        request_field=u'network',
        request_type_name=u'ComputeNetworksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of networks available to the specified project.

      Args:
        request: (ComputeNetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.networks.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/networks',
        request_field='',
        request_type_name=u'ComputeNetworksListRequest',
        response_type_name=u'NetworkList',
        supports_download=False,
    )

    def ListPeeringRoutes(self, request, global_params=None):
      r"""Lists the peering routes exchanged over peering connection.

      Args:
        request: (ComputeNetworksListPeeringRoutesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExchangedPeeringRoutesList) The response message.
      """
      config = self.GetMethodConfig('ListPeeringRoutes')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPeeringRoutes.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.networks.listPeeringRoutes',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[u'direction', u'filter', u'maxResults', u'orderBy', u'pageToken', u'peeringName', u'region'],
        relative_path=u'projects/{project}/global/networks/{network}/listPeeringRoutes',
        request_field='',
        request_type_name=u'ComputeNetworksListPeeringRoutesRequest',
        response_type_name=u'ExchangedPeeringRoutesList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified network with the data included in the request. Only the following fields can be modified: routingConfig.routingMode.

      Args:
        request: (ComputeNetworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.networks.patch',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/networks/{network}',
        request_field=u'networkResource',
        request_type_name=u'ComputeNetworksPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RemovePeering(self, request, global_params=None):
      r"""Removes a peering from the specified network.

      Args:
        request: (ComputeNetworksRemovePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemovePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemovePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networks.removePeering',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/networks/{network}/removePeering',
        request_field=u'networksRemovePeeringRequest',
        request_type_name=u'ComputeNetworksRemovePeeringRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SwitchToCustomMode(self, request, global_params=None):
      r"""Switches the network mode from auto subnet mode to custom subnet mode.

      Args:
        request: (ComputeNetworksSwitchToCustomModeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SwitchToCustomMode')
      return self._RunMethod(
          config, request, global_params=global_params)

    SwitchToCustomMode.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networks.switchToCustomMode',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/networks/{network}/switchToCustomMode',
        request_field='',
        request_type_name=u'ComputeNetworksSwitchToCustomModeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.networks.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/networks/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeNetworksTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def UpdatePeering(self, request, global_params=None):
      r"""Updates the specified network peering with the data included in the request Only the following fields can be modified: NetworkPeering.export_custom_routes, and NetworkPeering.import_custom_routes.

      Args:
        request: (ComputeNetworksUpdatePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdatePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdatePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.networks.updatePeering',
        ordered_params=[u'project', u'network'],
        path_params=[u'network', u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/networks/{network}/updatePeering',
        request_field=u'networksUpdatePeeringRequest',
        request_type_name=u'ComputeNetworksUpdatePeeringRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class NodeGroupsService(base_api.BaseApiService):
    """Service class for the nodeGroups resource."""

    _NAME = u'nodeGroups'

    def __init__(self, client):
      super(ComputeBeta.NodeGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddNodes(self, request, global_params=None):
      r"""Adds specified number of nodes to the node group.

      Args:
        request: (ComputeNodeGroupsAddNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeGroups.addNodes',
        ordered_params=[u'project', u'zone', u'nodeGroup'],
        path_params=[u'nodeGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/addNodes',
        request_field=u'nodeGroupsAddNodesRequest',
        request_type_name=u'ComputeNodeGroupsAddNodesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node groups. Note: use nodeGroups.listNodes for more details about each group.

      Args:
        request: (ComputeNodeGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeGroups.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/nodeGroups',
        request_field='',
        request_type_name=u'ComputeNodeGroupsAggregatedListRequest',
        response_type_name=u'NodeGroupAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NodeGroup resource.

      Args:
        request: (ComputeNodeGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.nodeGroups.delete',
        ordered_params=[u'project', u'zone', u'nodeGroup'],
        path_params=[u'nodeGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='',
        request_type_name=u'ComputeNodeGroupsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DeleteNodes(self, request, global_params=None):
      r"""Deletes specified nodes from the node group.

      Args:
        request: (ComputeNodeGroupsDeleteNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeGroups.deleteNodes',
        ordered_params=[u'project', u'zone', u'nodeGroup'],
        path_params=[u'nodeGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/deleteNodes',
        request_field=u'nodeGroupsDeleteNodesRequest',
        request_type_name=u'ComputeNodeGroupsDeleteNodesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified NodeGroup. Get a list of available NodeGroups by making a list() request. Note: the "nodes" field should not be used. Use nodeGroups.listNodes instead.

      Args:
        request: (ComputeNodeGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeGroups.get',
        ordered_params=[u'project', u'zone', u'nodeGroup'],
        path_params=[u'nodeGroup', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='',
        request_type_name=u'ComputeNodeGroupsGetRequest',
        response_type_name=u'NodeGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNodeGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeGroups.getIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeNodeGroupsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a NodeGroup resource in the specified project using the data included in the request.

      Args:
        request: (ComputeNodeGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeGroups.insert',
        ordered_params=[u'project', u'zone', u'initialNodeCount'],
        path_params=[u'project', u'zone'],
        query_params=[u'initialNodeCount', u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups',
        request_field=u'nodeGroup',
        request_type_name=u'ComputeNodeGroupsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node groups available to the specified project. Note: use nodeGroups.listNodes for more details about each group.

      Args:
        request: (ComputeNodeGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeGroups.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups',
        request_field='',
        request_type_name=u'ComputeNodeGroupsListRequest',
        response_type_name=u'NodeGroupList',
        supports_download=False,
    )

    def ListNodes(self, request, global_params=None):
      r"""Lists nodes in the node group.

      Args:
        request: (ComputeNodeGroupsListNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupsListNodes) The response message.
      """
      config = self.GetMethodConfig('ListNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeGroups.listNodes',
        ordered_params=[u'project', u'zone', u'nodeGroup'],
        path_params=[u'nodeGroup', u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/listNodes',
        request_field='',
        request_type_name=u'ComputeNodeGroupsListNodesRequest',
        response_type_name=u'NodeGroupsListNodes',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNodeGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeGroups.setIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy',
        request_field=u'zoneSetPolicyRequest',
        request_type_name=u'ComputeNodeGroupsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetNodeTemplate(self, request, global_params=None):
      r"""Updates the node template of the node group.

      Args:
        request: (ComputeNodeGroupsSetNodeTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNodeTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNodeTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeGroups.setNodeTemplate',
        ordered_params=[u'project', u'zone', u'nodeGroup'],
        path_params=[u'nodeGroup', u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/setNodeTemplate',
        request_field=u'nodeGroupsSetNodeTemplateRequest',
        request_type_name=u'ComputeNodeGroupsSetNodeTemplateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNodeGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeGroups.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/nodeGroups/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeNodeGroupsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class NodeTemplatesService(base_api.BaseApiService):
    """Service class for the nodeTemplates resource."""

    _NAME = u'nodeTemplates'

    def __init__(self, client):
      super(ComputeBeta.NodeTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node templates.

      Args:
        request: (ComputeNodeTemplatesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplateAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeTemplates.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/nodeTemplates',
        request_field='',
        request_type_name=u'ComputeNodeTemplatesAggregatedListRequest',
        response_type_name=u'NodeTemplateAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NodeTemplate resource.

      Args:
        request: (ComputeNodeTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.nodeTemplates.delete',
        ordered_params=[u'project', u'region', u'nodeTemplate'],
        path_params=[u'nodeTemplate', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}',
        request_field='',
        request_type_name=u'ComputeNodeTemplatesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified node template. Gets a list of available node templates by making a list() request.

      Args:
        request: (ComputeNodeTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeTemplates.get',
        ordered_params=[u'project', u'region', u'nodeTemplate'],
        path_params=[u'nodeTemplate', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}',
        request_field='',
        request_type_name=u'ComputeNodeTemplatesGetRequest',
        response_type_name=u'NodeTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNodeTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeTemplates.getIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeNodeTemplatesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a NodeTemplate resource in the specified project using the data included in the request.

      Args:
        request: (ComputeNodeTemplatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeTemplates.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/nodeTemplates',
        request_field=u'nodeTemplate',
        request_type_name=u'ComputeNodeTemplatesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node templates available to the specified project.

      Args:
        request: (ComputeNodeTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeTemplates.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/nodeTemplates',
        request_field='',
        request_type_name=u'ComputeNodeTemplatesListRequest',
        response_type_name=u'NodeTemplateList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNodeTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeTemplates.setIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy',
        request_field=u'regionSetPolicyRequest',
        request_type_name=u'ComputeNodeTemplatesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNodeTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.nodeTemplates.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/nodeTemplates/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeNodeTemplatesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class NodeTypesService(base_api.BaseApiService):
    """Service class for the nodeTypes resource."""

    _NAME = u'nodeTypes'

    def __init__(self, client):
      super(ComputeBeta.NodeTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node types.

      Args:
        request: (ComputeNodeTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeTypes.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/nodeTypes',
        request_field='',
        request_type_name=u'ComputeNodeTypesAggregatedListRequest',
        response_type_name=u'NodeTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified node type. Gets a list of available node types by making a list() request.

      Args:
        request: (ComputeNodeTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeTypes.get',
        ordered_params=[u'project', u'zone', u'nodeType'],
        path_params=[u'nodeType', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/nodeTypes/{nodeType}',
        request_field='',
        request_type_name=u'ComputeNodeTypesGetRequest',
        response_type_name=u'NodeType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node types available to the specified project.

      Args:
        request: (ComputeNodeTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.nodeTypes.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/nodeTypes',
        request_field='',
        request_type_name=u'ComputeNodeTypesListRequest',
        response_type_name=u'NodeTypeList',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ComputeBeta.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def DisableXpnHost(self, request, global_params=None):
      r"""Disable this project as a shared VPC host project.

      Args:
        request: (ComputeProjectsDisableXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DisableXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    DisableXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.disableXpnHost',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/disableXpnHost',
        request_field='',
        request_type_name=u'ComputeProjectsDisableXpnHostRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DisableXpnResource(self, request, global_params=None):
      r"""Disable a service resource (also known as service project) associated with this host project.

      Args:
        request: (ComputeProjectsDisableXpnResourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DisableXpnResource')
      return self._RunMethod(
          config, request, global_params=global_params)

    DisableXpnResource.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.disableXpnResource',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/disableXpnResource',
        request_field=u'projectsDisableXpnResourceRequest',
        request_type_name=u'ComputeProjectsDisableXpnResourceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def EnableXpnHost(self, request, global_params=None):
      r"""Enable this project as a shared VPC host project.

      Args:
        request: (ComputeProjectsEnableXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('EnableXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnableXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.enableXpnHost',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/enableXpnHost',
        request_field='',
        request_type_name=u'ComputeProjectsEnableXpnHostRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def EnableXpnResource(self, request, global_params=None):
      r"""Enable service resource (a.k.a service project) for a host project, so that subnets in the host project can be used by instances in the service project.

      Args:
        request: (ComputeProjectsEnableXpnResourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('EnableXpnResource')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnableXpnResource.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.enableXpnResource',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/enableXpnResource',
        request_field=u'projectsEnableXpnResourceRequest',
        request_type_name=u'ComputeProjectsEnableXpnResourceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Project resource.

      Args:
        request: (ComputeProjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.projects.get',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[],
        relative_path=u'projects/{project}',
        request_field='',
        request_type_name=u'ComputeProjectsGetRequest',
        response_type_name=u'Project',
        supports_download=False,
    )

    def GetXpnHost(self, request, global_params=None):
      r"""Gets the shared VPC host project that this project links to. May be empty if no link exists.

      Args:
        request: (ComputeProjectsGetXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('GetXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.projects.getXpnHost',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[],
        relative_path=u'projects/{project}/getXpnHost',
        request_field='',
        request_type_name=u'ComputeProjectsGetXpnHostRequest',
        response_type_name=u'Project',
        supports_download=False,
    )

    def GetXpnResources(self, request, global_params=None):
      r"""Gets service resources (a.k.a service project) associated with this host project.

      Args:
        request: (ComputeProjectsGetXpnResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ProjectsGetXpnResources) The response message.
      """
      config = self.GetMethodConfig('GetXpnResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetXpnResources.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.projects.getXpnResources',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'order_by', u'pageToken'],
        relative_path=u'projects/{project}/getXpnResources',
        request_field='',
        request_type_name=u'ComputeProjectsGetXpnResourcesRequest',
        response_type_name=u'ProjectsGetXpnResources',
        supports_download=False,
    )

    def ListXpnHosts(self, request, global_params=None):
      r"""Lists all shared VPC host projects visible to the user in an organization.

      Args:
        request: (ComputeProjectsListXpnHostsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (XpnHostList) The response message.
      """
      config = self.GetMethodConfig('ListXpnHosts')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListXpnHosts.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.listXpnHosts',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'order_by', u'pageToken'],
        relative_path=u'projects/{project}/listXpnHosts',
        request_field=u'projectsListXpnHostsRequest',
        request_type_name=u'ComputeProjectsListXpnHostsRequest',
        response_type_name=u'XpnHostList',
        supports_download=False,
    )

    def MoveDisk(self, request, global_params=None):
      r"""Moves a persistent disk from one zone to another.

      Args:
        request: (ComputeProjectsMoveDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('MoveDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.moveDisk',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/moveDisk',
        request_field=u'diskMoveRequest',
        request_type_name=u'ComputeProjectsMoveDiskRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def MoveInstance(self, request, global_params=None):
      r"""Moves an instance and its attached persistent disks from one zone to another.

      Args:
        request: (ComputeProjectsMoveInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('MoveInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.moveInstance',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/moveInstance',
        request_field=u'instanceMoveRequest',
        request_type_name=u'ComputeProjectsMoveInstanceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetCommonInstanceMetadata(self, request, global_params=None):
      r"""Sets metadata common to all instances within the specified project using the data included in the request.

      Args:
        request: (ComputeProjectsSetCommonInstanceMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetCommonInstanceMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetCommonInstanceMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.setCommonInstanceMetadata',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/setCommonInstanceMetadata',
        request_field=u'metadata',
        request_type_name=u'ComputeProjectsSetCommonInstanceMetadataRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetDefaultNetworkTier(self, request, global_params=None):
      r"""Sets the default network tier of the project. The default network tier is used when an address/forwardingRule/instance is created without specifying the network tier field.

      Args:
        request: (ComputeProjectsSetDefaultNetworkTierRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDefaultNetworkTier')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDefaultNetworkTier.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.setDefaultNetworkTier',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/setDefaultNetworkTier',
        request_field=u'projectsSetDefaultNetworkTierRequest',
        request_type_name=u'ComputeProjectsSetDefaultNetworkTierRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetUsageExportBucket(self, request, global_params=None):
      r"""Enables the usage export feature and sets the usage export bucket where reports are stored. If you provide an empty request body using this method, the usage export feature will be disabled.

      Args:
        request: (ComputeProjectsSetUsageExportBucketRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUsageExportBucket')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUsageExportBucket.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.projects.setUsageExportBucket',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/setUsageExportBucket',
        request_field=u'usageExportLocation',
        request_type_name=u'ComputeProjectsSetUsageExportBucketRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionAutoscalersService(base_api.BaseApiService):
    """Service class for the regionAutoscalers resource."""

    _NAME = u'regionAutoscalers'

    def __init__(self, client):
      super(ComputeBeta.RegionAutoscalersService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified autoscaler.

      Args:
        request: (ComputeRegionAutoscalersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionAutoscalers.delete',
        ordered_params=[u'project', u'region', u'autoscaler'],
        path_params=[u'autoscaler', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name=u'ComputeRegionAutoscalersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified autoscaler.

      Args:
        request: (ComputeRegionAutoscalersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Autoscaler) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionAutoscalers.get',
        ordered_params=[u'project', u'region', u'autoscaler'],
        path_params=[u'autoscaler', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name=u'ComputeRegionAutoscalersGetRequest',
        response_type_name=u'Autoscaler',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionAutoscalersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionAutoscalers.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/autoscalers',
        request_field=u'autoscaler',
        request_type_name=u'ComputeRegionAutoscalersInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of autoscalers contained within the specified region.

      Args:
        request: (ComputeRegionAutoscalersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionAutoscalerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionAutoscalers.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/autoscalers',
        request_field='',
        request_type_name=u'ComputeRegionAutoscalersListRequest',
        response_type_name=u'RegionAutoscalerList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionAutoscalersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.regionAutoscalers.patch',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'autoscaler', u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/autoscalers',
        request_field=u'autoscalerResource',
        request_type_name=u'ComputeRegionAutoscalersPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionAutoscalersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionAutoscalers.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/autoscalers/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeRegionAutoscalersTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionAutoscalersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.regionAutoscalers.update',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'autoscaler', u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/autoscalers',
        request_field=u'autoscalerResource',
        request_type_name=u'ComputeRegionAutoscalersUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionBackendServicesService(base_api.BaseApiService):
    """Service class for the regionBackendServices resource."""

    _NAME = u'regionBackendServices'

    def __init__(self, client):
      super(ComputeBeta.RegionBackendServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional BackendService resource.

      Args:
        request: (ComputeRegionBackendServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionBackendServices.delete',
        ordered_params=[u'project', u'region', u'backendService'],
        path_params=[u'backendService', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='',
        request_type_name=u'ComputeRegionBackendServicesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified regional BackendService resource.

      Args:
        request: (ComputeRegionBackendServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionBackendServices.get',
        ordered_params=[u'project', u'region', u'backendService'],
        path_params=[u'backendService', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='',
        request_type_name=u'ComputeRegionBackendServicesGetRequest',
        response_type_name=u'BackendService',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for this regional BackendService.

      Args:
        request: (ComputeRegionBackendServicesGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceGroupHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionBackendServices.getHealth',
        ordered_params=[u'project', u'region', u'backendService'],
        path_params=[u'backendService', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/backendServices/{backendService}/getHealth',
        request_field=u'resourceGroupReference',
        request_type_name=u'ComputeRegionBackendServicesGetHealthRequest',
        response_type_name=u'BackendServiceGroupHealth',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a regional BackendService resource in the specified project using the data included in the request. There are several restrictions and guidelines to keep in mind when creating a regional backend service. Read  Restrictions and Guidelines for more information.

      Args:
        request: (ComputeRegionBackendServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionBackendServices.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/backendServices',
        request_field=u'backendService',
        request_type_name=u'ComputeRegionBackendServicesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of regional BackendService resources available to the specified project in the given region.

      Args:
        request: (ComputeRegionBackendServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionBackendServices.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/backendServices',
        request_field='',
        request_type_name=u'ComputeRegionBackendServicesListRequest',
        response_type_name=u'BackendServiceList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional BackendService resource with the data included in the request. There are several restrictions and guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for more information. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionBackendServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.regionBackendServices.patch',
        ordered_params=[u'project', u'region', u'backendService'],
        path_params=[u'backendService', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field=u'backendServiceResource',
        request_type_name=u'ComputeRegionBackendServicesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionBackendServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionBackendServices.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/backendServices/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeRegionBackendServicesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified regional BackendService resource with the data included in the request. There are several restrictions and guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for more information.

      Args:
        request: (ComputeRegionBackendServicesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.regionBackendServices.update',
        ordered_params=[u'project', u'region', u'backendService'],
        path_params=[u'backendService', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field=u'backendServiceResource',
        request_type_name=u'ComputeRegionBackendServicesUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionCommitmentsService(base_api.BaseApiService):
    """Service class for the regionCommitments resource."""

    _NAME = u'regionCommitments'

    def __init__(self, client):
      super(ComputeBeta.RegionCommitmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of commitments.

      Args:
        request: (ComputeRegionCommitmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionCommitments.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/commitments',
        request_field='',
        request_type_name=u'ComputeRegionCommitmentsAggregatedListRequest',
        response_type_name=u'CommitmentAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified commitment resource. Gets a list of available commitments by making a list() request.

      Args:
        request: (ComputeRegionCommitmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Commitment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionCommitments.get',
        ordered_params=[u'project', u'region', u'commitment'],
        path_params=[u'commitment', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/commitments/{commitment}',
        request_field='',
        request_type_name=u'ComputeRegionCommitmentsGetRequest',
        response_type_name=u'Commitment',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a commitment in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionCommitmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionCommitments.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/commitments',
        request_field=u'commitment',
        request_type_name=u'ComputeRegionCommitmentsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of commitments contained within the specified region.

      Args:
        request: (ComputeRegionCommitmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionCommitments.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/commitments',
        request_field='',
        request_type_name=u'ComputeRegionCommitmentsListRequest',
        response_type_name=u'CommitmentList',
        supports_download=False,
    )

    def UpdateReservations(self, request, global_params=None):
      r"""Update the shape of reservations for GPUS/Local SSDs of reservations within the commitments.

      Args:
        request: (ComputeRegionCommitmentsUpdateReservationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateReservations')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateReservations.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionCommitments.updateReservations',
        ordered_params=[u'project', u'region', u'commitment'],
        path_params=[u'commitment', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/commitments/{commitment}/updateReservations',
        request_field=u'regionCommitmentsUpdateReservationsRequest',
        request_type_name=u'ComputeRegionCommitmentsUpdateReservationsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionDiskTypesService(base_api.BaseApiService):
    """Service class for the regionDiskTypes resource."""

    _NAME = u'regionDiskTypes'

    def __init__(self, client):
      super(ComputeBeta.RegionDiskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified regional disk type. Gets a list of available disk types by making a list() request.

      Args:
        request: (ComputeRegionDiskTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionDiskTypes.get',
        ordered_params=[u'project', u'region', u'diskType'],
        path_params=[u'diskType', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/diskTypes/{diskType}',
        request_field='',
        request_type_name=u'ComputeRegionDiskTypesGetRequest',
        response_type_name=u'DiskType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of regional disk types available to the specified project.

      Args:
        request: (ComputeRegionDiskTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionDiskTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionDiskTypes.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/diskTypes',
        request_field='',
        request_type_name=u'ComputeRegionDiskTypesListRequest',
        response_type_name=u'RegionDiskTypeList',
        supports_download=False,
    )

  class RegionDisksService(base_api.BaseApiService):
    """Service class for the regionDisks resource."""

    _NAME = u'regionDisks'

    def __init__(self, client):
      super(ComputeBeta.RegionDisksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to a regional disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.

      Args:
        request: (ComputeRegionDisksAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.addResourcePolicies',
        ordered_params=[u'project', u'region', u'disk'],
        path_params=[u'disk', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/disks/{disk}/addResourcePolicies',
        request_field=u'regionDisksAddResourcePoliciesRequest',
        request_type_name=u'ComputeRegionDisksAddResourcePoliciesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def CreateSnapshot(self, request, global_params=None):
      r"""Creates a snapshot of this regional disk.

      Args:
        request: (ComputeRegionDisksCreateSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateSnapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateSnapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.createSnapshot',
        ordered_params=[u'project', u'region', u'disk'],
        path_params=[u'disk', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/disks/{disk}/createSnapshot',
        request_field=u'snapshot',
        request_type_name=u'ComputeRegionDisksCreateSnapshotRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional persistent disk. Deleting a regional disk removes all the replicas of its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.

      Args:
        request: (ComputeRegionDisksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionDisks.delete',
        ordered_params=[u'project', u'region', u'disk'],
        path_params=[u'disk', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/disks/{disk}',
        request_field='',
        request_type_name=u'ComputeRegionDisksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a specified regional persistent disk.

      Args:
        request: (ComputeRegionDisksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Disk) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionDisks.get',
        ordered_params=[u'project', u'region', u'disk'],
        path_params=[u'disk', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/disks/{disk}',
        request_field='',
        request_type_name=u'ComputeRegionDisksGetRequest',
        response_type_name=u'Disk',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionDisksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionDisks.getIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/disks/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeRegionDisksGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a persistent regional disk in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionDisksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId', u'sourceImage'],
        relative_path=u'projects/{project}/regions/{region}/disks',
        request_field=u'disk',
        request_type_name=u'ComputeRegionDisksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of persistent disks contained within the specified region.

      Args:
        request: (ComputeRegionDisksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionDisks.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/disks',
        request_field='',
        request_type_name=u'ComputeRegionDisksListRequest',
        response_type_name=u'DiskList',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from a regional disk.

      Args:
        request: (ComputeRegionDisksRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.removeResourcePolicies',
        ordered_params=[u'project', u'region', u'disk'],
        path_params=[u'disk', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/disks/{disk}/removeResourcePolicies',
        request_field=u'regionDisksRemoveResourcePoliciesRequest',
        request_type_name=u'ComputeRegionDisksRemoveResourcePoliciesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the specified regional persistent disk.

      Args:
        request: (ComputeRegionDisksResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.resize',
        ordered_params=[u'project', u'region', u'disk'],
        path_params=[u'disk', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/disks/{disk}/resize',
        request_field=u'regionDisksResizeRequest',
        request_type_name=u'ComputeRegionDisksResizeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionDisksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.setIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/disks/{resource}/setIamPolicy',
        request_field=u'regionSetPolicyRequest',
        request_type_name=u'ComputeRegionDisksSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the target regional disk.

      Args:
        request: (ComputeRegionDisksSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.setLabels',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/disks/{resource}/setLabels',
        request_field=u'regionSetLabelsRequest',
        request_type_name=u'ComputeRegionDisksSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionDisksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionDisks.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/disks/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeRegionDisksTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class RegionHealthChecksService(base_api.BaseApiService):
    """Service class for the regionHealthChecks resource."""

    _NAME = u'regionHealthChecks'

    def __init__(self, client):
      super(ComputeBeta.RegionHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthCheck resource.

      Args:
        request: (ComputeRegionHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionHealthChecks.delete',
        ordered_params=[u'project', u'region', u'healthCheck'],
        path_params=[u'healthCheck', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='',
        request_type_name=u'ComputeRegionHealthChecksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthCheck resource. Gets a list of available health checks by making a list() request.

      Args:
        request: (ComputeRegionHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionHealthChecks.get',
        ordered_params=[u'project', u'region', u'healthCheck'],
        path_params=[u'healthCheck', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='',
        request_type_name=u'ComputeRegionHealthChecksGetRequest',
        response_type_name=u'HealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionHealthChecks.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/healthChecks',
        request_field=u'healthCheck',
        request_type_name=u'ComputeRegionHealthChecksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HealthCheck resources available to the specified project.

      Args:
        request: (ComputeRegionHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionHealthChecks.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/healthChecks',
        request_field='',
        request_type_name=u'ComputeRegionHealthChecksListRequest',
        response_type_name=u'HealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.regionHealthChecks.patch',
        ordered_params=[u'project', u'region', u'healthCheck'],
        path_params=[u'healthCheck', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field=u'healthCheckResource',
        request_type_name=u'ComputeRegionHealthChecksPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.regionHealthChecks.update',
        ordered_params=[u'project', u'region', u'healthCheck'],
        path_params=[u'healthCheck', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field=u'healthCheckResource',
        request_type_name=u'ComputeRegionHealthChecksUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionInstanceGroupManagersService(base_api.BaseApiService):
    """Service class for the regionInstanceGroupManagers resource."""

    _NAME = u'regionInstanceGroupManagers'

    def __init__(self, client):
      super(ComputeBeta.RegionInstanceGroupManagersService, self).__init__(client)
      self._upload_configs = {
          }

    def AbandonInstances(self, request, global_params=None):
      r"""Flags the specified instances to be immediately removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersAbandonInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AbandonInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AbandonInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.abandonInstances',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/abandonInstances',
        request_field=u'regionInstanceGroupManagersAbandonInstancesRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersAbandonInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ApplyUpdatesToInstances(self, request, global_params=None):
      r"""Apply updates to selected instances the managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ApplyUpdatesToInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyUpdatesToInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.applyUpdatesToInstances',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances',
        request_field=u'regionInstanceGroupManagersApplyUpdatesRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified managed instance group and all of the instances in that group.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionInstanceGroupManagers.delete',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name=u'ComputeRegionInstanceGroupManagersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DeleteInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately deleted. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. The deleteInstances operation is marked DONE if the deleteInstances request is successful. The underlying actions take additional time. You must separately verify the status of the deleting action with the listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeleteInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.deleteInstances',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deleteInstances',
        request_field=u'regionInstanceGroupManagersDeleteInstancesRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersDeleteInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManager) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionInstanceGroupManagers.get',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name=u'ComputeRegionInstanceGroupManagersGetRequest',
        response_type_name=u'InstanceGroupManager',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method.

A regional managed instance group can contain up to 2000 instances.

      Args:
        request: (ComputeRegionInstanceGroupManagersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers',
        request_field=u'instanceGroupManager',
        request_type_name=u'ComputeRegionInstanceGroupManagersInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of managed instance groups that are contained within the specified region.

      Args:
        request: (ComputeRegionInstanceGroupManagersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionInstanceGroupManagers.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers',
        request_field='',
        request_type_name=u'ComputeRegionInstanceGroupManagersListRequest',
        response_type_name=u'RegionInstanceGroupManagerList',
        supports_download=False,
    )

    def ListManagedInstances(self, request, global_params=None):
      r"""Lists the instances in the managed instance group and instances that are scheduled to be created. The list includes any current actions that the group has scheduled for its instances.

      Args:
        request: (ComputeRegionInstanceGroupManagersListManagedInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagersListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('ListManagedInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListManagedInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.listManagedInstances',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'order_by', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances',
        request_field='',
        request_type_name=u'ComputeRegionInstanceGroupManagersListManagedInstancesRequest',
        response_type_name=u'RegionInstanceGroupManagersListInstancesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listmanagedinstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionInstanceGroupManagersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.regionInstanceGroupManagers.patch',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field=u'instanceGroupManagerResource',
        request_type_name=u'ComputeRegionInstanceGroupManagersPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RecreateInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately recreated. The instances are deleted and recreated using the current instance template for the managed instance group. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of the recreating action with the listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersRecreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RecreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RecreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.recreateInstances',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/recreateInstances',
        request_field=u'regionInstanceGroupManagersRecreateRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersRecreateInstancesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Changes the intended size of the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes one or more instances.

The resize operation is marked DONE if the resize request is successful. The underlying actions take additional time. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method.

If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeRegionInstanceGroupManagersResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.resize',
        ordered_params=[u'project', u'region', u'instanceGroupManager', u'size'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId', u'size'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resize',
        request_field='',
        request_type_name=u'ComputeRegionInstanceGroupManagersResizeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetAutoHealingPolicies(self, request, global_params=None):
      r"""Modifies the autohealing policy for the instances in this managed instance group. [Deprecated] This method is deprecated. Please use Patch instead.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoHealingPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoHealingPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.setAutoHealingPolicies',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setAutoHealingPolicies',
        request_field=u'regionInstanceGroupManagersSetAutoHealingRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetInstanceTemplate(self, request, global_params=None):
      r"""Sets the instance template to use when creating new instances or recreating instances in this group. Existing instances are not affected.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetInstanceTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetInstanceTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.setInstanceTemplate',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate',
        request_field=u'regionInstanceGroupManagersSetTemplateRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetTargetPools(self, request, global_params=None):
      r"""Modifies the target pools to which all new instances in this group are assigned. Existing instances in the group are not affected.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetTargetPoolsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTargetPools')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTargetPools.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.setTargetPools',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setTargetPools',
        request_field=u'regionInstanceGroupManagersSetTargetPoolsRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersSetTargetPoolsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstanceGroupManagersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroupManagers.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeRegionInstanceGroupManagersTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listmanagedinstances method.

      Args:
        request: (ComputeRegionInstanceGroupManagersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.regionInstanceGroupManagers.update',
        ordered_params=[u'project', u'region', u'instanceGroupManager'],
        path_params=[u'instanceGroupManager', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field=u'instanceGroupManagerResource',
        request_type_name=u'ComputeRegionInstanceGroupManagersUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionInstanceGroupsService(base_api.BaseApiService):
    """Service class for the regionInstanceGroups resource."""

    _NAME = u'regionInstanceGroups'

    def __init__(self, client):
      super(ComputeBeta.RegionInstanceGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified instance group resource.

      Args:
        request: (ComputeRegionInstanceGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionInstanceGroups.get',
        ordered_params=[u'project', u'region', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name=u'ComputeRegionInstanceGroupsGetRequest',
        response_type_name=u'InstanceGroup',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of instance group resources contained within the specified region.

      Args:
        request: (ComputeRegionInstanceGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionInstanceGroups.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroups',
        request_field='',
        request_type_name=u'ComputeRegionInstanceGroupsListRequest',
        response_type_name=u'RegionInstanceGroupList',
        supports_download=False,
    )

    def ListInstances(self, request, global_params=None):
      r"""Lists the instances in the specified instance group and displays information about the named ports. Depending on the specified options, this method can list all instances or only the instances that are running.

      Args:
        request: (ComputeRegionInstanceGroupsListInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupsListInstances) The response message.
      """
      config = self.GetMethodConfig('ListInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroups.listInstances',
        ordered_params=[u'project', u'region', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/listInstances',
        request_field=u'regionInstanceGroupsListInstancesRequest',
        request_type_name=u'ComputeRegionInstanceGroupsListInstancesRequest',
        response_type_name=u'RegionInstanceGroupsListInstances',
        supports_download=False,
    )

    def SetNamedPorts(self, request, global_params=None):
      r"""Sets the named ports for the specified regional instance group.

      Args:
        request: (ComputeRegionInstanceGroupsSetNamedPortsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNamedPorts')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNamedPorts.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroups.setNamedPorts',
        ordered_params=[u'project', u'region', u'instanceGroup'],
        path_params=[u'instanceGroup', u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/setNamedPorts',
        request_field=u'regionInstanceGroupsSetNamedPortsRequest',
        request_type_name=u'ComputeRegionInstanceGroupsSetNamedPortsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstanceGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionInstanceGroups.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/instanceGroups/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeRegionInstanceGroupsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class RegionOperationsService(base_api.BaseApiService):
    """Service class for the regionOperations resource."""

    _NAME = u'regionOperations'

    def __init__(self, client):
      super(ComputeBeta.RegionOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified region-specific Operations resource.

      Args:
        request: (ComputeRegionOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeRegionOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionOperations.delete',
        ordered_params=[u'project', u'region', u'operation'],
        path_params=[u'operation', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/operations/{operation}',
        request_field='',
        request_type_name=u'ComputeRegionOperationsDeleteRequest',
        response_type_name=u'ComputeRegionOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified region-specific Operations resource.

      Args:
        request: (ComputeRegionOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionOperations.get',
        ordered_params=[u'project', u'region', u'operation'],
        path_params=[u'operation', u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/operations/{operation}',
        request_field='',
        request_type_name=u'ComputeRegionOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified region.

      Args:
        request: (ComputeRegionOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionOperations.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/operations',
        request_field='',
        request_type_name=u'ComputeRegionOperationsListRequest',
        response_type_name=u'OperationList',
        supports_download=False,
    )

  class RegionSslCertificatesService(base_api.BaseApiService):
    """Service class for the regionSslCertificates resource."""

    _NAME = u'regionSslCertificates'

    def __init__(self, client):
      super(ComputeBeta.RegionSslCertificatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SslCertificate resource in the region.

      Args:
        request: (ComputeRegionSslCertificatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionSslCertificates.delete',
        ordered_params=[u'project', u'region', u'sslCertificate'],
        path_params=[u'project', u'region', u'sslCertificate'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name=u'ComputeRegionSslCertificatesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified SslCertificate resource in the specified region. Get a list of available SSL certificates by making a list() request.

      Args:
        request: (ComputeRegionSslCertificatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionSslCertificates.get',
        ordered_params=[u'project', u'region', u'sslCertificate'],
        path_params=[u'project', u'region', u'sslCertificate'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name=u'ComputeRegionSslCertificatesGetRequest',
        response_type_name=u'SslCertificate',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a SslCertificate resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionSslCertificatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionSslCertificates.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/sslCertificates',
        request_field=u'sslCertificate',
        request_type_name=u'ComputeRegionSslCertificatesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of SslCertificate resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionSslCertificatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionSslCertificates.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/sslCertificates',
        request_field='',
        request_type_name=u'ComputeRegionSslCertificatesListRequest',
        response_type_name=u'SslCertificateList',
        supports_download=False,
    )

  class RegionTargetHttpProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetHttpProxies resource."""

    _NAME = u'regionTargetHttpProxies'

    def __init__(self, client):
      super(ComputeBeta.RegionTargetHttpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpProxy resource.

      Args:
        request: (ComputeRegionTargetHttpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionTargetHttpProxies.delete',
        ordered_params=[u'project', u'region', u'targetHttpProxy'],
        path_params=[u'project', u'region', u'targetHttpProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name=u'ComputeRegionTargetHttpProxiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpProxy resource in the specified region. Gets a list of available target HTTP proxies by making a list() request.

      Args:
        request: (ComputeRegionTargetHttpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionTargetHttpProxies.get',
        ordered_params=[u'project', u'region', u'targetHttpProxy'],
        path_params=[u'project', u'region', u'targetHttpProxy'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name=u'ComputeRegionTargetHttpProxiesGetRequest',
        response_type_name=u'TargetHttpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetHttpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionTargetHttpProxies.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpProxies',
        request_field=u'targetHttpProxy',
        request_type_name=u'ComputeRegionTargetHttpProxiesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpProxy resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionTargetHttpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionTargetHttpProxies.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpProxies',
        request_field='',
        request_type_name=u'ComputeRegionTargetHttpProxiesListRequest',
        response_type_name=u'TargetHttpProxyList',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpProxy.

      Args:
        request: (ComputeRegionTargetHttpProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionTargetHttpProxies.setUrlMap',
        ordered_params=[u'project', u'region', u'targetHttpProxy'],
        path_params=[u'project', u'region', u'targetHttpProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}/setUrlMap',
        request_field=u'urlMapReference',
        request_type_name=u'ComputeRegionTargetHttpProxiesSetUrlMapRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionTargetHttpsProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetHttpsProxies resource."""

    _NAME = u'regionTargetHttpsProxies'

    def __init__(self, client):
      super(ComputeBeta.RegionTargetHttpsProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpsProxy resource.

      Args:
        request: (ComputeRegionTargetHttpsProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionTargetHttpsProxies.delete',
        ordered_params=[u'project', u'region', u'targetHttpsProxy'],
        path_params=[u'project', u'region', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name=u'ComputeRegionTargetHttpsProxiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpsProxy resource in the specified region. Gets a list of available target HTTP proxies by making a list() request.

      Args:
        request: (ComputeRegionTargetHttpsProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionTargetHttpsProxies.get',
        ordered_params=[u'project', u'region', u'targetHttpsProxy'],
        path_params=[u'project', u'region', u'targetHttpsProxy'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name=u'ComputeRegionTargetHttpsProxiesGetRequest',
        response_type_name=u'TargetHttpsProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpsProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetHttpsProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionTargetHttpsProxies.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpsProxies',
        request_field=u'targetHttpsProxy',
        request_type_name=u'ComputeRegionTargetHttpsProxiesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpsProxy resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionTargetHttpsProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionTargetHttpsProxies.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpsProxies',
        request_field='',
        request_type_name=u'ComputeRegionTargetHttpsProxiesListRequest',
        response_type_name=u'TargetHttpsProxyList',
        supports_download=False,
    )

    def SetSslCertificates(self, request, global_params=None):
      r"""Replaces SslCertificates for TargetHttpsProxy.

      Args:
        request: (ComputeRegionTargetHttpsProxiesSetSslCertificatesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslCertificates')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslCertificates.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionTargetHttpsProxies.setSslCertificates',
        ordered_params=[u'project', u'region', u'targetHttpsProxy'],
        path_params=[u'project', u'region', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}/setSslCertificates',
        request_field=u'regionTargetHttpsProxiesSetSslCertificatesRequest',
        request_type_name=u'ComputeRegionTargetHttpsProxiesSetSslCertificatesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpsProxy.

      Args:
        request: (ComputeRegionTargetHttpsProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionTargetHttpsProxies.setUrlMap',
        ordered_params=[u'project', u'region', u'targetHttpsProxy'],
        path_params=[u'project', u'region', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}/setUrlMap',
        request_field=u'urlMapReference',
        request_type_name=u'ComputeRegionTargetHttpsProxiesSetUrlMapRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RegionUrlMapsService(base_api.BaseApiService):
    """Service class for the regionUrlMaps resource."""

    _NAME = u'regionUrlMaps'

    def __init__(self, client):
      super(ComputeBeta.RegionUrlMapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified UrlMap resource.

      Args:
        request: (ComputeRegionUrlMapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.regionUrlMaps.delete',
        ordered_params=[u'project', u'region', u'urlMap'],
        path_params=[u'project', u'region', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field='',
        request_type_name=u'ComputeRegionUrlMapsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified UrlMap resource. Gets a list of available URL maps by making a list() request.

      Args:
        request: (ComputeRegionUrlMapsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMap) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionUrlMaps.get',
        ordered_params=[u'project', u'region', u'urlMap'],
        path_params=[u'project', u'region', u'urlMap'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field='',
        request_type_name=u'ComputeRegionUrlMapsGetRequest',
        response_type_name=u'UrlMap',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a UrlMap resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionUrlMapsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionUrlMaps.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/urlMaps',
        request_field=u'urlMap',
        request_type_name=u'ComputeRegionUrlMapsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def InvalidateCache(self, request, global_params=None):
      r"""Initiates a cache invalidation operation, invalidating the specified path, scoped to the specified UrlMap.

      Args:
        request: (ComputeRegionUrlMapsInvalidateCacheRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('InvalidateCache')
      return self._RunMethod(
          config, request, global_params=global_params)

    InvalidateCache.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionUrlMaps.invalidateCache',
        ordered_params=[u'project', u'region', u'urlMap'],
        path_params=[u'project', u'region', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/urlMaps/{urlMap}/invalidateCache',
        request_field=u'cacheInvalidationRule',
        request_type_name=u'ComputeRegionUrlMapsInvalidateCacheRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of UrlMap resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionUrlMapsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regionUrlMaps.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/urlMaps',
        request_field='',
        request_type_name=u'ComputeRegionUrlMapsListRequest',
        response_type_name=u'UrlMapList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified UrlMap resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionUrlMapsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.regionUrlMaps.patch',
        ordered_params=[u'project', u'region', u'urlMap'],
        path_params=[u'project', u'region', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field=u'urlMapResource',
        request_type_name=u'ComputeRegionUrlMapsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified UrlMap resource with the data included in the request.

      Args:
        request: (ComputeRegionUrlMapsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.regionUrlMaps.update',
        ordered_params=[u'project', u'region', u'urlMap'],
        path_params=[u'project', u'region', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field=u'urlMapResource',
        request_type_name=u'ComputeRegionUrlMapsUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Validate(self, request, global_params=None):
      r"""Runs static validation for the UrlMap. In particular, the tests of the provided UrlMap will be run. Calling this method does NOT create the UrlMap.

      Args:
        request: (ComputeRegionUrlMapsValidateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapsValidateResponse) The response message.
      """
      config = self.GetMethodConfig('Validate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Validate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.regionUrlMaps.validate',
        ordered_params=[u'project', u'region', u'urlMap'],
        path_params=[u'project', u'region', u'urlMap'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/urlMaps/{urlMap}/validate',
        request_field=u'regionUrlMapsValidateRequest',
        request_type_name=u'ComputeRegionUrlMapsValidateRequest',
        response_type_name=u'UrlMapsValidateResponse',
        supports_download=False,
    )

  class RegionsService(base_api.BaseApiService):
    """Service class for the regions resource."""

    _NAME = u'regions'

    def __init__(self, client):
      super(ComputeBeta.RegionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified Region resource. Gets a list of available regions by making a list() request.

      Args:
        request: (ComputeRegionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Region) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regions.get',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}',
        request_field='',
        request_type_name=u'ComputeRegionsGetRequest',
        response_type_name=u'Region',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of region resources available to the specified project.

      Args:
        request: (ComputeRegionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.regions.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions',
        request_field='',
        request_type_name=u'ComputeRegionsListRequest',
        response_type_name=u'RegionList',
        supports_download=False,
    )

  class ReservationsService(base_api.BaseApiService):
    """Service class for the reservations resource."""

    _NAME = u'reservations'

    def __init__(self, client):
      super(ComputeBeta.ReservationsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of reservations.

      Args:
        request: (ComputeReservationsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReservationAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.reservations.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/reservations',
        request_field='',
        request_type_name=u'ComputeReservationsAggregatedListRequest',
        response_type_name=u'ReservationAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified reservation.

      Args:
        request: (ComputeReservationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.reservations.delete',
        ordered_params=[u'project', u'zone', u'reservation'],
        path_params=[u'project', u'reservation', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/reservations/{reservation}',
        request_field='',
        request_type_name=u'ComputeReservationsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves all information of the specified reservation.

      Args:
        request: (ComputeReservationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Reservation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.reservations.get',
        ordered_params=[u'project', u'zone', u'reservation'],
        path_params=[u'project', u'reservation', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/reservations/{reservation}',
        request_field='',
        request_type_name=u'ComputeReservationsGetRequest',
        response_type_name=u'Reservation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeReservationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.reservations.getIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/reservations/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeReservationsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new reservation.

      Args:
        request: (ComputeReservationsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.reservations.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/reservations',
        request_field=u'reservation',
        request_type_name=u'ComputeReservationsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""A list all the reservations that have been configured for the specified project in specified zone.

      Args:
        request: (ComputeReservationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReservationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.reservations.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/reservations',
        request_field='',
        request_type_name=u'ComputeReservationsListRequest',
        response_type_name=u'ReservationList',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the reservation (applicable to standalone reservations only).

      Args:
        request: (ComputeReservationsResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.reservations.resize',
        ordered_params=[u'project', u'zone', u'reservation'],
        path_params=[u'project', u'reservation', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/reservations/{reservation}/resize',
        request_field=u'reservationsResizeRequest',
        request_type_name=u'ComputeReservationsResizeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeReservationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.reservations.setIamPolicy',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/reservations/{resource}/setIamPolicy',
        request_field=u'zoneSetPolicyRequest',
        request_type_name=u'ComputeReservationsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeReservationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.reservations.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/reservations/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeReservationsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class ResourcePoliciesService(base_api.BaseApiService):
    """Service class for the resourcePolicies resource."""

    _NAME = u'resourcePolicies'

    def __init__(self, client):
      super(ComputeBeta.ResourcePoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of resource policies.

      Args:
        request: (ComputeResourcePoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResourcePolicyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.resourcePolicies.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/resourcePolicies',
        request_field='',
        request_type_name=u'ComputeResourcePoliciesAggregatedListRequest',
        response_type_name=u'ResourcePolicyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified resource policy.

      Args:
        request: (ComputeResourcePoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.resourcePolicies.delete',
        ordered_params=[u'project', u'region', u'resourcePolicy'],
        path_params=[u'project', u'region', u'resourcePolicy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}',
        request_field='',
        request_type_name=u'ComputeResourcePoliciesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves all information of the specified resource policy.

      Args:
        request: (ComputeResourcePoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResourcePolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.resourcePolicies.get',
        ordered_params=[u'project', u'region', u'resourcePolicy'],
        path_params=[u'project', u'region', u'resourcePolicy'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}',
        request_field='',
        request_type_name=u'ComputeResourcePoliciesGetRequest',
        response_type_name=u'ResourcePolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeResourcePoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.resourcePolicies.getIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeResourcePoliciesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new resource policy.

      Args:
        request: (ComputeResourcePoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.resourcePolicies.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/resourcePolicies',
        request_field=u'resourcePolicy',
        request_type_name=u'ComputeResourcePoliciesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""A list all the resource policies that have been configured for the specified project in specified region.

      Args:
        request: (ComputeResourcePoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResourcePolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.resourcePolicies.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/resourcePolicies',
        request_field='',
        request_type_name=u'ComputeResourcePoliciesListRequest',
        response_type_name=u'ResourcePolicyList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeResourcePoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.resourcePolicies.setIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy',
        request_field=u'regionSetPolicyRequest',
        request_type_name=u'ComputeResourcePoliciesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeResourcePoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.resourcePolicies.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/resourcePolicies/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeResourcePoliciesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class RoutersService(base_api.BaseApiService):
    """Service class for the routers resource."""

    _NAME = u'routers'

    def __init__(self, client):
      super(ComputeBeta.RoutersService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of routers.

      Args:
        request: (ComputeRoutersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouterAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.routers.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/routers',
        request_field='',
        request_type_name=u'ComputeRoutersAggregatedListRequest',
        response_type_name=u'RouterAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Router resource.

      Args:
        request: (ComputeRoutersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.routers.delete',
        ordered_params=[u'project', u'region', u'router'],
        path_params=[u'project', u'region', u'router'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/routers/{router}',
        request_field='',
        request_type_name=u'ComputeRoutersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Router resource. Gets a list of available routers by making a list() request.

      Args:
        request: (ComputeRoutersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Router) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.routers.get',
        ordered_params=[u'project', u'region', u'router'],
        path_params=[u'project', u'region', u'router'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/routers/{router}',
        request_field='',
        request_type_name=u'ComputeRoutersGetRequest',
        response_type_name=u'Router',
        supports_download=False,
    )

    def GetNatMappingInfo(self, request, global_params=None):
      r"""Retrieves runtime Nat mapping information of VM endpoints.

      Args:
        request: (ComputeRoutersGetNatMappingInfoRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VmEndpointNatMappingsList) The response message.
      """
      config = self.GetMethodConfig('GetNatMappingInfo')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetNatMappingInfo.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.routers.getNatMappingInfo',
        ordered_params=[u'project', u'region', u'router'],
        path_params=[u'project', u'region', u'router'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/routers/{router}/getNatMappingInfo',
        request_field='',
        request_type_name=u'ComputeRoutersGetNatMappingInfoRequest',
        response_type_name=u'VmEndpointNatMappingsList',
        supports_download=False,
    )

    def GetRouterStatus(self, request, global_params=None):
      r"""Retrieves runtime information of the specified router.

      Args:
        request: (ComputeRoutersGetRouterStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouterStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetRouterStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRouterStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.routers.getRouterStatus',
        ordered_params=[u'project', u'region', u'router'],
        path_params=[u'project', u'region', u'router'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/routers/{router}/getRouterStatus',
        request_field='',
        request_type_name=u'ComputeRoutersGetRouterStatusRequest',
        response_type_name=u'RouterStatusResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a Router resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRoutersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.routers.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/routers',
        request_field=u'router',
        request_type_name=u'ComputeRoutersInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Router resources available to the specified project.

      Args:
        request: (ComputeRoutersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouterList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.routers.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/routers',
        request_field='',
        request_type_name=u'ComputeRoutersListRequest',
        response_type_name=u'RouterList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified Router resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeRoutersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.routers.patch',
        ordered_params=[u'project', u'region', u'router'],
        path_params=[u'project', u'region', u'router'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/routers/{router}',
        request_field=u'routerResource',
        request_type_name=u'ComputeRoutersPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Preview(self, request, global_params=None):
      r"""Preview fields auto-generated during router create and update operations. Calling this method does NOT create or update the router.

      Args:
        request: (ComputeRoutersPreviewRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RoutersPreviewResponse) The response message.
      """
      config = self.GetMethodConfig('Preview')
      return self._RunMethod(
          config, request, global_params=global_params)

    Preview.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.routers.preview',
        ordered_params=[u'project', u'region', u'router'],
        path_params=[u'project', u'region', u'router'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/routers/{router}/preview',
        request_field=u'routerResource',
        request_type_name=u'ComputeRoutersPreviewRequest',
        response_type_name=u'RoutersPreviewResponse',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRoutersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.routers.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/routers/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeRoutersTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified Router resource with the data included in the request. This method conforms to PUT semantics, which requests that the state of the target resource be created or replaced with the state defined by the representation enclosed in the request message payload.

      Args:
        request: (ComputeRoutersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.routers.update',
        ordered_params=[u'project', u'region', u'router'],
        path_params=[u'project', u'region', u'router'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/routers/{router}',
        request_field=u'routerResource',
        request_type_name=u'ComputeRoutersUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class RoutesService(base_api.BaseApiService):
    """Service class for the routes resource."""

    _NAME = u'routes'

    def __init__(self, client):
      super(ComputeBeta.RoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Route resource.

      Args:
        request: (ComputeRoutesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.routes.delete',
        ordered_params=[u'project', u'route'],
        path_params=[u'project', u'route'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/routes/{route}',
        request_field='',
        request_type_name=u'ComputeRoutesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Route resource. Gets a list of available routes by making a list() request.

      Args:
        request: (ComputeRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.routes.get',
        ordered_params=[u'project', u'route'],
        path_params=[u'project', u'route'],
        query_params=[],
        relative_path=u'projects/{project}/global/routes/{route}',
        request_field='',
        request_type_name=u'ComputeRoutesGetRequest',
        response_type_name=u'Route',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a Route resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRoutesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.routes.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/routes',
        request_field=u'route',
        request_type_name=u'ComputeRoutesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Route resources available to the specified project.

      Args:
        request: (ComputeRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouteList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.routes.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/routes',
        request_field='',
        request_type_name=u'ComputeRoutesListRequest',
        response_type_name=u'RouteList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRoutesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.routes.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/routes/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeRoutesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class SecurityPoliciesService(base_api.BaseApiService):
    """Service class for the securityPolicies resource."""

    _NAME = u'securityPolicies'

    def __init__(self, client):
      super(ComputeBeta.SecurityPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a security policy.

      Args:
        request: (ComputeSecurityPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.securityPolicies.addRule',
        ordered_params=[u'project', u'securityPolicy'],
        path_params=[u'project', u'securityPolicy'],
        query_params=[u'validateOnly'],
        relative_path=u'projects/{project}/global/securityPolicies/{securityPolicy}/addRule',
        request_field=u'securityPolicyRule',
        request_type_name=u'ComputeSecurityPoliciesAddRuleRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeSecurityPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.securityPolicies.delete',
        ordered_params=[u'project', u'securityPolicy'],
        path_params=[u'project', u'securityPolicy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name=u'ComputeSecurityPoliciesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""List all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeSecurityPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.securityPolicies.get',
        ordered_params=[u'project', u'securityPolicy'],
        path_params=[u'project', u'securityPolicy'],
        query_params=[],
        relative_path=u'projects/{project}/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name=u'ComputeSecurityPoliciesGetRequest',
        response_type_name=u'SecurityPolicy',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule at the specified priority.

      Args:
        request: (ComputeSecurityPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.securityPolicies.getRule',
        ordered_params=[u'project', u'securityPolicy'],
        path_params=[u'project', u'securityPolicy'],
        query_params=[u'priority'],
        relative_path=u'projects/{project}/global/securityPolicies/{securityPolicy}/getRule',
        request_field='',
        request_type_name=u'ComputeSecurityPoliciesGetRuleRequest',
        response_type_name=u'SecurityPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeSecurityPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.securityPolicies.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId', u'validateOnly'],
        relative_path=u'projects/{project}/global/securityPolicies',
        request_field=u'securityPolicy',
        request_type_name=u'ComputeSecurityPoliciesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the policies that have been configured for the specified project.

      Args:
        request: (ComputeSecurityPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.securityPolicies.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/securityPolicies',
        request_field='',
        request_type_name=u'ComputeSecurityPoliciesListRequest',
        response_type_name=u'SecurityPolicyList',
        supports_download=False,
    )

    def ListPreconfiguredExpressionSets(self, request, global_params=None):
      r"""Gets the current list of preconfigured Web Application Firewall (WAF) expressions.

      Args:
        request: (ComputeSecurityPoliciesListPreconfiguredExpressionSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPoliciesListPreconfiguredExpressionSetsResponse) The response message.
      """
      config = self.GetMethodConfig('ListPreconfiguredExpressionSets')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPreconfiguredExpressionSets.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.securityPolicies.listPreconfiguredExpressionSets',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/securityPolicies/listPreconfiguredExpressionSets',
        request_field='',
        request_type_name=u'ComputeSecurityPoliciesListPreconfiguredExpressionSetsRequest',
        response_type_name=u'SecurityPoliciesListPreconfiguredExpressionSetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeSecurityPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.securityPolicies.patch',
        ordered_params=[u'project', u'securityPolicy'],
        path_params=[u'project', u'securityPolicy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/securityPolicies/{securityPolicy}',
        request_field=u'securityPolicyResource',
        request_type_name=u'ComputeSecurityPoliciesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule at the specified priority.

      Args:
        request: (ComputeSecurityPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.securityPolicies.patchRule',
        ordered_params=[u'project', u'securityPolicy'],
        path_params=[u'project', u'securityPolicy'],
        query_params=[u'priority', u'validateOnly'],
        relative_path=u'projects/{project}/global/securityPolicies/{securityPolicy}/patchRule',
        request_field=u'securityPolicyRule',
        request_type_name=u'ComputeSecurityPoliciesPatchRuleRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule at the specified priority.

      Args:
        request: (ComputeSecurityPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.securityPolicies.removeRule',
        ordered_params=[u'project', u'securityPolicy'],
        path_params=[u'project', u'securityPolicy'],
        query_params=[u'priority'],
        relative_path=u'projects/{project}/global/securityPolicies/{securityPolicy}/removeRule',
        request_field='',
        request_type_name=u'ComputeSecurityPoliciesRemoveRuleRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a security policy. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeSecurityPoliciesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.securityPolicies.setLabels',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/securityPolicies/{resource}/setLabels',
        request_field=u'globalSetLabelsRequest',
        request_type_name=u'ComputeSecurityPoliciesSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSecurityPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.securityPolicies.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/securityPolicies/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeSecurityPoliciesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class SnapshotsService(base_api.BaseApiService):
    """Service class for the snapshots resource."""

    _NAME = u'snapshots'

    def __init__(self, client):
      super(ComputeBeta.SnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Snapshot resource. Keep in mind that deleting a single snapshot might not necessarily delete all the data on that snapshot. If any data on the snapshot that is marked for deletion is needed for subsequent snapshots, the data will be moved to the next corresponding snapshot.

For more information, see Deleting snapshots.

      Args:
        request: (ComputeSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.snapshots.delete',
        ordered_params=[u'project', u'snapshot'],
        path_params=[u'project', u'snapshot'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/snapshots/{snapshot}',
        request_field='',
        request_type_name=u'ComputeSnapshotsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Snapshot resource. Gets a list of available snapshots by making a list() request.

      Args:
        request: (ComputeSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.snapshots.get',
        ordered_params=[u'project', u'snapshot'],
        path_params=[u'project', u'snapshot'],
        query_params=[],
        relative_path=u'projects/{project}/global/snapshots/{snapshot}',
        request_field='',
        request_type_name=u'ComputeSnapshotsGetRequest',
        response_type_name=u'Snapshot',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeSnapshotsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.snapshots.getIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/snapshots/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeSnapshotsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Snapshot resources contained within the specified project.

      Args:
        request: (ComputeSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SnapshotList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.snapshots.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/snapshots',
        request_field='',
        request_type_name=u'ComputeSnapshotsListRequest',
        response_type_name=u'SnapshotList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeSnapshotsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.snapshots.setIamPolicy',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/snapshots/{resource}/setIamPolicy',
        request_field=u'globalSetPolicyRequest',
        request_type_name=u'ComputeSnapshotsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a snapshot. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeSnapshotsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.snapshots.setLabels',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/snapshots/{resource}/setLabels',
        request_field=u'globalSetLabelsRequest',
        request_type_name=u'ComputeSnapshotsSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSnapshotsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.snapshots.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/snapshots/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeSnapshotsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class SslCertificatesService(base_api.BaseApiService):
    """Service class for the sslCertificates resource."""

    _NAME = u'sslCertificates'

    def __init__(self, client):
      super(ComputeBeta.SslCertificatesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all SslCertificate resources, regional and global, available to the specified project.

      Args:
        request: (ComputeSslCertificatesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificateAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.sslCertificates.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/sslCertificates',
        request_field='',
        request_type_name=u'ComputeSslCertificatesAggregatedListRequest',
        response_type_name=u'SslCertificateAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SslCertificate resource.

      Args:
        request: (ComputeSslCertificatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.sslCertificates.delete',
        ordered_params=[u'project', u'sslCertificate'],
        path_params=[u'project', u'sslCertificate'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name=u'ComputeSslCertificatesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified SslCertificate resource. Gets a list of available SSL certificates by making a list() request.

      Args:
        request: (ComputeSslCertificatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.sslCertificates.get',
        ordered_params=[u'project', u'sslCertificate'],
        path_params=[u'project', u'sslCertificate'],
        query_params=[],
        relative_path=u'projects/{project}/global/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name=u'ComputeSslCertificatesGetRequest',
        response_type_name=u'SslCertificate',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a SslCertificate resource in the specified project using the data included in the request.

      Args:
        request: (ComputeSslCertificatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.sslCertificates.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/sslCertificates',
        request_field=u'sslCertificate',
        request_type_name=u'ComputeSslCertificatesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of SslCertificate resources available to the specified project.

      Args:
        request: (ComputeSslCertificatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.sslCertificates.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/sslCertificates',
        request_field='',
        request_type_name=u'ComputeSslCertificatesListRequest',
        response_type_name=u'SslCertificateList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSslCertificatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.sslCertificates.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/sslCertificates/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeSslCertificatesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class SslPoliciesService(base_api.BaseApiService):
    """Service class for the sslPolicies resource."""

    _NAME = u'sslPolicies'

    def __init__(self, client):
      super(ComputeBeta.SslPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in use by any TargetHttpsProxy or TargetSslProxy resources.

      Args:
        request: (ComputeSslPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.sslPolicies.delete',
        ordered_params=[u'project', u'sslPolicy'],
        path_params=[u'project', u'sslPolicy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name=u'ComputeSslPoliciesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Lists all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeSslPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.sslPolicies.get',
        ordered_params=[u'project', u'sslPolicy'],
        path_params=[u'project', u'sslPolicy'],
        query_params=[],
        relative_path=u'projects/{project}/global/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name=u'ComputeSslPoliciesGetRequest',
        response_type_name=u'SslPolicy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Returns the specified SSL policy resource. Gets a list of available SSL policies by making a list() request.

      Args:
        request: (ComputeSslPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.sslPolicies.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/sslPolicies',
        request_field=u'sslPolicy',
        request_type_name=u'ComputeSslPoliciesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the SSL policies that have been configured for the specified project.

      Args:
        request: (ComputeSslPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.sslPolicies.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/sslPolicies',
        request_field='',
        request_type_name=u'ComputeSslPoliciesListRequest',
        response_type_name=u'SslPoliciesList',
        supports_download=False,
    )

    def ListAvailableFeatures(self, request, global_params=None):
      r"""Lists all features that can be specified in the SSL policy when using custom profile.

      Args:
        request: (ComputeSslPoliciesListAvailableFeaturesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesListAvailableFeaturesResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableFeatures')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableFeatures.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.sslPolicies.listAvailableFeatures',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/sslPolicies/listAvailableFeatures',
        request_field='',
        request_type_name=u'ComputeSslPoliciesListAvailableFeaturesRequest',
        response_type_name=u'SslPoliciesListAvailableFeaturesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified SSL policy with the data included in the request.

      Args:
        request: (ComputeSslPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.sslPolicies.patch',
        ordered_params=[u'project', u'sslPolicy'],
        path_params=[u'project', u'sslPolicy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/sslPolicies/{sslPolicy}',
        request_field=u'sslPolicyResource',
        request_type_name=u'ComputeSslPoliciesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSslPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.sslPolicies.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/sslPolicies/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeSslPoliciesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class SubnetworksService(base_api.BaseApiService):
    """Service class for the subnetworks resource."""

    _NAME = u'subnetworks'

    def __init__(self, client):
      super(ComputeBeta.SubnetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of subnetworks.

      Args:
        request: (ComputeSubnetworksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SubnetworkAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.subnetworks.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/subnetworks',
        request_field='',
        request_type_name=u'ComputeSubnetworksAggregatedListRequest',
        response_type_name=u'SubnetworkAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified subnetwork.

      Args:
        request: (ComputeSubnetworksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.subnetworks.delete',
        ordered_params=[u'project', u'region', u'subnetwork'],
        path_params=[u'project', u'region', u'subnetwork'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{subnetwork}',
        request_field='',
        request_type_name=u'ComputeSubnetworksDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ExpandIpCidrRange(self, request, global_params=None):
      r"""Expands the IP CIDR range of the subnetwork to a specified value.

      Args:
        request: (ComputeSubnetworksExpandIpCidrRangeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ExpandIpCidrRange')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExpandIpCidrRange.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.subnetworks.expandIpCidrRange',
        ordered_params=[u'project', u'region', u'subnetwork'],
        path_params=[u'project', u'region', u'subnetwork'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{subnetwork}/expandIpCidrRange',
        request_field=u'subnetworksExpandIpCidrRangeRequest',
        request_type_name=u'ComputeSubnetworksExpandIpCidrRangeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified subnetwork. Gets a list of available subnetworks list() request.

      Args:
        request: (ComputeSubnetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Subnetwork) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.subnetworks.get',
        ordered_params=[u'project', u'region', u'subnetwork'],
        path_params=[u'project', u'region', u'subnetwork'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{subnetwork}',
        request_field='',
        request_type_name=u'ComputeSubnetworksGetRequest',
        response_type_name=u'Subnetwork',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeSubnetworksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.subnetworks.getIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{resource}/getIamPolicy',
        request_field='',
        request_type_name=u'ComputeSubnetworksGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a subnetwork in the specified project using the data included in the request.

      Args:
        request: (ComputeSubnetworksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.subnetworks.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/subnetworks',
        request_field=u'subnetwork',
        request_type_name=u'ComputeSubnetworksInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of subnetworks available to the specified project.

      Args:
        request: (ComputeSubnetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SubnetworkList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.subnetworks.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/subnetworks',
        request_field='',
        request_type_name=u'ComputeSubnetworksListRequest',
        response_type_name=u'SubnetworkList',
        supports_download=False,
    )

    def ListUsable(self, request, global_params=None):
      r"""Retrieves an aggregated list of usable subnetworks.

      Args:
        request: (ComputeSubnetworksListUsableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UsableSubnetworksAggregatedList) The response message.
      """
      config = self.GetMethodConfig('ListUsable')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListUsable.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.subnetworks.listUsable',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/subnetworks/listUsable',
        request_field='',
        request_type_name=u'ComputeSubnetworksListUsableRequest',
        response_type_name=u'UsableSubnetworksAggregatedList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified subnetwork with the data included in the request. Only certain fields can up updated with a patch request as indicated in the field descriptions. You must specify the current fingeprint of the subnetwork resource being patched.

      Args:
        request: (ComputeSubnetworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.subnetworks.patch',
        ordered_params=[u'project', u'region', u'subnetwork'],
        path_params=[u'project', u'region', u'subnetwork'],
        query_params=[u'drainTimeoutSeconds', u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{subnetwork}',
        request_field=u'subnetworkResource',
        request_type_name=u'ComputeSubnetworksPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeSubnetworksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.subnetworks.setIamPolicy',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{resource}/setIamPolicy',
        request_field=u'regionSetPolicyRequest',
        request_type_name=u'ComputeSubnetworksSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetPrivateIpGoogleAccess(self, request, global_params=None):
      r"""Set whether VMs in this subnet can access Google services without assigning external IP addresses through Private Google Access.

      Args:
        request: (ComputeSubnetworksSetPrivateIpGoogleAccessRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetPrivateIpGoogleAccess')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetPrivateIpGoogleAccess.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.subnetworks.setPrivateIpGoogleAccess',
        ordered_params=[u'project', u'region', u'subnetwork'],
        path_params=[u'project', u'region', u'subnetwork'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{subnetwork}/setPrivateIpGoogleAccess',
        request_field=u'subnetworksSetPrivateIpGoogleAccessRequest',
        request_type_name=u'ComputeSubnetworksSetPrivateIpGoogleAccessRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSubnetworksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.subnetworks.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/subnetworks/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeSubnetworksTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class TargetHttpProxiesService(base_api.BaseApiService):
    """Service class for the targetHttpProxies resource."""

    _NAME = u'targetHttpProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetHttpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all TargetHttpProxy resources, regional and global, available to the specified project.

      Args:
        request: (ComputeTargetHttpProxiesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetHttpProxies.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/targetHttpProxies',
        request_field='',
        request_type_name=u'ComputeTargetHttpProxiesAggregatedListRequest',
        response_type_name=u'TargetHttpProxyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpProxy resource.

      Args:
        request: (ComputeTargetHttpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.targetHttpProxies.delete',
        ordered_params=[u'project', u'targetHttpProxy'],
        path_params=[u'project', u'targetHttpProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name=u'ComputeTargetHttpProxiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpProxy resource. Gets a list of available target HTTP proxies by making a list() request.

      Args:
        request: (ComputeTargetHttpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetHttpProxies.get',
        ordered_params=[u'project', u'targetHttpProxy'],
        path_params=[u'project', u'targetHttpProxy'],
        query_params=[],
        relative_path=u'projects/{project}/global/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name=u'ComputeTargetHttpProxiesGetRequest',
        response_type_name=u'TargetHttpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetHttpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpProxies.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetHttpProxies',
        request_field=u'targetHttpProxy',
        request_type_name=u'ComputeTargetHttpProxiesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpProxy resources available to the specified project.

      Args:
        request: (ComputeTargetHttpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetHttpProxies.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/targetHttpProxies',
        request_field='',
        request_type_name=u'ComputeTargetHttpProxiesListRequest',
        response_type_name=u'TargetHttpProxyList',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpProxy.

      Args:
        request: (ComputeTargetHttpProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpProxies.setUrlMap',
        ordered_params=[u'project', u'targetHttpProxy'],
        path_params=[u'project', u'targetHttpProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/targetHttpProxies/{targetHttpProxy}/setUrlMap',
        request_field=u'urlMapReference',
        request_type_name=u'ComputeTargetHttpProxiesSetUrlMapRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetHttpProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpProxies.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/targetHttpProxies/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeTargetHttpProxiesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class TargetHttpsProxiesService(base_api.BaseApiService):
    """Service class for the targetHttpsProxies resource."""

    _NAME = u'targetHttpsProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetHttpsProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all TargetHttpsProxy resources, regional and global, available to the specified project.

      Args:
        request: (ComputeTargetHttpsProxiesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetHttpsProxies.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/targetHttpsProxies',
        request_field='',
        request_type_name=u'ComputeTargetHttpsProxiesAggregatedListRequest',
        response_type_name=u'TargetHttpsProxyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpsProxy resource.

      Args:
        request: (ComputeTargetHttpsProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.targetHttpsProxies.delete',
        ordered_params=[u'project', u'targetHttpsProxy'],
        path_params=[u'project', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name=u'ComputeTargetHttpsProxiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpsProxy resource. Gets a list of available target HTTPS proxies by making a list() request.

      Args:
        request: (ComputeTargetHttpsProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetHttpsProxies.get',
        ordered_params=[u'project', u'targetHttpsProxy'],
        path_params=[u'project', u'targetHttpsProxy'],
        query_params=[],
        relative_path=u'projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name=u'ComputeTargetHttpsProxiesGetRequest',
        response_type_name=u'TargetHttpsProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpsProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetHttpsProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpsProxies.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetHttpsProxies',
        request_field=u'targetHttpsProxy',
        request_type_name=u'ComputeTargetHttpsProxiesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpsProxy resources available to the specified project.

      Args:
        request: (ComputeTargetHttpsProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetHttpsProxies.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/targetHttpsProxies',
        request_field='',
        request_type_name=u'ComputeTargetHttpsProxiesListRequest',
        response_type_name=u'TargetHttpsProxyList',
        supports_download=False,
    )

    def SetQuicOverride(self, request, global_params=None):
      r"""Sets the QUIC override policy for TargetHttpsProxy.

      Args:
        request: (ComputeTargetHttpsProxiesSetQuicOverrideRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetQuicOverride')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetQuicOverride.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpsProxies.setQuicOverride',
        ordered_params=[u'project', u'targetHttpsProxy'],
        path_params=[u'project', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setQuicOverride',
        request_field=u'targetHttpsProxiesSetQuicOverrideRequest',
        request_type_name=u'ComputeTargetHttpsProxiesSetQuicOverrideRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetSslCertificates(self, request, global_params=None):
      r"""Replaces SslCertificates for TargetHttpsProxy.

      Args:
        request: (ComputeTargetHttpsProxiesSetSslCertificatesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslCertificates')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslCertificates.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpsProxies.setSslCertificates',
        ordered_params=[u'project', u'targetHttpsProxy'],
        path_params=[u'project', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/targetHttpsProxies/{targetHttpsProxy}/setSslCertificates',
        request_field=u'targetHttpsProxiesSetSslCertificatesRequest',
        request_type_name=u'ComputeTargetHttpsProxiesSetSslCertificatesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetSslPolicy(self, request, global_params=None):
      r"""Sets the SSL policy for TargetHttpsProxy. The SSL policy specifies the server-side support for SSL features. This affects connections between clients and the HTTPS proxy load balancer. They do not affect the connection between the load balancer and the backends.

      Args:
        request: (ComputeTargetHttpsProxiesSetSslPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpsProxies.setSslPolicy',
        ordered_params=[u'project', u'targetHttpsProxy'],
        path_params=[u'project', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setSslPolicy',
        request_field=u'sslPolicyReference',
        request_type_name=u'ComputeTargetHttpsProxiesSetSslPolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpsProxy.

      Args:
        request: (ComputeTargetHttpsProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpsProxies.setUrlMap',
        ordered_params=[u'project', u'targetHttpsProxy'],
        path_params=[u'project', u'targetHttpsProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/targetHttpsProxies/{targetHttpsProxy}/setUrlMap',
        request_field=u'urlMapReference',
        request_type_name=u'ComputeTargetHttpsProxiesSetUrlMapRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetHttpsProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetHttpsProxies.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/targetHttpsProxies/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeTargetHttpsProxiesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class TargetInstancesService(base_api.BaseApiService):
    """Service class for the targetInstances resource."""

    _NAME = u'targetInstances'

    def __init__(self, client):
      super(ComputeBeta.TargetInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of target instances.

      Args:
        request: (ComputeTargetInstancesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetInstanceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetInstances.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/targetInstances',
        request_field='',
        request_type_name=u'ComputeTargetInstancesAggregatedListRequest',
        response_type_name=u'TargetInstanceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetInstance resource.

      Args:
        request: (ComputeTargetInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.targetInstances.delete',
        ordered_params=[u'project', u'zone', u'targetInstance'],
        path_params=[u'project', u'targetInstance', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/targetInstances/{targetInstance}',
        request_field='',
        request_type_name=u'ComputeTargetInstancesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetInstance resource. Gets a list of available target instances by making a list() request.

      Args:
        request: (ComputeTargetInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetInstance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetInstances.get',
        ordered_params=[u'project', u'zone', u'targetInstance'],
        path_params=[u'project', u'targetInstance', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/targetInstances/{targetInstance}',
        request_field='',
        request_type_name=u'ComputeTargetInstancesGetRequest',
        response_type_name=u'TargetInstance',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetInstance resource in the specified project and zone using the data included in the request.

      Args:
        request: (ComputeTargetInstancesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetInstances.insert',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/zones/{zone}/targetInstances',
        request_field=u'targetInstance',
        request_type_name=u'ComputeTargetInstancesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of TargetInstance resources available to the specified project and zone.

      Args:
        request: (ComputeTargetInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetInstanceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetInstances.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/targetInstances',
        request_field='',
        request_type_name=u'ComputeTargetInstancesListRequest',
        response_type_name=u'TargetInstanceList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetInstances.testIamPermissions',
        ordered_params=[u'project', u'zone', u'resource'],
        path_params=[u'project', u'resource', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/targetInstances/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeTargetInstancesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class TargetPoolsService(base_api.BaseApiService):
    """Service class for the targetPools resource."""

    _NAME = u'targetPools'

    def __init__(self, client):
      super(ComputeBeta.TargetPoolsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddHealthCheck(self, request, global_params=None):
      r"""Adds health check URLs to a target pool.

      Args:
        request: (ComputeTargetPoolsAddHealthCheckRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddHealthCheck')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddHealthCheck.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.addHealthCheck',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck',
        request_field=u'targetPoolsAddHealthCheckRequest',
        request_type_name=u'ComputeTargetPoolsAddHealthCheckRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AddInstance(self, request, global_params=None):
      r"""Adds an instance to a target pool.

      Args:
        request: (ComputeTargetPoolsAddInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.addInstance',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}/addInstance',
        request_field=u'targetPoolsAddInstanceRequest',
        request_type_name=u'ComputeTargetPoolsAddInstanceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of target pools.

      Args:
        request: (ComputeTargetPoolsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPoolAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetPools.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/targetPools',
        request_field='',
        request_type_name=u'ComputeTargetPoolsAggregatedListRequest',
        response_type_name=u'TargetPoolAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified target pool.

      Args:
        request: (ComputeTargetPoolsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.targetPools.delete',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}',
        request_field='',
        request_type_name=u'ComputeTargetPoolsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified target pool. Gets a list of available target pools by making a list() request.

      Args:
        request: (ComputeTargetPoolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetPools.get',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}',
        request_field='',
        request_type_name=u'ComputeTargetPoolsGetRequest',
        response_type_name=u'TargetPool',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for each IP for the instance that is referenced by the given target pool.

      Args:
        request: (ComputeTargetPoolsGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPoolInstanceHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.getHealth',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}/getHealth',
        request_field=u'instanceReference',
        request_type_name=u'ComputeTargetPoolsGetHealthRequest',
        response_type_name=u'TargetPoolInstanceHealth',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a target pool in the specified project and region using the data included in the request.

      Args:
        request: (ComputeTargetPoolsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetPools',
        request_field=u'targetPool',
        request_type_name=u'ComputeTargetPoolsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of target pools available to the specified project and region.

      Args:
        request: (ComputeTargetPoolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPoolList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetPools.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/targetPools',
        request_field='',
        request_type_name=u'ComputeTargetPoolsListRequest',
        response_type_name=u'TargetPoolList',
        supports_download=False,
    )

    def RemoveHealthCheck(self, request, global_params=None):
      r"""Removes health check URL from a target pool.

      Args:
        request: (ComputeTargetPoolsRemoveHealthCheckRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveHealthCheck')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveHealthCheck.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.removeHealthCheck',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck',
        request_field=u'targetPoolsRemoveHealthCheckRequest',
        request_type_name=u'ComputeTargetPoolsRemoveHealthCheckRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RemoveInstance(self, request, global_params=None):
      r"""Removes instance URL from a target pool.

      Args:
        request: (ComputeTargetPoolsRemoveInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.removeInstance',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}/removeInstance',
        request_field=u'targetPoolsRemoveInstanceRequest',
        request_type_name=u'ComputeTargetPoolsRemoveInstanceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetBackup(self, request, global_params=None):
      r"""Changes a backup target pool's configurations.

      Args:
        request: (ComputeTargetPoolsSetBackupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetBackup')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetBackup.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.setBackup',
        ordered_params=[u'project', u'region', u'targetPool'],
        path_params=[u'project', u'region', u'targetPool'],
        query_params=[u'failoverRatio', u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{targetPool}/setBackup',
        request_field=u'targetReference',
        request_type_name=u'ComputeTargetPoolsSetBackupRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetPoolsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetPools.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/targetPools/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeTargetPoolsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class TargetSslProxiesService(base_api.BaseApiService):
    """Service class for the targetSslProxies resource."""

    _NAME = u'targetSslProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetSslProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetSslProxy resource.

      Args:
        request: (ComputeTargetSslProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.targetSslProxies.delete',
        ordered_params=[u'project', u'targetSslProxy'],
        path_params=[u'project', u'targetSslProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetSslProxies/{targetSslProxy}',
        request_field='',
        request_type_name=u'ComputeTargetSslProxiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetSslProxy resource. Gets a list of available target SSL proxies by making a list() request.

      Args:
        request: (ComputeTargetSslProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetSslProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetSslProxies.get',
        ordered_params=[u'project', u'targetSslProxy'],
        path_params=[u'project', u'targetSslProxy'],
        query_params=[],
        relative_path=u'projects/{project}/global/targetSslProxies/{targetSslProxy}',
        request_field='',
        request_type_name=u'ComputeTargetSslProxiesGetRequest',
        response_type_name=u'TargetSslProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetSslProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetSslProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetSslProxies.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetSslProxies',
        request_field=u'targetSslProxy',
        request_type_name=u'ComputeTargetSslProxiesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetSslProxy resources available to the specified project.

      Args:
        request: (ComputeTargetSslProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetSslProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetSslProxies.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/targetSslProxies',
        request_field='',
        request_type_name=u'ComputeTargetSslProxiesListRequest',
        response_type_name=u'TargetSslProxyList',
        supports_download=False,
    )

    def SetBackendService(self, request, global_params=None):
      r"""Changes the BackendService for TargetSslProxy.

      Args:
        request: (ComputeTargetSslProxiesSetBackendServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetBackendService')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetBackendService.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetSslProxies.setBackendService',
        ordered_params=[u'project', u'targetSslProxy'],
        path_params=[u'project', u'targetSslProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetSslProxies/{targetSslProxy}/setBackendService',
        request_field=u'targetSslProxiesSetBackendServiceRequest',
        request_type_name=u'ComputeTargetSslProxiesSetBackendServiceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetProxyHeader(self, request, global_params=None):
      r"""Changes the ProxyHeaderType for TargetSslProxy.

      Args:
        request: (ComputeTargetSslProxiesSetProxyHeaderRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetProxyHeader')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetProxyHeader.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetSslProxies.setProxyHeader',
        ordered_params=[u'project', u'targetSslProxy'],
        path_params=[u'project', u'targetSslProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetSslProxies/{targetSslProxy}/setProxyHeader',
        request_field=u'targetSslProxiesSetProxyHeaderRequest',
        request_type_name=u'ComputeTargetSslProxiesSetProxyHeaderRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetSslCertificates(self, request, global_params=None):
      r"""Changes SslCertificates for TargetSslProxy.

      Args:
        request: (ComputeTargetSslProxiesSetSslCertificatesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslCertificates')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslCertificates.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetSslProxies.setSslCertificates',
        ordered_params=[u'project', u'targetSslProxy'],
        path_params=[u'project', u'targetSslProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslCertificates',
        request_field=u'targetSslProxiesSetSslCertificatesRequest',
        request_type_name=u'ComputeTargetSslProxiesSetSslCertificatesRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetSslPolicy(self, request, global_params=None):
      r"""Sets the SSL policy for TargetSslProxy. The SSL policy specifies the server-side support for SSL features. This affects connections between clients and the SSL proxy load balancer. They do not affect the connection between the load balancer and the backends.

      Args:
        request: (ComputeTargetSslProxiesSetSslPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetSslProxies.setSslPolicy',
        ordered_params=[u'project', u'targetSslProxy'],
        path_params=[u'project', u'targetSslProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslPolicy',
        request_field=u'sslPolicyReference',
        request_type_name=u'ComputeTargetSslProxiesSetSslPolicyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetSslProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetSslProxies.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/targetSslProxies/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeTargetSslProxiesTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class TargetTcpProxiesService(base_api.BaseApiService):
    """Service class for the targetTcpProxies resource."""

    _NAME = u'targetTcpProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetTcpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetTcpProxy resource.

      Args:
        request: (ComputeTargetTcpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.targetTcpProxies.delete',
        ordered_params=[u'project', u'targetTcpProxy'],
        path_params=[u'project', u'targetTcpProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name=u'ComputeTargetTcpProxiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetTcpProxy resource. Gets a list of available target TCP proxies by making a list() request.

      Args:
        request: (ComputeTargetTcpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetTcpProxies.get',
        ordered_params=[u'project', u'targetTcpProxy'],
        path_params=[u'project', u'targetTcpProxy'],
        query_params=[],
        relative_path=u'projects/{project}/global/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name=u'ComputeTargetTcpProxiesGetRequest',
        response_type_name=u'TargetTcpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetTcpProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetTcpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetTcpProxies.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetTcpProxies',
        request_field=u'targetTcpProxy',
        request_type_name=u'ComputeTargetTcpProxiesInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetTcpProxy resources available to the specified project.

      Args:
        request: (ComputeTargetTcpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetTcpProxies.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/targetTcpProxies',
        request_field='',
        request_type_name=u'ComputeTargetTcpProxiesListRequest',
        response_type_name=u'TargetTcpProxyList',
        supports_download=False,
    )

    def SetBackendService(self, request, global_params=None):
      r"""Changes the BackendService for TargetTcpProxy.

      Args:
        request: (ComputeTargetTcpProxiesSetBackendServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetBackendService')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetBackendService.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetTcpProxies.setBackendService',
        ordered_params=[u'project', u'targetTcpProxy'],
        path_params=[u'project', u'targetTcpProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetTcpProxies/{targetTcpProxy}/setBackendService',
        request_field=u'targetTcpProxiesSetBackendServiceRequest',
        request_type_name=u'ComputeTargetTcpProxiesSetBackendServiceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetProxyHeader(self, request, global_params=None):
      r"""Changes the ProxyHeaderType for TargetTcpProxy.

      Args:
        request: (ComputeTargetTcpProxiesSetProxyHeaderRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetProxyHeader')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetProxyHeader.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetTcpProxies.setProxyHeader',
        ordered_params=[u'project', u'targetTcpProxy'],
        path_params=[u'project', u'targetTcpProxy'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/targetTcpProxies/{targetTcpProxy}/setProxyHeader',
        request_field=u'targetTcpProxiesSetProxyHeaderRequest',
        request_type_name=u'ComputeTargetTcpProxiesSetProxyHeaderRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class TargetVpnGatewaysService(base_api.BaseApiService):
    """Service class for the targetVpnGateways resource."""

    _NAME = u'targetVpnGateways'

    def __init__(self, client):
      super(ComputeBeta.TargetVpnGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of target VPN gateways.

      Args:
        request: (ComputeTargetVpnGatewaysAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetVpnGatewayAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetVpnGateways.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/targetVpnGateways',
        request_field='',
        request_type_name=u'ComputeTargetVpnGatewaysAggregatedListRequest',
        response_type_name=u'TargetVpnGatewayAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified target VPN gateway.

      Args:
        request: (ComputeTargetVpnGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.targetVpnGateways.delete',
        ordered_params=[u'project', u'region', u'targetVpnGateway'],
        path_params=[u'project', u'region', u'targetVpnGateway'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}',
        request_field='',
        request_type_name=u'ComputeTargetVpnGatewaysDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified target VPN gateway. Gets a list of available target VPN gateways by making a list() request.

      Args:
        request: (ComputeTargetVpnGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetVpnGateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetVpnGateways.get',
        ordered_params=[u'project', u'region', u'targetVpnGateway'],
        path_params=[u'project', u'region', u'targetVpnGateway'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}',
        request_field='',
        request_type_name=u'ComputeTargetVpnGatewaysGetRequest',
        response_type_name=u'TargetVpnGateway',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a target VPN gateway in the specified project and region using the data included in the request.

      Args:
        request: (ComputeTargetVpnGatewaysInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetVpnGateways.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetVpnGateways',
        request_field=u'targetVpnGateway',
        request_type_name=u'ComputeTargetVpnGatewaysInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of target VPN gateways available to the specified project and region.

      Args:
        request: (ComputeTargetVpnGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetVpnGatewayList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.targetVpnGateways.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/targetVpnGateways',
        request_field='',
        request_type_name=u'ComputeTargetVpnGatewaysListRequest',
        response_type_name=u'TargetVpnGatewayList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a TargetVpnGateway. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeTargetVpnGatewaysSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetVpnGateways.setLabels',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/targetVpnGateways/{resource}/setLabels',
        request_field=u'regionSetLabelsRequest',
        request_type_name=u'ComputeTargetVpnGatewaysSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetVpnGatewaysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.targetVpnGateways.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/targetVpnGateways/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeTargetVpnGatewaysTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class UrlMapsService(base_api.BaseApiService):
    """Service class for the urlMaps resource."""

    _NAME = u'urlMaps'

    def __init__(self, client):
      super(ComputeBeta.UrlMapsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all UrlMap resources, regional and global, available to the specified project.

      Args:
        request: (ComputeUrlMapsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapsAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.urlMaps.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/urlMaps',
        request_field='',
        request_type_name=u'ComputeUrlMapsAggregatedListRequest',
        response_type_name=u'UrlMapsAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified UrlMap resource.

      Args:
        request: (ComputeUrlMapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.urlMaps.delete',
        ordered_params=[u'project', u'urlMap'],
        path_params=[u'project', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/urlMaps/{urlMap}',
        request_field='',
        request_type_name=u'ComputeUrlMapsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified UrlMap resource. Gets a list of available URL maps by making a list() request.

      Args:
        request: (ComputeUrlMapsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMap) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.urlMaps.get',
        ordered_params=[u'project', u'urlMap'],
        path_params=[u'project', u'urlMap'],
        query_params=[],
        relative_path=u'projects/{project}/global/urlMaps/{urlMap}',
        request_field='',
        request_type_name=u'ComputeUrlMapsGetRequest',
        response_type_name=u'UrlMap',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a UrlMap resource in the specified project using the data included in the request.

      Args:
        request: (ComputeUrlMapsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.urlMaps.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/urlMaps',
        request_field=u'urlMap',
        request_type_name=u'ComputeUrlMapsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def InvalidateCache(self, request, global_params=None):
      r"""Initiates a cache invalidation operation, invalidating the specified path, scoped to the specified UrlMap.

      Args:
        request: (ComputeUrlMapsInvalidateCacheRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('InvalidateCache')
      return self._RunMethod(
          config, request, global_params=global_params)

    InvalidateCache.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.urlMaps.invalidateCache',
        ordered_params=[u'project', u'urlMap'],
        path_params=[u'project', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/urlMaps/{urlMap}/invalidateCache',
        request_field=u'cacheInvalidationRule',
        request_type_name=u'ComputeUrlMapsInvalidateCacheRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of UrlMap resources available to the specified project.

      Args:
        request: (ComputeUrlMapsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.urlMaps.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/global/urlMaps',
        request_field='',
        request_type_name=u'ComputeUrlMapsListRequest',
        response_type_name=u'UrlMapList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified UrlMap resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeUrlMapsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'compute.urlMaps.patch',
        ordered_params=[u'project', u'urlMap'],
        path_params=[u'project', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/urlMaps/{urlMap}',
        request_field=u'urlMapResource',
        request_type_name=u'ComputeUrlMapsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeUrlMapsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.urlMaps.testIamPermissions',
        ordered_params=[u'project', u'resource'],
        path_params=[u'project', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/global/urlMaps/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeUrlMapsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified UrlMap resource with the data included in the request.

      Args:
        request: (ComputeUrlMapsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'compute.urlMaps.update',
        ordered_params=[u'project', u'urlMap'],
        path_params=[u'project', u'urlMap'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/global/urlMaps/{urlMap}',
        request_field=u'urlMapResource',
        request_type_name=u'ComputeUrlMapsUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Validate(self, request, global_params=None):
      r"""Runs static validation for the UrlMap. In particular, the tests of the provided UrlMap will be run. Calling this method does NOT create the UrlMap.

      Args:
        request: (ComputeUrlMapsValidateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapsValidateResponse) The response message.
      """
      config = self.GetMethodConfig('Validate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Validate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.urlMaps.validate',
        ordered_params=[u'project', u'urlMap'],
        path_params=[u'project', u'urlMap'],
        query_params=[],
        relative_path=u'projects/{project}/global/urlMaps/{urlMap}/validate',
        request_field=u'urlMapsValidateRequest',
        request_type_name=u'ComputeUrlMapsValidateRequest',
        response_type_name=u'UrlMapsValidateResponse',
        supports_download=False,
    )

  class VpnGatewaysService(base_api.BaseApiService):
    """Service class for the vpnGateways resource."""

    _NAME = u'vpnGateways'

    def __init__(self, client):
      super(ComputeBeta.VpnGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of VPN gateways.

      Args:
        request: (ComputeVpnGatewaysAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGatewayAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.vpnGateways.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/vpnGateways',
        request_field='',
        request_type_name=u'ComputeVpnGatewaysAggregatedListRequest',
        response_type_name=u'VpnGatewayAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified VPN gateway.

      Args:
        request: (ComputeVpnGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.vpnGateways.delete',
        ordered_params=[u'project', u'region', u'vpnGateway'],
        path_params=[u'project', u'region', u'vpnGateway'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/vpnGateways/{vpnGateway}',
        request_field='',
        request_type_name=u'ComputeVpnGatewaysDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified VPN gateway. Gets a list of available VPN gateways by making a list() request.

      Args:
        request: (ComputeVpnGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.vpnGateways.get',
        ordered_params=[u'project', u'region', u'vpnGateway'],
        path_params=[u'project', u'region', u'vpnGateway'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/vpnGateways/{vpnGateway}',
        request_field='',
        request_type_name=u'ComputeVpnGatewaysGetRequest',
        response_type_name=u'VpnGateway',
        supports_download=False,
    )

    def GetStatus(self, request, global_params=None):
      r"""Returns the status for the specified VPN gateway.

      Args:
        request: (ComputeVpnGatewaysGetStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGatewaysGetStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.vpnGateways.getStatus',
        ordered_params=[u'project', u'region', u'vpnGateway'],
        path_params=[u'project', u'region', u'vpnGateway'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/vpnGateways/{vpnGateway}/getStatus',
        request_field='',
        request_type_name=u'ComputeVpnGatewaysGetStatusRequest',
        response_type_name=u'VpnGatewaysGetStatusResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a VPN gateway in the specified project and region using the data included in the request.

      Args:
        request: (ComputeVpnGatewaysInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.vpnGateways.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/vpnGateways',
        request_field=u'vpnGateway',
        request_type_name=u'ComputeVpnGatewaysInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of VPN gateways available to the specified project and region.

      Args:
        request: (ComputeVpnGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGatewayList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.vpnGateways.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/vpnGateways',
        request_field='',
        request_type_name=u'ComputeVpnGatewaysListRequest',
        response_type_name=u'VpnGatewayList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a VpnGateway. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeVpnGatewaysSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.vpnGateways.setLabels',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/vpnGateways/{resource}/setLabels',
        request_field=u'regionSetLabelsRequest',
        request_type_name=u'ComputeVpnGatewaysSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class VpnTunnelsService(base_api.BaseApiService):
    """Service class for the vpnTunnels resource."""

    _NAME = u'vpnTunnels'

    def __init__(self, client):
      super(ComputeBeta.VpnTunnelsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of VPN tunnels.

      Args:
        request: (ComputeVpnTunnelsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnTunnelAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.vpnTunnels.aggregatedList',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/aggregated/vpnTunnels',
        request_field='',
        request_type_name=u'ComputeVpnTunnelsAggregatedListRequest',
        response_type_name=u'VpnTunnelAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified VpnTunnel resource.

      Args:
        request: (ComputeVpnTunnelsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.vpnTunnels.delete',
        ordered_params=[u'project', u'region', u'vpnTunnel'],
        path_params=[u'project', u'region', u'vpnTunnel'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}',
        request_field='',
        request_type_name=u'ComputeVpnTunnelsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified VpnTunnel resource. Gets a list of available VPN tunnels by making a list() request.

      Args:
        request: (ComputeVpnTunnelsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnTunnel) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.vpnTunnels.get',
        ordered_params=[u'project', u'region', u'vpnTunnel'],
        path_params=[u'project', u'region', u'vpnTunnel'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}',
        request_field='',
        request_type_name=u'ComputeVpnTunnelsGetRequest',
        response_type_name=u'VpnTunnel',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a VpnTunnel resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeVpnTunnelsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.vpnTunnels.insert',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/vpnTunnels',
        request_field=u'vpnTunnel',
        request_type_name=u'ComputeVpnTunnelsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of VpnTunnel resources contained in the specified project and region.

      Args:
        request: (ComputeVpnTunnelsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnTunnelList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.vpnTunnels.list',
        ordered_params=[u'project', u'region'],
        path_params=[u'project', u'region'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/regions/{region}/vpnTunnels',
        request_field='',
        request_type_name=u'ComputeVpnTunnelsListRequest',
        response_type_name=u'VpnTunnelList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a VpnTunnel. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeVpnTunnelsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.vpnTunnels.setLabels',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[u'requestId'],
        relative_path=u'projects/{project}/regions/{region}/vpnTunnels/{resource}/setLabels',
        request_field=u'regionSetLabelsRequest',
        request_type_name=u'ComputeVpnTunnelsSetLabelsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeVpnTunnelsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'compute.vpnTunnels.testIamPermissions',
        ordered_params=[u'project', u'region', u'resource'],
        path_params=[u'project', u'region', u'resource'],
        query_params=[],
        relative_path=u'projects/{project}/regions/{region}/vpnTunnels/{resource}/testIamPermissions',
        request_field=u'testPermissionsRequest',
        request_type_name=u'ComputeVpnTunnelsTestIamPermissionsRequest',
        response_type_name=u'TestPermissionsResponse',
        supports_download=False,
    )

  class ZoneOperationsService(base_api.BaseApiService):
    """Service class for the zoneOperations resource."""

    _NAME = u'zoneOperations'

    def __init__(self, client):
      super(ComputeBeta.ZoneOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified zone-specific Operations resource.

      Args:
        request: (ComputeZoneOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeZoneOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'compute.zoneOperations.delete',
        ordered_params=[u'project', u'zone', u'operation'],
        path_params=[u'operation', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/operations/{operation}',
        request_field='',
        request_type_name=u'ComputeZoneOperationsDeleteRequest',
        response_type_name=u'ComputeZoneOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified zone-specific Operations resource.

      Args:
        request: (ComputeZoneOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.zoneOperations.get',
        ordered_params=[u'project', u'zone', u'operation'],
        path_params=[u'operation', u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}/operations/{operation}',
        request_field='',
        request_type_name=u'ComputeZoneOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified zone.

      Args:
        request: (ComputeZoneOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.zoneOperations.list',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones/{zone}/operations',
        request_field='',
        request_type_name=u'ComputeZoneOperationsListRequest',
        response_type_name=u'OperationList',
        supports_download=False,
    )

  class ZonesService(base_api.BaseApiService):
    """Service class for the zones resource."""

    _NAME = u'zones'

    def __init__(self, client):
      super(ComputeBeta.ZonesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified Zone resource. Gets a list of available zones by making a list() request.

      Args:
        request: (ComputeZonesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Zone) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.zones.get',
        ordered_params=[u'project', u'zone'],
        path_params=[u'project', u'zone'],
        query_params=[],
        relative_path=u'projects/{project}/zones/{zone}',
        request_field='',
        request_type_name=u'ComputeZonesGetRequest',
        response_type_name=u'Zone',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Zone resources available to the specified project.

      Args:
        request: (ComputeZonesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ZoneList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'compute.zones.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'orderBy', u'pageToken'],
        relative_path=u'projects/{project}/zones',
        request_field='',
        request_type_name=u'ComputeZonesListRequest',
        response_type_name=u'ZoneList',
        supports_download=False,
    )
