"""Generated message classes for domains version v1alpha1.

API to register and manage domains in Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'domains'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuthorizationLoggingOptions(_messages.Message):
  r"""Authorization-related information used by Cloud Audit Logging.

  Enums:
    PermissionTypeValueValuesEnum: The type of the permission that was
      checked.

  Fields:
    permissionType: The type of the permission that was checked.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the permission that was checked.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: A read of admin (meta) data.
      ADMIN_WRITE: A write of admin (meta) data.
      DATA_READ: A read of standard data.
      DATA_WRITE: A write of standard data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: Unimplemented. The condition that is associated with this
      binding. NOTE: an unsatisfied condition will not allow user access via
      current binding. Different bindings, including their conditions, are
      examined independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CheckDomainAvailabilityResponse(_messages.Message):
  r"""A CheckDomainAvailabilityResponse object.

  Fields:
    availability: A DomainAvailability attribute.
  """

  availability = _messages.MessageField('DomainAvailability', 1)


class CloudAuditOptions(_messages.Message):
  r"""Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.

  Fields:
    authorizationLoggingOptions: Information used by the Cloud Audit Logging
      pipeline.
    logName: The log_name to populate in the Cloud Audit Record.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    r"""The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  authorizationLoggingOptions = _messages.MessageField('AuthorizationLoggingOptions', 1)
  logName = _messages.EnumField('LogNameValueValuesEnum', 2)


class Condition(_messages.Message):
  r"""A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    values: The objects of the condition.
  """

  class IamValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      SECURITY_REALM: Any of the security realms in the IAMContext (go
        /security-realms). When used with IN, the condition indicates "any of
        the request's realms match one of the given values; with NOT_IN, "none
        of the realms match any of the given values". Note that a value can
        be:  - 'self' (i.e., allow connections from clients that are in the
        same  security realm)  - a realm (e.g., 'campus-abc')  - a realm group
        (e.g., 'realms-for-borg-cell-xx', see: go/realm-groups) A match is
        determined by a realm group membership check performed by a
        RealmAclRep object (go/realm-acl-howto). It is not permitted to grant
        access based on the *absence* of a realm, so realm conditions can only
        be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        tech.iam.JustificationType, e.g. "MANUAL_STRING". It is not permitted
        to grant access based on the *absence* of a justification, so
        justification conditions can only be used in a "positive" context
        (e.g., ALLOW/IN or DENY/NOT_IN).  Multiple justifications, e.g., a
        Buganizer ID and a manually-entered reason, are normal and supported.
      CREDENTIALS_TYPE: What type of credentials have been supplied with this
        request. String values should match enum names from
        security_loas_l2.CredentialsType - currently, only
        CREDS_TYPE_EMERGENCY is supported. It is not permitted to grant access
        based on the *absence* of a credentials type, so the conditions can
        only be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    SECURITY_REALM = 3
    APPROVER = 4
    JUSTIFICATION_TYPE = 5
    CREDENTIALS_TYPE = 6

  class OpValueValuesEnum(_messages.Enum):
    r"""An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by any service that owns resources and
    uses the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  values = _messages.StringField(5, repeated=True)


class CounterOptions(_messages.Message):
  r"""Increment a streamz counter with the specified metric and field names.
  Metric names should start with a '/', generally be lowercase-only, and end
  in "_count". Field names should not contain an initial slash. The actual
  exported metric names will have "/iam/policy" prepended.  Field names
  correspond to IAM request parameters and field values are their respective
  values.  Supported field names:    - "authority", which is "[token]" if
  IAMContext.token is present,      otherwise the value of
  IAMContext.authority_selector if present, and      otherwise a
  representation of IAMContext.principal; or    - "iam_principal", a
  representation of IAMContext.principal even if a      token or authority
  selector is present; or    - "" (empty string), resulting in a counter with
  no fields.  Examples:   counter { metric: "/debug_access_count"  field:
  "iam_principal" }   ==> increment counter
  /iam/policy/backend_debug_access_count
  {iam_principal=[value of IAMContext.principal]}  At this time we do not
  support multiple field names (though this may be supported in the future).

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class DataAccessOptions(_messages.Message):
  r"""Write a Data Access (Gin) log

  Enums:
    LogModeValueValuesEnum: Whether Gin logging should happen in a fail-closed
      manner at the caller. This is relevant only in the LocalIAM
      implementation, for now.  NOTE: Logging to Gin in a fail-closed manner
      is currently unsupported while work is being done to satisfy the
      requirements of go/345. Currently, setting LOG_FAIL_CLOSED mode will
      have no effect, but still exists because there is active work being done
      to support it (b/115874152).

  Fields:
    logMode: Whether Gin logging should happen in a fail-closed manner at the
      caller. This is relevant only in the LocalIAM implementation, for now.
      NOTE: Logging to Gin in a fail-closed manner is currently unsupported
      while work is being done to satisfy the requirements of go/345.
      Currently, setting LOG_FAIL_CLOSED mode will have no effect, but still
      exists because there is active work being done to support it
      (b/115874152).
  """

  class LogModeValueValuesEnum(_messages.Enum):
    r"""Whether Gin logging should happen in a fail-closed manner at the
    caller. This is relevant only in the LocalIAM implementation, for now.
    NOTE: Logging to Gin in a fail-closed manner is currently unsupported
    while work is being done to satisfy the requirements of go/345. Currently,
    setting LOG_FAIL_CLOSED mode will have no effect, but still exists because
    there is active work being done to support it (b/115874152).

    Values:
      LOG_MODE_UNSPECIFIED: Client is not required to write a partial Gin log
        immediately after the authorization check. If client chooses to write
        one and it fails, client may either fail open (allow the operation to
        continue) or fail closed (handle as a DENY outcome).
      LOG_FAIL_CLOSED: The application's operation in the context of which
        this authorization check is being made may only be performed if it is
        successfully logged to Gin. For instance, the authorization library
        may satisfy this obligation by emitting a partial log entry at
        authorization check time and only returning ALLOW to the application
        if it succeeds.  If a matching Rule has this directive, but the client
        has not indicated that it will honor such requirements, then the IAM
        check will result in authorization failure by setting
        CheckPolicyResponse.success=false.  NOTE: This is currently
        unsupported. See the note on LogMode below. LOG_FAIL_CLOSED shouldn't
        be used unless the application wants fail-closed logging to be turned
        on implicitly when b/115874152 is resolved.
    """
    LOG_MODE_UNSPECIFIED = 0
    LOG_FAIL_CLOSED = 1

  logMode = _messages.EnumField('LogModeValueValuesEnum', 1)


class DetachRegistrationRequest(_messages.Message):
  r"""A DetachRegistrationRequest object."""


class DnsConfig(_messages.Message):
  r"""A DnsConfig object.

  Fields:
    nameServers: A string attribute.
  """

  nameServers = _messages.StringField(1, repeated=True)


class DomainAvailability(_messages.Message):
  r"""A DomainAvailability object.

  Enums:
    AvailableValueValuesEnum:
    NoticesValueListEntryValuesEnum:
    SupportedWhoisPrivacyValueListEntryValuesEnum:

  Fields:
    available: A AvailableValueValuesEnum attribute.
    domainName: A string attribute.
    notices: A NoticesValueListEntryValuesEnum attribute.
    registrationPrice: A Money attribute.
    renewalPrice: A Money attribute.
    supportedWhoisPrivacy: A SupportedWhoisPrivacyValueListEntryValuesEnum
      attribute.
  """

  class AvailableValueValuesEnum(_messages.Enum):
    r"""AvailableValueValuesEnum enum type.

    Values:
      AVAILABILITY_UNSPECIFIED: The system might return
        AVAILABILITY_UNSPECIFIED if something prevents the service from being
        able to determine availability.
      AVAILABLE: Domain is available for registration.
      UNAVAILABLE: Domain is not available for registration, e.g. registered
        by someone else.
      UNSUPPORTED: Domain is not supported by Cloud Domains, but may be
        available elsewhere.
    """
    AVAILABILITY_UNSPECIFIED = 0
    AVAILABLE = 1
    UNAVAILABLE = 2
    UNSUPPORTED = 3

  class NoticesValueListEntryValuesEnum(_messages.Enum):
    r"""NoticesValueListEntryValuesEnum enum type.

    Values:
      NOTICE_UNSPECIFIED: <no description>
      HSTS_PRELOADED: <no description>
    """
    NOTICE_UNSPECIFIED = 0
    HSTS_PRELOADED = 1

  class SupportedWhoisPrivacyValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedWhoisPrivacyValueListEntryValuesEnum enum type.

    Values:
      WHOIS_PRIVACY_UNSPECIFIED: <no description>
      PUBLISH_CONTACT_DATA: <no description>
      USE_WHOIS_PRIVACY_PROXY: <no description>
      PUBLISH_REDACTED_CONTACT_DATA: <no description>
    """
    WHOIS_PRIVACY_UNSPECIFIED = 0
    PUBLISH_CONTACT_DATA = 1
    USE_WHOIS_PRIVACY_PROXY = 2
    PUBLISH_REDACTED_CONTACT_DATA = 3

  available = _messages.EnumField('AvailableValueValuesEnum', 1)
  domainName = _messages.StringField(2)
  notices = _messages.EnumField('NoticesValueListEntryValuesEnum', 3, repeated=True)
  registrationPrice = _messages.MessageField('Money', 4)
  renewalPrice = _messages.MessageField('Money', 5)
  supportedWhoisPrivacy = _messages.EnumField('SupportedWhoisPrivacyValueListEntryValuesEnum', 6, repeated=True)


class DomainsProjectsLocationsGetRequest(_messages.Message):
  r"""A DomainsProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class DomainsProjectsLocationsListRequest(_messages.Message):
  r"""A DomainsProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DomainsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A DomainsProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DomainsProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A DomainsProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DomainsProjectsLocationsRegistrationsCheckAvailabilityRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsCheckAvailabilityRequest object.

  Fields:
    domainName: A string attribute.
    parent: A string attribute.
  """

  domainName = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class DomainsProjectsLocationsRegistrationsCreateRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsCreateRequest object.

  Fields:
    parent: A string attribute.
    registration: A Registration resource to be passed as the request body.
    validateOnly: When true, only validation will be performed, without
      actually registering the domain. Follows:
      https://cloud.google.com/apis/design/design_patterns#request_validation
  """

  parent = _messages.StringField(1, required=True)
  registration = _messages.MessageField('Registration', 2)
  validateOnly = _messages.BooleanField(3)


class DomainsProjectsLocationsRegistrationsDeleteRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsDeleteRequest object.

  Fields:
    name: A string attribute.
  """

  name = _messages.StringField(1, required=True)


class DomainsProjectsLocationsRegistrationsDetachRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsDetachRequest object.

  Fields:
    detachRegistrationRequest: A DetachRegistrationRequest resource to be
      passed as the request body.
    name: A string attribute.
  """

  detachRegistrationRequest = _messages.MessageField('DetachRegistrationRequest', 1)
  name = _messages.StringField(2, required=True)


class DomainsProjectsLocationsRegistrationsGetIamPolicyRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsGetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class DomainsProjectsLocationsRegistrationsGetRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsGetRequest object.

  Fields:
    name: A string attribute.
  """

  name = _messages.StringField(1, required=True)


class DomainsProjectsLocationsRegistrationsListRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsListRequest object.

  Fields:
    filter: A string attribute.
    pageSize: A integer attribute.
    pageToken: A string attribute.
    parent: A string attribute.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DomainsProjectsLocationsRegistrationsPatchRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsPatchRequest object.

  Fields:
    name: A string attribute.
    registration: A Registration resource to be passed as the request body.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask Required.
    validateOnly: When true, only validation will be performed, without
      actually updating the domain. Follows:
      https://cloud.google.com/apis/design/design_patterns#request_validation
  """

  name = _messages.StringField(1, required=True)
  registration = _messages.MessageField('Registration', 2)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DomainsProjectsLocationsRegistrationsSearchAvailabilityRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsSearchAvailabilityRequest object.

  Fields:
    parent: A string attribute.
    query: A string attribute.
  """

  parent = _messages.StringField(1, required=True)
  query = _messages.StringField(2)


class DomainsProjectsLocationsRegistrationsSetIamPolicyRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DomainsProjectsLocationsRegistrationsTestIamPermissionsRequest(_messages.Message):
  r"""A DomainsProjectsLocationsRegistrationsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRegistrationsResponse(_messages.Message):
  r"""A ListRegistrationsResponse object.

  Fields:
    nextPageToken: A string attribute.
    registrations: A Registration attribute.
  """

  nextPageToken = _messages.StringField(1)
  registrations = _messages.MessageField('Registration', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LogConfig(_messages.Message):
  r"""Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class Money(_messages.Message):
  r"""Represents an amount of money with its currency type.

  Fields:
    currencyCode: The 3-letter currency code defined in ISO 4217.
    nanos: Number of nano (10^-9) units of the amount. The value must be
      between -999,999,999 and +999,999,999 inclusive. If `units` is positive,
      `nanos` must be positive or zero. If `units` is zero, `nanos` can be
      positive, zero, or negative. If `units` is negative, `nanos` must be
      negative or zero. For example $-1.75 is represented as `units`=-1 and
      `nanos`=-750,000,000.
    units: The whole units of the amount. For example if `currencyCode` is
      `"USD"`, then 1 unit is one US dollar.
  """

  currencyCode = _messages.StringField(1)
  nanos = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  units = _messages.IntegerField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    statusDetail: Output only. Human-readable status of the operation, if any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  statusDetail = _messages.StringField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied.   Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is   granted.
      Logging will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class PostalAddress(_messages.Message):
  r"""Represents a postal address, e.g. for postal delivery or payments
  addresses. Given a postal address, a postal service can deliver items to a
  premise, P.O. Box or similar. It is not intended to model geographical
  locations (roads, towns, mountains).  In typical usage an address would be
  created via user input or from importing existing data, depending on the
  type of process.  Advice on address input / editing:  - Use an i18n-ready
  address widget such as    https://github.com/googlei18n/libaddressinput) -
  Users should not be presented with UI elements for input or editing of
  fields outside countries where that field is used.  For more guidance on how
  to use this schema, please see:
  https://support.google.com/business/answer/6397478

  Fields:
    addressLines: Unstructured address lines describing the lower levels of an
      address.  Because values in address_lines do not have type information
      and may sometimes contain multiple values in a single field (e.g.
      "Austin, TX"), it is important that the line order is clear. The order
      of address lines should be "envelope order" for the country/region of
      the address. In places where this can vary (e.g. Japan),
      address_language is used to make it explicit (e.g. "ja" for large-to-
      small ordering and "ja-Latn" or "en" for small-to-large). This way, the
      most specific line of an address can be selected based on the language.
      The minimum permitted structural representation of an address consists
      of a region_code with all remaining information placed in the
      address_lines. It would be possible to format such an address very
      approximately without geocoding, but no semantic reasoning could be made
      about any of the address components until it was at least partially
      resolved.  Creating an address only containing a region_code and
      address_lines, and then geocoding is the recommended way to handle
      completely unstructured addresses (as opposed to guessing which parts of
      the address should be localities or administrative areas).
    administrativeArea: Optional. Highest administrative subdivision which is
      used for postal addresses of a country or region. For example, this can
      be a state, a province, an oblast, or a prefecture. Specifically, for
      Spain this is the province and not the autonomous community (e.g.
      "Barcelona" and not "Catalonia"). Many countries don't use an
      administrative area in postal addresses. E.g. in Switzerland this should
      be left unpopulated.
    languageCode: Optional. BCP-47 language code of the contents of this
      address (if known). This is often the UI language of the input form or
      is expected to match one of the languages used in the address'
      country/region, or their transliterated equivalents. This can affect
      formatting in certain countries, but is not critical to the correctness
      of the data and will never affect any validation or other non-formatting
      related operations.  If this value is not known, it should be omitted
      (rather than specifying a possibly incorrect default).  Examples: "zh-
      Hant", "ja", "ja-Latn", "en".
    locality: Optional. Generally refers to the city/town portion of the
      address. Examples: US city, IT comune, UK post town. In regions of the
      world where localities are not well defined or do not fit into this
      structure well, leave locality empty and use address_lines.
    organization: Optional. The name of the organization at the address.
    postalCode: Optional. Postal code of the address. Not all countries use or
      require postal codes to be present, but where they are used, they may
      trigger additional validation with other parts of the address (e.g.
      state/zip validation in the U.S.A.).
    recipients: Optional. The recipient at the address. This field may, under
      certain circumstances, contain multiline information. For example, it
      might contain "care of" information.
    regionCode: Required. CLDR region code of the country/region of the
      address. This is never inferred and it is up to the user to ensure the
      value is correct. See http://cldr.unicode.org/ and http://www.unicode.or
      g/cldr/charts/30/supplemental/territory_information.html for details.
      Example: "CH" for Switzerland.
    revision: The schema revision of the `PostalAddress`. This must be set to
      0, which is the latest revision.  All new revisions **must** be backward
      compatible with old revisions.
    sortingCode: Optional. Additional, country-specific, sorting code. This is
      not used in most regions. Where it is used, the value is either a string
      like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just
      a number alone, representing the "sector code" (Jamaica), "delivery area
      indicator" (Malawi) or "post office indicator" (e.g. C\xf4te d'Ivoire).
    sublocality: Optional. Sublocality of the address. For example, this can
      be neighborhoods, boroughs, districts.
  """

  addressLines = _messages.StringField(1, repeated=True)
  administrativeArea = _messages.StringField(2)
  languageCode = _messages.StringField(3)
  locality = _messages.StringField(4)
  organization = _messages.StringField(5)
  postalCode = _messages.StringField(6)
  recipients = _messages.StringField(7, repeated=True)
  regionCode = _messages.StringField(8)
  revision = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  sortingCode = _messages.StringField(10)
  sublocality = _messages.StringField(11)


class Registration(_messages.Message):
  r"""A Registration object.

  Enums:
    NoticesValueListEntryValuesEnum:
    StateValueValuesEnum:

  Messages:
    LabelsValue: A LabelsValue object.

  Fields:
    createTime: A string attribute.
    detachTime: A string attribute.
    dnsConfig: A DnsConfig attribute.
    domainName: A string attribute.
    expireTime: A string attribute.
    labels: A LabelsValue attribute.
    name: A string attribute.
    notices: [Create only] List of accepted Notices about the domain. Needed
      e.g. for accepting the HSTS notice when registering .app domains. The
      list of notices for each domain can be retrieved with
      CheckDomainAvailability call.
    registrationPrice: [Create only] Registration price. Required for
      confirmation of the price when creating new registration. Price that
      should be put here can be obtained from CheckAvailability or
      SearchAvailability calls.
    renewalPrice: [Create only] Renewal price. Required for confirmation of
      the price when creating new registration. Renewal price that should be
      put here can be obtained from CheckAvailability or SearchAvailability
      calls.
    state: A StateValueValuesEnum attribute.
    updateTime: A string attribute.
    whoisConfig: A WhoisConfig attribute.
  """

  class NoticesValueListEntryValuesEnum(_messages.Enum):
    r"""NoticesValueListEntryValuesEnum enum type.

    Values:
      NOTICE_UNSPECIFIED: <no description>
      HSTS_PRELOADED: <no description>
    """
    NOTICE_UNSPECIFIED = 0
    HSTS_PRELOADED = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""StateValueValuesEnum enum type.

    Values:
      STATE_UNSPECIFIED: <no description>
      PROVISIONING: The registration operation is not yet completed.
      ACTIVE: The domain is registered and operational. It will automatically
        renew around expire_time.
      SUSPENDED: The registration is suspended and the domain is inaccessible.
        This probably means that the registrant email has not been verified.
        Check the emails received from the registrar and follow the provided
        steps.
      TRANSFERRED: The registration has been automatically detached from Cloud
        and transferred directly to Google Domains for individual management.
        This can happen if, for example, your billing account is inactive
        during renewal. The domain will remain valid until it expires and
        during that period you'll be able to reclaim it at
        https://domains.google.com/ using WHOIS contact information. For more
        information, see https://support.google.com/domains/answer/6339340.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    ACTIVE = 2
    SUSPENDED = 3
    TRANSFERRED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""A LabelsValue object.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  detachTime = _messages.StringField(2)
  dnsConfig = _messages.MessageField('DnsConfig', 3)
  domainName = _messages.StringField(4)
  expireTime = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  notices = _messages.EnumField('NoticesValueListEntryValuesEnum', 8, repeated=True)
  registrationPrice = _messages.MessageField('Money', 9)
  renewalPrice = _messages.MessageField('Money', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  updateTime = _messages.StringField(12)
  whoisConfig = _messages.MessageField('WhoisConfig', 13)


class Rule(_messages.Message):
  r"""A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met. All conditions must
      pass for the rule to match.
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries can be found at in the Local IAM documentation
      (see go/local-iam#features).
    permissions: A permission is a string of form '<service>.<resource
      type>.<verb>' (e.g., 'storage.buckets.list'). A value of '*' matches all
      permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches
      all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class SearchDomainAvailabilityResponse(_messages.Message):
  r"""A SearchDomainAvailabilityResponse object.

  Fields:
    availability: A DomainAvailability attribute.
  """

  availability = _messages.MessageField('DomainAvailability', 1, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class WhoisConfig(_messages.Message):
  r"""A WhoisConfig object.

  Enums:
    PrivacyValueValuesEnum:

  Fields:
    privacy: A PrivacyValueValuesEnum attribute.
    registrantContact: A WhoisContact attribute.
  """

  class PrivacyValueValuesEnum(_messages.Enum):
    r"""PrivacyValueValuesEnum enum type.

    Values:
      WHOIS_PRIVACY_UNSPECIFIED: <no description>
      PUBLISH_CONTACT_DATA: All the data from WHOIS config is publicly
        available (not supported yet).
      USE_WHOIS_PRIVACY_PROXY: Your contact info won't be available to the
        public. To help protect your info and prevent spam, a third party
        provides alternate contact info for your domain in the WHOIS directory
        at no extra cost.
      PUBLISH_REDACTED_CONTACT_DATA: Limited personal info will be available
        to the public. The actual information redacted depends on the domain.
    """
    WHOIS_PRIVACY_UNSPECIFIED = 0
    PUBLISH_CONTACT_DATA = 1
    USE_WHOIS_PRIVACY_PROXY = 2
    PUBLISH_REDACTED_CONTACT_DATA = 3

  privacy = _messages.EnumField('PrivacyValueValuesEnum', 1)
  registrantContact = _messages.MessageField('WhoisContact', 2)


class WhoisContact(_messages.Message):
  r"""A WhoisContact object.

  Fields:
    email: A string attribute.
    phoneNumber: A string attribute.
    postalAddress: A PostalAddress attribute.
  """

  email = _messages.StringField(1)
  phoneNumber = _messages.StringField(2)
  postalAddress = _messages.MessageField('PostalAddress', 3)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
