"""Generated client library for datacatalog version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.datacatalog.v1beta1 import datacatalog_v1beta1_messages as messages


class DatacatalogV1beta1(base_api.BaseApiClient):
  """Generated client library for service datacatalog version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://datacatalog.googleapis.com/'

  _PACKAGE = u'datacatalog'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'DatacatalogV1beta1'
  _URL_VERSION = u'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new datacatalog handle."""
    url = url or self.BASE_URL
    super(DatacatalogV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.catalog = self.CatalogService(self)
    self.entries = self.EntriesService(self)
    self.projects_datasets_entries_tags = self.ProjectsDatasetsEntriesTagsService(self)
    self.projects_datasets_entries = self.ProjectsDatasetsEntriesService(self)
    self.projects_datasets = self.ProjectsDatasetsService(self)
    self.projects_tagTemplates = self.ProjectsTagTemplatesService(self)
    self.projects = self.ProjectsService(self)

  class CatalogService(base_api.BaseApiService):
    """Service class for the catalog resource."""

    _NAME = u'catalog'

    def __init__(self, client):
      super(DatacatalogV1beta1.CatalogService, self).__init__(client)
      self._upload_configs = {
          }

    def Search(self, request, global_params=None):
      r"""Searches Cloud Data Catalog for multiple resources like entries, tags that.
match a query.

This API is a custom method
(https://cloud.google.com/apis/design/custom_methods), and does not return
the complete resource, only the resource identifier and high level
fields. Clients can subsequentally call Get APIs.

See [Cloud Data Catalog Search
Syntax](/data-catalog/docs/how-to/search-reference)

      Args:
        request: (DatacatalogCatalogSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1SearchCatalogResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'datacatalog.catalog.search',
        ordered_params=[],
        path_params=[],
        query_params=[u'orderBy', u'pageSize', u'pageToken', u'query'],
        relative_path=u'v1beta1/catalog:search',
        request_field='',
        request_type_name=u'DatacatalogCatalogSearchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1SearchCatalogResponse',
        supports_download=False,
    )

  class EntriesService(base_api.BaseApiService):
    """Service class for the entries resource."""

    _NAME = u'entries'

    def __init__(self, client):
      super(DatacatalogV1beta1.EntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Lookup(self, request, global_params=None):
      r"""Get an entry by Resource name.

      Args:
        request: (DatacatalogEntriesLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Entry) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'datacatalog.entries.lookup',
        ordered_params=[],
        path_params=[],
        query_params=[u'fullResourceName'],
        relative_path=u'v1beta1/entries:lookup',
        request_field='',
        request_type_name=u'DatacatalogEntriesLookupRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Entry',
        supports_download=False,
    )

  class ProjectsDatasetsEntriesTagsService(base_api.BaseApiService):
    """Service class for the projects_datasets_entries_tags resource."""

    _NAME = u'projects_datasets_entries_tags'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsDatasetsEntriesTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a Tag on an Entry.

      Args:
        request: (DatacatalogProjectsDatasetsEntriesTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Tag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/datasets/{datasetsId}/entries/{entriesId}/tags',
        http_method=u'POST',
        method_id=u'datacatalog.projects.datasets.entries.tags.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/tags',
        request_field=u'googleCloudDatacatalogV1beta1CreateTagRequest',
        request_type_name=u'DatacatalogProjectsDatasetsEntriesTagsCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Tag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a tag.

      Args:
        request: (DatacatalogProjectsDatasetsEntriesTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/datasets/{datasetsId}/entries/{entriesId}/tags/{tagsId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.datasets.entries.tags.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsDatasetsEntriesTagsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List tags on an entry.

      Args:
        request: (DatacatalogProjectsDatasetsEntriesTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ListTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/datasets/{datasetsId}/entries/{entriesId}/tags',
        http_method=u'GET',
        method_id=u'datacatalog.projects.datasets.entries.tags.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'fullResourceName', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/tags',
        request_field='',
        request_type_name=u'DatacatalogProjectsDatasetsEntriesTagsListRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ListTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update an existing tag.

      Args:
        request: (DatacatalogProjectsDatasetsEntriesTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1Tag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/datasets/{datasetsId}/entries/{entriesId}/tags/{tagsId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.datasets.entries.tags.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1UpdateTagRequest',
        request_type_name=u'DatacatalogProjectsDatasetsEntriesTagsPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1Tag',
        supports_download=False,
    )

  class ProjectsDatasetsEntriesService(base_api.BaseApiService):
    """Service class for the projects_datasets_entries resource."""

    _NAME = u'projects_datasets_entries'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsDatasetsEntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error.
is returned if the resource does not exist. An empty policy is returned
if the resource exists but does not have a policy set on it.

Supported resource are :- Tag Templates.
Note, this API cannot be used to manage policies for BigQuery, Pub/Sub and
any external GCP resources synced to Cloud Data Catalog.

Caller must have Google IAM `datacatalog.tagTemplates.getIamPolicy`
permission on the tag template resource.

      Args:
        request: (DatacatalogProjectsDatasetsEntriesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/datasets/{datasetsId}/entries/{entriesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.datasets.entries.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsDatasetsEntriesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists entries.

      Args:
        request: (DatacatalogProjectsDatasetsEntriesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1ListEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/datasets/{datasetsId}/entries',
        http_method=u'GET',
        method_id=u'datacatalog.projects.datasets.entries.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/entries',
        request_field='',
        request_type_name=u'DatacatalogProjectsDatasetsEntriesListRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1ListEntriesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy for a resource. Replaces any existing.
policy.
Supported resources are :- Tag Templates.
Note, this API cannot be used to manage policies for BigQuery, Pub/Sub and
any external GCP resources synced to Cloud Data Catalog.

Callers must have Google IAM `datacatalog.tagTemplates.setIamPolicy` to
set set policy on tag templates.

      Args:
        request: (DatacatalogProjectsDatasetsEntriesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/datasets/{datasetsId}/entries/{entriesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.datasets.entries.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsDatasetsEntriesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

  class ProjectsDatasetsService(base_api.BaseApiService):
    """Service class for the projects_datasets resource."""

    _NAME = u'projects_datasets'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsDatasetsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsTagTemplatesService(base_api.BaseApiService):
    """Service class for the projects_tagTemplates resource."""

    _NAME = u'projects_tagTemplates'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsTagTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a tag template.

      Args:
        request: (DatacatalogProjectsTagTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/tagTemplates',
        http_method=u'POST',
        method_id=u'datacatalog.projects.tagTemplates.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/tagTemplates',
        request_field=u'googleCloudDatacatalogV1beta1CreateTagTemplateRequest',
        request_type_name=u'DatacatalogProjectsTagTemplatesCreateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a tag template and all of that template's uses.

      Args:
        request: (DatacatalogProjectsTagTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/tagTemplates/{tagTemplatesId}',
        http_method=u'DELETE',
        method_id=u'datacatalog.projects.tagTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsTagTemplatesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a tag template.

      Args:
        request: (DatacatalogProjectsTagTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/tagTemplates/{tagTemplatesId}',
        http_method=u'GET',
        method_id=u'datacatalog.projects.tagTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'DatacatalogProjectsTagTemplatesGetRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error.
is returned if the resource does not exist. An empty policy is returned
if the resource exists but does not have a policy set on it.

Supported resource are :- Tag Templates.
Note, this API cannot be used to manage policies for BigQuery, Pub/Sub and
any external GCP resources synced to Cloud Data Catalog.

Caller must have Google IAM `datacatalog.tagTemplates.getIamPolicy`
permission on the tag template resource.

      Args:
        request: (DatacatalogProjectsTagTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/tagTemplates/{tagTemplatesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.tagTemplates.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsTagTemplatesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Mutate(self, request, global_params=None):
      r"""Mutates the fields of a tag template. This API can only modify the fields.
of a template. To modify anything else, use UpdateTagTemplate.

      Args:
        request: (DatacatalogProjectsTagTemplatesMutateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Mutate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Mutate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/tagTemplates/{tagTemplatesId}:mutate',
        http_method=u'POST',
        method_id=u'datacatalog.projects.tagTemplates.mutate',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:mutate',
        request_field=u'googleCloudDatacatalogV1beta1MutateTagTemplateRequest',
        request_type_name=u'DatacatalogProjectsTagTemplatesMutateRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplate',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a tag template. This API cannot be used to update the fields of a.
template (add/remove/change a field) -- use MutateTagTemplate to modify
fields.

      Args:
        request: (DatacatalogProjectsTagTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1beta1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/tagTemplates/{tagTemplatesId}',
        http_method=u'PATCH',
        method_id=u'datacatalog.projects.tagTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'googleCloudDatacatalogV1beta1TagTemplate',
        request_type_name=u'DatacatalogProjectsTagTemplatesPatchRequest',
        response_type_name=u'GoogleCloudDatacatalogV1beta1TagTemplate',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy for a resource. Replaces any existing.
policy.
Supported resources are :- Tag Templates.
Note, this API cannot be used to manage policies for BigQuery, Pub/Sub and
any external GCP resources synced to Cloud Data Catalog.

Callers must have Google IAM `datacatalog.tagTemplates.setIamPolicy` to
set set policy on tag templates.

      Args:
        request: (DatacatalogProjectsTagTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/tagTemplates/{tagTemplatesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datacatalog.projects.tagTemplates.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatacatalogProjectsTagTemplatesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(DatacatalogV1beta1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
