"""Generated message classes for genomics version v1.

Uploads, processes, queries, and searches Genomics data in the cloud.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'genomics'


class Annotation(_messages.Message):
  r"""An annotation describes a region of reference genome. The value of an
  annotation may be one of several canonical types, supplemented by arbitrary
  info tags. An annotation is not inherently associated with a specific sample
  or individual (though a client could choose to use annotations in this way).
  Example canonical annotation types are `GENE` and `VARIANT`.

  Enums:
    TypeValueValuesEnum: The data type for this annotation. Must match the
      containing annotation set's type.

  Messages:
    InfoValue: A map of additional read alignment information. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    annotationSetId: The annotation set to which this annotation belongs.
    end: The end position of the range on the reference, 0-based exclusive.
    id: The server-generated annotation ID, unique across all annotations.
    info: A map of additional read alignment information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    name: The display name of this annotation.
    referenceId: The ID of the Google Genomics reference associated with this
      range.
    referenceName: The display name corresponding to the reference specified
      by `referenceId`, for example `chr1`, `1`, or `chrX`.
    reverseStrand: Whether this range refers to the reverse strand, as opposed
      to the forward strand. Note that regardless of this field, the start/end
      position of the range always refer to the forward strand.
    start: The start position of the range on the reference, 0-based
      inclusive.
    transcript: A transcript value represents the assertion that a particular
      region of the reference genome may be transcribed as RNA. An alternative
      splicing pattern would be represented as a separate transcript object.
      This field is only set for annotations of type `TRANSCRIPT`.
    type: The data type for this annotation. Must match the containing
      annotation set's type.
    variant: A variant annotation, which describes the effect of a variant on
      the genome, the coding sequence, and/or higher level consequences at the
      organism level e.g. pathogenicity. This field is only set for
      annotations of type `VARIANT`.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The data type for this annotation. Must match the containing
    annotation set's type.

    Values:
      ANNOTATION_TYPE_UNSPECIFIED: <no description>
      GENERIC: A `GENERIC` annotation type should be used when no other
        annotation type will suffice. This represents an untyped annotation of
        the reference genome.
      VARIANT: A `VARIANT` annotation type.
      GENE: A `GENE` annotation type represents the existence of a gene at the
        associated reference coordinates. The start coordinate is typically
        the gene's transcription start site and the end is typically the end
        of the gene's last exon.
      TRANSCRIPT: A `TRANSCRIPT` annotation type represents the assertion that
        a particular region of the reference genome may be transcribed as RNA.
    """
    ANNOTATION_TYPE_UNSPECIFIED = 0
    GENERIC = 1
    VARIANT = 2
    GENE = 3
    TRANSCRIPT = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional read alignment information. This must be of the
    form map<string, string[]> (string key mapping to a list of string
    values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationSetId = _messages.StringField(1)
  end = _messages.IntegerField(2)
  id = _messages.StringField(3)
  info = _messages.MessageField('InfoValue', 4)
  name = _messages.StringField(5)
  referenceId = _messages.StringField(6)
  referenceName = _messages.StringField(7)
  reverseStrand = _messages.BooleanField(8)
  start = _messages.IntegerField(9)
  transcript = _messages.MessageField('Transcript', 10)
  type = _messages.EnumField('TypeValueValuesEnum', 11)
  variant = _messages.MessageField('VariantAnnotation', 12)


class AnnotationSet(_messages.Message):
  r"""An annotation set is a logical grouping of annotations that share
  consistent type information and provenance. Examples of annotation sets
  include 'all genes from refseq', and 'all variant annotations from ClinVar'.

  Enums:
    TypeValueValuesEnum: The type of annotations contained within this set.

  Messages:
    InfoValue: A map of additional read alignment information. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    datasetId: The dataset to which this annotation set belongs.
    id: The server-generated annotation set ID, unique across all annotation
      sets.
    info: A map of additional read alignment information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    name: The display name for this annotation set.
    referenceSetId: The ID of the reference set that defines the coordinate
      space for this set's annotations.
    sourceUri: The source URI describing the file from which this annotation
      set was generated, if any.
    type: The type of annotations contained within this set.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of annotations contained within this set.

    Values:
      ANNOTATION_TYPE_UNSPECIFIED: <no description>
      GENERIC: A `GENERIC` annotation type should be used when no other
        annotation type will suffice. This represents an untyped annotation of
        the reference genome.
      VARIANT: A `VARIANT` annotation type.
      GENE: A `GENE` annotation type represents the existence of a gene at the
        associated reference coordinates. The start coordinate is typically
        the gene's transcription start site and the end is typically the end
        of the gene's last exon.
      TRANSCRIPT: A `TRANSCRIPT` annotation type represents the assertion that
        a particular region of the reference genome may be transcribed as RNA.
    """
    ANNOTATION_TYPE_UNSPECIFIED = 0
    GENERIC = 1
    VARIANT = 2
    GENE = 3
    TRANSCRIPT = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional read alignment information. This must be of the
    form map<string, string[]> (string key mapping to a list of string
    values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  datasetId = _messages.StringField(1)
  id = _messages.StringField(2)
  info = _messages.MessageField('InfoValue', 3)
  name = _messages.StringField(4)
  referenceSetId = _messages.StringField(5)
  sourceUri = _messages.StringField(6)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class BatchCreateAnnotationsRequest(_messages.Message):
  r"""A BatchCreateAnnotationsRequest object.

  Fields:
    annotations: The annotations to be created. At most 4096 can be specified
      in a single request.
    requestId: A unique request ID which enables the server to detect
      duplicated requests. If provided, duplicated requests will result in the
      same response; if not provided, duplicated requests may result in
      duplicated data. For a given annotation set, callers should not reuse
      `request_id`s when writing different batches of annotations - behavior
      in this case is undefined. A common approach is to use a UUID. For batch
      jobs where worker crashes are a possibility, consider using some unique
      variant of a worker or run ID.
  """

  annotations = _messages.MessageField('Annotation', 1, repeated=True)
  requestId = _messages.StringField(2)


class BatchCreateAnnotationsResponse(_messages.Message):
  r"""A BatchCreateAnnotationsResponse object.

  Fields:
    entries: The resulting per-annotation entries, ordered consistently with
      the original request.
  """

  entries = _messages.MessageField('Entry', 1, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: Unimplemented. The condition that is associated with this
      binding. NOTE: an unsatisfied condition will not allow user access via
      current binding. Different bindings, including their conditions, are
      examined independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CallSet(_messages.Message):
  r"""A call set is a collection of variant calls, typically for one sample.
  It belongs to a variant set.

  Messages:
    InfoValue: A map of additional call set information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    created: The date this call set was created in milliseconds from the
      epoch.
    id: The server-generated call set ID, unique across all call sets.
    info: A map of additional call set information. This must be of the form
      map<string, string[]> (string key mapping to a list of string values).
    name: The call set name.
    sampleId: The sample ID this call set corresponds to.
    variantSetIds: The IDs of the variant sets this call set belongs to. This
      field must have exactly length one, as a call set belongs to a single
      variant set. This field is repeated for compatibility with the [GA4GH
      0.5.1 API](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resourc
      es/avro/variants.avdl#L76).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional call set information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  created = _messages.IntegerField(1)
  id = _messages.StringField(2)
  info = _messages.MessageField('InfoValue', 3)
  name = _messages.StringField(4)
  sampleId = _messages.StringField(5)
  variantSetIds = _messages.StringField(6, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CigarUnit(_messages.Message):
  r"""A single CIGAR operation.

  Enums:
    OperationValueValuesEnum:

  Fields:
    operation: A OperationValueValuesEnum attribute.
    operationLength: The number of genomic bases that the operation runs for.
      Required.
    referenceSequence: `referenceSequence` is only used at mismatches
      (`SEQUENCE_MISMATCH`) and deletions (`DELETE`). Filling this field
      replaces SAM's MD tag. If the relevant information is not available,
      this field is unset.
  """

  class OperationValueValuesEnum(_messages.Enum):
    r"""OperationValueValuesEnum enum type.

    Values:
      OPERATION_UNSPECIFIED: <no description>
      ALIGNMENT_MATCH: An alignment match indicates that a sequence can be
        aligned to the reference without evidence of an INDEL. Unlike the
        `SEQUENCE_MATCH` and `SEQUENCE_MISMATCH` operators, the
        `ALIGNMENT_MATCH` operator does not indicate whether the reference and
        read sequences are an exact match. This operator is equivalent to
        SAM's `M`.
      INSERT: The insert operator indicates that the read contains evidence of
        bases being inserted into the reference. This operator is equivalent
        to SAM's `I`.
      DELETE: The delete operator indicates that the read contains evidence of
        bases being deleted from the reference. This operator is equivalent to
        SAM's `D`.
      SKIP: The skip operator indicates that this read skips a long segment of
        the reference, but the bases have not been deleted. This operator is
        commonly used when working with RNA-seq data, where reads may skip
        long segments of the reference between exons. This operator is
        equivalent to SAM's `N`.
      CLIP_SOFT: The soft clip operator indicates that bases at the start/end
        of a read have not been considered during alignment. This may occur if
        the majority of a read maps, except for low quality bases at the
        start/end of a read. This operator is equivalent to SAM's `S`. Bases
        that are soft clipped will still be stored in the read.
      CLIP_HARD: The hard clip operator indicates that bases at the start/end
        of a read have been omitted from this alignment. This may occur if
        this linear alignment is part of a chimeric alignment, or if the read
        has been trimmed (for example, during error correction or to trim
        poly-A tails for RNA-seq). This operator is equivalent to SAM's `H`.
      PAD: The pad operator indicates that there is padding in an alignment.
        This operator is equivalent to SAM's `P`.
      SEQUENCE_MATCH: This operator indicates that this portion of the aligned
        sequence exactly matches the reference. This operator is equivalent to
        SAM's `=`.
      SEQUENCE_MISMATCH: This operator indicates that this portion of the
        aligned sequence is an alignment match to the reference, but a
        sequence mismatch. This can indicate a SNP or a read error. This
        operator is equivalent to SAM's `X`.
    """
    OPERATION_UNSPECIFIED = 0
    ALIGNMENT_MATCH = 1
    INSERT = 2
    DELETE = 3
    SKIP = 4
    CLIP_SOFT = 5
    CLIP_HARD = 6
    PAD = 7
    SEQUENCE_MATCH = 8
    SEQUENCE_MISMATCH = 9

  operation = _messages.EnumField('OperationValueValuesEnum', 1)
  operationLength = _messages.IntegerField(2)
  referenceSequence = _messages.StringField(3)


class ClinicalCondition(_messages.Message):
  r"""A ClinicalCondition object.

  Fields:
    conceptId: The MedGen concept id associated with this gene. Search for
      these IDs at http://www.ncbi.nlm.nih.gov/medgen/
    externalIds: The set of external IDs for this condition.
    names: A set of names for the condition.
    omimId: The OMIM id for this condition. Search for these IDs at
      http://omim.org/
  """

  conceptId = _messages.StringField(1)
  externalIds = _messages.MessageField('ExternalId', 2, repeated=True)
  names = _messages.StringField(3, repeated=True)
  omimId = _messages.StringField(4)


class CodingSequence(_messages.Message):
  r"""A CodingSequence object.

  Fields:
    end: The end of the coding sequence on this annotation's reference
      sequence, 0-based exclusive. Note that this position is relative to the
      reference start, and *not* the containing annotation start.
    start: The start of the coding sequence on this annotation's reference
      sequence, 0-based inclusive. Note that this position is relative to the
      reference start, and *not* the containing annotation start.
  """

  end = _messages.IntegerField(1)
  start = _messages.IntegerField(2)


class ComputeEngine(_messages.Message):
  r"""Describes a Compute Engine resource that is being managed by a running
  pipeline.

  Fields:
    diskNames: The names of the disks that were created for this pipeline.
    instanceName: The instance on which the operation is running.
    machineType: The machine type of the instance.
    zone: The availability zone in which the instance resides.
  """

  diskNames = _messages.StringField(1, repeated=True)
  instanceName = _messages.StringField(2)
  machineType = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerKilledEvent(_messages.Message):
  r"""An event generated when a container is forcibly terminated by the
  worker. Currently, this only occurs when the container outlives the timeout
  specified by the user.

  Fields:
    actionId: The numeric ID of the action that started the container.
  """

  actionId = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ContainerStartedEvent(_messages.Message):
  r"""An event generated when a container starts.

  Messages:
    PortMappingsValue: The container-to-host port mappings installed for this
      container. This set will contain any ports exposed using the
      `PUBLISH_EXPOSED_PORTS` flag as well as any specified in the `Action`
      definition.

  Fields:
    actionId: The numeric ID of the action that started this container.
    ipAddress: The public IP address that can be used to connect to the
      container. This field is only populated when at least one port mapping
      is present. If the instance was created with a private address, this
      field will be empty even if port mappings exist.
    portMappings: The container-to-host port mappings installed for this
      container. This set will contain any ports exposed using the
      `PUBLISH_EXPOSED_PORTS` flag as well as any specified in the `Action`
      definition.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PortMappingsValue(_messages.Message):
    r"""The container-to-host port mappings installed for this container. This
    set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
    as well as any specified in the `Action` definition.

    Messages:
      AdditionalProperty: An additional property for a PortMappingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type PortMappingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PortMappingsValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  actionId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  ipAddress = _messages.StringField(2)
  portMappings = _messages.MessageField('PortMappingsValue', 3)


class ContainerStoppedEvent(_messages.Message):
  r"""An event generated when a container exits.

  Fields:
    actionId: The numeric ID of the action that started this container.
    exitStatus: The exit status of the container.
    stderr: The tail end of any content written to standard error by the
      container. If the content emits large amounts of debugging noise or
      contains sensitive information, you can prevent the content from being
      printed by setting the `DISABLE_STANDARD_ERROR_CAPTURE` flag.  Note that
      only a small amount of the end of the stream is captured here. The
      entire stream is stored in the `/google/logs` directory mounted into
      each action, and can be copied off the machine as described elsewhere.
  """

  actionId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  exitStatus = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  stderr = _messages.StringField(3)


class CoverageBucket(_messages.Message):
  r"""A bucket over which read coverage has been precomputed. A bucket
  corresponds to a specific range of the reference sequence.

  Fields:
    meanCoverage: The average number of reads which are aligned to each
      individual reference base in this bucket.
    range: The genomic coordinate range spanned by this bucket.
  """

  meanCoverage = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  range = _messages.MessageField('Range', 2)


class Dataset(_messages.Message):
  r"""A Dataset is a collection of genomic data.

  Fields:
    createTime: The time this dataset was created, in seconds from the epoch.
    id: The server-generated dataset ID, unique across all datasets.
    name: The dataset name.
    projectId: The Google Cloud project ID that this dataset belongs to.
  """

  createTime = _messages.StringField(1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)


class DelayedEvent(_messages.Message):
  r"""An event generated whenever a resource limitation or transient error
  delays execution of a pipeline that was otherwise ready to run.

  Fields:
    cause: A textual description of the cause of the delay. The string can
      change without notice because it is often generated by another service
      (such as Compute Engine).
    metrics: If the delay was caused by a resource shortage, this field lists
      the Compute Engine metrics that are preventing this operation from
      running (for example, `CPUS` or `INSTANCES`). If the particular metric
      is not known, a single `UNKNOWN` metric will be present.
  """

  cause = _messages.StringField(1)
  metrics = _messages.StringField(2, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Entry(_messages.Message):
  r"""A Entry object.

  Fields:
    annotation: The created annotation, if creation was successful.
    status: The creation status.
  """

  annotation = _messages.MessageField('Annotation', 1)
  status = _messages.MessageField('Status', 2)


class Event(_messages.Message):
  r"""Carries information about events that occur during pipeline execution.

  Messages:
    DetailsValue: Machine-readable details about the event.

  Fields:
    description: A human-readable description of the event. Note that these
      strings can change at any time without notice. Any application logic
      must use the information in the `details` field.
    details: Machine-readable details about the event.
    timestamp: The time at which the event occurred.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValue(_messages.Message):
    r"""Machine-readable details about the event.

    Messages:
      AdditionalProperty: An additional property for a DetailsValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  details = _messages.MessageField('DetailsValue', 2)
  timestamp = _messages.StringField(3)


class Exon(_messages.Message):
  r"""A Exon object.

  Fields:
    end: The end position of the exon on this annotation's reference sequence,
      0-based exclusive. Note that this is relative to the reference start,
      and *not* the containing annotation start.
    frame: The frame of this exon. Contains a value of 0, 1, or 2, which
      indicates the offset of the first coding base of the exon within the
      reading frame of the coding DNA sequence, if any. This field is
      dependent on the strandedness of this annotation (see
      Annotation.reverse_strand). For forward stranded annotations, this
      offset is relative to the exon.start. For reverse strand annotations,
      this offset is relative to the exon.end `- 1`.  Unset if this exon does
      not intersect the coding sequence. Upon creation of a transcript, the
      frame must be populated for all or none of the coding exons.
    start: The start position of the exon on this annotation's reference
      sequence, 0-based inclusive. Note that this is relative to the reference
      start, and **not** the containing annotation start.
  """

  end = _messages.IntegerField(1)
  frame = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  start = _messages.IntegerField(3)


class Experiment(_messages.Message):
  r"""A Experiment object.

  Fields:
    instrumentModel: The instrument model used as part of this experiment.
      This maps to sequencing technology in the SAM spec.
    libraryId: A client-supplied library identifier; a library is a collection
      of DNA fragments which have been prepared for sequencing from a sample.
      This field is important for quality control as error or bias can be
      introduced during sample preparation.
    platformUnit: The platform unit used as part of this experiment, for
      example flowcell-barcode.lane for Illumina or slide for SOLiD.
      Corresponds to the @RG PU field in the SAM spec.
    sequencingCenter: The sequencing center used as part of this experiment.
  """

  instrumentModel = _messages.StringField(1)
  libraryId = _messages.StringField(2)
  platformUnit = _messages.StringField(3)
  sequencingCenter = _messages.StringField(4)


class ExportReadGroupSetRequest(_messages.Message):
  r"""The read group set export request.

  Fields:
    exportUri: Required. A Google Cloud Storage URI for the exported BAM file.
      The currently authenticated user must have write access to the new file.
      An error will be returned if the URI already contains data.
    projectId: Required. The Google Cloud project ID that owns this export.
      The caller must have WRITE access to this project.
    referenceNames: The reference names to export. If this is not specified,
      all reference sequences, including unmapped reads, are exported. Use `*`
      to export only unmapped reads.
  """

  exportUri = _messages.StringField(1)
  projectId = _messages.StringField(2)
  referenceNames = _messages.StringField(3, repeated=True)


class ExportVariantSetRequest(_messages.Message):
  r"""The variant data export request.

  Enums:
    FormatValueValuesEnum: The format for the exported data.

  Fields:
    bigqueryDataset: Required. The BigQuery dataset to export data to. This
      dataset must already exist. Note that this is distinct from the Genomics
      concept of "dataset".
    bigqueryTable: Required. The BigQuery table to export data to. If the
      table doesn't exist, it will be created. If it already exists, it will
      be overwritten.
    callSetIds: If provided, only variant call information from the specified
      call sets will be exported. By default all variant calls are exported.
    format: The format for the exported data.
    projectId: Required. The Google Cloud project ID that owns the destination
      BigQuery dataset. The caller must have WRITE access to this project.
      This project will also own the resulting export job.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""The format for the exported data.

    Values:
      FORMAT_UNSPECIFIED: <no description>
      FORMAT_BIGQUERY: Export the data to Google BigQuery.
    """
    FORMAT_UNSPECIFIED = 0
    FORMAT_BIGQUERY = 1

  bigqueryDataset = _messages.StringField(1)
  bigqueryTable = _messages.StringField(2)
  callSetIds = _messages.StringField(3, repeated=True)
  format = _messages.EnumField('FormatValueValuesEnum', 4)
  projectId = _messages.StringField(5)


class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ExternalId(_messages.Message):
  r"""A ExternalId object.

  Fields:
    id: The id used by the source of this data.
    sourceName: The name of the source of this data.
  """

  id = _messages.StringField(1)
  sourceName = _messages.StringField(2)


class FailedEvent(_messages.Message):
  r"""An event generated when the execution of a pipeline has failed. Note
  that other events can continue to occur after this event.

  Enums:
    CodeValueValuesEnum: The Google standard error code that best describes
      this failure.

  Fields:
    cause: The human-readable description of the cause of the failure.
    code: The Google standard error code that best describes this failure.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""The Google standard error code that best describes this failure.

    Values:
      OK: Not an error; returned on success  HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller.  HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error.  For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space.  Also errors raised by
        APIs that do not return enough error information may be converted to
        this error.  HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument.  Note that
        this differs from `FAILED_PRECONDITION`.  `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name).  HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully.  For example, a successful response from a server could
        have been delayed long enough for the deadline to expire.  HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found.  Note to server developers: if a request is denied for an
        entire class of users, such as gradual feature rollout or undocumented
        whitelist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used.  HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists.  HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions.  HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation.  HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space.  HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution.  For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc.  Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`:  (a) Use `UNAVAILABLE` if the client can
        retry just the failing call.  (b) Use `ABORTED` if the client should
        retry at a higher level      (e.g., when a client-specified test-and-
        set fails, indicating the      client should restart a read-modify-
        write sequence).  (c) Use `FAILED_PRECONDITION` if the client should
        not retry until      the system state has been explicitly fixed.
        E.g., if an "rmdir"      fails because the directory is non-empty,
        `FAILED_PRECONDITION`      should be returned since the client should
        not retry unless      the files are deleted from the directory.  HTTP
        Mapping: 400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort.  See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`.  HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range.  E.g.,
        seeking or reading past end-of-file.  Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size.  There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`.  We
        recommend using `OUT_OF_RANGE` (the more specific error) when it
        applies so that callers who are iterating through a space can easily
        look for an `OUT_OF_RANGE` error to detect when they are done.  HTTP
        Mapping: 400 Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service.  HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors.  This means that some invariants expected by
        the underlying system have been broken.  This error code is reserved
        for serious errors.  HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable.  This is most likely
        a transient condition, which can be corrected by retrying with a
        backoff.  See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`.  HTTP Mapping:
        503 Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption.  HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  cause = _messages.StringField(1)
  code = _messages.EnumField('CodeValueValuesEnum', 2)


class GenomicsAnnotationsDeleteRequest(_messages.Message):
  r"""A GenomicsAnnotationsDeleteRequest object.

  Fields:
    annotationId: The ID of the annotation to be deleted.
  """

  annotationId = _messages.StringField(1, required=True)


class GenomicsAnnotationsGetRequest(_messages.Message):
  r"""A GenomicsAnnotationsGetRequest object.

  Fields:
    annotationId: The ID of the annotation to be retrieved.
  """

  annotationId = _messages.StringField(1, required=True)


class GenomicsAnnotationsUpdateRequest(_messages.Message):
  r"""A GenomicsAnnotationsUpdateRequest object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    annotationId: The ID of the annotation to be updated.
    updateMask: An optional mask specifying which fields to update. Mutable
      fields are name, variant, transcript, and info. If unspecified, all
      mutable fields will be updated.
  """

  annotation = _messages.MessageField('Annotation', 1)
  annotationId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsAnnotationsetsDeleteRequest(_messages.Message):
  r"""A GenomicsAnnotationsetsDeleteRequest object.

  Fields:
    annotationSetId: The ID of the annotation set to be deleted.
  """

  annotationSetId = _messages.StringField(1, required=True)


class GenomicsAnnotationsetsGetRequest(_messages.Message):
  r"""A GenomicsAnnotationsetsGetRequest object.

  Fields:
    annotationSetId: The ID of the annotation set to be retrieved.
  """

  annotationSetId = _messages.StringField(1, required=True)


class GenomicsAnnotationsetsUpdateRequest(_messages.Message):
  r"""A GenomicsAnnotationsetsUpdateRequest object.

  Fields:
    annotationSet: A AnnotationSet resource to be passed as the request body.
    annotationSetId: The ID of the annotation set to be updated.
    updateMask: An optional mask specifying which fields to update. Mutable
      fields are name, source_uri, and info. If unspecified, all mutable
      fields will be updated.
  """

  annotationSet = _messages.MessageField('AnnotationSet', 1)
  annotationSetId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsCallsetsDeleteRequest(_messages.Message):
  r"""A GenomicsCallsetsDeleteRequest object.

  Fields:
    callSetId: The ID of the call set to be deleted.
  """

  callSetId = _messages.StringField(1, required=True)


class GenomicsCallsetsGetRequest(_messages.Message):
  r"""A GenomicsCallsetsGetRequest object.

  Fields:
    callSetId: The ID of the call set.
  """

  callSetId = _messages.StringField(1, required=True)


class GenomicsCallsetsPatchRequest(_messages.Message):
  r"""A GenomicsCallsetsPatchRequest object.

  Fields:
    callSet: A CallSet resource to be passed as the request body.
    callSetId: The ID of the call set to be updated.
    updateMask: An optional mask specifying which fields to update. At this
      time, the only mutable field is name. The only acceptable value is
      "name". If unspecified, all mutable fields will be updated.
  """

  callSet = _messages.MessageField('CallSet', 1)
  callSetId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsDatasetsDeleteRequest(_messages.Message):
  r"""A GenomicsDatasetsDeleteRequest object.

  Fields:
    datasetId: The ID of the dataset to be deleted.
  """

  datasetId = _messages.StringField(1, required=True)


class GenomicsDatasetsGetIamPolicyRequest(_messages.Message):
  r"""A GenomicsDatasetsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which policy is being specified.
      Format is `datasets/<dataset ID>`.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class GenomicsDatasetsGetRequest(_messages.Message):
  r"""A GenomicsDatasetsGetRequest object.

  Fields:
    datasetId: The ID of the dataset.
  """

  datasetId = _messages.StringField(1, required=True)


class GenomicsDatasetsListRequest(_messages.Message):
  r"""A GenomicsDatasetsListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 50. The maximum value is 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    projectId: Required. The Google Cloud project ID to list datasets for.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3)


class GenomicsDatasetsPatchRequest(_messages.Message):
  r"""A GenomicsDatasetsPatchRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    datasetId: The ID of the dataset to be updated.
    updateMask: An optional mask specifying which fields to update. At this
      time, the only mutable field is name. The only acceptable value is
      "name". If unspecified, all mutable fields will be updated.
  """

  dataset = _messages.MessageField('Dataset', 1)
  datasetId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsDatasetsSetIamPolicyRequest(_messages.Message):
  r"""A GenomicsDatasetsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which policy is being specified.
      Format is `datasets/<dataset ID>`.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GenomicsDatasetsTestIamPermissionsRequest(_messages.Message):
  r"""A GenomicsDatasetsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which policy is being specified.
      Format is `datasets/<dataset ID>`.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GenomicsDatasetsUndeleteRequest(_messages.Message):
  r"""A GenomicsDatasetsUndeleteRequest object.

  Fields:
    datasetId: The ID of the dataset to be undeleted.
    undeleteDatasetRequest: A UndeleteDatasetRequest resource to be passed as
      the request body.
  """

  datasetId = _messages.StringField(1, required=True)
  undeleteDatasetRequest = _messages.MessageField('UndeleteDatasetRequest', 2)


class GenomicsOperationsCancelRequest(_messages.Message):
  r"""A GenomicsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GenomicsOperationsGetRequest(_messages.Message):
  r"""A GenomicsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GenomicsOperationsListRequest(_messages.Message):
  r"""A GenomicsOperationsListRequest object.

  Fields:
    filter: A string for filtering Operations. In v2alpha1, the following
      filter fields are supported&#58;  * createTime&#58; The time this job
      was created * events&#58; The set of event (names) that have occurred
      while running   the pipeline.  The &#58; operator can be used to
      determine if a   particular event has occurred. * error&#58; If the
      pipeline is running, this value is NULL.  Once the   pipeline finishes,
      the value is the standard Google error code. * labels.key or labels."key
      with space" where key is a label key. * done&#58; If the pipeline is
      running, this value is false. Once the   pipeline finishes, the value is
      true.  In v1 and v1alpha2, the following filter fields are
      supported&#58;  * projectId&#58; Required. Corresponds to
      OperationMetadata.projectId. * createTime&#58; The time this job was
      created, in seconds from the
      [epoch](http://en.wikipedia.org/wiki/Unix_time). Can use `>=` and/or
      `<=`   operators. * status&#58; Can be `RUNNING`, `SUCCESS`, `FAILURE`,
      or `CANCELED`. Only   one status may be specified. * labels.key where
      key is a label key.  Examples&#58;  * `projectId = my-project AND
      createTime >= 1432140000` * `projectId = my-project AND createTime >=
      1432140000 AND createTime <= 1432150000 AND status = RUNNING` *
      `projectId = my-project AND labels.color = *` * `projectId = my-project
      AND labels.color = red`
    name: The name of the operation's parent resource.
    pageSize: The maximum number of results to return. The maximum value is
      256.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GenomicsReadgroupsetsCoveragebucketsListRequest(_messages.Message):
  r"""A GenomicsReadgroupsetsCoveragebucketsListRequest object.

  Fields:
    end: The end position of the range on the reference, 0-based exclusive. If
      specified, `referenceName` must also be specified. If unset or 0,
      defaults to the length of the reference.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024. The maximum value is 2048.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    readGroupSetId: Required. The ID of the read group set over which coverage
      is requested.
    referenceName: The name of the reference to query, within the reference
      set associated with this query. Optional.
    start: The start position of the range on the reference, 0-based
      inclusive. If specified, `referenceName` must also be specified.
      Defaults to 0.
    targetBucketWidth: The desired width of each reported coverage bucket in
      base pairs. This will be rounded down to the nearest precomputed bucket
      width; the value of which is returned as `bucketWidth` in the response.
      Defaults to infinity (each bucket spans an entire reference sequence) or
      the length of the target range, if specified. The smallest precomputed
      `bucketWidth` is currently 2048 base pairs; this is subject to change.
  """

  end = _messages.IntegerField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  readGroupSetId = _messages.StringField(4, required=True)
  referenceName = _messages.StringField(5)
  start = _messages.IntegerField(6)
  targetBucketWidth = _messages.IntegerField(7)


class GenomicsReadgroupsetsDeleteRequest(_messages.Message):
  r"""A GenomicsReadgroupsetsDeleteRequest object.

  Fields:
    readGroupSetId: The ID of the read group set to be deleted. The caller
      must have WRITE permissions to the dataset associated with this read
      group set.
  """

  readGroupSetId = _messages.StringField(1, required=True)


class GenomicsReadgroupsetsExportRequest(_messages.Message):
  r"""A GenomicsReadgroupsetsExportRequest object.

  Fields:
    exportReadGroupSetRequest: A ExportReadGroupSetRequest resource to be
      passed as the request body.
    readGroupSetId: Required. The ID of the read group set to export. The
      caller must have READ access to this read group set.
  """

  exportReadGroupSetRequest = _messages.MessageField('ExportReadGroupSetRequest', 1)
  readGroupSetId = _messages.StringField(2, required=True)


class GenomicsReadgroupsetsGetRequest(_messages.Message):
  r"""A GenomicsReadgroupsetsGetRequest object.

  Fields:
    readGroupSetId: The ID of the read group set.
  """

  readGroupSetId = _messages.StringField(1, required=True)


class GenomicsReadgroupsetsPatchRequest(_messages.Message):
  r"""A GenomicsReadgroupsetsPatchRequest object.

  Fields:
    readGroupSet: A ReadGroupSet resource to be passed as the request body.
    readGroupSetId: The ID of the read group set to be updated. The caller
      must have WRITE permissions to the dataset associated with this read
      group set.
    updateMask: An optional mask specifying which fields to update. Supported
      fields:  * name. * referenceSetId.  Leaving `updateMask` unset is
      equivalent to specifying all mutable fields.
  """

  readGroupSet = _messages.MessageField('ReadGroupSet', 1)
  readGroupSetId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsReferencesBasesListRequest(_messages.Message):
  r"""A GenomicsReferencesBasesListRequest object.

  Fields:
    end: The end position (0-based, exclusive) of this query. Defaults to the
      length of this reference.
    pageSize: The maximum number of bases to return in a single page. If
      unspecified, defaults to 200Kbp (kilo base pairs). The maximum value is
      10Mbp (mega base pairs).
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceId: The ID of the reference.
    start: The start position (0-based) of this query. Defaults to 0.
  """

  end = _messages.IntegerField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  referenceId = _messages.StringField(4, required=True)
  start = _messages.IntegerField(5)


class GenomicsReferencesGetRequest(_messages.Message):
  r"""A GenomicsReferencesGetRequest object.

  Fields:
    referenceId: The ID of the reference.
  """

  referenceId = _messages.StringField(1, required=True)


class GenomicsReferencesetsGetRequest(_messages.Message):
  r"""A GenomicsReferencesetsGetRequest object.

  Fields:
    referenceSetId: The ID of the reference set.
  """

  referenceSetId = _messages.StringField(1, required=True)


class GenomicsVariantsDeleteRequest(_messages.Message):
  r"""A GenomicsVariantsDeleteRequest object.

  Fields:
    variantId: The ID of the variant to be deleted.
  """

  variantId = _messages.StringField(1, required=True)


class GenomicsVariantsGetRequest(_messages.Message):
  r"""A GenomicsVariantsGetRequest object.

  Fields:
    variantId: The ID of the variant.
  """

  variantId = _messages.StringField(1, required=True)


class GenomicsVariantsPatchRequest(_messages.Message):
  r"""A GenomicsVariantsPatchRequest object.

  Fields:
    updateMask: An optional mask specifying which fields to update. At this
      time, mutable fields are names and info. Acceptable values are "names"
      and "info". If unspecified, all mutable fields will be updated.
    variant: A Variant resource to be passed as the request body.
    variantId: The ID of the variant to be updated.
  """

  updateMask = _messages.StringField(1)
  variant = _messages.MessageField('Variant', 2)
  variantId = _messages.StringField(3, required=True)


class GenomicsVariantsetsDeleteRequest(_messages.Message):
  r"""A GenomicsVariantsetsDeleteRequest object.

  Fields:
    variantSetId: The ID of the variant set to be deleted.
  """

  variantSetId = _messages.StringField(1, required=True)


class GenomicsVariantsetsExportRequest(_messages.Message):
  r"""A GenomicsVariantsetsExportRequest object.

  Fields:
    exportVariantSetRequest: A ExportVariantSetRequest resource to be passed
      as the request body.
    variantSetId: Required. The ID of the variant set that contains variant
      data which should be exported. The caller must have READ access to this
      variant set.
  """

  exportVariantSetRequest = _messages.MessageField('ExportVariantSetRequest', 1)
  variantSetId = _messages.StringField(2, required=True)


class GenomicsVariantsetsGetRequest(_messages.Message):
  r"""A GenomicsVariantsetsGetRequest object.

  Fields:
    variantSetId: Required. The ID of the variant set.
  """

  variantSetId = _messages.StringField(1, required=True)


class GenomicsVariantsetsPatchRequest(_messages.Message):
  r"""A GenomicsVariantsetsPatchRequest object.

  Fields:
    updateMask: An optional mask specifying which fields to update. Supported
      fields:  * metadata. * name. * description.  Leaving `updateMask` unset
      is equivalent to specifying all mutable fields.
    variantSet: A VariantSet resource to be passed as the request body.
    variantSetId: The ID of the variant to be updated (must already exist).
  """

  updateMask = _messages.StringField(1)
  variantSet = _messages.MessageField('VariantSet', 2)
  variantSetId = _messages.StringField(3, required=True)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method."""


class ImportReadGroupSetsRequest(_messages.Message):
  r"""The read group set import request.

  Enums:
    PartitionStrategyValueValuesEnum: The partition strategy describes how
      read groups are partitioned into read group sets.

  Fields:
    datasetId: Required. The ID of the dataset these read group sets will
      belong to. The caller must have WRITE permissions to this dataset.
    partitionStrategy: The partition strategy describes how read groups are
      partitioned into read group sets.
    referenceSetId: The reference set to which the imported read group sets
      are aligned to, if any. The reference names of this reference set must
      be a superset of those found in the imported file headers. If no
      reference set id is provided, a best effort is made to associate with a
      matching reference set.
    sourceUris: A list of URIs pointing at [BAM
      files](https://samtools.github.io/hts-specs/SAMv1.pdf) in Google Cloud
      Storage. Those URIs can include wildcards (*), but do not add or remove
      matching files before import has completed.  Note that Google Cloud
      Storage object listing is only eventually consistent: files added may be
      not be immediately visible to everyone. Thus, if using a wildcard it is
      preferable not to start the import immediately after the files are
      created.
  """

  class PartitionStrategyValueValuesEnum(_messages.Enum):
    r"""The partition strategy describes how read groups are partitioned into
    read group sets.

    Values:
      PARTITION_STRATEGY_UNSPECIFIED: <no description>
      PER_FILE_PER_SAMPLE: In most cases, this strategy yields one read group
        set per file. This is the default behavior.  Allocate one read group
        set per file per sample. For BAM files, read groups are considered to
        share a sample if they have identical sample names. Furthermore, all
        reads for each file which do not belong to a read group, if any, will
        be grouped into a single read group set per-file.
      MERGE_ALL: Includes all read groups in all imported files into a single
        read group set. Requires that the headers for all imported files are
        equivalent. All reads which do not belong to a read group, if any,
        will be grouped into a separate read group set.
    """
    PARTITION_STRATEGY_UNSPECIFIED = 0
    PER_FILE_PER_SAMPLE = 1
    MERGE_ALL = 2

  datasetId = _messages.StringField(1)
  partitionStrategy = _messages.EnumField('PartitionStrategyValueValuesEnum', 2)
  referenceSetId = _messages.StringField(3)
  sourceUris = _messages.StringField(4, repeated=True)


class ImportReadGroupSetsResponse(_messages.Message):
  r"""The read group set import response.

  Fields:
    readGroupSetIds: IDs of the read group sets that were created.
  """

  readGroupSetIds = _messages.StringField(1, repeated=True)


class ImportVariantsRequest(_messages.Message):
  r"""The variant data import request.

  Enums:
    FormatValueValuesEnum: The format of the variant data being imported. If
      unspecified, defaults to to `VCF`.

  Messages:
    InfoMergeConfigValue: A mapping between info field keys and the
      InfoMergeOperations to be performed on them. This is plumbed down to the
      MergeVariantRequests generated by the resulting import job.

  Fields:
    format: The format of the variant data being imported. If unspecified,
      defaults to to `VCF`.
    infoMergeConfig: A mapping between info field keys and the
      InfoMergeOperations to be performed on them. This is plumbed down to the
      MergeVariantRequests generated by the resulting import job.
    normalizeReferenceNames: Convert reference names to the canonical
      representation. hg19 haploytypes (those reference names containing
      "_hap") are not modified in any way. All other reference names are
      modified according to the following rules: The reference name is
      capitalized. The "chr" prefix is dropped for all autosomes and sex
      chromsomes. For example "chr17" becomes "17" and "chrX" becomes "X". All
      mitochondrial chromosomes ("chrM", "chrMT", etc) become "MT".
    sourceUris: A list of URIs referencing variant files in Google Cloud
      Storage. URIs can include wildcards [as described here](https://cloud.go
      ogle.com/storage/docs/gsutil/addlhelp/WildcardNames). Note that
      recursive wildcards ('**') are not supported.
    variantSetId: Required. The variant set to which variant data should be
      imported.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""The format of the variant data being imported. If unspecified,
    defaults to to `VCF`.

    Values:
      FORMAT_UNSPECIFIED: <no description>
      FORMAT_VCF: VCF (Variant Call Format). The VCF files may be gzip
        compressed. gVCF is also supported. Disclaimer: gzip VCF imports are
        currently much slower than equivalent uncompressed VCF imports. For
        this reason, uncompressed VCF is currently recommended for imports
        with more than 1GB combined uncompressed size, or for time sensitive
        imports.
      FORMAT_COMPLETE_GENOMICS: Complete Genomics masterVarBeta format. The
        masterVarBeta files may be bzip2 compressed.
    """
    FORMAT_UNSPECIFIED = 0
    FORMAT_VCF = 1
    FORMAT_COMPLETE_GENOMICS = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoMergeConfigValue(_messages.Message):
    r"""A mapping between info field keys and the InfoMergeOperations to be
    performed on them. This is plumbed down to the MergeVariantRequests
    generated by the resulting import job.

    Messages:
      AdditionalProperty: An additional property for a InfoMergeConfigValue
        object.

    Fields:
      additionalProperties: Additional properties of type InfoMergeConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoMergeConfigValue object.

      Enums:
        ValueValueValuesEnum:

      Fields:
        key: Name of the additional property.
        value: A ValueValueValuesEnum attribute.
      """

      class ValueValueValuesEnum(_messages.Enum):
        r"""ValueValueValuesEnum enum type.

        Values:
          INFO_MERGE_OPERATION_UNSPECIFIED: <no description>
          IGNORE_NEW: <no description>
          MOVE_TO_CALLS: <no description>
        """
        INFO_MERGE_OPERATION_UNSPECIFIED = 0
        IGNORE_NEW = 1
        MOVE_TO_CALLS = 2

      key = _messages.StringField(1)
      value = _messages.EnumField('ValueValueValuesEnum', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  infoMergeConfig = _messages.MessageField('InfoMergeConfigValue', 2)
  normalizeReferenceNames = _messages.BooleanField(3)
  sourceUris = _messages.StringField(4, repeated=True)
  variantSetId = _messages.StringField(5)


class ImportVariantsResponse(_messages.Message):
  r"""The variant data import response.

  Fields:
    callSetIds: IDs of the call sets created during the import.
  """

  callSetIds = _messages.StringField(1, repeated=True)


class LinearAlignment(_messages.Message):
  r"""A linear alignment can be represented by one CIGAR string. Describes the
  mapped position and local alignment of the read to the reference.

  Fields:
    cigar: Represents the local alignment of this sequence (alignment matches,
      indels, etc) against the reference.
    mappingQuality: The mapping quality of this alignment. Represents how
      likely the read maps to this position as opposed to other locations.
      Specifically, this is -10 log10 Pr(mapping position is wrong), rounded
      to the nearest integer.
    position: The position of this alignment.
  """

  cigar = _messages.MessageField('CigarUnit', 1, repeated=True)
  mappingQuality = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  position = _messages.MessageField('Position', 3)


class ListBasesResponse(_messages.Message):
  r"""A ListBasesResponse object.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    offset: The offset position (0-based) of the given `sequence` from the
      start of this `Reference`. This value will differ for each page in a
      paginated request.
    sequence: A substring of the bases that make up this reference.
  """

  nextPageToken = _messages.StringField(1)
  offset = _messages.IntegerField(2)
  sequence = _messages.StringField(3)


class ListCoverageBucketsResponse(_messages.Message):
  r"""A ListCoverageBucketsResponse object.

  Fields:
    bucketWidth: The length of each coverage bucket in base pairs. Note that
      buckets at the end of a reference sequence may be shorter. This value is
      omitted if the bucket width is infinity (the default behaviour, with no
      range or `targetBucketWidth`).
    coverageBuckets: The coverage buckets. The list of buckets is sparse; a
      bucket with 0 overlapping reads is not returned. A bucket never crosses
      more than one reference sequence. Each bucket has width `bucketWidth`,
      unless its end is the end of the reference sequence.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  bucketWidth = _messages.IntegerField(1)
  coverageBuckets = _messages.MessageField('CoverageBucket', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListDatasetsResponse(_messages.Message):
  r"""The dataset list response.

  Fields:
    datasets: The list of matching Datasets.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  datasets = _messages.MessageField('Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class MergeVariantsRequest(_messages.Message):
  r"""A MergeVariantsRequest object.

  Messages:
    InfoMergeConfigValue: A mapping between info field keys and the
      InfoMergeOperations to be performed on them.

  Fields:
    infoMergeConfig: A mapping between info field keys and the
      InfoMergeOperations to be performed on them.
    variantSetId: The destination variant set.
    variants: The variants to be merged with existing variants.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoMergeConfigValue(_messages.Message):
    r"""A mapping between info field keys and the InfoMergeOperations to be
    performed on them.

    Messages:
      AdditionalProperty: An additional property for a InfoMergeConfigValue
        object.

    Fields:
      additionalProperties: Additional properties of type InfoMergeConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoMergeConfigValue object.

      Enums:
        ValueValueValuesEnum:

      Fields:
        key: Name of the additional property.
        value: A ValueValueValuesEnum attribute.
      """

      class ValueValueValuesEnum(_messages.Enum):
        r"""ValueValueValuesEnum enum type.

        Values:
          INFO_MERGE_OPERATION_UNSPECIFIED: <no description>
          IGNORE_NEW: <no description>
          MOVE_TO_CALLS: <no description>
        """
        INFO_MERGE_OPERATION_UNSPECIFIED = 0
        IGNORE_NEW = 1
        MOVE_TO_CALLS = 2

      key = _messages.StringField(1)
      value = _messages.EnumField('ValueValueValuesEnum', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  infoMergeConfig = _messages.MessageField('InfoMergeConfigValue', 1)
  variantSetId = _messages.StringField(2)
  variants = _messages.MessageField('Variant', 3, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: An OperationMetadata or Metadata object. This will always
      be returned with the Operation.
    ResponseValue: If importing ReadGroupSets, an ImportReadGroupSetsResponse
      is returned. If importing Variants, an ImportVariantsResponse is
      returned. For pipelines and exports, an Empty response is returned.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: An OperationMetadata or Metadata object. This will always be
      returned with the Operation.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. For example&#58; `operations
      /CJHU7Oi_ChDrveSpBRjfuL-qzoWAgEw`
    response: If importing ReadGroupSets, an ImportReadGroupSetsResponse is
      returned. If importing Variants, an ImportVariantsResponse is returned.
      For pipelines and exports, an Empty response is returned.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""An OperationMetadata or Metadata object. This will always be returned
    with the Operation.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""If importing ReadGroupSets, an ImportReadGroupSetsResponse is
    returned. If importing Variants, an ImportVariantsResponse is returned.
    For pipelines and exports, an Empty response is returned.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationEvent(_messages.Message):
  r"""An event that occurred during an Operation.

  Fields:
    description: Required description of event.
    endTime: Optional time of when event finished. An event can have a start
      time and no finish time. If an event has a finish time, there must be a
      start time.
    startTime: Optional time of when event started.
  """

  description = _messages.StringField(1)
  endTime = _messages.StringField(2)
  startTime = _messages.StringField(3)


class OperationMetadata(_messages.Message):
  r"""Metadata describing an Operation.

  Messages:
    LabelsValue: Optionally provided by the caller when submitting the request
      that creates the operation.
    RequestValue: The original request that started the operation. Note that
      this will be in current version of the API. If the operation was started
      with v1beta2 API and a GetOperation is performed on v1 API, a v1 request
      will be returned.
    RuntimeMetadataValue: Runtime metadata on this Operation.

  Fields:
    clientId: This field is deprecated. Use `labels` instead. Optionally
      provided by the caller when submitting the request that creates the
      operation.
    createTime: The time at which the job was submitted to the Genomics
      service.
    endTime: The time at which the job stopped running.
    events: Optional event messages that were generated during the job's
      execution. This also contains any warnings that were generated during
      import or export.
    labels: Optionally provided by the caller when submitting the request that
      creates the operation.
    projectId: The Google Cloud Project in which the job is scoped.
    request: The original request that started the operation. Note that this
      will be in current version of the API. If the operation was started with
      v1beta2 API and a GetOperation is performed on v1 API, a v1 request will
      be returned.
    runtimeMetadata: Runtime metadata on this Operation.
    startTime: The time at which the job began to run.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optionally provided by the caller when submitting the request that
    creates the operation.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestValue(_messages.Message):
    r"""The original request that started the operation. Note that this will
    be in current version of the API. If the operation was started with
    v1beta2 API and a GetOperation is performed on v1 API, a v1 request will
    be returned.

    Messages:
      AdditionalProperty: An additional property for a RequestValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RuntimeMetadataValue(_messages.Message):
    r"""Runtime metadata on this Operation.

    Messages:
      AdditionalProperty: An additional property for a RuntimeMetadataValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RuntimeMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clientId = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  events = _messages.MessageField('OperationEvent', 4, repeated=True)
  labels = _messages.MessageField('LabelsValue', 5)
  projectId = _messages.StringField(6)
  request = _messages.MessageField('RequestValue', 7)
  runtimeMetadata = _messages.MessageField('RuntimeMetadataValue', 8)
  startTime = _messages.StringField(9)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Position(_messages.Message):
  r"""An abstraction for referring to a genomic position, in relation to some
  already known reference. For now, represents a genomic position as a
  reference name, a base number on that reference (0-based), and a
  determination of forward or reverse strand.

  Fields:
    position: The 0-based offset from the start of the forward strand for that
      reference.
    referenceName: The name of the reference in whatever reference set is
      being used.
    reverseStrand: Whether this position is on the reverse strand, as opposed
      to the forward strand.
  """

  position = _messages.IntegerField(1)
  referenceName = _messages.StringField(2)
  reverseStrand = _messages.BooleanField(3)


class Program(_messages.Message):
  r"""A Program object.

  Fields:
    commandLine: The command line used to run this program.
    id: The user specified locally unique ID of the program. Used along with
      `prevProgramId` to define an ordering between programs.
    name: The display name of the program. This is typically the colloquial
      name of the tool used, for example 'bwa' or 'picard'.
    prevProgramId: The ID of the program run before this one.
    version: The version of the program run.
  """

  commandLine = _messages.StringField(1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  prevProgramId = _messages.StringField(4)
  version = _messages.StringField(5)


class PullStartedEvent(_messages.Message):
  r"""An event generated when the worker starts pulling an image.

  Fields:
    imageUri: The URI of the image that was pulled.
  """

  imageUri = _messages.StringField(1)


class PullStoppedEvent(_messages.Message):
  r"""An event generated when the worker stops pulling an image.

  Fields:
    imageUri: The URI of the image that was pulled.
  """

  imageUri = _messages.StringField(1)


class Range(_messages.Message):
  r"""A 0-based half-open genomic coordinate range for search requests.

  Fields:
    end: The end position of the range on the reference, 0-based exclusive.
    referenceName: The reference sequence name, for example `chr1`, `1`, or
      `chrX`.
    start: The start position of the range on the reference, 0-based
      inclusive.
  """

  end = _messages.IntegerField(1)
  referenceName = _messages.StringField(2)
  start = _messages.IntegerField(3)


class Read(_messages.Message):
  r"""A read alignment describes a linear alignment of a string of DNA to a
  reference sequence, in addition to metadata about the fragment (the molecule
  of DNA sequenced) and the read (the bases which were read by the sequencer).
  A read is equivalent to a line in a SAM file. A read belongs to exactly one
  read group and exactly one read group set.  ### Reverse-stranded reads
  Mapped reads (reads having a non-null `alignment`) can be aligned to either
  the forward or the reverse strand of their associated reference.
  Strandedness of a mapped read is encoded by
  `alignment.position.reverseStrand`.  If we consider the reference to be a
  forward-stranded coordinate space of `[0, reference.length)` with `0` as the
  left-most position and `reference.length` as the right-most position, reads
  are always aligned left to right. That is, `alignment.position.position`
  always refers to the left-most reference coordinate and `alignment.cigar`
  describes the alignment of this read to the reference from left to right.
  All per-base fields such as `alignedSequence` and `alignedQuality` share
  this same left-to-right orientation; this is true of reads which are aligned
  to either strand. For reverse-stranded reads, this means that
  `alignedSequence` is the reverse complement of the bases that were
  originally reported by the sequencing machine.  ### Generating a reference-
  aligned sequence string  When interacting with mapped reads, it's often
  useful to produce a string representing the local alignment of the read to
  reference. The following pseudocode demonstrates one way of doing this:
  out = ""     offset = 0     for c in read.alignment.cigar {       switch
  c.operation {       case "ALIGNMENT_MATCH", "SEQUENCE_MATCH",
  "SEQUENCE_MISMATCH":         out +=
  read.alignedSequence[offset:offset+c.operationLength]         offset +=
  c.operationLength         break       case "CLIP_SOFT", "INSERT":
  offset += c.operationLength         break       case "PAD":         out +=
  repeat("*", c.operationLength)         break       case "DELETE":
  out += repeat("-", c.operationLength)         break       case "SKIP":
  out += repeat(" ", c.operationLength)         break       case "CLIP_HARD":
  break       }     }     return out  ### Converting to SAM's CIGAR string
  The following pseudocode generates a SAM CIGAR string from the `cigar`
  field. Note that this is a lossy conversion (`cigar.referenceSequence` is
  lost).      cigarMap = {       "ALIGNMENT_MATCH": "M",       "INSERT": "I",
  "DELETE": "D",       "SKIP": "N",       "CLIP_SOFT": "S",       "CLIP_HARD":
  "H",       "PAD": "P",       "SEQUENCE_MATCH": "=",
  "SEQUENCE_MISMATCH": "X",     }     cigarStr = ""     for c in
  read.alignment.cigar {       cigarStr += c.operationLength +
  cigarMap[c.operation]     }     return cigarStr

  Messages:
    InfoValue: A map of additional read alignment information. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    alignedQuality: The quality of the read sequence contained in this
      alignment record (equivalent to QUAL in SAM). `alignedSequence` and
      `alignedQuality` may be shorter than the full read sequence and quality.
      This will occur if the alignment is part of a chimeric alignment, or if
      the read was trimmed. When this occurs, the CIGAR for this read will
      begin/end with a hard clip operator that will indicate the length of the
      excised sequence.
    alignedSequence: The bases of the read sequence contained in this
      alignment record, **without CIGAR operations applied** (equivalent to
      SEQ in SAM). `alignedSequence` and `alignedQuality` may be shorter than
      the full read sequence and quality. This will occur if the alignment is
      part of a chimeric alignment, or if the read was trimmed. When this
      occurs, the CIGAR for this read will begin/end with a hard clip operator
      that will indicate the length of the excised sequence.
    alignment: The linear alignment for this alignment record. This field is
      null for unmapped reads.
    duplicateFragment: The fragment is a PCR or optical duplicate (SAM flag
      0x400).
    failedVendorQualityChecks: Whether this read did not pass filters, such as
      platform or vendor quality controls (SAM flag 0x200).
    fragmentLength: The observed length of the fragment, equivalent to TLEN in
      SAM.
    fragmentName: The fragment name. Equivalent to QNAME (query template name)
      in SAM.
    id: The server-generated read ID, unique across all reads. This is
      different from the `fragmentName`.
    info: A map of additional read alignment information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    nextMatePosition: The mapping of the primary alignment of the
      `(readNumber+1)%numberReads` read in the fragment. It replaces mate
      position and mate strand in SAM.
    numberReads: The number of reads in the fragment (extension to SAM flag
      0x1).
    properPlacement: The orientation and the distance between reads from the
      fragment are consistent with the sequencing protocol (SAM flag 0x2).
    readGroupId: The ID of the read group this read belongs to. A read belongs
      to exactly one read group. This is a server-generated ID which is
      distinct from SAM's RG tag (for that value, see ReadGroup.name).
    readGroupSetId: The ID of the read group set this read belongs to. A read
      belongs to exactly one read group set.
    readNumber: The read number in sequencing. 0-based and less than
      numberReads. This field replaces SAM flag 0x40 and 0x80.
    secondaryAlignment: Whether this alignment is secondary. Equivalent to SAM
      flag 0x100. A secondary alignment represents an alternative to the
      primary alignment for this read. Aligners may return secondary
      alignments if a read can map ambiguously to multiple coordinates in the
      genome. By convention, each read has one and only one alignment where
      both `secondaryAlignment` and `supplementaryAlignment` are false.
    supplementaryAlignment: Whether this alignment is supplementary.
      Equivalent to SAM flag 0x800. Supplementary alignments are used in the
      representation of a chimeric alignment. In a chimeric alignment, a read
      is split into multiple linear alignments that map to different reference
      contigs. The first linear alignment in the read will be designated as
      the representative alignment; the remaining linear alignments will be
      designated as supplementary alignments. These alignments may have
      different mapping quality scores. In each linear alignment in a chimeric
      alignment, the read will be hard clipped. The `alignedSequence` and
      `alignedQuality` fields in the alignment record will only represent the
      bases for its respective linear alignment.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional read alignment information. This must be of the
    form map<string, string[]> (string key mapping to a list of string
    values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  alignedQuality = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  alignedSequence = _messages.StringField(2)
  alignment = _messages.MessageField('LinearAlignment', 3)
  duplicateFragment = _messages.BooleanField(4)
  failedVendorQualityChecks = _messages.BooleanField(5)
  fragmentLength = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  fragmentName = _messages.StringField(7)
  id = _messages.StringField(8)
  info = _messages.MessageField('InfoValue', 9)
  nextMatePosition = _messages.MessageField('Position', 10)
  numberReads = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  properPlacement = _messages.BooleanField(12)
  readGroupId = _messages.StringField(13)
  readGroupSetId = _messages.StringField(14)
  readNumber = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  secondaryAlignment = _messages.BooleanField(16)
  supplementaryAlignment = _messages.BooleanField(17)


class ReadGroup(_messages.Message):
  r"""A read group is all the data that's processed the same way by the
  sequencer.

  Messages:
    InfoValue: A map of additional read group information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    datasetId: The dataset to which this read group belongs.
    description: A free-form text description of this read group.
    experiment: The experiment used to generate this read group.
    id: The server-generated read group ID, unique for all read groups. Note:
      This is different than the @RG ID field in the SAM spec. For that value,
      see name.
    info: A map of additional read group information. This must be of the form
      map<string, string[]> (string key mapping to a list of string values).
    name: The read group name. This corresponds to the @RG ID field in the SAM
      spec.
    predictedInsertSize: The predicted insert size of this read group. The
      insert size is the length the sequenced DNA fragment from end-to-end,
      not including the adapters.
    programs: The programs used to generate this read group. Programs are
      always identical for all read groups within a read group set. For this
      reason, only the first read group in a returned set will have this field
      populated.
    referenceSetId: The reference set the reads in this read group are aligned
      to.
    sampleId: A client-supplied sample identifier for the reads in this read
      group.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional read group information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  datasetId = _messages.StringField(1)
  description = _messages.StringField(2)
  experiment = _messages.MessageField('Experiment', 3)
  id = _messages.StringField(4)
  info = _messages.MessageField('InfoValue', 5)
  name = _messages.StringField(6)
  predictedInsertSize = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  programs = _messages.MessageField('Program', 8, repeated=True)
  referenceSetId = _messages.StringField(9)
  sampleId = _messages.StringField(10)


class ReadGroupSet(_messages.Message):
  r"""A read group set is a logical collection of read groups, which are
  collections of reads produced by a sequencer. A read group set typically
  models reads corresponding to one sample, sequenced one way, and aligned one
  way.  * A read group set belongs to one dataset. * A read group belongs to
  one read group set. * A read belongs to one read group.

  Messages:
    InfoValue: A map of additional read group set information.

  Fields:
    datasetId: The dataset to which this read group set belongs.
    filename: The filename of the original source file for this read group
      set, if any.
    id: The server-generated read group set ID, unique for all read group
      sets.
    info: A map of additional read group set information.
    name: The read group set name. By default this will be initialized to the
      sample name of the sequenced data contained in this set.
    readGroups: The read groups in this set. There are typically 1-10 read
      groups in a read group set.
    referenceSetId: The reference set to which the reads in this read group
      set are aligned.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional read group set information.

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  datasetId = _messages.StringField(1)
  filename = _messages.StringField(2)
  id = _messages.StringField(3)
  info = _messages.MessageField('InfoValue', 4)
  name = _messages.StringField(5)
  readGroups = _messages.MessageField('ReadGroup', 6, repeated=True)
  referenceSetId = _messages.StringField(7)


class Reference(_messages.Message):
  r"""A reference is a canonical assembled DNA sequence, intended to act as a
  reference coordinate space for other genomic annotations. A single reference
  might represent the human chromosome 1 or mitochandrial DNA, for instance. A
  reference belongs to one or more reference sets.

  Fields:
    id: The server-generated reference ID, unique across all references.
    length: The length of this reference's sequence.
    md5checksum: MD5 of the upper-case sequence excluding all whitespace
      characters (this is equivalent to SQ:M5 in SAM). This value is
      represented in lower case hexadecimal format.
    name: The name of this reference, for example `22`.
    ncbiTaxonId: ID from http://www.ncbi.nlm.nih.gov/taxonomy. For example,
      9606 for human.
    sourceAccessions: All known corresponding accession IDs in INSDC
      (GenBank/ENA/DDBJ) ideally with a version number, for example
      `GCF_000001405.26`.
    sourceUri: The URI from which the sequence was obtained. Typically
      specifies a FASTA format file.
  """

  id = _messages.StringField(1)
  length = _messages.IntegerField(2)
  md5checksum = _messages.StringField(3)
  name = _messages.StringField(4)
  ncbiTaxonId = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  sourceAccessions = _messages.StringField(6, repeated=True)
  sourceUri = _messages.StringField(7)


class ReferenceBound(_messages.Message):
  r"""ReferenceBound records an upper bound for the starting coordinate of
  variants in a particular reference.

  Fields:
    referenceName: The name of the reference associated with this reference
      bound.
    upperBound: An upper bound (inclusive) on the starting coordinate of any
      variant in the reference sequence.
  """

  referenceName = _messages.StringField(1)
  upperBound = _messages.IntegerField(2)


class ReferenceSet(_messages.Message):
  r"""A reference set is a set of references which typically comprise a
  reference assembly for a species, such as `GRCh38` which is representative
  of the human genome. A reference set defines a common coordinate space for
  comparing reference-aligned experimental data. A reference set contains 1 or
  more references.

  Fields:
    assemblyId: Public id of this reference set, such as `GRCh37`.
    description: Free text description of this reference set.
    id: The server-generated reference set ID, unique across all reference
      sets.
    md5checksum: Order-independent MD5 checksum which identifies this
      reference set. The checksum is computed by sorting all lower case
      hexidecimal string `reference.md5checksum` (for all reference in this
      set) in ascending lexicographic order, concatenating, and taking the MD5
      of that value. The resulting value is represented in lower case
      hexadecimal format.
    ncbiTaxonId: ID from http://www.ncbi.nlm.nih.gov/taxonomy (for example,
      9606 for human) indicating the species which this reference set is
      intended to model. Note that contained references may specify a
      different `ncbiTaxonId`, as assemblies may contain reference sequences
      which do not belong to the modeled species, for example EBV in a human
      reference genome.
    referenceIds: The IDs of the reference objects that are part of this set.
      `Reference.md5checksum` must be unique within this set.
    sourceAccessions: All known corresponding accession IDs in INSDC
      (GenBank/ENA/DDBJ) ideally with a version number, for example
      `NC_000001.11`.
    sourceUri: The URI from which the references were obtained.
  """

  assemblyId = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.StringField(3)
  md5checksum = _messages.StringField(4)
  ncbiTaxonId = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  referenceIds = _messages.StringField(6, repeated=True)
  sourceAccessions = _messages.StringField(7, repeated=True)
  sourceUri = _messages.StringField(8)


class RunPipelineResponse(_messages.Message):
  r"""The response to the RunPipeline method, returned in the operation's
  result field on success.
  """



class RuntimeMetadata(_messages.Message):
  r"""Runtime metadata that will be populated in the runtimeMetadata field of
  the Operation associated with a RunPipeline execution.

  Fields:
    computeEngine: Execution information specific to Google Compute Engine.
  """

  computeEngine = _messages.MessageField('ComputeEngine', 1)


class SearchAnnotationSetsRequest(_messages.Message):
  r"""A SearchAnnotationSetsRequest object.

  Enums:
    TypesValueListEntryValuesEnum:

  Fields:
    datasetIds: Required. The dataset IDs to search within. Caller must have
      `READ` access to these datasets.
    name: Only return annotations sets for which a substring of the name
      matches this string (case insensitive).
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 128. The maximum value is 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceSetId: If specified, only annotation sets associated with the
      given reference set are returned.
    types: If specified, only annotation sets that have any of these types are
      returned.
  """

  class TypesValueListEntryValuesEnum(_messages.Enum):
    r"""TypesValueListEntryValuesEnum enum type.

    Values:
      ANNOTATION_TYPE_UNSPECIFIED: <no description>
      GENERIC: <no description>
      VARIANT: <no description>
      GENE: <no description>
      TRANSCRIPT: <no description>
    """
    ANNOTATION_TYPE_UNSPECIFIED = 0
    GENERIC = 1
    VARIANT = 2
    GENE = 3
    TRANSCRIPT = 4

  datasetIds = _messages.StringField(1, repeated=True)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  referenceSetId = _messages.StringField(5)
  types = _messages.EnumField('TypesValueListEntryValuesEnum', 6, repeated=True)


class SearchAnnotationSetsResponse(_messages.Message):
  r"""A SearchAnnotationSetsResponse object.

  Fields:
    annotationSets: The matching annotation sets.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  annotationSets = _messages.MessageField('AnnotationSet', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchAnnotationsRequest(_messages.Message):
  r"""A SearchAnnotationsRequest object.

  Fields:
    annotationSetIds: Required. The annotation sets to search within. The
      caller must have `READ` access to these annotation sets. All queried
      annotation sets must have the same type.
    end: The end position of the range on the reference, 0-based exclusive. If
      referenceId or referenceName must be specified, Defaults to the length
      of the reference.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 256. The maximum value is 2048.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceId: The ID of the reference to query.
    referenceName: The name of the reference to query, within the reference
      set associated with this query.
    start: The start position of the range on the reference, 0-based
      inclusive. If specified, referenceId or referenceName must be specified.
      Defaults to 0.
  """

  annotationSetIds = _messages.StringField(1, repeated=True)
  end = _messages.IntegerField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  referenceId = _messages.StringField(5)
  referenceName = _messages.StringField(6)
  start = _messages.IntegerField(7)


class SearchAnnotationsResponse(_messages.Message):
  r"""A SearchAnnotationsResponse object.

  Fields:
    annotations: The matching annotations.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  annotations = _messages.MessageField('Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchCallSetsRequest(_messages.Message):
  r"""The call set search request.

  Fields:
    name: Only return call sets for which a substring of the name matches this
      string.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    variantSetIds: Restrict the query to call sets within the given variant
      sets. At least one ID must be provided.
  """

  name = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  variantSetIds = _messages.StringField(4, repeated=True)


class SearchCallSetsResponse(_messages.Message):
  r"""The call set search response.

  Fields:
    callSets: The list of matching call sets.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  callSets = _messages.MessageField('CallSet', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchReadGroupSetsRequest(_messages.Message):
  r"""The read group set search request.

  Fields:
    datasetIds: Restricts this query to read group sets within the given
      datasets. At least one ID must be provided.
    name: Only return read group sets for which a substring of the name
      matches this string.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 256. The maximum value is 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
  """

  datasetIds = _messages.StringField(1, repeated=True)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SearchReadGroupSetsResponse(_messages.Message):
  r"""The read group set search response.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    readGroupSets: The list of matching read group sets.
  """

  nextPageToken = _messages.StringField(1)
  readGroupSets = _messages.MessageField('ReadGroupSet', 2, repeated=True)


class SearchReadsRequest(_messages.Message):
  r"""The read search request.

  Fields:
    end: The end position of the range on the reference, 0-based exclusive. If
      specified, `referenceName` must also be specified.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 256. The maximum value is 2048.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    readGroupIds: The IDs of the read groups within which to search for reads.
      All specified read groups must belong to the same read group sets. Must
      specify one of `readGroupSetIds` or `readGroupIds`.
    readGroupSetIds: The IDs of the read groups sets within which to search
      for reads. All specified read group sets must be aligned against a
      common set of reference sequences; this defines the genomic coordinates
      for the query. Must specify one of `readGroupSetIds` or `readGroupIds`.
    referenceName: The reference sequence name, for example `chr1`, `1`, or
      `chrX`. If set to `*`, only unmapped reads are returned. If unspecified,
      all reads (mapped and unmapped) are returned.
    start: The start position of the range on the reference, 0-based
      inclusive. If specified, `referenceName` must also be specified.
  """

  end = _messages.IntegerField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  readGroupIds = _messages.StringField(4, repeated=True)
  readGroupSetIds = _messages.StringField(5, repeated=True)
  referenceName = _messages.StringField(6)
  start = _messages.IntegerField(7)


class SearchReadsResponse(_messages.Message):
  r"""The read search response.

  Fields:
    alignments: The list of matching alignments sorted by mapped genomic
      coordinate, if any, ascending in position within the same reference.
      Unmapped reads, which have no position, are returned contiguously and
      are sorted in ascending lexicographic order by fragment name.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  alignments = _messages.MessageField('Read', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchReferenceSetsRequest(_messages.Message):
  r"""A SearchReferenceSetsRequest object.

  Fields:
    accessions: If present, return reference sets for which a prefix of any of
      sourceAccessions match any of these strings. Accession numbers typically
      have a main number and a version, for example `NC_000001.11`.
    assemblyId: If present, return reference sets for which a substring of
      their `assemblyId` matches this string (case insensitive).
    md5checksums: If present, return reference sets for which the md5checksum
      matches exactly.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024. The maximum value is 4096.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
  """

  accessions = _messages.StringField(1, repeated=True)
  assemblyId = _messages.StringField(2)
  md5checksums = _messages.StringField(3, repeated=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class SearchReferenceSetsResponse(_messages.Message):
  r"""A SearchReferenceSetsResponse object.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    referenceSets: The matching references sets.
  """

  nextPageToken = _messages.StringField(1)
  referenceSets = _messages.MessageField('ReferenceSet', 2, repeated=True)


class SearchReferencesRequest(_messages.Message):
  r"""A SearchReferencesRequest object.

  Fields:
    accessions: If present, return references for which a prefix of any of
      sourceAccessions match any of these strings. Accession numbers typically
      have a main number and a version, for example `GCF_000001405.26`.
    md5checksums: If present, return references for which the md5checksum
      matches exactly.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024. The maximum value is 4096.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceSetId: If present, return only references which belong to this
      reference set.
  """

  accessions = _messages.StringField(1, repeated=True)
  md5checksums = _messages.StringField(2, repeated=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  referenceSetId = _messages.StringField(5)


class SearchReferencesResponse(_messages.Message):
  r"""A SearchReferencesResponse object.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    references: The matching references.
  """

  nextPageToken = _messages.StringField(1)
  references = _messages.MessageField('Reference', 2, repeated=True)


class SearchVariantSetsRequest(_messages.Message):
  r"""The search variant sets request.

  Fields:
    datasetIds: Exactly one dataset ID must be provided here. Only variant
      sets which belong to this dataset will be returned.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
  """

  datasetIds = _messages.StringField(1, repeated=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class SearchVariantSetsResponse(_messages.Message):
  r"""The search variant sets response.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    variantSets: The variant sets belonging to the requested dataset.
  """

  nextPageToken = _messages.StringField(1)
  variantSets = _messages.MessageField('VariantSet', 2, repeated=True)


class SearchVariantsRequest(_messages.Message):
  r"""The variant search request.

  Fields:
    callSetIds: Only return variant calls which belong to call sets with these
      ids. Leaving this blank returns all variant calls. If a variant has no
      calls belonging to any of these call sets, it won't be returned at all.
    end: The end of the window, 0-based exclusive. If unspecified or 0,
      defaults to the length of the reference.
    maxCalls: The maximum number of calls to return in a single page. Note
      that this limit may be exceeded in the event that a matching variant
      contains more calls than the requested maximum. If unspecified, defaults
      to 5000. The maximum value is 10000.
    pageSize: The maximum number of variants to return in a single page. If
      unspecified, defaults to 5000. The maximum value is 10000.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceName: Required. Only return variants in this reference sequence.
    start: The beginning of the window (0-based, inclusive) for which
      overlapping variants should be returned. If unspecified, defaults to 0.
    variantName: Only return variants which have exactly this name.
    variantSetIds: At most one variant set ID must be provided. Only variants
      from this variant set will be returned. If omitted, a call set id must
      be included in the request.
  """

  callSetIds = _messages.StringField(1, repeated=True)
  end = _messages.IntegerField(2)
  maxCalls = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  referenceName = _messages.StringField(6)
  start = _messages.IntegerField(7)
  variantName = _messages.StringField(8)
  variantSetIds = _messages.StringField(9, repeated=True)


class SearchVariantsResponse(_messages.Message):
  r"""The variant search response.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    variants: The list of matching Variants.
  """

  nextPageToken = _messages.StringField(1)
  variants = _messages.MessageField('Variant', 2, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: REQUIRED: The set of permissions to check for the 'resource'.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      Allowed permissions are&#58;  * `genomics.datasets.create` *
      `genomics.datasets.delete` * `genomics.datasets.get` *
      `genomics.datasets.list` * `genomics.datasets.update` *
      `genomics.datasets.getIamPolicy` * `genomics.datasets.setIamPolicy`
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Transcript(_messages.Message):
  r"""A transcript represents the assertion that a particular region of the
  reference genome may be transcribed as RNA.

  Fields:
    codingSequence: The range of the coding sequence for this transcript, if
      any. To determine the exact ranges of coding sequence, intersect this
      range with those of the exons, if any. If there are any exons, the
      codingSequence must start and end within them.  Note that in some cases,
      the reference genome will not exactly match the observed mRNA transcript
      e.g. due to variance in the source genome from reference. In these
      cases, exon.frame will not necessarily match the expected reference
      reading frame and coding exon reference bases cannot necessarily be
      concatenated to produce the original transcript mRNA.
    exons: The <a href="http://en.wikipedia.org/wiki/Exon">exons</a> that
      compose this transcript. This field should be unset for genomes where
      transcript splicing does not occur, for example prokaryotes.  Introns
      are regions of the transcript that are not included in the spliced RNA
      product. Though not explicitly modeled here, intron ranges can be
      deduced; all regions of this transcript that are not exons are introns.
      Exonic sequences do not necessarily code for a translational product
      (amino acids). Only the regions of exons bounded by the codingSequence
      correspond to coding DNA sequence.  Exons are ordered by start position
      and may not overlap.
    geneId: The annotation ID of the gene from which this transcript is
      transcribed.
  """

  codingSequence = _messages.MessageField('CodingSequence', 1)
  exons = _messages.MessageField('Exon', 2, repeated=True)
  geneId = _messages.StringField(3)


class UndeleteDatasetRequest(_messages.Message):
  r"""A UndeleteDatasetRequest object."""


class UnexpectedExitStatusEvent(_messages.Message):
  r"""An event generated when the execution of a container results in a non-
  zero exit status that was not otherwise ignored. Execution will continue,
  but only actions that are flagged as `ALWAYS_RUN` will be executed. Other
  actions will be skipped.

  Fields:
    actionId: The numeric ID of the action that started the container.
    exitStatus: The exit status of the container.
  """

  actionId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  exitStatus = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Variant(_messages.Message):
  r"""A variant represents a change in DNA sequence relative to a reference
  sequence. For example, a variant could represent a SNP or an insertion.
  Variants belong to a variant set.  Each of the calls on a variant represent
  a determination of genotype with respect to that variant. For example, a
  call might assign probability of 0.32 to the occurrence of a SNP named
  rs1234 in a sample named NA12345. A call belongs to a call set, which
  contains related calls typically from one sample.

  Messages:
    InfoValue: A map of additional variant information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    alternateBases: The bases that appear instead of the reference bases.
    calls: The variant calls for this particular variant. Each one represents
      the determination of genotype with respect to this variant.
    created: The date this variant was created, in milliseconds from the
      epoch.
    end: The end position (0-based) of this variant. This corresponds to the
      first base after the last base in the reference allele. So, the length
      of the reference allele is (end - start). This is useful for variants
      that don't explicitly give alternate bases, for example large deletions.
    filter: A list of filters (normally quality filters) this variant has
      failed. `PASS` indicates this variant has passed all filters.
    id: The server-generated variant ID, unique across all variants.
    info: A map of additional variant information. This must be of the form
      map<string, string[]> (string key mapping to a list of string values).
    names: Names for the variant, for example a RefSNP ID.
    quality: A measure of how likely this variant is to be real. A higher
      value is better.
    referenceBases: The reference bases for this variant. They start at the
      given position.
    referenceName: The reference on which this variant occurs. (such as
      `chr20` or `X`)
    start: The position at which this variant occurs (0-based). This
      corresponds to the first base of the string of reference bases.
    variantSetId: The ID of the variant set this variant belongs to.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional variant information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  alternateBases = _messages.StringField(1, repeated=True)
  calls = _messages.MessageField('VariantCall', 2, repeated=True)
  created = _messages.IntegerField(3)
  end = _messages.IntegerField(4)
  filter = _messages.StringField(5, repeated=True)
  id = _messages.StringField(6)
  info = _messages.MessageField('InfoValue', 7)
  names = _messages.StringField(8, repeated=True)
  quality = _messages.FloatField(9)
  referenceBases = _messages.StringField(10)
  referenceName = _messages.StringField(11)
  start = _messages.IntegerField(12)
  variantSetId = _messages.StringField(13)


class VariantAnnotation(_messages.Message):
  r"""A VariantAnnotation object.

  Enums:
    ClinicalSignificanceValueValuesEnum: Describes the clinical significance
      of a variant. It is adapted from the ClinVar controlled vocabulary for
      clinical significance described at:
      http://www.ncbi.nlm.nih.gov/clinvar/docs/clinsig/
    EffectValueValuesEnum: Effect of the variant on the coding sequence.
    TypeValueValuesEnum: Type has been adapted from ClinVar's list of variant
      types.

  Fields:
    alternateBases: The alternate allele for this variant. If multiple
      alternate alleles exist at this location, create a separate variant for
      each one, as they may represent distinct conditions.
    clinicalSignificance: Describes the clinical significance of a variant. It
      is adapted from the ClinVar controlled vocabulary for clinical
      significance described at:
      http://www.ncbi.nlm.nih.gov/clinvar/docs/clinsig/
    conditions: The set of conditions associated with this variant. A
      condition describes the way a variant influences human health.
    effect: Effect of the variant on the coding sequence.
    geneId: Google annotation ID of the gene affected by this variant. This
      should be provided when the variant is created.
    transcriptIds: Google annotation IDs of the transcripts affected by this
      variant. These should be provided when the variant is created.
    type: Type has been adapted from ClinVar's list of variant types.
  """

  class ClinicalSignificanceValueValuesEnum(_messages.Enum):
    r"""Describes the clinical significance of a variant. It is adapted from
    the ClinVar controlled vocabulary for clinical significance described at:
    http://www.ncbi.nlm.nih.gov/clinvar/docs/clinsig/

    Values:
      CLINICAL_SIGNIFICANCE_UNSPECIFIED: <no description>
      CLINICAL_SIGNIFICANCE_OTHER: `OTHER` should be used when no other
        clinical significance value will suffice.
      UNCERTAIN: <no description>
      BENIGN: <no description>
      LIKELY_BENIGN: <no description>
      LIKELY_PATHOGENIC: <no description>
      PATHOGENIC: <no description>
      DRUG_RESPONSE: <no description>
      HISTOCOMPATIBILITY: <no description>
      CONFERS_SENSITIVITY: <no description>
      RISK_FACTOR: <no description>
      ASSOCIATION: <no description>
      PROTECTIVE: <no description>
      MULTIPLE_REPORTED: `MULTIPLE_REPORTED` should be used when multiple
        clinical signficances are reported for a variant. The original
        clinical significance values may be provided in the `info` field.
    """
    CLINICAL_SIGNIFICANCE_UNSPECIFIED = 0
    CLINICAL_SIGNIFICANCE_OTHER = 1
    UNCERTAIN = 2
    BENIGN = 3
    LIKELY_BENIGN = 4
    LIKELY_PATHOGENIC = 5
    PATHOGENIC = 6
    DRUG_RESPONSE = 7
    HISTOCOMPATIBILITY = 8
    CONFERS_SENSITIVITY = 9
    RISK_FACTOR = 10
    ASSOCIATION = 11
    PROTECTIVE = 12
    MULTIPLE_REPORTED = 13

  class EffectValueValuesEnum(_messages.Enum):
    r"""Effect of the variant on the coding sequence.

    Values:
      EFFECT_UNSPECIFIED: <no description>
      EFFECT_OTHER: `EFFECT_OTHER` should be used when no other Effect will
        suffice.
      FRAMESHIFT: `FRAMESHIFT` indicates a mutation in which the insertion or
        deletion of nucleotides resulted in a frameshift change.
      FRAME_PRESERVING_INDEL: `FRAME_PRESERVING_INDEL` indicates a mutation in
        which a multiple of three nucleotides has been inserted or deleted,
        resulting in no change to the reading frame of the coding sequence.
      SYNONYMOUS_SNP: `SYNONYMOUS_SNP` indicates a single nucleotide
        polymorphism mutation that results in no amino acid change.
      NONSYNONYMOUS_SNP: `NONSYNONYMOUS_SNP` indicates a single nucleotide
        polymorphism mutation that results in an amino acid change.
      STOP_GAIN: `STOP_GAIN` indicates a mutation that leads to the creation
        of a stop codon at the variant site. Frameshift mutations creating
        downstream stop codons do not count as `STOP_GAIN`.
      STOP_LOSS: `STOP_LOSS` indicates a mutation that eliminates a stop codon
        at the variant site.
      SPLICE_SITE_DISRUPTION: `SPLICE_SITE_DISRUPTION` indicates that this
        variant is found in a splice site for the associated transcript, and
        alters the normal splicing pattern.
    """
    EFFECT_UNSPECIFIED = 0
    EFFECT_OTHER = 1
    FRAMESHIFT = 2
    FRAME_PRESERVING_INDEL = 3
    SYNONYMOUS_SNP = 4
    NONSYNONYMOUS_SNP = 5
    STOP_GAIN = 6
    STOP_LOSS = 7
    SPLICE_SITE_DISRUPTION = 8

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type has been adapted from ClinVar's list of variant types.

    Values:
      TYPE_UNSPECIFIED: <no description>
      TYPE_OTHER: `TYPE_OTHER` should be used when no other Type will suffice.
        Further explanation of the variant type may be included in the info
        field.
      INSERTION: `INSERTION` indicates an insertion.
      DELETION: `DELETION` indicates a deletion.
      SUBSTITUTION: `SUBSTITUTION` indicates a block substitution of two or
        more nucleotides.
      SNP: `SNP` indicates a single nucleotide polymorphism.
      STRUCTURAL: `STRUCTURAL` indicates a large structural variant, including
        chromosomal fusions, inversions, etc.
      CNV: `CNV` indicates a variation in copy number.
    """
    TYPE_UNSPECIFIED = 0
    TYPE_OTHER = 1
    INSERTION = 2
    DELETION = 3
    SUBSTITUTION = 4
    SNP = 5
    STRUCTURAL = 6
    CNV = 7

  alternateBases = _messages.StringField(1)
  clinicalSignificance = _messages.EnumField('ClinicalSignificanceValueValuesEnum', 2)
  conditions = _messages.MessageField('ClinicalCondition', 3, repeated=True)
  effect = _messages.EnumField('EffectValueValuesEnum', 4)
  geneId = _messages.StringField(5)
  transcriptIds = _messages.StringField(6, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class VariantCall(_messages.Message):
  r"""A call represents the determination of genotype with respect to a
  particular variant. It may include associated information such as quality
  and phasing. For example, a call might assign a probability of 0.32 to the
  occurrence of a SNP named rs1234 in a call set with the name NA12345.

  Messages:
    InfoValue: A map of additional variant call information. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    callSetId: The ID of the call set this variant call belongs to.
    callSetName: The name of the call set this variant call belongs to.
    genotype: The genotype of this variant call. Each value represents either
      the value of the `referenceBases` field or a 1-based index into
      `alternateBases`. If a variant had a `referenceBases` value of `T` and
      an `alternateBases` value of `["A", "C"]`, and the `genotype` was `[2,
      1]`, that would mean the call represented the heterozygous value `CA`
      for this variant. If the `genotype` was instead `[0, 1]`, the
      represented value would be `TA`. Ordering of the genotype values is
      important if the `phaseset` is present. If a genotype is not called
      (that is, a `.` is present in the GT string) -1 is returned.
    genotypeLikelihood: The genotype likelihoods for this variant call. Each
      array entry represents how likely a specific genotype is for this call.
      The value ordering is defined by the GL tag in the VCF spec. If Phred-
      scaled genotype likelihood scores (PL) are available and log10(P)
      genotype likelihood scores (GL) are not, PL scores are converted to GL
      scores.  If both are available, PL scores are stored in `info`.
    info: A map of additional variant call information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    phaseset: If this field is present, this variant call's genotype ordering
      implies the phase of the bases and is consistent with any other variant
      calls in the same reference sequence which have the same phaseset value.
      When importing data from VCF, if the genotype data was phased but no
      phase set was specified this field will be set to `*`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""A map of additional variant call information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  callSetId = _messages.StringField(1)
  callSetName = _messages.StringField(2)
  genotype = _messages.IntegerField(3, repeated=True, variant=_messages.Variant.INT32)
  genotypeLikelihood = _messages.FloatField(4, repeated=True)
  info = _messages.MessageField('InfoValue', 5)
  phaseset = _messages.StringField(6)


class VariantSet(_messages.Message):
  r"""A variant set is a collection of call sets and variants. It contains
  summary statistics of those contents. A variant set belongs to a dataset.

  Fields:
    datasetId: The dataset to which this variant set belongs.
    description: A textual description of this variant set.
    id: The server-generated variant set ID, unique across all variant sets.
    metadata: The metadata associated with this variant set.
    name: User-specified, mutable name.
    referenceBounds: A list of all references used by the variants in a
      variant set with associated coordinate upper bounds for each one.
    referenceSetId: The reference set to which the variant set is mapped. The
      reference set describes the alignment provenance of the variant set,
      while the `referenceBounds` describe the shape of the actual variant
      data. The reference set's reference names are a superset of those found
      in the `referenceBounds`.  For example, given a variant set that is
      mapped to the GRCh38 reference set and contains a single variant on
      reference 'X', `referenceBounds` would contain only an entry for 'X',
      while the associated reference set enumerates all possible references:
      '1', '2', 'X', 'Y', 'MT', etc.
  """

  datasetId = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.StringField(3)
  metadata = _messages.MessageField('VariantSetMetadata', 4, repeated=True)
  name = _messages.StringField(5)
  referenceBounds = _messages.MessageField('ReferenceBound', 6, repeated=True)
  referenceSetId = _messages.StringField(7)


class VariantSetMetadata(_messages.Message):
  r"""Metadata describes a single piece of variant call metadata. These data
  include a top level key and either a single value string (value) or a list
  of key-value pairs (info.) Value and info are mutually exclusive.

  Enums:
    TypeValueValuesEnum: The type of data. Possible types include: Integer,
      Float, Flag, Character, and String.

  Messages:
    InfoValue: Remaining structured metadata key-value pairs. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    description: A textual description of this metadata.
    id: User-provided ID field, not enforced by this API. Two or more pieces
      of structured metadata with identical id and key fields are considered
      equivalent.
    info: Remaining structured metadata key-value pairs. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    key: The top-level key.
    number: The number of values that can be included in a field described by
      this metadata.
    type: The type of data. Possible types include: Integer, Float, Flag,
      Character, and String.
    value: The value field for simple metadata
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of data. Possible types include: Integer, Float, Flag,
    Character, and String.

    Values:
      TYPE_UNSPECIFIED: <no description>
      INTEGER: <no description>
      FLOAT: <no description>
      FLAG: <no description>
      CHARACTER: <no description>
      STRING: <no description>
    """
    TYPE_UNSPECIFIED = 0
    INTEGER = 1
    FLOAT = 2
    FLAG = 3
    CHARACTER = 4
    STRING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    r"""Remaining structured metadata key-value pairs. This must be of the
    form map<string, string[]> (string key mapping to a list of string
    values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  id = _messages.StringField(2)
  info = _messages.MessageField('InfoValue', 3)
  key = _messages.StringField(4)
  number = _messages.StringField(5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  value = _messages.StringField(7)


class WorkerAssignedEvent(_messages.Message):
  r"""An event generated after a worker VM has been assigned to run the
  pipeline.

  Fields:
    instance: The worker's instance name.
    zone: The zone the worker is running in.
  """

  instance = _messages.StringField(1)
  zone = _messages.StringField(2)


class WorkerReleasedEvent(_messages.Message):
  r"""An event generated when the worker VM that was assigned to the pipeline
  has been released (deleted).

  Fields:
    instance: The worker's instance name.
    zone: The zone the worker was running in.
  """

  instance = _messages.StringField(1)
  zone = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
