"""Generated message classes for edge version v1alpha1.

Provides Cloud IoT Edge devices control APIs
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'edge'


class Container(_messages.Message):
  r"""Data used to control Container related things in Edge service.

  Messages:
    EnvironmentVariablesValue: The environment_variables key-value pairs will
      be set as environment variable when the docker container is started.

  Fields:
    autostart: If autostart is true, this container will be started right
      after the edge config is deployed to device.
    availableMemoryMb: Maximum memory size assigned to the docker container,
      in MB.
    description: Description of the edge container.
    deviceBindings: List of device bindings.
    dockerImageUri: URI that points to edge container in Google Container
      Registry.
    environmentVariables: The environment_variables key-value pairs will be
      set as environment variable when the docker container is started.
    inputTopics: List of input topics.
    name: Name of edge container. It must be unique among the edge containers
      running on the same edge device. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/containers/c1`.
    outputTopics: List of output topics.
    updateTime: Output only. Last updated time of this container config. This
      is assigned by Edge Manager API.
    version: Output only. Version of this container config. This is assigned
      by Edge Manager API.
    volumeBindings: List of volume bindings.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvironmentVariablesValue(_messages.Message):
    r"""The environment_variables key-value pairs will be set as environment
    variable when the docker container is started.

    Messages:
      AdditionalProperty: An additional property for a
        EnvironmentVariablesValue object.

    Fields:
      additionalProperties: Additional properties of type
        EnvironmentVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvironmentVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  autostart = _messages.BooleanField(1)
  availableMemoryMb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  description = _messages.StringField(3)
  deviceBindings = _messages.MessageField('DeviceBinding', 4, repeated=True)
  dockerImageUri = _messages.StringField(5)
  environmentVariables = _messages.MessageField('EnvironmentVariablesValue', 6)
  inputTopics = _messages.MessageField('TopicInfo', 7, repeated=True)
  name = _messages.StringField(8)
  outputTopics = _messages.MessageField('TopicInfo', 9, repeated=True)
  updateTime = _messages.StringField(10)
  version = _messages.IntegerField(11)
  volumeBindings = _messages.MessageField('VolumeBinding', 12, repeated=True)


class ContainerState(_messages.Message):
  r"""Indicates the state of an edge container.

  Enums:
    StateValueValuesEnum: State of the container, For example, `RUNNING` or
      `ERROR`.

  Fields:
    container: Name of the container. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/containers/c1`.
    dockerImageUri: URI of the deployed container in Google Container
      Registry. This value should be matched to the docker_image_uri field of
      Container message.
    state: State of the container, For example, `RUNNING` or `ERROR`.
    version: Version number of deployed edge container config. This value
      should be matched to the version of Container of the latest deployed
      config.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the container, For example, `RUNNING` or `ERROR`.

    Values:
      JOB_STATE_UNSPECIFIED: Unspecified.
      RUNNING: Job is running.
      ERROR: An error occurred.
    """
    JOB_STATE_UNSPECIFIED = 0
    RUNNING = 1
    ERROR = 2

  container = _messages.StringField(1)
  dockerImageUri = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  version = _messages.IntegerField(4)


class DeployableFunction(_messages.Message):
  r"""Indicates an edge function in Google Container Registry.

  Fields:
    container: Output only. Name of the container.
    dockerImageUri: Output only. URI of the container.
  """

  container = _messages.StringField(1)
  dockerImageUri = _messages.StringField(2)


class DeviceBinding(_messages.Message):
  r"""Defines the rules to bind local(edge device) resources to sandboxed
  environment(edge function or container).

  Fields:
    cgroupPermissions: cgroup permissions that will be given to the resource.
    destination: Absolute path where the resource is bound in the function or
      container.
    source: Absolute path to the resource of the edge device to be bound.
  """

  cgroupPermissions = _messages.StringField(1)
  destination = _messages.StringField(2)
  source = _messages.StringField(3)


class EdgeProjectsDeployableFunctionsListRequest(_messages.Message):
  r"""A EdgeProjectsDeployableFunctionsListRequest object.

  Fields:
    pageSize: The standard list page size.
    pageToken: Pagination token for next page of results.
    parent: The project name. The list of deployable functions in given
      project will be returned.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class EdgeProjectsLocationsRegistriesDevicesContainersCreateRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesContainersCreateRequest object.

  Fields:
    container: A Container resource to be passed as the request body.
    parent: The device resource name of Cloud IoT Device in which container
      will be created.
  """

  container = _messages.MessageField('Container', 1)
  parent = _messages.StringField(2, required=True)


class EdgeProjectsLocationsRegistriesDevicesContainersDeleteRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesContainersDeleteRequest object.

  Fields:
    name: The resource name of Cloud IoT Device.
  """

  name = _messages.StringField(1, required=True)


class EdgeProjectsLocationsRegistriesDevicesContainersGetRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesContainersGetRequest object.

  Fields:
    name: The container resource name of Cloud IoT Device.
  """

  name = _messages.StringField(1, required=True)


class EdgeProjectsLocationsRegistriesDevicesContainersListRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesContainersListRequest object.

  Fields:
    fieldMask: Mask to control the fields to retrieve. If empty, all fileds
      are retrieved.
    pageSize: The standard list page size.
    pageToken: Pagination token for next page of results.
    parent: The device resource name of Cloud IoT Device in which containers
      will be displayed.
  """

  fieldMask = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class EdgeProjectsLocationsRegistriesDevicesContainersPatchRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesContainersPatchRequest object.

  Fields:
    container: A Container resource to be passed as the request body.
    name: Name of edge container. It must be unique among the edge containers
      running on the same edge device. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/containers/c1`.
    updateMask: Mask to control the fields to update. If empty, all fileds are
      updated.
  """

  container = _messages.MessageField('Container', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class EdgeProjectsLocationsRegistriesDevicesFunctionsCreateRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesFunctionsCreateRequest object.

  Fields:
    function: A Function resource to be passed as the request body.
    parent: The device resource name of Cloud IoT Device in which function
      will be created.
  """

  function = _messages.MessageField('Function', 1)
  parent = _messages.StringField(2, required=True)


class EdgeProjectsLocationsRegistriesDevicesFunctionsDeleteRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesFunctionsDeleteRequest object.

  Fields:
    name: The function resource name of Cloud IoT Device.
  """

  name = _messages.StringField(1, required=True)


class EdgeProjectsLocationsRegistriesDevicesFunctionsGetRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesFunctionsGetRequest object.

  Fields:
    name: The function resource name of Cloud IoT Device.
  """

  name = _messages.StringField(1, required=True)


class EdgeProjectsLocationsRegistriesDevicesFunctionsListRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesFunctionsListRequest object.

  Fields:
    fieldMask: Mask to control the fields to retrieve. If empty, all fileds
      are retrieved.
    pageSize: The standard list page size.
    pageToken: Pagination token for next page of results.
    parent: The device resource name of Cloud IoT Device in which functions
      will be displayed.
  """

  fieldMask = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class EdgeProjectsLocationsRegistriesDevicesFunctionsPatchRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesFunctionsPatchRequest object.

  Fields:
    function: A Function resource to be passed as the request body.
    name: Name of the edge function. It must be unique among the edge
      functions running on the same edge device. For example,
      `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/functions/f1`.
    updateMask: Mask to control the fields to update. If empty, all fileds are
      updated.
  """

  function = _messages.MessageField('Function', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class EdgeProjectsLocationsRegistriesDevicesGetStateRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesGetStateRequest object.

  Fields:
    fieldMask: Mask to control the fields to retrieve. If empty, all fileds
      are retrieved.
    name: The device resource name of Cloud IoT Device.
  """

  fieldMask = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class EdgeProjectsLocationsRegistriesDevicesGetTopicBridgingTableRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesGetTopicBridgingTableRequest
  object.

  Fields:
    name: The topic bridging table resource name of Cloud IoT Device. It
      should be same as device name. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0`
  """

  name = _messages.StringField(1, required=True)


class EdgeProjectsLocationsRegistriesDevicesInitRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesInitRequest object.

  Fields:
    initAsEdgeDeviceRequest: A InitAsEdgeDeviceRequest resource to be passed
      as the request body.
    name: The device resource name of Cloud IoT Device.
  """

  initAsEdgeDeviceRequest = _messages.MessageField('InitAsEdgeDeviceRequest', 1)
  name = _messages.StringField(2, required=True)


class EdgeProjectsLocationsRegistriesDevicesMlModelsCreateRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesMlModelsCreateRequest object.

  Fields:
    mlModel: A MlModel resource to be passed as the request body.
    parent: The device resource name of Cloud IoT Device in which ML model
      will be created.
  """

  mlModel = _messages.MessageField('MlModel', 1)
  parent = _messages.StringField(2, required=True)


class EdgeProjectsLocationsRegistriesDevicesMlModelsDeleteRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesMlModelsDeleteRequest object.

  Fields:
    name: The ML model resource name of Cloud IoT Device which will be
      deleted.
  """

  name = _messages.StringField(1, required=True)


class EdgeProjectsLocationsRegistriesDevicesMlModelsGetRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesMlModelsGetRequest object.

  Fields:
    name: The container resource name of Cloud IoT Device.
  """

  name = _messages.StringField(1, required=True)


class EdgeProjectsLocationsRegistriesDevicesMlModelsListRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesMlModelsListRequest object.

  Fields:
    fieldMask: Mask to control the fields to retrieve. If empty, all fileds
      are retrieved.
    pageSize: The standard list page size.
    pageToken: Pagination token for next page of results.
    parent: The device resource name of Cloud IoT Device in which ML Models
      will be displayed.
  """

  fieldMask = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class EdgeProjectsLocationsRegistriesDevicesMlModelsPatchRequest(_messages.Message):
  r"""A EdgeProjectsLocationsRegistriesDevicesMlModelsPatchRequest object.

  Fields:
    mlModel: A MlModel resource to be passed as the request body.
    name: Name of the ML model. It must be unique among the ML models running
      on the same edge device. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/mlModels/m1`.
    updateMask: Mask to control the fields to update. If empty, all fileds are
      updated.
  """

  mlModel = _messages.MessageField('MlModel', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class EdgeState(_messages.Message):
  r"""Indicates the state of edge device and edge runtime.

  Fields:
    containerStates: Indicates the states of edge containers running on the
      edge device.
    functionStates: Indicates the states of edge functions running on the edge
      device.
    mlModelStates: Indicates the states of ML models running on the edge
      device.
    systemState: State of the edge device.
  """

  containerStates = _messages.MessageField('ContainerState', 1, repeated=True)
  functionStates = _messages.MessageField('FunctionState', 2, repeated=True)
  mlModelStates = _messages.MessageField('MlModelState', 3, repeated=True)
  systemState = _messages.MessageField('SystemState', 4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Function(_messages.Message):
  r"""Data used to control Edge Function related things in Edge service.

  Enums:
    FunctionTypeValueValuesEnum: Type of the function. A function may be
      invoked when a message is published(on demand) or be running for stream
      processing.

  Messages:
    EnvironmentVariablesValue: The environment_variables key-value pairs will
      be set as environment variable when the docker container is started.

  Fields:
    availableMemoryMb: Maximum memory size assigned to the docker container,
      in MB.
    description: Description of the edge function.
    deviceBindings: List of device bindings.
    dockerImageUri: URI that points to edge function in Google Container
      Registry.
    entryPoint: Name of the entry point function. The function will be called
      every time a message is published to one of the input_topics.
    environmentVariables: The environment_variables key-value pairs will be
      set as environment variable when the docker container is started.
    functionType: Type of the function. A function may be invoked when a
      message is published(on demand) or be running for stream processing.
    inputTopics: List of input topics.
    name: Name of the edge function. It must be unique among the edge
      functions running on the same edge device. For example,
      `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/functions/f1`.
    outputTopics: List of output topics.
    requestTimeout: Timeout for one request to this edge function.
    updateTime: Output only. Last updated time of this function config. This
      is assigned by Edge Manager API.
    version: Output only. Version number of this function config. This is
      assigned by Edge Manager API.
    volumeBindings: List of volume bindings.
  """

  class FunctionTypeValueValuesEnum(_messages.Enum):
    r"""Type of the function. A function may be invoked when a message is
    published(on demand) or be running for stream processing.

    Values:
      FUNCTION_TYPE_UNSPECIFIED: Default value, used when its value
        unspecified.
      ON_DEMAND: If a function is of type ON_DEMAND, the function will be
        invoked only when a message is published to one of `input_topics`.
      STREAM_PROCESSING: If a function is of type STREAM_PROCESSING, the
        function will be started when it is deployed for stream processing.
    """
    FUNCTION_TYPE_UNSPECIFIED = 0
    ON_DEMAND = 1
    STREAM_PROCESSING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvironmentVariablesValue(_messages.Message):
    r"""The environment_variables key-value pairs will be set as environment
    variable when the docker container is started.

    Messages:
      AdditionalProperty: An additional property for a
        EnvironmentVariablesValue object.

    Fields:
      additionalProperties: Additional properties of type
        EnvironmentVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvironmentVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  availableMemoryMb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  description = _messages.StringField(2)
  deviceBindings = _messages.MessageField('DeviceBinding', 3, repeated=True)
  dockerImageUri = _messages.StringField(4)
  entryPoint = _messages.StringField(5)
  environmentVariables = _messages.MessageField('EnvironmentVariablesValue', 6)
  functionType = _messages.EnumField('FunctionTypeValueValuesEnum', 7)
  inputTopics = _messages.MessageField('TopicInfo', 8, repeated=True)
  name = _messages.StringField(9)
  outputTopics = _messages.MessageField('TopicInfo', 10, repeated=True)
  requestTimeout = _messages.StringField(11)
  updateTime = _messages.StringField(12)
  version = _messages.IntegerField(13)
  volumeBindings = _messages.MessageField('VolumeBinding', 14, repeated=True)


class FunctionState(_messages.Message):
  r"""Indicates the state of an edge function.

  Enums:
    StateValueValuesEnum: State of the function, For example, `RUNNING` or
      `ERROR`.

  Fields:
    dockerImageUri: URI of the deployed container in Google Container
      Registry. This value should be matched to the docker_image_uri field of
      Function message.
    function: Name of the function. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/functions/f1`.
    state: State of the function, For example, `RUNNING` or `ERROR`.
    version: Version number of deployed edge function config. This value
      should be matched to the version of Function of the latest deployed
      config.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the function, For example, `RUNNING` or `ERROR`.

    Values:
      JOB_STATE_UNSPECIFIED: Unspecified.
      RUNNING: Job is running.
      ERROR: An error occurred.
    """
    JOB_STATE_UNSPECIFIED = 0
    RUNNING = 1
    ERROR = 2

  dockerImageUri = _messages.StringField(1)
  function = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  version = _messages.IntegerField(4)


class InitAsEdgeDeviceRequest(_messages.Message):
  r"""Request for 'InitAsEdgeDevice'."""


class ListContainersResponse(_messages.Message):
  r"""Response for 'ListContainers'.

  Fields:
    containers: The list of container.
    nextPageToken: Pagination token for next page of results.
  """

  containers = _messages.MessageField('Container', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDeployableFunctionsResponse(_messages.Message):
  r"""Response for 'ListDeployableFunctions'.

  Fields:
    deployableFunctions: List of deployable functions.
    nextPageToken: Pagination token for next page of results.
  """

  deployableFunctions = _messages.MessageField('DeployableFunction', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFunctionsResponse(_messages.Message):
  r"""Response for 'ListFunctions'.

  Fields:
    functions: List of functions.
    nextPageToken: Pagination token for next page of results.
  """

  functions = _messages.MessageField('Function', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMlModelsResponse(_messages.Message):
  r"""Response for 'ListMlModels'.

  Fields:
    mlModels: The list of ML Models.
    nextPageToken: Pagination token for next page of results.
  """

  mlModels = _messages.MessageField('MlModel', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class MlModel(_messages.Message):
  r"""Data used to control MlModel related things in Edge service.

  Enums:
    AcceleratorTypeValueValuesEnum: Type of device accelerator
    FrameworkValueValuesEnum: Type of framework

  Fields:
    acceleratorType: Type of device accelerator
    description: Description of the edge ml model.
    framework: Type of framework
    inputTensors: List of input tensors.
    inputTopics: List of input topics.
    modelUri: URI that points to ML model file of Google Cloud Storage.
    name: Name of the ML model. It must be unique among the ML models running
      on the same edge device. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/mlModels/m1`.
    numTfliteThreads: Number of threads that are spawned by TF Lite.
    outputTensors: List of output tensors.
    outputTopics: List of output topics.
    requestTimeout: Timeout for one request to this ML model.
    updateTime: Output only. Last updated time of this ml model config. This
      is assigned by Edge Manager API.
    version: Output only. Version of this ML model config. This is assigned by
      Edge Manager API.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Type of device accelerator

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Default value, used when its value
        unspecified.
      TPU: TPU, tensor processing unit.
      GPU: GPU, graphics processing unit.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    TPU = 1
    GPU = 2

  class FrameworkValueValuesEnum(_messages.Enum):
    r"""Type of framework

    Values:
      FRAMEWORK_UNSPECIFIED: Default value, used when its value unspecified.
      TFLITE: TFlite framework
      SCIKIT_LEARN: Scikit-learn framework
    """
    FRAMEWORK_UNSPECIFIED = 0
    TFLITE = 1
    SCIKIT_LEARN = 2

  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 1)
  description = _messages.StringField(2)
  framework = _messages.EnumField('FrameworkValueValuesEnum', 3)
  inputTensors = _messages.MessageField('TensorInfo', 4, repeated=True)
  inputTopics = _messages.MessageField('TopicInfo', 5, repeated=True)
  modelUri = _messages.StringField(6)
  name = _messages.StringField(7)
  numTfliteThreads = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  outputTensors = _messages.MessageField('TensorInfo', 9, repeated=True)
  outputTopics = _messages.MessageField('TopicInfo', 10, repeated=True)
  requestTimeout = _messages.StringField(11)
  updateTime = _messages.StringField(12)
  version = _messages.IntegerField(13)


class MlModelState(_messages.Message):
  r"""Indicates the state of an ML model.

  Enums:
    StateValueValuesEnum: State of the ML model, For example, `RUNNING` or
      `ERROR`.

  Fields:
    mlModel: Name of the ML model. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0/mlModels/m1`.
    modelUri: URI that points to ML model file in Google Cloud Storage. This
      value should be matched to the model_uri field of MlModel message.
    state: State of the ML model, For example, `RUNNING` or `ERROR`.
    version: Version number of deployed ML model config. This value should be
      matched to the version of MlModel of the latest deployed config.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the ML model, For example, `RUNNING` or `ERROR`.

    Values:
      JOB_STATE_UNSPECIFIED: Unspecified.
      RUNNING: Job is running.
      ERROR: An error occurred.
    """
    JOB_STATE_UNSPECIFIED = 0
    RUNNING = 1
    ERROR = 2

  mlModel = _messages.StringField(1)
  modelUri = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  version = _messages.IntegerField(4)


class Rule(_messages.Message):
  r"""Defines rules between topics.

  Enums:
    DestinationDomainValueValuesEnum: The destination of the messages to be
      republished.
    OperationValueValuesEnum: Indicates which action will be applied. If
      FORWARD, the messages will be imported from cloud to edge or exported
      from edge to cloud. If REWRITE, the messages will be republished within
      the edge device with new topic name, that is defined in
      `rewrite_topic_name`.
    SourceDomainValueValuesEnum: The source of the messages to be rewritten.

  Fields:
    destinationDomain: The destination of the messages to be republished.
    operation: Indicates which action will be applied. If FORWARD, the
      messages will be imported from cloud to edge or exported from edge to
      cloud. If REWRITE, the messages will be republished within the edge
      device with new topic name, that is defined in `rewrite_topic_name`.
    rewriteTopicName: The new topic name to be rewritten if the operation is
      REWRITE. Will be ignored if operation is FORWARD.
    sourceDomain: The source of the messages to be rewritten.
    sourceFilter: Indicates the topic filter of the messages to apply this
      rule.
  """

  class DestinationDomainValueValuesEnum(_messages.Enum):
    r"""The destination of the messages to be republished.

    Values:
      DOMAIN_UNSPECIFIED: Default value, used when its value unspecified.
      CLOUD: Cloud
      EDGE: Edge
    """
    DOMAIN_UNSPECIFIED = 0
    CLOUD = 1
    EDGE = 2

  class OperationValueValuesEnum(_messages.Enum):
    r"""Indicates which action will be applied. If FORWARD, the messages will
    be imported from cloud to edge or exported from edge to cloud. If REWRITE,
    the messages will be republished within the edge device with new topic
    name, that is defined in `rewrite_topic_name`.

    Values:
      OPERATION_UNSPECIFIED: Default value, used when its value unspecified.
      FORWARD: Forward the topic without changing the topic.
      REWRITE: Rewrite the message to the specified destination topic.
    """
    OPERATION_UNSPECIFIED = 0
    FORWARD = 1
    REWRITE = 2

  class SourceDomainValueValuesEnum(_messages.Enum):
    r"""The source of the messages to be rewritten.

    Values:
      DOMAIN_UNSPECIFIED: Default value, used when its value unspecified.
      CLOUD: Cloud
      EDGE: Edge
    """
    DOMAIN_UNSPECIFIED = 0
    CLOUD = 1
    EDGE = 2

  destinationDomain = _messages.EnumField('DestinationDomainValueValuesEnum', 1)
  operation = _messages.EnumField('OperationValueValuesEnum', 2)
  rewriteTopicName = _messages.StringField(3)
  sourceDomain = _messages.EnumField('SourceDomainValueValuesEnum', 4)
  sourceFilter = _messages.StringField(5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class SystemState(_messages.Message):
  r"""Indicates the state of the edge device.

  Enums:
    TpuInterfacesValueListEntryValuesEnum:

  Fields:
    cpuArch: CPU architecture, For example, `x86_64` or `armv7`.
    totalMemoryMb: Number of total memory of the device in MB.
    tpuInterfaces: Host TPU interfaces.
  """

  class TpuInterfacesValueListEntryValuesEnum(_messages.Enum):
    r"""TpuInterfacesValueListEntryValuesEnum enum type.

    Values:
      TPU_INTERFACE_UNSPECIFIED: <no description>
      PCI: <no description>
      USB: <no description>
    """
    TPU_INTERFACE_UNSPECIFIED = 0
    PCI = 1
    USB = 2

  cpuArch = _messages.StringField(1)
  totalMemoryMb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  tpuInterfaces = _messages.EnumField('TpuInterfacesValueListEntryValuesEnum', 3, repeated=True)


class TensorInfo(_messages.Message):
  r"""Indicates the info of input or output tensors of ML models.

  Enums:
    InferenceTypeValueValuesEnum: Type of the tensor.

  Fields:
    dimensions: Dimension description of the tensor.
    index: Index of the tensor in the input or output layer.
    inferenceType: Type of the tensor.
    tensorName: Name of the tensor.
  """

  class InferenceTypeValueValuesEnum(_messages.Enum):
    r"""Type of the tensor.

    Values:
      ML_INFERENCE_TYPE_UNSPECIFIED: Default value, used when its value
        unspecified.
      QUANTIZED_UINT_8: Quantized unsigned 8bit int.
      FLOAT_32: 32bit float.
    """
    ML_INFERENCE_TYPE_UNSPECIFIED = 0
    QUANTIZED_UINT_8 = 1
    FLOAT_32 = 2

  dimensions = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  index = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  inferenceType = _messages.EnumField('InferenceTypeValueValuesEnum', 3)
  tensorName = _messages.StringField(4)


class TopicBridgingTable(_messages.Message):
  r"""Describes the rules to rewrite the messages. Rewriting a message means
  importing/exporting the messages between edge device and cloud or publishing
  the same message with new topic name within the edge device.

  Fields:
    name: The name of the topic bridging table resource.
    rules: List of topic bridging rules.
    version: Output only. Version of this topic bridging table. This is
      assigned by Edge Manager API.
  """

  name = _messages.StringField(1)
  rules = _messages.MessageField('Rule', 2, repeated=True)
  version = _messages.IntegerField(3)


class TopicInfo(_messages.Message):
  r"""Defines the mapping rule between the topic names in broker and topic
  names used in edge functions or containers.

  Fields:
    id: Optional name associated with this topic.
    topic: The actual topic string.
  """

  id = _messages.StringField(1)
  topic = _messages.StringField(2)


class UpdateTopicBridgingTableRequest(_messages.Message):
  r"""A UpdateTopicBridgingTableRequest object.

  Fields:
    topicBridgingTable: The topic bridging table to be updated. The `name`
      field must indicate the path of the resource, which is same as device
      name. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0`
  """

  topicBridgingTable = _messages.MessageField('TopicBridgingTable', 1)


class VolumeBinding(_messages.Message):
  r"""Defines the rules to bind local(edge device) storage to sandboxed
  environment(edge function or container).

  Fields:
    destination: Absolute path where the resource is bound in the function or
      container.
    readOnly: If true, sandboxed environment only can read the path.
    source: Absolute path to the resource of the edge device to be bound.
  """

  destination = _messages.StringField(1)
  readOnly = _messages.BooleanField(2)
  source = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
