"""Generated message classes for videointelligence version v1.

Cloud Video Intelligence API.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'videointelligence'


class GoogleCloudVideointelligenceV1AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1AnnotateVideoRequest(_messages.Message):
  r"""Video annotation request.

  Enums:
    FeaturesValueListEntryValuesEnum:

  Fields:
    features: Requested video annotation features.
    inputContent: The video data bytes. If unset, the input video(s) should be
      specified via `input_uri`. If set, `input_uri` should be unset.
    inputUri: Input video location. Currently, only [Google Cloud
      Storage](https://cloud.google.com/storage/) URIs are supported, which
      must be specified in the following format: `gs://bucket-id/object-id`
      (other URI formats return google.rpc.Code.INVALID_ARGUMENT). For more
      information, see [Request URIs](/storage/docs/reference-uris). A video
      URI may include wildcards in `object-id`, and thus identify multiple
      videos. Supported wildcards: '*' to match 0 or more characters; '?' to
      match 1 character. If unset, the input video should be embedded in the
      request as `input_content`. If set, `input_content` should be unset.
    locationId: Optional cloud region where annotation should take place.
      Supported cloud regions: `us-east1`, `us-west1`, `europe-west1`, `asia-
      east1`. If no region is specified, a region will be determined based on
      video file location.
    outputUri: Optional location where the output (in JSON format) should be
      stored. Currently, only [Google Cloud
      Storage](https://cloud.google.com/storage/) URIs are supported, which
      must be specified in the following format: `gs://bucket-id/object-id`
      (other URI formats return google.rpc.Code.INVALID_ARGUMENT). For more
      information, see [Request URIs](/storage/docs/reference-uris).
    videoContext: Additional video context and/or feature-specific parameters.
  """

  class FeaturesValueListEntryValuesEnum(_messages.Enum):
    r"""FeaturesValueListEntryValuesEnum enum type.

    Values:
      FEATURE_UNSPECIFIED: <no description>
      LABEL_DETECTION: <no description>
      SHOT_CHANGE_DETECTION: <no description>
      EXPLICIT_CONTENT_DETECTION: <no description>
    """
    FEATURE_UNSPECIFIED = 0
    LABEL_DETECTION = 1
    SHOT_CHANGE_DETECTION = 2
    EXPLICIT_CONTENT_DETECTION = 3

  features = _messages.EnumField('FeaturesValueListEntryValuesEnum', 1, repeated=True)
  inputContent = _messages.BytesField(2)
  inputUri = _messages.StringField(3)
  locationId = _messages.StringField(4)
  outputUri = _messages.StringField(5)
  videoContext = _messages.MessageField('GoogleCloudVideointelligenceV1VideoContext', 6)


class GoogleCloudVideointelligenceV1AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g. `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1ExplicitContentFrame', 1, repeated=True)


class GoogleCloudVideointelligenceV1ExplicitContentDetectionConfig(_messages.Message):
  r"""Config for EXPLICIT_CONTENT_DETECTION.

  Fields:
    model: Model to use for explicit content detection. Supported values:
      "builtin/stable" (the default if unset) and "builtin/latest".
  """

  model = _messages.StringField(1)


class GoogleCloudVideointelligenceV1ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. E.g. when the
      label is `Terrier` the category is likely `dog`. And in some cases there
      might be more than one categories e.g. `Terrier` could also be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1LabelSegment', 4, repeated=True)


class GoogleCloudVideointelligenceV1LabelDetectionConfig(_messages.Message):
  r"""Config for LABEL_DETECTION.

  Enums:
    LabelDetectionModeValueValuesEnum: What labels should be detected with
      LABEL_DETECTION, in addition to video-level labels or segment-level
      labels. If unspecified, defaults to `SHOT_MODE`.

  Fields:
    labelDetectionMode: What labels should be detected with LABEL_DETECTION,
      in addition to video-level labels or segment-level labels. If
      unspecified, defaults to `SHOT_MODE`.
    model: Model to use for label detection. Supported values:
      "builtin/stable" (the default if unset) and "builtin/latest".
    stationaryCamera: Whether the video has been shot from a stationary (i.e.
      non-moving) camera. When set to true, might improve detection accuracy
      for moving objects. Should be used with `SHOT_AND_FRAME_MODE` enabled.
  """

  class LabelDetectionModeValueValuesEnum(_messages.Enum):
    r"""What labels should be detected with LABEL_DETECTION, in addition to
    video-level labels or segment-level labels. If unspecified, defaults to
    `SHOT_MODE`.

    Values:
      LABEL_DETECTION_MODE_UNSPECIFIED: Unspecified.
      SHOT_MODE: Detect shot-level labels.
      FRAME_MODE: Detect frame-level labels.
      SHOT_AND_FRAME_MODE: Detect both shot-level and frame-level labels.
    """
    LABEL_DETECTION_MODE_UNSPECIFIED = 0
    SHOT_MODE = 1
    FRAME_MODE = 2
    SHOT_AND_FRAME_MODE = 3

  labelDetectionMode = _messages.EnumField('LabelDetectionModeValueValuesEnum', 1)
  model = _messages.StringField(2)
  stationaryCamera = _messages.BooleanField(3)


class GoogleCloudVideointelligenceV1LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 2)


class GoogleCloudVideointelligenceV1ShotChangeDetectionConfig(_messages.Message):
  r"""Config for SHOT_CHANGE_DETECTION.

  Fields:
    model: Model to use for shot change detection. Supported values:
      "builtin/stable" (the default if unset) and "builtin/latest".
  """

  model = _messages.StringField(1)


class GoogleCloudVideointelligenceV1VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Fields:
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  inputUri = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class GoogleCloudVideointelligenceV1VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    segmentLabelAnnotations: Label annotations on video level or user
      specified segment level. There is exactly one element for each unique
      label.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Label annotations on shot level. There is exactly
      one element for each unique label.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 5, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 6, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1LabelAnnotation', 7, repeated=True)


class GoogleCloudVideointelligenceV1VideoContext(_messages.Message):
  r"""Video context and/or feature-specific parameters.

  Fields:
    explicitContentDetectionConfig: Config for EXPLICIT_CONTENT_DETECTION.
    labelDetectionConfig: Config for LABEL_DETECTION.
    segments: Video segments to annotate. The segments may overlap and are not
      required to be contiguous or span the whole video. If unspecified, each
      video is treated as a single segment.
    shotChangeDetectionConfig: Config for SHOT_CHANGE_DETECTION.
  """

  explicitContentDetectionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1ExplicitContentDetectionConfig', 1)
  labelDetectionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1LabelDetectionConfig', 2)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1VideoSegment', 3, repeated=True)
  shotChangeDetectionConfig = _messages.MessageField('GoogleCloudVideointelligenceV1ShotChangeDetectionConfig', 4)


class GoogleCloudVideointelligenceV1VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1beta2AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1beta2Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g. `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1beta2ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1beta2ExplicitContentFrame', 1, repeated=True)


class GoogleCloudVideointelligenceV1beta2ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. E.g. when the
      label is `Terrier` the category is likely `dog`. And in some cases there
      might be more than one categories e.g. `Terrier` could also be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1beta2Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1beta2Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelSegment', 4, repeated=True)


class GoogleCloudVideointelligenceV1beta2LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1beta2LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 2)


class GoogleCloudVideointelligenceV1beta2VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Fields:
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  inputUri = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class GoogleCloudVideointelligenceV1beta2VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    segmentLabelAnnotations: Label annotations on video level or user
      specified segment level. There is exactly one element for each unique
      label.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Label annotations on shot level. There is exactly
      one element for each unique label.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1beta2ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 5, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2VideoSegment', 6, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1beta2LabelAnnotation', 7, repeated=True)


class GoogleCloudVideointelligenceV1beta2VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g. `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p1beta1ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1ExplicitContentFrame', 1, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. E.g. when the
      label is `Terrier` the category is likely `dog`. And in some cases there
      might be more than one categories e.g. `Terrier` could also be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelSegment', 4, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 2)


class GoogleCloudVideointelligenceV1p1beta1SpeechRecognitionAlternative(_messages.Message):
  r"""Alternative hypotheses (a.k.a. n-best list).

  Fields:
    confidence: The confidence estimate between 0.0 and 1.0. A higher number
      indicates an estimated greater likelihood that the recognized words are
      correct. This field is typically provided only for the top hypothesis,
      and only for `is_final=true` results. Clients should not rely on the
      `confidence` field as it is not guaranteed to be accurate or consistent.
      The default of 0.0 is a sentinel value indicating `confidence` was not
      set.
    transcript: Transcript text representing the words that the user spoke.
    words: A list of word-specific information for each recognized word.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  transcript = _messages.StringField(2)
  words = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1WordInfo', 3, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1SpeechTranscription(_messages.Message):
  r"""A speech recognition result corresponding to a portion of the audio.

  Fields:
    alternatives: May contain one or more recognition hypotheses (up to the
      maximum specified in `max_alternatives`).  These alternatives are
      ordered in terms of accuracy, with the top (first) alternative being the
      most probable, as ranked by the recognizer.
    languageCode: Output only. The [BCP-47](https://www.rfc-
      editor.org/rfc/bcp/bcp47.txt) language tag of the language in this
      result. This language code was detected to have the most likelihood of
      being spoken in the audio.
  """

  alternatives = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1SpeechRecognitionAlternative', 1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Fields:
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  inputUri = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class GoogleCloudVideointelligenceV1p1beta1VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    segmentLabelAnnotations: Label annotations on video level or user
      specified segment level. There is exactly one element for each unique
      label.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Label annotations on shot level. There is exactly
      one element for each unique label.
    speechTranscriptions: Speech transcription.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 5, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1VideoSegment', 6, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1LabelAnnotation', 7, repeated=True)
  speechTranscriptions = _messages.MessageField('GoogleCloudVideointelligenceV1p1beta1SpeechTranscription', 8, repeated=True)


class GoogleCloudVideointelligenceV1p1beta1VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p1beta1WordInfo(_messages.Message):
  r"""Word-specific information for recognized words. Word information is only
  included in the response when certain request parameters are set, such as
  `enable_word_time_offsets`.

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    endTime: Time offset relative to the beginning of the audio, and
      corresponding to the end of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    speakerTag: Output only. A distinct integer value is assigned for every
      speaker within the audio. This field specifies which one of those
      speakers was detected to have spoken this word. Value ranges from 1 up
      to diarization_speaker_count, and is only set if speaker diarization is
      enabled.
    startTime: Time offset relative to the beginning of the audio, and
      corresponding to the start of the spoken word. This field is only set if
      `enable_word_time_offsets=true` and only in the top hypothesis. This is
      an experimental feature and the accuracy of the time offset can vary.
    word: The word corresponding to this set of information.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  endTime = _messages.StringField(2)
  speakerTag = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(4)
  word = _messages.StringField(5)


class GoogleCloudVideointelligenceV1p2beta1AnnotateVideoProgress(_messages.Message):
  r"""Video annotation progress. Included in the `metadata` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationProgress: Progress metadata for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationProgress = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoAnnotationProgress', 1, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1AnnotateVideoResponse(_messages.Message):
  r"""Video annotation response. Included in the `response` field of the
  `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    annotationResults: Annotation results for all videos specified in
      `AnnotateVideoRequest`.
  """

  annotationResults = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoAnnotationResults', 1, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1Entity(_messages.Message):
  r"""Detected entity from video analysis.

  Fields:
    description: Textual description, e.g. `Fixed-gear bicycle`.
    entityId: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    languageCode: Language code for `description` in BCP-47 format.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  languageCode = _messages.StringField(3)


class GoogleCloudVideointelligenceV1p2beta1ExplicitContentAnnotation(_messages.Message):
  r"""Explicit content annotation (based on per-frame visual signals only). If
  no explicit content has been detected in a frame, no annotations are present
  for that frame.

  Fields:
    frames: All video frames where explicit content was detected.
  """

  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ExplicitContentFrame', 1, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1ExplicitContentFrame(_messages.Message):
  r"""Video frame level annotation results for explicit content.

  Enums:
    PornographyLikelihoodValueValuesEnum: Likelihood of the pornography
      content..

  Fields:
    pornographyLikelihood: Likelihood of the pornography content..
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  class PornographyLikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood of the pornography content..

    Values:
      LIKELIHOOD_UNSPECIFIED: Unspecified likelihood.
      VERY_UNLIKELY: Very unlikely.
      UNLIKELY: Unlikely.
      POSSIBLE: Possible.
      LIKELY: Likely.
      VERY_LIKELY: Very likely.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  pornographyLikelihood = _messages.EnumField('PornographyLikelihoodValueValuesEnum', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1LabelAnnotation(_messages.Message):
  r"""Label annotation.

  Fields:
    categoryEntities: Common categories for the detected entity. E.g. when the
      label is `Terrier` the category is likely `dog`. And in some cases there
      might be more than one categories e.g. `Terrier` could also be a `pet`.
    entity: Detected entity.
    frames: All video frames where a label was detected.
    segments: All video segments where a label was detected.
  """

  categoryEntities = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Entity', 1, repeated=True)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelFrame', 3, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelSegment', 4, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1LabelFrame(_messages.Message):
  r"""Video frame level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    timeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the video frame for this location.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1LabelSegment(_messages.Message):
  r"""Video segment level annotation results for label detection.

  Fields:
    confidence: Confidence that the label is accurate. Range: [0, 1].
    segment: Video segment where a label was detected.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 2)


class GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingBox(_messages.Message):
  r"""Normalized bounding box. The normalized vertex coordinates are relative
  to the original image. Range: [0, 1].

  Fields:
    bottom: Bottom Y coordinate.
    left: Left X coordinate.
    right: Right X coordinate.
    top: Top Y coordinate.
  """

  bottom = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  left = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  right = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  top = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingPoly(_messages.Message):
  r"""Normalized bounding polygon for text (that might not be aligned with
  axis). Contains list of the corner points in clockwise order starting from
  top-left corner. For example, for a rectangular bounding box: When the text
  is horizontal it might look like:         0----1         |    |         3
  ----2  When it's clockwise rotated 180 degrees around the top-left corner it
  becomes:         2----3         |    |         1----0  and the vertex order
  will still be (0, 1, 2, 3). Note that values can be less than 0, or greater
  than 1 due to trignometric calculations for location of the box.

  Fields:
    vertices: Normalized vertices of the bounding polygon.
  """

  vertices = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedVertex', 1, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1NormalizedVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudVideointelligenceV1p2beta1ObjectTrackingAnnotation(_messages.Message):
  r"""Annotations corresponding to one tracked object.

  Fields:
    confidence: Object category's labeling confidence of this track.
    entity: Entity to specify the object category that this track is labeled
      as.
    frames: Information corresponding to all frames where this object track
      appears.
    segment: Each object track corresponds to one video segment where it
      appears.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  entity = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1Entity', 2)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ObjectTrackingFrame', 3, repeated=True)
  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 4)


class GoogleCloudVideointelligenceV1p2beta1ObjectTrackingFrame(_messages.Message):
  r"""Video frame level annotations for object detection and tracking. This
  field stores per frame location, time offset, and confidence.

  Fields:
    normalizedBoundingBox: The normalized bounding box location of this object
      track for the frame.
    timeOffset: The timestamp of the frame in microseconds.
  """

  normalizedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingBox', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1TextAnnotation(_messages.Message):
  r"""Annotations related to one detected OCR text snippet. This will contain
  the corresponding text, confidence value, and frame level information for
  each detection.

  Fields:
    confidence: Confidence for the track of detected text. It is calculated as
      the highest over all frames where OCR detected text appears.
    frames: Information related to the frames where OCR detected text appears.
    segments: All video segments where OCR detected text appears.
    text: The detected text.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  frames = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1TextFrame', 2, repeated=True)
  segments = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1TextSegment', 3, repeated=True)
  text = _messages.StringField(4)


class GoogleCloudVideointelligenceV1p2beta1TextFrame(_messages.Message):
  r"""Video frame level annotation results for text annotation (OCR). Contains
  information regarding timestamp and bounding box locations for the frames
  containing detected OCR text snippets.

  Fields:
    rotatedBoundingBox: Bounding polygon of the detected text for this frame.
    timeOffset: Timestamp of this frame.
  """

  rotatedBoundingBox = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1NormalizedBoundingPoly', 1)
  timeOffset = _messages.StringField(2)


class GoogleCloudVideointelligenceV1p2beta1TextSegment(_messages.Message):
  r"""Video segment level annotation results for text detection.

  Fields:
    segment: Video segment where a text snippet was detected.
  """

  segment = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 1)


class GoogleCloudVideointelligenceV1p2beta1VideoAnnotationProgress(_messages.Message):
  r"""Annotation progress for a single video.

  Fields:
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    progressPercent: Approximate percentage processed thus far. Guaranteed to
      be 100 when fully processed.
    startTime: Time when the request was received.
    updateTime: Time of the most recent update.
  """

  inputUri = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class GoogleCloudVideointelligenceV1p2beta1VideoAnnotationResults(_messages.Message):
  r"""Annotation results for a single video.

  Fields:
    error: If set, indicates an error. Note that for a single
      `AnnotateVideoRequest` some videos may succeed and some may fail.
    explicitAnnotation: Explicit content annotation.
    frameLabelAnnotations: Label annotations on frame level. There is exactly
      one element for each unique label.
    inputUri: Video file location in [Google Cloud
      Storage](https://cloud.google.com/storage/).
    objectAnnotations: Annotations for list of objects detected and tracked in
      video.
    segmentLabelAnnotations: Label annotations on video level or user
      specified segment level. There is exactly one element for each unique
      label.
    shotAnnotations: Shot annotations. Each shot is represented as a video
      segment.
    shotLabelAnnotations: Label annotations on shot level. There is exactly
      one element for each unique label.
    textAnnotations: OCR text detection and tracking. Annotations for list of
      detected text snippets. Each will have list of frame information
      associated with it.
  """

  error = _messages.MessageField('GoogleRpcStatus', 1)
  explicitAnnotation = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ExplicitContentAnnotation', 2)
  frameLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 3, repeated=True)
  inputUri = _messages.StringField(4)
  objectAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1ObjectTrackingAnnotation', 5, repeated=True)
  segmentLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 6, repeated=True)
  shotAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1VideoSegment', 7, repeated=True)
  shotLabelAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1LabelAnnotation', 8, repeated=True)
  textAnnotations = _messages.MessageField('GoogleCloudVideointelligenceV1p2beta1TextAnnotation', 9, repeated=True)


class GoogleCloudVideointelligenceV1p2beta1VideoSegment(_messages.Message):
  r"""Video segment.

  Fields:
    endTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the end of the segment (inclusive).
    startTimeOffset: Time-offset, relative to the beginning of the video,
      corresponding to the start of the segment (inclusive).
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class VideointelligenceOperationsCancelRequest(_messages.Message):
  r"""A VideointelligenceOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class VideointelligenceOperationsDeleteRequest(_messages.Message):
  r"""A VideointelligenceOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class VideointelligenceOperationsGetRequest(_messages.Message):
  r"""A VideointelligenceOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class VideointelligenceOperationsListRequest(_messages.Message):
  r"""A VideointelligenceOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
