"""Generated message classes for appengine version v1beta.

The App Engine Admin API enables developers to provision and manage their App
Engine applications.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'appengine'


class ApiConfigHandler(_messages.Message):
  r"""Google Cloud Endpoints
  (https://cloud.google.com/appengine/docs/python/endpoints/) configuration
  for API handlers.

  Enums:
    AuthFailActionValueValuesEnum: Action to take when users access resources
      that require authentication. Defaults to redirect.
    LoginValueValuesEnum: Level of login required to access this resource.
      Defaults to optional.
    SecurityLevelValueValuesEnum: Security (HTTPS) enforcement for this URL.

  Fields:
    authFailAction: Action to take when users access resources that require
      authentication. Defaults to redirect.
    login: Level of login required to access this resource. Defaults to
      optional.
    script: Path to the script from the application root directory.
    securityLevel: Security (HTTPS) enforcement for this URL.
    url: URL to serve the endpoint at.
  """

  class AuthFailActionValueValuesEnum(_messages.Enum):
    r"""Action to take when users access resources that require
    authentication. Defaults to redirect.

    Values:
      AUTH_FAIL_ACTION_UNSPECIFIED: Not specified. AUTH_FAIL_ACTION_REDIRECT
        is assumed.
      AUTH_FAIL_ACTION_REDIRECT: Redirects user to "accounts.google.com". The
        user is redirected back to the application URL after signing in or
        creating an account.
      AUTH_FAIL_ACTION_UNAUTHORIZED: Rejects request with a 401 HTTP status
        code and an error message.
    """
    AUTH_FAIL_ACTION_UNSPECIFIED = 0
    AUTH_FAIL_ACTION_REDIRECT = 1
    AUTH_FAIL_ACTION_UNAUTHORIZED = 2

  class LoginValueValuesEnum(_messages.Enum):
    r"""Level of login required to access this resource. Defaults to optional.

    Values:
      LOGIN_UNSPECIFIED: Not specified. LOGIN_OPTIONAL is assumed.
      LOGIN_OPTIONAL: Does not require that the user is signed in.
      LOGIN_ADMIN: If the user is not signed in, the auth_fail_action is
        taken. In addition, if the user is not an administrator for the
        application, they are given an error message regardless of
        auth_fail_action. If the user is an administrator, the handler
        proceeds.
      LOGIN_REQUIRED: If the user has signed in, the handler proceeds
        normally. Otherwise, the auth_fail_action is taken.
    """
    LOGIN_UNSPECIFIED = 0
    LOGIN_OPTIONAL = 1
    LOGIN_ADMIN = 2
    LOGIN_REQUIRED = 3

  class SecurityLevelValueValuesEnum(_messages.Enum):
    r"""Security (HTTPS) enforcement for this URL.

    Values:
      SECURE_UNSPECIFIED: Not specified.
      SECURE_DEFAULT: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_NEVER: Requests for a URL that match this handler that use HTTPS
        are automatically redirected to the HTTP equivalent URL.
      SECURE_OPTIONAL: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used and respond accordingly.
      SECURE_ALWAYS: Requests for a URL that match this handler that do not
        use HTTPS are automatically redirected to the HTTPS URL with the same
        path. Query parameters are reserved for the redirect.
    """
    SECURE_UNSPECIFIED = 0
    SECURE_DEFAULT = 1
    SECURE_NEVER = 2
    SECURE_OPTIONAL = 3
    SECURE_ALWAYS = 4

  authFailAction = _messages.EnumField('AuthFailActionValueValuesEnum', 1)
  login = _messages.EnumField('LoginValueValuesEnum', 2)
  script = _messages.StringField(3)
  securityLevel = _messages.EnumField('SecurityLevelValueValuesEnum', 4)
  url = _messages.StringField(5)


class ApiEndpointHandler(_messages.Message):
  r"""Uses Google Cloud Endpoints to handle requests.

  Fields:
    scriptPath: Path to the script from the application root directory.
  """

  scriptPath = _messages.StringField(1)


class AppengineAppsAuthorizedCertificatesCreateRequest(_messages.Message):
  r"""A AppengineAppsAuthorizedCertificatesCreateRequest object.

  Fields:
    authorizedCertificate: A AuthorizedCertificate resource to be passed as
      the request body.
    parent: Name of the parent Application resource. Example: apps/myapp.
  """

  authorizedCertificate = _messages.MessageField('AuthorizedCertificate', 1)
  parent = _messages.StringField(2, required=True)


class AppengineAppsAuthorizedCertificatesDeleteRequest(_messages.Message):
  r"""A AppengineAppsAuthorizedCertificatesDeleteRequest object.

  Fields:
    name: Name of the resource to delete. Example:
      apps/myapp/authorizedCertificates/12345.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsAuthorizedCertificatesGetRequest(_messages.Message):
  r"""A AppengineAppsAuthorizedCertificatesGetRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the GET
      response.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/authorizedCertificates/12345.
    view: Controls the set of fields returned in the GET response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Controls the set of fields returned in the GET response.

    Values:
      BASIC_CERTIFICATE: <no description>
      FULL_CERTIFICATE: <no description>
    """
    BASIC_CERTIFICATE = 0
    FULL_CERTIFICATE = 1

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class AppengineAppsAuthorizedCertificatesListRequest(_messages.Message):
  r"""A AppengineAppsAuthorizedCertificatesListRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the LIST
      response.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Application resource. Example: apps/myapp.
    view: Controls the set of fields returned in the LIST response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Controls the set of fields returned in the LIST response.

    Values:
      BASIC_CERTIFICATE: <no description>
      FULL_CERTIFICATE: <no description>
    """
    BASIC_CERTIFICATE = 0
    FULL_CERTIFICATE = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class AppengineAppsAuthorizedCertificatesPatchRequest(_messages.Message):
  r"""A AppengineAppsAuthorizedCertificatesPatchRequest object.

  Fields:
    authorizedCertificate: A AuthorizedCertificate resource to be passed as
      the request body.
    name: Name of the resource to update. Example:
      apps/myapp/authorizedCertificates/12345.
    updateMask: Standard field mask for the set of fields to be updated.
      Updates are only supported on the certificate_raw_data and display_name
      fields.
  """

  authorizedCertificate = _messages.MessageField('AuthorizedCertificate', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AppengineAppsAuthorizedDomainsListRequest(_messages.Message):
  r"""A AppengineAppsAuthorizedDomainsListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Application resource. Example: apps/myapp.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AppengineAppsDomainMappingsCreateRequest(_messages.Message):
  r"""A AppengineAppsDomainMappingsCreateRequest object.

  Enums:
    OverrideStrategyValueValuesEnum: Whether the domain creation should
      override any existing mappings for this domain. By default, overrides
      are rejected.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    overrideStrategy: Whether the domain creation should override any existing
      mappings for this domain. By default, overrides are rejected.
    parent: Name of the parent Application resource. Example: apps/myapp.
  """

  class OverrideStrategyValueValuesEnum(_messages.Enum):
    r"""Whether the domain creation should override any existing mappings for
    this domain. By default, overrides are rejected.

    Values:
      UNSPECIFIED_DOMAIN_OVERRIDE_STRATEGY: <no description>
      STRICT: <no description>
      OVERRIDE: <no description>
    """
    UNSPECIFIED_DOMAIN_OVERRIDE_STRATEGY = 0
    STRICT = 1
    OVERRIDE = 2

  domainMapping = _messages.MessageField('DomainMapping', 1)
  overrideStrategy = _messages.EnumField('OverrideStrategyValueValuesEnum', 2)
  parent = _messages.StringField(3, required=True)


class AppengineAppsDomainMappingsDeleteRequest(_messages.Message):
  r"""A AppengineAppsDomainMappingsDeleteRequest object.

  Fields:
    name: Name of the resource to delete. Example:
      apps/myapp/domainMappings/example.com.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsDomainMappingsGetRequest(_messages.Message):
  r"""A AppengineAppsDomainMappingsGetRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/domainMappings/example.com.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsDomainMappingsListRequest(_messages.Message):
  r"""A AppengineAppsDomainMappingsListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Application resource. Example: apps/myapp.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AppengineAppsDomainMappingsPatchRequest(_messages.Message):
  r"""A AppengineAppsDomainMappingsPatchRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    name: Name of the resource to update. Example:
      apps/myapp/domainMappings/example.com.
    updateMask: Standard field mask for the set of fields to be updated.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AppengineAppsFirewallIngressRulesBatchUpdateRequest(_messages.Message):
  r"""A AppengineAppsFirewallIngressRulesBatchUpdateRequest object.

  Fields:
    batchUpdateIngressRulesRequest: A BatchUpdateIngressRulesRequest resource
      to be passed as the request body.
    name: Name of the Firewall collection to set. Example:
      apps/myapp/firewall/ingressRules.
  """

  batchUpdateIngressRulesRequest = _messages.MessageField('BatchUpdateIngressRulesRequest', 1)
  name = _messages.StringField(2, required=True)


class AppengineAppsFirewallIngressRulesCreateRequest(_messages.Message):
  r"""A AppengineAppsFirewallIngressRulesCreateRequest object.

  Fields:
    firewallRule: A FirewallRule resource to be passed as the request body.
    parent: Name of the parent Firewall collection in which to create a new
      rule. Example: apps/myapp/firewall/ingressRules.
  """

  firewallRule = _messages.MessageField('FirewallRule', 1)
  parent = _messages.StringField(2, required=True)


class AppengineAppsFirewallIngressRulesDeleteRequest(_messages.Message):
  r"""A AppengineAppsFirewallIngressRulesDeleteRequest object.

  Fields:
    name: Name of the Firewall resource to delete. Example:
      apps/myapp/firewall/ingressRules/100.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsFirewallIngressRulesGetRequest(_messages.Message):
  r"""A AppengineAppsFirewallIngressRulesGetRequest object.

  Fields:
    name: Name of the Firewall resource to retrieve. Example:
      apps/myapp/firewall/ingressRules/100.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsFirewallIngressRulesListRequest(_messages.Message):
  r"""A AppengineAppsFirewallIngressRulesListRequest object.

  Fields:
    matchingAddress: A valid IP Address. If set, only rules matching this
      address will be returned. The first returned rule will be the rule that
      fires on requests from this IP.
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the Firewall collection to retrieve. Example:
      apps/myapp/firewall/ingressRules.
  """

  matchingAddress = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AppengineAppsFirewallIngressRulesPatchRequest(_messages.Message):
  r"""A AppengineAppsFirewallIngressRulesPatchRequest object.

  Fields:
    firewallRule: A FirewallRule resource to be passed as the request body.
    name: Name of the Firewall resource to update. Example:
      apps/myapp/firewall/ingressRules/100.
    updateMask: Standard field mask for the set of fields to be updated.
  """

  firewallRule = _messages.MessageField('FirewallRule', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AppengineAppsGetRequest(_messages.Message):
  r"""A AppengineAppsGetRequest object.

  Fields:
    name: Name of the Application resource to get. Example: apps/myapp.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsLocationsGetRequest(_messages.Message):
  r"""A AppengineAppsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsLocationsListRequest(_messages.Message):
  r"""A AppengineAppsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AppengineAppsOperationsGetRequest(_messages.Message):
  r"""A AppengineAppsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsOperationsListRequest(_messages.Message):
  r"""A AppengineAppsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AppengineAppsPatchRequest(_messages.Message):
  r"""A AppengineAppsPatchRequest object.

  Fields:
    application: A Application resource to be passed as the request body.
    name: Name of the Application resource to update. Example: apps/myapp.
    updateMask: Standard field mask for the set of fields to be updated.
  """

  application = _messages.MessageField('Application', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AppengineAppsRepairRequest(_messages.Message):
  r"""A AppengineAppsRepairRequest object.

  Fields:
    name: Name of the application to repair. Example: apps/myapp
    repairApplicationRequest: A RepairApplicationRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  repairApplicationRequest = _messages.MessageField('RepairApplicationRequest', 2)


class AppengineAppsServicesDeleteRequest(_messages.Message):
  r"""A AppengineAppsServicesDeleteRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesGetRequest(_messages.Message):
  r"""A AppengineAppsServicesGetRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesListRequest(_messages.Message):
  r"""A AppengineAppsServicesListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Application resource. Example: apps/myapp.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AppengineAppsServicesPatchRequest(_messages.Message):
  r"""A AppengineAppsServicesPatchRequest object.

  Fields:
    migrateTraffic: Set to true to gradually shift traffic to one or more
      versions that you specify. By default, traffic is shifted immediately.
      For gradual traffic migration, the target versions must be located
      within instances that are configured for both warmup requests
      (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1beta/apps.services.versions#inboundservicetype) and
      automatic scaling (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1beta/apps.services.versions#automaticscaling). You
      must specify the shardBy (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1beta/apps.services#shardby) field in the Service
      resource. Gradual traffic migration is not supported in the App Engine
      flexible environment. For examples, see Migrating and Splitting Traffic
      (https://cloud.google.com/appengine/docs/admin-api/migrating-splitting-
      traffic).
    name: Name of the resource to update. Example:
      apps/myapp/services/default.
    service: A Service resource to be passed as the request body.
    updateMask: Standard field mask for the set of fields to be updated.
  """

  migrateTraffic = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  service = _messages.MessageField('Service', 3)
  updateMask = _messages.StringField(4)


class AppengineAppsServicesVersionsCreateRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsCreateRequest object.

  Fields:
    parent: Name of the parent resource to create this version under. Example:
      apps/myapp/services/default.
    version: A Version resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  version = _messages.MessageField('Version', 2)


class AppengineAppsServicesVersionsDeleteRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsDeleteRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesVersionsGetRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsGetRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the Get
      response.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1.
    view: Controls the set of fields returned in the Get response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Controls the set of fields returned in the Get response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class AppengineAppsServicesVersionsInstancesDebugRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsInstancesDebugRequest object.

  Fields:
    debugInstanceRequest: A DebugInstanceRequest resource to be passed as the
      request body.
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.
  """

  debugInstanceRequest = _messages.MessageField('DebugInstanceRequest', 1)
  name = _messages.StringField(2, required=True)


class AppengineAppsServicesVersionsInstancesDeleteRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsInstancesDeleteRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesVersionsInstancesGetRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsInstancesGetRequest object.

  Fields:
    name: Name of the resource requested. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsServicesVersionsInstancesListRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsInstancesListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Version resource. Example:
      apps/myapp/services/default/versions/v1.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AppengineAppsServicesVersionsListRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsListRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the List
      response.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Service resource. Example:
      apps/myapp/services/default.
    view: Controls the set of fields returned in the List response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Controls the set of fields returned in the List response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class AppengineAppsServicesVersionsPatchRequest(_messages.Message):
  r"""A AppengineAppsServicesVersionsPatchRequest object.

  Fields:
    name: Name of the resource to update. Example:
      apps/myapp/services/default/versions/1.
    updateMask: Standard field mask for the set of fields to be updated.
    version: A Version resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class Application(_messages.Message):
  r"""An Application resource contains the top-level configuration of an App
  Engine application.

  Enums:
    ServingStatusValueValuesEnum: Serving status of this application.

  Fields:
    authDomain: Google Apps authentication domain that controls which users
      can access this application.Defaults to open access for any Google
      Account.
    codeBucket: Google Cloud Storage bucket that can be used for storing files
      associated with this application. This bucket is associated with the
      application and can be used by the gcloud deployment
      commands.@OutputOnly
    defaultBucket: Google Cloud Storage bucket that can be used by this
      application to store content.@OutputOnly
    defaultCookieExpiration: Cookie expiration policy for this application.
    defaultHostname: Hostname used to reach this application, as resolved by
      App Engine.@OutputOnly
    dispatchRules: HTTP path dispatch rules for requests to the application
      that do not explicitly target a service or version. Rules are order-
      dependent. Up to 20 dispatch rules can be supported.@OutputOnly
    featureSettings: The feature specific settings to be used in the
      application.
    gcrDomain: The Google Container Registry domain used for storing managed
      build docker images for this application.
    iap: A IdentityAwareProxy attribute.
    id: Identifier of the Application resource. This identifier is equivalent
      to the project ID of the Google Cloud Platform project where you want to
      deploy your application. Example: myapp.
    locationId: Location from which this application runs. Application
      instances run out of the data centers in the specified location, which
      is also where all of the application's end user content is
      stored.Defaults to us-central.View the list of supported locations
      (https://cloud.google.com/appengine/docs/locations).
    name: Full path to the Application resource in the API. Example:
      apps/myapp.@OutputOnly
    servingStatus: Serving status of this application.
  """

  class ServingStatusValueValuesEnum(_messages.Enum):
    r"""Serving status of this application.

    Values:
      UNSPECIFIED: Serving status is unspecified.
      SERVING: Application is serving.
      USER_DISABLED: Application has been disabled by the user.
      SYSTEM_DISABLED: Application has been disabled by the system.
    """
    UNSPECIFIED = 0
    SERVING = 1
    USER_DISABLED = 2
    SYSTEM_DISABLED = 3

  authDomain = _messages.StringField(1)
  codeBucket = _messages.StringField(2)
  defaultBucket = _messages.StringField(3)
  defaultCookieExpiration = _messages.StringField(4)
  defaultHostname = _messages.StringField(5)
  dispatchRules = _messages.MessageField('UrlDispatchRule', 6, repeated=True)
  featureSettings = _messages.MessageField('FeatureSettings', 7)
  gcrDomain = _messages.StringField(8)
  iap = _messages.MessageField('IdentityAwareProxy', 9)
  id = _messages.StringField(10)
  locationId = _messages.StringField(11)
  name = _messages.StringField(12)
  servingStatus = _messages.EnumField('ServingStatusValueValuesEnum', 13)


class AuthorizedCertificate(_messages.Message):
  r"""An SSL certificate that a user has been authorized to administer. A user
  is authorized to administer any certificate that applies to one of their
  authorized domains.

  Fields:
    certificateRawData: The SSL certificate serving the AuthorizedCertificate
      resource. This must be obtained independently from a certificate
      authority.
    displayName: The user-specified display name of the certificate. This is
      not guaranteed to be unique. Example: My Certificate.
    domainMappingsCount: Aggregate count of the domain mappings with this
      certificate mapped. This count includes domain mappings on applications
      for which the user does not have VIEWER permissions.Only returned by GET
      or LIST requests when specifically requested by the
      view=FULL_CERTIFICATE option.@OutputOnly
    domainNames: Topmost applicable domains of this certificate. This
      certificate applies to these domains and their subdomains. Example:
      example.com.@OutputOnly
    expireTime: The time when this certificate expires. To update the renewal
      time on this certificate, upload an SSL certificate with a different
      expiration time using
      AuthorizedCertificates.UpdateAuthorizedCertificate.@OutputOnly
    id: Relative name of the certificate. This is a unique value autogenerated
      on AuthorizedCertificate resource creation. Example: 12345.@OutputOnly
    managedCertificate: Only applicable if this certificate is managed by App
      Engine. Managed certificates are tied to the lifecycle of a
      DomainMapping and cannot be updated or deleted via the
      AuthorizedCertificates API. If this certificate is manually administered
      by the user, this field will be empty.@OutputOnly
    name: Full path to the AuthorizedCertificate resource in the API. Example:
      apps/myapp/authorizedCertificates/12345.@OutputOnly
    visibleDomainMappings: The full paths to user visible Domain Mapping
      resources that have this certificate mapped. Example:
      apps/myapp/domainMappings/example.com.This may not represent the full
      list of mapped domain mappings if the user does not have VIEWER
      permissions on all of the applications that have this certificate
      mapped. See domain_mappings_count for a complete count.Only returned by
      GET or LIST requests when specifically requested by the
      view=FULL_CERTIFICATE option.@OutputOnly
  """

  certificateRawData = _messages.MessageField('CertificateRawData', 1)
  displayName = _messages.StringField(2)
  domainMappingsCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  domainNames = _messages.StringField(4, repeated=True)
  expireTime = _messages.StringField(5)
  id = _messages.StringField(6)
  managedCertificate = _messages.MessageField('ManagedCertificate', 7)
  name = _messages.StringField(8)
  visibleDomainMappings = _messages.StringField(9, repeated=True)


class AuthorizedDomain(_messages.Message):
  r"""A domain that a user has been authorized to administer. To authorize use
  of a domain, verify ownership via Webmaster Central
  (https://www.google.com/webmasters/verification/home).

  Fields:
    id: Fully qualified domain name of the domain authorized for use. Example:
      example.com.
    name: Full path to the AuthorizedDomain resource in the API. Example:
      apps/myapp/authorizedDomains/example.com.@OutputOnly
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)


class AutomaticScaling(_messages.Message):
  r"""Automatic scaling is based on request rate, response latencies, and
  other application metrics.

  Fields:
    coolDownPeriod: Amount of time that the Autoscaler
      (https://cloud.google.com/compute/docs/autoscaler/) should wait between
      changes to the number of virtual machines. Only applicable in the App
      Engine flexible environment.
    cpuUtilization: Target scaling by CPU usage.
    customMetrics: Target scaling by user-provided metrics.
    diskUtilization: Target scaling by disk usage.
    maxConcurrentRequests: Number of concurrent requests an automatic scaling
      instance can accept before the scheduler spawns a new instance.Defaults
      to a runtime-specific value.
    maxIdleInstances: Maximum number of idle instances that should be
      maintained for this version.
    maxPendingLatency: Maximum amount of time that a request should wait in
      the pending queue before starting a new instance to handle it.
    maxTotalInstances: Maximum number of instances that should be started to
      handle requests for this version.
    minIdleInstances: Minimum number of idle instances that should be
      maintained for this version. Only applicable for the default version of
      a service.
    minPendingLatency: Minimum amount of time a request should wait in the
      pending queue before starting a new instance to handle it.
    minTotalInstances: Minimum number of running instances that should be
      maintained for this version.
    networkUtilization: Target scaling by network usage.
    requestUtilization: Target scaling by request utilization.
    standardSchedulerSettings: Scheduler settings for standard environment.
  """

  coolDownPeriod = _messages.StringField(1)
  cpuUtilization = _messages.MessageField('CpuUtilization', 2)
  customMetrics = _messages.MessageField('CustomMetric', 3, repeated=True)
  diskUtilization = _messages.MessageField('DiskUtilization', 4)
  maxConcurrentRequests = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxIdleInstances = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  maxPendingLatency = _messages.StringField(7)
  maxTotalInstances = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  minIdleInstances = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  minPendingLatency = _messages.StringField(10)
  minTotalInstances = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  networkUtilization = _messages.MessageField('NetworkUtilization', 12)
  requestUtilization = _messages.MessageField('RequestUtilization', 13)
  standardSchedulerSettings = _messages.MessageField('StandardSchedulerSettings', 14)


class BasicScaling(_messages.Message):
  r"""A service with basic scaling will create an instance when the
  application receives a request. The instance will be turned down when the
  app becomes idle. Basic scaling is ideal for work that is intermittent or
  driven by user activity.

  Fields:
    idleTimeout: Duration of time after the last request that an instance must
      wait before the instance is shut down.
    maxInstances: Maximum number of instances to create for this version.
  """

  idleTimeout = _messages.StringField(1)
  maxInstances = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class BatchUpdateIngressRulesRequest(_messages.Message):
  r"""Request message for Firewall.BatchUpdateIngressRules.

  Fields:
    ingressRules: A list of FirewallRules to replace the existing set.
  """

  ingressRules = _messages.MessageField('FirewallRule', 1, repeated=True)


class BatchUpdateIngressRulesResponse(_messages.Message):
  r"""Response message for Firewall.UpdateAllIngressRules.

  Fields:
    ingressRules: The full list of ingress FirewallRules for this application.
  """

  ingressRules = _messages.MessageField('FirewallRule', 1, repeated=True)


class BuildInfo(_messages.Message):
  r"""Google Cloud Build information.

  Fields:
    cloudBuildId: The Google Cloud Build id. Example: "f966068f-08b2-42c8
      -bdfe-74137dff2bf9"
  """

  cloudBuildId = _messages.StringField(1)


class CertificateRawData(_messages.Message):
  r"""An SSL certificate obtained from a certificate authority.

  Fields:
    privateKey: Unencrypted PEM encoded RSA private key. This field is set
      once on certificate creation and then encrypted. The key size must be
      2048 bits or fewer. Must include the header and footer. Example: <pre>
      -----BEGIN RSA PRIVATE KEY----- <unencrypted_key_value> -----END RSA
      PRIVATE KEY----- </pre> @InputOnly
    publicCertificate: PEM encoded x.509 public key certificate. This field is
      set once on certificate creation. Must include the header and footer.
      Example: <pre> -----BEGIN CERTIFICATE----- <certificate_value> -----END
      CERTIFICATE----- </pre>
  """

  privateKey = _messages.StringField(1)
  publicCertificate = _messages.StringField(2)


class CloudBuildOptions(_messages.Message):
  r"""Options for the build operations performed as a part of the version
  deployment. Only applicable for App Engine flexible environment when
  creating a version using source code directly.

  Fields:
    appYamlPath: Path to the yaml file used in deployment, used to determine
      runtime configuration details.Required for flexible environment
      builds.See
      https://cloud.google.com/appengine/docs/standard/python/config/appref
      for more details.
    cloudBuildTimeout: The Cloud Build timeout used as part of any dependent
      builds performed by version creation. Defaults to 10 minutes.
  """

  appYamlPath = _messages.StringField(1)
  cloudBuildTimeout = _messages.StringField(2)


class ContainerInfo(_messages.Message):
  r"""Docker image that is used to create a container and start a VM instance
  for the version that you deploy. Only applicable for instances running in
  the App Engine flexible environment.

  Fields:
    image: URI to the hosted container image in Google Container Registry. The
      URI must be fully qualified and include a tag or digest. Examples:
      "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
  """

  image = _messages.StringField(1)


class CpuUtilization(_messages.Message):
  r"""Target scaling by CPU usage.

  Fields:
    aggregationWindowLength: Period of time over which CPU utilization is
      calculated.
    targetUtilization: Target CPU utilization ratio to maintain when scaling.
      Must be between 0 and 1.
  """

  aggregationWindowLength = _messages.StringField(1)
  targetUtilization = _messages.FloatField(2)


class CreateVersionMetadataV1(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation during a
  google.appengine.v1.CreateVersionRequest.

  Fields:
    cloudBuildId: The Cloud Build ID if one was created as part of the version
      create. @OutputOnly
  """

  cloudBuildId = _messages.StringField(1)


class CreateVersionMetadataV1Alpha(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation during a
  google.appengine.v1alpha.CreateVersionRequest.

  Fields:
    cloudBuildId: The Cloud Build ID if one was created as part of the version
      create. @OutputOnly
  """

  cloudBuildId = _messages.StringField(1)


class CreateVersionMetadataV1Beta(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation during a
  google.appengine.v1beta.CreateVersionRequest.

  Fields:
    cloudBuildId: The Cloud Build ID if one was created as part of the version
      create. @OutputOnly
  """

  cloudBuildId = _messages.StringField(1)


class CustomMetric(_messages.Message):
  r"""Allows autoscaling based on Stackdriver metrics.

  Fields:
    filter: Allows filtering on the metric's fields.
    metricName: The name of the metric.
    singleInstanceAssignment: May be used instead of target_utilization when
      an instance can handle a specific amount of work/resources and the
      metric value is equal to the current amount of work remaining. The
      autoscaler will try to keep the number of instances equal to the metric
      value divided by single_instance_assignment.
    targetType: The type of the metric. Must be a string representing a
      Stackdriver metric type e.g. GAGUE, DELTA_PER_SECOND, etc.
    targetUtilization: The target value for the metric.
  """

  filter = _messages.StringField(1)
  metricName = _messages.StringField(2)
  singleInstanceAssignment = _messages.FloatField(3)
  targetType = _messages.StringField(4)
  targetUtilization = _messages.FloatField(5)


class DebugInstanceRequest(_messages.Message):
  r"""Request message for Instances.DebugInstance.

  Fields:
    sshKey: Public SSH key to add to the instance. Examples: [USERNAME]:ssh-
      rsa [KEY_VALUE] [USERNAME] [USERNAME]:ssh-rsa [KEY_VALUE] google-ssh
      {"userName":"[USERNAME]","expireOn":"[EXPIRE_TIME]"}For more
      information, see Adding and Removing SSH Keys
      (https://cloud.google.com/compute/docs/instances/adding-removing-ssh-
      keys).
  """

  sshKey = _messages.StringField(1)


class Deployment(_messages.Message):
  r"""Code and application artifacts used to deploy a version to App Engine.

  Messages:
    FilesValue: Manifest of the files stored in Google Cloud Storage that are
      included as part of this version. All files must be readable using the
      credentials supplied with this call.

  Fields:
    build: Google Cloud Build build information. Only applicable for instances
      running in the App Engine flexible environment.
    cloudBuildOptions: Options for any Google Cloud Build builds created as a
      part of this deployment.Note that this is orthogonal to the build
      parameter, where the deployment depends on an already existing cloud
      build. These options will only be used if a new build is created, such
      as when deploying to the App Engine flexible environment using files or
      zip.
    container: The Docker image for the container that runs the version. Only
      applicable for instances running in the App Engine flexible environment.
    files: Manifest of the files stored in Google Cloud Storage that are
      included as part of this version. All files must be readable using the
      credentials supplied with this call.
    zip: The zip file for this deployment, if this is a zip deployment.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilesValue(_messages.Message):
    r"""Manifest of the files stored in Google Cloud Storage that are included
    as part of this version. All files must be readable using the credentials
    supplied with this call.

    Messages:
      AdditionalProperty: An additional property for a FilesValue object.

    Fields:
      additionalProperties: Additional properties of type FilesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FilesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileInfo attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileInfo', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  build = _messages.MessageField('BuildInfo', 1)
  cloudBuildOptions = _messages.MessageField('CloudBuildOptions', 2)
  container = _messages.MessageField('ContainerInfo', 3)
  files = _messages.MessageField('FilesValue', 4)
  zip = _messages.MessageField('ZipInfo', 5)


class DiskUtilization(_messages.Message):
  r"""Target scaling by disk usage. Only applicable in the App Engine flexible
  environment.

  Fields:
    targetReadBytesPerSecond: Target bytes read per second.
    targetReadOpsPerSecond: Target ops read per seconds.
    targetWriteBytesPerSecond: Target bytes written per second.
    targetWriteOpsPerSecond: Target ops written per second.
  """

  targetReadBytesPerSecond = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetReadOpsPerSecond = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  targetWriteBytesPerSecond = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  targetWriteOpsPerSecond = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class DomainMapping(_messages.Message):
  r"""A domain serving an App Engine application.

  Fields:
    id: Relative name of the domain serving the application. Example:
      example.com.
    name: Full path to the DomainMapping resource in the API. Example:
      apps/myapp/domainMapping/example.com.@OutputOnly
    resourceRecords: The resource records required to configure this domain
      mapping. These records must be added to the domain's DNS configuration
      in order to serve the application via this domain mapping.@OutputOnly
    sslSettings: SSL configuration for this domain. If unconfigured, this
      domain will not serve with SSL.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  resourceRecords = _messages.MessageField('ResourceRecord', 3, repeated=True)
  sslSettings = _messages.MessageField('SslSettings', 4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo {   rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for Empty is empty JSON object {}.
  """



class EndpointsApiService(_messages.Message):
  r"""Cloud Endpoints (https://cloud.google.com/endpoints) configuration. The
  Endpoints API Service provides tooling for serving Open API and gRPC
  endpoints via an NGINX proxy. Only valid for App Engine Flexible environment
  deployments.The fields here refer to the name and configuration ID of a
  "service" resource in the Service Management API (https://cloud.google.com
  /service-management/overview).

  Enums:
    RolloutStrategyValueValuesEnum: Endpoints rollout strategy. If FIXED,
      config_id must be specified. If MANAGED, config_id must be omitted.

  Fields:
    configId: Endpoints service configuration ID as specified by the Service
      Management API. For example "2016-09-19r1".By default, the rollout
      strategy for Endpoints is RolloutStrategy.FIXED. This means that
      Endpoints starts up with a particular configuration ID. When a new
      configuration is rolled out, Endpoints must be given the new
      configuration ID. The config_id field is used to give the configuration
      ID and is required in this case.Endpoints also has a rollout strategy
      called RolloutStrategy.MANAGED. When using this, Endpoints fetches the
      latest configuration and does not need the configuration ID. In this
      case, config_id must be omitted.
    disableTraceSampling: Enable or disable trace sampling. By default, this
      is set to false for enabled.
    name: Endpoints service name which is the name of the "service" resource
      in the Service Management API. For example
      "myapi.endpoints.myproject.cloud.goog"
    rolloutStrategy: Endpoints rollout strategy. If FIXED, config_id must be
      specified. If MANAGED, config_id must be omitted.
  """

  class RolloutStrategyValueValuesEnum(_messages.Enum):
    r"""Endpoints rollout strategy. If FIXED, config_id must be specified. If
    MANAGED, config_id must be omitted.

    Values:
      UNSPECIFIED_ROLLOUT_STRATEGY: Not specified. Defaults to FIXED.
      FIXED: Endpoints service configuration ID will be fixed to the
        configuration ID specified by config_id.
      MANAGED: Endpoints service configuration ID will be updated with each
        rollout.
    """
    UNSPECIFIED_ROLLOUT_STRATEGY = 0
    FIXED = 1
    MANAGED = 2

  configId = _messages.StringField(1)
  disableTraceSampling = _messages.BooleanField(2)
  name = _messages.StringField(3)
  rolloutStrategy = _messages.EnumField('RolloutStrategyValueValuesEnum', 4)


class Entrypoint(_messages.Message):
  r"""The entrypoint for the application.

  Fields:
    shell: The format should be a shell command that can be fed to bash -c.
  """

  shell = _messages.StringField(1)


class ErrorHandler(_messages.Message):
  r"""Custom static error page to be served when an error occurs.

  Enums:
    ErrorCodeValueValuesEnum: Error condition this handler applies to.

  Fields:
    errorCode: Error condition this handler applies to.
    mimeType: MIME type of file. Defaults to text/html.
    staticFile: Static file content to be served for this error.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Error condition this handler applies to.

    Values:
      ERROR_CODE_UNSPECIFIED: Not specified. ERROR_CODE_DEFAULT is assumed.
      ERROR_CODE_DEFAULT: All other error types.
      ERROR_CODE_OVER_QUOTA: Application has exceeded a resource quota.
      ERROR_CODE_DOS_API_DENIAL: Client blocked by the application's Denial of
        Service protection configuration.
      ERROR_CODE_TIMEOUT: Deadline reached before the application responds.
    """
    ERROR_CODE_UNSPECIFIED = 0
    ERROR_CODE_DEFAULT = 1
    ERROR_CODE_OVER_QUOTA = 2
    ERROR_CODE_DOS_API_DENIAL = 3
    ERROR_CODE_TIMEOUT = 4

  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 1)
  mimeType = _messages.StringField(2)
  staticFile = _messages.StringField(3)


class FeatureSettings(_messages.Message):
  r"""The feature specific settings to be used in the application. These
  define behaviors that are user configurable.

  Fields:
    splitHealthChecks: Boolean value indicating if split health checks should
      be used instead of the legacy health checks. At an app.yaml level, this
      means defaulting to 'readiness_check' and 'liveness_check' values
      instead of 'health_check' ones. Once the legacy 'health_check' behavior
      is deprecated, and this value is always true, this setting can be
      removed.
    useContainerOptimizedOs: If true, use Container-Optimized OS
      (https://cloud.google.com/container-optimized-os/) base image for VMs,
      rather than a base Debian image.
  """

  splitHealthChecks = _messages.BooleanField(1)
  useContainerOptimizedOs = _messages.BooleanField(2)


class FileInfo(_messages.Message):
  r"""Single source file that is part of the version to be deployed. Each
  source file that is deployed must be specified separately.

  Fields:
    mimeType: The MIME type of the file.Defaults to the value from Google
      Cloud Storage.
    sha1Sum: The SHA1 hash of the file, in hex.
    sourceUrl: URL source to use to fetch this file. Must be a URL to a
      resource in Google Cloud Storage in the form
      'http(s)://storage.googleapis.com/<bucket>/<object>'.
  """

  mimeType = _messages.StringField(1)
  sha1Sum = _messages.StringField(2)
  sourceUrl = _messages.StringField(3)


class FirewallRule(_messages.Message):
  r"""A single firewall rule that is evaluated against incoming traffic and
  provides an action to take on matched requests.

  Enums:
    ActionValueValuesEnum: The action to take on matched requests.

  Fields:
    action: The action to take on matched requests.
    description: An optional string description of this rule. This field has a
      maximum length of 100 characters.
    priority: A positive integer between 1, Int32.MaxValue-1 that defines the
      order of rule evaluation. Rules with the lowest priority are evaluated
      first.A default rule at priority Int32.MaxValue matches all IPv4 and
      IPv6 traffic when no previous rule matches. Only the action of this rule
      can be modified by the user.
    sourceRange: IP address or range, defined using CIDR notation, of requests
      that this rule applies to. You can use the wildcard character "*" to
      match all IPs equivalent to "0/0" and "::/0" together. Examples:
      192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32  or
      2001:0db8:0000:0042:0000:8a2e:0370:7334.<p>Truncation will be silently
      performed on addresses which are not properly truncated. For example,
      1.2.3.4/24 is accepted as the same address as 1.2.3.0/24. Similarly, for
      IPv6, 2001:db8::1/32 is accepted as the same address as 2001:db8::/32.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""The action to take on matched requests.

    Values:
      UNSPECIFIED_ACTION: <no description>
      ALLOW: Matching requests are allowed.
      DENY: Matching requests are denied.
    """
    UNSPECIFIED_ACTION = 0
    ALLOW = 1
    DENY = 2

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  description = _messages.StringField(2)
  priority = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sourceRange = _messages.StringField(4)


class HealthCheck(_messages.Message):
  r"""Health checking configuration for VM instances. Unhealthy instances are
  killed and replaced with new instances. Only applicable for instances in App
  Engine flexible environment.

  Fields:
    checkInterval: Interval between health checks.
    disableHealthCheck: Whether to explicitly disable health checks for this
      instance.
    healthyThreshold: Number of consecutive successful health checks required
      before receiving traffic.
    host: Host header to send when performing an HTTP health check. Example:
      "myapp.appspot.com"
    restartThreshold: Number of consecutive failed health checks required
      before an instance is restarted.
    timeout: Time before the health check is considered failed.
    unhealthyThreshold: Number of consecutive failed health checks required
      before removing traffic.
  """

  checkInterval = _messages.StringField(1)
  disableHealthCheck = _messages.BooleanField(2)
  healthyThreshold = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  host = _messages.StringField(4)
  restartThreshold = _messages.IntegerField(5, variant=_messages.Variant.UINT32)
  timeout = _messages.StringField(6)
  unhealthyThreshold = _messages.IntegerField(7, variant=_messages.Variant.UINT32)


class IdentityAwareProxy(_messages.Message):
  r"""Identity-Aware Proxy

  Fields:
    enabled: Whether the serving infrastructure will authenticate and
      authorize all incoming requests.If true, the oauth2_client_id and
      oauth2_client_secret fields must be non-empty.
    oauth2ClientId: OAuth2 client ID to use for the authentication flow.
    oauth2ClientInfo: InputOnly OAuth client info required to generate client
      id to be used for IAP.
    oauth2ClientSecret: OAuth2 client secret to use for the authentication
      flow.For security reasons, this value cannot be retrieved via the API.
      Instead, the SHA-256 hash of the value is returned in the
      oauth2_client_secret_sha256 field.@InputOnly
    oauth2ClientSecretSha256: Hex-encoded SHA-256 hash of the client
      secret.@OutputOnly
  """

  enabled = _messages.BooleanField(1)
  oauth2ClientId = _messages.StringField(2)
  oauth2ClientInfo = _messages.MessageField('OAuth2ClientInfo', 3)
  oauth2ClientSecret = _messages.StringField(4)
  oauth2ClientSecretSha256 = _messages.StringField(5)


class Instance(_messages.Message):
  r"""An Instance resource is the computing unit that App Engine uses to
  automatically scale an application.

  Enums:
    AvailabilityValueValuesEnum: Availability of the instance.@OutputOnly

  Fields:
    appEngineRelease: App Engine release this instance is running
      on.@OutputOnly
    availability: Availability of the instance.@OutputOnly
    averageLatency: Average latency (ms) over the last minute.@OutputOnly
    errors: Number of errors since this instance was started.@OutputOnly
    id: Relative name of the instance within the version. Example:
      instance-1.@OutputOnly
    memoryUsage: Total memory in use (bytes).@OutputOnly
    name: Full path to the Instance resource in the API. Example:
      apps/myapp/services/default/versions/v1/instances/instance-1.@OutputOnly
    qps: Average queries per second (QPS) over the last minute.@OutputOnly
    requests: Number of requests since this instance was started.@OutputOnly
    startTime: Time that this instance was started.@OutputOnly
    vmDebugEnabled: Whether this instance is in debug mode. Only applicable
      for instances in App Engine flexible environment.@OutputOnly
    vmId: Virtual machine ID of this instance. Only applicable for instances
      in App Engine flexible environment.@OutputOnly
    vmIp: The IP address of this instance. Only applicable for instances in
      App Engine flexible environment.@OutputOnly
    vmName: Name of the virtual machine where this instance lives. Only
      applicable for instances in App Engine flexible environment.@OutputOnly
    vmStatus: Status of the virtual machine where this instance lives. Only
      applicable for instances in App Engine flexible environment.@OutputOnly
    vmZoneName: Zone where the virtual machine is located. Only applicable for
      instances in App Engine flexible environment.@OutputOnly
  """

  class AvailabilityValueValuesEnum(_messages.Enum):
    r"""Availability of the instance.@OutputOnly

    Values:
      UNSPECIFIED: <no description>
      RESIDENT: <no description>
      DYNAMIC: <no description>
    """
    UNSPECIFIED = 0
    RESIDENT = 1
    DYNAMIC = 2

  appEngineRelease = _messages.StringField(1)
  availability = _messages.EnumField('AvailabilityValueValuesEnum', 2)
  averageLatency = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  errors = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  id = _messages.StringField(5)
  memoryUsage = _messages.IntegerField(6)
  name = _messages.StringField(7)
  qps = _messages.FloatField(8, variant=_messages.Variant.FLOAT)
  requests = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(10)
  vmDebugEnabled = _messages.BooleanField(11)
  vmId = _messages.StringField(12)
  vmIp = _messages.StringField(13)
  vmName = _messages.StringField(14)
  vmStatus = _messages.StringField(15)
  vmZoneName = _messages.StringField(16)


class Library(_messages.Message):
  r"""Third-party Python runtime library that is required by the application.

  Fields:
    name: Name of the library. Example: "django".
    version: Version of the library to select, or "latest".
  """

  name = _messages.StringField(1)
  version = _messages.StringField(2)


class ListAuthorizedCertificatesResponse(_messages.Message):
  r"""Response message for AuthorizedCertificates.ListAuthorizedCertificates.

  Fields:
    certificates: The SSL certificates the user is authorized to administer.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  certificates = _messages.MessageField('AuthorizedCertificate', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAuthorizedDomainsResponse(_messages.Message):
  r"""Response message for AuthorizedDomains.ListAuthorizedDomains.

  Fields:
    domains: The authorized domains belonging to the user.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  domains = _messages.MessageField('AuthorizedDomain', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDomainMappingsResponse(_messages.Message):
  r"""Response message for DomainMappings.ListDomainMappings.

  Fields:
    domainMappings: The domain mappings for the application.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  domainMappings = _messages.MessageField('DomainMapping', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListIngressRulesResponse(_messages.Message):
  r"""Response message for Firewall.ListIngressRules.

  Fields:
    ingressRules: The ingress FirewallRules for this application.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  ingressRules = _messages.MessageField('FirewallRule', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListInstancesResponse(_messages.Message):
  r"""Response message for Instances.ListInstances.

  Fields:
    instances: The instances belonging to the requested version.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListServicesResponse(_messages.Message):
  r"""Response message for Services.ListServices.

  Fields:
    nextPageToken: Continuation token for fetching the next page of results.
    services: The services belonging to the requested application.
  """

  nextPageToken = _messages.StringField(1)
  services = _messages.MessageField('Service', 2, repeated=True)


class ListVersionsResponse(_messages.Message):
  r"""Response message for Versions.ListVersions.

  Fields:
    nextPageToken: Continuation token for fetching the next page of results.
    versions: The versions belonging to the requested service.
  """

  nextPageToken = _messages.StringField(1)
  versions = _messages.MessageField('Version', 2, repeated=True)


class LivenessCheck(_messages.Message):
  r"""Health checking configuration for VM instances. Unhealthy instances are
  killed and replaced with new instances.

  Fields:
    checkInterval: Interval between health checks.
    failureThreshold: Number of consecutive failed checks required before
      considering the VM unhealthy.
    host: Host header to send when performing a HTTP Liveness check. Example:
      "myapp.appspot.com"
    initialDelay: The initial delay before starting to execute the checks.
    path: The request path.
    successThreshold: Number of consecutive successful checks required before
      considering the VM healthy.
    timeout: Time before the check is considered failed.
  """

  checkInterval = _messages.StringField(1)
  failureThreshold = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  host = _messages.StringField(3)
  initialDelay = _messages.StringField(4)
  path = _messages.StringField(5)
  successThreshold = _messages.IntegerField(6, variant=_messages.Variant.UINT32)
  timeout = _messages.StringField(7)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: "us-east1".
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: "projects/example-project/locations/us-
      east1"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationMetadata(_messages.Message):
  r"""Metadata for the given google.cloud.location.Location.

  Fields:
    flexibleEnvironmentAvailable: App Engine flexible environment is available
      in the given location.@OutputOnly
    standardEnvironmentAvailable: App Engine standard environment is available
      in the given location.@OutputOnly
  """

  flexibleEnvironmentAvailable = _messages.BooleanField(1)
  standardEnvironmentAvailable = _messages.BooleanField(2)


class ManagedCertificate(_messages.Message):
  r"""A certificate managed by App Engine.

  Enums:
    StatusValueValuesEnum: Status of certificate management. Refers to the
      most recent certificate acquisition or renewal attempt.@OutputOnly

  Fields:
    lastRenewalTime: Time at which the certificate was last renewed. The
      renewal process is fully managed. Certificate renewal will automatically
      occur before the certificate expires. Renewal errors can be tracked via
      ManagementStatus.@OutputOnly
    status: Status of certificate management. Refers to the most recent
      certificate acquisition or renewal attempt.@OutputOnly
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of certificate management. Refers to the most recent
    certificate acquisition or renewal attempt.@OutputOnly

    Values:
      MANAGEMENT_STATUS_UNSPECIFIED: <no description>
      OK: Certificate was successfully obtained and inserted into the serving
        system.
      PENDING: Certificate is under active attempts to acquire or renew.
      FAILED_RETRYING_NOT_VISIBLE: Most recent renewal failed due to an
        invalid DNS setup and will be retried. Renewal attempts will continue
        to fail until the certificate domain's DNS configuration is fixed. The
        last successfully provisioned certificate may still be serving.
      FAILED_PERMANENT: All renewal attempts have been exhausted, likely due
        to an invalid DNS setup.
      FAILED_RETRYING_CAA_FORBIDDEN: Most recent renewal failed due to an
        explicit CAA record that does not include the in-use CA, Let's
        Encrypt. Renewals will continue to fail until the CAA is reconfigured.
        The last successfully provisioned certificate may still be serving.
      FAILED_RETRYING_CAA_CHECKING: Most recent renewal failed due to a CAA
        retrieval failure. This means that the domain's DNS provider does not
        properly handle CAA records, failing requests for CAA records when no
        CAA records are defined. Renewals will continue to fail until the DNS
        provider is changed or a CAA record is added for the given domain. The
        last successfully provisioned certificate may still be serving.
    """
    MANAGEMENT_STATUS_UNSPECIFIED = 0
    OK = 1
    PENDING = 2
    FAILED_RETRYING_NOT_VISIBLE = 3
    FAILED_PERMANENT = 4
    FAILED_RETRYING_CAA_FORBIDDEN = 5
    FAILED_RETRYING_CAA_CHECKING = 6

  lastRenewalTime = _messages.StringField(1)
  status = _messages.EnumField('StatusValueValuesEnum', 2)


class ManualScaling(_messages.Message):
  r"""A service with manual scaling runs continuously, allowing you to perform
  complex initialization and rely on the state of its memory over time.

  Fields:
    instances: Number of instances to assign to the service at the start. This
      number can later be altered by using the Modules API
      (https://cloud.google.com/appengine/docs/python/modules/functions)
      set_num_instances() function.
  """

  instances = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Network(_messages.Message):
  r"""Extra network settings. Only applicable in the App Engine flexible
  environment.

  Fields:
    forwardedPorts: List of ports, or port pairs, to forward from the virtual
      machine to the application container. Only applicable in the App Engine
      flexible environment.
    instanceTag: Tag to apply to the instance during creation. Only applicable
      in the App Engine flexible environment.
    name: Google Compute Engine network where the virtual machines are
      created. Specify the short name, not the resource path.Defaults to
      default.
    sessionAffinity: Enable session affinity.
    subnetworkName: Google Cloud Platform sub-network where the virtual
      machines are created. Specify the short name, not the resource path.If a
      subnetwork name is specified, a network name will also be required
      unless it is for the default network. If the network that the instance
      is being created in is a Legacy network, then the IP address is
      allocated from the IPv4Range. If the network that the instance is being
      created in is an auto Subnet Mode Network, then only network name should
      be specified (not the subnetwork_name) and the IP address is created
      from the IPCidrRange of the subnetwork that exists in that zone for that
      network. If the network that the instance is being created in is a
      custom Subnet Mode Network, then the subnetwork_name must be specified
      and the IP address is created from the IPCidrRange of the subnetwork.If
      specified, the subnetwork must exist in the same region as the App
      Engine flexible environment application.
  """

  forwardedPorts = _messages.StringField(1, repeated=True)
  instanceTag = _messages.StringField(2)
  name = _messages.StringField(3)
  sessionAffinity = _messages.BooleanField(4)
  subnetworkName = _messages.StringField(5)


class NetworkUtilization(_messages.Message):
  r"""Target scaling by network usage. Only applicable in the App Engine
  flexible environment.

  Fields:
    targetReceivedBytesPerSecond: Target bytes received per second.
    targetReceivedPacketsPerSecond: Target packets received per second.
    targetSentBytesPerSecond: Target bytes sent per second.
    targetSentPacketsPerSecond: Target packets sent per second.
  """

  targetReceivedBytesPerSecond = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetReceivedPacketsPerSecond = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  targetSentBytesPerSecond = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  targetSentPacketsPerSecond = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class OAuth2ClientInfo(_messages.Message):
  r"""A OAuth2ClientInfo object.

  Fields:
    applicationName: Application name to be used in OAuth consent screen.
    clientName: Nameof the client to be generated. Optional - If not provided,
      the name will be autogenerated by the backend.
    developerEmailAddress: Developer's information to be used in OAuth consent
      screen.
  """

  applicationName = _messages.StringField(1)
  clientName = _messages.StringField(2)
  developerEmailAddress = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as Delete, the
      response is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.

  Fields:
    done: If the value is false, it means the operation is still in progress.
      If true, the operation is completed, and either error or response is
      available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the name should have the format of operations/some/unique/name.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as Delete, the response
    is google.protobuf.Empty. If the original method is standard
    Get/Create/Update, the response should be the resource. For other methods,
    the response should have the type XxxResponse, where Xxx is the original
    method name. For example, if the original method name is TakeSnapshot(),
    the inferred response type is TakeSnapshotResponse.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Timestamp that this operation completed.@OutputOnly
    insertTime: Timestamp that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.v1beta4.Version.CreateVersion.@OutputOnly
    operationType: Type of this operation. Deprecated, use method field
      instead. Example: "create_version".@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/modules/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
  """

  endTime = _messages.StringField(1)
  insertTime = _messages.StringField(2)
  method = _messages.StringField(3)
  operationType = _messages.StringField(4)
  target = _messages.StringField(5)
  user = _messages.StringField(6)


class OperationMetadataV1(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation.

  Fields:
    createVersionMetadata: A CreateVersionMetadataV1 attribute.
    endTime: Time that this operation completed.@OutputOnly
    ephemeralMessage: Ephemeral message that may change every time the
      operation is polled. @OutputOnly
    insertTime: Time that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.v1.Versions.CreateVersion.@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/services/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
    warning: Durable messages that persist on every operation poll.
      @OutputOnly
  """

  createVersionMetadata = _messages.MessageField('CreateVersionMetadataV1', 1)
  endTime = _messages.StringField(2)
  ephemeralMessage = _messages.StringField(3)
  insertTime = _messages.StringField(4)
  method = _messages.StringField(5)
  target = _messages.StringField(6)
  user = _messages.StringField(7)
  warning = _messages.StringField(8, repeated=True)


class OperationMetadataV1Alpha(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation.

  Fields:
    createVersionMetadata: A CreateVersionMetadataV1Alpha attribute.
    endTime: Time that this operation completed.@OutputOnly
    ephemeralMessage: Ephemeral message that may change every time the
      operation is polled. @OutputOnly
    insertTime: Time that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.v1alpha.Versions.CreateVersion.@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/services/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
    warning: Durable messages that persist on every operation poll.
      @OutputOnly
  """

  createVersionMetadata = _messages.MessageField('CreateVersionMetadataV1Alpha', 1)
  endTime = _messages.StringField(2)
  ephemeralMessage = _messages.StringField(3)
  insertTime = _messages.StringField(4)
  method = _messages.StringField(5)
  target = _messages.StringField(6)
  user = _messages.StringField(7)
  warning = _messages.StringField(8, repeated=True)


class OperationMetadataV1Beta(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation.

  Fields:
    createVersionMetadata: A CreateVersionMetadataV1Beta attribute.
    endTime: Time that this operation completed.@OutputOnly
    ephemeralMessage: Ephemeral message that may change every time the
      operation is polled. @OutputOnly
    insertTime: Time that this operation was created.@OutputOnly
    method: API method that initiated this operation. Example:
      google.appengine.v1beta.Versions.CreateVersion.@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/services/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
    warning: Durable messages that persist on every operation poll.
      @OutputOnly
  """

  createVersionMetadata = _messages.MessageField('CreateVersionMetadataV1Beta', 1)
  endTime = _messages.StringField(2)
  ephemeralMessage = _messages.StringField(3)
  insertTime = _messages.StringField(4)
  method = _messages.StringField(5)
  target = _messages.StringField(6)
  user = _messages.StringField(7)
  warning = _messages.StringField(8, repeated=True)


class OperationMetadataV1Beta5(_messages.Message):
  r"""Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Timestamp that this operation completed.@OutputOnly
    insertTime: Timestamp that this operation was created.@OutputOnly
    method: API method name that initiated this operation. Example:
      google.appengine.v1beta5.Version.CreateVersion.@OutputOnly
    target: Name of the resource that this operation is acting on. Example:
      apps/myapp/services/default.@OutputOnly
    user: User who requested this operation.@OutputOnly
  """

  endTime = _messages.StringField(1)
  insertTime = _messages.StringField(2)
  method = _messages.StringField(3)
  target = _messages.StringField(4)
  user = _messages.StringField(5)


class ReadinessCheck(_messages.Message):
  r"""Readiness checking configuration for VM instances. Unhealthy instances
  are removed from traffic rotation.

  Fields:
    appStartTimeout: A maximum time limit on application initialization,
      measured from moment the application successfully replies to a
      healthcheck until it is ready to serve traffic.
    checkInterval: Interval between health checks.
    failureThreshold: Number of consecutive failed checks required before
      removing traffic.
    host: Host header to send when performing a HTTP Readiness check. Example:
      "myapp.appspot.com"
    path: The request path.
    successThreshold: Number of consecutive successful checks required before
      receiving traffic.
    timeout: Time before the check is considered failed.
  """

  appStartTimeout = _messages.StringField(1)
  checkInterval = _messages.StringField(2)
  failureThreshold = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  host = _messages.StringField(4)
  path = _messages.StringField(5)
  successThreshold = _messages.IntegerField(6, variant=_messages.Variant.UINT32)
  timeout = _messages.StringField(7)


class RepairApplicationRequest(_messages.Message):
  r"""Request message for 'Applications.RepairApplication'."""


class RequestUtilization(_messages.Message):
  r"""Target scaling by request utilization. Only applicable in the App Engine
  flexible environment.

  Fields:
    targetConcurrentRequests: Target number of concurrent requests.
    targetRequestCountPerSecond: Target requests per second.
  """

  targetConcurrentRequests = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetRequestCountPerSecond = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ResourceRecord(_messages.Message):
  r"""A DNS resource record.

  Enums:
    TypeValueValuesEnum: Resource record type. Example: AAAA.

  Fields:
    name: Relative name of the object affected by this record. Only applicable
      for CNAME records. Example: 'www'.
    rrdata: Data for this record. Values vary by record type, as defined in
      RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
    type: Resource record type. Example: AAAA.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Resource record type. Example: AAAA.

    Values:
      A: An A resource record. Data is an IPv4 address.
      AAAA: An AAAA resource record. Data is an IPv6 address.
      CNAME: A CNAME resource record. Data is a domain name to be aliased.
    """
    A = 0
    AAAA = 1
    CNAME = 2

  name = _messages.StringField(1)
  rrdata = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class Resources(_messages.Message):
  r"""Machine resources for a version.

  Fields:
    cpu: Number of CPU cores needed.
    diskGb: Disk size (GB) needed.
    memoryGb: Memory (GB) needed.
    volumes: User specified volumes.
  """

  cpu = _messages.FloatField(1)
  diskGb = _messages.FloatField(2)
  memoryGb = _messages.FloatField(3)
  volumes = _messages.MessageField('Volume', 4, repeated=True)


class ScriptHandler(_messages.Message):
  r"""Executes a script to handle the request that matches the URL pattern.

  Fields:
    scriptPath: Path to the script from the application root directory.
  """

  scriptPath = _messages.StringField(1)


class Service(_messages.Message):
  r"""A Service resource is a logical component of an application that can
  share state and communicate in a secure fashion with other services. For
  example, an application that handles customer requests might include
  separate services to handle tasks such as backend data analysis or API
  requests from mobile devices. Each service has a collection of versions that
  define a specific set of code used to implement the functionality of that
  service.

  Fields:
    id: Relative name of the service within the application. Example:
      default.@OutputOnly
    name: Full path to the Service resource in the API. Example:
      apps/myapp/services/default.@OutputOnly
    split: Mapping that defines fractional HTTP traffic diversion to different
      versions within the service.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  split = _messages.MessageField('TrafficSplit', 3)


class SslSettings(_messages.Message):
  r"""SSL configuration for a DomainMapping resource.

  Enums:
    SslManagementTypeValueValuesEnum: SSL management type for this domain. If
      AUTOMATIC, a managed certificate is automatically provisioned. If
      MANUAL, certificate_id must be manually specified in order to configure
      SSL for this domain.

  Fields:
    certificateId: ID of the AuthorizedCertificate resource configuring SSL
      for the application. Clearing this field will remove SSL support.By
      default, a managed certificate is automatically created for every domain
      mapping. To omit SSL support or to configure SSL manually, specify
      SslManagementType.MANUAL on a CREATE or UPDATE request. You must be
      authorized to administer the AuthorizedCertificate resource to manually
      map it to a DomainMapping resource. Example: 12345.
    pendingManagedCertificateId: ID of the managed AuthorizedCertificate
      resource currently being provisioned, if applicable. Until the new
      managed certificate has been successfully provisioned, the previous SSL
      state will be preserved. Once the provisioning process completes, the
      certificate_id field will reflect the new managed certificate and this
      field will be left empty. To remove SSL support while there is still a
      pending managed certificate, clear the certificate_id field with an
      UpdateDomainMappingRequest.@OutputOnly
    sslManagementType: SSL management type for this domain. If AUTOMATIC, a
      managed certificate is automatically provisioned. If MANUAL,
      certificate_id must be manually specified in order to configure SSL for
      this domain.
  """

  class SslManagementTypeValueValuesEnum(_messages.Enum):
    r"""SSL management type for this domain. If AUTOMATIC, a managed
    certificate is automatically provisioned. If MANUAL, certificate_id must
    be manually specified in order to configure SSL for this domain.

    Values:
      AUTOMATIC: SSL support for this domain is configured automatically. The
        mapped SSL certificate will be automatically renewed.
      MANUAL: SSL support for this domain is configured manually by the user.
        Either the domain has no SSL support or a user-obtained SSL
        certificate has been explictly mapped to this domain.
    """
    AUTOMATIC = 0
    MANUAL = 1

  certificateId = _messages.StringField(1)
  pendingManagedCertificateId = _messages.StringField(2)
  sslManagementType = _messages.EnumField('SslManagementTypeValueValuesEnum', 3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StandardSchedulerSettings(_messages.Message):
  r"""Scheduler settings for standard environment.

  Fields:
    maxInstances: Maximum number of instances to run for this version. Set to
      zero to disable max_instances configuration.
    minInstances: Minimum number of instances to run for this version. Set to
      zero to disable min_instances configuration.
    targetCpuUtilization: Target CPU utilization ratio to maintain when
      scaling.
    targetThroughputUtilization: Target throughput utilization ratio to
      maintain when scaling
  """

  maxInstances = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minInstances = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  targetCpuUtilization = _messages.FloatField(3)
  targetThroughputUtilization = _messages.FloatField(4)


class StaticFilesHandler(_messages.Message):
  r"""Files served directly to the user for a given URL, such as images, CSS
  stylesheets, or JavaScript source files. Static file handlers describe which
  files in the application directory are static files, and which URLs serve
  them.

  Messages:
    HttpHeadersValue: HTTP headers to use for all responses from these URLs.

  Fields:
    applicationReadable: Whether files should also be uploaded as code data.
      By default, files declared in static file handlers are uploaded as
      static data and are only served to end users; they cannot be read by the
      application. If enabled, uploads are charged against both your code and
      static data storage resource quotas.
    expiration: Time a static file served by this handler should be cached by
      web proxies and browsers.
    httpHeaders: HTTP headers to use for all responses from these URLs.
    mimeType: MIME type used to serve all files served by this
      handler.Defaults to file-specific MIME types, which are derived from
      each file's filename extension.
    path: Path to the static files matched by the URL pattern, from the
      application root directory. The path can refer to text matched in
      groupings in the URL pattern.
    requireMatchingFile: Whether this handler should match the request if the
      file referenced by the handler does not exist.
    uploadPathRegex: Regular expression that matches the file paths for all
      files that should be referenced by this handler.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HttpHeadersValue(_messages.Message):
    r"""HTTP headers to use for all responses from these URLs.

    Messages:
      AdditionalProperty: An additional property for a HttpHeadersValue
        object.

    Fields:
      additionalProperties: Additional properties of type HttpHeadersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HttpHeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  applicationReadable = _messages.BooleanField(1)
  expiration = _messages.StringField(2)
  httpHeaders = _messages.MessageField('HttpHeadersValue', 3)
  mimeType = _messages.StringField(4)
  path = _messages.StringField(5)
  requireMatchingFile = _messages.BooleanField(6)
  uploadPathRegex = _messages.StringField(7)


class Status(_messages.Message):
  r"""The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). The error model is designed to be:
  Simple to use and understand for most users Flexible enough to meet
  unexpected needsOverviewThe Status message contains three pieces of data:
  error code, error message, and error details. The error code should be an
  enum value of google.rpc.Code, but it may accept additional error codes if
  needed. The error message should be a developer-facing English message that
  helps developers understand and resolve the error. If a localized user-
  facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package google.rpc that can be used for common error
  conditions.Language mappingThe Status message is the logical representation
  of the error model, but it is not necessarily the actual wire format. When
  the Status message is exposed in different client libraries and different
  wire protocols, it can be mapped differently. For example, it will likely be
  mapped to some exceptions in Java, but more likely mapped to some error
  codes in C.Other usesThe error model and the Status message can be used in a
  variety of environments, either with or without APIs, to provide a
  consistent developer experience across different environments.Example uses
  of this error model include: Partial errors. If a service needs to return
  partial errors to the client, it may embed the Status in the normal response
  to indicate the partial errors. Workflow errors. A typical workflow has
  multiple steps. Each step may have a Status message for error reporting.
  Batch operations. If a client uses batch request and batch response, the
  Status message should be used directly inside batch response, one for each
  error sub-response. Asynchronous operations. If an API call embeds
  asynchronous operation results in its response, the status of those
  operations should be represented directly using the Status message. Logging.
  If some API errors are stored in logs, the message Status could be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TrafficSplit(_messages.Message):
  r"""Traffic routing configuration for versions within a single service.
  Traffic splits define how traffic directed to the service is assigned to
  versions.

  Enums:
    ShardByValueValuesEnum: Mechanism used to determine which version a
      request is sent to. The traffic selection algorithm will be stable for
      either type until allocations are changed.

  Messages:
    AllocationsValue: Mapping from version IDs within the service to
      fractional (0.000, 1] allocations of traffic for that version. Each
      version can be specified only once, but some versions in the service may
      not have any traffic allocation. Services that have traffic allocated
      cannot be deleted until either the service is deleted or their traffic
      allocation is removed. Allocations must sum to 1. Up to two decimal
      place precision is supported for IP-based splits and up to three decimal
      places is supported for cookie-based splits.

  Fields:
    allocations: Mapping from version IDs within the service to fractional
      (0.000, 1] allocations of traffic for that version. Each version can be
      specified only once, but some versions in the service may not have any
      traffic allocation. Services that have traffic allocated cannot be
      deleted until either the service is deleted or their traffic allocation
      is removed. Allocations must sum to 1. Up to two decimal place precision
      is supported for IP-based splits and up to three decimal places is
      supported for cookie-based splits.
    shardBy: Mechanism used to determine which version a request is sent to.
      The traffic selection algorithm will be stable for either type until
      allocations are changed.
  """

  class ShardByValueValuesEnum(_messages.Enum):
    r"""Mechanism used to determine which version a request is sent to. The
    traffic selection algorithm will be stable for either type until
    allocations are changed.

    Values:
      UNSPECIFIED: Diversion method unspecified.
      COOKIE: Diversion based on a specially named cookie, "GOOGAPPUID." The
        cookie must be set by the application itself or no diversion will
        occur.
      IP: Diversion based on applying the modulus operation to a fingerprint
        of the IP address.
      RANDOM: Diversion based on weighted random assignment. An incoming
        request is randomly routed to a version in the traffic split, with
        probability proportional to the version's traffic share.
    """
    UNSPECIFIED = 0
    COOKIE = 1
    IP = 2
    RANDOM = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AllocationsValue(_messages.Message):
    r"""Mapping from version IDs within the service to fractional (0.000, 1]
    allocations of traffic for that version. Each version can be specified
    only once, but some versions in the service may not have any traffic
    allocation. Services that have traffic allocated cannot be deleted until
    either the service is deleted or their traffic allocation is removed.
    Allocations must sum to 1. Up to two decimal place precision is supported
    for IP-based splits and up to three decimal places is supported for
    cookie-based splits.

    Messages:
      AdditionalProperty: An additional property for a AllocationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AllocationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AllocationsValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allocations = _messages.MessageField('AllocationsValue', 1)
  shardBy = _messages.EnumField('ShardByValueValuesEnum', 2)


class UrlDispatchRule(_messages.Message):
  r"""Rules to match an HTTP request and dispatch that request to a service.

  Fields:
    domain: Domain name to match against. The wildcard "*" is supported if
      specified before a period: "*.".Defaults to matching all domains: "*".
    path: Pathname within the host. Must start with a "/". A single "*" can be
      included at the end of the path.The sum of the lengths of the domain and
      path may not exceed 100 characters.
    service: Resource ID of a service in this application that should serve
      the matched request. The service must already exist. Example: default.
  """

  domain = _messages.StringField(1)
  path = _messages.StringField(2)
  service = _messages.StringField(3)


class UrlMap(_messages.Message):
  r"""URL pattern and description of how the URL should be handled. App Engine
  can handle URLs by executing application code or by serving static files
  uploaded with the version, such as images, CSS, or JavaScript.

  Enums:
    AuthFailActionValueValuesEnum: Action to take when users access resources
      that require authentication. Defaults to redirect.
    LoginValueValuesEnum: Level of login required to access this resource. Not
      supported for Node.js in the App Engine standard environment.
    RedirectHttpResponseCodeValueValuesEnum: 30x code to use when performing
      redirects for the secure field. Defaults to 302.
    SecurityLevelValueValuesEnum: Security (HTTPS) enforcement for this URL.

  Fields:
    apiEndpoint: Uses API Endpoints to handle requests.
    authFailAction: Action to take when users access resources that require
      authentication. Defaults to redirect.
    login: Level of login required to access this resource. Not supported for
      Node.js in the App Engine standard environment.
    redirectHttpResponseCode: 30x code to use when performing redirects for
      the secure field. Defaults to 302.
    script: Executes a script to handle the requests that match this URL
      pattern. Only the auto value is supported for Node.js in the App Engine
      standard environment, for example "script": "auto".
    securityLevel: Security (HTTPS) enforcement for this URL.
    staticFiles: Returns the contents of a file, such as an image, as the
      response.
    urlRegex: URL prefix. Uses regular expression syntax, which means regexp
      special characters must be escaped, but should not contain groupings.
      All URLs that begin with this prefix are handled by this handler, using
      the portion of the URL after the prefix as part of the file path.
  """

  class AuthFailActionValueValuesEnum(_messages.Enum):
    r"""Action to take when users access resources that require
    authentication. Defaults to redirect.

    Values:
      AUTH_FAIL_ACTION_UNSPECIFIED: Not specified. AUTH_FAIL_ACTION_REDIRECT
        is assumed.
      AUTH_FAIL_ACTION_REDIRECT: Redirects user to "accounts.google.com". The
        user is redirected back to the application URL after signing in or
        creating an account.
      AUTH_FAIL_ACTION_UNAUTHORIZED: Rejects request with a 401 HTTP status
        code and an error message.
    """
    AUTH_FAIL_ACTION_UNSPECIFIED = 0
    AUTH_FAIL_ACTION_REDIRECT = 1
    AUTH_FAIL_ACTION_UNAUTHORIZED = 2

  class LoginValueValuesEnum(_messages.Enum):
    r"""Level of login required to access this resource. Not supported for
    Node.js in the App Engine standard environment.

    Values:
      LOGIN_UNSPECIFIED: Not specified. LOGIN_OPTIONAL is assumed.
      LOGIN_OPTIONAL: Does not require that the user is signed in.
      LOGIN_ADMIN: If the user is not signed in, the auth_fail_action is
        taken. In addition, if the user is not an administrator for the
        application, they are given an error message regardless of
        auth_fail_action. If the user is an administrator, the handler
        proceeds.
      LOGIN_REQUIRED: If the user has signed in, the handler proceeds
        normally. Otherwise, the auth_fail_action is taken.
    """
    LOGIN_UNSPECIFIED = 0
    LOGIN_OPTIONAL = 1
    LOGIN_ADMIN = 2
    LOGIN_REQUIRED = 3

  class RedirectHttpResponseCodeValueValuesEnum(_messages.Enum):
    r"""30x code to use when performing redirects for the secure field.
    Defaults to 302.

    Values:
      REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED: Not specified. 302 is assumed.
      REDIRECT_HTTP_RESPONSE_CODE_301: 301 Moved Permanently code.
      REDIRECT_HTTP_RESPONSE_CODE_302: 302 Moved Temporarily code.
      REDIRECT_HTTP_RESPONSE_CODE_303: 303 See Other code.
      REDIRECT_HTTP_RESPONSE_CODE_307: 307 Temporary Redirect code.
    """
    REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED = 0
    REDIRECT_HTTP_RESPONSE_CODE_301 = 1
    REDIRECT_HTTP_RESPONSE_CODE_302 = 2
    REDIRECT_HTTP_RESPONSE_CODE_303 = 3
    REDIRECT_HTTP_RESPONSE_CODE_307 = 4

  class SecurityLevelValueValuesEnum(_messages.Enum):
    r"""Security (HTTPS) enforcement for this URL.

    Values:
      SECURE_UNSPECIFIED: Not specified.
      SECURE_DEFAULT: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_NEVER: Requests for a URL that match this handler that use HTTPS
        are automatically redirected to the HTTP equivalent URL.
      SECURE_OPTIONAL: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used and respond accordingly.
      SECURE_ALWAYS: Requests for a URL that match this handler that do not
        use HTTPS are automatically redirected to the HTTPS URL with the same
        path. Query parameters are reserved for the redirect.
    """
    SECURE_UNSPECIFIED = 0
    SECURE_DEFAULT = 1
    SECURE_NEVER = 2
    SECURE_OPTIONAL = 3
    SECURE_ALWAYS = 4

  apiEndpoint = _messages.MessageField('ApiEndpointHandler', 1)
  authFailAction = _messages.EnumField('AuthFailActionValueValuesEnum', 2)
  login = _messages.EnumField('LoginValueValuesEnum', 3)
  redirectHttpResponseCode = _messages.EnumField('RedirectHttpResponseCodeValueValuesEnum', 4)
  script = _messages.MessageField('ScriptHandler', 5)
  securityLevel = _messages.EnumField('SecurityLevelValueValuesEnum', 6)
  staticFiles = _messages.MessageField('StaticFilesHandler', 7)
  urlRegex = _messages.StringField(8)


class Version(_messages.Message):
  r"""A Version resource is a specific set of source code and configuration
  files that are deployed into a service.

  Enums:
    InboundServicesValueListEntryValuesEnum:
    ServingStatusValueValuesEnum: Current serving status of this version. Only
      the versions with a SERVING status create instances and can be
      billed.SERVING_STATUS_UNSPECIFIED is an invalid value. Defaults to
      SERVING.

  Messages:
    BetaSettingsValue: Metadata settings that are supplied to this version to
      enable beta runtime features.
    EnvVariablesValue: Environment variables available to the application.Only
      returned in GET requests if view=FULL is set.

  Fields:
    apiConfig: Serving configuration for Google Cloud Endpoints
      (https://cloud.google.com/appengine/docs/python/endpoints/).Only
      returned in GET requests if view=FULL is set.
    automaticScaling: Automatic scaling is based on request rate, response
      latencies, and other application metrics.
    basicScaling: A service with basic scaling will create an instance when
      the application receives a request. The instance will be turned down
      when the app becomes idle. Basic scaling is ideal for work that is
      intermittent or driven by user activity.
    betaSettings: Metadata settings that are supplied to this version to
      enable beta runtime features.
    createTime: Time that this version was created.@OutputOnly
    createdBy: Email address of the user who created this version.@OutputOnly
    defaultExpiration: Duration that static files should be cached by web
      proxies and browsers. Only applicable if the corresponding
      StaticFilesHandler (https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1beta/apps.services.versions#staticfileshandler)
      does not specify its own expiration time.Only returned in GET requests
      if view=FULL is set.
    deployment: Code and application artifacts that make up this version.Only
      returned in GET requests if view=FULL is set.
    diskUsageBytes: Total size in bytes of all the files that are included in
      this version and currently hosted on the App Engine disk.@OutputOnly
    endpointsApiService: Cloud Endpoints configuration.If
      endpoints_api_service is set, the Cloud Endpoints Extensible Service
      Proxy will be provided to serve the API implemented by the app.
    entrypoint: The entrypoint for the application.
    env: App Engine execution environment for this version.Defaults to
      standard.
    envVariables: Environment variables available to the application.Only
      returned in GET requests if view=FULL is set.
    errorHandlers: Custom static error pages. Limited to 10KB per page.Only
      returned in GET requests if view=FULL is set.
    handlers: An ordered list of URL-matching patterns that should be applied
      to incoming requests. The first matching URL handles the request and
      other request handlers are not attempted.Only returned in GET requests
      if view=FULL is set.
    healthCheck: Configures health checking for instances. Unhealthy instances
      are stopped and replaced with new instances. Only applicable in the App
      Engine flexible environment.Only returned in GET requests if view=FULL
      is set.
    id: Relative name of the version within the service. Example: v1. Version
      names can contain only lowercase letters, numbers, or hyphens. Reserved
      names: "default", "latest", and any name with the prefix "ah-".
    inboundServices: Before an application can receive email or XMPP messages,
      the application must be configured to enable the service.
    instanceClass: Instance class that is used to run this version. Valid
      values are: AutomaticScaling: F1, F2, F4, F4_1G ManualScaling or
      BasicScaling: B1, B2, B4, B8, B4_1GDefaults to F1 for AutomaticScaling
      and B1 for ManualScaling or BasicScaling.
    libraries: Configuration for third-party Python runtime libraries that are
      required by the application.Only returned in GET requests if view=FULL
      is set.
    livenessCheck: Configures liveness health checking for instances.
      Unhealthy instances are stopped and replaced with new instancesOnly
      returned in GET requests if view=FULL is set.
    manualScaling: A service with manual scaling runs continuously, allowing
      you to perform complex initialization and rely on the state of its
      memory over time.
    name: Full path to the Version resource in the API. Example:
      apps/myapp/services/default/versions/v1.@OutputOnly
    network: Extra network settings. Only applicable in the App Engine
      flexible environment.
    nobuildFilesRegex: Files that match this pattern will not be built into
      this version. Only applicable for Go runtimes.Only returned in GET
      requests if view=FULL is set.
    readinessCheck: Configures readiness health checking for instances.
      Unhealthy instances are not put into the backend traffic rotation.Only
      returned in GET requests if view=FULL is set.
    resources: Machine resources for this version. Only applicable in the App
      Engine flexible environment.
    runtime: Desired runtime. Example: python27.
    runtimeApiVersion: The version of the API in the given runtime
      environment. Please see the app.yaml reference for valid values at https
      ://cloud.google.com/appengine/docs/standard/<language>/config/appref
    runtimeChannel: The channel of the runtime to use. Only available for some
      runtimes. Defaults to the default channel.
    servingStatus: Current serving status of this version. Only the versions
      with a SERVING status create instances and can be
      billed.SERVING_STATUS_UNSPECIFIED is an invalid value. Defaults to
      SERVING.
    threadsafe: Whether multiple requests can be dispatched to this version at
      once.
    versionUrl: Serving URL for this version. Example: "https://myversion-dot-
      myservice-dot-myapp.appspot.com"@OutputOnly
    vm: Whether to deploy this version in a container on a virtual machine.
    zones: The Google Compute Engine zones that are supported by this version
      in the App Engine flexible environment.
  """

  class InboundServicesValueListEntryValuesEnum(_messages.Enum):
    r"""InboundServicesValueListEntryValuesEnum enum type.

    Values:
      INBOUND_SERVICE_UNSPECIFIED: <no description>
      INBOUND_SERVICE_MAIL: <no description>
      INBOUND_SERVICE_MAIL_BOUNCE: <no description>
      INBOUND_SERVICE_XMPP_ERROR: <no description>
      INBOUND_SERVICE_XMPP_MESSAGE: <no description>
      INBOUND_SERVICE_XMPP_SUBSCRIBE: <no description>
      INBOUND_SERVICE_XMPP_PRESENCE: <no description>
      INBOUND_SERVICE_CHANNEL_PRESENCE: <no description>
      INBOUND_SERVICE_WARMUP: <no description>
    """
    INBOUND_SERVICE_UNSPECIFIED = 0
    INBOUND_SERVICE_MAIL = 1
    INBOUND_SERVICE_MAIL_BOUNCE = 2
    INBOUND_SERVICE_XMPP_ERROR = 3
    INBOUND_SERVICE_XMPP_MESSAGE = 4
    INBOUND_SERVICE_XMPP_SUBSCRIBE = 5
    INBOUND_SERVICE_XMPP_PRESENCE = 6
    INBOUND_SERVICE_CHANNEL_PRESENCE = 7
    INBOUND_SERVICE_WARMUP = 8

  class ServingStatusValueValuesEnum(_messages.Enum):
    r"""Current serving status of this version. Only the versions with a
    SERVING status create instances and can be
    billed.SERVING_STATUS_UNSPECIFIED is an invalid value. Defaults to
    SERVING.

    Values:
      SERVING_STATUS_UNSPECIFIED: Not specified.
      SERVING: Currently serving. Instances are created according to the
        scaling settings of the version.
      STOPPED: Disabled. No instances will be created and the scaling settings
        are ignored until the state of the version changes to SERVING.
    """
    SERVING_STATUS_UNSPECIFIED = 0
    SERVING = 1
    STOPPED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BetaSettingsValue(_messages.Message):
    r"""Metadata settings that are supplied to this version to enable beta
    runtime features.

    Messages:
      AdditionalProperty: An additional property for a BetaSettingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BetaSettingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BetaSettingsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvVariablesValue(_messages.Message):
    r"""Environment variables available to the application.Only returned in
    GET requests if view=FULL is set.

    Messages:
      AdditionalProperty: An additional property for a EnvVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type EnvVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  apiConfig = _messages.MessageField('ApiConfigHandler', 1)
  automaticScaling = _messages.MessageField('AutomaticScaling', 2)
  basicScaling = _messages.MessageField('BasicScaling', 3)
  betaSettings = _messages.MessageField('BetaSettingsValue', 4)
  createTime = _messages.StringField(5)
  createdBy = _messages.StringField(6)
  defaultExpiration = _messages.StringField(7)
  deployment = _messages.MessageField('Deployment', 8)
  diskUsageBytes = _messages.IntegerField(9)
  endpointsApiService = _messages.MessageField('EndpointsApiService', 10)
  entrypoint = _messages.MessageField('Entrypoint', 11)
  env = _messages.StringField(12)
  envVariables = _messages.MessageField('EnvVariablesValue', 13)
  errorHandlers = _messages.MessageField('ErrorHandler', 14, repeated=True)
  handlers = _messages.MessageField('UrlMap', 15, repeated=True)
  healthCheck = _messages.MessageField('HealthCheck', 16)
  id = _messages.StringField(17)
  inboundServices = _messages.EnumField('InboundServicesValueListEntryValuesEnum', 18, repeated=True)
  instanceClass = _messages.StringField(19)
  libraries = _messages.MessageField('Library', 20, repeated=True)
  livenessCheck = _messages.MessageField('LivenessCheck', 21)
  manualScaling = _messages.MessageField('ManualScaling', 22)
  name = _messages.StringField(23)
  network = _messages.MessageField('Network', 24)
  nobuildFilesRegex = _messages.StringField(25)
  readinessCheck = _messages.MessageField('ReadinessCheck', 26)
  resources = _messages.MessageField('Resources', 27)
  runtime = _messages.StringField(28)
  runtimeApiVersion = _messages.StringField(29)
  runtimeChannel = _messages.StringField(30)
  servingStatus = _messages.EnumField('ServingStatusValueValuesEnum', 31)
  threadsafe = _messages.BooleanField(32)
  versionUrl = _messages.StringField(33)
  vm = _messages.BooleanField(34)
  zones = _messages.StringField(35, repeated=True)


class Volume(_messages.Message):
  r"""Volumes mounted within the app container. Only applicable in the App
  Engine flexible environment.

  Fields:
    name: Unique name for the volume.
    sizeGb: Volume size in gigabytes.
    volumeType: Underlying volume type, e.g. 'tmpfs'.
  """

  name = _messages.StringField(1)
  sizeGb = _messages.FloatField(2)
  volumeType = _messages.StringField(3)


class ZipInfo(_messages.Message):
  r"""The zip file information for a zip deployment.

  Fields:
    filesCount: An estimate of the number of files in a zip for a zip
      deployment. If set, must be greater than or equal to the actual number
      of files. Used for optimizing performance; if not provided, deployment
      may be slow.
    sourceUrl: URL of the zip file to deploy from. Must be a URL to a resource
      in Google Cloud Storage in the form
      'http(s)://storage.googleapis.com/<bucket>/<object>'.
  """

  filesCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  sourceUrl = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
