"""Generated message classes for bigtableadmin version v2.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'bigtableadmin'


class AppProfile(_messages.Message):
  r"""A configuration object describing how Cloud Bigtable should treat
  traffic from a particular end user application.

  Fields:
    description: Optional long form description of the use case for this
      AppProfile.
    etag: Strongly validated etag for optimistic concurrency control. Preserve
      the value returned from `GetAppProfile` when calling `UpdateAppProfile`
      to fail the request if there has been a modification in the mean time.
      The `update_mask` of the request need not include `etag` for this
      protection to apply. See
      [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and [RFC
      7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more details.
    multiClusterRoutingUseAny: Use a multi-cluster routing policy that may
      pick any cluster.
    name: (`OutputOnly`) The unique name of the app profile. Values are of the
      form `projects/<project>/instances/<instance>/appProfiles/_a-zA-Z0-9*`.
    singleClusterRouting: Use a single-cluster routing policy.
  """

  description = _messages.StringField(1)
  etag = _messages.StringField(2)
  multiClusterRoutingUseAny = _messages.MessageField('MultiClusterRoutingUseAny', 3)
  name = _messages.StringField(4)
  singleClusterRouting = _messages.MessageField('SingleClusterRouting', 5)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BigtableadminOperationsCancelRequest(_messages.Message):
  r"""A BigtableadminOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsDeleteRequest(_messages.Message):
  r"""A BigtableadminOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsGetRequest(_messages.Message):
  r"""A BigtableadminOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsProjectsOperationsListRequest(_messages.Message):
  r"""A BigtableadminOperationsProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BigtableadminProjectsInstancesAppProfilesCreateRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesCreateRequest object.

  Fields:
    appProfile: A AppProfile resource to be passed as the request body.
    appProfileId: The ID to be used when referring to the new app profile
      within its instance, e.g., just `myprofile` rather than
      `projects/myproject/instances/myinstance/appProfiles/myprofile`.
    ignoreWarnings: If true, ignore safety checks when creating the app
      profile.
    parent: The unique name of the instance in which to create the new app
      profile. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  appProfile = _messages.MessageField('AppProfile', 1)
  appProfileId = _messages.StringField(2)
  ignoreWarnings = _messages.BooleanField(3)
  parent = _messages.StringField(4, required=True)


class BigtableadminProjectsInstancesAppProfilesDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesDeleteRequest object.

  Fields:
    ignoreWarnings: If true, ignore safety checks when deleting the app
      profile.
    name: The unique name of the app profile to be deleted. Values are of the
      form
      `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
  """

  ignoreWarnings = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesAppProfilesGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesGetRequest object.

  Fields:
    name: The unique name of the requested app profile. Values are of the form
      `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesAppProfilesListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesListRequest object.

  Fields:
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the instance for which a list of app profiles
      is requested. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesAppProfilesPatchRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesPatchRequest object.

  Fields:
    appProfile: A AppProfile resource to be passed as the request body.
    ignoreWarnings: If true, ignore safety checks when updating the app
      profile.
    name: (`OutputOnly`) The unique name of the app profile. Values are of the
      form `projects/<project>/instances/<instance>/appProfiles/_a-zA-Z0-9*`.
    updateMask: The subset of app profile fields which should be replaced. If
      unset, all fields will be replaced.
  """

  appProfile = _messages.MessageField('AppProfile', 1)
  ignoreWarnings = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class BigtableadminProjectsInstancesClustersCreateRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: The ID to be used when referring to the new cluster within its
      instance, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`.
    parent: The unique name of the instance in which to create the new
      cluster. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BigtableadminProjectsInstancesClustersDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersDeleteRequest object.

  Fields:
    name: The unique name of the cluster to be deleted. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersGetRequest object.

  Fields:
    name: The unique name of the requested cluster. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersListRequest object.

  Fields:
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the instance for which a list of clusters is
      requested. Values are of the form
      `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to
      list Clusters for all Instances in a project, e.g.,
      `projects/myproject/instances/-`.
  """

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesDeleteRequest object.

  Fields:
    name: The unique name of the instance to be deleted. Values are of the
      form `projects/<project>/instances/<instance>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesGetIamPolicyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesGetRequest object.

  Fields:
    name: The unique name of the requested instance. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesListRequest object.

  Fields:
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the project for which a list of instances is
      requested. Values are of the form `projects/<project>`.
  """

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesPartialUpdateInstanceRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesPartialUpdateInstanceRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: (`OutputOnly`) The unique name of the instance. Values are of the
      form `projects/<project>/instances/a-z+[a-z0-9]`.
    updateMask: The subset of Instance fields which should be replaced. Must
      be explicitly set.
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BigtableadminProjectsInstancesSetIamPolicyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BigtableadminProjectsInstancesTablesCheckConsistencyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesCheckConsistencyRequest object.

  Fields:
    checkConsistencyRequest: A CheckConsistencyRequest resource to be passed
      as the request body.
    name: The unique name of the Table for which to check replication
      consistency. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  checkConsistencyRequest = _messages.MessageField('CheckConsistencyRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesCreateRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesCreateRequest object.

  Fields:
    createTableRequest: A CreateTableRequest resource to be passed as the
      request body.
    parent: The unique name of the instance in which to create the table.
      Values are of the form `projects/<project>/instances/<instance>`.
  """

  createTableRequest = _messages.MessageField('CreateTableRequest', 1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesDeleteRequest object.

  Fields:
    name: The unique name of the table to be deleted. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesTablesDropRowRangeRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesDropRowRangeRequest object.

  Fields:
    dropRowRangeRequest: A DropRowRangeRequest resource to be passed as the
      request body.
    name: The unique name of the table on which to drop a range of rows.
      Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  dropRowRangeRequest = _messages.MessageField('DropRowRangeRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesGenerateConsistencyTokenRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesGenerateConsistencyTokenRequest
  object.

  Fields:
    generateConsistencyTokenRequest: A GenerateConsistencyTokenRequest
      resource to be passed as the request body.
    name: The unique name of the Table for which to create a consistency
      token. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  generateConsistencyTokenRequest = _messages.MessageField('GenerateConsistencyTokenRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesGetRequest object.

  Enums:
    ViewValueValuesEnum: The view to be applied to the returned table's
      fields. Defaults to `SCHEMA_VIEW` if unspecified.

  Fields:
    name: The unique name of the requested table. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
    view: The view to be applied to the returned table's fields. Defaults to
      `SCHEMA_VIEW` if unspecified.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view to be applied to the returned table's fields. Defaults to
    `SCHEMA_VIEW` if unspecified.

    Values:
      VIEW_UNSPECIFIED: <no description>
      NAME_ONLY: <no description>
      SCHEMA_VIEW: <no description>
      REPLICATION_VIEW: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    NAME_ONLY = 1
    SCHEMA_VIEW = 2
    REPLICATION_VIEW = 3
    FULL = 4

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class BigtableadminProjectsInstancesTablesListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesListRequest object.

  Enums:
    ViewValueValuesEnum: The view to be applied to the returned tables'
      fields. Defaults to `NAME_ONLY` if unspecified; no others are currently
      supported.

  Fields:
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the instance for which tables should be listed.
      Values are of the form `projects/<project>/instances/<instance>`.
    view: The view to be applied to the returned tables' fields. Defaults to
      `NAME_ONLY` if unspecified; no others are currently supported.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view to be applied to the returned tables' fields. Defaults to
    `NAME_ONLY` if unspecified; no others are currently supported.

    Values:
      VIEW_UNSPECIFIED: <no description>
      NAME_ONLY: <no description>
      SCHEMA_VIEW: <no description>
      REPLICATION_VIEW: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    NAME_ONLY = 1
    SCHEMA_VIEW = 2
    REPLICATION_VIEW = 3
    FULL = 4

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 3)


class BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest
  object.

  Fields:
    modifyColumnFamiliesRequest: A ModifyColumnFamiliesRequest resource to be
      passed as the request body.
    name: The unique name of the table whose families should be modified.
      Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  modifyColumnFamiliesRequest = _messages.MessageField('ModifyColumnFamiliesRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class CheckConsistencyRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency

  Fields:
    consistencyToken: The token created using GenerateConsistencyToken for the
      Table.
  """

  consistencyToken = _messages.StringField(1)


class CheckConsistencyResponse(_messages.Message):
  r"""Response message for
  google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency

  Fields:
    consistent: True only if the token is consistent. A token is consistent if
      replication has caught up with the restrictions specified in the
      request.
  """

  consistent = _messages.BooleanField(1)


class Cluster(_messages.Message):
  r"""A resizable group of nodes in a particular cloud location, capable of
  serving all Tables in the parent Instance.

  Enums:
    DefaultStorageTypeValueValuesEnum: (`CreationOnly`) The type of storage
      used by this cluster to serve its parent instance's tables, unless
      explicitly overridden.
    StateValueValuesEnum: (`OutputOnly`) The current state of the cluster.

  Fields:
    defaultStorageType: (`CreationOnly`) The type of storage used by this
      cluster to serve its parent instance's tables, unless explicitly
      overridden.
    location: (`CreationOnly`) The location where this cluster's nodes and
      storage reside. For best performance, clients should be located as close
      as possible to this cluster. Currently only zones are supported, so
      values should be of the form `projects/<project>/locations/<zone>`.
    name: (`OutputOnly`) The unique name of the cluster. Values are of the
      form `projects/<project>/instances/<instance>/clusters/a-z*`.
    serveNodes: The number of nodes allocated to this cluster. More nodes
      enable higher throughput and more consistent performance.
    state: (`OutputOnly`) The current state of the cluster.
  """

  class DefaultStorageTypeValueValuesEnum(_messages.Enum):
    r"""(`CreationOnly`) The type of storage used by this cluster to serve its
    parent instance's tables, unless explicitly overridden.

    Values:
      STORAGE_TYPE_UNSPECIFIED: The user did not specify a storage type.
      SSD: Flash (SSD) storage should be used.
      HDD: Magnetic drive (HDD) storage should be used.
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    SSD = 1
    HDD = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""(`OutputOnly`) The current state of the cluster.

    Values:
      STATE_NOT_KNOWN: The state of the cluster could not be determined.
      READY: The cluster has been successfully created and is ready to serve
        requests.
      CREATING: The cluster is currently being created, and may be destroyed
        if the creation process encounters an error. A cluster may not be able
        to serve requests while being created.
      RESIZING: The cluster is currently being resized, and may revert to its
        previous node count if the process encounters an error. A cluster is
        still capable of serving requests while being resized, but may exhibit
        performance as if its number of allocated nodes is between the
        starting and requested states.
      DISABLED: The cluster has no backing nodes. The data (tables) still
        exist, but no operations can be performed on the cluster.
    """
    STATE_NOT_KNOWN = 0
    READY = 1
    CREATING = 2
    RESIZING = 3
    DISABLED = 4

  defaultStorageType = _messages.EnumField('DefaultStorageTypeValueValuesEnum', 1)
  location = _messages.StringField(2)
  name = _messages.StringField(3)
  serveNodes = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class ClusterState(_messages.Message):
  r"""The state of a table's data in a particular cluster.

  Enums:
    ReplicationStateValueValuesEnum: (`OutputOnly`) The state of replication
      for the table in this cluster.

  Fields:
    replicationState: (`OutputOnly`) The state of replication for the table in
      this cluster.
  """

  class ReplicationStateValueValuesEnum(_messages.Enum):
    r"""(`OutputOnly`) The state of replication for the table in this cluster.

    Values:
      STATE_NOT_KNOWN: The replication state of the table is unknown in this
        cluster.
      INITIALIZING: The cluster was recently created, and the table must
        finish copying over pre-existing data from other clusters before it
        can begin receiving live replication updates and serving Data API
        requests.
      PLANNED_MAINTENANCE: The table is temporarily unable to serve Data API
        requests from this cluster due to planned internal maintenance.
      UNPLANNED_MAINTENANCE: The table is temporarily unable to serve Data API
        requests from this cluster due to unplanned or emergency maintenance.
      READY: The table can serve Data API requests from this cluster.
        Depending on replication delay, reads may not immediately reflect the
        state of the table in other clusters.
    """
    STATE_NOT_KNOWN = 0
    INITIALIZING = 1
    PLANNED_MAINTENANCE = 2
    UNPLANNED_MAINTENANCE = 3
    READY = 4

  replicationState = _messages.EnumField('ReplicationStateValueValuesEnum', 1)


class ColumnFamily(_messages.Message):
  r"""A set of columns within a table which share a common configuration.

  Fields:
    gcRule: Garbage collection rule specified as a protobuf. Must serialize to
      at most 500 bytes.  NOTE: Garbage collection executes opportunistically
      in the background, and so it's possible for reads to return a cell even
      if it matches the active GC expression for its family.
  """

  gcRule = _messages.MessageField('GcRule', 1)


class CreateClusterMetadata(_messages.Message):
  r"""The metadata for the Operation returned by CreateCluster.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      CreateCluster operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('CreateClusterRequest', 2)
  requestTime = _messages.StringField(3)


class CreateClusterRequest(_messages.Message):
  r"""Request message for BigtableInstanceAdmin.CreateCluster.

  Fields:
    cluster: The cluster to be created. Fields marked `OutputOnly` must be
      left blank.
    clusterId: The ID to be used when referring to the new cluster within its
      instance, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`.
    parent: The unique name of the instance in which to create the new
      cluster. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3)


class CreateInstanceMetadata(_messages.Message):
  r"""The metadata for the Operation returned by CreateInstance.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      CreateInstance operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('CreateInstanceRequest', 2)
  requestTime = _messages.StringField(3)


class CreateInstanceRequest(_messages.Message):
  r"""Request message for BigtableInstanceAdmin.CreateInstance.

  Messages:
    ClustersValue: The clusters to be created within the instance, mapped by
      desired cluster ID, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
      marked `OutputOnly` must be left blank. Currently, at most two clusters
      can be specified.

  Fields:
    clusters: The clusters to be created within the instance, mapped by
      desired cluster ID, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
      marked `OutputOnly` must be left blank. Currently, at most two clusters
      can be specified.
    instance: The instance to create. Fields marked `OutputOnly` must be left
      blank.
    instanceId: The ID to be used when referring to the new instance within
      its project, e.g., just `myinstance` rather than
      `projects/myproject/instances/myinstance`.
    parent: The unique name of the project in which to create the new
      instance. Values are of the form `projects/<project>`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClustersValue(_messages.Message):
    r"""The clusters to be created within the instance, mapped by desired
    cluster ID, e.g., just `mycluster` rather than
    `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
    marked `OutputOnly` must be left blank. Currently, at most two clusters
    can be specified.

    Messages:
      AdditionalProperty: An additional property for a ClustersValue object.

    Fields:
      additionalProperties: Additional properties of type ClustersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ClustersValue object.

      Fields:
        key: Name of the additional property.
        value: A Cluster attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Cluster', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusters = _messages.MessageField('ClustersValue', 1)
  instance = _messages.MessageField('Instance', 2)
  instanceId = _messages.StringField(3)
  parent = _messages.StringField(4)


class CreateTableRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.CreateTable

  Fields:
    initialSplits: The optional list of row keys that will be used to
      initially split the table into several tablets (tablets are similar to
      HBase regions). Given two split keys, `s1` and `s2`, three tablets will
      be created, spanning the key ranges: `[, s1), [s1, s2), [s2, )`.
      Example:  * Row keys := `["a", "apple", "custom", "customer_1",
      "customer_2",`                `"other", "zz"]` * initial_split_keys :=
      `["apple", "customer_1", "customer_2", "other"]` * Key assignment:     -
      Tablet 1 `[, apple)                => {"a"}.`     - Tablet 2 `[apple,
      customer_1)      => {"apple", "custom"}.`     - Tablet 3 `[customer_1,
      customer_2) => {"customer_1"}.`     - Tablet 4 `[customer_2, other)
      => {"customer_2"}.`     - Tablet 5 `[other, )                =>
      {"other", "zz"}.`
    table: The Table to create.
    tableId: The name by which the new table should be referred to within the
      parent instance, e.g., `foobar` rather than `<parent>/tables/foobar`.
  """

  initialSplits = _messages.MessageField('Split', 1, repeated=True)
  table = _messages.MessageField('Table', 2)
  tableId = _messages.StringField(3)


class DropRowRangeRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange

  Fields:
    deleteAllDataFromTable: Delete all rows in the table. Setting this to
      false is a no-op.
    rowKeyPrefix: Delete all rows that start with this row key prefix. Prefix
      cannot be zero length.
  """

  deleteAllDataFromTable = _messages.BooleanField(1)
  rowKeyPrefix = _messages.BytesField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GcRule(_messages.Message):
  r"""Rule for determining which cells to delete during garbage collection.

  Fields:
    intersection: Delete cells that would be deleted by every nested rule.
    maxAge: Delete cells in a column older than the given age. Values must be
      at least one millisecond, and will be truncated to microsecond
      granularity.
    maxNumVersions: Delete all cells in a column except the most recent N.
    union: Delete cells that would be deleted by any nested rule.
  """

  intersection = _messages.MessageField('Intersection', 1)
  maxAge = _messages.StringField(2)
  maxNumVersions = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  union = _messages.MessageField('Union', 4)


class GenerateConsistencyTokenRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken
  """



class GenerateConsistencyTokenResponse(_messages.Message):
  r"""Response message for
  google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken

  Fields:
    consistencyToken: The generated consistency token.
  """

  consistencyToken = _messages.StringField(1)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method."""


class Instance(_messages.Message):
  r"""A collection of Bigtable Tables and the resources that serve them. All
  tables in an instance are served from a single Cluster.

  Enums:
    StateValueValuesEnum: (`OutputOnly`) The current state of the instance.
    TypeValueValuesEnum: The type of the instance. Defaults to `PRODUCTION`.

  Messages:
    LabelsValue: Labels are a flexible and lightweight mechanism for
      organizing cloud resources into groups that reflect a customer's
      organizational needs and deployment strategies. They can be used to
      filter resources and aggregate metrics.  * Label keys must be between 1
      and 63 characters long and must conform to   the regular expression:
      `\p{Ll}\p{Lo}{0,62}`. * Label values must be between 0 and 63 characters
      long and must conform to   the regular expression:
      `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more than 64 labels can be
      associated with a given resource. * Keys and values must both be under
      128 bytes.

  Fields:
    displayName: The descriptive name for this instance as it appears in UIs.
      Can be changed at any time, but should be kept globally unique to avoid
      confusion.
    labels: Labels are a flexible and lightweight mechanism for organizing
      cloud resources into groups that reflect a customer's organizational
      needs and deployment strategies. They can be used to filter resources
      and aggregate metrics.  * Label keys must be between 1 and 63 characters
      long and must conform to   the regular expression: `\p{Ll}\p{Lo}{0,62}`.
      * Label values must be between 0 and 63 characters long and must conform
      to   the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more
      than 64 labels can be associated with a given resource. * Keys and
      values must both be under 128 bytes.
    name: (`OutputOnly`) The unique name of the instance. Values are of the
      form `projects/<project>/instances/a-z+[a-z0-9]`.
    state: (`OutputOnly`) The current state of the instance.
    type: The type of the instance. Defaults to `PRODUCTION`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""(`OutputOnly`) The current state of the instance.

    Values:
      STATE_NOT_KNOWN: The state of the instance could not be determined.
      READY: The instance has been successfully created and can serve requests
        to its tables.
      CREATING: The instance is currently being created, and may be destroyed
        if the creation process encounters an error.
    """
    STATE_NOT_KNOWN = 0
    READY = 1
    CREATING = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the instance. Defaults to `PRODUCTION`.

    Values:
      TYPE_UNSPECIFIED: The type of the instance is unspecified. If set when
        creating an instance, a `PRODUCTION` instance will be created. If set
        when updating an instance, the type will be left unchanged.
      PRODUCTION: An instance meant for production use. `serve_nodes` must be
        set on the cluster.
      DEVELOPMENT: The instance is meant for development and testing purposes
        only; it has no performance or uptime guarantees and is not covered by
        SLA. After a development instance is created, it can be upgraded by
        updating the instance to type `PRODUCTION`. An instance created as a
        production instance cannot be changed to a development instance. When
        creating a development instance, `serve_nodes` on the cluster must not
        be set.
    """
    TYPE_UNSPECIFIED = 0
    PRODUCTION = 1
    DEVELOPMENT = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a flexible and lightweight mechanism for organizing cloud
    resources into groups that reflect a customer's organizational needs and
    deployment strategies. They can be used to filter resources and aggregate
    metrics.  * Label keys must be between 1 and 63 characters long and must
    conform to   the regular expression: `\p{Ll}\p{Lo}{0,62}`. * Label values
    must be between 0 and 63 characters long and must conform to   the regular
    expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more than 64 labels can be
    associated with a given resource. * Keys and values must both be under 128
    bytes.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class Intersection(_messages.Message):
  r"""A GcRule which deletes cells matching all of the given rules.

  Fields:
    rules: Only delete cells which would be deleted by every element of
      `rules`.
  """

  rules = _messages.MessageField('GcRule', 1, repeated=True)


class ListAppProfilesResponse(_messages.Message):
  r"""Response message for BigtableInstanceAdmin.ListAppProfiles.

  Fields:
    appProfiles: The list of requested app profiles.
    nextPageToken: Set if not all app profiles could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
  """

  appProfiles = _messages.MessageField('AppProfile', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListClustersResponse(_messages.Message):
  r"""Response message for BigtableInstanceAdmin.ListClusters.

  Fields:
    clusters: The list of requested clusters.
    failedLocations: Locations from which Cluster information could not be
      retrieved, due to an outage or some other transient condition. Clusters
      from these locations may be missing from `clusters`, or may only have
      partial information returned.
    nextPageToken: Set if not all clusters could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  failedLocations = _messages.StringField(2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListInstancesResponse(_messages.Message):
  r"""Response message for BigtableInstanceAdmin.ListInstances.

  Fields:
    failedLocations: Locations from which Instance information could not be
      retrieved, due to an outage or some other transient condition. Instances
      whose Clusters are all in one of the failed locations may be missing
      from `instances`, and Instances with at least one Cluster in a failed
      location may only have partial information returned.
    instances: The list of requested instances.
    nextPageToken: Set if not all instances could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
  """

  failedLocations = _messages.StringField(1, repeated=True)
  instances = _messages.MessageField('Instance', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListTablesResponse(_messages.Message):
  r"""Response message for
  google.bigtable.admin.v2.BigtableTableAdmin.ListTables

  Fields:
    nextPageToken: Set if not all tables could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
    tables: The tables present in the requested instance.
  """

  nextPageToken = _messages.StringField(1)
  tables = _messages.MessageField('Table', 2, repeated=True)


class Modification(_messages.Message):
  r"""A create, update, or delete of a particular column family.

  Fields:
    create: Create a new column family with the specified schema, or fail if
      one already exists with the given ID.
    drop: Drop (delete) the column family with the given ID, or fail if no
      such family exists.
    id: The ID of the column family to be modified.
    update: Update an existing column family to the specified schema, or fail
      if no column family exists with the given ID.
  """

  create = _messages.MessageField('ColumnFamily', 1)
  drop = _messages.BooleanField(2)
  id = _messages.StringField(3)
  update = _messages.MessageField('ColumnFamily', 4)


class ModifyColumnFamiliesRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies

  Fields:
    modifications: Modifications to be atomically applied to the specified
      table's families. Entries are applied in order, meaning that earlier
      modifications can be masked by later ones (in the case of repeated
      updates to the same family, for example).
  """

  modifications = _messages.MessageField('Modification', 1, repeated=True)


class MultiClusterRoutingUseAny(_messages.Message):
  r"""Read/write requests may be routed to any cluster in the instance, and
  will fail over to another cluster in the event of transient errors or
  delays. Choosing this option sacrifices read-your-writes consistency to
  improve availability.
  """



class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class PartialUpdateInstanceRequest(_messages.Message):
  r"""Request message for BigtableInstanceAdmin.PartialUpdateInstance.

  Fields:
    instance: The Instance which will (partially) replace the current value.
    updateMask: The subset of Instance fields which should be replaced. Must
      be explicitly set.
  """

  instance = _messages.MessageField('Instance', 1)
  updateMask = _messages.StringField(2)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SingleClusterRouting(_messages.Message):
  r"""Unconditionally routes all read/write requests to a specific cluster.
  This option preserves read-your-writes consistency, but does not improve
  availability.

  Fields:
    allowTransactionalWrites: Whether or not `CheckAndMutateRow` and
      `ReadModifyWriteRow` requests are allowed by this app profile. It is
      unsafe to send these requests to the same table/row/column in multiple
      clusters.
    clusterId: The cluster to which read/write requests should be routed.
  """

  allowTransactionalWrites = _messages.BooleanField(1)
  clusterId = _messages.StringField(2)


class Split(_messages.Message):
  r"""An initial split point for a newly created table.

  Fields:
    key: Row key to use as an initial tablet boundary.
  """

  key = _messages.BytesField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Table(_messages.Message):
  r"""A collection of user data indexed by row, column, and timestamp. Each
  table is served using the resources of its parent cluster.

  Enums:
    GranularityValueValuesEnum: (`CreationOnly`) The granularity (i.e.
      `MILLIS`) at which timestamps are stored in this table. Timestamps not
      matching the granularity will be rejected. If unspecified at creation
      time, the value will be set to `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`

  Messages:
    ClusterStatesValue: (`OutputOnly`) Map from cluster ID to per-cluster
      table state. If it could not be determined whether or not the table has
      data in a particular cluster (for example, if its zone is unavailable),
      then there will be an entry for the cluster with UNKNOWN
      `replication_status`. Views: `REPLICATION_VIEW`, `FULL`
    ColumnFamiliesValue: (`CreationOnly`) The column families configured for
      this table, mapped by column family ID. Views: `SCHEMA_VIEW`, `FULL`

  Fields:
    clusterStates: (`OutputOnly`) Map from cluster ID to per-cluster table
      state. If it could not be determined whether or not the table has data
      in a particular cluster (for example, if its zone is unavailable), then
      there will be an entry for the cluster with UNKNOWN
      `replication_status`. Views: `REPLICATION_VIEW`, `FULL`
    columnFamilies: (`CreationOnly`) The column families configured for this
      table, mapped by column family ID. Views: `SCHEMA_VIEW`, `FULL`
    granularity: (`CreationOnly`) The granularity (i.e. `MILLIS`) at which
      timestamps are stored in this table. Timestamps not matching the
      granularity will be rejected. If unspecified at creation time, the value
      will be set to `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`
    name: (`OutputOnly`) The unique name of the table. Values are of the form
      `projects/<project>/instances/<instance>/tables/_a-zA-Z0-9*`. Views:
      `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
  """

  class GranularityValueValuesEnum(_messages.Enum):
    r"""(`CreationOnly`) The granularity (i.e. `MILLIS`) at which timestamps
    are stored in this table. Timestamps not matching the granularity will be
    rejected. If unspecified at creation time, the value will be set to
    `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`

    Values:
      TIMESTAMP_GRANULARITY_UNSPECIFIED: The user did not specify a
        granularity. Should not be returned. When specified during table
        creation, MILLIS will be used.
      MILLIS: The table keeps data versioned at a granularity of 1ms.
    """
    TIMESTAMP_GRANULARITY_UNSPECIFIED = 0
    MILLIS = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClusterStatesValue(_messages.Message):
    r"""(`OutputOnly`) Map from cluster ID to per-cluster table state. If it
    could not be determined whether or not the table has data in a particular
    cluster (for example, if its zone is unavailable), then there will be an
    entry for the cluster with UNKNOWN `replication_status`. Views:
    `REPLICATION_VIEW`, `FULL`

    Messages:
      AdditionalProperty: An additional property for a ClusterStatesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ClusterStatesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ClusterStatesValue object.

      Fields:
        key: Name of the additional property.
        value: A ClusterState attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ClusterState', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ColumnFamiliesValue(_messages.Message):
    r"""(`CreationOnly`) The column families configured for this table, mapped
    by column family ID. Views: `SCHEMA_VIEW`, `FULL`

    Messages:
      AdditionalProperty: An additional property for a ColumnFamiliesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ColumnFamiliesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ColumnFamiliesValue object.

      Fields:
        key: Name of the additional property.
        value: A ColumnFamily attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ColumnFamily', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterStates = _messages.MessageField('ClusterStatesValue', 1)
  columnFamilies = _messages.MessageField('ColumnFamiliesValue', 2)
  granularity = _messages.EnumField('GranularityValueValuesEnum', 3)
  name = _messages.StringField(4)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Union(_messages.Message):
  r"""A GcRule which deletes cells matching any of the given rules.

  Fields:
    rules: Delete cells which would be deleted by any element of `rules`.
  """

  rules = _messages.MessageField('GcRule', 1, repeated=True)


class UpdateAppProfileMetadata(_messages.Message):
  r"""The metadata for the Operation returned by UpdateAppProfile."""


class UpdateClusterMetadata(_messages.Message):
  r"""The metadata for the Operation returned by UpdateCluster.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      UpdateCluster operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('Cluster', 2)
  requestTime = _messages.StringField(3)


class UpdateInstanceMetadata(_messages.Message):
  r"""The metadata for the Operation returned by UpdateInstance.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      UpdateInstance operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('PartialUpdateInstanceRequest', 2)
  requestTime = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
